/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_DELAYED_DISPATCH_HH_INCLUDED
#define PEEKABOT_CLIENT_DELAYED_DISPATCH_HH_INCLUDED


#include <boost/utility.hpp>
#include <boost/shared_ptr.hpp>

#include "../Visibility.hh"


namespace peekabot
{
    class Action;

    namespace client
    {
        class Status;
        class ClientImpl;

        /**
         * \brief A wrapper class that enables optional status tracking of
         * operations.
         *
         * Call status() to get a Status object tracking the outcome of your
         * operation.
         *
         * More technically, it's a wrapper for optionally decorating sent
         * actions with a status tracking action. This functionality is provided
         * without any bandwidth overhead - extra bytes are sent only if the
         * status() method is used.
         */
        class PEEKABOT_API DelayedDispatch //: public boost::noncopyable
        {
        public:
            DelayedDispatch(
                boost::shared_ptr<ClientImpl> client,
                boost::shared_ptr<Action> action,
                bool master_only = false);

            DelayedDispatch(
                boost::shared_ptr<ClientImpl> client,
                Action *action,
                bool master_only = false);

            ~DelayedDispatch();

            /**
             * \brief Returns a Status object tracking the status of your
             * operation.
             */
            Status status();

        private:
            boost::shared_ptr<ClientImpl> m_client;

            boost::shared_ptr<Action> m_action;

            bool m_master_only;
        };
    }
}


#endif // PEEKABOT_CLIENT_DELAYED_DISPATCH_HH_INCLUDED
