/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SET_SLIDER_AXIS_HH_INCLUDED
#define PEEKABOT_SET_SLIDER_AXIS_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    class SetSliderAxis : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        SetSliderAxis(
            ObjectID target,
            float x, float y, float z,
            CoordinateSystem coord_sys);

        virtual ~SetSliderAxis() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        SetSliderAxis() throw();

        SetSliderAxis(const SetSliderAxis &other) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;

        float m_x, m_y, m_z;

        CoordinateSystem m_coord_sys;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 99


#endif // PEEKABOT_SET_SLIDER_AXIS_HH_INCLUDED
