/*
 * Copyright Staffan Gimåker 2009-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "SetProp.hh"
#include "serialization/Any.hh"

#include <stdexcept>

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "../SceneObject.hh"
#endif


using namespace peekabot;


Action *SetProp::clone() const
{
    return new SetProp(m_target, m_key, m_val, m_recursive);
}


void SetProp::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    SceneObject *obj = context->get_object(m_target);

    if( !obj )
        throw std::runtime_error("Target object not found");

    if( m_recursive )
        set_recursive(obj);
    else
        obj->set_prop_value(m_key, m_val);
#endif
}


void SetProp::set_recursive(SceneObject *obj) const
{
#ifdef __PEEKABOT_SERVER
    obj->set_prop_value(m_key, m_val);
    for( SceneObject::ChildIterator it = obj->begin();
         it != obj->end(); ++it )
    {
        set_recursive(*it);
    }
#endif
}


void SetProp::save(SerializationInterface &ar) const
{
    ar << m_target << m_key << m_val << m_recursive;
}


void SetProp::load(DeserializationInterface &ar)
{
    ar >> m_target >> m_key >> m_val >> m_recursive;
}
