/*
 * Copyright Staffan Gimåker 2006-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <stdexcept>
#include "RemoveObject.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "../SceneObject.hh"
#endif


using namespace peekabot;


RemoveObject::RemoveObject() throw()
{
}


RemoveObject::RemoveObject(ObjectID id) throw()
    : m_id(id)
{
}


RemoveObject::~RemoveObject() throw()
{
}


Action *RemoveObject::clone() const
{
    return new RemoveObject(m_id);
}


void RemoveObject::execute(
    ServerExecutionContext *context) 
    const throw(std::exception)
{
#ifdef __PEEKABOT_SERVER
    SceneObject *ptr = context->get_object(m_id);

    if( !ptr )
        throw std::runtime_error(
            "Failed to remove subtree, target object not found");

    ptr->detach();
    delete ptr;
#endif
}


void RemoveObject::save(SerializationInterface &ar) const
{
    ar << m_id;
}

void RemoveObject::load(DeserializationInterface &ar)
{
    ar >> m_id;
}
