/*
 * Copyright Staffan Gimåker 2007-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_GET_ORIENTATION_HH_INCLUDED
#define PEEKABOT_GET_ORIENTATION_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"

#include <boost/cstdint.hpp>


namespace peekabot
{
    /**
     * \brief This action fetches the orientation of an object and returns
     * it to the source proxy - it is not intended for usage by components other
     * than the proxy.
     */
    class GetOrientation : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        GetOrientation(
            boost::uint32_t request_id,
            ObjectID target,
            CoordinateSystem coord_sys) throw();

        virtual ~GetOrientation() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        GetOrientation() throw();

        GetOrientation(const GetOrientation &x) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        boost::uint32_t m_request_id;

        ObjectID m_target;

        CoordinateSystem m_coord_sys;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 38


#endif // PEEKABOT_GET_ORIENTATION_HH_INCLUDED
