/*
 * Copyright Staffan Gimåker 2007-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "GetOrientation.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "ActionResultContainer.hh"
#  include "../serialization/Types.hh"
#  include "../SceneObject.hh"
#endif

#include <stdexcept>


using namespace peekabot;


GetOrientation::GetOrientation() throw()
{
}


GetOrientation::GetOrientation(
    boost::uint32_t request_id,
    ObjectID target,
    CoordinateSystem coord_sys) throw()
    : m_request_id(request_id),
      m_target(target),
      m_coord_sys(coord_sys)
{
}


GetOrientation::GetOrientation(const GetOrientation &x) throw()
    : m_request_id(x.m_request_id),
      m_target(x.m_target),
      m_coord_sys(x.m_coord_sys)
{
}


GetOrientation::~GetOrientation() throw()
{
}


Action *GetOrientation::clone() const
{
    return new GetOrientation(*this);
}


void GetOrientation::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    SceneObject *ptr = context->get_object(m_target);

    if( !ptr )
        throw std::runtime_error(
            "Failed to get orientation, target object not found.");

    Eigen::Vector3f orientation;
    switch( m_coord_sys )
    {
        case PARENT_COORDINATES:
            orientation = ptr->get_transformation().linear().col(0);
            break;

        case WORLD_COORDINATES:
            orientation = ptr->get_mtow().linear().col(0);
            break;

        default:
            throw std::runtime_error(
                "Failed to get orientation: unsupported coordinate system");
            break;
    }

    Vector3 res(orientation(0), orientation(1), orientation(2));
    context->post_response(new ActionResultContainer(m_request_id, Any(res)));
#endif
}


void GetOrientation::save(SerializationInterface &ar) const
{
    ar << m_request_id << m_target << m_coord_sys;
}

void GetOrientation::load(DeserializationInterface &ar)
{
    ar >> m_request_id >> m_target >> m_coord_sys;
}
