/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_DEREGISTER_PSEUDONYM_HH_INCLUDED
#define PEEKABOT_DEREGISTER_PSEUDONYM_HH_INCLUDED


#include <string>

#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    class DeregisterPseudonym : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        DeregisterPseudonym(ObjectID id) throw();

        virtual ~DeregisterPseudonym() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        DeregisterPseudonym() throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID  m_pseudonym_id;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 3


#endif // PEEKABOT_DEREGISTER_PSEUDONYM_HH_INCLUDED
