/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <stdexcept>
#include "ClearChildren.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "../SceneObject.hh"
#endif


using namespace peekabot;


ClearChildren::ClearChildren() throw()
{
}


ClearChildren::ClearChildren(ObjectID id) throw()
    : m_id(id)
{
}


ClearChildren::~ClearChildren() throw()
{
}


Action *ClearChildren::clone() const
{
    return new ClearChildren(m_id);
}


void ClearChildren::execute(
    ServerExecutionContext *context) 
    const throw(std::exception)
{
#ifdef __PEEKABOT_SERVER
    SceneObject *ptr = context->get_object(m_id);

    if( !ptr )
        throw std::runtime_error(
            "Failed to clear children, object not found");

    ptr->clear();
#endif
}


void ClearChildren::save(SerializationInterface &ar) const
{
    ar << m_id;
}


void ClearChildren::load(DeserializationInterface &ar)
{
    ar >> m_id;
}
