/*
 * Copyright Staffan Gimåker 2007-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_ACTION_RESULT_CONTAINER_HH_INCLUDED
#define PEEKABOT_ACTION_RESULT_CONTAINER_HH_INCLUDED


#include <string>
#include <stdexcept>
#include <boost/cstdint.hpp>

#include "../Any.hh"
#include "../Action.hh"


namespace peekabot
{
    /**
     * \brief Stores an \c ActionResult, of any type that can be 
     * serialized, deserialized and constructed by the the ActionResultFactory.
     */
    class ActionResultContainer : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        ActionResultContainer(
            boost::uint32_t request_id,
            const Any &result) throw();

        virtual ~ActionResultContainer() throw();

        virtual Action *clone() const;

        virtual void execute(
            ClientExecutionContext *context)
            const throw(std::exception);

        //boost::shared_ptr<ActionResult> get_action_result() throw();

    private:
        ActionResultContainer() throw();

        ActionResultContainer(const ActionResultContainer &x) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        boost::uint32_t m_request_id;

        Any m_action_result;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 30


#endif // PEEKABOT_ACTION_RESULT_CONTAINER_HH_INCLUDED
