/*
 * Copyright Anders Boberg 2006.
 * Copyright Staffan Gimåker 2008.
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef __PEEKABOT_SINGLETON_HH
#define __PEEKABOT_SINGLETON_HH

namespace peekabot
{
    namespace singleton
    {
        template<class T>
        class StaticSingleton
        {
        protected:
            virtual ~StaticSingleton() {}

            inline static T *_instance()
            {
                static T inst;
                return &inst;
            }
        };

        template<class T>
        class LeakySingleton
        {
        protected:
            virtual ~LeakySingleton() {}

            inline static T *_instance()
            {
                static T *inst = new T;
                return inst;
            }
        };
    }

    template<
        class T, 
        template<class> class SingletonType = singleton::LeakySingleton >
    class Singleton : public SingletonType<T>
    {
    public:
        typedef T InstanceType;

        inline static InstanceType &instance()
        {
            return *SingletonType<T>::_instance();
        }

    private:
        Singleton() {}
        ~Singleton() {}
        Singleton(Singleton const&) {}
        Singleton& operator=(Singleton const&) {}
    };

}
#endif //__PEEKABOT_SINGLETON_HH
