/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_PROP_VISITOR_HH_INCLUDED
#define PEEKABOT_PROP_VISITOR_HH_INCLUDED


namespace peekabot
{
    class Prop;
    class BoolPropBase;
    class FloatPropBase;
    class StringPropBase;
    class EnumPropBase;
    class ColorPropBase;
    class Uint32PropBase;
    class Vector3PropBase;
    class LayerPropAdapter;
    class MtowPropAdapter;

    class PropVisitor
    {
    public:
        virtual ~PropVisitor() {}

        virtual void visit(Prop *prop) {}

        virtual void visit(BoolPropBase *prop) = 0;

        virtual void visit(FloatPropBase *prop) = 0;

        virtual void visit(StringPropBase *prop) = 0;

        virtual void visit(EnumPropBase *prop) = 0;

        virtual void visit(ColorPropBase *prop) = 0;

        virtual void visit(Uint32PropBase *prop) = 0;

        virtual void visit(Vector3PropBase *prop) = 0;

        virtual void visit(LayerPropAdapter *prop) = 0;

        virtual void visit(MtowPropAdapter *prop) = 0;
    };
}


#endif // PEEKABOT_PROP_VISITOR_HH_INCLUDED
