/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_PROP_HH_INCLUDED
#define PEEKABOT_PROP_HH_INCLUDED


#include "Any.hh"

#include <boost/signals2.hpp>


namespace peekabot
{
    class SceneObject;
    class PropVisitor;

    class Prop
    {
    public:
        typedef boost::signals2::signal<void ()> SignalType;

        virtual ~Prop() {}

        virtual void set(const Any &val, SceneObject *obj) = 0;

        virtual Any get(const SceneObject *obj) const = 0;

        virtual void accept(PropVisitor &visitor) = 0;

        virtual SignalType &signal(SceneObject *obj) = 0;

        virtual bool is_read_only() const { return false; }

        virtual bool is_gui_visibile() const { return true; }
    };
}


#endif // PEEKABOT_PROP_HH_INCLUDED
