/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_PBAR_WRITER_HH_INCLUDED
#define PEEKABOT_PBAR_WRITER_HH_INCLUDED


#include <ostream>
#include <boost/date_time/posix_time/posix_time.hpp>


namespace peekabot
{
    class Action;

    class PbarWriter
    {
    public:
        PbarWriter(std::ostream &os, bool multi_client);

        void write(
            const boost::shared_ptr<Action> a,
            const boost::posix_time::time_duration &timestamp,
            int32_t client_id);

        void flush();

    private:
        void write_preamble();

        void write_epilogue();

    private:
        std::ostream &m_os;

        uint32_t m_action_count;

        bool m_is_multi_client;
    };
}


#endif // PEEKABOT_PBAR_WRITER_HH_INCLUDED
