/*
 * Copyright Staffan Gimåker 2006-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef PEEKABOT_MODEL_OBJECT_HH_INCLUDED
#define PEEKABOT_MODEL_OBJECT_HH_INCLUDED


#include "SceneObject.hh"
#include "ScalableObject.hh"
#include "ObjectVisitor.hh"
#include "HandlerInformer.hh"
#include "Path.hh"

#include <string>


namespace peekabot
{
    class ScopedHandler;

    /**
     * \internal
     *
     * \brief Class representing externally modeled objects in the scene.
     */
    class ModelObject : public SceneObject, public ScalableObject
    {
    public:
        /** \brief Creates a new \c ModelObject from the given model file.
         *
         * \param model_file_name The file name of the model file to import.
         */
        ModelObject(const Path &model_path);

        /** \brief Construct object from XML data.
         */
        ModelObject(ScopedHandler *handler);

        /** \brief Adds a texture to a model object.
         *
         * \param texture_file_name The file name of the texture file to be loaded.
         */
        //void set_texture(std::string texture_file_name) {}

        virtual void accept(ObjectVisitor* visitor) throw();

        virtual ObjectType get_object_type() const;

        const Path &get_model_path() const;

        void set_model_path(const Path &path);

    protected:
        virtual PropMap &get_prop_adapters();

    private:
        static void create_prop_adapters(PropMap &adapters);

        /// \name XML handler methods
        /// @{

        /** \brief Element start handler for XML parsing.
         */
        static void start_handler(
            const std::string & name,
            XMLHandler::AttributeMap &attributes,
            ScopedHandler *handler) throw();

        /** \brief File start handler for XML parsing.
         */
        void file_start_handler(
            const std::string & name,
            XMLHandler::AttributeMap &attributes,
            ScopedHandler *handler) throw();

        /** \brief File CDATA handler.
         */
        void file_cdata_handler(
            const std::string &cdata,
            ScopedHandler *handler);

        /// @}

    private:
        Path m_model_path;

        static HandlerInformer ms_handler_informer;
    };
}


#endif // PEEKABOT_MODEL_OBJECT_HH_INCLUDED
