/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_LABEL_HH_INCLUDED
#define PEEKABOT_LABEL_HH_INCLUDED


#include <string>
#include "SceneObject.hh"
#include "ScalableObject.hh"
#include "XMLHandler.hh"
#include "HandlerInformer.hh"


namespace peekabot
{
    class ScopedHandler;

    /**
     * \internal
     *
     * \brief A text label primitives, for showing orientable, scalable labels.
     */
    class Label : public SceneObject,
                  public ScalableObject
    {
    public:
        Label() throw();

        Label(ScopedHandler *handler) throw();

        virtual void accept(ObjectVisitor* visitor) throw();

        virtual ObjectType get_object_type() const;

        void set_text(const std::string &text) throw();

        const std::string &get_text() const throw();

        void set_alignment(TextAlignment alignment) throw();

        TextAlignment get_alignment() const throw();

        /// \name Signals
        /// @{

        typedef boost::signals2::signal<void ()> TextSetSignal;

        typedef boost::signals2::signal<void ()> AlignmentSetSignal;

        inline TextSetSignal &text_set_signal()
        {
            return m_text_set_signal;
        }

        inline AlignmentSetSignal &alignment_set_signal()
        {
            return m_alignment_set_signal;
        }

        /// @}

    protected:
        virtual PropMap &get_prop_adapters();

    private:
        static void create_prop_adapters(PropMap &adapters);

        /**
         * \brief Element start handler for XML parsing.
         */
        static void start_handler(
            const std::string &name,
            XMLHandler::AttributeMap &attributes,
            ScopedHandler *handler) throw();

        void text_start_handler(
            const std::string &name,
            XMLHandler::AttributeMap &attributes,
            ScopedHandler *handler) throw();

        void text_cdata_handler(
            const std::string &cdata,
            ScopedHandler *handler) throw();

        void align_start_handler(
            const std::string &name,
            XMLHandler::AttributeMap &attributes,
            ScopedHandler *handler) throw();

        void align_cdata_handler(
            const std::string &cdata,
            ScopedHandler *handler);

    private:
        static HandlerInformer ms_handler_informer;

        std::string m_text;

        TextAlignment m_alignment;

        TextSetSignal m_text_set_signal;
        AlignmentSetSignal m_alignment_set_signal;
    };
}

#endif // PEEKABOT_LABEL_HH_INCLUDED
