/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PEEKABOT_FACTORY_INFORMER_HH
#define __PEEKABOT_FACTORY_INFORMER_HH


#include <boost/function.hpp>

#include "Types.hh"
#include "Factory.hh"
#include "Singleton.hh"


namespace peekabot
{

    // Auxillary class for defining derived actions.
    // Declare a static member of type FactoryInformer(my_id, my_create_fn)
    template<class FactorySingleton>
    class FactoryInformer
    {
    public:
        typedef typename FactorySingleton::InstanceType FactoryType;
        typedef typename FactoryType::IdentifierTypeType GUIDType;
        typedef typename FactoryType::AbstractProductType AbstractProduct;
        typedef typename FactoryType::ProductCreatorType ProductCreatorType;

        FactoryInformer(
            GUIDType guid, 
            ProductCreatorType creator) throw()
            : m_guid(guid)
        {
            FactorySingleton::instance().register_product(m_guid, creator);
        }

        ~FactoryInformer() throw()
        {
            FactorySingleton::instance().deregister_product(m_guid);
        }

        GUIDType get_guid() const throw()
        {
            return m_guid;
        }

    private:
        GUIDType m_guid;
    };


    
}


#endif // __PEEKABOT_FACTORY_INFORMER_HH
