/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_CLIENT_CONNECTION_HH_INCLUDED
#define PEEKABOT_CLIENT_CONNECTION_HH_INCLUDED


#include "Types.hh"
#include "Connection.hh"
#include "ActionSource.hh"

#include <boost/asio.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/enable_shared_from_this.hpp>


namespace peekabot
{
    class Server;
    class ServerData;
    class Action;

    /**
     * \internal
     *
     *
     * \section Thread safety
     *
     * This class is NOT thread safe.
     */
    class ClientConnection :
        public Connection,
        public ActionSource,
        public boost::enable_shared_from_this<ClientConnection>
    {
    public:
        static boost::shared_ptr<ClientConnection> create(
            Server &server,
            boost::asio::io_service &io_service);

        virtual void start();

        virtual void send_response(const boost::shared_ptr<Action> &action);

    private:
        ClientConnection(
            Server &server,
            boost::asio::io_service &io_service);

        void execute_action(
            boost::shared_ptr<Action> action,
            ServerData &sd);

    protected:
        virtual boost::shared_ptr<Connection> ptr();

        virtual void action_read(
            const boost::shared_ptr<Action> &action);

        virtual void on_authenticated();

        virtual void on_authentication_failed(
            protocol::AuthenticationResult reason);

    private:
        Server &m_server;
    };
}


#endif // PEEKABOT_CLIENT_CONNECTION_HH_INCLUDED
