/*
 * Copyright Staffan Gimåker 2006-2009.
 * Copyright Anders Boberg 2006.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_ACTION_HH_INCLUDED
#define PEEKABOT_ACTION_HH_INCLUDED


#include "serialization/SerializationInterface.hh"
#include "serialization/DeserializationInterface.hh"


namespace peekabot
{
    class ServerExecutionContext;
    namespace client
    {
        class ClientExecutionContext;
    }
    using peekabot::client::ClientExecutionContext;

    class DeserializationInterface;
    class SerializationInterface;

    /**
     * \internal
     *
     * \brief Abstract base class for all actions.
     *
     * This class provides some core functionality and properties common to all
     * action types, and relieves derived classes from certain duties such as
     * keeping track of its origin. It also establishes a set of services that
     * the derived classes are required to provide, such as a method for
     * translating all \c ObjectID numbers that it references.
     */
    class Action
    {
    public:
        Action();

        virtual ~Action();

        /**
         * \brief Produces a deep clone of an action.
         *
         * This must produce a complete, deep clone of an action, recursively
         * cloning all objects referenced by pointers. It is used by the capture
         * subsystem, which needs to create copies of captures stored in memory
         * as they are replayed.
         *
         * \return A pointer to a deep clone of this \c Action
         */
        virtual Action *clone() const = 0;

        virtual void execute(ServerExecutionContext *context) const;

        virtual void execute(ClientExecutionContext *context) const;
    };
}


#endif // PEEKABOT_ACTION_HH_INCLUDED
