<?php
/**
 * FIT Examples
 * 
 * $Id: Display.php 12 2007-08-12 18:34:25Z gerd $
 * 
 * These examples are derived from http://fit.c2.com/ 
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage Example
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */

/**
 * Load basic fixture: Column and HelloWorld 
 */
Testing_FIT_Loader::loadClass( 
            'Testing_FIT_Fixture'
            , 'Testing_FIT_Fixture_Row'
            );

/**
 * MusicLibrary is required
 */ 
require_once dirname( __FILE__ ) . '/MusicLibrary.php';

/**
 * FIT Fixture
 *
 * Music browser  
 * 
 * @version 0.1.0
 * @package FIT
 * @subpackage example
 */
class Music_Display extends Testing_FIT_Fixture_Row
{
   /**
    * song title
    * @var string
    */
    public $title;
    
   /**
    * song's artist
    * @var string
    */
    public $artist;
    
   /**
    * song's album
    * @var string
    */
    public $album;
    
   /**
    * song's releas year
    * @var string
    */
    public $year;


   /**
    * receive this song's playing time
    * 
    * @return float
    */
	public function time() 
    {
		return MusicLibrary::time();
	}
    	
   /**
    * receive this track no
    * 
    * @return string
    */
	public function track() 
    {
		return MusicLibrary::track();
	}
    
    public function query()
    {
        return MusicLibrary::getSelection();
    }
}
?>