<?php
/**
 * FIT Fixture type filter: boolean
 * 
 * $Id: Boolean.php 8 2007-08-07 07:15:22Z gerd $
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage Parser
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */
 
/**
 * FIT Fixture type filter: boolean
 * 
 * @version 0.1.0
 * @package FIT
 * @subpackage Fixture
 */
class Testing_FIT_TypeFilter_Boolean extends Testing_FIT_TypeFilter
{
   /**
    * name of type
    * @var string
    */
    protected $type = 'boolean';
    
   /**
    * make string representation of value
    * 
    * @param mixed $value
    * @return string 
    */
    public function out( $value ) 
    {
        $cData  = 'false';
        if( $value === true ) {
            $cData  = 'true';
        }
        
        return $cData;
    }
    
   /**
    * parse string to figure out PHP value
    *
    * @param string $cData
    * @return mixed $value
    */
    public function in( $cData ) 
    {
        $value  = false;
        $cData  = strtolower( trim( $cData ) );
        if( $cData == 'true' ) {
            $value  = true;
        }
    
        return $value;
    }
}
?>