<?php
/**
* FIT class loader
* 
* $Id: Loader.php 13 2007-08-12 19:06:04Z gerd $
* 
* @author gERD Schaufelberger <gerd@php-tools.net>
* @package FIT
* @subpackage Loader
* @license LGPL http://www.gnu.org/copyleft/lesser.html
*/
 
/**
* FIT class loader
* 
* @version 0.1.0
* @package FIT
* @subpackage Fixture
*/
class Testing_FIT_Loader
{
    /**
    * @var array
    */
    private static $_incPath = array();
    
    /**
    * list of loaded classes
    * @var array
    */
    private static $_loaded = array();
    
    /**
    * Add module dir
    *
    * Prepend another folder as module include dir
    * 
    * @param string $type 
    * @param string $dir
    * @return bool true on success
    */
    static function addClassDir( $dir )
    {   
        if( !is_dir( $dir ) ) {
            return false;
        }
        $dir    =   realpath( $dir );
        array_unshift( self::$_incPath, $dir );
        return true;
    }
    
    /**
    * Load module class
    * 
    * @param string $name ...
    * @return bool true on success
    */
    static function loadClass()
    {
        $args = func_get_args();
        foreach( $args as $name ) {
        
            if( class_exists( $name, false ) ) {
                continue;
            }
        
            $file   =   str_replace( '_', '/', $name ) . '.php';
            $found  =   false;
            foreach( self::$_incPath as $dir ) {
                $inc    =   $dir . '/' . $file;
                if( !file_exists( $inc ) ) {
                    continue;
                }
                
                self::$_loaded[]    =   $name;
                $found              =   include $inc;
                break;
            }
            
            if( !$found ) {
                throw new Exception( 'Could not load FIT class' . $name );                
            }
        }
        
        return true;
    }
}

/**
 * add basic installation dir to include path
 */
Testing_FIT_Loader::addClassDir( dirname( __FILE__ ) . '/../..' );

/**
 * use deprecated constant
 */
if( defined( 'TESTING_FIT_FIXTURE_DIR' ) ) {
    trigger_error( 'The usage of constant TESTING_FIT_FIXTURE_DIR is deprecated! Make use of Testing_FIT_Loader::addClassDir() instead.', E_USER_WARNING );
    Testing_FIT_Loader::addClassDir( TESTING_FIT_FIXTURE_DIR );
}
?>
