<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Content analysis dispatcher
 *
 * Copyright 2005-2006 Martin Jansen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @package    Services_Yahoo
 * @author     Martin Jansen <mj@php.net>
 * @copyright  2005-2006 Martin Jansen
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License, Version 2.0
 * @version    CVS: $Id: ContentAnalysis.php,v 1.2 2006/10/02 12:53:33 mj Exp $
 * @link       http://pear.php.net/package/Services_Yahoo
 */

require_once "Services/Yahoo/Exception.php";

/**
 * Content analysis class
 *
 * This class provides a method to create a concrete instance of one
 * of the supported content analysis services.
 *
 * @category   Services
 * @package    Services_Yahoo
 * @author     Martin Jansen <mj@php.net>
 * @copyright  2005-2006 Martin Jansen
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License, Version 2.0
 * @version    CVS: $Id: ContentAnalysis.php,v 1.2 2006/10/02 12:53:33 mj Exp $
 */
class Services_Yahoo_ContentAnalysis {

    /**
     * Attempts to return a concrete instance of a content analysis class
     *
     * @access  public
     * @param   string Type of content analysis. Can be one of spellingSuggestion or termExtraction
     * @return  object Concrete instance of a content analysis class based on the paramter
     * @throws  Services_Yahoo_Exception
     */
    public function factory($type)
    {
        switch ($type) {

        case "termExtraction" :
        case "spellingSuggestion" :
            require_once "Services/Yahoo/ContentAnalysis/" . $type . ".php";
            $classname = "Services_Yahoo_ContentAnalysis_" . $type;
            return new $classname;

        default :
            throw new Services_Yahoo_Exception("Unknown content analysis type {$type}");
            break;
        }
    }
}
