<?php
// Call QA_Peardoc_Coverage_Renderer_DeveloperListTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "QA_Peardoc_Coverage_Renderer_DeveloperListTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

//make cvs testing work
chdir(dirname(__FILE__) . '/../');
require_once "QA/Peardoc/Coverage/Renderer/DeveloperList.php";
require_once dirname(__FILE__) . '/config.php';

/**
 * Test class for QA_Peardoc_Coverage_Renderer_DeveloperList.
 * Generated by PHPUnit2_Util_Skeleton on 2006-10-19 at 11:41:33.
 */
class QA_Peardoc_Coverage_Renderer_DeveloperListTest extends PHPUnit_Framework_TestCase {
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("QA_Peardoc_Coverage_Renderer_DeveloperListTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
        $this->strPearDir = $GLOBALS['testConfig']['PearDir'];
        $this->assertTrue(file_exists($this->strPearDir));
        $this->assertTrue(is_dir($this->strPearDir));
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    }

    /**
     * @todo Implement testRender().
     */
    public function testRender() {
        // Remove the following line when you implement this test.
//        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     *
     */
    public function testGetMaintainers() {
        if (!file_exists('doc.dat')) {
            $this->markTestSkipped(
                'No generated doc.dat available for testing.'
            );
            return;
        }
        $ar = QA_Peardoc_Coverage_Renderer_DeveloperList::getMaintainers(
            unserialize(
                file_get_contents('doc.dat')
            )
        );

        $this->assertTrue(isset($ar['cweiske']));
        $this->assertTrue(10 <= count($ar['cweiske']['packagelist']));
        $this->assertTrue(5  <= $ar['cweiske']['docced']);
        $this->assertTrue(10 <= $ar['cweiske']['packages']);
        $this->assertEquals(
            count($ar['cweiske']['packagelist']),
            $ar['cweiske']['packages']
        );
        $this->assertTrue(
            count($ar['cweiske']['packagelist']) >=
            $ar['cweiske']['docced']
        );
    }

    /**
     *
     */
    public function testGetPackageMaintainers() {
        //test package.xml v1
        $ar = QA_Peardoc_Coverage_Renderer_DeveloperList::getPackageMaintainers(
            dirname(__FILE__) . '/package-v1.xml'
        );
        $this->assertEquals(2, count($ar));
        $this->assertTrue(isset($ar['cipri']));
        $this->assertTrue(isset($ar['dufuz']));

        //no version info
        $ar = QA_Peardoc_Coverage_Renderer_DeveloperList::getPackageMaintainers(
            dirname(__FILE__) . '/package-noversion.xml'
        );
        $this->assertEquals(1, count($ar));

        //test package.xml v2
        $ar = QA_Peardoc_Coverage_Renderer_DeveloperList::getPackageMaintainers(
            dirname(__FILE__) . '/package-v2.xml'
        );
        $this->assertEquals(2, count($ar));
    }
}

// Call QA_Peardoc_Coverage_Renderer_DeveloperListTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "QA_Peardoc_Coverage_Renderer_DeveloperListTest::main") {
    QA_Peardoc_Coverage_Renderer_DeveloperListTest::main();
}
?>
