<?php
/* Driver template for the PHP_PHPrGenerator parser generator. (PHP port of LEMON)
*/

/**
 * This can be used to store both the string representation of
 * a token, and any useful meta-data associated with the token.
 *
 * meta-data should be stored as an array
 */
class PHPyyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof PHPyyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof PHPyyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof PHPyyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof PHPyyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

// code external to the class is included here

/** The following structure represents a single element of the
 * parser's stack.  Information stored includes:
 *
 *   +  The state number for the parser at this level of the stack.
 *
 *   +  The value of the token stored at this level of the stack.
 *      (In other words, the "major" token.)
 *
 *   +  The semantic value stored at this level of the stack.  This is
 *      the information used by the action routines in the grammar.
 *      It is sometimes called the "minor" token.
 */
class PHPyyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

// any extra class_declaration (extends/implements) are defined here
/**
 * The state of the parser is completely contained in an instance of
 * the following structure
 */
class PHPyyParser
{
/* First off, code is included which follows the "include_class" declaration
** in the input file. */
#line 16 "PHP_Parser.y"

    static public $transTable = array();

    function __construct()
    {
        if (!count(self::$transTable)) {
            $start = 240; // start nice and low to be sure
            while (token_name($start) == 'UNKNOWN') {
                $start++;
            }
            $hash = array_flip(self::$yyTokenName);
            $map =
                array(
                    ord(',') => self::COMMA,
                    ord('=') => self::EQUALS,
                    ord('?') => self::QUESTION,
                    ord(':') => self::COLON,
                    ord('|') => self::BAR,
                    ord('^') => self::CARAT,
                    ord('&') => self::AMPERSAND,
                    ord('<') => self::LESSTHAN,
                    ord('>') => self::GREATERTHAN,
                    ord('+') => self::PLUS,
                    ord('-') => self::MINUS,
                    ord('.') => self::DOT,
                    ord('*') => self::TIMES,
                    ord('/') => self::DIVIDE,
                    ord('%') => self::PERCENT,
                    ord('!') => self::EXCLAM,
                    ord('~') => self::TILDE,
                    ord('@') => self::AT,
                    ord('[') => self::LBRACKET,
                    ord('(') => self::LPAREN,
                    ord(')') => self::RPAREN,
                    ord(';') => self::SEMI,
                    ord('{') => self::LCURLY,
                    ord('}') => self::RCURLY,
                    ord('`') => self::BACKQUOTE,
                    ord('$') => self::DOLLAR,
                    ord(']') => self::RBRACKET,
                    ord('"') => self::DOUBLEQUOTE,
                    ord("'") => self::SINGLEQUOTE,
                );
            for ($i = $start; $i < self::YYERRORSYMBOL + $start; $i++) {
                $lt = token_name($i);
                $lt = ($lt == 'T_DOUBLE_COLON') ?  'T_PAAMAYIM_NEKUDOTAYIM' : $lt;
//                echo "$lt has hash? ".$hash[$lt]."\n";
                if (!isset($hash[$lt])) {
                    continue;
                }
                
                //echo "compare $lt with {$tokens[$i]}\n";
                $map[$i] = $hash[$lt];
            }
            //print_r($map);
            // set the map to false if nothing in there.
            self::$transTable = $map;
        }
    }

    public $data;
#line 171 "PHP_Parser.php"

/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
    const T_INCLUDE                      =  1;
    const T_INCLUDE_ONCE                 =  2;
    const T_EVAL                         =  3;
    const T_REQUIRE                      =  4;
    const T_REQUIRE_ONCE                 =  5;
    const COMMA                          =  6;
    const T_LOGICAL_OR                   =  7;
    const T_LOGICAL_XOR                  =  8;
    const T_LOGICAL_AND                  =  9;
    const T_PRINT                        = 10;
    const EQUALS                         = 11;
    const T_PLUS_EQUAL                   = 12;
    const T_MINUS_EQUAL                  = 13;
    const T_MUL_EQUAL                    = 14;
    const T_DIV_EQUAL                    = 15;
    const T_CONCAT_EQUAL                 = 16;
    const T_MOD_EQUAL                    = 17;
    const T_AND_EQUAL                    = 18;
    const T_OR_EQUAL                     = 19;
    const T_XOR_EQUAL                    = 20;
    const T_SL_EQUAL                     = 21;
    const T_SR_EQUAL                     = 22;
    const QUESTION                       = 23;
    const COLON                          = 24;
    const T_BOOLEAN_OR                   = 25;
    const T_BOOLEAN_AND                  = 26;
    const BAR                            = 27;
    const CARAT                          = 28;
    const AMPERSAND                      = 29;
    const T_IS_EQUAL                     = 30;
    const T_IS_NOT_EQUAL                 = 31;
    const T_IS_IDENTICAL                 = 32;
    const T_IS_NOT_IDENTICAL             = 33;
    const LESSTHAN                       = 34;
    const T_IS_SMALLER_OR_EQUAL          = 35;
    const GREATERTHAN                    = 36;
    const T_IS_GREATER_OR_EQUAL          = 37;
    const T_SL                           = 38;
    const T_SR                           = 39;
    const PLUS                           = 40;
    const MINUS                          = 41;
    const DOT                            = 42;
    const TIMES                          = 43;
    const DIVIDE                         = 44;
    const PERCENT                        = 45;
    const EXCLAM                         = 46;
    const T_INSTANCEOF                   = 47;
    const TILDE                          = 48;
    const T_INC                          = 49;
    const T_DEC                          = 50;
    const T_INT_CAST                     = 51;
    const T_DOUBLE_CAST                  = 52;
    const T_STRING_CAST                  = 53;
    const T_ARRAY_CAST                   = 54;
    const T_OBJECT_CAST                  = 55;
    const T_BOOL_CAST                    = 56;
    const T_UNSET_CAST                   = 57;
    const AT                             = 58;
    const LBRACKET                       = 59;
    const T_NEW                          = 60;
    const T_CLONE                        = 61;
    const T_ELSEIF                       = 62;
    const T_ELSE                         = 63;
    const T_ENDIF                        = 64;
    const T_STATIC                       = 65;
    const T_ABSTRACT                     = 66;
    const T_FINAL                        = 67;
    const T_PRIVATE                      = 68;
    const T_PROTECTED                    = 69;
    const T_PUBLIC                       = 70;
    const T_HALT_COMPILER                = 71;
    const LPAREN                         = 72;
    const RPAREN                         = 73;
    const SEMI                           = 74;
    const LCURLY                         = 75;
    const RCURLY                         = 76;
    const T_IF                           = 77;
    const T_WHILE                        = 78;
    const T_DO                           = 79;
    const T_FOR                          = 80;
    const T_SWITCH                       = 81;
    const T_BREAK                        = 82;
    const T_CONTINUE                     = 83;
    const T_RETURN                       = 84;
    const T_GLOBAL                       = 85;
    const T_ECHO                         = 86;
    const T_INLINE_HTML                  = 87;
    const T_USE                          = 88;
    const T_UNSET                        = 89;
    const T_FOREACH                      = 90;
    const T_AS                           = 91;
    const T_DECLARE                      = 92;
    const T_TRY                          = 93;
    const T_CATCH                        = 94;
    const T_VARIABLE                     = 95;
    const T_THROW                        = 96;
    const T_FUNCTION                     = 97;
    const T_STRING                       = 98;
    const T_CLASS                        = 99;
    const T_EXTENDS                      = 100;
    const T_INTERFACE                    = 101;
    const T_IMPLEMENTS                   = 102;
    const T_LIST                         = 103;
    const T_EXIT                         = 104;
    const BACKQUOTE                      = 105;
    const T_ARRAY                        = 106;
    const T_LNUMBER                      = 107;
    const T_DNUMBER                      = 108;
    const T_CONSTANT_ENCAPSED_STRING     = 109;
    const T_LINE                         = 110;
    const T_FILE                         = 111;
    const T_CLASS_C                      = 112;
    const T_METHOD_C                     = 113;
    const T_FUNC_C                       = 114;
    const T_DOUBLE_ARROW                 = 115;
    const T_PAAMAYIM_NEKUDOTAYIM         = 116;
    const T_ENDFOR                       = 117;
    const T_ENDFOREACH                   = 118;
    const T_ENDDECLARE                   = 119;
    const T_ENDSWITCH                    = 120;
    const T_CASE                         = 121;
    const T_DEFAULT                      = 122;
    const T_ENDWHILE                     = 123;
    const DOLLAR                         = 124;
    const T_VAR                          = 125;
    const T_CONST                        = 126;
    const T_OBJECT_OPERATOR              = 127;
    const RBRACKET                       = 128;
    const T_NUM_STRING                   = 129;
    const T_ENCAPSED_AND_WHITESPACE      = 130;
    const T_CHARACTER                    = 131;
    const T_BAD_CHARACTER                = 132;
    const T_DOLLAR_OPEN_CURLY_BRACES     = 133;
    const T_STRING_VARNAME               = 134;
    const T_CURLY_OPEN                   = 135;
    const T_ISSET                        = 136;
    const T_EMPTY                        = 137;
    const DOUBLEQUOTE                    = 138;
    const SINGLEQUOTE                    = 139;
    const T_START_HEREDOC                = 140;
    const T_END_HEREDOC                  = 141;
    const YY_NO_ACTION = 1041;
    const YY_ACCEPT_ACTION = 1040;
    const YY_ERROR_ACTION = 1039;

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
    const YY_SZ_ACTTAB = 11490;
static public $yy_action = array(
 /*     0 */    86,   84,  440,   89,   90,  423,   81,  193,   51,   96,
 /*    10 */   102,  112,  115,  117,  114,  116,   94,  121,  113,   56,
 /*    20 */    57,   58,   55,  108,   99,  111,  110,  118,  101,  107,
 /*    30 */   120,  222,  148, 1040,   13,  667,  333,  178,  539,   53,
 /*    40 */    50,  435,  540,  339,  661,   60,  470,   66,  136,  140,
 /*    50 */    65,   64,   62,   63,   68,   47,   48,   49,  472,  146,
 /*    60 */   104,  449,  333,  178,  211,  451,  425,  422,  540,  664,
 /*    70 */   389,   67,  539,  655,  230,  641,  383,  458,   24,  467,
 /*    80 */   461,   45,   41,   40,  180,   35,  626,  196,  399,  372,
 /*    90 */   361,  367,  366,  326,  539,   78,  199,  350,  519,  540,
 /*   100 */   530,  418,  462,  204,  239,  547,  541,  541,  541,  541,
 /*   110 */   541,  541,  541,  541,  330,   86,   84,  440,   89,   90,
 /*   120 */   474,   81,  193,  422,   96,  111,  110,  118,  101,  107,
 /*   130 */   120,  190,  148,  570,  334,  437,  432,  223,  229,  232,
 /*   140 */    56,   57,   58,   55,  108,   99,  111,  110,  118,  101,
 /*   150 */   107,  120,  475,  148,   53,   50,  394,  636,  390,  384,
 /*   160 */    60,  628,   66,  136,  140,   65,   64,   62,   63,   68,
 /*   170 */    47,   48,   49,  164,  146,  104,  676,  333,  178,  211,
 /*   180 */   451,  425,  421,  540,  632,  389,   67,  539,  655,  230,
 /*   190 */   533,  383,  458,   24,  467,  461,   45,   41,   40,  180,
 /*   200 */    35,  626,  196,  399,  372,   29,  367,  366,  478,  539,
 /*   210 */    78,  199,  350,  519,  173,  530,  422,  462,  204,  239,
 /*   220 */   547,  541,  541,  541,  541,  541,  541,  541,  541,   79,
 /*   230 */    86,   84,  440,   89,   90,  388,  335,  201,  422,   96,
 /*   240 */   505,  505,  505,  505,  505,  505,  490,  401,  570, 1010,
 /*   250 */   437,  432,  223,  229,  232,  627,  541,  541,  541,  541,
 /*   260 */   541,  541,  541,  541,  101,  107,  120,  147,  148,   53,
 /*   270 */    50,  354,  915,  579,  582,   60,   32,   66,  136,  140,
 /*   280 */    65,   64,   62,   63,   68,   47,   48,   49,  210,  146,
 /*   290 */   104,   81,  193,  495,  211,  451,  425,  623,  388,  335,
 /*   300 */   389,   67,  539,  655,  230,  435,  383,  458,   24,  467,
 /*   310 */   461,   45,   41,   40,  180,   35,  626,  196,  399,  372,
 /*   320 */   487,  367,  366,  341,  539,   78,  199,  350,  519,  540,
 /*   330 */   530,  422,  462,  204,  239,  547,  541,  541,  541,  541,
 /*   340 */   541,  541,  541,  541,   37,  636,  517,  384,  443,  628,
 /*   350 */   636,  524,  384,  422,  628,   86,   84,  440,   89,   90,
 /*   360 */    54,  139,  396,  570,   96,  437,  432,  223,  229,  232,
 /*   370 */   112,  115,  117,  114,  116,   94,  121,  113,   56,   57,
 /*   380 */    58,   55,  108,   99,  111,  110,  118,  101,  107,  120,
 /*   390 */   427,  148,   33,  427,   53,   50,  637,  636,  523,  384,
 /*   400 */    60,  628,   66,  136,  140,   65,   64,   62,   63,   68,
 /*   410 */    47,   48,   49,  665,  146,  104,  654,  212,  529,  211,
 /*   420 */   451,  425,  469,  382,  427,  389,   67,  539,  655,  230,
 /*   430 */   435,  383,  458,   24,  467,  461,   45,   41,   40,  180,
 /*   440 */    35,  626,  196,  399,  372,  122,  367,  366,  407,  539,
 /*   450 */    78,  199,  350,  519,  878,  530,  422,  462,  204,  239,
 /*   460 */   547,  541,  541,  541,  541,  541,  541,  541,  541,   36,
 /*   470 */   492,  203,  436,  347,  404,  145,  188,  503,  422,  515,
 /*   480 */    86,   84,  440,   89,   90,   72,  141,  515,  570,   96,
 /*   490 */   437,  432,  223,  229,  232,  115,  117,  114,  116,   94,
 /*   500 */   121,  113,   56,   57,   58,   55,  108,   99,  111,  110,
 /*   510 */   118,  101,  107,  120,  539,  148,  536,  435,  148,   53,
 /*   520 */    50,  213,  636,  531,  384,   60,  628,   66,  136,  140,
 /*   530 */    65,   64,   62,   63,   68,   47,   48,   49,  123,  146,
 /*   540 */   104,  353,  560,  422,  211,  451,  425,  540,  512,  226,
 /*   550 */   389,   67,  356,  655,  230,  369,  383,  458,   24,  467,
 /*   560 */   461,   45,   41,   40,  180,   35,  626,  196,  399,  372,
 /*   570 */   169,  367,  366,  358,  539,   78,  199,  350,  519,  508,
 /*   580 */   530,   34,  462,  204,  239,  547,  541,  541,  541,  541,
 /*   590 */   541,  541,  541,  541,  477,   86,   84,  440,   89,   90,
 /*   600 */   500,  476,  368,  422,   96,  636,  392,  384,  391,  628,
 /*   610 */   398,  694,  378,  570,  687,  437,  432,  223,  229,  232,
 /*   620 */   636,  525,  384,  130,  628,  403,  205,  894,  127,  891,
 /*   630 */   667,  333,  178,  539,   53,   50,  410,  540,  339,  661,
 /*   640 */    60,  501,   66,  136,  140,   65,   64,   62,   63,   68,
 /*   650 */    47,   48,   49,  488,  146,  104,   81,  193,  189,  211,
 /*   660 */   451,  425,  422,  159,  687,  389,   67,  371,  655,  230,
 /*   670 */   595,  383,  458,   24,  467,  461,   45,   41,   40,  180,
 /*   680 */    35,  626,  196,  399,  372,  373,  367,  366,  657,  539,
 /*   690 */    78,  199,  350,  519,  894,  530,  891,  462,  204,  239,
 /*   700 */   547,  541,  541,  541,  541,  541,  541,  541,  541,  400,
 /*   710 */    86,   84,  440,   89,   90,  485,   22,  129,  422,   96,
 /*   720 */   235,  508,   70,  636,  506,  384,  684,  628,  570,  515,
 /*   730 */   437,  432,  223,  229,  232,  220,  415,  515,   27,  667,
 /*   740 */   333,  178,  539,  206,   29,  660,  540,  339,  661,   53,
 /*   750 */    50,  638,  636,  622,  384,   60,  628,   66,  136,  140,
 /*   760 */    65,   64,   62,   63,   68,   47,   48,   49,  635,  146,
 /*   770 */   104,  422,  172,  634,  211,  451,  425,  633,  149,  170,
 /*   780 */   389,   67,  539,  655,  230,  435,  383,  458,   24,  467,
 /*   790 */   461,   45,   41,   40,  180,   35,  626,  196,  399,  372,
 /*   800 */   445,  367,  366,  387,  539,   78,  199,  350,  519,  167,
 /*   810 */   530,  422,  462,  204,  239,  547,  541,  541,  541,  541,
 /*   820 */   541,  541,  541,  541,  355,   86,   84,  440,   89,   90,
 /*   830 */    31,  397,  471,  422,   96,  636,  535,  384,  157,  628,
 /*   840 */   636,  620,  384,  570,  628,  437,  432,  223,  229,  232,
 /*   850 */   663,  128,  405,   85,  667,  333,  178,  539,  624,  408,
 /*   860 */   439,  540,  339,  661,   53,   50,  198,  636,  516,  384,
 /*   870 */    60,  628,   66,  136,  140,   65,   64,   62,   63,   68,
 /*   880 */    47,   48,   49,  555,  146,  104,  422,   88,  617,  211,
 /*   890 */   451,  425,  442,  561,  565,  389,   67,  554,  655,  230,
 /*   900 */   697,  383,  458,   24,  467,  461,   45,   41,   40,  180,
 /*   910 */    35,  626,  196,  399,  372,  532,  367,  366,  690,  539,
 /*   920 */    78,  199,  350,  519,   30,  530,  426,  462,  204,  239,
 /*   930 */   547,  541,  541,  541,  541,  541,  541,  541,  541,  494,
 /*   940 */    86,   84,  440,   89,   90,  518,   17,  143,  422,   96,
 /*   950 */  1010,  395,   80,  636,  514,  384,  158,  628,  570,   19,
 /*   960 */   437,  432,  223,  229,  232,  636,  527,  384,  558,  628,
 /*   970 */   131,  171,  539,  539,  128,  435,  413,   73,  567,   53,
 /*   980 */    50,  566,  636,  621,  384,   60,  628,   66,  136,  140,
 /*   990 */    65,   64,   62,   63,   68,   47,   48,   49,  191,  146,
 /*  1000 */   104,  422,  422,  521,  211,  451,  425,   16,  674,  233,
 /*  1010 */   389,   67,  238,  655,  230,  593,  383,  458,   24,  467,
 /*  1020 */   461,   45,   41,   40,  180,   35,  626,  196,  399,  372,
 /*  1030 */   693,  367,  366,  165,  539,   78,  199,  350,  519,  100,
 /*  1040 */   530,  453,  462,  204,  239,  547,  541,  541,  541,  541,
 /*  1050 */   541,  541,  541,  541,  370,  218,  482,  241,   86,   84,
 /*  1060 */   440,   89,   90,  422,  636,  619,  384,   96,  628,  357,
 /*  1070 */    37,   37,  240,  570,  219,  437,  432,  223,  229,  232,
 /*  1080 */   360,   76,  124,  943,  944,  168,   54,   54,   18,  365,
 /*  1090 */   215,  452,  228,   71,  651,   75,  197,   53,   50,  236,
 /*  1100 */   160,  573,  246,   60,  163,   66,  136,  140,   65,   64,
 /*  1110 */    62,   63,   68,   47,   48,   49,  105,  146,  104,  166,
 /*  1120 */   646,  386,  211,  451,  425,  568,  174,  153,  389,   67,
 /*  1130 */   385,  655,  230,  176,  383,  458,   24,  467,  461,   45,
 /*  1140 */    41,   40,  180,   35,  626,  196,  399,  372,  156,  367,
 /*  1150 */   366,  175,  539,   78,  199,  350,  519,  152,  530,   77,
 /*  1160 */   462,  204,  239,  547,  541,  541,  541,  541,  541,  541,
 /*  1170 */   541,  541,  520,   86,   84,  440,   89,   90,  162,  362,
 /*  1180 */   374,  422,   96,   43,  161,  686,   26,  618,  359,  447,
 /*  1190 */    46,  570,  581,  437,  432,  223,  229,  232,  181,  244,
 /*  1200 */   351,   25,   28,  336,  409,  381,  457,  331,  507,  648,
 /*  1210 */   509,  502,   53,   50,    2,   15,   10,    6,   60,    9,
 /*  1220 */    66,  136,  140,   65,   64,   62,   63,   68,   47,   48,
 /*  1230 */    49,  677,  146,  104,    7,  187,   11,  211,  451,  425,
 /*  1240 */   328,  185,   12,  389,   67,    1,  655,  230,  192,  383,
 /*  1250 */   458,   24,  467,  461,   45,   41,   40,  180,   35,  626,
 /*  1260 */   196,  399,  372,   14,  367,  366,    4,  539,   78,  199,
 /*  1270 */   350,  519,    5,  530,    3,  462,  204,  239,  547,  541,
 /*  1280 */   541,  541,  541,  541,  541,  541,  541,  208,   86,   84,
 /*  1290 */   440,   89,   90,  242,  155,  416,  422,   96,  186,  594,
 /*  1300 */   695,  406,  585,  221,  224,  375,  570,  534,  437,  432,
 /*  1310 */   223,  229,  232,  338,  658,  379,  200,  606,  513,  126,
 /*  1320 */   364,  510,  688,  151,  150,  662,  601,   53,   50,  584,
 /*  1330 */    38,  243,  380,   60,  182,   66,  136,  140,   65,   64,
 /*  1340 */    62,   63,   68,   47,   48,   49,  402,  146,  104,  327,
 /*  1350 */   377,  429,  211,  451,  425,  325,  184,  352,  393,   67,
 /*  1360 */   154,  655,  230,  666,  383,  458,   24,  467,  461,   45,
 /*  1370 */    41,   40,  180,   35,  626,  196,  399,  372,    8,  367,
 /*  1380 */   366,  209,  539,   78,  199,  350,  519,  109,  530,   61,
 /*  1390 */   462,  204,  239,  547,  541,  541,  541,  541,  541,  541,
 /*  1400 */   541,  541,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  1410 */   590,  422,  590,   86,   84,  440,   89,   90,  590,  590,
 /*  1420 */   590,  570,   96,  437,  432,  223,  229,  232,  590,  590,
 /*  1430 */   590,  590,  590,  590,  590,  590,  234,   44,  106,   87,
 /*  1440 */    95,   97,   69,   93,   91,   92,   83,   82,   74,  590,
 /*  1450 */   590,  590,   53,   50,  590,  590,  590,  590,   60,  590,
 /*  1460 */    66,  136,  140,   65,   64,   62,   63,   68,   47,   48,
 /*  1470 */    49,  590,  146,  104,  590,  935,  935,  211,  590,  590,
 /*  1480 */   590,  590,  590,  590,   67,  590,  655,  230,  590,  383,
 /*  1490 */   458,   24,  467,  461,   45,   41,   40,  180,   35,  626,
 /*  1500 */   196,  399,  372,  590,  367,  366,  590,  539,   78,  479,
 /*  1510 */   350,  590,  590,  590,  590,  462,  204,  239,  547,  541,
 /*  1520 */   541,  541,  541,  541,  541,  541,  541,  214,  590,  590,
 /*  1530 */   590,  590,  590,  590,  590,  590,  422,  590,   86,   84,
 /*  1540 */   440,   89,   90,  590,  590,  590,  570,   96,  437,  432,
 /*  1550 */   223,  229,  232,  590,  590,  590,  590,  590,  590,  590,
 /*  1560 */   590,  225,  590,  590,  343,  177,  545,  450,  590,  590,
 /*  1570 */   540,  590,  590,  590,  590,  590,  590,   53,   50,  675,
 /*  1580 */   590,  590,  590,   60,  590,   66,  136,  140,   65,   64,
 /*  1590 */    62,   63,   68,   47,   48,   49,  590,  146,  104,  590,
 /*  1600 */   590,  590,  211,  590,  590,  590,  590,  590,  590,   67,
 /*  1610 */   590,  655,  230,  590,  383,  458,   24,  467,  461,   45,
 /*  1620 */    41,   40,  180,   35,  626,  196,  399,  372,  590,  367,
 /*  1630 */   366,  590,  539,   78,  479,  350,  590,  590,  590,  590,
 /*  1640 */   462,  204,  239,  547,  541,  541,  541,  541,  541,  541,
 /*  1650 */   541,  541,  216,  590,  590,  590,  590,  590,  590,  590,
 /*  1660 */   590,  422,  590,   86,   84,  440,   89,   90,  590,  590,
 /*  1670 */   590,  570,   96,  437,  432,  223,  229,  232,  590,  590,
 /*  1680 */   590,  590,  590,  590,  590,  590,  245,  590,  590,  343,
 /*  1690 */   177,  545,  450,  590,  590,  540,  590,  590,  590,  590,
 /*  1700 */   590,  590,   53,   50,  675,  590,  590,  590,   60,  590,
 /*  1710 */    66,  136,  140,   65,   64,   62,   63,   68,   47,   48,
 /*  1720 */    49,  590,  146,  104,  590,  590,  590,  211,  590,  590,
 /*  1730 */   590,  590,  590,  590,   67,  590,  655,  230,  590,  383,
 /*  1740 */   458,   24,  467,  461,   45,   41,   40,  180,   35,  626,
 /*  1750 */   196,  399,  372,  590,  367,  366,  590,  539,   78,  479,
 /*  1760 */   350,  590,  590,  590,  590,  462,  204,  239,  547,  541,
 /*  1770 */   541,  541,  541,  541,  541,  541,  541,  598,  590,  590,
 /*  1780 */   590,  590,  590,  590,  590,  590,  422,  590,   86,   84,
 /*  1790 */   440,   89,   90,  590,  590,  590,  570,   96,  437,  432,
 /*  1800 */   223,  229,  232,  590,  590,  590,  590,  590,  590,  590,
 /*  1810 */   590,  227,  590,  590,  343,  177,  545,  450,  590,  590,
 /*  1820 */   540,  590,  590,  590,  590,  590,  590,   53,   50,  675,
 /*  1830 */   590,  590,  590,   60,  590,   66,  136,  140,   65,   64,
 /*  1840 */    62,   63,   68,   47,   48,   49,  590,  146,  104,  590,
 /*  1850 */   590,  590,  211,  590,  590,  590,  590,  590,  590,   67,
 /*  1860 */   590,  655,  230,  590,  383,  458,   24,  467,  461,   45,
 /*  1870 */    41,   40,  180,   35,  626,  196,  399,  372,  590,  367,
 /*  1880 */   366,  590,  539,   78,  590,  350,  590,  590,  590,  590,
 /*  1890 */   462,  204,  239,  547,  541,  541,  541,  541,  541,  541,
 /*  1900 */   541,  541,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  1910 */   590,  422,  590,   86,   84,  440,   89,   90,  590,  590,
 /*  1920 */   590,  570,   96,  437,  432,  223,  229,  232,  590,  590,
 /*  1930 */   590,  590,  590,  590,  590,  590,  237,  590,  590,  590,
 /*  1940 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  1950 */   590,  590,   53,   50,  590,  590,  590,  590,   60,  590,
 /*  1960 */    66,  136,  140,   65,   64,   62,   63,   68,   47,   48,
 /*  1970 */    49,  590,  146,  104,  590,  590,  590,  211,  590,  590,
 /*  1980 */   590,  590,  590,  590,   67,  590,  655,  230,  590,  383,
 /*  1990 */   458,   24,  467,  461,   45,   41,   40,  180,   35,  626,
 /*  2000 */   196,  399,  372,  590,  367,  366,  590,  539,   78,  590,
 /*  2010 */   350,  590,  590,  590,  590,  462,  204,  239,  547,  541,
 /*  2020 */   541,  541,  541,  541,  541,  541,  541,  590,   86,   84,
 /*  2030 */   440,   89,   90,  590,  590,  590,  422,   96,  590,  590,
 /*  2040 */   590,  590,  590,  590,  590,  590,  570,  590,  437,  432,
 /*  2050 */   223,  229,  232,  590,  590,  590,  590,  590,  590,  590,
 /*  2060 */   590,  590,  590,  590,  590,  590,  590,   53,   50,  590,
 /*  2070 */   590,  590,  590,   60,  590,   66,  136,  140,   65,   64,
 /*  2080 */    62,   63,   68,   47,   48,   49,  590,  146,  104,  590,
 /*  2090 */   590,  590,  211,  590,  590,  590,  590,  590,  590,   67,
 /*  2100 */   590,  655,  230,  590,  383,  458,   24,  467,  461,   45,
 /*  2110 */    41,   40,  180,   35,  626,  196,  399,  372,  590,  367,
 /*  2120 */   366,  590,  539,   78,  590,  350,  590,  590,  590,  590,
 /*  2130 */   462,  204,  239,  547,  541,  541,  541,  541,  541,  541,
 /*  2140 */   541,  541,  590,   86,   84,  440,   89,   90,  590,  590,
 /*  2150 */   590,  422,   96,  590,  590,  590,  590,  590,  590,  590,
 /*  2160 */   590,  570,  590,  437,  432,  223,  229,  232,  590,  590,
 /*  2170 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  2180 */   590,  590,   53,   50,  590,  590,  590,  590,   60,  590,
 /*  2190 */    66,  136,  140,   65,   64,   62,   63,   68,   47,   48,
 /*  2200 */    49,  590,  146,  104,  505,  505,  505,  505,  505,  505,
 /*  2210 */   590,  590,  590,  590,   67,  511,  683,  117,  114,  116,
 /*  2220 */    94,  121,  113,   56,   57,   58,   55,  108,   99,  111,
 /*  2230 */   110,  118,  101,  107,  120,  590,  148,  539,  590,  590,
 /*  2240 */   350,  590,  590,  590,  590,  462,  204,  239,  547,  541,
 /*  2250 */   541,  541,  541,  541,  541,  541,  541,  590,   86,   84,
 /*  2260 */   440,   89,   90,  590,  504,  473,  422,   96,  590,  590,
 /*  2270 */   590,  590,  590,  590,  590,  590,  570,  590,  437,  432,
 /*  2280 */   223,  229,  232,  590,  590,  590,  132,  590,  590,  590,
 /*  2290 */   590,  590,  590,  590,  590,  590,  590,   53,   50,  590,
 /*  2300 */   590,  590,  590,   60,  590,   66,  136,  140,   65,   64,
 /*  2310 */    62,   63,   68,   47,   48,   49,  590,  146,  104,  505,
 /*  2320 */   505,  505,  505,  505,  505,  590,  590,  590,  590,   67,
 /*  2330 */   493,  102,  112,  115,  117,  114,  116,   94,  121,  113,
 /*  2340 */    56,   57,   58,   55,  108,   99,  111,  110,  118,  101,
 /*  2350 */   107,  120,  539,  148,  590,  350,  590,  590,  590,  590,
 /*  2360 */   462,  204,  239,  547,  541,  541,  541,  541,  541,  541,
 /*  2370 */   541,  541,  590,   86,   84,  440,   89,   90,  590,  504,
 /*  2380 */   473,  422,   96,  590,  590,  590,  590,  590,  590,  590,
 /*  2390 */   590,  570,  590,  437,  432,  223,  229,  232,  590,  590,
 /*  2400 */   590,  142,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  2410 */   590,  590,   53,   50,  590,  590,  590,  590,   60,  590,
 /*  2420 */    66,  136,  140,   65,   64,   62,   63,   68,   47,   48,
 /*  2430 */    49,  590,  146,  104,  590,  590,  590,  590,  590,  590,
 /*  2440 */   590,  590,  590,  590,   67,  590,  590,  590,  114,  116,
 /*  2450 */    94,  121,  113,   56,   57,   58,   55,  108,   99,  111,
 /*  2460 */   110,  118,  101,  107,  120,  590,  148,  539,  590,  590,
 /*  2470 */   350,  590,  590,  590,  590,  462,  204,  239,  547,  541,
 /*  2480 */   541,  541,  541,  541,  541,  541,  541,  590,   86,   84,
 /*  2490 */   440,   89,   90,  590,  590,  590,  422,   96,  590,  590,
 /*  2500 */   590,  590,  590,  590,  590,  590,  570,  590,  437,  432,
 /*  2510 */   223,  229,  232,  590,  590,  590,  138,  590,  590,  590,
 /*  2520 */   590,  590,  590,  590,  590,  590,  590,   53,   50,  590,
 /*  2530 */   590,  590,  590,   60,  590,   66,  136,  140,   65,   64,
 /*  2540 */    62,   63,   68,   47,   48,   49,  590,  146,  104,  590,
 /*  2550 */   590,  590,  590,  590,  590,  590,  590,  590,  590,   67,
 /*  2560 */   590,  590,  590,  590,  116,   94,  121,  113,   56,   57,
 /*  2570 */    58,   55,  108,   99,  111,  110,  118,  101,  107,  120,
 /*  2580 */   590,  148,  539,  590,  590,  350,  590,  590,  590,  590,
 /*  2590 */   462,  204,  239,  547,  541,  541,  541,  541,  541,  541,
 /*  2600 */   541,  541,  590,   86,   84,  440,   89,   90,  590,  590,
 /*  2610 */   649,  422,   96,  590,  590,  342,  590,  590,  590,  590,
 /*  2620 */   590,  570,  438,  437,  432,  223,  229,  232,  590,  590,
 /*  2630 */   590,  135,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  2640 */   590,  590,   53,   50,  590,  590,  590,  590,   60,  590,
 /*  2650 */    66,  136,  140,   65,   64,   62,   63,   68,   47,   48,
 /*  2660 */    49,  590,  146,  104,  590,  590,  590,  590,  590,  590,
 /*  2670 */   652,  441,  590,  590,   67,  590,  434,  329,  179,  545,
 /*  2680 */   543,  546,  590,  540,  590,  590,  590,  590,  590,  590,
 /*  2690 */   590,  590,  590,  590,  590,  590,  590,  539,  590,  590,
 /*  2700 */   350,  590,  590,  590,  590,  462,  204,  239,  547,  541,
 /*  2710 */   541,  541,  541,  541,  541,  541,  541,  590,   86,   84,
 /*  2720 */   440,   89,   90,  590,  590,  590,  422,   96,  590,  590,
 /*  2730 */   590,  590,  590,  590,  590,  590,  570,  557,  437,  432,
 /*  2740 */   223,  229,  232,  207,  590,  590,  498,  590,  590,  438,
 /*  2750 */   590,  590,  590,  590,  590,  590,  590,   53,   50,  590,
 /*  2760 */   590,  590,  590,   60,  590,   66,  136,  140,   65,   64,
 /*  2770 */    62,   63,   68,   47,   48,   49,  590,  146,  104,  590,
 /*  2780 */   590,  590,  590,  590,  590,  590,  590,  590,  590,   67,
 /*  2790 */   590,  679,  590,  590,  590,  590,  590,  590,  441,  590,
 /*  2800 */   590,  590,  590,  434,  329,  179,  545,  543,  546,  590,
 /*  2810 */   540,  590,  539,  590,  590,  350,  590,  590,  590,  590,
 /*  2820 */   462,  204,  239,  547,  541,  541,  541,  541,  541,  541,
 /*  2830 */   541,  541,  590,   86,   84,  440,   89,   90,  590,  590,
 /*  2840 */   590,  422,   96,  590,  590,  590,  590,  590,  590,  590,
 /*  2850 */   590,  570,  590,  437,  432,  223,  229,  232,  590,  590,
 /*  2860 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  2870 */   590,  590,   53,   50,  590,  590,  590,  590,   60,  590,
 /*  2880 */    66,  136,  140,   65,   64,   62,   63,   68,   47,   48,
 /*  2890 */    49,  590,  146,  104,  590,  590,  590,  590,  590,  590,
 /*  2900 */   590,  590,  590,  590,   67,  590,  681,  590,  590,  590,
 /*  2910 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  2920 */   590,  590,  590,  590,  590,  590,  590,  539,  590,  590,
 /*  2930 */   350,  590,  590,  590,  590,  462,  204,  239,  547,  541,
 /*  2940 */   541,  541,  541,  541,  541,  541,  541,  590,   86,   84,
 /*  2950 */   440,   89,   90,  590,  590,  590,  422,   96,  590,  590,
 /*  2960 */   590,  590,  590,  590,  590,  691,  570,  590,  437,  432,
 /*  2970 */   223,  229,  232,  590,  590,  590,  137,  438,  590,  590,
 /*  2980 */   590,  590,  590,  590,  590,  590,  590,   53,   50,  590,
 /*  2990 */   590,  590,  590,   60,  332,   66,  136,  140,   65,   64,
 /*  3000 */    62,   63,   68,   47,   48,   49,  590,  146,  104,  590,
 /*  3010 */   590,  590,  590,  590,  590,  590,  590,  590,  590,   67,
 /*  3020 */   590,  590,  590,  590,  590,  590,  441,  590,  590,  590,
 /*  3030 */   590,  434,  329,  179,  545,  543,  546,  590,  540,  590,
 /*  3040 */   590,  689,  539,  590,  590,  350,  590,  590,  590,  590,
 /*  3050 */   462,  204,  239,  547,  541,  541,  541,  541,  541,  541,
 /*  3060 */   541,  541,  590,   86,   84,  440,   89,   90,  590,  590,
 /*  3070 */   590,  422,   96,  590,  590,  590,  590,  590,  590,  590,
 /*  3080 */   590,  570,  590,  437,  432,  223,  229,  232,  590,  590,
 /*  3090 */   590,  134,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  3100 */   590,  590,   53,   50,  590,  590,  590,  590,   60,  590,
 /*  3110 */    66,  136,  140,   65,   64,   62,   63,   68,   47,   48,
 /*  3120 */    49,  590,  146,  104,  590,  590,  590,  590,  590,  590,
 /*  3130 */   590,  590,  590,  590,   67,  590,  590,  590,  590,  590,
 /*  3140 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  3150 */   590,  590,  590,  590,  590,  590,  590,  539,  590,  590,
 /*  3160 */   350,  590,  590,  590,  590,  462,  204,  239,  547,  541,
 /*  3170 */   541,  541,  541,  541,  541,  541,  541,  590,   86,   84,
 /*  3180 */   440,   89,   90,  590,  590,  590,  422,   96,  590,  590,
 /*  3190 */   590,  590,  590,  691,  590,  590,  570,  590,  437,  432,
 /*  3200 */   223,  229,  232,  590,  590,  438,  590,  590,  590,  590,
 /*  3210 */   590,  590,  590,  590,  590,  590,  590,   53,   50,  590,
 /*  3220 */   590,  590,  337,   60,  590,   66,  136,  140,   65,   64,
 /*  3230 */    62,   63,   68,   47,   48,   49,  590,  146,  104,  590,
 /*  3240 */   590,  590,  590,  590,  590,  590,  590,  590,  590,   67,
 /*  3250 */   672,  590,  590,  590,  441,  590,  590,  590,  590,  434,
 /*  3260 */   329,  179,  545,  543,  546,  590,  540,  590,  590,  689,
 /*  3270 */   590,  590,  539,  590,  590,  350,  590,  590,  590,  590,
 /*  3280 */   462,  204,  239,  547,  541,  541,  541,  541,  541,  541,
 /*  3290 */   541,  541,  590,   86,   84,  440,   89,   90,  590,  590,
 /*  3300 */   590,  422,   96,  590,  590,  590,  590,  590,  590,  590,
 /*  3310 */   590,  570,  590,  437,  432,  223,  229,  232,  590,  590,
 /*  3320 */   590,  133,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  3330 */   590,  590,   53,   50,  590,  590,  590,  590,   60,  590,
 /*  3340 */    66,  136,  140,   65,   64,   62,   63,   68,   47,   48,
 /*  3350 */    49,  590,  146,  104,  590,  590,  590,  590,  590,  590,
 /*  3360 */   590,  590,  590,  590,   67,  590,  590,  590,  590,  590,
 /*  3370 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  3380 */   590,  590,  590,  590,  590,  590,  590,  539,  590,  590,
 /*  3390 */   350,  590,  590,  590,  590,  462,  204,  239,  547,  541,
 /*  3400 */   541,  541,  541,  541,  541,  541,  541,  590,   86,   84,
 /*  3410 */   440,   89,   90,  590,  590,  590,  422,   96,  590,  590,
 /*  3420 */   590,  649,  590,  590,  590,  590,  570,  590,  437,  432,
 /*  3430 */   223,  229,  232,  438,  590,  590,  590,  590,  590,  590,
 /*  3440 */   590,  590,  590,  590,  590,  590,  590,   53,   50,  590,
 /*  3450 */   590,  590,  590,   60,  590,   66,  136,  140,   65,   64,
 /*  3460 */    62,   63,   68,   47,   48,   49,  590,  146,  104,  590,
 /*  3470 */   590,  590,  590,  590,  590,  590,  590,  590,  590,   67,
 /*  3480 */   590,  650,  441,  590,  590,  590,  590,  434,  329,  179,
 /*  3490 */   545,  543,  546,  590,  540,  590,  590,  590,  590,  590,
 /*  3500 */   590,  590,  539,  590,  590,  350,  590,  590,  590,  590,
 /*  3510 */   462,  204,  239,  547,  541,  541,  541,  541,  541,  541,
 /*  3520 */   541,  541,  590,   86,   84,  440,   89,   90,  590,  590,
 /*  3530 */   590,  422,   96,  590,  590,  590,  590,  590,  590,  590,
 /*  3540 */   590,  570,  590,  437,  432,  223,  229,  232,  590,  590,
 /*  3550 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  3560 */   590,  590,   53,   50,  590,  590,  590,  590,   60,  590,
 /*  3570 */    66,  136,  140,   65,   64,   62,   63,   68,   47,   48,
 /*  3580 */    49,  590,  146,  104,  590,  590,  590,  590,  590,  590,
 /*  3590 */   590,  590,  590,  590,   67,  590,  590,  590,  590,  590,
 /*  3600 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  3610 */   590,  590,  590,  590,  590,  590,  590,  539,  590,  590,
 /*  3620 */   350,  590,  590,  590,  590,  462,  204,  239,  547,  541,
 /*  3630 */   541,  541,  541,  541,  541,  541,  541,  590,  590,  590,
 /*  3640 */   590,  590,  590,  590,  590,  590,  422,  590,  590,  639,
 /*  3650 */   642,  643,  596,  590,  255,  590,  414,  194,  437,  432,
 /*  3660 */   223,  229,  232,  587,  313,  590,  590,  590,  590,  590,
 /*  3670 */   590,  590,  590,  590,  590,  590,  431,  590,  590,  590,
 /*  3680 */   640,  645,  644,  590,  590,  419,  590,  590,  590,  460,
 /*  3690 */   550,  590,  588,  590,  590,  590,  349,  609,  590,  602,
 /*  3700 */   424,  590,  590,  572,  895,  590,  552,  553,  590,   44,
 /*  3710 */   106,   87,   95,   97,   69,   93,   91,   92,   83,   82,
 /*  3720 */    74,  590,  590,  590,  590,  441,  340,  590,  590,  605,
 /*  3730 */   434,  329,  179,  545,  543,  546,  603,  540,  590,  590,
 /*  3740 */   590,  639,  642,  643,  596,  569,  255,  935,  935,  590,
 /*  3750 */   590,  590,  590,  590,  590,  587,  313,  590,  556,  549,
 /*  3760 */   604,  578,  577,  551,   59,  590,  144,  590,  431,  590,
 /*  3770 */   590,  895,  640,  645,  644,  590,  590,  419,  590,  590,
 /*  3780 */   590,  460,  590,  590,  588,  590,  590,  590,  349,  609,
 /*  3790 */   590,  602,  424,  590,  590,  572,   44,  106,   87,   95,
 /*  3800 */    97,   69,   93,   91,   92,   83,   82,   74,  590,  590,
 /*  3810 */   590,  590,  590,  590,  590,  590,  590,  441,  590,  590,
 /*  3820 */   590,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /*  3830 */    98,  119,  103,  590,  935,  935,  590,  569,  590,  590,
 /*  3840 */   590,  590,  590,  590,  590,  590,   51,  687,  102,  112,
 /*  3850 */   115,  117,  114,  116,   94,  121,  113,   56,   57,   58,
 /*  3860 */    55,  108,   99,  111,  110,  118,  101,  107,  120,  590,
 /*  3870 */   148,  591,  590,  589,  592,  596,  125,  255,  590,  590,
 /*  3880 */   590,  590,  590,  590,  590,  590,  587,  313,  590,  590,
 /*  3890 */   590,  590,  590,  590,  590,  590,  590,  687,  590,  431,
 /*  3900 */   590,  590,  590,  590,  645,  644,  590,  590,  419,  590,
 /*  3910 */   590,  590,  460,  590,  590,  588,  590,  590,  590,  349,
 /*  3920 */   609,  590,  602,  424,  528,  590,  572,  596,  590,  255,
 /*  3930 */   590,  590,  590,  590,  590,  590,  590,  590,  587,  313,
 /*  3940 */   590,  590,  590,  590,  590,  590,  590,  590,  441,  590,
 /*  3950 */   656,  431,  590,  434,  329,  179,  545,  543,  546,  590,
 /*  3960 */   540,   98,  119,  103,  590,  590,  590,  588,  569,  590,
 /*  3970 */   590,  349,  609,  590,  602,  424,  590,   51,  572,  102,
 /*  3980 */   112,  115,  117,  114,  116,   94,  121,  113,   56,   57,
 /*  3990 */    58,   55,  108,   99,  111,  110,  118,  101,  107,  120,
 /*  4000 */   441,  148,  590,  590,  590,  434,  329,  179,  545,  543,
 /*  4010 */   546,  590,  540,  590,  590,  590,  590,  590,  590,  590,
 /*  4020 */   569,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4030 */   673,  590,  590,  590,  590,  590,  590,  590,   98,  119,
 /*  4040 */   103,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4050 */   590,  590,  590,  590,   51,  590,  102,  112,  115,  117,
 /*  4060 */   114,  116,   94,  121,  113,   56,   57,   58,   55,  108,
 /*  4070 */    99,  111,  110,  118,  101,  107,  120,  590,  148,  590,
 /*  4080 */   590,  590,  590,  590,  590,  590,  590,  590,   44,  106,
 /*  4090 */    87,   95,   97,   69,   93,   91,   92,   83,   82,   74,
 /*  4100 */   590,  590,  590,  590,  363,  590,  590,  590,  590,  590,
 /*  4110 */   590,  590,   98,  119,  103,  590,  590,  590,  590,  590,
 /*  4120 */   590,  590,  590,  590,  590,  590,  935,  935,   51,  590,
 /*  4130 */   102,  112,  115,  117,  114,  116,   94,  121,  113,   56,
 /*  4140 */    57,   58,   55,  108,   99,  111,  110,  118,  101,  107,
 /*  4150 */   120,  685,  148,  590,  590,  590,  590,  590,  590,  550,
 /*  4160 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4170 */   590,  590,  590,  590,  590,  552,  553,  590,  454,  590,
 /*  4180 */   590,  590,  590,  590,  590,  590,   98,  119,  103,  590,
 /*  4190 */   590,  590,  590,  590,  590,  340,  590,  590,  605,  590,
 /*  4200 */   590,  590,   51,  590,  102,  112,  115,  117,  114,  116,
 /*  4210 */    94,  121,  113,   56,   57,   58,   55,  108,   99,  111,
 /*  4220 */   110,  118,  101,  107,  120,  590,  148,  556,  549,  604,
 /*  4230 */   578,  577,  551,   59,  590,  144,  550,  590,  590,  575,
 /*  4240 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4250 */   557,  590,  552,  553,  590,  548,  489,  590,  590,  498,
 /*  4260 */   590,  590,  438,   98,  119,  103,  590,  590,  590,  590,
 /*  4270 */   590,  590,  340,  590,  590,  605,  590,  590,  590,   51,
 /*  4280 */   590,  102,  112,  115,  117,  114,  116,   94,  121,  113,
 /*  4290 */    56,   57,   58,   55,  108,   99,  111,  110,  118,  101,
 /*  4300 */   107,  120,  590,  148,  556,  549,  604,  578,  577,  551,
 /*  4310 */    59,  441,  144,  590,  590,  576,  434,  329,  179,  545,
 /*  4320 */   543,  546,  590,  540,  590,  590,  590,  590,  590,  590,
 /*  4330 */   682,  590,  590,  590,  590,  590,  590,  590,   98,  119,
 /*  4340 */   103,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4350 */   590,  590,  590,  590,   51,  590,  102,  112,  115,  117,
 /*  4360 */   114,  116,   94,  121,  113,   56,   57,   58,   55,  108,
 /*  4370 */    99,  111,  110,  118,  101,  107,  120,  590,  148,  590,
 /*  4380 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4390 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4400 */   590,  590,  590,  590,  590,  590,  590,  542,  590,  590,
 /*  4410 */   590,  590,  590,  590,  590,   98,  119,  103,  590,  590,
 /*  4420 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4430 */   590,   51,  590,  102,  112,  115,  117,  114,  116,   94,
 /*  4440 */   121,  113,   56,   57,   58,   55,  108,   99,  111,  110,
 /*  4450 */   118,  101,  107,  120,  892,  148,   98,  119,  103,   44,
 /*  4460 */   106,   87,   95,   97,   69,   93,   91,   92,   83,   82,
 /*  4470 */    74,  590,   51,  590,  102,  112,  115,  117,  114,  116,
 /*  4480 */    94,  121,  113,   56,   57,   58,   55,  108,   99,  111,
 /*  4490 */   110,  118,  101,  107,  120,  590,  148,  935,  935,  590,
 /*  4500 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4510 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4520 */   590,  892,  600,   42,  590,  590,  590,  590,  590,  590,
 /*  4530 */    98,  119,  103,  590,  590,  590,  590,  590,  590,  590,
 /*  4540 */   590,  590,  590,  590,  590,  590,   51,   52,  102,  112,
 /*  4550 */   115,  117,  114,  116,   94,  121,  113,   56,   57,   58,
 /*  4560 */    55,  108,   99,  111,  110,  118,  101,  107,  120,  590,
 /*  4570 */   148,   98,  119,  103,  590,  590,  590,  590,  590,  590,
 /*  4580 */   590,  590,  590,  590,  590,  590,  590,   51,  590,  102,
 /*  4590 */   112,  115,  117,  114,  116,   94,  121,  113,   56,   57,
 /*  4600 */    58,   55,  108,   99,  111,  110,  118,  101,  107,  120,
 /*  4610 */   590,  148,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4620 */   590,  590,  590,  590,  557,  590,  590,  590,  590,  590,
 /*  4630 */   590,  590,  590,  544,  590,  590,  438,  590,  647,  590,
 /*  4640 */   590,  590,  590,  590,  590,  590,   98,  119,  103,  590,
 /*  4650 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4660 */   590,  590,   51,  590,  102,  112,  115,  117,  114,  116,
 /*  4670 */    94,  121,  113,   56,   57,   58,   55,  108,   99,  111,
 /*  4680 */   110,  118,  101,  107,  120,  441,  148,   98,  119,  103,
 /*  4690 */   434,  329,  179,  545,  543,  546,  590,  540,  590,  590,
 /*  4700 */   590,  590,  590,   51,  590,  102,  112,  115,  117,  114,
 /*  4710 */   116,   94,  121,  113,   56,   57,   58,   55,  108,   99,
 /*  4720 */   111,  110,  118,  101,  107,  120,  590,  148,  590,  590,
 /*  4730 */   590,  590,  590,  590,  550,  590,  590,  590,  590,  590,
 /*  4740 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4750 */   552,  553,  590,   20,  590,  590,  557,  590,  590,  590,
 /*  4760 */   590,   98,  119,  103,  590,  669,  590,  420,  438,  590,
 /*  4770 */   340,  590,  590,  605,  590,  590,  590,   51,  590,  102,
 /*  4780 */   112,  115,  117,  114,  116,   94,  121,  113,   56,   57,
 /*  4790 */    58,   55,  108,   99,  111,  110,  118,  101,  107,  120,
 /*  4800 */   590,  148,  556,  549,  604,  578,  577,  551,   59,  590,
 /*  4810 */   144,  590,  590,  590,  590,  590,  574,  441,  590,  590,
 /*  4820 */   590,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /*  4830 */   668,  590,  590,  557,  590,  590,  590,  590,   98,  119,
 /*  4840 */   103,  590,  202,  590,  590,  438,  590,  590,  590,  590,
 /*  4850 */   590,  590,  590,  590,   51,  590,  102,  112,  115,  117,
 /*  4860 */   114,  116,   94,  121,  113,   56,   57,   58,   55,  108,
 /*  4870 */    99,  111,  110,  118,  101,  107,  120,  590,  148,  590,
 /*  4880 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  4890 */   590,  590,  590,  590,  441,  590,  562,  590,  590,  434,
 /*  4900 */   329,  179,  545,  543,  546,  680,  540,  590,  438,  590,
 /*  4910 */   590,  590,  590,   98,  119,  103,  590,  590,  590,  590,
 /*  4920 */   590,  590,  590,  590,  590,  590,  590,  590,  590,   51,
 /*  4930 */   590,  102,  112,  115,  117,  114,  116,   94,  121,  113,
 /*  4940 */    56,   57,   58,   55,  108,   99,  111,  110,  118,  101,
 /*  4950 */   107,  120,  590,  148,  590,  590,  590,  441,  590,  590,
 /*  4960 */   590,  590,  434,  329,  179,  545,  543,  546,  691,  540,
 /*  4970 */   590,  590,  590,  590,  590,  590,  345,  590,  590,  610,
 /*  4980 */   438,  590,  590,  590,  590,  590,  590,   98,  119,  103,
 /*  4990 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5000 */   590,  590,  590,   51,  590,  102,  112,  115,  117,  114,
 /*  5010 */   116,   94,  121,  113,   56,   57,   58,   55,  108,   99,
 /*  5020 */   111,  110,  118,  101,  107,  120,  590,  148,  590,  441,
 /*  5030 */   590,  590,  590,  590,  434,  329,  179,  545,  543,  546,
 /*  5040 */   590,  540,  590,  590,  678,  590,  590,  590,  590,  590,
 /*  5050 */   590,  590,  590,   21,  590,  590,  590,  590,  590,  590,
 /*  5060 */   590,   98,  119,  103,  590,  590,  590,  590,  590,  590,
 /*  5070 */   590,  590,  590,  590,  590,  590,  590,   51,  590,  102,
 /*  5080 */   112,  115,  117,  114,  116,   94,  121,  113,   56,   57,
 /*  5090 */    58,   55,  108,   99,  111,  110,  118,  101,  107,  120,
 /*  5100 */   590,  148,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5110 */   590,  590,  590,  629,  590,  590,  590,  590,  590,  590,
 /*  5120 */   590,  590,  590,  590,  590,  438,  590,  571,  590,  590,
 /*  5130 */   590,  590,  590,  590,  590,   98,  119,  103,  590,  590,
 /*  5140 */   590,  631,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5150 */   590,   51,  590,  102,  112,  115,  117,  114,  116,   94,
 /*  5160 */   121,  113,   56,   57,   58,   55,  108,   99,  111,  110,
 /*  5170 */   118,  101,  107,  120,  441,  148,   98,  119,  103,  434,
 /*  5180 */   329,  179,  545,  543,  546,  590,  540,  590,  590,  590,
 /*  5190 */   590,  590,   51,  590,  102,  112,  115,  117,  114,  116,
 /*  5200 */    94,  121,  113,   56,   57,   58,   55,  108,   99,  111,
 /*  5210 */   110,  118,  101,  107,  120,  590,  148,  590,  590,  590,
 /*  5220 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5230 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5240 */   590,  590,  195,   39,  557,  590,  590,  590,  590,  590,
 /*  5250 */    98,  119,  103,  670,  590,  590,  438,  590,  590,  590,
 /*  5260 */   590,  590,  590,  590,  590,  590,   51,  590,  102,  112,
 /*  5270 */   115,  117,  114,  116,   94,  121,  113,   56,   57,   58,
 /*  5280 */    55,  108,   99,  111,  110,  118,  101,  107,  120,  590,
 /*  5290 */   148,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5300 */   590,  590,  590,  590,  590,  441,  590,  590,  590,  590,
 /*  5310 */   434,  329,  179,  545,  543,  546,  590,  540,  590,  630,
 /*  5320 */   590,  557,  590,  590,  590,  590,  590,   98,  119,  103,
 /*  5330 */   671,  590,  590,  438,  590,  590,  590,  590,  590,  590,
 /*  5340 */   590,  590,  590,   51,  590,  102,  112,  115,  117,  114,
 /*  5350 */   116,   94,  121,  113,   56,   57,   58,   55,  108,   99,
 /*  5360 */   111,  110,  118,  101,  107,  120,  590,  148,  590,  590,
 /*  5370 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5380 */   590,  590,  441,  590,  590,  590,  590,  434,  329,  179,
 /*  5390 */   545,  543,  546,  590,  540,  590,  659,  590,  590,  590,
 /*  5400 */   590,  590,  590,  590,   98,  119,  103,  590,  590,  590,
 /*  5410 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5420 */    51,  590,  102,  112,  115,  117,  114,  116,   94,  121,
 /*  5430 */   113,   56,   57,   58,   55,  108,   99,  111,  110,  118,
 /*  5440 */   101,  107,  120,  590,  148,  590,  590,  590,  590,  590,
 /*  5450 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5460 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5470 */    23,  590,  590,  557,  590,  590,  590,  590,   98,  119,
 /*  5480 */   103,  590,  499,  590,  590,  438,  590,  590,  590,  590,
 /*  5490 */   590,  590,  590,  590,   51,  590,  102,  112,  115,  117,
 /*  5500 */   114,  116,   94,  121,  113,   56,   57,   58,   55,  108,
 /*  5510 */    99,  111,  110,  118,  101,  107,  120,  590,  148,  590,
 /*  5520 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5530 */   590,  590,  590,  590,  441,  590,  590,  590,  590,  434,
 /*  5540 */   329,  179,  545,  543,  546,  625,  540,  590,  590,  590,
 /*  5550 */   590,  590,  590,   98,  119,  103,  590,  590,  590,  590,
 /*  5560 */   590,  590,  590,  590,  590,  590,  590,  590,  590,   51,
 /*  5570 */   590,  102,  112,  115,  117,  114,  116,   94,  121,  113,
 /*  5580 */    56,   57,   58,   55,  108,   99,  111,  110,  118,  101,
 /*  5590 */   107,  120,  590,  148,  119,  103,  590,  590,  590,  590,
 /*  5600 */   590,  590,  590,  590,  590,  590,  590,  590,  590,   51,
 /*  5610 */   590,  102,  112,  115,  117,  114,  116,   94,  121,  113,
 /*  5620 */    56,   57,   58,   55,  108,   99,  111,  110,  118,  101,
 /*  5630 */   107,  120,  103,  148,  590,  590,  590,  590,  590,  590,
 /*  5640 */   590,  590,  590,  590,  590,  590,   51,  590,  102,  112,
 /*  5650 */   115,  117,  114,  116,   94,  121,  113,   56,   57,   58,
 /*  5660 */    55,  108,   99,  111,  110,  118,  101,  107,  120,  586,
 /*  5670 */   148,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5680 */   590,  438,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5690 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5700 */   496,  597,  590,  596,  590,  255,  590,  590,  590,  590,
 /*  5710 */   590,  590,  696,  590,  587,  313,  590,  590,  497,  590,
 /*  5720 */   590,  596,  590,  255,  590,  590,  590,  431,  692,  590,
 /*  5730 */   441,  590,  587,  313,  590,  434,  329,  179,  545,  543,
 /*  5740 */   546,  590,  540,  588,  590,  431,  590,  349,  609,  590,
 /*  5750 */   602,  424,  590,  590,  572,  590,  590,  590,  590,  590,
 /*  5760 */   590,  588,  590,  590,  590,  349,  609,  590,  602,  424,
 /*  5770 */   590,  590,  572,  590,  590,  590,  441,  590,  590,  590,
 /*  5780 */   590,  434,  329,  179,  545,  543,  546,  590,  540,  590,
 /*  5790 */   590,  590,  590,  590,  441,  590,  569,  590,  590,  434,
 /*  5800 */   329,  179,  545,  543,  546,  526,  540,  590,  596,  590,
 /*  5810 */   255,  590,  590,  590,  569,  590,  590,  590,  590,  587,
 /*  5820 */   313,  590,  590,  590,  590,  590,  590,  590,  653,  590,
 /*  5830 */   590,  590,  431,  590,  590,  590,  590,  590,  590,  590,
 /*  5840 */   590,  590,  590,  590,  590,  590,  590,  590,  588,  590,
 /*  5850 */   590,  590,  349,  609,  590,  602,  424,  590,  590,  572,
 /*  5860 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5870 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  5880 */   526,  441,  590,  596,  590,  255,  434,  329,  179,  545,
 /*  5890 */   543,  546,  590,  540,  587,  313,  590,  590,  590,  590,
 /*  5900 */   590,  569,  273,  491,  590,  590,  590,  431,  465,  590,
 /*  5910 */   590,  587,  313,  590,  590,  590,  590,  590,  590,  590,
 /*  5920 */   590,  590,  590,  588,  431,  590,  590,  349,  609,  590,
 /*  5930 */   602,  424,  590,  590,  572,  590,  590,  590,  590,  590,
 /*  5940 */   588,  590,  590,  590,  349,  609,  557,  602,  424,  590,
 /*  5950 */   590,  572,  590,  590,  590,  563,  441,  590,  438,  590,
 /*  5960 */   590,  434,  329,  179,  545,  543,  546,  590,  540,  590,
 /*  5970 */   590,  590,  590,  441,  590,  590,  569,  590,  434,  329,
 /*  5980 */   179,  545,  543,  546,  590,  540,  590,  590,  590,  590,
 /*  5990 */   590,  590,  590,  569,  590,  590,  590,  484,  590,  590,
 /*  6000 */   280,  590,  590,  590,  590,  590,  590,  441,  590,  348,
 /*  6010 */   310,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /*  6020 */   590,  590,  431,  590,  590,  590,  590,  590,  590,  590,
 /*  6030 */   590,  590,  590,  590,  590,  590,  590,  590,  588,  590,
 /*  6040 */   590,  590,  349,  609,  590,  602,  424,  261,  590,  572,
 /*  6050 */   590,  590,  590,  590,  590,  590,  587,  313,  590,  430,
 /*  6060 */   448,  590,  590,  590,  590,  590,  590,  590,  590,  431,
 /*  6070 */   590,  441,  590,  590,  590,  590,  434,  329,  179,  545,
 /*  6080 */   543,  546,  590,  540,  590,  588,  590,  590,  590,  349,
 /*  6090 */   609,  569,  602,  424,  428,  590,  572,  280,  590,  590,
 /*  6100 */   590,  590,  590,  590,  590,  590,  348,  310,  590,  590,
 /*  6110 */   590,  590,  590,  590,  590,  590,  590,  590,  441,  431,
 /*  6120 */   590,  590,  590,  434,  329,  179,  545,  543,  546,  590,
 /*  6130 */   540,  590,  590,  590,  217,  588,  590,  590,  569,  349,
 /*  6140 */   609,  590,  602,  424,  590,  590,  572,  590,  590,  280,
 /*  6150 */   590,  590,  590,  590,  590,  590,  483,  448,  348,  310,
 /*  6160 */   590,  590,  590,  590,  590,  590,  590,  590,  441,  590,
 /*  6170 */   590,  431,  590,  434,  329,  179,  545,  543,  546,  590,
 /*  6180 */   540,  590,  590,  590,  590,  590,  590,  588,  569,  590,
 /*  6190 */   590,  349,  609,  590,  602,  424,  590,  590,  572,  590,
 /*  6200 */   590,  280,  590,  590,  590,  590,  590,  590,  412,  448,
 /*  6210 */   348,  310,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  6220 */   441,  590,  590,  431,  590,  434,  329,  179,  545,  543,
 /*  6230 */   546,  590,  540,  590,  590,  590,  590,  590,  590,  588,
 /*  6240 */   569,  590,  590,  349,  609,  590,  602,  424,  590,  590,
 /*  6250 */   572,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  6260 */   417,  448,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  6270 */   590,  231,  441,  590,  596,  590,  255,  434,  329,  179,
 /*  6280 */   545,  543,  546,  590,  540,  587,  313,  590,  590,  590,
 /*  6290 */   590,  590,  569,  590,  273,  590,  590,  590,  431,  590,
 /*  6300 */   466,  590,  590,  587,  313,  590,  590,  590,  590,  590,
 /*  6310 */   590,  590,  590,  590,  588,  590,  431,  590,  349,  609,
 /*  6320 */   590,  602,  424,  590,  590,  572,  590,  590,  590,  590,
 /*  6330 */   590,  590,  588,  590,  590,  590,  349,  609,  559,  602,
 /*  6340 */   424,  590,  590,  572,  590,  590,  590,  441,  590,  590,
 /*  6350 */   438,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /*  6360 */   590,  590,  590,  590,  590,  441,  590,  569,  590,  590,
 /*  6370 */   434,  329,  179,  545,  543,  546,  522,  540,  590,  596,
 /*  6380 */   590,  255,  590,  590,  590,  569,  590,  590,  590,  484,
 /*  6390 */   587,  313,  590,  590,  590,  590,  590,  590,  590,  441,
 /*  6400 */   590,  590,  590,  431,  434,  329,  179,  545,  543,  546,
 /*  6410 */   590,  540,  590,  590,  590,  590,  590,  590,  590,  588,
 /*  6420 */   590,  590,  590,  349,  609,  590,  602,  424,  280,  590,
 /*  6430 */   572,  590,  590,  590,  590,  590,  590,  348,  310,  590,
 /*  6440 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  6450 */   431,  590,  441,  590,  590,  590,  590,  434,  329,  179,
 /*  6460 */   545,  543,  546,  590,  540,  590,  588,  590,  590,  590,
 /*  6470 */   349,  609,  569,  602,  424,  590,  590,  572,  590,  590,
 /*  6480 */   590,  590,  590,  590,  590,  590,  537,  480,  448,  596,
 /*  6490 */   590,  255,  590,  590,  590,  590,  590,  590,  590,  441,
 /*  6500 */   587,  313,  590,  590,  434,  329,  179,  545,  543,  546,
 /*  6510 */   590,  540,  590,  431,  590,  590,  590,  590,  590,  569,
 /*  6520 */   590,  590,  590,  590,  590,  590,  590,  586,  590,  588,
 /*  6530 */   590,  590,  590,  349,  609,  590,  602,  424,  590,  438,
 /*  6540 */   572,  273,  590,  590,  590,  590,  590,  463,  590,  590,
 /*  6550 */   587,  313,  590,  590,  590,  590,  590,  590,  590,  583,
 /*  6560 */   590,  590,  441,  431,  590,  590,  590,  434,  329,  179,
 /*  6570 */   545,  543,  546,  590,  540,  590,  590,  590,  590,  588,
 /*  6580 */   590,  590,  569,  349,  609,  590,  602,  424,  441,  590,
 /*  6590 */   572,  590,  590,  434,  329,  179,  545,  543,  546,  590,
 /*  6600 */   540,  590,  590,  590,  280,  590,  590,  590,  590,  590,
 /*  6610 */   590,  590,  441,  348,  310,  590,  590,  434,  329,  179,
 /*  6620 */   545,  543,  546,  590,  540,  590,  431,  590,  590,  590,
 /*  6630 */   590,  590,  569,  590,  590,  590,  484,  590,  590,  590,
 /*  6640 */   590,  590,  588,  590,  590,  590,  349,  609,  557,  602,
 /*  6650 */   424,  459,  590,  572,  596,  590,  255,  564,  590,  590,
 /*  6660 */   438,  590,  590,  444,  448,  587,  313,  590,  590,  590,
 /*  6670 */   590,  590,  590,  590,  590,  441,  590,  590,  431,  590,
 /*  6680 */   434,  329,  179,  545,  543,  546,  590,  540,  590,  590,
 /*  6690 */   590,  590,  590,  590,  588,  569,  446,  590,  349,  609,
 /*  6700 */   590,  602,  424,  277,  590,  572,  590,  590,  438,  441,
 /*  6710 */   590,  590,  587,  313,  434,  329,  179,  545,  543,  546,
 /*  6720 */   590,  540,  590,  590,  590,  431,  590,  441,  590,  590,
 /*  6730 */   590,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /*  6740 */   590,  588,  590,  590,  433,  349,  609,  569,  602,  424,
 /*  6750 */   590,  590,  572,  590,  590,  590,  438,  441,  590,  590,
 /*  6760 */   590,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /*  6770 */   590,  590,  590,  590,  441,  590,  590,  590,  279,  434,
 /*  6780 */   329,  179,  545,  543,  546,  455,  540,  587,  313,  590,
 /*  6790 */   590,  346,  590,  590,  569,  590,  590,  590,  590,  590,
 /*  6800 */   431,  590,  590,  590,  590,  441,  590,  590,  590,  590,
 /*  6810 */   434,  329,  179,  545,  543,  546,  588,  540,  590,  590,
 /*  6820 */   349,  609,  538,  602,  424,  590,  590,  572,  590,  590,
 /*  6830 */   277,  590,  590,  590,  438,  590,  590,  590,  590,  587,
 /*  6840 */   313,  590,  590,  590,  590,  590,  590,  590,  590,  441,
 /*  6850 */   590,  590,  431,  590,  434,  329,  179,  545,  543,  546,
 /*  6860 */   590,  540,  590,  590,  590,  590,  590,  590,  588,  569,
 /*  6870 */   590,  590,  349,  609,  590,  602,  424,  306,  590,  572,
 /*  6880 */   590,  590,  590,  441,  590,  590,  587,  313,  434,  329,
 /*  6890 */   179,  545,  543,  546,  590,  540,  590,  590,  590,  431,
 /*  6900 */   590,  441,  590,  590,  590,  590,  434,  329,  179,  545,
 /*  6910 */   543,  546,  486,  540,  590,  588,  590,  590,  590,  349,
 /*  6920 */   609,  569,  602,  424,  590,  590,  572,  590,  590,  590,
 /*  6930 */   590,  590,  590,  590,  590,  590,  590,  304,  590,  590,
 /*  6940 */   590,  590,  590,  590,  590,  590,  587,  313,  441,  590,
 /*  6950 */   590,  590,  590,  434,  329,  179,  545,  543,  546,  431,
 /*  6960 */   540,  590,  590,  590,  590,  590,  590,  590,  569,  590,
 /*  6970 */   590,  590,  590,  590,  590,  588,  590,  590,  590,  349,
 /*  6980 */   609,  590,  602,  424,  590,  590,  572,  590,  590,  590,
 /*  6990 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7000 */   590,  283,  590,  590,  590,  590,  590,  590,  441,  590,
 /*  7010 */   587,  313,  590,  434,  329,  179,  545,  543,  546,  590,
 /*  7020 */   540,  590,  590,  431,  590,  590,  590,  590,  569,  590,
 /*  7030 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  588,
 /*  7040 */   590,  590,  590,  349,  609,  590,  602,  424,  590,  590,
 /*  7050 */   572,  307,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7060 */   587,  313,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7070 */   590,  590,  441,  431,  590,  590,  590,  434,  329,  179,
 /*  7080 */   545,  543,  546,  590,  540,  590,  590,  590,  590,  588,
 /*  7090 */   590,  590,  569,  349,  609,  590,  602,  424,  250,  590,
 /*  7100 */   572,  590,  590,  590,  590,  590,  590,  587,  313,  590,
 /*  7110 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7120 */   431,  590,  441,  590,  590,  590,  590,  434,  329,  179,
 /*  7130 */   545,  543,  546,  590,  540,  590,  588,  590,  590,  590,
 /*  7140 */   349,  609,  569,  602,  424,  590,  590,  572,  590,  590,
 /*  7150 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7160 */   590,  590,  481,  590,  590,  590,  590,  590,  590,  441,
 /*  7170 */   590,  587,  313,  590,  434,  329,  179,  545,  543,  546,
 /*  7180 */   590,  540,  590,  590,  431,  590,  590,  590,  590,  569,
 /*  7190 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7200 */   588,  590,  590,  590,  349,  609,  590,  602,  424,  590,
 /*  7210 */   590,  572,  324,  590,  590,  590,  590,  590,  590,  590,
 /*  7220 */   590,  587,  313,  590,  590,  590,  590,  590,  590,  590,
 /*  7230 */   590,  590,  590,  441,  431,  590,  590,  590,  434,  329,
 /*  7240 */   179,  545,  543,  546,  590,  540,  590,  590,  590,  590,
 /*  7250 */   588,  590,  590,  569,  349,  609,  590,  602,  424,  305,
 /*  7260 */   590,  572,  590,  590,  590,  590,  590,  590,  587,  313,
 /*  7270 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7280 */   590,  431,  590,  441,  590,  590,  590,  590,  434,  329,
 /*  7290 */   179,  545,  543,  546,  590,  540,  590,  588,  590,  590,
 /*  7300 */   590,  349,  609,  569,  602,  424,  590,  590,  572,  590,
 /*  7310 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7320 */   590,  590,  590,  303,  590,  590,  590,  590,  590,  590,
 /*  7330 */   441,  590,  587,  313,  590,  434,  329,  179,  545,  543,
 /*  7340 */   546,  590,  540,  590,  590,  431,  590,  590,  590,  590,
 /*  7350 */   569,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7360 */   590,  588,  590,  590,  590,  349,  609,  590,  602,  424,
 /*  7370 */   590,  590,  572,  302,  590,  590,  590,  590,  590,  590,
 /*  7380 */   590,  590,  587,  313,  590,  590,  590,  590,  590,  590,
 /*  7390 */   590,  590,  590,  590,  441,  431,  590,  590,  590,  434,
 /*  7400 */   329,  179,  545,  543,  546,  590,  540,  590,  590,  590,
 /*  7410 */   590,  588,  590,  590,  569,  349,  609,  590,  602,  424,
 /*  7420 */   275,  590,  572,  590,  590,  590,  590,  590,  590,  587,
 /*  7430 */   313,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7440 */   590,  590,  431,  590,  441,  590,  590,  590,  590,  434,
 /*  7450 */   329,  179,  545,  543,  546,  590,  540,  590,  588,  590,
 /*  7460 */   590,  590,  349,  609,  569,  602,  424,  590,  590,  572,
 /*  7470 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7480 */   590,  590,  590,  590,  280,  590,  590,  590,  590,  590,
 /*  7490 */   590,  441,  590,  411,  312,  590,  434,  329,  179,  545,
 /*  7500 */   543,  546,  590,  540,  590,  590,  431,  590,  590,  590,
 /*  7510 */   590,  569,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7520 */   590,  590,  588,  590,  590,  590,  349,  609,  590,  602,
 /*  7530 */   424,  590,  590,  572,  269,  590,  590,  590,  590,  590,
 /*  7540 */   590,  590,  590,  587,  313,  590,  590,  590,  590,  590,
 /*  7550 */   590,  590,  590,  590,  590,  441,  431,  590,  590,  590,
 /*  7560 */   434,  329,  179,  545,  543,  546,  590,  540,  590,  590,
 /*  7570 */   590,  590,  588,  590,  590,  569,  349,  609,  590,  602,
 /*  7580 */   424,  281,  590,  572,  590,  590,  590,  590,  590,  590,
 /*  7590 */   587,  313,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7600 */   590,  590,  590,  431,  590,  441,  590,  590,  590,  590,
 /*  7610 */   434,  329,  179,  545,  543,  546,  590,  540,  590,  588,
 /*  7620 */   590,  590,  590,  349,  609,  569,  602,  424,  590,  590,
 /*  7630 */   572,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7640 */   590,  590,  590,  590,  590,  257,  590,  590,  590,  590,
 /*  7650 */   590,  590,  441,  590,  587,  313,  590,  434,  329,  179,
 /*  7660 */   545,  543,  546,  590,  540,  590,  590,  431,  590,  590,
 /*  7670 */   590,  590,  569,  590,  590,  590,  590,  590,  590,  590,
 /*  7680 */   590,  590,  590,  588,  590,  590,  590,  349,  609,  590,
 /*  7690 */   602,  424,  590,  590,  572,  256,  590,  590,  590,  590,
 /*  7700 */   590,  590,  590,  590,  587,  313,  590,  590,  590,  590,
 /*  7710 */   590,  590,  590,  590,  590,  590,  441,  431,  590,  590,
 /*  7720 */   590,  434,  329,  179,  545,  543,  546,  590,  540,  590,
 /*  7730 */   590,  590,  590,  588,  590,  590,  569,  349,  609,  590,
 /*  7740 */   602,  424,  251,  590,  572,  590,  590,  590,  590,  590,
 /*  7750 */   590,  587,  313,  590,  590,  590,  590,  590,  590,  590,
 /*  7760 */   590,  590,  590,  590,  431,  590,  441,  590,  590,  590,
 /*  7770 */   590,  434,  329,  179,  545,  543,  546,  590,  540,  590,
 /*  7780 */   588,  590,  590,  590,  349,  609,  569,  602,  424,  590,
 /*  7790 */   590,  572,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  7800 */   590,  590,  590,  590,  590,  590,  258,  590,  590,  590,
 /*  7810 */   590,  590,  590,  441,  590,  587,  313,  590,  434,  329,
 /*  7820 */   179,  545,  543,  546,  590,  540,  590,  590,  431,  590,
 /*  7830 */   590,  590,  590,  569,  590,  590,  590,  590,  590,  590,
 /*  7840 */   590,  590,  590,  590,  588,  590,  590,  590,  349,  609,
 /*  7850 */   590,  602,  424,  590,  590,  572,  267,  590,  590,  590,
 /*  7860 */   590,  590,  590,  590,  590,  587,  313,  590,  590,  590,
 /*  7870 */   590,  590,  590,  590,  590,  590,  590,  441,  431,  590,
 /*  7880 */   590,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /*  7890 */   590,  590,  590,  590,  588,  590,  590,  569,  349,  609,
 /*  7900 */   590,  602,  424,  259,  590,  572,  590,  590,  590,  590,
 /*  7910 */   590,  590,  587,  313,  590,  590,  590,  590,  590,  590,
 /*  7920 */   590,  590,  590,  590,  590,  431,  590,  441,  590,  590,
 /*  7930 */   590,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /*  7940 */   590,  588,  590,  590,  590,  349,  609,  569,  602,  424,
 /*  7950 */   590,  590,  572,  590,  590,  590,  590,  590,  590,  590,
 /*  7960 */   590,  590,  590,  590,  590,  590,  590,  293,  590,  590,
 /*  7970 */   590,  590,  590,  590,  441,  590,  587,  313,  590,  434,
 /*  7980 */   329,  179,  545,  543,  546,  590,  540,  590,  590,  431,
 /*  7990 */   590,  590,  590,  590,  569,  590,  590,  590,  590,  590,
 /*  8000 */   590,  590,  590,  590,  590,  588,  590,  590,  590,  349,
 /*  8010 */   609,  590,  602,  424,  590,  590,  572,  183,  590,  590,
 /*  8020 */   590,  590,  590,  590,  590,  590,  587,  313,  590,  590,
 /*  8030 */   590,  590,  590,  590,  590,  590,  590,  590,  441,  431,
 /*  8040 */   590,  590,  590,  434,  329,  179,  545,  543,  546,  590,
 /*  8050 */   540,  590,  590,  590,  590,  588,  590,  590,  569,  349,
 /*  8060 */   609,  590,  602,  424,  288,  590,  572,  590,  590,  590,
 /*  8070 */   590,  590,  590,  587,  313,  590,  590,  590,  590,  590,
 /*  8080 */   590,  590,  590,  590,  590,  590,  431,  590,  441,  590,
 /*  8090 */   590,  590,  590,  434,  329,  179,  545,  543,  546,  590,
 /*  8100 */   540,  590,  588,  590,  590,  590,  349,  609,  569,  602,
 /*  8110 */   424,  590,  590,  572,  590,  590,  590,  590,  590,  590,
 /*  8120 */   590,  590,  590,  590,  590,  590,  590,  590,  284,  590,
 /*  8130 */   590,  590,  590,  590,  590,  441,  590,  587,  313,  590,
 /*  8140 */   434,  329,  179,  545,  543,  546,  590,  540,  590,  590,
 /*  8150 */   431,  590,  590,  590,  590,  569,  590,  590,  590,  590,
 /*  8160 */   590,  590,  590,  590,  590,  590,  588,  590,  590,  590,
 /*  8170 */   349,  609,  590,  602,  424,  590,  590,  572,  280,  590,
 /*  8180 */   590,  590,  590,  590,  590,  590,  590,  344,  309,  590,
 /*  8190 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  441,
 /*  8200 */   431,  590,  590,  590,  434,  329,  179,  545,  543,  546,
 /*  8210 */   590,  540,  590,  590,  590,  590,  588,  590,  590,  569,
 /*  8220 */   349,  609,  590,  602,  424,  292,  590,  572,  590,  590,
 /*  8230 */   590,  590,  590,  590,  587,  313,  590,  590,  590,  590,
 /*  8240 */   590,  590,  590,  590,  590,  590,  590,  431,  590,  441,
 /*  8250 */   590,  590,  590,  590,  434,  329,  179,  545,  543,  546,
 /*  8260 */   590,  540,  590,  588,  590,  590,  590,  349,  609,  569,
 /*  8270 */   602,  424,  590,  590,  572,  590,  590,  590,  590,  590,
 /*  8280 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  608,
 /*  8290 */   590,  590,  590,  590,  590,  590,  441,  590,  587,  313,
 /*  8300 */   590,  434,  329,  179,  545,  543,  546,  590,  540,  590,
 /*  8310 */   590,  431,  590,  590,  590,  590,  569,  590,  590,  590,
 /*  8320 */   590,  590,  590,  590,  590,  590,  590,  588,  590,  590,
 /*  8330 */   590,  349,  609,  590,  602,  424,  590,  590,  572,  276,
 /*  8340 */   590,  590,  590,  590,  590,  590,  590,  590,  587,  313,
 /*  8350 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  8360 */   441,  431,  590,  590,  590,  434,  329,  179,  545,  543,
 /*  8370 */   546,  590,  540,  590,  590,  590,  590,  588,  590,  590,
 /*  8380 */   569,  349,  609,  590,  602,  424,  266,  590,  572,  590,
 /*  8390 */   590,  590,  590,  590,  590,  587,  313,  590,  590,  590,
 /*  8400 */   590,  590,  590,  590,  590,  590,  590,  590,  431,  590,
 /*  8410 */   441,  590,  590,  590,  590,  434,  329,  179,  545,  543,
 /*  8420 */   546,  590,  540,  590,  588,  590,  590,  590,  349,  609,
 /*  8430 */   569,  602,  424,  590,  590,  572,  590,  590,  590,  590,
 /*  8440 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  8450 */   296,  590,  590,  590,  590,  590,  590,  441,  590,  587,
 /*  8460 */   313,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /*  8470 */   590,  590,  431,  590,  590,  590,  590,  569,  590,  590,
 /*  8480 */   590,  590,  590,  590,  590,  590,  590,  590,  588,  590,
 /*  8490 */   590,  590,  349,  609,  590,  602,  424,  590,  590,  572,
 /*  8500 */   253,  590,  590,  590,  590,  590,  590,  590,  590,  587,
 /*  8510 */   313,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  8520 */   590,  441,  431,  590,  590,  590,  434,  329,  179,  545,
 /*  8530 */   543,  546,  590,  540,  590,  590,  590,  590,  588,  590,
 /*  8540 */   590,  569,  349,  609,  590,  602,  424,  265,  590,  572,
 /*  8550 */   590,  590,  590,  590,  590,  590,  587,  313,  590,  590,
 /*  8560 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  431,
 /*  8570 */   590,  441,  590,  590,  590,  590,  434,  329,  179,  545,
 /*  8580 */   543,  546,  590,  540,  590,  588,  590,  590,  590,  349,
 /*  8590 */   609,  569,  602,  424,  590,  590,  572,  590,  590,  590,
 /*  8600 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  8610 */   590,  301,  590,  590,  590,  590,  590,  590,  441,  590,
 /*  8620 */   587,  313,  590,  434,  329,  179,  545,  543,  546,  590,
 /*  8630 */   540,  590,  590,  431,  590,  590,  590,  590,  569,  590,
 /*  8640 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  588,
 /*  8650 */   590,  590,  590,  349,  609,  590,  602,  424,  590,  590,
 /*  8660 */   572,  252,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  8670 */   587,  313,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  8680 */   590,  590,  441,  431,  590,  590,  590,  434,  329,  179,
 /*  8690 */   545,  543,  546,  590,  540,  590,  590,  590,  590,  588,
 /*  8700 */   590,  590,  569,  349,  609,  590,  602,  424,  290,  590,
 /*  8710 */   572,  590,  590,  590,  590,  590,  590,  587,  313,  590,
 /*  8720 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  8730 */   431,  590,  441,  590,  590,  590,  590,  434,  329,  179,
 /*  8740 */   545,  543,  546,  590,  540,  590,  588,  590,  590,  590,
 /*  8750 */   349,  609,  569,  602,  424,  590,  590,  572,  590,  590,
 /*  8760 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  8770 */   590,  590,  249,  590,  590,  590,  590,  590,  590,  441,
 /*  8780 */   590,  587,  313,  590,  434,  329,  179,  545,  543,  546,
 /*  8790 */   590,  540,  590,  590,  431,  590,  590,  590,  590,  569,
 /*  8800 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  8810 */   588,  590,  590,  590,  349,  609,  590,  602,  424,  590,
 /*  8820 */   590,  572,  315,  590,  590,  590,  590,  590,  590,  590,
 /*  8830 */   590,  587,  313,  590,  590,  590,  590,  590,  590,  590,
 /*  8840 */   590,  590,  590,  441,  431,  590,  590,  590,  434,  329,
 /*  8850 */   179,  545,  543,  546,  590,  540,  590,  590,  590,  590,
 /*  8860 */   588,  590,  590,  569,  349,  609,  590,  602,  424,  314,
 /*  8870 */   590,  572,  590,  590,  590,  590,  590,  590,  587,  313,
 /*  8880 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  8890 */   590,  431,  590,  441,  590,  590,  590,  590,  434,  329,
 /*  8900 */   179,  545,  543,  546,  590,  540,  590,  588,  590,  590,
 /*  8910 */   590,  349,  609,  569,  602,  424,  590,  590,  572,  590,
 /*  8920 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  8930 */   590,  590,  590,  317,  590,  590,  590,  590,  590,  590,
 /*  8940 */   441,  590,  587,  313,  590,  434,  329,  179,  545,  543,
 /*  8950 */   546,  590,  540,  590,  590,  431,  590,  590,  590,  590,
 /*  8960 */   569,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  8970 */   590,  588,  590,  590,  590,  349,  609,  590,  602,  424,
 /*  8980 */   590,  590,  572,  322,  590,  590,  590,  590,  590,  590,
 /*  8990 */   590,  590,  587,  313,  590,  590,  590,  590,  590,  590,
 /*  9000 */   590,  590,  590,  590,  441,  431,  590,  590,  590,  434,
 /*  9010 */   329,  179,  545,  543,  546,  590,  540,  590,  590,  590,
 /*  9020 */   590,  588,  590,  590,  569,  349,  609,  590,  602,  424,
 /*  9030 */   299,  590,  572,  590,  590,  590,  590,  590,  590,  587,
 /*  9040 */   313,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  9050 */   590,  590,  431,  590,  441,  590,  590,  590,  590,  434,
 /*  9060 */   329,  179,  545,  543,  546,  590,  540,  590,  588,  590,
 /*  9070 */   590,  590,  349,  609,  569,  602,  424,  590,  590,  572,
 /*  9080 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  9090 */   590,  590,  590,  590,  607,  590,  590,  590,  590,  590,
 /*  9100 */   590,  441,  590,  587,  313,  590,  434,  329,  179,  545,
 /*  9110 */   543,  546,  590,  540,  590,  590,  431,  590,  590,  590,
 /*  9120 */   590,  569,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  9130 */   590,  590,  588,  590,  590,  590,  349,  609,  590,  602,
 /*  9140 */   424,  590,  590,  572,  599,  590,  590,  590,  590,  590,
 /*  9150 */   590,  590,  590,  587,  313,  590,  590,  590,  590,  590,
 /*  9160 */   590,  590,  590,  590,  590,  441,  431,  590,  590,  590,
 /*  9170 */   434,  329,  179,  545,  543,  546,  590,  540,  590,  590,
 /*  9180 */   590,  590,  588,  590,  590,  569,  349,  609,  590,  602,
 /*  9190 */   424,  321,  590,  572,  590,  590,  590,  590,  590,  590,
 /*  9200 */   587,  313,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  9210 */   590,  590,  590,  431,  590,  441,  590,  590,  590,  590,
 /*  9220 */   434,  329,  179,  545,  543,  546,  590,  540,  590,  588,
 /*  9230 */   590,  590,  590,  349,  609,  569,  602,  424,  590,  590,
 /*  9240 */   572,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  9250 */   590,  590,  590,  590,  590,  260,  590,  590,  590,  590,
 /*  9260 */   590,  590,  441,  590,  587,  313,  590,  434,  329,  179,
 /*  9270 */   545,  543,  546,  590,  540,  590,  590,  431,  590,  590,
 /*  9280 */   590,  590,  569,  590,  590,  590,  590,  590,  590,  590,
 /*  9290 */   590,  590,  590,  588,  590,  590,  590,  349,  609,  590,
 /*  9300 */   602,  424,  590,  590,  572,  316,  590,  590,  590,  590,
 /*  9310 */   590,  590,  590,  590,  587,  313,  590,  590,  590,  590,
 /*  9320 */   590,  590,  590,  590,  590,  590,  441,  431,  590,  590,
 /*  9330 */   590,  434,  329,  179,  545,  543,  546,  590,  540,  590,
 /*  9340 */   590,  590,  590,  588,  590,  590,  569,  349,  609,  590,
 /*  9350 */   602,  424,  248,  590,  572,  590,  590,  590,  590,  590,
 /*  9360 */   590,  587,  313,  590,  590,  590,  590,  590,  590,  590,
 /*  9370 */   590,  590,  590,  590,  431,  590,  441,  590,  590,  590,
 /*  9380 */   590,  434,  329,  179,  545,  543,  546,  590,  540,  590,
 /*  9390 */   588,  590,  590,  590,  349,  609,  569,  602,  424,  590,
 /*  9400 */   590,  572,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  9410 */   590,  590,  590,  590,  590,  590,  612,  590,  590,  590,
 /*  9420 */   590,  590,  590,  441,  590,  587,  313,  590,  434,  329,
 /*  9430 */   179,  545,  543,  546,  590,  540,  590,  590,  431,  590,
 /*  9440 */   590,  590,  590,  569,  590,  590,  590,  590,  590,  590,
 /*  9450 */   590,  590,  590,  590,  588,  590,  590,  590,  349,  609,
 /*  9460 */   590,  602,  424,  590,  590,  572,  611,  590,  590,  590,
 /*  9470 */   590,  590,  590,  590,  590,  587,  313,  590,  590,  590,
 /*  9480 */   590,  590,  590,  590,  590,  590,  590,  441,  431,  590,
 /*  9490 */   590,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /*  9500 */   590,  590,  590,  590,  588,  590,  590,  569,  349,  609,
 /*  9510 */   590,  602,  424,  262,  590,  572,  590,  590,  590,  590,
 /*  9520 */   590,  590,  587,  313,  590,  590,  590,  590,  590,  590,
 /*  9530 */   590,  590,  590,  590,  590,  431,  590,  441,  590,  590,
 /*  9540 */   590,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /*  9550 */   590,  588,  590,  590,  590,  349,  609,  569,  602,  424,
 /*  9560 */   590,  590,  572,  590,  590,  590,  590,  590,  590,  590,
 /*  9570 */   590,  590,  590,  590,  590,  590,  590,  614,  590,  590,
 /*  9580 */   590,  590,  590,  590,  441,  590,  587,  313,  590,  434,
 /*  9590 */   329,  179,  545,  543,  546,  590,  540,  590,  590,  431,
 /*  9600 */   590,  590,  590,  590,  569,  590,  590,  590,  590,  590,
 /*  9610 */   590,  590,  590,  590,  590,  588,  590,  590,  590,  349,
 /*  9620 */   609,  590,  602,  424,  590,  590,  572,  613,  590,  590,
 /*  9630 */   590,  590,  590,  590,  590,  590,  587,  313,  590,  590,
 /*  9640 */   590,  590,  590,  590,  590,  590,  590,  590,  441,  431,
 /*  9650 */   590,  590,  590,  434,  329,  179,  545,  543,  546,  590,
 /*  9660 */   540,  590,  590,  590,  590,  588,  590,  590,  569,  349,
 /*  9670 */   609,  590,  602,  424,  615,  590,  572,  590,  590,  590,
 /*  9680 */   590,  590,  590,  587,  313,  590,  590,  590,  590,  590,
 /*  9690 */   590,  590,  590,  590,  590,  590,  431,  590,  441,  590,
 /*  9700 */   590,  590,  590,  434,  329,  179,  545,  543,  546,  590,
 /*  9710 */   540,  590,  588,  590,  590,  590,  349,  609,  569,  602,
 /*  9720 */   424,  590,  590,  572,  590,  590,  590,  590,  590,  590,
 /*  9730 */   590,  590,  590,  590,  590,  590,  590,  590,  456,  590,
 /*  9740 */   590,  590,  590,  590,  590,  441,  590,  587,  313,  590,
 /*  9750 */   434,  329,  179,  545,  543,  546,  590,  540,  590,  590,
 /*  9760 */   431,  590,  590,  590,  590,  569,  590,  590,  590,  590,
 /*  9770 */   590,  590,  590,  590,  590,  590,  588,  590,  590,  590,
 /*  9780 */   349,  609,  590,  602,  424,  590,  590,  572,  270,  590,
 /*  9790 */   590,  590,  590,  590,  590,  590,  590,  587,  313,  590,
 /*  9800 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  441,
 /*  9810 */   431,  590,  590,  590,  434,  329,  179,  545,  543,  546,
 /*  9820 */   590,  540,  590,  590,  590,  590,  588,  590,  590,  569,
 /*  9830 */   349,  609,  590,  602,  424,  616,  590,  572,  590,  590,
 /*  9840 */   590,  590,  590,  590,  587,  313,  590,  590,  590,  590,
 /*  9850 */   590,  590,  590,  590,  590,  590,  590,  431,  590,  441,
 /*  9860 */   590,  590,  590,  590,  434,  329,  179,  545,  543,  546,
 /*  9870 */   590,  540,  590,  588,  590,  590,  590,  349,  609,  569,
 /*  9880 */   602,  424,  590,  590,  572,  590,  590,  590,  590,  590,
 /*  9890 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  247,
 /*  9900 */   590,  590,  590,  590,  590,  590,  441,  590,  587,  313,
 /*  9910 */   590,  434,  329,  179,  545,  543,  546,  590,  540,  590,
 /*  9920 */   590,  431,  590,  590,  590,  590,  569,  590,  590,  590,
 /*  9930 */   590,  590,  590,  590,  590,  590,  590,  588,  590,  590,
 /*  9940 */   590,  349,  609,  590,  602,  424,  590,  590,  572,  278,
 /*  9950 */   590,  590,  590,  590,  590,  590,  590,  590,  587,  313,
 /*  9960 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /*  9970 */   441,  431,  590,  590,  590,  434,  329,  179,  545,  543,
 /*  9980 */   546,  590,  540,  590,  590,  590,  590,  588,  590,  590,
 /*  9990 */   569,  349,  609,  590,  602,  424,  464,  590,  572,  590,
 /* 10000 */   590,  590,  590,  590,  590,  587,  313,  590,  590,  590,
 /* 10010 */   590,  590,  590,  590,  590,  590,  590,  590,  431,  590,
 /* 10020 */   441,  590,  590,  590,  590,  434,  329,  179,  545,  543,
 /* 10030 */   546,  590,  540,  590,  588,  590,  590,  590,  349,  609,
 /* 10040 */   569,  602,  424,  590,  590,  572,  590,  590,  590,  590,
 /* 10050 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10060 */   286,  590,  590,  590,  590,  590,  590,  441,  590,  587,
 /* 10070 */   313,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /* 10080 */   590,  590,  431,  590,  590,  590,  590,  569,  590,  590,
 /* 10090 */   590,  590,  590,  590,  590,  590,  590,  590,  588,  590,
 /* 10100 */   590,  590,  349,  609,  590,  602,  424,  590,  590,  572,
 /* 10110 */   298,  590,  590,  590,  590,  590,  590,  590,  590,  587,
 /* 10120 */   313,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10130 */   590,  441,  431,  590,  590,  590,  434,  329,  179,  545,
 /* 10140 */   543,  546,  590,  540,  590,  590,  590,  590,  588,  590,
 /* 10150 */   590,  569,  349,  609,  590,  602,  424,  308,  590,  572,
 /* 10160 */   590,  590,  590,  590,  590,  590,  587,  313,  590,  590,
 /* 10170 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  431,
 /* 10180 */   590,  441,  590,  590,  590,  590,  434,  329,  179,  545,
 /* 10190 */   543,  546,  590,  540,  590,  588,  590,  590,  590,  349,
 /* 10200 */   609,  569,  602,  424,  590,  590,  572,  590,  590,  590,
 /* 10210 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10220 */   590,  287,  590,  590,  590,  590,  590,  590,  441,  590,
 /* 10230 */   587,  313,  590,  434,  329,  179,  545,  543,  546,  590,
 /* 10240 */   540,  590,  590,  431,  590,  590,  590,  590,  569,  590,
 /* 10250 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  588,
 /* 10260 */   590,  590,  590,  349,  609,  590,  602,  424,  590,  590,
 /* 10270 */   572,  294,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10280 */   587,  313,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10290 */   590,  590,  441,  431,  590,  590,  590,  434,  329,  179,
 /* 10300 */   545,  543,  546,  590,  540,  590,  590,  590,  590,  588,
 /* 10310 */   590,  590,  569,  349,  609,  590,  602,  424,  318,  590,
 /* 10320 */   572,  590,  590,  590,  590,  590,  590,  587,  313,  590,
 /* 10330 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10340 */   431,  590,  441,  590,  590,  590,  590,  434,  329,  179,
 /* 10350 */   545,  543,  546,  590,  540,  590,  588,  590,  590,  590,
 /* 10360 */   349,  609,  569,  602,  424,  590,  590,  572,  590,  590,
 /* 10370 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10380 */   590,  590,  285,  590,  590,  590,  590,  590,  590,  441,
 /* 10390 */   590,  587,  313,  590,  434,  329,  179,  545,  543,  546,
 /* 10400 */   590,  540,  590,  590,  431,  590,  590,  590,  590,  569,
 /* 10410 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10420 */   588,  590,  590,  590,  349,  609,  590,  602,  424,  590,
 /* 10430 */   590,  572,  295,  590,  590,  590,  590,  590,  590,  590,
 /* 10440 */   590,  587,  313,  590,  590,  590,  590,  590,  590,  590,
 /* 10450 */   590,  590,  590,  441,  431,  590,  590,  590,  434,  329,
 /* 10460 */   179,  545,  543,  546,  590,  540,  590,  590,  590,  590,
 /* 10470 */   588,  590,  590,  569,  349,  609,  590,  602,  424,  289,
 /* 10480 */   590,  572,  590,  590,  590,  590,  590,  590,  587,  313,
 /* 10490 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10500 */   590,  431,  590,  441,  590,  590,  590,  590,  434,  329,
 /* 10510 */   179,  545,  543,  546,  590,  540,  590,  588,  590,  590,
 /* 10520 */   590,  349,  609,  569,  602,  424,  590,  590,  572,  590,
 /* 10530 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10540 */   590,  590,  590,  263,  590,  590,  590,  590,  590,  590,
 /* 10550 */   441,  590,  587,  313,  590,  434,  329,  179,  545,  543,
 /* 10560 */   546,  590,  540,  590,  590,  431,  590,  590,  590,  590,
 /* 10570 */   569,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10580 */   590,  588,  590,  590,  590,  349,  609,  590,  602,  424,
 /* 10590 */   590,  590,  572,  282,  590,  590,  590,  590,  590,  590,
 /* 10600 */   590,  590,  587,  313,  590,  590,  590,  590,  590,  590,
 /* 10610 */   590,  590,  590,  590,  441,  431,  590,  590,  590,  434,
 /* 10620 */   329,  179,  545,  543,  546,  590,  540,  590,  590,  590,
 /* 10630 */   590,  588,  590,  590,  569,  349,  609,  590,  602,  424,
 /* 10640 */   580,  590,  572,  590,  590,  590,  590,  590,  590,  587,
 /* 10650 */   313,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10660 */   590,  590,  431,  590,  441,  590,  590,  590,  590,  434,
 /* 10670 */   329,  179,  545,  543,  546,  590,  540,  590,  588,  590,
 /* 10680 */   590,  590,  349,  609,  569,  602,  424,  590,  590,  572,
 /* 10690 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10700 */   590,  590,  590,  590,  300,  590,  590,  590,  590,  590,
 /* 10710 */   590,  441,  590,  587,  313,  590,  434,  329,  179,  545,
 /* 10720 */   543,  546,  590,  540,  590,  590,  431,  590,  590,  590,
 /* 10730 */   590,  569,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10740 */   590,  590,  588,  590,  590,  590,  349,  609,  590,  602,
 /* 10750 */   424,  590,  590,  572,  264,  590,  590,  590,  590,  590,
 /* 10760 */   590,  590,  590,  587,  313,  590,  590,  590,  590,  590,
 /* 10770 */   590,  590,  590,  590,  590,  441,  431,  590,  590,  590,
 /* 10780 */   434,  329,  179,  545,  543,  546,  590,  540,  590,  590,
 /* 10790 */   590,  590,  588,  590,  590,  569,  349,  609,  590,  602,
 /* 10800 */   424,  254,  590,  572,  590,  590,  590,  590,  590,  590,
 /* 10810 */   587,  313,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10820 */   590,  590,  590,  431,  590,  441,  590,  590,  590,  590,
 /* 10830 */   434,  329,  179,  545,  543,  546,  590,  540,  590,  588,
 /* 10840 */   590,  590,  590,  349,  609,  569,  602,  424,  590,  590,
 /* 10850 */   572,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 10860 */   590,  590,  590,  590,  590,  274,  590,  590,  590,  590,
 /* 10870 */   590,  590,  441,  590,  587,  313,  590,  434,  329,  179,
 /* 10880 */   545,  543,  546,  590,  540,  590,  590,  431,  590,  590,
 /* 10890 */   590,  590,  569,  590,  590,  590,  590,  590,  590,  590,
 /* 10900 */   590,  590,  590,  588,  590,  590,  590,  349,  609,  590,
 /* 10910 */   602,  424,  590,  590,  572,  320,  590,  590,  590,  590,
 /* 10920 */   590,  590,  590,  590,  587,  313,  590,  590,  590,  590,
 /* 10930 */   590,  590,  590,  590,  590,  590,  441,  431,  590,  590,
 /* 10940 */   590,  434,  329,  179,  545,  543,  546,  590,  540,  590,
 /* 10950 */   590,  590,  590,  588,  590,  590,  569,  349,  609,  590,
 /* 10960 */   602,  424,  272,  590,  572,  590,  590,  590,  590,  590,
 /* 10970 */   590,  587,  313,  590,  590,  590,  590,  590,  590,  590,
 /* 10980 */   590,  590,  590,  590,  431,  590,  441,  590,  590,  590,
 /* 10990 */   590,  434,  329,  179,  545,  543,  546,  590,  540,  590,
 /* 11000 */   588,  590,  590,  590,  349,  609,  569,  602,  424,  590,
 /* 11010 */   590,  572,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 11020 */   590,  590,  590,  590,  590,  590,  268,  590,  590,  590,
 /* 11030 */   590,  590,  590,  441,  590,  587,  313,  590,  434,  329,
 /* 11040 */   179,  545,  543,  546,  590,  540,  590,  590,  431,  590,
 /* 11050 */   590,  590,  590,  569,  590,  590,  590,  590,  590,  590,
 /* 11060 */   590,  590,  590,  590,  588,  590,  590,  590,  349,  609,
 /* 11070 */   590,  602,  424,  590,  590,  572,  323,  590,  590,  590,
 /* 11080 */   590,  590,  590,  590,  590,  587,  313,  590,  590,  590,
 /* 11090 */   590,  590,  590,  590,  590,  590,  590,  441,  431,  590,
 /* 11100 */   590,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /* 11110 */   590,  590,  590,  590,  588,  590,  590,  569,  349,  609,
 /* 11120 */   590,  602,  424,  297,  590,  572,  590,  590,  590,  590,
 /* 11130 */   590,  590,  587,  313,  590,  590,  590,  590,  590,  590,
 /* 11140 */   590,  590,  590,  590,  590,  431,  590,  441,  590,  590,
 /* 11150 */   590,  590,  434,  329,  179,  545,  543,  546,  590,  540,
 /* 11160 */   590,  588,  590,  590,  590,  349,  609,  569,  602,  424,
 /* 11170 */   590,  590,  572,  590,  590,  590,  590,  590,  590,  590,
 /* 11180 */   590,  590,  590,  590,  590,  590,  590,  291,  590,  590,
 /* 11190 */   590,  590,  590,  590,  441,  590,  587,  313,  590,  434,
 /* 11200 */   329,  179,  545,  543,  546,  590,  540,  590,  590,  431,
 /* 11210 */   590,  590,  590,  590,  569,  590,  590,  590,  590,  590,
 /* 11220 */   590,  590,  590,  590,  590,  588,  590,  590,  590,  349,
 /* 11230 */   609,  590,  602,  424,  590,  590,  572,  468,  590,  590,
 /* 11240 */   590,  590,  590,  590,  590,  590,  587,  313,  590,  590,
 /* 11250 */   590,  590,  590,  590,  590,  590,  590,  590,  441,  431,
 /* 11260 */   590,  590,  590,  434,  329,  179,  545,  543,  546,  590,
 /* 11270 */   540,  590,  590,  590,  590,  588,  590,  590,  569,  349,
 /* 11280 */   609,  590,  602,  424,  271,  590,  572,  590,  590,  590,
 /* 11290 */   590,  590,  590,  587,  313,  590,  590,  590,  590,  590,
 /* 11300 */   590,  590,  590,  590,  590,  590,  431,  590,  441,  590,
 /* 11310 */   590,  590,  590,  434,  329,  179,  545,  543,  546,  590,
 /* 11320 */   540,  590,  588,  590,  590,  590,  349,  609,  569,  602,
 /* 11330 */   424,  590,  590,  572,  590,  590,  590,  590,  590,  590,
 /* 11340 */   590,  590,  590,  590,  590,  590,  590,  590,  319,  590,
 /* 11350 */   590,  590,  590,  590,  590,  441,  590,  587,  313,  590,
 /* 11360 */   434,  329,  179,  545,  543,  546,  590,  540,  590,  590,
 /* 11370 */   431,  590,  590,  590,  590,  569,  590,  590,  590,  590,
 /* 11380 */   590,  590,  590,  590,  590,  590,  588,  590,  590,  590,
 /* 11390 */   349,  609,  590,  602,  424,  590,  590,  572,  280,  590,
 /* 11400 */   590,  590,  590,  590,  590,  590,  590,  376,  311,  590,
 /* 11410 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  441,
 /* 11420 */   431,  590,  590,  590,  434,  329,  179,  545,  543,  546,
 /* 11430 */   590,  540,  590,  590,  590,  590,  588,  590,  590,  569,
 /* 11440 */   349,  609,  590,  602,  424,  590,  590,  572,  590,  590,
 /* 11450 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
 /* 11460 */   590,  590,  590,  590,  590,  590,  590,  590,  590,  441,
 /* 11470 */   590,  590,  590,  590,  434,  329,  179,  545,  543,  546,
 /* 11480 */   590,  540,  590,  590,  590,  590,  590,  590,  590,  569,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,    2,    3,    4,    5,  120,  121,  122,   23,   10,
 /*    10 */    25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
 /*    20 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*    30 */    45,  223,   47,  143,  144,  227,  228,  229,   95,   40,
 /*    40 */    41,   98,  234,  235,  236,   46,  103,   48,   49,   50,
 /*    50 */    51,   52,   53,   54,   55,   56,   57,   58,   98,   60,
 /*    60 */    61,  227,  228,  229,   65,   66,   67,  124,  234,   73,
 /*    70 */    71,   72,   95,   74,   75,   76,   77,   78,   79,   80,
 /*    80 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*    90 */    29,   92,   93,  228,   95,   96,   97,   98,   99,  234,
 /*   100 */   101,  124,  103,  104,  105,  106,  107,  108,  109,  110,
 /*   110 */   111,  112,  113,  114,   59,    1,    2,    3,    4,    5,
 /*   120 */   120,  121,  122,  124,   10,   40,   41,   42,   43,   44,
 /*   130 */    45,   73,   47,  134,  162,  136,  137,  138,  139,  140,
 /*   140 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*   150 */    44,   45,   95,   47,   40,   41,   95,  200,  201,  202,
 /*   160 */    46,  204,   48,   49,   50,   51,   52,   53,   54,   55,
 /*   170 */    56,   57,   58,   11,   60,   61,  227,  228,  229,   65,
 /*   180 */    66,   67,  127,  234,  212,   71,   72,   95,   74,   75,
 /*   190 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   200 */    86,   87,   88,   89,   90,   72,   92,   93,  181,   95,
 /*   210 */    96,   97,   98,   99,  116,  101,  124,  103,  104,  105,
 /*   220 */   106,  107,  108,  109,  110,  111,  112,  113,  114,    6,
 /*   230 */     1,    2,    3,    4,    5,  208,  209,   24,  124,   10,
 /*   240 */    65,   66,   67,   68,   69,   70,   76,   98,  134,  116,
 /*   250 */   136,  137,  138,  139,  140,  106,  107,  108,  109,  110,
 /*   260 */   111,  112,  113,  114,   43,   44,   45,   60,   47,   40,
 /*   270 */    41,  181,   97,   49,   50,   46,   74,   48,   49,   50,
 /*   280 */    51,   52,   53,   54,   55,   56,   57,   58,   75,   60,
 /*   290 */    61,  121,  122,   74,   65,   66,   67,   74,  208,  209,
 /*   300 */    71,   72,   95,   74,   75,   98,   77,   78,   79,   80,
 /*   310 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   320 */    74,   92,   93,  228,   95,   96,   97,   98,   99,  234,
 /*   330 */   101,  124,  103,  104,  105,  106,  107,  108,  109,  110,
 /*   340 */   111,  112,  113,  114,   59,  200,  201,  202,  119,  204,
 /*   350 */   200,  201,  202,  124,  204,    1,    2,    3,    4,    5,
 /*   360 */    75,   29,   75,  134,   10,  136,  137,  138,  139,  140,
 /*   370 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*   380 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*   390 */    95,   47,   72,   98,   40,   41,  109,  200,  201,  202,
 /*   400 */    46,  204,   48,   49,   50,   51,   52,   53,   54,   55,
 /*   410 */    56,   57,   58,   73,   60,   61,  174,  175,  176,   65,
 /*   420 */    66,   67,   62,   63,  129,   71,   72,   95,   74,   75,
 /*   430 */    98,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   440 */    86,   87,   88,   89,   90,   72,   92,   93,    6,   95,
 /*   450 */    96,   97,   98,   99,   73,  101,  124,  103,  104,  105,
 /*   460 */   106,  107,  108,  109,  110,  111,  112,  113,  114,   59,
 /*   470 */   213,  214,  118,  216,  217,    6,  219,  220,  124,   98,
 /*   480 */     1,    2,    3,    4,    5,   75,    6,  106,  134,   10,
 /*   490 */   136,  137,  138,  139,  140,   27,   28,   29,   30,   31,
 /*   500 */    32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
 /*   510 */    42,   43,   44,   45,   95,   47,   74,   98,   47,   40,
 /*   520 */    41,    6,  200,  201,  202,   46,  204,   48,   49,   50,
 /*   530 */    51,   52,   53,   54,   55,   56,   57,   58,   72,   60,
 /*   540 */    61,  228,   73,  124,   65,   66,   67,  234,   74,   75,
 /*   550 */    71,   72,   72,   74,   75,   76,   77,   78,   79,   80,
 /*   560 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   570 */    11,   92,   93,    6,   95,   96,   97,   98,   99,  173,
 /*   580 */   101,   24,  103,  104,  105,  106,  107,  108,  109,  110,
 /*   590 */   111,  112,  113,  114,  188,    1,    2,    3,    4,    5,
 /*   600 */    74,   29,   95,  124,   10,  200,  201,  202,  203,  204,
 /*   610 */   205,   76,   95,  134,   24,  136,  137,  138,  139,  140,
 /*   620 */   200,  201,  202,   72,  204,  116,  223,    6,   72,    6,
 /*   630 */   227,  228,  229,   95,   40,   41,   98,  234,  235,  236,
 /*   640 */    46,   74,   48,   49,   50,   51,   52,   53,   54,   55,
 /*   650 */    56,   57,   58,   74,   60,   61,  121,  122,    6,   65,
 /*   660 */    66,   67,  124,    6,   74,   71,   72,   95,   74,   75,
 /*   670 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   680 */    86,   87,   88,   89,   90,   98,   92,   93,   95,   95,
 /*   690 */    96,   97,   98,   99,   73,  101,   73,  103,  104,  105,
 /*   700 */   106,  107,  108,  109,  110,  111,  112,  113,  114,    6,
 /*   710 */     1,    2,    3,    4,    5,   62,   63,  124,  124,   10,
 /*   720 */    75,  173,   75,  200,  201,  202,   74,  204,  134,   98,
 /*   730 */   136,  137,  138,  139,  140,  223,  188,  106,   72,  227,
 /*   740 */   228,  229,   95,   97,   72,   98,  234,  235,  236,   40,
 /*   750 */    41,   76,  200,  201,  202,   46,  204,   48,   49,   50,
 /*   760 */    51,   52,   53,   54,   55,   56,   57,   58,   98,   60,
 /*   770 */    61,  124,  116,   73,   65,   66,   67,   74,  127,  115,
 /*   780 */    71,   72,   95,   74,   75,   98,   77,   78,   79,   80,
 /*   790 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   800 */    98,   92,   93,   72,   95,   96,   97,   98,   99,  115,
 /*   810 */   101,  124,  103,  104,  105,  106,  107,  108,  109,  110,
 /*   820 */   111,  112,  113,  114,   72,    1,    2,    3,    4,    5,
 /*   830 */    72,  109,  123,  124,   10,  200,  201,  202,   11,  204,
 /*   840 */   200,  201,  202,  134,  204,  136,  137,  138,  139,  140,
 /*   850 */   223,    6,   73,   72,  227,  228,  229,   95,   74,   98,
 /*   860 */    98,  234,  235,  236,   40,   41,   98,  200,  201,  202,
 /*   870 */    46,  204,   48,   49,   50,   51,   52,   53,   54,   55,
 /*   880 */    56,   57,   58,  128,   60,   61,  124,   75,   73,   65,
 /*   890 */    66,   67,    6,   73,   76,   71,   72,   98,   74,   75,
 /*   900 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   910 */    86,   87,   88,   89,   90,   99,   92,   93,   73,   95,
 /*   920 */    96,   97,   98,   99,   72,  101,   64,  103,  104,  105,
 /*   930 */   106,  107,  108,  109,  110,  111,  112,  113,  114,   74,
 /*   940 */     1,    2,    3,    4,    5,   74,   73,   72,  124,   10,
 /*   950 */   116,   95,   75,  200,  201,  202,   11,  204,  134,   73,
 /*   960 */   136,  137,  138,  139,  140,  200,  201,  202,   73,  204,
 /*   970 */    91,  116,   95,   95,    6,   98,   98,   59,   73,   40,
 /*   980 */    41,   73,  200,  201,  202,   46,  204,   48,   49,   50,
 /*   990 */    51,   52,   53,   54,   55,   56,   57,   58,    6,   60,
 /*  1000 */    61,  124,  124,   74,   65,   66,   67,   73,  128,   24,
 /*  1010 */    71,   72,   75,   74,   75,   74,   77,   78,   79,   80,
 /*  1020 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  1030 */    74,   92,   93,   11,   95,   96,   97,   98,   99,   11,
 /*  1040 */   101,   73,  103,  104,  105,  106,  107,  108,  109,  110,
 /*  1050 */   111,  112,  113,  114,   94,   72,  117,   75,    1,    2,
 /*  1060 */     3,    4,    5,  124,  200,  201,  202,   10,  204,   95,
 /*  1070 */    59,   59,   75,  134,   98,  136,  137,  138,  139,  140,
 /*  1080 */    73,   72,   72,   72,   72,   11,   75,   75,   73,   73,
 /*  1090 */    72,   78,   75,   72,   74,   72,   72,   40,   41,   24,
 /*  1100 */    11,   76,   75,   46,   11,   48,   49,   50,   51,   52,
 /*  1110 */    53,   54,   55,   56,   57,   58,   72,   60,   61,   11,
 /*  1120 */    74,   73,   65,   66,   67,   73,   72,   72,   71,   72,
 /*  1130 */    98,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*  1140 */    83,   84,   85,   86,   87,   88,   89,   90,   11,   92,
 /*  1150 */    93,   72,   95,   96,   97,   98,   99,  127,  101,   72,
 /*  1160 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  1170 */   113,  114,   99,    1,    2,    3,    4,    5,   11,   73,
 /*  1180 */    95,  124,   10,    6,   11,   74,   72,  239,   94,   98,
 /*  1190 */     6,  134,  192,  136,  137,  138,  139,  140,  100,  224,
 /*  1200 */   171,   72,   72,  163,  173,   95,  187,  206,  173,  176,
 /*  1210 */    98,  173,   40,   41,  150,  150,  150,  150,   46,  150,
 /*  1220 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  1230 */    58,  192,   60,   61,  150,  199,  150,   65,   66,   67,
 /*  1240 */   206,  199,  150,   71,   72,  150,   74,   75,  152,   77,
 /*  1250 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1260 */    88,   89,   90,  150,   92,   93,  150,   95,   96,   97,
 /*  1270 */    98,   99,  150,  101,  150,  103,  104,  105,  106,  107,
 /*  1280 */   108,  109,  110,  111,  112,  113,  114,  244,    1,    2,
 /*  1290 */     3,    4,    5,   74,  185,  155,  124,   10,  199,  153,
 /*  1300 */   159,  165,  226,  100,  207,  173,  134,   29,  136,  137,
 /*  1310 */   138,  139,  140,  209,  212,  180,  183,  240,  218,  115,
 /*  1320 */   168,  220,  207,  127,  127,  245,  195,   40,   41,  224,
 /*  1330 */    72,   74,  184,   46,  102,   48,   49,   50,   51,   52,
 /*  1340 */    53,   54,   55,   56,   57,   58,  180,   60,   61,  206,
 /*  1350 */    95,  168,   65,   66,   67,  206,  199,  215,   71,   72,
 /*  1360 */   185,   74,   75,  128,   77,   78,   79,   80,   81,   82,
 /*  1370 */    83,   84,   85,   86,   87,   88,   89,   90,  150,   92,
 /*  1380 */    93,  225,   95,   96,   97,   98,   99,   72,  101,    6,
 /*  1390 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  1400 */   113,  114,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  1410 */   247,  124,  247,    1,    2,    3,    4,    5,  247,  247,
 /*  1420 */   247,  134,   10,  136,  137,  138,  139,  140,  247,  247,
 /*  1430 */   247,  247,  247,  247,  247,  247,   24,   11,   12,   13,
 /*  1440 */    14,   15,   16,   17,   18,   19,   20,   21,   22,  247,
 /*  1450 */   247,  247,   40,   41,  247,  247,  247,  247,   46,  247,
 /*  1460 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  1470 */    58,  247,   60,   61,  247,   49,   50,   65,  247,  247,
 /*  1480 */   247,  247,  247,  247,   72,  247,   74,   75,  247,   77,
 /*  1490 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1500 */    88,   89,   90,  247,   92,   93,  247,   95,   96,  173,
 /*  1510 */    98,  247,  247,  247,  247,  103,  104,  105,  106,  107,
 /*  1520 */   108,  109,  110,  111,  112,  113,  114,  191,  247,  247,
 /*  1530 */   247,  247,  247,  247,  247,  247,  124,  247,    1,    2,
 /*  1540 */     3,    4,    5,  247,  247,  247,  134,   10,  136,  137,
 /*  1550 */   138,  139,  140,  247,  247,  247,  247,  247,  247,  247,
 /*  1560 */   247,   24,  247,  247,  228,  229,  230,  231,  247,  247,
 /*  1570 */   234,  247,  247,  247,  247,  247,  247,   40,   41,  243,
 /*  1580 */   247,  247,  247,   46,  247,   48,   49,   50,   51,   52,
 /*  1590 */    53,   54,   55,   56,   57,   58,  247,   60,   61,  247,
 /*  1600 */   247,  247,   65,  247,  247,  247,  247,  247,  247,   72,
 /*  1610 */   247,   74,   75,  247,   77,   78,   79,   80,   81,   82,
 /*  1620 */    83,   84,   85,   86,   87,   88,   89,   90,  247,   92,
 /*  1630 */    93,  247,   95,   96,  173,   98,  247,  247,  247,  247,
 /*  1640 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  1650 */   113,  114,  191,  247,  247,  247,  247,  247,  247,  247,
 /*  1660 */   247,  124,  247,    1,    2,    3,    4,    5,  247,  247,
 /*  1670 */   247,  134,   10,  136,  137,  138,  139,  140,  247,  247,
 /*  1680 */   247,  247,  247,  247,  247,  247,   24,  247,  247,  228,
 /*  1690 */   229,  230,  231,  247,  247,  234,  247,  247,  247,  247,
 /*  1700 */   247,  247,   40,   41,  243,  247,  247,  247,   46,  247,
 /*  1710 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  1720 */    58,  247,   60,   61,  247,  247,  247,   65,  247,  247,
 /*  1730 */   247,  247,  247,  247,   72,  247,   74,   75,  247,   77,
 /*  1740 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1750 */    88,   89,   90,  247,   92,   93,  247,   95,   96,  173,
 /*  1760 */    98,  247,  247,  247,  247,  103,  104,  105,  106,  107,
 /*  1770 */   108,  109,  110,  111,  112,  113,  114,  191,  247,  247,
 /*  1780 */   247,  247,  247,  247,  247,  247,  124,  247,    1,    2,
 /*  1790 */     3,    4,    5,  247,  247,  247,  134,   10,  136,  137,
 /*  1800 */   138,  139,  140,  247,  247,  247,  247,  247,  247,  247,
 /*  1810 */   247,   24,  247,  247,  228,  229,  230,  231,  247,  247,
 /*  1820 */   234,  247,  247,  247,  247,  247,  247,   40,   41,  243,
 /*  1830 */   247,  247,  247,   46,  247,   48,   49,   50,   51,   52,
 /*  1840 */    53,   54,   55,   56,   57,   58,  247,   60,   61,  247,
 /*  1850 */   247,  247,   65,  247,  247,  247,  247,  247,  247,   72,
 /*  1860 */   247,   74,   75,  247,   77,   78,   79,   80,   81,   82,
 /*  1870 */    83,   84,   85,   86,   87,   88,   89,   90,  247,   92,
 /*  1880 */    93,  247,   95,   96,  247,   98,  247,  247,  247,  247,
 /*  1890 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  1900 */   113,  114,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  1910 */   247,  124,  247,    1,    2,    3,    4,    5,  247,  247,
 /*  1920 */   247,  134,   10,  136,  137,  138,  139,  140,  247,  247,
 /*  1930 */   247,  247,  247,  247,  247,  247,   24,  247,  247,  247,
 /*  1940 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  1950 */   247,  247,   40,   41,  247,  247,  247,  247,   46,  247,
 /*  1960 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  1970 */    58,  247,   60,   61,  247,  247,  247,   65,  247,  247,
 /*  1980 */   247,  247,  247,  247,   72,  247,   74,   75,  247,   77,
 /*  1990 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  2000 */    88,   89,   90,  247,   92,   93,  247,   95,   96,  247,
 /*  2010 */    98,  247,  247,  247,  247,  103,  104,  105,  106,  107,
 /*  2020 */   108,  109,  110,  111,  112,  113,  114,  247,    1,    2,
 /*  2030 */     3,    4,    5,  247,  247,  247,  124,   10,  247,  247,
 /*  2040 */   247,  247,  247,  247,  247,  247,  134,  247,  136,  137,
 /*  2050 */   138,  139,  140,  247,  247,  247,  247,  247,  247,  247,
 /*  2060 */   247,  247,  247,  247,  247,  247,  247,   40,   41,  247,
 /*  2070 */   247,  247,  247,   46,  247,   48,   49,   50,   51,   52,
 /*  2080 */    53,   54,   55,   56,   57,   58,  247,   60,   61,  247,
 /*  2090 */   247,  247,   65,  247,  247,  247,  247,  247,  247,   72,
 /*  2100 */   247,   74,   75,  247,   77,   78,   79,   80,   81,   82,
 /*  2110 */    83,   84,   85,   86,   87,   88,   89,   90,  247,   92,
 /*  2120 */    93,  247,   95,   96,  247,   98,  247,  247,  247,  247,
 /*  2130 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  2140 */   113,  114,  247,    1,    2,    3,    4,    5,  247,  247,
 /*  2150 */   247,  124,   10,  247,  247,  247,  247,  247,  247,  247,
 /*  2160 */   247,  134,  247,  136,  137,  138,  139,  140,  247,  247,
 /*  2170 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  2180 */   247,  247,   40,   41,  247,  247,  247,  247,   46,  247,
 /*  2190 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  2200 */    58,  247,   60,   61,   65,   66,   67,   68,   69,   70,
 /*  2210 */   247,  247,  247,  247,   72,   76,   74,   28,   29,   30,
 /*  2220 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*  2230 */    41,   42,   43,   44,   45,  247,   47,   95,  247,  247,
 /*  2240 */    98,  247,  247,  247,  247,  103,  104,  105,  106,  107,
 /*  2250 */   108,  109,  110,  111,  112,  113,  114,  247,    1,    2,
 /*  2260 */     3,    4,    5,  247,  125,  126,  124,   10,  247,  247,
 /*  2270 */   247,  247,  247,  247,  247,  247,  134,  247,  136,  137,
 /*  2280 */   138,  139,  140,  247,  247,  247,   29,  247,  247,  247,
 /*  2290 */   247,  247,  247,  247,  247,  247,  247,   40,   41,  247,
 /*  2300 */   247,  247,  247,   46,  247,   48,   49,   50,   51,   52,
 /*  2310 */    53,   54,   55,   56,   57,   58,  247,   60,   61,   65,
 /*  2320 */    66,   67,   68,   69,   70,  247,  247,  247,  247,   72,
 /*  2330 */    76,   25,   26,   27,   28,   29,   30,   31,   32,   33,
 /*  2340 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  2350 */    44,   45,   95,   47,  247,   98,  247,  247,  247,  247,
 /*  2360 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  2370 */   113,  114,  247,    1,    2,    3,    4,    5,  247,  125,
 /*  2380 */   126,  124,   10,  247,  247,  247,  247,  247,  247,  247,
 /*  2390 */   247,  134,  247,  136,  137,  138,  139,  140,  247,  247,
 /*  2400 */   247,   29,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  2410 */   247,  247,   40,   41,  247,  247,  247,  247,   46,  247,
 /*  2420 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  2430 */    58,  247,   60,   61,  247,  247,  247,  247,  247,  247,
 /*  2440 */   247,  247,  247,  247,   72,  247,  247,  247,   29,   30,
 /*  2450 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*  2460 */    41,   42,   43,   44,   45,  247,   47,   95,  247,  247,
 /*  2470 */    98,  247,  247,  247,  247,  103,  104,  105,  106,  107,
 /*  2480 */   108,  109,  110,  111,  112,  113,  114,  247,    1,    2,
 /*  2490 */     3,    4,    5,  247,  247,  247,  124,   10,  247,  247,
 /*  2500 */   247,  247,  247,  247,  247,  247,  134,  247,  136,  137,
 /*  2510 */   138,  139,  140,  247,  247,  247,   29,  247,  247,  247,
 /*  2520 */   247,  247,  247,  247,  247,  247,  247,   40,   41,  247,
 /*  2530 */   247,  247,  247,   46,  247,   48,   49,   50,   51,   52,
 /*  2540 */    53,   54,   55,   56,   57,   58,  247,   60,   61,  247,
 /*  2550 */   247,  247,  247,  247,  247,  247,  247,  247,  247,   72,
 /*  2560 */   247,  247,  247,  247,   30,   31,   32,   33,   34,   35,
 /*  2570 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  2580 */   247,   47,   95,  247,  247,   98,  247,  247,  247,  247,
 /*  2590 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  2600 */   113,  114,  247,    1,    2,    3,    4,    5,  247,  247,
 /*  2610 */   161,  124,   10,  247,  247,  166,  247,  247,  247,  247,
 /*  2620 */   247,  134,  173,  136,  137,  138,  139,  140,  247,  247,
 /*  2630 */   247,   29,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  2640 */   247,  247,   40,   41,  247,  247,  247,  247,   46,  247,
 /*  2650 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  2660 */    58,  247,   60,   61,  247,  247,  247,  247,  247,  247,
 /*  2670 */   221,  222,  247,  247,   72,  247,  227,  228,  229,  230,
 /*  2680 */   231,  232,  247,  234,  247,  247,  247,  247,  247,  247,
 /*  2690 */   247,  247,  247,  247,  247,  247,  247,   95,  247,  247,
 /*  2700 */    98,  247,  247,  247,  247,  103,  104,  105,  106,  107,
 /*  2710 */   108,  109,  110,  111,  112,  113,  114,  247,    1,    2,
 /*  2720 */     3,    4,    5,  247,  247,  247,  124,   10,  247,  247,
 /*  2730 */   247,  247,  247,  247,  247,  247,  134,  161,  136,  137,
 /*  2740 */   138,  139,  140,  167,  247,  247,  170,  247,  247,  173,
 /*  2750 */   247,  247,  247,  247,  247,  247,  247,   40,   41,  247,
 /*  2760 */   247,  247,  247,   46,  247,   48,   49,   50,   51,   52,
 /*  2770 */    53,   54,   55,   56,   57,   58,  247,   60,   61,  247,
 /*  2780 */   247,  247,  247,  247,  247,  247,  247,  247,  247,   72,
 /*  2790 */   247,   74,  247,  247,  247,  247,  247,  247,  222,  247,
 /*  2800 */   247,  247,  247,  227,  228,  229,  230,  231,  232,  247,
 /*  2810 */   234,  247,   95,  247,  247,   98,  247,  247,  247,  247,
 /*  2820 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  2830 */   113,  114,  247,    1,    2,    3,    4,    5,  247,  247,
 /*  2840 */   247,  124,   10,  247,  247,  247,  247,  247,  247,  247,
 /*  2850 */   247,  134,  247,  136,  137,  138,  139,  140,  247,  247,
 /*  2860 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  2870 */   247,  247,   40,   41,  247,  247,  247,  247,   46,  247,
 /*  2880 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  2890 */    58,  247,   60,   61,  247,  247,  247,  247,  247,  247,
 /*  2900 */   247,  247,  247,  247,   72,  247,   74,  247,  247,  247,
 /*  2910 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  2920 */   247,  247,  247,  247,  247,  247,  247,   95,  247,  247,
 /*  2930 */    98,  247,  247,  247,  247,  103,  104,  105,  106,  107,
 /*  2940 */   108,  109,  110,  111,  112,  113,  114,  247,    1,    2,
 /*  2950 */     3,    4,    5,  247,  247,  247,  124,   10,  247,  247,
 /*  2960 */   247,  247,  247,  247,  247,  161,  134,  247,  136,  137,
 /*  2970 */   138,  139,  140,  247,  247,  247,   29,  173,  247,  247,
 /*  2980 */   247,  247,  247,  247,  247,  247,  247,   40,   41,  247,
 /*  2990 */   247,  247,  247,   46,  190,   48,   49,   50,   51,   52,
 /*  3000 */    53,   54,   55,   56,   57,   58,  247,   60,   61,  247,
 /*  3010 */   247,  247,  247,  247,  247,  247,  247,  247,  247,   72,
 /*  3020 */   247,  247,  247,  247,  247,  247,  222,  247,  247,  247,
 /*  3030 */   247,  227,  228,  229,  230,  231,  232,  247,  234,  247,
 /*  3040 */   247,  237,   95,  247,  247,   98,  247,  247,  247,  247,
 /*  3050 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  3060 */   113,  114,  247,    1,    2,    3,    4,    5,  247,  247,
 /*  3070 */   247,  124,   10,  247,  247,  247,  247,  247,  247,  247,
 /*  3080 */   247,  134,  247,  136,  137,  138,  139,  140,  247,  247,
 /*  3090 */   247,   29,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  3100 */   247,  247,   40,   41,  247,  247,  247,  247,   46,  247,
 /*  3110 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  3120 */    58,  247,   60,   61,  247,  247,  247,  247,  247,  247,
 /*  3130 */   247,  247,  247,  247,   72,  247,  247,  247,  247,  247,
 /*  3140 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  3150 */   247,  247,  247,  247,  247,  247,  247,   95,  247,  247,
 /*  3160 */    98,  247,  247,  247,  247,  103,  104,  105,  106,  107,
 /*  3170 */   108,  109,  110,  111,  112,  113,  114,  247,    1,    2,
 /*  3180 */     3,    4,    5,  247,  247,  247,  124,   10,  247,  247,
 /*  3190 */   247,  247,  247,  161,  247,  247,  134,  247,  136,  137,
 /*  3200 */   138,  139,  140,  247,  247,  173,  247,  247,  247,  247,
 /*  3210 */   247,  247,  247,  247,  247,  247,  247,   40,   41,  247,
 /*  3220 */   247,  247,  190,   46,  247,   48,   49,   50,   51,   52,
 /*  3230 */    53,   54,   55,   56,   57,   58,  247,   60,   61,  247,
 /*  3240 */   247,  247,  247,  247,  247,  247,  247,  247,  247,   72,
 /*  3250 */    73,  247,  247,  247,  222,  247,  247,  247,  247,  227,
 /*  3260 */   228,  229,  230,  231,  232,  247,  234,  247,  247,  237,
 /*  3270 */   247,  247,   95,  247,  247,   98,  247,  247,  247,  247,
 /*  3280 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  3290 */   113,  114,  247,    1,    2,    3,    4,    5,  247,  247,
 /*  3300 */   247,  124,   10,  247,  247,  247,  247,  247,  247,  247,
 /*  3310 */   247,  134,  247,  136,  137,  138,  139,  140,  247,  247,
 /*  3320 */   247,   29,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  3330 */   247,  247,   40,   41,  247,  247,  247,  247,   46,  247,
 /*  3340 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  3350 */    58,  247,   60,   61,  247,  247,  247,  247,  247,  247,
 /*  3360 */   247,  247,  247,  247,   72,  247,  247,  247,  247,  247,
 /*  3370 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  3380 */   247,  247,  247,  247,  247,  247,  247,   95,  247,  247,
 /*  3390 */    98,  247,  247,  247,  247,  103,  104,  105,  106,  107,
 /*  3400 */   108,  109,  110,  111,  112,  113,  114,  247,    1,    2,
 /*  3410 */     3,    4,    5,  247,  247,  247,  124,   10,  247,  247,
 /*  3420 */   247,  161,  247,  247,  247,  247,  134,  247,  136,  137,
 /*  3430 */   138,  139,  140,  173,  247,  247,  247,  247,  247,  247,
 /*  3440 */   247,  247,  247,  247,  247,  247,  247,   40,   41,  247,
 /*  3450 */   247,  247,  247,   46,  247,   48,   49,   50,   51,   52,
 /*  3460 */    53,   54,   55,   56,   57,   58,  247,   60,   61,  247,
 /*  3470 */   247,  247,  247,  247,  247,  247,  247,  247,  247,   72,
 /*  3480 */   247,  221,  222,  247,  247,  247,  247,  227,  228,  229,
 /*  3490 */   230,  231,  232,  247,  234,  247,  247,  247,  247,  247,
 /*  3500 */   247,  247,   95,  247,  247,   98,  247,  247,  247,  247,
 /*  3510 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  3520 */   113,  114,  247,    1,    2,    3,    4,    5,  247,  247,
 /*  3530 */   247,  124,   10,  247,  247,  247,  247,  247,  247,  247,
 /*  3540 */   247,  134,  247,  136,  137,  138,  139,  140,  247,  247,
 /*  3550 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  3560 */   247,  247,   40,   41,  247,  247,  247,  247,   46,  247,
 /*  3570 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  3580 */    58,  247,   60,   61,  247,  247,  247,  247,  247,  247,
 /*  3590 */   247,  247,  247,  247,   72,  247,  247,  247,  247,  247,
 /*  3600 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  3610 */   247,  247,  247,  247,  247,  247,  247,   95,  247,  247,
 /*  3620 */    98,  247,  247,  247,  247,  103,  104,  105,  106,  107,
 /*  3630 */   108,  109,  110,  111,  112,  113,  114,  247,  247,  247,
 /*  3640 */   247,  247,  247,  247,  247,  247,  124,  247,  247,  146,
 /*  3650 */   147,  148,  149,  247,  151,  247,  134,  154,  136,  137,
 /*  3660 */   138,  139,  140,  160,  161,  247,  247,  247,  247,  247,
 /*  3670 */   247,  247,  247,  247,  247,  247,  173,  247,  247,  247,
 /*  3680 */   177,  178,  179,  247,  247,  182,  247,  247,  247,  186,
 /*  3690 */    59,  247,  189,  247,  247,  247,  193,  194,  247,  196,
 /*  3700 */   197,  247,  247,  200,    6,  247,   75,   76,  247,   11,
 /*  3710 */    12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
 /*  3720 */    22,  247,  247,  247,  247,  222,   95,  247,  247,   98,
 /*  3730 */   227,  228,  229,  230,  231,  232,  105,  234,  247,  247,
 /*  3740 */   247,  146,  147,  148,  149,  242,  151,   49,   50,  247,
 /*  3750 */   247,  247,  247,  247,  247,  160,  161,  247,  127,  128,
 /*  3760 */   129,  130,  131,  132,  133,  247,  135,  247,  173,  247,
 /*  3770 */   247,   73,  177,  178,  179,  247,  247,  182,  247,  247,
 /*  3780 */   247,  186,  247,  247,  189,  247,  247,  247,  193,  194,
 /*  3790 */   247,  196,  197,  247,  247,  200,   11,   12,   13,   14,
 /*  3800 */    15,   16,   17,   18,   19,   20,   21,   22,  247,  247,
 /*  3810 */   247,  247,  247,  247,  247,  247,  247,  222,  247,  247,
 /*  3820 */   247,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /*  3830 */     7,    8,    9,  247,   49,   50,  247,  242,  247,  247,
 /*  3840 */   247,  247,  247,  247,  247,  247,   23,   24,   25,   26,
 /*  3850 */    27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
 /*  3860 */    37,   38,   39,   40,   41,   42,   43,   44,   45,  247,
 /*  3870 */    47,  145,  146,  147,  148,  149,   91,  151,  247,  247,
 /*  3880 */   247,  247,  247,  247,  247,  247,  160,  161,  247,  247,
 /*  3890 */   247,  247,  247,  247,  247,  247,  247,   74,  247,  173,
 /*  3900 */   247,  247,  247,  247,  178,  179,  247,  247,  182,  247,
 /*  3910 */   247,  247,  186,  247,  247,  189,  247,  247,  247,  193,
 /*  3920 */   194,  247,  196,  197,  146,  247,  200,  149,  247,  151,
 /*  3930 */   247,  247,  247,  247,  247,  247,  247,  247,  160,  161,
 /*  3940 */   247,  247,  247,  247,  247,  247,  247,  247,  222,  247,
 /*  3950 */   172,  173,  247,  227,  228,  229,  230,  231,  232,  247,
 /*  3960 */   234,    7,    8,    9,  247,  247,  247,  189,  242,  247,
 /*  3970 */   247,  193,  194,  247,  196,  197,  247,   23,  200,   25,
 /*  3980 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  3990 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  4000 */   222,   47,  247,  247,  247,  227,  228,  229,  230,  231,
 /*  4010 */   232,  247,  234,  247,  247,  247,  247,  247,  247,  247,
 /*  4020 */   242,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4030 */    76,  247,  247,  247,  247,  247,  247,  247,    7,    8,
 /*  4040 */     9,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4050 */   247,  247,  247,  247,   23,  247,   25,   26,   27,   28,
 /*  4060 */    29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
 /*  4070 */    39,   40,   41,   42,   43,   44,   45,  247,   47,  247,
 /*  4080 */   247,  247,  247,  247,  247,  247,  247,  247,   11,   12,
 /*  4090 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*  4100 */   247,  247,  247,  247,   73,  247,  247,  247,  247,  247,
 /*  4110 */   247,  247,    7,    8,    9,  247,  247,  247,  247,  247,
 /*  4120 */   247,  247,  247,  247,  247,  247,   49,   50,   23,  247,
 /*  4130 */    25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
 /*  4140 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*  4150 */    45,   74,   47,  247,  247,  247,  247,  247,  247,   59,
 /*  4160 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4170 */   247,  247,  247,  247,  247,   75,   76,  247,   73,  247,
 /*  4180 */   247,  247,  247,  247,  247,  247,    7,    8,    9,  247,
 /*  4190 */   247,  247,  247,  247,  247,   95,  247,  247,   98,  247,
 /*  4200 */   247,  247,   23,  247,   25,   26,   27,   28,   29,   30,
 /*  4210 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*  4220 */    41,   42,   43,   44,   45,  247,   47,  127,  128,  129,
 /*  4230 */   130,  131,  132,  133,  247,  135,   59,  247,  247,  139,
 /*  4240 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4250 */   161,  247,   75,   76,  247,   76,  167,  247,  247,  170,
 /*  4260 */   247,  247,  173,    7,    8,    9,  247,  247,  247,  247,
 /*  4270 */   247,  247,   95,  247,  247,   98,  247,  247,  247,   23,
 /*  4280 */   247,   25,   26,   27,   28,   29,   30,   31,   32,   33,
 /*  4290 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  4300 */    44,   45,  247,   47,  127,  128,  129,  130,  131,  132,
 /*  4310 */   133,  222,  135,  247,  247,  138,  227,  228,  229,  230,
 /*  4320 */   231,  232,  247,  234,  247,  247,  247,  247,  247,  247,
 /*  4330 */    74,  247,  247,  247,  247,  247,  247,  247,    7,    8,
 /*  4340 */     9,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4350 */   247,  247,  247,  247,   23,  247,   25,   26,   27,   28,
 /*  4360 */    29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
 /*  4370 */    39,   40,   41,   42,   43,   44,   45,  247,   47,  247,
 /*  4380 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4390 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4400 */   247,  247,  247,  247,  247,  247,  247,   76,  247,  247,
 /*  4410 */   247,  247,  247,  247,  247,    7,    8,    9,  247,  247,
 /*  4420 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4430 */   247,   23,  247,   25,   26,   27,   28,   29,   30,   31,
 /*  4440 */    32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
 /*  4450 */    42,   43,   44,   45,    6,   47,    7,    8,    9,   11,
 /*  4460 */    12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
 /*  4470 */    22,  247,   23,  247,   25,   26,   27,   28,   29,   30,
 /*  4480 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*  4490 */    41,   42,   43,   44,   45,  247,   47,   49,   50,  247,
 /*  4500 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4510 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4520 */   247,   73,   73,  115,  247,  247,  247,  247,  247,  247,
 /*  4530 */     7,    8,    9,  247,  247,  247,  247,  247,  247,  247,
 /*  4540 */   247,  247,  247,  247,  247,  247,   23,   24,   25,   26,
 /*  4550 */    27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
 /*  4560 */    37,   38,   39,   40,   41,   42,   43,   44,   45,  247,
 /*  4570 */    47,    7,    8,    9,  247,  247,  247,  247,  247,  247,
 /*  4580 */   247,  247,  247,  247,  247,  247,  247,   23,  247,   25,
 /*  4590 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  4600 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  4610 */   247,   47,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4620 */   247,  247,  247,  247,  161,  247,  247,  247,  247,  247,
 /*  4630 */   247,  247,  247,  170,  247,  247,  173,  247,   74,  247,
 /*  4640 */   247,  247,  247,  247,  247,  247,    7,    8,    9,  247,
 /*  4650 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4660 */   247,  247,   23,  247,   25,   26,   27,   28,   29,   30,
 /*  4670 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*  4680 */    41,   42,   43,   44,   45,  222,   47,    7,    8,    9,
 /*  4690 */   227,  228,  229,  230,  231,  232,  247,  234,  247,  247,
 /*  4700 */   247,  247,  247,   23,  247,   25,   26,   27,   28,   29,
 /*  4710 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*  4720 */    40,   41,   42,   43,   44,   45,  247,   47,  247,  247,
 /*  4730 */   247,  247,  247,  247,   59,  247,  247,  247,  247,  247,
 /*  4740 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4750 */    75,   76,  247,   73,  247,  247,  161,  247,  247,  247,
 /*  4760 */   247,    7,    8,    9,  247,  170,  247,  128,  173,  247,
 /*  4770 */    95,  247,  247,   98,  247,  247,  247,   23,  247,   25,
 /*  4780 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  4790 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  4800 */   247,   47,  127,  128,  129,  130,  131,  132,  133,  247,
 /*  4810 */   135,  247,  247,  247,  247,  247,  141,  222,  247,  247,
 /*  4820 */   247,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /*  4830 */    76,  247,  247,  161,  247,  247,  247,  247,    7,    8,
 /*  4840 */     9,  247,  170,  247,  247,  173,  247,  247,  247,  247,
 /*  4850 */   247,  247,  247,  247,   23,  247,   25,   26,   27,   28,
 /*  4860 */    29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
 /*  4870 */    39,   40,   41,   42,   43,   44,   45,  247,   47,  247,
 /*  4880 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  4890 */   247,  247,  247,  247,  222,  247,  161,  247,  247,  227,
 /*  4900 */   228,  229,  230,  231,  232,   74,  234,  247,  173,  247,
 /*  4910 */   247,  247,  247,    7,    8,    9,  247,  247,  247,  247,
 /*  4920 */   247,  247,  247,  247,  247,  247,  247,  247,  247,   23,
 /*  4930 */   247,   25,   26,   27,   28,   29,   30,   31,   32,   33,
 /*  4940 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  4950 */    44,   45,  247,   47,  247,  247,  247,  222,  247,  247,
 /*  4960 */   247,  247,  227,  228,  229,  230,  231,  232,  161,  234,
 /*  4970 */   247,  247,  247,  247,  247,  247,  241,  247,  247,   73,
 /*  4980 */   173,  247,  247,  247,  247,  247,  247,    7,    8,    9,
 /*  4990 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5000 */   247,  247,  247,   23,  247,   25,   26,   27,   28,   29,
 /*  5010 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*  5020 */    40,   41,   42,   43,   44,   45,  247,   47,  247,  222,
 /*  5030 */   247,  247,  247,  247,  227,  228,  229,  230,  231,  232,
 /*  5040 */   247,  234,  247,  247,  237,  247,  247,  247,  247,  247,
 /*  5050 */   247,  247,  247,   73,  247,  247,  247,  247,  247,  247,
 /*  5060 */   247,    7,    8,    9,  247,  247,  247,  247,  247,  247,
 /*  5070 */   247,  247,  247,  247,  247,  247,  247,   23,  247,   25,
 /*  5080 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  5090 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  5100 */   247,   47,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5110 */   247,  247,  247,  161,  247,  247,  247,  247,  247,  247,
 /*  5120 */   247,  247,  247,  247,  247,  173,  247,   73,  247,  247,
 /*  5130 */   247,  247,  247,  247,  247,    7,    8,    9,  247,  247,
 /*  5140 */   247,  189,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5150 */   247,   23,  247,   25,   26,   27,   28,   29,   30,   31,
 /*  5160 */    32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
 /*  5170 */    42,   43,   44,   45,  222,   47,    7,    8,    9,  227,
 /*  5180 */   228,  229,  230,  231,  232,  247,  234,  247,  247,  247,
 /*  5190 */   247,  247,   23,  247,   25,   26,   27,   28,   29,   30,
 /*  5200 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*  5210 */    41,   42,   43,   44,   45,  247,   47,  247,  247,  247,
 /*  5220 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5230 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5240 */   247,  247,   73,  115,  161,  247,  247,  247,  247,  247,
 /*  5250 */     7,    8,    9,  170,  247,  247,  173,  247,  247,  247,
 /*  5260 */   247,  247,  247,  247,  247,  247,   23,  247,   25,   26,
 /*  5270 */    27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
 /*  5280 */    37,   38,   39,   40,   41,   42,   43,   44,   45,  247,
 /*  5290 */    47,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5300 */   247,  247,  247,  247,  247,  222,  247,  247,  247,  247,
 /*  5310 */   227,  228,  229,  230,  231,  232,  247,  234,  247,   76,
 /*  5320 */   247,  161,  247,  247,  247,  247,  247,    7,    8,    9,
 /*  5330 */   170,  247,  247,  173,  247,  247,  247,  247,  247,  247,
 /*  5340 */   247,  247,  247,   23,  247,   25,   26,   27,   28,   29,
 /*  5350 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*  5360 */    40,   41,   42,   43,   44,   45,  247,   47,  247,  247,
 /*  5370 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5380 */   247,  247,  222,  247,  247,  247,  247,  227,  228,  229,
 /*  5390 */   230,  231,  232,  247,  234,  247,   76,  247,  247,  247,
 /*  5400 */   247,  247,  247,  247,    7,    8,    9,  247,  247,  247,
 /*  5410 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5420 */    23,  247,   25,   26,   27,   28,   29,   30,   31,   32,
 /*  5430 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*  5440 */    43,   44,   45,  247,   47,  247,  247,  247,  247,  247,
 /*  5450 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5460 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5470 */    73,  247,  247,  161,  247,  247,  247,  247,    7,    8,
 /*  5480 */     9,  247,  170,  247,  247,  173,  247,  247,  247,  247,
 /*  5490 */   247,  247,  247,  247,   23,  247,   25,   26,   27,   28,
 /*  5500 */    29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
 /*  5510 */    39,   40,   41,   42,   43,   44,   45,  247,   47,  247,
 /*  5520 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5530 */   247,  247,  247,  247,  222,  247,  247,  247,  247,  227,
 /*  5540 */   228,  229,  230,  231,  232,   74,  234,  247,  247,  247,
 /*  5550 */   247,  247,  247,    7,    8,    9,  247,  247,  247,  247,
 /*  5560 */   247,  247,  247,  247,  247,  247,  247,  247,  247,   23,
 /*  5570 */   247,   25,   26,   27,   28,   29,   30,   31,   32,   33,
 /*  5580 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  5590 */    44,   45,  247,   47,    8,    9,  247,  247,  247,  247,
 /*  5600 */   247,  247,  247,  247,  247,  247,  247,  247,  247,   23,
 /*  5610 */   247,   25,   26,   27,   28,   29,   30,   31,   32,   33,
 /*  5620 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  5630 */    44,   45,    9,   47,  247,  247,  247,  247,  247,  247,
 /*  5640 */   247,  247,  247,  247,  247,  247,   23,  247,   25,   26,
 /*  5650 */    27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
 /*  5660 */    37,   38,   39,   40,   41,   42,   43,   44,   45,  161,
 /*  5670 */    47,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5680 */   247,  173,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5690 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5700 */   146,  193,  247,  149,  247,  151,  247,  247,  247,  247,
 /*  5710 */   247,  247,  158,  247,  160,  161,  247,  247,  146,  247,
 /*  5720 */   247,  149,  247,  151,  247,  247,  247,  173,  156,  247,
 /*  5730 */   222,  247,  160,  161,  247,  227,  228,  229,  230,  231,
 /*  5740 */   232,  247,  234,  189,  247,  173,  247,  193,  194,  247,
 /*  5750 */   196,  197,  247,  247,  200,  247,  247,  247,  247,  247,
 /*  5760 */   247,  189,  247,  247,  247,  193,  194,  247,  196,  197,
 /*  5770 */   247,  247,  200,  247,  247,  247,  222,  247,  247,  247,
 /*  5780 */   247,  227,  228,  229,  230,  231,  232,  247,  234,  247,
 /*  5790 */   247,  247,  247,  247,  222,  247,  242,  247,  247,  227,
 /*  5800 */   228,  229,  230,  231,  232,  146,  234,  247,  149,  247,
 /*  5810 */   151,  247,  247,  247,  242,  247,  247,  247,  247,  160,
 /*  5820 */   161,  247,  247,  247,  247,  247,  247,  247,  169,  247,
 /*  5830 */   247,  247,  173,  247,  247,  247,  247,  247,  247,  247,
 /*  5840 */   247,  247,  247,  247,  247,  247,  247,  247,  189,  247,
 /*  5850 */   247,  247,  193,  194,  247,  196,  197,  247,  247,  200,
 /*  5860 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5870 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  5880 */   146,  222,  247,  149,  247,  151,  227,  228,  229,  230,
 /*  5890 */   231,  232,  247,  234,  160,  161,  247,  247,  247,  247,
 /*  5900 */   247,  242,  151,  169,  247,  247,  247,  173,  157,  247,
 /*  5910 */   247,  160,  161,  247,  247,  247,  247,  247,  247,  247,
 /*  5920 */   247,  247,  247,  189,  173,  247,  247,  193,  194,  247,
 /*  5930 */   196,  197,  247,  247,  200,  247,  247,  247,  247,  247,
 /*  5940 */   189,  247,  247,  247,  193,  194,  161,  196,  197,  247,
 /*  5950 */   247,  200,  247,  247,  247,  170,  222,  247,  173,  247,
 /*  5960 */   247,  227,  228,  229,  230,  231,  232,  247,  234,  247,
 /*  5970 */   247,  247,  247,  222,  247,  247,  242,  247,  227,  228,
 /*  5980 */   229,  230,  231,  232,  247,  234,  247,  247,  247,  247,
 /*  5990 */   247,  247,  247,  242,  247,  247,  247,  246,  247,  247,
 /*  6000 */   151,  247,  247,  247,  247,  247,  247,  222,  247,  160,
 /*  6010 */   161,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /*  6020 */   247,  247,  173,  247,  247,  247,  247,  247,  247,  247,
 /*  6030 */   247,  247,  247,  247,  247,  247,  247,  247,  189,  247,
 /*  6040 */   247,  247,  193,  194,  247,  196,  197,  151,  247,  200,
 /*  6050 */   247,  247,  247,  247,  247,  247,  160,  161,  247,  210,
 /*  6060 */   211,  247,  247,  247,  247,  247,  247,  247,  247,  173,
 /*  6070 */   247,  222,  247,  247,  247,  247,  227,  228,  229,  230,
 /*  6080 */   231,  232,  247,  234,  247,  189,  247,  247,  247,  193,
 /*  6090 */   194,  242,  196,  197,  198,  247,  200,  151,  247,  247,
 /*  6100 */   247,  247,  247,  247,  247,  247,  160,  161,  247,  247,
 /*  6110 */   247,  247,  247,  247,  247,  247,  247,  247,  222,  173,
 /*  6120 */   247,  247,  247,  227,  228,  229,  230,  231,  232,  247,
 /*  6130 */   234,  247,  247,  247,  238,  189,  247,  247,  242,  193,
 /*  6140 */   194,  247,  196,  197,  247,  247,  200,  247,  247,  151,
 /*  6150 */   247,  247,  247,  247,  247,  247,  210,  211,  160,  161,
 /*  6160 */   247,  247,  247,  247,  247,  247,  247,  247,  222,  247,
 /*  6170 */   247,  173,  247,  227,  228,  229,  230,  231,  232,  247,
 /*  6180 */   234,  247,  247,  247,  247,  247,  247,  189,  242,  247,
 /*  6190 */   247,  193,  194,  247,  196,  197,  247,  247,  200,  247,
 /*  6200 */   247,  151,  247,  247,  247,  247,  247,  247,  210,  211,
 /*  6210 */   160,  161,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  6220 */   222,  247,  247,  173,  247,  227,  228,  229,  230,  231,
 /*  6230 */   232,  247,  234,  247,  247,  247,  247,  247,  247,  189,
 /*  6240 */   242,  247,  247,  193,  194,  247,  196,  197,  247,  247,
 /*  6250 */   200,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  6260 */   210,  211,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  6270 */   247,  146,  222,  247,  149,  247,  151,  227,  228,  229,
 /*  6280 */   230,  231,  232,  247,  234,  160,  161,  247,  247,  247,
 /*  6290 */   247,  247,  242,  247,  151,  247,  247,  247,  173,  247,
 /*  6300 */   157,  247,  247,  160,  161,  247,  247,  247,  247,  247,
 /*  6310 */   247,  247,  247,  247,  189,  247,  173,  247,  193,  194,
 /*  6320 */   247,  196,  197,  247,  247,  200,  247,  247,  247,  247,
 /*  6330 */   247,  247,  189,  247,  247,  247,  193,  194,  161,  196,
 /*  6340 */   197,  247,  247,  200,  247,  247,  247,  222,  247,  247,
 /*  6350 */   173,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /*  6360 */   247,  247,  247,  247,  247,  222,  247,  242,  247,  247,
 /*  6370 */   227,  228,  229,  230,  231,  232,  146,  234,  247,  149,
 /*  6380 */   247,  151,  247,  247,  247,  242,  247,  247,  247,  246,
 /*  6390 */   160,  161,  247,  247,  247,  247,  247,  247,  247,  222,
 /*  6400 */   247,  247,  247,  173,  227,  228,  229,  230,  231,  232,
 /*  6410 */   247,  234,  247,  247,  247,  247,  247,  247,  247,  189,
 /*  6420 */   247,  247,  247,  193,  194,  247,  196,  197,  151,  247,
 /*  6430 */   200,  247,  247,  247,  247,  247,  247,  160,  161,  247,
 /*  6440 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  6450 */   173,  247,  222,  247,  247,  247,  247,  227,  228,  229,
 /*  6460 */   230,  231,  232,  247,  234,  247,  189,  247,  247,  247,
 /*  6470 */   193,  194,  242,  196,  197,  247,  247,  200,  247,  247,
 /*  6480 */   247,  247,  247,  247,  247,  247,  146,  210,  211,  149,
 /*  6490 */   247,  151,  247,  247,  247,  247,  247,  247,  247,  222,
 /*  6500 */   160,  161,  247,  247,  227,  228,  229,  230,  231,  232,
 /*  6510 */   247,  234,  247,  173,  247,  247,  247,  247,  247,  242,
 /*  6520 */   247,  247,  247,  247,  247,  247,  247,  161,  247,  189,
 /*  6530 */   247,  247,  247,  193,  194,  247,  196,  197,  247,  173,
 /*  6540 */   200,  151,  247,  247,  247,  247,  247,  157,  247,  247,
 /*  6550 */   160,  161,  247,  247,  247,  247,  247,  247,  247,  193,
 /*  6560 */   247,  247,  222,  173,  247,  247,  247,  227,  228,  229,
 /*  6570 */   230,  231,  232,  247,  234,  247,  247,  247,  247,  189,
 /*  6580 */   247,  247,  242,  193,  194,  247,  196,  197,  222,  247,
 /*  6590 */   200,  247,  247,  227,  228,  229,  230,  231,  232,  247,
 /*  6600 */   234,  247,  247,  247,  151,  247,  247,  247,  247,  247,
 /*  6610 */   247,  247,  222,  160,  161,  247,  247,  227,  228,  229,
 /*  6620 */   230,  231,  232,  247,  234,  247,  173,  247,  247,  247,
 /*  6630 */   247,  247,  242,  247,  247,  247,  246,  247,  247,  247,
 /*  6640 */   247,  247,  189,  247,  247,  247,  193,  194,  161,  196,
 /*  6650 */   197,  146,  247,  200,  149,  247,  151,  170,  247,  247,
 /*  6660 */   173,  247,  247,  210,  211,  160,  161,  247,  247,  247,
 /*  6670 */   247,  247,  247,  247,  247,  222,  247,  247,  173,  247,
 /*  6680 */   227,  228,  229,  230,  231,  232,  247,  234,  247,  247,
 /*  6690 */   247,  247,  247,  247,  189,  242,  161,  247,  193,  194,
 /*  6700 */   247,  196,  197,  151,  247,  200,  247,  247,  173,  222,
 /*  6710 */   247,  247,  160,  161,  227,  228,  229,  230,  231,  232,
 /*  6720 */   247,  234,  247,  247,  247,  173,  247,  222,  247,  247,
 /*  6730 */   247,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /*  6740 */   247,  189,  247,  247,  161,  193,  194,  242,  196,  197,
 /*  6750 */   247,  247,  200,  247,  247,  247,  173,  222,  247,  247,
 /*  6760 */   247,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /*  6770 */   247,  247,  247,  247,  222,  247,  247,  247,  151,  227,
 /*  6780 */   228,  229,  230,  231,  232,  233,  234,  160,  161,  247,
 /*  6790 */   247,  164,  247,  247,  242,  247,  247,  247,  247,  247,
 /*  6800 */   173,  247,  247,  247,  247,  222,  247,  247,  247,  247,
 /*  6810 */   227,  228,  229,  230,  231,  232,  189,  234,  247,  247,
 /*  6820 */   193,  194,  161,  196,  197,  247,  247,  200,  247,  247,
 /*  6830 */   151,  247,  247,  247,  173,  247,  247,  247,  247,  160,
 /*  6840 */   161,  247,  247,  247,  247,  247,  247,  247,  247,  222,
 /*  6850 */   247,  247,  173,  247,  227,  228,  229,  230,  231,  232,
 /*  6860 */   247,  234,  247,  247,  247,  247,  247,  247,  189,  242,
 /*  6870 */   247,  247,  193,  194,  247,  196,  197,  151,  247,  200,
 /*  6880 */   247,  247,  247,  222,  247,  247,  160,  161,  227,  228,
 /*  6890 */   229,  230,  231,  232,  247,  234,  247,  247,  247,  173,
 /*  6900 */   247,  222,  247,  247,  247,  247,  227,  228,  229,  230,
 /*  6910 */   231,  232,  233,  234,  247,  189,  247,  247,  247,  193,
 /*  6920 */   194,  242,  196,  197,  247,  247,  200,  247,  247,  247,
 /*  6930 */   247,  247,  247,  247,  247,  247,  247,  151,  247,  247,
 /*  6940 */   247,  247,  247,  247,  247,  247,  160,  161,  222,  247,
 /*  6950 */   247,  247,  247,  227,  228,  229,  230,  231,  232,  173,
 /*  6960 */   234,  247,  247,  247,  247,  247,  247,  247,  242,  247,
 /*  6970 */   247,  247,  247,  247,  247,  189,  247,  247,  247,  193,
 /*  6980 */   194,  247,  196,  197,  247,  247,  200,  247,  247,  247,
 /*  6990 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7000 */   247,  151,  247,  247,  247,  247,  247,  247,  222,  247,
 /*  7010 */   160,  161,  247,  227,  228,  229,  230,  231,  232,  247,
 /*  7020 */   234,  247,  247,  173,  247,  247,  247,  247,  242,  247,
 /*  7030 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  189,
 /*  7040 */   247,  247,  247,  193,  194,  247,  196,  197,  247,  247,
 /*  7050 */   200,  151,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7060 */   160,  161,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7070 */   247,  247,  222,  173,  247,  247,  247,  227,  228,  229,
 /*  7080 */   230,  231,  232,  247,  234,  247,  247,  247,  247,  189,
 /*  7090 */   247,  247,  242,  193,  194,  247,  196,  197,  151,  247,
 /*  7100 */   200,  247,  247,  247,  247,  247,  247,  160,  161,  247,
 /*  7110 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7120 */   173,  247,  222,  247,  247,  247,  247,  227,  228,  229,
 /*  7130 */   230,  231,  232,  247,  234,  247,  189,  247,  247,  247,
 /*  7140 */   193,  194,  242,  196,  197,  247,  247,  200,  247,  247,
 /*  7150 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7160 */   247,  247,  151,  247,  247,  247,  247,  247,  247,  222,
 /*  7170 */   247,  160,  161,  247,  227,  228,  229,  230,  231,  232,
 /*  7180 */   247,  234,  247,  247,  173,  247,  247,  247,  247,  242,
 /*  7190 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7200 */   189,  247,  247,  247,  193,  194,  247,  196,  197,  247,
 /*  7210 */   247,  200,  151,  247,  247,  247,  247,  247,  247,  247,
 /*  7220 */   247,  160,  161,  247,  247,  247,  247,  247,  247,  247,
 /*  7230 */   247,  247,  247,  222,  173,  247,  247,  247,  227,  228,
 /*  7240 */   229,  230,  231,  232,  247,  234,  247,  247,  247,  247,
 /*  7250 */   189,  247,  247,  242,  193,  194,  247,  196,  197,  151,
 /*  7260 */   247,  200,  247,  247,  247,  247,  247,  247,  160,  161,
 /*  7270 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7280 */   247,  173,  247,  222,  247,  247,  247,  247,  227,  228,
 /*  7290 */   229,  230,  231,  232,  247,  234,  247,  189,  247,  247,
 /*  7300 */   247,  193,  194,  242,  196,  197,  247,  247,  200,  247,
 /*  7310 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7320 */   247,  247,  247,  151,  247,  247,  247,  247,  247,  247,
 /*  7330 */   222,  247,  160,  161,  247,  227,  228,  229,  230,  231,
 /*  7340 */   232,  247,  234,  247,  247,  173,  247,  247,  247,  247,
 /*  7350 */   242,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7360 */   247,  189,  247,  247,  247,  193,  194,  247,  196,  197,
 /*  7370 */   247,  247,  200,  151,  247,  247,  247,  247,  247,  247,
 /*  7380 */   247,  247,  160,  161,  247,  247,  247,  247,  247,  247,
 /*  7390 */   247,  247,  247,  247,  222,  173,  247,  247,  247,  227,
 /*  7400 */   228,  229,  230,  231,  232,  247,  234,  247,  247,  247,
 /*  7410 */   247,  189,  247,  247,  242,  193,  194,  247,  196,  197,
 /*  7420 */   151,  247,  200,  247,  247,  247,  247,  247,  247,  160,
 /*  7430 */   161,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7440 */   247,  247,  173,  247,  222,  247,  247,  247,  247,  227,
 /*  7450 */   228,  229,  230,  231,  232,  247,  234,  247,  189,  247,
 /*  7460 */   247,  247,  193,  194,  242,  196,  197,  247,  247,  200,
 /*  7470 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7480 */   247,  247,  247,  247,  151,  247,  247,  247,  247,  247,
 /*  7490 */   247,  222,  247,  160,  161,  247,  227,  228,  229,  230,
 /*  7500 */   231,  232,  247,  234,  247,  247,  173,  247,  247,  247,
 /*  7510 */   247,  242,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7520 */   247,  247,  189,  247,  247,  247,  193,  194,  247,  196,
 /*  7530 */   197,  247,  247,  200,  151,  247,  247,  247,  247,  247,
 /*  7540 */   247,  247,  247,  160,  161,  247,  247,  247,  247,  247,
 /*  7550 */   247,  247,  247,  247,  247,  222,  173,  247,  247,  247,
 /*  7560 */   227,  228,  229,  230,  231,  232,  247,  234,  247,  247,
 /*  7570 */   247,  247,  189,  247,  247,  242,  193,  194,  247,  196,
 /*  7580 */   197,  151,  247,  200,  247,  247,  247,  247,  247,  247,
 /*  7590 */   160,  161,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7600 */   247,  247,  247,  173,  247,  222,  247,  247,  247,  247,
 /*  7610 */   227,  228,  229,  230,  231,  232,  247,  234,  247,  189,
 /*  7620 */   247,  247,  247,  193,  194,  242,  196,  197,  247,  247,
 /*  7630 */   200,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7640 */   247,  247,  247,  247,  247,  151,  247,  247,  247,  247,
 /*  7650 */   247,  247,  222,  247,  160,  161,  247,  227,  228,  229,
 /*  7660 */   230,  231,  232,  247,  234,  247,  247,  173,  247,  247,
 /*  7670 */   247,  247,  242,  247,  247,  247,  247,  247,  247,  247,
 /*  7680 */   247,  247,  247,  189,  247,  247,  247,  193,  194,  247,
 /*  7690 */   196,  197,  247,  247,  200,  151,  247,  247,  247,  247,
 /*  7700 */   247,  247,  247,  247,  160,  161,  247,  247,  247,  247,
 /*  7710 */   247,  247,  247,  247,  247,  247,  222,  173,  247,  247,
 /*  7720 */   247,  227,  228,  229,  230,  231,  232,  247,  234,  247,
 /*  7730 */   247,  247,  247,  189,  247,  247,  242,  193,  194,  247,
 /*  7740 */   196,  197,  151,  247,  200,  247,  247,  247,  247,  247,
 /*  7750 */   247,  160,  161,  247,  247,  247,  247,  247,  247,  247,
 /*  7760 */   247,  247,  247,  247,  173,  247,  222,  247,  247,  247,
 /*  7770 */   247,  227,  228,  229,  230,  231,  232,  247,  234,  247,
 /*  7780 */   189,  247,  247,  247,  193,  194,  242,  196,  197,  247,
 /*  7790 */   247,  200,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  7800 */   247,  247,  247,  247,  247,  247,  151,  247,  247,  247,
 /*  7810 */   247,  247,  247,  222,  247,  160,  161,  247,  227,  228,
 /*  7820 */   229,  230,  231,  232,  247,  234,  247,  247,  173,  247,
 /*  7830 */   247,  247,  247,  242,  247,  247,  247,  247,  247,  247,
 /*  7840 */   247,  247,  247,  247,  189,  247,  247,  247,  193,  194,
 /*  7850 */   247,  196,  197,  247,  247,  200,  151,  247,  247,  247,
 /*  7860 */   247,  247,  247,  247,  247,  160,  161,  247,  247,  247,
 /*  7870 */   247,  247,  247,  247,  247,  247,  247,  222,  173,  247,
 /*  7880 */   247,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /*  7890 */   247,  247,  247,  247,  189,  247,  247,  242,  193,  194,
 /*  7900 */   247,  196,  197,  151,  247,  200,  247,  247,  247,  247,
 /*  7910 */   247,  247,  160,  161,  247,  247,  247,  247,  247,  247,
 /*  7920 */   247,  247,  247,  247,  247,  173,  247,  222,  247,  247,
 /*  7930 */   247,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /*  7940 */   247,  189,  247,  247,  247,  193,  194,  242,  196,  197,
 /*  7950 */   247,  247,  200,  247,  247,  247,  247,  247,  247,  247,
 /*  7960 */   247,  247,  247,  247,  247,  247,  247,  151,  247,  247,
 /*  7970 */   247,  247,  247,  247,  222,  247,  160,  161,  247,  227,
 /*  7980 */   228,  229,  230,  231,  232,  247,  234,  247,  247,  173,
 /*  7990 */   247,  247,  247,  247,  242,  247,  247,  247,  247,  247,
 /*  8000 */   247,  247,  247,  247,  247,  189,  247,  247,  247,  193,
 /*  8010 */   194,  247,  196,  197,  247,  247,  200,  151,  247,  247,
 /*  8020 */   247,  247,  247,  247,  247,  247,  160,  161,  247,  247,
 /*  8030 */   247,  247,  247,  247,  247,  247,  247,  247,  222,  173,
 /*  8040 */   247,  247,  247,  227,  228,  229,  230,  231,  232,  247,
 /*  8050 */   234,  247,  247,  247,  247,  189,  247,  247,  242,  193,
 /*  8060 */   194,  247,  196,  197,  151,  247,  200,  247,  247,  247,
 /*  8070 */   247,  247,  247,  160,  161,  247,  247,  247,  247,  247,
 /*  8080 */   247,  247,  247,  247,  247,  247,  173,  247,  222,  247,
 /*  8090 */   247,  247,  247,  227,  228,  229,  230,  231,  232,  247,
 /*  8100 */   234,  247,  189,  247,  247,  247,  193,  194,  242,  196,
 /*  8110 */   197,  247,  247,  200,  247,  247,  247,  247,  247,  247,
 /*  8120 */   247,  247,  247,  247,  247,  247,  247,  247,  151,  247,
 /*  8130 */   247,  247,  247,  247,  247,  222,  247,  160,  161,  247,
 /*  8140 */   227,  228,  229,  230,  231,  232,  247,  234,  247,  247,
 /*  8150 */   173,  247,  247,  247,  247,  242,  247,  247,  247,  247,
 /*  8160 */   247,  247,  247,  247,  247,  247,  189,  247,  247,  247,
 /*  8170 */   193,  194,  247,  196,  197,  247,  247,  200,  151,  247,
 /*  8180 */   247,  247,  247,  247,  247,  247,  247,  160,  161,  247,
 /*  8190 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  222,
 /*  8200 */   173,  247,  247,  247,  227,  228,  229,  230,  231,  232,
 /*  8210 */   247,  234,  247,  247,  247,  247,  189,  247,  247,  242,
 /*  8220 */   193,  194,  247,  196,  197,  151,  247,  200,  247,  247,
 /*  8230 */   247,  247,  247,  247,  160,  161,  247,  247,  247,  247,
 /*  8240 */   247,  247,  247,  247,  247,  247,  247,  173,  247,  222,
 /*  8250 */   247,  247,  247,  247,  227,  228,  229,  230,  231,  232,
 /*  8260 */   247,  234,  247,  189,  247,  247,  247,  193,  194,  242,
 /*  8270 */   196,  197,  247,  247,  200,  247,  247,  247,  247,  247,
 /*  8280 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  151,
 /*  8290 */   247,  247,  247,  247,  247,  247,  222,  247,  160,  161,
 /*  8300 */   247,  227,  228,  229,  230,  231,  232,  247,  234,  247,
 /*  8310 */   247,  173,  247,  247,  247,  247,  242,  247,  247,  247,
 /*  8320 */   247,  247,  247,  247,  247,  247,  247,  189,  247,  247,
 /*  8330 */   247,  193,  194,  247,  196,  197,  247,  247,  200,  151,
 /*  8340 */   247,  247,  247,  247,  247,  247,  247,  247,  160,  161,
 /*  8350 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  8360 */   222,  173,  247,  247,  247,  227,  228,  229,  230,  231,
 /*  8370 */   232,  247,  234,  247,  247,  247,  247,  189,  247,  247,
 /*  8380 */   242,  193,  194,  247,  196,  197,  151,  247,  200,  247,
 /*  8390 */   247,  247,  247,  247,  247,  160,  161,  247,  247,  247,
 /*  8400 */   247,  247,  247,  247,  247,  247,  247,  247,  173,  247,
 /*  8410 */   222,  247,  247,  247,  247,  227,  228,  229,  230,  231,
 /*  8420 */   232,  247,  234,  247,  189,  247,  247,  247,  193,  194,
 /*  8430 */   242,  196,  197,  247,  247,  200,  247,  247,  247,  247,
 /*  8440 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  8450 */   151,  247,  247,  247,  247,  247,  247,  222,  247,  160,
 /*  8460 */   161,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /*  8470 */   247,  247,  173,  247,  247,  247,  247,  242,  247,  247,
 /*  8480 */   247,  247,  247,  247,  247,  247,  247,  247,  189,  247,
 /*  8490 */   247,  247,  193,  194,  247,  196,  197,  247,  247,  200,
 /*  8500 */   151,  247,  247,  247,  247,  247,  247,  247,  247,  160,
 /*  8510 */   161,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  8520 */   247,  222,  173,  247,  247,  247,  227,  228,  229,  230,
 /*  8530 */   231,  232,  247,  234,  247,  247,  247,  247,  189,  247,
 /*  8540 */   247,  242,  193,  194,  247,  196,  197,  151,  247,  200,
 /*  8550 */   247,  247,  247,  247,  247,  247,  160,  161,  247,  247,
 /*  8560 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  173,
 /*  8570 */   247,  222,  247,  247,  247,  247,  227,  228,  229,  230,
 /*  8580 */   231,  232,  247,  234,  247,  189,  247,  247,  247,  193,
 /*  8590 */   194,  242,  196,  197,  247,  247,  200,  247,  247,  247,
 /*  8600 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  8610 */   247,  151,  247,  247,  247,  247,  247,  247,  222,  247,
 /*  8620 */   160,  161,  247,  227,  228,  229,  230,  231,  232,  247,
 /*  8630 */   234,  247,  247,  173,  247,  247,  247,  247,  242,  247,
 /*  8640 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  189,
 /*  8650 */   247,  247,  247,  193,  194,  247,  196,  197,  247,  247,
 /*  8660 */   200,  151,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  8670 */   160,  161,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  8680 */   247,  247,  222,  173,  247,  247,  247,  227,  228,  229,
 /*  8690 */   230,  231,  232,  247,  234,  247,  247,  247,  247,  189,
 /*  8700 */   247,  247,  242,  193,  194,  247,  196,  197,  151,  247,
 /*  8710 */   200,  247,  247,  247,  247,  247,  247,  160,  161,  247,
 /*  8720 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  8730 */   173,  247,  222,  247,  247,  247,  247,  227,  228,  229,
 /*  8740 */   230,  231,  232,  247,  234,  247,  189,  247,  247,  247,
 /*  8750 */   193,  194,  242,  196,  197,  247,  247,  200,  247,  247,
 /*  8760 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  8770 */   247,  247,  151,  247,  247,  247,  247,  247,  247,  222,
 /*  8780 */   247,  160,  161,  247,  227,  228,  229,  230,  231,  232,
 /*  8790 */   247,  234,  247,  247,  173,  247,  247,  247,  247,  242,
 /*  8800 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  8810 */   189,  247,  247,  247,  193,  194,  247,  196,  197,  247,
 /*  8820 */   247,  200,  151,  247,  247,  247,  247,  247,  247,  247,
 /*  8830 */   247,  160,  161,  247,  247,  247,  247,  247,  247,  247,
 /*  8840 */   247,  247,  247,  222,  173,  247,  247,  247,  227,  228,
 /*  8850 */   229,  230,  231,  232,  247,  234,  247,  247,  247,  247,
 /*  8860 */   189,  247,  247,  242,  193,  194,  247,  196,  197,  151,
 /*  8870 */   247,  200,  247,  247,  247,  247,  247,  247,  160,  161,
 /*  8880 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  8890 */   247,  173,  247,  222,  247,  247,  247,  247,  227,  228,
 /*  8900 */   229,  230,  231,  232,  247,  234,  247,  189,  247,  247,
 /*  8910 */   247,  193,  194,  242,  196,  197,  247,  247,  200,  247,
 /*  8920 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  8930 */   247,  247,  247,  151,  247,  247,  247,  247,  247,  247,
 /*  8940 */   222,  247,  160,  161,  247,  227,  228,  229,  230,  231,
 /*  8950 */   232,  247,  234,  247,  247,  173,  247,  247,  247,  247,
 /*  8960 */   242,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  8970 */   247,  189,  247,  247,  247,  193,  194,  247,  196,  197,
 /*  8980 */   247,  247,  200,  151,  247,  247,  247,  247,  247,  247,
 /*  8990 */   247,  247,  160,  161,  247,  247,  247,  247,  247,  247,
 /*  9000 */   247,  247,  247,  247,  222,  173,  247,  247,  247,  227,
 /*  9010 */   228,  229,  230,  231,  232,  247,  234,  247,  247,  247,
 /*  9020 */   247,  189,  247,  247,  242,  193,  194,  247,  196,  197,
 /*  9030 */   151,  247,  200,  247,  247,  247,  247,  247,  247,  160,
 /*  9040 */   161,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  9050 */   247,  247,  173,  247,  222,  247,  247,  247,  247,  227,
 /*  9060 */   228,  229,  230,  231,  232,  247,  234,  247,  189,  247,
 /*  9070 */   247,  247,  193,  194,  242,  196,  197,  247,  247,  200,
 /*  9080 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  9090 */   247,  247,  247,  247,  151,  247,  247,  247,  247,  247,
 /*  9100 */   247,  222,  247,  160,  161,  247,  227,  228,  229,  230,
 /*  9110 */   231,  232,  247,  234,  247,  247,  173,  247,  247,  247,
 /*  9120 */   247,  242,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  9130 */   247,  247,  189,  247,  247,  247,  193,  194,  247,  196,
 /*  9140 */   197,  247,  247,  200,  151,  247,  247,  247,  247,  247,
 /*  9150 */   247,  247,  247,  160,  161,  247,  247,  247,  247,  247,
 /*  9160 */   247,  247,  247,  247,  247,  222,  173,  247,  247,  247,
 /*  9170 */   227,  228,  229,  230,  231,  232,  247,  234,  247,  247,
 /*  9180 */   247,  247,  189,  247,  247,  242,  193,  194,  247,  196,
 /*  9190 */   197,  151,  247,  200,  247,  247,  247,  247,  247,  247,
 /*  9200 */   160,  161,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  9210 */   247,  247,  247,  173,  247,  222,  247,  247,  247,  247,
 /*  9220 */   227,  228,  229,  230,  231,  232,  247,  234,  247,  189,
 /*  9230 */   247,  247,  247,  193,  194,  242,  196,  197,  247,  247,
 /*  9240 */   200,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  9250 */   247,  247,  247,  247,  247,  151,  247,  247,  247,  247,
 /*  9260 */   247,  247,  222,  247,  160,  161,  247,  227,  228,  229,
 /*  9270 */   230,  231,  232,  247,  234,  247,  247,  173,  247,  247,
 /*  9280 */   247,  247,  242,  247,  247,  247,  247,  247,  247,  247,
 /*  9290 */   247,  247,  247,  189,  247,  247,  247,  193,  194,  247,
 /*  9300 */   196,  197,  247,  247,  200,  151,  247,  247,  247,  247,
 /*  9310 */   247,  247,  247,  247,  160,  161,  247,  247,  247,  247,
 /*  9320 */   247,  247,  247,  247,  247,  247,  222,  173,  247,  247,
 /*  9330 */   247,  227,  228,  229,  230,  231,  232,  247,  234,  247,
 /*  9340 */   247,  247,  247,  189,  247,  247,  242,  193,  194,  247,
 /*  9350 */   196,  197,  151,  247,  200,  247,  247,  247,  247,  247,
 /*  9360 */   247,  160,  161,  247,  247,  247,  247,  247,  247,  247,
 /*  9370 */   247,  247,  247,  247,  173,  247,  222,  247,  247,  247,
 /*  9380 */   247,  227,  228,  229,  230,  231,  232,  247,  234,  247,
 /*  9390 */   189,  247,  247,  247,  193,  194,  242,  196,  197,  247,
 /*  9400 */   247,  200,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  9410 */   247,  247,  247,  247,  247,  247,  151,  247,  247,  247,
 /*  9420 */   247,  247,  247,  222,  247,  160,  161,  247,  227,  228,
 /*  9430 */   229,  230,  231,  232,  247,  234,  247,  247,  173,  247,
 /*  9440 */   247,  247,  247,  242,  247,  247,  247,  247,  247,  247,
 /*  9450 */   247,  247,  247,  247,  189,  247,  247,  247,  193,  194,
 /*  9460 */   247,  196,  197,  247,  247,  200,  151,  247,  247,  247,
 /*  9470 */   247,  247,  247,  247,  247,  160,  161,  247,  247,  247,
 /*  9480 */   247,  247,  247,  247,  247,  247,  247,  222,  173,  247,
 /*  9490 */   247,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /*  9500 */   247,  247,  247,  247,  189,  247,  247,  242,  193,  194,
 /*  9510 */   247,  196,  197,  151,  247,  200,  247,  247,  247,  247,
 /*  9520 */   247,  247,  160,  161,  247,  247,  247,  247,  247,  247,
 /*  9530 */   247,  247,  247,  247,  247,  173,  247,  222,  247,  247,
 /*  9540 */   247,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /*  9550 */   247,  189,  247,  247,  247,  193,  194,  242,  196,  197,
 /*  9560 */   247,  247,  200,  247,  247,  247,  247,  247,  247,  247,
 /*  9570 */   247,  247,  247,  247,  247,  247,  247,  151,  247,  247,
 /*  9580 */   247,  247,  247,  247,  222,  247,  160,  161,  247,  227,
 /*  9590 */   228,  229,  230,  231,  232,  247,  234,  247,  247,  173,
 /*  9600 */   247,  247,  247,  247,  242,  247,  247,  247,  247,  247,
 /*  9610 */   247,  247,  247,  247,  247,  189,  247,  247,  247,  193,
 /*  9620 */   194,  247,  196,  197,  247,  247,  200,  151,  247,  247,
 /*  9630 */   247,  247,  247,  247,  247,  247,  160,  161,  247,  247,
 /*  9640 */   247,  247,  247,  247,  247,  247,  247,  247,  222,  173,
 /*  9650 */   247,  247,  247,  227,  228,  229,  230,  231,  232,  247,
 /*  9660 */   234,  247,  247,  247,  247,  189,  247,  247,  242,  193,
 /*  9670 */   194,  247,  196,  197,  151,  247,  200,  247,  247,  247,
 /*  9680 */   247,  247,  247,  160,  161,  247,  247,  247,  247,  247,
 /*  9690 */   247,  247,  247,  247,  247,  247,  173,  247,  222,  247,
 /*  9700 */   247,  247,  247,  227,  228,  229,  230,  231,  232,  247,
 /*  9710 */   234,  247,  189,  247,  247,  247,  193,  194,  242,  196,
 /*  9720 */   197,  247,  247,  200,  247,  247,  247,  247,  247,  247,
 /*  9730 */   247,  247,  247,  247,  247,  247,  247,  247,  151,  247,
 /*  9740 */   247,  247,  247,  247,  247,  222,  247,  160,  161,  247,
 /*  9750 */   227,  228,  229,  230,  231,  232,  247,  234,  247,  247,
 /*  9760 */   173,  247,  247,  247,  247,  242,  247,  247,  247,  247,
 /*  9770 */   247,  247,  247,  247,  247,  247,  189,  247,  247,  247,
 /*  9780 */   193,  194,  247,  196,  197,  247,  247,  200,  151,  247,
 /*  9790 */   247,  247,  247,  247,  247,  247,  247,  160,  161,  247,
 /*  9800 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  222,
 /*  9810 */   173,  247,  247,  247,  227,  228,  229,  230,  231,  232,
 /*  9820 */   247,  234,  247,  247,  247,  247,  189,  247,  247,  242,
 /*  9830 */   193,  194,  247,  196,  197,  151,  247,  200,  247,  247,
 /*  9840 */   247,  247,  247,  247,  160,  161,  247,  247,  247,  247,
 /*  9850 */   247,  247,  247,  247,  247,  247,  247,  173,  247,  222,
 /*  9860 */   247,  247,  247,  247,  227,  228,  229,  230,  231,  232,
 /*  9870 */   247,  234,  247,  189,  247,  247,  247,  193,  194,  242,
 /*  9880 */   196,  197,  247,  247,  200,  247,  247,  247,  247,  247,
 /*  9890 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  151,
 /*  9900 */   247,  247,  247,  247,  247,  247,  222,  247,  160,  161,
 /*  9910 */   247,  227,  228,  229,  230,  231,  232,  247,  234,  247,
 /*  9920 */   247,  173,  247,  247,  247,  247,  242,  247,  247,  247,
 /*  9930 */   247,  247,  247,  247,  247,  247,  247,  189,  247,  247,
 /*  9940 */   247,  193,  194,  247,  196,  197,  247,  247,  200,  151,
 /*  9950 */   247,  247,  247,  247,  247,  247,  247,  247,  160,  161,
 /*  9960 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /*  9970 */   222,  173,  247,  247,  247,  227,  228,  229,  230,  231,
 /*  9980 */   232,  247,  234,  247,  247,  247,  247,  189,  247,  247,
 /*  9990 */   242,  193,  194,  247,  196,  197,  151,  247,  200,  247,
 /* 10000 */   247,  247,  247,  247,  247,  160,  161,  247,  247,  247,
 /* 10010 */   247,  247,  247,  247,  247,  247,  247,  247,  173,  247,
 /* 10020 */   222,  247,  247,  247,  247,  227,  228,  229,  230,  231,
 /* 10030 */   232,  247,  234,  247,  189,  247,  247,  247,  193,  194,
 /* 10040 */   242,  196,  197,  247,  247,  200,  247,  247,  247,  247,
 /* 10050 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10060 */   151,  247,  247,  247,  247,  247,  247,  222,  247,  160,
 /* 10070 */   161,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /* 10080 */   247,  247,  173,  247,  247,  247,  247,  242,  247,  247,
 /* 10090 */   247,  247,  247,  247,  247,  247,  247,  247,  189,  247,
 /* 10100 */   247,  247,  193,  194,  247,  196,  197,  247,  247,  200,
 /* 10110 */   151,  247,  247,  247,  247,  247,  247,  247,  247,  160,
 /* 10120 */   161,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10130 */   247,  222,  173,  247,  247,  247,  227,  228,  229,  230,
 /* 10140 */   231,  232,  247,  234,  247,  247,  247,  247,  189,  247,
 /* 10150 */   247,  242,  193,  194,  247,  196,  197,  151,  247,  200,
 /* 10160 */   247,  247,  247,  247,  247,  247,  160,  161,  247,  247,
 /* 10170 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  173,
 /* 10180 */   247,  222,  247,  247,  247,  247,  227,  228,  229,  230,
 /* 10190 */   231,  232,  247,  234,  247,  189,  247,  247,  247,  193,
 /* 10200 */   194,  242,  196,  197,  247,  247,  200,  247,  247,  247,
 /* 10210 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10220 */   247,  151,  247,  247,  247,  247,  247,  247,  222,  247,
 /* 10230 */   160,  161,  247,  227,  228,  229,  230,  231,  232,  247,
 /* 10240 */   234,  247,  247,  173,  247,  247,  247,  247,  242,  247,
 /* 10250 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  189,
 /* 10260 */   247,  247,  247,  193,  194,  247,  196,  197,  247,  247,
 /* 10270 */   200,  151,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10280 */   160,  161,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10290 */   247,  247,  222,  173,  247,  247,  247,  227,  228,  229,
 /* 10300 */   230,  231,  232,  247,  234,  247,  247,  247,  247,  189,
 /* 10310 */   247,  247,  242,  193,  194,  247,  196,  197,  151,  247,
 /* 10320 */   200,  247,  247,  247,  247,  247,  247,  160,  161,  247,
 /* 10330 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10340 */   173,  247,  222,  247,  247,  247,  247,  227,  228,  229,
 /* 10350 */   230,  231,  232,  247,  234,  247,  189,  247,  247,  247,
 /* 10360 */   193,  194,  242,  196,  197,  247,  247,  200,  247,  247,
 /* 10370 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10380 */   247,  247,  151,  247,  247,  247,  247,  247,  247,  222,
 /* 10390 */   247,  160,  161,  247,  227,  228,  229,  230,  231,  232,
 /* 10400 */   247,  234,  247,  247,  173,  247,  247,  247,  247,  242,
 /* 10410 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10420 */   189,  247,  247,  247,  193,  194,  247,  196,  197,  247,
 /* 10430 */   247,  200,  151,  247,  247,  247,  247,  247,  247,  247,
 /* 10440 */   247,  160,  161,  247,  247,  247,  247,  247,  247,  247,
 /* 10450 */   247,  247,  247,  222,  173,  247,  247,  247,  227,  228,
 /* 10460 */   229,  230,  231,  232,  247,  234,  247,  247,  247,  247,
 /* 10470 */   189,  247,  247,  242,  193,  194,  247,  196,  197,  151,
 /* 10480 */   247,  200,  247,  247,  247,  247,  247,  247,  160,  161,
 /* 10490 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10500 */   247,  173,  247,  222,  247,  247,  247,  247,  227,  228,
 /* 10510 */   229,  230,  231,  232,  247,  234,  247,  189,  247,  247,
 /* 10520 */   247,  193,  194,  242,  196,  197,  247,  247,  200,  247,
 /* 10530 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10540 */   247,  247,  247,  151,  247,  247,  247,  247,  247,  247,
 /* 10550 */   222,  247,  160,  161,  247,  227,  228,  229,  230,  231,
 /* 10560 */   232,  247,  234,  247,  247,  173,  247,  247,  247,  247,
 /* 10570 */   242,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10580 */   247,  189,  247,  247,  247,  193,  194,  247,  196,  197,
 /* 10590 */   247,  247,  200,  151,  247,  247,  247,  247,  247,  247,
 /* 10600 */   247,  247,  160,  161,  247,  247,  247,  247,  247,  247,
 /* 10610 */   247,  247,  247,  247,  222,  173,  247,  247,  247,  227,
 /* 10620 */   228,  229,  230,  231,  232,  247,  234,  247,  247,  247,
 /* 10630 */   247,  189,  247,  247,  242,  193,  194,  247,  196,  197,
 /* 10640 */   151,  247,  200,  247,  247,  247,  247,  247,  247,  160,
 /* 10650 */   161,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10660 */   247,  247,  173,  247,  222,  247,  247,  247,  247,  227,
 /* 10670 */   228,  229,  230,  231,  232,  247,  234,  247,  189,  247,
 /* 10680 */   247,  247,  193,  194,  242,  196,  197,  247,  247,  200,
 /* 10690 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10700 */   247,  247,  247,  247,  151,  247,  247,  247,  247,  247,
 /* 10710 */   247,  222,  247,  160,  161,  247,  227,  228,  229,  230,
 /* 10720 */   231,  232,  247,  234,  247,  247,  173,  247,  247,  247,
 /* 10730 */   247,  242,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10740 */   247,  247,  189,  247,  247,  247,  193,  194,  247,  196,
 /* 10750 */   197,  247,  247,  200,  151,  247,  247,  247,  247,  247,
 /* 10760 */   247,  247,  247,  160,  161,  247,  247,  247,  247,  247,
 /* 10770 */   247,  247,  247,  247,  247,  222,  173,  247,  247,  247,
 /* 10780 */   227,  228,  229,  230,  231,  232,  247,  234,  247,  247,
 /* 10790 */   247,  247,  189,  247,  247,  242,  193,  194,  247,  196,
 /* 10800 */   197,  151,  247,  200,  247,  247,  247,  247,  247,  247,
 /* 10810 */   160,  161,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10820 */   247,  247,  247,  173,  247,  222,  247,  247,  247,  247,
 /* 10830 */   227,  228,  229,  230,  231,  232,  247,  234,  247,  189,
 /* 10840 */   247,  247,  247,  193,  194,  242,  196,  197,  247,  247,
 /* 10850 */   200,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 10860 */   247,  247,  247,  247,  247,  151,  247,  247,  247,  247,
 /* 10870 */   247,  247,  222,  247,  160,  161,  247,  227,  228,  229,
 /* 10880 */   230,  231,  232,  247,  234,  247,  247,  173,  247,  247,
 /* 10890 */   247,  247,  242,  247,  247,  247,  247,  247,  247,  247,
 /* 10900 */   247,  247,  247,  189,  247,  247,  247,  193,  194,  247,
 /* 10910 */   196,  197,  247,  247,  200,  151,  247,  247,  247,  247,
 /* 10920 */   247,  247,  247,  247,  160,  161,  247,  247,  247,  247,
 /* 10930 */   247,  247,  247,  247,  247,  247,  222,  173,  247,  247,
 /* 10940 */   247,  227,  228,  229,  230,  231,  232,  247,  234,  247,
 /* 10950 */   247,  247,  247,  189,  247,  247,  242,  193,  194,  247,
 /* 10960 */   196,  197,  151,  247,  200,  247,  247,  247,  247,  247,
 /* 10970 */   247,  160,  161,  247,  247,  247,  247,  247,  247,  247,
 /* 10980 */   247,  247,  247,  247,  173,  247,  222,  247,  247,  247,
 /* 10990 */   247,  227,  228,  229,  230,  231,  232,  247,  234,  247,
 /* 11000 */   189,  247,  247,  247,  193,  194,  242,  196,  197,  247,
 /* 11010 */   247,  200,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 11020 */   247,  247,  247,  247,  247,  247,  151,  247,  247,  247,
 /* 11030 */   247,  247,  247,  222,  247,  160,  161,  247,  227,  228,
 /* 11040 */   229,  230,  231,  232,  247,  234,  247,  247,  173,  247,
 /* 11050 */   247,  247,  247,  242,  247,  247,  247,  247,  247,  247,
 /* 11060 */   247,  247,  247,  247,  189,  247,  247,  247,  193,  194,
 /* 11070 */   247,  196,  197,  247,  247,  200,  151,  247,  247,  247,
 /* 11080 */   247,  247,  247,  247,  247,  160,  161,  247,  247,  247,
 /* 11090 */   247,  247,  247,  247,  247,  247,  247,  222,  173,  247,
 /* 11100 */   247,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /* 11110 */   247,  247,  247,  247,  189,  247,  247,  242,  193,  194,
 /* 11120 */   247,  196,  197,  151,  247,  200,  247,  247,  247,  247,
 /* 11130 */   247,  247,  160,  161,  247,  247,  247,  247,  247,  247,
 /* 11140 */   247,  247,  247,  247,  247,  173,  247,  222,  247,  247,
 /* 11150 */   247,  247,  227,  228,  229,  230,  231,  232,  247,  234,
 /* 11160 */   247,  189,  247,  247,  247,  193,  194,  242,  196,  197,
 /* 11170 */   247,  247,  200,  247,  247,  247,  247,  247,  247,  247,
 /* 11180 */   247,  247,  247,  247,  247,  247,  247,  151,  247,  247,
 /* 11190 */   247,  247,  247,  247,  222,  247,  160,  161,  247,  227,
 /* 11200 */   228,  229,  230,  231,  232,  247,  234,  247,  247,  173,
 /* 11210 */   247,  247,  247,  247,  242,  247,  247,  247,  247,  247,
 /* 11220 */   247,  247,  247,  247,  247,  189,  247,  247,  247,  193,
 /* 11230 */   194,  247,  196,  197,  247,  247,  200,  151,  247,  247,
 /* 11240 */   247,  247,  247,  247,  247,  247,  160,  161,  247,  247,
 /* 11250 */   247,  247,  247,  247,  247,  247,  247,  247,  222,  173,
 /* 11260 */   247,  247,  247,  227,  228,  229,  230,  231,  232,  247,
 /* 11270 */   234,  247,  247,  247,  247,  189,  247,  247,  242,  193,
 /* 11280 */   194,  247,  196,  197,  151,  247,  200,  247,  247,  247,
 /* 11290 */   247,  247,  247,  160,  161,  247,  247,  247,  247,  247,
 /* 11300 */   247,  247,  247,  247,  247,  247,  173,  247,  222,  247,
 /* 11310 */   247,  247,  247,  227,  228,  229,  230,  231,  232,  247,
 /* 11320 */   234,  247,  189,  247,  247,  247,  193,  194,  242,  196,
 /* 11330 */   197,  247,  247,  200,  247,  247,  247,  247,  247,  247,
 /* 11340 */   247,  247,  247,  247,  247,  247,  247,  247,  151,  247,
 /* 11350 */   247,  247,  247,  247,  247,  222,  247,  160,  161,  247,
 /* 11360 */   227,  228,  229,  230,  231,  232,  247,  234,  247,  247,
 /* 11370 */   173,  247,  247,  247,  247,  242,  247,  247,  247,  247,
 /* 11380 */   247,  247,  247,  247,  247,  247,  189,  247,  247,  247,
 /* 11390 */   193,  194,  247,  196,  197,  247,  247,  200,  151,  247,
 /* 11400 */   247,  247,  247,  247,  247,  247,  247,  160,  161,  247,
 /* 11410 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  222,
 /* 11420 */   173,  247,  247,  247,  227,  228,  229,  230,  231,  232,
 /* 11430 */   247,  234,  247,  247,  247,  247,  189,  247,  247,  242,
 /* 11440 */   193,  194,  247,  196,  197,  247,  247,  200,  247,  247,
 /* 11450 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
 /* 11460 */   247,  247,  247,  247,  247,  247,  247,  247,  247,  222,
 /* 11470 */   247,  247,  247,  247,  227,  228,  229,  230,  231,  232,
 /* 11480 */   247,  234,  247,  247,  247,  247,  247,  247,  247,  242,
);
    const YY_SHIFT_USE_DFLT = -116;
    const YY_SHIFT_MAX = 486;
    static public $yy_shift_ofst = array(
 /*     0 */  -116, 1172,  939,  594,  114,  229,  354,  479,  709, 1057,
 /*    10 */    -1,  824, 1172, 1287, 1172, 1172, 1412, 1412, 1912, 1787,
 /*    20 */  1662, 1537, 2027, 2027, 2027, 2257, 2257, 2257, 2257, 2257,
 /*    30 */  3292, 2257, 3407, 3407, 3407, 3407, 3407, 3407, 3177, 2947,
 /*    40 */  2142, 2717, 2602, 2487, 2372, 2832, 3062, 3407, 3407, 3407,
 /*    50 */  3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3522,
 /*    60 */  3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407,
 /*    70 */  3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407,
 /*    80 */  3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407,
 /*    90 */  3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407,
 /*   100 */  3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407,
 /*   110 */  3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407, 3407,
 /*   120 */  3407, 3407, 3407,  -57,  -57,  332,  332,  687,  -57,  877,
 /*   130 */   687,  687,  687,  687,  687,  419,  687,  419,  419,  419,
 /*   140 */   419,  419,  207,  419,  419,  419,  538,  538,  538,  647,
 /*   150 */   647,  647,  647,  149, 2254, 2139,  149,  149,  149,  149,
 /*   160 */   149,  149,  149,  149,  149,  149,  149,  149,  149,  149,
 /*   170 */   149,  878,  762,   92,  381,  381, 1094,  -23,  -23,  -23,
 /*   180 */   593, 1112, 1112, 3823, 4675, 4177, 4100, 3631,  175,  593,
 /*   190 */   474,  631,  653,  590,  360,  213,  287, 1112, 1203, 1278,
 /*   200 */  1232, 1257, 1204, 1255, 1258, 1129, 1278, 1204, 1197, 1196,
 /*   210 */  1219, 1110, 1094, 1112, 1130, 1112, 1130, 1184, 1091, 1098,
 /*   220 */  1129, 1112, -116, -116, -116, -116, -116, -116, -116, -116,
 /*   230 */  -116, -116, -116, -116, -116, -116, -116, -116, -116, -116,
 /*   240 */  -116, -116, -116, -116, -116, -116, -116, 4331, 4179, 3954,
 /*   250 */  4031, 4105, 5320, 4408, 5397, 5471, 5169, 5243, 4680, 4639,
 /*   260 */  4523, 5128, 4906, 4256, 4980, 5054, 4831, 4754, 4449, 4564,
 /*   270 */  5546, 5546, 5546, 5546, 5546, 5546, 5546, 5546, 5546, 5546,
 /*   280 */  5546, 5546, 5586, 5623,  -15,  -15,  -15,  -15,  -15,  -15,
 /*   290 */   -15,  -15,  -15,  -15,  -15,  -15,  -15,  -15,  -15, 2306,
 /*   300 */   344,  468, 2189, 2419, 2534, 2534, 2534, 2534, 2534, 3698,
 /*   310 */  4448, 4077, 3785, 1426,  106,  106,  106,  106,   85,   85,
 /*   320 */   221,  221,  221,  221,  221,    0, 1012, -115,  170, 1011,
 /*   330 */   295,  535,  968,  285,  652,  572,  703,  845,   61,  410,
 /*   340 */    55,  285,  480,  285,  621,  469,  223,  442,  623,  224,
 /*   350 */   133,  886,  567,  285, 1007, 1016, 1020, 1074,  507, 1018,
 /*   360 */   997,  974,  937,  985,  934,  941,  982,  983, 1022,  960,
 /*   370 */  1024, 1167, 1087, 1079, 1106, 1085, 1111, 1173, 1137, 1032,
 /*   380 */  1027, 1089, 1075, 1044, 1055, 1054, 1046, 1048,  992,  731,
 /*   390 */   664,  700,  694,  752,  827,  779,  722,  675,  657,  556,
 /*   400 */   517,  509,  587,  670,  646,  645,  784,  761,  945,  856,
 /*   410 */   834,  879,  908,  758,  918,  515,  862,  820,  812,  768,
 /*   420 */   818,  799,  812,  865,  852,  816,  871,  755,  815,  873,
 /*   430 */   905,  855,  875,  895,  666,  672,  579,  551,  656,  758,
 /*   440 */   781,  651,  702,  929, 1052, 1108, 1025, 1093, 1177, 1114,
 /*   450 */  1030, 1073, 1023, 1028,  956,  880,  471, 1017, 1021, 1013,
 /*   460 */   976, 1009, 1010, 1015,  471,  202,  557,  320,  471,  373,
 /*   470 */   466,  246,  559,  -40,  219,  162,   57,  515,   58,   98,
 /*   480 */    -4,  471,  526,  340, 1383, 1315, 1235,
);
    const YY_REDUCE_USE_DFLT = -193;
    const YY_REDUCE_MAX = 246;
    static public $yy_reduce_ofst = array(
 /*     0 */  -110, 3503, 3595, 3595, 3595, 3595, 3595, 3595, 3595, 3595,
 /*    10 */  3595, 3595, 3595, 3726, 3595, 3595, 5659, 5734, 5554, 3778,
 /*    20 */  5572, 6125, 6230, 6340, 6505, 5946, 5998, 6453, 6277, 5849,
 /*    30 */  5896, 6050, 6390, 6143, 5751, 6627, 6552, 6679, 10875, 10714,
 /*    40 */  11247, 10392, 9798, 8027, 7977, 8235, 8349, 8138, 8943, 8993,
 /*    50 */  9040, 9104, 8879, 8832, 8621, 8671, 8718, 8782, 9154, 9201,
 /*    60 */  9587, 9637, 9684, 9523, 9476, 9265, 9315, 9362, 9426, 8557,
 /*    70 */  8510, 7655, 7705, 7752, 7816, 7591, 7544, 7333, 7383, 7430,
 /*    80 */  7494, 7866, 7913, 8299, 7269, 8396, 8188, 8074, 9748, 10811,
 /*    90 */  11133, 10972, 9959, 10120, 10006, 10281, 10231, 10328, 10442, 10167,
 /*   100 */  9909, 9845, 10553, 10070, 10489, 10603, 11036, 11086, 11197, 10650,
 /*   110 */  10764, 10925, 8460, 6786, 6726, 7222, 7108, 7172, 7061, 6850,
 /*   120 */  7011, 6900, 6947, 3032, 2804, 2576, 4089, 2449, 4807, 4952,
 /*   130 */  4735, 4672, 4463, 4595, 5083, 5160, 6366, 6487, 5785, 5312,
 /*   140 */  5508, 3260, 6661, 6583, 6535, 6177, 1461, 1336, 1586,  512,
 /*   150 */   627,  403, -192,  405,  257,  257,  864,  145,  322,  -43,
 /*   160 */   552,  197,  635,  765,  753,  150,  420,  640,  667,  523,
 /*   170 */   782, -166, -166,  -51,   27,   90,  242,   95,  313, -135,
 /*   180 */   -28,  406,  548, 1115, 1077, 1077, 1077, 1077, 1101, 1102,
 /*   190 */  1100, 1104, 1146, 1097, 1140, 1141, 1136, 1132, 1133, 1166,
 /*   200 */  1148, 1143, 1183, 1142, 1131, 1105, 1135, 1152, 1080, 1076,
 /*   210 */  1001, 1040, 1033, 1035, 1039, 1031, 1000,  948, 1029, 1019,
 /*   220 */   975, 1038, 1043, 1042, 1113, 1095, 1116, 1122, 1109, 1099,
 /*   230 */  1124, 1096, 1157, 1092, 1067, 1066, 1065, 1064, 1069, 1036,
 /*   240 */  1086, 1084, 1034, 1149, 1156, 1228, 1175,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(),
        /* 1 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 2 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 117, 124, 134, 136, 137, 138, 139, 140, ),
        /* 3 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 4 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 5 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 119, 124, 134, 136, 137, 138, 139, 140, ),
        /* 6 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 118, 124, 134, 136, 137, 138, 139, 140, ),
        /* 7 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 8 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 123, 124, 134, 136, 137, 138, 139, 140, ),
        /* 9 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 10 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 11 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 12 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 13 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 14 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 15 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 66, 67, 71, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 97, 98, 99, 101, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 16 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 17 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 18 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 19 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 20 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 21 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 22 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 23 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 24 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 65, 72, 74, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 95, 96, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 25 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 26 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 27 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 28 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 29 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 30 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 31 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 32 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 33 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 34 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 35 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 36 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 37 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 38 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 73, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 39 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 40 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 74, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 41 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 74, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 42 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 43 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 44 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 45 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 74, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 46 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 47 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 48 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 49 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 50 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 51 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 52 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 53 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 54 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 55 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 56 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 57 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 58 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 59 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 60 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 61 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 62 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 63 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 64 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 65 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 66 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 67 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 68 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 69 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 70 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 71 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 72 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 73 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 74 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 75 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 76 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 77 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 78 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 79 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 80 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 81 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 82 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 83 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 84 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 85 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 86 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 87 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 88 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 89 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 90 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 91 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 92 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 93 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 94 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 95 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 96 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 97 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 98 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 99 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 100 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 101 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 102 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 103 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 104 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 105 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 106 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 107 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 108 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 109 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 110 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 111 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 112 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 113 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 114 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 115 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 116 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 117 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 118 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 119 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 120 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 121 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 122 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 72, 95, 98, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 124, 134, 136, 137, 138, 139, 140, ),
        /* 123 */ array(95, 98, 103, 124, ),
        /* 124 */ array(95, 98, 103, 124, ),
        /* 125 */ array(29, 95, 98, 124, ),
        /* 126 */ array(29, 95, 98, 124, ),
        /* 127 */ array(95, 98, 124, ),
        /* 128 */ array(95, 98, 103, 124, ),
        /* 129 */ array(75, 95, 98, 124, ),
        /* 130 */ array(95, 98, 124, ),
        /* 131 */ array(95, 98, 124, ),
        /* 132 */ array(95, 98, 124, ),
        /* 133 */ array(95, 98, 124, ),
        /* 134 */ array(95, 98, 124, ),
        /* 135 */ array(95, 98, 124, ),
        /* 136 */ array(95, 98, 124, ),
        /* 137 */ array(95, 98, 124, ),
        /* 138 */ array(95, 98, 124, ),
        /* 139 */ array(95, 98, 124, ),
        /* 140 */ array(95, 98, 124, ),
        /* 141 */ array(95, 98, 124, ),
        /* 142 */ array(60, 95, 98, 124, ),
        /* 143 */ array(95, 98, 124, ),
        /* 144 */ array(95, 98, 124, ),
        /* 145 */ array(95, 98, 124, ),
        /* 146 */ array(95, 98, 124, ),
        /* 147 */ array(95, 98, 124, ),
        /* 148 */ array(95, 98, 124, ),
        /* 149 */ array(75, 95, 98, 124, ),
        /* 150 */ array(75, 95, 98, 124, ),
        /* 151 */ array(75, 95, 98, 124, ),
        /* 152 */ array(75, 95, 98, 124, ),
        /* 153 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 154 */ array(65, 66, 67, 68, 69, 70, 76, 125, 126, ),
        /* 155 */ array(65, 66, 67, 68, 69, 70, 76, 125, 126, ),
        /* 156 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 157 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 158 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 159 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 160 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 161 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 162 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 163 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 164 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 165 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 166 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 167 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 168 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 169 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 170 */ array(98, 106, 107, 108, 109, 110, 111, 112, 113, 114, ),
        /* 171 */ array(95, 98, 124, ),
        /* 172 */ array(95, 98, 124, ),
        /* 173 */ array(95, 124, ),
        /* 174 */ array(73, 98, 106, ),
        /* 175 */ array(73, 98, 106, ),
        /* 176 */ array(94, ),
        /* 177 */ array(95, 124, ),
        /* 178 */ array(95, 124, ),
        /* 179 */ array(95, 124, ),
        /* 180 */ array(95, 124, ),
        /* 181 */ array(98, ),
        /* 182 */ array(98, ),
        /* 183 */ array(7, 8, 9, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 74, ),
        /* 184 */ array(59, 75, 76, 95, 98, 127, 128, 129, 130, 131, 132, 133, 135, 141, ),
        /* 185 */ array(59, 75, 76, 95, 98, 127, 128, 129, 130, 131, 132, 133, 135, 138, ),
        /* 186 */ array(59, 75, 76, 95, 98, 127, 128, 129, 130, 131, 132, 133, 135, 139, ),
        /* 187 */ array(59, 75, 76, 95, 98, 105, 127, 128, 129, 130, 131, 132, 133, 135, ),
        /* 188 */ array(65, 66, 67, 68, 69, 70, 97, ),
        /* 189 */ array(95, 124, ),
        /* 190 */ array(74, 75, ),
        /* 191 */ array(98, 106, ),
        /* 192 */ array(62, 63, ),
        /* 193 */ array(24, 74, ),
        /* 194 */ array(62, 63, ),
        /* 195 */ array(24, 75, ),
        /* 196 */ array(75, 109, ),
        /* 197 */ array(98, ),
        /* 198 */ array(100, ),
        /* 199 */ array(29, ),
        /* 200 */ array(102, ),
        /* 201 */ array(74, ),
        /* 202 */ array(115, ),
        /* 203 */ array(95, ),
        /* 204 */ array(72, ),
        /* 205 */ array(72, ),
        /* 206 */ array(29, ),
        /* 207 */ array(115, ),
        /* 208 */ array(127, ),
        /* 209 */ array(127, ),
        /* 210 */ array(74, ),
        /* 211 */ array(95, ),
        /* 212 */ array(94, ),
        /* 213 */ array(98, ),
        /* 214 */ array(72, ),
        /* 215 */ array(98, ),
        /* 216 */ array(72, ),
        /* 217 */ array(6, ),
        /* 218 */ array(98, ),
        /* 219 */ array(100, ),
        /* 220 */ array(72, ),
        /* 221 */ array(98, ),
        /* 222 */ array(),
        /* 223 */ array(),
        /* 224 */ array(),
        /* 225 */ array(),
        /* 226 */ array(),
        /* 227 */ array(),
        /* 228 */ array(),
        /* 229 */ array(),
        /* 230 */ array(),
        /* 231 */ array(),
        /* 232 */ array(),
        /* 233 */ array(),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 248 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 249 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 250 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 73, ),
        /* 251 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 73, ),
        /* 252 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 253 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 115, ),
        /* 254 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 73, ),
        /* 255 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 74, ),
        /* 256 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 73, ),
        /* 257 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 258 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 73, ),
        /* 259 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 128, ),
        /* 260 */ array(7, 8, 9, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 261 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 115, ),
        /* 262 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 73, ),
        /* 263 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 74, ),
        /* 264 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 73, ),
        /* 265 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 73, ),
        /* 266 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 74, ),
        /* 267 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 268 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 73, ),
        /* 269 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 74, ),
        /* 270 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 271 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 272 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 273 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 274 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 275 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 276 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 277 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 278 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 279 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 280 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 281 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 282 */ array(8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 283 */ array(9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 284 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 285 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 286 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 287 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 288 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 289 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 290 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 291 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 292 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 293 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 294 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 295 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 296 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 297 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 298 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 299 */ array(25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 300 */ array(26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 301 */ array(27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 302 */ array(28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 303 */ array(29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 304 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 305 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 306 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 307 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 308 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 309 */ array(6, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, 73, ),
        /* 310 */ array(6, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, 73, ),
        /* 311 */ array(11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, 74, ),
        /* 312 */ array(11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, 91, ),
        /* 313 */ array(11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, ),
        /* 314 */ array(34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 315 */ array(34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 316 */ array(34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 317 */ array(34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 318 */ array(40, 41, 42, 43, 44, 45, 47, ),
        /* 319 */ array(40, 41, 42, 43, 44, 45, 47, ),
        /* 320 */ array(43, 44, 45, 47, ),
        /* 321 */ array(43, 44, 45, 47, ),
        /* 322 */ array(43, 44, 45, 47, ),
        /* 323 */ array(43, 44, 45, 47, ),
        /* 324 */ array(43, 44, 45, 47, ),
        /* 325 */ array(120, 121, 122, ),
        /* 326 */ array(59, 72, 75, ),
        /* 327 */ array(120, 121, 122, ),
        /* 328 */ array(76, 121, 122, ),
        /* 329 */ array(59, 72, 75, ),
        /* 330 */ array(95, 98, 129, ),
        /* 331 */ array(76, 121, 122, ),
        /* 332 */ array(6, 73, ),
        /* 333 */ array(59, 75, ),
        /* 334 */ array(6, 74, ),
        /* 335 */ array(29, 95, ),
        /* 336 */ array(6, 74, ),
        /* 337 */ array(6, 73, ),
        /* 338 */ array(29, 95, ),
        /* 339 */ array(59, 75, ),
        /* 340 */ array(59, 127, ),
        /* 341 */ array(59, 75, ),
        /* 342 */ array(6, 72, ),
        /* 343 */ array(59, 75, ),
        /* 344 */ array(6, 73, ),
        /* 345 */ array(6, 73, ),
        /* 346 */ array(6, 74, ),
        /* 347 */ array(6, 74, ),
        /* 348 */ array(6, 73, ),
        /* 349 */ array(49, 50, ),
        /* 350 */ array(72, 116, ),
        /* 351 */ array(6, 73, ),
        /* 352 */ array(6, 74, ),
        /* 353 */ array(59, 75, ),
        /* 354 */ array(73, ),
        /* 355 */ array(73, ),
        /* 356 */ array(74, ),
        /* 357 */ array(11, ),
        /* 358 */ array(95, ),
        /* 359 */ array(72, ),
        /* 360 */ array(75, ),
        /* 361 */ array(95, ),
        /* 362 */ array(75, ),
        /* 363 */ array(24, ),
        /* 364 */ array(73, ),
        /* 365 */ array(74, ),
        /* 366 */ array(75, ),
        /* 367 */ array(72, ),
        /* 368 */ array(11, ),
        /* 369 */ array(94, ),
        /* 370 */ array(72, ),
        /* 371 */ array(11, ),
        /* 372 */ array(72, ),
        /* 373 */ array(72, ),
        /* 374 */ array(73, ),
        /* 375 */ array(95, ),
        /* 376 */ array(74, ),
        /* 377 */ array(11, ),
        /* 378 */ array(11, ),
        /* 379 */ array(98, ),
        /* 380 */ array(75, ),
        /* 381 */ array(11, ),
        /* 382 */ array(24, ),
        /* 383 */ array(72, ),
        /* 384 */ array(72, ),
        /* 385 */ array(72, ),
        /* 386 */ array(74, ),
        /* 387 */ array(73, ),
        /* 388 */ array(6, ),
        /* 389 */ array(72, ),
        /* 390 */ array(115, ),
        /* 391 */ array(73, ),
        /* 392 */ array(115, ),
        /* 393 */ array(72, ),
        /* 394 */ array(11, ),
        /* 395 */ array(73, ),
        /* 396 */ array(109, ),
        /* 397 */ array(76, ),
        /* 398 */ array(6, ),
        /* 399 */ array(72, ),
        /* 400 */ array(95, ),
        /* 401 */ array(116, ),
        /* 402 */ array(98, ),
        /* 403 */ array(98, ),
        /* 404 */ array(97, ),
        /* 405 */ array(75, ),
        /* 406 */ array(74, ),
        /* 407 */ array(98, ),
        /* 408 */ array(11, ),
        /* 409 */ array(95, ),
        /* 410 */ array(116, ),
        /* 411 */ array(91, ),
        /* 412 */ array(73, ),
        /* 413 */ array(72, ),
        /* 414 */ array(59, ),
        /* 415 */ array(6, ),
        /* 416 */ array(64, ),
        /* 417 */ array(73, ),
        /* 418 */ array(75, ),
        /* 419 */ array(98, ),
        /* 420 */ array(76, ),
        /* 421 */ array(98, ),
        /* 422 */ array(75, ),
        /* 423 */ array(74, ),
        /* 424 */ array(72, ),
        /* 425 */ array(99, ),
        /* 426 */ array(74, ),
        /* 427 */ array(128, ),
        /* 428 */ array(73, ),
        /* 429 */ array(73, ),
        /* 430 */ array(73, ),
        /* 431 */ array(116, ),
        /* 432 */ array(72, ),
        /* 433 */ array(73, ),
        /* 434 */ array(72, ),
        /* 435 */ array(72, ),
        /* 436 */ array(74, ),
        /* 437 */ array(72, ),
        /* 438 */ array(116, ),
        /* 439 */ array(72, ),
        /* 440 */ array(72, ),
        /* 441 */ array(127, ),
        /* 442 */ array(98, ),
        /* 443 */ array(74, ),
        /* 444 */ array(73, ),
        /* 445 */ array(11, ),
        /* 446 */ array(76, ),
        /* 447 */ array(11, ),
        /* 448 */ array(6, ),
        /* 449 */ array(72, ),
        /* 450 */ array(127, ),
        /* 451 */ array(99, ),
        /* 452 */ array(72, ),
        /* 453 */ array(11, ),
        /* 454 */ array(74, ),
        /* 455 */ array(128, ),
        /* 456 */ array(47, ),
        /* 457 */ array(75, ),
        /* 458 */ array(72, ),
        /* 459 */ array(78, ),
        /* 460 */ array(98, ),
        /* 461 */ array(72, ),
        /* 462 */ array(72, ),
        /* 463 */ array(73, ),
        /* 464 */ array(47, ),
        /* 465 */ array(74, ),
        /* 466 */ array(24, ),
        /* 467 */ array(72, ),
        /* 468 */ array(47, ),
        /* 469 */ array(72, ),
        /* 470 */ array(72, ),
        /* 471 */ array(74, ),
        /* 472 */ array(11, ),
        /* 473 */ array(98, ),
        /* 474 */ array(74, ),
        /* 475 */ array(11, ),
        /* 476 */ array(95, ),
        /* 477 */ array(6, ),
        /* 478 */ array(73, ),
        /* 479 */ array(116, ),
        /* 480 */ array(73, ),
        /* 481 */ array(47, ),
        /* 482 */ array(74, ),
        /* 483 */ array(73, ),
        /* 484 */ array(6, ),
        /* 485 */ array(72, ),
        /* 486 */ array(128, ),
        /* 487 */ array(),
        /* 488 */ array(),
        /* 489 */ array(),
        /* 490 */ array(),
        /* 491 */ array(),
        /* 492 */ array(),
        /* 493 */ array(),
        /* 494 */ array(),
        /* 495 */ array(),
        /* 496 */ array(),
        /* 497 */ array(),
        /* 498 */ array(),
        /* 499 */ array(),
        /* 500 */ array(),
        /* 501 */ array(),
        /* 502 */ array(),
        /* 503 */ array(),
        /* 504 */ array(),
        /* 505 */ array(),
        /* 506 */ array(),
        /* 507 */ array(),
        /* 508 */ array(),
        /* 509 */ array(),
        /* 510 */ array(),
        /* 511 */ array(),
        /* 512 */ array(),
        /* 513 */ array(),
        /* 514 */ array(),
        /* 515 */ array(),
        /* 516 */ array(),
        /* 517 */ array(),
        /* 518 */ array(),
        /* 519 */ array(),
        /* 520 */ array(),
        /* 521 */ array(),
        /* 522 */ array(),
        /* 523 */ array(),
        /* 524 */ array(),
        /* 525 */ array(),
        /* 526 */ array(),
        /* 527 */ array(),
        /* 528 */ array(),
        /* 529 */ array(),
        /* 530 */ array(),
        /* 531 */ array(),
        /* 532 */ array(),
        /* 533 */ array(),
        /* 534 */ array(),
        /* 535 */ array(),
        /* 536 */ array(),
        /* 537 */ array(),
        /* 538 */ array(),
        /* 539 */ array(),
        /* 540 */ array(),
        /* 541 */ array(),
        /* 542 */ array(),
        /* 543 */ array(),
        /* 544 */ array(),
        /* 545 */ array(),
        /* 546 */ array(),
        /* 547 */ array(),
        /* 548 */ array(),
        /* 549 */ array(),
        /* 550 */ array(),
        /* 551 */ array(),
        /* 552 */ array(),
        /* 553 */ array(),
        /* 554 */ array(),
        /* 555 */ array(),
        /* 556 */ array(),
        /* 557 */ array(),
        /* 558 */ array(),
        /* 559 */ array(),
        /* 560 */ array(),
        /* 561 */ array(),
        /* 562 */ array(),
        /* 563 */ array(),
        /* 564 */ array(),
        /* 565 */ array(),
        /* 566 */ array(),
        /* 567 */ array(),
        /* 568 */ array(),
        /* 569 */ array(),
        /* 570 */ array(),
        /* 571 */ array(),
        /* 572 */ array(),
        /* 573 */ array(),
        /* 574 */ array(),
        /* 575 */ array(),
        /* 576 */ array(),
        /* 577 */ array(),
        /* 578 */ array(),
        /* 579 */ array(),
        /* 580 */ array(),
        /* 581 */ array(),
        /* 582 */ array(),
        /* 583 */ array(),
        /* 584 */ array(),
        /* 585 */ array(),
        /* 586 */ array(),
        /* 587 */ array(),
        /* 588 */ array(),
        /* 589 */ array(),
        /* 590 */ array(),
        /* 591 */ array(),
        /* 592 */ array(),
        /* 593 */ array(),
        /* 594 */ array(),
        /* 595 */ array(),
        /* 596 */ array(),
        /* 597 */ array(),
        /* 598 */ array(),
        /* 599 */ array(),
        /* 600 */ array(),
        /* 601 */ array(),
        /* 602 */ array(),
        /* 603 */ array(),
        /* 604 */ array(),
        /* 605 */ array(),
        /* 606 */ array(),
        /* 607 */ array(),
        /* 608 */ array(),
        /* 609 */ array(),
        /* 610 */ array(),
        /* 611 */ array(),
        /* 612 */ array(),
        /* 613 */ array(),
        /* 614 */ array(),
        /* 615 */ array(),
        /* 616 */ array(),
        /* 617 */ array(),
        /* 618 */ array(),
        /* 619 */ array(),
        /* 620 */ array(),
        /* 621 */ array(),
        /* 622 */ array(),
        /* 623 */ array(),
        /* 624 */ array(),
        /* 625 */ array(),
        /* 626 */ array(),
        /* 627 */ array(),
        /* 628 */ array(),
        /* 629 */ array(),
        /* 630 */ array(),
        /* 631 */ array(),
        /* 632 */ array(),
        /* 633 */ array(),
        /* 634 */ array(),
        /* 635 */ array(),
        /* 636 */ array(),
        /* 637 */ array(),
        /* 638 */ array(),
        /* 639 */ array(),
        /* 640 */ array(),
        /* 641 */ array(),
        /* 642 */ array(),
        /* 643 */ array(),
        /* 644 */ array(),
        /* 645 */ array(),
        /* 646 */ array(),
        /* 647 */ array(),
        /* 648 */ array(),
        /* 649 */ array(),
        /* 650 */ array(),
        /* 651 */ array(),
        /* 652 */ array(),
        /* 653 */ array(),
        /* 654 */ array(),
        /* 655 */ array(),
        /* 656 */ array(),
        /* 657 */ array(),
        /* 658 */ array(),
        /* 659 */ array(),
        /* 660 */ array(),
        /* 661 */ array(),
        /* 662 */ array(),
        /* 663 */ array(),
        /* 664 */ array(),
        /* 665 */ array(),
        /* 666 */ array(),
        /* 667 */ array(),
        /* 668 */ array(),
        /* 669 */ array(),
        /* 670 */ array(),
        /* 671 */ array(),
        /* 672 */ array(),
        /* 673 */ array(),
        /* 674 */ array(),
        /* 675 */ array(),
        /* 676 */ array(),
        /* 677 */ array(),
        /* 678 */ array(),
        /* 679 */ array(),
        /* 680 */ array(),
        /* 681 */ array(),
        /* 682 */ array(),
        /* 683 */ array(),
        /* 684 */ array(),
        /* 685 */ array(),
        /* 686 */ array(),
        /* 687 */ array(),
        /* 688 */ array(),
        /* 689 */ array(),
        /* 690 */ array(),
        /* 691 */ array(),
        /* 692 */ array(),
        /* 693 */ array(),
        /* 694 */ array(),
        /* 695 */ array(),
        /* 696 */ array(),
        /* 697 */ array(),
);
    static public $yy_default = array(
 /*     0 */   700,  872, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*    10 */  1039, 1039,  871,  698,  864,  875, 1039, 1039, 1039, 1039,
 /*    20 */  1039, 1039, 1039, 1039, 1039,  890,  890,  890,  890,  890,
 /*    30 */   973,  890, 1034, 1034, 1034, 1039,  957,  957, 1039, 1039,
 /*    40 */  1039, 1039, 1039, 1039, 1039, 1039, 1031, 1039, 1039, 1039,
 /*    50 */  1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*    60 */  1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*    70 */  1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*    80 */  1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*    90 */  1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*   100 */  1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*   110 */  1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*   120 */  1039, 1039, 1039,  971,  971, 1039, 1039, 1039,  971, 1039,
 /*   130 */  1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*   140 */  1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*   150 */  1039, 1039, 1039,  841,  916,  916, 1039, 1039, 1039,  840,
 /*   160 */  1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*   170 */  1039, 1039, 1039, 1039,  888,  888,  734, 1039, 1039, 1039,
 /*   180 */  1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,  913, 1039,
 /*   190 */  1039,  888,  874, 1039,  876, 1039, 1039, 1039,  753, 1038,
 /*   200 */   757,  865,  848, 1039,  832,  942, 1038,  848, 1024,  936,
 /*   210 */   865, 1039,  733, 1039, 1030, 1039, 1030, 1032, 1039,  756,
 /*   220 */   942, 1039, 1027,  993,  739,  739,  739,  739,  907,  993,
 /*   230 */   739,  870,  993,  739,  739,  739,  739,  739,  739,  993,
 /*   240 */   739,  739,  865,  865,  939,  739,  907, 1039, 1039, 1039,
 /*   250 */  1039, 1039, 1039,  978, 1039, 1039, 1039, 1039, 1039, 1039,
 /*   260 */  1039,  975, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*   270 */  1035, 1006, 1005, 1036,  979, 1003, 1002,  956,  977,  927,
 /*   280 */  1039,  926,  786,  788,  764,  828,  763,  787,  778,  772,
 /*   290 */   773,  769,  770,  779,  774,  771,  777,  775,  776,  814,
 /*   300 */   784,  785,  789,  791,  805,  806,  790,  804,  807,  933,
 /*   310 */   933,  933,  933,  933,  808,  811,  810,  809,  799,  798,
 /*   320 */   794,  801,  800,  793,  792, 1039,  949, 1039, 1039,  948,
 /*   330 */  1039, 1039, 1039,  943, 1039, 1039, 1039, 1039, 1039,  958,
 /*   340 */   994,  949, 1039,  948,  762, 1039, 1039, 1039,  762, 1039,
 /*   350 */  1015, 1039, 1039,  944, 1039, 1039, 1039,  884, 1039, 1039,
 /*   360 */  1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,  920, 1039,
 /*   370 */  1039,  879, 1039, 1039, 1039, 1039,  762,  922,  902, 1039,
 /*   380 */  1039,  904, 1039, 1039, 1039, 1039, 1039, 1039,  877, 1039,
 /*   390 */   843, 1039,  845, 1039,  883, 1039, 1039, 1039,  839, 1039,
 /*   400 */  1039,  835, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*   410 */  1022,  762, 1039, 1009, 1016,  758, 1039, 1039,  966, 1039,
 /*   420 */  1039, 1039,  965, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
 /*   430 */  1039, 1039, 1039, 1039, 1039, 1010, 1039, 1039, 1039, 1039,
 /*   440 */  1039,  937, 1039, 1039, 1039, 1039, 1039, 1039,  889,  945,
 /*   450 */  1025, 1039, 1039, 1039, 1039, 1039,  802, 1039, 1039, 1039,
 /*   460 */  1039, 1039, 1039, 1039,  795, 1039, 1039, 1039,  796, 1039,
 /*   470 */  1039, 1039, 1039, 1039, 1039,  880, 1039,  755, 1039, 1039,
 /*   480 */  1039,  797, 1039, 1039, 1033, 1039, 1039,  868,  854,  847,
 /*   490 */   860,  728,  906,  747,  861,  862,  851,  867,  849,  850,
 /*   500 */   852,  908,  752,  917,  914,  919,  925,  760,  759, 1010,
 /*   510 */   918,  748,  911,  910,  881,  887,  885,  886,  708,  749,
 /*   520 */   750,  856,  873,  923,  921,  858,  853,  857,  855,  735,
 /*   530 */   754,  924,  751,  912, 1037,  882,  909,  869,  765,  954,
 /*   540 */   953,  833,  955,  946,  893,  950,  947,  829,  997,  989,
 /*   550 */   988,  987,  990,  991,  996,  995,  992,  934, 1001, 1008,
 /*   560 */  1000, 1012, 1007,  896,  974,  998, 1013, 1011, 1014, 1017,
 /*   570 */  1016, 1004, 1018,  999, 1021, 1020, 1019,  986,  985,  780,
 /*   580 */   768,  767,  782,  781,  940,  938,  935,  762,  761,  702,
 /*   590 */   701,  699,  703,  704,  707,  706,  705,  783,  812,  824,
 /*   600 */   831,  823,  825,  827,  984,  983,  982,  822,  821,  815,
 /*   610 */   813,  803,  816,  817,  820,  819,  818,  826,  972,  903,
 /*   620 */   844,  842,  905,  722,  725,  724,  723,  838,  837,  933,
 /*   630 */   901,  900,  898,  721,  836,  846,  834,  931,  932,  740,
 /*   640 */   738,  737,  741,  742,  745,  744,  743,  732,  736,  930,
 /*   650 */   929,  726,  928,  727,  731,  730,  729,  899,  897,  964,
 /*   660 */   963,  962, 1026, 1028, 1029,  941,  951,  959,  961,  976,
 /*   670 */   981,  980,  830,  952,  960, 1023,  945,  766,  967,  715,
 /*   680 */   714,  713,  716,  717,  720,  719,  718,  866,  863,  968,
 /*   690 */   970,  969,  709,  710,  859,  712,  711,  746,
);
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    PHPTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is PHPTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    PHPARG_DECL      A global declaration for the %extra_argument
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
    const YYNOCODE = 248;
    const YYSTACKDEPTH = 100;
    const PHPARG_DECL = 'lex';
    const YYNSTATE = 698;
    const YYNRULE = 341;
    const YYERRORSYMBOL = 142;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    /** The next table maps tokens into fallback tokens.  If a construct
     * like the following:
     * 
     *      %fallback ID X Y Z.
     *
     * appears in the grammer, then ID becomes a fallback token for X, Y,
     * and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
     * but it does not parse, the type of the token is changed to ID and
     * the parse is retried before an error is thrown.
     */
    static public $yyFallback = array(
    );
    /**
     * Turn parser tracing on by giving a stream to which to write the trace
     * and a prompt to preface each trace message.  Tracing is turned off
     * by making either argument NULL 
     *
     * Inputs:
     * 
     * - A stream resource to which trace output should be written.
     *   If NULL, then tracing is turned off.
     * - A prefix string written at the beginning of every
     *   line of trace output.  If NULL, then tracing is
     *   turned off.
     *
     * Outputs:
     * 
     * - None.
     * @param resource
     * @param string
     */
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    /**
     * @var int
     */
    public $yyidx;                    /* Index of top element in stack */
    /**
     * @var int
     */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    //public $???????;      /* A place to hold %extra_argument - dynamically added */
    /**
     * @var array
     */
    public $yystack = array();  /* The parser's stack */

    /**
     * For tracing shifts, the names of all terminals and nonterminals
     * are required.  The following table supplies these names
     * @var array
     */
    static public $yyTokenName = array( 
  '$',             'T_INCLUDE',     'T_INCLUDE_ONCE',  'T_EVAL',      
  'T_REQUIRE',     'T_REQUIRE_ONCE',  'COMMA',         'T_LOGICAL_OR',
  'T_LOGICAL_XOR',  'T_LOGICAL_AND',  'T_PRINT',       'EQUALS',      
  'T_PLUS_EQUAL',  'T_MINUS_EQUAL',  'T_MUL_EQUAL',   'T_DIV_EQUAL', 
  'T_CONCAT_EQUAL',  'T_MOD_EQUAL',   'T_AND_EQUAL',   'T_OR_EQUAL',  
  'T_XOR_EQUAL',   'T_SL_EQUAL',    'T_SR_EQUAL',    'QUESTION',    
  'COLON',         'T_BOOLEAN_OR',  'T_BOOLEAN_AND',  'BAR',         
  'CARAT',         'AMPERSAND',     'T_IS_EQUAL',    'T_IS_NOT_EQUAL',
  'T_IS_IDENTICAL',  'T_IS_NOT_IDENTICAL',  'LESSTHAN',      'T_IS_SMALLER_OR_EQUAL',
  'GREATERTHAN',   'T_IS_GREATER_OR_EQUAL',  'T_SL',          'T_SR',        
  'PLUS',          'MINUS',         'DOT',           'TIMES',       
  'DIVIDE',        'PERCENT',       'EXCLAM',        'T_INSTANCEOF',
  'TILDE',         'T_INC',         'T_DEC',         'T_INT_CAST',  
  'T_DOUBLE_CAST',  'T_STRING_CAST',  'T_ARRAY_CAST',  'T_OBJECT_CAST',
  'T_BOOL_CAST',   'T_UNSET_CAST',  'AT',            'LBRACKET',    
  'T_NEW',         'T_CLONE',       'T_ELSEIF',      'T_ELSE',      
  'T_ENDIF',       'T_STATIC',      'T_ABSTRACT',    'T_FINAL',     
  'T_PRIVATE',     'T_PROTECTED',   'T_PUBLIC',      'T_HALT_COMPILER',
  'LPAREN',        'RPAREN',        'SEMI',          'LCURLY',      
  'RCURLY',        'T_IF',          'T_WHILE',       'T_DO',        
  'T_FOR',         'T_SWITCH',      'T_BREAK',       'T_CONTINUE',  
  'T_RETURN',      'T_GLOBAL',      'T_ECHO',        'T_INLINE_HTML',
  'T_USE',         'T_UNSET',       'T_FOREACH',     'T_AS',        
  'T_DECLARE',     'T_TRY',         'T_CATCH',       'T_VARIABLE',  
  'T_THROW',       'T_FUNCTION',    'T_STRING',      'T_CLASS',     
  'T_EXTENDS',     'T_INTERFACE',   'T_IMPLEMENTS',  'T_LIST',      
  'T_EXIT',        'BACKQUOTE',     'T_ARRAY',       'T_LNUMBER',   
  'T_DNUMBER',     'T_CONSTANT_ENCAPSED_STRING',  'T_LINE',        'T_FILE',      
  'T_CLASS_C',     'T_METHOD_C',    'T_FUNC_C',      'T_DOUBLE_ARROW',
  'T_PAAMAYIM_NEKUDOTAYIM',  'T_ENDFOR',      'T_ENDFOREACH',  'T_ENDDECLARE',
  'T_ENDSWITCH',   'T_CASE',        'T_DEFAULT',     'T_ENDWHILE',  
  'DOLLAR',        'T_VAR',         'T_CONST',       'T_OBJECT_OPERATOR',
  'RBRACKET',      'T_NUM_STRING',  'T_ENCAPSED_AND_WHITESPACE',  'T_CHARACTER', 
  'T_BAD_CHARACTER',  'T_DOLLAR_OPEN_CURLY_BRACES',  'T_STRING_VARNAME',  'T_CURLY_OPEN',
  'T_ISSET',       'T_EMPTY',       'DOUBLEQUOTE',   'SINGLEQUOTE', 
  'T_START_HEREDOC',  'T_END_HEREDOC',  'error',         'start',       
  'top_statement_list',  'top_statement',  'statement',     'function_declaration_statement',
  'class_declaration_statement',  'unticked_statement',  'inner_statement_list',  'expr',        
  'elseif_list',   'else_single',   'new_elseif_list',  'new_else_single',
  'while_statement',  'for_expr',      'for_statement',  'switch_case_list',
  'expr_without_variable',  'variable',      'global_var_list',  'static_var_list',
  'echo_expr_list',  'use_filename',  'unset_variables',  'foreach_variable',
  'foreach_optional_arg',  'foreach_statement',  'w_variable',    'declare_list',
  'declare_statement',  'fully_qualified_class_name',  'additional_catches',  'non_empty_additional_catches',
  'additional_catch',  'inner_statement',  'unticked_function_declaration_statement',  'unticked_class_declaration_statement',
  'is_reference',  'parameter_list',  'class_entry_type',  'extends_from',
  'implements_list',  'class_statement_list',  'interface_entry',  'interface_extends_list',
  'interface_list',  'r_variable',    'assignment_list',  'class_name_reference',
  'ctor_arguments',  'rw_variable',   'internal_functions_in_yacc',  'exit_expr',   
  'scalar',        'expr_without_variable_t_array',  'array_pair_list',  'encaps_list', 
  'common_scalar',  'static_scalar',  'static_scalar_t_array',  'static_array_pair_list',
  'static_class_constant',  'non_empty_static_array_pair_list',  'case_list',     'case_separator',
  'non_empty_parameter_list',  'optional_class_type',  'function_call_parameter_list',  'non_empty_function_call_parameter_list',
  'global_var',    'class_statement',  'variable_modifiers',  'class_variable_declaration',
  'class_constant_declaration',  'method_modifiers',  'method_body',   'non_empty_member_modifiers',
  'member_modifier',  'unset_variable',  'base_variable_with_function_calls',  'object_property',
  'method_or_not',  'variable_properties',  'variable_property',  'variable_without_objects',
  'reference_variable',  'simple_indirect_reference',  'static_member',  'base_variable',
  'function_call',  'dim_offset',    'compound_variable',  'object_dim_list',
  'variable_name',  'assignment_list_element',  'non_empty_array_pair_list',  'possible_comma',
  'encaps_var',    'isset_variables',  'class_constant',  'dynamic_class_name_reference',
  'dynamic_class_name_variable_properties',  'dynamic_class_name_variable_property',  'non_empty_for_expr',
    );

    /**
     * For tracing reduce actions, the names of all rules are required.
     * @var array
     */
    static public $yyRuleName = array(
 /*   0 */ "start ::= top_statement_list",
 /*   1 */ "top_statement_list ::= top_statement_list top_statement",
 /*   2 */ "top_statement_list ::=",
 /*   3 */ "top_statement ::= statement",
 /*   4 */ "top_statement ::= function_declaration_statement",
 /*   5 */ "top_statement ::= class_declaration_statement",
 /*   6 */ "top_statement ::= T_HALT_COMPILER LPAREN RPAREN SEMI",
 /*   7 */ "statement ::= unticked_statement",
 /*   8 */ "unticked_statement ::= LCURLY inner_statement_list RCURLY",
 /*   9 */ "unticked_statement ::= T_IF LPAREN expr RPAREN statement elseif_list else_single",
 /*  10 */ "unticked_statement ::= T_IF LPAREN expr RPAREN COLON inner_statement_list new_elseif_list new_else_single T_ENDIF SEMI",
 /*  11 */ "unticked_statement ::= T_WHILE LPAREN expr RPAREN while_statement",
 /*  12 */ "unticked_statement ::= T_DO statement T_WHILE LPAREN expr RPAREN SEMI",
 /*  13 */ "unticked_statement ::= T_FOR LPAREN for_expr COLON for_expr SEMI for_expr RPAREN for_statement",
 /*  14 */ "unticked_statement ::= T_SWITCH LPAREN expr RPAREN switch_case_list",
 /*  15 */ "unticked_statement ::= T_BREAK SEMI",
 /*  16 */ "unticked_statement ::= T_BREAK expr SEMI",
 /*  17 */ "unticked_statement ::= T_CONTINUE SEMI",
 /*  18 */ "unticked_statement ::= T_CONTINUE expr SEMI",
 /*  19 */ "unticked_statement ::= T_RETURN SEMI",
 /*  20 */ "unticked_statement ::= T_RETURN expr_without_variable SEMI",
 /*  21 */ "unticked_statement ::= T_RETURN variable SEMI",
 /*  22 */ "unticked_statement ::= T_GLOBAL global_var_list SEMI",
 /*  23 */ "unticked_statement ::= T_STATIC static_var_list SEMI",
 /*  24 */ "unticked_statement ::= T_ECHO echo_expr_list SEMI",
 /*  25 */ "unticked_statement ::= T_INLINE_HTML",
 /*  26 */ "unticked_statement ::= expr SEMI",
 /*  27 */ "unticked_statement ::= T_USE use_filename SEMI",
 /*  28 */ "unticked_statement ::= T_UNSET LPAREN unset_variables LPAREN SEMI",
 /*  29 */ "unticked_statement ::= T_FOREACH LPAREN variable T_AS foreach_variable foreach_optional_arg RPAREN foreach_statement",
 /*  30 */ "unticked_statement ::= T_FOREACH LPAREN expr_without_variable T_AS w_variable foreach_optional_arg RPAREN foreach_statement",
 /*  31 */ "unticked_statement ::= T_DECLARE LPAREN declare_list RPAREN declare_statement",
 /*  32 */ "unticked_statement ::= SEMI",
 /*  33 */ "unticked_statement ::= T_TRY LCURLY inner_statement_list RCURLY T_CATCH LPAREN fully_qualified_class_name T_VARIABLE RPAREN LCURLY inner_statement_list RCURLY additional_catches",
 /*  34 */ "unticked_statement ::= T_THROW expr SEMI",
 /*  35 */ "additional_catches ::= non_empty_additional_catches",
 /*  36 */ "additional_catches ::=",
 /*  37 */ "non_empty_additional_catches ::= additional_catch",
 /*  38 */ "non_empty_additional_catches ::= non_empty_additional_catches additional_catch",
 /*  39 */ "additional_catch ::= T_CATCH LPAREN fully_qualified_class_name T_VARIABLE RPAREN LCURLY inner_statement_list RCURLY",
 /*  40 */ "inner_statement_list ::= inner_statement_list inner_statement",
 /*  41 */ "inner_statement_list ::=",
 /*  42 */ "inner_statement ::= statement",
 /*  43 */ "inner_statement ::= function_declaration_statement",
 /*  44 */ "inner_statement ::= class_declaration_statement",
 /*  45 */ "inner_statement ::= T_HALT_COMPILER LPAREN RPAREN SEMI",
 /*  46 */ "function_declaration_statement ::= unticked_function_declaration_statement",
 /*  47 */ "class_declaration_statement ::= unticked_class_declaration_statement",
 /*  48 */ "unticked_function_declaration_statement ::= T_FUNCTION is_reference T_STRING LPAREN parameter_list RPAREN LCURLY inner_statement_list RCURLY",
 /*  49 */ "unticked_class_declaration_statement ::= class_entry_type T_STRING extends_from implements_list LCURLY class_statement_list RCURLY",
 /*  50 */ "unticked_class_declaration_statement ::= interface_entry T_STRING interface_extends_list LCURLY class_statement_list RCURLY",
 /*  51 */ "class_entry_type ::= T_CLASS",
 /*  52 */ "class_entry_type ::= T_ABSTRACT T_CLASS",
 /*  53 */ "class_entry_type ::= T_FINAL T_CLASS",
 /*  54 */ "extends_from ::= T_EXTENDS fully_qualified_class_name",
 /*  55 */ "extends_from ::=",
 /*  56 */ "interface_entry ::= T_INTERFACE",
 /*  57 */ "interface_extends_list ::= T_EXTENDS interface_list",
 /*  58 */ "interface_extends_list ::=",
 /*  59 */ "implements_list ::=",
 /*  60 */ "implements_list ::= T_IMPLEMENTS interface_list",
 /*  61 */ "interface_list ::= fully_qualified_class_name",
 /*  62 */ "interface_list ::= interface_list COMMA fully_qualified_class_name",
 /*  63 */ "expr ::= r_variable",
 /*  64 */ "expr ::= expr_without_variable",
 /*  65 */ "expr_without_variable ::= T_LIST LPAREN assignment_list RPAREN EQUALS expr",
 /*  66 */ "expr_without_variable ::= variable EQUALS expr",
 /*  67 */ "expr_without_variable ::= variable EQUALS AMPERSAND variable",
 /*  68 */ "expr_without_variable ::= variable EQUALS AMPERSAND T_NEW class_name_reference ctor_arguments",
 /*  69 */ "expr_without_variable ::= T_NEW class_name_reference ctor_arguments",
 /*  70 */ "expr_without_variable ::= T_CLONE expr",
 /*  71 */ "expr_without_variable ::= variable T_PLUS_EQUAL expr",
 /*  72 */ "expr_without_variable ::= variable T_MINUS_EQUAL expr",
 /*  73 */ "expr_without_variable ::= variable T_MUL_EQUAL expr",
 /*  74 */ "expr_without_variable ::= variable T_DIV_EQUAL expr",
 /*  75 */ "expr_without_variable ::= variable T_CONCAT_EQUAL expr",
 /*  76 */ "expr_without_variable ::= variable T_MOD_EQUAL expr",
 /*  77 */ "expr_without_variable ::= variable T_AND_EQUAL expr",
 /*  78 */ "expr_without_variable ::= variable T_OR_EQUAL expr",
 /*  79 */ "expr_without_variable ::= variable T_XOR_EQUAL expr",
 /*  80 */ "expr_without_variable ::= variable T_SL_EQUAL expr",
 /*  81 */ "expr_without_variable ::= variable T_SR_EQUAL expr",
 /*  82 */ "expr_without_variable ::= rw_variable T_INC",
 /*  83 */ "expr_without_variable ::= T_INC rw_variable",
 /*  84 */ "expr_without_variable ::= rw_variable T_DEC",
 /*  85 */ "expr_without_variable ::= T_DEC rw_variable",
 /*  86 */ "expr_without_variable ::= expr T_BOOLEAN_OR expr",
 /*  87 */ "expr_without_variable ::= expr T_BOOLEAN_AND expr",
 /*  88 */ "expr_without_variable ::= expr T_LOGICAL_OR expr",
 /*  89 */ "expr_without_variable ::= expr T_LOGICAL_AND expr",
 /*  90 */ "expr_without_variable ::= expr T_LOGICAL_XOR expr",
 /*  91 */ "expr_without_variable ::= expr BAR expr",
 /*  92 */ "expr_without_variable ::= expr AMPERSAND expr",
 /*  93 */ "expr_without_variable ::= expr CARAT expr",
 /*  94 */ "expr_without_variable ::= expr DOT expr",
 /*  95 */ "expr_without_variable ::= expr PLUS expr",
 /*  96 */ "expr_without_variable ::= expr MINUS expr",
 /*  97 */ "expr_without_variable ::= expr TIMES expr",
 /*  98 */ "expr_without_variable ::= expr DIVIDE expr",
 /*  99 */ "expr_without_variable ::= expr PERCENT expr",
 /* 100 */ "expr_without_variable ::= expr T_SL expr",
 /* 101 */ "expr_without_variable ::= expr T_SR expr",
 /* 102 */ "expr_without_variable ::= PLUS expr",
 /* 103 */ "expr_without_variable ::= MINUS expr",
 /* 104 */ "expr_without_variable ::= EXCLAM expr",
 /* 105 */ "expr_without_variable ::= TILDE expr",
 /* 106 */ "expr_without_variable ::= expr T_IS_IDENTICAL expr",
 /* 107 */ "expr_without_variable ::= expr T_IS_NOT_IDENTICAL expr",
 /* 108 */ "expr_without_variable ::= expr T_IS_EQUAL expr",
 /* 109 */ "expr_without_variable ::= expr T_IS_NOT_EQUAL expr",
 /* 110 */ "expr_without_variable ::= expr LESSTHAN expr",
 /* 111 */ "expr_without_variable ::= expr T_IS_SMALLER_OR_EQUAL expr",
 /* 112 */ "expr_without_variable ::= expr GREATERTHAN expr",
 /* 113 */ "expr_without_variable ::= expr T_IS_GREATER_OR_EQUAL expr",
 /* 114 */ "expr_without_variable ::= expr T_INSTANCEOF class_name_reference",
 /* 115 */ "expr_without_variable ::= LPAREN expr RPAREN",
 /* 116 */ "expr_without_variable ::= expr QUESTION expr COLON expr",
 /* 117 */ "expr_without_variable ::= internal_functions_in_yacc",
 /* 118 */ "expr_without_variable ::= T_INT_CAST expr",
 /* 119 */ "expr_without_variable ::= T_DOUBLE_CAST expr",
 /* 120 */ "expr_without_variable ::= T_STRING_CAST expr",
 /* 121 */ "expr_without_variable ::= T_ARRAY_CAST expr",
 /* 122 */ "expr_without_variable ::= T_OBJECT_CAST expr",
 /* 123 */ "expr_without_variable ::= T_BOOL_CAST expr",
 /* 124 */ "expr_without_variable ::= T_UNSET_CAST expr",
 /* 125 */ "expr_without_variable ::= T_EXIT exit_expr",
 /* 126 */ "expr_without_variable ::= AT expr",
 /* 127 */ "expr_without_variable ::= scalar",
 /* 128 */ "expr_without_variable ::= expr_without_variable_t_array LPAREN array_pair_list RPAREN",
 /* 129 */ "expr_without_variable ::= BACKQUOTE encaps_list BACKQUOTE",
 /* 130 */ "expr_without_variable ::= T_PRINT expr",
 /* 131 */ "expr_without_variable_t_array ::= T_ARRAY",
 /* 132 */ "exit_expr ::= LPAREN RPAREN",
 /* 133 */ "exit_expr ::= LPAREN expr RPAREN",
 /* 134 */ "exit_expr ::=",
 /* 135 */ "common_scalar ::= T_LNUMBER|T_DNUMBER|T_CONSTANT_ENCAPSED_STRING|T_LINE|T_FILE|T_CLASS_C|T_METHOD_C|T_FUNC_C",
 /* 136 */ "static_scalar ::= common_scalar",
 /* 137 */ "static_scalar ::= T_STRING",
 /* 138 */ "static_scalar ::= static_scalar_t_array LPAREN static_array_pair_list RPAREN",
 /* 139 */ "static_scalar ::= static_class_constant",
 /* 140 */ "static_scalar_t_array ::= T_ARRAY",
 /* 141 */ "static_array_pair_list ::= non_empty_static_array_pair_list",
 /* 142 */ "static_array_pair_list ::= non_empty_static_array_pair_list COMMA",
 /* 143 */ "static_array_pair_list ::=",
 /* 144 */ "non_empty_static_array_pair_list ::= non_empty_static_array_pair_list COMMA static_scalar T_DOUBLE_ARROW static_scalar",
 /* 145 */ "non_empty_static_array_pair_list ::= non_empty_static_array_pair_list COMMA static_scalar",
 /* 146 */ "non_empty_static_array_pair_list ::= static_scalar T_DOUBLE_ARROW static_scalar",
 /* 147 */ "non_empty_static_array_pair_list ::= static_scalar",
 /* 148 */ "static_class_constant ::= T_STRING T_PAAMAYIM_NEKUDOTAYIM T_STRING",
 /* 149 */ "foreach_optional_arg ::= T_DOUBLE_ARROW foreach_variable",
 /* 150 */ "foreach_optional_arg ::=",
 /* 151 */ "foreach_variable ::= w_variable",
 /* 152 */ "foreach_variable ::= AMPERSAND w_variable",
 /* 153 */ "for_statement ::= statement",
 /* 154 */ "for_statement ::= COLON inner_statement_list T_ENDFOR SEMI",
 /* 155 */ "foreach_statement ::= statement",
 /* 156 */ "foreach_statement ::= COLON inner_statement_list T_ENDFOREACH SEMI",
 /* 157 */ "declare_statement ::= statement",
 /* 158 */ "declare_statement ::= COLON inner_statement_list T_ENDDECLARE SEMI",
 /* 159 */ "declare_list ::= T_STRING EQUALS static_scalar",
 /* 160 */ "declare_list ::= declare_list COMMA T_STRING EQUALS static_scalar",
 /* 161 */ "switch_case_list ::= LCURLY case_list RCURLY",
 /* 162 */ "switch_case_list ::= LCURLY SEMI case_list RCURLY",
 /* 163 */ "switch_case_list ::= COLON case_list T_ENDSWITCH SEMI",
 /* 164 */ "switch_case_list ::= COLON SEMI case_list T_ENDSWITCH SEMI",
 /* 165 */ "case_list ::= case_list T_CASE expr case_separator",
 /* 166 */ "case_list ::= case_list T_DEFAULT case_separator inner_statement_list",
 /* 167 */ "case_list ::=",
 /* 168 */ "case_separator ::= COLON|SEMI",
 /* 169 */ "while_statement ::= statement",
 /* 170 */ "while_statement ::= COLON inner_statement_list T_ENDWHILE SEMI",
 /* 171 */ "elseif_list ::= elseif_list T_ELSEIF LPAREN expr RPAREN statement",
 /* 172 */ "elseif_list ::=",
 /* 173 */ "new_elseif_list ::= new_elseif_list T_ELSEIF LPAREN expr RPAREN COLON inner_statement_list",
 /* 174 */ "new_elseif_list ::=",
 /* 175 */ "else_single ::= T_ELSE statement",
 /* 176 */ "else_single ::=",
 /* 177 */ "new_else_single ::= T_ELSE COLON inner_statement_list",
 /* 178 */ "new_else_single ::=",
 /* 179 */ "parameter_list ::= non_empty_parameter_list",
 /* 180 */ "parameter_list ::=",
 /* 181 */ "non_empty_parameter_list ::= optional_class_type T_VARIABLE",
 /* 182 */ "non_empty_parameter_list ::= optional_class_type AMPERSAND T_VARIABLE",
 /* 183 */ "non_empty_parameter_list ::= optional_class_type AMPERSAND T_VARIABLE EQUALS static_scalar",
 /* 184 */ "non_empty_parameter_list ::= optional_class_type T_VARIABLE EQUALS static_scalar",
 /* 185 */ "non_empty_parameter_list ::= non_empty_parameter_list COMMA optional_class_type T_VARIABLE",
 /* 186 */ "non_empty_parameter_list ::= non_empty_parameter_list COMMA optional_class_type AMPERSAND T_VARIABLE",
 /* 187 */ "non_empty_parameter_list ::= non_empty_parameter_list COMMA optional_class_type AMPERSAND T_VARIABLE EQUALS static_scalar",
 /* 188 */ "non_empty_parameter_list ::= non_empty_parameter_list COMMA optional_class_type T_VARIABLE EQUALS static_scalar",
 /* 189 */ "optional_class_type ::= T_STRING|T_ARRAY",
 /* 190 */ "optional_class_type ::=",
 /* 191 */ "function_call_parameter_list ::= non_empty_function_call_parameter_list",
 /* 192 */ "function_call_parameter_list ::=",
 /* 193 */ "non_empty_function_call_parameter_list ::= expr_without_variable",
 /* 194 */ "non_empty_function_call_parameter_list ::= variable",
 /* 195 */ "non_empty_function_call_parameter_list ::= AMPERSAND w_variable",
 /* 196 */ "non_empty_function_call_parameter_list ::= non_empty_function_call_parameter_list COMMA expr_without_variable",
 /* 197 */ "non_empty_function_call_parameter_list ::= non_empty_function_call_parameter_list COMMA variable",
 /* 198 */ "non_empty_function_call_parameter_list ::= non_empty_function_call_parameter_list COMMA AMPERSAND w_variable",
 /* 199 */ "global_var_list ::= global_var_list COMMA global_var",
 /* 200 */ "global_var_list ::= global_var",
 /* 201 */ "global_var ::= T_VARIABLE",
 /* 202 */ "global_var ::= DOLLAR r_variable",
 /* 203 */ "global_var ::= DOLLAR LCURLY expr RCURLY",
 /* 204 */ "static_var_list ::= static_var_list COMMA T_VARIABLE",
 /* 205 */ "static_var_list ::= static_var_list COMMA T_VARIABLE EQUALS static_scalar",
 /* 206 */ "static_var_list ::= T_VARIABLE",
 /* 207 */ "static_var_list ::= T_VARIABLE EQUALS static_scalar",
 /* 208 */ "class_statement_list ::= class_statement_list class_statement",
 /* 209 */ "class_statement_list ::=",
 /* 210 */ "class_statement ::= variable_modifiers class_variable_declaration SEMI",
 /* 211 */ "class_statement ::= class_constant_declaration SEMI",
 /* 212 */ "class_statement ::= method_modifiers T_FUNCTION is_reference T_STRING LPAREN parameter_list RPAREN method_body",
 /* 213 */ "method_body ::= SEMI",
 /* 214 */ "method_body ::= LCURLY inner_statement_list RCURLY",
 /* 215 */ "variable_modifiers ::= non_empty_member_modifiers",
 /* 216 */ "variable_modifiers ::= T_VAR",
 /* 217 */ "method_modifiers ::= non_empty_member_modifiers",
 /* 218 */ "method_modifiers ::=",
 /* 219 */ "non_empty_member_modifiers ::= member_modifier",
 /* 220 */ "non_empty_member_modifiers ::= non_empty_member_modifiers member_modifier",
 /* 221 */ "member_modifier ::= T_PUBLIC|T_PROTECTED|T_PRIVATE|T_STATIC|T_ABSTRACT|T_FINAL",
 /* 222 */ "class_variable_declaration ::= class_variable_declaration COMMA T_VARIABLE",
 /* 223 */ "class_variable_declaration ::= class_variable_declaration COMMA T_VARIABLE EQUALS static_scalar",
 /* 224 */ "class_variable_declaration ::= T_VARIABLE",
 /* 225 */ "class_variable_declaration ::= T_VARIABLE EQUALS static_scalar",
 /* 226 */ "class_constant_declaration ::= class_constant_declaration COMMA T_STRING EQUALS static_scalar",
 /* 227 */ "class_constant_declaration ::= T_CONST T_STRING EQUALS static_scalar",
 /* 228 */ "echo_expr_list ::= echo_expr_list COMMA expr",
 /* 229 */ "echo_expr_list ::= expr",
 /* 230 */ "unset_variables ::= unset_variable",
 /* 231 */ "unset_variables ::= unset_variables COMMA unset_variable",
 /* 232 */ "unset_variable ::= variable",
 /* 233 */ "use_filename ::= T_CONSTANT_ENCAPSED_STRING",
 /* 234 */ "use_filename ::= LCURLY T_CONSTANT_ENCAPSED_STRING RCURLY",
 /* 235 */ "r_variable ::= variable",
 /* 236 */ "w_variable ::= variable",
 /* 237 */ "rw_variable ::= variable",
 /* 238 */ "variable ::= base_variable_with_function_calls T_OBJECT_OPERATOR object_property method_or_not variable_properties",
 /* 239 */ "variable ::= base_variable_with_function_calls",
 /* 240 */ "variable_properties ::= variable_properties variable_property",
 /* 241 */ "variable_properties ::=",
 /* 242 */ "variable_property ::= T_OBJECT_OPERATOR object_property method_or_not",
 /* 243 */ "method_or_not ::= LPAREN function_call_parameter_list RPAREN",
 /* 244 */ "method_or_not ::=",
 /* 245 */ "variable_without_objects ::= reference_variable",
 /* 246 */ "variable_without_objects ::= simple_indirect_reference reference_variable",
 /* 247 */ "static_member ::= fully_qualified_class_name T_PAAMAYIM_NEKUDOTAYIM variable_without_objects",
 /* 248 */ "base_variable_with_function_calls ::= base_variable",
 /* 249 */ "base_variable_with_function_calls ::= function_call",
 /* 250 */ "base_variable ::= reference_variable",
 /* 251 */ "base_variable ::= simple_indirect_reference reference_variable",
 /* 252 */ "base_variable ::= static_member",
 /* 253 */ "reference_variable ::= reference_variable LBRACKET dim_offset RBRACKET",
 /* 254 */ "reference_variable ::= reference_variable LCURLY expr RCURLY",
 /* 255 */ "reference_variable ::= compound_variable",
 /* 256 */ "compound_variable ::= T_VARIABLE",
 /* 257 */ "compound_variable ::= DOLLAR LCURLY expr RCURLY",
 /* 258 */ "dim_offset ::= expr",
 /* 259 */ "dim_offset ::=",
 /* 260 */ "object_property ::= object_dim_list",
 /* 261 */ "object_property ::= variable_without_objects",
 /* 262 */ "object_dim_list ::= object_dim_list LBRACKET dim_offset RBRACKET",
 /* 263 */ "object_dim_list ::= object_dim_list LCURLY expr RCURLY",
 /* 264 */ "object_dim_list ::= variable_name",
 /* 265 */ "variable_name ::= T_STRING",
 /* 266 */ "variable_name ::= LCURLY expr RCURLY",
 /* 267 */ "simple_indirect_reference ::= DOLLAR",
 /* 268 */ "simple_indirect_reference ::= simple_indirect_reference DOLLAR",
 /* 269 */ "assignment_list ::= assignment_list COMMA assignment_list_element",
 /* 270 */ "assignment_list ::= assignment_list_element",
 /* 271 */ "assignment_list_element ::= variable",
 /* 272 */ "assignment_list_element ::= T_LIST LPAREN assignment_list RPAREN",
 /* 273 */ "assignment_list_element ::=",
 /* 274 */ "array_pair_list ::= non_empty_array_pair_list possible_comma",
 /* 275 */ "array_pair_list ::=",
 /* 276 */ "non_empty_array_pair_list ::= expr T_DOUBLE_ARROW AMPERSAND w_variable",
 /* 277 */ "non_empty_array_pair_list ::= expr",
 /* 278 */ "non_empty_array_pair_list ::= AMPERSAND w_variable",
 /* 279 */ "non_empty_array_pair_list ::= non_empty_array_pair_list COMMA expr T_DOUBLE_ARROW expr",
 /* 280 */ "non_empty_array_pair_list ::= non_empty_array_pair_list COMMA expr",
 /* 281 */ "non_empty_array_pair_list ::= expr T_DOUBLE_ARROW expr",
 /* 282 */ "non_empty_array_pair_list ::= non_empty_array_pair_list COMMA expr T_DOUBLE_ARROW AMPERSAND w_variable",
 /* 283 */ "non_empty_array_pair_list ::= non_empty_array_pair_list COMMA AMPERSAND w_variable",
 /* 284 */ "encaps_list ::= encaps_list encaps_var",
 /* 285 */ "encaps_list ::= encaps_list T_STRING",
 /* 286 */ "encaps_list ::= encaps_list T_NUM_STRING",
 /* 287 */ "encaps_list ::= encaps_list T_ENCAPSED_AND_WHITESPACE",
 /* 288 */ "encaps_list ::= encaps_list T_CHARACTER",
 /* 289 */ "encaps_list ::= encaps_list T_BAD_CHARACTER",
 /* 290 */ "encaps_list ::= encaps_list LBRACKET",
 /* 291 */ "encaps_list ::= encaps_list RBRACKET",
 /* 292 */ "encaps_list ::= encaps_list LCURLY",
 /* 293 */ "encaps_list ::= encaps_list RCURLY",
 /* 294 */ "encaps_list ::= encaps_list T_OBJECT_OPERATOR",
 /* 295 */ "encaps_list ::=",
 /* 296 */ "encaps_var ::= T_VARIABLE",
 /* 297 */ "encaps_var ::= T_VARIABLE LBRACKET T_STRING|T_NUM_STRING|T_VARIABLE RBRACKET",
 /* 298 */ "encaps_var ::= T_VARIABLE T_OBJECT_OPERATOR T_STRING",
 /* 299 */ "encaps_var ::= T_DOLLAR_OPEN_CURLY_BRACES expr RCURLY",
 /* 300 */ "encaps_var ::= T_DOLLAR_OPEN_CURLY_BRACES T_STRING_VARNAME LBRACKET expr RBRACKET RCURLY",
 /* 301 */ "encaps_var ::= T_CURLY_OPEN variable RCURLY",
 /* 302 */ "internal_functions_in_yacc ::= T_ISSET LPAREN isset_variables RPAREN",
 /* 303 */ "internal_functions_in_yacc ::= T_EMPTY LPAREN variable RPAREN",
 /* 304 */ "internal_functions_in_yacc ::= T_INCLUDE expr",
 /* 305 */ "internal_functions_in_yacc ::= T_INCLUDE_ONCE expr",
 /* 306 */ "internal_functions_in_yacc ::= T_EVAL LPAREN expr RPAREN",
 /* 307 */ "internal_functions_in_yacc ::= T_REQUIRE expr",
 /* 308 */ "internal_functions_in_yacc ::= T_REQUIRE_ONCE expr",
 /* 309 */ "isset_variables ::= variable",
 /* 310 */ "isset_variables ::= isset_variables COMMA variable",
 /* 311 */ "class_constant ::= fully_qualified_class_name T_PAAMAYIM_NEKUDOTAYIM T_STRING",
 /* 312 */ "fully_qualified_class_name ::= T_STRING",
 /* 313 */ "function_call ::= T_STRING LPAREN function_call_parameter_list RPAREN",
 /* 314 */ "function_call ::= fully_qualified_class_name T_PAAMAYIM_NEKUDOTAYIM T_STRING LPAREN function_call_parameter_list RPAREN",
 /* 315 */ "function_call ::= fully_qualified_class_name T_PAAMAYIM_NEKUDOTAYIM variable_without_objects LPAREN function_call_parameter_list RPAREN",
 /* 316 */ "function_call ::= variable_without_objects LPAREN function_call_parameter_list RPAREN",
 /* 317 */ "scalar ::= T_STRING",
 /* 318 */ "scalar ::= T_STRING_VARNAME",
 /* 319 */ "scalar ::= class_constant",
 /* 320 */ "scalar ::= common_scalar",
 /* 321 */ "scalar ::= DOUBLEQUOTE encaps_list DOUBLEQUOTE",
 /* 322 */ "scalar ::= SINGLEQUOTE encaps_list SINGLEQUOTE",
 /* 323 */ "scalar ::= T_START_HEREDOC encaps_list T_END_HEREDOC",
 /* 324 */ "class_name_reference ::= T_STRING",
 /* 325 */ "class_name_reference ::= dynamic_class_name_reference",
 /* 326 */ "dynamic_class_name_reference ::= base_variable T_OBJECT_OPERATOR object_property dynamic_class_name_variable_properties",
 /* 327 */ "dynamic_class_name_reference ::= base_variable",
 /* 328 */ "dynamic_class_name_variable_properties ::= dynamic_class_name_variable_properties dynamic_class_name_variable_property",
 /* 329 */ "dynamic_class_name_variable_properties ::=",
 /* 330 */ "dynamic_class_name_variable_property ::= T_OBJECT_OPERATOR object_property",
 /* 331 */ "ctor_arguments ::= LPAREN function_call_parameter_list RPAREN",
 /* 332 */ "ctor_arguments ::=",
 /* 333 */ "possible_comma ::= COMMA",
 /* 334 */ "possible_comma ::=",
 /* 335 */ "for_expr ::= non_empty_for_expr",
 /* 336 */ "for_expr ::=",
 /* 337 */ "non_empty_for_expr ::= non_empty_for_expr COMMA expr",
 /* 338 */ "non_empty_for_expr ::= expr",
 /* 339 */ "is_reference ::= AMPERSAND",
 /* 340 */ "is_reference ::=",
    );

    /**
     * This function returns the symbolic name associated with a token
     * value.
     * @param int
     * @return string
     */
    function tokenName($tokenType)
    {
        if ($tokenType > 0 && $tokenType < count(self::$yyTokenName)) {
            return self::$yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    /* The following function deletes the value associated with a
    ** symbol.  The symbol can be either a terminal or nonterminal.
    ** "yymajor" is the symbol code, and "yypminor" is a pointer to
    ** the value.
    */
    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is 
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    /**
     * Pop the parser's stack once.
     *
     * If there is a destructor routine associated with the token which
     * is popped from the stack, then call it.
     *
     * Return the major token number for the symbol popped.
     * @param PHPyyParser
     * @return int
     */
    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . self::$yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    /**
     * Deallocate and destroy a parser.  Destructors are all called for
     * all stack elements before shutting the parser down.
     */
    function __destruct()
    {
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected += self::$yyExpectedTokens[$nextstate];
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new PHPyyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new PHPyyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        return true;
    }

    /**
     * Find the appropriate action for a parser given the terminal
     * look-ahead token iLookAhead.
     *
     * If the look-ahead token is YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return YY_NO_ACTION.
     * @param int The look-ahead token
     */
    function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        self::$yyTokenName[$iLookAhead] . " => " .
                        self::$yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Find the appropriate action for a parser given the non-terminal
     * look-ahead token iLookAhead.
     *
     * If the look-ahead token is YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return YY_NO_ACTION.
     * @param int Current state number
     * @param int The look-ahead token
     */
    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Perform a shift action.
     * @param int The new state to shift in
     * @param int The major token to shift in
     * @param mixed the minor token to shift in
     */
    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            /* Here code is inserted which will execute if the parser
            ** stack ever overflows */
            return;
        }
        $yytos = new PHPyyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    self::$yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    /**
     * The following table contains information about every rule that
     * is used during the reduce.
     *
     * static const struct {
     *  YYCODETYPE lhs;         Symbol on the left-hand side of the rule
     *  unsigned char nrhs;     Number of right-hand side symbols in the rule
     * } 
     */
    static public $yyRuleInfo = array(
  array( 'lhs' => 143, 'rhs' => 1 ),
  array( 'lhs' => 144, 'rhs' => 2 ),
  array( 'lhs' => 144, 'rhs' => 0 ),
  array( 'lhs' => 145, 'rhs' => 1 ),
  array( 'lhs' => 145, 'rhs' => 1 ),
  array( 'lhs' => 145, 'rhs' => 1 ),
  array( 'lhs' => 145, 'rhs' => 4 ),
  array( 'lhs' => 146, 'rhs' => 1 ),
  array( 'lhs' => 149, 'rhs' => 3 ),
  array( 'lhs' => 149, 'rhs' => 7 ),
  array( 'lhs' => 149, 'rhs' => 10 ),
  array( 'lhs' => 149, 'rhs' => 5 ),
  array( 'lhs' => 149, 'rhs' => 7 ),
  array( 'lhs' => 149, 'rhs' => 9 ),
  array( 'lhs' => 149, 'rhs' => 5 ),
  array( 'lhs' => 149, 'rhs' => 2 ),
  array( 'lhs' => 149, 'rhs' => 3 ),
  array( 'lhs' => 149, 'rhs' => 2 ),
  array( 'lhs' => 149, 'rhs' => 3 ),
  array( 'lhs' => 149, 'rhs' => 2 ),
  array( 'lhs' => 149, 'rhs' => 3 ),
  array( 'lhs' => 149, 'rhs' => 3 ),
  array( 'lhs' => 149, 'rhs' => 3 ),
  array( 'lhs' => 149, 'rhs' => 3 ),
  array( 'lhs' => 149, 'rhs' => 3 ),
  array( 'lhs' => 149, 'rhs' => 1 ),
  array( 'lhs' => 149, 'rhs' => 2 ),
  array( 'lhs' => 149, 'rhs' => 3 ),
  array( 'lhs' => 149, 'rhs' => 5 ),
  array( 'lhs' => 149, 'rhs' => 8 ),
  array( 'lhs' => 149, 'rhs' => 8 ),
  array( 'lhs' => 149, 'rhs' => 5 ),
  array( 'lhs' => 149, 'rhs' => 1 ),
  array( 'lhs' => 149, 'rhs' => 13 ),
  array( 'lhs' => 149, 'rhs' => 3 ),
  array( 'lhs' => 174, 'rhs' => 1 ),
  array( 'lhs' => 174, 'rhs' => 0 ),
  array( 'lhs' => 175, 'rhs' => 1 ),
  array( 'lhs' => 175, 'rhs' => 2 ),
  array( 'lhs' => 176, 'rhs' => 8 ),
  array( 'lhs' => 150, 'rhs' => 2 ),
  array( 'lhs' => 150, 'rhs' => 0 ),
  array( 'lhs' => 177, 'rhs' => 1 ),
  array( 'lhs' => 177, 'rhs' => 1 ),
  array( 'lhs' => 177, 'rhs' => 1 ),
  array( 'lhs' => 177, 'rhs' => 4 ),
  array( 'lhs' => 147, 'rhs' => 1 ),
  array( 'lhs' => 148, 'rhs' => 1 ),
  array( 'lhs' => 178, 'rhs' => 9 ),
  array( 'lhs' => 179, 'rhs' => 7 ),
  array( 'lhs' => 179, 'rhs' => 6 ),
  array( 'lhs' => 182, 'rhs' => 1 ),
  array( 'lhs' => 182, 'rhs' => 2 ),
  array( 'lhs' => 182, 'rhs' => 2 ),
  array( 'lhs' => 183, 'rhs' => 2 ),
  array( 'lhs' => 183, 'rhs' => 0 ),
  array( 'lhs' => 186, 'rhs' => 1 ),
  array( 'lhs' => 187, 'rhs' => 2 ),
  array( 'lhs' => 187, 'rhs' => 0 ),
  array( 'lhs' => 184, 'rhs' => 0 ),
  array( 'lhs' => 184, 'rhs' => 2 ),
  array( 'lhs' => 188, 'rhs' => 1 ),
  array( 'lhs' => 188, 'rhs' => 3 ),
  array( 'lhs' => 151, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 1 ),
  array( 'lhs' => 160, 'rhs' => 6 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 4 ),
  array( 'lhs' => 160, 'rhs' => 6 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 5 ),
  array( 'lhs' => 160, 'rhs' => 1 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 1 ),
  array( 'lhs' => 160, 'rhs' => 4 ),
  array( 'lhs' => 160, 'rhs' => 3 ),
  array( 'lhs' => 160, 'rhs' => 2 ),
  array( 'lhs' => 197, 'rhs' => 1 ),
  array( 'lhs' => 195, 'rhs' => 2 ),
  array( 'lhs' => 195, 'rhs' => 3 ),
  array( 'lhs' => 195, 'rhs' => 0 ),
  array( 'lhs' => 200, 'rhs' => 1 ),
  array( 'lhs' => 201, 'rhs' => 1 ),
  array( 'lhs' => 201, 'rhs' => 1 ),
  array( 'lhs' => 201, 'rhs' => 4 ),
  array( 'lhs' => 201, 'rhs' => 1 ),
  array( 'lhs' => 202, 'rhs' => 1 ),
  array( 'lhs' => 203, 'rhs' => 1 ),
  array( 'lhs' => 203, 'rhs' => 2 ),
  array( 'lhs' => 203, 'rhs' => 0 ),
  array( 'lhs' => 205, 'rhs' => 5 ),
  array( 'lhs' => 205, 'rhs' => 3 ),
  array( 'lhs' => 205, 'rhs' => 3 ),
  array( 'lhs' => 205, 'rhs' => 1 ),
  array( 'lhs' => 204, 'rhs' => 3 ),
  array( 'lhs' => 168, 'rhs' => 2 ),
  array( 'lhs' => 168, 'rhs' => 0 ),
  array( 'lhs' => 167, 'rhs' => 1 ),
  array( 'lhs' => 167, 'rhs' => 2 ),
  array( 'lhs' => 158, 'rhs' => 1 ),
  array( 'lhs' => 158, 'rhs' => 4 ),
  array( 'lhs' => 169, 'rhs' => 1 ),
  array( 'lhs' => 169, 'rhs' => 4 ),
  array( 'lhs' => 172, 'rhs' => 1 ),
  array( 'lhs' => 172, 'rhs' => 4 ),
  array( 'lhs' => 171, 'rhs' => 3 ),
  array( 'lhs' => 171, 'rhs' => 5 ),
  array( 'lhs' => 159, 'rhs' => 3 ),
  array( 'lhs' => 159, 'rhs' => 4 ),
  array( 'lhs' => 159, 'rhs' => 4 ),
  array( 'lhs' => 159, 'rhs' => 5 ),
  array( 'lhs' => 206, 'rhs' => 4 ),
  array( 'lhs' => 206, 'rhs' => 4 ),
  array( 'lhs' => 206, 'rhs' => 0 ),
  array( 'lhs' => 207, 'rhs' => 1 ),
  array( 'lhs' => 156, 'rhs' => 1 ),
  array( 'lhs' => 156, 'rhs' => 4 ),
  array( 'lhs' => 152, 'rhs' => 6 ),
  array( 'lhs' => 152, 'rhs' => 0 ),
  array( 'lhs' => 154, 'rhs' => 7 ),
  array( 'lhs' => 154, 'rhs' => 0 ),
  array( 'lhs' => 153, 'rhs' => 2 ),
  array( 'lhs' => 153, 'rhs' => 0 ),
  array( 'lhs' => 155, 'rhs' => 3 ),
  array( 'lhs' => 155, 'rhs' => 0 ),
  array( 'lhs' => 181, 'rhs' => 1 ),
  array( 'lhs' => 181, 'rhs' => 0 ),
  array( 'lhs' => 208, 'rhs' => 2 ),
  array( 'lhs' => 208, 'rhs' => 3 ),
  array( 'lhs' => 208, 'rhs' => 5 ),
  array( 'lhs' => 208, 'rhs' => 4 ),
  array( 'lhs' => 208, 'rhs' => 4 ),
  array( 'lhs' => 208, 'rhs' => 5 ),
  array( 'lhs' => 208, 'rhs' => 7 ),
  array( 'lhs' => 208, 'rhs' => 6 ),
  array( 'lhs' => 209, 'rhs' => 1 ),
  array( 'lhs' => 209, 'rhs' => 0 ),
  array( 'lhs' => 210, 'rhs' => 1 ),
  array( 'lhs' => 210, 'rhs' => 0 ),
  array( 'lhs' => 211, 'rhs' => 1 ),
  array( 'lhs' => 211, 'rhs' => 1 ),
  array( 'lhs' => 211, 'rhs' => 2 ),
  array( 'lhs' => 211, 'rhs' => 3 ),
  array( 'lhs' => 211, 'rhs' => 3 ),
  array( 'lhs' => 211, 'rhs' => 4 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 1 ),
  array( 'lhs' => 212, 'rhs' => 1 ),
  array( 'lhs' => 212, 'rhs' => 2 ),
  array( 'lhs' => 212, 'rhs' => 4 ),
  array( 'lhs' => 163, 'rhs' => 3 ),
  array( 'lhs' => 163, 'rhs' => 5 ),
  array( 'lhs' => 163, 'rhs' => 1 ),
  array( 'lhs' => 163, 'rhs' => 3 ),
  array( 'lhs' => 185, 'rhs' => 2 ),
  array( 'lhs' => 185, 'rhs' => 0 ),
  array( 'lhs' => 213, 'rhs' => 3 ),
  array( 'lhs' => 213, 'rhs' => 2 ),
  array( 'lhs' => 213, 'rhs' => 8 ),
  array( 'lhs' => 218, 'rhs' => 1 ),
  array( 'lhs' => 218, 'rhs' => 3 ),
  array( 'lhs' => 214, 'rhs' => 1 ),
  array( 'lhs' => 214, 'rhs' => 1 ),
  array( 'lhs' => 217, 'rhs' => 1 ),
  array( 'lhs' => 217, 'rhs' => 0 ),
  array( 'lhs' => 219, 'rhs' => 1 ),
  array( 'lhs' => 219, 'rhs' => 2 ),
  array( 'lhs' => 220, 'rhs' => 1 ),
  array( 'lhs' => 215, 'rhs' => 3 ),
  array( 'lhs' => 215, 'rhs' => 5 ),
  array( 'lhs' => 215, 'rhs' => 1 ),
  array( 'lhs' => 215, 'rhs' => 3 ),
  array( 'lhs' => 216, 'rhs' => 5 ),
  array( 'lhs' => 216, 'rhs' => 4 ),
  array( 'lhs' => 164, 'rhs' => 3 ),
  array( 'lhs' => 164, 'rhs' => 1 ),
  array( 'lhs' => 166, 'rhs' => 1 ),
  array( 'lhs' => 166, 'rhs' => 3 ),
  array( 'lhs' => 221, 'rhs' => 1 ),
  array( 'lhs' => 165, 'rhs' => 1 ),
  array( 'lhs' => 165, 'rhs' => 3 ),
  array( 'lhs' => 189, 'rhs' => 1 ),
  array( 'lhs' => 170, 'rhs' => 1 ),
  array( 'lhs' => 193, 'rhs' => 1 ),
  array( 'lhs' => 161, 'rhs' => 5 ),
  array( 'lhs' => 161, 'rhs' => 1 ),
  array( 'lhs' => 225, 'rhs' => 2 ),
  array( 'lhs' => 225, 'rhs' => 0 ),
  array( 'lhs' => 226, 'rhs' => 3 ),
  array( 'lhs' => 224, 'rhs' => 3 ),
  array( 'lhs' => 224, 'rhs' => 0 ),
  array( 'lhs' => 227, 'rhs' => 1 ),
  array( 'lhs' => 227, 'rhs' => 2 ),
  array( 'lhs' => 230, 'rhs' => 3 ),
  array( 'lhs' => 222, 'rhs' => 1 ),
  array( 'lhs' => 222, 'rhs' => 1 ),
  array( 'lhs' => 231, 'rhs' => 1 ),
  array( 'lhs' => 231, 'rhs' => 2 ),
  array( 'lhs' => 231, 'rhs' => 1 ),
  array( 'lhs' => 228, 'rhs' => 4 ),
  array( 'lhs' => 228, 'rhs' => 4 ),
  array( 'lhs' => 228, 'rhs' => 1 ),
  array( 'lhs' => 234, 'rhs' => 1 ),
  array( 'lhs' => 234, 'rhs' => 4 ),
  array( 'lhs' => 233, 'rhs' => 1 ),
  array( 'lhs' => 233, 'rhs' => 0 ),
  array( 'lhs' => 223, 'rhs' => 1 ),
  array( 'lhs' => 223, 'rhs' => 1 ),
  array( 'lhs' => 235, 'rhs' => 4 ),
  array( 'lhs' => 235, 'rhs' => 4 ),
  array( 'lhs' => 235, 'rhs' => 1 ),
  array( 'lhs' => 236, 'rhs' => 1 ),
  array( 'lhs' => 236, 'rhs' => 3 ),
  array( 'lhs' => 229, 'rhs' => 1 ),
  array( 'lhs' => 229, 'rhs' => 2 ),
  array( 'lhs' => 190, 'rhs' => 3 ),
  array( 'lhs' => 190, 'rhs' => 1 ),
  array( 'lhs' => 237, 'rhs' => 1 ),
  array( 'lhs' => 237, 'rhs' => 4 ),
  array( 'lhs' => 237, 'rhs' => 0 ),
  array( 'lhs' => 198, 'rhs' => 2 ),
  array( 'lhs' => 198, 'rhs' => 0 ),
  array( 'lhs' => 238, 'rhs' => 4 ),
  array( 'lhs' => 238, 'rhs' => 1 ),
  array( 'lhs' => 238, 'rhs' => 2 ),
  array( 'lhs' => 238, 'rhs' => 5 ),
  array( 'lhs' => 238, 'rhs' => 3 ),
  array( 'lhs' => 238, 'rhs' => 3 ),
  array( 'lhs' => 238, 'rhs' => 6 ),
  array( 'lhs' => 238, 'rhs' => 4 ),
  array( 'lhs' => 199, 'rhs' => 2 ),
  array( 'lhs' => 199, 'rhs' => 2 ),
  array( 'lhs' => 199, 'rhs' => 2 ),
  array( 'lhs' => 199, 'rhs' => 2 ),
  array( 'lhs' => 199, 'rhs' => 2 ),
  array( 'lhs' => 199, 'rhs' => 2 ),
  array( 'lhs' => 199, 'rhs' => 2 ),
  array( 'lhs' => 199, 'rhs' => 2 ),
  array( 'lhs' => 199, 'rhs' => 2 ),
  array( 'lhs' => 199, 'rhs' => 2 ),
  array( 'lhs' => 199, 'rhs' => 2 ),
  array( 'lhs' => 199, 'rhs' => 0 ),
  array( 'lhs' => 240, 'rhs' => 1 ),
  array( 'lhs' => 240, 'rhs' => 4 ),
  array( 'lhs' => 240, 'rhs' => 3 ),
  array( 'lhs' => 240, 'rhs' => 3 ),
  array( 'lhs' => 240, 'rhs' => 6 ),
  array( 'lhs' => 240, 'rhs' => 3 ),
  array( 'lhs' => 194, 'rhs' => 4 ),
  array( 'lhs' => 194, 'rhs' => 4 ),
  array( 'lhs' => 194, 'rhs' => 2 ),
  array( 'lhs' => 194, 'rhs' => 2 ),
  array( 'lhs' => 194, 'rhs' => 4 ),
  array( 'lhs' => 194, 'rhs' => 2 ),
  array( 'lhs' => 194, 'rhs' => 2 ),
  array( 'lhs' => 241, 'rhs' => 1 ),
  array( 'lhs' => 241, 'rhs' => 3 ),
  array( 'lhs' => 242, 'rhs' => 3 ),
  array( 'lhs' => 173, 'rhs' => 1 ),
  array( 'lhs' => 232, 'rhs' => 4 ),
  array( 'lhs' => 232, 'rhs' => 6 ),
  array( 'lhs' => 232, 'rhs' => 6 ),
  array( 'lhs' => 232, 'rhs' => 4 ),
  array( 'lhs' => 196, 'rhs' => 1 ),
  array( 'lhs' => 196, 'rhs' => 1 ),
  array( 'lhs' => 196, 'rhs' => 1 ),
  array( 'lhs' => 196, 'rhs' => 1 ),
  array( 'lhs' => 196, 'rhs' => 3 ),
  array( 'lhs' => 196, 'rhs' => 3 ),
  array( 'lhs' => 196, 'rhs' => 3 ),
  array( 'lhs' => 191, 'rhs' => 1 ),
  array( 'lhs' => 191, 'rhs' => 1 ),
  array( 'lhs' => 243, 'rhs' => 4 ),
  array( 'lhs' => 243, 'rhs' => 1 ),
  array( 'lhs' => 244, 'rhs' => 2 ),
  array( 'lhs' => 244, 'rhs' => 0 ),
  array( 'lhs' => 245, 'rhs' => 2 ),
  array( 'lhs' => 192, 'rhs' => 3 ),
  array( 'lhs' => 192, 'rhs' => 0 ),
  array( 'lhs' => 239, 'rhs' => 1 ),
  array( 'lhs' => 239, 'rhs' => 0 ),
  array( 'lhs' => 157, 'rhs' => 1 ),
  array( 'lhs' => 157, 'rhs' => 0 ),
  array( 'lhs' => 246, 'rhs' => 3 ),
  array( 'lhs' => 246, 'rhs' => 1 ),
  array( 'lhs' => 180, 'rhs' => 1 ),
  array( 'lhs' => 180, 'rhs' => 0 ),
    );

    /**
     * The following table contains a mapping of reduce action to method name
     * that handles the reduction.
     * 
     * If a rule is not set, it has no handler.
     */
    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        38 => 1,
        40 => 1,
        208 => 1,
        220 => 1,
        2 => 2,
        41 => 2,
        55 => 2,
        59 => 2,
        134 => 2,
        167 => 2,
        172 => 2,
        174 => 2,
        176 => 2,
        178 => 2,
        180 => 2,
        192 => 2,
        213 => 2,
        241 => 2,
        244 => 2,
        259 => 2,
        273 => 2,
        275 => 2,
        295 => 2,
        329 => 2,
        332 => 2,
        336 => 2,
        3 => 3,
        4 => 3,
        5 => 3,
        7 => 3,
        35 => 3,
        37 => 3,
        60 => 3,
        63 => 3,
        64 => 3,
        117 => 3,
        135 => 3,
        136 => 3,
        137 => 3,
        139 => 3,
        141 => 3,
        147 => 3,
        153 => 3,
        155 => 3,
        157 => 3,
        169 => 3,
        175 => 3,
        177 => 3,
        179 => 3,
        189 => 3,
        191 => 3,
        200 => 3,
        215 => 3,
        217 => 3,
        229 => 3,
        230 => 3,
        232 => 3,
        233 => 3,
        235 => 3,
        236 => 3,
        237 => 3,
        239 => 3,
        245 => 3,
        249 => 3,
        250 => 3,
        252 => 3,
        256 => 3,
        260 => 3,
        261 => 3,
        265 => 3,
        270 => 3,
        271 => 3,
        277 => 3,
        309 => 3,
        312 => 3,
        324 => 3,
        325 => 3,
        327 => 3,
        335 => 3,
        338 => 3,
        6 => 6,
        45 => 6,
        8 => 8,
        22 => 8,
        23 => 8,
        26 => 8,
        161 => 8,
        162 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        14 => 11,
        12 => 12,
        13 => 13,
        16 => 16,
        18 => 18,
        24 => 18,
        20 => 20,
        21 => 20,
        27 => 27,
        28 => 28,
        29 => 29,
        30 => 29,
        31 => 31,
        33 => 33,
        34 => 34,
        39 => 39,
        42 => 42,
        43 => 42,
        44 => 42,
        46 => 42,
        47 => 42,
        48 => 48,
        49 => 49,
        51 => 51,
        52 => 52,
        53 => 53,
        54 => 54,
        61 => 61,
        62 => 62,
        199 => 62,
        231 => 62,
        65 => 65,
        66 => 66,
        67 => 67,
        68 => 68,
        69 => 69,
        70 => 70,
        71 => 71,
        72 => 72,
        73 => 73,
        74 => 74,
        75 => 75,
        76 => 76,
        77 => 77,
        78 => 78,
        79 => 79,
        80 => 80,
        81 => 81,
        82 => 82,
        83 => 83,
        84 => 84,
        85 => 85,
        86 => 86,
        87 => 87,
        88 => 88,
        89 => 89,
        90 => 90,
        91 => 91,
        92 => 92,
        93 => 93,
        94 => 94,
        95 => 95,
        96 => 96,
        97 => 97,
        98 => 98,
        99 => 99,
        100 => 100,
        101 => 101,
        102 => 102,
        103 => 103,
        104 => 104,
        105 => 105,
        106 => 106,
        107 => 107,
        108 => 108,
        109 => 109,
        110 => 110,
        111 => 111,
        112 => 112,
        113 => 113,
        114 => 114,
        115 => 115,
        331 => 115,
        116 => 116,
        118 => 118,
        119 => 119,
        120 => 120,
        121 => 121,
        122 => 122,
        123 => 123,
        124 => 124,
        125 => 125,
        126 => 126,
        127 => 127,
        128 => 128,
        129 => 129,
        130 => 130,
        131 => 131,
        132 => 132,
        133 => 133,
        138 => 138,
        140 => 140,
        142 => 142,
        143 => 143,
        190 => 143,
        334 => 143,
        144 => 144,
        145 => 145,
        146 => 145,
        148 => 148,
        154 => 154,
        156 => 154,
        158 => 154,
        163 => 154,
        164 => 154,
        170 => 154,
        159 => 159,
        160 => 160,
        165 => 165,
        166 => 166,
        171 => 171,
        173 => 173,
        181 => 181,
        182 => 182,
        183 => 183,
        184 => 184,
        185 => 185,
        186 => 186,
        187 => 187,
        188 => 188,
        193 => 193,
        248 => 193,
        255 => 193,
        258 => 193,
        264 => 193,
        296 => 193,
        317 => 193,
        318 => 193,
        319 => 193,
        320 => 193,
        194 => 194,
        195 => 195,
        196 => 196,
        197 => 196,
        198 => 198,
        201 => 201,
        202 => 202,
        203 => 203,
        299 => 203,
        204 => 204,
        205 => 205,
        206 => 206,
        207 => 207,
        209 => 209,
        210 => 210,
        211 => 211,
        212 => 212,
        214 => 214,
        216 => 216,
        218 => 216,
        219 => 219,
        221 => 221,
        222 => 222,
        223 => 223,
        224 => 224,
        225 => 225,
        226 => 226,
        227 => 227,
        228 => 228,
        234 => 234,
        238 => 238,
        242 => 242,
        243 => 243,
        246 => 246,
        251 => 246,
        247 => 247,
        253 => 253,
        254 => 254,
        257 => 257,
        262 => 262,
        263 => 263,
        266 => 266,
        267 => 267,
        268 => 268,
        269 => 269,
        280 => 269,
        310 => 269,
        337 => 269,
        272 => 272,
        274 => 274,
        285 => 274,
        286 => 274,
        287 => 274,
        288 => 274,
        289 => 274,
        276 => 276,
        278 => 278,
        279 => 279,
        281 => 281,
        282 => 282,
        283 => 283,
        284 => 284,
        290 => 290,
        291 => 291,
        292 => 292,
        293 => 293,
        294 => 294,
        297 => 297,
        298 => 298,
        300 => 300,
        301 => 301,
        302 => 302,
        303 => 303,
        304 => 304,
        305 => 305,
        306 => 306,
        307 => 307,
        308 => 308,
        311 => 311,
        313 => 313,
        314 => 314,
        315 => 315,
        316 => 316,
        321 => 321,
        322 => 322,
        323 => 323,
        326 => 326,
        328 => 328,
        330 => 330,
        333 => 333,
        339 => 339,
        340 => 340,
    );
    /* Beginning here are the reduction cases.  A typical example
    ** follows:
    **  #line <lineno> <grammarfile>
    **   function yy_r0($yymsp){ ... }           // User supplied code
    **  #line <lineno> <thisfile>
    */
#line 113 "PHP_Parser.y"
    function yy_r0(){$this->data = $this->yystack[$this->yyidx + 0]->minor->metadata;    }
#line 5072 "PHP_Parser.php"
#line 115 "PHP_Parser.y"
    function yy_r1(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5078 "PHP_Parser.php"
#line 119 "PHP_Parser.y"
    function yy_r2(){$this->_retvalue = new PHPyyToken('');    }
#line 5081 "PHP_Parser.php"
#line 121 "PHP_Parser.y"
    function yy_r3(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 5084 "PHP_Parser.php"
#line 124 "PHP_Parser.y"
    function yy_r6(){ $this->lex->haltParsing();     }
#line 5087 "PHP_Parser.php"
#line 128 "PHP_Parser.y"
    function yy_r8(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;    }
#line 5090 "PHP_Parser.php"
#line 129 "PHP_Parser.y"
    function yy_r9(){
    $this->_retvalue = new PHPyyToken('');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5099 "PHP_Parser.php"
#line 136 "PHP_Parser.y"
    function yy_r10(){
    $this->_retvalue = new PHPyyToken('if (' . $this->yystack[$this->yyidx + -7]->minor->string . '):' . $this->yystack[$this->yyidx + -4]->minor->string . $this->yystack[$this->yyidx + -3]->minor->string . $this->yystack[$this->yyidx + -2]->minor->string . 'endif;');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -7]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    }
#line 5108 "PHP_Parser.php"
#line 143 "PHP_Parser.y"
    function yy_r11(){
    $this->_retvalue = new PHPyyToken('');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5115 "PHP_Parser.php"
#line 148 "PHP_Parser.y"
    function yy_r12(){
    $this->_retvalue = new PHPyyToken('');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -5]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    }
#line 5122 "PHP_Parser.php"
#line 161 "PHP_Parser.y"
    function yy_r13(){
    $this->_retvalue = new PHPyyToken('');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -6]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5131 "PHP_Parser.php"
#line 174 "PHP_Parser.y"
    function yy_r16(){
    $this->_retvalue = new PHPyyToken('');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 5137 "PHP_Parser.php"
#line 179 "PHP_Parser.y"
    function yy_r18(){
    $this->_retvalue = new PHPyyToken('', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 5142 "PHP_Parser.php"
#line 183 "PHP_Parser.y"
    function yy_r20(){
    $this->_retvalue = new PHPyyToken('return ' . $this->yystack[$this->yyidx + -1]->minor->string . ';', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 5147 "PHP_Parser.php"
#line 196 "PHP_Parser.y"
    function yy_r27(){
    $this->_retvalue = new PHPyyToken('', array('uses' => $this->yystack[$this->yyidx + -1]->minor));
    // not that "uses" would actually work in real life
    }
#line 5153 "PHP_Parser.php"
#line 200 "PHP_Parser.y"
    function yy_r28(){
    $this->_retvalue = new PHPyyToken('', $this->yystack[$this->yyidx + -2]->minor);
    }
#line 5158 "PHP_Parser.php"
#line 205 "PHP_Parser.y"
    function yy_r29(){
    $this->_retvalue = new PHPyyToken('', $this->yystack[$this->yyidx + -5]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5164 "PHP_Parser.php"
#line 215 "PHP_Parser.y"
    function yy_r31(){
    $this->_retvalue = new PHPyyToken('', $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5170 "PHP_Parser.php"
#line 225 "PHP_Parser.y"
    function yy_r33(){
    $this->_retvalue = new PHPyyToken('',
        array(
            'catches' => $this->yystack[$this->yyidx + -6]->minor,
        ));
    $this->_retvalue[] = $this->yystack[$this->yyidx + -10]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5181 "PHP_Parser.php"
#line 234 "PHP_Parser.y"
    function yy_r34(){
    if ($this->yystack[$this->yyidx + -1]->minor->metadata && isset($this->yystack[$this->yyidx + -1]->minor->metadata[0]) && isset($this->yystack[$this->yyidx + -1]->minor->metadata[0]['uses']) &&
          $this->yystack[$this->yyidx + -1]->minor->metadata[0]['uses'] === 'class') {
        $this->_retvalue = new PHPyyToken('throw ' . $this->yystack[$this->yyidx + -1]->minor->string, array('throws' => $this->yystack[$this->yyidx + -1]->minor->metadata[0]['name']));
    } else {
        $this->_retvalue = new PHPyyToken('throw ' . $this->yystack[$this->yyidx + -1]->minor->string);
        $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
    }
#line 5192 "PHP_Parser.php"
#line 253 "PHP_Parser.y"
    function yy_r39(){
    $this->_retvalue = new PHPyyToken('', $this->yystack[$this->yyidx + -1]->minor);
    $this->_retvalue[] = array('catches' => $this->yystack[$this->yyidx + -5]->minor);
    }
#line 5198 "PHP_Parser.php"
#line 264 "PHP_Parser.y"
    function yy_r42(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + 0]->minor);
    }
#line 5203 "PHP_Parser.php"
#line 285 "PHP_Parser.y"
    function yy_r48(){
	$this->_retvalue = new PHPyyToken('function ' . ($this->yystack[$this->yyidx + -7]->minor ? '&' : '') .
	   $this->yystack[$this->yyidx + -6]->minor . '(' . $this->yystack[$this->yyidx + -4]->minor->string . ')');
    $this->_retvalue[] = array(
        'type' => 'function',
        'returnsref' => $this->yystack[$this->yyidx + -7]->minor,
        'name' => $this->yystack[$this->yyidx + -6]->minor,
        'parameters' => $this->yystack[$this->yyidx + -4]->minor->metadata,
        'info' => $this->yystack[$this->yyidx + -1]->minor->metadata,
    );
    }
#line 5216 "PHP_Parser.php"
#line 302 "PHP_Parser.y"
    function yy_r49(){
	$this->_retvalue = new PHPyyToken('', array(
	   'type' => $this->yystack[$this->yyidx + -6]->minor['type'],
	   'modifiers' => $this->yystack[$this->yyidx + -6]->minor['modifiers'],
	   'name' => $this->yystack[$this->yyidx + -5]->minor,
	   'extends' => $this->yystack[$this->yyidx + -4]->minor,
	   'implements' => $this->yystack[$this->yyidx + -3]->minor,
	   'info' => $this->yystack[$this->yyidx + -1]->minor->metadata,
	));
    }
#line 5228 "PHP_Parser.php"
#line 319 "PHP_Parser.y"
    function yy_r51(){ $this->_retvalue = new PHPyyToken('', array('type' => 'class', 'modifiers' => array()));     }
#line 5231 "PHP_Parser.php"
#line 320 "PHP_Parser.y"
    function yy_r52(){
    $this->_retvalue = new PHPyyToken('', array('type' => 'class', 'modifiers' => array('abstract')));
    }
#line 5236 "PHP_Parser.php"
#line 323 "PHP_Parser.y"
    function yy_r53(){
    $this->_retvalue = new PHPyyToken('', array('type' => 'class', 'modifiers' => array('final')));
    }
#line 5241 "PHP_Parser.php"
#line 327 "PHP_Parser.y"
    function yy_r54(){$this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + 0]->minor, array($this->yystack[$this->yyidx + 0]->minor));    }
#line 5244 "PHP_Parser.php"
#line 338 "PHP_Parser.y"
    function yy_r61(){$this->_retvalue = new PHPyyToken('', array($this->yystack[$this->yyidx + 0]->minor));    }
#line 5247 "PHP_Parser.php"
#line 339 "PHP_Parser.y"
    function yy_r62(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5253 "PHP_Parser.php"
#line 347 "PHP_Parser.y"
    function yy_r65(){
    $this->_retvalue = new PHPyyToken('list(' . $this->yystack[$this->yyidx + -3]->minor->string . ') = ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5259 "PHP_Parser.php"
#line 351 "PHP_Parser.y"
    function yy_r66(){
    if ($this->lex->globalSearch($this->yystack[$this->yyidx + -2]->minor->string)) {
        $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' = ' . $this->yystack[$this->yyidx + 0]->minor->string,
            array(
                'type' => 'global',
                'name' => $this->yystack[$this->yyidx + -2]->minor->string,
                'default' => $this->yystack[$this->yyidx + 0]->minor->string,
            ));
        $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
        $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' = ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
        $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 5276 "PHP_Parser.php"
#line 366 "PHP_Parser.y"
    function yy_r67(){
    if ($this->lex->globalSearch($this->yystack[$this->yyidx + -3]->minor->string)) {
        $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -3]->minor->string . ' = ' . $this->yystack[$this->yyidx + 0]->minor->string,
            array(
                'type' => 'global',
                'name' => $this->yystack[$this->yyidx + -3]->minor->string,
                'default' => '&' . $this->yystack[$this->yyidx + 0]->minor->string,
            ));
        $this->_retvalue[] = $this->yystack[$this->yyidx + -3]->minor;
        $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -3]->minor->string . ' = &' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -3]->minor);
        $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 5293 "PHP_Parser.php"
#line 382 "PHP_Parser.y"
    function yy_r68(){
    $c = is_string($this->yystack[$this->yyidx + -1]->minor) ? $this->yystack[$this->yyidx + -1]->minor : $this->yystack[$this->yyidx + -1]->minor->string;
    if ($this->lex->globalSearch($this->yystack[$this->yyidx + -5]->minor->string)) {
        $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -5]->minor->string . ' = &new ' . $c . $this->yystack[$this->yyidx + 0]->minor->string,
            array(
                'type' => 'global',
                'name' => $this->yystack[$this->yyidx + -5]->minor->string,
                'default' => '&new ' . $this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor->string,
            ));
        $this->_retvalue[] = $this->yystack[$this->yyidx + -5]->minor;
    } else {
        $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -5]->minor->string . ' = &new ' . $c . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -5]->minor);
    }
    if (is_string($this->yystack[$this->yyidx + -1]->minor)) {
        $this->_retvalue[] = array('usedclass' => $this->yystack[$this->yyidx + -1]->minor);
    }
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5313 "PHP_Parser.php"
#line 400 "PHP_Parser.y"
    function yy_r69(){
    $b = is_string($this->yystack[$this->yyidx + -1]->minor) ? $this->yystack[$this->yyidx + -1]->minor : $this->yystack[$this->yyidx + -1]->minor->string;
    $this->_retvalue = new PHPyyToken('new ' . $b . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -1]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    if (is_string($this->yystack[$this->yyidx + -1]->minor)) {
        $this->_retvalue[] = array('uses' => 'class', 'name' => $this->yystack[$this->yyidx + -1]->minor);
    }
    }
#line 5323 "PHP_Parser.php"
#line 408 "PHP_Parser.y"
    function yy_r70(){
    $this->_retvalue = new PHPyyToken('clone ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5328 "PHP_Parser.php"
#line 411 "PHP_Parser.y"
    function yy_r71(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' += ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5334 "PHP_Parser.php"
#line 415 "PHP_Parser.y"
    function yy_r72(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' -= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5340 "PHP_Parser.php"
#line 420 "PHP_Parser.y"
    function yy_r73(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' *= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5346 "PHP_Parser.php"
#line 425 "PHP_Parser.y"
    function yy_r74(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' /= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5352 "PHP_Parser.php"
#line 430 "PHP_Parser.y"
    function yy_r75(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' .= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5358 "PHP_Parser.php"
#line 435 "PHP_Parser.y"
    function yy_r76(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' %= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5364 "PHP_Parser.php"
#line 440 "PHP_Parser.y"
    function yy_r77(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' &= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5370 "PHP_Parser.php"
#line 445 "PHP_Parser.y"
    function yy_r78(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' |= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5376 "PHP_Parser.php"
#line 450 "PHP_Parser.y"
    function yy_r79(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' ^= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5382 "PHP_Parser.php"
#line 455 "PHP_Parser.y"
    function yy_r80(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' <<= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5388 "PHP_Parser.php"
#line 460 "PHP_Parser.y"
    function yy_r81(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' >>= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5394 "PHP_Parser.php"
#line 465 "PHP_Parser.y"
    function yy_r82(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -1]->minor->string . '++', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 5399 "PHP_Parser.php"
#line 468 "PHP_Parser.y"
    function yy_r83(){
    $this->_retvalue = new PHPyyToken('++' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5404 "PHP_Parser.php"
#line 471 "PHP_Parser.y"
    function yy_r84(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -1]->minor->string . '--', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 5409 "PHP_Parser.php"
#line 474 "PHP_Parser.y"
    function yy_r85(){
    $this->_retvalue = new PHPyyToken('--' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5414 "PHP_Parser.php"
#line 477 "PHP_Parser.y"
    function yy_r86(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' || ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5420 "PHP_Parser.php"
#line 481 "PHP_Parser.y"
    function yy_r87(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' && ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5426 "PHP_Parser.php"
#line 485 "PHP_Parser.y"
    function yy_r88(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' OR ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5432 "PHP_Parser.php"
#line 489 "PHP_Parser.y"
    function yy_r89(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' AND ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5438 "PHP_Parser.php"
#line 493 "PHP_Parser.y"
    function yy_r90(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' XOR ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5444 "PHP_Parser.php"
#line 497 "PHP_Parser.y"
    function yy_r91(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' | ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5450 "PHP_Parser.php"
#line 501 "PHP_Parser.y"
    function yy_r92(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' & ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5456 "PHP_Parser.php"
#line 505 "PHP_Parser.y"
    function yy_r93(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' ^ ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5462 "PHP_Parser.php"
#line 509 "PHP_Parser.y"
    function yy_r94(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' . ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5468 "PHP_Parser.php"
#line 513 "PHP_Parser.y"
    function yy_r95(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' + ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5474 "PHP_Parser.php"
#line 517 "PHP_Parser.y"
    function yy_r96(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' - ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5480 "PHP_Parser.php"
#line 521 "PHP_Parser.y"
    function yy_r97(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' * ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5486 "PHP_Parser.php"
#line 525 "PHP_Parser.y"
    function yy_r98(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' / ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5492 "PHP_Parser.php"
#line 529 "PHP_Parser.y"
    function yy_r99(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' % ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5498 "PHP_Parser.php"
#line 533 "PHP_Parser.y"
    function yy_r100(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' << ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5504 "PHP_Parser.php"
#line 537 "PHP_Parser.y"
    function yy_r101(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' >> ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5510 "PHP_Parser.php"
#line 541 "PHP_Parser.y"
    function yy_r102(){
    $this->_retvalue = new PHPyyToken('+' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5515 "PHP_Parser.php"
#line 544 "PHP_Parser.y"
    function yy_r103(){
    $this->_retvalue = new PHPyyToken('-' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5520 "PHP_Parser.php"
#line 547 "PHP_Parser.y"
    function yy_r104(){
    $this->_retvalue = new PHPyyToken('!' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5525 "PHP_Parser.php"
#line 550 "PHP_Parser.y"
    function yy_r105(){
    $this->_retvalue = new PHPyyToken('~' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5530 "PHP_Parser.php"
#line 553 "PHP_Parser.y"
    function yy_r106(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' === ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5536 "PHP_Parser.php"
#line 557 "PHP_Parser.y"
    function yy_r107(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' !== ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5542 "PHP_Parser.php"
#line 561 "PHP_Parser.y"
    function yy_r108(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' == ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5548 "PHP_Parser.php"
#line 565 "PHP_Parser.y"
    function yy_r109(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' != ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5554 "PHP_Parser.php"
#line 569 "PHP_Parser.y"
    function yy_r110(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' < ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5560 "PHP_Parser.php"
#line 573 "PHP_Parser.y"
    function yy_r111(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' <= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5566 "PHP_Parser.php"
#line 577 "PHP_Parser.y"
    function yy_r112(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' > ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5572 "PHP_Parser.php"
#line 581 "PHP_Parser.y"
    function yy_r113(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' >= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5578 "PHP_Parser.php"
#line 585 "PHP_Parser.y"
    function yy_r114(){
    $c = is_string($this->yystack[$this->yyidx + 0]->minor) ? $this->yystack[$this->yyidx + 0]->minor : $this->yystack[$this->yyidx + 0]->minor->string;
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' instanceof ' . $c, $this->yystack[$this->yyidx + -2]->minor);
    if (!is_string($this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 5587 "PHP_Parser.php"
#line 592 "PHP_Parser.y"
    function yy_r115(){
    $this->_retvalue = new PHPyyToken('(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 5592 "PHP_Parser.php"
#line 597 "PHP_Parser.y"
    function yy_r116(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -4]->minor->string . ' ? ' . $this->yystack[$this->yyidx + -2]->minor->string . ' : ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -4]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5599 "PHP_Parser.php"
#line 603 "PHP_Parser.y"
    function yy_r118(){
    $this->_retvalue = new PHPyyToken('(int) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5604 "PHP_Parser.php"
#line 606 "PHP_Parser.y"
    function yy_r119(){
    $this->_retvalue = new PHPyyToken('(double) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5609 "PHP_Parser.php"
#line 609 "PHP_Parser.y"
    function yy_r120(){
    $this->_retvalue = new PHPyyToken('(string) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5614 "PHP_Parser.php"
#line 612 "PHP_Parser.y"
    function yy_r121(){
    $this->_retvalue = new PHPyyToken('(array) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5619 "PHP_Parser.php"
#line 615 "PHP_Parser.y"
    function yy_r122(){
    $this->_retvalue = new PHPyyToken('(object) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5624 "PHP_Parser.php"
#line 618 "PHP_Parser.y"
    function yy_r123(){
    $this->_retvalue = new PHPyyToken('(bool) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5629 "PHP_Parser.php"
#line 621 "PHP_Parser.y"
    function yy_r124(){
    $this->_retvalue = new PHPyyToken('(unset) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5634 "PHP_Parser.php"
#line 624 "PHP_Parser.y"
    function yy_r125(){
    $this->_retvalue = new PHPyyToken('exit ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5639 "PHP_Parser.php"
#line 627 "PHP_Parser.y"
    function yy_r126(){
    $this->_retvalue = new PHPyyToken('@' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5644 "PHP_Parser.php"
#line 630 "PHP_Parser.y"
    function yy_r127(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5649 "PHP_Parser.php"
#line 633 "PHP_Parser.y"
    function yy_r128(){
    $this->_retvalue = new PHPyyToken('array(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 5654 "PHP_Parser.php"
#line 636 "PHP_Parser.y"
    function yy_r129(){
    $this->_retvalue = new PHPyyToken('`' . $this->yystack[$this->yyidx + -1]->minor->string . '`');
    }
#line 5659 "PHP_Parser.php"
#line 639 "PHP_Parser.y"
    function yy_r130(){
    $this->_retvalue = new PHPyyToken('print ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5664 "PHP_Parser.php"
#line 643 "PHP_Parser.y"
    function yy_r131(){$this->lex->trackWhitespace();    }
#line 5667 "PHP_Parser.php"
#line 645 "PHP_Parser.y"
    function yy_r132(){$this->_retvalue = new PHPyyToken('()');    }
#line 5670 "PHP_Parser.php"
#line 646 "PHP_Parser.y"
    function yy_r133(){$this->_retvalue = new PHPyyToken('(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);    }
#line 5673 "PHP_Parser.php"
#line 662 "PHP_Parser.y"
    function yy_r138(){
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor;
    // have to do all because of nested arrays
    $this->lex->stopTrackingWhitespace(); // we only need whitespace for
                                          // array default values
    }
#line 5681 "PHP_Parser.php"
#line 670 "PHP_Parser.y"
    function yy_r140(){
    $this->lex->trackWhitespace();
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5687 "PHP_Parser.php"
#line 676 "PHP_Parser.y"
    function yy_r142(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5692 "PHP_Parser.php"
#line 679 "PHP_Parser.y"
    function yy_r143(){$this->_retvalue = '';    }
#line 5695 "PHP_Parser.php"
#line 681 "PHP_Parser.y"
    function yy_r144(){
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor . $this->yystack[$this->yyidx + -3]->minor . $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5700 "PHP_Parser.php"
#line 684 "PHP_Parser.y"
    function yy_r145(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5705 "PHP_Parser.php"
#line 692 "PHP_Parser.y"
    function yy_r148(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . '::' . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5710 "PHP_Parser.php"
#line 703 "PHP_Parser.y"
    function yy_r154(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 5713 "PHP_Parser.php"
#line 712 "PHP_Parser.y"
    function yy_r159(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor . ' = ' . $this->yystack[$this->yyidx + 0]->minor, array('declare' => $this->yystack[$this->yyidx + -2]->minor, 'default' => $this->yystack[$this->yyidx + 0]->minor));
    }
#line 5718 "PHP_Parser.php"
#line 715 "PHP_Parser.y"
    function yy_r160(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -4]->minor->string . ', ' . $this->yystack[$this->yyidx + -2]->minor . ' = ' . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -4]->minor);
    $this->_retvalue[] = array('declare' => $this->yystack[$this->yyidx + -2]->minor, 'default' => $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5724 "PHP_Parser.php"
#line 725 "PHP_Parser.y"
    function yy_r165(){
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 5730 "PHP_Parser.php"
#line 729 "PHP_Parser.y"
    function yy_r166(){
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5736 "PHP_Parser.php"
#line 740 "PHP_Parser.y"
    function yy_r171(){
    $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5743 "PHP_Parser.php"
#line 747 "PHP_Parser.y"
    function yy_r173(){
    $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5750 "PHP_Parser.php"
#line 763 "PHP_Parser.y"
    function yy_r181(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor, array(
            array(
                'typehint' => $this->yystack[$this->yyidx + -1]->minor,
                'param' => $this->yystack[$this->yyidx + 0]->minor,
                'isreference' => false,
                'default' => null,
            )
        ));
    }
#line 5762 "PHP_Parser.php"
#line 773 "PHP_Parser.y"
    function yy_r182(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor . '&' . $this->yystack[$this->yyidx + 0]->minor, array(
            array(
                'typehint' => $this->yystack[$this->yyidx + -2]->minor,
                'param' => $this->yystack[$this->yyidx + 0]->minor,
                'isreference' => true,
                'default' => null,
            )
        ));
    }
#line 5774 "PHP_Parser.php"
#line 783 "PHP_Parser.y"
    function yy_r183(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -4]->minor . '&' . $this->yystack[$this->yyidx + -2]->minor . ' = ' . $this->yystack[$this->yyidx + 0]->minor, array(
            array(
                'typehint' => $this->yystack[$this->yyidx + -4]->minor,
                'param' => $this->yystack[$this->yyidx + -2]->minor,
                'isreference' => true,
                'default' => $this->yystack[$this->yyidx + 0]->minor,
            )
        ));
    }
#line 5786 "PHP_Parser.php"
#line 793 "PHP_Parser.y"
    function yy_r184(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -3]->minor . $this->yystack[$this->yyidx + -2]->minor . ' = ' . $this->yystack[$this->yyidx + 0]->minor, array(
            array(
                'typehint' => $this->yystack[$this->yyidx + -3]->minor,
                'param' => $this->yystack[$this->yyidx + -2]->minor,
                'isreference' => false,
                'default' => $this->yystack[$this->yyidx + 0]->minor,
            )
        ));
    }
#line 5798 "PHP_Parser.php"
#line 803 "PHP_Parser.y"
    function yy_r185(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -3]->minor->string . ', ' . $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = 
        array(
            'typehint' => $this->yystack[$this->yyidx + -1]->minor,
            'param' => $this->yystack[$this->yyidx + 0]->minor,
            'isreference' => false,
            'default' => null,
        );
    }
#line 5810 "PHP_Parser.php"
#line 813 "PHP_Parser.y"
    function yy_r186(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -4]->minor->string . ', ' . $this->yystack[$this->yyidx + -2]->minor . '&' . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -4]->minor);
    $this->_retvalue[] = 
        array(
            'typehint' => $this->yystack[$this->yyidx + -2]->minor,
            'param' => $this->yystack[$this->yyidx + 0]->minor,
            'isreference' => true,
            'default' => null,
        );
    }
#line 5822 "PHP_Parser.php"
#line 823 "PHP_Parser.y"
    function yy_r187(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -6]->minor->string . ', ' . $this->yystack[$this->yyidx + -4]->minor . $this->yystack[$this->yyidx + -2]->minor . ' = ' . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -6]->minor);
    $this->_retvalue[] = 
        array(
            'typehint' => $this->yystack[$this->yyidx + -4]->minor,
            'param' => $this->yystack[$this->yyidx + -2]->minor,
            'isreference' => true,
            'default' => $this->yystack[$this->yyidx + 0]->minor,
        );
    }
#line 5834 "PHP_Parser.php"
#line 833 "PHP_Parser.y"
    function yy_r188(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -5]->minor->string . ', ' . $this->yystack[$this->yyidx + -3]->minor . $this->yystack[$this->yyidx + -2]->minor . ' = ' . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -5]->minor);
    $this->_retvalue[] = 
        array(
            'typehint' => $this->yystack[$this->yyidx + -3]->minor,
            'param' => $this->yystack[$this->yyidx + -2]->minor,
            'isreference' => false,
            'default' => $this->yystack[$this->yyidx + 0]->minor,
        );
    }
#line 5846 "PHP_Parser.php"
#line 851 "PHP_Parser.y"
    function yy_r193(){$this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + 0]->minor);    }
#line 5849 "PHP_Parser.php"
#line 852 "PHP_Parser.y"
    function yy_r194(){$this->_retvalue = PHPyyToken($this->yystack[$this->yyidx + 0]->minor);    }
#line 5852 "PHP_Parser.php"
#line 853 "PHP_Parser.y"
    function yy_r195(){
    if ($this->yystack[$this->yyidx + 0]->minor instanceof PHPyyToken) {
        $b = $this->yystack[$this->yyidx + 0]->minor->string;
    } else {
        $b = (string) $this->yystack[$this->yyidx + 0]->minor;
    }
    $this->_retvalue = new PHPyyToken('&' . $b, $this->yystack[$this->yyidx + 0]->minor);    }
#line 5861 "PHP_Parser.php"
#line 860 "PHP_Parser.y"
    function yy_r196(){
    if ($this->yystack[$this->yyidx + 0]->minor instanceof PHPyyToken) {
        $b = $this->yystack[$this->yyidx + 0]->minor->string;
    } else {
        $b = (string) $this->yystack[$this->yyidx + 0]->minor;
    }
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ', ' . $b, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5872 "PHP_Parser.php"
#line 878 "PHP_Parser.y"
    function yy_r198(){
    if ($this->yystack[$this->yyidx + 0]->minor instanceof PHPyyToken) {
        $b = $this->yystack[$this->yyidx + 0]->minor->string;
    } else {
        $b = (string) $this->yystack[$this->yyidx + 0]->minor;
    }
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -3]->minor->string . ', &' . $b, $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5883 "PHP_Parser.php"
#line 894 "PHP_Parser.y"
    function yy_r201(){$this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + 0]->minor, array('global' => $this->yystack[$this->yyidx + 0]->minor));    }
#line 5886 "PHP_Parser.php"
#line 895 "PHP_Parser.y"
    function yy_r202(){$this->_retvalue = new PHPyyToken('$' . $this->yystack[$this->yyidx + 0]->minor);    }
#line 5889 "PHP_Parser.php"
#line 896 "PHP_Parser.y"
    function yy_r203(){
    $this->_retvalue = new PHPyyToken('${' . $this->yystack[$this->yyidx + -1]->minor->string . '}', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 5894 "PHP_Parser.php"
#line 901 "PHP_Parser.y"
    function yy_r204(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = array('static' => $this->yystack[$this->yyidx + 0]->minor, 'default' => null);
    }
#line 5900 "PHP_Parser.php"
#line 905 "PHP_Parser.y"
    function yy_r205(){
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = array('static' => $this->yystack[$this->yyidx + -2]->minor, 'default' => $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5906 "PHP_Parser.php"
#line 909 "PHP_Parser.y"
    function yy_r206(){
    $this->_retvalue = new PHPyyToken('', array('static' => $this->yystack[$this->yyidx + 0]->minor, 'default' => null));
    }
#line 5911 "PHP_Parser.php"
#line 912 "PHP_Parser.y"
    function yy_r207(){
    $this->_retvalue = new PHPyyToken('', array('static' => $this->yystack[$this->yyidx + -2]->minor, 'default' => $this->yystack[$this->yyidx + 0]->minor));
    }
#line 5916 "PHP_Parser.php"
#line 920 "PHP_Parser.y"
    function yy_r209(){$this->_retvalue = array();    }
#line 5919 "PHP_Parser.php"
#line 922 "PHP_Parser.y"
    function yy_r210(){
    $a = array();
    foreach ($this->yystack[$this->yyidx + -1]->minor as $item) {
        $a[] = array(
            'type' => 'var',
            'name' => $item['name'],
            'default' => $item['default'],
            'modifiers' => $this->yystack[$this->yyidx + -2]->minor,
        );
    }
    $this->_retvalue = new PHPyyToken('', $a);
    }
#line 5933 "PHP_Parser.php"
#line 934 "PHP_Parser.y"
    function yy_r211(){
    $a = array();
    foreach ($this->yystack[$this->yyidx + -1]->minor as $item) {
        $a[] = array(
            'type' => 'const',
            'name' => $item['name'],
            'value' => $item['value'],
        );
    }
    $this->_retvalue = new PHPyyToken('', $a);
    }
#line 5946 "PHP_Parser.php"
#line 945 "PHP_Parser.y"
    function yy_r212(){
    $this->_retvalue = new PHPyyToken('', array(
            array(
                'type' => 'method',
                'name' => $this->yystack[$this->yyidx + -4]->minor,
                'parameters' => $this->yystack[$this->yyidx + -2]->minor->metadata,
                'modifiers' => $this->yystack[$this->yyidx + -7]->minor,
            )
        ));
    }
#line 5958 "PHP_Parser.php"
#line 958 "PHP_Parser.y"
    function yy_r214(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 5963 "PHP_Parser.php"
#line 963 "PHP_Parser.y"
    function yy_r216(){$this->_retvalue = array('public');    }
#line 5966 "PHP_Parser.php"
#line 968 "PHP_Parser.y"
    function yy_r219(){$this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 5969 "PHP_Parser.php"
#line 974 "PHP_Parser.y"
    function yy_r221(){$this->_retvalue = strtolower($this->yystack[$this->yyidx + 0]->minor);    }
#line 5972 "PHP_Parser.php"
#line 976 "PHP_Parser.y"
    function yy_r222(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = array(
        'name' => $this->yystack[$this->yyidx + 0]->minor,
        'default' => null,
    );
    }
#line 5981 "PHP_Parser.php"
#line 983 "PHP_Parser.y"
    function yy_r223(){
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = array(
        'name' => $this->yystack[$this->yyidx + -2]->minor,
        'default' => $this->yystack[$this->yyidx + 0]->minor,
    );
    }
#line 5990 "PHP_Parser.php"
#line 990 "PHP_Parser.y"
    function yy_r224(){
    $this->_retvalue = array(
            array(
                'name' => $this->yystack[$this->yyidx + 0]->minor,
                'default' => null,
            )
        );
    }
#line 6000 "PHP_Parser.php"
#line 998 "PHP_Parser.y"
    function yy_r225(){
    $this->_retvalue = array(
            array(
                'name' => $this->yystack[$this->yyidx + -2]->minor,
                'default' => $this->yystack[$this->yyidx + 0]->minor,
            )
        );
    }
#line 6010 "PHP_Parser.php"
#line 1007 "PHP_Parser.y"
    function yy_r226(){
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = array('name' => $this->yystack[$this->yyidx + -2]->minor, 'value' => $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6016 "PHP_Parser.php"
#line 1011 "PHP_Parser.y"
    function yy_r227(){
    $this->_retvalue = array(
        array('name' => $this->yystack[$this->yyidx + -2]->minor, 'value' => $this->yystack[$this->yyidx + 0]->minor)
    );
    }
#line 6023 "PHP_Parser.php"
#line 1017 "PHP_Parser.y"
    function yy_r228(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;$this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;    }
#line 6026 "PHP_Parser.php"
#line 1029 "PHP_Parser.y"
    function yy_r234(){
    $this->_retvalue = '{' . $this->yystack[$this->yyidx + -1]->minor . '}';
    }
#line 6031 "PHP_Parser.php"
#line 1039 "PHP_Parser.y"
    function yy_r238(){
    $this->_retvalue = new PHPyyToken((string) $this->yystack[$this->yyidx + -4]->minor . '->' . (string) $this->yystack[$this->yyidx + -2]->minor .
        (string) $this->yystack[$this->yyidx + -1]->minor . (string) $this->yystack[$this->yyidx + 0]->minor, array());
    $this->_retvalue[] = $this->yystack[$this->yyidx + -4]->minor;
    if (is_array($this->yystack[$this->yyidx + -2]->minor)) {
        $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    } else {
        if ($this->yystack[$this->yyidx + -1]->minor->string) {
            $this->_retvalue[] = array(
                'uses' => 'method',
                'name' => $this->yystack[$this->yyidx + -2]->minor,
            );
        } else {
            $this->_retvalue[] = array(
                'uses' => 'var',
                'name' => $this->yystack[$this->yyidx + -2]->minor,
            );
        }
    }
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6054 "PHP_Parser.php"
#line 1065 "PHP_Parser.y"
    function yy_r242(){
    $this->_retvalue = new PHPyyToken('->' . $this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -1]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6060 "PHP_Parser.php"
#line 1070 "PHP_Parser.y"
    function yy_r243(){
    $this->_retvalue = new PHPyyToken('(' . $this->yystack[$this->yyidx + -1]->minor . ')', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6065 "PHP_Parser.php"
#line 1076 "PHP_Parser.y"
    function yy_r246(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6070 "PHP_Parser.php"
#line 1080 "PHP_Parser.y"
    function yy_r247(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor . '::' . (string) $this->yystack[$this->yyidx + 0]->minor, array(
        array(
            'usedclass' => $this->yystack[$this->yyidx + -2]->minor,
        )
    ));
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6080 "PHP_Parser.php"
#line 1098 "PHP_Parser.y"
    function yy_r253(){
    $this->_retvalue = new PHPyyToken((string) $this->yystack[$this->yyidx + -3]->minor . '[' . (string) $this->yystack[$this->yyidx + -1]->minor . ']', array());
    $this->_retvalue[] = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 6087 "PHP_Parser.php"
#line 1103 "PHP_Parser.y"
    function yy_r254(){
    $this->_retvalue = new PHPyyToken((string) $this->yystack[$this->yyidx + -3]->minor . '{' . (string) $this->yystack[$this->yyidx + -1]->minor . '}', array());
    $this->_retvalue[] = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 6094 "PHP_Parser.php"
#line 1111 "PHP_Parser.y"
    function yy_r257(){$this->_retvalue = new PHPyyToken('${' . (string) $this->yystack[$this->yyidx + -1]->minor . '}', $this->yystack[$this->yyidx + -1]->minor);    }
#line 6097 "PHP_Parser.php"
#line 1119 "PHP_Parser.y"
    function yy_r262(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -3]->minor->string . '[' . $this->yystack[$this->yyidx + -1]->minor->string . ']', $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 6103 "PHP_Parser.php"
#line 1123 "PHP_Parser.y"
    function yy_r263(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -3]->minor->string . '{' . $this->yystack[$this->yyidx + -1]->minor->string . '}', $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 6109 "PHP_Parser.php"
#line 1130 "PHP_Parser.y"
    function yy_r266(){$this->_retvalue = new PHPyyToken('{' . $this->yystack[$this->yyidx + -1]->minor->string . '}', $this->yystack[$this->yyidx + -1]->minor);    }
#line 6112 "PHP_Parser.php"
#line 1132 "PHP_Parser.y"
    function yy_r267(){$this->_retvalue = '$';    }
#line 6115 "PHP_Parser.php"
#line 1133 "PHP_Parser.y"
    function yy_r268(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor . '$';    }
#line 6118 "PHP_Parser.php"
#line 1135 "PHP_Parser.y"
    function yy_r269(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ', ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6124 "PHP_Parser.php"
#line 1142 "PHP_Parser.y"
    function yy_r272(){
    $this->_retvalue = new PHPyyToken('list(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6129 "PHP_Parser.php"
#line 1147 "PHP_Parser.y"
    function yy_r274(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6134 "PHP_Parser.php"
#line 1152 "PHP_Parser.y"
    function yy_r276(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -3]->minor->string . ' => &' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6140 "PHP_Parser.php"
#line 1157 "PHP_Parser.y"
    function yy_r278(){
    $this->_retvalue = new PHPyyToken('&' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6145 "PHP_Parser.php"
#line 1160 "PHP_Parser.y"
    function yy_r279(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -4]->minor->string . ', ' . $this->yystack[$this->yyidx + -2]->minor->string . ' => ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -4]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6152 "PHP_Parser.php"
#line 1169 "PHP_Parser.y"
    function yy_r281(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' => ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6158 "PHP_Parser.php"
#line 1173 "PHP_Parser.y"
    function yy_r282(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -5]->minor->string . ', ' . $this->yystack[$this->yyidx + -3]->minor->string . ' => &' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -5]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6165 "PHP_Parser.php"
#line 1178 "PHP_Parser.y"
    function yy_r283(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -3]->minor->string . ', &' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6171 "PHP_Parser.php"
#line 1184 "PHP_Parser.y"
    function yy_r284(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6177 "PHP_Parser.php"
#line 1203 "PHP_Parser.y"
    function yy_r290(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -1]->minor->string . '[', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6182 "PHP_Parser.php"
#line 1206 "PHP_Parser.y"
    function yy_r291(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -1]->minor->string . ']', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6187 "PHP_Parser.php"
#line 1209 "PHP_Parser.y"
    function yy_r292(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -1]->minor->string . '{', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6192 "PHP_Parser.php"
#line 1212 "PHP_Parser.y"
    function yy_r293(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -1]->minor->string . '}', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6197 "PHP_Parser.php"
#line 1215 "PHP_Parser.y"
    function yy_r294(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -1]->minor->string . '->', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6202 "PHP_Parser.php"
#line 1221 "PHP_Parser.y"
    function yy_r297(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -3]->minor . '[' . $this->yystack[$this->yyidx + -1]->minor . ']');
    }
#line 6207 "PHP_Parser.php"
#line 1224 "PHP_Parser.y"
    function yy_r298(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor . '->' . $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6212 "PHP_Parser.php"
#line 1230 "PHP_Parser.y"
    function yy_r300(){
    $this->_retvalue = new PHPyyToken('${' . $this->yystack[$this->yyidx + -4]->minor . '[' . $this->yystack[$this->yyidx + -2]->minor->string . ']}', $this->yystack[$this->yyidx + -2]->minor);
    }
#line 6217 "PHP_Parser.php"
#line 1233 "PHP_Parser.y"
    function yy_r301(){
    $this->_retvalue = new PHPyyToken('{' . $this->yystack[$this->yyidx + -1]->minor->string, '}', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6222 "PHP_Parser.php"
#line 1237 "PHP_Parser.y"
    function yy_r302(){
    $this->_retvalue = new PHPyyToken('isset(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6227 "PHP_Parser.php"
#line 1240 "PHP_Parser.y"
    function yy_r303(){
    $this->_retvalue = new PHPyyToken('empty(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6232 "PHP_Parser.php"
#line 1243 "PHP_Parser.y"
    function yy_r304(){
    $this->_retvalue = new PHPyyToken('include ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue[] = array(
        'type' => 'include',
        'file' => $this->yystack[$this->yyidx + 0]->minor->string,
    );
    }
#line 6241 "PHP_Parser.php"
#line 1250 "PHP_Parser.y"
    function yy_r305(){
    $this->_retvalue = new PHPyyToken('include_once ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue[] = array(
        'type' => 'include_once',
        'file' => $this->yystack[$this->yyidx + 0]->minor->string,
    );
    }
#line 6250 "PHP_Parser.php"
#line 1257 "PHP_Parser.y"
    function yy_r306(){
    $this->_retvalue = new PHPyyToken('eval ' . $this->yystack[$this->yyidx + -1]->minor->string, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6255 "PHP_Parser.php"
#line 1260 "PHP_Parser.y"
    function yy_r307(){
    $this->_retvalue = new PHPyyToken('require ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue[] = array(
        'type' => 'require',
        'file' => $this->yystack[$this->yyidx + 0]->minor->string,
    );
    }
#line 6264 "PHP_Parser.php"
#line 1267 "PHP_Parser.y"
    function yy_r308(){
    $this->_retvalue = new PHPyyToken('require_once ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue[] = array(
        'type' => 'require_once',
        'file' => $this->yystack[$this->yyidx + 0]->minor->string,
    );
    }
#line 6273 "PHP_Parser.php"
#line 1281 "PHP_Parser.y"
    function yy_r311(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor . '::' . $this->yystack[$this->yyidx + 0]->minor, array('usedclass' => $this->yystack[$this->yyidx + -2]->minor));
    $this->_retvalue[] = array('usedclassconstant' => $this->yystack[$this->yyidx + -2]->minor . '::' . $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6279 "PHP_Parser.php"
#line 1288 "PHP_Parser.y"
    function yy_r313(){$this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -3]->minor . '(' . (string) $this->yystack[$this->yyidx + -1]->minor . ')', $this->yystack[$this->yyidx + -1]->minor);    }
#line 6282 "PHP_Parser.php"
#line 1289 "PHP_Parser.y"
    function yy_r314(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -5]->minor . '::' . $this->yystack[$this->yyidx + -3]->minor . '(' . $this->yystack[$this->yyidx + -1]->minor->string . ')',
            $this->yystack[$this->yyidx + -1]->minor);
    $this->_retvalue[] = array(
        'uses' => 'class',
        'name' => $this->yystack[$this->yyidx + -5]->minor,
    );
    $this->_retvalue[] = array(
        'uses' => 'method',
        'class' => $this->yystack[$this->yyidx + -5]->minor,
        'name' => $this->yystack[$this->yyidx + -3]->minor,
    );
    }
#line 6297 "PHP_Parser.php"
#line 1302 "PHP_Parser.y"
    function yy_r315(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -5]->minor . '::' . (string) $this->yystack[$this->yyidx + -3]->minor . '(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    $this->_retvalue[] = array(
        'uses' => 'class',
        'name' => $this->yystack[$this->yyidx + -5]->minor,
    );
    }
#line 6307 "PHP_Parser.php"
#line 1310 "PHP_Parser.y"
    function yy_r316(){
    $this->_retvalue = new PHPyyToken((string) $this->yystack[$this->yyidx + -3]->minor . '(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 6313 "PHP_Parser.php"
#line 1319 "PHP_Parser.y"
    function yy_r321(){
    $this->_retvalue = new PHPyyToken('"' . $this->yystack[$this->yyidx + -1]->minor->string . '"', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6318 "PHP_Parser.php"
#line 1322 "PHP_Parser.y"
    function yy_r322(){
    $this->_retvalue = new PHPyyToken("'" . $this->yystack[$this->yyidx + -1]->minor->string . "'", $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6323 "PHP_Parser.php"
#line 1325 "PHP_Parser.y"
    function yy_r323(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -2]->minor->string . $this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6328 "PHP_Parser.php"
#line 1332 "PHP_Parser.y"
    function yy_r326(){
    $this->_retvalue = new PHPyyToken($this->yystack[$this->yyidx + -3]->minor->string . '->' . $this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = array('usedmember' => array($this->yystack[$this->yyidx + -3]->minor->string, $this->yystack[$this->yyidx + -1]->minor->string));
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6335 "PHP_Parser.php"
#line 1339 "PHP_Parser.y"
    function yy_r328(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    $this->yystack[$this->yyidx + -1]->minor[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6341 "PHP_Parser.php"
#line 1345 "PHP_Parser.y"
    function yy_r330(){
    $this->_retvalue = new PHPyyToken('->' . $this->yystack[$this->yyidx + 0]->minor->string, array('usedmember' => $this->yystack[$this->yyidx + 0]->minor->string));
    }
#line 6346 "PHP_Parser.php"
#line 1354 "PHP_Parser.y"
    function yy_r333(){$this->_retvalue = ',';    }
#line 6349 "PHP_Parser.php"
#line 1366 "PHP_Parser.y"
    function yy_r339(){$this->_retvalue = true;    }
#line 6352 "PHP_Parser.php"
#line 1367 "PHP_Parser.y"
    function yy_r340(){$this->_retvalue = false;    }
#line 6355 "PHP_Parser.php"

    /**
     * placeholder for the left hand side in a reduce operation.
     * 
     * For a parser with a rule like this:
     * <pre>
     * rule(A) ::= B. { A = 1; }
     * </pre>
     * 
     * The parser will translate to something like:
     * 
     * <code>
     * function yy_r0(){$this->_retvalue = 1;}
     * </code>
     */
    private $_retvalue;

    /**
     * Perform a reduce action and the shift that must immediately
     * follow the reduce.
     * 
     * For a rule such as:
     * 
     * <pre>
     * A ::= B blah C. { dosomething(); }
     * </pre>
     * 
     * This function will first call the action, if any, ("dosomething();" in our
     * example), and then it will pop three states from the stack,
     * one for each entry on the right-hand side of the expression
     * (B, blah, and C in our example rule), and then push the result of the action
     * back on to the stack with the resulting state reduced to (as described in the .out
     * file)
     * @param int Number of the rule by which to reduce
     */
    function yy_reduce($yyruleno)
    {
        //int $yygoto;                     /* The next state */
        //int $yyact;                      /* The next action */
        //mixed $yygotominor;        /* The LHS of the rule reduced */
        //PHPyyStackEntry $yymsp;            /* The top of the parser's stack */
        //int $yysize;                     /* Amount to pop the stack */
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            /* If we are not debugging and the reduce action popped at least
            ** one element off the stack, then we can push the new element back
            ** onto the stack here, and skip the stack overflow test in yy_shift().
            ** That gives a significant speed improvement. */
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new PHPyyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    /**
     * The following code executes when the parse fails
     */
    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser fails */
    }

    /**
     * The following code executes when a syntax error first occurs.
     * @param int The major type of the error token
     * @param mixed The minor type of the error token
     */
    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 3 "PHP_Parser.y"

/* ?><?php */
    echo "Syntax Error on line " . $this->lex->line . ": token '" . 
        $this->lex->value . "' while parsing rule:";
    foreach ($this->yystack as $entry) {
        echo $this->PHPTokenName($entry->major) . ' ';
    }
    foreach ($this->yy_get_expected_tokens($yymajor) as $token) {
        $expect[] = self::$yyTokenName[$token];
    }
    throw new Exception('Unexpected ' . $this->tokenName($yymajor) . '(' . $TOKEN
        . '), expected one of: ' . implode(',', $expect));
#line 6477 "PHP_Parser.php"
    }

    /*
    ** The following is executed when the parser accepts
    */
    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser accepts */
#line 109 "PHP_Parser.y"

    var_dump($this->data);
#line 6497 "PHP_Parser.php"
    }

    /**
     *  The main parser program.
     * The first argument is a pointer to a structure obtained from
     * "PHPAlloc" which describes the current state of the parser.
     * The second argument is the major token number.  The third is
     * the minor token.  The fourth optional argument is whatever the
     * user wants (and specified in the grammar) and is available for
     * use by the action routines.
     *
     * Inputs:
     * 
     * - A pointer to the parser (an opaque structure.)
     * - The major token number.
     * - The minor token number (token value).
     * - An option argument of a grammar-specified type.
     *
     * Outputs:
     * None.
     * @param int the token number
     * @param mixed the token value
     * @param mixed any extra arguments that should be passed to handlers
     */
    function doParse($yymajor, $yytokenvalue, $extraargument = null)
    {
        if (self::PHPARG_DECL && $extraargument !== null) {
            $this->{self::PHPARG_DECL} = $extraargument;
        }
//        YYMINORTYPE yyminorunion;
//        int yyact;            /* The parser action. */
//        int yyendofinput;     /* True if we are at the end of input */
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        /* (re)initialize the parser, if necessary */
        if ($this->yyidx === null || $this->yyidx < 0) {
            /* if ($yymajor == 0) return; // not sure why this was here... */
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new PHPyyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, self::$yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    /* A syntax error has occurred.
                    ** The response to an error depends upon whether or not the
                    ** grammar defines an error token "ERROR".  
                    **
                    ** This is what we do if the grammar does define ERROR:
                    **
                    **  * Call the %syntax_error function.
                    **
                    **  * Begin popping the stack until we enter a state where
                    **    it is legal to shift the error symbol, then shift
                    **    the error symbol.
                    **
                    **  * Set the error count to three.
                    **
                    **  * Begin accepting and shifting new tokens.  No new error
                    **    processing will occur until three tokens have been
                    **    shifted successfully.
                    **
                    */
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, self::$yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    /* YYERRORSYMBOL is not defined */
                    /* This is what we do if the grammar does not define ERROR:
                    **
                    **  * Report an error message, and throw away the input token.
                    **
                    **  * If the input token is $, then fail the parse.
                    **
                    ** As before, subsequent error messages are suppressed until
                    ** three input tokens have been successfully shifted.
                    */
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}