<?php
/**
 * Unit tests for PHP_LexerGenerator_Lexer
 *
 * @author Alan Langford <jal@ambitonline.com>
 * @package PHP_LexerGenerator
 * @version $Id: LexerTest.php 294970 2010-02-12 03:46:38Z clockwerx $
 */

require_once 'LexerOutputRecorder.php';

/**
 * Tests for the Lexer.
 *
 * This class contains low level tests that verify the token stream generated by
 * the lexer.
 * @version @package_version@
 */
class LexerTest extends PHPUnit_Framework_TestCase {

    public function testMinimalLexer() {
        $recorder = new LexerOutputRecorder();
        $testResult = $recorder -> process('file', 'data/MinimalLexer.plex');
        $expected = unserialize(file_get_contents(dirname(__FILE__) . '/data/MinimalLexer.expect.dat'));
        $this->assertEquals($testResult, $expected);
    }

    public function testDeclareEquals() {
        $recorder = new LexerOutputRecorder();
        $testResult = $recorder -> process('file', 'data/DeclareEquals.plex');
        $expected = unserialize(file_get_contents(dirname(__FILE__) . '/data/DeclareEquals.expect.dat'));
        $this->assertEquals($testResult, $expected);
    }

    public function testComments() {
        $recorder = new LexerOutputRecorder();
        $testResult = $recorder -> process('file', 'data/Comments.plex');
        $expected = unserialize(file_get_contents(dirname(__FILE__) . '/data/Comments.expect.dat'));
        $this->assertEquals($testResult, $expected);
    }

}
?>
