<?php
/*
  +----------------------------------------------------------------------+
  | PHP Version 4                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2008 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.0 of the PHP license,       |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_0.txt.                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors:    Gabor Hojtsy <goba@php.net>                              |
  +----------------------------------------------------------------------+

  $Id: phpweb-entities.php,v 1.1 2008/02/02 15:09:40 farell Exp $
*/

set_time_limit(0);

// Too few or too many parameters
if ($argc != 3) { die("ERROR in " . __FILE__ . ": Too few or too many parameters"); }

// Workdir is the first param
$workdir = $argv[1];

// Whether we are in phpweb mode
$phpweb_mode = ($argv[2] == "phpweb");

// Entity file for phpweb entities
$phpweb_ent = "$workdir/entities/phpweb.ent";

// Automatically generated file note
$autonote = "<!-- This file is autogenerated - don't touch it by hand! -->\n";

// Replace current phpweb.ent with a 0 byte file
if (!$phpweb_mode) {
    $pe = fopen($phpweb_ent, "w");
    fwrite($pe, $autonote);
    fclose($pe);
    echo "$phpweb_ent should be empty now...\n";
    exit;
}

echo "creating $phpweb_ent...\n";

// Read in global.ent from the source dir
$lines = file("@SRCDIR@/entities/global.ent");

// Collect all phpweb entities
$phpweb_entities = array($autonote);
foreach ($lines as $line) {
    if (strpos($line, "http://www.php.net") !== FALSE) {
        $phpweb_entities[] = str_replace("http://www.php.net", "", $line);
    }
}

// Write out entity file
$pe = fopen($phpweb_ent, "w");
fwrite($pe, join("", $phpweb_entities));
fclose($pe);