<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker */
// $Id: mask.php,v 1.1 2008/05/26 03:03:26 firman Exp $

/**
 * Image_Tools
 */
require_once 'Image/Tools.php';

// creates an instance of Mask tool object
$mask = Image_Tools::factory('mask');
if (PEAR::isError($mask)) {
    echo $mask->toString();
    exit;
}

// set destination image
$mask->set('image', dirname(__FILE__) . '/images/zebra.jpg');

// set mask image
$mask->set('mask', dirname(__FILE__) . '/images/masker.png');

// set sample image to be masking
$mask->set('sample', dirname(__FILE__) . '/images/3dgirl.jpg');

// display the result image
$err = $mask->display(IMAGETYPE_JPEG);
if (PEAR::isError($err)) {
    echo $err->toString();
    exit;
}
