<?php
// Call HTML_Template_PHPLIB_GeneratorTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD')) {
    define('PHPUnit_MAIN_METHOD', 'HTML_Template_PHPLIB_GeneratorTest::main');
}

require_once dirname(__FILE__) . '/helper.inc';

require_once 'HTML/Template/PHPLIB/Generator.php';

/**
 * Test class for HTML_Template_PHPLIB_Generator.
 * Generated by PHPUnit on 2007-10-03 at 21:44:43.
 */
class HTML_Template_PHPLIB_GeneratorTest extends PHPUnit_Framework_TestCase {
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once 'PHPUnit/TextUI/TestRunner.php';

        $suite  = new PHPUnit_Framework_TestSuite('HTML_Template_PHPLIB_GeneratorTest');
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    }


    /**
     */
    public function testGetBlocks()
    {
        $strTemplate = <<<EOT
<!-- BEGIN one -->
 <!-- BEGIN three -->
  <!-- BEGIN four -->
   <!-- BEGIN six -->
    some text
   <!-- END six -->
  <!-- END four -->
 <!-- END three -->
 <!-- BEGIN five -->
 <!-- END five -->
<!-- END one -->
<!-- BEGIN two -->
<!-- END two -->
EOT;
        $arBlocks = HTML_Template_PHPLIB_Generator::getBlocks(
            HTML_Template_PHPLIB_Helper::splitLines($strTemplate)
        );

        $this->assertEquals(2, count($arBlocks));
        $this->assertArrayHasKey('one', $arBlocks);
        $this->assertArrayHasKey('two', $arBlocks);
        $this->assertEquals(2, count($arBlocks['one']['sub']));
        $this->assertArrayHasKey('three', $arBlocks['one']['sub']);
        $this->assertArrayHasKey('five',  $arBlocks['one']['sub']);
        $this->assertArrayHasKey('four',  $arBlocks['one']['sub']['three']['sub']);
    }//public function testGetBlocks()



    public function testGetTemplateNameFromFilename()
    {
        $this->assertEquals(
            'some',
            HTML_Template_PHPLIB_Generator::getTemplateNameFromFilename(
                'some.tpl'
            )
        );
        $this->assertEquals(
            'order',
            HTML_Template_PHPLIB_Generator::getTemplateNameFromFilename(
                '/path/to/templates/order.mail'
            )
        );
        /*
        //does not work on unix
        $this->assertEquals(
            'mytemplate',
            HTML_Template_PHPLIB_Generator::getTemplateNameFromFilename(
                'C:\\mytemplate.ihtml'
            )
        );
        */
    }//public function testGetTemplateNameFromFilename()
}

// Call HTML_Template_PHPLIB_GeneratorTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'HTML_Template_PHPLIB_GeneratorTest::main') {
    HTML_Template_PHPLIB_GeneratorTest::main();
}
?>
