<?php
/**
 * Console GetoptPlus/Help tests
 *
 * PHP version 5
 *
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * + Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * + Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation and/or
 * other materials provided with the distribution.
 * + The names of its contributors may not be used to endorse or promote
 * products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @category  PHP
 * @package   Console_GetoptPlus
 * @author    Michel Corne <mcorne@yahoo.com>
 * @copyright 2008 Michel Corne
 * @license   http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version   SVN: $Id: HelpTest.php 47 2008-01-10 11:03:38Z mcorne $
 * @link      http://pear.php.net/package/Console_GetoptPlus
 */
// Call tests_GetoptPlus_HelpTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "tests_GetoptPlus_HelpTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'Console/GetoptPlus/Help.php';

/**
 * Test class for Console_GetoptPlus_Help.
 * Generated by PHPUnit_Util_Skeleton on 2007-05-17 at 11:00:39.
 *
 * @category  PHP
 * @package   Console_GetoptPlus
 * @author    Michel Corne <mcorne@yahoo.com>
 * @copyright 2008 Michel Corne
 * @license   http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version   Release:@package_version@
 * @link      http://pear.php.net/package/Console_GetoptPlus
 */
class tests_GetoptPlus_HelpTest extends PHPUnit_Framework_TestCase
{
    private $help;

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main()
    {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite = new PHPUnit_Framework_TestSuite("Console_GetoptPlus_HelpTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp()
    {
        $this->help = new Console_GetoptPlus_Help();
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown()
    {
    }

    /**
     * Tests tidyString()
     */
    public function testTidyString()
    {
        // format: <string>, <expected tidied string>
        $test = array(// /
            0 => array(null, ''),
            1 => array('', ''),
            2 => array(array(), ''),
            3 => array(array('foo'), 'foo'),
            );

        foreach($test as $idx => $values) {
            list($string, $expected) = $values;
            // tidies the string
            $tidied = $this->help->tidyString($string);
            $this->assertEquals($expected, $tidied , 'test #' . $idx);
        }
    }

    /**
     * Tests tidyArray()
     */
    public function testTidyArray()
    {
        // format: <array>, <expected tidied array>
        $test = array(// /
            0 => array(null, array()),
            1 => array('', array('')),
            2 => array('foo', array('foo')),
            3 => array(array(), array()),
            4 => array(array('foo'), array('foo')),
            );

        foreach($test as $idx => $values) {
            list($array, $expected) = $values;
            // tidies the string
            $tidied = $this->help->tidyArray($array);
            $this->assertEquals($expected, $tidied , 'test #' . $idx);
        }
    }

    /**
     * Tests alignLines()
     */
    public function testAlignLines()
    {
        // format: <lines>, <first line addon>, <padding length>, <expected tidied lines>
        $test = array(// /
            // no line or empty line + no addon
            0 => array(null, null, null, array('')),
            1 => array(null, null, 0, array('')),
            2 => array(null, null, 1, array('')),
            3 => array('', '', null, array('')),
            4 => array('', '', 0, array('')),
            5 => array('', '', 1, array('')),
            // no line or empty line + addon
            10 => array(null, 'addon', null, array('addon')),
            11 => array(null, 'addon', 0, array('addon')),
            12 => array(null, 'addon', 1, array('addon')),
            13 => array(null, 'addon', 5, array('addon')),
            14 => array(null, 'addon', 6, array('addon')),
            15 => array('', 'addon', null, array('addon')),
            16 => array('', 'addon', 0, array('addon')),
            17 => array('', 'addon', 1, array('addon')),
            18 => array('', 'addon', 5, array('addon')),
            19 => array('', 'addon', 6, array('addon')),
            // 1 lines + no addon
            20 => array('some text', '', null, array('some text')),
            21 => array('some text', '', 0, array('some text')),
            22 => array('some text', null, 1, array(' some text')),
            // 1 line + addon
            30 => array('some text', 'addon', null, array('addon some text')),
            31 => array('some text', 'addon', 0, array('addon', 'some text')),
            32 => array('some text', 'addon', 1, array('addon', ' some text')),
            33 => array('some text', 'addon', 5, array('addon', '     some text')),
            34 => array('some text', 'addon', 6, array('addon some text')),
            // 2 lines + addon
            40 => array(array('some text', 'second line'), 'addon', null,
                array('addon some text', '      second line')),
            41 => array(array('some text', 'second line'), 'addon', 0,
                array('addon', 'some text', 'second line')),
            42 => array(array('some text', 'second line'), 'addon', 1,
                array('addon', ' some text', ' second line')),
            43 => array(array('some text', 'second line'), 'addon', 5,
                array('addon', '     some text', '     second line')),
            44 => array(array('some text', 'second line'), 'addon', 6,
                array('addon some text', '      second line')),
            );

        foreach($test as $idx => $values) {
            list($lines, $addon, $paddingLength, $expected) = $values;
            // tidies the string
            $tidied = $this->help->alignLines($lines, $addon, $paddingLength);
            $this->assertEquals($expected, $tidied , 'test #' . $idx);
        }
    }

    /**
     * Tests setUsage()
     */
    public function testSetUsage()
    {
        // format: <config>, <expected usage text>
        $test = array(// /
            0 => array(null, array('Usage: command')),
            1 => array(array('options' => true), array('Usage: command [options]')),
            2 => array(array('parameters' => true), array('Usage: command [parameters]')),
            3 => array(// /
                array('options' => true, 'parameters' => true),
                array('Usage: command [options] [parameters]')),
            4 => array(// /
                array('usage' => 'blabla...'),
                array('Usage: command blabla...')),
            5 => array(// /
                array('usage' => array(array('first line...', 'second line...'))),
                array(// /
                    'Usage: command first line...',
                    '               second line...')),
            6 => array(// /
                array('usage' => array(// /
                        array('first usage first line...', 'first usage second line...'),
                        array('second usage first line...', 'second usage second line...'))),
                array(// /
                    'Usage: command first usage first line...',
                    '               first usage second line...',
                    '       command second usage first line...',
                    '               second usage second line...')),
            );

        foreach($test as $idx => $values) {
            list($config, $expected) = $values;
            // sets the command usages
            $tidied = $this->help->setUsage($config, 'command');
            $this->assertEquals($expected, $tidied , 'test #' . $idx);
        }
    }

    /**
     * Tests setOptions()
     */
    public function testSetOptions()
    {
        // format: <options configuration>, <expected options usage>
        $test = array(// /
            // no description
            0 => array(null, array()),
            1 => array(// /
                array(array('long' => 'foo', 'type' => 'noarg')),
                array('Options:', '--foo')),
            2 => array(// /
                array(array('short' => 'f', 'type' => 'mandatory', 'desc' => 'name')),
                array('Options:', '-f <name>')),
            3 => array(// /
                array(array('long' => 'foo', 'short' => 'f', 'type' => 'optional', 'desc' => 'name')),
                array('Options:', '-f --foo [name]')),
            // 1 line description
            10 => array(// /
                array(array('long' => 'foo', 'type' => 'noarg',
                        'desc' => 'option description...')),
                array('Options:', '--foo                         option description...')),
            11 => array(// /
                array(array('long' => 'foo', 'type' => 'mandatory',
                        'desc' => array('name', 'option description...'))),
                array('Options:', '--foo <name>                  option description...')),
            12 => array(// /
                array(array('long' => 'foo', 'type' => 'optional',
                        'desc' => array('name', 'option description...'))),
                array('Options:', '--foo [name]                  option description...')),
            // 2 line description
            20 => array(// /
                array(array('long' => 'foo', 'type' => 'noarg', 'desc' => array(// /
                            'option description first line...',
                            'option description second line...'))),
                array(// /
                    'Options:',
                    '--foo                         option description first line...',
                    '                              option description second line...')),
            21 => array(// /
                array(array('long' => 'foo', 'type' => 'mandatory', 'desc' => array(// /
                            'name',
                            'option description first line...',
                            'option description second line...'))),
                array(// /
                    'Options:',
                    '--foo <name>                  option description first line...',
                    '                              option description second line...')),
            22 => array(// /
                array(array('long' => 'foo', 'type' => 'optional', 'desc' => array(// /
                            'name',
                            'option description first line...',
                            'option description second line...'))),
                array(// /
                    'Options:',
                    '--foo [name]                  option description first line...',
                    '                              option description second line...')),
            // integrated
            30 => array(// /
                array(// /
                    array('long' => 'foo', 'type' => 'noarg', 'desc' => array(// /
                            'option foo description first line...',
                            'option foo description second line...')),
                    array('long' => 'bar', 'type' => 'mandatory', 'short' => 'b', 'desc' => array(// /
                            'name',
                            'option bar description first line...',
                            'option bar description second line...')),
                    array('short' => 'c', 'type' => 'optional', 'desc' => array(// /
                            'value',
                            'option c description first line...',
                            'option c description second line...'))),
                array(// /
                    'Options:',
                    '--foo                         option foo description first line...',
                    '                              option foo description second line...',
                    '-b --bar <name>               option bar description first line...',
                    '                              option bar description second line...',
                    '-c [value]                    option c description first line...',
                    '                              option c description second line...')),
            );

        foreach($test as $idx => $values) {
            list($optionsConfig, $expected) = $values;
            // sets the command usages
            $tidied = $this->help->setOptions($optionsConfig);
            $this->assertEquals($expected, $tidied , 'test #' . $idx);
        }
    }

    /**
     * Tests set()
     */
    public function testSet()
    {
        $config = array(// /
            'header' => array('Note: some text ...', '... more text.', ''),
            'options' => array(// /
                array('long' => 'foo', 'type' => 'noarg', 'desc' => array(// /
                        'option foo description first line...',
                        'option foo description second line...')),
                array('long' => 'bar', 'type' => 'mandatory', 'short' => 'b', 'desc' => array(// /
                        'name',
                        'option bar description first line...',
                        'option bar description second line...')),
                array('short' => 'c', 'type' => 'optional', 'desc' => array(// /
                        'value',
                        'option c description first line...',
                        'option c description second line...'))),
            'parameters' => array('[param1] [,param2]', 'The parameters decription.'),
            'footer' => array('Note: some text ...', '... more text.'),
            );

        $expected = array(// /
            'Note: some text ...',
            '... more text.',
            '',
            'Usage: command [options] [parameters]',
            'Options:',
            '--foo                         option foo description first line...',
            '                              option foo description second line...',
            '-b --bar <name>               option bar description first line...',
            '                              option bar description second line...',
            '-c [value]                    option c description first line...',
            '                              option c description second line...',
            'Parameters: [param1] [,param2]',
            '            The parameters decription.',
            'Note: some text ...',
            '... more text.'
            );

        $help = $this->help->set($config, 'command');
        is_string($help) and $help = explode("\n", $help);

        $this->assertEquals($expected, $help);
    }

    /**
     * Tests get()
     */
    public function testget()
    {
        $expected = array('Usage: command');

        $help = Console_GetoptPlus_Help::get(array(), 'command');
        is_string($help) and $help = explode("\n", $help);

        $this->assertEquals($expected, $help);
    }
}
// Call tests_GetoptPlus_HelpTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "tests_GetoptPlus_HelpTest::main") {
    tests_GetoptPlus_HelpTest::main();
}

?>
