/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;

public class JavadocVariableCheck
extends Check {
    private Scope mScope = Scope.PRIVATE;
    private Scope mExcludeScope;

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    public void setExcludeScope(String aScope) {
        this.mExcludeScope = Scope.getInstance(aScope);
    }

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    public void visitToken(DetailAST aAST) {
        FileContents contents;
        TextBlock cmt;
        if (this.shouldCheck(aAST) && (cmt = (contents = this.getFileContents()).getJavadocBefore(aAST.getLineNo())) == null) {
            this.log(aAST, "javadoc.missing");
        }
    }

    private boolean shouldCheck(DetailAST aAST) {
        if (ScopeUtils.inCodeBlock(aAST)) {
            return false;
        }
        DetailAST mods = aAST.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
        Scope scope = ScopeUtils.inInterfaceBlock(aAST) ? Scope.PUBLIC : declaredScope;
        Scope surroundingScope = ScopeUtils.getSurroundingScope(aAST);
        return scope.isIn(this.mScope) && surroundingScope.isIn(this.mScope) && (this.mExcludeScope == null || !scope.isIn(this.mExcludeScope) || !surroundingScope.isIn(this.mExcludeScope));
    }
}

