/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.psvi.ObjectList;
import org.apache.xerces.impl.xs.psvi.StringList;
import org.apache.xerces.impl.xs.psvi.XSAttributeDeclaration;
import org.apache.xerces.impl.xs.psvi.XSAttributeGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSElementDeclaration;
import org.apache.xerces.impl.xs.psvi.XSModelGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSNamedMap;
import org.apache.xerces.impl.xs.psvi.XSNamespaceItem;
import org.apache.xerces.impl.xs.psvi.XSNotationDeclaration;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.util.ObjectListImpl;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.impl.xs.util.StringListImpl;
import org.apache.xerces.impl.xs.util.XSNamedMap4Types;
import org.apache.xerces.impl.xs.util.XSNamedMapImpl;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;

public class SchemaGrammar
implements Grammar,
XSNamespaceItem {
    public String fTargetNamespace;
    SymbolHash fGlobalAttrDecls;
    SymbolHash fGlobalAttrGrpDecls;
    SymbolHash fGlobalElemDecls;
    SymbolHash fGlobalGroupDecls;
    SymbolHash fGlobalNotationDecls;
    SymbolHash fGlobalIDConstraintDecls;
    SymbolHash fGlobalTypeDecls;
    XSDDescription fGrammarDescription = null;
    private static final int BASICSET_COUNT = 29;
    private static final int FULLSET_COUNT = 46;
    private static final int GRAMMAR_XS = 1;
    private static final int GRAMMAR_XSI = 2;
    Vector fImported = null;
    private static final int INITIAL_SIZE = 16;
    private static final int INC_SIZE = 16;
    private int fCTCount = 0;
    private XSComplexTypeDecl[] fComplexTypeDecls = new XSComplexTypeDecl[16];
    private SimpleLocator[] fCTLocators = new SimpleLocator[16];
    private static final int REDEFINED_GROUP_INIT_SIZE = 2;
    private int fRGCount = 0;
    private XSGroupDecl[] fRedefinedGroupDecls = new XSGroupDecl[2];
    private SimpleLocator[] fRGLocators = new SimpleLocator[1];
    boolean fFullChecked = false;
    private int fSubGroupCount = 0;
    private XSElementDecl[] fSubGroups = new XSElementDecl[16];
    public static final XSComplexTypeDecl fAnyType = new XSComplexTypeDecl();
    public static final SchemaGrammar SG_SchemaNS;
    public static final XSSimpleType fAnySimpleType;
    public static final SchemaGrammar SG_XSI;
    private static final short MAX_COMP_IDX = 14;
    private static final boolean[] GLOBAL_COMP;
    private XSNamedMap[] fComponents = null;
    private Vector fDocuments = null;
    private Vector fLocations = null;

    public SchemaGrammar(String string, XSDDescription xSDDescription) {
        this.fTargetNamespace = string;
        this.fGrammarDescription = xSDDescription;
        this.fGlobalAttrDecls = new SymbolHash();
        this.fGlobalAttrGrpDecls = new SymbolHash();
        this.fGlobalElemDecls = new SymbolHash();
        this.fGlobalGroupDecls = new SymbolHash();
        this.fGlobalNotationDecls = new SymbolHash();
        this.fGlobalTypeDecls = new SymbolHash();
        this.fGlobalIDConstraintDecls = new SymbolHash();
    }

    protected SchemaGrammar(int n) {
        SchemaDVFactory schemaDVFactory = SchemaDVFactory.getInstance();
        if (n == 1) {
            this.fTargetNamespace = SchemaSymbols.URI_SCHEMAFORSCHEMA;
            this.fGrammarDescription = new XSDDescription();
            this.fGrammarDescription.fContextType = (short)3;
            this.fGrammarDescription.fTargetNamespace = SchemaSymbols.URI_SCHEMAFORSCHEMA;
            this.fGlobalAttrDecls = new SymbolHash(1);
            this.fGlobalAttrGrpDecls = new SymbolHash(1);
            this.fGlobalElemDecls = new SymbolHash(1);
            this.fGlobalGroupDecls = new SymbolHash(1);
            this.fGlobalNotationDecls = new SymbolHash(1);
            this.fGlobalIDConstraintDecls = new SymbolHash(1);
            this.fGlobalTypeDecls = schemaDVFactory.getBuiltInTypes();
            this.addGlobalTypeDecl(fAnyType);
        } else if (n == 2) {
            this.fTargetNamespace = "http://www.w3.org/2001/XMLSchema-instance";
            this.fGrammarDescription = new XSDDescription();
            this.fGrammarDescription.fContextType = (short)3;
            this.fGrammarDescription.fTargetNamespace = "http://www.w3.org/2001/XMLSchema-instance";
            this.fGlobalAttrGrpDecls = new SymbolHash(1);
            this.fGlobalElemDecls = new SymbolHash(1);
            this.fGlobalGroupDecls = new SymbolHash(1);
            this.fGlobalNotationDecls = new SymbolHash(1);
            this.fGlobalIDConstraintDecls = new SymbolHash(1);
            this.fGlobalTypeDecls = new SymbolHash(1);
            this.fGlobalAttrDecls = new SymbolHash(8);
            XSAttributeDecl xSAttributeDecl = new XSAttributeDecl();
            xSAttributeDecl.fName = "type".intern();
            xSAttributeDecl.fTargetNamespace = "http://www.w3.org/2001/XMLSchema-instance";
            xSAttributeDecl.fType = schemaDVFactory.getBuiltInType("QName");
            xSAttributeDecl.fScope = 1;
            this.fGlobalAttrDecls.put(xSAttributeDecl.fName, xSAttributeDecl);
            xSAttributeDecl = new XSAttributeDecl();
            xSAttributeDecl.fName = "nil".intern();
            xSAttributeDecl.fTargetNamespace = "http://www.w3.org/2001/XMLSchema-instance";
            xSAttributeDecl.fType = schemaDVFactory.getBuiltInType("boolean");
            xSAttributeDecl.fScope = 1;
            this.fGlobalAttrDecls.put(xSAttributeDecl.fName, xSAttributeDecl);
            XSSimpleType xSSimpleType = schemaDVFactory.getBuiltInType("anyURI");
            xSAttributeDecl = new XSAttributeDecl();
            xSAttributeDecl.fName = "schemaLocation".intern();
            xSAttributeDecl.fTargetNamespace = "http://www.w3.org/2001/XMLSchema-instance";
            xSAttributeDecl.fType = schemaDVFactory.createTypeList(null, "http://www.w3.org/2001/XMLSchema-instance", (short)0, xSSimpleType);
            xSAttributeDecl.fScope = 1;
            this.fGlobalAttrDecls.put(xSAttributeDecl.fName, xSAttributeDecl);
            xSAttributeDecl = new XSAttributeDecl();
            xSAttributeDecl.fName = "noNamespaceSchemaLocation".intern();
            xSAttributeDecl.fTargetNamespace = "http://www.w3.org/2001/XMLSchema-instance";
            xSAttributeDecl.fType = xSSimpleType;
            xSAttributeDecl.fScope = 1;
            this.fGlobalAttrDecls.put(xSAttributeDecl.fName, xSAttributeDecl);
        }
    }

    public XMLGrammarDescription getGrammarDescription() {
        return this.fGrammarDescription;
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public void setImportedGrammars(Vector vector) {
        this.fImported = vector;
    }

    public Vector getImportedGrammars() {
        return this.fImported;
    }

    public final String getTargetNamespace() {
        return this.fTargetNamespace;
    }

    public final void addGlobalAttributeDecl(XSAttributeDecl xSAttributeDecl) {
        this.fGlobalAttrDecls.put(xSAttributeDecl.fName, xSAttributeDecl);
    }

    public final void addGlobalAttributeGroupDecl(XSAttributeGroupDecl xSAttributeGroupDecl) {
        this.fGlobalAttrGrpDecls.put(xSAttributeGroupDecl.fName, xSAttributeGroupDecl);
    }

    public final void addGlobalElementDecl(XSElementDecl xSElementDecl) {
        this.fGlobalElemDecls.put(xSElementDecl.fName, xSElementDecl);
        if (xSElementDecl.fSubGroup != null) {
            if (this.fSubGroupCount == this.fSubGroups.length) {
                this.fSubGroups = SchemaGrammar.resize(this.fSubGroups, this.fSubGroupCount + 16);
            }
            this.fSubGroups[this.fSubGroupCount++] = xSElementDecl;
        }
    }

    public final void addGlobalGroupDecl(XSGroupDecl xSGroupDecl) {
        this.fGlobalGroupDecls.put(xSGroupDecl.fName, xSGroupDecl);
    }

    public final void addGlobalNotationDecl(XSNotationDecl xSNotationDecl) {
        this.fGlobalNotationDecls.put(xSNotationDecl.fName, xSNotationDecl);
    }

    public final void addGlobalTypeDecl(XSTypeDecl xSTypeDecl) {
        this.fGlobalTypeDecls.put(xSTypeDecl.getName(), xSTypeDecl);
    }

    public final void addIDConstraintDecl(XSElementDecl xSElementDecl, IdentityConstraint identityConstraint) {
        xSElementDecl.addIDConstaint(identityConstraint);
        this.fGlobalIDConstraintDecls.put(identityConstraint.getIdentityConstraintName(), identityConstraint);
    }

    public final XSAttributeDecl getGlobalAttributeDecl(String string) {
        return (XSAttributeDecl)this.fGlobalAttrDecls.get(string);
    }

    public final XSAttributeGroupDecl getGlobalAttributeGroupDecl(String string) {
        return (XSAttributeGroupDecl)this.fGlobalAttrGrpDecls.get(string);
    }

    public final XSElementDecl getGlobalElementDecl(String string) {
        return (XSElementDecl)this.fGlobalElemDecls.get(string);
    }

    public final XSGroupDecl getGlobalGroupDecl(String string) {
        return (XSGroupDecl)this.fGlobalGroupDecls.get(string);
    }

    public final XSNotationDecl getGlobalNotationDecl(String string) {
        return (XSNotationDecl)this.fGlobalNotationDecls.get(string);
    }

    public final XSTypeDecl getGlobalTypeDecl(String string) {
        return (XSTypeDecl)this.fGlobalTypeDecls.get(string);
    }

    public final IdentityConstraint getIDConstraintDecl(String string) {
        return (IdentityConstraint)this.fGlobalIDConstraintDecls.get(string);
    }

    public final void addComplexTypeDecl(XSComplexTypeDecl xSComplexTypeDecl, SimpleLocator simpleLocator) {
        if (this.fCTCount == this.fComplexTypeDecls.length) {
            this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount + 16);
            this.fCTLocators = SchemaGrammar.resize(this.fCTLocators, this.fCTCount + 16);
        }
        this.fCTLocators[this.fCTCount] = simpleLocator;
        this.fComplexTypeDecls[this.fCTCount++] = xSComplexTypeDecl;
    }

    public final void addRedefinedGroupDecl(XSGroupDecl xSGroupDecl, XSGroupDecl xSGroupDecl2, SimpleLocator simpleLocator) {
        if (this.fRGCount == this.fRedefinedGroupDecls.length) {
            this.fRedefinedGroupDecls = SchemaGrammar.resize(this.fRedefinedGroupDecls, this.fRGCount << 1);
            this.fRGLocators = SchemaGrammar.resize(this.fRGLocators, this.fRGCount);
        }
        this.fRGLocators[this.fCTCount / 2] = simpleLocator;
        this.fRedefinedGroupDecls[this.fRGCount++] = xSGroupDecl;
        this.fRedefinedGroupDecls[this.fRGCount++] = xSGroupDecl2;
    }

    final XSComplexTypeDecl[] getUncheckedComplexTypeDecls() {
        if (this.fCTCount < this.fComplexTypeDecls.length) {
            this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount);
            this.fCTLocators = SchemaGrammar.resize(this.fCTLocators, this.fCTCount);
        }
        return this.fComplexTypeDecls;
    }

    final SimpleLocator[] getUncheckedCTLocators() {
        if (this.fCTCount < this.fCTLocators.length) {
            this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount);
            this.fCTLocators = SchemaGrammar.resize(this.fCTLocators, this.fCTCount);
        }
        return this.fCTLocators;
    }

    final XSGroupDecl[] getRedefinedGroupDecls() {
        if (this.fRGCount < this.fRedefinedGroupDecls.length) {
            this.fRedefinedGroupDecls = SchemaGrammar.resize(this.fRedefinedGroupDecls, this.fRGCount);
            this.fRGLocators = SchemaGrammar.resize(this.fRGLocators, this.fRGCount / 2);
        }
        return this.fRedefinedGroupDecls;
    }

    final SimpleLocator[] getRGLocators() {
        if (this.fRGCount < this.fRedefinedGroupDecls.length) {
            this.fRedefinedGroupDecls = SchemaGrammar.resize(this.fRedefinedGroupDecls, this.fRGCount);
            this.fRGLocators = SchemaGrammar.resize(this.fRGLocators, this.fRGCount / 2);
        }
        return this.fRGLocators;
    }

    final void setUncheckedTypeNum(int n) {
        this.fCTCount = n;
        this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount);
        this.fCTLocators = SchemaGrammar.resize(this.fCTLocators, this.fCTCount);
    }

    final XSElementDecl[] getSubstitutionGroups() {
        if (this.fSubGroupCount < this.fSubGroups.length) {
            this.fSubGroups = SchemaGrammar.resize(this.fSubGroups, this.fSubGroupCount);
        }
        return this.fSubGroups;
    }

    static final XSComplexTypeDecl[] resize(XSComplexTypeDecl[] xSComplexTypeDeclArray, int n) {
        XSComplexTypeDecl[] xSComplexTypeDeclArray2 = new XSComplexTypeDecl[n];
        System.arraycopy(xSComplexTypeDeclArray, 0, xSComplexTypeDeclArray2, 0, Math.min(xSComplexTypeDeclArray.length, n));
        return xSComplexTypeDeclArray2;
    }

    static final XSGroupDecl[] resize(XSGroupDecl[] xSGroupDeclArray, int n) {
        XSGroupDecl[] xSGroupDeclArray2 = new XSGroupDecl[n];
        System.arraycopy(xSGroupDeclArray, 0, xSGroupDeclArray2, 0, Math.min(xSGroupDeclArray.length, n));
        return xSGroupDeclArray2;
    }

    static final XSElementDecl[] resize(XSElementDecl[] xSElementDeclArray, int n) {
        XSElementDecl[] xSElementDeclArray2 = new XSElementDecl[n];
        System.arraycopy(xSElementDeclArray, 0, xSElementDeclArray2, 0, Math.min(xSElementDeclArray.length, n));
        return xSElementDeclArray2;
    }

    static final SimpleLocator[] resize(SimpleLocator[] simpleLocatorArray, int n) {
        SimpleLocator[] simpleLocatorArray2 = new SimpleLocator[n];
        System.arraycopy(simpleLocatorArray, 0, simpleLocatorArray2, 0, Math.min(simpleLocatorArray.length, n));
        return simpleLocatorArray2;
    }

    public synchronized void addDocument(Object object, String string) {
        if (this.fDocuments == null) {
            this.fDocuments = new Vector();
            this.fLocations = new Vector();
        }
        this.fDocuments.addElement(object);
        this.fLocations.addElement(string);
    }

    public String getSchemaNamespace() {
        return this.fTargetNamespace;
    }

    public synchronized XSNamedMap getComponents(short s) {
        if (s <= 0 || s > 14 || !GLOBAL_COMP[s]) {
            return null;
        }
        if (this.fComponents == null) {
            this.fComponents = new XSNamedMap[15];
        }
        if (this.fComponents[s] == null) {
            SymbolHash symbolHash = null;
            switch (s) {
                case 3: 
                case 13: 
                case 14: {
                    symbolHash = this.fGlobalTypeDecls;
                    break;
                }
                case 1: {
                    symbolHash = this.fGlobalAttrDecls;
                    break;
                }
                case 2: {
                    symbolHash = this.fGlobalElemDecls;
                    break;
                }
                case 5: {
                    symbolHash = this.fGlobalAttrGrpDecls;
                    break;
                }
                case 6: {
                    symbolHash = this.fGlobalGroupDecls;
                    break;
                }
                case 11: {
                    symbolHash = this.fGlobalNotationDecls;
                }
            }
            this.fComponents[s] = s == 13 || s == 14 ? new XSNamedMap4Types(this.fTargetNamespace, symbolHash, s) : new XSNamedMapImpl(this.fTargetNamespace, symbolHash);
        }
        return this.fComponents[s];
    }

    public XSTypeDefinition getTypeDefinition(String string) {
        return this.getGlobalTypeDecl(string);
    }

    public XSAttributeDeclaration getAttributeDecl(String string) {
        return this.getGlobalAttributeDecl(string);
    }

    public XSElementDeclaration getElementDecl(String string) {
        return this.getGlobalElementDecl(string);
    }

    public XSAttributeGroupDefinition getAttributeGroup(String string) {
        return this.getGlobalAttributeGroupDecl(string);
    }

    public XSModelGroupDefinition getModelGroupDefinition(String string) {
        return this.getGlobalGroupDecl(string);
    }

    public XSNotationDeclaration getNotationDecl(String string) {
        return this.getGlobalNotationDecl(string);
    }

    public ObjectList getDocuments() {
        return new ObjectListImpl(this.fDocuments);
    }

    public StringList getDocumentLocations() {
        return new StringListImpl(this.fLocations);
    }

    static {
        SchemaGrammar.fAnyType.fName = "anyType";
        SchemaGrammar.fAnyType.fTargetNamespace = SchemaSymbols.URI_SCHEMAFORSCHEMA;
        SchemaGrammar.fAnyType.fBaseType = fAnyType;
        SchemaGrammar.fAnyType.fDerivedBy = (short)2;
        SchemaGrammar.fAnyType.fContentType = (short)3;
        XSWildcardDecl xSWildcardDecl = new XSWildcardDecl();
        xSWildcardDecl.fProcessContents = (short)3;
        XSParticleDecl xSParticleDecl = new XSParticleDecl();
        xSParticleDecl.fMinOccurs = 0;
        xSParticleDecl.fMaxOccurs = -1;
        xSParticleDecl.fType = (short)2;
        xSParticleDecl.fValue = xSWildcardDecl;
        XSModelGroupImpl xSModelGroupImpl = new XSModelGroupImpl();
        xSModelGroupImpl.fCompositor = (short)102;
        xSModelGroupImpl.fParticleCount = 1;
        xSModelGroupImpl.fParticles = new XSParticleDecl[1];
        xSModelGroupImpl.fParticles[0] = xSParticleDecl;
        XSParticleDecl xSParticleDecl2 = new XSParticleDecl();
        xSParticleDecl2.fType = (short)3;
        xSParticleDecl2.fValue = xSModelGroupImpl;
        SchemaGrammar.fAnyType.fParticle = xSParticleDecl2;
        SchemaGrammar.fAnyType.fAttrGrp.fAttributeWC = xSWildcardDecl;
        SG_SchemaNS = new SchemaGrammar(1);
        fAnySimpleType = (XSSimpleType)SG_SchemaNS.getGlobalTypeDecl("anySimpleType");
        SG_XSI = new SchemaGrammar(2);
        GLOBAL_COMP = new boolean[]{false, true, true, true, false, true, true, false, false, false, false, true, false, true, true};
    }
}

