/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.log4j.Logger;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.filter.Filter;
import org.pdfbox.filter.FilterManager;
import org.pdfbox.io.RandomAccessFileInputStream;
import org.pdfbox.io.RandomAccessFileOutputStream;
import org.pdfbox.pdfparser.PDFStreamParser;

public class COSStream
extends COSDictionary {
    private static final int BUFFER_SIZE = 16384;
    private static Logger log = Logger.getLogger((Class)(class$org$pdfbox$cos$COSStream == null ? (class$org$pdfbox$cos$COSStream = COSStream.class$("org.pdfbox.cos.COSStream")) : class$org$pdfbox$cos$COSStream));
    private RandomAccessFile file;
    private RandomAccessFileOutputStream filteredStream;
    private RandomAccessFileOutputStream unFilteredStream;
    static /* synthetic */ Class class$org$pdfbox$cos$COSStream;

    public COSStream(RandomAccessFile storage) {
        this.file = storage;
    }

    public COSStream(COSDictionary dictionary, RandomAccessFile storage) {
        super(dictionary);
        this.file = storage;
    }

    public void replaceWithStream(COSStream stream) {
        this.clear();
        this.addAll(stream);
        this.file = stream.file;
        this.filteredStream = stream.filteredStream;
        this.unFilteredStream = stream.unFilteredStream;
    }

    public RandomAccessFile getScratchFile() {
        return this.file;
    }

    public List getStreamTokens() throws IOException {
        PDFStreamParser parser = new PDFStreamParser(this);
        parser.parse();
        return parser.getTokens();
    }

    public InputStream getFilteredStream() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        long position = this.filteredStream.getPosition();
        long length = this.filteredStream.getLength();
        RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.file, position, length);
        return new BufferedInputStream(input, 16384);
    }

    public InputStream getUnfilteredStream() throws IOException {
        InputStream retval = null;
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        if (this.unFilteredStream != null) {
            long position = this.unFilteredStream.getPosition();
            long length = this.unFilteredStream.getLength();
            RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.file, position, length);
            retval = new BufferedInputStream(input, 16384);
        } else {
            retval = new ByteArrayInputStream(new byte[0]);
        }
        return retval;
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromStream(this);
    }

    private void doDecode() throws IOException {
        log.debug((Object)"doDecode() start");
        this.unFilteredStream = this.filteredStream;
        COSBase filters = this.getFilters();
        if (filters == null) {
            log.debug((Object)"doDecode() - No filter to apply");
        } else if (filters instanceof COSName) {
            log.debug((Object)"doDecode( COSName )");
            this.doDecode((COSName)filters);
        } else if (filters instanceof COSArray) {
            log.debug((Object)"doDecode( COSArray )");
            COSArray filterArray = (COSArray)filters;
            for (int i = 0; i < filterArray.size(); ++i) {
                COSName filterName = (COSName)filterArray.get(i);
                this.doDecode(filterName);
            }
        } else {
            throw new IOException("Error: Unknown filter type:" + filters);
        }
        log.debug((Object)"doDecode() end");
    }

    private void doDecode(COSName filterName) throws IOException {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("doDecode( " + filterName.getName() + " ) dic=" + this + " read.length=" + this.unFilteredStream.getLength()));
        }
        FilterManager manager = this.getFilterManager();
        Filter filter = manager.getFilter(filterName);
        boolean done = false;
        IOException exception = null;
        long position = this.unFilteredStream.getPosition();
        long length = this.unFilteredStream.getLength();
        for (int tryCount = 0; !done && tryCount < 5; ++tryCount) {
            try {
                BufferedInputStream input = new BufferedInputStream(new RandomAccessFileInputStream(this.file, position, length), 16384);
                this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
                filter.decode(input, this.unFilteredStream, this);
                done = true;
                continue;
            }
            catch (IOException io) {
                --length;
                exception = io;
            }
        }
        if (!done) {
            throw exception;
        }
        long stop = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("doDecode( " + filterName.getName() + " ) done time=" + (stop - start)));
        }
    }

    private void doEncode() throws IOException {
        this.filteredStream = this.unFilteredStream;
        COSBase filters = this.getFilters();
        if (filters == null) {
            log.debug((Object)"No filters for stream");
        } else if (filters instanceof COSName) {
            this.doEncode((COSName)filters);
        } else if (filters instanceof COSArray) {
            COSArray filterArray = (COSArray)filters;
            for (int i = filterArray.size() - 1; i >= 0; --i) {
                COSName filterName = (COSName)filterArray.get(i);
                this.doEncode(filterName);
            }
        }
    }

    private void doEncode(COSName filterName) throws IOException {
        FilterManager manager = this.getFilterManager();
        Filter filter = manager.getFilter(filterName);
        BufferedInputStream input = new BufferedInputStream(new RandomAccessFileInputStream(this.file, this.filteredStream.getPosition(), this.filteredStream.getLength()), 16384);
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        filter.encode(input, this.filteredStream, this);
    }

    public COSBase getFilters() {
        return this.getDictionaryObject(COSName.FILTER);
    }

    public OutputStream createFilteredStream() throws IOException {
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        this.unFilteredStream = null;
        return new BufferedOutputStream(this.filteredStream, 16384);
    }

    public OutputStream createFilteredStream(COSBase expectedLength) throws IOException {
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        this.filteredStream.setExpectedLength(expectedLength);
        this.unFilteredStream = null;
        return new BufferedOutputStream(this.filteredStream, 16384);
    }

    public void setFilters(COSBase filters) throws IOException {
        this.setItem(COSName.FILTER, filters);
        this.filteredStream = null;
    }

    public OutputStream createUnfilteredStream() throws IOException {
        this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
        this.filteredStream = null;
        return new BufferedOutputStream(this.unFilteredStream, 16384);
    }

    private static void printHexString(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            int nextByte = (data[i] + 256) % 256;
            String hexString = Integer.toHexString(nextByte);
            if (hexString.length() < 2) {
                hexString = "0" + hexString;
            }
            System.out.print(hexString);
            if (i != 0 && (i + 1) % 2 == 0) {
                System.out.print(" ");
            }
            if (i == 0 || i % 20 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

