# encoding=UTF-8

# Copyright © 2009-2015 Jakub Wilk <jwilk@jwilk.net>
#
# This package is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 dated June, 1991.

import re

from common import (
    case,
)

class test(case):
    '''
    https://bitbucket.org/jwilk/pdf2djvu/issue/20
    fixed in [c06a41afdc46]
    '''
    def test_no_crop(self):
        self.pdf2djvu().assert_()
        r = self.print_text()
        r.assert_(stdout=re.compile('^Lorem ipsum *\n'))

    def test_crop(self):
        self.pdf2djvu('--crop-text').assert_()
        r = self.print_text()
        r.assert_(stdout=re.compile('^Lorem *\n'))

# vim:ts=4 sts=4 sw=4 et
