/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Iterator;
import javax.vecmath.Point3i;
import org.jmol.modelset.Atom;
import org.jmol.shape.Echo;
import org.jmol.shape.Object2d;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shape.Text;

public class EchoRenderer
extends ShapeRenderer {
    float imageFontScaling;
    Atom ptAtom;
    Point3i pt = new Point3i();

    protected void render() {
        Object object;
        if (this.viewer.isPreviewOnly()) {
            return;
        }
        Echo echo = (Echo)this.shape;
        Iterator iterator = echo.objects.values().iterator();
        float f = this.viewer.getFontScaling() ? this.viewer.getScalePixelsPerAngstrom(true) * 10000.0f : 0.0f;
        this.imageFontScaling = this.viewer.getImageFontScaling();
        while (iterator.hasNext()) {
            object = (Text)iterator.next();
            if (!((Text)object).visible || ((Text)object).hidden) continue;
            if (((Text)object).valign == 4) {
                this.viewer.transformPoint(((Text)object).xyz, this.pt);
                ((Object2d)object).setXYZs(this.pt.x, this.pt.y, this.pt.z, this.pt.z);
            } else if (((Text)object).movableZPercent != Integer.MAX_VALUE) {
                int n = this.viewer.zValueFromPercent(((Text)object).movableZPercent);
                ((Object2d)object).setZs(n, n);
            }
            ((Text)object).render(this.g3d, f, this.imageFontScaling, false);
        }
        object = this.viewer.getFrameTitle();
        if (object != null && ((String)object).length() > 0) {
            if (((String)object).indexOf("%{") >= 0 || ((String)object).indexOf("@{") >= 0) {
                object = this.viewer.formatText((String)object);
            }
            this.renderFrameTitle((String)object);
        }
    }

    private void renderFrameTitle(String string) {
        if (this.exportType != 0 || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        byte by = this.g3d.getFontFid("Monospaced", 14.0f * this.imageFontScaling);
        this.g3d.setFont(by);
        int n = (int)((float)(this.viewer.getScreenHeight() * (this.g3d.isAntialiased() ? 2 : 1)) - 10.0f * this.imageFontScaling);
        int n2 = (int)(5.0f * this.imageFontScaling);
        this.g3d.drawStringNoSlab(string, null, n2, n, 0);
    }
}

