/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;
import org.jmol.util.Logger;

public final class Bspf {
    int dimMax;
    Bspt[] bspts;
    CubeIterator[] cubeIterators;

    public Bspf(int n) {
        this.dimMax = n;
        this.bspts = new Bspt[0];
        this.cubeIterators = new CubeIterator[0];
    }

    public int getBsptCount() {
        return this.bspts.length;
    }

    public void clearBspt(int n) {
        this.bspts[n] = null;
    }

    public boolean isInitialized(int n) {
        return this.bspts.length > n && this.bspts[n] != null;
    }

    public void addTuple(int n, Point3f point3f) {
        Object object;
        if (n >= this.bspts.length) {
            object = new Bspt[n + 1];
            System.arraycopy(this.bspts, 0, object, 0, this.bspts.length);
            this.bspts = object;
        }
        if ((object = this.bspts[n]) == null) {
            this.bspts[n] = new Bspt(this.dimMax);
            object = this.bspts[n];
        }
        ((Bspt)object).addTuple(point3f);
    }

    public void stats() {
        for (int i = 0; i < this.bspts.length; ++i) {
            if (this.bspts[i] == null) continue;
            this.bspts[i].stats();
        }
    }

    public void dump() {
        for (int i = 0; i < this.bspts.length; ++i) {
            Logger.info(">>>>\nDumping bspt #" + i + "\n>>>>");
            this.bspts[i].dump();
        }
        Logger.info("<<<<");
    }

    public CubeIterator getCubeIterator(int n) {
        if (n < 0) {
            return this.getNewCubeIterator(-1 - n);
        }
        if (n >= this.cubeIterators.length) {
            CubeIterator[] cubeIteratorArray = new CubeIterator[n + 1];
            System.arraycopy(this.cubeIterators, 0, cubeIteratorArray, 0, this.cubeIterators.length);
            this.cubeIterators = cubeIteratorArray;
        }
        if (this.cubeIterators[n] == null && this.bspts[n] != null) {
            this.cubeIterators[n] = this.getNewCubeIterator(n);
        }
        return this.cubeIterators[n];
    }

    public CubeIterator getNewCubeIterator(int n) {
        return this.bspts[n].allocateCubeIterator();
    }

    public void initialize(int n, Point3f[] point3fArray, BitSet bitSet) {
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            this.addTuple(n, point3fArray[n2]);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
    }
}

