// Copyright (c) 2005-2017 Code Synthesis Tools CC
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

#ifndef AGUILA_XSD_H
#define AGUILA_XSD_H

#ifndef XSD_CXX11
#define XSD_CXX11
#endif

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/config.hxx>

#if (XSD_INT_VERSION != 4009911L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

#include <xsd/cxx/tree/parsing.hxx>
#include <xsd/cxx/tree/parsing/byte.hxx>
#include <xsd/cxx/tree/parsing/unsigned-byte.hxx>
#include <xsd/cxx/tree/parsing/short.hxx>
#include <xsd/cxx/tree/parsing/unsigned-short.hxx>
#include <xsd/cxx/tree/parsing/int.hxx>
#include <xsd/cxx/tree/parsing/unsigned-int.hxx>
#include <xsd/cxx/tree/parsing/long.hxx>
#include <xsd/cxx/tree/parsing/unsigned-long.hxx>
#include <xsd/cxx/tree/parsing/boolean.hxx>
#include <xsd/cxx/tree/parsing/float.hxx>
#include <xsd/cxx/tree/parsing/double.hxx>
#include <xsd/cxx/tree/parsing/decimal.hxx>

#include <xsd/cxx/xml/dom/serialization-header.hxx>
#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/tree/serialization/byte.hxx>
#include <xsd/cxx/tree/serialization/unsigned-byte.hxx>
#include <xsd/cxx/tree/serialization/short.hxx>
#include <xsd/cxx/tree/serialization/unsigned-short.hxx>
#include <xsd/cxx/tree/serialization/int.hxx>
#include <xsd/cxx/tree/serialization/unsigned-int.hxx>
#include <xsd/cxx/tree/serialization/long.hxx>
#include <xsd/cxx/tree/serialization/unsigned-long.hxx>
#include <xsd/cxx/tree/serialization/boolean.hxx>
#include <xsd/cxx/tree/serialization/float.hxx>
#include <xsd/cxx/tree/serialization/double.hxx>
#include <xsd/cxx/tree/serialization/decimal.hxx>

#include <xsd/cxx/tree/std-ostream-operators.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type< char, type > simple_type;
  typedef ::xsd::cxx::tree::type container;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef long long non_positive_integer;
  typedef unsigned long long non_negative_integer;
  typedef unsigned long long positive_integer;
  typedef long long negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken > nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< char, ncname, type > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::time_zone time_zone;
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::gday< char, simple_type > gday;
  typedef ::xsd::cxx::tree::gmonth< char, simple_type > gmonth;
  typedef ::xsd::cxx::tree::gmonth_day< char, simple_type > gmonth_day;
  typedef ::xsd::cxx::tree::gyear< char, simple_type > gyear;
  typedef ::xsd::cxx::tree::gyear_month< char, simple_type > gyear_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  typedef ::xsd::cxx::tree::content_order content_order;
  // Namespace information and list stream. Used in
  // serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info< char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap< char > namespace_infomap;
  typedef ::xsd::cxx::tree::list_stream< char > list_stream;
  typedef ::xsd::cxx::tree::as_double< double_ > as_double;
  typedef ::xsd::cxx::tree::as_decimal< decimal > as_decimal;
  typedef ::xsd::cxx::tree::facet facet;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::bounds< char > bounds;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::serialization< char > serialization;

  // Error handler callback interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // DOM interaction.
  //
  namespace dom
  {
    // Automatic pointer for DOMDocument.
    //
    using ::xsd::cxx::xml::dom::unique_ptr;

#ifndef XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
    // DOM user data key for back pointers to tree nodes.
    //
    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;
#endif
  }
}

// Forward declarations.
//
namespace pcrxml
{
  class Aguila;
  class VisualisationGroup;
  class DataSpace;
  class Timesteps;
  class DateMapper;
  class AguilaView;
  class AguilaData;
  class DrawProperties;
  class Palette;
  class Rgb;
  class LegendBorderValuesType;
  class ColourAssignment;
  class ConfidenceLevel;
  class DrawMode;
  class AguilaCursorValues;
  class AguilaCursorValue;
  class Cursor;
  class DataValue;
}


#include <memory>    // ::std::unique_ptr
#include <limits>    // std::numeric_limits
#include <algorithm> // std::binary_search
#include <utility>   // std::move

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

#include "commonTypesXSD.h"

namespace pcrxml
{
  class Aguila: public ::xml_schema::type
  {
    public:
    // multiView
    //
    typedef ::pcrxml::NrRowsNrCols multiView_type;
    typedef ::xsd::cxx::tree::optional< multiView_type > multiView_optional;
    typedef ::xsd::cxx::tree::traits< multiView_type, char > multiView_traits;

    const multiView_optional&
    multiView () const;

    multiView_optional&
    multiView ();

    void
    multiView (const multiView_type& x);

    void
    multiView (const multiView_optional& x);

    void
    multiView (::std::unique_ptr< multiView_type > p);

    // visualisationGroup
    //
    typedef ::pcrxml::VisualisationGroup visualisationGroup_type;
    typedef ::xsd::cxx::tree::traits< visualisationGroup_type, char > visualisationGroup_traits;

    const visualisationGroup_type&
    visualisationGroup () const;

    visualisationGroup_type&
    visualisationGroup ();

    void
    visualisationGroup (const visualisationGroup_type& x);

    void
    visualisationGroup (::std::unique_ptr< visualisationGroup_type > p);

    // Constructors.
    //
    Aguila (const visualisationGroup_type&);

    Aguila (::std::unique_ptr< visualisationGroup_type >);

    Aguila (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    Aguila (const Aguila& x,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    virtual Aguila*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Aguila&
    operator= (const Aguila& x);

    virtual
    ~Aguila ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    multiView_optional multiView_;
    ::xsd::cxx::tree::one< visualisationGroup_type > visualisationGroup_;
  };

  class VisualisationGroup: public ::xml_schema::type
  {
    public:
    // cursorValueMonitorFile
    //
    typedef ::xml_schema::string cursorValueMonitorFile_type;
    typedef ::xsd::cxx::tree::optional< cursorValueMonitorFile_type > cursorValueMonitorFile_optional;
    typedef ::xsd::cxx::tree::traits< cursorValueMonitorFile_type, char > cursorValueMonitorFile_traits;

    const cursorValueMonitorFile_optional&
    cursorValueMonitorFile () const;

    cursorValueMonitorFile_optional&
    cursorValueMonitorFile ();

    void
    cursorValueMonitorFile (const cursorValueMonitorFile_type& x);

    void
    cursorValueMonitorFile (const cursorValueMonitorFile_optional& x);

    void
    cursorValueMonitorFile (::std::unique_ptr< cursorValueMonitorFile_type > p);

    // fileToGetCursorValue
    //
    typedef ::xml_schema::string fileToGetCursorValue_type;
    typedef ::xsd::cxx::tree::optional< fileToGetCursorValue_type > fileToGetCursorValue_optional;
    typedef ::xsd::cxx::tree::traits< fileToGetCursorValue_type, char > fileToGetCursorValue_traits;

    const fileToGetCursorValue_optional&
    fileToGetCursorValue () const;

    fileToGetCursorValue_optional&
    fileToGetCursorValue ();

    void
    fileToGetCursorValue (const fileToGetCursorValue_type& x);

    void
    fileToGetCursorValue (const fileToGetCursorValue_optional& x);

    void
    fileToGetCursorValue (::std::unique_ptr< fileToGetCursorValue_type > p);

    // searchSpace
    //
    typedef ::pcrxml::DataSpace searchSpace_type;
    typedef ::xsd::cxx::tree::optional< searchSpace_type > searchSpace_optional;
    typedef ::xsd::cxx::tree::traits< searchSpace_type, char > searchSpace_traits;

    const searchSpace_optional&
    searchSpace () const;

    searchSpace_optional&
    searchSpace ();

    void
    searchSpace (const searchSpace_type& x);

    void
    searchSpace (const searchSpace_optional& x);

    void
    searchSpace (::std::unique_ptr< searchSpace_type > p);

    // data
    //
    typedef ::pcrxml::AguilaData data_type;
    typedef ::xsd::cxx::tree::sequence< data_type > data_sequence;
    typedef data_sequence::iterator data_iterator;
    typedef data_sequence::const_iterator data_const_iterator;
    typedef ::xsd::cxx::tree::traits< data_type, char > data_traits;

    const data_sequence&
    data () const;

    data_sequence&
    data ();

    void
    data (const data_sequence& s);

    // view
    //
    typedef ::pcrxml::AguilaView view_type;
    typedef ::xsd::cxx::tree::sequence< view_type > view_sequence;
    typedef view_sequence::iterator view_iterator;
    typedef view_sequence::const_iterator view_const_iterator;
    typedef ::xsd::cxx::tree::traits< view_type, char > view_traits;

    const view_sequence&
    view () const;

    view_sequence&
    view ();

    void
    view (const view_sequence& s);

    // Constructors.
    //
    VisualisationGroup ();

    VisualisationGroup (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    VisualisationGroup (const VisualisationGroup& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual VisualisationGroup*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    VisualisationGroup&
    operator= (const VisualisationGroup& x);

    virtual
    ~VisualisationGroup ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    cursorValueMonitorFile_optional cursorValueMonitorFile_;
    fileToGetCursorValue_optional fileToGetCursorValue_;
    searchSpace_optional searchSpace_;
    data_sequence data_;
    view_sequence view_;
  };

  class DataSpace: public ::xml_schema::type
  {
    public:
    // scenarios
    //
    typedef ::pcrxml::StringSet scenarios_type;
    typedef ::xsd::cxx::tree::sequence< scenarios_type > scenarios_sequence;
    typedef scenarios_sequence::iterator scenarios_iterator;
    typedef scenarios_sequence::const_iterator scenarios_const_iterator;
    typedef ::xsd::cxx::tree::traits< scenarios_type, char > scenarios_traits;

    const scenarios_sequence&
    scenarios () const;

    scenarios_sequence&
    scenarios ();

    void
    scenarios (const scenarios_sequence& s);

    // quantiles
    //
    typedef ::pcrxml::FloatRangeOrSet quantiles_type;
    typedef ::xsd::cxx::tree::sequence< quantiles_type > quantiles_sequence;
    typedef quantiles_sequence::iterator quantiles_iterator;
    typedef quantiles_sequence::const_iterator quantiles_const_iterator;
    typedef ::xsd::cxx::tree::traits< quantiles_type, char > quantiles_traits;

    const quantiles_sequence&
    quantiles () const;

    quantiles_sequence&
    quantiles ();

    void
    quantiles (const quantiles_sequence& s);

    // timesteps
    //
    typedef ::pcrxml::Timesteps timesteps_type;
    typedef ::xsd::cxx::tree::sequence< timesteps_type > timesteps_sequence;
    typedef timesteps_sequence::iterator timesteps_iterator;
    typedef timesteps_sequence::const_iterator timesteps_const_iterator;
    typedef ::xsd::cxx::tree::traits< timesteps_type, char > timesteps_traits;

    const timesteps_sequence&
    timesteps () const;

    timesteps_sequence&
    timesteps ();

    void
    timesteps (const timesteps_sequence& s);

    // Constructors.
    //
    DataSpace ();

    DataSpace (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    DataSpace (const DataSpace& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual DataSpace*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DataSpace&
    operator= (const DataSpace& x);

    virtual
    ~DataSpace ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    scenarios_sequence scenarios_;
    quantiles_sequence quantiles_;
    timesteps_sequence timesteps_;
  };

  class Timesteps: public ::pcrxml::OneBasedIntegerRangeOrSet
  {
    public:
    // dateMapper
    //
    typedef ::pcrxml::DateMapper dateMapper_type;
    typedef ::xsd::cxx::tree::optional< dateMapper_type > dateMapper_optional;
    typedef ::xsd::cxx::tree::traits< dateMapper_type, char > dateMapper_traits;

    const dateMapper_optional&
    dateMapper () const;

    dateMapper_optional&
    dateMapper ();

    void
    dateMapper (const dateMapper_type& x);

    void
    dateMapper (const dateMapper_optional& x);

    void
    dateMapper (::std::unique_ptr< dateMapper_type > p);

    // Constructors.
    //
    Timesteps ();

    Timesteps (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    Timesteps (const Timesteps& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual Timesteps*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Timesteps&
    operator= (const Timesteps& x);

    virtual
    ~Timesteps ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    dateMapper_optional dateMapper_;
  };

  class DateMapper: public ::xml_schema::type
  {
    public:
    // index
    //
    typedef ::xml_schema::unsigned_int index_type;
    typedef ::xsd::cxx::tree::traits< index_type, char > index_traits;

    const index_type&
    index () const;

    index_type&
    index ();

    void
    index (const index_type& x);

    // timeOfIndex
    //
    typedef ::xml_schema::date_time timeOfIndex_type;
    typedef ::xsd::cxx::tree::traits< timeOfIndex_type, char > timeOfIndex_traits;

    const timeOfIndex_type&
    timeOfIndex () const;

    timeOfIndex_type&
    timeOfIndex ();

    void
    timeOfIndex (const timeOfIndex_type& x);

    void
    timeOfIndex (::std::unique_ptr< timeOfIndex_type > p);

    // duration
    //
    typedef ::pcrxml::TimeDuration duration_type;
    typedef ::xsd::cxx::tree::traits< duration_type, char > duration_traits;

    const duration_type&
    duration () const;

    duration_type&
    duration ();

    void
    duration (const duration_type& x);

    void
    duration (::std::unique_ptr< duration_type > p);

    // Constructors.
    //
    DateMapper (const index_type&,
                const timeOfIndex_type&,
                const duration_type&);

    DateMapper (const index_type&,
                const timeOfIndex_type&,
                ::std::unique_ptr< duration_type >);

    DateMapper (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    DateMapper (const DateMapper& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual DateMapper*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DateMapper&
    operator= (const DateMapper& x);

    virtual
    ~DateMapper ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< index_type > index_;
    ::xsd::cxx::tree::one< timeOfIndex_type > timeOfIndex_;
    ::xsd::cxx::tree::one< duration_type > duration_;
  };

  class AguilaView: public ::xml_schema::type
  {
    public:
    // map
    //
    typedef ::pcrxml::StringSet map_type;
    typedef ::xsd::cxx::tree::optional< map_type > map_optional;
    typedef ::xsd::cxx::tree::traits< map_type, char > map_traits;

    const map_optional&
    map () const;

    map_optional&
    map ();

    void
    map (const map_type& x);

    void
    map (const map_optional& x);

    void
    map (::std::unique_ptr< map_type > p);

    // drape
    //
    typedef ::pcrxml::StringSet drape_type;
    typedef ::xsd::cxx::tree::optional< drape_type > drape_optional;
    typedef ::xsd::cxx::tree::traits< drape_type, char > drape_traits;

    const drape_optional&
    drape () const;

    drape_optional&
    drape ();

    void
    drape (const drape_type& x);

    void
    drape (const drape_optional& x);

    void
    drape (::std::unique_ptr< drape_type > p);

    // timeGraph
    //
    typedef ::pcrxml::StringSet timeGraph_type;
    typedef ::xsd::cxx::tree::optional< timeGraph_type > timeGraph_optional;
    typedef ::xsd::cxx::tree::traits< timeGraph_type, char > timeGraph_traits;

    const timeGraph_optional&
    timeGraph () const;

    timeGraph_optional&
    timeGraph ();

    void
    timeGraph (const timeGraph_type& x);

    void
    timeGraph (const timeGraph_optional& x);

    void
    timeGraph (::std::unique_ptr< timeGraph_type > p);

    // probabilityGraph
    //
    typedef ::pcrxml::StringSet probabilityGraph_type;
    typedef ::xsd::cxx::tree::optional< probabilityGraph_type > probabilityGraph_optional;
    typedef ::xsd::cxx::tree::traits< probabilityGraph_type, char > probabilityGraph_traits;

    const probabilityGraph_optional&
    probabilityGraph () const;

    probabilityGraph_optional&
    probabilityGraph ();

    void
    probabilityGraph (const probabilityGraph_type& x);

    void
    probabilityGraph (const probabilityGraph_optional& x);

    void
    probabilityGraph (::std::unique_ptr< probabilityGraph_type > p);

    // valueOnly
    //
    typedef ::pcrxml::StringSet valueOnly_type;
    typedef ::xsd::cxx::tree::optional< valueOnly_type > valueOnly_optional;
    typedef ::xsd::cxx::tree::traits< valueOnly_type, char > valueOnly_traits;

    const valueOnly_optional&
    valueOnly () const;

    valueOnly_optional&
    valueOnly ();

    void
    valueOnly (const valueOnly_type& x);

    void
    valueOnly (const valueOnly_optional& x);

    void
    valueOnly (::std::unique_ptr< valueOnly_type > p);

    // default
    //
    typedef ::pcrxml::StringSet default_type;
    typedef ::xsd::cxx::tree::optional< default_type > default_optional;
    typedef ::xsd::cxx::tree::traits< default_type, char > default_traits;

    const default_optional&
    default_ () const;

    default_optional&
    default_ ();

    void
    default_ (const default_type& x);

    void
    default_ (const default_optional& x);

    void
    default_ (::std::unique_ptr< default_type > p);

    // test
    //
    typedef ::pcrxml::StringSet test_type;
    typedef ::xsd::cxx::tree::optional< test_type > test_optional;
    typedef ::xsd::cxx::tree::traits< test_type, char > test_traits;

    const test_optional&
    test () const;

    test_optional&
    test ();

    void
    test (const test_type& x);

    void
    test (const test_optional& x);

    void
    test (::std::unique_ptr< test_type > p);

    // Constructors.
    //
    AguilaView ();

    AguilaView (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    AguilaView (const AguilaView& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual AguilaView*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    AguilaView&
    operator= (const AguilaView& x);

    virtual
    ~AguilaView ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    map_optional map_;
    drape_optional drape_;
    timeGraph_optional timeGraph_;
    probabilityGraph_optional probabilityGraph_;
    valueOnly_optional valueOnly_;
    default_optional default__;
    test_optional test_;
  };

  class AguilaData: public ::xml_schema::type
  {
    public:
    // name
    //
    typedef ::xml_schema::string name_type;
    typedef ::xsd::cxx::tree::traits< name_type, char > name_traits;

    const name_type&
    name () const;

    name_type&
    name ();

    void
    name (const name_type& x);

    void
    name (::std::unique_ptr< name_type > p);

    // dataSpace
    //
    typedef ::pcrxml::DataSpace dataSpace_type;
    typedef ::xsd::cxx::tree::optional< dataSpace_type > dataSpace_optional;
    typedef ::xsd::cxx::tree::traits< dataSpace_type, char > dataSpace_traits;

    const dataSpace_optional&
    dataSpace () const;

    dataSpace_optional&
    dataSpace ();

    void
    dataSpace (const dataSpace_type& x);

    void
    dataSpace (const dataSpace_optional& x);

    void
    dataSpace (::std::unique_ptr< dataSpace_type > p);

    // drawProperties
    //
    typedef ::pcrxml::DrawProperties drawProperties_type;
    typedef ::xsd::cxx::tree::optional< drawProperties_type > drawProperties_optional;
    typedef ::xsd::cxx::tree::traits< drawProperties_type, char > drawProperties_traits;

    const drawProperties_optional&
    drawProperties () const;

    drawProperties_optional&
    drawProperties ();

    void
    drawProperties (const drawProperties_type& x);

    void
    drawProperties (const drawProperties_optional& x);

    void
    drawProperties (::std::unique_ptr< drawProperties_type > p);

    // Constructors.
    //
    AguilaData (const name_type&);

    AguilaData (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    AguilaData (const AguilaData& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual AguilaData*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    AguilaData&
    operator= (const AguilaData& x);

    virtual
    ~AguilaData ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< name_type > name_;
    dataSpace_optional dataSpace_;
    drawProperties_optional drawProperties_;
  };

  class DrawProperties: public ::xml_schema::type
  {
    public:
    // legendBorderValuesType
    //
    typedef ::pcrxml::LegendBorderValuesType legendBorderValuesType_type;
    typedef ::xsd::cxx::tree::optional< legendBorderValuesType_type > legendBorderValuesType_optional;
    typedef ::xsd::cxx::tree::traits< legendBorderValuesType_type, char > legendBorderValuesType_traits;

    const legendBorderValuesType_optional&
    legendBorderValuesType () const;

    legendBorderValuesType_optional&
    legendBorderValuesType ();

    void
    legendBorderValuesType (const legendBorderValuesType_type& x);

    void
    legendBorderValuesType (const legendBorderValuesType_optional& x);

    void
    legendBorderValuesType (::std::unique_ptr< legendBorderValuesType_type > p);

    // minimumCutOff
    //
    typedef ::xml_schema::double_ minimumCutOff_type;
    typedef ::xsd::cxx::tree::optional< minimumCutOff_type > minimumCutOff_optional;
    typedef ::xsd::cxx::tree::traits< minimumCutOff_type, char, ::xsd::cxx::tree::schema_type::double_ > minimumCutOff_traits;

    const minimumCutOff_optional&
    minimumCutOff () const;

    minimumCutOff_optional&
    minimumCutOff ();

    void
    minimumCutOff (const minimumCutOff_type& x);

    void
    minimumCutOff (const minimumCutOff_optional& x);

    // maximumCutOff
    //
    typedef ::xml_schema::double_ maximumCutOff_type;
    typedef ::xsd::cxx::tree::optional< maximumCutOff_type > maximumCutOff_optional;
    typedef ::xsd::cxx::tree::traits< maximumCutOff_type, char, ::xsd::cxx::tree::schema_type::double_ > maximumCutOff_traits;

    const maximumCutOff_optional&
    maximumCutOff () const;

    maximumCutOff_optional&
    maximumCutOff ();

    void
    maximumCutOff (const maximumCutOff_type& x);

    void
    maximumCutOff (const maximumCutOff_optional& x);

    // numberOfColours
    //
    typedef ::pcrxml::Non0UnsignedInt numberOfColours_type;
    typedef ::xsd::cxx::tree::optional< numberOfColours_type > numberOfColours_optional;
    typedef ::xsd::cxx::tree::traits< numberOfColours_type, char > numberOfColours_traits;

    const numberOfColours_optional&
    numberOfColours () const;

    numberOfColours_optional&
    numberOfColours ();

    void
    numberOfColours (const numberOfColours_type& x);

    void
    numberOfColours (const numberOfColours_optional& x);

    void
    numberOfColours (::std::unique_ptr< numberOfColours_type > p);

    // colourAssignment
    //
    typedef ::pcrxml::ColourAssignment colourAssignment_type;
    typedef ::xsd::cxx::tree::optional< colourAssignment_type > colourAssignment_optional;
    typedef ::xsd::cxx::tree::traits< colourAssignment_type, char > colourAssignment_traits;

    const colourAssignment_optional&
    colourAssignment () const;

    colourAssignment_optional&
    colourAssignment ();

    void
    colourAssignment (const colourAssignment_type& x);

    void
    colourAssignment (const colourAssignment_optional& x);

    void
    colourAssignment (::std::unique_ptr< colourAssignment_type > p);

    // drawMode
    //
    typedef ::pcrxml::DrawMode drawMode_type;
    typedef ::xsd::cxx::tree::optional< drawMode_type > drawMode_optional;
    typedef ::xsd::cxx::tree::traits< drawMode_type, char > drawMode_traits;

    const drawMode_optional&
    drawMode () const;

    drawMode_optional&
    drawMode ();

    void
    drawMode (const drawMode_type& x);

    void
    drawMode (const drawMode_optional& x);

    void
    drawMode (::std::unique_ptr< drawMode_type > p);

    // palette
    //
    typedef ::pcrxml::Palette palette_type;
    typedef ::xsd::cxx::tree::optional< palette_type > palette_optional;
    typedef ::xsd::cxx::tree::traits< palette_type, char > palette_traits;

    const palette_optional&
    palette () const;

    palette_optional&
    palette ();

    void
    palette (const palette_type& x);

    void
    palette (const palette_optional& x);

    void
    palette (::std::unique_ptr< palette_type > p);

    // Constructors.
    //
    DrawProperties ();

    DrawProperties (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    DrawProperties (const DrawProperties& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual DrawProperties*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DrawProperties&
    operator= (const DrawProperties& x);

    virtual
    ~DrawProperties ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    legendBorderValuesType_optional legendBorderValuesType_;
    minimumCutOff_optional minimumCutOff_;
    maximumCutOff_optional maximumCutOff_;
    numberOfColours_optional numberOfColours_;
    colourAssignment_optional colourAssignment_;
    drawMode_optional drawMode_;
    palette_optional palette_;
  };

  class Palette: public ::xml_schema::type
  {
    public:
    // rgb
    //
    typedef ::pcrxml::Rgb rgb_type;
    typedef ::xsd::cxx::tree::sequence< rgb_type > rgb_sequence;
    typedef rgb_sequence::iterator rgb_iterator;
    typedef rgb_sequence::const_iterator rgb_const_iterator;
    typedef ::xsd::cxx::tree::traits< rgb_type, char > rgb_traits;

    const rgb_sequence&
    rgb () const;

    rgb_sequence&
    rgb ();

    void
    rgb (const rgb_sequence& s);

    // Constructors.
    //
    Palette ();

    Palette (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    Palette (const Palette& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    virtual Palette*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Palette&
    operator= (const Palette& x);

    virtual
    ~Palette ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    rgb_sequence rgb_;
  };

  class Rgb: public ::xml_schema::type
  {
    public:
    // r
    //
    typedef ::xml_schema::unsigned_byte r_type;
    typedef ::xsd::cxx::tree::traits< r_type, char > r_traits;

    const r_type&
    r () const;

    r_type&
    r ();

    void
    r (const r_type& x);

    // g
    //
    typedef ::xml_schema::unsigned_byte g_type;
    typedef ::xsd::cxx::tree::traits< g_type, char > g_traits;

    const g_type&
    g () const;

    g_type&
    g ();

    void
    g (const g_type& x);

    // b
    //
    typedef ::xml_schema::unsigned_byte b_type;
    typedef ::xsd::cxx::tree::traits< b_type, char > b_traits;

    const b_type&
    b () const;

    b_type&
    b ();

    void
    b (const b_type& x);

    // Constructors.
    //
    Rgb (const r_type&,
         const g_type&,
         const b_type&);

    Rgb (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f = 0,
         ::xml_schema::container* c = 0);

    Rgb (const Rgb& x,
         ::xml_schema::flags f = 0,
         ::xml_schema::container* c = 0);

    virtual Rgb*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Rgb&
    operator= (const Rgb& x);

    virtual
    ~Rgb ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< r_type > r_;
    ::xsd::cxx::tree::one< g_type > g_;
    ::xsd::cxx::tree::one< b_type > b_;
  };

  class LegendBorderValuesType: public ::xml_schema::type
  {
    public:
    // rounded
    //
    typedef ::pcrxml::EmptyElement rounded_type;
    typedef ::xsd::cxx::tree::optional< rounded_type > rounded_optional;
    typedef ::xsd::cxx::tree::traits< rounded_type, char > rounded_traits;

    const rounded_optional&
    rounded () const;

    rounded_optional&
    rounded ();

    void
    rounded (const rounded_type& x);

    void
    rounded (const rounded_optional& x);

    void
    rounded (::std::unique_ptr< rounded_type > p);

    // exact
    //
    typedef ::pcrxml::EmptyElement exact_type;
    typedef ::xsd::cxx::tree::optional< exact_type > exact_optional;
    typedef ::xsd::cxx::tree::traits< exact_type, char > exact_traits;

    const exact_optional&
    exact () const;

    exact_optional&
    exact ();

    void
    exact (const exact_type& x);

    void
    exact (const exact_optional& x);

    void
    exact (::std::unique_ptr< exact_type > p);

    // Constructors.
    //
    LegendBorderValuesType ();

    LegendBorderValuesType (const ::xercesc::DOMElement& e,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    LegendBorderValuesType (const LegendBorderValuesType& x,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    virtual LegendBorderValuesType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LegendBorderValuesType&
    operator= (const LegendBorderValuesType& x);

    virtual
    ~LegendBorderValuesType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    rounded_optional rounded_;
    exact_optional exact_;
  };

  class ColourAssignment: public ::xml_schema::type
  {
    public:
    // linear
    //
    typedef ::pcrxml::EmptyElement linear_type;
    typedef ::xsd::cxx::tree::optional< linear_type > linear_optional;
    typedef ::xsd::cxx::tree::traits< linear_type, char > linear_traits;

    const linear_optional&
    linear () const;

    linear_optional&
    linear ();

    void
    linear (const linear_type& x);

    void
    linear (const linear_optional& x);

    void
    linear (::std::unique_ptr< linear_type > p);

    // trueLogarithmic
    //
    typedef ::pcrxml::EmptyElement trueLogarithmic_type;
    typedef ::xsd::cxx::tree::optional< trueLogarithmic_type > trueLogarithmic_optional;
    typedef ::xsd::cxx::tree::traits< trueLogarithmic_type, char > trueLogarithmic_traits;

    const trueLogarithmic_optional&
    trueLogarithmic () const;

    trueLogarithmic_optional&
    trueLogarithmic ();

    void
    trueLogarithmic (const trueLogarithmic_type& x);

    void
    trueLogarithmic (const trueLogarithmic_optional& x);

    void
    trueLogarithmic (::std::unique_ptr< trueLogarithmic_type > p);

    // shiftedLogarithmic
    //
    typedef ::pcrxml::EmptyElement shiftedLogarithmic_type;
    typedef ::xsd::cxx::tree::optional< shiftedLogarithmic_type > shiftedLogarithmic_optional;
    typedef ::xsd::cxx::tree::traits< shiftedLogarithmic_type, char > shiftedLogarithmic_traits;

    const shiftedLogarithmic_optional&
    shiftedLogarithmic () const;

    shiftedLogarithmic_optional&
    shiftedLogarithmic ();

    void
    shiftedLogarithmic (const shiftedLogarithmic_type& x);

    void
    shiftedLogarithmic (const shiftedLogarithmic_optional& x);

    void
    shiftedLogarithmic (::std::unique_ptr< shiftedLogarithmic_type > p);

    // confidenceLevel
    //
    typedef ::pcrxml::ConfidenceLevel confidenceLevel_type;
    typedef ::xsd::cxx::tree::optional< confidenceLevel_type > confidenceLevel_optional;
    typedef ::xsd::cxx::tree::traits< confidenceLevel_type, char > confidenceLevel_traits;

    const confidenceLevel_optional&
    confidenceLevel () const;

    confidenceLevel_optional&
    confidenceLevel ();

    void
    confidenceLevel (const confidenceLevel_type& x);

    void
    confidenceLevel (const confidenceLevel_optional& x);

    void
    confidenceLevel (::std::unique_ptr< confidenceLevel_type > p);

    // Constructors.
    //
    ColourAssignment ();

    ColourAssignment (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    ColourAssignment (const ColourAssignment& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual ColourAssignment*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ColourAssignment&
    operator= (const ColourAssignment& x);

    virtual
    ~ColourAssignment ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    linear_optional linear_;
    trueLogarithmic_optional trueLogarithmic_;
    shiftedLogarithmic_optional shiftedLogarithmic_;
    confidenceLevel_optional confidenceLevel_;
  };

  class ConfidenceLevel: public ::xml_schema::type
  {
    public:
    // value
    //
    typedef ::xml_schema::double_ value_type;
    typedef ::xsd::cxx::tree::traits< value_type, char, ::xsd::cxx::tree::schema_type::double_ > value_traits;

    const value_type&
    value () const;

    value_type&
    value ();

    void
    value (const value_type& x);

    // Constructors.
    //
    ConfidenceLevel (const value_type&);

    ConfidenceLevel (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    ConfidenceLevel (const ConfidenceLevel& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual ConfidenceLevel*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ConfidenceLevel&
    operator= (const ConfidenceLevel& x);

    virtual
    ~ConfidenceLevel ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< value_type > value_;
  };

  class DrawMode: public ::xml_schema::type
  {
    public:
    // fill
    //
    typedef ::pcrxml::EmptyElement fill_type;
    typedef ::xsd::cxx::tree::optional< fill_type > fill_optional;
    typedef ::xsd::cxx::tree::traits< fill_type, char > fill_traits;

    const fill_optional&
    fill () const;

    fill_optional&
    fill ();

    void
    fill (const fill_type& x);

    void
    fill (const fill_optional& x);

    void
    fill (::std::unique_ptr< fill_type > p);

    // contour
    //
    typedef ::pcrxml::EmptyElement contour_type;
    typedef ::xsd::cxx::tree::optional< contour_type > contour_optional;
    typedef ::xsd::cxx::tree::traits< contour_type, char > contour_traits;

    const contour_optional&
    contour () const;

    contour_optional&
    contour ();

    void
    contour (const contour_type& x);

    void
    contour (const contour_optional& x);

    void
    contour (::std::unique_ptr< contour_type > p);

    // Constructors.
    //
    DrawMode ();

    DrawMode (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    DrawMode (const DrawMode& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual DrawMode*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DrawMode&
    operator= (const DrawMode& x);

    virtual
    ~DrawMode ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    fill_optional fill_;
    contour_optional contour_;
  };

  class AguilaCursorValues: public ::xml_schema::type
  {
    public:
    // aguilaCursorValue
    //
    typedef ::pcrxml::AguilaCursorValue aguilaCursorValue_type;
    typedef ::xsd::cxx::tree::sequence< aguilaCursorValue_type > aguilaCursorValue_sequence;
    typedef aguilaCursorValue_sequence::iterator aguilaCursorValue_iterator;
    typedef aguilaCursorValue_sequence::const_iterator aguilaCursorValue_const_iterator;
    typedef ::xsd::cxx::tree::traits< aguilaCursorValue_type, char > aguilaCursorValue_traits;

    const aguilaCursorValue_sequence&
    aguilaCursorValue () const;

    aguilaCursorValue_sequence&
    aguilaCursorValue ();

    void
    aguilaCursorValue (const aguilaCursorValue_sequence& s);

    // Constructors.
    //
    AguilaCursorValues ();

    AguilaCursorValues (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    AguilaCursorValues (const AguilaCursorValues& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual AguilaCursorValues*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    AguilaCursorValues&
    operator= (const AguilaCursorValues& x);

    virtual
    ~AguilaCursorValues ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    aguilaCursorValue_sequence aguilaCursorValue_;
  };

  class AguilaCursorValue: public ::xml_schema::type
  {
    public:
    // cursor
    //
    typedef ::pcrxml::Cursor cursor_type;
    typedef ::xsd::cxx::tree::optional< cursor_type > cursor_optional;
    typedef ::xsd::cxx::tree::traits< cursor_type, char > cursor_traits;

    const cursor_optional&
    cursor () const;

    cursor_optional&
    cursor ();

    void
    cursor (const cursor_type& x);

    void
    cursor (const cursor_optional& x);

    void
    cursor (::std::unique_ptr< cursor_type > p);

    // dataValue
    //
    typedef ::pcrxml::DataValue dataValue_type;
    typedef ::xsd::cxx::tree::sequence< dataValue_type > dataValue_sequence;
    typedef dataValue_sequence::iterator dataValue_iterator;
    typedef dataValue_sequence::const_iterator dataValue_const_iterator;
    typedef ::xsd::cxx::tree::traits< dataValue_type, char > dataValue_traits;

    const dataValue_sequence&
    dataValue () const;

    dataValue_sequence&
    dataValue ();

    void
    dataValue (const dataValue_sequence& s);

    // Constructors.
    //
    AguilaCursorValue ();

    AguilaCursorValue (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    AguilaCursorValue (const AguilaCursorValue& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual AguilaCursorValue*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    AguilaCursorValue&
    operator= (const AguilaCursorValue& x);

    virtual
    ~AguilaCursorValue ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    cursor_optional cursor_;
    dataValue_sequence dataValue_;
  };

  class Cursor: public ::xml_schema::type
  {
    public:
    // time
    //
    typedef ::xml_schema::unsigned_int time_type;
    typedef ::xsd::cxx::tree::optional< time_type > time_optional;
    typedef ::xsd::cxx::tree::traits< time_type, char > time_traits;

    const time_optional&
    time () const;

    time_optional&
    time ();

    void
    time (const time_type& x);

    void
    time (const time_optional& x);

    // date
    //
    typedef ::xml_schema::date_time date_type;
    typedef ::xsd::cxx::tree::optional< date_type > date_optional;
    typedef ::xsd::cxx::tree::traits< date_type, char > date_traits;

    const date_optional&
    date () const;

    date_optional&
    date ();

    void
    date (const date_type& x);

    void
    date (const date_optional& x);

    void
    date (::std::unique_ptr< date_type > p);

    // x
    //
    typedef ::xml_schema::double_ x_type;
    typedef ::xsd::cxx::tree::optional< x_type > x_optional;
    typedef ::xsd::cxx::tree::traits< x_type, char, ::xsd::cxx::tree::schema_type::double_ > x_traits;

    const x_optional&
    x () const;

    x_optional&
    x ();

    void
    x (const x_type& x);

    void
    x (const x_optional& x);

    // y
    //
    typedef ::xml_schema::double_ y_type;
    typedef ::xsd::cxx::tree::optional< y_type > y_optional;
    typedef ::xsd::cxx::tree::traits< y_type, char, ::xsd::cxx::tree::schema_type::double_ > y_traits;

    const y_optional&
    y () const;

    y_optional&
    y ();

    void
    y (const y_type& x);

    void
    y (const y_optional& x);

    // Constructors.
    //
    Cursor ();

    Cursor (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    Cursor (const Cursor& x,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    virtual Cursor*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Cursor&
    operator= (const Cursor& x);

    virtual
    ~Cursor ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    time_optional time_;
    date_optional date_;
    x_optional x_;
    y_optional y_;
  };

  class DataValue: public ::xml_schema::type
  {
    public:
    // name
    //
    typedef ::xml_schema::string name_type;
    typedef ::xsd::cxx::tree::traits< name_type, char > name_traits;

    const name_type&
    name () const;

    name_type&
    name ();

    void
    name (const name_type& x);

    void
    name (::std::unique_ptr< name_type > p);

    // value
    //
    typedef ::xml_schema::string value_type;
    typedef ::xsd::cxx::tree::traits< value_type, char > value_traits;

    const value_type&
    value () const;

    value_type&
    value ();

    void
    value (const value_type& x);

    void
    value (::std::unique_ptr< value_type > p);

    // Constructors.
    //
    DataValue (const name_type&,
               const value_type&);

    DataValue (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    DataValue (const DataValue& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual DataValue*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DataValue&
    operator= (const DataValue& x);

    virtual
    ~DataValue ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< name_type > name_;
    ::xsd::cxx::tree::one< value_type > value_;
  };
}

#include <iosfwd>

namespace pcrxml
{
  ::std::ostream&
  operator<< (::std::ostream&, const Aguila&);

  ::std::ostream&
  operator<< (::std::ostream&, const VisualisationGroup&);

  ::std::ostream&
  operator<< (::std::ostream&, const DataSpace&);

  ::std::ostream&
  operator<< (::std::ostream&, const Timesteps&);

  ::std::ostream&
  operator<< (::std::ostream&, const DateMapper&);

  ::std::ostream&
  operator<< (::std::ostream&, const AguilaView&);

  ::std::ostream&
  operator<< (::std::ostream&, const AguilaData&);

  ::std::ostream&
  operator<< (::std::ostream&, const DrawProperties&);

  ::std::ostream&
  operator<< (::std::ostream&, const Palette&);

  ::std::ostream&
  operator<< (::std::ostream&, const Rgb&);

  ::std::ostream&
  operator<< (::std::ostream&, const LegendBorderValuesType&);

  ::std::ostream&
  operator<< (::std::ostream&, const ColourAssignment&);

  ::std::ostream&
  operator<< (::std::ostream&, const ConfidenceLevel&);

  ::std::ostream&
  operator<< (::std::ostream&, const DrawMode&);

  ::std::ostream&
  operator<< (::std::ostream&, const AguilaCursorValues&);

  ::std::ostream&
  operator<< (::std::ostream&, const AguilaCursorValue&);

  ::std::ostream&
  operator<< (::std::ostream&, const Cursor&);

  ::std::ostream&
  operator<< (::std::ostream&, const DataValue&);
}

#include <iosfwd>

#include <xercesc/sax/InputSource.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace pcrxml
{
  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (const ::std::string& uri,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (const ::std::string& uri,
          ::xml_schema::error_handler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (const ::std::string& uri,
          ::xercesc::DOMErrorHandler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::std::istream& is,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::std::istream& is,
          ::xml_schema::error_handler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::std::istream& is,
          ::xercesc::DOMErrorHandler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::std::istream& is,
          const ::std::string& id,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::std::istream& is,
          const ::std::string& id,
          ::xml_schema::error_handler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::std::istream& is,
          const ::std::string& id,
          ::xercesc::DOMErrorHandler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::xercesc::InputSource& is,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::xercesc::InputSource& is,
          ::xml_schema::error_handler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::xercesc::InputSource& is,
          ::xercesc::DOMErrorHandler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (const ::xercesc::DOMDocument& d,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (const ::std::string& uri,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (const ::std::string& uri,
                      ::xml_schema::error_handler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (const ::std::string& uri,
                      ::xercesc::DOMErrorHandler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::std::istream& is,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::std::istream& is,
                      ::xml_schema::error_handler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::std::istream& is,
                      ::xercesc::DOMErrorHandler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::std::istream& is,
                      const ::std::string& id,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::std::istream& is,
                      const ::std::string& id,
                      ::xml_schema::error_handler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::std::istream& is,
                      const ::std::string& id,
                      ::xercesc::DOMErrorHandler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::xercesc::InputSource& is,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::xercesc::InputSource& is,
                      ::xml_schema::error_handler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::xercesc::InputSource& is,
                      ::xercesc::DOMErrorHandler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (const ::xercesc::DOMDocument& d,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (const ::std::string& uri,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (const ::std::string& uri,
                ::xml_schema::error_handler& eh,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (const ::std::string& uri,
                ::xercesc::DOMErrorHandler& eh,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::std::istream& is,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::std::istream& is,
                ::xml_schema::error_handler& eh,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::std::istream& is,
                ::xercesc::DOMErrorHandler& eh,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::std::istream& is,
                const ::std::string& id,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::std::istream& is,
                const ::std::string& id,
                ::xml_schema::error_handler& eh,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::std::istream& is,
                const ::std::string& id,
                ::xercesc::DOMErrorHandler& eh,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::xercesc::InputSource& is,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::xercesc::InputSource& is,
                ::xml_schema::error_handler& eh,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::xercesc::InputSource& is,
                ::xercesc::DOMErrorHandler& eh,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (const ::xercesc::DOMDocument& d,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                ::xml_schema::flags f = 0,
                const ::xml_schema::properties& p = ::xml_schema::properties ());
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace pcrxml
{
  // Serialize to std::ostream.
  //

  void
  aguila (::std::ostream& os,
          const ::pcrxml::Aguila& x,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  void
  aguila (::std::ostream& os,
          const ::pcrxml::Aguila& x,
          ::xml_schema::error_handler& eh,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  void
  aguila (::std::ostream& os,
          const ::pcrxml::Aguila& x,
          ::xercesc::DOMErrorHandler& eh,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  aguila (::xercesc::XMLFormatTarget& ft,
          const ::pcrxml::Aguila& x,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  void
  aguila (::xercesc::XMLFormatTarget& ft,
          const ::pcrxml::Aguila& x,
          ::xml_schema::error_handler& eh,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  void
  aguila (::xercesc::XMLFormatTarget& ft,
          const ::pcrxml::Aguila& x,
          ::xercesc::DOMErrorHandler& eh,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  aguila (::xercesc::DOMDocument& d,
          const ::pcrxml::Aguila& x,
          ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  aguila (const ::pcrxml::Aguila& x,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          ::xml_schema::flags f = 0);

  // Serialize to std::ostream.
  //

  void
  aguilaCursorValues (::std::ostream& os,
                      const ::pcrxml::AguilaCursorValues& x,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      const ::std::string& e = "UTF-8",
                      ::xml_schema::flags f = 0);

  void
  aguilaCursorValues (::std::ostream& os,
                      const ::pcrxml::AguilaCursorValues& x,
                      ::xml_schema::error_handler& eh,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      const ::std::string& e = "UTF-8",
                      ::xml_schema::flags f = 0);

  void
  aguilaCursorValues (::std::ostream& os,
                      const ::pcrxml::AguilaCursorValues& x,
                      ::xercesc::DOMErrorHandler& eh,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      const ::std::string& e = "UTF-8",
                      ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  aguilaCursorValues (::xercesc::XMLFormatTarget& ft,
                      const ::pcrxml::AguilaCursorValues& x,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      const ::std::string& e = "UTF-8",
                      ::xml_schema::flags f = 0);

  void
  aguilaCursorValues (::xercesc::XMLFormatTarget& ft,
                      const ::pcrxml::AguilaCursorValues& x,
                      ::xml_schema::error_handler& eh,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      const ::std::string& e = "UTF-8",
                      ::xml_schema::flags f = 0);

  void
  aguilaCursorValues (::xercesc::XMLFormatTarget& ft,
                      const ::pcrxml::AguilaCursorValues& x,
                      ::xercesc::DOMErrorHandler& eh,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      const ::std::string& e = "UTF-8",
                      ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  aguilaCursorValues (::xercesc::DOMDocument& d,
                      const ::pcrxml::AguilaCursorValues& x,
                      ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  aguilaCursorValues (const ::pcrxml::AguilaCursorValues& x,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      ::xml_schema::flags f = 0);

  // Serialize to std::ostream.
  //

  void
  aguilaCursor (::std::ostream& os,
                const ::pcrxml::Cursor& x,
                const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                const ::std::string& e = "UTF-8",
                ::xml_schema::flags f = 0);

  void
  aguilaCursor (::std::ostream& os,
                const ::pcrxml::Cursor& x,
                ::xml_schema::error_handler& eh,
                const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                const ::std::string& e = "UTF-8",
                ::xml_schema::flags f = 0);

  void
  aguilaCursor (::std::ostream& os,
                const ::pcrxml::Cursor& x,
                ::xercesc::DOMErrorHandler& eh,
                const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                const ::std::string& e = "UTF-8",
                ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  aguilaCursor (::xercesc::XMLFormatTarget& ft,
                const ::pcrxml::Cursor& x,
                const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                const ::std::string& e = "UTF-8",
                ::xml_schema::flags f = 0);

  void
  aguilaCursor (::xercesc::XMLFormatTarget& ft,
                const ::pcrxml::Cursor& x,
                ::xml_schema::error_handler& eh,
                const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                const ::std::string& e = "UTF-8",
                ::xml_schema::flags f = 0);

  void
  aguilaCursor (::xercesc::XMLFormatTarget& ft,
                const ::pcrxml::Cursor& x,
                ::xercesc::DOMErrorHandler& eh,
                const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                const ::std::string& e = "UTF-8",
                ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  aguilaCursor (::xercesc::DOMDocument& d,
                const ::pcrxml::Cursor& x,
                ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  aguilaCursor (const ::pcrxml::Cursor& x,
                const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                ::xml_schema::flags f = 0);

  void
  operator<< (::xercesc::DOMElement&, const Aguila&);

  void
  operator<< (::xercesc::DOMElement&, const VisualisationGroup&);

  void
  operator<< (::xercesc::DOMElement&, const DataSpace&);

  void
  operator<< (::xercesc::DOMElement&, const Timesteps&);

  void
  operator<< (::xercesc::DOMElement&, const DateMapper&);

  void
  operator<< (::xercesc::DOMElement&, const AguilaView&);

  void
  operator<< (::xercesc::DOMElement&, const AguilaData&);

  void
  operator<< (::xercesc::DOMElement&, const DrawProperties&);

  void
  operator<< (::xercesc::DOMElement&, const Palette&);

  void
  operator<< (::xercesc::DOMElement&, const Rgb&);

  void
  operator<< (::xercesc::DOMElement&, const LegendBorderValuesType&);

  void
  operator<< (::xercesc::DOMElement&, const ColourAssignment&);

  void
  operator<< (::xercesc::DOMElement&, const ConfidenceLevel&);

  void
  operator<< (::xercesc::DOMElement&, const DrawMode&);

  void
  operator<< (::xercesc::DOMElement&, const AguilaCursorValues&);

  void
  operator<< (::xercesc::DOMElement&, const AguilaCursorValue&);

  void
  operator<< (::xercesc::DOMElement&, const Cursor&);

  void
  operator<< (::xercesc::DOMElement&, const DataValue&);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
#ifndef INCLUDED_SSTREAM
#include <sstream>
#define INCLUDED_SSTREAM
#endif
#ifndef INCLUDED_STRING
#include <string>
#define INCLUDED_STRING
#endif
#ifndef INCLUDED_PCRXSD_SUPPORTEDSCHEMA
#include "pcrxsd_supportedschema.h"
#define INCLUDED_PCRXSD_SUPPORTEDSCHEMA
#endif
namespace pcrxsd {
  inline xml_schema::namespace_infomap namespaceInfoMap(
      const char* schemaSystemId) {

    // should know schema
    assert(SupportedSchema::findBySystemId(schemaSystemId));

    xml_schema::namespace_infomap map;
    map["pcr"].name = "http://www.pcraster.nl/pcrxml";
    map["pcr"].schema = schemaSystemId;

    return map;
   }

  //! convert an xs:string type to std::string
  /*!
     It is a template version because I have no clue what the actual
     type is :-)
   */
  template<typename T>
   inline std::string toString(
       T const& xsStringTypeValue)
  {
      std::ostringstream s;
      s << xsStringTypeValue;
      return s.str();
  }

//! function template to cast types derived from xsd fundamental types
/*!
 * suppress gcc warnings like:
 * \verbatim
 *  choosing 'xsd::cxx::tree::fundamental_base<X>::operator X&() [with X = unsigned int]' over 'xsd::cxx::tree::fundamental_base<X>::operator Y() const [with Y = unsigned int, X = unsigned int]'
 *    for conversion from 'pcrxml::Non0UnsignedInt' to 'unsigned int'
 *    because conversion sequence for the argument is better
 * \endverbatim
 *
 * generated from types derived from fundamental types like:
 * \verbatim
 * <xs:simpleType name="Non0UnsignedInt">
 *  <xs:restriction base="xs:unsignedInt">
 *    <xs:minInclusive value="1"/>
 *     </xs:restriction>
 *     </xs:simpleType>
 * \endverbatim
 *
 * solution is inspired by xsd/examples/cxx/tree/library/library.cxx
 *
 * MSVC-8.0 does not compile the solution, but also does not complain about
 * this issue. Hence, for MSVC this function is a NO-OP
 *
 * the macro (NOT USED)
 * #define XSD_CAST(type,value) \
 * (static_cast< ::xsd::cxx::tree::fundamental_base< type > const& >(value))
 */
template<
  typename T,
  typename V>
inline T fundamentalBaseCast(V value) {
#ifdef _MSC_VER
   return value;
#else
   return value;
//   return static_cast< ::xsd::cxx::tree::fundamental_base<T> const& >(value);
#endif
  }
}
//
// End epilogue.

#endif // AGUILA_XSD_H
