#ifndef INCLUDED_CALC_OPERATOR
#define INCLUDED_CALC_OPERATOR

#ifndef INCLUDED_STDDEFX
#include "stddefx.h"
#define INCLUDED_STDDEFX
#endif

#ifndef INCLUDED_CALCTYPES
# include "calctypes.h"
#define INCLUDED_CALCTYPES
#endif

#ifndef INCLUDED_MAJOR_OP
# include "major_op.h"
#define INCLUDED_MAJOR_OP
#endif

#ifndef INCLUDED_STRING
# include <string>
#define INCLUDED_STRING
#endif
#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif


/* appearance of an operator/function
 */
typedef enum SYNTAX {
    SYNTAX_FUNC=0, /* like func(...)  */
    SYNTAX_OP=1,    /* like ... op ... */
    SYNTAX_NONE=2  /* grammar construction */
} SYNTAX;

typedef enum CG {    /* code generation type */
  CG_COMM=0,   /* commutative operator */
  CG_VARARG=1, /* variable number of arguments 
                * should be split out in binary ops.
                * min,max,cover
                */
  CG_SPEC=2,   /* codes needs to be generated by special rules */
  CG_PLAIN=3   /* default algorithm */
} CG;

/*!
 * \todo
 *   rename EXEC_MISC to something sensible
 */
typedef enum EXEC { /* execution type */
        /* A is in { UINT1, INT4, REAL4 }
         * s,n,?,d = spatial,nonspatial,both, derived
         */
        EXEC_MISC,   /* MISNAMED, more a EXEC_MIXED, mis-used for test_until */
        /* SEGMENTABLE: */
        EXEC_SAME_UN,   /* Ad = op A?, */
        EXEC_SAME_BIN,  /* Ad = A? op A? */
        EXEC_DIFF_UN,   /* Ad = op A?, */
        EXEC_DIFF_BIN,  /* Ad = A? op A? */
        EXEC_IFTHENELSE,    /* Ad = mif(t then j else k ) */
        EXEC_IFTHEN,    /* Ad = mif(t then j else k ) */
        EXEC_GEN_NS,       /* generate something non spatial */
        EXEC_GEN_SP,       /* generate something spatial */
        /* NOT SEGMENTABLE: */
        EXEC_GLOBAL,    /* args can be spatial or non-spatial
                           * and of all cell representations
                           */
        EXEC_DASS,      /* same as GLOBAL but two results */
        EXEC_TOUT,     
        EXEC_EXTERN,   /* dynamic linked functions */
        /* exec_types that are remapped to one of the
         * above in the makecode module
         */
        EXEC_DOUBLE,   /* function that returns 1 of the result of a DASS type */
        EXEC_POLY,     /* there are different impl. for uint1,int4 and scalar  */
        EXEC_TRIG,     /* there are different impl. for scalar and directional input  */
        EXEC_CONV,     /* there are different impl. stored in the conv. matrix */
        EXEC_ASS,      /* syntax only not an executable construction, +=, *=, etc. */
        EXEC_LOOKUP,   /* lookupfunctions */
        EXEC_T_IN,     /* timeinputfunctions */
        EXEC_INDEX,    /* indextablefunctions */
        EXEC_NONE      /* syntax only not an executable construction */
} EXEC;

namespace calc {

class Operator {
  /* friends for pushBackArg only */
  friend class ParsArgTable;
  friend class MethodOperator;
  friend class ExternalSymbols;

  /* const */  std::string d_name; /* name of operator or function   */
  MAJOR_CODE  d_major;      /* major number of operation      */
  SYNTAX  d_syntax; 
  VS      d_vs;        /* what type the operator returns */
  ST      d_st;             /* how about spatial or nonspatial? */
  int     d_nrArgs;     /*  < -1 means that function can have unlimited
                       *  nr. args and ABS(nrArg-1) is type for
                       *  all arguments nrs. > ABS(nrArg)
                       *  -1 means also unlimited nr of args but 
                       *     at least two
                       */
  EXEC     d_exec;
  int      d_execId;
  CG       d_cg;
  std::vector<OP_ARGS> d_argPars;
  int      nrArgsDef() const { return ABS(d_nrArgs); }
  void pushBackArg(VS vs, ST st);
public:
  // CREATORS
  Operator(const std::string &name,
    MAJOR_CODE major,SYNTAX syntax,
    VS vs,ST st, int nrArgs,EXEC exec,int execId, CG cg);
  // ACCESSORS
  const std::string& name()   const { return d_name; }
  VS   vs()     const { return d_vs; }
  ST   st()     const { return d_st; }
  VS   argVs(int a)  const;
  ST   argSt(int a)  const;
  int  firstPolyArg() const;
  int  nrArgs() const { return d_nrArgs; }
  std::string  syntax() const;
  std::string  strArg(int argNr) const; // return an argument description

  MAJOR_CODE opCode() const { return d_major; }
  EXEC exec() const { return d_exec; }
  int  execId() const { return d_execId; }
  CG   cg() const { return d_cg; }

};

}

#endif
