# PCRaster
Environmental modelling software

PCRaster is a collection of tools and software libraries tailored to the construction of spatio-temporal environmental models. Application domains are amongst others hydrology (rainfall-runoff, global water balance, groundwater (with Modflow)), ecology, or land use change. Two scripting languages (Python and PCRcalc) include a rich set of spatial operations for manipulating and analysing raster maps. A Python framework supports Monte Carlo simulations and data assimilation (Ensemble Kalman Filter and Particle Filter). The Aguila tool allows for the interactive visualisation of stochastic spatio-temporal data.

You can find more information about our research and development projects on [our website.](http://computationalgeography.org/) Information on PCRaster is given at the [project website](http://www.pcraster.eu/), and online documentation can be found [here](https://pcraster.geo.uu.nl/pcraster/latest/documentation/index.html). For questions regarding the usage of PCRaster please use our [mailing list](https://lists.geo.uu.nl/mailman/listinfo/pcraster-info), bugs can be reported via our [issue tracker](https://github.com/pcraster/pcraster/issues).


## Installation
[![Anaconda-Server Badge](https://anaconda.org/conda-forge/pcraster/badges/version.svg)](https://anaconda.org/conda-forge/pcraster)
[![Anaconda-Server Badge](https://anaconda.org/conda-forge/pcraster/badges/platforms.svg)](https://anaconda.org/conda-forge/pcraster)
[![Anaconda-Server Badge](https://anaconda.org/conda-forge/pcraster/badges/installer/conda.svg)](https://conda.anaconda.org/conda-forge)

Packages are available for Linux, macOS and Windows via [conda-forge](https://github.com/conda-forge/pcraster-feedstock).
Install PCRaster with:

```bash
conda install -c conda-forge pcraster
```

More information on the installation of PCRaster is given in the [documentation](https://pcraster.geo.uu.nl/pcraster/latest/documentation/pcraster_project/install.html).

## Build status
CI builds of our current development version:

[![Linux build status](https://github.com/pcraster/pcraster/workflows/Linux%20CI/badge.svg)](https://github.com/pcraster/pcraster/actions/workflows/linux.yaml)
[![macOS build status](https://github.com/pcraster/pcraster/workflows/macOS%20CI/badge.svg)](https://github.com/pcraster/pcraster/actions/workflows/macos.yaml)
[![Linux Conda status](https://github.com/pcraster/pcraster/actions/workflows/linux-conda.yaml/badge.svg)](https://github.com/pcraster/pcraster/actions/workflows/linux-conda.yaml)
[![Windows build status](https://github.com/pcraster/pcraster/actions/workflows/windows.yaml/badge.svg)](https://github.com/pcraster/pcraster/actions/workflows/windows.yaml)

