#include "stddefx.h"

#ifndef INCLUDED_COM_CPUCYCLECOUNTER
#include "com_cpucyclecounter.h"
#define INCLUDED_COM_CPUCYCLECOUNTER
#endif
#ifndef INCLUDED_COM_CSFCELL
#include "com_csfcell.h"
#define INCLUDED_COM_CSFCELL
#endif
#ifndef INCLUDED_IOSTREAM
#include <iostream>
#define INCLUDED_IOSTREAM
#endif
#ifndef INCLUDED_COM_MATH
#include "com_math.h"
#define INCLUDED_COM_MATH
#endif

#ifndef INCLUDED_CALC_SIMDMATH
#include "calc_simdmath.h"
#define INCLUDED_CALC_SIMDMATH
#endif

/*
check if MV will generate a cost penalty
check if domain problems will generate a cost penalty
 sqrt(ddA)
  if isNan
  setMV9ddd);

generate a test suite that compiles into (? pcrcom)
  run the MV/domain test on a 8-element arrays
  and performance test on a 32000 array.

kijk of laaste gcc meer sse heeft en wat de laatste mingw is.
*/
#define N 200003
#define MV_AT 3

int main(
  int   ,
  char**)
{
  size_t NC=N;
  float *f,*r1,*r2;
  posix_memalign((void**)&f,16,N*4);
  posix_memalign((void**)&r1,16,N*4);
  posix_memalign((void**)&r2,16,N*4);
  PRECOND(!(((int)f)%16));
  PRECOND(!(((int)r1)%16));
  PRECOND(!(((int)r2)%16));

  for(size_t i=0; i < NC; ++i) {
    if (i%MV_AT) {
      f[i]=i+0.5;
      r1[i]=3;
      r2[i]=3;
    }
    else
      com::setMV(f[i]);
  }

  bool check=false;

   startCpuCycleCounter(0);

   for (size_t i=0; i < NC; ++i) {
     if (!com::isMV(f[i]))
      r1[i]=(r1[i]-r1[i]);
     else
      com::setMV(r1[i]);
   }
   for (size_t i=0; i < NC; ++i) {
     if (!com::isMV(f[i]))
      r1[i]=(r1[i])*f[i];
     else
      com::setMV(r1[i]);
   }

   for (size_t i=0; i < NC; ++i) {
     if (check) {
      if (i%MV_AT) {
       POSTCOND(!com::isMV(f[i]));
       POSTCOND(!com::isMV(r1[i]));
       POSTCOND( com::equal_epsilon(r1[i],(float)(i+0.5)*0));
      }
      else
       POSTCOND(com::isMV(r1[i]));
     }
   }
   stopCpuCycleCounter(0);

   startCpuCycleCounter(1);
   calc::SIMDInstr<calc::Mulps,float>::assTo1stArg(r2,f,NC);
   if (check)
    for (size_t i=0; i < NC; ++i) {
      if (i%MV_AT) {
       POSTCOND(!com::isMV(f[i]));
       POSTCOND(!com::isMV(r2[i]));
       POSTCOND( com::equal_epsilon(r2[i],(float)(i+0.5)*0));
      } else
       POSTCOND(com::isMV(r2[i]));
    }
   stopCpuCycleCounter(1);



   if (check)
     std::cout << "No stats! Verify mode" << std::endl;
   else

    writeCpuCycleCounterStats(16);
    writeCpuCycleCounterStats(8);
  return 0;
}
