#ifndef INCLUDED_STDDEFX
#include "stddefx.h"
#define INCLUDED_STDDEFX
#endif

#ifndef INCLUDED_CALC_OPIMPL
#include "calc_opimpl.h"
#define INCLUDED_CALC_OPIMPL
#endif

// Library headers.

// PCRaster library headers.

// Module headers.
#ifndef INCLUDED_CALC_CR
#include "calc_cr.h"
#define INCLUDED_CALC_CR
#endif
#ifndef INCLUDED_CALC_FIELD
#include "calc_field.h"
#define INCLUDED_CALC_FIELD
#endif
#ifndef INCLUDED_CALC_RUNTIMEENV
#include "calc_runtimeenv.h"
#define INCLUDED_CALC_RUNTIMEENV
#endif
#ifndef INCLUDED_CALC_FINDSYMBOL
#include "calc_findsymbol.h"
#define INCLUDED_CALC_FINDSYMBOL
#endif

/*!
  \file
  This file contains the implementation of the IOpImpl class.
*/

#ifndef INCLUDED_CALC_SPATIAL
#include "calc_spatial.h"
#define INCLUDED_CALC_SPATIAL
#endif
#ifndef INCLUDED_CALC_OPERATOR
#include "calc_operator.h"
#define INCLUDED_CALC_OPERATOR
#endif
#ifndef INCLUDED_CALC_EXECARGUMENTS
#include "calc_execarguments.h"
#define INCLUDED_CALC_EXECARGUMENTS
#endif
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// DEFINITION OF STATIC IOPIMPL MEMBERS
//------------------------------------------------------------------------------
namespace calc {
  template<class V, class I>
    static void initOp(V& fArray, const I *f) {
      if (f)
        fArray[f->cri()]=f;
    }


  struct BinArg {
   typedef enum LR { Left=0, Right=1} LR;
   typedef enum T { SS_NN=0, NS=1, SN=2 } T;
   T       t;
   size_t  n; // max array size
   BinArg(const ExecArguments& a,size_t left=Left,size_t right=Right)
   {
      n=std::max<>(a[left].nrValues(),a[right].nrValues());
      t=SS_NN;
      if (a[left].isSpatial() != a[right].isSpatial()) {
        t = a[left].isSpatial() ? SN : NS;
      }
   }
  };

};


//------------------------------------------------------------------------------
// DEFINITION OF IOPIMPL MEMBERS
//------------------------------------------------------------------------------

calc::SameUn::SameUn(const ISameUn* fieldOp):
 d_fieldOp(fieldOp)
{}

calc::SameUn::~SameUn()
{}

void calc::SameUn::exec(RunTimeEnv* rte,const Operator& op, size_t nrArgs) const
{
  PRECOND(nrArgs==1);
  ResultIsSrc   a(op,rte,nrArgs);
  d_fieldOp->f(a.dest(0),a[0].nrValues());
  a.pushResult();
}

void calc::SameUn::genPointCode      (PointCodeGenerator* /*g*/) const
{}

calc::SameBin::SameBin( const ISameBin* op1,
                        const ISameBin* op2,
                        const ISameBin* op3):
  d_fieldOp(3)
{
 initOp(d_fieldOp,op1);
 initOp(d_fieldOp,op2);
 initOp(d_fieldOp,op3);
}

calc::SameBin::~SameBin()
{}
#ifndef INCLUDED_CALC_SIMDMATH
#include "calc_simdmath.h"
#define INCLUDED_CALC_SIMDMATH
#endif
void calc::SameBin::exec              (RunTimeEnv* rte,const Operator& op,size_t nrArgs) const
{
  PRECOND(nrArgs==2);
  typedef BinArg B;
  ResultIsSrc   a(op,rte,2);
  B             b(a);

  POSTCOND(a[B::Left].cri() == a[B::Right].cri()); // same binary operands

  CRIndex i = a[B::Left].cri();
  POSTCOND(d_fieldOp[i]);
  switch(b.t) {
    case B::SS_NN: {
        size_t left =B::Left;
        size_t right=B::Right;
        // optimize a redundant field copy
        if (op.cg()==CG_COMM && a[left].readOnlyReference())
          std::swap(left,right);
        if (b.n > 1)
        switch(op.opCode()) {
          case OP_MUL:
              calc::SIMDInstr<Mulps,float>::assTo1stArg(
                   (REAL4*)a.dest(left),a[right].src_f(),b.n);break;
          case OP_BADD:
              calc::SIMDInstr<Addps,float>::assTo1stArg(
                   (REAL4*)a.dest(left),a[right].src_f(),b.n);break;
          case OP_BMIN:
              calc::SIMDInstr<Subps,float>::assTo1stArg(
                   (REAL4*)a.dest(left),a[right].src_f(),b.n);break;
          default:
            d_fieldOp[i]->ss(a.dest(left),a[right].src(),b.n);break;
        }
        else
            d_fieldOp[i]->ss(a.dest(left),a[right].src(),b.n);break;
      }
    case B::SN:
      // if (op.opCode() == OP_POW) // TODO optimize 0.5,1,2,3,4,etc.
      //    std::cout << "pow exp " << *a[B::Right].src_f()  << std::endl;
      d_fieldOp[i]->sn(a.dest(B::Left),a[B::Right].src(),b.n);
      break;
    case B::NS:
      d_fieldOp[i]->ns(a[B::Left].src(),a.dest(B::Right),b.n);
      break;
  }

  a.pushResult();
}

void calc::SameBin::genPointCode      (PointCodeGenerator* /*g*/) const
{}

void calc::DiffBin::exec(RunTimeEnv* rte,const Operator& op,size_t nrArgs) const
{
  PRECOND(nrArgs==2);
  typedef BinArg B;
  ExecArguments a(op,rte,2);
  B             b(a);

  UINT1 *r = static_cast<UINT1 *>(a.dest());
  CRIndex i = a[1].cri(); // selection on 2nd/right operand in case of IfThenArray
  POSTCOND(d_fieldOp[i]);
  switch(b.t) {
    case B::SS_NN:
      d_fieldOp[i]->ss(r,a[0].src(),a[1].src(),b.n);break;
    case B::SN:
      d_fieldOp[i]->sn(r,a[0].src(),a[1].src(),b.n);break;
    case B::NS:
      d_fieldOp[i]->ns(r,a[0].src(),a[1].src(),b.n); break;
  }

  a.pushResult();
}

calc::DiffBin::DiffBin(const IDiffBin* op1,
                       const IDiffBin* op2,
                       const IDiffBin* op3):
  d_fieldOp(3)
{
 initOp(d_fieldOp,op1);
 initOp(d_fieldOp,op2);
 initOp(d_fieldOp,op3);
}

calc::DiffBin::~DiffBin()
{}
void calc::DiffBin::genPointCode      (PointCodeGenerator* /*g*/) const
{}

void calc::IfThenElse::exec(RunTimeEnv* rte,const Operator& op,size_t nrArgs) const
{
  PRECOND(nrArgs==3);
  typedef BinArg B;
  ExecArguments a(op,rte,3);
  B             b(a,1,2);

  if (a[0].isSpatial()) {
    // compute field
    CRIndex i = a[1].cri(); // selection on true branch of IfThenElseArray
    // always spatial
    size_t n = std::max<>(a[0].nrValues(),b.n);
    POSTCOND(d_fieldOp[i]);
    switch(b.t) {
      case B::SS_NN:
       if (a[1].isSpatial())
        d_fieldOp[i]->ss(a.dest(),a[0].src_1(),a[1].src(),a[2].src(),n);
       else
        d_fieldOp[i]->nn(a.dest(),a[0].src_1(),a[1].src(),a[2].src(),n);
       break;
      case B::SN:
        d_fieldOp[i]->sn(a.dest(),a[0].src_1(),a[1].src(),a[2].src(),n);
        break;
      case B::NS:
        d_fieldOp[i]->ns(a.dest(),a[0].src_1(),a[1].src(),a[2].src(),n);
        break;
    }
    a.pushResult();
  } else {
    // condition is nonspatial: select an entire branch field as result
    PRECOND(!a[0].isMV());
    bool           cond=a[0].src_1()[0]==1;
    size_t resultBranch=cond ?  1 : 2;
    size_t  otherBranch=3-resultBranch;

    // set result to this argument
    (void)a.dest(resultBranch);
    bool cast=!a.result()->isSpatial() && a[otherBranch].isSpatial();
    a.pushResult();
    if (cast)
      major2op(OP_SPATIAL)->exec(rte,1);
  }
}

calc::IfThenElse::IfThenElse(const IIfThenElse* op1,
                       const IIfThenElse* op2,
                       const IIfThenElse* op3):
  d_fieldOp(3)
{
 initOp(d_fieldOp,op1);
 initOp(d_fieldOp,op2);
 initOp(d_fieldOp,op3);
}

calc::IfThenElse::~IfThenElse()
{}
void calc::IfThenElse::genPointCode      (PointCodeGenerator* /*g*/) const
{}

calc::DiffUn::DiffUn(const IDiffUn* op1,
                     const IDiffUn* op2,
                     const IDiffUn* op3):
 d_fieldOp(3)
{
 initOp(d_fieldOp,op1);
 initOp(d_fieldOp,op2);
 initOp(d_fieldOp,op3);
}

calc::DiffUn::~DiffUn()
{}

void calc::DiffUn::exec              (RunTimeEnv* rte,const Operator& op,size_t nrArgs) const
{
  PRECOND(nrArgs==1);
  ExecArguments a(op,rte,nrArgs);
  Field& r(a.createResult());

  size_t n=std::max(r.nrValues(),a[0].nrValues());
  CRIndex i = a[0].cri();
  if (!d_fieldOp[i])
    POSTCOND(d_fieldOp[i]);
  d_fieldOp[i]->f(r.dest(),a[0].src(),n);

  a.pushResult();
}

void calc::DiffUn::genPointCode      (PointCodeGenerator* /*g*/) const
{}

calc::SpatialImpl::SpatialImpl(const IDiffUn* op1,
                     const IDiffUn* op2,
                     const IDiffUn* op3):
 DiffUn(op1,op2,op3)
{
}

calc::SpatialImpl::~SpatialImpl()
{}

void calc::SpatialImpl::exec              (RunTimeEnv* rte,const Operator& op,size_t nrArgs) const
{
  Field *in=rte->fieldStack().pop();
  bool  nop=in->isSpatial();
  rte->fieldStack().push(in);
  if (!nop)
    DiffUn::exec(rte,op,nrArgs);
}

#ifndef INCLUDED_CALC_GENERATEFIELD
#include "calc_generatefield.h"
#define INCLUDED_CALC_GENERATEFIELD
#endif
calc::GenNonSpatial::GenNonSpatial()
{}
calc::GenNonSpatial::~GenNonSpatial()
{}
void calc::GenNonSpatial::exec          (RunTimeEnv* rte,const Operator& op,size_t nrArgs) const
{
  PRECOND(nrArgs==0);
  ExecArguments a(op,rte,nrArgs);
  Field& r(a.createResult());

  GenerateNonSpatial gsf(rte->rasterSpace());
  switch(op.opCode()) {
    case OP_CELLLENGTH:
      gsf.celllength(r.dest_f()); break;
    case OP_CELLAREA:
      gsf.cellarea(r.dest_f()); break;
    case OP_MAPUNIFORM:
      gsf.mapuniform(r.dest_f()); break;
    case OP_MAPNORMAL:
      gsf.mapnormal(r.dest_f()); break;
    case OP_TIME:
     *(r.dest_f())=rte->currentTimeStep(); break;
    case OP_TIMESLICE:
     *(r.dest_f())=1; break;
    default: PRECOND(FALSE);
  }
  a.pushResult();
}

calc::GenSpatial::GenSpatial()
{}
calc::GenSpatial::~GenSpatial()
{}

/*!
 * \bug  the Operator::exec d_impl->setOp() fix makes it possible to
 *  have a single GenSpatial and NonSpatial class, if that is fixed
 *  this is not possible
 */
void calc::GenSpatial::exec              (RunTimeEnv* rte,const Operator& op,size_t nrArgs) const
{
  PRECOND(nrArgs==1);
  ExecArguments a(op,rte,nrArgs);
  Field& r(a.createResult());
  GenerateSpatial gsf(a[0],rte->spatialPacking(),rte->rasterSpace());

  switch(op.opCode()) {
    case OP_UNIQUEID:
      gsf.uniqueid(r.dest_f()); break;
    case OP_XCOORDINATE:
      gsf.xcoordinate(r.dest_f()); break;
    case OP_YCOORDINATE:
      gsf.ycoordinate(r.dest_f()); break;
    case OP_NORMAL:
      gsf.normal(r.dest_f()); break;
    case OP_UNIFORM:
      gsf.uniform(r.dest_f()); break;
    default: PRECOND(FALSE);
  }
  a.pushResult();
}

void calc::GenSpatial::genPointCode(PointCodeGenerator* /*g*/) const
{
}
void calc::GenNonSpatial::genPointCode(PointCodeGenerator* /*g*/) const
{
}

calc::Conversion::Conversion()
{}
calc::Conversion::~Conversion()
{}

#ifndef INCLUDED_MISC
#include "misc.h"  // BITSET
#define INCLUDED_MISC
#endif
void calc::Conversion::exec          (RunTimeEnv* rte,const Operator& op,size_t nrArgs) const
{
  PRECOND(nrArgs==1);

  /*!return the proper value scale conversion based
   * on internal conversion matrix
   */
  struct ConvTable {
  MAJOR_CODE operator()(VS from, VS to)
  {
    const MAJOR_CODE convTable[6][6] = {
    // indexed by 2log valuescale
    // from:  |   to:
    //        |   VS_B 1      VS_N 4      VS_O 4      VS_S s      VS_D s     VS_L 1
    /* VS_B 1 */ {OP_NOP    , OP_C_1_2_N, OP_C_1_2_O, OP_C_1_2_S, OP_C_1_2_D ,OP_ILL     },
    /* VS_N 4 */ {OP_C_4_2_B, OP_NOP    , OP_NOP    , OP_C_4_2_S, OP_C_4_2_D ,OP_C_4_2_L },
    /* VS_O 4 */ {OP_C_4_2_B, OP_NOP    , OP_NOP    , OP_C_4_2_S, OP_C_4_2_D ,OP_C_4_2_L },
    /* VS_S s */ {OP_C_S_2_B, OP_C_S_2_N, OP_C_S_2_O, OP_NOP    , OP_C_S_2_D ,OP_C_S_2_L },
    /* VS_D s */ {OP_C_S_2_B, OP_C_D_2_N, OP_C_D_2_O, OP_C_D_2_S, OP_NOP     ,OP_C_D_2_L },
    /* VS_L 1 */ {OP_C_1_2_B, OP_C_1_2_N, OP_C_1_2_O, OP_C_1_2_S, OP_C_L_2_D ,OP_NOP   }};
    from = biggestVs(from);
    PRECOND(NRBITSET_TYPE(from,VS) == 1);
    PRECOND(NRBITSET_TYPE(to  ,VS) == 1);
    PRECOND(FIRSTBITSET_TYPE(from,VS) < 6);
    PRECOND(FIRSTBITSET_TYPE(to  ,VS) < 6);
    return convTable[FIRSTBITSET_TYPE(from,VS)][FIRSTBITSET_TYPE(to  ,VS)];
   }
  };

  Field *in=rte->fieldStack().pop();
  MAJOR_CODE doOp=ConvTable()(in->vs(),op.vs());
  POSTCOND(doOp!=OP_ILL);
  rte->fieldStack().push(in); 
  if (doOp != OP_NOP)
    major2op(doOp)->exec(rte,1);
  // ELSE in == out for OP_NOP
}

void calc::Conversion::genPointCode(PointCodeGenerator* /*g*/) const
{
}

calc::Trig::Trig(const ISameUn* fieldOp):
 d_fieldOp(fieldOp)
{}

calc::Trig::~Trig()
{}

void calc::Trig::exec              (RunTimeEnv* rte,const Operator& op,size_t nrArgs) const
{
  // need conversion?
  Field *in=rte->fieldStack().pop();
  if (in->vs() == VS_S) {
    rte->fieldStack().push(in);
    major2op(OP_C_S_2_D)->exec(rte,1);
  } else
    rte->fieldStack().push(in);

  PRECOND(nrArgs==1);
  ResultIsSrc   a(op,rte,nrArgs);
  PRECOND(a[0].vs()==VS_D);
  d_fieldOp->f(a.dest(0),a[0].nrValues());

  a.pushResult();
}

void calc::Trig::genPointCode      (PointCodeGenerator* /*g*/) const
{
  // select on base of VS_S or VS_D
}

/* NOT IMPLEMENTED
//! Assignment operator.
calc::IOpImpl& calc::IOpImpl::operator=(const IOpImpl& rhs)
{
  if (this != &rhs) {
  }
  return *this;
}

//! Copy constructor. NOT IMPLEMENTED.
calc::IOpImpl::IOpImpl(const IOpImpl& rhs):
  Base(rhs)
{
}
*/


//------------------------------------------------------------------------------
// DEFINITION OF FREE OPERATORS
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
// DEFINITION OF FREE FUNCTIONS
//------------------------------------------------------------------------------



