
/*
    pbrt source code is Copyright(c) 1998-2016
                        Matt Pharr, Greg Humphreys, and Wenzel Jakob.

    This file is part of pbrt.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are
    met:

    - Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

    - Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
    IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
    TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
    HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */


// core/sobolmatrices.cpp*
// Copyright (c) 2012 Leonhard Gruenschloss (leonhard@gruenschloss.org)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
// of the Software, and to permit persons to whom the Software is furnished to
// do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

// These matrices are based on the following publication:
//
// S. Joe and F. Y. Kuo: "Constructing Sobol sequences with better
// two-dimensional projections", SIAM J. Sci. Comput. 30, 2635-2654 (2008).
//
// The tabulated direction numbers are available here:
// http://web.maths.unsw.edu.au/~fkuo/sobol/new-joe-kuo-6.21201

#include "sobolmatrices.h"

namespace pbrt {

const uint32_t SobolMatrices32[NumSobolDimensions * SobolMatrixSize] = {
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x04000000,
    0x02000000, 0x01000000, 0x00800000, 0x00400000, 0x00200000, 0x00100000,
    0x00080000, 0x00040000, 0x00020000, 0x00010000, 0x00008000, 0x00004000,
    0x00002000, 0x00001000, 0x00000800, 0x00000400, 0x00000200, 0x00000100,
    0x00000080, 0x00000040, 0x00000020, 0x00000010, 0x00000008, 0x00000004,
    0x00000002, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x80000000, 0xc0000000,
    0xa0000000, 0xf0000000, 0x88000000, 0xcc000000, 0xaa000000, 0xff000000,
    0x80800000, 0xc0c00000, 0xa0a00000, 0xf0f00000, 0x88880000, 0xcccc0000,
    0xaaaa0000, 0xffff0000, 0x80008000, 0xc000c000, 0xa000a000, 0xf000f000,
    0x88008800, 0xcc00cc00, 0xaa00aa00, 0xff00ff00, 0x80808080, 0xc0c0c0c0,
    0xa0a0a0a0, 0xf0f0f0f0, 0x88888888, 0xcccccccc, 0xaaaaaaaa, 0xffffffff,
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x88000000, 0xcc000000,
    0xaa000000, 0xff000000, 0x80800000, 0xc0c00000, 0xa0a00000, 0xf0f00000,
    0x88880000, 0xcccc0000, 0xaaaa0000, 0xffff0000, 0x80008000, 0xc000c000,
    0xa000a000, 0xf000f000, 0x80000000, 0xc0000000, 0x60000000, 0x90000000,
    0xe8000000, 0x5c000000, 0x8e000000, 0xc5000000, 0x68800000, 0x9cc00000,
    0xee600000, 0x55900000, 0x80680000, 0xc09c0000, 0x60ee0000, 0x90550000,
    0xe8808000, 0x5cc0c000, 0x8e606000, 0xc5909000, 0x6868e800, 0x9c9c5c00,
    0xeeee8e00, 0x5555c500, 0x8000e880, 0xc0005cc0, 0x60008e60, 0x9000c590,
    0xe8006868, 0x5c009c9c, 0x8e00eeee, 0xc5005555, 0x68808000, 0x9cc0c000,
    0xee606000, 0x55909000, 0x8068e800, 0xc09c5c00, 0x60ee8e00, 0x9055c500,
    0xe880e880, 0x5cc05cc0, 0x8e608e60, 0xc590c590, 0x68686868, 0x9c9c9c9c,
    0xeeeeeeee, 0x55555555, 0x80000000, 0xc0000000, 0x60000000, 0x90000000,
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xf8000000, 0x74000000,
    0xa2000000, 0x93000000, 0xd8800000, 0x25400000, 0x59e00000, 0xe6d00000,
    0x78080000, 0xb40c0000, 0x82020000, 0xc3050000, 0x208f8000, 0x51474000,
    0xfbea2000, 0x75d93000, 0xa0858800, 0x914e5400, 0xdbe79e00, 0x25db6d00,
    0x58800080, 0xe54000c0, 0x79e00020, 0xb6d00050, 0x800800f8, 0xc00c0074,
    0x200200a2, 0x50050093, 0xf80f80d8, 0x74074025, 0xa20a2059, 0x930930e6,
    0xd88d8878, 0x254254b4, 0x59e59e82, 0xe6de6dc3, 0x780f80a0, 0xb4074091,
    0x820a20db, 0xc3093025, 0x208d8858, 0x514254e5, 0xfbe59e79, 0x75de6db6,
    0xa08f8000, 0x91474000, 0xdbea2000, 0x25d93000, 0x80000000, 0x40000000,
    0x20000000, 0xb0000000, 0xf8000000, 0xdc000000, 0x7a000000, 0x9d000000,
    0x5a800000, 0x2fc00000, 0xa1600000, 0xf0b00000, 0xda880000, 0x6fc40000,
    0x81620000, 0x40bb0000, 0x22878000, 0xb3c9c000, 0xfb65a000, 0xddb2d000,
    0x78022800, 0x9c0b3c00, 0x5a0fb600, 0x2d0ddb00, 0xa2878080, 0xf3c9c040,
    0xdb65a020, 0x6db2d0b0, 0x800228f8, 0x400b3cdc, 0x200fb67a, 0xb00ddb9d,
    0xf80780da, 0xdc09c06f, 0x7a05a081, 0x9d02d040, 0x5a8a2822, 0x2fcf3cb3,
    0xa16db6fb, 0xf0b6dbdd, 0xda8000f8, 0x6fc000dc, 0x8160007a, 0x40b0009d,
    0x2288005a, 0xb3c4002f, 0xfb6200a1, 0xddbb00f0, 0x780780da, 0x9c09c06f,
    0x5a05a081, 0x2d02d040, 0x80000000, 0x40000000, 0x60000000, 0x30000000,
    0xc8000000, 0x24000000, 0x56000000, 0xfb000000, 0xe0800000, 0x70400000,
    0xa8600000, 0x14300000, 0x9ec80000, 0xdf240000, 0xb6d60000, 0x8bbb0000,
    0x48008000, 0x64004000, 0x36006000, 0xcb003000, 0x2880c800, 0x54402400,
    0xfe605600, 0xef30fb00, 0x7e48e080, 0xaf647040, 0x1eb6a860, 0x9f8b1430,
    0xd6c81ec8, 0xbb249f24, 0x80d6d6d6, 0x40bbbbbb, 0x60800000, 0x30400000,
    0xc8600000, 0x24300000, 0x56c80000, 0xfb240000, 0xe0d60000, 0x70bb0000,
    0xa8808000, 0x14404000, 0x9e606000, 0xdf303000, 0xb648c800, 0x8b642400,
    0x48b65600, 0x648bfb00, 0x36486080, 0xcb643040, 0x28b6c860, 0x548b2430,
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x58000000, 0x94000000,
    0x3e000000, 0xe3000000, 0xbe800000, 0x23c00000, 0x1e200000, 0xf3100000,
    0x46780000, 0x67840000, 0x78460000, 0x84670000, 0xc6788000, 0xa784c000,
    0xd846a000, 0x5467d000, 0x9e78d800, 0x33845400, 0xe6469e00, 0xb7673300,
    0x20f86680, 0x104477c0, 0xf8668020, 0x4477c010, 0x668020f8, 0x77c01044,
    0x8020f866, 0xc0104477, 0xa0f86680, 0xd04477c0, 0x58668020, 0x9477c010,
    0x3e8020f8, 0xe3c01044, 0xbe20f866, 0x23104477, 0x1e786680, 0xf38477c0,
    0x46468020, 0x6767c010, 0x78f820f8, 0x84441044, 0xc666f866, 0xa7774477,
    0xd800e680, 0x5400b7c0, 0x9e002020, 0x33001010, 0x80000000, 0x40000000,
    0xa0000000, 0x50000000, 0x88000000, 0x24000000, 0x12000000, 0x2d000000,
    0x76800000, 0x9e400000, 0x08200000, 0x64100000, 0xb2280000, 0x7d140000,
    0xfea20000, 0xba490000, 0x1a248000, 0x491b4000, 0xc4b5a000, 0xe3739000,
    0xf6800800, 0xde400400, 0xa8200a00, 0x34100500, 0x3a280880, 0x59140240,
    0xeca20120, 0x974902d0, 0x6ca48768, 0xd75b49e4, 0xcc95a082, 0x87639641,
    0x44a80322, 0xa35403d1, 0x568205ea, 0x8e590ea4, 0x200c8922, 0x100f46d1,
    0x2817ad6b, 0x743a9ce7, 0x9a248000, 0x091b4000, 0x64b5a000, 0xb3739000,
    0x7e800800, 0xfa400400, 0xba200a00, 0x19100500, 0x4ca80880, 0xc7540240,
    0xe4820120, 0xf35902d0, 0x80000000, 0x40000000, 0xa0000000, 0x50000000,
    0x28000000, 0xd4000000, 0x6a000000, 0x71000000, 0x38800000, 0x58400000,
    0xea200000, 0x31100000, 0x98a80000, 0x08540000, 0xc22a0000, 0xe5250000,
    0xf2b28000, 0x79484000, 0xfaa42000, 0xbd731000, 0x18a80800, 0x48540400,
    0x622a0a00, 0xb5250500, 0xdab28280, 0xad484d40, 0x90a426a0, 0xcc731710,
    0x20280b88, 0x10140184, 0x880a04a2, 0x84350611, 0x421a8b0a, 0xa51c4dc5,
    0x528e2a82, 0x29561942, 0xd29a84a3, 0x695c4610, 0x72ae2b08, 0x39461dc6,
    0x5ab28280, 0xed484d40, 0x30a426a0, 0x9c731710, 0x08280b88, 0xc4140184,
    0xe20a04a2, 0xf5350611, 0x7a9a8b0a, 0xfd5c4dc5, 0xb8ae2a82, 0x18461942,
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x98000000, 0x94000000,
    0x8a000000, 0x5b000000, 0x33800000, 0xd9c00000, 0x72200000, 0x3f100000,
    0xc1b80000, 0xa6ec0000, 0x53860000, 0x29f50000, 0x0a3a8000, 0x1b2ac000,
    0xd392e000, 0x69ff7000, 0xea380800, 0xab2c0400, 0x4ba60e00, 0xfde50b00,
    0x60028980, 0xf006c940, 0x7834e8a0, 0x241a75b0, 0x123a8b38, 0xcf2ac99c,
    0xb992e922, 0x82ff78f1, 0x41b80d9b, 0xe6ec072e, 0xb3860398, 0x99f50c2f,
    0x923a8a1b, 0x8f2ac56e, 0x5992e2bb, 0x32ff70de, 0xd9b80980, 0x72ec0940,
    0x398608a0, 0xc2f505b0, 0xa1ba8338, 0x56eacd9c, 0x2bb2e722, 0x0def73f1,
    0x1800041b, 0xd4000e6e, 0x6a000b38, 0xeb00099f, 0x80000000, 0x40000000,
    0xa0000000, 0x10000000, 0x08000000, 0x6c000000, 0x9e000000, 0x23000000,
    0x57800000, 0xadc00000, 0x7fa00000, 0x91d00000, 0x49880000, 0xced40000,
    0x880a0000, 0x2c0f0000, 0x3e0d8000, 0x3317c000, 0x5fb06000, 0xc1f8b000,
    0xe18d8800, 0xb2d7c400, 0x1e106a00, 0x6328b100, 0xf7858880, 0xbdc3c2c0,
    0x77ba63e0, 0xfdf7b330, 0xd7800df8, 0xedc0081c, 0xdfa0041a, 0x81d00a2d,
    0x41880160, 0xa2d400f1, 0x160a069a, 0x0f0f09ed, 0x698d8200, 0x9ed7c500,
    0x20106a81, 0x5028b7c2, 0xa8058160, 0x7c03c0f1, 0x961a669a, 0x4f27b9ed,
    0xc9880a00, 0x8ed40100, 0x280a0081, 0x3c0f06c2, 0x360d89e0, 0x5f17c231,
    0xc1b0657a, 0xe2f8badd, 0x80000000, 0x40000000, 0x20000000, 0x30000000,
    0x58000000, 0xac000000, 0x96000000, 0x2b000000, 0xd4800000, 0x09400000,
    0xe2a00000, 0x52500000, 0x4e280000, 0xc71c0000, 0x629e0000, 0x12670000,
    0x6e138000, 0xf731c000, 0x3a98a000, 0xbe449000, 0xf83b8800, 0xdc2dc400,
    0xee06a200, 0xb7239300, 0x1aa80d80, 0x8e5c0ec0, 0xa03e0b60, 0x703701b0,
    0x783b88c8, 0x9c2dca54, 0xce06a74a, 0x87239795, 0x42a801aa, 0x225c08e5,
    0x363e0a03, 0x5b370703, 0xacbb8783, 0x956dc9c2, 0x2ca6ace0, 0xd5739872,
    0x0c800c2a, 0xe5400625, 0x54a00163, 0x495006b3, 0xc2a80f4b, 0x625c0396,
    0x163e0baa, 0x6b370fe7, 0xf4bb8d80, 0x396dcec0, 0xbaa6ab60, 0xfe7391b0,
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xf8000000, 0x8c000000,
    0xe2000000, 0x33000000, 0x0f800000, 0x21400000, 0x95a00000, 0x5e700000,
    0xd8080000, 0x1c240000, 0xba160000, 0xef370000, 0x15868000, 0x9e6fc000,
    0x781b6000, 0x4c349000, 0x420e8800, 0x630bcc00, 0xf7ad6a00, 0xad739500,
    0x77800780, 0x6d4004c0, 0xd7a00420, 0x3d700630, 0x2f880f78, 0xb1640ad4,
    0xcdb6077a, 0x824706d7, 0xc20e8d78, 0xa30bc3d6, 0x57ad62fb, 0xfd739b14,
    0x8f8004d8, 0xe1400424, 0x35a00620, 0x0e700f30, 0x20080af8, 0x90240716,
    0x581606db, 0xdc370d24, 0x1a0683a0, 0xbf2fc2f0, 0xedbb6b5a, 0x12449ce7,
    0x9a068000, 0x7f2fc000, 0x4dbb6000, 0x42449000, 0x80000000, 0xc0000000,
    0x60000000, 0x90000000, 0x38000000, 0xc4000000, 0x42000000, 0xa3000000,
    0xf1800000, 0xaa400000, 0xfce00000, 0x85100000, 0xe0080000, 0x500c0000,
    0x58060000, 0x54090000, 0x7a038000, 0x670c4000, 0xb3842000, 0x094a3000,
    0x0d6f1800, 0x2f5aa400, 0x1ce7ce00, 0xd5145100, 0xb8000080, 0x040000c0,
    0x22000060, 0x33000090, 0xc9800038, 0x6e4000c4, 0xbee00042, 0x261000a3,
    0x118800f1, 0xfa4c00aa, 0xa4e600fc, 0xd1190085, 0x9a0b80e0, 0x37004050,
    0xeb822058, 0x5d433054, 0x776c987a, 0x4856e467, 0xaf63eeb3, 0xdc5e6109,
    0xb56f188d, 0x2b5aa4ef, 0x3ee7ce7c, 0xe6145145, 0x71800000, 0x6a400000,
    0x9ce00000, 0x15100000, 0x80000000, 0x40000000, 0x20000000, 0xf0000000,
    0xa8000000, 0x54000000, 0x9a000000, 0x9d000000, 0x1e800000, 0x5cc00000,
    0x7d200000, 0x8d100000, 0x24880000, 0x71c40000, 0xeba20000, 0x75df0000,
    0x6ba28000, 0x35d14000, 0x4ba3a000, 0xc5d2d000, 0xe3a16800, 0x91db8c00,
    0x79aef200, 0x0cdf4100, 0x672a8080, 0x50154040, 0x1a01a020, 0xdd0dd0f0,
    0x3e83e8a8, 0xaccacc54, 0xd52d529a, 0xd91d919d, 0xbe83e89e, 0xeccacc1c,
    0xf52d525d, 0x291d917d, 0x1683e80c, 0xb8cacc65, 0x6f2d5251, 0xb41d9118,
    0x0803e85d, 0xe40acc7d, 0x120d528c, 0x390d9125, 0x2c8be8f1, 0x95cecca8,
    0xf9af5255, 0x4cd29199, 0x4729681e, 0xa01f8c5c, 0xb20cf27d, 0x8900418d,
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xd8000000, 0xc4000000,
    0x46000000, 0x85000000, 0xa5800000, 0x76c00000, 0xada00000, 0x6ab00000,
    0x2da80000, 0xaabc0000, 0x0daa0000, 0x7ab10000, 0xd5a78000, 0xbebd4000,
    0x93a3e000, 0x3bb51000, 0x3629b800, 0x4d727c00, 0x9b836200, 0x27c4d700,
    0xb629b880, 0x8d727cc0, 0xbb836220, 0xf7c4d7d0, 0x6e29b858, 0x49727c04,
    0xfd836266, 0x72c4d755, 0xcba9b8fd, 0x3fb27c72, 0x502362cb, 0x1874d73f,
    0xe601b8d0, 0x950e7cd8, 0x5d8962c6, 0x62c5d745, 0x33a63805, 0x2bb33c66,
    0xce2a8255, 0x5970c77e, 0x058f8033, 0x66c1402b, 0x55a9e0ce, 0x7eb41059,
    0xb3a63805, 0xebb33c66, 0xee2a8255, 0x8970c77e, 0x80000000, 0x40000000,
    0x20000000, 0xf0000000, 0x38000000, 0x14000000, 0xf6000000, 0x67000000,
    0x8f800000, 0x50400000, 0x8aa00000, 0x0ff00000, 0x12a80000, 0xabf40000,
    0xfcaa0000, 0x28fb0000, 0xbd298000, 0x0bba4000, 0x4e06e000, 0x330c3000,
    0x59861800, 0xc74d3400, 0x3d2cb200, 0x4bb2cb00, 0x6e061880, 0xc30d3440,
    0x618cb220, 0xd342cbf0, 0xcb2e18b8, 0x2cb93454, 0xe186b2d6, 0x9349cb97,
    0xeb2f9837, 0xdcb77404, 0xd98a525c, 0x874efb98, 0x1d280025, 0xbbb400af,
    0x560a00a0, 0xd70b00b0, 0x97818018, 0xb44e40e4, 0x44ace0ce, 0x7cf73073,
    0x6b2f9879, 0x9cb77437, 0xf98a5205, 0x774efb5f, 0x25280018, 0xafb400e4,
    0xa00a00ce, 0xb00b0073, 0x80000000, 0xc0000000, 0x20000000, 0xf0000000,
    0x68000000, 0x64000000, 0x36000000, 0x6d000000, 0x41800000, 0xe0400000,
    0xd2e00000, 0x9bf00000, 0x0ce80000, 0x52fc0000, 0x5b6a0000, 0x2fb30000,
    0xa00c8000, 0x30054000, 0x4807e000, 0x940f9000, 0x5e01f800, 0x090e9400,
    0x778a5600, 0x8d416b00, 0x9369f880, 0x7bb294c0, 0xde005620, 0xc9026bf0,
    0x578d78e8, 0x7d4bd4a4, 0xfb6db616, 0x1fbefb9d, 0xe80000a9, 0xa4000044,
    0x160000c4, 0x9d000006, 0x29800025, 0x844000d6, 0xe4e000bf, 0xf6f000d9,
    0x4d6800ed, 0xb2bc0082, 0x898a00c1, 0xb4430020, 0xace480f2, 0x62f9406b,
    0x136de064, 0xbbbc9036, 0xfe0d786d, 0x390bd442, 0x3f8db6e1, 0x194efbd0,
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x98000000, 0xf4000000,
    0xae000000, 0xbb000000, 0xe7800000, 0x95c00000, 0x1c200000, 0xd0300000,
    0xdba80000, 0x55f40000, 0xff820000, 0x21c10000, 0x12238000, 0x3b3a4000,
    0xa42b6000, 0x3430f000, 0x4da69800, 0x4af3ec00, 0x2e043a00, 0xfb0a1f00,
    0x47851880, 0xc5c9ac40, 0x842f5aa0, 0x243aef50, 0x75a38018, 0xeefa40b4,
    0x180b600e, 0xb400f0eb, 0x0e0e987f, 0xeb07ec61, 0x7f863ab2, 0x61cb1f6b,
    0xb22698bc, 0x6b33ec80, 0x3c243a43, 0xc03a1fa1, 0xe3ad18d1, 0xf1fdacda,
    0xc98d5a55, 0x6ecbeffe, 0x5ba800a0, 0x15f40050, 0x5f820098, 0x71c100f4,
    0x8a2380ae, 0xcf3a40bb, 0x0a2b60e7, 0x8f30f095, 0x80000000, 0xc0000000,
    0xe0000000, 0xb0000000, 0xb8000000, 0x3c000000, 0xce000000, 0x41000000,
    0x21800000, 0x51c00000, 0x09600000, 0x85700000, 0xf2780000, 0x8e9c0000,
    0x60020000, 0x70030000, 0x58038000, 0x8c02c000, 0x7602e000, 0x7d00f000,
    0xef833800, 0x10c10400, 0x28e08600, 0xd4b14700, 0xfb182580, 0x0bee15c0,
    0x9279c9e0, 0xfe9d3a70, 0x38000008, 0xfc00000c, 0x2e00000e, 0xf100000b,
    0x9980000b, 0x6dc00003, 0xc760000c, 0xc4700004, 0xd3f80002, 0xdf5c0005,
    0x69620000, 0xf5730008, 0xaa7b800f, 0x029ec008, 0x1600e006, 0x0d03f007,
    0xb780b805, 0x9cc3c408, 0x5ee26607, 0xa9b1b707, 0x149b1d8e, 0x1b2f11c1,
    0xba994fe2, 0x2a2c7d7d, 0x80000000, 0xc0000000, 0xe0000000, 0xd0000000,
    0x68000000, 0x3c000000, 0x8a000000, 0x51000000, 0xa9800000, 0xddc00000,
    0x5ba00000, 0x39d00000, 0x95f80000, 0x56d40000, 0x0a020000, 0x91030000,
    0x49838000, 0x0dc34000, 0x33a1a000, 0x05d0f000, 0x1ffa2800, 0x07d54400,
    0xa380a600, 0x4cc07700, 0x1222ee80, 0x3413a740, 0xa65bf7e0, 0x5305ab50,
    0x15f80008, 0x96d4000c, 0xea02000e, 0x4103000d, 0x21838006, 0x31c34003,
    0xb9a1a008, 0x54d0f005, 0xb67a280a, 0xda15440d, 0xf820a605, 0x75107703,
    0x87daee89, 0x62c7a745, 0xac59f7e0, 0xc206ab59, 0x5c7b800c, 0x9b17400c,
    0xd9a3a00d, 0x44d3f00d, 0x3e79a807, 0x36160403, 0x1a210602, 0x18108701,
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x38000000, 0x8c000000,
    0x7e000000, 0x71000000, 0xc8800000, 0x04c00000, 0x1ba00000, 0xbb700000,
    0x4a980000, 0xc3bc0000, 0xa6020000, 0x6d010000, 0xee818000, 0x29c34000,
    0x9520e000, 0x42b23000, 0xe7b9f800, 0x0d0dc400, 0x3fb92200, 0x110d1300,
    0x19bbee80, 0x3c0cadc0, 0x973a4a60, 0xc5cf7ef0, 0x3a180008, 0x0b7c0004,
    0xa3a20006, 0x7771000d, 0x54998003, 0x62bf4008, 0x5682e007, 0xe5c33007,
    0x8b20780c, 0xe3b28400, 0x173bc201, 0x85ce230b, 0x5a1b9684, 0xdb7e29cc,
    0x9ba1886a, 0xfb715df6, 0x2a9b9686, 0x13be29c6, 0x9e01886f, 0xe1015df9,
    0x90839685, 0x58c229cc, 0x5da38862, 0x46705dfb, 0x80000000, 0xc0000000,
    0xa0000000, 0x90000000, 0x08000000, 0x64000000, 0x6a000000, 0x89000000,
    0xa5800000, 0xcb400000, 0x18200000, 0xad900000, 0xaf880000, 0x72f40000,
    0x25820000, 0x0b430000, 0xb8228000, 0x3d924000, 0xa7882000, 0x16f59000,
    0x4f83a800, 0x82412400, 0x1da01600, 0xf6d16d00, 0xbfa84080, 0xbb672640,
    0xe0091620, 0xf0b4efd0, 0x38228008, 0xfd92400c, 0x0788200a, 0x86f59009,
    0x4783a800, 0xe6412406, 0x77a01606, 0x7fd16d08, 0x1a28408a, 0x7027264c,
    0xf8291621, 0x5d24efda, 0x97aa8002, 0x8f66400b, 0x220a2008, 0x8db69009,
    0xffa1280b, 0xdbd36405, 0xd028360c, 0x6924fd09, 0x55abe88e, 0xf2660244,
    0xe5890020, 0xabf582d5, 0x80000000, 0xc0000000, 0x20000000, 0xd0000000,
    0x48000000, 0x8c000000, 0xd6000000, 0x39000000, 0xd5800000, 0x32400000,
    0xb2a00000, 0x72100000, 0x53d80000, 0x82cc0000, 0xcb820000, 0x47430000,
    0x91208000, 0xa9534000, 0x7cf92000, 0x4e9e3000, 0xfcf95800, 0x8e9fe400,
    0xdcf9d600, 0x5e9c8900, 0x94f96a80, 0xd29fb840, 0x42f9b760, 0xeb9c9f30,
    0x97788008, 0xd9df400c, 0x25db2002, 0xabcd300d, 0x7601d804, 0x2900a408,
    0xbd82f60d, 0x6e41b903, 0x2ca0b28d, 0xc7131c43, 0x5059416b, 0x898e2637,
    0xaca0b28d, 0x07131c44, 0x7059416e, 0x598e2639, 0xe4a0b285, 0x8b131c4e,
    0xa6594168, 0x608e263a, 0x3120b28e, 0xb9531c4f, 0x14f94169, 0x129e263c,
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xd8000000, 0xf4000000,
    0x3e000000, 0x95000000, 0x8f800000, 0x3d400000, 0xf3200000, 0x2ef00000,
    0xadc80000, 0x0a0c0000, 0x8b220000, 0x4af30000, 0x6bc88000, 0x3b0d4000,
    0xe2a16000, 0x16b0d000, 0x29687800, 0xbdbf1400, 0x33cb5e00, 0x0f0c2500,
    0xfca1b480, 0xd3b0afc0, 0x7eeb6920, 0x74fe4d30, 0xfee87808, 0xb4ff140c,
    0xdeeb5e02, 0xe4fc2505, 0x06e9b48d, 0x10fcafcf, 0x38e96923, 0x85fd4d39,
    0xb768f800, 0xb8be540f, 0x44483e0d, 0x964ff507, 0xe9814c87, 0x9c42fbcf,
    0x62a1572b, 0xd6b2b83d, 0x0969b486, 0xedbcafcc, 0xebc96923, 0xfb0d4d36,
    0xc2a0f80d, 0x46b25408, 0xf16a3e0a, 0x49bcf508, 0x80000000, 0x40000000,
    0xa0000000, 0xb0000000, 0x98000000, 0xa4000000, 0x7a000000, 0xd5000000,
    0x02800000, 0x60400000, 0x51e00000, 0x88700000, 0x8c280000, 0x47c40000,
    0x0be20000, 0xad710000, 0xb6aa8000, 0x3386c000, 0xb8006000, 0x54039000,
    0x42036800, 0xc1019400, 0xe0826a00, 0x11431100, 0x2960af80, 0x3d3175c0,
    0xdf4a3aa0, 0xaff49e10, 0xd62b6808, 0x62c59404, 0x31606a0a, 0xd932110b,
    0x054a2f89, 0xcaf7b5ca, 0x4caa5aa7, 0xa6870e1d, 0x1a800008, 0x84400002,
    0x8be0000f, 0xed700003, 0x16a80001, 0x8384000e, 0x20020007, 0xf0010007,
    0x3802800b, 0x1402c005, 0xe202600e, 0x7102900d, 0x7881e80c, 0xb5435408,
    0x53600a0e, 0xe831810b, 0x80000000, 0xc0000000, 0xa0000000, 0x30000000,
    0x18000000, 0x34000000, 0x8a000000, 0x9d000000, 0x67800000, 0x82400000,
    0x40e00000, 0x60f00000, 0x91480000, 0x29440000, 0x2d620000, 0xbfb30000,
    0x162a8000, 0xfbf4c000, 0xe4ca6000, 0xc207d000, 0x2002a800, 0xf001b400,
    0xb8037e00, 0x04021900, 0x92034b80, 0xa90327c0, 0xed81f320, 0x1f40d810,
    0x27602808, 0xe2b1740c, 0xd1ab1e0a, 0x49b6c903, 0xbc2b6381, 0x96f653c3,
    0x3b48ed28, 0x44451119, 0xf2e1cb8e, 0x39f3e7c4, 0xc4c9932e, 0x32040815,
    0x98000000, 0xf400000d, 0x2a000000, 0xad000001, 0x7f800006, 0xb6400004,
    0xcae00002, 0xfdf00003, 0xf6c8000d, 0xab040005, 0x6d82000d, 0xdf43000d,
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x08000000, 0x4c000000,
    0x02000000, 0xb5000000, 0x36800000, 0xc2c00000, 0x14200000, 0x07500000,
    0x1bf80000, 0x50340000, 0x48a20000, 0xac910000, 0xd35b8000, 0xbca74000,
    0x7bfa2000, 0xc0343000, 0xa0a18800, 0x30909400, 0xd95b7a00, 0x45a57b00,
    0x4f7a7880, 0xb7f6f940, 0x82013de0, 0xf502dfd0, 0xd6820808, 0x12c3d404,
    0x1c235a0e, 0x4b504b0d, 0x19f87080, 0xe5352d44, 0x7e2267e0, 0x6e5294db,
    0xc77a788b, 0xbbf6f948, 0x60013def, 0x9002dfdd, 0xe8020809, 0x9c03d405,
    0x0a035a0a, 0xf9004b0c, 0x3480708e, 0x77c12d43, 0x22a067e6, 0xc59394d7,
    0x0fd9f880, 0x5765b94e, 0x53591de6, 0xfca7efd3, 0x80000000, 0xc0000000,
    0xe0000000, 0x50000000, 0x68000000, 0x4c000000, 0x76000000, 0xf7000000,
    0x36800000, 0xd7400000, 0x87e00000, 0xef300000, 0xa3a80000, 0xd5440000,
    0x23aa0000, 0x15470000, 0xc3a98000, 0x45464000, 0xaba82000, 0x09477000,
    0xdda9f800, 0xfe44ac00, 0xeb292200, 0x2907f100, 0x6ccb3d80, 0xc6344dc0,
    0xcf61b320, 0x137318d0, 0xeccb3d88, 0x06344dcc, 0x2f61b32e, 0x437318d5,
    0x84cb3d8e, 0x4a344dc8, 0x5961b329, 0xb47318da, 0xb24b3d8d, 0x9d744dc5,
    0xde81b321, 0x5b4318d4, 0x11e33d87, 0x48304dc8, 0xfd2bb323, 0x4e0418d5,
    0xd24abd8b, 0x0d760dcc, 0x56839329, 0x474368d5, 0x0fe34586, 0xf332a1c3,
    0xbdaab127, 0x6e4499d7, 0x80000000, 0x40000000, 0x60000000, 0x90000000,
    0xc8000000, 0x74000000, 0x52000000, 0x03000000, 0xeb800000, 0x6f400000,
    0x64600000, 0xdaf00000, 0x17980000, 0x297c0000, 0xa59a0000, 0xfa7d0000,
    0xe61b8000, 0x713f4000, 0x1878a000, 0xdcce9000, 0xb661e800, 0x99f29c00,
    0x9c184600, 0xd63e2100, 0x09fa5780, 0x548e0ac0, 0xa380a9e0, 0x5b413f30,
    0x56625788, 0x49f20ac4, 0x341aa9e6, 0x323c3f39, 0x93f9d784, 0x238d4ac3,
    0x1a0209e3, 0x3702af39, 0xd9803f8a, 0xfc43d6c5, 0x47e04fe5, 0xc1b18e34,
    0x21f9e80b, 0xf08e9c07, 0x5982460f, 0xbc43210b, 0x27e1d78d, 0x51b14ac4,
    0xe9f809e8, 0x848faf3f, 0x0b83bf82, 0xbf4096ce, 0xcc62efe2, 0x3ef21e3b,
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0xb8000000, 0x04000000,
    0x6e000000, 0x97000000, 0xf2800000, 0xedc00000, 0x13600000, 0x5c900000,
    0xdb580000, 0x31e40000, 0x09da0000, 0xcc270000, 0x02b88000, 0x44b44000,
    0x0fe26000, 0xe6505000, 0x9ab9d800, 0x50b50c00, 0x79e29200, 0xa552fb00,
    0xbe38bf80, 0x2e77d940, 0xf6000ae0, 0x830112d0, 0x84803f88, 0xaec3994c,
    0x37e26aea, 0x225142dd, 0x54b9e783, 0x17b6954c, 0x3360f8ec, 0x4c93b9d4,
    0xc359580c, 0xe5e54c02, 0xdfdaf20d, 0x5f25ab01, 0x9e39e789, 0x3e76954d,
    0xee00f8e7, 0x5703b9d0, 0x5281580a, 0x3dc14c05, 0xab60f20b, 0x5892ab0a,
    0xb559678f, 0xa6e6d542, 0xfb5898e1, 0x21e4e9d1, 0x80000000, 0xc0000000,
    0xe0000000, 0x30000000, 0x68000000, 0xec000000, 0x22000000, 0x2b000000,
    0x36800000, 0x9d400000, 0x6a200000, 0x16700000, 0x4de80000, 0x330c0000,
    0x936a0000, 0x824f0000, 0x3b498000, 0x8f3fc000, 0x28202000, 0xcd707000,
    0xf36aa800, 0x724fdc00, 0xb34bf200, 0x533e6900, 0x62207a80, 0x0a7140c0,
    0xe7ea6520, 0xc40d90f0, 0xefe9fa88, 0xd80e80cc, 0x45ea452e, 0x2f0de0f3,
    0x396b528e, 0x754d5cc2, 0x47cbb72c, 0xd57c89f1, 0x5682a80d, 0x6d43dc0b,
    0xe221f20a, 0xca716900, 0x07e9fa81, 0xf40e80c4, 0x87ea452d, 0x340de0fb,
    0x67eb528c, 0x040d5cce, 0x0febb723, 0xe80c89f6, 0x2deaa806, 0xc30fdc0e,
    0x1b6bf20c, 0x5e4e6900, 0x80000000, 0xc0000000, 0x20000000, 0x30000000,
    0x28000000, 0xd4000000, 0x8a000000, 0xff000000, 0x84800000, 0x73c00000,
    0x13200000, 0xc2b00000, 0xfb380000, 0x361c0000, 0x401a0000, 0xe0af0000,
    0x11228000, 0x19b3c000, 0xfdb82000, 0x5edf9000, 0x75b88800, 0x7adfac00,
    0xf7baba00, 0x61ddf300, 0xd1387e80, 0x391e55c0, 0xcc9ba860, 0x776cbeb0,
    0xa000f688, 0xf001f9cc, 0x08011262, 0xe4014db3, 0xa200880a, 0x2b03ac01,
    0x0e80ba0a, 0x8cc2f30c, 0x97a2fe8a, 0xb17195ca, 0xe8198869, 0xf4ac2eb3,
    0xbb22fe8f, 0xd6b195c8, 0x51398867, 0xf91c2eb1, 0xec9afe84, 0x476d95c3,
    0x88038861, 0x24032eb7, 0x82007e84, 0x1b0255c0, 0x2681a86b, 0x58c3beb3,
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xb8000000, 0x84000000,
    0x1a000000, 0xaf000000, 0xbd800000, 0xdfc00000, 0x14e00000, 0x43500000,
    0xda380000, 0x4e1c0000, 0x4cda0000, 0x364d0000, 0x29608000, 0xdc904000,
    0x6ed86000, 0x5d4f5000, 0x2ee08800, 0xfc51ac00, 0x7fb81e00, 0x45dc8300,
    0xfa3a4580, 0x5e1d6240, 0x54dbd360, 0xe24ec930, 0x8b62cd88, 0xf790ce44,
    0xc959cd6a, 0x2d8f4a35, 0x87800803, 0x60c1ec0c, 0xb1607e0b, 0x4893d30f,
    0x6cdacd80, 0x264cce45, 0x3163cd60, 0x08924a3e, 0xccd8880e, 0x764dac0d,
    0x89621e0f, 0x8c918302, 0xd6dac584, 0xd94d2241, 0x34e3b363, 0x5351993c,
    0xc23a4583, 0x9a1d624b, 0xeedbd36a, 0x1d4ec930, 0x80000000, 0x40000000,
    0xe0000000, 0x70000000, 0x08000000, 0xf4000000, 0xf6000000, 0x8b000000,
    0xc9800000, 0x55400000, 0x67200000, 0xf3f00000, 0x34780000, 0x57440000,
    0x1ada0000, 0xb1f50000, 0xa9818000, 0x6540c000, 0x8f23a000, 0x77f21000,
    0xca7bf800, 0x2845fc00, 0x255afe00, 0x6fb67900, 0x07233a80, 0xc3f25ac0,
    0xdc7aed60, 0xd34482d0, 0xe4d94288, 0xcef766c4, 0x9603b36e, 0xbb00ebd7,
    0x21818008, 0xd140c00b, 0x9923a001, 0x8cf2100f, 0x0bfbf80c, 0x8905fc0a,
    0xb47afe09, 0x17467907, 0xfadb3a8f, 0xc1f65ac0, 0xa180ed67, 0x914182d4,
    0x7920c281, 0xfcf3a6c7, 0x03fa1367, 0x7d07fbdb, 0x427bf80e, 0x9c45fc0f,
    0x335afe0b, 0x94b6790e, 0x80000000, 0x40000000, 0xe0000000, 0x90000000,
    0x68000000, 0xf4000000, 0x62000000, 0xdf000000, 0x79800000, 0xdd400000,
    0x76e00000, 0x2cf00000, 0xcfb80000, 0x51ec0000, 0xc8da0000, 0x845d0000,
    0x9b818000, 0x42434000, 0xef622000, 0x61b19000, 0xd1582800, 0x891cac00,
    0x65626e00, 0x0ab10900, 0x2adbbd80, 0x1b5d86c0, 0x02014560, 0x0f032470,
    0xf1821588, 0xb9426ac4, 0x7ce10b6e, 0x07f3bd79, 0xd439800e, 0x53af400b,
    0xc7b82008, 0x75ec9004, 0x22d9a801, 0x3f5fec02, 0xe8004e01, 0xb400990f,
    0x8203958b, 0x4f012ac8, 0x11832b6b, 0x29422d7a, 0x14e1a80d, 0xf3f3ec05,
    0xb63a4e0c, 0x8cad9907, 0xbe3a1582, 0xa8ae6ac3, 0x543b0b6e, 0x13aebd7b,
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x18000000, 0xdc000000,
    0x42000000, 0x37000000, 0x20800000, 0xf1400000, 0x28600000, 0x94900000,
    0x87880000, 0xa83c0000, 0x556a0000, 0xe6ef0000, 0xf8038000, 0x4c024000,
    0x3a01e000, 0xbb023000, 0x7a816800, 0x1a43ac00, 0x4ae18a00, 0x52d31900,
    0x8f682380, 0xcded9740, 0xfa80bfa0, 0xda43f2b0, 0x2ae2cb88, 0x02d07b4c,
    0x976ad5a6, 0x11eddbb5, 0xb8800009, 0xed400001, 0x0a600002, 0xf3900006,
    0xbf080003, 0x857c0002, 0x3f0a0006, 0x457f000a, 0x5f0b800a, 0x157e4005,
    0x470be007, 0xc97d3007, 0x050ae807, 0xfe7dec0e, 0x258a6a06, 0x0f3e2905,
    0x0deacb88, 0x9bac7b45, 0x8a60d5a7, 0x3392dbbe, 0x80000000, 0xc0000000,
    0x20000000, 0xf0000000, 0xf8000000, 0x34000000, 0x62000000, 0xf5000000,
    0xa8800000, 0xfcc00000, 0x8e200000, 0x53f00000, 0xc7780000, 0x95740000,
    0xb8020000, 0xd4e50000, 0xb2808000, 0xfdc0c000, 0x64a02000, 0xaa30f000,
    0x19d8f800, 0x0e443400, 0x935a6200, 0xe761f500, 0x657a2880, 0x40913cc0,
    0xe0022e20, 0xd0e563f0, 0x08809f78, 0xccc09174, 0x56200202, 0x97f0e5e5,
    0x5d788000, 0x5474c000, 0x72822000, 0xdd25f000, 0x94207800, 0x52f0f400,
    0x2df84200, 0x6cb40500, 0x66a25080, 0x4fd5c8c0, 0x99d86c20, 0xce4466f0,
    0xb35a4ff8, 0x176199b4, 0x9d7a4e22, 0x74917315, 0x8202b7f8, 0x25e5adb4,
    0xa0002c22, 0x30008615, 0x80000000, 0xc0000000, 0xa0000000, 0xf0000000,
    0xf8000000, 0xec000000, 0x7e000000, 0x61000000, 0x5c800000, 0xe6c00000,
    0xdda00000, 0x2a700000, 0x93380000, 0x13cc0000, 0xd3ce0000, 0x73790000,
    0x83a08000, 0x7b70c000, 0x97b8a000, 0xe90cf000, 0x886ef800, 0xd409ec00,
    0x3218fe00, 0xef7ca100, 0xc556fc80, 0x56c516c0, 0x4556a5a0, 0x96c50670,
    0xe556cd38, 0x66c542cc, 0x1d56574e, 0x8ac549b9, 0x6356f800, 0xebc5ec00,
    0x3fd6fe00, 0x0d05a100, 0xe2767c80, 0x2775d6c0, 0x714e05a0, 0x34b9f670,
    0xa2803538, 0x47c0aecc, 0x2120a94e, 0x3cb0e8b9, 0xb6988480, 0xd5bc3ac0,
    0x3ef6fba0, 0x01b55770, 0x0ceec9b8, 0xeec9b80c, 0xc9b80cee, 0xb80ceec9,
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x58000000, 0x2c000000,
    0x9a000000, 0xf9000000, 0x3c800000, 0xb2c00000, 0xad200000, 0x3a300000,
    0x89980000, 0x448c0000, 0x2eea0000, 0x6f810000, 0xef208000, 0x2f30c000,
    0x0f182000, 0xbf4cb000, 0xe74a5800, 0xcb712c00, 0x51981a00, 0xa88c3900,
    0x94ea1c80, 0x268102c0, 0x8ba07520, 0xb1f0d630, 0x38383398, 0x7c7c0d8c,
    0x52524a6a, 0x3d3df141, 0xd2525800, 0xfd3d2c00, 0xf2521a00, 0x4d3d3900,
    0xaa529c80, 0x613dc2c0, 0x30525520, 0x983d6630, 0x0cd2eb98, 0x2afde18c,
    0xa1f2706a, 0x10cd7841, 0x286a1c80, 0x544102c0, 0x06807520, 0x3bc0d630,
    0xe9a03398, 0x14f00d8c, 0xe6b84a6a, 0xabbcf141, 0x80000000, 0xc0000000,
    0x20000000, 0xb0000000, 0xd8000000, 0xac000000, 0x8e000000, 0x09000000,
    0x9e800000, 0xa1c00000, 0xcaa00000, 0x33700000, 0x95780000, 0x085c0000,
    0x24b60000, 0x6a350000, 0x43788000, 0x6d5cc000, 0x14362000, 0x72f5b000,
    0xcf585800, 0x53ec6c00, 0xc5eeae00, 0x40d9b900, 0xe016c680, 0x9045cdc0,
    0x6880e4a0, 0x74c04a70, 0x2220f3f8, 0x87b0b59c, 0x9758b816, 0x3fecfc45,
    0x6beec680, 0xf9d9cdc0, 0xa696e4a0, 0x9d854a70, 0x2c2073f8, 0x4eb0759c,
    0x29d89816, 0x2e2c4c45, 0x794e1e80, 0x66a961c0, 0xbdee6aa0, 0x9cd94370,
    0x9616ed78, 0x8545d45c, 0xa000d2b6, 0x7000bf35, 0xf800abf8, 0x1c00d99c,
    0x56001616, 0xa5004545, 0x80000000, 0x40000000, 0xe0000000, 0xf0000000,
    0xa8000000, 0x2c000000, 0xa2000000, 0x2d000000, 0xda800000, 0xf9400000,
    0xec600000, 0x02b00000, 0x3d480000, 0x825c0000, 0x7d4a0000, 0x62610000,
    0x8dc88000, 0xca1c4000, 0xa1aae000, 0x6891f000, 0x8c602800, 0xb2b06c00,
    0x75484200, 0x5e5cdd00, 0x774a7280, 0x6361d540, 0xf548ce60, 0x1e5c6fb0,
    0x974a07c8, 0x93618b1c, 0x5d48b92a, 0x325c0cd1, 0x354af280, 0xbe619540,
    0x87c82e60, 0xcb1c9fb0, 0xd92aafc8, 0xbcd1a71c, 0xba801b2a, 0x494021d1,
    0xa4602800, 0xdeb06c00, 0x37484200, 0x835cdd00, 0x05ca7280, 0xb621d540,
    0xbb28ce60, 0x31ec6fb0, 0x708207c8, 0xe87d8b1c, 0xcc62b92a, 0x528d0cd1,
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xc8000000, 0x7c000000,
    0x82000000, 0x4f000000, 0xbe800000, 0xedc00000, 0x21600000, 0xab700000,
    0x78680000, 0x746c0000, 0x1e9a0000, 0xfdcb0000, 0x39088000, 0x2f1cc000,
    0x4ef2e000, 0xc5a73000, 0x6d924800, 0xe1d7bc00, 0x4b7ae200, 0x487bbf00,
    0xbc801680, 0x62c061c0, 0x7fe08b60, 0x76b0a870, 0x91088ce8, 0xa31caaac,
    0xe4f2037a, 0xc6a7f47b, 0x99125e80, 0x3f17ddc0, 0x569a6960, 0x41cb1770,
    0x5b089a68, 0x501ccb6c, 0x3872881a, 0x54675c0b, 0xcef2d268, 0x05a7776c,
    0x8d926a1a, 0xd1d7e30b, 0x837a44e8, 0x347bd6ac, 0x3e80017a, 0x2dc07b7b,
    0xc1608000, 0x9b70c000, 0xb068e000, 0x086c3000, 0x80000000, 0xc0000000,
    0x20000000, 0x10000000, 0x98000000, 0x2c000000, 0x06000000, 0xcd000000,
    0x8a800000, 0x1bc00000, 0xffa00000, 0xad500000, 0x7af80000, 0xb3dc0000,
    0x5b2e0000, 0x1f290000, 0x9d588000, 0xf28cc000, 0x07d62000, 0x71f51000,
    0xd4f61800, 0xda65ec00, 0x632ea600, 0xe3291d00, 0x2358b280, 0x038ce7c0,
    0x135641a0, 0x8b355c50, 0xa7d6ee78, 0xa1f5891c, 0x6cf6880e, 0xe665b4b9,
    0xfd2eaa80, 0x02290bc0, 0xafd8e7a0, 0xd54c4150, 0x66765cf8, 0x3da56edc,
    0x228ec9ae, 0xbf79e8e9, 0x4d20c4f8, 0x4a9042dc, 0x3b584fae, 0xef8ce5e9,
    0x3556ee78, 0x5635891c, 0xb556880e, 0x9635b4b9, 0x9556aa80, 0x86350bc0,
    0x0d56e7a0, 0xaa354150, 0x80000000, 0x40000000, 0xa0000000, 0x90000000,
    0x98000000, 0x54000000, 0x3a000000, 0x9d000000, 0x7e800000, 0x7f400000,
    0x17200000, 0xab500000, 0x6df80000, 0x96a40000, 0x83d20000, 0x71e10000,
    0xc0d88000, 0xe0f44000, 0x30aaa000, 0x08059000, 0xcc2a1800, 0x6e451400,
    0xa78a1a00, 0xe3554d00, 0x01d2c680, 0x68e1fb40, 0xbc589520, 0xc6b4b250,
    0xfb0a1178, 0x1515b0e4, 0xf272c872, 0xb1f12cf1, 0x2000de80, 0xd000ef40,
    0x38008f20, 0xc400ff50, 0xa20057f8, 0xc9000ba4, 0x4480fd52, 0xe2400ea1,
    0x69a0d7f8, 0xd4104ba4, 0x7ad85d52, 0x3df49ea1, 0xee2a4ff8, 0xe7451fa4,
    0x430ae752, 0x911543a1, 0xf0721178, 0xe8f1b0e4, 0xfc80c872, 0x66402cf1,
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x08000000, 0x84000000,
    0xb2000000, 0xb9000000, 0xbe800000, 0x4fc00000, 0x55600000, 0xf8f00000,
    0xac280000, 0x66d40000, 0xb30a0000, 0x8bb50000, 0xc7c88000, 0x11e4c000,
    0xaa42e000, 0xa591b000, 0xd0ea8800, 0x78854400, 0x6c80d200, 0x86c0c900,
    0x03e05680, 0x83307bc0, 0x4348ef60, 0xa324c5f0, 0x13a2a0a8, 0x1ba19014,
    0x9f22d8ea, 0x2d61fc85, 0x94c25e80, 0x2a51ffc0, 0x658add60, 0x3075bcf0,
    0xc8a87e28, 0x6414afd4, 0x02eae58a, 0xb185f075, 0x3a00a8a8, 0xfd001414,
    0xec80eaea, 0x46c08585, 0xe3e08000, 0x3330c000, 0x4b48e000, 0x2724b000,
    0xa1a20800, 0xa2a18400, 0x21a23200, 0x62a17900, 0x80000000, 0xc0000000,
    0x60000000, 0x30000000, 0x78000000, 0x24000000, 0x9e000000, 0x47000000,
    0x67800000, 0xf7400000, 0xdf200000, 0xb3100000, 0x71680000, 0x8c4c0000,
    0x32520000, 0xe5d50000, 0xaa528000, 0x31d5c000, 0x2c52e000, 0x62d5f000,
    0xadd29800, 0xf695d400, 0x8b720600, 0xf5c59300, 0x42ba6180, 0x3dd96440,
    0xdea0bea0, 0xe750d750, 0x37c84fc8, 0xbf1c9b1c, 0x839a1d9a, 0x09c94ec9,
    0xa8484fc8, 0xac5c9b1c, 0xa2ba1d9a, 0xcdd94ec9, 0xc6a04fc8, 0xf3509b1c,
    0xd1c81d9a, 0xdc1c4ec9, 0x7a1acfc8, 0xb9895b1c, 0x10e8fd9a, 0xe80cbec9,
    0x0cf2d7c8, 0xf2854f1c, 0x859a1b9a, 0x9ac9ddc9, 0x49c8ae48, 0x081c3f5c,
    0xfc1a433a, 0xea896999, 0x80000000, 0xc0000000, 0xe0000000, 0xb0000000,
    0x78000000, 0x9c000000, 0xee000000, 0x1b000000, 0xcb800000, 0xc3400000,
    0xc7a00000, 0x05100000, 0x88680000, 0xc4740000, 0x225a0000, 0x3da10000,
    0x345a8000, 0x7aa1c000, 0xf1da6000, 0x12e17000, 0x85fa1800, 0x48b1ec00,
    0x2432f600, 0x92d5f700, 0x45803d80, 0xa8403440, 0x94207a20, 0xea50f150,
    0xd9c81248, 0x46648524, 0x8fb24812, 0x21952485, 0x1a201248, 0x81508524,
    0x8a484812, 0xa9242485, 0xde129248, 0xa3854524, 0xb7c82812, 0x9d645485,
    0xa4320a48, 0x52d56924, 0xa580be12, 0x1840d385, 0xec202fc8, 0x7650b164,
    0x37c83232, 0x5d64d5d5, 0x44328000, 0xe2d5c000, 0xdd806000, 0x84407000,
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x58000000, 0x7c000000,
    0xc2000000, 0xe1000000, 0x0d800000, 0xd7c00000, 0x2aa00000, 0xf5300000,
    0x9ba80000, 0xc0f40000, 0x20c60000, 0x702f0000, 0x48668000, 0x241f4000,
    0xbe4ee000, 0x232b5000, 0xec28b800, 0xda342c00, 0xfde6fa00, 0xdfdf8d00,
    0x6eee1780, 0x5b1b0ac0, 0xe0000520, 0x500093f0, 0x38008488, 0x6c008e04,
    0x9a000bce, 0x9d00d8eb, 0xcf803c88, 0x36c0a204, 0x2720f1ce, 0x22f055eb,
    0xb108ab08, 0x35c4e8c4, 0xbb6e14ee, 0xb0db961b, 0x68a09780, 0x54304ac0,
    0xf628e520, 0x0734c3f0, 0x5266bc88, 0xf91fe204, 0x11ce11ce, 0x05eb05eb,
    0x93081308, 0x84c4c4c4, 0x8eeeeeee, 0x0b1b1b1b, 0x80000000, 0x40000000,
    0x20000000, 0x30000000, 0xb8000000, 0xac000000, 0x72000000, 0xb1000000,
    0x03800000, 0xd2c00000, 0xc1600000, 0x9b900000, 0x4e480000, 0x0b740000,
    0x864e0000, 0x3f0b0000, 0x68068000, 0x447f4000, 0x7648a000, 0xe7747000,
    0xd44e9800, 0xbe0b9c00, 0xd3864a00, 0x3abf5d00, 0xc528d180, 0xcde413c0,
    0x99865ae0, 0x67bfd550, 0x94a8c528, 0x9e24cde4, 0xe3669986, 0x82ef67bf,
    0x698014a8, 0xbfc0de24, 0x28e0c366, 0x6450b2ef, 0x46a8d180, 0x5f2413c0,
    0x78e65ae0, 0xcc2fd550, 0x62e0c528, 0x3950cde4, 0x17289986, 0x0ce467bf,
    0x020694a8, 0x297f9e24, 0x9fc86366, 0x18b4c2ef, 0xdcae4980, 0xea5b8fc0,
    0x2d2e10e0, 0xc99b8850, 0x80000000, 0xc0000000, 0xe0000000, 0x70000000,
    0x88000000, 0x44000000, 0x4a000000, 0x47000000, 0xdd800000, 0x42400000,
    0xc3200000, 0x77100000, 0x75b80000, 0x966c0000, 0x715e0000, 0xfc950000,
    0xa6e68000, 0xd9f9c000, 0x28386000, 0x142cb000, 0x527e6800, 0xfb853400,
    0x5b5e4200, 0x0b95c300, 0x1366f780, 0xafb9b540, 0x2918f6a0, 0x603cc150,
    0xb0469498, 0x68a9927c, 0x34a09b66, 0xc250ebb9, 0x03186318, 0x973c273c,
    0x05c66dc6, 0x1ee92ae9, 0x35807780, 0xb6407540, 0xe12096a0, 0x04107150,
    0x6a38fc98, 0xd72ca67c, 0x25fed966, 0x8ec528b9, 0xcdfe9498, 0x7ac5927c,
    0xeffe9b66, 0x09c5ebb9, 0xf07ee318, 0x4885e73c, 0xa4de0dc6, 0x3ad59ae9,
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xd8000000, 0xfc000000,
    0xf6000000, 0xd5000000, 0xbf800000, 0x2c400000, 0xeee00000, 0x09700000,
    0x19080000, 0x21640000, 0xad6a0000, 0xd3130000, 0x22828000, 0x9707c000,
    0x98e0a000, 0x1c709000, 0x8688f800, 0x5d24ac00, 0x9b8a2e00, 0x26632900,
    0xcd8ac980, 0x63633940, 0x8a0af160, 0xe323b530, 0x4aea8fe8, 0xc3534414,
    0x1a623a62, 0x1b774b77, 0xe668be68, 0xed54d154, 0x3302e502, 0x5247d747,
    0x1f80f800, 0xbc40ac00, 0x16e02e00, 0xa5702900, 0x37084980, 0x0864f940,
    0xe4ea5160, 0x2a532530, 0x73e277e8, 0xb237e814, 0x6f081462, 0x34646277,
    0x32ea77e8, 0xaf53e814, 0x14621462, 0x62776277, 0x80000000, 0x40000000,
    0x60000000, 0x50000000, 0x58000000, 0xac000000, 0x6a000000, 0x85000000,
    0xfb800000, 0xa8c00000, 0x84200000, 0xae300000, 0x4b080000, 0xe0740000,
    0x10860000, 0x388f0000, 0xfc2e8000, 0x320b4000, 0x2980e000, 0x91c01000,
    0x2da03800, 0x7ff0fc00, 0x06a83200, 0xcf842900, 0x4e2e9180, 0x5b0b2dc0,
    0xd800ffa0, 0xec0046f0, 0x0a00af28, 0xd5001e44, 0xa380038e, 0x04c074fb,
    0xee2086a8, 0x2b308f84, 0xb0882e2e, 0x48b40b0b, 0x94a68000, 0x96bf4000,
    0xb726e000, 0xd27f1000, 0x3906b800, 0xa94fbc00, 0xd18ed200, 0x4dfb3900,
    0x2f282980, 0x5e4491c0, 0x638e2da0, 0x24fb7ff0, 0xdea886a8, 0x23848f84,
    0x442e2e2e, 0x8e0b0b0b, 0x80000000, 0xc0000000, 0xa0000000, 0x50000000,
    0xe8000000, 0x44000000, 0x5e000000, 0xad000000, 0xef800000, 0x68400000,
    0x84600000, 0xfe500000, 0xfd280000, 0x07f40000, 0x2c620000, 0xda4f0000,
    0x53068000, 0x12dfc000, 0x6f802000, 0xa8403000, 0x24602800, 0xae501400,
    0x15283a00, 0x43f41100, 0x72621780, 0x774f2b40, 0xbc86bbe0, 0x7a9fda10,
    0xebe00118, 0x56100f94, 0xd948174a, 0xa9a415fd, 0x394a3118, 0x99bb2793,
    0x21648341, 0x6590eff7, 0xd3068000, 0xd2dfc000, 0xcf802000, 0xf8403000,
    0xcc602800, 0xea501400, 0x4b283a00, 0xeef41100, 0x9de21780, 0x1f0f2b40,
    0x38e6bbe0, 0x84cfda10, 0x16c80118, 0x51e40f94, 0xf52a174a, 0x73eb15fd,
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x18000000, 0x04000000,
    0xda000000, 0x09000000, 0x22800000, 0xe8400000, 0xbc600000, 0x0e300000,
    0x7b580000, 0x378c0000, 0x14c20000, 0x874d0000, 0x99d48000, 0xbfb94000,
    0x18802000, 0x91403000, 0xe6e01800, 0x52702c00, 0x05380600, 0x34bc0100,
    0x971a3680, 0x51810240, 0x13f688a0, 0xde847a10, 0x466c8f18, 0x1745738c,
    0x91fa26d6, 0x73f111e3, 0x6ece9b30, 0x5e384cd3, 0x1376b6f5, 0x4bc45cae,
    0x7a8c8000, 0x4c354000, 0xb6422000, 0xaf0d3000, 0x45b49800, 0x01896c00,
    0x7bd82600, 0xa2cc3100, 0x28222e80, 0xdc3d2e40, 0xbe6c8ea0, 0x63457b10,
    0x33fa3998, 0xcef131cc, 0x8e4e8e76, 0xbb785bf3, 0x80000000, 0x40000000,
    0x20000000, 0x50000000, 0x88000000, 0x9c000000, 0x2e000000, 0x05000000,
    0xab800000, 0x1c400000, 0x6e200000, 0x25100000, 0xfba80000, 0x94040000,
    0xf26e0000, 0x0b070000, 0xfeaa8000, 0x3fd1c000, 0xee202000, 0x65101000,
    0xdba80800, 0xc4041400, 0x7a6e2200, 0x97072700, 0xd0aa8b80, 0x3ad1c140,
    0x45a00ae0, 0x79501710, 0xb5881388, 0xe1141d44, 0x81c61cea, 0x03030201,
    0x22c4b71b, 0x31d6c381, 0xbb0ab54a, 0x4681d8e4, 0x5ba80800, 0x84041400,
    0x5a6e2200, 0xc7072700, 0x58aa8b80, 0xa6d1c140, 0x6ba00ae0, 0x7c501710,
    0x1e081388, 0xfd541d44, 0xefe61cea, 0x26130201, 0xd96cb71b, 0xa5d2c381,
    0x4964b54a, 0x4d86d8e4, 0x80000000, 0xc0000000, 0x20000000, 0x50000000,
    0xc8000000, 0x3c000000, 0x3e000000, 0x67000000, 0xf9800000, 0xcc400000,
    0x66600000, 0xb3100000, 0xaba80000, 0x5d240000, 0xc4fe0000, 0xb8cf0000,
    0x66bb8000, 0x71a8c000, 0x10602000, 0x28103000, 0x4c280800, 0xa6641400,
    0x931e3200, 0xfb9f0f00, 0x95738f80, 0xf89cd9c0, 0x86b61e60, 0x01bb0310,
    0x880d9198, 0xdc13f8c4, 0x4e6db8ea, 0xff03e849, 0x0dc596bf, 0xce27d3f3,
    0x3f3bbdce, 0x2de8c47a, 0x9e000800, 0xf7001400, 0x11803200, 0xa0400f00,
    0x90600f80, 0xe81019c0, 0x6c283e60, 0xf6643310, 0x5b1e1998, 0xc79f2cc4,
    0xab73aaea, 0x9f9cd749, 0x7f36113f, 0xcdfb1e33, 0xee6d91ae, 0x6f03c86a,
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x58000000, 0x44000000,
    0x7e000000, 0x69000000, 0x5b800000, 0xdc400000, 0x5a200000, 0x87100000,
    0xdad80000, 0x9bec0000, 0xbc420000, 0xca0f0000, 0x6f7c8000, 0xc6d9c000,
    0xa1a02000, 0xab501000, 0xf8f80800, 0xe8fc2c00, 0x409a1600, 0x7ce31100,
    0xf6be9f80, 0xb996da40, 0xcf7cb6e0, 0x36d9e710, 0xd9a03e88, 0x5f501dc4,
    0xdef828b6, 0xc5fc1bfb, 0x651a2690, 0xc9a339c3, 0xf71e92bf, 0xe2c6dce6,
    0x4f848800, 0x2a25ec00, 0xbf3a3600, 0x0eb30100, 0x0dc69780, 0xc92af640,
    0xabc6a0e0, 0xa42af610, 0xae46a108, 0xa16ac784, 0xf7e69e56, 0xbe3afceb,
    0x091e9818, 0xcbc6e407, 0x34049a09, 0x4665d71d, 0x80000000, 0x40000000,
    0xa0000000, 0xb0000000, 0x48000000, 0x74000000, 0xc2000000, 0xe7000000,
    0xb5800000, 0xba400000, 0x9b200000, 0xa3d00000, 0x2f180000, 0x81840000,
    0xd82a0000, 0xcc190000, 0x5e078000, 0xe138c000, 0xd8982000, 0x9cc41000,
    0x568a2800, 0x65892c00, 0xa23f9200, 0xb76cdd00, 0xedaa1080, 0x365929c0,
    0x65278560, 0xf2e8c290, 0xbf8014c8, 0x694025f4, 0x4ca01346, 0x4e9035a1,
    0x49b8096a, 0xec140096, 0xae1201c9, 0x094d297a, 0x1cb59080, 0x16e5e9c0,
    0xc595a560, 0x1235d290, 0xff0dbcc8, 0x99f1c9f4, 0xf407a146, 0x8238f8a1,
    0x471831ea, 0x05840556, 0xf22a16a9, 0xef1936ea, 0x618794c8, 0xc878e5f4,
    0x34383346, 0x625425a1, 0x80000000, 0x40000000, 0xa0000000, 0xf0000000,
    0x98000000, 0xb4000000, 0x52000000, 0x07000000, 0xbf800000, 0x5a400000,
    0x3b200000, 0x91d00000, 0xd3380000, 0xfdec0000, 0x954a0000, 0x58f10000,
    0xb5df8000, 0x091dc000, 0x86b82000, 0xa4ac1000, 0x7bea2800, 0xd0613c00,
    0x2847a600, 0x8c61ed00, 0x166a3480, 0xcd2111c0, 0x0ce787e0, 0xb7f1ea90,
    0x667208c8, 0x151d1974, 0x1895884e, 0x15ecc2bb, 0xf9678cb2, 0x1eb1fdac,
    0x10d23f3f, 0x298d0bf3, 0xd70db480, 0x9790d1c0, 0xd635a7e0, 0x2d7cfa90,
    0x5cffa0c8, 0xdfcde574, 0x4a000e4e, 0xf3003fbb, 0x4d801032, 0xad40106c,
    0x1ca03edf, 0x7f901c63, 0xba1820c8, 0x6b3c2574, 0xf9f22e4e, 0xff5d2fbb,
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xf8000000, 0x4c000000,
    0xa6000000, 0x89000000, 0x6e800000, 0x1a400000, 0x17600000, 0x4bf00000,
    0xa2f80000, 0x7c5c0000, 0x7e360000, 0x551b0000, 0x40808000, 0x272d4000,
    0x93982000, 0x7eac3000, 0x524e3800, 0x43071c00, 0xd1d6be00, 0x75c65300,
    0xd7e08980, 0xacdd5240, 0xd16003a0, 0x72f02a90, 0xd47803d8, 0x5a1c1dfc,
    0x37563f3e, 0xdbeb2e57, 0x2af8adad, 0xc8317196, 0x944e2e58, 0x7a072da7,
    0xa756b180, 0x53864e40, 0x9e80bda0, 0x222d7990, 0xbb180a58, 0x9dec0fbc,
    0xd3ae1c9e, 0x5eb734c7, 0xc24e9675, 0xcb6a706a, 0x65aeaf66, 0x9fda50f0,
    0xf8b695ad, 0x4b366d96, 0xa5989058, 0x7fc17ea7, 0x80000000, 0x40000000,
    0x20000000, 0x30000000, 0xb8000000, 0x3c000000, 0xde000000, 0xdf000000,
    0x29800000, 0x32400000, 0xe9200000, 0x62900000, 0x71d80000, 0x5e3c0000,
    0x9f2e0000, 0x09e70000, 0x026b8000, 0x5176c000, 0x5ef82000, 0xafac1000,
    0x81760800, 0xb69b0c00, 0x3be5ae00, 0xeb41cf00, 0x33eb9780, 0x2f36e7c0,
    0xf1d82260, 0x1e3c1090, 0xbf2e1c48, 0x39e71ba4, 0xba6b85f6, 0x6d76ef4f,
    0x80f83a2b, 0x70ac2929, 0xa8f638b2, 0x84db0c69, 0xd2c59f80, 0x89d1ebc0,
    0x42338c60, 0x710adf90, 0x6ef60bc8, 0x17db3c64, 0xbd458796, 0x6891efdf,
    0xe493ae63, 0xc2dafe8d, 0x018e3344, 0xc6373c26, 0x9313ba2b, 0x6f9ae929,
    0xe12e18b2, 0xa6e71c69, 0x80000000, 0x40000000, 0xa0000000, 0xd0000000,
    0xf8000000, 0x3c000000, 0x6e000000, 0x19000000, 0x50800000, 0xca400000,
    0x7b200000, 0xafd00000, 0x97a80000, 0x4b9c0000, 0x55ae0000, 0x64ef0000,
    0xf0288000, 0x68524000, 0x64082000, 0x820c1000, 0x8f262800, 0x75a33400,
    0xf4aebe00, 0xa8614f00, 0x842ebb80, 0xf2215640, 0xa70e9c20, 0xb1f15690,
    0xa6a6a8c8, 0xdf6d40f4, 0xcd88886a, 0x68c27fa7, 0x16002ccb, 0x650006eb,
    0x9e803b62, 0x03403e30, 0xd3a01380, 0x59902240, 0x82880220, 0xfd4c0990,
    0x92863b48, 0xe53322b4, 0xdea6aa4a, 0xa36d6637, 0x0388bf83, 0xa1c2505f,
    0xbe800f28, 0x93400707, 0x8ba03f83, 0xb590105f, 0x14882f28, 0xd84c1707,
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xc8000000, 0xbc000000,
    0x4e000000, 0x57000000, 0x80800000, 0x0a400000, 0xfd200000, 0x8db00000,
    0xffa80000, 0xa6840000, 0x110e0000, 0x4bdf0000, 0x74d78000, 0xb8724000,
    0x84082000, 0x8a741000, 0xbd061800, 0xedab3400, 0x2fd1b200, 0x6ed96f00,
    0xad59b380, 0x05ed45c0, 0x23ff9820, 0x38b66690, 0x8e263548, 0x771b286c,
    0x30f9866a, 0x121d6761, 0x8977a5e3, 0x7f827aa7, 0xe68029dd, 0x71403e20,
    0x9ba02b80, 0xbcf031c0, 0x04080a20, 0xca741990, 0xdd061ec8, 0x3dab19ac,
    0xe7d18c4a, 0xd2d97ef1, 0xe359bb2b, 0x52ed630b, 0xa37fa597, 0x32f640d1,
    0x730610ab, 0xfaab12cb, 0xcf518fb7, 0xb4994941, 0x80000000, 0x40000000,
    0x20000000, 0xb0000000, 0xa8000000, 0xd4000000, 0xfa000000, 0xf9000000,
    0x92800000, 0x19400000, 0x42a00000, 0x21500000, 0x8ef80000, 0xa7040000,
    0x59920000, 0x36f90000, 0x2b2e8000, 0xffd04000, 0x51922000, 0x12f91000,
    0x592e8800, 0x62d06c00, 0x91120a00, 0x26b92500, 0x730eb680, 0xa3c05240,
    0xcfca2ea0, 0xb9ad2350, 0xe6c4a628, 0x136d5a14, 0x338e8d1e, 0xd7804a91,
    0xc5ea104c, 0xc8bd07aa, 0x101cafd5, 0x58794965, 0x5c44a628, 0x9e2d5a14,
    0xab2e8d1e, 0xbfd04a91, 0x7192104c, 0xa2f907aa, 0xf12eafd5, 0xb6d04965,
    0x6b122628, 0xdfb91a14, 0xe18ead1e, 0xba805a91, 0x8d6a184c, 0x98fd2baa,
    0x683c85d5, 0xb4697c65, 0x80000000, 0x40000000, 0xe0000000, 0xb0000000,
    0x58000000, 0x1c000000, 0x72000000, 0x4f000000, 0xa1800000, 0x77400000,
    0x4da00000, 0xbd300000, 0xaef80000, 0x369c0000, 0x8ab60000, 0xa8850000,
    0x0fe18000, 0xea0dc000, 0xf3362000, 0x83c51000, 0xd041b800, 0xa83dec00,
    0xa44e3600, 0xde191700, 0x6557a480, 0xf288ffc0, 0xa4d79e60, 0x75c8cad0,
    0x517797e8, 0x64f8c08c, 0xd58f8dde, 0x0164eb77, 0x8cb9a345, 0x91a1edad,
    0x6f7812a6, 0xb1dc0234, 0x7f1617e8, 0xb9b5008c, 0x8b19adde, 0x8f91fb77,
    0xaa001b45, 0x130001ad, 0x338024a6, 0x88401534, 0xb4203368, 0xd6703f4c,
    0x915813be, 0xc4ac21a7, 0x85ce34ad, 0xe9592d21, 0xc8f79f78, 0xffb8e943,
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x88000000, 0x34000000,
    0xa2000000, 0x03000000, 0x41800000, 0xf7400000, 0x03a00000, 0x04100000,
    0x9a080000, 0x4f140000, 0x0fb20000, 0xea550000, 0xd73b8000, 0x13a1c000,
    0x2c122000, 0xfe451000, 0x6533a800, 0x38b5d400, 0x09a00200, 0x23101d00,
    0x51880080, 0xdf5414c0, 0x67923260, 0x2e0530d0, 0xad13a868, 0xace5c1c4,
    0xfb8816e2, 0xa8543e15, 0x24122b04, 0x8a452f91, 0x6733b14c, 0x6bb5da2d,
    0xc0200068, 0xe05015c4, 0xf02814e2, 0xd8442315, 0xbc1a2b84, 0x96513b51,
    0xa101832c, 0x42a0eafd, 0xb6bba800, 0xf4e1d400, 0x07b20200, 0x9e551d00,
    0xd53b8080, 0x40a1d4c0, 0xe5921260, 0x3d0520d0, 0x80000000, 0x40000000,
    0xe0000000, 0xd0000000, 0xb8000000, 0x1c000000, 0x82000000, 0xfb000000,
    0xed800000, 0x87400000, 0xffa00000, 0x24300000, 0xde480000, 0x992c0000,
    0xc6e60000, 0xd2dd0000, 0x64938000, 0x59a7c000, 0x01462000, 0xaaed1000,
    0xd8dbb800, 0xeb8bf400, 0x92200e00, 0xe3701700, 0xc1e81880, 0x6d1c0ac0,
    0xa0ae1560, 0x57f126d0, 0x20759f68, 0x707af7cc, 0x8855acf2, 0x740ad79b,
    0x263d9651, 0x6556d9bb, 0x94b398b6, 0x91d7d322, 0x952e2768, 0x5cb103cc,
    0x05d5a2f2, 0x634ac09b, 0x819d8ed1, 0x8d66d37b, 0x70fb8dd6, 0xeffbf5f2,
    0x3c483800, 0xf22c3400, 0x73662e00, 0x999d0700, 0xa133a080, 0x9a97fec0,
    0xb08e1b60, 0x4f8131d0, 0x80000000, 0xc0000000, 0xa0000000, 0x10000000,
    0x48000000, 0xac000000, 0x06000000, 0x95000000, 0x05800000, 0xc9400000,
    0x3be00000, 0x08100000, 0xcc680000, 0xb6740000, 0xcd5e0000, 0xe1a70000,
    0x635c8000, 0xa8e1c000, 0x98be2000, 0x00b73000, 0x44b4a800, 0xfed5c400,
    0x25803200, 0x19401b00, 0xd3e02980, 0xb4102140, 0x82681360, 0x8f741950,
    0xcede0f78, 0xbde72744, 0x5d3cb27a, 0x69b1dfcd, 0x6f361daf, 0xbed30a6d,
    0x458283cd, 0xa906c3a5, 0x8b82a778, 0x5006e344, 0x2802807a, 0x1c46c4cd,
    0x5e62b42f, 0x7116eb2d, 0xafeab0ad, 0x5a72eaf5, 0xab5c8000, 0xc4e1c000,
    0x3ebe2000, 0x85b73000, 0x0934a800, 0x9b95c400, 0x18603200, 0x84501b00,
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xf8000000, 0x34000000,
    0x1a000000, 0xff000000, 0xf3800000, 0x93400000, 0x2da00000, 0x3e700000,
    0x3d480000, 0x88cc0000, 0x52b20000, 0x8d910000, 0xce358000, 0x750cc000,
    0x94922000, 0x84a11000, 0x5cdd9800, 0xd8b0f400, 0xeae81e00, 0xd9bc1d00,
    0x047a1e80, 0x721d0bc0, 0x532782e0, 0x0dede9d0, 0x8e6fade8, 0x1521e05c,
    0x44dd8bb2, 0x7cb0e2e3, 0x68e819c4, 0xc2bc05f8, 0x15fa1c5f, 0x2a5d39b0,
    0x9707b5e8, 0x5fddd45c, 0x6d07b5b2, 0x30ddefe3, 0x06879f44, 0x479dfa38,
    0xc92780bf, 0xb2edcd60, 0x1def8680, 0x5661ffc0, 0x917d9ce0, 0x76c0f4d0,
    0x4fa03368, 0xb5702b9c, 0xb4c82952, 0x348c1b33, 0x80000000, 0xc0000000,
    0x60000000, 0x10000000, 0x28000000, 0xfc000000, 0xb2000000, 0x5b000000,
    0x3f800000, 0x7f400000, 0x89e00000, 0x22700000, 0xb3680000, 0xa3a40000,
    0xdd360000, 0xfaad0000, 0xe1a38000, 0x7e6ec000, 0x71562000, 0xc09d3000,
    0x36ab9800, 0xcbfac400, 0x81682a00, 0x38a40f00, 0x82b63480, 0x95ed12c0,
    0x404385e0, 0xa01ee0d0, 0x703e2ef8, 0x38392e5c, 0xd41dbb3a, 0x4e17f339,
    0xe92bbf35, 0x64baf937, 0x40880032, 0xf6d415b2, 0xabde36f8, 0x91492a5c,
    0x10f5b13a, 0x7ef3cc39, 0x27fd93b5, 0x1b67eff7, 0x9fc38fd2, 0x0f5eca62,
    0xb1de3480, 0xf64912c0, 0xfd7585e0, 0x4ab3e0d0, 0xb99daef8, 0xba57ee5c,
    0x174b9b3a, 0xd58ac339, 0x80000000, 0x40000000, 0x60000000, 0x30000000,
    0x08000000, 0x4c000000, 0xf6000000, 0x7f000000, 0x76800000, 0x19400000,
    0x11a00000, 0x7bf00000, 0x8af80000, 0xa7540000, 0x42ae0000, 0xcb170000,
    0xe4a58000, 0x8c124000, 0xd6562000, 0x2f431000, 0x4e8b9800, 0x5d454c00,
    0xabd3a200, 0xf2e14300, 0x83058580, 0xc8e243c0, 0x4a2e27a0, 0xa1570950,
    0x1585a3e8, 0xa1a25e3c, 0x338e209e, 0xa6a73345, 0x617dace3, 0x35f679a9,
    0xf1a0205f, 0x0bf0117d, 0xe2f82668, 0xdb541dfc, 0xbcae073e, 0xf8173a15,
    0x64258f0b, 0xea526795, 0xb17620c1, 0x4df33238, 0xd5d3928b, 0x81e16855,
    0x6385a561, 0x9ea27868, 0x250e34e3, 0x8fe735a9, 0x78dd825f, 0x0206527d,
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0xb8000000, 0x7c000000,
    0x4a000000, 0xf3000000, 0x90800000, 0x81400000, 0x5fa00000, 0xfb900000,
    0x5dd80000, 0x8cec0000, 0x5b360000, 0xc4b10000, 0xdf338000, 0x52974000,
    0x166e2000, 0x891d1000, 0x7ba5a800, 0x1db65c00, 0x2c858e00, 0x2b664f00,
    0x7cfd9a80, 0xa31a70c0, 0x18938220, 0xe5077350, 0x19b62368, 0xfaf11124,
    0x4213a7d6, 0xd7477cab, 0x76963985, 0xf0211c58, 0xf86ba9f2, 0xdc3b49ea,
    0x3a7839e8, 0x4b7c21e4, 0xecee05f6, 0xcb5d1ffb, 0xac85b2ed, 0x6b66517c,
    0xdcfd8024, 0xd31a7a41, 0xa0939aed, 0x99074d7c, 0x53b62e24, 0x09f12541,
    0xd293a86d, 0x560761bc, 0x29362204, 0x0bb11911, 0x80000000, 0x40000000,
    0xa0000000, 0xb0000000, 0x88000000, 0xd4000000, 0xea000000, 0xb7000000,
    0xf5800000, 0xa5400000, 0xfea00000, 0x7e900000, 0x3eb80000, 0x9ef40000,
    0x2e820000, 0xa6d90000, 0x729d8000, 0x98c9c000, 0x2fba2000, 0xda6d1000,
    0x7f3fa800, 0x81c0ec00, 0xff3f8200, 0xc1c0e500, 0x5f3fb280, 0x71c0d1c0,
    0xd73f9760, 0xa5c0e050, 0x3d3faf28, 0x12c0fb64, 0xc8bfa24e, 0xb780ea2d,
    0x361f99e8, 0xc910fb82, 0x08a78141, 0x57e4d3bb, 0x26259da8, 0xf13deaa4,
    0x54b8152e, 0x69f41a7d, 0x7b021ec0, 0xb3992ce6, 0x043d810f, 0x3259cc96,
    0xfb021ec0, 0xf3992ce6, 0xa43d810f, 0x8259cc96, 0x73021ec0, 0x27992ce6,
    0x4e3d810f, 0x3559cc96, 0x80000000, 0x40000000, 0x20000000, 0x50000000,
    0x08000000, 0x34000000, 0x1a000000, 0xd1000000, 0xac800000, 0x57400000,
    0x43a00000, 0x18d00000, 0x0d480000, 0xb2b40000, 0xe4620000, 0x52010000,
    0xc5668000, 0xe6e94000, 0x8e0a2000, 0xdb251000, 0x55ec8800, 0x9f8c5400,
    0x06c6a200, 0xbe395d00, 0xa3422e80, 0x39913040, 0xb98ea120, 0xf98d4cd0,
    0xd9a03468, 0x89d02f74, 0x81c826f2, 0xb5f4193d, 0xafc200d0, 0x7ed10a64,
    0xd22ea463, 0x855d6763, 0xc6e812e8, 0xde640b34, 0xd32a05d2, 0x61b518ed,
    0x85849238, 0xd7a84150, 0x12cc81b1, 0xf41c6f8e, 0x7a2e88d0, 0xa15d5e64,
    0xf4e80663, 0x6b643a63, 0x6daa3c68, 0xd3f53b74, 0x70a4a4f2, 0x4938543d,
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x08000000, 0xe4000000,
    0xe6000000, 0x07000000, 0x10800000, 0x7d400000, 0x5da00000, 0x08f00000,
    0x21180000, 0x37940000, 0xfdfa0000, 0xd8ef0000, 0xb9258000, 0x2be14000,
    0xf7c22000, 0xddcb1000, 0x48e79800, 0x412a7c00, 0xc7a5a200, 0xf5a16900,
    0x3ce20180, 0x5f7b2dc0, 0x2cdf9e20, 0xe70e5a50, 0xa0e78ce8, 0x152a6afc,
    0x49a58de6, 0xe6a17f75, 0xc2621636, 0xc13b3e57, 0x87ff92e7, 0x95be41e1,
    0xccdf9568, 0x570e7b3c, 0xc8e791c6, 0x012a5c25, 0xa7a5835e, 0x05a1456b,
    0x34e20321, 0xbb7b1dc4, 0xcadf9636, 0xe00e7e57, 0xb067b2e7, 0x686a51e1,
    0x14058d68, 0xee51473c, 0xe37a13c6, 0xf6af2525, 0x80000000, 0xc0000000,
    0x20000000, 0xb0000000, 0x38000000, 0xac000000, 0xa2000000, 0xcf000000,
    0x57800000, 0x2fc00000, 0x63a00000, 0x51b00000, 0x16e80000, 0xd5740000,
    0xf4e20000, 0xfa130000, 0x33448000, 0x5dc74000, 0xc4c4a000, 0x02077000,
    0xbf64a800, 0x4fb75c00, 0x338ca600, 0xf9c37700, 0x32ee8e80, 0xe31044c0,
    0x358a1b60, 0xc0a70f30, 0x8406a388, 0x46646b5c, 0xd9680e32, 0x26b40201,
    0x2d42150a, 0x78a30b85, 0xe82cb75b, 0xc4736834, 0xa606950a, 0x49644b85,
    0xaee8175b, 0xb9741834, 0x76e23d0a, 0x85131785, 0x5cc4b15b, 0xde076f34,
    0x0564b38a, 0x9cb75345, 0xfe0caa3b, 0xb5036004, 0xa4ce9002, 0x52607819,
    0x17420409, 0x6ba31205, 0x80000000, 0xc0000000, 0x20000000, 0x10000000,
    0x78000000, 0x6c000000, 0x7e000000, 0xff000000, 0x18800000, 0xc0c00000,
    0x7ca00000, 0x5ab00000, 0xd9b80000, 0xc7040000, 0x94f20000, 0x8eed0000,
    0xebe28000, 0x5676c000, 0x0b62a000, 0x3ab6f000, 0x29c2a800, 0x8f06f400,
    0x90fab600, 0xe4c2ef00, 0x06a8a980, 0xcf9fd0c0, 0x2c722fa0, 0x9e2d20f0,
    0xcf429088, 0x70c6c65c, 0xd4da8ee6, 0x6eb2c39d, 0xdbb0bdda, 0x3e2bff26,
    0x1f3806a2, 0x28c40e7b, 0xa8d23dda, 0x689d3f26, 0x48faa6a2, 0x58c2fe7b,
    0x20a895da, 0x4c9fcb26, 0x32f210a2, 0xcded117b, 0xd562bc5a, 0x15b6dbe6,
    0x69429f02, 0x33c6c18b, 0xea5a84d2, 0x2d72e9ba, 0xb990a7e4, 0x375bed16,
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xd8000000, 0xf4000000,
    0xd2000000, 0xab000000, 0x98800000, 0x90c00000, 0xeca00000, 0x82f00000,
    0xe7e80000, 0x2a040000, 0xaf3e0000, 0x32b70000, 0xfff28000, 0x7e46c000,
    0x4d72a000, 0x4186f000, 0x93528800, 0x3cb6fc00, 0x0a9abe00, 0x5b82c100,
    0xe46c8a80, 0xfa01ebc0, 0x27682ca0, 0x8ec40ff0, 0x319e3788, 0x2b471f4c,
    0x589aa672, 0x3082d9cd, 0xdcec9bbd, 0x5ac1d860, 0x13c838c1, 0xf8342131,
    0x04761bbd, 0xaa431860, 0x6f2498c1, 0x92f5d131, 0xcfbe13bd, 0xa6772460,
    0xb95286c1, 0x93b6e031, 0x381a913d, 0xa442f3a0, 0x9a4cb461, 0xb731dec1,
    0x66a02435, 0x1df03b2c, 0x0d6820b3, 0x21c439fc, 0x80000000, 0x40000000,
    0xa0000000, 0x30000000, 0x08000000, 0x0c000000, 0x72000000, 0xf9000000,
    0x4a800000, 0x86c00000, 0x14e00000, 0x7db00000, 0x0f280000, 0x8dec0000,
    0xe70a0000, 0x11830000, 0xad578000, 0xecdec000, 0x99b7a000, 0xe16ed000,
    0x3e9f8800, 0x5082dc00, 0xa3958a00, 0xb401df00, 0x36421680, 0x271f2140,
    0xf195a420, 0x3d01d0f0, 0xd4c22918, 0x9ddf139c, 0x9f75a0d2, 0xb5b1efe7,
    0xe36a0f90, 0x6ff30ac7, 0x261fa0e5, 0x5f42f100, 0x55f58790, 0x7371d6c7,
    0x578a2ae5, 0x22432e00, 0x21379110, 0xdeaef787, 0xc0ff8ec5, 0x9bf2fef0,
    0xb05db808, 0x485de41b, 0xac602e17, 0x42701117, 0xf1483798, 0x469c2edc,
    0xf4c22ef2, 0xeddf3017, 0x80000000, 0x40000000, 0x60000000, 0x50000000,
    0x28000000, 0xe4000000, 0x1e000000, 0x0d000000, 0x4f800000, 0x03c00000,
    0xb9e00000, 0xcad00000, 0xd8780000, 0xbc2c0000, 0xe27e0000, 0x8f410000,
    0x90ef8000, 0xbb1c4000, 0xe68fa000, 0x320c5000, 0xe717b800, 0x14f04400,
    0xf511b200, 0xc39d7d00, 0x99803580, 0xfac03e40, 0xa0600660, 0x70102eb0,
    0x18183018, 0x9c3c0804, 0xd2660c06, 0xf77d1e0f, 0x5c89b319, 0x41617e9f,
    0xf58624c2, 0x70ad00a8, 0xab718b19, 0xae8d7a9f, 0x861836c2, 0xd13c2da8,
    0xfde60699, 0xa4bd00df, 0xcd6982a2, 0x6fb17e18, 0x33fe0301, 0xc181369b,
    0x068f88c4, 0x220c4ea7, 0xaf178000, 0xa0f04000, 0xc311a000, 0x2a9d5000,
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x38000000, 0x2c000000,
    0xd2000000, 0x8d000000, 0x70800000, 0x14c00000, 0xb2e00000, 0x51f00000,
    0xf6280000, 0x0b740000, 0x23c20000, 0x8b7b0000, 0x63858000, 0xab51c000,
    0xd3e5a000, 0x9361d000, 0xffada800, 0x4125fc00, 0x72a7a600, 0x31daf700,
    0x66481280, 0x83441440, 0x378a2ea0, 0x753f0170, 0x3c8f8a18, 0x56aef90c,
    0xb78a1992, 0x353f20d1, 0x1c8f8de2, 0xe6aedd4f, 0x8f8a2f23, 0x193f05ab,
    0xce8fa5e2, 0x6baee14f, 0xff0a2923, 0x0dff22ab, 0x7c6f9f62, 0x3a5ec90f,
    0x09220183, 0x068b04db, 0x5fadaffa, 0xb125d843, 0x6aa790b1, 0xaddad27a,
    0x8c483a80, 0x22442840, 0x950a28a0, 0xecff2670, 0x80000000, 0xc0000000,
    0x60000000, 0x50000000, 0xd8000000, 0xec000000, 0xf2000000, 0x65000000,
    0x87800000, 0x05c00000, 0x48a00000, 0xcb100000, 0x58f80000, 0xb3340000,
    0x84d20000, 0xc9130000, 0xd5f58000, 0x50944000, 0x470da000, 0xfaa07000,
    0x0e5fb800, 0xef736400, 0x3e8a0e00, 0xf8371f00, 0x1c5f9280, 0x1a737640,
    0x010a0b60, 0x41f71330, 0x7eff9748, 0x58637ef4, 0x2c7233f6, 0x92031479,
    0x350d81a2, 0x5fa0610d, 0xe9dfb597, 0xbab340dc, 0xae2a1322, 0xdf27174d,
    0xb6a7bef7, 0xcc4753ec, 0x0258046a, 0x8d2429b9, 0xe3aa2d01, 0xc3e73795,
    0x3387bdc8, 0xdb976cb4, 0xbf803696, 0x79c01849, 0x02a0046a, 0x121029b9,
    0xf5782d01, 0x3ff43795, 0x80000000, 0xc0000000, 0xa0000000, 0x90000000,
    0x58000000, 0xc4000000, 0x66000000, 0x3b000000, 0x39800000, 0xd7c00000,
    0x10a00000, 0xbb700000, 0xf9f80000, 0x77f40000, 0x80a60000, 0xe30d0000,
    0x3db48000, 0x11c64000, 0xbbcca000, 0xdaf27000, 0xea4a8800, 0x014f5400,
    0x00a61e00, 0x230d2500, 0x9db4a780, 0x81c65bc0, 0xe3cca1e0, 0x1ef27a30,
    0x8c4a9bc8, 0x3a4f41ec, 0x39262a36, 0xf4cd23d1, 0x8d14bdff, 0x3ab65022,
    0x1a34b0da, 0x69065b7f, 0x0cec9a7f, 0xd9424be2, 0x0492b13a, 0xe50b514f,
    0x36d809b7, 0xe0441e0e, 0xf07e250c, 0x6849279e, 0x0c4a9bc8, 0xfa4f41ec,
    0x99262a36, 0x64cd23d1, 0xd514bdff, 0xfeb65022, 0x7c34b0da, 0x52065b7f,
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xb8000000, 0xb4000000,
    0xfa000000, 0x47000000, 0xd1800000, 0x1fc00000, 0xe2e00000, 0x94100000,
    0x4a580000, 0x0f240000, 0xcd8e0000, 0xe9bb0000, 0xebe48000, 0xf8a64000,
    0xc35ca000, 0x23925000, 0xa48a9800, 0xd50d5400, 0x3ae03600, 0x70103900,
    0xe8582880, 0xec2438c0, 0x5e0e24e0, 0x057b3b30, 0x2284b258, 0x34767334,
    0xba64be4e, 0xa766713d, 0xc1bc814d, 0xa78248a3, 0x56d2ad0c, 0x6e297e8e,
    0x0d6e31cd, 0xdeab2463, 0xd23cbfec, 0x0b427cbe, 0x7fb2ab15, 0xb2f96f97,
    0xcc562542, 0xee5f36b3, 0x4d0a9800, 0x3ecd5400, 0xc2003600, 0xb3003900,
    0xcb802880, 0x48c038c0, 0x8b6024e0, 0x3fd03b30, 0x80000000, 0x40000000,
    0x60000000, 0x50000000, 0xb8000000, 0x14000000, 0xd2000000, 0x6d000000,
    0x25800000, 0x73c00000, 0x54e00000, 0x38500000, 0x54380000, 0xb2440000,
    0x3d7e0000, 0x9dbf0000, 0x67958000, 0x86ad4000, 0x554da000, 0x71b95000,
    0xc18bb800, 0x69824400, 0xa5801600, 0x33c00100, 0x34e00280, 0x68500a40,
    0xec3813e0, 0xa64402b0, 0xef7e28d8, 0xf0bf09a4, 0x42158956, 0xf56d7e75,
    0x01adaf69, 0x49e955ea, 0x95b3bbb4, 0xdbc66e55, 0x98fe15e9, 0xae7f1baa,
    0x5375be54, 0xeefd6de5, 0xb975bfb1, 0xd7fd584e, 0x2ef584e2, 0x993d4120,
    0xe7958000, 0xc6ad4000, 0x354da000, 0x21b95000, 0x798bb800, 0x7d824400,
    0x77801600, 0x5ec00100, 0x80000000, 0x40000000, 0xe0000000, 0xf0000000,
    0x38000000, 0x2c000000, 0x86000000, 0x79000000, 0xe2800000, 0xd8c00000,
    0xafe00000, 0xc0100000, 0xa0280000, 0x10140000, 0xc8720000, 0x14490000,
    0xaa698000, 0xff0ec000, 0x9ba1a000, 0x3a0ad000, 0x777b9800, 0x6f97ec00,
    0x60001600, 0xb0002700, 0xd8001780, 0xdc002940, 0xbe001720, 0x55002370,
    0x648032d8, 0xa1c01874, 0x4d603b52, 0x18d00231, 0x0fc831ee, 0xd0043113,
    0x685a308c, 0x045d3ed4, 0x621bbe6e, 0xeb47f453, 0x31c831ac, 0xc5043aa4,
    0xecda1b36, 0x559d0567, 0x177bbdde, 0xdf97cbe5, 0xb8000000, 0x6c000000,
    0x66000000, 0x89000000, 0xda800000, 0xf4c00000, 0x29e00000, 0xb9100000,
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x48000000, 0x34000000,
    0x3e000000, 0x1b000000, 0xe0800000, 0xe2c00000, 0xd3a00000, 0xc6500000,
    0xa7080000, 0x0acc0000, 0xf7e60000, 0x60010000, 0xf0188000, 0xa80ac000,
    0x0430a000, 0x7656f000, 0x2f7e9800, 0xdecbfc00, 0xf9880a00, 0x330c3100,
    0x24c62580, 0x749107c0, 0xccb0a5a0, 0x5096f370, 0x6adea348, 0x079bffe4,
    0xc8003d0a, 0xf4003797, 0xde000ad3, 0x2b002a27, 0xa88035bd, 0xd6c03b71,
    0xeda03753, 0xdd5011e7, 0x47883a1d, 0xe80c0901, 0x2446299b, 0xa65115c3,
    0x5710a8b7, 0xa2c6fce6, 0xf3d6a580, 0x1657c7c0, 0xdf6605a0, 0x76c10370,
    0xfdb8bb48, 0x455ac3e4, 0x0bb8970a, 0xaa5af697, 0x80000000, 0xc0000000,
    0x20000000, 0xf0000000, 0x98000000, 0x9c000000, 0x4e000000, 0x59000000,
    0x07800000, 0xddc00000, 0xdea00000, 0x1a300000, 0x23080000, 0x34a40000,
    0xa13a0000, 0x8bc50000, 0xdb958000, 0x73d04000, 0x57bda000, 0x75847000,
    0xfaafa800, 0x38154c00, 0xac280e00, 0xf6542b00, 0x35123d80, 0xd1910d40,
    0x1887b460, 0x97414630, 0x9eba05c8, 0xfa0517bc, 0xf335b68a, 0x5ce040d5,
    0xa5359124, 0x59e07e54, 0xccb5ade9, 0x2d20696c, 0x8d9584a4, 0x76d07f14,
    0x3e3db789, 0x0144745c, 0xbb8f94ec, 0x63e569e8, 0x1f801b63, 0x81c029b9,
    0xb0a01580, 0xb3300140, 0xbc881a60, 0x75641d30, 0x319a1048, 0xc8f516fc,
    0xff1dacea, 0x9ab45de5, 0x80000000, 0x40000000, 0x20000000, 0x10000000,
    0x08000000, 0x84000000, 0x92000000, 0x91000000, 0xbd800000, 0x8cc00000,
    0x61600000, 0xc5b00000, 0x30d80000, 0x6f6c0000, 0x4af60000, 0x0a530000,
    0x5d2d8000, 0x8bc04000, 0x9fdba000, 0x45935000, 0x70f62800, 0x4f531400,
    0x5aad8a00, 0x02006500, 0xd93b8680, 0x19e35540, 0x0ece23e0, 0xf84f1370,
    0xfc63bd38, 0x2e4f775c, 0x9f5812ee, 0x32ac3ff7, 0xb6161d6b, 0x53231a3f,
    0x0495b0ce, 0xa51c5338, 0x77f5a053, 0xb1ac6d63, 0xdaada220, 0x42006ccf,
    0xf93bbd38, 0x09e3775c, 0x06ce12ee, 0x7c4f3ff7, 0x6e639d6b, 0xbf4f5a3f,
    0x22d810ce, 0xbe6c0338, 0xd7760853, 0x96933963, 0x344d8820, 0xca7059cf,
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x78000000, 0xac000000,
    0x3a000000, 0x0d000000, 0xf1800000, 0x6cc00000, 0xf5200000, 0x9df00000,
    0x76a80000, 0x08640000, 0x141a0000, 0xb6230000, 0xc75f8000, 0x84944000,
    0x3145a000, 0xa3b77000, 0x659a2800, 0x1ae30c00, 0x127f9600, 0xe9645700,
    0x3fedb080, 0x07d35840, 0x4b801ae0, 0xa1c01470, 0x24a01728, 0x01302b4c,
    0xfb883062, 0x39940d25, 0x58b22a4c, 0xb34737e1, 0x22c5b5f9, 0x5e7770e1,
    0x033a3d64, 0xbad31cad, 0x2277859b, 0xb1307dc4, 0x63ff9728, 0x45a46b4c,
    0xeacd9062, 0x6a237d25, 0x4528024c, 0x05a43be1, 0x0aba23f9, 0xba1327e1,
    0xcd578de4, 0xd1c044ed, 0x9cd79f7b, 0x8d0069b4, 0x80000000, 0x40000000,
    0xe0000000, 0x30000000, 0x98000000, 0x6c000000, 0xaa000000, 0x83000000,
    0xd7800000, 0xc0c00000, 0xa1600000, 0x30d00000, 0x99280000, 0x8cf40000,
    0x9b4a0000, 0xfbdb0000, 0x8ae88000, 0x12644000, 0x7f42a000, 0x35af5000,
    0x87e21800, 0x28ef1c00, 0xb5429e00, 0xc6af5700, 0x28622c80, 0xb42f2bc0,
    0x2622a760, 0x197f5cf0, 0xccca1bb8, 0x7b1b3704, 0xcb889c92, 0x12b443c9,
    0x7e6ab378, 0xd55b66fb, 0xb6a81eb0, 0x50340a9b, 0xe82a30c0, 0x140b0dff,
    0xf640bc22, 0xb1504e52, 0x38e8b738, 0xbd645cc4, 0xe2c29bf2, 0x466f4f39,
    0x690230c0, 0xb4ff0dff, 0x270abc22, 0xf98b4e52, 0xfd803738, 0x03c01cc4,
    0x96e03bf2, 0xc0101f39, 0x80000000, 0xc0000000, 0x60000000, 0x30000000,
    0x28000000, 0x8c000000, 0x2e000000, 0xc3000000, 0xae800000, 0x79c00000,
    0x9d200000, 0xe5d00000, 0x0b680000, 0xd2ec0000, 0x1fa20000, 0xe2690000,
    0x4d328000, 0x3dd8c000, 0xcf30a000, 0x40a1f000, 0xdaca3800, 0x03853c00,
    0xb4109200, 0x1a71ef00, 0x19222180, 0xd7a923c0, 0x9e12b820, 0x2b08e2b0,
    0x42d8a6e8, 0x678df404, 0x76481612, 0xc73c010f, 0x5cca3c92, 0x8c853d51,
    0x5490b26c, 0x90b1dd58, 0x0282227a, 0xc7b93555, 0x265a967e, 0xdf34c357,
    0xf8928768, 0x2ec8d7c4, 0xb9f8ae32, 0xfd5de3bf, 0xd5a01a7a, 0x23100955,
    0x5ec8047e, 0x31fc2c57, 0x216a26e8, 0xe3953404, 0x4458b612, 0x524df10f,
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x48000000, 0x6c000000,
    0x4e000000, 0x3b000000, 0x94800000, 0xc1c00000, 0xbe200000, 0xb3500000,
    0x98880000, 0xffdc0000, 0xcd320000, 0x4bc10000, 0x17728000, 0x7aabc000,
    0xeac8a000, 0x12b6f000, 0x56883800, 0x04dc2c00, 0x39b20a00, 0xfa010700,
    0xe1528180, 0xa5fbd5c0, 0x3c4096a0, 0xd66aceb0, 0x0f3a32a8, 0x8edd30a4,
    0x90e083aa, 0x33fad423, 0x931234ee, 0x489108c7, 0xa7fa9830, 0x9977eeea,
    0x21fa87c6, 0x0e77eda3, 0x9b7a8d3a, 0x84b7f479, 0xf9da8180, 0x9a27d5c0,
    0x917296a0, 0xedabceb0, 0x5048b2a8, 0x9876f0a4, 0x342823aa, 0x1a4c2423,
    0x511a0cee, 0x8d8d24c7, 0x20689230, 0xd026e9ea, 0x80000000, 0x40000000,
    0x60000000, 0x90000000, 0x58000000, 0x44000000, 0x1a000000, 0xf1000000,
    0x4e800000, 0xf5c00000, 0x32600000, 0x3d100000, 0x28f80000, 0xcaa40000,
    0xcfee0000, 0x337f0000, 0xbbad8000, 0xc14bc000, 0xa6bba000, 0x1990d000,
    0xa4783800, 0xca643400, 0xc90e0e00, 0x9aaf3500, 0xb7b59080, 0x873fed40,
    0x69cdb520, 0x2c5bd130, 0xb643a738, 0x0734c634, 0x299628a6, 0x4c1b18ed,
    0x2623b145, 0x5f24f736, 0x6dee3e30, 0x567f3cbd, 0xd72d86fd, 0x118bdc42,
    0x985ba3b6, 0x6440f560, 0xea601080, 0x39102d40, 0x52f81520, 0xaba40130,
    0xd96e1f38, 0x82bf3234, 0x93cd86a6, 0x0d5bfded, 0xc0c399c5, 0x26f4ee76,
    0x59f62510, 0xc40b088d, 0x80000000, 0xc0000000, 0xe0000000, 0xf0000000,
    0xc8000000, 0xe4000000, 0x42000000, 0xbd000000, 0x6a800000, 0x05c00000,
    0x2a200000, 0x89100000, 0xf0880000, 0x64dc0000, 0x2eb60000, 0x97830000,
    0x4f578000, 0x3fe7c000, 0x9b69a000, 0x55b8f000, 0x32081800, 0xb51c0c00,
    0x6e960a00, 0xb7930500, 0x5f5fa280, 0x07fbd640, 0xb77faa20, 0xf3ebde30,
    0xcd778828, 0x62f7ef34, 0x01e19caa, 0x9864ce73, 0xfc3e0d0f, 0x7e5f2697,
    0x23619858, 0xb9a4c129, 0x741e27a7, 0xba4f1fe3, 0x7169aed2, 0x3cb8d16a,
    0x32882280, 0x19dc1640, 0xa4360a20, 0x62432e30, 0xad779028, 0x52f7e334,
    0x29e196aa, 0x8c64cb73, 0x763e2f8f, 0x275f30d7, 0x0be19278, 0x0164ef19,
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x48000000, 0xdc000000,
    0x92000000, 0x53000000, 0x6c800000, 0x85c00000, 0x36600000, 0xe5500000,
    0xc9f80000, 0xac6c0000, 0x8a6a0000, 0x27570000, 0x32e88000, 0x0cfbc000,
    0xd5faa000, 0x9e00d000, 0x29181800, 0x13fc1400, 0x23722a00, 0x74ab3300,
    0xf19ab680, 0x6850e3c0, 0x6c601fa0, 0x2a5025b0, 0xd7782eb8, 0x6aac1c24,
    0x988a2de6, 0x9bc7254f, 0x5f70b464, 0x16c7f60e, 0xfae89500, 0x90fbfb9b,
    0xa7faac5c, 0xdd00c9ea, 0x0d980746, 0x4a3c2b64, 0x87122e80, 0xc2fb37c0,
    0x54e295a0, 0x41fcc6b0, 0xd06a0038, 0xe8572be4, 0x2c68b846, 0xca3be3ff,
    0xc71ab45c, 0x2290ddea, 0x44802d46, 0x09c01864, 0x80000000, 0xc0000000,
    0x60000000, 0xd0000000, 0x98000000, 0x6c000000, 0x2e000000, 0x71000000,
    0x7c800000, 0xebc00000, 0xd2200000, 0x67500000, 0xd1d80000, 0xf1640000,
    0xbc9a0000, 0x8bd10000, 0x02678000, 0xff1ac000, 0xbda5a000, 0xdf6ff000,
    0xcdf83800, 0xf7340400, 0xe9c23e00, 0x2d752f00, 0xdaddad80, 0x0e9bc740,
    0x3c9a34a0, 0x4bd116b0, 0x6267b3a8, 0x2f1ad724, 0x25a586fe, 0xb36fce8d,
    0xe3f828d0, 0x863406ed, 0x95420e9f, 0xc6b508c2, 0x08fdb6f8, 0x69cbd689,
    0xed421cc1, 0xbab520ff, 0xdefd9580, 0xa4cbc340, 0x27c20aa0, 0x4c7539b0,
    0x5e5d9e28, 0x595bd064, 0x58ba125e, 0x3181283d, 0xe13fa378, 0x44bed5c9,
    0x379fb661, 0xb42ee94f, 0x80000000, 0xc0000000, 0xa0000000, 0x30000000,
    0xb8000000, 0xac000000, 0x06000000, 0xfd000000, 0xef800000, 0xf8c00000,
    0x8c200000, 0xf6300000, 0xe5480000, 0x73c40000, 0x46ca0000, 0xdd750000,
    0x1fcd8000, 0xe0814000, 0x106fa000, 0x48007000, 0xb4200800, 0x9a303c00,
    0x43480600, 0xbec42700, 0x114a2f80, 0x89b51440, 0x95edba60, 0xebb14170,
    0x1aa7b8e8, 0xc30473bc, 0x7eca125a, 0xb1751d7d, 0xb9cdaee0, 0x2d814cac,
    0x47ef99c1, 0x1cc06b3d, 0x3e003188, 0x91001750, 0x498037fb, 0x35c01030,
    0xdba00800, 0xa2f03c00, 0x6f680600, 0x78f42700, 0x4c022f80, 0x56711440,
    0xd527ba60, 0xcbc44170, 0xeaea38e8, 0xdb4533bc, 0xe285b25a, 0x0f456d7d,
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x58000000, 0x14000000,
    0x5a000000, 0x75000000, 0x6c800000, 0x87c00000, 0xdc600000, 0xf6700000,
    0xcb780000, 0x4b840000, 0xd2660000, 0x79070000, 0x82c78000, 0xf8e4c000,
    0x9db9a000, 0x0917d000, 0xcae00800, 0x14b00400, 0x83983e00, 0x7e341100,
    0xc77e0080, 0xa5f31840, 0xad598da0, 0x38a7fcb0, 0x7df80c38, 0xf9440c6c,
    0xc2862dc6, 0x58b73b7d, 0xcddf9047, 0x5110c9a0, 0xdea7a2a8, 0x4e94ed38,
    0xf6c194ff, 0x1293d98c, 0x40863cce, 0x79b73bf5, 0x5b5f8800, 0xf3d0c400,
    0x36479e00, 0x2b24c100, 0xbbd98880, 0xda67dc40, 0x351813a0, 0xccf43db0,
    0xd79e04b8, 0x8443102c, 0xe2419e66, 0x9153d6cd, 0x80000000, 0xc0000000,
    0x60000000, 0x70000000, 0xe8000000, 0x94000000, 0x42000000, 0x7b000000,
    0x49800000, 0x3cc00000, 0x90200000, 0x58500000, 0x1c080000, 0xa64c0000,
    0xd13e0000, 0xa6eb0000, 0x375c8000, 0xd7f94000, 0x81caa000, 0x78ce7000,
    0x2a003800, 0x2f002c00, 0x6b802200, 0x37c03900, 0x31a02a80, 0xf0903bc0,
    0xce2802e0, 0x851c11f0, 0x84b63668, 0x3c671924, 0x7642a30a, 0x29427f87,
    0xaa9e134d, 0x097b3029, 0x7af4a198, 0xf1254044, 0x76dcb7a5, 0xcf397ecd,
    0xdbea8272, 0xbf9e6733, 0xd5880000, 0x5a8c0000, 0x211e0000, 0x8ebb0000,
    0xc3548000, 0xe5b54000, 0x12f4a000, 0xa5257000, 0x54dcb800, 0xc4396c00,
    0x7a6a8200, 0x175e4900, 0x80000000, 0xc0000000, 0x20000000, 0xf0000000,
    0x28000000, 0x14000000, 0x4a000000, 0xe3000000, 0x6f800000, 0x72c00000,
    0x70200000, 0xe8300000, 0x34080000, 0xba3c0000, 0xcb0a0000, 0x7b850000,
    0x38d28000, 0x9318c000, 0x87abe000, 0x46d4b000, 0xca000800, 0x23000c00,
    0x4f800200, 0x82c00f00, 0x58200280, 0xfc300140, 0x7e0804a0, 0x593c0e30,
    0xa48a06f8, 0x0945072c, 0x48f28702, 0x7b28ce83, 0xb3a3e340, 0xfce8bba3,
    0x010a04b0, 0x58850bb8, 0x7752818d, 0x11d8c631, 0xdf8beafa, 0xbae4b52d,
    0xb4080000, 0x7a3c0000, 0xeb0a0000, 0x8b850000, 0x10d28000, 0x8718c000,
    0xcdabe000, 0xa5d4b000, 0xa5800800, 0x51c00c00, 0x3fa00200, 0x6af00f00,
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x28000000, 0x9c000000,
    0x7e000000, 0xff000000, 0x43800000, 0x79c00000, 0xb8200000, 0x14100000,
    0x52380000, 0xf9140000, 0x088a0000, 0xd8670000, 0x40ff8000, 0x108fc000,
    0x7c78e000, 0x6ad27000, 0x5d800800, 0x96c00400, 0x33a00e00, 0xa1d00500,
    0xbc180280, 0x8e0409c0, 0x673207e0, 0xa7b30ff0, 0xb3d58438, 0xa538c79c,
    0xd69f6b82, 0x9759b141, 0x7b4aed23, 0xdd617b91, 0x26558688, 0xfff8cc86,
    0xb33f688f, 0x5589bdc8, 0xfad2eaa7, 0xd5a5749d, 0xbac78000, 0x359bc000,
    0xeaf2e000, 0x1db57000, 0x76ff8800, 0x638fc400, 0x89f8ee00, 0x20127500,
    0xf0200a80, 0x98100dc0, 0xe43809e0, 0xca140af0, 0x80000000, 0xc0000000,
    0x20000000, 0x70000000, 0x48000000, 0x1c000000, 0xae000000, 0xf9000000,
    0x6c800000, 0x95c00000, 0x7c200000, 0x3e300000, 0xe1080000, 0x489c0000,
    0x6fd20000, 0x37270000, 0x059b8000, 0xe1764000, 0xcde72000, 0xb8277000,
    0x94200800, 0x92300c00, 0x27080200, 0xdd9c0700, 0xe5520480, 0x47e701c0,
    0xbb3b8ae0, 0xb3864f90, 0x3c4f26c8, 0x5b4b795c, 0x66da0fc2, 0xd3bb0fe3,
    0xac498c10, 0x43514389, 0x42fca27d, 0x299132b2, 0xe76722b9, 0x78e77d87,
    0x42800016, 0xacc009de, 0x30a00800, 0xdbf00c00, 0xd5280200, 0x6aac0700,
    0x20da0480, 0x86bb01c0, 0x06c98ae0, 0x43914f90, 0xb45ca6c8, 0x6761395c,
    0xb8cf2fc2, 0x628b7fe3, 0x80000000, 0x40000000, 0x60000000, 0xd0000000,
    0x48000000, 0xbc000000, 0x0e000000, 0xe1000000, 0xb5800000, 0x3dc00000,
    0x8c200000, 0xd6100000, 0x75180000, 0xd7b40000, 0x9ad20000, 0x648f0000,
    0x50538000, 0x25c04000, 0x38296000, 0x04157000, 0x4a200800, 0xcb100400,
    0xae980600, 0xdb740d00, 0xeb720480, 0x335f0bc0, 0xa76b80e0, 0xc5644e10,
    0x62636b58, 0x8aee73dc, 0x0c8180c2, 0x5c4f4961, 0xb3fae151, 0x2d15307b,
    0x03a9652d, 0x98d57988, 0x13800be5, 0xf0c0054c, 0x1fa00a5a, 0x66d0055d,
    0x0ab80800, 0x61640400, 0xd86a0600, 0xb9eb0d00, 0x86398480, 0x7d2b4bc0,
    0x0b90e0e0, 0x44fe3e10, 0xcd90e358, 0x59fe37dc, 0x1610e6c2, 0x553e3461,
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x98000000, 0x34000000,
    0x12000000, 0x43000000, 0x04800000, 0xb8400000, 0x46200000, 0x41300000,
    0x3fb80000, 0x58f40000, 0x74460000, 0x701d0000, 0x680c8000, 0x9c1cc000,
    0x6e132000, 0xfd051000, 0x61980800, 0xedc40c00, 0xb9fe0e00, 0xbbe90d00,
    0x80ca8980, 0x6041c340, 0x523fa120, 0x6329d430, 0x34b32848, 0xf0751784,
    0xea000262, 0x67000513, 0x6e80047b, 0x1f400bcf, 0xc8a00fe4, 0x8e700071,
    0x6f1807e8, 0xe2840675, 0x095e02cb, 0xd1990047, 0x65d28180, 0xf5c5cf40,
    0x4de1af20, 0x49f0d930, 0x13c1a1c8, 0xfcc0d4c4, 0xde79a342, 0x3734d123,
    0x36bfac33, 0xcb69dc4b, 0x0a932d86, 0x55451562, 0x80000000, 0xc0000000,
    0xa0000000, 0x50000000, 0x98000000, 0xec000000, 0x0e000000, 0x29000000,
    0x9f800000, 0xa9400000, 0x52200000, 0x8f300000, 0x32a80000, 0x1cd40000,
    0xa8460000, 0x89ab0000, 0xac5b8000, 0x63964000, 0x5f65e000, 0x673f5000,
    0xd6880800, 0xc6e40c00, 0x336e0a00, 0xa93f0500, 0x5fbd8980, 0x094d4ec0,
    0x023660e0, 0x170d1290, 0xdea3e1f8, 0x12d45694, 0x81738722, 0x160241f3,
    0x0503e0aa, 0x31a45a0d, 0xd07b8be4, 0x55a648ca, 0xca4de9dd, 0x6eab5b3d,
    0xbaee08ac, 0x057f06d4, 0x3c1d8180, 0x563d42c0, 0x653e6ae0, 0xc1a91790,
    0x186de878, 0x219b5854, 0x284607c2, 0x49ab0363, 0x0c5b8952, 0x33964099,
    0xc765e6c6, 0x8b3f5c39, 0x80000000, 0x40000000, 0xa0000000, 0x30000000,
    0xf8000000, 0xfc000000, 0x1e000000, 0x2b000000, 0x67800000, 0xc5400000,
    0xab200000, 0x27900000, 0x65680000, 0x9b2c0000, 0xdfae0000, 0x99570000,
    0x852b8000, 0xf4a4c000, 0xfecee000, 0x405ad000, 0x5fae0800, 0xd9570400,
    0x252b8a00, 0xc4a4c300, 0x06ceef80, 0xbc5adfc0, 0x41ae09e0, 0xf25706b0,
    0x42ab8c78, 0x01e4cf54, 0xadeee532, 0x9bcaddb9, 0x24c60fb6, 0x697b0f02,
    0x9d058182, 0x98b3c6c1, 0x28c56d60, 0x6f6e12f3, 0xda08e05a, 0x2921db07,
    0xc2ab8c78, 0x41e4cf54, 0x0deee532, 0xabcaddb9, 0xdcc60fb6, 0x957b0f02,
    0x83058182, 0xb3b3c6c1, 0x4f456d60, 0xaa2e12f3, 0x7128e05a, 0x0eb1db07,
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x68000000, 0x9c000000,
    0x06000000, 0x2f000000, 0xf8800000, 0x2a400000, 0x7f200000, 0x30900000,
    0xc6780000, 0x81040000, 0xeb8a0000, 0xa4df0000, 0x82458000, 0x4321c000,
    0x46b12000, 0x11571000, 0x8d8a0800, 0x5bdf0400, 0xf2c58e00, 0x6561c900,
    0x57912680, 0x92c719c0, 0xb5720860, 0xdf9b06f0, 0x9eef8188, 0xdb6ecba4,
    0x6c8ca172, 0x6072dac9, 0xde312407, 0xeb171ee0, 0x7aaa0730, 0x674f05e9,
    0x5abd8756, 0x5765c7fb, 0x429b2eec, 0x33581235, 0xb0978188, 0x866acba4,
    0x6106a172, 0x7baddac9, 0xccf4a407, 0x1e76dee0, 0x453b2730, 0x698815e9,
    0xe9cf8f56, 0xa7fec3fb, 0x24f4a0ec, 0xc276db35, 0x80000000, 0xc0000000,
    0x20000000, 0x70000000, 0xa8000000, 0x44000000, 0xc2000000, 0x13000000,
    0xcf800000, 0xe2400000, 0x71200000, 0x6cb00000, 0xa5c80000, 0xa77c0000,
    0x77ba0000, 0x9e690000, 0x0f048000, 0x2182c000, 0x5740e000, 0x1fa51000,
    0xfa720800, 0xbd150c00, 0x9abe8200, 0xdcebc700, 0x3fc46a80, 0x9867d440,
    0x1e12e420, 0xdd001d30, 0x0a8486f8, 0x24c2c524, 0xa3e0ef92, 0xb655158b,
    0x8b1a04fc, 0xc3990307, 0x346c85a3, 0x780ec1f2, 0x5c12e19a, 0x0e001eb7,
    0xe5048c1a, 0xb682c076, 0x7ac0ec78, 0x9ee51164, 0xecd20bb2, 0x77e508bb,
    0x8c568204, 0x0427c623, 0x22366a31, 0x4332d479, 0x178c6566, 0x0e5bddb0,
    0xf708e9b9, 0xbd991184, 0x80000000, 0xc0000000, 0xe0000000, 0x10000000,
    0x18000000, 0x7c000000, 0x8e000000, 0x6f000000, 0x52800000, 0x1fc00000,
    0x59200000, 0x71b00000, 0x2b780000, 0x5de40000, 0x90160000, 0xd8170000,
    0x9c1f8000, 0x9e19c000, 0x770da000, 0x2ebb7000, 0x91ee0800, 0x36330c00,
    0x23298e00, 0x34bec100, 0x04ea2180, 0xe186b7c0, 0xf355a0e0, 0xc1ef7af0,
    0x0e000328, 0xaf000cfc, 0xb2800a12, 0x0fc001db, 0x41200bd7, 0x0db004ee,
    0xa57804c9, 0x32e40a8d, 0xc296097b, 0xc7d70f06, 0xc53f8055, 0xefa9c02e,
    0x5c75a2a8, 0x735f7b3c, 0x01f80af2, 0xee240b2b, 0xbf3600ff, 0xaaa70412,
    0x73e780db, 0xcf3dca56, 0x62bba32c, 0xf7dc7c28, 0x2d29847c, 0x9bbec053,
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x08000000, 0xf4000000,
    0xa6000000, 0x77000000, 0x65800000, 0xd3c00000, 0x45200000, 0xe4900000,
    0xd9680000, 0xbf4c0000, 0x28720000, 0x5de50000, 0x361d8000, 0x8f0bc000,
    0x39a26000, 0x31ce7000, 0x9c3a0800, 0x02390400, 0xc9078a00, 0x5ea2cb00,
    0xec4de080, 0xb3e0bf40, 0x1525e260, 0xfcacb370, 0x9557e458, 0xe549b23c,
    0x0d4a66d2, 0xe9427e09, 0xf7680576, 0x7c4c0cc4, 0x4bf2043f, 0x49250bd2,
    0x1ebd8b8b, 0x4c5bc3b5, 0x03ea6666, 0x1d127ced, 0x08a00cd8, 0x3350097c,
    0x92480eb2, 0x68dc0679, 0x3a9a01ae, 0xb26901b8, 0x98cf808d, 0x92bec6ab,
    0xf677eaa5, 0x36d9bd4d, 0x11a2648b, 0x35ce7936, 0x80000000, 0xc0000000,
    0x60000000, 0xd0000000, 0x48000000, 0xf4000000, 0x26000000, 0x61000000,
    0x17800000, 0x08c00000, 0xbb200000, 0x04b00000, 0xe8580000, 0x5d540000,
    0x1cc20000, 0x8d350000, 0x4d958000, 0xdbe64000, 0x3bbee000, 0x32d4b000,
    0xb83a0800, 0xcc110c00, 0x2a2f8600, 0x2b374d00, 0xecb16480, 0xac53ff40,
    0xe3536a60, 0xc1d6fa10, 0x489eef78, 0x0264b18c, 0x16620132, 0x20450e0b,
    0x696d8e65, 0x5ac24185, 0x3c04e654, 0x1205b10f, 0x27358473, 0xa6964769,
    0x5746e1f4, 0x47f0bb3f, 0x998003f8, 0x8dc002cc, 0xa2a00d52, 0x4970091b,
    0x2af80d9d, 0xc4240349, 0x7e3a0b06, 0xbd110814, 0x15af81ee, 0x07f74820,
    0x39916cf2, 0x3de3fe2b, 0x80000000, 0x40000000, 0xe0000000, 0x70000000,
    0x78000000, 0x74000000, 0x7e000000, 0x5f000000, 0xd0800000, 0x75400000,
    0x7d200000, 0x2d900000, 0x18f80000, 0x85fc0000, 0xd86e0000, 0xb8950000,
    0x496b8000, 0xef0dc000, 0x08bb2000, 0x9179d000, 0x0b360800, 0x7eb90400,
    0xc25d8e00, 0xd1b4c700, 0x2ae6a780, 0x30cd1740, 0x59d0afe0, 0x3a7411f0,
    0xe58d2b08, 0xb4c0d454, 0x1feb8652, 0xf14dc699, 0x3b1b2fef, 0xe6a9ddef,
    0xc66e08ee, 0xd7950a6d, 0x01eb87ac, 0x9e4dc98d, 0x739b2c5e, 0x97e9d385,
    0xbd4e0488, 0xd1050714, 0xb79387b2, 0x31f1c069, 0x06552b67, 0x77acdafb,
    0x91fd8f5c, 0x9664ca04, 0x7fbeaccb, 0x9de11376, 0x9c66a302, 0x5e8d1981,
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0xc8000000, 0x24000000,
    0x8e000000, 0x39000000, 0x6a800000, 0x60400000, 0x5aa00000, 0xf8700000,
    0x96a80000, 0xc2540000, 0xe99a0000, 0xb5dd0000, 0x6d798000, 0xb6334000,
    0xa5332000, 0xb8b35000, 0xab798800, 0x6b334c00, 0x61b32200, 0x71f35900,
    0x53598480, 0xd7034e40, 0x23bb2ae0, 0x72d75a90, 0x46eb8228, 0xc0ca4844,
    0xfdf8af4a, 0x89491517, 0x18092b42, 0x0c1e5461, 0x1a2809d3, 0xef14024a,
    0xbfba0795, 0xa0ed0a02, 0x8df18500, 0xf1574e81, 0x64212b42, 0x6e0a5461,
    0x891209d3, 0x32b9024a, 0x8c6b8795, 0xf08a4a02, 0x4f58a500, 0xc5391e81,
    0xc8a12342, 0xd34a5861, 0x17320bd3, 0x03890b4a, 0x80000000, 0xc0000000,
    0xa0000000, 0xd0000000, 0xf8000000, 0xbc000000, 0xca000000, 0x39000000,
    0x13800000, 0x55400000, 0xbba00000, 0xd1700000, 0x6d880000, 0xf2440000,
    0xbf360000, 0x08ab0000, 0x9be48000, 0x5b754000, 0x34986000, 0x91ec1000,
    0xc2648800, 0xf7354c00, 0x3cb86a00, 0xc5dc1d00, 0xec4c8780, 0x680147c0,
    0x240666a0, 0x06331e90, 0xdb1e06b8, 0x6e9f0294, 0x30da8d1a, 0x1dda4387,
    0x406ae860, 0xfa0251b0, 0x713064e9, 0x2798120d, 0x0b7a8c5e, 0x0caa4ec7,
    0x8de2e680, 0xd8465243, 0x36066860, 0x933311b0, 0x5a9e04e9, 0x6edf020d,
    0xaafa845e, 0x1cea42c7, 0x4fc2ec80, 0xb5765f43, 0x0bae67e0, 0x59471a70,
    0xf9800849, 0x7c40019d, 0x80000000, 0x40000000, 0x60000000, 0x30000000,
    0xf8000000, 0xe4000000, 0xfa000000, 0xad000000, 0xb6800000, 0x89c00000,
    0x92a00000, 0x53d00000, 0x6fb80000, 0x2d5c0000, 0xfa460000, 0xa1c50000,
    0xfea88000, 0xd5d64000, 0xec992000, 0x34d23000, 0x8c088800, 0xf6064400,
    0x1b212600, 0xcd8e3300, 0x744e8780, 0x1ec34a40, 0xa909a9a0, 0x3c9879d0,
    0xbcf7ace8, 0xf00172dc, 0xd819288a, 0xb41238ed, 0x32288c13, 0xb1164309,
    0xa8b920ae, 0xdec238b1, 0x89108a59, 0x6c8a4784, 0x74df2a8f, 0xec173d20,
    0xc6200413, 0xe3100709, 0x299806ae, 0x8e4c0bb1, 0xb3de0dd9, 0x1f890dc4,
    0xb576832f, 0x2e5f44f0, 0xa3efa8fb, 0xb78d75d5, 0x99672e24, 0xc84b335c,
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x68000000, 0xe4000000,
    0x86000000, 0x9d000000, 0xe1800000, 0xb0c00000, 0xeda00000, 0x12f00000,
    0x16980000, 0x7e740000, 0x2fc20000, 0xc72d0000, 0x56b38000, 0x5e624000,
    0xdfe7e000, 0xbf387000, 0xda938800, 0x3c524c00, 0xc4dfee00, 0xc3bc7100,
    0x8bc98e80, 0x610b4240, 0x3bae6660, 0xc7f338d0, 0xe31de098, 0x3091794c,
    0xd37a00ba, 0x566905ff, 0xebc987f1, 0xb10b43ab, 0xb3ae62c6, 0x33f33acd,
    0x0d1dea7a, 0x49917cdd, 0xb4fa09c0, 0x7ba900a2, 0xe7e98ff1, 0x133b4fab,
    0x48966cc6, 0x5f773bcd, 0x3447ecfa, 0xf0c8729d, 0xcd8b81a0, 0xe2e64972,
    0x6ebde1e9, 0xf26174a7, 0x4de20a1c, 0xdc1d06e2, 0x80000000, 0x40000000,
    0x20000000, 0x70000000, 0xa8000000, 0x34000000, 0xd2000000, 0x59000000,
    0xd6800000, 0xf1400000, 0x9aa00000, 0x8f500000, 0xada80000, 0x96cc0000,
    0xa9420000, 0x46a10000, 0x49468000, 0x56af4000, 0xb1672000, 0xbaa51000,
    0xff668800, 0x05bf4400, 0xa2ef2200, 0x7b791700, 0x1fac8280, 0x9fc24740,
    0xa7e3af20, 0x2beb5290, 0x35e72fe8, 0x52e51854, 0x93468e8a, 0x0baf4e65,
    0x3de72f32, 0x56e51238, 0xc9468c9e, 0x16af4e4f, 0x91672c06, 0xcaa51182,
    0x576687c0, 0x31bf4f61, 0x70ef2732, 0x22791638, 0xc92c8e9e, 0x6e82494f,
    0x3d43a686, 0xa4bb52c2, 0x984f2ae0, 0xc4291af1, 0x3a04825a, 0x4d0e4d2c,
    0x74a1ad34, 0x004a52ba, 0x80000000, 0x40000000, 0xa0000000, 0x90000000,
    0x88000000, 0xcc000000, 0x5a000000, 0x77000000, 0x4e800000, 0x23400000,
    0xd4a00000, 0xb4500000, 0xaa080000, 0x8f340000, 0x3a8a0000, 0xad570000,
    0xbd948000, 0x1bfec000, 0xeacd2000, 0x41411000, 0x379c8800, 0x44cac400,
    0xf8472a00, 0xb0161900, 0x58080080, 0xe43408c0, 0x060a0fa0, 0xa5170e70,
    0xf5b48c68, 0x37eecef4, 0x80e528ea, 0x2e651c35, 0x3d3e8648, 0xf1b9cec7,
    0x01f1a4e2, 0x3ddbd890, 0x9fd3a1f9, 0x9ce8d18c, 0x5c452aa4, 0x163514b1,
    0x6d3686c8, 0x998dc607, 0xfdfbab42, 0x7fccd6e0, 0xace72d91, 0x44461f78,
    0x5200024e, 0xfb000884, 0xb4800080, 0xc44008c0, 0x12200fa0, 0x5b100e70,
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x68000000, 0xb4000000,
    0xb6000000, 0x09000000, 0x40800000, 0xb9400000, 0x3ea00000, 0x54700000,
    0x30180000, 0x482c0000, 0x24220000, 0xae310000, 0xd5378000, 0x42af4000,
    0x067da000, 0x770c1000, 0xadaf8800, 0xb7c34c00, 0x22ffae00, 0x404d1700,
    0xd6000e80, 0xb9000740, 0xc8800560, 0x7d400790, 0xe0a00288, 0xe97000d4,
    0xc698088a, 0xf86c05d7, 0x5a020709, 0x43010f16, 0xdb8f81a8, 0x5ef34fa4,
    0x1247ae52, 0x911110a8, 0x5cba0a25, 0x5b5d0193, 0xf1b58989, 0x75ee4856,
    0x7dd224c8, 0x79cf5834, 0x47d024da, 0x8ace5c7c, 0x145facaf, 0x103d1344,
    0xd8180000, 0x3c2c0000, 0x72220000, 0xd7310000, 0x80000000, 0xc0000000,
    0xe0000000, 0x10000000, 0xb8000000, 0xe4000000, 0x86000000, 0x8d000000,
    0x4b800000, 0x8ec00000, 0x79a00000, 0x1df00000, 0xab180000, 0xf6b40000,
    0x8d560000, 0xbb5d0000, 0xbe5f8000, 0x59f24000, 0x1d1f6000, 0x33a2f000,
    0x8ae78800, 0xefb64c00, 0x28d16e00, 0x048bf100, 0xfe4e0380, 0x79e90240,
    0xed098660, 0x9baf49d0, 0xd6c0ef38, 0x8d90b6ac, 0x23d8e7fa, 0xc224b50f,
    0x3b0ee809, 0x8eb9ba87, 0x897162cf, 0x2d7bf92a, 0x8b5604b4, 0xf65d0164,
    0x15df805c, 0xc73247f3, 0xdcbf6389, 0xca52f4c7, 0xa7ff8aaf, 0x940241fa,
    0xee07680c, 0x3116f588, 0x39b181c6, 0x3deb4b2c, 0x5b0eecb8, 0x5eb9b4ec,
    0xd171619a, 0xd97bfcdf, 0x80000000, 0x40000000, 0x60000000, 0xb0000000,
    0x88000000, 0xbc000000, 0xba000000, 0x6b000000, 0xbb800000, 0x27400000,
    0x30a00000, 0x6cd00000, 0xfff80000, 0x505c0000, 0xa10a0000, 0x788b0000,
    0xf0f88000, 0x95dbc000, 0x037d6000, 0x2eba9000, 0x59f28800, 0x1150c400,
    0x2985e600, 0x60615b00, 0x690fe080, 0xa4aa5fc0, 0xfad765a0, 0x76e199b0,
    0x04f20d38, 0xb3d706b4, 0x0272862a, 0xc610c0bd, 0xf125e767, 0x00b15a01,
    0xa4f7e102, 0x23f65181, 0x5a5d6642, 0x422a97e1, 0x7f2a8052, 0x6d9cc26b,
    0xce57ea5f, 0xd4265cb5, 0xf6256728, 0x3936913c, 0xdc808125, 0xaec7cde0,
    0xc0d76150, 0x5de193ea, 0xdf720c1d, 0x24970b54, 0xbad2877a, 0x16c0c357,
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x58000000, 0x54000000,
    0x56000000, 0x33000000, 0x54800000, 0xe4c00000, 0x17a00000, 0x18700000,
    0xcf780000, 0x05c40000, 0xbe1e0000, 0xaf290000, 0x6e8f8000, 0x85dbc000,
    0x7e23a000, 0xcf057000, 0x3e918800, 0xddf2cc00, 0x2a2c2600, 0x991eb500,
    0x0d922d80, 0x8947b940, 0xcee5ab60, 0x8e987a30, 0x15f80ec8, 0x4604020c,
    0xcb3e079a, 0x309902f7, 0xbad7895f, 0x28afc860, 0x4ee5aab3, 0x4e987609,
    0x75f8062d, 0x16040bca, 0x933e078e, 0x649902d9, 0xecd78797, 0x1bafca6c,
    0x1a65ad29, 0xaa5874fe, 0x62580f72, 0x0e7403aa, 0x5c460d3d, 0x615d04d0,
    0x52c989ba, 0xb486cda6, 0x74ea2ca7, 0x2f83b327, 0x80000000, 0x40000000,
    0xa0000000, 0x30000000, 0x78000000, 0xdc000000, 0xca000000, 0x43000000,
    0xe3800000, 0x9c400000, 0xb8a00000, 0x73d00000, 0x06c80000, 0x1c7c0000,
    0xf8860000, 0xd3c30000, 0x36e88000, 0x6445c000, 0x24bb6000, 0x19c65000,
    0x75ee8800, 0x87c6c400, 0xb8f3ea00, 0xa1539300, 0x061def80, 0x813c99c0,
    0xa4bb6ea0, 0x59c65330, 0xd5ee8bb8, 0xb7c6c304, 0xc0f3eaaa, 0x7d539dcd,
    0xcc1ded74, 0xc23c95f3, 0x473b649a, 0xc58650f5, 0x6d4e8330, 0xc416c3ba,
    0xc63be705, 0x612f90aa, 0x349be6cc, 0x11ff96f7, 0x71d3ee30, 0xa1c39d38,
    0x49f5e644, 0xddd09249, 0xb3d5699f, 0xe6e9535f, 0x8c680a7c, 0xb0ac0c8d,
    0x77ce0795, 0x20ff0ea2, 0x80000000, 0xc0000000, 0xa0000000, 0x90000000,
    0x08000000, 0x5c000000, 0x3a000000, 0x2f000000, 0xac800000, 0x94c00000,
    0x5fa00000, 0xc2700000, 0x44480000, 0xa1740000, 0x1afa0000, 0xe68b0000,
    0x43f08000, 0x9732c000, 0xa8a4a000, 0x5add7000, 0x86aa8800, 0x73c9cc00,
    0x0f1c2a00, 0xfc9bb900, 0x3cf42880, 0x939fb9c0, 0xf04621a0, 0x3760b7f0,
    0x37cca848, 0xa119798c, 0x15b884da, 0x1546ce17, 0x8cdea7ac, 0xcb967d6b,
    0x047a05bd, 0xc14b0033, 0x2ad086e9, 0x7e82cdff, 0x17cca0d3, 0xf1197179,
    0xbdb887e4, 0xd946c8e7, 0xbedeab67, 0xb8967724, 0x92fa09c5, 0x7a8b0954,
    0xd9f084ce, 0x2832c6ba, 0x0c24a945, 0x921d7c94, 0xe30a8f6e, 0x9eb9c84a,
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x28000000, 0xc4000000,
    0x3a000000, 0x9b000000, 0xa1800000, 0x93400000, 0xa0a00000, 0xf9f00000,
    0x2a580000, 0x560c0000, 0xa5020000, 0xe0950000, 0xd9d88000, 0xba7dc000,
    0x0e07e000, 0x49049000, 0x1e828800, 0x78e4cc00, 0x80dd6e00, 0x3cec5700,
    0x7addea80, 0x47dd9040, 0xab7805a0, 0xfcbc02b0, 0xcffa0698, 0x3f690274,
    0x7e828b2a, 0xc8e4ca6f, 0x48dd6b1d, 0x88ec55e4, 0x68dde242, 0x18dd94a2,
    0x30f80332, 0xf4fc0a58, 0xceda0495, 0x55d904b9, 0xf47a8705, 0x6718c7d0,
    0xc7876cc8, 0x3e755c7d, 0x14076eb7, 0x42355dc8, 0xe7276dfd, 0x07855a74,
    0xde5f6f2a, 0x6439586c, 0x6a256a1f, 0x23105c66, 0x80000000, 0xc0000000,
    0x60000000, 0x70000000, 0x28000000, 0xa4000000, 0xfe000000, 0x3d000000,
    0x82800000, 0xb3400000, 0x05a00000, 0x42f00000, 0x41780000, 0xa28c0000,
    0x63620000, 0x3d8d0000, 0xbed98000, 0x33544000, 0xc5ba2000, 0x22fe1000,
    0x31638800, 0x8aa54c00, 0xc779a600, 0xc3ab5700, 0x83e22a80, 0xb1c21640,
    0x76d981e0, 0x275448d0, 0x73ba2ca8, 0xcbfe1674, 0x65e3853a, 0xa0e541bf,
    0xbe59a5df, 0x0f1b55cc, 0x45ba24c4, 0xe2fe1a83, 0x51638e40, 0xfaa545e2,
    0xef79a2d2, 0x67ab5dab, 0x7de22bf7, 0x8cc219f8, 0xf459861e, 0x941444ec,
    0x761a2db7, 0x890e101a, 0x249b82cc, 0x02694e47, 0xdd3bacc0, 0x32965fa2,
    0xfb63a532, 0xd1aa527b, 0x80000000, 0xc0000000, 0xe0000000, 0x70000000,
    0x88000000, 0x5c000000, 0xea000000, 0x43000000, 0x40800000, 0xfc400000,
    0x9da00000, 0x19f00000, 0x90580000, 0xdf8c0000, 0x96ea0000, 0xc2d30000,
    0xb4d48000, 0xfdcdc000, 0x8e49a000, 0xba835000, 0x87468800, 0xe922cc00,
    0x238f2e00, 0x2ce19700, 0x99e9a080, 0x507359c0, 0x3f9e88a0, 0xe6eecf30,
    0x4ac52288, 0xe8c29d04, 0x17e527fa, 0xcd729c6f, 0xfa1d25ad, 0x7b0e9d0c,
    0x74af2a3c, 0x3a519cb6, 0xbc91abb2, 0x464f594b, 0xc68c8ca7, 0xfd41cf49,
    0x5223afa5, 0xb71055c8, 0x66b20b66, 0xad5f08e9, 0x4a3e8417, 0x131ecc83,
    0x589d27c1, 0x584e97a0, 0xa38f23b2, 0xece1954b, 0x79e9a2a7, 0x20735849,
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x58000000, 0x9c000000,
    0x2a000000, 0xcf000000, 0x3d800000, 0x4c400000, 0x0ca00000, 0x70d00000,
    0xb4780000, 0x60840000, 0xb2de0000, 0x6f6b0000, 0xb3188000, 0x878ac000,
    0xbb4ee000, 0x7d285000, 0x4e9e8800, 0xebf5c400, 0x07d06600, 0x85dd9d00,
    0x3eceed80, 0x3d685dc0, 0x503e8ca0, 0x1825c5f0, 0xfc286058, 0xfa199004,
    0x9730efea, 0xa193563d, 0x667e043f, 0xc3bb073c, 0x4d608bbf, 0xf80ec1ff,
    0x6c10e79c, 0xc2035c4d, 0xdb2602a6, 0xd3af0b18, 0x356681e7, 0xd431cef8,
    0xce2e6ef5, 0xc9269f32, 0x508e667b, 0x7af692b5, 0xcb766c53, 0xd532942a,
    0x3a88679c, 0xd5c99c4d, 0x26c8e2a6, 0xc1575b18, 0x80000000, 0x40000000,
    0x60000000, 0x90000000, 0xe8000000, 0x0c000000, 0xbe000000, 0x2f000000,
    0x73800000, 0x12400000, 0x3a600000, 0x16700000, 0x58680000, 0x0f4c0000,
    0x98f60000, 0x38b50000, 0x93fa8000, 0xd9014000, 0xe0b5a000, 0xc7dd3000,
    0x7335a800, 0x059d3400, 0xc155ae00, 0x8fed3d00, 0xcf3da080, 0xa3a13dc0,
    0x9a4bab60, 0xa6543f30, 0x40512c58, 0x7b657e14, 0xc2ec8ffe, 0xa5844f73,
    0x71472278, 0x97e07b87, 0xbb1e05f7, 0xf9b9050c, 0x076c8c48, 0x44c4455c,
    0x0ea72123, 0x20d07211, 0xfc960c48, 0xd1c5055c, 0x30128123, 0x580d4211,
    0x1423a448, 0xca18315c, 0x75272f23, 0xee907f11, 0xf0f604c8, 0x74b50c9c,
    0x4dfa8443, 0x66014021, 0x80000000, 0xc0000000, 0x20000000, 0x90000000,
    0x08000000, 0x74000000, 0xea000000, 0x15000000, 0xdc800000, 0x40c00000,
    0xe8e00000, 0xccd00000, 0x0ed80000, 0xfffc0000, 0xc17e0000, 0xe0a30000,
    0x3ef98000, 0xa7ecc000, 0x9d63e000, 0xee9fd000, 0xc9e3e800, 0x1a5fdc00,
    0xeb03ea00, 0x538fd500, 0x315bea80, 0x98b3d240, 0xf2c5e420, 0xa1c0d310,
    0x1e6469e8, 0xb910171c, 0xaa998766, 0x7bfccbd1, 0x535bef8b, 0x39b3d82e,
    0xe445e99c, 0x6400d324, 0x220468f3, 0x4100171a, 0xa6a18f05, 0x5dd0cfe3,
    0x407de8f3, 0x662cd71a, 0xf3226f05, 0xef9f1fe3, 0x8f4600f3, 0xf78f0b1a,
    0x335f8505, 0x49b3cae3, 0x5c646a73, 0x8810195a, 0xb4198125, 0xca3cc9f3,
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xa8000000, 0x9c000000,
    0xfa000000, 0xd3000000, 0xdb800000, 0xb4c00000, 0x88e00000, 0x62d00000,
    0x39d80000, 0xae6c0000, 0x48860000, 0x8f410000, 0xcc2f8000, 0x92034000,
    0x6f39a000, 0xf1829000, 0xcfd9a800, 0xcf529c00, 0x2c01aa00, 0x623e9100,
    0x1707a080, 0xc5bf98c0, 0xa9c82f20, 0xe66cd5f0, 0x24a98298, 0x0d424ebc,
    0x2b162216, 0x2f81d491, 0xf2e00b8b, 0x71d00f77, 0xc2580f83, 0xcaac0f43,
    0x68660461, 0x71910f93, 0x0ff78a0a, 0xef6f4f37, 0xfc3fac61, 0xca039393,
    0x8b16200a, 0x3f81de37, 0x7ae00ce1, 0x3dd00b53, 0x90580f2a, 0x85ac0bc7,
    0x49e60e79, 0x165105ef, 0x5c978d3c, 0x397f4f56, 0x80000000, 0x40000000,
    0xe0000000, 0x30000000, 0x88000000, 0xfc000000, 0xe6000000, 0x59000000,
    0x18800000, 0xc1400000, 0x95600000, 0x1f700000, 0xf8480000, 0xfdc40000,
    0xb6260000, 0xa1390000, 0x8c908000, 0xeb7ec000, 0xa254e000, 0xa2d6b000,
    0xc7b4e800, 0xf0e6b400, 0x249ce600, 0x8752b700, 0x1c72ee80, 0xbfefb8c0,
    0x4d2460e0, 0x72987d50, 0x16480168, 0x18c40144, 0xa8a6003e, 0x097904b3,
    0x897081ba, 0xc94ec86f, 0x297ce258, 0x1962bdbc, 0x915aecf1, 0x6d5bb29b,
    0x8b4a695c, 0xd26577a2, 0xcafe84f1, 0x0b83c69b, 0x9ee26f5c, 0x819170a2,
    0x79f08271, 0x840eca5b, 0x321ce9bc, 0x9312baf2, 0x1f92ed99, 0xf4dfb3df,
    0x568c6962, 0xf46c7311, 0x80000000, 0xc0000000, 0xe0000000, 0xd0000000,
    0x58000000, 0x84000000, 0xca000000, 0x6b000000, 0x1f800000, 0x12400000,
    0x98600000, 0xd3500000, 0xfce80000, 0x669c0000, 0x22ea0000, 0xbf9b0000,
    0xe2418000, 0xf0474000, 0xdf6aa000, 0xead53000, 0x4382a800, 0x9c493c00,
    0xd968a600, 0x77d23100, 0xa9292380, 0x68957940, 0xa3c38f20, 0xfb004ff0,
    0x67a126d8, 0xa65972d4, 0xda41895e, 0x64474ee1, 0xad6aa510, 0xd5d531c8,
    0xce02a81e, 0x610935c1, 0x9488a0e2, 0xddc23811, 0xd2212c4a, 0xcf19745d,
    0xe5a18362, 0xf1574151, 0x5be2a36a, 0x8f193bad, 0xc580a5ba, 0xc14e3385,
    0xd3c32a34, 0x530e754c, 0x8b8200aa, 0x6047024d, 0xa74b822a, 0x5ecc408d,
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x68000000, 0xe4000000,
    0x7e000000, 0x87000000, 0xda800000, 0x2c400000, 0x62600000, 0x3d700000,
    0x9bd80000, 0x158c0000, 0x02f60000, 0xf83f0000, 0x6c388000, 0x6a354000,
    0xc125e000, 0xd199f000, 0x6cfde800, 0xb715f400, 0x028be200, 0x506af100,
    0xc0536480, 0x486fbf40, 0x5c4e8360, 0x1a4a4730, 0x117d66c8, 0x51dcb1f4,
    0x848002ee, 0xbb400323, 0x70e00fd3, 0xa5300d3b, 0xefb8049c, 0x4bfc0188,
    0x3dae0e97, 0x46f303df, 0xd62e8eeb, 0x833a47a5, 0x54a56a17, 0x9350bc9f,
    0x34f60d8b, 0x8b3f0095, 0x00b88cdf, 0x75754d6b, 0x6fc5ef65, 0xa3a9f3b6,
    0x31c5eb0c, 0x34a9f450, 0x2345e9f9, 0xace9f33e, 0x80000000, 0x40000000,
    0x60000000, 0x70000000, 0xd8000000, 0xfc000000, 0xba000000, 0x2f000000,
    0xd0800000, 0x78c00000, 0xaae00000, 0x81f00000, 0x07680000, 0x42b40000,
    0x33e20000, 0x5c6d0000, 0x1c0b8000, 0x8a244000, 0x972a6000, 0x5ca55000,
    0x1ac26800, 0x79d15400, 0xeb406e00, 0x508c5300, 0x38c3e380, 0xcaec1cc0,
    0xf1e38820, 0xdf504e30, 0xbea86d28, 0x89f85dbc, 0x7341e986, 0xccb116a3,
    0xf2e00270, 0x3df00a48, 0xdd680f6e, 0x1db406be, 0x3b620e06, 0xd8ad0c60,
    0x0ceb8d52, 0x24d449f9, 0x40c26d86, 0x66d150a0, 0x83c06572, 0xa44c57c9,
    0xf023e8ae, 0x981c191c, 0x9c0b82f4, 0xca24426a, 0xf72a615e, 0x2ca55b94,
    0xc2c26bba, 0x85d159e4, 0x80000000, 0x40000000, 0x60000000, 0x10000000,
    0xb8000000, 0x74000000, 0x02000000, 0xbf000000, 0x18800000, 0x05c00000,
    0x5be00000, 0x6af00000, 0xdb680000, 0x6b2c0000, 0x2aa20000, 0x72ef0000,
    0x9f578000, 0xa12c4000, 0x49bc6000, 0xa4741000, 0x53b46800, 0x5f681400,
    0x811e6e00, 0x399b1500, 0x0c63e580, 0x9f845240, 0x294205a0, 0x3c1f09b0,
    0x9e3f8c28, 0x11004dec, 0xc19e6f96, 0x185b1a43, 0x8d83e1a0, 0x2e745fb1,
    0x50aa052a, 0x99f3026f, 0xf5fd8ed7, 0xb3df4b61, 0xc6c1e9d2, 0xbd6b5d79,
    0x6e158357, 0xf9334d21, 0x6d83e272, 0x7e7451c9, 0x88aa02ff, 0xfdf3068d,
    0x4ffd8644, 0x78df473a, 0xdc41e2f7, 0x07ab5290, 0x2d758758, 0x960343a6,
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xc8000000, 0xdc000000,
    0x12000000, 0x65000000, 0x6d800000, 0x97c00000, 0xc1e00000, 0x72f00000,
    0xec680000, 0x85140000, 0xdd860000, 0x3fe10000, 0xeddd8000, 0xa8e8c000,
    0x5559a000, 0xfab75000, 0x2f51a800, 0x93935400, 0x08dfae00, 0x85565b00,
    0xa28c2280, 0xcb7b96c0, 0x958603a0, 0xa3e10090, 0x9fdd8d78, 0x3de8cdec,
    0xf0d9a766, 0xb17755c3, 0xfcb1ad20, 0x84635452, 0x8937a7d8, 0x97825efc,
    0xbeea235d, 0x866a90ce, 0x94338b36, 0x8e1dce1a, 0x170229dd, 0xf8be920e,
    0x32558696, 0x8a0cc58a, 0xa137ae25, 0xfb825d22, 0x04ea2c50, 0xcf6a9bd9,
    0x23b384fd, 0xa0ddc65c, 0xa962214e, 0x788e9b76, 0x80000000, 0xc0000000,
    0x20000000, 0x70000000, 0x38000000, 0x4c000000, 0x66000000, 0xfb000000,
    0xc4800000, 0x4cc00000, 0x47e00000, 0x7b500000, 0x5b980000, 0x0a640000,
    0xb23a0000, 0x61310000, 0x418c8000, 0x4f684000, 0x91b86000, 0xc77fd000,
    0xc5826800, 0x9d4edc00, 0x608eea00, 0xeee69b00, 0x8ed68980, 0x1ec94fc0,
    0x76cce7e0, 0x72e39c70, 0x60f801a8, 0xb1f403bc, 0xe8420c56, 0x9b050bc9,
    0x54ae8e0f, 0x24fd471f, 0x43eeec84, 0x69769eb0, 0x8aae8eca, 0x53fd4a8f,
    0xc16ee05e, 0xaeb69e27, 0x31ce8f62, 0x286d4933, 0xbb16ec08, 0x248295ee,
    0x1cec816d, 0x0ff84e2c, 0x0f40608c, 0x718bdb5e, 0x974067a7, 0x8d8bd8a3,
    0xe9406ad2, 0x4a8bde79, 0x80000000, 0xc0000000, 0x60000000, 0x30000000,
    0xc8000000, 0xdc000000, 0x22000000, 0x4b000000, 0xa8800000, 0x00c00000,
    0xbfe00000, 0x19500000, 0xd8880000, 0x68e40000, 0x33c60000, 0xc3590000,
    0x87858000, 0x3e494000, 0x5a366000, 0x9f01d000, 0x36906800, 0x59c8dc00,
    0x947dee00, 0x6d359f00, 0x45858280, 0x854942c0, 0x5ab668a0, 0x73c1da70,
    0x63706c28, 0xd798d57c, 0xc675ed56, 0x4e119a29, 0x61238e7e, 0x5f8045d7,
    0xba5bedea, 0x3c3c915e, 0xd2080ae4, 0xe3240c23, 0x44a60bb1, 0xeac90008,
    0x28ed8ecc, 0x93fd455f, 0x937868e7, 0x7fbcd521, 0x2a53ea32, 0xa4189e48,
    0xf62e03ad, 0xd52d010f, 0xf1ab8e7e, 0x2b6445d7, 0xcb9dedea, 0x8465915e,
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xc8000000, 0x44000000,
    0x82000000, 0x2d000000, 0xef800000, 0x67400000, 0x48600000, 0xcaf00000,
    0x62380000, 0x9d2c0000, 0xd78e0000, 0x3b570000, 0x46638000, 0x21cac000,
    0x22a82000, 0x38c57000, 0x171e2800, 0xdebe7400, 0xa6f3aa00, 0x1423b900,
    0x0a380680, 0x492c0d40, 0xbd8e06a0, 0x82570b90, 0xe3e38a58, 0x2f8ac0e4,
    0x0748225e, 0xb875780b, 0xd2c6245d, 0xee227709, 0x5b25a5dd, 0x78a8bfc8,
    0xf9ed89bd, 0xce9dc53b, 0x0ecbad94, 0xa00fb9b5, 0x90360565, 0xe83b089f,
    0x940d896a, 0x4a2dca2e, 0x6913ab60, 0x6d93bf72, 0x4a600ee9, 0xa7f00ded,
    0xadb80680, 0x2a6c0d40, 0x57ee06a0, 0xb5a70b90, 0x80000000, 0x40000000,
    0xe0000000, 0x70000000, 0xd8000000, 0xc4000000, 0xc6000000, 0xa1000000,
    0x6a800000, 0xb5c00000, 0xcae00000, 0x65700000, 0xec080000, 0x9a340000,
    0x43120000, 0x7d9b0000, 0xa6768000, 0xd188c000, 0xdc536000, 0xe2879000,
    0x79c96800, 0x80e89400, 0x6e4de600, 0xfd8b5300, 0xe6600b80, 0x31b00f40,
    0xac680fe0, 0x3a840150, 0xbdfa0748, 0x46df0d0c, 0xcf6c8666, 0x9727c71b,
    0x53b7e4c6, 0xfb5454a8, 0xc90c8e5f, 0xd697cc2d, 0x27dfee96, 0x05d05462,
    0xb2f68613, 0x3148cca9, 0x8233625e, 0x2737962e, 0x2ba16f95, 0xaf6c9ae2,
    0xa737e9d0, 0x6b945b8a, 0x4f6c81ac, 0xd727c2d4, 0xb3b7e800, 0x8b545400,
    0x110c8600, 0x1297c300, 0x80000000, 0xc0000000, 0xa0000000, 0x10000000,
    0xb8000000, 0x14000000, 0x56000000, 0x29000000, 0x7d800000, 0xd6400000,
    0xe1600000, 0x69d00000, 0x88380000, 0x7c1c0000, 0x5a020000, 0x7b2f0000,
    0xbabe8000, 0x96dac000, 0x1ca0a000, 0x77d0b000, 0x7d1aa800, 0x4ba3bc00,
    0x4f462200, 0x34c67d00, 0x13800980, 0x2b400c40, 0x6ae004e0, 0x869002d0,
    0xacd80938, 0xd78c0eb4, 0x655a0cae, 0x47e30969, 0x1504814d, 0x47a9cc38,
    0x1d7c2335, 0xf3f576ee, 0x533c8e88, 0xd6b5c51e, 0x74fe25c1, 0x739a78a2,
    0x9b620e30, 0xc2ff07ea, 0x2a868d8f, 0xeec6c31b, 0xa8a2ae45, 0x31ffb966,
    0xec242014, 0x2239719c, 0xcf068000, 0xfc86c000, 0x07c2a000, 0x752fb000,
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x58000000, 0xf4000000,
    0x4e000000, 0x57000000, 0xbf800000, 0xd0c00000, 0xf5e00000, 0x4f500000,
    0xf5080000, 0xf2b40000, 0x66520000, 0xe5970000, 0x79c88000, 0x25434000,
    0xa425a000, 0xc6301000, 0xeb1fa800, 0x2d831c00, 0x65ed2e00, 0xa7735b00,
    0x393a0b80, 0x38b30440, 0x27728760, 0xf9304d30, 0x58b72a98, 0x5750573c,
    0xa1208846, 0xaca74089, 0x197fadf6, 0xf61311d2, 0x13052beb, 0xc99756c7,
    0x03e00449, 0x5c500d56, 0x3c8803c3, 0xf1740522, 0x3a320d51, 0xd907022a,
    0x88a082e5, 0x1f67439b, 0x7d1fa9bf, 0x4e831c84, 0xf46d2828, 0x50b353e5,
    0x2b5a0918, 0x53230f7c, 0x699a8126, 0x13d446b9, 0x80000000, 0x40000000,
    0x60000000, 0xf0000000, 0x68000000, 0x1c000000, 0x3a000000, 0x07000000,
    0xfc800000, 0xe6c00000, 0xd2600000, 0xf8b00000, 0xe8c80000, 0x93440000,
    0xc9160000, 0x9d950000, 0x476d8000, 0x3f094000, 0x58b3e000, 0x38d71000,
    0x6b5e6800, 0x4d1e5400, 0xd38d8e00, 0x66794b00, 0xfe9be080, 0x45e31ec0,
    0xf0e06d20, 0xa77f55b0, 0x8f3e0268, 0x50a1051c, 0xd4d3826e, 0x39684f27,
    0x5600668a, 0x150f570f, 0x87960675, 0xd0550af1, 0x5b8d8c09, 0xca7944ce,
    0xcc9be4d7, 0xaee31702, 0x5e606a83, 0x5abf53c1, 0x9bde02a2, 0x49d10df3,
    0x12fb8e8a, 0xb45c430f, 0xa5be6875, 0xe36e51f1, 0xe1258489, 0xe18d4e0e,
    0x8d45e7f7, 0x503219b2, 0x80000000, 0xc0000000, 0xe0000000, 0x10000000,
    0x28000000, 0x7c000000, 0x5e000000, 0x9d000000, 0xde800000, 0x7d400000,
    0xfbe00000, 0x02900000, 0x13480000, 0xbedc0000, 0x981e0000, 0x641d0000,
    0xfa348000, 0x873ec000, 0x4985e000, 0x1ce07000, 0x9b316800, 0xc79ebc00,
    0x49d48600, 0x29aecd00, 0xcccdec80, 0x533c76c0, 0xabaf6f60, 0x3fc3b210,
    0xc8800e08, 0x4c400304, 0xb3600ed6, 0x8ed0013d, 0x402809ea, 0x200c05d4,
    0xf03600bd, 0x381103a8, 0x54028474, 0x222fc9cf, 0xc30765b1, 0x438fb279,
    0xa3d60d9e, 0x86810c1b, 0xf94a850c, 0x11f3c1d1, 0xad9961ea, 0x26d2b9d4,
    0xfc0286bd, 0x9e2fcea8, 0x7d0768f4, 0xce8fbf0f, 0x55560ad1, 0x87c10069,
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x08000000, 0xac000000,
    0x12000000, 0x93000000, 0x39800000, 0x97400000, 0x82e00000, 0x47b00000,
    0x36480000, 0x38640000, 0x916e0000, 0x87c10000, 0x431b8000, 0x61b64000,
    0x2347a000, 0x44fa3000, 0x62bc2800, 0x22fc7400, 0x17b38e00, 0x2e624300,
    0xec61a680, 0x275f3dc0, 0xaac9a9a0, 0xfb8b37f0, 0x5c6facb8, 0x0f6e3344,
    0x16fa2536, 0x91a974cf, 0x6b6e04ea, 0x88c1070d, 0x009b8e4a, 0xb9f6467e,
    0x8227a731, 0xab0a3098, 0xfd9427f7, 0x596871ed, 0x0bf58bdb, 0x41374395,
    0x8abc27bd, 0xbefc7493, 0x6db38a6a, 0x61624ecd, 0xcfe1a9ea, 0x8f1f328e,
    0x03a9ad09, 0xb87b3e1c, 0xd147ab61, 0xe7fa32d2, 0x80000000, 0xc0000000,
    0x60000000, 0xd0000000, 0x28000000, 0x04000000, 0xee000000, 0xd3000000,
    0xe3800000, 0xfa400000, 0x65e00000, 0x9d900000, 0xa1680000, 0x324c0000,
    0x71ee0000, 0x3b830000, 0xa6668000, 0x17c94000, 0x5ca32000, 0x53def000,
    0x12a5a800, 0x30c7bc00, 0x090e8e00, 0xe6854100, 0x86cd2480, 0x461dfd40,
    0x17232460, 0x6d9ef170, 0xf945aed8, 0xae57b394, 0x63e684e6, 0x2a89473d,
    0x7cc32628, 0x330efa8d, 0xf3ada750, 0xb25bbe48, 0xb1e885fe, 0x5b9a4889,
    0x764da95c, 0x3fcbbc58, 0x58808bd6, 0xbdd64e04, 0xc1a3a00c, 0xd348b310,
    0xf36602a8, 0x835f07cd, 0x1b608330, 0xe7464f38, 0x254bab26, 0x1c44bb1d,
    0xc2e80dba, 0x080c0b65, 0x80000000, 0x40000000, 0x60000000, 0x50000000,
    0x68000000, 0x4c000000, 0x06000000, 0xf3000000, 0x25800000, 0xd2c00000,
    0x51600000, 0x00b00000, 0x2c480000, 0x8a2c0000, 0xd51e0000, 0xe6910000,
    0xcf468000, 0xa7874000, 0x1bf6a000, 0xd9c45000, 0x70f82800, 0xa86f1400,
    0xb0108e00, 0x783a4100, 0x442e2080, 0x1a1211c0, 0x9d280ee0, 0x9a9c0ff0,
    0xf1560438, 0x70bd071c, 0x745881ce, 0xfe1649e7, 0xf73027b2, 0x5f831799,
    0x1fee85cd, 0xa3db4fe7, 0xbdc0a2b3, 0x5ac9511a, 0x0d68a10f, 0x0e955f86,
    0xc35ea581, 0xc1985743, 0xb8ce2a22, 0x94621f91, 0xee00030a, 0xff000145,
    0x43800ae3, 0x71c009f0, 0x1ce00139, 0x9e70019f, 0x7b28050c, 0x799c0986,
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x08000000, 0x4c000000,
    0xb6000000, 0xf9000000, 0xb2800000, 0x93400000, 0x87e00000, 0x55900000,
    0xc4c80000, 0x88040000, 0x8c2e0000, 0x56290000, 0x89228000, 0xba91c000,
    0xdf41e000, 0x31c5f000, 0xacab6800, 0x76503c00, 0x1b448600, 0x0bfccb00,
    0x03ad6e80, 0x4ded33c0, 0x328003e0, 0x53400750, 0x67e00e48, 0x259001a4,
    0xccc803d6, 0xc40408ad, 0x3a2e0f52, 0xaf290249, 0x3ba28fa6, 0x29d1c4d6,
    0x58a1e82e, 0x6455fb92, 0x6863612a, 0xfe543c35, 0x976a89fc, 0x5dd5ca1b,
    0x8a8fed6c, 0xf77cffb3, 0xedc1ef9a, 0x6285f02d, 0xcb4b6f90, 0x53c03b2b,
    0xd78c8134, 0xcff8c47f, 0x39836b5a, 0xe2c43b4e, 0x80000000, 0x40000000,
    0x20000000, 0x90000000, 0x08000000, 0x64000000, 0xda000000, 0xc5000000,
    0x8b800000, 0x66c00000, 0x9f600000, 0x88b00000, 0x6e580000, 0xb10c0000,
    0x19b60000, 0xe7d30000, 0x5eeb8000, 0x2375c000, 0x1eb2a000, 0x8571d000,
    0x2d812800, 0x55c81400, 0x4fe58a00, 0xeadacd00, 0xd1572280, 0x2fab1f40,
    0xdcd60520, 0xea630e10, 0x9b338718, 0x64b9c33c, 0x9064a1ce, 0x8e12d8a7,
    0xc732aab3, 0x02b1dbcb, 0xc36125c6, 0xeeb81e01, 0x3d5d8703, 0xd1a6cf81,
    0xe3d92dc0, 0x34c41260, 0x7e538f30, 0xf909cb0a, 0x5dbcad26, 0xadded271,
    0x93e4a72b, 0xccd2d3b7, 0xa252ab28, 0xdf01d5b6, 0x2eb92028, 0x5d741c36,
    0x618b86e8, 0x7bc5c7d6, 0x80000000, 0xc0000000, 0x20000000, 0xf0000000,
    0xb8000000, 0xe4000000, 0x76000000, 0x87000000, 0x5f800000, 0x12c00000,
    0xf3600000, 0xfa900000, 0xe4780000, 0x0d140000, 0x7aa20000, 0x245f0000,
    0x2d388000, 0x8aa24000, 0x9c472000, 0xc912d000, 0xfc87a800, 0x1b649c00,
    0x96828a00, 0xee794300, 0xe825a980, 0x6c3b9140, 0x0a3a04e0, 0xe51b0a30,
    0x16828098, 0x2e79465c, 0xc825a14e, 0x9c3b90c5, 0xb23a0e11, 0x011b0b08,
    0x60828e15, 0xa9794cb8, 0x97a5a1cf, 0x8efb9b06, 0x415a0a30, 0xfb8b009a,
    0x84fa865e, 0xa46d414e, 0xed07a0c5, 0xaaa49612, 0x6c628f09, 0x71294014,
    0x18bda1bb, 0x6d7f954d, 0x118006c6, 0xb1c00712, 0xfae0018b, 0x9f5006d7,
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xe8000000, 0x54000000,
    0x4e000000, 0xfd000000, 0xbf800000, 0x57400000, 0x32e00000, 0x36b00000,
    0x16f80000, 0xd0b40000, 0x1fd60000, 0xd1270000, 0x5daa8000, 0x087ec000,
    0x7259a000, 0xd163b000, 0x2beb2800, 0x8f197400, 0x189c8200, 0xfbe9cb00,
    0xd70b2480, 0x04a97a40, 0x11e48260, 0x8c1dce90, 0x123d2518, 0xb73e75a4,
    0x14b60e56, 0xa9d7075f, 0xc0328ca1, 0xe03aceb0, 0x5017a5ea, 0x1800b02d,
    0xbc0fabe9, 0x1a04b52e, 0xb321aa68, 0x4297beee, 0xe8dd2bc8, 0x658e75de,
    0x044e0fe2, 0x20630b53, 0xc66481b9, 0xcf5dcf14, 0xcedd29bc, 0x8c8e7c72,
    0x55ce03c8, 0x7a2301de, 0xa3048de2, 0xfaadc053, 0x80000000, 0xc0000000,
    0x60000000, 0x50000000, 0x98000000, 0xb4000000, 0x7a000000, 0x97000000,
    0x63800000, 0xf5400000, 0x70e00000, 0xd4900000, 0x66e80000, 0x2dac0000,
    0xd8420000, 0xe4730000, 0x12778000, 0x7b554000, 0x3dcc2000, 0x10013000,
    0x3833a800, 0x84287c00, 0xb2358e00, 0xbb264900, 0xadbbaf80, 0x18547e40,
    0x847f8620, 0x42694e30, 0xe3662798, 0x89de3324, 0x6a0620b6, 0xaf0e355d,
    0xe78e28c0, 0x47723fe3, 0xcbc42a52, 0x793d3189, 0x7e99ab8d, 0xa9f77f8b,
    0x9a00028d, 0x0700000b, 0x9b8004cd, 0x11400228, 0x92e000ff, 0xf79006b2,
    0x7f680f58, 0x4fec0cc7, 0xcb220ae4, 0xc5a304d4, 0x047f834d, 0x82694068,
    0x836628df, 0xd9de3182, 0x80000000, 0xc0000000, 0xa0000000, 0xd0000000,
    0x48000000, 0xf4000000, 0xd6000000, 0x8d000000, 0x46800000, 0x00400000,
    0x3be00000, 0x25100000, 0x02980000, 0xee5c0000, 0xdac60000, 0x09bf0000,
    0xadd08000, 0xc82ac000, 0x3424e000, 0x7616b000, 0x5d326800, 0x0e837c00,
    0xf4460200, 0xedff0100, 0xa8308e80, 0x443ac240, 0xee3ce9e0, 0xe10ab790,
    0x2c946108, 0xaf6c74d4, 0x266e85d6, 0xeed9c355, 0x7faa6d17, 0xf0df7ef4,
    0xc6800c65, 0xc04005ee, 0x9be00479, 0xf51009cd, 0x4a980ac9, 0x1a5c06f6,
    0x0cc60866, 0x84bf03ed, 0xeb50837a, 0xc86ac04d, 0x0fc4e108, 0x5306b4d4,
    0x5faa65d6, 0xe0df7355, 0x2e800517, 0xe44002f4, 0x05e00e65, 0x8c1004ee,
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xd8000000, 0x64000000,
    0xaa000000, 0x69000000, 0x9a800000, 0xf4c00000, 0x9f600000, 0x75100000,
    0x24b80000, 0xcfe40000, 0xb8fa0000, 0x697f0000, 0x422b8000, 0x1524c000,
    0x74aee000, 0x87d89000, 0xb4ff6800, 0x7f435c00, 0xe51a0a00, 0x4caf0700,
    0x73f38f80, 0x76d0cd40, 0xaa6ce720, 0xb18390d0, 0x7b4eeb08, 0x1f0895dc,
    0x6da76a5e, 0xe5775f1d, 0x94380c3d, 0x92240aef, 0x9d1a0ce4, 0x58af01b9,
    0x21f38125, 0xcbd0c859, 0x42ece996, 0x484397a2, 0xd4aee610, 0xf7d8976a,
    0x4cff6f2c, 0xab435906, 0x971a0308, 0x41af09dc, 0x4373805e, 0xeb10c81d,
    0xaf8cebbd, 0x30539baf, 0xc096e1c4, 0xa5fc9669, 0x80000000, 0xc0000000,
    0x60000000, 0xb0000000, 0x98000000, 0x1c000000, 0xe6000000, 0xdf000000,
    0xae800000, 0x0ac00000, 0x7f600000, 0xe1100000, 0xcda80000, 0x92740000,
    0x82aa0000, 0xb4d10000, 0xdc468000, 0x19b24000, 0x80526000, 0x5fba1000,
    0x8f5ee800, 0xd9095c00, 0x01820e00, 0x5c650700, 0xd98c8f80, 0xe0734ac0,
    0xefbce7e0, 0x177c5c30, 0xc5268c88, 0xe7a2415c, 0x837a6b1e, 0x770e15bd,
    0xea94eaac, 0x90c85af6, 0xf66c8490, 0x08a3489a, 0x75f4e086, 0x01d850ba,
    0xc3c48dd7, 0x36d74a41, 0x895eeea2, 0x76095710, 0x57020c59, 0xfaa50066,
    0xd8ec8308, 0xc2634b9c, 0x6a94ecfe, 0x50c8598d, 0x966c8e24, 0xb8a347aa,
    0xedf4e18e, 0x1dd85a27, 0x80000000, 0x40000000, 0xe0000000, 0x90000000,
    0xa8000000, 0x9c000000, 0xf6000000, 0x15000000, 0x89800000, 0xe7c00000,
    0x75600000, 0x9a300000, 0x9b280000, 0x489c0000, 0x944e0000, 0xd9ad0000,
    0xefca8000, 0x9960c000, 0x54332000, 0xba199000, 0xab1fa800, 0x90885400,
    0x30480600, 0x1bac0d00, 0x90e60480, 0xf3f100c0, 0x2f6485e0, 0xa13dc890,
    0xa3b1a7f8, 0xe4d55f2c, 0x79ca87ce, 0x5c60c3df, 0x95b320e4, 0x51d9942a,
    0x807fa276, 0x83b854d3, 0xd4e00ed8, 0xa1f0085c, 0xf84807a7, 0x57ac0c8b,
    0x2ee60d44, 0xeaf1039a, 0xf8e487ff, 0xcffdc317, 0xa951ac80, 0x8c2554c0,
    0x1e0283e0, 0x690cc590, 0xefb52378, 0x5ad89fec, 0x60d3222e, 0x8be99b4f,
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x78000000, 0xa4000000,
    0x5e000000, 0xf3000000, 0x97800000, 0x6d400000, 0x4be00000, 0x18300000,
    0x34280000, 0xc60c0000, 0x872a0000, 0xb1b70000, 0x3a7e8000, 0x824b4000,
    0x86692000, 0xe876b000, 0xb375a800, 0xf8f6f400, 0x6f800600, 0x89400900,
    0xf5e00980, 0x3b300740, 0xdba80260, 0x0f4c0570, 0x92ca0c98, 0x5a8709e4,
    0x99d68dc6, 0x29074757, 0x4aa327fc, 0x41f1bde3, 0xbd232330, 0xbcb1b37b,
    0x6ec32dd5, 0xd081ba3f, 0x7ceb2a41, 0x418db5e3, 0x32412731, 0x6e7abd78,
    0xd45fa0d7, 0x9941fdbf, 0x2dfe8000, 0xaf0b4000, 0x2d892000, 0x2046b000,
    0xff5da800, 0x9afaf400, 0xb6aa0600, 0xcbf70900, 0x80000000, 0x40000000,
    0x20000000, 0x70000000, 0x38000000, 0x0c000000, 0x1e000000, 0x63000000,
    0xcc800000, 0xb3c00000, 0xc6600000, 0xb0300000, 0x58180000, 0x5c140000,
    0x56120000, 0x570d0000, 0xde848000, 0xcedf4000, 0x69cbe000, 0xcf6fd000,
    0x2da56800, 0x2a599400, 0xbe000a00, 0x53000300, 0xd4800180, 0xcfc007c0,
    0xe0600260, 0xdf3006f0, 0x8a980d28, 0x8cd40d0c, 0x5cf200ae, 0x54fd003f,
    0x40fc89e7, 0x22fb4ec2, 0x67c1e0e0, 0xc476d0b1, 0xa533e089, 0xb38bdd9d,
    0x094f6174, 0x52b0931b, 0x90ee8dc6, 0x2af64d93, 0x73c5695a, 0xa6699665,
    0xe0180000, 0x10140000, 0x68120000, 0x440d0000, 0x2a048000, 0x711f4000,
    0xb1abe000, 0x1c5fd000, 0x80000000, 0xc0000000, 0x60000000, 0xf0000000,
    0xd8000000, 0xc4000000, 0xe2000000, 0x7b000000, 0x38800000, 0x10c00000,
    0x3aa00000, 0xe0100000, 0x30180000, 0xb80c0000, 0x341e0000, 0x3a1b0000,
    0xbf188000, 0xda9c4000, 0x6bcf6000, 0x02271000, 0xf0d21800, 0x0abf5400,
    0x58000200, 0x04000300, 0x82000180, 0x8b0003c0, 0xe0800360, 0xd4c00310,
    0xd8a00388, 0x9b1001ec, 0x089800e2, 0xa8cc0043, 0x0ebe00ea, 0xda0b0380,
    0x8f0080c0, 0x629042e0, 0x5fd160d0, 0x383c10e8, 0x4fca9afc, 0xd023176a,
    0x33cf63af, 0x06271308, 0x72d21a43, 0x81bf57ea, 0xb8800000, 0xd0c00000,
    0x5aa00000, 0x10100000, 0xe8180000, 0x7c0c0000, 0xd61e0000, 0x411b0000,
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x18000000, 0x5c000000,
    0xae000000, 0xa9000000, 0x3b800000, 0x78c00000, 0x18e00000, 0xb8100000,
    0xcc180000, 0xe61c0000, 0x5d160000, 0xd1830000, 0x23cb8000, 0x2475c000,
    0x52452000, 0x97bf7000, 0x3e231800, 0x31fd1c00, 0x43800200, 0x54c00300,
    0x4ee00380, 0xfd1002c0, 0x41980060, 0x6bdc0170, 0xd07602b8, 0xb85302a4,
    0xccb380ee, 0x02b9c1e3, 0xdbab2063, 0x183072e0, 0x8ce69b30, 0x2217df98,
    0x6f18a374, 0x3689b046, 0x014dbb0f, 0x7f27ae51, 0x6e7e3b29, 0x995e6c2e,
    0xe3351bc0, 0x207e1fa3, 0x804b8000, 0xc0b5c000, 0x04a52000, 0x36af7000,
    0xd1bb1800, 0xf3211c00, 0xa8760200, 0x94530300, 0x80000000, 0x40000000,
    0xa0000000, 0xf0000000, 0x38000000, 0x44000000, 0xda000000, 0xe5000000,
    0x59800000, 0x35400000, 0x5ca00000, 0x74100000, 0x02080000, 0xf1140000,
    0x4b9e0000, 0xac470000, 0x9b288000, 0x7e4b4000, 0xe234a000, 0xe9cf3000,
    0x2070a800, 0x75e89400, 0xa6a00200, 0x21100100, 0xc3880280, 0x705403c0,
    0xf53e00e0, 0x79570110, 0x1aa08368, 0x5f1f4394, 0xac8aa166, 0x04d830d5,
    0xe5f02972, 0x8ea7d5d0, 0x0d02a208, 0x958c32c4, 0x334e2bae, 0xd7b0d571,
    0x2a82208c, 0xcfc371e9, 0x1b6c8a60, 0xb36ce7f3, 0xdf640b07, 0x2977a512,
    0x9a78a800, 0x80fc9400, 0x973e0200, 0x98570100, 0x39208280, 0x7f5f43c0,
    0x91aaa0e0, 0x01883110, 0x80000000, 0x40000000, 0xa0000000, 0xd0000000,
    0x58000000, 0x44000000, 0x32000000, 0x87000000, 0xc9800000, 0x8b400000,
    0xb3200000, 0xb4100000, 0xfa080000, 0x3b140000, 0x6f9a0000, 0x664b0000,
    0xb9a88000, 0xc4d64000, 0x4578e000, 0xf5bd3000, 0xaad36800, 0x14616400,
    0x59200200, 0x37100100, 0xa1880280, 0xe7540340, 0x4d3a0160, 0x1d1b0110,
    0xc28080c8, 0xccd2421c, 0x196ae326, 0x23a2322d, 0xcfc1eacc, 0x02ec26d0,
    0x5ff861e8, 0x3d6f71ec, 0x21b98b3e, 0x60c356d9, 0x0761e986, 0xfabc2703,
    0x7f50615d, 0xe92b738a, 0x5f0b8a6d, 0xcd8c542c, 0x195b6800, 0xe4356400,
    0x259a0200, 0x354b0100, 0xba288280, 0x5c964340, 0x55d8e160, 0x09ed3110,
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x08000000, 0xf4000000,
    0x86000000, 0xd7000000, 0x5e800000, 0xec400000, 0x9b600000, 0xe6100000,
    0x27180000, 0x66840000, 0x00420000, 0xe1610000, 0x430e8000, 0x2888c000,
    0x035ee000, 0x29e9d000, 0x704c8800, 0x1975ec00, 0x8f180200, 0x42840300,
    0xae420080, 0xd2610040, 0x938e8020, 0xe7c8c3d0, 0x40bee218, 0xf4b9d35c,
    0x92b4897a, 0x75a1efb1, 0x3322006d, 0x23710098, 0xca16801c, 0x7d0cc1da,
    0xd39ce021, 0x07c8d055, 0x70a20b14, 0xecad2ffe, 0x6ebee377, 0x07b9d016,
    0x62348b2c, 0xaae1efbd, 0x78c20080, 0x0a210040, 0xaeee8020, 0xc6d8c3d0,
    0x3126e218, 0x8a7dd35c, 0x8f96897a, 0xa5d0efb1, 0x80000000, 0x40000000,
    0xe0000000, 0xd0000000, 0x88000000, 0x84000000, 0x12000000, 0xdd000000,
    0xd6800000, 0x36400000, 0xd1e00000, 0x56100000, 0x6f080000, 0x3b9c0000,
    0xb8da0000, 0xebb10000, 0x11e08000, 0xf61a4000, 0x5f0fa000, 0x639cd000,
    0xb4cdc800, 0x7dbbbc00, 0xdee80200, 0xfd8c0100, 0xbfd20380, 0x842d0340,
    0x333a8220, 0x44ab4210, 0x8a6f2048, 0x7ec69374, 0xeca26b5a, 0x7e776cd9,
    0xd4cdc947, 0xedbbbc58, 0xb6e8003c, 0xa98c02ae, 0x25d20343, 0xdd2d02fe,
    0xf7ba822f, 0xafeb42bc, 0x8d0f226e, 0x1e969223, 0x524a6ace, 0x13fb6c77,
    0x031fcb80, 0x3d96bf40, 0x1fd28020, 0xb4274310, 0x6b3d23c8, 0x48ab9034,
    0x1c78e97a, 0xb1cc2ec9, 0x80000000, 0x40000000, 0x60000000, 0xb0000000,
    0xd8000000, 0x0c000000, 0x1e000000, 0x5d000000, 0x2e800000, 0xd8400000,
    0x83200000, 0xf2100000, 0xb3080000, 0xcb8c0000, 0x4ad60000, 0x9d7b0000,
    0x20318000, 0x719bc000, 0xfdcfa000, 0x2cffd000, 0xfde60800, 0x8d72e400,
    0x68280200, 0x759c0100, 0x87de0180, 0xbbf702c0, 0x9c678360, 0x38a0c030,
    0x40de2078, 0xf2741174, 0x9da1a8ba, 0xb2413761, 0x5c38080c, 0x9785e6c8,
    0x7ccf814c, 0x747cc0ee, 0xaca023cb, 0x32d31085, 0x016e2b98, 0x363df482,
    0x48982935, 0x1956f7a6, 0xbba1aac1, 0x1341355c, 0xd4b80980, 0xaec5e6c0,
    0x176f8160, 0x0f2cc130, 0xac0821f8, 0x8e0f13b4, 0x55102bda, 0x4a9af751,
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xc8000000, 0xa4000000,
    0xf2000000, 0x23000000, 0xba800000, 0x5ec00000, 0xc1600000, 0x1e100000,
    0xb5180000, 0x8b9c0000, 0xb74e0000, 0xed390000, 0x25a48000, 0x98764000,
    0x03906000, 0x335d5000, 0x8f20d800, 0xbeabac00, 0x4ef80200, 0x0b4c0300,
    0x23360380, 0x08b501c0, 0xeff28320, 0x5ad34290, 0x637ae3c8, 0x6512108c,
    0x13943aea, 0x4b40bd7b, 0x0328b905, 0x98aaff78, 0x57f6db54, 0x36ceacee,
    0x3572807d, 0xb41343e4, 0x8a1ae3fe, 0xaf0211bd, 0x9c8c3a0c, 0x47dcbfaa,
    0xfce6ba1b, 0x0853fc75, 0x09b25b80, 0xee68edc0, 0x429ae120, 0x12c21190,
    0x076c3848, 0x770cbd4c, 0x409ebbca, 0x39dffceb, 0x80000000, 0xc0000000,
    0x60000000, 0x90000000, 0x58000000, 0x8c000000, 0x5a000000, 0xcd000000,
    0x78800000, 0x02400000, 0x07600000, 0x5e100000, 0xe3180000, 0x938c0000,
    0x25d20000, 0x64ab0000, 0xf5a18000, 0x2f234000, 0x9c7da000, 0x71991000,
    0x34cd4800, 0x7e246c00, 0x26f80200, 0x52dc0300, 0x812a0180, 0xb7770240,
    0x360b8160, 0xc7144230, 0x8d962168, 0x66dd5334, 0x072369e2, 0x18653c09,
    0x9f916a1d, 0xbfde3e78, 0xc9a8e80c, 0x1d317f0e, 0x75674a77, 0x17136ee2,
    0x7593805e, 0x1ad840f8, 0x9524221b, 0x0166528b, 0x311ae924, 0x2a8a7d8d,
    0x7b5ec980, 0x39fc2e40, 0x935c2360, 0xddfa5130, 0xed50e8e8, 0x0eed7d74,
    0xd6cd4a82, 0x6f246d39, 0x80000000, 0xc0000000, 0x20000000, 0x70000000,
    0x18000000, 0xcc000000, 0x0e000000, 0xb1000000, 0x1a800000, 0xf3c00000,
    0x0b200000, 0x61100000, 0xb2980000, 0x07c40000, 0xb92e0000, 0xc6130000,
    0xd5018000, 0xe085c000, 0xf0d82000, 0xb6a05000, 0xf557f800, 0x5ef8a400,
    0x2f2e0200, 0x7b130300, 0xe1818080, 0xd245c1c0, 0xf9782060, 0xe8705330,
    0x42eff838, 0x892ca6c4, 0x3e18026a, 0x490400cf, 0x868e00ac, 0x95c30044,
    0x6e3982aa, 0xb991c32f, 0xfe4e22dc, 0xa76751dc, 0x31607b3e, 0x8c6a644d,
    0xb8f9a1ef, 0x8a35905e, 0x8397d99f, 0xdd5cf4a4, 0x6af7f838, 0xbd28a6c4,
    0xac16026a, 0x9e0700cf, 0xf91780ac, 0xbe82c044, 0x29cfa2aa, 0x7822932f,
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xd8000000, 0x04000000,
    0xe2000000, 0xe7000000, 0x95800000, 0xbdc00000, 0x6ba00000, 0xdf100000,
    0x81880000, 0xe7cc0000, 0xd8aa0000, 0x708b0000, 0xdf488000, 0xfbf04000,
    0x5d66e000, 0x0f31b000, 0x5a433800, 0xc97f3400, 0x152a0200, 0x894b0100,
    0x36e88180, 0x93e04140, 0x916ee360, 0x513db010, 0x0b493b88, 0x81e4379c,
    0xde6a8056, 0x28b743f7, 0xd884602e, 0x334af23c, 0x95ed5966, 0x847ec78f,
    0x9bafdaea, 0x7715875e, 0x6d89baab, 0x89d87558, 0x01a6603b, 0xe40df310,
    0xf20fda07, 0x5f058676, 0xc181bb88, 0x87d4779c, 0x88ac6056, 0xa896f3f7,
    0xdb4f582e, 0x19f9c63c, 0xba6d5b66, 0x9abec68f, 0x80000000, 0xc0000000,
    0x60000000, 0xf0000000, 0xc8000000, 0x74000000, 0x0a000000, 0xff000000,
    0x45800000, 0xdec00000, 0xfde00000, 0xe7100000, 0xa9980000, 0xf8cc0000,
    0x44fe0000, 0xeb890000, 0xb3d68000, 0x6b6d4000, 0x3a51e000, 0xc3a9b000,
    0x26a95800, 0x6428fc00, 0x237e0200, 0x8e490300, 0xa9b68180, 0x29bd43c0,
    0xe9a9e320, 0x89b5b1d0, 0x79af5828, 0xb1bdfffc, 0xc5ae8316, 0xcfb1407b,
    0x30b7e277, 0x752cb05c, 0xabe1d986, 0x561cbe33, 0xb101633b, 0x1891f352,
    0xe0483a59, 0xa4a90d16, 0x4f2e3a3e, 0xfcec0e42, 0x9786b994, 0xadc84d4f,
    0x6e61d828, 0x48dcbffc, 0x2ce16316, 0x0f81f07b, 0x81d03a77, 0x28650c5c,
    0x01d03b86, 0xe8650d33, 0x80000000, 0xc0000000, 0x20000000, 0x10000000,
    0x68000000, 0x24000000, 0xda000000, 0xc1000000, 0xd1800000, 0x17c00000,
    0x02200000, 0x75100000, 0xa3980000, 0xd2c40000, 0x19a20000, 0xcbdd0000,
    0x543c8000, 0x6a0f4000, 0x79022000, 0xbd933000, 0xf9c47800, 0x71360400,
    0x41820200, 0xbfcd0300, 0x06248080, 0xbf0b4040, 0x0a8021a0, 0x275e3090,
    0xd460fb68, 0x08fd4704, 0xf0a22146, 0xde43335f, 0xa9fc7888, 0xd1220594,
    0x9198012e, 0xf7c400db, 0x3222038e, 0x0d1d006b, 0xef9c83b6, 0x2cdf4167,
    0x02ba2284, 0xdb473026, 0x927e7a2f, 0x7fef06d0, 0x0e3c8368, 0x6b0f4304,
    0x88822346, 0xba53305f, 0x93e47808, 0x202605d4, 0x381a008e, 0xac09004b,
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x18000000, 0x1c000000,
    0x3a000000, 0x29000000, 0x43800000, 0xd1c00000, 0x6c600000, 0xad100000,
    0x25880000, 0x22dc0000, 0x96f20000, 0x27530000, 0x842b8000, 0xd9ab4000,
    0x376f2000, 0x638f7000, 0xe1dfb800, 0x0467cc00, 0x39120200, 0x1b830100,
    0x2dc38380, 0xc6674240, 0x9c152060, 0x7a007070, 0xc90638e8, 0xd39f8ca4,
    0xc9d6a30e, 0x70673247, 0x97131a31, 0x0c9ffcf4, 0x61509af6, 0x4738bdfb,
    0x4b25bb33, 0x2928cf79, 0xfc2b82fe, 0x15ab4311, 0xf56f2264, 0xc68f71ae,
    0x805fba97, 0xe0a7cf09, 0x2cf200e8, 0x4e5300a4, 0x27ab810e, 0x986b4347,
    0x430f21b1, 0xd29f72b4, 0xfe57b896, 0x0fbbcc8b, 0x80000000, 0x40000000,
    0xe0000000, 0x90000000, 0xc8000000, 0xc4000000, 0xf6000000, 0xd9000000,
    0x38800000, 0xe3400000, 0x1ae00000, 0x9f100000, 0x19880000, 0xa7dc0000,
    0x93b20000, 0xa6e90000, 0x55008000, 0x4a8ac000, 0x2c552000, 0x6b6c1000,
    0x8ccde800, 0x242d1c00, 0xd43a0200, 0xcc350100, 0x20328380, 0x8223c240,
    0x6535a320, 0x40b6d310, 0x6d70cbd8, 0x4dcd0f64, 0xf0adeae2, 0x957d1e8d,
    0x31d201eb, 0x9ab9013c, 0xb66880c6, 0xe246c3cf, 0x6e6f22b6, 0xae5912ef,
    0xbc7f6a6e, 0x114eddc3, 0x95efa238, 0x0e93d15c, 0x9a4a49be, 0x5272ce33,
    0x244a4858, 0x0f72cd24, 0x0aca49c2, 0xa532cd9d, 0xe0aa4a33, 0x1d62ce58,
    0x15c24a24, 0xfcaecd42, 0x80000000, 0x40000000, 0xe0000000, 0x30000000,
    0xb8000000, 0x3c000000, 0x56000000, 0x85000000, 0x6c800000, 0x51c00000,
    0x70a00000, 0xeb100000, 0x95880000, 0x8b5c0000, 0x94660000, 0x4f270000,
    0x135f8000, 0x387ec000, 0x713aa000, 0x22449000, 0x86eeb800, 0xcfe95400,
    0xed6e0200, 0xd5bb0100, 0x17998380, 0xac49c0c0, 0x4fed22e0, 0xad6650f0,
    0x35b21958, 0x278ac614, 0x145f3bb2, 0x73ec9447, 0xfb6d2042, 0xb0a6526c,
    0x4b121b36, 0x459ac61d, 0x03573be9, 0x107096d8, 0x252b2127, 0xc0515272,
    0xd1e598d4, 0x4c680652, 0x03239837, 0x1d5f055a, 0xb1741ad8, 0xf3bdc6d4,
    0xca88b952, 0xccce54b7, 0xf031811a, 0x64c5c078, 0xe4232284, 0x66cd535a,
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x68000000, 0xd4000000,
    0x7e000000, 0x7b000000, 0xee800000, 0xb1c00000, 0xad600000, 0x51100000,
    0xab880000, 0x444c0000, 0xc2260000, 0x25bd0000, 0x83e28000, 0xc0dbc000,
    0x56ed6000, 0x4d4ad000, 0xd5afb800, 0xcbf1ec00, 0x44ce0200, 0x70e10100,
    0x8a4c8180, 0x912ac0c0, 0x7f29e1a0, 0x7c2c1350, 0x7ea059f8, 0x3d60fdec,
    0x290cd9ba, 0x479a3fc7, 0xb64d3935, 0x7b2a2c84, 0x1a23608e, 0xd9abd381,
    0x49e33ad0, 0xf5db2eea, 0xab67e3ed, 0xc60d1278, 0xb70cd82c, 0x4c9a3f9a,
    0x50cd3b57, 0x2eea2fed, 0xa1436078, 0x27bbd12c, 0x72eb3a1a, 0x7b572d97,
    0x2aa1e14d, 0x036011a8, 0x32065894, 0x991dff16, 0x80000000, 0x40000000,
    0x60000000, 0xf0000000, 0x38000000, 0x74000000, 0x96000000, 0x77000000,
    0x5a800000, 0xef400000, 0x1ee00000, 0x35100000, 0x6b880000, 0x6acc0000,
    0x173e0000, 0x1eb70000, 0xd5768000, 0x8fc6c000, 0xd4b4e000, 0xc86e5000,
    0x18526800, 0x047c9c00, 0xba560200, 0x856b0100, 0x67c08180, 0x08bdc3c0,
    0xe27c60e0, 0xb55f91d0, 0xcbf00a58, 0xee840ddc, 0x59588b6a, 0xf9e5cebd,
    0xa792ebfb, 0xc8c15e14, 0x962a62ce, 0xc33492bb, 0x58b08b64, 0x0a79cfb6,
    0x6944ea87, 0xe1ea5c8e, 0x438ae39b, 0x96d95354, 0xad24e9be, 0x7bba5cc3,
    0x56e2e3d8, 0x3905521c, 0xe992e98a, 0x7bc15e6d, 0x02aa6023, 0xdf749008,
    0xb2d08944, 0xd329cdd6, 0x80000000, 0x40000000, 0x20000000, 0xb0000000,
    0xd8000000, 0x64000000, 0xda000000, 0x97000000, 0x85800000, 0x18c00000,
    0xb6a00000, 0x59100000, 0x70880000, 0xfe440000, 0x99f60000, 0xdc6b0000,
    0xa4b48000, 0x82074000, 0xb308e000, 0x7f99b000, 0x3fc29800, 0xeb3a1400,
    0x25de0200, 0x1c3f0100, 0x304a8080, 0x6ce842c0, 0x3aea6360, 0x8be5f190,
    0x0776fb68, 0x6720e65c, 0x03c27816, 0x1527a563, 0x48ca985a, 0xbebe16a4,
    0x75080022, 0xa68401a9, 0x0f5602ef, 0x357b027d, 0x0c3c808c, 0x184341a7,
    0xf0fee168, 0x34f2b2a5, 0x1ef619f1, 0x71fd5552, 0x2076e3e8, 0x3ab6b09c,
    0x7f001976, 0x799655f3, 0x86c263b2, 0x4bb1f238, 0x9388fb54, 0x89cfe55a,
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x28000000, 0x14000000,
    0x6a000000, 0x91000000, 0x05800000, 0xb5400000, 0xbba00000, 0xa7100000,
    0xda980000, 0x83dc0000, 0x7e7e0000, 0xee750000, 0xf66a8000, 0x2a794000,
    0xa4782000, 0x776fb000, 0xf7fb2800, 0x2d37b400, 0xb2c60200, 0xabf90300,
    0x632c8380, 0x81c043c0, 0xdb74a0a0, 0x91fff050, 0x0a3789a8, 0xa8444644,
    0xc8378a16, 0xed4445d5, 0x47b78b6e, 0x3904465c, 0xd1978a4a, 0x3f54469f,
    0xdaaf8971, 0x8a98456d, 0x7bc98b47, 0x527144a8, 0x487d08e1, 0x316d0740,
    0xc0f7aac5, 0xefa7f426, 0xed0aa228, 0x5b8af184, 0x5e5d08b6, 0xf73d0685,
    0x2bcfa946, 0xaa6bf7d8, 0x646ca2fc, 0x9763f01a, 0x80000000, 0xc0000000,
    0xe0000000, 0x10000000, 0x48000000, 0xac000000, 0x8e000000, 0xe5000000,
    0x4e800000, 0x97c00000, 0xe5600000, 0x3e900000, 0x0fd80000, 0xe17c0000,
    0x0c920000, 0x2cd10000, 0xe6e98000, 0x5bc3c000, 0xbb6da000, 0x73905000,
    0xfd593800, 0xb0b50c00, 0xa0e98200, 0xd2c3c300, 0x9beda380, 0x11505040,
    0x1eb93920, 0xb5e50eb0, 0xc4518038, 0xe82fc094, 0xd627a2ba, 0x4b3d521f,
    0x11a2bab5, 0xfc67ce4a, 0x960da007, 0x21005311, 0x9c813a88, 0xa4c90eac,
    0xaafb832e, 0xc5d2c025, 0x1664236a, 0x9103919f, 0xe48c9bdd, 0xb0c95e9e,
    0xd0fabab5, 0x4adbce4a, 0x9fffa007, 0x23415311, 0x3db0ba88, 0xb276ceac,
    0x9304232e, 0x7f939025, 0x80000000, 0xc0000000, 0x60000000, 0xd0000000,
    0xc8000000, 0x04000000, 0x0a000000, 0x1b000000, 0xeb800000, 0x57400000,
    0x0fe00000, 0x63900000, 0xf3580000, 0xb5ec0000, 0x608a0000, 0xd4c10000,
    0xecac8000, 0x7e6b4000, 0x47d26000, 0xa329f000, 0x932da800, 0x4b299c00,
    0xe72c8200, 0x392b4300, 0xe0326180, 0x14b9f340, 0xa275ab20, 0xe1c59c10,
    0x66268228, 0xa1aa436c, 0xe8fee22e, 0x5e02b21d, 0x191fcb1f, 0x94906d9e,
    0x66d929e5, 0x8baeddbb, 0x83f4e1ac, 0xcd83b24e, 0x5253492d, 0x5d6b2f27,
    0x10534bda, 0x826b2f27, 0x91d34bc8, 0x1e2b2f0e, 0xbdb34b1f, 0x2efb2d9e,
    0x4b0b49e5, 0xe3872dbb, 0x335949ac, 0xd5ea2e4e, 0xb09fcb2d, 0x1cd06c27,
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xb8000000, 0x94000000,
    0x12000000, 0xdd000000, 0x86800000, 0xe0400000, 0xd2a00000, 0xb2900000,
    0xa2480000, 0x97a40000, 0xb0120000, 0xe81f0000, 0x0c168000, 0x96004000,
    0x770ca000, 0xcf825000, 0x74de4800, 0xefe1f400, 0xe6b68200, 0xf0904100,
    0xe744a080, 0x95265040, 0xfa4c4ae0, 0x73bef650, 0x2a000248, 0x09000274,
    0xb480029a, 0x2d4003c1, 0xec2001aa, 0xc6d0009a, 0x62e802c1, 0xf834012a,
    0x94da00da, 0x9ffb0021, 0x6ea4837a, 0xcc8f4092, 0xd9522355, 0xce261160,
    0xb3c0eb13, 0xc87ca41f, 0x9e7e49aa, 0x8971f49a, 0x76fe80c1, 0xaa34402a,
    0x69d6a05a, 0x09795061, 0x36fac99a, 0x8a2eb6c2, 0x80000000, 0x40000000,
    0x60000000, 0x30000000, 0xf8000000, 0x74000000, 0x66000000, 0x13000000,
    0x9b800000, 0x8a400000, 0xf6200000, 0x5f900000, 0x54480000, 0xf12c0000,
    0x92160000, 0x35170000, 0xe8828000, 0x21cac000, 0x847d6000, 0xddadf000,
    0x6dc58800, 0xb678a400, 0xf8a28200, 0x2d5ac100, 0x2bb56180, 0x96c1f0c0,
    0xf1f38be0, 0xa8ffa5d0, 0x22680398, 0xeebc014c, 0xa65e03ee, 0xf43b02e9,
    0x82948038, 0x60ddc0ae, 0x0affe0c9, 0xef673388, 0x7238e826, 0xe19556fd,
    0x63470a7a, 0xc4b264f9, 0x875fe0c0, 0x4ab73172, 0x4850e99f, 0x0b29571d,
    0x3b190838, 0x678964ae, 0x004b62c9, 0xc72af288, 0x490f09a6, 0x229e663d,
    0x70c9e19a, 0xa2e03129, 0x80000000, 0xc0000000, 0xe0000000, 0x50000000,
    0x28000000, 0xdc000000, 0x22000000, 0x27000000, 0xed800000, 0xa7c00000,
    0xbf200000, 0x09900000, 0x51d80000, 0xd63c0000, 0x991a0000, 0xc89d0000,
    0xdd478000, 0x8d6e4000, 0xe571e000, 0x196e3000, 0x8b64b800, 0xd46d0400,
    0xcde78200, 0x943e4300, 0x2e09e380, 0xed023140, 0xf686b8a0, 0x385c0770,
    0x17e20288, 0x8731039c, 0xdd858036, 0x1fcf43df, 0xab2c625c, 0xa79d7356,
    0x7cd2d9cf, 0xc0ad77c4, 0xf152dbd2, 0xf76d76bd, 0x8672d809, 0x72fd7453,
    0xddaadbf2, 0x5fc1760d, 0x8b30d9e1, 0x179c75df, 0x04d75a5c, 0x34a23756,
    0x0f5ebbcf, 0xf26004c4, 0x4cf80052, 0x38ac03fd, 0xc54202a9, 0xe9610023,
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x08000000, 0x8c000000,
    0x5e000000, 0x1b000000, 0xda800000, 0x62c00000, 0xcc600000, 0x2e900000,
    0xe8c80000, 0xed7c0000, 0x2d120000, 0x1d890000, 0x0e4d8000, 0x29a9c000,
    0x6e726000, 0x3392d000, 0x4d539800, 0x9724ec00, 0xcead8200, 0xb2f9c100,
    0x2e5a6380, 0x99bed040, 0x96699820, 0xa781ee30, 0x975a0378, 0x5e35016c,
    0x513f80ea, 0x11b0c1cb, 0x5a77e311, 0x1987128a, 0x9c53fadb, 0x8caf3fd9,
    0xbffb99de, 0x83c8ecfd, 0x6ff78288, 0x2bccc15c, 0x13e5e1ba, 0x6dce110b,
    0x8cfe78d9, 0x6556fc76, 0xab21fb11, 0x68b63e8a, 0x3dfe18db, 0x2edd2ed9,
    0x3277e25e, 0xc58710bd, 0x2a53f8a8, 0x0baf3e6c, 0x80000000, 0x40000000,
    0xe0000000, 0x30000000, 0x68000000, 0x5c000000, 0x56000000, 0x87000000,
    0xa3800000, 0x22c00000, 0x30a00000, 0x95900000, 0xd5c80000, 0x1b3c0000,
    0xdb560000, 0xdb650000, 0x55a78000, 0xfb14c000, 0x6589e000, 0x1dc5f000,
    0x97259800, 0xd5407400, 0x686f8200, 0xfc28c100, 0x08dfe380, 0x71a0f0c0,
    0x090219a0, 0x5094b570, 0x6b466358, 0xf37d331c, 0xe9b2790e, 0x9d1c844b,
    0x8a9b9b62, 0xe2497626, 0xe3f6038f, 0x62f503b0, 0x5e6f83c3, 0x0b28c256,
    0x235fe16c, 0x3f60f2d6, 0x07a21917, 0x1e04b68c, 0x4b0e617d, 0x4d8133e5,
    0xa1c478e2, 0xf12986e6, 0x3a541a2f, 0x97f1b6c0, 0x88e1e09b, 0xbf69f14a,
    0x47bb9862, 0xfe19769d, 0x80000000, 0xc0000000, 0xe0000000, 0x30000000,
    0x48000000, 0x64000000, 0xb6000000, 0x19000000, 0xd6800000, 0x36c00000,
    0x40200000, 0xd0900000, 0xa7d80000, 0x12bc0000, 0x60560000, 0xb6f10000,
    0x70a08000, 0x4758c000, 0xfd6e2000, 0x16fc5000, 0x60b71800, 0xdf5aa400,
    0xe1788200, 0x8ce4c300, 0xabb82380, 0xa6cd50c0, 0x18379920, 0x2c926590,
    0x0dcea0d8, 0x91a49364, 0x7dd938da, 0xf9a6f41b, 0xc9cf9a20, 0x37be65d2,
    0xfcc0a1c7, 0x332993ee, 0x650fb87b, 0xbc9f3750, 0x55d9393a, 0x6da6f4ab,
    0xd7cf9968, 0x7abe676e, 0xd440a2f9, 0x78e9906f, 0x45afb9a0, 0x43cf3512,
    0x64a138e7, 0x994af67e, 0x506198a3, 0x0e636434, 0x636e21e0, 0x9bfc50b0,
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x68000000, 0x74000000,
    0xee000000, 0xc9000000, 0x8a800000, 0x27400000, 0xff600000, 0x8c900000,
    0xda480000, 0xfbec0000, 0x32da0000, 0xc7a50000, 0x24328000, 0xf9efc000,
    0x79c02000, 0x4631d000, 0xe2e22800, 0x90574c00, 0xf4fa8200, 0x6543c100,
    0xd47a2180, 0x5d04d140, 0x7498a9a0, 0xe6548dd0, 0x51e0a1b8, 0x2dd71224,
    0x982a8baa, 0x13fc5ddd, 0x06c2085d, 0x49b69ee2, 0xbd30ab51, 0x1b688c8b,
    0x2a92a0c1, 0x574e1213, 0xa76a08f5, 0xc08a9e61, 0x2842a8bc, 0xa8f18d9e,
    0x9f5222af, 0xa378d094, 0x768aa9dd, 0xad5d8fa2, 0xd06822f1, 0xeb0dd15b,
    0xf1902979, 0x9ece4c37, 0x25ba015f, 0x7f3502bc, 0x80000000, 0xc0000000,
    0xa0000000, 0x30000000, 0xe8000000, 0xe4000000, 0x1a000000, 0x11000000,
    0x53800000, 0xb8c00000, 0x80e00000, 0xd1900000, 0xc5d80000, 0xbd740000,
    0xba560000, 0x0ba50000, 0x79b88000, 0x4cad4000, 0xa5232000, 0x3cecf000,
    0x07935800, 0x8ad9bc00, 0xd5e08200, 0xa8194300, 0x84152280, 0x8a19f0c0,
    0xc913dba0, 0x5f90ff90, 0x46cda268, 0x8be4b344, 0x9308fbce, 0x2e980e23,
    0x8550fba3, 0xeb2c0fd6, 0x1fe6fbff, 0x01190d71, 0x4b867887, 0x14c04e9d,
    0x4ef358ad, 0x3289be60, 0x63588385, 0x4c3d40f1, 0x937b20f2, 0x0958f0b4,
    0xd5255923, 0xb4ecbf16, 0x7380005f, 0x48c002e1, 0xc8e002ef, 0x059001d9,
    0x37d80163, 0x48740343, 0x80000000, 0xc0000000, 0x60000000, 0x50000000,
    0xe8000000, 0x54000000, 0xbe000000, 0x1b000000, 0x7f800000, 0xa9c00000,
    0xbf600000, 0x3d900000, 0xf8d80000, 0x55ec0000, 0x48da0000, 0x2de50000,
    0x94d68000, 0x97e5c000, 0xd9c26000, 0xa7777000, 0xb183f800, 0xaacc0c00,
    0x4cee8200, 0xc659c300, 0x5ea06180, 0xe6ee7140, 0xc3577ba0, 0x0a20cd50,
    0x88a060f8, 0x69ee736c, 0x62d7787e, 0xe8e0cfe7, 0xa040635d, 0xa9be72a6,
    0x9b6f789b, 0x9b9ccc7b, 0x6fc2617d, 0x78777040, 0xf803fbd6, 0x1c0c0f85,
    0xda0e80da, 0x1d09c33d, 0xd8986260, 0x3c5273c6, 0xb3b57add, 0xe679cfe6,
    0x1314e13b, 0xbb92b22b, 0x9fc19805, 0xa07b7e6c, 0x140d7a08, 0x1e05ce32,
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x48000000, 0x14000000,
    0x2a000000, 0x47000000, 0x1e800000, 0xf0400000, 0x96200000, 0x08900000,
    0xb9580000, 0x4dbc0000, 0x454e0000, 0xa3b10000, 0x704e8000, 0x56234000,
    0xe88de000, 0x49475000, 0x05ae4800, 0x5156a400, 0x89b68200, 0x374f4300,
    0x48bbe380, 0x18da53c0, 0xdf76c920, 0x0d38e450, 0xe81be2a8, 0xc40a521c,
    0x720ecbfa, 0xeb14e401, 0x688de178, 0x89475372, 0xe5ae49cd, 0xa156a7ea,
    0xc1b6824f, 0x234f421f, 0x62bbe0b1, 0x5fda53a6, 0xc1f6c81d, 0xfd78e782,
    0x7e3be1f3, 0xcc9a51f5, 0xcb56caf8, 0xa6a8e4b2, 0x2dc3e2ed, 0x2af650ba,
    0x95e0cb67, 0xf775e7c3, 0x293b606b, 0x6a0810f7, 0x80000000, 0xc0000000,
    0xa0000000, 0xd0000000, 0x78000000, 0xe4000000, 0x42000000, 0x5d000000,
    0xe5800000, 0xd8c00000, 0x1be00000, 0x0b900000, 0xebd80000, 0x0d740000,
    0x65ca0000, 0x4e770000, 0xdb588000, 0xbc2a4000, 0xd8e0a000, 0x75123000,
    0xb9905800, 0xdeda5c00, 0xd4e08200, 0xcb0e4300, 0x3292a280, 0x8c413340,
    0x28bad9e0, 0x4ba31f90, 0xe52aa308, 0xcf653274, 0xf8c8d916, 0x0bf01c23,
    0xd380238f, 0xdfdc70be, 0x3762f827, 0xdccb6e01, 0xe9e259e1, 0x5e895eca,
    0x424a028a, 0x0bb703ea, 0x8538803a, 0xbf7a4252, 0x50d8a3f6, 0x97f63088,
    0x7582590f, 0xc0d95ffe, 0x8ff203c7, 0xe1930291, 0x2aca8069, 0x4ee943fe,
    0xa212207c, 0xed1f7359, 0x80000000, 0x40000000, 0x20000000, 0xf0000000,
    0x88000000, 0xac000000, 0xfe000000, 0xbf000000, 0x21800000, 0x2c400000,
    0x86200000, 0x5e900000, 0x6dc80000, 0x7a640000, 0xa0ae0000, 0x17490000,
    0x45b98000, 0x9bd5c000, 0x2970e000, 0x5f34b000, 0x7409c800, 0x6a05e400,
    0x45178200, 0x3c9cc100, 0xc4c96080, 0x98e173c0, 0x2b792a20, 0x263156b0,
    0xee9e49f8, 0xc5d927fc, 0x267ee206, 0xd6adb271, 0x045848b8, 0x9a24240a,
    0x0881626f, 0x8ec570a5, 0x2df7297c, 0x9fe855d0, 0x4eefcba8, 0x8868e414,
    0x51a00272, 0x21d001d3, 0x146800c3, 0x47b401dd, 0xe2c60140, 0xb3fd03f6,
    0xf0ff8069, 0x1768c2d4, 0x802f61c4, 0x858c71da, 0x3e4ea9c7, 0xe73d94b1,
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xb8000000, 0x1c000000,
    0x2a000000, 0xc7000000, 0x25800000, 0x49400000, 0xc9600000, 0xf2900000,
    0x44c80000, 0xf4240000, 0x45ee0000, 0xff4f0000, 0x646f8000, 0x300f4000,
    0xd819e000, 0xcc143000, 0x6211e800, 0x63138c00, 0x13818200, 0xa4404100,
    0x2bf66080, 0x9e5b73c0, 0xc4e80ae0, 0xcfd7bc70, 0xf3b86aa8, 0x4fa7ce1c,
    0xd5b1e216, 0x8aa033e5, 0x4337e945, 0x98788c7a, 0x8a00015b, 0x770001bc,
    0xbd8001a9, 0xa5400204, 0x5b6000c2, 0x2990025f, 0x4b4801fe, 0x7a640036,
    0xa90e011a, 0x449f0084, 0xe9c783ed, 0x36bb4266, 0xd93fe34d, 0xc77f3259,
    0x439068ec, 0xac53ce7e, 0xaff7e199, 0x585b33e3, 0x80000000, 0xc0000000,
    0xe0000000, 0xd0000000, 0x78000000, 0x9c000000, 0x2a000000, 0x95000000,
    0x20800000, 0xb9400000, 0x27e00000, 0xb9900000, 0xebd80000, 0xa7bc0000,
    0x3cea0000, 0x9a070000, 0xfd178000, 0x24834000, 0xdf47a000, 0xe0f89000,
    0x9011e800, 0x580b1c00, 0xac1d8200, 0x82144300, 0x71082380, 0x9687d340,
    0x065c49e0, 0x92648e70, 0x2043eaa8, 0x75601d54, 0x39d80102, 0x6ebc02a5,
    0xd66a02ff, 0x664703d6, 0x827782e7, 0xb85342ba, 0x397fa0d9, 0x6bd492d9,
    0x67a3ebe9, 0xdcf01c91, 0x4a00024d, 0x850000fb, 0xb880029c, 0xf54002d6,
    0x75e00057, 0xb0900282, 0xe15801e5, 0x8bfc031f, 0x3b8a01a6, 0x9ad7024f,
    0x312f80ee, 0x3aaf405b, 0x80000000, 0xc0000000, 0xe0000000, 0xb0000000,
    0xb8000000, 0x34000000, 0xca000000, 0x59000000, 0x8a800000, 0x81c00000,
    0x58e00000, 0x37900000, 0x09580000, 0xec3c0000, 0xabe60000, 0x941f0000,
    0x5a028000, 0xb1134000, 0xb68a2000, 0xc7c0d000, 0xffeff800, 0x2e097c00,
    0x5b048200, 0xbf9c4300, 0x4550a380, 0xf22f92c0, 0x88e3dae0, 0xff86acd0,
    0x6551f928, 0xa22a7e64, 0x80e003aa, 0x739003c7, 0x9b580003, 0x313c02ce,
    0x536601ed, 0x78df0204, 0x426283ad, 0x5e434133, 0x6db22221, 0x9dacd01d,
    0x05b1fb9c, 0x61ba7c71, 0xa3b80375, 0x76ac0258, 0x023e012b, 0x10e300aa,
    0x9b848047, 0xa75c42c3, 0x7730a02e, 0xf47f913d, 0x615bd92c, 0x102aaec9,
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x98000000, 0x6c000000,
    0xaa000000, 0xcb000000, 0xdc800000, 0x18400000, 0xece00000, 0x93900000,
    0x5ad80000, 0x19bc0000, 0x32ee0000, 0x5e9b0000, 0x07498000, 0xe6774000,
    0x82c46000, 0x55bd1000, 0x88f7c800, 0xfd87bc00, 0x2fc78200, 0x383c4300,
    0x0f35e380, 0xd1a653c0, 0x16e5aa60, 0x108dadb0, 0x624fc8a8, 0xafebbc2c,
    0x4b1182f2, 0x1c8b40a1, 0xf84a6253, 0x1cf6103e, 0x0b8649a3, 0x36dcfefa,
    0xb3b5e311, 0xf9e65137, 0x8205ab5c, 0x1f1dae76, 0x0a97c8b3, 0x1157bdce,
    0x0f7f80ab, 0x91504106, 0xcf63e2fb, 0x71515012, 0x3f7a2951, 0xe94ded5b,
    0x53742ac2, 0x4346eec9, 0x9865aa9f, 0x9fcdae3c, 0x80000000, 0xc0000000,
    0x20000000, 0x30000000, 0xe8000000, 0x64000000, 0x2a000000, 0x9b000000,
    0x05800000, 0x2fc00000, 0x18a00000, 0xd4900000, 0x61580000, 0xcae40000,
    0x5ff60000, 0x0b750000, 0xaa208000, 0x40cf4000, 0x2f346000, 0xcc433000,
    0x026f3800, 0x68b0b400, 0xdc8e8200, 0x155e4300, 0x38e2e080, 0x48f970c0,
    0x40fbdba0, 0x34fcc590, 0xc6f5daa8, 0xd1fdc56c, 0x9a7b5a96, 0x04a3877f,
    0x8299b942, 0x7c5af502, 0x2a62600d, 0x2ca63317, 0xc697bae1, 0x665bf7ae,
    0x596ce3d4, 0x4d387212, 0xc3555965, 0xe5f2855b, 0x886f3927, 0x03b0b7d9,
    0x110e836a, 0x6e9e40ae, 0xe242e13b, 0x636971f8, 0x0e23d90b, 0x4ad8c7c0,
    0x8423d94f, 0x21d8c67a, 0x80000000, 0x40000000, 0xe0000000, 0x50000000,
    0xd8000000, 0x2c000000, 0xa2000000, 0x65000000, 0xe4800000, 0xa8c00000,
    0xd2e00000, 0x2b900000, 0x9d480000, 0xf0bc0000, 0xc6ba0000, 0x3da30000,
    0x26218000, 0x737a4000, 0x97d9a000, 0x8f7c1000, 0xadd9d800, 0x267e3c00,
    0xbb538200, 0x33a54100, 0xa1222380, 0x12f55140, 0x8b89fb60, 0x2d546cb0,
    0x78a1f888, 0x32b86c94, 0xb3b3fa12, 0xe1376ee3, 0xf2e079ab, 0xdb922c5e,
    0xf5425a1d, 0x54a77ea6, 0x90aba0e0, 0xd6a31331, 0x05a25a29, 0x5a377fa4,
    0x0963a31b, 0xdedf13d6, 0xc9f85a09, 0x60047d74, 0x100a22a3, 0x3819518a,
    0x7c1bfb6f, 0x7a1b6cf5, 0x491279c3, 0x468d2ffb, 0xcdd9d826, 0x367e3ee1,
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xc8000000, 0x14000000,
    0x82000000, 0xc1000000, 0x14800000, 0x8dc00000, 0x61a00000, 0xe3900000,
    0x4a580000, 0xd1e40000, 0x5f7a0000, 0x0fb10000, 0xcc8e8000, 0xb1c64000,
    0x87af2000, 0x38831000, 0x43c27800, 0xdea2d400, 0xf00c8200, 0x58034300,
    0xfc03a080, 0xc6105140, 0x8b19db20, 0xc1968450, 0x1b4f5808, 0x2d74c404,
    0x96ba7ad2, 0x2416d477, 0xfa0e8026, 0x6d06419e, 0x1a8f2081, 0x12d31153,
    0x223a7807, 0x39d6d55d, 0x73ae82ee, 0xca96437a, 0x1ad72263, 0x1637135c,
    0xebc07bfd, 0x7aa7d7dd, 0xca0000ae, 0x150000da, 0xb6800373, 0x1cc00274,
    0xbd2000a9, 0x7a500187, 0xa9f8039d, 0xf374020e, 0x80000000, 0xc0000000,
    0x20000000, 0x50000000, 0x58000000, 0x3c000000, 0xe2000000, 0x4d000000,
    0xcd800000, 0xadc00000, 0x8ae00000, 0x66900000, 0x43580000, 0x6da40000,
    0xf53a0000, 0x49630000, 0xfc4b8000, 0x552a4000, 0xd97ca000, 0x84573000,
    0x39397800, 0x637d3c00, 0xf5498200, 0x16bd4300, 0x83b52080, 0xb22a7140,
    0xddec5960, 0x4a074cf0, 0xb91dd988, 0x6b8e0e34, 0x6ecaf9b6, 0xb0637cf7,
    0x77d721cb, 0x4bed732a, 0x611ddb65, 0x978e0d32, 0xaccaf80a, 0xad637d56,
    0xe25723e4, 0xda2d710d, 0x09fdda95, 0xbc1e0d3a, 0x2212f8fe, 0x6d077e40,
    0x9d8d20c3, 0xf5de705e, 0xb6ee59b3, 0x84904e35, 0x0e5458c9, 0xa0334d08,
    0x58ffda57, 0xc3890f38, 0x80000000, 0x40000000, 0x60000000, 0x90000000,
    0x58000000, 0xd4000000, 0xee000000, 0xab000000, 0x1b800000, 0x4a400000,
    0x3fa00000, 0xca500000, 0x7fa80000, 0xaa5c0000, 0xefba0000, 0xf2570000,
    0x3ba08000, 0x1c4ac000, 0x90b5e000, 0x07c9b000, 0xdafca800, 0x386e4400,
    0x10b5e200, 0x47c9b100, 0xbafca980, 0xa86e4640, 0x48b5e360, 0x93c9b250,
    0x54fcaa38, 0x036e44ec, 0x5335e30e, 0xd989b379, 0x6b5caac6, 0xc93e47c5,
    0x2c9de2f0, 0x73d5b1d0, 0x84e6a978, 0x3b69440c, 0x173d621e, 0x6f9f71a1,
    0x14534b3a, 0x3ca0f413, 0xcdc1c975, 0x57f13540, 0x04e6a978, 0x7b69440c,
    0x773d621e, 0xff9f71a1, 0x4c534b3a, 0xe8a0f413, 0x23c1c975, 0xfcf13540,
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0x9c000000,
    0xe2000000, 0x8b000000, 0x52800000, 0x56c00000, 0x4a600000, 0xb6d00000,
    0x3a680000, 0xded40000, 0xee6a0000, 0xf8df0000, 0x1b798000, 0xc3434000,
    0x9428e000, 0x8d691000, 0x3e523800, 0x4bb85c00, 0x6c28e200, 0x41691100,
    0xa4523880, 0x4cb85c40, 0x84a8e360, 0x00a91370, 0x5eb23b08, 0x27a85e6c,
    0xa620e22a, 0x3e6d122b, 0xc0d03a21, 0xb7735cb7, 0x695b62c3, 0xdb255150,
    0xa1eb5998, 0x01860f54, 0xd8583aae, 0xdeb75e5d, 0x67b961c8, 0x863e5061,
    0x2e70d8d7, 0x98de4e33, 0x2b6b5998, 0x8b460f54, 0x50383aae, 0xf3675e5d,
    0x575161c8, 0x922a5061, 0x687ad8d7, 0x5dd14e33, 0x80000000, 0xc0000000,
    0xe0000000, 0xb0000000, 0x48000000, 0x44000000, 0xca000000, 0x0d000000,
    0x28800000, 0x51400000, 0xd8a00000, 0x59500000, 0xbcb80000, 0xc34c0000,
    0x49ae0000, 0xe7c50000, 0x96e68000, 0xf87c4000, 0xea372000, 0x3d015000,
    0xa0910800, 0xf5444400, 0xa2b72200, 0x1c415300, 0xd0310b80, 0x581446c0,
    0x9c0f2320, 0x960d5210, 0x7b1f08a8, 0xe39146f4, 0xfac9a382, 0x66611355,
    0xf5302bca, 0x448c1791, 0xaf4ea970, 0xb7ac5458, 0x88cf88ec, 0x4774070e,
    0x03ae00ab, 0x2ac50179, 0x5e668064, 0x193c41ea, 0x7a972081, 0x20515358,
    0xd62908ec, 0x3b08470e, 0xc39920ab, 0xaac45179, 0x9e778864, 0xf93805ea,
    0xca800281, 0x68400058, 0x80000000, 0xc0000000, 0x20000000, 0x10000000,
    0xa8000000, 0xac000000, 0xe6000000, 0x09000000, 0x38800000, 0xe2c00000,
    0x50a00000, 0xead00000, 0x2cb80000, 0x84d40000, 0x99ba0000, 0xf2410000,
    0xde6f8000, 0x7c7dc000, 0xdf7ea000, 0x38e2d000, 0x53a6f800, 0xdd4ac400,
    0xcffea200, 0xb622d300, 0xc506f880, 0x2e9ac440, 0x73c6a0a0, 0x7c36d1b0,
    0xea1cfb18, 0x3f0bc464, 0xb9912042, 0x665f123b, 0xfc785a5a, 0x1f7817cf,
    0x18e058f0, 0x43bc1428, 0x75425a3c, 0x63f91706, 0x502fdb09, 0xcc11d599,
    0x1604fbe1, 0x910fc555, 0x2c9321df, 0x00ca12c8, 0x13adda3c, 0x3d44d706,
    0xfff17b09, 0x0e230599, 0xc11a03e1, 0x64910155, 0x9cd783df, 0x4da9c1c8,
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x48000000, 0x64000000,
    0xea000000, 0xc5000000, 0x4f800000, 0x75c00000, 0x3b600000, 0xa1d00000,
    0xd9680000, 0xe0cc0000, 0x4cee0000, 0x18050000, 0x5c028000, 0x26084000,
    0x7b122000, 0x289db000, 0x9b5a9800, 0xeb33dc00, 0x2a722200, 0x0c4db100,
    0xedb29b80, 0x4e3fdcc0, 0x15fc2320, 0xd198b090, 0x82d81828, 0x4dfb9fd4,
    0x6d80021e, 0x94c00147, 0x7ee000c5, 0x21100153, 0xe588037b, 0x50dc03c4,
    0x44e60276, 0x9c1901f3, 0x8604832b, 0xab0142cc, 0x509ea032, 0xb740f245,
    0x65223878, 0x056a2cb7, 0x86d49a76, 0xd7e6ddf3, 0x0098a12b, 0x8f49f3cc,
    0xa92ebbb2, 0xbb776e85, 0xe1cc3b58, 0x396f2c27, 0x80000000, 0xc0000000,
    0x20000000, 0x90000000, 0x58000000, 0x54000000, 0x72000000, 0xcf000000,
    0xf2800000, 0x99400000, 0xcfa00000, 0xfb500000, 0x98b80000, 0x7dd40000,
    0xe3ea0000, 0x257f0000, 0xbe308000, 0x56894000, 0xc35d6000, 0xbcad1000,
    0xe7c94800, 0xb0f06400, 0xa9e56200, 0xce791300, 0xd6a34880, 0x9ccf6640,
    0x8075e360, 0x37a05250, 0xff462948, 0x92b6757c, 0x76d6a8aa, 0x3b6f3435,
    0x2733c876, 0xf1162591, 0xfb908248, 0x66d94382, 0xa3656099, 0x53391354,
    0x13034bf8, 0x6c9f64a4, 0xc04de3be, 0x483453d3, 0x538c2b71, 0x1ad975a6,
    0x6d7e2819, 0x72227514, 0x509ca898, 0xee4036f4, 0xd93b4af6, 0xd80b66af,
    0x9407e3db, 0x521b5193, 0x80000000, 0x40000000, 0xe0000000, 0x70000000,
    0xd8000000, 0xdc000000, 0x62000000, 0xdf000000, 0x2c800000, 0x15400000,
    0xbe600000, 0x2b500000, 0x43680000, 0x38cc0000, 0x0aa60000, 0x4bf70000,
    0x438d8000, 0x41c34000, 0xe7326000, 0x5f2cd000, 0xb321c800, 0xe9219c00,
    0x9a3a6200, 0x0cb0d100, 0x1aefcb80, 0xea1a9dc0, 0x0b11e160, 0xda849270,
    0xdc502a08, 0x2bf50ebc, 0x738249d2, 0x79c9de25, 0x4b2b82f1, 0xe5344311,
    0xb03fe15f, 0xa7af9206, 0x5073a83b, 0x9e5d4d8e, 0x24f3ab39, 0x171d4fcd,
    0x1893a87d, 0x934d4c6b, 0xaf7baad6, 0x62c14d5d, 0x79bdabbb, 0xdd664c4e,
    0x55d82859, 0xb1290cbd, 0x062c49f5, 0x8ea2df17, 0xb5e80264, 0x1e8c0108,
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x98000000, 0xa4000000,
    0x5a000000, 0x33000000, 0xdf800000, 0x4ac00000, 0xa9600000, 0xa4d00000,
    0x28680000, 0xd4440000, 0x732e0000, 0xc6f70000, 0x360a8000, 0x85044000,
    0x1a80e000, 0xf045b000, 0x6928b800, 0x55e11c00, 0xd988e200, 0x57d1b100,
    0x17eeba80, 0x0e921cc0, 0x724c6060, 0x5e32f390, 0xe06cdbe8, 0x3847ec0c,
    0x85223b1e, 0xa3e55ebb, 0xbc88034d, 0xdd54039f, 0x4fa6033f, 0x5ba3002a,
    0xd9ac8061, 0xeea743d4, 0x5b2c626f, 0xbae2f0a2, 0x6804d87d, 0xdc03ef62,
    0x6e0c3978, 0xc1125f81, 0xd08282e1, 0x6b504314, 0x8aa6e00f, 0xe126b232,
    0x19e43915, 0x1f965fae, 0xaacc8206, 0x397742aa, 0x80000000, 0xc0000000,
    0x20000000, 0xd0000000, 0x08000000, 0x84000000, 0xea000000, 0x8f000000,
    0x9c800000, 0x2ec00000, 0x86200000, 0x18d00000, 0xaf380000, 0x45540000,
    0xa8620000, 0xf6350000, 0x00c28000, 0x03204000, 0xfb4f6000, 0xc56dd000,
    0x61b1b800, 0x589c9400, 0x24d76200, 0xf929d300, 0x5c4bb880, 0x0ded9740,
    0xad6fe220, 0xd5b89110, 0x4a9c5b28, 0xf7c1057c, 0x03b1b852, 0x939c95ab,
    0x72576330, 0x88e9d21f, 0x4eebb86e, 0xbffd94fe, 0x6e77e131, 0x073c9097,
    0xd1465be5, 0x6a6004de, 0x2d313b06, 0x7e59d505, 0x26e28009, 0x0bf04264,
    0x7c7761b1, 0xd439d3d7, 0x2bd3bbc5, 0xa5a996ce, 0x5295e0ae, 0x5bc99339,
    0xbda4d87b, 0xfe9045df, 0x80000000, 0x40000000, 0xe0000000, 0x70000000,
    0x28000000, 0x2c000000, 0x82000000, 0x61000000, 0xbc800000, 0x5e400000,
    0xbba00000, 0x88500000, 0x8ca80000, 0x43cc0000, 0xf9660000, 0xfda90000,
    0xe7538000, 0x43214000, 0x980ba000, 0xa404d000, 0x3e1b6800, 0xbb1b2400,
    0xd983a200, 0x4cd8d100, 0x06f56b80, 0xee6e25c0, 0xe63e22a0, 0x2a8c91b0,
    0x89434988, 0x003eb444, 0xd5936852, 0x1ec724c9, 0xdfeda166, 0x26edd365,
    0x3e68ebe0, 0x5e2a6506, 0x5e8001a3, 0x0f4001e3, 0xcf2002d5, 0x8a10013e,
    0x9d080139, 0x869c028e, 0x4b4e01b1, 0x8125014a, 0x19158223, 0x68984023,
    0x48502275, 0x2cb9918e, 0xd3decb31, 0xa17af70a, 0xf9ad4943, 0x494bb533,
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xa8000000, 0x8c000000,
    0xbe000000, 0x41000000, 0x31800000, 0x05c00000, 0x9ae00000, 0xe4d00000,
    0x7b780000, 0x69140000, 0x7d9a0000, 0x9bd10000, 0xcbf38000, 0x7d52c000,
    0xf2a1a000, 0x4de5f000, 0xd8429800, 0xd13c6c00, 0xa73ba200, 0x9a34f300,
    0x8db11880, 0xfd6eac40, 0xcc1a00a0, 0x5e110130, 0x71138278, 0x8982c144,
    0x21d9a266, 0xa8f1f227, 0x1bd89893, 0x0bed6e97, 0x5d48232b, 0xe2a632b3,
    0xe5f0bb1d, 0x545b5dbc, 0x6f209a62, 0xe6396d61, 0xabb22244, 0x8867311c,
    0x679b3aa8, 0x28cd9cd6, 0x25633965, 0x18199cf8, 0xf4193804, 0xba189f46,
    0x6312bad7, 0x669e5f8b, 0xf9491983, 0x10baae65, 0x80000000, 0x40000000,
    0xa0000000, 0x90000000, 0x18000000, 0x94000000, 0xbe000000, 0xa7000000,
    0x39800000, 0x6a400000, 0x6c600000, 0x55500000, 0x81e80000, 0x21040000,
    0xda9a0000, 0x55d70000, 0xa5208000, 0xa6a4c000, 0x8dfe6000, 0x4b1cf000,
    0x6397a800, 0x5b4fbc00, 0xeee46200, 0x348bf100, 0x0ad72a80, 0x38bb7e40,
    0xfaf20260, 0xca930350, 0x0dda8078, 0x9123c0dc, 0x88b6e086, 0x32fc33f9,
    0xe693cb49, 0xb7d44fc9, 0x903b48e1, 0x82248c2d, 0xdf372a5b, 0x47ab7f42,
    0xb77a0073, 0x2ec7030e, 0x4ea88145, 0x71f0c2f7, 0x490c6164, 0x668ff292,
    0xf7cd2a23, 0x302c7f9e, 0x123280f5, 0xc727c0f7, 0xd3ace20c, 0x096b313e,
    0x89d34b85, 0x77208fbf, 0x80000000, 0xc0000000, 0x60000000, 0xd0000000,
    0x08000000, 0x94000000, 0x36000000, 0xbd000000, 0x28800000, 0xa9c00000,
    0x60a00000, 0x2cd00000, 0xc4380000, 0x4f1c0000, 0x6b820000, 0xc84d0000,
    0x07e88000, 0x50b7c000, 0x34cd2000, 0x3837d000, 0x3d049800, 0xe88a0400,
    0xc9cf2200, 0xb0bad300, 0x24cc1980, 0x502dc740, 0x791a0220, 0xd6810150,
    0xe0d28158, 0xae26c1b4, 0x3007a082, 0x181d10f7, 0xfc19395a, 0x72161647,
    0x830499b2, 0x018a049b, 0xb74f23ac, 0x747ad3d2, 0x64ec1aaf, 0x413dc56e,
    0xeb820385, 0x084d0065, 0x67e88111, 0x80b7c1f3, 0x3ccd22f4, 0xac37d266,
    0x0b049a2d, 0x558a0599, 0xe14f22df, 0x197ad222, 0x446c1aa3, 0x7cfdc668,
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x08000000, 0xf4000000,
    0xc6000000, 0xe9000000, 0xd6800000, 0xf2400000, 0x06200000, 0x4f500000,
    0x86a80000, 0x8c1c0000, 0x1a1e0000, 0x0b0d0000, 0x41888000, 0x31d9c000,
    0x10e3a000, 0x94321000, 0xf05b6800, 0x613e1400, 0xe4dda200, 0xd46f1100,
    0x997be980, 0x71fbd6c0, 0xf6a00220, 0xa41002d0, 0x3e080298, 0x750c0164,
    0x5496037a, 0xd5410019, 0xcdbe8300, 0xad88c299, 0x9bd52140, 0x13f6d1f9,
    0x21b84870, 0x0799c511, 0x98d3691c, 0xa67217f7, 0xd66ba3ab, 0xfe7e11bc,
    0xda6d6b67, 0xa46f1453, 0xb16b22e8, 0x55ebd075, 0x88b8c866, 0xb10c06ee,
    0xda86c92b, 0xa85105e5, 0x6d264807, 0xbed4c77a, 0x80000000, 0x40000000,
    0x20000000, 0x70000000, 0xc8000000, 0xfc000000, 0xc6000000, 0xa5000000,
    0x7a800000, 0xc6400000, 0x8ee00000, 0x2f500000, 0x9a680000, 0xe0140000,
    0x10060000, 0x981d0000, 0x44118000, 0xf201c000, 0x9f0b2000, 0x19979000,
    0x19cc6800, 0x323e8c00, 0x67ed2200, 0x3bda9100, 0x5535e880, 0x6a6b4dc0,
    0x68000120, 0xcc0002f0, 0x2e000398, 0x29000354, 0x748002ca, 0x9f4000e9,
    0x32600123, 0x4c100229, 0x6e080383, 0x09040099, 0x048e027b, 0x575902dd,
    0xce7f8379, 0x8a08c048, 0xcb1ca23c, 0x738b5206, 0xc2d6c977, 0xd9a8df00,
    0xe12a69e3, 0x10738d89, 0x2b14a3b3, 0x638f51a1, 0x5ad8cb9f, 0x9db1ddef,
    0x1335ebd4, 0x8f6b4d69, 0x80000000, 0x40000000, 0xa0000000, 0xb0000000,
    0x58000000, 0xac000000, 0x6e000000, 0x41000000, 0x23800000, 0x46c00000,
    0x22200000, 0x33d00000, 0x23a80000, 0x4a040000, 0x8b1e0000, 0xe89f0000,
    0x0e438000, 0x9c66c000, 0xf7ada000, 0x7811b000, 0x5c1cf800, 0x96023400,
    0x5d13a200, 0x159eb100, 0xabd77a80, 0x6fb0f6c0, 0x34080360, 0x221403b0,
    0x3f160338, 0x8a8b03c4, 0x915581ee, 0xa6edc3ab, 0x3ef82130, 0x72fc71cb,
    0x0ce4d800, 0xa5fe4433, 0x727778a4, 0xf6a0f66d, 0xfb800037, 0xaac00099,
    0xec200212, 0xc2d00232, 0x58280191, 0xa0c4039d, 0xc73e039c, 0x9a4f01a9,
    0x0e6b83d9, 0x90a2c232, 0x5e93a1a2, 0xa35eb139, 0x71f778f1, 0x4060f51e,
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x48000000, 0x0c000000,
    0xca000000, 0xfb000000, 0xb1800000, 0x5ec00000, 0xc9600000, 0xc1d00000,
    0xaee80000, 0x46040000, 0x71020000, 0xea9d0000, 0xbf4b8000, 0xdfb04000,
    0x04aee000, 0xa5377000, 0x13f8b800, 0x86891c00, 0xc54ce200, 0x9cba7100,
    0xa13b3a80, 0x75ed5d40, 0xe7880320, 0xc7d40130, 0x7fea01a8, 0xfc9902ac,
    0x864983e6, 0x392d414b, 0x71e5600d, 0x818730eb, 0xa6d6587d, 0x7d7e6c63,
    0x1fd458e1, 0xdbe36dad, 0xca9fd8c6, 0xaf532e26, 0x37b13876, 0x58a45d4e,
    0x2729803a, 0xe4fd42f8, 0xfd0d6149, 0x60833301, 0xe4545920, 0x3e236e6d,
    0x127fdafb, 0x60432ce5, 0x18393967, 0xd3705eab, 0x80000000, 0x40000000,
    0x20000000, 0xf0000000, 0xa8000000, 0xfc000000, 0xaa000000, 0x63000000,
    0x18800000, 0xbb400000, 0xa6e00000, 0x7a500000, 0x91680000, 0xfb940000,
    0xe3d60000, 0x3db10000, 0x2cb18000, 0x43384000, 0x96efe000, 0xb2545000,
    0xbd7c0800, 0x09974c00, 0xd4d1e200, 0x73315100, 0x5efb8880, 0x9e4e0fc0,
    0x4f6780a0, 0x3e8942f0, 0x9a5e6228, 0x016c124c, 0x8393eac2, 0x47c31d1d,
    0xc3adea33, 0x19a61d65, 0x92aa68a7, 0x563f5fc3, 0xb77c0934, 0xda974c2f,
    0x4451e07f, 0xc471525e, 0xfa1b893e, 0x7b1e0d6e, 0x6c8f82b6, 0x1d5d4152,
    0xc7e8639c, 0xfdcd11a3, 0x98aa6a1d, 0x853f5db3, 0x27fc0925, 0x6dd74e47,
    0xe0b1e2d3, 0x2121528c, 0x80000000, 0x40000000, 0xa0000000, 0xd0000000,
    0xd8000000, 0x24000000, 0xf2000000, 0x2b000000, 0x7f800000, 0xb2c00000,
    0x24200000, 0x03d00000, 0xbca80000, 0xb0840000, 0xdf520000, 0xcdef0000,
    0x506e8000, 0xf1bd4000, 0xfe0de000, 0xb517b000, 0xfa863800, 0xe04ef400,
    0xe877e200, 0xe5bcb100, 0xa41aba80, 0xb20cb740, 0x8b1c8160, 0xaf824190,
    0x6acb6148, 0x002ef3ec, 0xf1d9da9e, 0x97b6465b, 0xcf1f5958, 0x6d8f05a3,
    0xe9c0bb8c, 0x53b7b649, 0x4d08000d, 0x4e9401e8, 0x6a5a019b, 0x377b0278,
    0xb03481d3, 0x19c64314, 0x1bb9600d, 0x1111f22f, 0x489f5bc5, 0x6b4f0544,
    0x47e0ba65, 0x8f67b5b3, 0xa42001c3, 0x43d0015b, 0x1ca8031f, 0x6084033d,
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xd8000000, 0x4c000000,
    0x22000000, 0xdf000000, 0x26800000, 0x8ec00000, 0xb0e00000, 0xefd00000,
    0x73780000, 0xf4940000, 0x19d20000, 0x227f0000, 0x5f138000, 0xe6874000,
    0xaed66000, 0xe0ea9000, 0x37c13800, 0x3f634c00, 0xd69c6200, 0xc6d19300,
    0x04f8b880, 0xd1cf0d40, 0x566b8160, 0x41134230, 0x93846008, 0xc355923c,
    0x26b2bbfa, 0xf4f40f0b, 0x99d2004b, 0xe27f03c3, 0x7f1381d7, 0xb68740a9,
    0x76d661c4, 0xacea9206, 0x15c13839, 0xe0634f34, 0xf01c6046, 0x48119231,
    0xb418bbe0, 0x3e1f0d98, 0x2513814c, 0xb587417a, 0x8a5660a3, 0xe12a910f,
    0x79a13885, 0x12734e8e, 0x370460ad, 0x0295900a, 0x80000000, 0x40000000,
    0xa0000000, 0x30000000, 0x68000000, 0xec000000, 0xfa000000, 0xfb000000,
    0x61800000, 0x89c00000, 0xd9200000, 0x34d00000, 0x01a80000, 0x33840000,
    0x7ece0000, 0xd2b90000, 0x1e0b8000, 0x3d1a4000, 0x9896e000, 0xa7557000,
    0x4f635800, 0x893a9400, 0x8cd0e200, 0x15b87100, 0x7d8eda80, 0xfbddd4c0,
    0x5e2383a0, 0xf75e42b0, 0xf778e168, 0x9d3c732c, 0xc2c0d826, 0x90a4d597,
    0xf108028c, 0x1294023f, 0x94460300, 0xf2ed0229, 0x92ed833f, 0x42e74029,
    0xbaf36396, 0x0ee633d6, 0x70f63a1f, 0x9de1a7f0, 0xfd635821, 0xee3a9703,
    0xdf50e0d7, 0xbb7873c5, 0x572eda10, 0x51cdd5f1, 0x1d2b837b, 0x82ca4223,
    0x30bee0a7, 0xc111720d, 0x80000000, 0xc0000000, 0x60000000, 0xf0000000,
    0x68000000, 0x6c000000, 0x62000000, 0x69000000, 0xc2800000, 0xf2c00000,
    0x5e600000, 0x7dd00000, 0x3bf80000, 0x269c0000, 0xccc60000, 0x5d610000,
    0x4a438000, 0x01b94000, 0x8f3ca000, 0x4fe21000, 0x809a7800, 0xcbd41c00,
    0x64e2a200, 0x7b0f1300, 0x0387f980, 0x3c405fc0, 0x3ea383a0, 0x22a942b0,
    0xe8a4a008, 0x8dae1264, 0xdd247aaa, 0x2ee91e7b, 0xde0722f1, 0x33075353,
    0x3f80da65, 0xa6470c91, 0xa3a359ea, 0x862e4e32, 0x7d67fbce, 0x1a505df8,
    0xf9bb8025, 0x7b2542f1, 0x29faa3fa, 0xe783110a, 0x0259f862, 0x3dad5f96,
    0x153e00c4, 0xd2fd0233, 0x2405835c, 0x5e184006, 0xf31f2295, 0x5f8b5250,
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xb8000000, 0xac000000,
    0x46000000, 0x6b000000, 0xdf800000, 0xbec00000, 0x1fa00000, 0x37d00000,
    0x99380000, 0x87840000, 0x82c60000, 0xb1a30000, 0xb8db8000, 0x14a7c000,
    0xb85ce000, 0x6ff53000, 0x8c29b800, 0x5f1b8400, 0x0582e200, 0x8bc23300,
    0xf72c3a80, 0xa88b47c0, 0xff5b80e0, 0x3667c1b0, 0xf9fce398, 0x6f25326c,
    0x3491b99e, 0xa15f844b, 0x0164e366, 0xd8713273, 0x16efbb9a, 0xb2b88725,
    0x43596295, 0x5865f3a9, 0xd6f0db1f, 0x12be7420, 0xb3523b74, 0xe06c4432,
    0x7ae60135, 0x54b3009d, 0xd843838d, 0x3ff3c205, 0xc422e061, 0x4b1232db,
    0xef94390a, 0xa6cf47ed, 0x43bd81d1, 0xc9d4c143, 0x80000000, 0xc0000000,
    0xa0000000, 0xb0000000, 0xa8000000, 0x0c000000, 0x22000000, 0x27000000,
    0xf8800000, 0x65c00000, 0x4c600000, 0xdd500000, 0x49b80000, 0x81240000,
    0x8cfe0000, 0x6c890000, 0x23db8000, 0xe5734000, 0x90d66000, 0x5bf7d000,
    0x5c099800, 0x5a183c00, 0x930de200, 0xce849300, 0xc4dffa80, 0xbdefeec0,
    0x450478a0, 0xbf9caf30, 0x8d521808, 0x31ab7d5c, 0x353b81c2, 0xbae34067,
    0xcd8e6199, 0xd243d119, 0x7d2f98ec, 0x66e53f3f, 0x57906268, 0xe15ad0cc,
    0x03ac19fa, 0x0a227db3, 0xe66000c7, 0x8650029c, 0x9b3800e2, 0x7fe40317,
    0xb21e03f1, 0xff1901d5, 0xfc838116, 0xfbc7428c, 0xe17062af, 0x0ecad250,
    0xf6f41918, 0x8f967ea4, 0x80000000, 0x40000000, 0xe0000000, 0xd0000000,
    0x78000000, 0x7c000000, 0xe2000000, 0x11000000, 0x0b800000, 0x7ec00000,
    0xf9600000, 0x25500000, 0xbfa80000, 0x402c0000, 0xa8e20000, 0x968b0000,
    0x9f418000, 0xa2b54000, 0xe1a8a000, 0x1325b000, 0x827a3800, 0x4bde3c00,
    0x1ce92200, 0xe090f100, 0x88529b80, 0xf63b8f40, 0x1ff31be0, 0xf21eccf0,
    0xc913ba08, 0x47877e04, 0x34c3804e, 0xec6e424b, 0xb0c1220d, 0x327cf261,
    0xa3d098b8, 0xf8e08d4f, 0xae9a98e0, 0x03478e70, 0x90b91ac8, 0x88b9cca4,
    0x64b0385e, 0x1eb93c33, 0xa3aaa3c1, 0x323eb30b, 0x21f3baed, 0x31177c11,
    0x7b8b8270, 0x36d241eb, 0x2d6b20be, 0xc34bf243, 0x30bb1909, 0xb8a2cfaf,
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x18000000, 0x3c000000,
    0x3e000000, 0x99000000, 0xd3800000, 0x13c00000, 0x3ee00000, 0x58500000,
    0x51280000, 0xb8ac0000, 0x60660000, 0x22070000, 0xf70d8000, 0x4286c000,
    0x1449a000, 0x37393000, 0xfda11800, 0x7df14c00, 0xb0c42200, 0x267ff100,
    0x3708bb80, 0xe2987fc0, 0x044d3a60, 0xdf22bdf0, 0xd9aa9978, 0x7fe08ca4,
    0x17c802ae, 0x6cfc027f, 0xf74e03e3, 0xcfab0035, 0x62eb8292, 0xd641c039,
    0x302422cc, 0xa72ff3c2, 0x55a0b92d, 0xb9f47ec6, 0x42cb3a6f, 0x9975bed7,
    0x418f196f, 0x1cca4c57, 0xb067a12f, 0x6a0233f7, 0xc3029bbf, 0xa88c8eff,
    0x974e00a3, 0x7fab0115, 0x9aeb8242, 0x1a41c391, 0x80000000, 0x40000000,
    0xe0000000, 0x90000000, 0x98000000, 0x64000000, 0x2e000000, 0xab000000,
    0xfc800000, 0xe6c00000, 0xf8a00000, 0x26500000, 0xf4680000, 0x2bec0000,
    0x8daa0000, 0x39d70000, 0xf22a8000, 0xef88c000, 0x4e50e000, 0xd879d000,
    0x19e2f800, 0xfcbb2400, 0xd85a6200, 0x27611100, 0x237a1b80, 0xdd7ef640,
    0x0e7a9860, 0x06e13490, 0x5620f938, 0x618025ec, 0x955ae012, 0x2cfed14b,
    0x03207aba, 0x4e1fe5e5, 0x7b0080fb, 0x849fc108, 0x12da611e, 0x4ea11309,
    0xe95a1a69, 0x26eef583, 0x66329984, 0x899d341c, 0xf942f83a, 0xfeeb24df,
    0xe23263a4, 0x378d12ec, 0xca501892, 0x6669f58b, 0x2af01b1a, 0x6439f555,
    0x10981833, 0x74d5f4cc, 0x80000000, 0x40000000, 0xa0000000, 0x90000000,
    0xa8000000, 0x6c000000, 0xf2000000, 0xdf000000, 0x42800000, 0x15c00000,
    0x57200000, 0x63500000, 0x04e80000, 0xed640000, 0x5c2a0000, 0x57d90000,
    0xf0238000, 0x45dd4000, 0x1f396000, 0x3f4a9000, 0xcef09800, 0xf6761400,
    0x80bae200, 0x6f07d100, 0x3a81fa80, 0x71c88640, 0x592878a0, 0xe65cc4b0,
    0xf57a9b48, 0x483f143c, 0xc1d1632a, 0x212e92a7, 0x825a9ab4, 0xfb6f1501,
    0xcd396271, 0x304a902e, 0x8470986e, 0x1fb615b9, 0x8d9ae325, 0xbf57d3c8,
    0x8ee9f90b, 0x566c86a6, 0x10a27832, 0xc715c4c3, 0x56911ada, 0x83d654b8,
    0x862a0354, 0xa4d902e6, 0xe0a383e5, 0x1f1d415f, 0xa29961b7, 0x25da92bb,
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x48000000, 0x4c000000,
    0xd6000000, 0x63000000, 0x9f800000, 0xbf400000, 0xb6a00000, 0x76d00000,
    0x2ae80000, 0xffe40000, 0xb3720000, 0x2ba50000, 0x764f8000, 0x6425c000,
    0xc102e000, 0x3e8bb000, 0x31d5c800, 0x3f700400, 0x1da56200, 0xe54a7100,
    0xe3a52a80, 0x7a5eb540, 0x123f2b20, 0xf21fb430, 0xe902abd8, 0xc29f75cc,
    0x5fcfcbde, 0x0871078d, 0x5038e022, 0xa31ab127, 0x7f804a2d, 0x4f54c4fe,
    0xaeba0211, 0x72d10234, 0xb0f5800e, 0x4af4c185, 0x4ff760e6, 0x0b7f71bd,
    0x7fa2aafa, 0xa44f766b, 0x9d27c8b3, 0xeb950653, 0x7d4ae103, 0xa7bfb14b,
    0x404fc92f, 0xf7310645, 0x4698e12a, 0x85cab063, 0x80000000, 0x40000000,
    0x60000000, 0x30000000, 0x98000000, 0x64000000, 0x06000000, 0x65000000,
    0x55800000, 0xb6400000, 0x17600000, 0x15d00000, 0x7c280000, 0x633c0000,
    0x71be0000, 0x91670000, 0x30de8000, 0x49b1c000, 0xe5692000, 0xfecbf000,
    0xe0a12800, 0x4af2bc00, 0x4f9fa200, 0xc1463100, 0xd9f60980, 0xc71e4cc0,
    0x16800860, 0xd6d54c90, 0x5ca88b98, 0x48ef8c54, 0x1c8928b6, 0x69cebe89,
    0x5e21a1a5, 0x60213193, 0x71288b5e, 0xeaaf8f91, 0xf5e928b5, 0x4d1ebdcf,
    0xe989a3a0, 0xb45d3270, 0x44768948, 0xbd588fec, 0xfbffab52, 0xc4037e97,
    0x16168090, 0xad1dc09c, 0x999f209e, 0x4c40f171, 0x1069aa65, 0x23587e77,
    0xfaf60044, 0x978b026e, 0x80000000, 0x40000000, 0x60000000, 0x10000000,
    0x68000000, 0x5c000000, 0xaa000000, 0x5d000000, 0x91800000, 0x34400000,
    0x04a00000, 0xf7d00000, 0x19e80000, 0xf4fc0000, 0x3d7a0000, 0x4d390000,
    0xc79d8000, 0xf35e4000, 0xd0232000, 0x7613f000, 0xb716e800, 0xac8bc400,
    0xb5d6a200, 0x58f1b100, 0xaf6fc980, 0x44313440, 0xb015cba0, 0x58083470,
    0x44084928, 0x8e167434, 0xc30b6866, 0x3a9584e1, 0x52d5809a, 0xfc72429b,
    0x56b120a9, 0xded6f346, 0x1e7169a9, 0x27ac863e, 0x9d480185, 0x432c0364,
    0x44920006, 0xa9c50071, 0x92e780e2, 0xe2674137, 0xbdbea0b3, 0xd84db0e5,
    0xf6b5ca8c, 0xeed83452, 0x06604887, 0x03aa767b, 0x03516b01, 0xe83c87b2,
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xc8000000, 0x64000000,
    0x9a000000, 0xfd000000, 0xa6800000, 0xecc00000, 0x86200000, 0x08500000,
    0xabe80000, 0xcef40000, 0x74660000, 0x8ea50000, 0xfb8e8000, 0xfa584000,
    0x82f02000, 0x1a7c1000, 0xf1bcf800, 0xfc187400, 0x8616a200, 0xeb105100,
    0x558ad880, 0xe55167c0, 0x556cd920, 0x5e346490, 0x344258e8, 0x4dfc2534,
    0xf5fa7b3a, 0x19e434e3, 0xc7e881d0, 0x50fd4085, 0xc37ea1fd, 0xed24512c,
    0x1dccd81b, 0x6ea467cc, 0x6b8a59ab, 0xe25825b4, 0xdef47b77, 0x2c75343a,
    0xf2a000ee, 0x3d900269, 0x3148014b, 0x27640089, 0x372e0176, 0xc0c10008,
    0x38208384, 0x4f5942c2, 0x0070a07f, 0x4cb5523e, 0x80000000, 0x40000000,
    0x60000000, 0x90000000, 0x88000000, 0x74000000, 0x6e000000, 0x2f000000,
    0x7f800000, 0x4c400000, 0xfea00000, 0xc9d00000, 0x23e80000, 0x8ffc0000,
    0x3dea0000, 0xf8e50000, 0xde688000, 0x3ebac000, 0xe9dc6000, 0xd3ebb000,
    0x97f02800, 0xc1ed8400, 0xe2fce200, 0x9f7d7100, 0x6e2e4980, 0xda1f3640,
    0x610e4820, 0xa08f34d0, 0x2bc64a38, 0x4ee337fc, 0x2d64485e, 0xab2a37a1,
    0xfc8ecbe2, 0x81c9f50b, 0x77f02969, 0x11ed8522, 0x0afce2eb, 0x7b7d73d9,
    0x882e4bea, 0x811f37ff, 0x708e4843, 0xc3cf34e9, 0xaae64962, 0xcb7337cb,
    0xf02c4889, 0xed063492, 0xe28cc8a3, 0xf6d0f70d, 0x9472a910, 0xd7b2468c,
    0x3d4802f6, 0x962c0345, 0x80000000, 0xc0000000, 0x60000000, 0x90000000,
    0xe8000000, 0xfc000000, 0x12000000, 0x67000000, 0xf4800000, 0xeac00000,
    0xbe600000, 0x40500000, 0xf9b80000, 0x89bc0000, 0x31ba0000, 0x45b90000,
    0x3ba98000, 0xa6a94000, 0xc9386000, 0xc5685000, 0xf6c77800, 0xfc637c00,
    0xaf49e200, 0x612d1300, 0x997d1980, 0x14ce2e40, 0xe37d19a0, 0x4fce2cf0,
    0x65fd1bc8, 0x520e2cdc, 0xc71d1bf2, 0x049e2d1b, 0x92c51a91, 0xaa722e2d,
    0xae47185c, 0x8cb72ea1, 0x1a349985, 0x2ff76c90, 0x111d7a4b, 0xc58a7d3a,
    0x1f586147, 0xb93851a3, 0x7d7f7b56, 0x82df7cdd, 0x8273e294, 0x325410fd,
    0x0eb499b7, 0x95376c6b, 0x277d7a8a, 0xe9da7faf, 0x1ce0634f, 0xab84500c,
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x38000000, 0x7c000000,
    0xb2000000, 0xaf000000, 0xb8800000, 0x54c00000, 0x4a600000, 0x8a500000,
    0x77b80000, 0xc1ac0000, 0x80b60000, 0x35330000, 0xbe658000, 0x5c5b4000,
    0x06a76000, 0xac3bd000, 0x87f7b800, 0x5d017c00, 0x379ae200, 0xfc5c9300,
    0xd6bedb80, 0x8435afc0, 0x33e6dae0, 0xab09aef0, 0x5688db48, 0x59c6ae7c,
    0x95e35b82, 0x2202ec63, 0xa717ba81, 0x1c917da5, 0x6ac2e094, 0x6f6091d9,
    0xe1d0d861, 0x29faaf22, 0x700d58c4, 0xf80ded41, 0x9c1c3b45, 0x42053c64,
    0x970e0191, 0xc49f019d, 0xe6d38160, 0xe5684147, 0x32c2e0b0, 0x23609168,
    0x8bd0dbec, 0x0afaaefa, 0x428d5a37, 0x7fcded4f, 0x80000000, 0xc0000000,
    0xe0000000, 0xd0000000, 0xc8000000, 0x14000000, 0x8e000000, 0xcf000000,
    0x7d800000, 0x5bc00000, 0x53200000, 0x49500000, 0x85780000, 0xb9ac0000,
    0x93120000, 0x279d0000, 0xfac48000, 0x31b2c000, 0xa7126000, 0x9984f000,
    0x2ddf5800, 0x90263400, 0x66c4e200, 0x8bab3300, 0xd609bb80, 0x33100740,
    0xd789d920, 0x02c9f750, 0x3db203b8, 0xf50d037c, 0xcc9c8156, 0x114ec27f,
    0x79786054, 0x13b5f249, 0xca09d9db, 0x4909f4b5, 0x469200f6, 0x785d03d4,
    0x0fe48332, 0x73e2c045, 0x19ea61e5, 0xa0e8f04e, 0x1e6d5b28, 0x6a2b3524,
    0x37d8631a, 0x1125f2e1, 0x3451dbbf, 0x7df5f68f, 0x16f80147, 0x3d6c01d3,
    0x95b201c1, 0xf10d01d4, 0x80000000, 0xc0000000, 0x60000000, 0x30000000,
    0xa8000000, 0x64000000, 0x96000000, 0x23000000, 0x0f800000, 0x50400000,
    0xc8600000, 0x0cd00000, 0x9fb80000, 0xa0fc0000, 0x550e0000, 0xdc810000,
    0x97c68000, 0xcc21c000, 0xfaade000, 0xd477b000, 0xa6d8a800, 0x86ae9c00,
    0x4e656200, 0x17d77300, 0x0c33c980, 0x9ab8ecc0, 0xe47028a0, 0x0ede5e90,
    0xe2b601d8, 0xd87d034c, 0x34c8831e, 0x03a0c011, 0xcaeb63d9, 0x2c16712f,
    0x02154818, 0x7d092f4e, 0x7885c84b, 0x61c5ed00, 0xdf38a880, 0x5d3e9e40,
    0xe03d61e0, 0xf8bb70f0, 0xa965c8e8, 0xde55ef84, 0xe760aa4a, 0x91529f63,
    0x4aeb6386, 0xec16711f, 0x62154a72, 0x4d092cdf, 0xd085c870, 0x05c5ee8a,
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x58000000, 0x04000000,
    0x82000000, 0x05000000, 0x05800000, 0x52400000, 0x42e00000, 0xcad00000,
    0x71280000, 0xe8740000, 0x340a0000, 0x0a070000, 0x79168000, 0x13894000,
    0x8d4b2000, 0x46707000, 0x1f0aa800, 0x64804c00, 0x65d7a200, 0xddbe3100,
    0xd1b70880, 0x6fa97e40, 0x5cbe2b60, 0x163a0d10, 0x18e00088, 0x8bd00354,
    0xd6a801f6, 0x2f340319, 0x2b6a0263, 0x9697032f, 0xc8de83da, 0x342d42fc,
    0xcde921cd, 0xf643724a, 0x10f6292b, 0xb7de0cc4, 0xe0a20121, 0x60330390,
    0x77fc81c8, 0x475e43b4, 0x5f75a326, 0xbc8d3231, 0x21cb8b07, 0x7fb73d21,
    0x44ab8a8f, 0x32273ef5, 0x0ae38939, 0xd6c33c8c, 0x80000000, 0x40000000,
    0xa0000000, 0x30000000, 0x98000000, 0x34000000, 0x22000000, 0x2b000000,
    0xbd800000, 0x79400000, 0x2fe00000, 0x57d00000, 0xaf280000, 0x1b640000,
    0xf81e0000, 0xe40f0000, 0x2a148000, 0xb7114000, 0x3390e000, 0x44557000,
    0x9b6e0800, 0xb8072c00, 0x441a6200, 0x1a0b3100, 0x2f0a6a80, 0x07931cc0,
    0x664c8860, 0xb07d6dd0, 0x05800008, 0x3d40016c, 0x35e00216, 0x78d001f5,
    0xa8a80257, 0x7d240123, 0x487e00c2, 0xe19f0124, 0x175c81a9, 0x82e5432a,
    0x4b46e2ab, 0xecee73ee, 0xe64c8992, 0xf07d6eec, 0xa5800325, 0x0d4002ac,
    0xade003f6, 0x4cd00365, 0x8aa8007f, 0x5624033f, 0xf5fe026c, 0x98df00e5,
    0x38bc834c, 0xd5354166, 0x80000000, 0xc0000000, 0xa0000000, 0xd0000000,
    0x68000000, 0x24000000, 0xaa000000, 0x93000000, 0xf4800000, 0xc4c00000,
    0x8da00000, 0xb7500000, 0xcff80000, 0x51240000, 0x37920000, 0x98410000,
    0xcd6a8000, 0x40f24000, 0x83b3e000, 0x4e535000, 0x0869b800, 0xb16e4400,
    0x16eb6200, 0x86b01300, 0x1fc8da80, 0x4d2b5740, 0x11833ba0, 0x255c0790,
    0xd0f88228, 0x8bb3420c, 0x1a5960f2, 0x1a6110c3, 0x6e7a593e, 0x6c6d1401,
    0x7b7ad845, 0xf5fa571b, 0xca31b9ba, 0x971a47ef, 0x4e81631c, 0x9fd5124a,
    0x8d305867, 0xb1981780, 0xf55a5910, 0xb8fd1768, 0xafa2daac, 0xb04e55e2,
    0x897bb9ab, 0x9aef4692, 0xa8a1e263, 0xf6d2532e, 0x42a339e9, 0x05cc05a9,
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x28000000, 0xcc000000,
    0x4a000000, 0x81000000, 0x61800000, 0x4a400000, 0xdee00000, 0x2ed00000,
    0x83380000, 0x69740000, 0x678a0000, 0x41590000, 0x1e7f8000, 0x151e4000,
    0x3f94a000, 0x5558f000, 0x80722800, 0x2a12cc00, 0x71012200, 0x798fb300,
    0xbe410880, 0x70f07c40, 0x29d5aaa0, 0x29a88c30, 0xc3a783a8, 0x92ba4144,
    0xfb26a1a6, 0x6d75f259, 0xd187aaf3, 0xb2558d8f, 0x1aea00a2, 0xb8c90188,
    0x602783e3, 0x45fa40d7, 0x0646a1ae, 0x54e5f27a, 0x8fdfaa44, 0xf2b18ff1,
    0x0b380060, 0x757403d0, 0x258a02b8, 0x1c59001c, 0x1dff82aa, 0x125e42ab,
    0xcaf4a3d4, 0xb0c8f2e9, 0xbc2a29cc, 0x27f6cf12, 0x80000000, 0x40000000,
    0x60000000, 0xf0000000, 0x98000000, 0xe4000000, 0x76000000, 0xb5000000,
    0xe3800000, 0xae400000, 0xfe200000, 0x94d00000, 0x09e80000, 0x1bbc0000,
    0x57860000, 0x90570000, 0xa72e8000, 0x8d53c000, 0x18b12000, 0x21123000,
    0x4d9ba800, 0x9f4a1400, 0x9bb9a200, 0x1786f100, 0xf04c0980, 0x5727e7c0,
    0x155d2860, 0xfca5d690, 0x570e8258, 0xf883c014, 0x7cd9206e, 0x35ee32e9,
    0xe9bda840, 0x648d1717, 0x5edf2071, 0x0ef93103, 0xab3328a8, 0xc74ed56b,
    0x5fa60123, 0xf1870298, 0x2d468143, 0xc8afc3bf, 0x2917231a, 0xc1953320,
    0x955d2ab0, 0xbca5d668, 0x370e833c, 0x0883c072, 0xe4d9202b, 0xd1ee3203,
    0x9fbda828, 0xd18d172b, 0x80000000, 0xc0000000, 0xe0000000, 0x10000000,
    0xd8000000, 0x24000000, 0x82000000, 0x91000000, 0xa2800000, 0x2f400000,
    0x19200000, 0x0ed00000, 0x1df80000, 0x5e2c0000, 0xb74a0000, 0x1d3f0000,
    0x7cca8000, 0x44f14000, 0x00a1a000, 0x3e0a9000, 0x17188800, 0x419fd400,
    0xd4d92200, 0x68e8d300, 0x9eb9ab80, 0x191b0440, 0x7e8a8960, 0x795cd790,
    0xc221a388, 0xc14a9104, 0x36388a6a, 0x7b4fd46d, 0x9321230c, 0x83c4d1ef,
    0x0973ab75, 0xba6407c1, 0xb9e00953, 0x1c3d9762, 0xc6580268, 0xafbc0154,
    0x8b9200c2, 0x79c30199, 0x8c78827e, 0xb2e2428e, 0xeba12257, 0xd984d3c9,
    0xd0d3aa17, 0x1af40568, 0xc7b80915, 0x47819610, 0xf7ca0109, 0x737f0076,
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0xf8000000, 0x5c000000,
    0x26000000, 0x05000000, 0xf2800000, 0x91400000, 0x43600000, 0x08d00000,
    0x61b80000, 0x82740000, 0x90560000, 0xfbe30000, 0x62818000, 0x795dc000,
    0x37702000, 0x7adf1000, 0xe6b14800, 0x0fe91c00, 0xd09fa200, 0xde55d300,
    0x4af6e880, 0xc218cfc0, 0x9f0749e0, 0x019a1e70, 0x6ec62218, 0x84ac10d4,
    0xa0e8c8aa, 0x0910dcf5, 0x1c818075, 0x105dc247, 0x3bf02254, 0x429f1398,
    0x89514b66, 0xcf791cf9, 0x26c7a399, 0xc0b1d0db, 0x0af8e850, 0x221fcd88,
    0x4f08c8bc, 0x0980dc66, 0xcad9818b, 0xfeb9c1aa, 0x83fe2087, 0xfe9811c6,
    0x7f5ec95b, 0xc263dfe2, 0x705803db, 0x2be400d0, 0x80000000, 0x40000000,
    0xe0000000, 0xd0000000, 0x58000000, 0x3c000000, 0x82000000, 0x53000000,
    0x5c800000, 0xd3c00000, 0x67e00000, 0xb6500000, 0x4fa80000, 0x58ec0000,
    0x70c20000, 0x137f0000, 0x31918000, 0x1e494000, 0x5bbae000, 0x8ef65000,
    0x15d35800, 0xfafe8c00, 0x53c16200, 0x27ec1100, 0x565a3b80, 0x9fae9f40,
    0x00f15b60, 0x4cd18df0, 0x9178e388, 0x6289530c, 0x42c2db92, 0x8877ccff,
    0xe91b80f7, 0xa38a4265, 0xb54161c4, 0x0b2c1020, 0x573a384e, 0x453e9d2b,
    0xae39586f, 0x1ead8f8f, 0x1772e161, 0x1f8a521a, 0x77595a2d, 0xb83d8eb6,
    0xdbbae0b1, 0xcef65302, 0xf5d35959, 0x2afe8ea0, 0x0bc16250, 0x1bec1258,
    0xd45a3a14, 0xccae9ce6, 0x80000000, 0xc0000000, 0xa0000000, 0x70000000,
    0x38000000, 0xdc000000, 0x92000000, 0x0f000000, 0x97800000, 0x7fc00000,
    0xee200000, 0x49500000, 0x8b780000, 0xa8240000, 0x50460000, 0x8deb0000,
    0x95718000, 0xbd334000, 0x8cc16000, 0x5bb93000, 0xa1915800, 0x5ec45400,
    0x34aee200, 0xe6157300, 0x691fba80, 0x3e8125c0, 0xe1495ae0, 0x7f705470,
    0x0e30e2c8, 0x594a72fc, 0x6370383e, 0x3c2d674f, 0x2647bb10, 0xccf52569,
    0x9ff75abb, 0x5a7f55a3, 0x8aa760c7, 0x8302335d, 0x8d98dbe8, 0x34d317fd,
    0x47a983a9, 0x9387404a, 0x21df60bc, 0x9b26309e, 0x45dedb9f, 0x15381508,
    0x78d8018d, 0xfdb40261, 0xa89e0036, 0xb05f0142, 0x9def8331, 0x7d6c41ff,
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x38000000, 0x54000000,
    0x5a000000, 0x0f000000, 0xc6800000, 0x60400000, 0x4aa00000, 0x17d00000,
    0xd1780000, 0x38a40000, 0xb4da0000, 0xb9eb0000, 0x9dfc8000, 0x0ff64000,
    0x5cf06000, 0x3c771000, 0x652fa800, 0xe813e400, 0x0c0ee200, 0x3e1e5300,
    0xfd014a80, 0xa59db640, 0xa8d7aae0, 0x7ff7e650, 0x94f4e1e8, 0x6065517c,
    0xc325c97a, 0xd11ff691, 0xcb85caa2, 0xcdcff633, 0x1e7dc9b7, 0x5e2bf41f,
    0x4487c883, 0xcb50f729, 0xde234910, 0x8492b4ae, 0x6b512af7, 0x4e3aa759,
    0xbc800208, 0x3f40008a, 0x14200149, 0xb3900226, 0xf9d8013d, 0x74740370,
    0xf92203be, 0xee0f017f, 0xa5068135, 0xc18d40fa, 0x80000000, 0xc0000000,
    0xe0000000, 0x30000000, 0xb8000000, 0x34000000, 0x92000000, 0xdd000000,
    0xff800000, 0xdcc00000, 0x9e200000, 0xee300000, 0x76280000, 0x92340000,
    0x88320000, 0xd9250000, 0x80a38000, 0x1371c000, 0xafca6000, 0x62a59000,
    0x56760800, 0xb441cc00, 0xa4760a00, 0x9941cf00, 0x03f60980, 0x4181cfc0,
    0xb7d60b60, 0x46b1cf10, 0xac7e0928, 0xd545cc64, 0x45ec0ad6, 0x3e90cf17,
    0x2d4788ae, 0x51e50caf, 0x7c97e976, 0x78519ee7, 0x22706356, 0x06449183,
    0xa96f8b54, 0xeed10ece, 0x5325e86b, 0x79b49c84, 0x16f3e052, 0x12055245,
    0x1d0de86b, 0x1f809c84, 0xecc1e052, 0x26205245, 0xda2e686b, 0xe4315c84,
    0x4f2b8052, 0x77b5c245, 0x80000000, 0x40000000, 0x60000000, 0xb0000000,
    0x08000000, 0xcc000000, 0x92000000, 0xb9000000, 0x10800000, 0xf3c00000,
    0xb4200000, 0xe4300000, 0x1c380000, 0xb8340000, 0x56220000, 0x75230000,
    0x10ba8000, 0x61e8c000, 0x9f1fe000, 0xdf8df000, 0xd45b8800, 0xc4610c00,
    0xce5b8a00, 0xf1610d00, 0x2cdb8b80, 0x0ba10fc0, 0x807b8ba0, 0xd0510cf0,
    0xba6389e8, 0x35550e14, 0xe0f989aa, 0x0b820ddb, 0x12410b7a, 0xfb79ce4b,
    0x81dc6b0a, 0xfd28fcab, 0x9cba0252, 0x93e7017f, 0x96008010, 0xc70fc1f8,
    0xeb9f63ec, 0xe2423046, 0x9364e89d, 0xfdd33c67, 0x672763ec, 0xe9b63046,
    0x1166e89d, 0xdcc03c67, 0x63a5e3ec, 0xfc6af046, 0x4a5b089d, 0xcf6ecc67,
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x98000000, 0xec000000,
    0x2a000000, 0x27000000, 0xa9800000, 0x09400000, 0x11e00000, 0x99f00000,
    0x2de80000, 0x8be40000, 0x16f60000, 0x00650000, 0x4cb88000, 0x7e1dc000,
    0xd1092000, 0xcc841000, 0x63c93800, 0xef390400, 0x60493a00, 0x01790700,
    0xb8293b80, 0x01c90540, 0x1c2139e0, 0xffdd06f0, 0x0d3f3948, 0x535c066c,
    0xfef1bbee, 0x2464c649, 0x72a01ba9, 0x0f0d142e, 0xed88031e, 0xa7540201,
    0xf8fe0145, 0x49710100, 0x6c2681f7, 0x37dcc2b8, 0x1927a0d3, 0x054cd23a,
    0x6bf099f4, 0x46f4d51a, 0xf87720d3, 0x30b5123a, 0xcc0fb9f4, 0x1a15c51a,
    0x4f0698d3, 0x4d91d63a, 0x574fa3f4, 0xf0e8d21a, 0x80000000, 0x40000000,
    0xe0000000, 0x10000000, 0xf8000000, 0x84000000, 0x26000000, 0xa7000000,
    0x3a800000, 0x9ec00000, 0x4fe00000, 0x87f00000, 0x4bf80000, 0xe1e40000,
    0x0ce60000, 0xcb790000, 0x6a298000, 0x008d4000, 0xcbc9a000, 0xec66f000,
    0x10b92800, 0x7e5ad400, 0x94392a00, 0x939ad500, 0xdf592980, 0xb9aad540,
    0x3fc12a60, 0x627ed750, 0x2bbf2af8, 0xf6d3d5cc, 0x73e8aa12, 0xc5f397b7,
    0xdaf68b2d, 0x847525a8, 0x2cb18202, 0x3c59422f, 0x0537a031, 0xf60bf002,
    0xff0eaa19, 0x4e8a9440, 0x50df08d6, 0x94f864e1, 0x1f78238c, 0x543fb3c4,
    0x338e88d6, 0x2f5124e1, 0x51b7838c, 0x43d043c4, 0xc06620d6, 0xaaa2b0e1,
    0x6b41098c, 0xd7a566c4, 0x80000000, 0x40000000, 0x20000000, 0x30000000,
    0x28000000, 0x34000000, 0x76000000, 0x53000000, 0xb1800000, 0x57400000,
    0xf5e00000, 0x4bf00000, 0x7cf80000, 0x837c0000, 0xab3a0000, 0x855f0000,
    0x88e98000, 0x957f4000, 0xe8392000, 0x2ccd1000, 0xc3b4f800, 0x2291c400,
    0x86ccfa00, 0xb2adc500, 0xa616fa80, 0x2b02c5c0, 0xbd877a20, 0x0d418510,
    0xcce45bf8, 0xeb63945c, 0xbf21213e, 0xc3411101, 0xf3f6f8e9, 0x10f2c52e,
    0xc97f7b9a, 0x8a3d86e3, 0x39de5916, 0x093c94e6, 0xf048a24d, 0x527e532f,
    0x5fafd8f3, 0x208fd68d, 0x83d3806c, 0x602043b5, 0x68d0a273, 0xbdb2534d,
    0x758dda4c, 0x695cd6a5, 0x82f8018b, 0x947c0311, 0x64ba0172, 0x851f02a4,
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x98000000, 0x0c000000,
    0x6a000000, 0x85000000, 0x30800000, 0xd7c00000, 0x7ae00000, 0x9cf00000,
    0x33f80000, 0xa67c0000, 0x11360000, 0x24050000, 0xce148000, 0x0b11c000,
    0x1b856000, 0x9c497000, 0x7ea08800, 0xee5e5400, 0xb7b88a00, 0x94d25500,
    0xb5768a80, 0x46ab5440, 0xf25408e0, 0x65bf9470, 0x4dc5e948, 0x77e72664,
    0x1860018a, 0xd230013b, 0xab980261, 0x344c0248, 0x9aae022e, 0x40490191,
    0xccba800a, 0x4758c131, 0xbd3fe29a, 0x5e11b309, 0xf31f6a36, 0x678fe627,
    0x3e47e027, 0x6fadb2ed, 0xb8c968b6, 0x8f7ae667, 0x5bab62c7, 0xcec0739d,
    0xd87a0b7e, 0xb2369443, 0xdb9f6bad, 0xfc4fe6d6, 0x80000000, 0xc0000000,
    0x20000000, 0xd0000000, 0x48000000, 0xa4000000, 0xb6000000, 0x69000000,
    0x56800000, 0x18400000, 0x4e200000, 0xcc300000, 0xbb280000, 0xd0ac0000,
    0xb0760000, 0x631f0000, 0xa59b8000, 0x15d54000, 0x0ffc6000, 0xeddcb000,
    0xd3feb800, 0x47cffc00, 0x30f6ba00, 0x2253ff00, 0x0528ba80, 0xfda0fc40,
    0xa0e53ba0, 0x8a5abed0, 0x512ad978, 0xd3bf4f74, 0x25fe0022, 0xcec30315,
    0x9665831a, 0xa2164325, 0xa719e176, 0x238af327, 0xc4c75a97, 0x65750c3b,
    0xaf99e0d9, 0xe6caf2c8, 0x02675b3c, 0xac050d5e, 0xf211e2eb, 0x2f16f1a1,
    0xa79959bc, 0xa2c60d1e, 0x4474634b, 0x5d00b071, 0x4880ba44, 0x254cfe2a,
    0x36b338c9, 0x5175bdb4, 0x80000000, 0x40000000, 0xa0000000, 0x30000000,
    0x38000000, 0xc4000000, 0xe6000000, 0x85000000, 0x23800000, 0x39c00000,
    0x84e00000, 0x5ef00000, 0x19f80000, 0xc96c0000, 0x5e2a0000, 0x3c8d0000,
    0xfd458000, 0x5db14000, 0x7545e000, 0xe1bf9000, 0xf753a800, 0xb2b1b400,
    0x69cbaa00, 0x6cedb500, 0x32f9a880, 0x33fcb5c0, 0x566e2860, 0xdaacf6d0,
    0x45c44bf8, 0xe6ef24c4, 0x9df78376, 0x8f604023, 0xeb326365, 0x271fd058,
    0x0081c982, 0x3f5e67bd, 0xaeb2621a, 0xdbdfd15f, 0x07e1caf7, 0x686e67fd,
    0x0baa63cc, 0x8843d24c, 0xa633c9fa, 0x188f6539, 0x8b45e34c, 0xd0bf938c,
    0xaad3ab9a, 0xfa71b6e9, 0x10aba834, 0x4addb688, 0x6a61aa8c, 0x18a0b51a,
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x88000000, 0xac000000,
    0x5e000000, 0x2d000000, 0xf8800000, 0x88c00000, 0x5ea00000, 0x13b00000,
    0xfb380000, 0x1be40000, 0xb94e0000, 0x7cef0000, 0x06c28000, 0xbbad4000,
    0xa726e000, 0x7df6f000, 0xe0556800, 0xfe6bfc00, 0x511b6a00, 0x6e84fd00,
    0xe9d9e980, 0xa829bc40, 0x3e7f0ba0, 0xf11f4ef0, 0xde8a62d8, 0x31c4b244,
    0x8c290b3a, 0xcc644d67, 0x821ee3c0, 0x0b12f169, 0x419b6b8c, 0x5a44fff6,
    0x8179ebb1, 0x6a99bc41, 0xebc70890, 0xe33b4fc8, 0x9fe463cc, 0xfb5bb256,
    0xd7f38a41, 0xf75d0e19, 0x39ee0114, 0x025f0012, 0xe57a817b, 0x7889437e,
    0xc8c8e2d4, 0xbea9f17b, 0x43afeaf7, 0x7322bc88, 0x80000000, 0xc0000000,
    0xa0000000, 0xf0000000, 0xa8000000, 0xf4000000, 0xf6000000, 0xbf000000,
    0x7c800000, 0x07c00000, 0x4ee00000, 0x81f00000, 0x95680000, 0xc6bc0000,
    0x8e420000, 0x18a70000, 0x05518000, 0x32334000, 0x4d86a000, 0xa85e3000,
    0x3fa74800, 0x85c1d400, 0xc7e54a00, 0xe266d700, 0x1e34c880, 0x279594c0,
    0xb5526a20, 0xfa3ba710, 0xe99d21f8, 0x064671ec, 0xdcba6a0a, 0xfb47a6f3,
    0x893f23b1, 0x6f117034, 0xe483ebc4, 0xfbc8e43e, 0xbcfb8005, 0x60e841b0,
    0xa2f5201a, 0x4bfa708b, 0x78786a1d, 0xab20a6de, 0x160ea307, 0x2f1233e7,
    0x848d4be5, 0xabdad732, 0xe4f6c90d, 0x3cf29514, 0xa0e3e854, 0x02f8e706,
    0xbbf382c9, 0xd064412a, 0x80000000, 0xc0000000, 0xe0000000, 0x90000000,
    0x88000000, 0x1c000000, 0x16000000, 0xb9000000, 0x3f800000, 0x2a400000,
    0xf3e00000, 0x62f00000, 0xf1680000, 0x35340000, 0x7bc60000, 0xa4a70000,
    0xcc8c8000, 0x9ada4000, 0x2f3b6000, 0x9cd39000, 0xde3e5800, 0x5f446400,
    0x72785a00, 0x9da36700, 0x3314d980, 0x50892540, 0x4cc7bba0, 0x762eb530,
    0x335fe3f8, 0x7c7dd3d4, 0xb0a33906, 0x0680f47d, 0xd5c28349, 0x39b940b6,
    0x0119e32c, 0x1b9ad152, 0xd84fbb3b, 0x58eab714, 0x6671e08f, 0x57aed042,
    0x7c09bada, 0x460db4b7, 0xd11d62f6, 0xb384910c, 0xb45ad922, 0x56ea2763,
    0x4b653bf0, 0x6227f571, 0xf94e026b, 0x336303d5, 0xa62282dc, 0x9b494323,
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x58000000, 0x2c000000,
    0x12000000, 0x31000000, 0x0e800000, 0x1f400000, 0x62e00000, 0x1bf00000,
    0x81780000, 0xd02c0000, 0x19d60000, 0x49ad0000, 0xe7108000, 0x699ec000,
    0x36dee000, 0xf43a3000, 0x3fdd5800, 0xe6a5c400, 0x1a8b5a00, 0x1148c500,
    0x69fbd880, 0x80660640, 0xf6bd39e0, 0xa28036f0, 0x4d4e61a8, 0xf3e4f234,
    0xc563bb92, 0xc62ff749, 0x9ece0299, 0x10310166, 0xf9de817c, 0x39afc0d6,
    0x6f0062b3, 0x1d95f2c4, 0x08dd383d, 0xd730376b, 0x0056631f, 0xf778f16d,
    0x672db8d4, 0x685ef7e5, 0xf37082b7, 0xd12ec359, 0x3f46e346, 0xf2e630ac,
    0xe3f3582e, 0x7d64c63f, 0x9a2dd83a, 0x04cb057a, 0x80000000, 0x40000000,
    0x20000000, 0xf0000000, 0xf8000000, 0xa4000000, 0x1a000000, 0xa7000000,
    0x88800000, 0x6b400000, 0x07200000, 0x08300000, 0x6cb80000, 0x61fc0000,
    0x8fc20000, 0x4a6d0000, 0xc6018000, 0x591ec000, 0x15982000, 0xb4cc3000,
    0x1cf4d800, 0xc04cfc00, 0x79b6da00, 0xa261fd00, 0x0a175a80, 0xcf0f3ec0,
    0x04977960, 0xdd4f0c50, 0xe639a108, 0x99a2f2cc, 0x3274f92a, 0x220cce61,
    0x631803b6, 0x428c0081, 0xc45a0364, 0xd3a10156, 0xdd7b8253, 0xd68fc3b3,
    0x465ba0e1, 0x00bff376, 0x47ed7ae1, 0x46de0eb4, 0x77fa231e, 0xded130bf,
    0x03ed5be9, 0xccde3c78, 0xf8f4fa34, 0xfa4ccede, 0x2eb8005f, 0xd2fc00f9,
    0xc5420350, 0xd22d0288, 0x80000000, 0xc0000000, 0xa0000000, 0x30000000,
    0xd8000000, 0x1c000000, 0x46000000, 0xd1000000, 0x20800000, 0x42400000,
    0xae200000, 0xfb300000, 0xe1a80000, 0xa4fc0000, 0x135a0000, 0x4eb10000,
    0x197a8000, 0x7f9e4000, 0x87c66000, 0xeee77000, 0xac53b800, 0xdb233c00,
    0x11a9ba00, 0xdce23f00, 0x3f5b3880, 0xd0b07fc0, 0xd46f5be0, 0x191a0fb0,
    0x149c62f8, 0x605670f4, 0x1529387a, 0x94bd7efd, 0x4e6fda42, 0x2e054ed1,
    0xd5088024, 0xda9340f2, 0xe546e011, 0x87b831fc, 0x85e75b6e, 0x4bd60e8f,
    0x20ee622b, 0x295b70a1, 0x49a9b83c, 0x00e23e36, 0xd95b38d3, 0x31b07c55,
    0x2cef5a46, 0x475a0fcb, 0xfcbc6211, 0x4a667144, 0xd4013b82, 0x72017f89,
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xf8000000, 0x4c000000,
    0x6a000000, 0x8f000000, 0x43800000, 0x02400000, 0x7fa00000, 0xf4b00000,
    0x59280000, 0xfa6c0000, 0x47560000, 0xa3390000, 0x6d788000, 0xb8c9c000,
    0xe3762000, 0x29d35000, 0x29e99800, 0x5d14ac00, 0x609f9a00, 0xdbddaf00,
    0xdaef1a80, 0x7c886c40, 0x89c73960, 0x39fe3d70, 0x850820c8, 0xfc86534c,
    0x49c71bc6, 0x19e46c45, 0x551138b8, 0x04873fd7, 0x05d0a2bc, 0x73ff924e,
    0xda193be9, 0x471b3cce, 0x078ea07a, 0x0c5a9058, 0x2ebfba67, 0x1e37fe54,
    0xfdfe0292, 0x4b150057, 0x8d8e82af, 0x7340c118, 0x4526a354, 0xa8769312,
    0xa449b897, 0x5abefe8f, 0x182e8288, 0xc8f0c32c, 0x80000000, 0x40000000,
    0xe0000000, 0xd0000000, 0xf8000000, 0x14000000, 0xe6000000, 0x99000000,
    0x47800000, 0xef400000, 0x4de00000, 0x12f00000, 0xbc780000, 0xdca40000,
    0x421e0000, 0x17110000, 0xd29b8000, 0x8adb4000, 0x25b26000, 0x95959000,
    0xe052f800, 0x5b738400, 0x8634fa00, 0x14c68500, 0xe8b17980, 0xd40cc640,
    0x46189a60, 0xa9021610, 0x6f9801f8, 0x03540074, 0xbfe602e6, 0x6df502c9,
    0x62e58051, 0x747a41c2, 0xe0b1e140, 0x481ad2e0, 0x7c069bd0, 0xea1314d8,
    0xbb038384, 0xc08f404e, 0x25d463a5, 0x03209013, 0x29577ab5, 0xa4f9c51c,
    0x9d7d1bdd, 0x6f385627, 0x9b49e233, 0x3bfed1c5, 0x93f89a74, 0x3ff21791,
    0x2de00195, 0x82f001ec, 0x80000000, 0x40000000, 0xa0000000, 0xb0000000,
    0xc8000000, 0x4c000000, 0x3a000000, 0x1f000000, 0x94800000, 0xebc00000,
    0x37600000, 0x82700000, 0x31f80000, 0x6aac0000, 0x701a0000, 0x28130000,
    0x5c128000, 0x4201c000, 0x9b142000, 0xe29fb000, 0xcecb4800, 0xbceae400,
    0xfd294a00, 0xed55e500, 0xdfa1c880, 0xc38727c0, 0x73476ba0, 0x46a956f0,
    0x1a000348, 0xef00028c, 0xfc80031a, 0x17c00023, 0xc5600147, 0xd17000ea,
    0x9f7802a0, 0x9e6c0070, 0xd3fa0388, 0x41a300ac, 0x5a8a80aa, 0xaaddc20b,
    0xdaf6221b, 0xa020b388, 0xe2c3c9e7, 0xd6f824d1, 0x3a2fe9d3, 0x4dcb96c4,
    0x8a7ea15d, 0x9df27202, 0x40a56bdc, 0x171654a2, 0x388880e7, 0xc1d2c251,
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xa8000000, 0x2c000000,
    0xfe000000, 0x51000000, 0xef800000, 0x06400000, 0x57600000, 0x10700000,
    0x22e80000, 0x05240000, 0xfd0e0000, 0xd18b0000, 0x37568000, 0xe8e54000,
    0xbe356000, 0x59859000, 0xeb5cd800, 0x8efbf400, 0x3b3ada00, 0xcc14f700,
    0x6e025b80, 0x990ab640, 0x9389b920, 0x504e66f0, 0x2a6e02d8, 0x01fb03b4,
    0x75be8366, 0xbdc140ad, 0xeb3b63bb, 0xa40e91ac, 0x220a5990, 0x371eb508,
    0x6a8fbb9c, 0x93d1640a, 0xd23e817f, 0x078142f0, 0x8a5b627a, 0x997e9067,
    0xb9625b24, 0x497ab64c, 0xd161bb22, 0x056a6593, 0x7f600162, 0xfc700011,
    0xbce80241, 0x0424038b, 0xba8e0194, 0xfbcb02b4, 0x80000000, 0x40000000,
    0x60000000, 0xb0000000, 0xc8000000, 0x7c000000, 0xc2000000, 0x13000000,
    0x61800000, 0xc3400000, 0x58200000, 0xa1300000, 0x5fb80000, 0x97740000,
    0xd3020000, 0x418b0000, 0x134c8000, 0x2038c000, 0x153ca000, 0xe1a19000,
    0x467a7800, 0xa19f3c00, 0xe3407a00, 0x88203d00, 0xd92efb80, 0xeba3ffc0,
    0x2966d8a0, 0x020eae30, 0x330203a8, 0xb18b027c, 0xbb4c802e, 0xec38c071,
    0x1f3ca0ce, 0x8ea19035, 0xe5fa7a90, 0x71df3f98, 0xdae078d4, 0xea503fd2,
    0xdeb6f89f, 0xdde7fe9f, 0xa5dcda8b, 0xd4f1ae6d, 0xf34c81e4, 0xd038c2fa,
    0xbd3ca2a3, 0x2da193d1, 0x4c7a796a, 0xce9f3cbb, 0x40c079c5, 0x58603d98,
    0xe08ef9d4, 0x89d3fe52, 0x80000000, 0x40000000, 0xa0000000, 0x50000000,
    0xf8000000, 0x2c000000, 0x96000000, 0xcf000000, 0x62800000, 0xdd400000,
    0xfea00000, 0x4bb00000, 0x90380000, 0x10ec0000, 0xf9860000, 0x45c90000,
    0xdae48000, 0x48924000, 0x9c59a000, 0x8f36f000, 0xca66d800, 0xa8d6cc00,
    0x7d78da00, 0xa643cd00, 0x96225880, 0xc7f48c40, 0x47197b60, 0xa6993cf0,
    0x3f428138, 0xdbab43cc, 0x882522b2, 0xccf8b1b9, 0xc7817bc8, 0x5ec53dd7,
    0x027c8068, 0xccce4024, 0xcf67a156, 0x7b53f24f, 0x79a45ad7, 0x0d3d8de8,
    0x5f7df8e4, 0x634b7c76, 0xa5bb20df, 0x332db39f, 0x447bf95c, 0xbbc27ffa,
    0x21ffa30d, 0x600ff3d6, 0xb01a5b2c, 0x08188da1, 0x841f7ab7, 0x42103ebb,
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x48000000, 0x5c000000,
    0x3a000000, 0xe7000000, 0x99800000, 0x04400000, 0xbb200000, 0x0a300000,
    0x46b80000, 0x407c0000, 0xec8a0000, 0xf6d30000, 0xc4f08000, 0xf643c000,
    0x40312000, 0x89b71000, 0x15e61800, 0x2acd3c00, 0xbef41a00, 0x31523d00,
    0x69b69a80, 0xc5feffc0, 0xf2dd3ba0, 0x1ae92eb0, 0x1f428348, 0xe8acc12c,
    0x816ba32e, 0x8817d03d, 0x3c1fb942, 0xaa05eed5, 0x1f092378, 0x8d8b13a4,
    0x624c1aa2, 0x662e3c23, 0x74bc9877, 0xdb6dfd5b, 0xff0dbad3, 0x5d9aef79,
    0xba4ba030, 0xc227d02e, 0x5aa7bb1b, 0x5a79ed95, 0xbb8322be, 0x275813a3,
    0x9cbc9b91, 0x776dfdac, 0xad0db948, 0x569aee8a, 0x80000000, 0x40000000,
    0xa0000000, 0xb0000000, 0x58000000, 0xac000000, 0xde000000, 0xe9000000,
    0x99800000, 0x82c00000, 0x9d600000, 0x3e700000, 0x6cf80000, 0x08ac0000,
    0x239a0000, 0xb1c10000, 0x67fc8000, 0x0e234000, 0x85c06000, 0xf5fc5000,
    0x29378800, 0x1d48e400, 0x1ab58a00, 0x4495e500, 0x894b0880, 0x38aba7c0,
    0x3b95e9e0, 0xbdd9b570, 0x09e48298, 0xbf3f42d4, 0xb04262fe, 0xa92151df,
    0x5d490a0b, 0xbab6a7e6, 0xf48b68d8, 0xd157f474, 0x94a261ae, 0xe59153d7,
    0x54d10937, 0x906aa654, 0x3de96aad, 0x2d3af51e, 0x9744e23c, 0x31b31332,
    0xb20de8b5, 0xd705b40a, 0x60868322, 0xf352429d, 0xeba4e0a6, 0xd10312f8,
    0x6595eae4, 0x14d9b746, 0x80000000, 0x40000000, 0xe0000000, 0x50000000,
    0x08000000, 0x54000000, 0xd6000000, 0xe5000000, 0xab800000, 0xe9400000,
    0x1b200000, 0x70b00000, 0x39f80000, 0x92c40000, 0xba7e0000, 0xdf870000,
    0xcf498000, 0x462d4000, 0xd736e000, 0x5aaa1000, 0xeefa7800, 0x525ffc00,
    0x41b3fa00, 0x0472bd00, 0x7e851980, 0x5ad8ac40, 0x4e7f61a0, 0xb9875110,
    0x724c98f8, 0xb1b5ef84, 0xbc6983d6, 0x729d4061, 0xd0cee21a, 0x296e10b3,
    0x21047a05, 0xd598fd7c, 0xe85a7b3a, 0x3eaffe63, 0x20ebfa1d, 0x0b46bfc8,
    0x38231b44, 0xd62bafde, 0x7f30e1c5, 0xbea911f4, 0x60edf95e, 0xeb45bf6d,
    0x68349bc0, 0xde31ec88, 0x2b378264, 0x68aa410e, 0x85ff61dd, 0x40c75340,
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x18000000, 0x54000000,
    0xfa000000, 0x83000000, 0xca800000, 0x95c00000, 0xb7a00000, 0x2d300000,
    0x70f80000, 0x1b5c0000, 0x307a0000, 0x75810000, 0x89578000, 0x9f72c000,
    0x8103a000, 0xcd9d7000, 0x2d550800, 0x5d745c00, 0xe6028a00, 0xe5069d00,
    0x6f812a80, 0xda5befc0, 0xddf422e0, 0xe8dfb290, 0xcc2eab08, 0x2d752d9c,
    0x9e0d82a2, 0x2103c00b, 0x3d8c229c, 0x1543b22f, 0xb974a857, 0x04042fde,
    0x32020234, 0x5f1d0203, 0xcc8d808d, 0xa0c3c351, 0x502c225e, 0x0b73b179,
    0x1b0caabf, 0xde982e5f, 0x4fd800c2, 0x84ac0356, 0xffa202e8, 0xb12d0181,
    0x56f582f6, 0x9e5fc155, 0xcff62265, 0x07c2b2d0, 0x80000000, 0xc0000000,
    0xa0000000, 0x50000000, 0x48000000, 0x9c000000, 0x42000000, 0x51000000,
    0xc2800000, 0x25c00000, 0x65600000, 0x9ff00000, 0xfe280000, 0xad5c0000,
    0xeda60000, 0x8a070000, 0x0d088000, 0x2086c000, 0x24dbe000, 0xeff33000,
    0x26354800, 0xd9500400, 0x63bdca00, 0xd116c700, 0x02862880, 0x85d5f640,
    0x357b61a0, 0xd7e9f030, 0x6228aaa8, 0xef543674, 0xbca80122, 0x489c00a3,
    0x28c60117, 0x45f702ec, 0xbb208047, 0x11dac22d, 0x8b7de0d3, 0x34f433a6,
    0xe9bdcb70, 0xdc16c488, 0x22062884, 0xa115f46a, 0xda9b6347, 0xf1d9f0ad,
    0xbb60a993, 0x8cf83686, 0x6da60300, 0x4a070280, 0xad088140, 0x7086c120,
    0x6cdbe270, 0x73f33108, 0x80000000, 0x40000000, 0xe0000000, 0x70000000,
    0x38000000, 0x04000000, 0x76000000, 0xdf000000, 0x84800000, 0x84400000,
    0xfca00000, 0x5c300000, 0x7e780000, 0xf5c40000, 0x617a0000, 0xd1450000,
    0x75218000, 0x65e54000, 0x1503a000, 0x6996b000, 0x49c97800, 0x53784c00,
    0x9848fa00, 0x5ead0d00, 0x5d335980, 0x69ffbcc0, 0xbf002160, 0xb482f0d0,
    0x5c495ab8, 0x88babeac, 0x1221a12a, 0xa567b07d, 0x074afbb8, 0x3a2c0ddd,
    0xa968daf9, 0xad5ffda6, 0xe72203d6, 0xbcf1025e, 0x768380da, 0x6d5442c4,
    0x472022cf, 0x2cf2f168, 0x3e915a94, 0x514ebfc6, 0x3523a177, 0x85e6b0b5,
    0x65117a6d, 0x518c4f60, 0x4dcafb21, 0x256c0e2b, 0x4748dbd7, 0xda2ffd74,
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x48000000, 0x5c000000,
    0xaa000000, 0xb5000000, 0x17800000, 0x42400000, 0x06200000, 0xddb00000,
    0x8de80000, 0x0acc0000, 0x06fa0000, 0x9e5b0000, 0x6c3c8000, 0x48a3c000,
    0xaa666000, 0x00841000, 0x5ccd9800, 0xe9f43c00, 0x54d11a00, 0x55e7ff00,
    0xeedf7a80, 0x98efefc0, 0xed48e3a0, 0x2cb0d2b0, 0xf46d7b08, 0x5388ef64,
    0x2c4661d6, 0x1d3411ad, 0xf1259a6e, 0xd3383c6b, 0x1a2b1951, 0x97bcfc24,
    0x28e3fa1c, 0x654c2c30, 0x50ae8062, 0x6e74c0c9, 0xae80e012, 0x67ccd34b,
    0xf57f7b8b, 0x421fec01, 0x1900e27c, 0xd58cd320, 0x9b5f78da, 0xf3afef25,
    0x76e8e2e0, 0x3640d0d0, 0x20257b18, 0x9ab4ed5c, 0x80000000, 0xc0000000,
    0xa0000000, 0xb0000000, 0x98000000, 0x5c000000, 0x12000000, 0x07000000,
    0x4e800000, 0x4ac00000, 0xf7e00000, 0x2b700000, 0xa6a80000, 0xbfdc0000,
    0x6e7a0000, 0xa7210000, 0x6f868000, 0xb556c000, 0xaaab2000, 0xe5de7000,
    0xbd60e800, 0x8fb3b400, 0xf44e6a00, 0x45397700, 0x909f4880, 0xb7c605c0,
    0xda7922e0, 0xd12370b0, 0x969c68a8, 0x76c477ac, 0xf5e3c912, 0x0471c747,
    0x2c34822d, 0xbb1bc05a, 0x8c9fa09f, 0xc5c5b0c9, 0xcd7f4ad4, 0xb7b605a2,
    0x185121ef, 0xcf3f7081, 0xcb866ac8, 0xeb557498, 0x97ad48c4, 0x684b075e,
    0xf72da065, 0x2788b102, 0x614bcabb, 0xccadc727, 0x34ce8219, 0xbafac30c,
    0x9ef92246, 0x00e370e1, 0x80000000, 0xc0000000, 0x20000000, 0x50000000,
    0x78000000, 0x14000000, 0x2a000000, 0x69000000, 0x0e800000, 0x54c00000,
    0x82200000, 0xc6b00000, 0x4b680000, 0xcfcc0000, 0x61b60000, 0xeef10000,
    0xb08f8000, 0xd7d4c000, 0xc5a4e000, 0xccfcb000, 0xe583e800, 0x9f40cc00,
    0xc6646a00, 0x03580f00, 0x10768a80, 0x0c55be40, 0x19fae360, 0x6d01b210,
    0xbc9a69c8, 0x59d50cb4, 0x8ea70b72, 0x977c7fa7, 0xf9c7801a, 0x1ea8c1ad,
    0xcf7ae27f, 0xbdc1b066, 0x4cba6beb, 0xb2650e6a, 0x994f08fb, 0x71707c2c,
    0x3ed180e0, 0x0b29c3de, 0xb83d6007, 0x37a97324, 0x21e08a7a, 0x9914bc33,
    0xe69d6118, 0x18d97152, 0xec288859, 0xfda8beed, 0x38e36291, 0xbf9472d9,
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x28000000, 0x84000000,
    0x82000000, 0x55000000, 0x37800000, 0xb0400000, 0x3be00000, 0x06700000,
    0x37380000, 0xb15c0000, 0xc66e0000, 0x57330000, 0x814f8000, 0xfe69c000,
    0xfb3c6000, 0x87431000, 0x2963d800, 0x99a14400, 0x00945a00, 0xa2d48500,
    0xa4263a80, 0x31d49540, 0x24b26220, 0xd3001350, 0xa0945a28, 0xf2d48704,
    0xac263876, 0xa5d49485, 0x8eb260b9, 0x020012cc, 0x151458cd, 0x1794864d,
    0xa0463b82, 0x13e495c4, 0x826a6196, 0xb52c12b5, 0xe4425ae1, 0xf1fb8430,
    0xe767b9d7, 0xbabe571a, 0xf81980d8, 0xcc06c3bc, 0x361de33a, 0xef19d207,
    0xce903972, 0x81cb957c, 0x5cabe0da, 0x5f06d137, 0x80000000, 0x40000000,
    0x20000000, 0x70000000, 0x48000000, 0x8c000000, 0x9a000000, 0x57000000,
    0x4b800000, 0x50400000, 0x0ca00000, 0x65300000, 0xe6780000, 0x975c0000,
    0x1f220000, 0xa1730000, 0xc4ce8000, 0xfb67c000, 0xf3d22000, 0xe0ffd000,
    0x9b851800, 0x28462c00, 0xe8b39a00, 0x033ded00, 0x6363ba80, 0x07c13cc0,
    0x9ef023a0, 0xaa8cd2f0, 0xe6cb9bc8, 0x2861eeac, 0x8e41b866, 0x0db23f2d,
    0xc3bea1f4, 0xdaab1149, 0xc839bb25, 0xaaee3d78, 0xb49ca29f, 0x87d81320,
    0xdef73b30, 0x8a89fee8, 0x96ce829c, 0x6067c10e, 0x025223f1, 0x97bfd39a,
    0x94a519e8, 0x91362c87, 0x986b9b74, 0xa651ec12, 0xd1b9b8bf, 0x61ae3d0b,
    0x49bca222, 0x95a810d7, 0x80000000, 0x40000000, 0xa0000000, 0x70000000,
    0x88000000, 0x04000000, 0x66000000, 0xc5000000, 0x57800000, 0xcac00000,
    0x99a00000, 0x6c300000, 0xe5f80000, 0x3ecc0000, 0x37b20000, 0x0d3b0000,
    0xa4678000, 0xb9114000, 0xfd86e000, 0xcdd59000, 0x1d348800, 0xbc6ddc00,
    0xe50b0a00, 0x67809d00, 0xe2c7e880, 0xeda20cc0, 0x8226e2a0, 0x24e590d0,
    0x0f4c8938, 0x3861dec4, 0xc31908e6, 0x028b9d2f, 0xc5586a20, 0xaf7f4d4f,
    0x1f92020f, 0x2ecb02b0, 0x2fbf8017, 0x512d43bb, 0x3e6ce33e, 0x96129204,
    0x0d190b19, 0xf38b9c68, 0xdcd86bbc, 0xd4bf4c42, 0x3fb201b9, 0x493b01e7,
    0x62678113, 0x0c114322, 0x2206e016, 0x03159058, 0xe294886b, 0x155ddcd9,
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xb8000000, 0x94000000,
    0xaa000000, 0xb9000000, 0x77800000, 0x87c00000, 0x5b600000, 0xc2f00000,
    0xbe280000, 0x97c40000, 0xd36a0000, 0x8ef50000, 0x70338000, 0x3cd4c000,
    0x89fae000, 0xd4b99000, 0x159aa800, 0xd2d1a400, 0x72e12a00, 0xa6316700,
    0x93d9cb80, 0x3179f4c0, 0x1bfae160, 0x39b99290, 0xa81aa9c8, 0x1c11a774,
    0xe6012b96, 0x770165ab, 0xdc91c99b, 0xdd4df730, 0x0138e32b, 0xa74891db,
    0x50232910, 0x6cc0641b, 0xa1e04be3, 0x08a8353c, 0x939b8131, 0x55d0c2aa,
    0x1670e29a, 0xef7c9231, 0x38e12b2a, 0x2f31655a, 0x3c59cad1, 0xd2b9f67a,
    0x529ae072, 0xd64992f5, 0xcbb2abc4, 0xb515a47d, 0x80000000, 0xc0000000,
    0x20000000, 0x70000000, 0x38000000, 0xdc000000, 0xde000000, 0x6d000000,
    0x90800000, 0x6dc00000, 0x1e600000, 0x34f00000, 0xf6280000, 0xebcc0000,
    0x3f720000, 0x127d0000, 0x62fa8000, 0x5f2b4000, 0x094fe000, 0xd9b17000,
    0x2d948800, 0x754d2400, 0xb7a60a00, 0x589a6700, 0x49d3ea80, 0x3c6a16c0,
    0xf7e7e260, 0x33bd71b0, 0xca868b18, 0x92c02704, 0x55f48bda, 0x30bd2473,
    0x2f0e0bc3, 0xc3966610, 0xc041eb83, 0xab27177b, 0xa3556244, 0xdeaa3331,
    0x9a136bf4, 0xdf005429, 0x3b8882f0, 0x3c5642f3, 0x05356303, 0xf65a3170,
    0x923b6bb3, 0x29cc5623, 0xac7a80e0, 0x9feb40bb, 0xa7afe06f, 0xf08170d6,
    0xfddc88ae, 0x76712651, 0x80000000, 0x40000000, 0xe0000000, 0xb0000000,
    0x88000000, 0xd4000000, 0x46000000, 0xd9000000, 0x81800000, 0xd5400000,
    0xd0600000, 0xc0f00000, 0xe0380000, 0xf3040000, 0x02820000, 0xffdb0000,
    0xabbd8000, 0x15534000, 0x70616000, 0x90efd000, 0xd83fb800, 0xaf059400,
    0x90803a00, 0x60cdd500, 0xf33cd980, 0x418147c0, 0x755a03a0, 0x806f0090,
    0xf8e780b8, 0xbc3c42f4, 0x6106e13e, 0x9d939361, 0xa759585f, 0xff660732,
    0x106160c7, 0x60efd29a, 0xb03fbb4b, 0xcb0595f0, 0x5e803904, 0x6dcdd636,
    0x34bcdbfd, 0x4dc1454d, 0x24ba01a9, 0x95df036f, 0xc8bf831a, 0x8fc8408b,
    0x83bce050, 0x914c9294, 0x0e66d80e, 0x15ee4649, 0xcbbd8393, 0xe5534338,
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x08000000, 0xfc000000,
    0xae000000, 0x11000000, 0x24800000, 0x8d400000, 0x88600000, 0x45f00000,
    0x68280000, 0x870c0000, 0x918e0000, 0xd3d70000, 0xd62c8000, 0x5e1b4000,
    0x69106000, 0x60977000, 0x47451800, 0xc3653400, 0x22679a00, 0x7ee97700,
    0xb7bb7a80, 0xf5d54540, 0xfb2602a0, 0xf49b02b0, 0x65428218, 0xc47c41f4,
    0x73f4e20a, 0x8d303181, 0xf193780b, 0xa3d94766, 0x6e280113, 0x3a0c023e,
    0x330e0147, 0x23970204, 0xdccc809e, 0x7bab43db, 0x03d86202, 0x3e2b73f1,
    0x12031b73, 0x5f0e35c2, 0x858d1811, 0x31d93563, 0xf121986a, 0x9f82767d,
    0x92d1f95d, 0xdaa50401, 0xbf5ce3e7, 0x477c3098, 0x80000000, 0x40000000,
    0x60000000, 0x30000000, 0x58000000, 0xa4000000, 0x02000000, 0x39000000,
    0x93800000, 0x41c00000, 0x80a00000, 0x3e300000, 0xf6780000, 0xca140000,
    0xd5020000, 0x3d810000, 0xb6d98000, 0xd43fc000, 0x7363e000, 0x9f8d1000,
    0x9fd96800, 0x4fa05c00, 0xfea2ea00, 0xe12e9d00, 0x3ee08b80, 0x11484dc0,
    0xdff802e0, 0x66d40350, 0xfc2200e8, 0xef7102b4, 0x09818326, 0xfcdbc373,
    0x4139e044, 0x2ee8111b, 0x195aeb95, 0x13fa9ed7, 0x98c2888f, 0x63394e26,
    0x47f981d6, 0xe2cfc14e, 0xae3be0a2, 0xbe691388, 0x66036801, 0x1b055e64,
    0xfa81680e, 0xba445c27, 0x3d78eab2, 0x188b9ec0, 0xf3430b45, 0x96e28eda,
    0xcd406211, 0x29e7d209, 0x80000000, 0x40000000, 0xa0000000, 0x10000000,
    0xd8000000, 0xb4000000, 0xda000000, 0xa1000000, 0xcd800000, 0x69400000,
    0xae600000, 0x7ef00000, 0x8c380000, 0x340c0000, 0x9a1e0000, 0x010d0000,
    0xdd8f8000, 0xb156c000, 0x1a79e000, 0xa4e6d000, 0x2d38b800, 0xf98d5400,
    0xf3493a00, 0xaf669500, 0xa3675880, 0x3d6a8540, 0x2e6003e0, 0x3ef00390,
    0x2c380288, 0x240c0014, 0x421e033e, 0xb50d01f1, 0x078f82e7, 0x1056c2da,
    0xd7f9e3bf, 0xcda6d08e, 0x8358bae1, 0x877d552f, 0x7f71392e, 0x9b6a9711,
    0x397959f7, 0x3c678512, 0xf3ef804b, 0x8fa6c020, 0x3641e198, 0x80ead3dc,
    0x6f26baca, 0x4c80545f, 0xf4c6b91e, 0xbf305569, 0x749eb9bb, 0xf0cc5550,
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xc8000000, 0x8c000000,
    0x5e000000, 0xbf000000, 0xa9800000, 0x68400000, 0xd7e00000, 0x15700000,
    0xbea80000, 0x041c0000, 0xb21a0000, 0xf11b0000, 0x6e9e8000, 0x85c34000,
    0x6dada000, 0x23991000, 0xbd57d800, 0x7b76c400, 0x09b35a00, 0x819e8700,
    0x34487880, 0x51e8d5c0, 0x5e6003a0, 0x0d3003f0, 0x014800d8, 0x2d6c020c,
    0x9ab200fe, 0xc607016d, 0x2b048081, 0xa3984308, 0x7d532303, 0xdb6a51e4,
    0xb9b27b6d, 0x4983d781, 0xb8568388, 0x0fef42c3, 0xe17fa044, 0xa4ae139d,
    0x691b59d9, 0xfa828544, 0x8fd2781d, 0x78b3d699, 0x2f1e8024, 0x118342cd,
    0x8c4da371, 0xb5e913d0, 0x3c7fd90f, 0x242ac51a, 0x80000000, 0x40000000,
    0xa0000000, 0xf0000000, 0xa8000000, 0x04000000, 0xba000000, 0xfb000000,
    0xaf800000, 0x36400000, 0xdce00000, 0x42700000, 0xc8b80000, 0x298c0000,
    0xcb420000, 0xce7f0000, 0xc6bb8000, 0x609ac000, 0x6bd4a000, 0x45b7d000,
    0xd3175800, 0xeb952400, 0x2c56da00, 0xd7fce500, 0x45fbf880, 0xfaeef6c0,
    0x4f638220, 0x7226c2d0, 0xa94ea2c8, 0xd974d03c, 0x7736daf6, 0xe7cce725,
    0x4ba3f925, 0x9a12f73c, 0x4b19826f, 0xa795c3b6, 0xc257235c, 0xcee11146,
    0xbd61fb5d, 0xdd2df5e1, 0xe4c203ce, 0xb83f0198, 0xba5b82b4, 0xd2eac12a,
    0x0b6ca0a3, 0x683bd058, 0xa255580d, 0xdeea2769, 0x456d5812, 0x8126261e,
    0xf2cf5bc9, 0xfd29261b, 0x80000000, 0xc0000000, 0x60000000, 0xb0000000,
    0x18000000, 0x1c000000, 0x96000000, 0x9b000000, 0x9c800000, 0x34c00000,
    0x3d600000, 0x94f00000, 0xaba80000, 0x60840000, 0xd2c20000, 0xde790000,
    0xa4668000, 0x117a4000, 0xdae62000, 0x4ca03000, 0xda176800, 0x65102400,
    0x639bea00, 0x92576700, 0x1cb94b80, 0xb20415c0, 0x010683e0, 0x598a41b0,
    0x874e23b8, 0x072430dc, 0x8c55684a, 0x93a926cf, 0x6c9d6adf, 0x8cdd27ec,
    0xf1776ba9, 0xaae026c2, 0x34b3eaf0, 0x76136518, 0xeb1b4acc, 0xe48d1562,
    0x98c8017b, 0xb3740101, 0x13ea03ad, 0xa13d02bf, 0xcf44839c, 0x733343f1,
    0x7e48a3ae, 0x32ae7302, 0xe51b480b, 0xa38d15d9, 0xf2480081, 0xacb4016d,
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x58000000, 0x24000000,
    0xca000000, 0xa1000000, 0xe2800000, 0xe4400000, 0x85600000, 0x44f00000,
    0x3f280000, 0x62840000, 0x245e0000, 0xe56d0000, 0x14f58000, 0x673ec000,
    0x468de000, 0xee4f3000, 0x4479f800, 0xf665f400, 0x837a7a00, 0xc3f23700,
    0xaabc1b80, 0x7b5ec640, 0x94f582e0, 0xa73ec2d0, 0x268de3c8, 0xbe4f3354,
    0x1c79f9c2, 0xd265f585, 0x497a78b7, 0x62f23706, 0x483c1ae3, 0x9f1ec548,
    0x11958098, 0xe3cec1dc, 0x19a5e3f6, 0xdccb30d7, 0x3827f81a, 0x3708f435,
    0x5d8ff8ef, 0x05ccf6fa, 0x0eb1f8e5, 0x7151f627, 0x55ec792e, 0x15ab34e7,
    0x9adf9b02, 0x1f3907a9, 0x929be3f9, 0x4c5633fd, 0x80000000, 0x40000000,
    0x60000000, 0x10000000, 0x78000000, 0xb4000000, 0xfe000000, 0x8d000000,
    0x51800000, 0xb5c00000, 0xc7a00000, 0xd1300000, 0x06780000, 0xc8940000,
    0x2a460000, 0xf7610000, 0x9b0b8000, 0x508e4000, 0xce54e000, 0x11665000,
    0xb2122800, 0x871afc00, 0x4287aa00, 0x7951bd00, 0x5be6cb80, 0x174cad40,
    0xeeed8260, 0x92df4390, 0xb5276398, 0xa07c10a4, 0x8180cb5e, 0xedddae33,
    0x03be03a0, 0x473502a7, 0x476d83c1, 0xd31f42f1, 0xec87624e, 0xec4c116b,
    0xae78c924, 0x2489af89, 0x105802ba, 0xec64010d, 0x8b9e0103, 0xfec5001f,
    0xcf358102, 0xdb7b424e, 0x811961fc, 0x3b89124d, 0xb6cd48f4, 0x7332ec66,
    0xf9616227, 0x3e1d1296, 0x80000000, 0xc0000000, 0x60000000, 0x70000000,
    0x08000000, 0x84000000, 0x7e000000, 0x49000000, 0x24800000, 0x55400000,
    0xd3600000, 0x64f00000, 0xf2280000, 0x01840000, 0x3bda0000, 0xd9230000,
    0x2e0f8000, 0x91064000, 0xb89a6000, 0xd74c7000, 0x68661800, 0xf374d400,
    0xb4fb9a00, 0xea259700, 0xfd9c7b80, 0xc9c8a6c0, 0x6a3583a0, 0x3d9540d0,
    0xa9dde058, 0x1a3e32f4, 0x358e794a, 0x2ddfa661, 0x64280027, 0x7c8402e2,
    0x095a0197, 0x31630100, 0xafef804a, 0x6db640e1, 0xc3526267, 0xae787002,
    0x56741a27, 0x1a63d728, 0x80661ab6, 0xc774d447, 0xa2fb99d8, 0x572595fe,
    0xaf1c7bcb, 0x5188a4f6, 0xe3d5826d, 0x452543c9, 0xac15e2d1, 0x2a0a3345,
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x78000000, 0x9c000000,
    0x6a000000, 0xeb000000, 0x26800000, 0x18c00000, 0x76a00000, 0x15300000,
    0x26680000, 0x379c0000, 0xcd560000, 0xa4e10000, 0xb9568000, 0x4ae9c000,
    0xd447a000, 0x4576f000, 0xe511a800, 0xfb989c00, 0x1f592a00, 0x73fc5f00,
    0x25d60880, 0xc12e6c40, 0x18688160, 0x2294c230, 0x5ec722c8, 0xffbe329c,
    0xeca088d2, 0x9637adbf, 0x44e722e8, 0x094e309b, 0x42e88b59, 0xe05bafa9,
    0xcb792196, 0xf8033369, 0x5c000a61, 0xca0f6f8a, 0x3b1e01fb, 0x5e8d03be,
    0x84c880d2, 0x1ca4c368, 0xfe2f215b, 0x00e231f9, 0x2f568839, 0xbbe6ac4e,
    0xb1d9a06d, 0x9f3bf0d7, 0x7d792ab3, 0x190c5ce2, 0x80000000, 0x40000000,
    0xa0000000, 0xd0000000, 0xf8000000, 0x44000000, 0xc2000000, 0x0d000000,
    0x6b800000, 0x4b400000, 0xf0e00000, 0x9bb00000, 0xfb580000, 0x38fc0000,
    0x57be0000, 0x555d0000, 0x4beb8000, 0xb72ec000, 0xba84e000, 0x96c75000,
    0xfcbad800, 0x61db9400, 0x3e3e3a00, 0xf31cc500, 0xa084e080, 0x4fc75240,
    0x0d3ad960, 0xb39b9650, 0x9f5e3ae8, 0x6aecc424, 0x02bce226, 0xaacb5359,
    0x3abcdb0d, 0x0eca9513, 0x88b3bac6, 0x2bd306a9, 0x5f358095, 0xe683c2ef,
    0x60d7637c, 0x1ba5929a, 0xbb583b03, 0x98fdc72e, 0x87b1630d, 0xad449273,
    0x0fedbb96, 0x753e05c1, 0xb7860071, 0xfd5100e9, 0xb7ed8095, 0x913fc2ef,
    0xa589637c, 0x0848929a, 0x80000000, 0x40000000, 0xe0000000, 0x10000000,
    0x08000000, 0x94000000, 0xb6000000, 0x5d000000, 0xdc800000, 0x3ec00000,
    0x8d600000, 0xcbb00000, 0x8ad80000, 0x8b740000, 0x6eae0000, 0xda5b0000,
    0x9fa78000, 0x9cca4000, 0x26766000, 0xaa2fb000, 0x78820800, 0x30de1400,
    0xbc746a00, 0x2d31a500, 0xc3166180, 0xa59fb140, 0xac5a0ba0, 0x62aa1610,
    0xb05a68f8, 0x00aaa624, 0xbb51e02a, 0x9125f0cf, 0x51146ae7, 0xb681a5c5,
    0xa1ce60e6, 0xaaebb327, 0x7cf409bb, 0x71f1148b, 0x457de8a3, 0xffa0e59f,
    0xccc781a1, 0xce7a41ec, 0x2e2e6238, 0xc69bb1c4, 0xf9cc081a, 0xd6f51567,
    0x4eebea9b, 0x92ffe45b, 0x50f601bb, 0xabef008b, 0x226982a3, 0x5421409f,
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0xc8000000, 0x14000000,
    0xd2000000, 0x45000000, 0x28800000, 0xebc00000, 0xb6600000, 0xc9b00000,
    0x6dc80000, 0x01640000, 0xd43e0000, 0xf6830000, 0x80df8000, 0x6df6c000,
    0xc5e9e000, 0x81fe3000, 0x7bf4a800, 0xbaff5400, 0x887d4a00, 0x32b16700,
    0x7e41e180, 0x192a3140, 0xea02a8a0, 0xc9185610, 0xc69cca68, 0xf8c4a644,
    0xc1f7826a, 0x5be2c3fb, 0xcaffe2db, 0xd0693299, 0xeebd2b06, 0xb85e9667,
    0x8e3d2b0d, 0x879e9664, 0x0a5d2aa8, 0x9b2e97a4, 0x871528da, 0x658a9583,
    0x374b29f7, 0x1fb99737, 0xf2dcabd7, 0x98eb57e7, 0x556b495f, 0x26266793,
    0xc388628d, 0xf04bf324, 0x5a22c808, 0xb587a6b4, 0x80000000, 0xc0000000,
    0xe0000000, 0xb0000000, 0xf8000000, 0xac000000, 0x1a000000, 0xd1000000,
    0x0d800000, 0xfe400000, 0x3ea00000, 0xccf00000, 0x78480000, 0xcda40000,
    0x5c7a0000, 0x21810000, 0x244e8000, 0x0fbcc000, 0x71606000, 0x7e191000,
    0x5f0cb800, 0x8a8b7c00, 0x88ccda00, 0xe4626f00, 0xad886180, 0x6e4d11c0,
    0x96beb860, 0x28ee7c70, 0x36585988, 0xaaafaef4, 0x9aee81de, 0x034cc17d,
    0xe92860ac, 0x03bd10ba, 0xfb76ba93, 0x070a7df1, 0xb6825ace, 0x3adeac0d,
    0xd16800ac, 0xee1401b2, 0xf712002f, 0x6e9501b3, 0xc6dc83a1, 0x8369c196,
    0x6b1ce2e1, 0x4c80d1be, 0x5bd8590d, 0x24efaf24, 0xbc4e834e, 0xd3bcc1cd,
    0x736062cc, 0xb31912c2, 0x80000000, 0x40000000, 0xe0000000, 0xf0000000,
    0x08000000, 0x84000000, 0x3e000000, 0xe9000000, 0x50800000, 0x7ec00000,
    0x30600000, 0xfab00000, 0x5cd80000, 0xdb740000, 0x11320000, 0xd1870000,
    0x1a458000, 0x98b54000, 0x57d5e000, 0xc0eeb000, 0x947e8800, 0x94b53400,
    0xadcb6a00, 0xf7eb8500, 0xddede180, 0xb2eab2c0, 0x67748ba0, 0x033635d0,
    0x9284ead8, 0x65ddc4b4, 0xd3f7803a, 0xf3f2409f, 0xa3f06223, 0xbbebf3c1,
    0xc7f3696a, 0x75ef8533, 0x26e7e28d, 0xa169b374, 0x663b0a2e, 0x780074f5,
    0xcc1e8aa4, 0x5a0536f6, 0x27136b41, 0xb19f841e, 0xaa5fe029, 0x70adb182,
    0x23d10b6f, 0xf6f375eb, 0xf9690b0d, 0xfa3775b4, 0x3a030b8e, 0x97047425,
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x28000000, 0xd4000000,
    0x42000000, 0xb1000000, 0xfb800000, 0x9cc00000, 0xf0e00000, 0xd0300000,
    0x16c80000, 0x05f40000, 0x21b60000, 0xbf070000, 0x648b8000, 0x0854c000,
    0xe0b16000, 0x9c86d000, 0x34462800, 0x16bfe400, 0x3f974a00, 0x56c93700,
    0xa5f96380, 0x11b2d240, 0xc7102920, 0x9888e610, 0x9e54cba8, 0x13a9f694,
    0xd61e0166, 0x530302f7, 0x7a95810d, 0x1f57c323, 0x9024e230, 0xb6d112c3,
    0x35e2ca3b, 0x59aef65c, 0x43158339, 0xf297c0ee, 0xfb44e008, 0xaa211044,
    0xfbcacb2e, 0x586af793, 0x366b8233, 0xf964c218, 0x45f96217, 0x81b2d07d,
    0x8f1029bb, 0x1c88e41c, 0xf454ca19, 0x76a9f6fe, 0x80000000, 0x40000000,
    0xe0000000, 0xb0000000, 0x38000000, 0xf4000000, 0xee000000, 0x1f000000,
    0xe4800000, 0x39400000, 0xea600000, 0x2f300000, 0xa7580000, 0x6d740000,
    0x6fba0000, 0xf8090000, 0x540d8000, 0xbe094000, 0x970f2000, 0x2886f000,
    0x2358f800, 0x1b644400, 0xd4b7da00, 0x7a92b500, 0xbe572180, 0xaaf2f3c0,
    0x7062fb60, 0x9e2d4510, 0xbcda5958, 0x00abf6ac, 0x848001aa, 0xc9400359,
    0x3260035b, 0x6b300149, 0x7158026c, 0x867402a5, 0x653a0309, 0xde4902cc,
    0x5aed80d5, 0xa8794141, 0xda372238, 0x6ac2f353, 0xebbaf9f2, 0x8e19469a,
    0xef005931, 0x3c92f59f, 0x7d558327, 0x3c7d42db, 0xc4352289, 0xadcff10c,
    0x4b357bb5, 0x615d0451, 0x80000000, 0x40000000, 0xa0000000, 0xf0000000,
    0x98000000, 0x14000000, 0x6a000000, 0xc9000000, 0x4e800000, 0xdd400000,
    0x84200000, 0x53700000, 0x0e580000, 0xdbbc0000, 0x74ba0000, 0xcd350000,
    0x5dfd8000, 0x731dc000, 0xaf856000, 0xbfcb7000, 0xd770b800, 0xec5ecc00,
    0xceadda00, 0x2c29bd00, 0x3f676080, 0x204272c0, 0x10b738e0, 0x7f360f90,
    0x20f539c8, 0xa78f0e74, 0x23cab812, 0x616bce91, 0x335059ca, 0xaf347ca8,
    0x08e20161, 0x8b890397, 0xadc78199, 0x5a68c39b, 0xa0d8e047, 0x56e6b3b4,
    0x988dd972, 0x1259bd41, 0x2dbf6122, 0x0bbe722c, 0x5cad386b, 0xe1330c1a,
    0xd3f0b985, 0x481ece08, 0x3c0dd8d1, 0x4619bf2f, 0x471f60b5, 0x758e72b5,
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x08000000, 0x8c000000,
    0x66000000, 0x71000000, 0x7c800000, 0x6a400000, 0x7e200000, 0xa2700000,
    0x85480000, 0xa7a40000, 0xb6be0000, 0x9a3b0000, 0x18648000, 0x7a5b4000,
    0xb635e000, 0xce6f3000, 0x73449800, 0xdeb4ec00, 0x46397a00, 0x967fdf00,
    0x1743e180, 0xa4b03140, 0x593e1ba0, 0x17e4ac70, 0x67801bb8, 0xc1dfacf4,
    0xf9e499ea, 0x5a84ed2d, 0x3b5179aa, 0x72abdc50, 0x5035e3d5, 0x7f6f32a3,
    0xefc49b05, 0x24f4eceb, 0x30197909, 0xb80fdc55, 0xf40be0be, 0x721433ea,
    0x93001870, 0xe79fafe5, 0x01c49a3b, 0x19f4ee41, 0xca997ad9, 0x334fdfc0,
    0xfeabe13d, 0x3624315f, 0x0e681b43, 0x934bad08, 0x80000000, 0xc0000000,
    0xa0000000, 0x70000000, 0xa8000000, 0xd4000000, 0x4a000000, 0x9b000000,
    0x3b800000, 0x56400000, 0x4ee00000, 0xdab00000, 0x6b480000, 0xc86c0000,
    0xca6a0000, 0x95730000, 0x9cf38000, 0x5da1c000, 0x1edd2000, 0x97399000,
    0x58017800, 0xbc00b400, 0x3e145a00, 0xa1152700, 0x089f2080, 0xb9d692c0,
    0x52b0f820, 0x0f4e7690, 0x8a78f988, 0xf562763c, 0x4cf2f946, 0x85a175f5,
    0x62c97bf5, 0x092cb7a3, 0x891e5b9e, 0x1c9627b7, 0x53c4a162, 0xb9ab53d1,
    0x9ccfd987, 0x0828e5ec, 0xf18003f8, 0x0d400004, 0xd56001e2, 0xfcf00047,
    0x8da8021a, 0xc6dc0115, 0xeb220045, 0xc61f033b, 0x6d19806a, 0x9e92c32d,
    0xcccea2e1, 0x10285189, 0x80000000, 0xc0000000, 0xa0000000, 0x70000000,
    0x78000000, 0x7c000000, 0xda000000, 0x45000000, 0xfb800000, 0x94c00000,
    0xeae00000, 0x4c300000, 0xf7c80000, 0x4e6c0000, 0xc66a0000, 0x02690000,
    0x047c8000, 0xeb66c000, 0x2deee000, 0x3ea55000, 0x9a842800, 0x795ea400,
    0x3922ca00, 0x1457f700, 0x76ace080, 0xfe9052c0, 0x0f5aab60, 0xae3d6430,
    0xaedaa888, 0xbffd67e4, 0x1fbaa806, 0x170d6587, 0x7a92a925, 0x69516453,
    0x9130aa7c, 0x6054662d, 0xa8a62920, 0x1d9ba547, 0x6bd44945, 0x846836e3,
    0x2b768134, 0x8dffc329, 0x4eba6256, 0xe29f9268, 0x0548c894, 0xe33ef4ae,
    0x51506073, 0x8d3690bb, 0x6a544928, 0xe5a83463, 0xe2168023, 0x590fc054,
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xc8000000, 0x8c000000,
    0x82000000, 0x83000000, 0xc9800000, 0xb0400000, 0x3ee00000, 0xc8b00000,
    0xbb480000, 0xdb740000, 0x8afe0000, 0xdeb30000, 0x9e4c8000, 0x8ff7c000,
    0x3a272000, 0x968bd000, 0x93c3f800, 0xf1ae7400, 0x65ccda00, 0x04a1a700,
    0x99592380, 0x2878d340, 0x9b6f7aa0, 0x2ae9b670, 0xaea3fb28, 0x465e773c,
    0xcbe4daae, 0x3425a78d, 0x978f237d, 0xd94fd093, 0x8875fabe, 0xeb697433,
    0xf2fe58c8, 0xeaa565ea, 0x48528207, 0xcaf4c1ea, 0x7ea3a101, 0xee48109b,
    0x57fadbb2, 0x7e26a695, 0x988ba249, 0x92cc1231, 0xbb2cd915, 0x1c11a60f,
    0x8a1123e0, 0x6f0cd2d6, 0x5b9178a9, 0xfb5ab667, 0x80000000, 0xc0000000,
    0xe0000000, 0x70000000, 0x98000000, 0x84000000, 0x16000000, 0x99000000,
    0x16800000, 0x9e400000, 0x3e600000, 0x9a300000, 0x17480000, 0x00e40000,
    0xf8620000, 0xcb350000, 0x8dd78000, 0xe4b84000, 0x5500e000, 0x4c847000,
    0x9d4c5800, 0xcbfb6400, 0x81e4ba00, 0xaaeb1700, 0xa362e180, 0x5ab172c0,
    0xf01bd9e0, 0x580327d0, 0x64045838, 0x661f6774, 0x0106b982, 0x929e16dd,
    0x88556343, 0xa77930c1, 0x8cb3391c, 0x891357df, 0x3e8203de, 0x62450222,
    0xdc7f82ad, 0x8d2c430b, 0x1ccae1fd, 0x9e2570a2, 0xc151d83c, 0x79e2253e,
    0x9ef9dba3, 0xcd762440, 0x37b3d971, 0x689726e5, 0xdb4e5be6, 0x5afe6556,
    0xfb7b3b2f, 0x3eb755d6, 0x80000000, 0xc0000000, 0x60000000, 0x50000000,
    0x58000000, 0x0c000000, 0x3a000000, 0x5d000000, 0xf3800000, 0x08400000,
    0x57e00000, 0x81b00000, 0x75480000, 0x54740000, 0xe1f60000, 0x26a90000,
    0xbbce8000, 0xffb8c000, 0xe651e000, 0xfced5000, 0x752eb800, 0x83849400,
    0xa0575a00, 0x33edc700, 0xbfa7e380, 0x46445240, 0xcce038e0, 0x7d3c5570,
    0xd786bb88, 0x96409644, 0x54e958a6, 0x1130c715, 0xbd9f6071, 0x93559057,
    0xab7f5882, 0x2369c753, 0xb779e214, 0xe16953ae, 0xd670ba91, 0x20e99577,
    0xd727d952, 0xb288044b, 0x39ce8228, 0x3eb8c104, 0x17d1e0c6, 0xf5ad51a5,
    0xb34eba59, 0x5b749603, 0x4b7f599c, 0xb369c5ea, 0x8f79e237, 0xbd695262,
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xa8000000, 0xd4000000,
    0xd6000000, 0xb3000000, 0xc1800000, 0xe7c00000, 0xdba00000, 0x0f700000,
    0x55580000, 0xdde40000, 0xa3020000, 0xd9830000, 0xfbc38000, 0x29be4000,
    0xc269a000, 0xf3ccd000, 0x2dba0800, 0x2c73ec00, 0xccd1aa00, 0x463c3d00,
    0x7aa82380, 0xb3f192c0, 0xdc102b20, 0xd2017c90, 0x5d0203f8, 0xfe83009c,
    0x8c4381de, 0x8d7e4293, 0x7049a2c8, 0xcf7cd0f2, 0x75420963, 0x4de7ed86,
    0xfb0baadf, 0xa59b3e8e, 0xf9c9a18d, 0x4cbcd13d, 0xb0e20a93, 0xd597ec8e,
    0x11d3aacb, 0xf8bf3c84, 0x96eba3b4, 0xce8fd29c, 0x04598a98, 0xc97daf2a,
    0xfe400bef, 0x0064eee0, 0xb6c82930, 0xcf257e28, 0x80000000, 0x40000000,
    0x60000000, 0x70000000, 0xa8000000, 0xb4000000, 0x66000000, 0x93000000,
    0x57800000, 0x4f400000, 0x2d200000, 0x99700000, 0x77d80000, 0xd7e40000,
    0xc6120000, 0xc3130000, 0xef8f8000, 0x23544000, 0x572ba000, 0xd87e1000,
    0xd557d800, 0x5c3a2c00, 0xf3ee7a00, 0x38173d00, 0x2c162380, 0x1a0950c0,
    0x310bfb20, 0x0a847f10, 0x3fd80138, 0x53e4019c, 0x68120146, 0x941302b1,
    0x760f834a, 0x4b144188, 0x4b8ba0f3, 0x9d4e1376, 0xd82fdb99, 0x5dee2d6e,
    0x6f047a12, 0xb5903ce4, 0x7253a0bd, 0x2daa1073, 0x4fbdda31, 0x32bd2e0d,
    0x522bfa1c, 0xf4f47c81, 0x19800165, 0x28400058, 0x7ca001eb, 0x3530017a,
    0xa57801a7, 0xb5d40023, 0x80000000, 0x40000000, 0x20000000, 0x70000000,
    0x38000000, 0x34000000, 0x1e000000, 0xf3000000, 0x86800000, 0xc6c00000,
    0xf5a00000, 0x68700000, 0x07580000, 0xebec0000, 0x881a0000, 0x6c010000,
    0x7a058000, 0xa50b4000, 0x799aa000, 0x6a483000, 0xde6bc800, 0xe8480c00,
    0x2f6b6a00, 0xdfc13d00, 0xfe252280, 0x8b3270c0, 0xfaace860, 0xbce77d10,
    0x38800298, 0x05c0021c, 0x6b2002e2, 0xeab00117, 0xd4f8012c, 0x449c026a,
    0x17c203b3, 0xb22d01c2, 0x813f8027, 0x67ba4104, 0xf167201e, 0x4cdf7285,
    0x28b36813, 0x05ed3c92, 0x031f22bf, 0xfe8372b8, 0xd2d16aac, 0x9bb03f8a,
    0xa378a043, 0xb5d5312a, 0x332c4b93, 0x8eae4d72, 0x82ee4b4f, 0xbb834f50,
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x98000000, 0x84000000,
    0x72000000, 0x73000000, 0xdd800000, 0x86400000, 0x4e600000, 0xff300000,
    0x3ed80000, 0x04a40000, 0x61960000, 0x00510000, 0xe76f8000, 0x1da4c000,
    0x0b0b2000, 0x49815000, 0x0c433800, 0xe96e6400, 0xc8be1a00, 0x4f8e3500,
    0xe54aa380, 0x6be09040, 0xad699be0, 0x9abef750, 0x0c8f81a8, 0xf0d4c2dc,
    0xf1b3233e, 0x15155295, 0x648d382f, 0x9cdb67f5, 0xafa79a0a, 0x580bf722,
    0xa416018b, 0x4211024a, 0xbb0f80c2, 0xc194c0db, 0x705320e2, 0x4f65529e,
    0x51b53b25, 0x650f6557, 0xcc8998c1, 0xd0cef608, 0xc1b782d9, 0xdd00c219,
    0x789d238c, 0x6ad05323, 0xaeacb816, 0xf68aa73c, 0x80000000, 0xc0000000,
    0x60000000, 0x90000000, 0x18000000, 0x9c000000, 0x32000000, 0x3d000000,
    0x5c800000, 0xb3400000, 0x83200000, 0x59700000, 0x90c80000, 0x19f40000,
    0xd18e0000, 0xc7c90000, 0x447c8000, 0xfc57c000, 0x42bae000, 0x46a3b000,
    0x28a1b800, 0x47a6ac00, 0xb6355a00, 0x41fc1f00, 0xed806380, 0x05c97140,
    0xf169d9e0, 0x24dbdc30, 0x5ff282a8, 0xca9ec184, 0x1046603a, 0x38b47079,
    0x9fbb5b1e, 0x4a351dd8, 0xe3fce287, 0xc89eb2f6, 0xc55339f7, 0x70386ff5,
    0x9af33a3b, 0x5a086cfb, 0xe91b3910, 0x8a8c6f38, 0xb05d387c, 0xc8b16ee6,
    0x17afba4f, 0xce2fad49, 0x4de9d87d, 0xc79bdd64, 0xa4d283c1, 0x9feec2e9,
    0xaa8e6166, 0x80407244, 0x80000000, 0xc0000000, 0xe0000000, 0x30000000,
    0x38000000, 0x94000000, 0xd6000000, 0x99000000, 0x03800000, 0x43400000,
    0xc5a00000, 0x59f00000, 0x2ec80000, 0x4be40000, 0xa9ca0000, 0x9d790000,
    0x9b198000, 0x6c964000, 0x09d2e000, 0x8d67d000, 0x7305d800, 0xf0897c00,
    0x73d53a00, 0x5673af00, 0x3f836180, 0x295593c0, 0xf6bd3b60, 0x8967ae90,
    0x8d0161b8, 0x15889334, 0x3a4eb8d6, 0xf638efa9, 0x22a201f8, 0x7f6d013a,
    0xc41b8375, 0x1e0b42ec, 0xd50162f2, 0x71889007, 0x344eb885, 0xcb38ecc4,
    0xcf2200fe, 0x312d00a5, 0xd43b83da, 0x9dbb4225, 0x3de96234, 0x20dc9056,
    0x76ecb8e9, 0x4455efd8, 0xd339828a, 0x8b2642fd, 0xef3ae090, 0xe133d0b8,
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x38000000, 0xa4000000,
    0xb6000000, 0x29000000, 0x48800000, 0x7a400000, 0x9ba00000, 0x16f00000,
    0x00d80000, 0xeef40000, 0x04ca0000, 0x88e90000, 0x25df8000, 0x5c6c4000,
    0x4d98e000, 0x58d6b000, 0x3aeb9800, 0x6adb9c00, 0x35e17a00, 0xe3502d00,
    0xab3f6180, 0x28bef1c0, 0x1d617b60, 0xe9102e50, 0xe89f6038, 0xaa4ef334,
    0x93b9787a, 0x8ae42d8d, 0x12d561ac, 0x71e7f222, 0x6546fb35, 0xba386f84,
    0xc43583d2, 0xd13543e1, 0x5bbf63b2, 0xb6fef36d, 0xd0c17860, 0xe6e02cd0,
    0x98c76378, 0x9afaf314, 0xbad37a0a, 0x3dfd2dc5, 0x7f52e3d0, 0xb93fb3a4,
    0xb7b41bfe, 0x7cf7dc03, 0xdbd999e7, 0x09769fb9, 0x80000000, 0x40000000,
    0xa0000000, 0x90000000, 0x38000000, 0x1c000000, 0xd2000000, 0x51000000,
    0xc9800000, 0x65c00000, 0x23600000, 0x21b00000, 0xb4580000, 0x8abc0000,
    0x48d60000, 0x48fd0000, 0x1d608000, 0xeab3c000, 0x38db6000, 0x40fe9000,
    0xa97ec800, 0x1cac7400, 0xa7cbaa00, 0x0a63e500, 0x543be080, 0x938d5340,
    0xc0c5aa60, 0xbce2e630, 0x4b6d61a8, 0xe5b39034, 0x4a464aee, 0xa1a3b693,
    0xf446c94b, 0x2aa07461, 0xd8c5a994, 0x70e2e4a8, 0x016d60b4, 0x38b391ae,
    0x69c648f3, 0x8963b57b, 0xcca6c8c9, 0x3fd07520, 0x867dab06, 0xbe2ee747,
    0xde836155, 0xdb4293fa, 0x8828c97b, 0xa191779f, 0xa1cb29ff, 0xdd6025cf,
    0x0ab88167, 0x08cfc1d3, 0x80000000, 0x40000000, 0xe0000000, 0x90000000,
    0xd8000000, 0xdc000000, 0x3a000000, 0x4d000000, 0x60800000, 0xf0c00000,
    0x76a00000, 0xe5700000, 0xc0580000, 0xfe740000, 0x3fde0000, 0x57210000,
    0x772c8000, 0x4736c000, 0xef31e000, 0x7b283000, 0x45384800, 0xee2fec00,
    0xf9afaa00, 0x24e2dd00, 0xc21d6180, 0xa11ef340, 0xf289a8e0, 0x29c7dd30,
    0x2837e188, 0xbebd3344, 0xa16acaea, 0xc6482cb7, 0x196ac938, 0xca482e26,
    0x1b6acbb3, 0xcb482e18, 0x99eac89c, 0xaa882d56, 0xb5cacaf1, 0xf2382ed1,
    0x63b2caeb, 0x19fc2dce, 0xea94c807, 0x55d92e5a, 0x623e4a7f, 0xbbbaec9c,
    0xc5fd2afc, 0xd0851c0c, 0x18d801a4, 0x02b40370, 0x4b7e0142, 0xb35100c9,
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xc8000000, 0xcc000000,
    0xd6000000, 0x3f000000, 0xc9800000, 0xe5400000, 0x65e00000, 0xb9300000,
    0x11980000, 0x915c0000, 0x17f20000, 0xac2f0000, 0xf9188000, 0x4e9f4000,
    0x88cf2000, 0xaaa1d000, 0xfdd51800, 0x923b5400, 0x7a02ba00, 0x3905c500,
    0xae988080, 0x18df41c0, 0x52af21a0, 0xf9d1d3f0, 0x882d1878, 0x931757cc,
    0xcf88ba7e, 0x8246c669, 0x986a0231, 0x8e7300b1, 0x516a8071, 0x08f04351,
    0x15b7a061, 0x744e9339, 0xd7623bc5, 0x2ff684e3, 0x483da176, 0x730d93e1,
    0x5f90ba85, 0x7a5ac483, 0x9c780326, 0x946c0069, 0xb86a0131, 0xfe730331,
    0x396a8231, 0xf4f040b1, 0x0bb7a071, 0x874e9351, 0x80000000, 0x40000000,
    0xe0000000, 0x30000000, 0x38000000, 0xf4000000, 0x26000000, 0x33000000,
    0xe4800000, 0x95c00000, 0x42e00000, 0xbbb00000, 0xe0980000, 0x2bd40000,
    0x55fa0000, 0x71310000, 0x8a418000, 0x5fae4000, 0x6e88a000, 0x04d3f000,
    0x6b6ba800, 0x3df6a400, 0xcd228a00, 0x804b1500, 0x8ea18180, 0xa71e41c0,
    0xb290a360, 0x7ec7f310, 0x6271a878, 0x3077a71c, 0x657b090a, 0x52f1579b,
    0x13b32319, 0xfc8cb179, 0xf1c289e9, 0x8cfb1551, 0x74b980ad, 0xee0a4377,
    0x5f0aa3f4, 0xe686f2e1, 0x88c829ea, 0x597de604, 0x18f1a806, 0x22b7a769,
    0x051b0a5e, 0x7f81540a, 0x6d4b221b, 0x0d28b0d9, 0x20408b19, 0x5eae1579,
    0xaf1a03e9, 0x7e810051, 0x80000000, 0xc0000000, 0xe0000000, 0x10000000,
    0xb8000000, 0xcc000000, 0xd2000000, 0x99000000, 0x77800000, 0x35c00000,
    0xe6e00000, 0x50b00000, 0x5d880000, 0x40c40000, 0xb37e0000, 0x54650000,
    0xb8e68000, 0x3bb7c000, 0x431f6000, 0xaa8cd000, 0x1458c800, 0xfc2ca400,
    0xfec12a00, 0xc867b700, 0xf2ee8180, 0x9eb3c340, 0x4e816160, 0x7259d370,
    0x9b3649a8, 0xd25f6554, 0xab204896, 0x9a4e65b3, 0xcf30cbc5, 0x3c58a6d5,
    0x4837298d, 0x00c6b431, 0x93760393, 0xa4610246, 0x10f883d8, 0x4fa2c07c,
    0x5d11e002, 0xe18f1285, 0xfad1a926, 0xbe7177a8, 0x2de96054, 0x7e2dd216,
    0xffc04973, 0x83fe64e5, 0xbd38ca45, 0x955ca595, 0x77a928ed, 0x5113b741,
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xd8000000, 0x5c000000,
    0x9e000000, 0x31000000, 0xf7800000, 0x0b400000, 0xf1e00000, 0x29300000,
    0x61980000, 0xfe440000, 0xa4660000, 0xdd610000, 0x8ee88000, 0x77ac4000,
    0xa14be000, 0xcaedd000, 0x95b91800, 0x3e4e1400, 0x847a7a00, 0xed7f8500,
    0x06f08380, 0xf3a84040, 0x634de2e0, 0x65fcd030, 0x53299918, 0xc29655b4,
    0x7ecf9ba6, 0x35b755e9, 0x4e471b99, 0x6c6b14c9, 0x3974faa1, 0x1cf2c66d,
    0x00b3e18f, 0x3bd9d178, 0xa8271bec, 0x5e1b1672, 0x110cfbbf, 0xc786c6c8,
    0x834de0b4, 0x75fcd026, 0xeb2999a9, 0xce965779, 0x38cf9bf9, 0x58b75539,
    0x27c71819, 0x562b1489, 0x3f14f841, 0x3e82c65d, 0x80000000, 0x40000000,
    0x20000000, 0xb0000000, 0x58000000, 0xbc000000, 0x6e000000, 0x85000000,
    0xf7800000, 0xf9c00000, 0xb6a00000, 0x9ef00000, 0x40980000, 0x354c0000,
    0xf5f20000, 0x720d0000, 0x1b148000, 0x0a9e4000, 0x024b6000, 0x79655000,
    0x11464800, 0x47ec2c00, 0x0901aa00, 0x819b3d00, 0xe0de8280, 0x9f2f43c0,
    0xba35e1e0, 0xbdba1030, 0x3c6ba8d8, 0x86da3ce4, 0x2e380066, 0x57bc00f3,
    0xfb6a0184, 0x7241035c, 0x416682b8, 0x3d53405e, 0xc1ffe36d, 0x680b1309,
    0xa4152865, 0xf2057e05, 0x5b15e0bf, 0x2a8a12b4, 0xb253a9ce, 0x21663eef,
    0xad5200d6, 0x29fd0121, 0x8c0c82f3, 0x76124084, 0x191963dc, 0x29985078,
    0x24cac93e, 0xfd3e6d9d, 0x80000000, 0x40000000, 0x60000000, 0xf0000000,
    0xd8000000, 0xcc000000, 0xba000000, 0x11000000, 0xb1800000, 0xbec00000,
    0xd1600000, 0x98300000, 0xa4980000, 0x11440000, 0xb0b20000, 0x6fd50000,
    0x40ea8000, 0xb6f2c000, 0x5df36000, 0x9d7b1000, 0x62326800, 0xd58bb400,
    0x50d38a00, 0xd6766500, 0x72b88380, 0x62d7c2c0, 0x0361e2e0, 0xfd3dd0f0,
    0x930b0988, 0xdc91a774, 0x0d41622e, 0x42ae13bf, 0x9ad8e803, 0x5f79775b,
    0x6f20e8b7, 0x960d7415, 0x1b0ae938, 0x189c777e, 0x335269e7, 0x0dbbb46f,
    0x944b8939, 0x3732677a, 0x1a0a82a3, 0xc102c229, 0xf98b6382, 0x5acf119f,
    0x7f786b13, 0xff2ab7a3, 0xbe13098b, 0x0f15a42f, 0x6e936099, 0x984b12aa,
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x08000000, 0x0c000000,
    0x9e000000, 0x77000000, 0xf9800000, 0x04400000, 0x7c600000, 0x83b00000,
    0xea880000, 0xbfdc0000, 0x89220000, 0x45570000, 0x0ef88000, 0xc8664000,
    0xd9b32000, 0x2f9cd000, 0x9f443800, 0x0bffc400, 0xc8e79a00, 0x6b695700,
    0xaa3a8280, 0xf6c143c0, 0xf7a3a0a0, 0x909690f0, 0x4add1a58, 0xa1a815ec,
    0xcb99239e, 0x1d57d2cd, 0xdafeba97, 0x427e86df, 0x04a4387b, 0x3b0fc7c1,
    0x878f9976, 0x634555f6, 0xbdf08359, 0x83fa41d5, 0x04f12074, 0xd57bd0bd,
    0xed34bb0f, 0x07458793, 0xfff6b915, 0x72e28454, 0xbe663a8d, 0xb2a8c677,
    0x701f18cf, 0xe80f1733, 0x1c09a1e5, 0xa61d920c, 0x80000000, 0x40000000,
    0x20000000, 0x10000000, 0x78000000, 0xac000000, 0x5a000000, 0x11000000,
    0x53800000, 0xf3400000, 0x63e00000, 0xed300000, 0xca980000, 0x04cc0000,
    0x2ea60000, 0x01dd0000, 0xeb328000, 0x898ac000, 0xa2436000, 0x10635000,
    0x0e739800, 0xd16e5400, 0x45fa7a00, 0xbe3bc500, 0x14148280, 0x9617c140,
    0x7b11e160, 0x2a9992f0, 0x74c8f888, 0x66b106f4, 0xc5d7e226, 0x65349289,
    0x6e827841, 0xbac7c439, 0xa1aa8145, 0xcd46c017, 0xace56278, 0x01be5010,
    0x9d411bb8, 0xf4e4975c, 0xbdb91bc2, 0xbf589497, 0x49e71a54, 0xb439959a,
    0x5d0b9b7b, 0x799255fe, 0xaa447bc9, 0xf46ac521, 0x906000c9, 0x4e7002cd,
    0xf1780363, 0x55fc029e, 0x80000000, 0x40000000, 0x20000000, 0x30000000,
    0xd8000000, 0xc4000000, 0xb2000000, 0x1d000000, 0xf1800000, 0xe4400000,
    0xfce00000, 0x34300000, 0xbd180000, 0x818c0000, 0x1c420000, 0x08fd0000,
    0x5e338000, 0x6416c000, 0xc219e000, 0xe51f9000, 0x059fb800, 0x8e409400,
    0x25f7da00, 0x77b4c500, 0x44420280, 0x8cfd01c0, 0xcc3383e0, 0x4916c3d0,
    0xeb99e1a8, 0xc55f9364, 0x4b7fb90e, 0xa77097e5, 0x696fda35, 0x1278c641,
    0xa4e00387, 0xb0300316, 0x2f180165, 0xac8c01f5, 0x35c200a1, 0x28bd02d7,
    0x10d3837e, 0x4d26c1e1, 0x8e81e32b, 0x80d392ec, 0xe53db986, 0xb28d9531,
    0xc6dc5903, 0x922e04c8, 0x9a19e1a8, 0x611f9364, 0x979fb90e, 0xa34097e5,
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x28000000, 0x2c000000,
    0x96000000, 0x07000000, 0x14800000, 0xd4c00000, 0x4c600000, 0x23300000,
    0xc3180000, 0x8e840000, 0x15ca0000, 0x47e30000, 0xe7708000, 0xe1af4000,
    0x70c62000, 0xe6607000, 0xca270800, 0xe48d9400, 0xdcdbaa00, 0x3061a500,
    0xad2a0380, 0xc01301c0, 0x20088120, 0x501b4070, 0x181422f8, 0x040770ac,
    0xba1d8a0a, 0x9101d74f, 0x138d0b63, 0xc05e96df, 0x98b329bd, 0x6f4ae776,
    0xe026207b, 0x4d907255, 0x9b5f08b2, 0x523996f5, 0xa089aaf4, 0x06c6a6e0,
    0x91708250, 0x96af4208, 0x2c462314, 0x2ea072c6, 0x38470955, 0xecbd94c4,
    0x9d43aaf8, 0x6d25a4ac, 0xe000000a, 0x7000024f, 0x80000000, 0xc0000000,
    0x20000000, 0x30000000, 0x38000000, 0xe4000000, 0x4e000000, 0x7b000000,
    0x80800000, 0x46c00000, 0x3f600000, 0xda300000, 0x17080000, 0xd29c0000,
    0xb7c20000, 0xbae10000, 0x5f6b8000, 0x0a3d4000, 0x3f0aa000, 0x3e857000,
    0x25ddc800, 0x6bf2b400, 0xeafeea00, 0xb76b8700, 0xc6220280, 0x9d1103c0,
    0xd7838060, 0x74514350, 0x98a0a1d8, 0x68c8727c, 0x947c4b3a, 0x72b2f4f7,
    0xbdddc8ff, 0x7ff2b573, 0xbcfeea21, 0x186b87e2, 0x30a200e3, 0x44d101f1,
    0x266382fa, 0x93a1407f, 0x3048a25b, 0x26a473b5, 0x0bd64bac, 0xc0fff6ca,
    0x427c4b9f, 0x1db2f54b, 0x6b5dc84d, 0x9632b5a0, 0x751ee9d8, 0x1b9b867c,
    0xd64a013a, 0x71bd03f7, 0x80000000, 0xc0000000, 0x60000000, 0xb0000000,
    0xd8000000, 0x5c000000, 0xe2000000, 0xe5000000, 0x5d800000, 0x4ac00000,
    0x10a00000, 0xcaf00000, 0xe9080000, 0x17940000, 0x4bda0000, 0x432d0000,
    0x5f208000, 0x1d3fc000, 0x2824e000, 0x1da51000, 0xd36be800, 0x7dc9cc00,
    0xb0358a00, 0xe1be1f00, 0xe17a0380, 0xf0dd01c0, 0x69a882e0, 0x156bc3b0,
    0xf6dee0e8, 0x82b812e4, 0x97e36afe, 0x58920ebf, 0x67436b34, 0xe2620d00,
    0x364b6866, 0x19f60eb5, 0x47916a6b, 0xe3db0de2, 0xa731eb3b, 0x5124ce5c,
    0xc2350bc2, 0xccb1de0d, 0xe8f6e1b1, 0x6c1c10a5, 0xfa116a75, 0xd91b0c0b,
    0x0f91e812, 0x77d4cef3, 0x113d08e8, 0x6225dee4, 0x1cace0fe, 0x80f111bf,
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x48000000, 0xfc000000,
    0xca000000, 0x4d000000, 0xe1800000, 0x2a400000, 0x2a200000, 0xf0f00000,
    0x2b180000, 0x6e840000, 0x1ad60000, 0xfbf30000, 0xf5868000, 0xec4ec000,
    0x553ce000, 0x387f9000, 0x9ec87800, 0x15fb8c00, 0xa6841a00, 0xa6c9dd00,
    0x51ee0380, 0x68870240, 0x45c880a0, 0x8379c0b0, 0xd84c6208, 0x233252c4,
    0xdf6a18ae, 0xe24edd9d, 0x9626812e, 0x5afec26a, 0xb604e184, 0xc70b9139,
    0xcc8679e7, 0x1bcc8da5, 0x48749a95, 0x26c41c6a, 0x11ec6284, 0x088251b9,
    0x95d21b27, 0xcb7adfc5, 0x24488045, 0xe939c0b2, 0x926c6298, 0x03c2520b,
    0xbc721988, 0x70cadc84, 0x46f0820e, 0xec0dc02d, 0x80000000, 0xc0000000,
    0xe0000000, 0x30000000, 0x18000000, 0xec000000, 0x5a000000, 0xc3000000,
    0x72800000, 0x67c00000, 0x33200000, 0x59700000, 0xcd080000, 0x17840000,
    0x445a0000, 0x21650000, 0xd10e8000, 0xb58ec000, 0x5b4f2000, 0x11f03000,
    0x99d1a800, 0xae2f1c00, 0xa6ea0a00, 0x9d44ef00, 0xb0f20180, 0x145103c0,
    0xc97c83e0, 0xc51fc370, 0x3393a108, 0xda5ff0bc, 0x4c6a08a2, 0xd684ee93,
    0x39d20306, 0xbe2103fa, 0x6ef48078, 0x595bc1fb, 0x1ee9a245, 0x614af36b,
    0x22ec8b3d, 0x134e2d5f, 0x15e721e3, 0xd7c4300e, 0xeb23a846, 0x557e1f5a,
    0xa71689a8, 0xcc9b2c23, 0xdac1a1a1, 0x1cbef26d, 0x213e8888, 0x9e6f2f7c,
    0xf193a142, 0x355ff2e3, 0x80000000, 0xc0000000, 0xa0000000, 0x30000000,
    0x58000000, 0x4c000000, 0x8e000000, 0x5d000000, 0x15800000, 0xd6400000,
    0x2e200000, 0x84f00000, 0x5b080000, 0x0c8c0000, 0xc9d20000, 0x0f6d0000,
    0x78528000, 0x83204000, 0x697e6000, 0xf1471000, 0xf4bf7800, 0x5c348c00,
    0xcfe19a00, 0xff8edf00, 0x715a0080, 0x34a103c0, 0xfc2083e0, 0xfffd41f0,
    0xa784e358, 0x3d5b5044, 0xbabb1a6e, 0xa1229e2d, 0xea7662ee, 0x71cb124a,
    0x136d7b54, 0x3e598ee1, 0xfa33192b, 0xe6ee9e3f, 0xb804607e, 0x1c161085,
    0x4617fbf2, 0x7905cf60, 0x8f977b97, 0x49488fe2, 0xe8bb9b6f, 0x1a2fdf51,
    0xb6fa80d3, 0x701c40ab, 0x380463d8, 0xdc161384, 0xe617f98e, 0x4905cfdd,
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x98000000, 0x84000000,
    0xe6000000, 0x13000000, 0x78800000, 0xafc00000, 0x1ee00000, 0xccb00000,
    0xde080000, 0x27040000, 0x768e0000, 0x30c10000, 0x9c638000, 0x127c4000,
    0x4d76a000, 0x2ff97000, 0x613ce800, 0x6a432400, 0xe6afca00, 0x17031700,
    0x5e880180, 0x5cc40140, 0xf66e01e0, 0xfb710050, 0x44eb81f8, 0x0db8425c,
    0xbb98a27a, 0x6f4872f3, 0x45376999, 0x3c4b658d, 0x1dbf6903, 0xe38f64ae,
    0x0b516b22, 0x333e651f, 0xb75ae84b, 0xe13627da, 0xaa4a4b3c, 0x06ba57ea,
    0x8713212b, 0xc68030b5, 0xd8c7c9ff, 0x10771464, 0xe86e03f9, 0x3c710162,
    0xa26b8180, 0xa5784140, 0xa3f8a1e0, 0x9b387050, 0x80000000, 0xc0000000,
    0xa0000000, 0xb0000000, 0x28000000, 0x8c000000, 0x2a000000, 0x9b000000,
    0xe7800000, 0xfb400000, 0x86200000, 0x43f00000, 0xae080000, 0x4d0c0000,
    0xde820000, 0xbbd30000, 0x98f48000, 0x2984c000, 0xa64e2000, 0xc0bb9000,
    0x5c259800, 0x90e2ac00, 0xd5953a00, 0x0442ff00, 0x67a80080, 0xb9bc01c0,
    0x7caa0220, 0x9e2f00f0, 0x27fe8008, 0xa81bc05c, 0x4c18a336, 0x8a1c5181,
    0x2b173986, 0xcf91fee2, 0x775c82a0, 0xac38c33b, 0xd8e42342, 0x4994911b,
    0xb65b19b9, 0x58b96c79, 0xf82d9a52, 0x36eeaec8, 0x649738f7, 0x78d1ff6c,
    0x7b7c801e, 0xc4c8c0ad, 0xb96c22f8, 0x73d8915f, 0xc4f91880, 0x3b9a6dc0,
    0x29511820, 0xa9266ff0, 0x80000000, 0xc0000000, 0xe0000000, 0x30000000,
    0xc8000000, 0x3c000000, 0xda000000, 0x53000000, 0x2e800000, 0x11400000,
    0x94a00000, 0x7e700000, 0xac080000, 0x02040000, 0x771a0000, 0x309f0000,
    0x6c5e8000, 0x0f3cc000, 0xc8a12000, 0x5467b000, 0xd713f800, 0x2092bc00,
    0x745e5a00, 0xcb22cf00, 0xe6a00180, 0xe17003c0, 0x708800a0, 0x4c440030,
    0xdf3a0048, 0x30af01bc, 0xa07683d2, 0x3108c109, 0xa99322e8, 0x09ccb1bc,
    0xf4ff78e2, 0x63457df1, 0x0bb3f96c, 0xa2e2bfca, 0xe25659ed, 0xaa26cf3e,
    0x773a0033, 0xfcaf025d, 0x527683b6, 0x6e08c0af, 0x9513227f, 0x778cb257,
    0x94df7bcb, 0x5f757c59, 0x1d9bf800, 0xcfd6bc00, 0xade45a00, 0xe6cdcf00,
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x28000000, 0x54000000,
    0xba000000, 0x85000000, 0x43800000, 0x29c00000, 0x70e00000, 0x81b00000,
    0x4c080000, 0xa60c0000, 0xbb1a0000, 0x248b0000, 0x934f8000, 0xf4bdc000,
    0xe797e000, 0x7bc0d000, 0x01f94800, 0x08352400, 0xc8d32a00, 0xc17f3700,
    0xa9600080, 0x9d7002c0, 0xf7680220, 0x2a7c0090, 0x15f20248, 0xd2370344,
    0x9ddd83e6, 0xdafac2b3, 0xfca260cd, 0x038612a1, 0x49c928f3, 0xa0f4349e,
    0xd9af81dc, 0x300dc10a, 0x481fe221, 0x840cd280, 0xe2034973, 0xf90e276d,
    0xad94ab71, 0x16cef4db, 0xb66de2aa, 0xebfbd142, 0x153eca65, 0x5744e7e6,
    0x76bec800, 0xce84e400, 0x8e5eca00, 0x6b34e700, 0x80000000, 0x40000000,
    0xe0000000, 0x70000000, 0x18000000, 0xec000000, 0xf2000000, 0xa1000000,
    0x8e800000, 0xcbc00000, 0xdd200000, 0xe7900000, 0x2a080000, 0xed040000,
    0xec8e0000, 0x02c70000, 0xa7a18000, 0x325ec000, 0xa4272000, 0x251e1000,
    0x83cee800, 0xf92fbc00, 0x71925200, 0xfd0fb900, 0xc4880080, 0x16c40040,
    0xc9ae00e0, 0x79570070, 0x67a98018, 0x925ac0ec, 0x342920f2, 0x4d1910a1,
    0x77cf688e, 0xe7217ccb, 0x229d72dd, 0xd285a9e7, 0x81c0e8aa, 0x0028bcad,
    0xf313d20c, 0xb4c17972, 0xa0a7203f, 0x93de109e, 0xda6ee8b6, 0xe87fbcf4,
    0xe23a5215, 0x715bb9de, 0xa3ae00de, 0x745700fb, 0xfb298080, 0x889ac040,
    0x7f8920e0, 0x8d491070, 0x80000000, 0xc0000000, 0x20000000, 0x10000000,
    0x18000000, 0xbc000000, 0xce000000, 0xab000000, 0xbe800000, 0x98400000,
    0x17200000, 0x17500000, 0xe2080000, 0xbd0c0000, 0x89820000, 0xf8c10000,
    0x3c618000, 0x02fbc000, 0xa314e000, 0xe32eb000, 0x9d55e800, 0x0b028400,
    0x6e8df200, 0xa0493500, 0xbb280080, 0xc15c00c0, 0xf50a0020, 0xcd8d0010,
    0xbac38018, 0x516ac0bc, 0xb37d60ce, 0xf7d970ab, 0x094308be, 0x88ad3498,
    0xd8999a17, 0xbee07117, 0x94b91262, 0x3f37857d, 0x5af5e829, 0xff128428,
    0x1d25f204, 0x3e5535ae, 0x118200f5, 0x84c10034, 0xd26180cd, 0xb9fbc028,
    0x0594e0df, 0xc76eb093, 0x4475e880, 0xb75284c0, 0x3205f220, 0x85053510,
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xb8000000, 0x84000000,
    0xd6000000, 0x83000000, 0xdc800000, 0x6f400000, 0x56200000, 0x80b00000,
    0x5a080000, 0xc90c0000, 0x9d860000, 0xaecf0000, 0x5aeb8000, 0x37584000,
    0xb6d56000, 0x1a1c3000, 0x3dffc800, 0x992bf400, 0x763be200, 0x844acb00,
    0xe6a80080, 0x95fc00c0, 0x952e0060, 0xfc3300f0, 0xa54580b8, 0xd72b4084,
    0x2130e0d6, 0xa6c77083, 0xc6e728dc, 0xf550846f, 0xabd2ca56, 0x79994f80,
    0xdc374ada, 0xf5420f09, 0xff2faa7d, 0xed397f9e, 0x4cc68202, 0x17eafb83,
    0x7cd9c838, 0x9b14f42d, 0x9c7862ef, 0x65ee8b01, 0x79d36012, 0xec9330ac,
    0xe3b44880, 0xb683b4c0, 0x7e468260, 0xbfaafbf0, 0x80000000, 0xc0000000,
    0x60000000, 0xb0000000, 0x38000000, 0xd4000000, 0xca000000, 0xa7000000,
    0xd9800000, 0xc8c00000, 0x9ce00000, 0xec500000, 0x76080000, 0xf10c0000,
    0x38860000, 0x184b0000, 0xd8a38000, 0x12fd4000, 0xddf4a000, 0x987e7000,
    0x16bf9800, 0x83558c00, 0xe3834e00, 0xf7c10500, 0x41680080, 0x669c00c0,
    0xa1ee0060, 0xdad700b0, 0xeb4d8038, 0x0b2a40d4, 0x1d3920ca, 0x289430a7,
    0x84e6b8d9, 0x2851bcc8, 0x540df69c, 0x0a0cb9ec, 0xc70bf6f6, 0x6987b931,
    0xf0c876d8, 0x48eaf968, 0x2654d600, 0xd10889b6, 0x28854ecf, 0xf04a059b,
    0x84ab80dd, 0x34f14048, 0x64f2a034, 0x2cf57010, 0xa0fc1880, 0x0ef8ccc0,
    0x5bffee60, 0xf17375b0, 0x80000000, 0x40000000, 0xa0000000, 0xb0000000,
    0x78000000, 0xec000000, 0x52000000, 0x13000000, 0x43800000, 0xd0c00000,
    0x9de00000, 0x1f900000, 0x5b080000, 0x97840000, 0xceca0000, 0x6ceb0000,
    0x37178000, 0x2446c000, 0x88a12000, 0x5fbb3000, 0x6bf73800, 0x2b568c00,
    0xe0e11e00, 0x3511d900, 0x5f4a0080, 0xef2b0040, 0x497780a0, 0x5b16c0b0,
    0x36492078, 0x3baf30ec, 0xac353852, 0xc3398c13, 0x5abc9e43, 0xad7c19d0,
    0x7d1ca01d, 0x8b46f05f, 0xf12998fb, 0xb87f7c27, 0x739506b6, 0x49036580,
    0x2489a6e5, 0x3d459577, 0xc4203eeb, 0x46fae97f, 0x69d538ae, 0xc0a98c28,
    0x8bb49e31, 0x75f819ed, 0xda56a078, 0xc86df0ec, 0x4a5e1852, 0x4069bc13,
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xa8000000, 0xc4000000,
    0x2e000000, 0xdb000000, 0x3f800000, 0xf0400000, 0x85200000, 0x18100000,
    0xdd080000, 0x60840000, 0x01ce0000, 0x1e6b0000, 0x0aba8000, 0xf1544000,
    0x16aee000, 0xa257b000, 0xfd2ef800, 0x841a8400, 0x7f089200, 0xe1802100,
    0x63460080, 0xceaf0040, 0x6e5480e0, 0x472f40b0, 0x691c60a8, 0xf787f0c4,
    0xc44e182e, 0xe32634db, 0xb71cea3f, 0x648ee5f0, 0x8fc07205, 0x95689158,
    0x2d3478bd, 0x6d1ec490, 0x798e7249, 0x4f43916a, 0xc4aef80c, 0x2b5a84ae,
    0x0ba892e7, 0x62d02139, 0xacee006f, 0x827b00e8, 0x19b280e9, 0xfad040f2,
    0x80e0e028, 0x887cb084, 0x5cb478ce, 0xb65ec46b, 0x80000000, 0xc0000000,
    0xa0000000, 0xf0000000, 0x38000000, 0xbc000000, 0xea000000, 0xd9000000,
    0x16800000, 0xb6c00000, 0xcce00000, 0x2dd00000, 0x3f080000, 0x7d8c0000,
    0x954a0000, 0x4eaf0000, 0x0af38000, 0x9eb3c000, 0xea9aa000, 0xd4a39000,
    0x2bf86800, 0x9435ec00, 0x465f8e00, 0xf94a3d00, 0xaca20080, 0xf7f300c0,
    0x2e3180a0, 0x5750c0f0, 0x6bc32038, 0x4c6f50bc, 0x081948ea, 0xcc69bcd9,
    0xc8174616, 0x6c6341b6, 0x381e664c, 0x546311ed, 0x8414ae1f, 0xbe696d4d,
    0x5d11488d, 0xa8e5bcc2, 0xebdd4678, 0x640c410b, 0xc60de6ae, 0x5b00d1c7,
    0xbb860e3b, 0xce46fde6, 0xf52320bb, 0xc4bf5093, 0x6b9148b8, 0x2e25bc7c,
    0xbf3d464a, 0x05dc4129, 0x80000000, 0x40000000, 0xe0000000, 0xb0000000,
    0xd8000000, 0xe4000000, 0xb6000000, 0x57000000, 0x28800000, 0x08c00000,
    0x9ea00000, 0x3ef00000, 0x08880000, 0x18c40000, 0x16ae0000, 0xb2fb0000,
    0x82858000, 0x1dca4000, 0xdf256000, 0xc5be7000, 0x3c670800, 0xb55acc00,
    0x77f48a00, 0xeb019f00, 0x3a858080, 0x09ca4040, 0x512560e0, 0xc6be70b0,
    0x7ae708d8, 0x0e9acce4, 0x77d48ab6, 0x8a319f57, 0x842d80a8, 0x273e4048,
    0xd1a3607e, 0x5271708e, 0xe64488d0, 0xb96f8cfc, 0x3cda6aa0, 0xe0beafe5,
    0xe5ea682a, 0x4a10bc55, 0x451582a1, 0xc994534b, 0x97528a6c, 0xeefe9f09,
    0x208e00b7, 0xc4cb00fe, 0xf4ad80a8, 0x8bfe4048, 0x1903607e, 0x8b81708e,
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x78000000, 0x94000000,
    0x6a000000, 0xdb000000, 0x60800000, 0xea400000, 0xed600000, 0xe9500000,
    0x08880000, 0x96440000, 0xbb660000, 0x045b0000, 0x350f8000, 0x398d4000,
    0x6dc0a000, 0x51a6b000, 0xb3718800, 0x493fe400, 0x4c547600, 0x99092500,
    0xa78f8080, 0x6ccd4040, 0x9220a060, 0xadb6b0b0, 0x24198878, 0x936be494,
    0x185a766a, 0xd30625db, 0xac8e00e0, 0xc44f00aa, 0x9461808d, 0xbed24059,
    0x7c492070, 0x2060f002, 0x04d6a8d1, 0x6f4014df, 0xaceb5e55, 0x109f71d3,
    0x332bfe00, 0xfe39c1f8, 0x92da765b, 0xa246252f, 0x416e006f, 0x775f00f9,
    0x098980e0, 0x55c640aa, 0xa5a7208d, 0x697ff059, 0x80000000, 0xc0000000,
    0xa0000000, 0x30000000, 0x68000000, 0x2c000000, 0x36000000, 0x13000000,
    0x63800000, 0x62400000, 0x78a00000, 0x89300000, 0x0f880000, 0x344c0000,
    0xfbaa0000, 0xb2b30000, 0x29ce8000, 0x56eec000, 0x57996000, 0xcdba3000,
    0x1c44b800, 0xb7a2e400, 0x14bdea00, 0x62c42300, 0x716e8080, 0x2fdec0c0,
    0x901160a0, 0xe5f63030, 0xb9eeb868, 0x3a11e42c, 0x68f36a36, 0x456ae313,
    0x3dd7e0e3, 0x0914f0a2, 0xfb7dd8d8, 0xef28d4b9, 0x59715267, 0xde2ac718,
    0xcbf96a4d, 0x8ee9e361, 0xd391606a, 0x77b630c4, 0x094eb8e7, 0xaf21e458,
    0x397b6a4d, 0x4e26e3bc, 0x93fde03a, 0xcae7f061, 0xc99358e3, 0x52b614a2,
    0x79c032d8, 0xaeecf7b9, 0x80000000, 0xc0000000, 0x20000000, 0x30000000,
    0x28000000, 0x04000000, 0x4a000000, 0xad000000, 0xce800000, 0xffc00000,
    0x45200000, 0x19900000, 0x92880000, 0x79cc0000, 0xb6220000, 0x28130000,
    0x22ca8000, 0x43ac4000, 0xf256a000, 0x85a1d000, 0xe1526800, 0xa425bc00,
    0x491ff200, 0xb243c900, 0x436a8080, 0xf8fc40c0, 0xe37ea020, 0x2e3dd030,
    0xe2d86828, 0x456abc04, 0xcbff724a, 0xf2f089ad, 0xae74a04e, 0xf0b2d03f,
    0x0518e865, 0x2c49fc29, 0x9c6952ba, 0x8772197d, 0xb430e87c, 0x77d5fc45,
    0x97e352cc, 0x523d198c, 0x54d0681f, 0x9e66bc58, 0xfe7d7219, 0x08b38940,
    0x39162099, 0x7a4290a1, 0x5764484e, 0xaaf72c3f, 0x6273ba65, 0xaeb8e529,
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x78000000, 0x74000000,
    0xf6000000, 0x5f000000, 0x7f800000, 0x5d400000, 0xe0e00000, 0xf0100000,
    0x99880000, 0xea4c0000, 0xc3620000, 0x27570000, 0xdc6f8000, 0xb8db4000,
    0xd1256000, 0x503ef000, 0x2d3a7800, 0x4bb19400, 0x6e70ee00, 0xa85cb100,
    0x6be78080, 0xc99740c0, 0xc3c76020, 0x7129f070, 0xe035f878, 0x753ad474,
    0x4fbd8ef6, 0xe07e415f, 0x8357f8ff, 0xe26dd49d, 0xcbd20ec0, 0x5ca50180,
    0xdc729861, 0x9953245e, 0x6f687615, 0x15549508, 0x2d62765b, 0x9c5f9551,
    0x7de7f667, 0xc69fd54f, 0xb44f1613, 0x206d6538, 0x82df8e63, 0x2c2941e4,
    0xf6b8787f, 0x28f6945d, 0xfd976ee0, 0xd5cbf1f0, 0x80000000, 0xc0000000,
    0xa0000000, 0xd0000000, 0xa8000000, 0xe4000000, 0x66000000, 0x11000000,
    0xff800000, 0x30c00000, 0x90a00000, 0x72700000, 0xd1880000, 0x75cc0000,
    0xd12a0000, 0xcfbd0000, 0x94a28000, 0xa4724000, 0x18846000, 0x16401000,
    0xcbef7800, 0xcc104c00, 0x6e5dea00, 0xabbc7700, 0x32aa8080, 0x157e40c0,
    0x370e60a0, 0x8e8d10d0, 0xbf45f8a8, 0xd86e0ce4, 0xaed38a66, 0x21f16711,
    0xd34f787f, 0x4a604cf0, 0xd1d5ea30, 0xfb7077a2, 0xd20080f9, 0x1f034051,
    0xaa8ce017, 0x794f500e, 0x196998c3, 0xf9521c70, 0xf53ef2ee, 0x25e02b75,
    0x29121265, 0xffdf7b49, 0xbe738a0f, 0x93816706, 0xa2c778ff, 0xefac4c30,
    0xa8ffea90, 0xd0cd7772, 0x80000000, 0x40000000, 0x20000000, 0xf0000000,
    0xe8000000, 0x4c000000, 0x0e000000, 0x49000000, 0x93800000, 0x81c00000,
    0x49600000, 0xdc300000, 0x51880000, 0x86c40000, 0xb3e20000, 0x3e7f0000,
    0x71268000, 0x5f90c000, 0x305ae000, 0xa0379000, 0xd789b800, 0x53c5dc00,
    0x3667f600, 0x52bc1300, 0xe9ce8080, 0x4564c040, 0xf230e020, 0xe88c90f0,
    0xfd4d38e8, 0x7e2a1c4c, 0x791b960e, 0xe41b4349, 0x9d9dd813, 0x37568cc1,
    0x5abeae69, 0x35c55f2c, 0x736c4e39, 0xef36cf8a, 0xd107f61d, 0x778c13c7,
    0xe3c680aa, 0xfe60c022, 0xeeb2e0bf, 0x0fc39089, 0x4063b8f3, 0x6fbedc51,
    0x20437651, 0x27a3d378, 0x23dae093, 0x61f79081, 0xbee9b849, 0x7ff5dcdc,
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x68000000, 0x8c000000,
    0xe6000000, 0xbf000000, 0x3d800000, 0x85c00000, 0x59a00000, 0x67d00000,
    0x47880000, 0x54c40000, 0x272a0000, 0x819d0000, 0xc0ee8000, 0x3d3cc000,
    0xdbbc6000, 0x49faf000, 0x6c935800, 0x006b9c00, 0xf07e7a00, 0xb35ccd00,
    0x18c68080, 0x2128c040, 0x4e9e60a0, 0x4563f0d0, 0x5cf7d868, 0xe81a5c8c,
    0x77249ae6, 0xa99efdbf, 0xece3b8bd, 0x0b34acc5, 0x0cb5c2f9, 0xf87c61b7,
    0x0f5142af, 0xe6cda198, 0xaa2ba2e1, 0x711f91ae, 0x15a69ab5, 0x61d7fda4,
    0x888f382c, 0xd1416c8d, 0x46e52238, 0xb2335132, 0xfe32fabd, 0xf8390da3,
    0x373e603d, 0xb2b3f085, 0xd37fd859, 0xe0de5c67, 0x80000000, 0xc0000000,
    0x60000000, 0x50000000, 0xb8000000, 0x54000000, 0x5e000000, 0xfb000000,
    0xbd800000, 0xe6400000, 0x8be00000, 0x12900000, 0xa6880000, 0xcbcc0000,
    0xb5a60000, 0x9d750000, 0x52138000, 0xc2414000, 0x9defe000, 0x359cb000,
    0xf90d5800, 0x648ca400, 0x72ce1e00, 0x712e7900, 0xdfb58080, 0xcb3440c0,
    0xf1fc6060, 0x5cddf050, 0x6162b8b8, 0xe3501454, 0x5e23465e, 0xfc32ddfb,
    0xb6739e3d, 0x97963926, 0x100fe06b, 0x180cb082, 0x6405587e, 0xb600a4cf,
    0x17081e53, 0xb78b7932, 0x434e0031, 0xcd69001f, 0x495d80cb, 0xcb284091,
    0x52b2606c, 0x01b4f0e9, 0xf03f383f, 0x2c7854dc, 0xea912685, 0x52862d72,
    0xa5cca635, 0xa6ae6d79, 0x80000000, 0xc0000000, 0x60000000, 0x90000000,
    0xe8000000, 0xd4000000, 0xf2000000, 0xc9000000, 0x43800000, 0x30400000,
    0x41600000, 0xb7f00000, 0xf6880000, 0xf5cc0000, 0xba260000, 0x04190000,
    0x0eb68000, 0x54694000, 0x82752000, 0x75cb9000, 0x7a2fb800, 0x6416c400,
    0x9eb77600, 0xbc624f00, 0x56708080, 0x87c040c0, 0xb32ba060, 0x279ed090,
    0xaef498e8, 0xfd0854d4, 0xe1884ef2, 0x7144cbc9, 0x46e456c3, 0x9db0dff0,
    0xaae9b8a1, 0xf3bfc4e7, 0xb5e9f67e, 0xf3370fb1, 0x332ba020, 0xe79ed0d9,
    0xcef498df, 0x6d08543d, 0x09884e68, 0xa544cb26, 0xb4e456bf, 0x54b0df2f,
    0xe969b871, 0xc3ffc42d, 0xf489f62b, 0x44c70f24, 0xc5a3a053, 0x1252d02e,
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xe8000000, 0xb4000000,
    0xfa000000, 0x09000000, 0x31800000, 0xd8c00000, 0x35200000, 0x25900000,
    0xda880000, 0xfc440000, 0xb2620000, 0x4b770000, 0x1ab68000, 0x5e174000,
    0x8341a000, 0x1ce19000, 0x2d389800, 0xf1d74c00, 0xbce53200, 0x1d302900,
    0x39dc8080, 0x78e44040, 0x0f352020, 0x84d1d070, 0xb367b8e8, 0xdef59cb4,
    0x80760afa, 0x4e35f509, 0x3155aab1, 0x59a36598, 0x26dbb295, 0x86636915,
    0xf17f2092, 0x33b2d078, 0x1f9b3880, 0xb381dc86, 0x9dcb2a39, 0xf2a0253b,
    0x225012fd, 0x7121f9a8, 0x779b3853, 0x4781dcc0, 0x47cb2a29, 0x8ba0254b,
    0xfbd012d9, 0x1de1f96c, 0xb8bb384f, 0x6b11dc6c, 0x80000000, 0xc0000000,
    0x20000000, 0x90000000, 0x68000000, 0x3c000000, 0x86000000, 0xb5000000,
    0x36800000, 0x49400000, 0xa3200000, 0xc0700000, 0x9d880000, 0xeecc0000,
    0xbee20000, 0xdd190000, 0xaf5e8000, 0xc3f7c000, 0x224e6000, 0x24ac5000,
    0x4dbee800, 0xe8e0d400, 0xe01b1200, 0x15d6f700, 0xf4b48080, 0x6062c0c0,
    0x6852e020, 0xaa729090, 0x26860868, 0xe147443c, 0xbf219a86, 0xd67f73b5,
    0x4085fab6, 0xe4462389, 0x71a79203, 0xcb383790, 0x59a46055, 0x17395082,
    0x6fa26870, 0x5a3e14c4, 0x0d23f277, 0xa9716703, 0x9d0e08b1, 0xea8b44d8,
    0x7f439a65, 0xee26731f, 0xa2fb7a88, 0x6ec1e31a, 0x7ee1f25e, 0xfd186775,
    0x3f5888a5, 0xabf084b5, 0x80000000, 0xc0000000, 0x60000000, 0x90000000,
    0x28000000, 0x8c000000, 0x1e000000, 0xd1000000, 0x98800000, 0x15c00000,
    0x5fe00000, 0xaeb00000, 0x65c80000, 0x27ec0000, 0x6ab60000, 0x67c10000,
    0xc0ee8000, 0xaf3ec000, 0xf480e000, 0x5bc39000, 0xc6e74800, 0x2a39bc00,
    0x46026e00, 0x2507a300, 0x4280e080, 0xc6c390c0, 0x20674860, 0x7ef9bc90,
    0xa9626e28, 0x1277a38c, 0x66a8e09e, 0x9e9f9011, 0xb79948f8, 0x2b14bc85,
    0x5cdaee77, 0x74386322, 0x370e80fb, 0x4d8ec036, 0xef48e092, 0x3d2f90e2,
    0x1cd148b7, 0xd438bc8d, 0xc70cee8f, 0xf58963ad, 0x4b4800b4, 0xaf2c0098,
    0xd3d600b9, 0x9db100b4, 0x4a4680fb, 0xbfa2c036, 0xba1ee092, 0x645e90e2,
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xd8000000, 0xe4000000,
    0xe2000000, 0x7b000000, 0x59800000, 0xa0c00000, 0x12a00000, 0x20b00000,
    0xbcc80000, 0x04ac0000, 0xb1b60000, 0x12430000, 0x23e18000, 0x7ed84000,
    0xe0dd2000, 0x3dde3000, 0x2d59d800, 0xc71d2c00, 0x10f21a00, 0x842d5300,
    0x93fd2080, 0x29ae30c0, 0xd931d860, 0xcc012cb0, 0x7e0c1ad8, 0xad0253e4,
    0xa88aa062, 0xbe4570bb, 0xede57839, 0x0bdb5c10, 0xac56e2ca, 0x619e4fc4,
    0xbbbee2de, 0x95424fbf, 0x1c60e208, 0xf71d4fc2, 0x08ff6209, 0x002a0fca,
    0xc1f5c286, 0x8aaf7fd6, 0x64b0ba1f, 0x8ec4239a, 0x17ae58a2, 0xd4366c95,
    0xb486bade, 0xa84723bf, 0x7cefd808, 0xa55e2cc2, 0x80000000, 0x40000000,
    0x60000000, 0xf0000000, 0x58000000, 0x44000000, 0x86000000, 0xdf000000,
    0x1f800000, 0xa4400000, 0x29e00000, 0xced00000, 0xa8480000, 0x03e40000,
    0xebd60000, 0x5ac70000, 0xb9218000, 0xe2f24000, 0x803f6000, 0x8d147000,
    0xb1efb800, 0xaadf2400, 0xbe4bee00, 0x74e7d500, 0xe85f6080, 0x3c847040,
    0xc9c7b860, 0xecab24f0, 0x93b5ee58, 0x0354d544, 0xbd00e006, 0x9685309f,
    0xacc7587f, 0x7e2e1454, 0xd972b671, 0x527ac18a, 0x23f256ae, 0x24bff19c,
    0x20d50e14, 0x4b41e54e, 0x4e6fb828, 0xbe9f24d8, 0xafabee96, 0x0e37d5e5,
    0x9e17601b, 0xa460708f, 0xbb91b8d7, 0xcd2c24d3, 0x1cf46eae, 0x8b36959c,
    0xbc978014, 0xd6a5404e, 0x80000000, 0x40000000, 0x20000000, 0x90000000,
    0xc8000000, 0x74000000, 0xda000000, 0x9f000000, 0x13800000, 0x80400000,
    0x47600000, 0x6e100000, 0xce480000, 0xf2640000, 0x9a920000, 0x71810000,
    0x53488000, 0x82e54000, 0x8754a000, 0x63ad7000, 0x3eb27800, 0xc57fa400,
    0xa6588600, 0xbd255900, 0x667ca080, 0x5bd97040, 0x58687820, 0x3d9aa490,
    0x6e0206c8, 0x25011974, 0x3c80805a, 0xcbc140df, 0x7b26a033, 0x877c7010,
    0xe552f88f, 0xb0aee41a, 0xfb362614, 0x2c3d296d, 0x0bbc5809, 0x71f694b1,
    0x3996de34, 0x8c02cd7c, 0xb60afe01, 0xd90afda5, 0xb28c26de, 0x1ec829fb,
    0x3faed88e, 0x60b6d41b, 0xf878fe94, 0x06dbfd2d, 0x48eca629, 0x90596921,
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x28000000, 0xfc000000,
    0x96000000, 0x13000000, 0xe3800000, 0x96400000, 0x0f600000, 0x2b300000,
    0x14480000, 0x56640000, 0x3db60000, 0x4a890000, 0xf8c68000, 0xe5a9c000,
    0xff986000, 0x615bb000, 0xeffdf800, 0x47ea0400, 0xcaf2c600, 0x87610b00,
    0xe7306080, 0xda4fb040, 0x8163f860, 0x9c370410, 0xa5ca4628, 0x9125cbfc,
    0xa8588016, 0x9174c053, 0x8520e083, 0xe25f7086, 0x64751827, 0x4da174d7,
    0x4399de82, 0x975d7f45, 0xecf13e5e, 0x8c660f9c, 0xa0b22617, 0x1e0e7b9e,
    0xdf0d7823, 0x2d8ac49b, 0x414c260c, 0xaee37bf2, 0xc47df8ef, 0x7daa045b,
    0x1b92c602, 0x53510b05, 0xaef8603e, 0xf56bb08c, 0x80000000, 0x40000000,
    0x20000000, 0x30000000, 0xa8000000, 0x14000000, 0x5a000000, 0xa9000000,
    0xbc800000, 0x80400000, 0xf3e00000, 0xa0500000, 0xb6480000, 0xece40000,
    0x43d20000, 0xf58b0000, 0x6cce8000, 0xcba34000, 0xdfb6a000, 0xf0181000,
    0xbda68800, 0xe0bba400, 0x239cae00, 0x56644d00, 0x749ea080, 0xf1ec1040,
    0xd55c8820, 0x54c4a430, 0x07a82ea8, 0x19b80d14, 0x271c80da, 0x5a2840e9,
    0x6178209c, 0xb6bb50b0, 0x2c90285b, 0x2de3b4b4, 0x8b5a26ec, 0x3fcfe945,
    0xae2a0e7f, 0x6b7c5d35, 0xa7b8283f, 0x1c17b41b, 0x4ba026e1, 0x9fb0e938,
    0xd01e8e8c, 0x8da01de8, 0x48ba0809, 0x3793e4c4, 0x0c648e6c, 0xdd9f1d05,
    0x4d6e885f, 0x551fa405, 0x80000000, 0x40000000, 0x60000000, 0xb0000000,
    0x18000000, 0x84000000, 0xee000000, 0x45000000, 0x7e800000, 0xe2c00000,
    0x64a00000, 0x5a900000, 0x0bc80000, 0x28240000, 0xf7560000, 0x0ae30000,
    0xb3f58000, 0x80764000, 0x1039e000, 0x345fd000, 0x8d6ea800, 0x95b84c00,
    0x051eda00, 0x89826100, 0x934fe080, 0x83ecd040, 0x4f732860, 0x35ba0cb0,
    0x95193a18, 0x418ab184, 0xbf4ac86e, 0xf1e5dc05, 0x6077921e, 0xe032fd52,
    0x4c5412fc, 0xb967bd9e, 0x63b87205, 0xc41e2d9d, 0x19073a71, 0x348db19c,
    0x99c948c1, 0xf7209ceb, 0x5ad3f2f3, 0xe7af6d8f, 0xbd1d5a16, 0x9d8721a6,
    0xb54b80a9, 0xeae1402c, 0x43f2601d, 0xf87e9019, 0x243cc81f, 0xc256dc99,
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xf8000000, 0x3c000000,
    0x22000000, 0x07000000, 0xf9800000, 0x0f400000, 0x55e00000, 0x74b00000,
    0xaa480000, 0xeb640000, 0x227a0000, 0x20e50000, 0x323b8000, 0xc081c000,
    0x43cb2000, 0xfc25f000, 0x3b915800, 0x5e555400, 0x5b7aee00, 0xcc6cf300,
    0x4bf92080, 0x77a4f040, 0x8bd0d8a0, 0x6e3194d0, 0xd28a4ef8, 0xccc8c33c,
    0x11a358a2, 0xd2d45447, 0x12bb6e59, 0xf34833df, 0x97e9802d, 0x03b0c008,
    0x7bc2a028, 0x2025303c, 0x699bf823, 0x71546413, 0x66fb1645, 0xdd2d97b3,
    0x3b11b690, 0xfd9ca758, 0xd7584e6c, 0xdff9c39a, 0xd1aad81b, 0x32d4944b,
    0x62b1ce50, 0xdb490340, 0x53e87821, 0x1db1a484, 0x80000000, 0xc0000000,
    0xe0000000, 0xb0000000, 0x88000000, 0x84000000, 0x92000000, 0x4d000000,
    0x95800000, 0x3cc00000, 0x50200000, 0x92900000, 0x13c80000, 0x20ac0000,
    0xefde0000, 0xd5230000, 0xa3148000, 0xed0e4000, 0x058e2000, 0xe4c25000,
    0xec2a1800, 0x0c926c00, 0x48c19200, 0x6a255100, 0x0b982080, 0x2c4d50c0,
    0x5d6098e0, 0x3c7f2cb0, 0xa47b3288, 0x38794184, 0xf6741812, 0x95716c8d,
    0xd3f51275, 0x21bb118c, 0x07de0058, 0x212300d6, 0x59148061, 0x940e40dd,
    0x8a0e20f2, 0x1102506d, 0xbb8a1861, 0xefc26c32, 0x9ea99283, 0xe4d951f8,
    0xa7ae20d3, 0x4b52508b, 0x02621818, 0x24fe6c17, 0xed3f9269, 0xe4965199,
    0xbcc4a000, 0x902f1050, 0x80000000, 0x40000000, 0xe0000000, 0xb0000000,
    0x48000000, 0x8c000000, 0x3e000000, 0xeb000000, 0xb3800000, 0xa1c00000,
    0x2f600000, 0x48900000, 0x82480000, 0xd6a40000, 0xf3fe0000, 0x80d30000,
    0x45e88000, 0xcfd2c000, 0xb46ee000, 0x13153000, 0xff817800, 0x3fce3c00,
    0x94652600, 0x0312c100, 0xe7866080, 0x4bc7f040, 0x6e6f98e0, 0x5a1b0cb0,
    0x81045e48, 0xb28cfd8c, 0x534b46be, 0x9c2131ab, 0x64bff8d3, 0xaefbfc51,
    0xf4554687, 0x39a23174, 0x527f7874, 0xa41d3cf1, 0xca0da69e, 0x5100017a,
    0x0a888011, 0x7742c0ea, 0x9e26e0c7, 0xf9b130d6, 0x7a7f7875, 0xd81d3c44,
    0x5c0da633, 0x860001ef, 0xcf0880a7, 0xb182c0a0, 0x3cc6e019, 0xfbe1300e,
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xf8000000, 0x64000000,
    0x0a000000, 0x43000000, 0x10800000, 0x0b400000, 0x36a00000, 0xfe300000,
    0xf3c80000, 0x91ec0000, 0x3e960000, 0xd0f70000, 0xc3ab8000, 0x93bc4000,
    0xc901a000, 0x9388b000, 0x7bcec800, 0xcde95400, 0x30987a00, 0x69f49b00,
    0x682a2080, 0xec74f0c0, 0xfeef6860, 0x1811e4f0, 0x66beb2f8, 0xa481cf64,
    0xa94c5a8a, 0x79ab6b83, 0x88b0c8f0, 0x2d82543b, 0x9acdfaae, 0x9263db6a,
    0x4d5e0081, 0x811b0076, 0x9d3d8044, 0xb34b4068, 0xf2aa201d, 0x6434f002,
    0xb8cf6806, 0x1d61e4bf, 0x5bd6b2a6, 0xaf5dcf87, 0x6e125a7b, 0x7bb06b14,
    0x650d4871, 0x6589144d, 0xa6c7daea, 0x6c672b02, 0x80000000, 0x40000000,
    0x60000000, 0xb0000000, 0x38000000, 0x44000000, 0x4a000000, 0x57000000,
    0xa6800000, 0x3f400000, 0xbda00000, 0xb6900000, 0x5dc80000, 0x88e40000,
    0x3c360000, 0xfdd30000, 0xd26f8000, 0x4d764000, 0x3d71a000, 0x2571f000,
    0xb177a800, 0x73721400, 0x58788a00, 0xf0f2b100, 0xd2be2080, 0x9e97b040,
    0xb1ce0860, 0x6ee7e4b0, 0xed392238, 0x3a53a544, 0x12a92aca, 0x74134117,
    0xf8818846, 0xea41a4cf, 0x502082e5, 0x91565542, 0xfa2082af, 0x365655db,
    0x04a08230, 0xfd165565, 0xcb008211, 0x58865570, 0x7a48824f, 0xb82255f8,
    0x5d5e82e4, 0xcc2155da, 0x6f59023f, 0xbf23152a, 0x33d6a2e9, 0xef65e514,
    0x6cf88ad5, 0x2cb2b127, 0x80000000, 0x40000000, 0xe0000000, 0xf0000000,
    0x38000000, 0x3c000000, 0xd6000000, 0xbd000000, 0x4c800000, 0xc0400000,
    0xbe200000, 0xd6300000, 0xf8c80000, 0xec640000, 0xdf1e0000, 0xf9770000,
    0x1d6f8000, 0x3d99c000, 0x58346000, 0xc9cb5000, 0xaeee8800, 0x6e53a400,
    0xe5d9d200, 0x8a1e3b00, 0xe1fbe080, 0x1f229040, 0x1cb2e8e0, 0xad8cf4f0,
    0xeac15a38, 0x1b6e9f3c, 0xe89bb256, 0x00b66bfd, 0x2b8ce82c, 0x7fcbf470,
    0xa3e6da66, 0xfad35f1a, 0xe991d296, 0xda3a3b2d, 0xb6c5e025, 0x7d659034,
    0x8d956837, 0x803134e7, 0x05cb3af0, 0x40e2cf72, 0xef52ba93, 0x7f580f46,
    0xf75f5ab5, 0x13599fe8, 0x095432ba, 0x5a5fab5d, 0x97d08843, 0xcd14a42e,
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x28000000, 0xf4000000,
    0xe2000000, 0x25000000, 0x92800000, 0x62400000, 0x0e200000, 0x02b00000,
    0x1cc80000, 0xe26c0000, 0x679a0000, 0x47f50000, 0x15668000, 0x48194000,
    0x1b312000, 0x9709d000, 0x5f82e800, 0xa4c04400, 0x5e631200, 0x01969300,
    0x78f7a080, 0x7ee090c0, 0xaedbc8a0, 0xb05594d0, 0x2c13fa28, 0xb13fd7f4,
    0x36003262, 0xd70643e5, 0x3f89c8b2, 0xd4cc9472, 0xa66f7a86, 0xdd939726,
    0x6ef79256, 0xb9e6d3f3, 0x19520037, 0x40990010, 0x407c8001, 0xbdac400c,
    0x2877a0c3, 0x29a090a6, 0xba7bc854, 0xf4a59446, 0xf4fbfab0, 0x80e3d76e,
    0x3dd232e4, 0x35df4381, 0xd1d548b1, 0xbbd0d436, 0x80000000, 0x40000000,
    0x20000000, 0xf0000000, 0xe8000000, 0xac000000, 0xd6000000, 0x1f000000,
    0x53800000, 0x24c00000, 0x25a00000, 0x3fd00000, 0xf1480000, 0x46640000,
    0x2df20000, 0x60570000, 0xb3828000, 0xb4ccc000, 0x1da06000, 0x8bd07000,
    0x63497800, 0x2361ec00, 0xb77cca00, 0x08103500, 0xe16ae080, 0x8a78b040,
    0xf69b1820, 0x03269cf0, 0xf99732e8, 0x28ad19ac, 0x495e4a56, 0x6f0cf55f,
    0xfb8280f3, 0xa8ccc094, 0x03a060ed, 0xc8d07063, 0x0ec978cf, 0xb4a1ecf5,
    0x175ccaa8, 0x0c00355b, 0x6602e045, 0xd70cb0ef, 0x0f8118e9, 0x1ac59c02,
    0x96afb257, 0xba52d9a9, 0xca8eaa7f, 0x30474583, 0x36e918bc, 0xb4b19c21,
    0xca35b265, 0x6871d9c8, 0x80000000, 0x40000000, 0x20000000, 0xd0000000,
    0x18000000, 0x04000000, 0x46000000, 0x5d000000, 0x61800000, 0x2d400000,
    0xfd600000, 0x5d300000, 0x96c80000, 0x8f240000, 0xfad20000, 0x0a350000,
    0xb04d8000, 0xfce64000, 0x807b6000, 0xa3a15000, 0xce13d800, 0x2e1cf400,
    0x9e1f6600, 0x76199b00, 0xba1ee080, 0xe0131040, 0xff12b820, 0x859ca4d0,
    0x945b3e18, 0x25f22f04, 0xa8e566c6, 0x9e789b1d, 0xdaa960c1, 0x399450bd,
    0x465e58c5, 0x06fab489, 0x406406c8, 0x8cb8cbd6, 0x538d385d, 0xbe4fe43a,
    0xfdedde0c, 0x83f53f5c, 0x45edde73, 0x17f53f35, 0x3bedde44, 0x9ef53f66,
    0x046dde0d, 0xeab53f39, 0xde8dde89, 0xc7c53f2b, 0xd4a5deb8, 0x38913f63,
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x68000000, 0x84000000,
    0x9a000000, 0xc7000000, 0x4c800000, 0x37400000, 0xd4600000, 0xe5700000,
    0x64c80000, 0x83ac0000, 0x78560000, 0x38db0000, 0xe1928000, 0x60fa4000,
    0xba08a000, 0x5703f000, 0x748f0800, 0xeb471400, 0xa2665600, 0x3c770f00,
    0x754c2080, 0x3f62b0c0, 0xd7f52860, 0x3e8ea430, 0xb449fe68, 0x62efeb84,
    0x253b7e1a, 0x9425ab07, 0xd59bdeac, 0x52fa5bc7, 0x990ad65c, 0xb18a4f91,
    0xecc80076, 0xf7ac0030, 0xea5600a6, 0x4bdb007c, 0x5f12808b, 0x14ba40f1,
    0xb8e8a0dc, 0x4233f0c1, 0x88a708f0, 0xbadb1482, 0x6a98568b, 0x62700f02,
    0x8840a0b2, 0xe4eff073, 0xf43908e0, 0x31ac14ea, 0x80000000, 0xc0000000,
    0xa0000000, 0xd0000000, 0x38000000, 0xc4000000, 0xf6000000, 0x9b000000,
    0xf7800000, 0xaa400000, 0x66600000, 0x32900000, 0x42c80000, 0xadac0000,
    0x15ba0000, 0x09b50000, 0x8bb78000, 0xaeb24000, 0xee3c6000, 0xb9f93000,
    0xdcd3b800, 0x12a90400, 0xa4347600, 0x70fa4100, 0x3651e080, 0x3c6e70c0,
    0x639058a0, 0xbc4e74d0, 0x4d61ae38, 0x8d1f75c4, 0xc481ae76, 0xc1cf755b,
    0x8e29aed7, 0xd1f375ba, 0xe0dbae7e, 0x80aa75e6, 0x19362eac, 0x247d35e2,
    0xaf95ce0c, 0x064a45ec, 0xac6816f4, 0x3b937179, 0x084a58d3, 0x536b74c3,
    0xea1e2e74, 0x010135a1, 0x0687cea7, 0x84c3457d, 0xbead9643, 0x6e38319c,
    0x79fbb804, 0x7cd50451, 0x80000000, 0xc0000000, 0xa0000000, 0xf0000000,
    0xd8000000, 0xf4000000, 0xea000000, 0xbd000000, 0x5b800000, 0xddc00000,
    0x4d200000, 0xfd500000, 0xbf480000, 0x396c0000, 0x84ba0000, 0x4eb70000,
    0xc3b98000, 0xe0314000, 0x39ffa000, 0x46d75000, 0xf2867800, 0xfc48bc00,
    0xa5e66200, 0x37f2dd00, 0x59dc2080, 0x680110c0, 0x4c0858a0, 0x4e02acf0,
    0x7f05bad8, 0xca8a31f4, 0x984dba6a, 0xc7e6317d, 0x56f7ba7b, 0xc45131ed,
    0x16ce3ab5, 0x0da07139, 0x88119aad, 0x0b272140, 0x9e5fe2cd, 0x13c39dea,
    0xf22380c7, 0x97d640b9, 0xd70e2002, 0x268a10e6, 0x2643d8ed, 0x60e8ece2,
    0x68799aa1, 0xb61b213d, 0x6c2de20e, 0x00d89d59, 0x91800012, 0x50c000ae,
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xf8000000, 0xec000000,
    0xfa000000, 0xeb000000, 0xc2800000, 0x5c400000, 0x37e00000, 0x40f00000,
    0xd7e80000, 0x50f40000, 0x7fea0000, 0x34f30000, 0x91e58000, 0xc9fdc000,
    0x426a2000, 0xbc337000, 0xeb460800, 0x9766b400, 0x4bbd7600, 0x508ebb00,
    0xb3460880, 0x4b66b440, 0x69bd7620, 0x278ebb70, 0x73c60878, 0x1026b4ac,
    0x66dd76da, 0xd03ebb9b, 0x514e08ba, 0x5c62b4f0, 0xf93f76ed, 0xf4c9bbdb,
    0x68a9886d, 0xf19874a0, 0x555ad692, 0xb5f40bef, 0x506020fc, 0x13307069,
    0xb7cb88d0, 0xce2f7453, 0x43dd5697, 0x9fbecbbe, 0x268d803b, 0xf249c033,
    0xeae020fc, 0xe3707069, 0x5a2b88d0, 0x15df7453, 0x80000000, 0xc0000000,
    0xa0000000, 0x10000000, 0x28000000, 0x9c000000, 0xe6000000, 0x59000000,
    0x7c800000, 0x5e400000, 0x35e00000, 0xea300000, 0x01e80000, 0x503c0000,
    0x1ee20000, 0x65bd0000, 0x14208000, 0x9214c000, 0x2dfee000, 0x20c95000,
    0x00ad2800, 0x3052b400, 0x4e117600, 0xabf19700, 0xc9cd2880, 0x4422b4c0,
    0xda1976a0, 0x01fd9710, 0xfec728a8, 0xeda3b45c, 0x36dbf646, 0xaf545749,
    0xbb9948d4, 0x013e2402, 0x2e683e73, 0x55ffb3a3, 0xf4cd16d5, 0xcaa10752,
    0xb75660ed, 0xdf919006, 0xf339c8e1, 0x1d6ae410, 0xbe76dec8, 0x1306e36a,
    0x3b883e0f, 0x6fcfb335, 0x7d251614, 0x169d078a, 0x67b460e1, 0x7f2c9010,
    0x7d9948c8, 0x883e246a, 0x80000000, 0x40000000, 0x20000000, 0x50000000,
    0x38000000, 0xbc000000, 0x76000000, 0x9d000000, 0x26800000, 0x6f400000,
    0x57600000, 0xd6f00000, 0x33680000, 0x2cf40000, 0x906a0000, 0x43710000,
    0x2ba98000, 0x2c5ac000, 0x67bee000, 0x1d0b1000, 0x66808800, 0x4f43e400,
    0x0766fe00, 0xeefa0b00, 0x8f608880, 0x5af3e440, 0x0d6efe20, 0x65fe0b50,
    0x44e288b8, 0x7b36e4fc, 0xb14d7e56, 0x2e65cbcd, 0x4a7de89e, 0xdf233493,
    0x44111601, 0xc5583f1b, 0xa3301ead, 0x3d451bbf, 0x106a0011, 0x03710018,
    0x0ba98026, 0x7c5ac083, 0x5fbee0ee, 0xa10b10a9, 0x1080882e, 0xd243e4bd,
    0x21e6fe81, 0x81ba0b09, 0xd8008826, 0x8c03e483, 0x3e06feee, 0x490a0ba9,
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0x54000000,
    0x26000000, 0x4b000000, 0x05800000, 0x95c00000, 0xc4e00000, 0x2df00000,
    0x12e80000, 0x4ef40000, 0x2b6e0000, 0xa1310000, 0x8e8b8000, 0xb0444000,
    0x6121e000, 0xe114f000, 0x331fb800, 0x2e14ac00, 0x08947600, 0xc4d03300,
    0xbff7b880, 0x6fe0ac40, 0x387a7660, 0xbf213350, 0x8e1c38d8, 0x7894ec14,
    0xacd39646, 0xe3f1c31b, 0x45e580dd, 0x01754081, 0xd7aa6082, 0x5550b036,
    0x2c3e584f, 0xd0005c8f, 0x180bcec9, 0x34049fc7, 0x7603ce19, 0x13009f2b,
    0x5185ce6e, 0xb3c59f7d, 0x8fe04e17, 0x2870df94, 0x872a2edc, 0x8a106f8b,
    0x069c7699, 0xb3d4336b, 0xc071b80e, 0x9b25ac2d, 0x80000000, 0xc0000000,
    0xa0000000, 0x30000000, 0x98000000, 0x34000000, 0x52000000, 0x45000000,
    0x63800000, 0x23c00000, 0xdc200000, 0xc8f00000, 0x06280000, 0xd1fc0000,
    0x3ba20000, 0xe13f0000, 0x0b0b8000, 0x188c4000, 0xc346a000, 0xbb641000,
    0x899a9800, 0x66bd2c00, 0xb2cada00, 0xbdace300, 0xa6329880, 0x25812cc0,
    0xc4c8daa0, 0xc2a3e330, 0x8cb11818, 0x33c16cf4, 0xb4247af2, 0xc4f4f375,
    0x502a007b, 0x5ef300d7, 0x2921802e, 0xf37f40bd, 0xb1e720fd, 0x6fdb50c6,
    0x2e5db8b5, 0xb0967c6c, 0xab3f626e, 0xba069fea, 0x890ffaa4, 0x9588b352,
    0x9cc4a0a4, 0x56ab105f, 0xeeb91872, 0xeecd6ce3, 0xe3ae7aee, 0xb537f32a,
    0xc9038004, 0xf5804062, 0x80000000, 0xc0000000, 0xa0000000, 0x70000000,
    0x98000000, 0xac000000, 0x32000000, 0x29000000, 0x14800000, 0x02c00000,
    0xcde00000, 0xadf00000, 0xb3e80000, 0xa6fc0000, 0xc6620000, 0xf4bb0000,
    0x0f4b8000, 0x23a1c000, 0x1ed0a000, 0x09f75000, 0xa5efe800, 0x59fe7c00,
    0x8debb600, 0xcdfae300, 0x63e7e880, 0x4ef27cc0, 0xf261b6a0, 0x6abde370,
    0x144e6818, 0x1e28bc6c, 0x089a9692, 0xc6db7359, 0xc5f9200c, 0x47ed906e,
    0x98f4c85f, 0xad68ecf4, 0x5134fe3f, 0xb503cf08, 0xde8bb6b9, 0x57cae3b0,
    0x036fe888, 0xb23e7c37, 0xf48bb62d, 0x12cae38c, 0x85efe833, 0xe9fe7c99,
    0xb5ebb6d3, 0x11fae36b, 0xc9e7e808, 0xcbf27cf7, 0xd4e1b68d, 0x417de3fc,
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x98000000, 0xb4000000,
    0xde000000, 0x61000000, 0xca800000, 0x63c00000, 0x39200000, 0xc9300000,
    0x6b280000, 0x923c0000, 0xa6aa0000, 0x7e750000, 0x70c38000, 0x38ae4000,
    0xff766000, 0x0a4c5000, 0x5364c800, 0xea596c00, 0xa973da00, 0x87413f00,
    0xd3ecc880, 0xa6956cc0, 0xa3d1da20, 0x53383f90, 0x3c2d4818, 0xa5b22c74,
    0x6dee3afe, 0xb79f2ff1, 0x415460d2, 0x8cf55017, 0xf70548c7, 0x678e2c38,
    0x73443a39, 0xedea2f45, 0x7797e0c1, 0x615b1016, 0x1cf328f1, 0x6f027c59,
    0xd380f2f8, 0xad434309, 0x8cec3a16, 0xbd162fe1, 0x029de09a, 0x25de10c0,
    0xa638a871, 0xb8a03c99, 0x3f7492d8, 0x2a461399, 0x80000000, 0x40000000,
    0x60000000, 0x10000000, 0xb8000000, 0x3c000000, 0x82000000, 0x79000000,
    0x1d800000, 0xf6400000, 0x67a00000, 0x8d300000, 0x82a80000, 0x22b40000,
    0xc5ee0000, 0xcc950000, 0xb8958000, 0xee9ec000, 0xf199a000, 0x3b1f5000,
    0x93d97800, 0x5abbb400, 0xd9ecc200, 0x3e934700, 0x69977880, 0x771eb440,
    0xb9d14260, 0xa7b98710, 0x7a60d838, 0x33d4e47c, 0x6abdbae2, 0x11ecf369,
    0xaa9dba25, 0x6f9cf38a, 0xb015ba05, 0x5f58f3a4, 0x3573bac7, 0xf609f3b8,
    0x2f003a78, 0x02863354, 0x3cca1afd, 0xcf66a32f, 0x44514294, 0x01f98799,
    0xc5c0d809, 0x92e4e4f8, 0xd215ba4f, 0x7658f3c5, 0xf0f3bac5, 0x2c49f353,
    0x72a03a76, 0xcab633f0, 0x80000000, 0x40000000, 0x60000000, 0x70000000,
    0x88000000, 0x34000000, 0xd6000000, 0xe5000000, 0x25800000, 0x89c00000,
    0xa2600000, 0x93b00000, 0xe3680000, 0xd8340000, 0x53ae0000, 0xcdd30000,
    0xf2d68000, 0x78584000, 0xc31fe000, 0x06301000, 0xc2aab800, 0x5e580c00,
    0xee17de00, 0x77b25700, 0xed64b880, 0x913b0c40, 0x6c295e60, 0xcb1e1770,
    0x72355808, 0x74a81c74, 0xcb5d66b6, 0x439a5b95, 0xca7b662d, 0x990d5bfd,
    0xe78be694, 0xaac21b46, 0x9ae486ae, 0x83fd4b55, 0x2ac15e4f, 0xdaea17bf,
    0xe3fb588a, 0x5acb1cc8, 0x52e3e629, 0xd7f61b70, 0x8cca868a, 0xb7ee4b75,
    0xf277de2c, 0x050257ab, 0x158cb882, 0x61cf0cbc, 0xe6675e9f, 0xcdbd17e5,
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xa8000000, 0xe4000000,
    0x2e000000, 0xc7000000, 0xfe800000, 0x22c00000, 0xfae00000, 0xf2300000,
    0x7be80000, 0xcfb40000, 0x79a20000, 0x28910000, 0xc3f88000, 0x49874000,
    0x64466000, 0x342d3000, 0x92d28800, 0xc8d29c00, 0x69d0e600, 0x44559f00,
    0x4e188880, 0x1d379c40, 0x216a66a0, 0x6373df50, 0x144e6828, 0x8c29eca4,
    0x7edc8e8e, 0x52dd7397, 0x28d486d6, 0x99d9af86, 0xbc5a80f4, 0x02164025,
    0xd73ee08d, 0xc86a7059, 0x5af4e805, 0xc80facf9, 0x540a6e68, 0x76030363,
    0xdb026e99, 0x9c87038c, 0x2fc86ef0, 0xed6203ac, 0xe972ee87, 0x5d444363,
    0xe5a40ec0, 0x0a9a3387, 0x6ef2e6b7, 0x0e049f4b, 0x80000000, 0xc0000000,
    0x20000000, 0xb0000000, 0x98000000, 0xd4000000, 0x1e000000, 0xe5000000,
    0x6b800000, 0xb9400000, 0x56e00000, 0x33700000, 0xed680000, 0x423c0000,
    0x678a0000, 0x93470000, 0x3deb8000, 0x95f64000, 0x73a06000, 0x679f1000,
    0xf91d5800, 0xc3dac400, 0x407c5600, 0x5fe8e300, 0xe2f6d880, 0x172c84c0,
    0xfe5c3620, 0x0037f3b0, 0xa08b8018, 0x6fc64014, 0x7028603e, 0x72d31055,
    0xf5ff58f3, 0x23a1c46d, 0x6f9dd648, 0x0519a3d6, 0x91dd3806, 0x6f75d43b,
    0xcf690e11, 0xd53e2710, 0x93088ec8, 0x228f67c3, 0x88c36eaa, 0x3ca63761,
    0xa71e5697, 0xc6d3e34b, 0xbbf75843, 0xceadc44a, 0xf81fd63b, 0xee52a3ae,
    0xe834b8e2, 0xcc8894b7, 0x80000000, 0xc0000000, 0xe0000000, 0x10000000,
    0xe8000000, 0x0c000000, 0x22000000, 0xa3000000, 0xd0800000, 0x8bc00000,
    0x44a00000, 0x13f00000, 0x0c280000, 0xac3c0000, 0x6e860000, 0x22cd0000,
    0xdb208000, 0x7ab1c000, 0x8844a000, 0x27e6f000, 0xd8912800, 0x657b8c00,
    0xdae3c200, 0xb11b4300, 0x9931a880, 0xfb0a4cc0, 0x048762e0, 0xbdcdb310,
    0x31a88068, 0xa67dc0cc, 0xda6aa0c2, 0x32d7f0b3, 0xc197a838, 0x22f74c87,
    0xa7afe266, 0xe37073b0, 0x77e2205c, 0x109a30e7, 0x997508ca, 0x00ecbc21,
    0xf6164a3f, 0x67b63fda, 0xf1cb4244, 0x33a68366, 0xf57b08b3, 0xf2edbc44,
    0x5d18ca1e, 0xab36ff99, 0xb0096207, 0xd80cb35d, 0x14060022, 0xd60d00d6,
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x88000000, 0x24000000,
    0x5e000000, 0x85000000, 0xb6800000, 0x01c00000, 0xf2200000, 0x42f00000,
    0x6aa80000, 0x5e3c0000, 0xa20a0000, 0xb7010000, 0x698a8000, 0xbc4f4000,
    0x486d6000, 0x239a1000, 0x85b68800, 0x014c4c00, 0x62ea4a00, 0x205b3300,
    0xd0940880, 0x823f0cc0, 0x400d2a20, 0xe00023d0, 0xf0080008, 0x580c00e4,
    0xac02007e, 0x7a0d0055, 0xdb08803e, 0x33824025, 0xb745e0ac, 0xf3e850c7,
    0xb0db68dc, 0x28581c5f, 0x349b2250, 0xfc322ff5, 0x150daa83, 0xde8e6322,
    0xd5cfe04a, 0xf4295084, 0x6bf1e844, 0xa6275c49, 0x84fe42fc, 0x63a43fa2,
    0x42b9223d, 0xf0cf2fc7, 0x52ad2ac6, 0xc2302393, 0x80000000, 0xc0000000,
    0xa0000000, 0x70000000, 0x98000000, 0x94000000, 0x6e000000, 0xa3000000,
    0x96800000, 0x3e400000, 0x56200000, 0x91700000, 0xbba80000, 0xcdbc0000,
    0x6dc20000, 0x41eb0000, 0xdd938000, 0xf3b64000, 0xe6cb6000, 0x7b657000,
    0x69d28800, 0xf09f5400, 0xd638ca00, 0x060b5300, 0x6f030880, 0xcc8214c0,
    0x83402aa0, 0xfba86370, 0xadb2e018, 0xbdc43054, 0xa9e868ce, 0xd19764d3,
    0x09baa20e, 0x2bcb37aa, 0x4ee82ab8, 0xc11463f2, 0x98f0e00d, 0x116f3043,
    0x2cdbe803, 0x19112434, 0x6cf9c290, 0xaf624709, 0x67d0a2f3, 0x839c3767,
    0xa8b9aa54, 0x3449231c, 0xc3280065, 0x90fc0005, 0x0d620086, 0x9edb00f7,
    0xa81b8085, 0x3b7a4046, 0x80000000, 0xc0000000, 0xa0000000, 0xd0000000,
    0x58000000, 0x5c000000, 0x7a000000, 0xcd000000, 0x80800000, 0x5e400000,
    0x4ce00000, 0x5b100000, 0x5b680000, 0x58dc0000, 0x31420000, 0x9d610000,
    0x5fdf8000, 0x54c0c000, 0x97ae2000, 0x33731000, 0xa83aa800, 0xa058b400,
    0x23070600, 0x538cf500, 0x45cf2880, 0xad2574c0, 0x0034a6a0, 0xb45e25d0,
    0xfd0420d8, 0x688e109c, 0x2a4728da, 0xe2e9741d, 0xe81ea6d8, 0x30e32502,
    0x3119a0b6, 0x6e6fd056, 0x5456887b, 0x4d0aa4d6, 0x40822e25, 0xfe44819a,
    0x9cee0efe, 0x03169101, 0x076b2606, 0x22dee5e0, 0xfc4a00c3, 0x1ded00e3,
    0x0195806d, 0x182dc079, 0xccbba07e, 0x681ed05f, 0xf0e108ca, 0x9116647b,
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xb8000000, 0x94000000,
    0x1a000000, 0x4b000000, 0xa5800000, 0x7bc00000, 0x48600000, 0xd2700000,
    0xe4e80000, 0xa33c0000, 0x60c20000, 0x35ed0000, 0x8db18000, 0x1e804000,
    0x16462000, 0xafa7f000, 0xbc1af800, 0x4b908c00, 0x27539e00, 0x4cb53b00,
    0x88017880, 0xfc01ccc0, 0x96063ea0, 0xd50f8b10, 0x4c842038, 0x014af054,
    0x8c2b78ba, 0xaad0cc5b, 0xdb75be1d, 0xee62cbef, 0x6f7380d2, 0x246d4059,
    0x3c77a0e1, 0x05e7b0c8, 0xe5bcd890, 0x92877c73, 0x88416673, 0x46a9b7f6,
    0xc698e653, 0x8fd5f721, 0x5ffcc659, 0x732f0757, 0xc55fbe4d, 0xf3b3cb04,
    0x878000d6, 0x64c0008d, 0x57e0009b, 0xf2b00033, 0x80000000, 0x40000000,
    0x20000000, 0x90000000, 0x08000000, 0x5c000000, 0x62000000, 0x81000000,
    0xed800000, 0x87c00000, 0x6e600000, 0x9e300000, 0x58e80000, 0xf1740000,
    0x4aca0000, 0xa9ed0000, 0xe4f28000, 0x2904c000, 0x6182a000, 0xcdcfd000,
    0x2361f800, 0x19b0ec00, 0x0225fe00, 0x1093bf00, 0xd2317880, 0x72ed2c40,
    0x0c7fde20, 0x5545af90, 0xa728a088, 0x3b12d01c, 0x52fb7842, 0xd6002c11,
    0x4f0d5ee5, 0xb6816fdb, 0x2f4a008c, 0x322d005f, 0xc8928095, 0xa634c0e6,
    0xdceaa02c, 0xe77bd06b, 0x65cbf8de, 0xaf6dec59, 0x53bf7ec6, 0x4f237fe3,
    0x9719d829, 0x88fffcee, 0x9304a61b, 0x948583bc, 0x8e45fe33, 0x4fa3bfde,
    0x47597828, 0x94592c3d, 0x80000000, 0xc0000000, 0x20000000, 0x50000000,
    0xb8000000, 0xec000000, 0x66000000, 0x23000000, 0xab800000, 0xadc00000,
    0x1b600000, 0x17100000, 0x09e80000, 0x0c5c0000, 0xabca0000, 0x88690000,
    0x74998000, 0xa023c000, 0x2531e000, 0x15d6f000, 0x6f0dd800, 0x5d8d6c00,
    0x16c2ce00, 0x0ce34d00, 0x64d65880, 0xdd8bacc0, 0xd6c8ae20, 0x2ce37d50,
    0x34d9e038, 0x658af02c, 0x3ac7d846, 0x4ae46c73, 0x17db4e13, 0xce008d41,
    0x9707b8fd, 0x518d5cf4, 0x00cd7682, 0xc7e211f1, 0x9b592e88, 0xfa4cbdb3,
    0x88aa00bb, 0xb379001f, 0x3b7180bd, 0xdf7fc08c, 0x9d7be0de, 0xdc7ff025,
    0x66f458f7, 0xc9beac9b, 0x919b2e10, 0xb8a9bdb2, 0xbb718026, 0x1f7fc05b,
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xd8000000, 0x44000000,
    0x7e000000, 0x61000000, 0x23800000, 0x7ec00000, 0xf1200000, 0x26500000,
    0x1fe80000, 0xcf7c0000, 0x1dbe0000, 0xbe950000, 0x6bcf8000, 0xc4af4000,
    0xd59d6000, 0x3f46d000, 0x14e01800, 0x8bf45c00, 0x15f5da00, 0xa4f82100,
    0x3f7d7880, 0x15b28cc0, 0x4295c260, 0x41cc7d10, 0x03a8a258, 0xd31aad84,
    0x1c00ba9e, 0xfa02f1b1, 0x7f03601b, 0x5283d0ea, 0x85479837, 0xcbe71c13,
    0xa976ba9a, 0x58bbf194, 0xf31ae031, 0xac059047, 0x520b78c6, 0xf30b8c43,
    0xb08c42fe, 0xde4a3d2c, 0xf7644283, 0x95363d9f, 0xf4da4275, 0x5aa33d4f,
    0x6495c25c, 0xa4cc7dd7, 0x3e28a2cf, 0xdcdaad6b, 0x80000000, 0x40000000,
    0xa0000000, 0x10000000, 0xa8000000, 0x7c000000, 0x16000000, 0x6d000000,
    0x7b800000, 0x66400000, 0xe3200000, 0x87d00000, 0xf3680000, 0xf9f40000,
    0x17320000, 0xa8dd0000, 0xcfec8000, 0x3f38c000, 0x94d8e000, 0x79e69000,
    0x42359800, 0x47551400, 0x63a9ba00, 0xb71c3100, 0xad857880, 0xeb478440,
    0x28ae22a0, 0x59942510, 0xc4404228, 0x1423753c, 0x9f53ba36, 0x47a5313d,
    0xc513f8f3, 0x1286444a, 0x3fc042fd, 0x32637586, 0xdc73bab6, 0xd07531ce,
    0x9e7bf8b9, 0x97724474, 0x3ef242ac, 0xf7be754b, 0x681f3aad, 0x890df1fe,
    0xe9831824, 0x6944d472, 0x8fafdabf, 0x491f61d4, 0x1c84809a, 0x96ccc0c5,
    0x8beae0b4, 0xbd3b909a, 0x80000000, 0x40000000, 0x60000000, 0xf0000000,
    0xb8000000, 0x24000000, 0x0e000000, 0xd1000000, 0x96800000, 0x05c00000,
    0x12600000, 0x69b00000, 0x41a80000, 0x3ed40000, 0x689e0000, 0x7fb30000,
    0x64a18000, 0x8e5f4000, 0xd05a6000, 0x6957d000, 0xf3da4800, 0x941aec00,
    0xc57b3e00, 0xc14e7f00, 0xcca82880, 0xa2593c40, 0x225f7660, 0x625793f0,
    0x025a9638, 0xf25c0364, 0x4a533eee, 0x6e5a7f61, 0x605628ce, 0xb15a3c91,
    0x27d6f6c4, 0x221cd36c, 0x307ef6e1, 0x59c8d38e, 0x1860f602, 0x26bbd372,
    0x4e2176f9, 0x31949348, 0x553316bd, 0xdb674304, 0x0b3f5e7e, 0x626aaf1b,
    0x91b3e0cb, 0x05ac9070, 0xc0d62898, 0x019a3c86, 0xcd36f6df, 0x6f6cd386,
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x28000000, 0x4c000000,
    0x4a000000, 0xe5000000, 0x7c800000, 0x45400000, 0x8b600000, 0x90500000,
    0x7c280000, 0xda340000, 0x76f60000, 0x1c590000, 0x96208000, 0x8f3bc000,
    0x72752000, 0x3d111000, 0x1b472800, 0xb0656400, 0x97dc0e00, 0xdeef8900,
    0xa39a0880, 0xb7007440, 0xed8d26e0, 0xf7c3ed50, 0x7d2e86a8, 0xe0b03d0c,
    0x7cbc0e2a, 0x5ebf89f5, 0x17b20834, 0x71347419, 0xf97b2609, 0x429aed69,
    0xdd8e06e2, 0xcfcbfd76, 0xf9292eab, 0xb6be993c, 0xfbbd2055, 0x8b3510dc,
    0x64792871, 0x5a186492, 0x9ec28e99, 0xeba94915, 0xf0f1a838, 0xf357a400,
    0xefa1ae37, 0xe6f159ea, 0x945e003a, 0x6a2d00fe, 0x80000000, 0x40000000,
    0x20000000, 0x50000000, 0x28000000, 0xfc000000, 0x0a000000, 0xf9000000,
    0x8e800000, 0x6bc00000, 0x2ae00000, 0x9a300000, 0xe4280000, 0x24540000,
    0xe4da0000, 0xc8190000, 0x137c8000, 0xe704c000, 0xe1812000, 0x6645d000,
    0x4ea00800, 0x8194cc00, 0xc932b600, 0x83a4c700, 0xc91b2880, 0x09f81c40,
    0x5ac63e20, 0x6860cb50, 0xa3f2bea8, 0xb3c00bbc, 0xeee19eaa, 0x6438dbe9,
    0xbb2f1606, 0x71d5d787, 0x049200a8, 0x0dbd008f, 0x316e8068, 0x3d79c01a,
    0xd00fa062, 0x680c103c, 0xdc07a859, 0x5a0cdccb, 0xd10f1e45, 0x72811b7b,
    0x61c0b6f7, 0xd3e9c750, 0x14bda89b, 0x8fe5dcfe, 0x0ebb9e99, 0x7ee1db6d,
    0x2c33968d, 0x372117ae, 0x80000000, 0x40000000, 0x20000000, 0xb0000000,
    0x38000000, 0xb4000000, 0x46000000, 0x4b000000, 0xfc800000, 0x86400000,
    0x03a00000, 0xb6700000, 0x52e80000, 0x73540000, 0xc3da0000, 0xd7970000,
    0x493d8000, 0xc0ce4000, 0x64eae000, 0x60557000, 0x1b506800, 0x9fdc7400,
    0x8d9a6200, 0x78391b00, 0xbd408880, 0xa72e0440, 0x143f8a20, 0x9f4f2fb0,
    0x02220ab8, 0x9fb16ff4, 0x2f80eae6, 0x3ec01fbb, 0xdbe28264, 0xfadf6bc2,
    0x661f60dd, 0x58ff30b9, 0x09a888f0, 0x6f7a04ba, 0x33658a42, 0xca982f18,
    0x36bf8a22, 0x160f2f88, 0xa3020aaa, 0xe0816f04, 0xfc48ea58, 0x82a41f09,
    0xf3f082ef, 0x252c6b73, 0x4130e06a, 0x0cc270c6, 0xb6ede80e, 0xdd5234a7,
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x58000000, 0x9c000000,
    0x1e000000, 0x3f000000, 0x83800000, 0x02400000, 0x18e00000, 0x1bd00000,
    0xe1280000, 0xad7c0000, 0x04120000, 0x048b0000, 0x8dc38000, 0x0cacc000,
    0x083b6000, 0xa377b000, 0xf3141800, 0x130c3400, 0xa5834600, 0xf1492100,
    0x2d6cf880, 0xe29744c0, 0xf84c3ea0, 0x95e2a5f0, 0x4153a6d8, 0x33ee515c,
    0x7251803e, 0xa667c00f, 0x7b18e07b, 0xe70b706e, 0xdf87785e, 0xbc4784b8,
    0xd7e55e7c, 0xc05e1590, 0x7f643e1f, 0xab9ea5dd, 0x20c1a654, 0x6625518a,
    0x22f20095, 0x105b00a6, 0x176b809c, 0xcf90c048, 0x52c960e5, 0x1f2cb0ff,
    0x027f9853, 0x8f9cf474, 0x32ca26d4, 0x4f2591c3, 0x80000000, 0xc0000000,
    0x60000000, 0x30000000, 0xd8000000, 0xfc000000, 0x6a000000, 0xab000000,
    0x71800000, 0x0fc00000, 0x83200000, 0x33b00000, 0x95680000, 0x5b5c0000,
    0xd3fe0000, 0x0c870000, 0x1f478000, 0x066ac000, 0x26d82000, 0x0e30f000,
    0xe8aa7800, 0xef76ec00, 0xcbc89a00, 0xe5265f00, 0x4ab5d880, 0x83ecdcc0,
    0x971ac260, 0x08104330, 0xa79f3a58, 0x1d506f3c, 0x3af1808a, 0x9201c05b,
    0xc709a0c9, 0x938130c3, 0xb0cbd831, 0xbcabdc64, 0x017d428e, 0xa6ca83ff,
    0xbdaf1aa1, 0xbbfc9ff0, 0xe885f8e9, 0xe9402c9e, 0xf76ebad8, 0x2451af95,
    0x8c782016, 0x0e40f072, 0xf4e27889, 0x1c9aec79, 0x24de9aae, 0x413d5fa2,
    0x6f2c5848, 0x11b11c01, 0x80000000, 0x40000000, 0x60000000, 0xd0000000,
    0x38000000, 0x2c000000, 0xe6000000, 0xb7000000, 0x59800000, 0xea400000,
    0xdf200000, 0x17d00000, 0x4ae80000, 0xb5b40000, 0x6b9e0000, 0xeac10000,
    0x5fe18000, 0xe939c000, 0xc558e000, 0x07263000, 0xabdb3800, 0xf4e8b400,
    0xfeb99a00, 0xec150100, 0x9b8a5880, 0x3f434440, 0xa3a44260, 0x091a85d0,
    0x4f097ab8, 0x5587316c, 0xbc4f6006, 0x802af027, 0x5a5c5801, 0x6aa64416,
    0x3b93c201, 0x92c6458c, 0x13e61a75, 0xdf3dc1a8, 0x4a5b380d, 0x72a8b487,
    0xa7999a92, 0x9cc501b7, 0xb0e258ba, 0x4cb74483, 0xf11a4240, 0x430b857a,
    0x0380fa5a, 0xe34af193, 0xcda98066, 0x7a1dc049, 0xe48ee0d6, 0xc2c33058,
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x68000000, 0x3c000000,
    0xd6000000, 0x51000000, 0x1a800000, 0x49c00000, 0xdf200000, 0xead00000,
    0xfa680000, 0x5d3c0000, 0x9d1a0000, 0x884f0000, 0x5b688000, 0xcfbac000,
    0x78d8e000, 0x59645000, 0xb4b10800, 0xc55dec00, 0xeb20ca00, 0x50d0d900,
    0x85696880, 0xf2bf7cc0, 0x4c532220, 0xa5a665b0, 0xf3102ae8, 0xdd4889fc,
    0x53e26076, 0xe57d9021, 0x6e736852, 0x5bf07cc5, 0x45bba261, 0xafdca587,
    0xeae8cab6, 0x03fcd985, 0xd1bb68f8, 0x65dc7c5b, 0xdde9a236, 0x207fa5f4,
    0xbef24a21, 0x25351921, 0xb911081e, 0x2a4decea, 0x5068ca45, 0x3a3cd9e9,
    0x469b6852, 0x030c7c74, 0x9981a298, 0x1043a54d, 0x80000000, 0xc0000000,
    0x60000000, 0xd0000000, 0x58000000, 0x14000000, 0xda000000, 0xf3000000,
    0x01800000, 0x7e400000, 0x28600000, 0x55d00000, 0x21a80000, 0x2efc0000,
    0x4c9e0000, 0x12490000, 0x966f8000, 0x94da4000, 0x4f2d2000, 0xc737f000,
    0x27b2f800, 0x477c7400, 0x6eda2e00, 0xcc2ce100, 0x2eb85880, 0xc5fdc4c0,
    0xf913f660, 0x060265d0, 0xc5090ed8, 0x8c8211d4, 0xdecd203a, 0xe8a7f0e3,
    0xcc7af839, 0x0b5074ba, 0x806c2eaa, 0x69d9e1b2, 0x07a9d87a, 0x9bfe8463,
    0x28195605, 0x5083d5e9, 0xe8c0d647, 0x65ac953b, 0x6cfc7618, 0xcb982518,
    0x19c42e44, 0x4325e1bb, 0xa937d8fd, 0xbeb7843d, 0x3df6d684, 0x5d199522,
    0x540df6d7, 0x7a0b6593, 0x80000000, 0xc0000000, 0x60000000, 0xb0000000,
    0xa8000000, 0xcc000000, 0x22000000, 0xb1000000, 0xbe800000, 0xea400000,
    0x9de00000, 0xf3100000, 0x48280000, 0x523c0000, 0x609e0000, 0xe6ef0000,
    0x90908000, 0xeee9c000, 0x8c9fa000, 0xd4e35000, 0x59920800, 0x84631400,
    0x20d2e600, 0x160cdd00, 0x87032880, 0x298684c0, 0xbbcfce60, 0xf22559b0,
    0x473c6628, 0x501a1d0c, 0x2fa408c2, 0xaaf014c1, 0x853c6676, 0x911a1d96,
    0x59240897, 0x3cb0144e, 0x92dc66b4, 0x1f0a1db9, 0x8d8c086b, 0x35cc14f3,
    0xd1226607, 0xe0b51d4e, 0xc8d48832, 0x7a09d486, 0x750bc676, 0x80854d7e,
    0x614800e2, 0xf66c0098, 0x49d600ed, 0xac83006d, 0x3346800c, 0x8f6ac0fa,
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xd8000000, 0x64000000,
    0xaa000000, 0xc1000000, 0x47800000, 0x8f400000, 0x94a00000, 0xbb300000,
    0x49680000, 0xc55c0000, 0x34b20000, 0xba2d0000, 0x3ffb8000, 0x748d4000,
    0xadc22000, 0x566dd000, 0xf1d19800, 0xf97bc400, 0xdc436200, 0x862b9f00,
    0x31fa3880, 0xbf8654c0, 0xbb435aa0, 0x46accb90, 0x8e38e258, 0x7ce6dfa4,
    0xef18188a, 0x4d9b8491, 0x4f5ac23f, 0xa5bb0f7b, 0x85a18066, 0x44bc40de,
    0x922ba004, 0xb3fd901b, 0xf280383f, 0x7ac754ea, 0x1ee2da48, 0x52108bcb,
    0x64134217, 0x3b1b4f66, 0x6f98204e, 0x925cd0dc, 0xbc38187f, 0xb9eb8495,
    0x3292c22b, 0x4bd70f0f, 0x207b80c4, 0x5fcd40c3, 0x80000000, 0xc0000000,
    0xa0000000, 0xb0000000, 0x68000000, 0x24000000, 0xa2000000, 0x15000000,
    0x4f800000, 0xee400000, 0x0b600000, 0x6d700000, 0xb3a80000, 0x21dc0000,
    0x9cf20000, 0x76ef0000, 0x8e308000, 0x1b4b4000, 0x94eba000, 0xfb3f9000,
    0x44cf9800, 0xa2af1400, 0xbc5d5e00, 0xafb5eb00, 0xa606b880, 0xc704c4c0,
    0x9281e6a0, 0x35c22fb0, 0x2f25dee8, 0x5712abe4, 0x33571882, 0x69385465,
    0xf9c4fe87, 0x69257b7a, 0x4019a041, 0xd9d0909c, 0xa0ff18fe, 0x38e4546a,
    0xad36feb0, 0x8bca7bd1, 0x04292014, 0xf39bd082, 0xd994b854, 0x389bc4f2,
    0xad196635, 0xaa556f86, 0x00bc7e37, 0x10823bbb, 0x50c80085, 0xa8ac0076,
    0x2d5a0027, 0xf23300da, 0x80000000, 0x40000000, 0x60000000, 0x30000000,
    0xd8000000, 0xf4000000, 0x16000000, 0xfd000000, 0xc3800000, 0x53400000,
    0x8a200000, 0x27b00000, 0x5be80000, 0x17540000, 0x323e0000, 0xd5af0000,
    0x0eff8000, 0xaec24000, 0x286be000, 0xdc1b1000, 0x2c191800, 0xd41a0400,
    0x701e0a00, 0x8e131700, 0x5f137880, 0x7e9c5440, 0xc6db7260, 0x72744330,
    0xc5098a58, 0x478557b4, 0xfd4698f6, 0xb328448d, 0x2a3dea7b, 0x01ac0797,
    0x48fc60c4, 0xbbcd506e, 0xc7ecf8ee, 0x6d5e1489, 0x4d3092a3, 0xcd2f5355,
    0xbb309249, 0x402f5323, 0xc0b09262, 0xd76f533d, 0x849092a2, 0xf9df530c,
    0x0af89223, 0x40cb5392, 0x71669284, 0xe1945389, 0xae5112f3, 0x7fb2138b,
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x48000000, 0xe4000000,
    0xbe000000, 0x51000000, 0xd1800000, 0xb7c00000, 0x1f600000, 0x47500000,
    0x16280000, 0xaf7c0000, 0x485e0000, 0xa6ab0000, 0xe13e8000, 0xf4ff4000,
    0x08946000, 0x054dd000, 0x222db800, 0x09780c00, 0x25543e00, 0x95273100,
    0x15f15880, 0x311d9cc0, 0xc68d6660, 0x3b46adf0, 0xb3223ec8, 0xb8f03124,
    0x6291d85e, 0xc249dc61, 0xb6a786f9, 0x99343da3, 0x38fbe669, 0xa295ed32,
    0xa2405e99, 0x46aae179, 0xd13ce02e, 0xdcf59082, 0x1c91587e, 0xf34d9c59,
    0x97256671, 0x66faad0e, 0xc39c3e7b, 0x5bcb313a, 0xe56758f4, 0x385a9c0b,
    0x2ea5e656, 0x653eed67, 0xbafede08, 0x1195a12f, 0x80000000, 0x40000000,
    0xa0000000, 0x90000000, 0xf8000000, 0x9c000000, 0x76000000, 0x0d000000,
    0x9f800000, 0xc9c00000, 0x9b200000, 0x98100000, 0x76180000, 0x971c0000,
    0xb6960000, 0x865f0000, 0x90f08000, 0x26294000, 0x2f962000, 0x7bdaf000,
    0x763d0800, 0xad829400, 0xfec5a600, 0x27ae6700, 0xcf5da680, 0x35726740,
    0xcceba620, 0x2a3d67d0, 0x3b8326d8, 0xc3c8274c, 0xd02306ae, 0x629dd741,
    0x44568e31, 0x2ffa0388, 0xceab08aa, 0xfadd9410, 0x27b5265c, 0x554727c7,
    0x1c6b86ca, 0x83789791, 0x21eeae02, 0x85b3f3bb, 0x9a4880a3, 0x3ce54051,
    0xa23820bc, 0x6f89f078, 0x41c388e6, 0xcf28d49e, 0x1a15063c, 0x6912d738,
    0xef9e0ec6, 0x9bdf434e, 0x80000000, 0xc0000000, 0x60000000, 0x50000000,
    0xd8000000, 0x34000000, 0xd6000000, 0x8d000000, 0xd3800000, 0xea400000,
    0xfd600000, 0xca100000, 0x74180000, 0x85140000, 0x0c920000, 0xd9d70000,
    0x743a8000, 0x3ee9c000, 0x585ca000, 0x8d707000, 0x11074800, 0x1982ec00,
    0x6d49ba00, 0xc9eddb00, 0x44d1ba80, 0xdfb9dbc0, 0xd0a3bae0, 0xfb3edb90,
    0x26613a38, 0x54931ba4, 0x2dd79aee, 0xc2306b29, 0xe3e0523d, 0x53d847c3,
    0x533dc8c0, 0x3a6b2c09, 0x5e951a34, 0xcaddab4c, 0xa6b6f2d8, 0xb52b3705,
    0xcc720014, 0xd087005f, 0x40c280c2, 0x72adc0ab, 0x0036a0b6, 0x48e37085,
    0xe557c82d, 0xd6f82c58, 0x17459a36, 0x06e76b45, 0xfc5ad2cd, 0xe37187c8,
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x48000000, 0x64000000,
    0xfa000000, 0x17000000, 0xdd800000, 0xd0c00000, 0x9ba00000, 0x34f00000,
    0xebf80000, 0x92740000, 0xd8b20000, 0xc41b0000, 0x656f8000, 0x3a51c000,
    0xc98a6000, 0x32c91000, 0xc0a7c800, 0xe7714400, 0x9e3b3e00, 0xa7591100,
    0x1b093e80, 0x738211c0, 0x85c6bee0, 0xed23d150, 0xefb4dea8, 0x299ec134,
    0x0da11652, 0x1df48523, 0x2b75a88f, 0x503c54f3, 0x6256f694, 0x25875507,
    0xcccf809f, 0xbda1c0c5, 0x65f260ef, 0xf77d1035, 0x1635c858, 0xa35a44ec,
    0x710cbefe, 0x2c8cd17d, 0x3c495e02, 0xc7e401a9, 0x631cf651, 0xc0e855e8,
    0x369200aa, 0x142b009d, 0xc7378003, 0x7fd5c0cb, 0x80000000, 0x40000000,
    0xe0000000, 0xf0000000, 0x88000000, 0x44000000, 0xa6000000, 0x6b000000,
    0xcd800000, 0x47400000, 0x69e00000, 0x62300000, 0xa1380000, 0x78bc0000,
    0x01f20000, 0x3f1d0000, 0xfaa58000, 0x95d9c000, 0x840fa000, 0x060b1000,
    0x7b02c800, 0xb58f3c00, 0x8b4a6200, 0x8beae100, 0xaf386280, 0x07b7e140,
    0xf27de260, 0x2f5e21b0, 0x34ca42e8, 0x39a931f4, 0x4c5a8a4e, 0xfd4b0d9f,
    0x38ed6883, 0xbeb42cd8, 0xdaf0aa6a, 0x9a99ddfa, 0x09e000ab, 0xd2300032,
    0xc9380042, 0xccbc00f9, 0x2ff20076, 0x101d00b3, 0x91258011, 0xb999c0dd,
    0x206fa068, 0x237b1026, 0xb3dac8e6, 0xaf033cf0, 0x2b806280, 0xcc4be1d2,
    0x546fe2a8, 0xad73216f, 0x80000000, 0x40000000, 0x60000000, 0xd0000000,
    0xe8000000, 0xf4000000, 0x4a000000, 0x51000000, 0xae800000, 0xb5c00000,
    0xb5a00000, 0x7a500000, 0x67580000, 0xdfdc0000, 0xe51a0000, 0x35370000,
    0xed298000, 0xd09ec000, 0x3f766000, 0x23c17000, 0x7aa89800, 0x7fd44400,
    0x1510de00, 0x6d359b00, 0x212ade80, 0x86929b40, 0xd07b5ee0, 0x96405b90,
    0x30ef3e08, 0xd13a2b64, 0x6f2c2642, 0xc59baf35, 0xe3f918ec, 0xdb068480,
    0xdf84bed9, 0xab4febba, 0x3869c65e, 0xd3f31ff5, 0xa30e6033, 0xa38d70e4,
    0xc54a98fc, 0xcb6f44d1, 0xd87b5e47, 0xf2405bc6, 0xf2ef3e4e, 0xa43a2bc2,
    0x63ac26a3, 0xd55baf8b, 0xb2d91846, 0x459684a6, 0xa3fcbee1, 0xbb03ebbe,
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xf8000000, 0x34000000,
    0x76000000, 0x4d000000, 0x88800000, 0x93c00000, 0x9e200000, 0x5fd00000,
    0x40d80000, 0x9b540000, 0x511a0000, 0xde710000, 0x7b4e8000, 0x7de5c000,
    0xd9fea000, 0x9b0c7000, 0x558bf800, 0xb34f4400, 0x71e0e600, 0x7bf6fb00,
    0x1002e680, 0x6803fbc0, 0x9c0e6660, 0x0a033b70, 0xf7044698, 0x878b8b44,
    0x20479eee, 0xc8697f09, 0xdab02066, 0x12e9b09a, 0x1a755878, 0xd5433405,
    0x54eb1ed8, 0x6f79bf2e, 0x89c200f1, 0x01250004, 0x4454809c, 0x6a94c044,
    0xa43020d5, 0x0c29b0c8, 0xecd55890, 0xa953345d, 0x72131e5f, 0x9ffdbf63,
    0xee000088, 0x090000d9, 0xe68000d1, 0x5ac0001a, 0x80000000, 0x40000000,
    0xe0000000, 0x70000000, 0x68000000, 0x44000000, 0x32000000, 0x19000000,
    0x5d800000, 0x52400000, 0x2b600000, 0x5c100000, 0xd9980000, 0x07dc0000,
    0xcab20000, 0xa5a50000, 0x14bb8000, 0x6aa3c000, 0xf232e000, 0x64667000,
    0xfa902800, 0x3752cc00, 0x7f7c9a00, 0xf1802b00, 0x64471a80, 0xe063eb40,
    0x6895fa60, 0xbe559b30, 0x3afdd208, 0x8fcb5774, 0x392b483a, 0x97727c6d,
    0xf585d2e7, 0xb647577f, 0x896148ac, 0x5d1b7c13, 0xa814527d, 0x239d9760,
    0xcada288d, 0xbd3bcca8, 0xc2ed1afe, 0x145aebfd, 0x4ffc7a40, 0x44435bfa,
    0x306cb2af, 0x9092e7e9, 0xe25b80ef, 0x24f3c0e9, 0xe0cae048, 0x4faa7096,
    0x81ba2843, 0xd12bccfa, 0x80000000, 0xc0000000, 0xe0000000, 0x70000000,
    0x28000000, 0xcc000000, 0x4a000000, 0x63000000, 0x6e800000, 0x26400000,
    0x3ee00000, 0xa1700000, 0x4bf80000, 0x5bb40000, 0x845a0000, 0x94ad0000,
    0xf5978000, 0x198f4000, 0x26c1e000, 0x1da2d000, 0xa81fb800, 0xe94c9c00,
    0xaa619200, 0x2c37d500, 0xa7961280, 0xbe8895c0, 0x5e4ff260, 0x4aee45b0,
    0x7f724a48, 0x86fbd97c, 0xd03e5802, 0xe59e4c1f, 0x81862aec, 0x22cf49f9,
    0xebad80b2, 0xa91240e8, 0x28ce60b1, 0xa8a990cf, 0x579c58b7, 0x56874c84,
    0x724baa4e, 0x70ed0914, 0x347be0f2, 0x247fd02d, 0xbc703821, 0xb877dca8,
    0x4e7a72b2, 0x4f780556, 0x8efe2acd, 0x8c3b4951, 0xf7978000, 0x068f40be,
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x98000000, 0x6c000000,
    0x16000000, 0x45000000, 0x5a800000, 0x77c00000, 0x93e00000, 0xc9d00000,
    0x05580000, 0xf7940000, 0x1ef60000, 0x70eb0000, 0x7e5a8000, 0x2c184000,
    0x21b72000, 0xe3cc7000, 0xd9e55800, 0xf2d16400, 0x3ed5fa00, 0x38dd5700,
    0xc5d77a80, 0x235117c0, 0xda965aa0, 0x60766710, 0xe5298238, 0xd2bf437c,
    0xec4b582e, 0x4cae6439, 0xaaf97af4, 0xeaee178e, 0xdd5adac7, 0x7b952757,
    0xf8fc227a, 0x7def731c, 0xd0d720ea, 0x21dc7045, 0xe15d5858, 0x3595649b,
    0xf1fbfa90, 0xe1625716, 0x7a1bfac7, 0x84b25776, 0x4943fad4, 0xe626575c,
    0x9535fab3, 0x8d0d5738, 0x6e8f7ab3, 0x2dc5171b, 0x80000000, 0xc0000000,
    0x60000000, 0xd0000000, 0xb8000000, 0x54000000, 0xce000000, 0x93000000,
    0xa1800000, 0xe3400000, 0x76600000, 0x13b00000, 0xc8380000, 0x66740000,
    0xfa920000, 0x2fef0000, 0x04fc8000, 0xc05dc000, 0x8ecb2000, 0x7f211000,
    0x30d18800, 0xd50f7c00, 0xce88ba00, 0x00cdd100, 0x4c2c3a80, 0x215411c0,
    0x5e4d1ae0, 0x54ee0110, 0x89721258, 0xd913bd44, 0x75ad0896, 0xe612bcd7,
    0xee239ab7, 0xe85cc1f4, 0xc2c5b221, 0x552f6df7, 0x05d7a031, 0x0b8cd015,
    0x1642a83d, 0xc8ea6c3d, 0x1b733236, 0xb819ad5d, 0x652a0057, 0xaddb0046,
    0x878e80f7, 0x5c42c065, 0x2defa072, 0x7df8d04b, 0x34d0a8c0, 0x63056c51,
    0x698fb2b3, 0xbf446dac, 0x80000000, 0xc0000000, 0x20000000, 0x30000000,
    0xb8000000, 0x04000000, 0x3e000000, 0x3b000000, 0x2e800000, 0x80400000,
    0x05a00000, 0x8df00000, 0x51780000, 0x88340000, 0xb2160000, 0x1c250000,
    0x61368000, 0xf592c000, 0x1bef2000, 0x43559000, 0x6a0bf800, 0x6d0e3c00,
    0xb980c600, 0x1cc2c900, 0x3cee4680, 0xa7d409c0, 0x774f66a0, 0x492099f0,
    0x1cbc1e18, 0xf75d65f4, 0x2c0b7826, 0x7209fccf, 0x99016688, 0x1f81998f,
    0x13c49e2d, 0x946ea5f2, 0x189cd8e4, 0x626fac4e, 0x7f9d3e50, 0x66e9f5ad,
    0x72d80081, 0xcac40013, 0x6bee00a9, 0x1b5100a9, 0x7e008031, 0xdb07c0ce,
    0x3e81a0c3, 0x084350f9, 0xb9aad839, 0xb7faac81, 0x5473be4e, 0x9dbf35fb,
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x38000000, 0xac000000,
    0xda000000, 0x3b000000, 0x73800000, 0x0a400000, 0xbd600000, 0x95100000,
    0x8d980000, 0xac540000, 0x077e0000, 0xdd0f0000, 0x6a848000, 0x4ec24000,
    0x0ea5e000, 0x21375000, 0x7a6be800, 0x64958c00, 0xa0ddfa00, 0x90b01b00,
    0x37277a80, 0xe87d5bc0, 0xb8861a20, 0x31c84bd0, 0x93281218, 0x767a977c,
    0x6d8600c2, 0x1f4b0047, 0x33e28031, 0x25d9408d, 0xe63f602c, 0x8bea1008,
    0x49d28899, 0x9c349c08, 0xa0edf244, 0x025dc7ee, 0x3a75e8dd, 0xc78a8c6a,
    0xac417a4e, 0xc4665b0e, 0x619c9aa1, 0x16550bba, 0x8c717244, 0x868b8770,
    0xf4ce0888, 0x85a2dc4b, 0x7ab612aa, 0xe425973f, 0x80000000, 0xc0000000,
    0x20000000, 0x50000000, 0xf8000000, 0xe4000000, 0x62000000, 0xdf000000,
    0x8d800000, 0xfd400000, 0x01600000, 0x2bd00000, 0xe5580000, 0xd3940000,
    0xb2b60000, 0x9a830000, 0xdcc48000, 0xf226c000, 0xdbb2e000, 0xe2021000,
    0x1f014800, 0xad8edc00, 0xad4fea00, 0xf96a2700, 0xcfdd6a80, 0x875fe7c0,
    0x0c930aa0, 0x3f3f3790, 0x67cea258, 0xdda4fb74, 0xd9f2803a, 0x3ee5c0ab,
    0x31966037, 0xadb4d096, 0x370ba816, 0x7188cced, 0x0b40a20b, 0x1463fbda,
    0x6558005b, 0x1394005f, 0x92b600aa, 0xca8300c0, 0x24c480a8, 0x1626c0bd,
    0xb9b2e0c8, 0x3d0210f8, 0x92814838, 0x50cedcb9, 0xac2feaa7, 0xd2ba271a,
    0x2a856a14, 0x54cbe7ff, 0x80000000, 0x40000000, 0xa0000000, 0x10000000,
    0x98000000, 0xd4000000, 0x6e000000, 0x1f000000, 0x0f800000, 0x4ac00000,
    0x3de00000, 0x2b500000, 0x47d80000, 0x709c0000, 0x9ab60000, 0x36870000,
    0xf6468000, 0x72afc000, 0xa5732000, 0x0debd000, 0xe35ea800, 0xabd14400,
    0xda9b7a00, 0x73babf00, 0xf20bfa80, 0xdd027f40, 0x1a865a20, 0xbc4a6f50,
    0x2ba5d2b8, 0xe9fbfb84, 0x6aa880d6, 0x3174c09b, 0xc3e3a059, 0xec531091,
    0x3c5308c4, 0x445954aa, 0x2058f21b, 0xc65b2b0e, 0x955ea86f, 0x20d14467,
    0x1b1b7ab6, 0x367abf0f, 0x586bfa96, 0x68927fad, 0x0ebe5a64, 0xf8866fad,
    0xf94bd2dd, 0xe520fb69, 0x3bb80085, 0x5e0c00b8, 0xd70e00cf, 0xe38b0058,
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x28000000, 0x84000000,
    0x9a000000, 0xfd000000, 0xd5800000, 0xc5c00000, 0x5b600000, 0x3fb00000,
    0x9d380000, 0x98740000, 0x37520000, 0x9c4b0000, 0xb0a18000, 0xdbd5c000,
    0xb6026000, 0x2300b000, 0xd2856800, 0x7d4e7400, 0x6329e200, 0x251f0900,
    0x63e26280, 0xc7f5c9c0, 0xe79382e0, 0xf6abb950, 0x40d50ac8, 0xc880bdd4,
    0x4043e052, 0xd6a57029, 0x70df0807, 0x108ac42c, 0x7c468a3c, 0xe0ae7d83,
    0x93d80009, 0xa204005f, 0x910a0044, 0xab8f006e, 0x32cb8069, 0x5beac064,
    0xabf1e036, 0x999e7001, 0x01a68836, 0x405b04dc, 0x5cceeaec, 0x44e1cd9f,
    0x4f76e879, 0x07d0b4e4, 0xd00a0262, 0x880a7965, 0x80000000, 0xc0000000,
    0xe0000000, 0xb0000000, 0x08000000, 0x24000000, 0xee000000, 0xcb000000,
    0x1a800000, 0xdb400000, 0xd5600000, 0xdab00000, 0xf5380000, 0x67f40000,
    0x0f5a0000, 0xa9c10000, 0x5a298000, 0x09d7c000, 0x708f2000, 0x6e4c9000,
    0x5cefb800, 0x87754c00, 0x39157a00, 0x692aa100, 0x1f5efa80, 0x31c861c0,
    0x26225a60, 0x7bd23170, 0x798b4268, 0x75cc2d54, 0xb826a086, 0x58db509f,
    0xf700981c, 0x4889dc84, 0x8242c229, 0x76ebedee, 0x12718054, 0xe093c06d,
    0x8ced20d5, 0xff79907f, 0xf51c387d, 0x13238c39, 0x3253da3e, 0xc441f162,
    0x09e662e3, 0xbef5bd52, 0x6cda98fa, 0x8108dc23, 0xff8b4217, 0xeacc2d42,
    0xa4a6a035, 0xdc9b5022, 0x80000000, 0x40000000, 0x60000000, 0x70000000,
    0x68000000, 0x9c000000, 0x6e000000, 0x9f000000, 0xd3800000, 0x1c400000,
    0xcea00000, 0xd7f00000, 0xc9780000, 0xa7bc0000, 0x41da0000, 0x134d0000,
    0x45238000, 0x5fbe4000, 0x85d6a000, 0xe94c5000, 0x5829e800, 0x1532ec00,
    0x49106600, 0x862e2900, 0xc231e680, 0x16916940, 0xec66c6e0, 0x67927930,
    0xe0e00e88, 0xc85f85ac, 0x420ca0e6, 0xb9015033, 0xc08a68b5, 0xb9ccac6f,
    0xb9e6c61b, 0x38d279c8, 0xf3c00e3a, 0xecef85b3, 0xfe54a075, 0x490d504f,
    0xe888680b, 0x45cdacd0, 0xa7e7464e, 0xcfdd3901, 0xbc4f2ee4, 0x9ea09573,
    0xaff0682c, 0x4d71acde, 0x3dbd4659, 0x2cd039f0, 0x31ccae31, 0x15eed515,
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xa8000000, 0xbc000000,
    0x66000000, 0x3b000000, 0x1b800000, 0x66c00000, 0x74600000, 0x0fb00000,
    0x51780000, 0x111c0000, 0xf4aa0000, 0x00d70000, 0x25418000, 0x76a04000,
    0x39d12000, 0x47c31000, 0x12eae800, 0x79f9a400, 0xa05bf200, 0x1804e100,
    0x040ad280, 0x1207f140, 0xb1003ae0, 0xee8e5510, 0xfa43c848, 0x6f26b4ac,
    0x261b1aae, 0x312a45d7, 0x2910a055, 0xc0a350a1, 0xeadbc869, 0x804ab402,
    0x42291a96, 0x9e9145c4, 0x08632037, 0x49b81065, 0x5a7968fb, 0xf292e451,
    0x86615234, 0xaeb0b182, 0x77f09ab9, 0x075d0522, 0x55800084, 0xa1c00050,
    0x69e0002f, 0x027000e6, 0x969800b3, 0xc46c0035, 0x80000000, 0xc0000000,
    0xe0000000, 0x30000000, 0xf8000000, 0x64000000, 0xa2000000, 0x73000000,
    0xca800000, 0x3bc00000, 0x5ca00000, 0x1c700000, 0x33b80000, 0x15140000,
    0xce6a0000, 0x5d510000, 0x9c8a8000, 0x02c6c000, 0xa92de000, 0xe3385000,
    0x19d63800, 0x2a4a6400, 0xc1e2fe00, 0xa51d8100, 0xf66f1e80, 0xd955d1c0,
    0x0e812660, 0x89cbb5f0, 0x07a9d898, 0x7af73494, 0x367446ba, 0xfcb02527,
    0xc9928010, 0xeca2c0ec, 0x247fe0d4, 0xb7bd5064, 0x8716b85d, 0x456da456,
    0xf3dd9e03, 0x05471127, 0x2d66c62b, 0x7fd2e5b1, 0xeb4d60c7, 0x506f9050,
    0xf8515807, 0xaf04f48a, 0x2c8126e5, 0x3acbb526, 0x2d29d85a, 0x713734dc,
    0x92d446e6, 0x84c02501, 0x80000000, 0x40000000, 0xa0000000, 0x10000000,
    0xf8000000, 0x0c000000, 0xca000000, 0x53000000, 0xef800000, 0x7ac00000,
    0xde600000, 0x8b100000, 0xc5d80000, 0x3dbc0000, 0x9fa60000, 0x0eff0000,
    0x520c8000, 0xaf0a4000, 0x6d89e000, 0xcdc85000, 0x0fe8e800, 0x64dca400,
    0x6d301200, 0x70ebcb00, 0x1159f280, 0x1cf39b40, 0x5d091a20, 0xd2833f50,
    0x584708d8, 0xce2bf45c, 0xa1347a92, 0x5aed2f4f, 0xf258005d, 0x1b7c0065,
    0xd3c6005b, 0xcaef00b2, 0x4a54800c, 0xb77640c0, 0x09cfe04e, 0x61e750eb,
    0xa9dc68e7, 0x07bae4e6, 0x84a7f27e, 0x05709be7, 0x16c39a75, 0xe4667f7b,
    0x901a68b0, 0xce55e487, 0x79737279, 0xd4c6dbbb, 0xf36c7afe, 0x51912f6c,
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x48000000, 0x94000000,
    0xd6000000, 0xa1000000, 0x65800000, 0x7dc00000, 0x5fe00000, 0xd6b00000,
    0x59780000, 0xf9940000, 0x1fa20000, 0xb8990000, 0x8a298000, 0xed52c000,
    0x71cea000, 0xa5e13000, 0x1db3a800, 0xeff9d400, 0xded99a00, 0x6d0e1900,
    0xff8f3a80, 0x86cb29c0, 0xa16692e0, 0x65fffdf0, 0xfdd488a8, 0x1f8a2464,
    0x76c492fe, 0x8966fd05, 0xc1fd087b, 0x63d8e488, 0x2a8a328c, 0xc547cd3a,
    0x55aea0ab, 0xfb913006, 0xc8aba8af, 0x2c1dd406, 0xea639ae1, 0x13731945,
    0xba9cbaed, 0x5d24e947, 0x79dbb23a, 0x11810dd3, 0x5bc2005a, 0xd6e9002d,
    0x17318011, 0xbab6c015, 0x9374a015, 0x7a9c30db, 0x80000000, 0xc0000000,
    0xe0000000, 0x90000000, 0x08000000, 0x6c000000, 0x7a000000, 0x77000000,
    0x74800000, 0x09c00000, 0xabe00000, 0xff900000, 0x51580000, 0xa6340000,
    0x4c6a0000, 0x54db0000, 0x1e7f8000, 0x61cb4000, 0x97e3e000, 0x6d911000,
    0xda561800, 0xa0b2e400, 0x5ea60a00, 0xf1be0b00, 0x9f2fea80, 0xeff41bc0,
    0xc7867260, 0xdb4dbf50, 0xd7239868, 0xa3f2a43c, 0xcd826a92, 0x34405b8b,
    0xc7a81286, 0xbc38efd2, 0x6b63e0c5, 0xc85110d1, 0xebb61866, 0xb822e4ac,
    0x737e0ac4, 0x324a0b16, 0x02a5ea8d, 0x33bf1b2d, 0xfc21f27a, 0x1572fffe,
    0xa74a78c1, 0x6528b4c9, 0x58f3f29c, 0x530dff45, 0x4287f8cf, 0x74ccf459,
    0x306592ca, 0xe6dcafd8, 0x80000000, 0x40000000, 0xa0000000, 0x90000000,
    0x08000000, 0x7c000000, 0x5a000000, 0x33000000, 0xb8800000, 0x92c00000,
    0x2fe00000, 0xafd00000, 0xdc180000, 0x447c0000, 0x3be60000, 0xf9d70000,
    0x8d1b8000, 0x2bf24000, 0x3fa4e000, 0x51f65000, 0xdca69800, 0x417bd400,
    0xa260ba00, 0x3c9d7f00, 0x42ba5a80, 0x02002f40, 0xa7014220, 0xae8ebbd0,
    0x63c69828, 0xd06bd4ac, 0xa398baf2, 0x08317fdf, 0x4fc45a6a, 0x626b2f9d,
    0xdc9cc2ed, 0x72bbfbde, 0x9a01f863, 0xd303c4d5, 0x8884c23a, 0x0ac7fbcd,
    0x5be7f800, 0x89d4c40b, 0xb51f42e4, 0xcff5bb1d, 0x11a318ad, 0x44f2947e,
    0x0d21da73, 0x58326f9d, 0xa7c5a266, 0x2e68eb47, 0x1e98009b, 0x35bc005f,
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0xf8000000, 0x1c000000,
    0x62000000, 0x77000000, 0xf3800000, 0x93c00000, 0xcb600000, 0x03500000,
    0x19980000, 0xf4740000, 0x006a0000, 0xe2d70000, 0xb55c8000, 0x789f4000,
    0x16f26000, 0x392f9000, 0xa4f6e800, 0x762c3400, 0xab7bd200, 0xd7ecaf00,
    0xef1bb280, 0x3b303fc0, 0x0743da60, 0x73204b90, 0xf7fce898, 0x1bab348c,
    0x7dbf527a, 0x6007ef3b, 0x9003d2e9, 0x1808af38, 0x4c09b23a, 0x9a033f77,
    0x6b0d5ab9, 0x918c0be8, 0xe4c00828, 0x38e8e4ee, 0x90955a25, 0xd2f80bc6,
    0xf72a0881, 0x19ffe498, 0x16a9daa4, 0xb5374b74, 0x9a406840, 0xa3a474c2,
    0x41b53205, 0xb20c7fd0, 0x4f073a72, 0x0f879b87, 0x80000000, 0x40000000,
    0xe0000000, 0x10000000, 0x48000000, 0xbc000000, 0x02000000, 0xdf000000,
    0xb8800000, 0xb1c00000, 0xc8600000, 0x77d00000, 0x8f180000, 0xcefc0000,
    0xc5620000, 0xf85b0000, 0xca538000, 0xed524000, 0x51dd6000, 0x06151000,
    0xe771d800, 0x49212400, 0x12787200, 0xc2a57700, 0xb13f1280, 0xc8076740,
    0xfc074a60, 0xe2030350, 0xcf0bd828, 0xf08624ec, 0x0dc9f2aa, 0xca6c3773,
    0xa8d1f272, 0x37903792, 0x7f33f212, 0x0d0b3749, 0x8f8072d7, 0x454977e4,
    0x23a512a8, 0x94b06772, 0xfe4eca12, 0x2d264359, 0xa47f3804, 0x43a674e6,
    0xc4b4ca29, 0x564143d9, 0x812eb854, 0xee7f345e, 0x20a22a56, 0x7e3a1391,
    0x38800036, 0xf1c0000f, 0x80000000, 0xc0000000, 0xa0000000, 0x30000000,
    0xa8000000, 0x94000000, 0xde000000, 0x11000000, 0xf1800000, 0xb8c00000,
    0x95200000, 0xad700000, 0x94380000, 0x71d40000, 0x4d8e0000, 0x32c50000,
    0xfa238000, 0x7df0c000, 0x75762000, 0xc831b000, 0xabdde800, 0x1a888400,
    0xee424600, 0xf962c900, 0x9f17e680, 0xada3b9c0, 0xb83c2e20, 0x63da8df0,
    0x1e838088, 0xa840c064, 0xd46e20d6, 0x2495b0b5, 0xda6be887, 0xcd99843d,
    0x87efc6ba, 0xa7570904, 0xe1c24670, 0xa0a2c9a4, 0xf3b7e66c, 0x1c13b91e,
    0xcf242eab, 0x3a7e8d5a, 0xe8b58094, 0x4291c0f2, 0x0763a003, 0x7e1070a2,
    0x54264822, 0xa4fcf4bb, 0x80f20ef4, 0x36ff3d3b, 0x13f068f4, 0x0c7d44a1,
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x88000000, 0x2c000000,
    0x66000000, 0x75000000, 0xe3800000, 0x2fc00000, 0xbaa00000, 0xeed00000,
    0xea980000, 0xf3f40000, 0xd1820000, 0x58cd0000, 0x06298000, 0x419d4000,
    0x61742000, 0x47c7f000, 0x26a50800, 0x60da9400, 0xc390ee00, 0xfe79fb00,
    0xa74d4e80, 0x67e34bc0, 0xb23c66e0, 0xf22e2fb0, 0x53918068, 0xc679409c,
    0x634e208e, 0x5deef029, 0x2936880d, 0x48aed476, 0xf9d74e3f, 0x261a4bb4,
    0xd4b7e633, 0x766e6ff2, 0x8af42061, 0x8407f0f5, 0x9a0508d5, 0x8b0a94b6,
    0x4288ee58, 0x0e4dfb07, 0xaa6f4e44, 0xa4fe4bfc, 0xbd0de63d, 0x6f876fa8,
    0x59c7a07a, 0x37a3b078, 0xa95aa863, 0x8f5d24e9, 0x80000000, 0x40000000,
    0xa0000000, 0x90000000, 0xb8000000, 0x9c000000, 0xc6000000, 0xb5000000,
    0xab800000, 0x79400000, 0x0c600000, 0x78b00000, 0xe2780000, 0xc35c0000,
    0x65860000, 0x38470000, 0xe5e88000, 0x7efb4000, 0x8e962000, 0x4022f000,
    0x9f538800, 0x438d7c00, 0xbd4b6a00, 0x66689900, 0x23b5ca80, 0xd8f12940,
    0x4b906220, 0x63aea5d0, 0x52108098, 0xade7404c, 0x2af020de, 0x5c95f0b9,
    0x872308d5, 0x63da3c50, 0x7e434a61, 0x10e169b4, 0x7570c2c5, 0x67dc1582,
    0xf443a8ab, 0x7be88c53, 0x67f0627a, 0xcb1ea589, 0xa86880f0, 0x62bb406f,
    0x31762039, 0x4dd2f021, 0x0f4b88b3, 0xd1617cf8, 0x57356a29, 0x513399f3,
    0x043b4a79, 0x9fbd691f, 0x80000000, 0xc0000000, 0x20000000, 0x70000000,
    0xe8000000, 0xc4000000, 0x3e000000, 0x47000000, 0xf4800000, 0x83c00000,
    0xdc600000, 0xb5d00000, 0x74980000, 0x38340000, 0x23060000, 0x7a890000,
    0x0ccb8000, 0x9ce5c000, 0xe0112000, 0x2bf3d000, 0x476cd800, 0x935d0400,
    0x6a57b200, 0x19d32700, 0x4e951280, 0x613137c0, 0xe08eeaa0, 0xe5c6e3b0,
    0x97660048, 0xcb590074, 0x665380f6, 0x93d1c0f3, 0xdf972022, 0x16bad000,
    0xa9c75816, 0xfd68c471, 0x0a5e925c, 0x89d4f70e, 0xf69fca0b, 0x3d353337,
    0xf28ad8fb, 0x58c4046e, 0x1ae43207, 0xfb12e779, 0xcd7a32fd, 0x79afe767,
    0xc2b7b2a7, 0xefc327d5, 0xc66d1203, 0x9cd537a9, 0x5f10ea1a, 0x637be323,
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x28000000, 0x14000000,
    0x92000000, 0xbd000000, 0xa0800000, 0x0e400000, 0x94e00000, 0xe6500000,
    0x5d980000, 0x33bc0000, 0x7d460000, 0x5f650000, 0x5f938000, 0x56b0c000,
    0x41c6e000, 0x672db000, 0xcc79f800, 0xb960bc00, 0x20946200, 0x733daf00,
    0x63070280, 0x5385df40, 0x85cb9a20, 0x8d2813f0, 0x5d78e008, 0x07e4b0e4,
    0x3dd4781a, 0x7c597c19, 0x049f021a, 0x8939dfa7, 0x6a0d9a26, 0xd10d1315,
    0x1e8b6049, 0xad44702b, 0x276a983c, 0x7398cc2e, 0x48b8fac5, 0x52c06393,
    0xfcac78d1, 0x4db57c9d, 0x3e410246, 0xfce0dfd0, 0x52581acc, 0x7f98d32c,
    0xa6be001d, 0xc9c900b8, 0xc32d80cc, 0x7679c00e, 0x80000000, 0x40000000,
    0xa0000000, 0xf0000000, 0x68000000, 0xb4000000, 0xfa000000, 0xcf000000,
    0xb9800000, 0x67c00000, 0x27600000, 0x3d700000, 0xf8380000, 0xeb1c0000,
    0x61c60000, 0x16610000, 0x79f38000, 0xad7ac000, 0x803e6000, 0x671e1000,
    0xb7c1c800, 0xff669400, 0x41775200, 0x4632bd00, 0xb61cb280, 0xa3476d40,
    0x32289a20, 0xf65929b0, 0x0ee66048, 0x22b21004, 0x535fc832, 0x006b948b,
    0x70fad22b, 0xc5f57d1c, 0xf37752e4, 0x8d32bdd5, 0x3d9cb246, 0x4f876d01,
    0x3ec89af6, 0xd7e929c4, 0x923e6052, 0x5c1e109b, 0x5441c813, 0xa7a69430,
    0xb7975242, 0xa882bd14, 0x9344b26a, 0xba2b6de0, 0x12569a67, 0x6ce4290d,
    0x31b3e04a, 0xa4d9d07a, 0x80000000, 0xc0000000, 0x60000000, 0x50000000,
    0xc8000000, 0xec000000, 0x42000000, 0x1f000000, 0x77800000, 0xe5c00000,
    0xe8600000, 0xa9500000, 0x70180000, 0x9c340000, 0x71c20000, 0x1e6f0000,
    0xb05f8000, 0xe69f4000, 0x9b726000, 0xf8e91000, 0x8f1da800, 0x7bbf5400,
    0x3c04e200, 0x4a062f00, 0x930b0280, 0x658f7fc0, 0x32c34ae0, 0x73e27b90,
    0x0e926028, 0x8779107c, 0x42e5a8ea, 0xe41b54a3, 0x6a3ee2fd, 0x68cd2f16,
    0x88ee825d, 0xb71b3f93, 0x6fb4aa0f, 0x0a0f2b40, 0x330028c1, 0x558f1457,
    0xaac9025b, 0x57e07fc7, 0xa09cca27, 0xda7d3bd6, 0x2a600099, 0x765000a6,
    0x6798006f, 0x29f400a5, 0x51a20043, 0x5b3f008c, 0x82478019, 0x65ab40c2,
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0xd8000000, 0xf4000000,
    0x2e000000, 0x73000000, 0x1e800000, 0x67400000, 0x9f600000, 0xde700000,
    0x7ab80000, 0x2f140000, 0xb7ce0000, 0x3b2b0000, 0xf79a8000, 0x3f87c000,
    0xc8cc2000, 0xefa09000, 0xb5d93800, 0xe9652c00, 0x997d2a00, 0xea328500,
    0xeb5d8a80, 0xee2ad5c0, 0x761c1220, 0x3c43a910, 0xbdeea0f8, 0x1b3350e4,
    0x9cdb1856, 0x6aeebc57, 0x33be92e8, 0xdc9069e0, 0x150c802f, 0x2188c00a,
    0xd3c0a05b, 0xad285046, 0x0099988a, 0x070d7c3e, 0xf084b214, 0xb44ff958,
    0x51e13816, 0x61312c4c, 0x11d32ab5, 0xdf698537, 0xbe7f0ac6, 0x0ab915f7,
    0x271e327e, 0x9bc839b5, 0xe12d1815, 0xaa91bc84, 0x80000000, 0xc0000000,
    0xe0000000, 0xf0000000, 0x28000000, 0xec000000, 0xca000000, 0x51000000,
    0x17800000, 0xf1c00000, 0x65200000, 0xc7500000, 0xd2180000, 0xcc740000,
    0x524a0000, 0x5aed0000, 0x35738000, 0x69cb4000, 0x812ce000, 0xf1597000,
    0x911fc800, 0x4efdf400, 0x920cf600, 0x55049b00, 0xd1819680, 0x9acfabc0,
    0x0bab3e60, 0xcd1d6f30, 0x8cff6048, 0x3f0230dc, 0x508b2802, 0xb540844d,
    0xce613ef5, 0xa6306f4c, 0x3cace038, 0x619970a7, 0x2bbfc840, 0x646df40a,
    0xc734f6cd, 0xe3209bbd, 0x8c5396ff, 0xac96ab6e, 0x1e32be91, 0xc8ab2f03,
    0x8f980008, 0xacb400cd, 0xc0ea0052, 0x9c7d006b, 0xaa4b8075, 0x8eef4097,
    0xcb7ee0c5, 0x36c0700c, 0x80000000, 0x40000000, 0xa0000000, 0xb0000000,
    0xf8000000, 0x3c000000, 0x4e000000, 0x19000000, 0x56800000, 0x7e400000,
    0x65200000, 0xa7500000, 0xe2780000, 0xb52c0000, 0x0f5e0000, 0x36790000,
    0x8f288000, 0x9c524000, 0x0bfe2000, 0xf0edf000, 0xc8b6b800, 0xe14cac00,
    0xaea44600, 0x5d9e9f00, 0x1e12fe80, 0xc0d23340, 0x5eb6b820, 0x344cacf0,
    0xee244658, 0xb6de9f8c, 0x9bb2fe36, 0x3cc23365, 0xc16eb838, 0x4170ac97,
    0x30a2466b, 0xec9b9f55, 0x9c9c7eb1, 0x84957377, 0xa89e18d5, 0xae9a1c14,
    0x739c5eeb, 0x571183ff, 0x7e582035, 0x54f8f01b, 0xdb603896, 0x2277ec45,
    0x552ae62d, 0x1f5d2ff3, 0x7e7c667d, 0x4b266fba, 0xee52c618, 0x5cf5dfe8,
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x98000000, 0x34000000,
    0xbe000000, 0x59000000, 0xff800000, 0x1fc00000, 0xae600000, 0xb7700000,
    0x01180000, 0xc26c0000, 0xdd7e0000, 0xd61b0000, 0x6cec8000, 0x9134c000,
    0xedb3a000, 0x92f2f000, 0x81d6a800, 0xce89a400, 0x3c4bea00, 0x93a23900,
    0xc21d4280, 0x02eb9d40, 0xf036a820, 0xb639a4d0, 0xab33ea38, 0x42be39a4,
    0x387b42a6, 0x7b9c9d2d, 0x00242861, 0xb7d66496, 0x7b8cca69, 0xe9c8090c,
    0xfb664a09, 0x52fbc958, 0x61df6abd, 0xfe8af982, 0x3448e258, 0x3fae6d0b,
    0x48128028, 0xe5efc0cb, 0x56bf20c9, 0x567630aa, 0x1a9d087b, 0x5ba754df,
    0x8e1b4291, 0xb8ec9da1, 0x1f3c2853, 0xbcba6414, 0x80000000, 0x40000000,
    0xa0000000, 0x50000000, 0xf8000000, 0xb4000000, 0x12000000, 0x39000000,
    0x2d800000, 0x4bc00000, 0xa1e00000, 0xc8f00000, 0xf1180000, 0x3dec0000,
    0xd6fe0000, 0xce170000, 0x6b668000, 0x71bac000, 0xbdbd6000, 0x5bb43000,
    0xd0b38800, 0x943f0400, 0x0a709200, 0x54501900, 0x2f431a80, 0x2faf1d40,
    0xced38820, 0x6e0f0410, 0xd7089258, 0xba8c19e4, 0x51451a6a, 0xa0a41dcd,
    0x9053081f, 0xd54ec462, 0xfaad72d4, 0x1555e967, 0xf6cd723a, 0xd665e938,
    0x06357238, 0x7379e991, 0xd9d372e9, 0x3482e998, 0x764bf24c, 0xb22f2942,
    0x8d1012ad, 0xd3e1d9ea, 0x41fefa21, 0xd49aed61, 0x6a25e044, 0x2919f072,
    0x99e8686d, 0x9cf1f423, 0x80000000, 0xc0000000, 0x60000000, 0x30000000,
    0x98000000, 0x3c000000, 0xe2000000, 0xbb000000, 0x6c800000, 0x7a400000,
    0xa0a00000, 0x70b00000, 0xcc180000, 0xcea40000, 0x71ba0000, 0x479d0000,
    0x0a6e8000, 0x88504000, 0xc700e000, 0x2e831000, 0x91413800, 0x642f8c00,
    0xaef1be00, 0xb2bbb900, 0xe7108680, 0x6a2435c0, 0x9ff938e0, 0xa13b8cf0,
    0x1fd3bef8, 0x71c2b90c, 0xa46406fa, 0xe9597547, 0x7c8f586e, 0x724cdc31,
    0x54a86634, 0x06b32506, 0x311a0096, 0xc72d00f9, 0x3e768053, 0x4af44078,
    0xccbae02f, 0xee1e10f9, 0x15afb843, 0x2d3fcca3, 0xa5d15e87, 0x96c8a9b9,
    0x1ae9be64, 0xb01fb9a9, 0x8caa86a8, 0x9ab93540, 0x8317b827, 0xd42bcc0a,
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0x74000000,
    0x72000000, 0x8b000000, 0x7f800000, 0x31400000, 0x43200000, 0x88700000,
    0x49580000, 0x722c0000, 0x38f20000, 0x6d9f0000, 0x874b8000, 0xe223c000,
    0x10f76000, 0x79901000, 0xe5428800, 0x01268c00, 0x1b7fb600, 0x3adc7d00,
    0x2d653e80, 0xf6d6f140, 0x636888e0, 0x0bd58c50, 0x9de63608, 0xd210bd64,
    0x9601de9a, 0xd10921bf, 0xe08f60ed, 0x2ccc10ea, 0x91688834, 0xc0d58cdd,
    0x82663610, 0xf350bd05, 0xbd21defc, 0x2d7921e5, 0xdbd76063, 0xd5e01066,
    0xd61a8895, 0x9c0a8c05, 0x460db69e, 0x99037d98, 0xe48ebecc, 0x26c5314e,
    0x0667e87d, 0xb9599cbe, 0x4a2ebeb9, 0x44f5311b, 0x80000000, 0xc0000000,
    0x20000000, 0xf0000000, 0x58000000, 0x1c000000, 0x6a000000, 0xff000000,
    0xe9800000, 0x02400000, 0x5ea00000, 0xc5f00000, 0x04580000, 0x38240000,
    0xb63e0000, 0x64b50000, 0x397e8000, 0xd0924000, 0xad4e6000, 0xdf2dd000,
    0xa3b82800, 0xdcfb5c00, 0x30dcde00, 0xb8e9bd00, 0xdd5af680, 0x2ca7e1c0,
    0xc6f8a8a0, 0x57dc1c30, 0x6d6c3e78, 0x45162dec, 0xd50cbeb2, 0xf6816d23,
    0x3bc45e23, 0xf4eafdcd, 0xdf54164f, 0xb7ad71eb, 0xa97060c8, 0x9898d02e,
    0x3946a849, 0x01291c4d, 0x72b2be0a, 0xbc746d90, 0x4e1adecd, 0xf288bdcf,
    0xadc276ab, 0xb1e4a1a8, 0x61d648be, 0x18668c01, 0x839cf6d9, 0x96c6e1d4,
    0xee6028c1, 0xd69f5ced, 0x80000000, 0xc0000000, 0x60000000, 0xf0000000,
    0xa8000000, 0x34000000, 0x12000000, 0xbd000000, 0xb3800000, 0x50c00000,
    0x06200000, 0x14d00000, 0xd7f80000, 0xbca40000, 0x259a0000, 0x5c110000,
    0xedd18000, 0x1e7bc000, 0x056f6000, 0x72357000, 0x0d082800, 0xbb85d400,
    0xf4c05e00, 0x4c2ca700, 0x35d27680, 0x427873c0, 0x4363a8e0, 0x2d3f1430,
    0xab86bec8, 0x6cc617c4, 0xb02f3e3a, 0xe3d9d749, 0x457a5e41, 0x79eda7dd,
    0xdc7bf6fd, 0x4067b340, 0xcdb6c88b, 0x23cb6411, 0x8ea7169b, 0xc89c03c9,
    0xd79a0047, 0xd111004f, 0x965180f8, 0x8abbc0d9, 0xb94f60e7, 0xefe57059,
    0x7b7028f2, 0xeae1d4a0, 0x64fa5e68, 0x542da7d2, 0x09dbf630, 0xf477b330,
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x38000000, 0x94000000,
    0x2a000000, 0x77000000, 0xc8800000, 0x27400000, 0xcf600000, 0x42d00000,
    0x0eb80000, 0xdee40000, 0x58120000, 0xa51d0000, 0x8a9c8000, 0x0d50c000,
    0xf97ae000, 0xf2c75000, 0x77a83800, 0x32739c00, 0x2c429200, 0xf1e74300,
    0x7498aa80, 0x7059dfc0, 0x16feb860, 0x950a5c70, 0x338ef2d8, 0x01c9d324,
    0x3d24f292, 0x9e30d323, 0x1daa7282, 0x657d1320, 0xb4cc125f, 0x5eaa8381,
    0x17fecab3, 0x8c8e4f0f, 0x454c60ec, 0xf46e90cf, 0x845c5827, 0x4cf90c9e,
    0x3a0cca68, 0xdf034fa7, 0x3488e075, 0x114a5069, 0x3e6cb860, 0x43575c60,
    0xbc72728a, 0x894913d3, 0x3a66129a, 0x015383e4, 0x80000000, 0x40000000,
    0xa0000000, 0x70000000, 0x88000000, 0x84000000, 0xe6000000, 0xe5000000,
    0x4a800000, 0x25c00000, 0xfd600000, 0x11700000, 0xb5180000, 0xe4ec0000,
    0x233e0000, 0x8b350000, 0x3f338000, 0xf136c000, 0xe0372000, 0xc4b9b000,
    0x807b3800, 0xd1995400, 0x002c7a00, 0x02d39900, 0xd2894280, 0xb9cfcd40,
    0xc76eb820, 0x6e769430, 0xf096da28, 0x0ca9e9f4, 0xb216daee, 0xed69e921,
    0x0976da8c, 0x6919e9f0, 0x7eeeda1f, 0x2c35e980, 0x46b0da06, 0x5370e9a4,
    0x861b5a92, 0x636a291b, 0xb8727ae5, 0x3d96991f, 0xb222c293, 0xf9d50db4,
    0x7107980f, 0xb48a241f, 0x1cc66250, 0x2dea7d68, 0x3bb380c2, 0x85f6c0f4,
    0x99d7202d, 0xe109b0fd, 0x80000000, 0x40000000, 0xa0000000, 0xf0000000,
    0x28000000, 0xc4000000, 0x9a000000, 0x9b000000, 0xbf800000, 0x60400000,
    0xf8200000, 0x3b100000, 0xe2380000, 0x4dac0000, 0xf85e0000, 0x199d0000,
    0x90f18000, 0x0f48c000, 0x15a4e000, 0x54579000, 0xe79b8800, 0x61f69c00,
    0x03c3d600, 0x0e66db00, 0x563e5e80, 0xbfa14740, 0x07520820, 0xcc125cb0,
    0x43b93688, 0x8cec4b34, 0xd4f45632, 0xd54f1b1f, 0x2ead3e05, 0x1bdf174b,
    0xafdae04f, 0x5dda902f, 0xa2d20808, 0x77525cd9, 0xa4193617, 0x27bc4b6b,
    0xe6ec5635, 0x67f31b96, 0xaecb3e00, 0xd4ee17fd, 0x78f56018, 0x2b4f502e,
    0xdfa7687c, 0x175d0c9b, 0xb41e5e25, 0x5fb147cc, 0xfaea086e, 0x11fe5cc9,
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x38000000, 0xdc000000,
    0xaa000000, 0x29000000, 0xb2800000, 0x83c00000, 0xd6600000, 0x65300000,
    0x80580000, 0x86e40000, 0x0bf20000, 0x42b50000, 0xeb148000, 0x22444000,
    0xe6266000, 0xb616b000, 0xceccf800, 0xd2ebf400, 0x85feaa00, 0xfdb32d00,
    0xea985280, 0x0209d9c0, 0xdd007860, 0x2c8bb4f0, 0xd4cacad8, 0x03e09dec,
    0x0b782a12, 0xe4726d35, 0x2df2b278, 0x09bf295a, 0x7498e03c, 0x5503f0ca,
    0x088c1824, 0x42cc0426, 0xb0e0b2ab, 0xa8fa29b2, 0x093460ae, 0xd253b06f,
    0x93e07809, 0x237bb4c4, 0xd072ca4d, 0x53f49d19, 0x6eb22a01, 0x99136d20,
    0xe74c32bb, 0xc6aa695a, 0xc0d8007a, 0x00240021, 0x80000000, 0x40000000,
    0x60000000, 0x10000000, 0xa8000000, 0xb4000000, 0xe6000000, 0x15000000,
    0x63800000, 0xf1c00000, 0xc5a00000, 0xedf00000, 0x6b580000, 0x682c0000,
    0xfd320000, 0x4b7f0000, 0x71178000, 0x984bc000, 0x8b662000, 0xc4d2b000,
    0x43efa800, 0x0f928400, 0x8e093600, 0x810e8d00, 0xf58c9e80, 0x5ccf0940,
    0xba2028e0, 0x4e354450, 0x5dfd16c8, 0xf3533da4, 0x042cb6ce, 0x173a4de1,
    0xa47d3e65, 0x559679b4, 0xf909a0ee, 0xc98570f8, 0x7ec38880, 0xf1233434,
    0x24bb1ebb, 0x9db4c973, 0x343e084c, 0x5afbf49a, 0x03d8be57, 0x9362b938,
    0xe8d800b3, 0xc9ec00f1, 0xf09200ac, 0x028f0030, 0x544f80b7, 0x5167c08f,
    0xf3d420d5, 0x6b6db0b9, 0x80000000, 0x40000000, 0x60000000, 0x70000000,
    0xa8000000, 0x9c000000, 0xea000000, 0xbf000000, 0x54800000, 0x12400000,
    0x33a00000, 0xd5900000, 0x47380000, 0x2f2c0000, 0x6bd20000, 0x56990000,
    0xa9b18000, 0x3a694000, 0x48f26000, 0x4f46d000, 0x142ef800, 0xc15f8c00,
    0x9dd18e00, 0x4398fb00, 0x22357680, 0x0ca27740, 0xc11f78e0, 0x3576cc30,
    0x6c83eec8, 0x164e2bec, 0x8da38ec2, 0x6c91fb63, 0xeebcf65e, 0x4ae7379d,
    0xf4bf182f, 0x1de91c6b, 0x5c3c9656, 0x95a8e7a9, 0x789860ba, 0x88b3d008,
    0xc7ed782f, 0x2b3fcc64, 0x2d2a6e69, 0x28db6b01, 0x981bee29, 0xacf22bdd,
    0xc1498eb8, 0x6524fbe3, 0x84df764e, 0xba177715, 0xfffcf8f3, 0xd7c68cb1,
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x08000000, 0x7c000000,
    0x72000000, 0xc3000000, 0x73800000, 0x50400000, 0x2de00000, 0x40300000,
    0xfe580000, 0x5e2c0000, 0x75960000, 0xcf870000, 0x42498000, 0x1ee54000,
    0xebbde000, 0xda139000, 0x7dc0c800, 0x84a31c00, 0x8154ea00, 0x3fa46500,
    0x16dda280, 0x49e23940, 0x2634a8a0, 0xc355cc90, 0x44a9c228, 0xe154e9ac,
    0xcfa980fa, 0xced540ff, 0x3de5e021, 0x283f9043, 0x7256c856, 0xf4241c6c,
    0xc29d6aa1, 0xb20125dd, 0xa3004278, 0x8381a981, 0x884c60ba, 0x59ead001,
    0x4e33287f, 0x4f5b8c36, 0xeeaba299, 0x5655392e, 0xb225283f, 0x2f9c8c76,
    0xa0822202, 0x4bc0796c, 0xf1a0c816, 0xc7d31c2c, 0x80000000, 0xc0000000,
    0xe0000000, 0x30000000, 0x58000000, 0x74000000, 0x5e000000, 0xa1000000,
    0x23800000, 0x68c00000, 0xd7200000, 0x1b500000, 0xdbf80000, 0xd6640000,
    0xabb20000, 0x2d050000, 0x198a8000, 0x1fccc000, 0x49a1a000, 0x221a7000,
    0xef176800, 0xc6955400, 0x815bee00, 0xbcf7ff00, 0xc0e60680, 0x8efe6bc0,
    0x6be44860, 0x8277e4f0, 0xe9a726b8, 0x3219db44, 0x67120086, 0xda950015,
    0xf352809d, 0x37f8c0f9, 0x1c6ba0ac, 0x64bb7007, 0xf78fe852, 0x26cc946c,
    0xfe28ce53, 0x24d54f93, 0xc13acee5, 0x8a404fe9, 0x6c684eeb, 0x1cb88f1b,
    0x5383ee35, 0x10c3ff4d, 0x732c0611, 0x2d5f6b40, 0x56fcc84d, 0xdfee245d,
    0x3c740656, 0x78ab6b5c, 0x80000000, 0x40000000, 0xe0000000, 0x30000000,
    0x58000000, 0x24000000, 0x56000000, 0x41000000, 0x4e800000, 0x00400000,
    0xe7600000, 0x33700000, 0x0c980000, 0xdeac0000, 0xabda0000, 0x2e450000,
    0x12628000, 0xa3f9c000, 0x01dc2000, 0x5d48f000, 0xabe8b800, 0x9c3c8c00,
    0xf074e200, 0xad126900, 0x2566da80, 0x3c7b2540, 0xc7141860, 0xf664bc70,
    0x55f8fab8, 0x90dad514, 0x7bc4208e, 0xd7a4f025, 0x0952b8f8, 0xd4098c71,
    0xae0e62f1, 0xb507a917, 0x7080fa3d, 0x3d46d5ec, 0xdbe62089, 0x243df080,
    0xe47238e6, 0xa3194caa, 0x406ac211, 0x24f39945, 0x8656e299, 0x5f8b69ee,
    0x66c65a80, 0x7b2be5d1, 0x9610b807, 0x70e08c75, 0xf9b6e200, 0x6dbb69f3,
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xa8000000, 0x3c000000,
    0x3e000000, 0x65000000, 0x92800000, 0x4ac00000, 0x0fe00000, 0x52900000,
    0xd9f80000, 0xd8ac0000, 0x82360000, 0x77cf0000, 0x196b8000, 0x925b4000,
    0xe11d2000, 0xebb33000, 0xda82b800, 0x46cd6400, 0xe9ef8200, 0xf390bf00,
    0xe17eba80, 0xf56a9b40, 0x445a18a0, 0x98161410, 0x17359a88, 0x5d46ab6c,
    0xe7ab2016, 0xcfbc3019, 0x4089388c, 0xf9c6247f, 0xe46aa235, 0xe4df8f24,
    0x51d20268, 0x2b54ffaf, 0x7d901a69, 0x1c7eebf5, 0x83eb809c, 0xf49b409b,
    0x58fd2097, 0xb02330a8, 0x07fab8bd, 0x8da164c9, 0xc8b98289, 0xf90fbf5a,
    0xbc8d3a2d, 0xa7cddb6d, 0xf169388b, 0x8e5624c6, 0x80000000, 0x40000000,
    0xe0000000, 0x10000000, 0xd8000000, 0x04000000, 0x16000000, 0xe5000000,
    0x78800000, 0xb0400000, 0x05600000, 0x5c300000, 0x3fd80000, 0x4aac0000,
    0xea9a0000, 0x77470000, 0xe6e88000, 0x5df3c000, 0x28782000, 0x8cbeb000,
    0x039b9800, 0x65ceec00, 0x51a38200, 0x1b10dd00, 0x85889a80, 0x6cc1f140,
    0x53293860, 0x74589c50, 0xc76aba38, 0xd7384114, 0x565a204e, 0x5c65b0a1,
    0x66b1188e, 0x44962c45, 0xc64922a5, 0xb06aade8, 0x1cbba2ac, 0x9b9e6db3,
    0x81cb02cd, 0x57a31ddd, 0x2610bab1, 0xf90f4122, 0xca8aa05f, 0xb34a702a,
    0x50eb3897, 0x48f39cdf, 0x98f83a07, 0xe0fc812e, 0x14f28028, 0xcaf4c0f8,
    0xf3f0a09d, 0x997d70bc, 0x80000000, 0xc0000000, 0xe0000000, 0x10000000,
    0x28000000, 0x3c000000, 0x92000000, 0xb7000000, 0x60800000, 0x0dc00000,
    0xa8200000, 0x03100000, 0x2db80000, 0xea640000, 0xe2720000, 0xfd470000,
    0x4def8000, 0x773f4000, 0xaca3e000, 0x58dcd000, 0x5498b800, 0x80faf400,
    0xaf89ae00, 0x594c7b00, 0xfbe69680, 0xb63dcfc0, 0xed26d860, 0x049e64d0,
    0x88fd76c8, 0x63851f2c, 0xf34c603a, 0x58e3904b, 0x78bb5812, 0xc5e624aa,
    0x7b3116e0, 0xe6a68f32, 0xebd73897, 0xb215b49e, 0x94324e4f, 0x4224ab0a,
    0x80142eaf, 0x13343b75, 0xfaaaf63e, 0x89de5fa2, 0x3d1d8032, 0xe0b840c4,
    0xe1ec6044, 0x0d339036, 0xc7a3580f, 0xba5224db, 0xc65b16fa, 0x74558f76,
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x98000000, 0x0c000000,
    0x6e000000, 0x15000000, 0x54800000, 0xa5c00000, 0xd1600000, 0x08900000,
    0x78780000, 0x71a40000, 0x857a0000, 0x112d0000, 0x12b68000, 0x13474000,
    0xcfa92000, 0xf8783000, 0xb1afd800, 0xe57c7400, 0x2128da00, 0x8ab13700,
    0x1f4b8280, 0xa1a703c0, 0xed7cf8e0, 0xe52944f0, 0x40b182f8, 0xf04a033c,
    0x822a7876, 0x673e04d9, 0xd000a25a, 0x68063380, 0xf407a09d, 0x520b7061,
    0xe304f8a7, 0x4d8d445c, 0x9f4b8231, 0x61a703c9, 0x8d7cf8a8, 0xd52944df,
    0xd8b18291, 0xfc4a030f, 0xec2a7832, 0x723e04c8, 0x8480a2f4, 0xcdc63328,
    0x2567a038, 0x5a9b70ab, 0x9b7cf88e, 0x3c29449f, 0x80000000, 0x40000000,
    0x20000000, 0xd0000000, 0x38000000, 0x54000000, 0x8a000000, 0x43000000,
    0xba800000, 0xf1400000, 0x9f200000, 0x8e700000, 0xb8d80000, 0x056c0000,
    0xa7d60000, 0xe9e70000, 0x039a8000, 0xb94cc000, 0x6324e000, 0x487d1000,
    0xf5dfd800, 0x4ee39c00, 0xfb119600, 0xb7051d00, 0xa082ce80, 0xaa4d4140,
    0xa1ad38a0, 0xcd398c90, 0x30f4ce18, 0xbb9a4184, 0xad4fb832, 0xc9294c57,
    0xdb7e2e10, 0x775c5162, 0xeba4e09d, 0xee3d106b, 0x7a7fd88d, 0xa2d39c18,
    0x5e69969d, 0x99591d49, 0xaaacce31, 0x8bb641dd, 0x07b9b8c2, 0x69be4c95,
    0x68bcaeb6, 0x2d3c91e5, 0x80f60087, 0x73970012, 0x1142808f, 0x2f20c0de,
    0x4672e0ea, 0x04da10bb, 0x80000000, 0x40000000, 0xe0000000, 0x70000000,
    0xa8000000, 0x5c000000, 0x22000000, 0x2b000000, 0xaa800000, 0xd3400000,
    0x3a200000, 0xd1b00000, 0xf0d80000, 0x774c0000, 0x3c2a0000, 0xbcb90000,
    0xd7558000, 0xf3834000, 0x2acde000, 0x27e99000, 0x9ed59800, 0xe640dc00,
    0xa9ad7600, 0xcb702900, 0x9f350e80, 0xc5996540, 0x506de060, 0x62199030,
    0x94ad9848, 0x94fcdc2c, 0x7fff768a, 0x75752977, 0x36328e08, 0xd41f25b8,
    0xf1a780f0, 0x7f764032, 0x01326082, 0xbc93d08a, 0x79edf846, 0x47da0cbc,
    0x5fcd0e63, 0x546565b7, 0xf41fe0ed, 0x21ac9096, 0x4772189e, 0x85369c17,
    0x6a9f1653, 0x2ce3f9ba, 0xe458f67f, 0x0d03692a, 0x1780eef8, 0xccccf590,
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xc8000000, 0x14000000,
    0xa2000000, 0x65000000, 0x74800000, 0x22c00000, 0x2ce00000, 0x80900000,
    0x96b80000, 0x26c40000, 0x26e60000, 0x019f0000, 0xd8318000, 0xbd09c000,
    0xc88d6000, 0x64c37000, 0x73e89800, 0x4d18a400, 0x76f38200, 0xefe2b700,
    0x9b167a80, 0x41f963c0, 0x666d6020, 0x11537090, 0xf9d09868, 0x0d1ca444,
    0x16f5826a, 0x1fedb771, 0x031ffa56, 0x9df4a387, 0xd0660078, 0xd65f0032,
    0xe85180d2, 0x5b59c0e2, 0x18d560da, 0xb3977056, 0x15369828, 0x2d83a4fb,
    0xd0440248, 0xf124777b, 0x31f29a81, 0x3e67d34f, 0x6d569895, 0x1fd3a415,
    0x021c027b, 0x13707756, 0xebac9a07, 0x683cd338, 0x80000000, 0x40000000,
    0x60000000, 0xb0000000, 0x78000000, 0x9c000000, 0x6e000000, 0x03000000,
    0xeb800000, 0xbf400000, 0x8ee00000, 0xf6500000, 0x4bf80000, 0xb54c0000,
    0x3fe20000, 0x10dd0000, 0xac348000, 0x17624000, 0x641d2000, 0x4d93d000,
    0xa7de0800, 0x3db10c00, 0x412d3a00, 0x407fdb00, 0xfa0e1280, 0xa90d0740,
    0xca8520e0, 0xf1cfd0f0, 0x3d240818, 0xde700c2c, 0xe103ba16, 0x6e8c9b9f,
    0x63c5b205, 0xe02197fc, 0x4ef28885, 0x29cf4cb9, 0x312a1add, 0x187d0b6f,
    0xb6069ae2, 0x0f034b7a, 0x2d81baf6, 0xe8419b4b, 0xef693235, 0xb81fd77f,
    0x4395a8f0, 0x14dd9c5c, 0xae3a920f, 0x626f4748, 0xa09800db, 0x0f5c0078,
    0x097a00d8, 0xc081004d, 0x80000000, 0x40000000, 0xe0000000, 0xf0000000,
    0x48000000, 0xe4000000, 0xa2000000, 0x4f000000, 0x6b800000, 0x6c400000,
    0x29a00000, 0xf0f00000, 0x77180000, 0x514c0000, 0x152a0000, 0x4b310000,
    0xccf38000, 0xc916c000, 0xf0466000, 0x87abd000, 0xe9f7c800, 0x499dbc00,
    0xb588be00, 0x7d470500, 0x13211680, 0x463d6940, 0x18746060, 0x86d6d0b0,
    0x51ae48a8, 0xfcfa7c14, 0x211d5eea, 0x044a15ab, 0x9da8be49, 0x0af70563,
    0x64191622, 0x34c1692c, 0x70666076, 0xe41bd0f5, 0x74cfc868, 0x9061bc41,
    0x141abe58, 0x3cca0545, 0x7460965c, 0xb616a9dd, 0x73cb804c, 0x1feac0b3,
    0xda5460bf, 0x5a66d0ca, 0xef1648e2, 0xad467c43, 0x0b2f5eeb, 0xfa3715e6,
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x98000000, 0xb4000000,
    0xa6000000, 0x1f000000, 0x68800000, 0x5ac00000, 0x57a00000, 0x51700000,
    0xe2180000, 0x0fcc0000, 0xd22e0000, 0x2a3f0000, 0x50f48000, 0x175ec000,
    0x7e272000, 0x78309000, 0x49f9f800, 0x30d8e400, 0xd46e7600, 0xc15bbd00,
    0xe928ae80, 0x9cbfc940, 0x51312020, 0x46739010, 0x469b7838, 0xb70524e4,
    0xf48bd63e, 0x20c6edab, 0x92acf64e, 0xacf67d05, 0xdd550e1f, 0xd32e991b,
    0xf9bb780d, 0xfcb524fa, 0xe133d6ae, 0x2e7aedde, 0x3a9af654, 0x3d057d8c,
    0xf98f8e97, 0xf14f596b, 0xbfe8d852, 0xc91b74e8, 0x814d0e64, 0x37e2997e,
    0x4515788b, 0xc34a24de, 0x16e7567d, 0x86942ddb, 0x80000000, 0xc0000000,
    0xe0000000, 0x50000000, 0x08000000, 0x34000000, 0x6e000000, 0xa3000000,
    0xd9800000, 0xc9c00000, 0x23e00000, 0x7ef00000, 0x6ed80000, 0x8ec40000,
    0x5c620000, 0xc03b0000, 0xaabd8000, 0x92f7c000, 0xfcdfa000, 0x97c3d000,
    0x18e02800, 0x7b79c400, 0xad168200, 0x682ec100, 0x6c110a80, 0xd0a0d5c0,
    0x6d5da060, 0x4a08d090, 0xe505a8e8, 0xfe8a0464, 0x264b2266, 0x75261197,
    0xde94a237, 0x14ead1aa, 0xb976829a, 0xbc1ec127, 0x18a90a25, 0xb954d554,
    0x7407a034, 0x4e07d049, 0x130228a9, 0x8182c45c, 0xf5cb02ca, 0x79e90125,
    0xb3f6aa9e, 0x145705b6, 0x9e87881d, 0xb64e147a, 0x9d2caa92, 0xba98057e,
    0x72e00883, 0x2e76d486, 0x80000000, 0xc0000000, 0x60000000, 0x70000000,
    0x18000000, 0x0c000000, 0x22000000, 0xc5000000, 0x13800000, 0x2a400000,
    0x3d200000, 0x6e900000, 0x0ff80000, 0x17440000, 0x92aa0000, 0x1ed10000,
    0x8bde8000, 0x50554000, 0x7e10e000, 0x053b7000, 0x98a9e800, 0x6fdfdc00,
    0xa65b1600, 0xf5190b00, 0x81ba1e80, 0x7c69a7c0, 0x673ae0e0, 0xfdaa70b0,
    0x6c576878, 0xe41a9c7c, 0xdc33f63a, 0xc1267bc9, 0x9499f6b1, 0xa6f77b2f,
    0x56c776ce, 0x65e23bf4, 0x3c7796ca, 0xed094bc5, 0xa7867e47, 0x14429770,
    0xb22f68d0, 0xac1e9c1d, 0x1839f681, 0xe7277ba8, 0x179f767d, 0x46763b30,
    0x8405964f, 0x860c4ba2, 0x930afee7, 0x8882d728, 0xc6cb0869, 0xcde1acca,
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xe8000000, 0xac000000,
    0xae000000, 0xa1000000, 0x90800000, 0x54c00000, 0x9a200000, 0x93100000,
    0x0cf80000, 0x0d4c0000, 0xb2620000, 0x93f30000, 0xf4c38000, 0xea204000,
    0x4b162000, 0x18fdf000, 0xe7419800, 0x11648400, 0x0c750e00, 0x91890300,
    0xb440b680, 0x16e37740, 0x1d37a0e0, 0x75eeb010, 0xa2b43888, 0x20a934fc,
    0x44dab646, 0x395c770d, 0x431620be, 0xa4fdf0b5, 0xc141986a, 0x4c648497,
    0xdaf50e7e, 0xc8490332, 0x10e0b690, 0x7033777f, 0x1b6fa036, 0xbf72b03d,
    0x860e38ad, 0x2d06349d, 0x0e8336e6, 0x4dc33709, 0x4ea180e7, 0xc5d340a6,
    0x99d5a026, 0xafddb0fa, 0x7ad7b89c, 0x50597449, 0x80000000, 0xc0000000,
    0x60000000, 0x90000000, 0xa8000000, 0x24000000, 0x9a000000, 0x01000000,
    0xe2800000, 0x29c00000, 0xcd600000, 0x8b300000, 0x90980000, 0x0f440000,
    0x2eaa0000, 0x8f5f0000, 0x4d2b8000, 0x8414c000, 0xc985e000, 0x524cb000,
    0x7a22b800, 0xe997f400, 0xc1c56a00, 0x496a3500, 0xe1303280, 0xa99a71c0,
    0x61ce60e0, 0xb9687050, 0xd93f58c8, 0x259f44b4, 0xdfcdd232, 0x2262c125,
    0x3abed8f8, 0xeed484e8, 0x3b63b24f, 0x643ab132, 0x21198075, 0x710fc060,
    0x1a846044, 0xc5c77011, 0xe36cd829, 0xb83f8406, 0x571a32d3, 0x5e05715c,
    0xcb05e041, 0x2b8cb05d, 0x7f42b838, 0xd6a7f434, 0x635d6a55, 0x632e354f,
    0xb71a327d, 0x0e05710c, 0x80000000, 0x40000000, 0xe0000000, 0x10000000,
    0x78000000, 0x1c000000, 0x86000000, 0x21000000, 0x60800000, 0x3c400000,
    0x80e00000, 0x92300000, 0xb6180000, 0xc48c0000, 0x064a0000, 0xd7ef0000,
    0xbbb68000, 0x8ede4000, 0xe225a000, 0xb3907000, 0xb2431800, 0x95e74c00,
    0xf0b38a00, 0x21518d00, 0xfbe3b280, 0xf5b8f140, 0x3bd68060, 0x70ae4050,
    0x4cdda098, 0xe92c700c, 0xfc1118fe, 0xbb844c3d, 0xabcf0ae6, 0x6520cd1d,
    0x42109260, 0x6686c1ee, 0x5d483856, 0x00657c06, 0xbe7f3228, 0x4ef9b11f,
    0x4abda0c3, 0x365c7024, 0x3269185f, 0xdd784c30, 0x657d0ac8, 0xd973cd94,
    0xaf741272, 0xe67b8183, 0xe2f118bb, 0x44b44cab, 0x63570a65, 0xb0eccd42,
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x08000000, 0xfc000000,
    0x5a000000, 0x41000000, 0x84800000, 0xa5400000, 0x6a200000, 0x7bb00000,
    0xc8580000, 0x68840000, 0x874e0000, 0xff290000, 0xe93b8000, 0x7e174000,
    0x3b2e6000, 0x873fb000, 0xb91d5800, 0x14ad9c00, 0xeffdb600, 0x0efa7900,
    0xfa750e80, 0x773f15c0, 0x511b80a0, 0x78a74070, 0x0df66028, 0xbbfbb04c,
    0xd8f35852, 0xc9749cbd, 0xfebe36de, 0x22d939e4, 0x0acd6e6e, 0xc2eda51e,
    0xec535802, 0x96849c63, 0xf8463667, 0x24ad39db, 0x27fb6ebc, 0xd2f0a5fc,
    0x107ed8ac, 0x3e3edc6d, 0x299dd644, 0x87ecc901, 0x26d3d626, 0x44c5c974,
    0xb5e85624, 0xcbd2897a, 0x02463683, 0x15ad39dc, 0x80000000, 0xc0000000,
    0x20000000, 0xd0000000, 0x98000000, 0xc4000000, 0x06000000, 0x0b000000,
    0x4f800000, 0x35400000, 0x52600000, 0xb1700000, 0x3dd80000, 0xdd840000,
    0x604e0000, 0xf2ef0000, 0x1db48000, 0xc9fdc000, 0xb5182000, 0xdfa6d000,
    0x4bd74800, 0x5e892c00, 0x53c2b200, 0xd5a99100, 0xdad95a80, 0xf80badc0,
    0xf40c80a0, 0x6e09c010, 0x870e20b8, 0x158dd014, 0xfc4dc89e, 0x10ebeccf,
    0xc0b61249, 0x1576813e, 0x0bd8329d, 0xbe8b5144, 0xa3cdfacf, 0x9da4bd7c,
    0x86d5e865, 0x3a0d3cfb, 0xf9015ac3, 0x2a8fad24, 0xfdc280f9, 0x72a6c02c,
    0x1f5aa0c5, 0x9c4010de, 0x20ede8a0, 0xa8b93c16, 0x99775a80, 0x51d4adb8,
    0x778000a1, 0xe1400085, 0x80000000, 0xc0000000, 0xa0000000, 0xb0000000,
    0x48000000, 0x74000000, 0x36000000, 0xe3000000, 0x7e800000, 0x70400000,
    0xaf600000, 0xd6300000, 0xfd980000, 0x95840000, 0x1ac60000, 0xf9210000,
    0x625f8000, 0x692bc000, 0x5a582000, 0xf52f5000, 0xa85ed800, 0x68266c00,
    0x41ddb200, 0x50e27500, 0x7dfcca80, 0x573489c0, 0x26198020, 0x904ac070,
    0x7f67a0e8, 0x8e3490c4, 0x719ef87e, 0x9f8d3c97, 0xbbc56a48, 0x52a51993,
    0x8f9ef851, 0xc88d3c66, 0x53456af2, 0x71e519f3, 0x167ef82f, 0x1afd3cd8,
    0x37bd6aee, 0xd15119c3, 0x8fa0f88e, 0x06183c58, 0xe044eacb, 0x976bd918,
    0x4a3f58a2, 0x0f98ac69, 0x0884121f, 0xf343e57b, 0xc1e3b272, 0x5e7775ff,
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x38000000, 0x0c000000,
    0x9a000000, 0x8f000000, 0x8a800000, 0xc2c00000, 0xbb600000, 0x1db00000,
    0xc9980000, 0x530c0000, 0x08820000, 0x31c70000, 0x83e28000, 0x64734000,
    0x6e716000, 0x997d5000, 0x7ffa5800, 0x373f8400, 0x3b5f1a00, 0xa0622d00,
    0x3134a280, 0x5654b940, 0xc9e200e0, 0xf3770050, 0x98fa8058, 0xe9bf401c,
    0x7f9360a2, 0x360a5083, 0x2500d810, 0x4d80c44d, 0x6c4c7a31, 0xd7a87ddf,
    0xbfd47af2, 0x4ba47d0e, 0x5dd67a21, 0xa8a37d32, 0x5d54fa53, 0xdd603d09,
    0x60bd9aaf, 0x98116d2e, 0x9d45c2d9, 0x5c29e9bf, 0x9e985837, 0x8588849b,
    0x08459a30, 0x19ad6de9, 0xb6dfc22a, 0xec22e9db, 0x80000000, 0x40000000,
    0x20000000, 0x50000000, 0x58000000, 0x5c000000, 0xae000000, 0x83000000,
    0xc4800000, 0xd4400000, 0x18200000, 0xc7500000, 0xd8b80000, 0xdd0c0000,
    0x0f860000, 0x34c70000, 0x6e608000, 0xaa704000, 0x04672000, 0xbb76d000,
    0x9dee7800, 0x20b00c00, 0x91034600, 0xd9893700, 0xbbcc9e80, 0x5ce8ab40,
    0xa13e00a0, 0x76cb0010, 0x2b668078, 0x99f7400c, 0xeea7a0f6, 0x5e1690df,
    0xf711586a, 0x029adc57, 0x1f533edc, 0xc4b23b13, 0x53095840, 0xdc86dc5a,
    0xa84d3ef7, 0xe6293bb9, 0x1c57d8b9, 0x403d9c82, 0xa74c9ee4, 0x94a8abc2,
    0x371e0085, 0x629b0053, 0x6f5e809a, 0xccbb40ed, 0x5701a06e, 0x2e8190d0,
    0x8549d8a3, 0xa1a69c5a, 0x80000000, 0xc0000000, 0xa0000000, 0xb0000000,
    0x18000000, 0x0c000000, 0xb2000000, 0x09000000, 0xe0800000, 0x3cc00000,
    0xbba00000, 0x6cb00000, 0x86580000, 0x5b040000, 0x39860000, 0xd4410000,
    0x236a8000, 0x71114000, 0x5de3e000, 0x86d7b000, 0xb7cc9800, 0x8a2ac400,
    0x1cf3f600, 0x033eb100, 0x9d100e80, 0x3fe385c0, 0x87de0020, 0xf3450070,
    0x10ec80b8, 0x105040bc, 0x340960aa, 0xce06f005, 0x030f7852, 0x558d7435,
    0x76476e5b, 0x82607550, 0x859df8bd, 0xdf2834f7, 0x867a8e1f, 0x32f2c53f,
    0xd03de082, 0xc092b069, 0xeda0186c, 0xa3ba844e, 0xc1da9612, 0x9448413c,
    0x43677622, 0x611af12c, 0xf5e76ec7, 0x92d0752b, 0x09c5f8a0, 0x312c3408,
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0xe8000000, 0x74000000,
    0xe2000000, 0x0f000000, 0x20800000, 0x98c00000, 0x10e00000, 0xe6700000,
    0xb3d80000, 0xda040000, 0x730e0000, 0x068b0000, 0x0dc78000, 0xa369c000,
    0xc8396000, 0xd6f6d000, 0x0316f800, 0x9eed8400, 0xe77f8200, 0x5252e900,
    0x83419a80, 0xaaaf7dc0, 0xd15800a0, 0x1dc40050, 0x8b6e00c8, 0x9c3b00e4,
    0xa4ff800a, 0xe41dc07b, 0xca6f60c2, 0x9db9d097, 0x4dbf7830, 0x45bf447e,
    0x81b962a3, 0x1bb9f93c, 0x88b80240, 0x3e3b291c, 0x4bf8fade, 0x7499adf5,
    0x2aaef88d, 0x11598451, 0x3dc982e1, 0x1b6de9a3, 0x74301a4e, 0xd0f9bdef,
    0x0610e016, 0xc56410d9, 0xbd301819, 0xd57694f7, 0x80000000, 0x40000000,
    0x20000000, 0x90000000, 0xa8000000, 0x4c000000, 0x4e000000, 0x97000000,
    0xc5800000, 0x7d400000, 0xa7600000, 0x3bf00000, 0x55280000, 0xf8040000,
    0x84020000, 0xb2010000, 0xe1048000, 0xb6854000, 0xbac26000, 0x03227000,
    0xce14b800, 0xd61e2c00, 0x770fea00, 0xe0933b00, 0x58dadf80, 0xfe2b2940,
    0x2b800020, 0x3a400010, 0xeae00008, 0x9ab00024, 0x1448002a, 0x18f40013,
    0x5aaa0013, 0xa0450025, 0x07e68031, 0x4234401f, 0xa98ee029, 0x7653300e,
    0xa5fcd815, 0x9f395c3e, 0xdc1dd221, 0x3209572c, 0x7413d5b8, 0xab1f226d,
    0x078c078e, 0x11577550, 0x787b521b, 0x967d1701, 0xd17d35bf, 0x9cfc124f,
    0x3db8df8f, 0x7cda2959, 0x80000000, 0xc0000000, 0xe0000000, 0x10000000,
    0x38000000, 0x8c000000, 0x5a000000, 0x21000000, 0x3b800000, 0x38400000,
    0xcbe00000, 0x69f00000, 0x2d980000, 0x2c040000, 0x6a060000, 0xe9070000,
    0x9f808000, 0xd641c000, 0x3ce46000, 0x2972d000, 0x0f590800, 0xe425dc00,
    0xf057c200, 0x66895f00, 0xf7efcf80, 0xbddaacc0, 0x93e00020, 0x35f00030,
    0xaf980038, 0x91040004, 0x3386000e, 0x7c470023, 0x35e08016, 0xa6f1c008,
    0xe11c600e, 0x54c6d00e, 0x83270832, 0x48d6dc1a, 0x2849420b, 0x75cb9f0b,
    0x3e8d2f9a, 0xabeebcfa, 0x3fdde807, 0x2ee6cc05, 0x6c72aa37, 0x3ada530e,
    0x3b67058d, 0x43312fda, 0xa1b88d8a, 0x485233e1, 0x2a8bafab, 0x4de87cd5,
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xc8000000, 0xdc000000,
    0x4a000000, 0x4f000000, 0x53800000, 0xe2c00000, 0x86600000, 0x10f00000,
    0x7ed80000, 0xb4040000, 0xe6020000, 0xed010000, 0xf0818000, 0x33464000,
    0xf7a6e000, 0x8f125000, 0xc3ea7800, 0x1f3e9c00, 0xa0311600, 0xf3bf3300,
    0xb9740780, 0x5b1e36c0, 0x9de00020, 0x6e300010, 0x92b80008, 0xdbf4000c,
    0x035a0032, 0x67c50037, 0xdae38012, 0x81b74013, 0x2a7f6014, 0xea901038,
    0x542e9821, 0x6dddcc04, 0xed82ee1f, 0x6bc3ef2d, 0x08e1f1b9, 0xcab255fb,
    0x17ffff9c, 0x1956eadc, 0x58cff615, 0xc969633f, 0xeb7c7f8a, 0xf811aafc,
    0xe4689628, 0x7bfd7308, 0xdb50e7a0, 0xebcd66f1, 0x80000000, 0xc0000000,
    0xa0000000, 0xd0000000, 0x28000000, 0x34000000, 0x6a000000, 0xa5000000,
    0xda800000, 0x10c00000, 0xd5200000, 0xc6900000, 0xfcf80000, 0x02040000,
    0xf1060000, 0xc0850000, 0x4dc68000, 0x13a14000, 0x8851a000, 0xe6db5000,
    0xbb112800, 0xc7b8d400, 0x07618600, 0xaf762900, 0xe94a7480, 0x3b6cc7c0,
    0x06780020, 0x02c40030, 0xac260028, 0xe2150034, 0xf33e800a, 0x80a5400d,
    0xc9d7a01a, 0x939e5029, 0xf977a836, 0x02499404, 0xa6e82635, 0x8d397931,
    0x5fa55cbf, 0x3e5513c0, 0xbdd9061c, 0x7e966900, 0x80fb54bb, 0x2c03d7f0,
    0xc6060808, 0xa302c404, 0xd9810e1c, 0x1945ad2c, 0xe462dabd, 0x16f63ae2,
    0x800df2b5, 0x270feee6, 0x80000000, 0xc0000000, 0x60000000, 0xd0000000,
    0xd8000000, 0xe4000000, 0xbe000000, 0x37000000, 0xdd800000, 0x3d400000,
    0xf3200000, 0x6bd00000, 0x3c480000, 0xba040000, 0x99060000, 0x52830000,
    0xd4c68000, 0xa866c000, 0x4bf72000, 0x341df000, 0x8c0db800, 0x0da4ec00,
    0x9d14ea00, 0x492a1900, 0xad771e80, 0x46de0240, 0x97680020, 0xf5d40030,
    0x7b4e0018, 0x0f870034, 0x48408036, 0x23a5c039, 0xd211a02f, 0xc0ab300d,
    0x26329837, 0xbefd1c0f, 0x7b3f523c, 0x7dddf51a, 0xd8ed748f, 0x1d96db6e,
    0xe8ee3e86, 0xd594f264, 0xb4ed380d, 0x5f912c2e, 0xe5ed4a3c, 0x51152900,
    0xbb2b86ba, 0xa8741e77, 0xfe5fd21f, 0xc2a83520, 0x8b34d4b8, 0x8a79eb70,
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x28000000, 0x84000000,
    0xda000000, 0x23000000, 0x31800000, 0xcec00000, 0x2aa00000, 0x96100000,
    0x4b580000, 0xae040000, 0xa1060000, 0x0e810000, 0x19448000, 0xb1614000,
    0xf0342000, 0xdb0ed000, 0x13bd1800, 0x4cf38c00, 0x96a97600, 0x4e28d500,
    0x7a6b7080, 0x0b8c3ac0, 0x33f80020, 0xcf140030, 0x09de0008, 0x59450024,
    0x5162800a, 0x40304021, 0x6308a036, 0xbfbb9008, 0x12f7380c, 0x6fa85c33,
    0x5caeee0a, 0x852f1925, 0xefeca692, 0x8f4e7feb, 0x1258c888, 0xec8526f3,
    0x5642ce2e, 0xfee5c938, 0x57f7bebe, 0xcb2cf3f3, 0xfeed3e98, 0x39c8b3ca,
    0xa71b9eb7, 0x03e623fc, 0x5f7626ba, 0x376a3fe1, 0x80000000, 0x40000000,
    0xa0000000, 0x90000000, 0x38000000, 0x84000000, 0x56000000, 0x27000000,
    0x2b800000, 0xc7c00000, 0x4f600000, 0xd9900000, 0xdfb80000, 0x77040000,
    0xf3820000, 0x73c50000, 0xb1648000, 0x4291c000, 0x263c2000, 0xc1c6b000,
    0xb0633800, 0x46145c00, 0xe67abe00, 0xa367bb00, 0xd390ec80, 0x1ab94dc0,
    0x85820020, 0x84c50010, 0x02e48028, 0x9151c024, 0x075c200e, 0xbb56b021,
    0x125b3815, 0xd1d05c09, 0x7118be0a, 0xcef2bb31, 0xf22c6c93, 0xf6bc8df6,
    0x8f842017, 0x41c2b00d, 0xf0613814, 0xe6115c38, 0x767e3e22, 0x9b667b31,
    0x5794cc9c, 0x4cbbfdf9, 0xa2833806, 0xaf445c30, 0xc522be02, 0xde33bb3a,
    0xdecaec8d, 0x64e84dfa, 0x80000000, 0xc0000000, 0x20000000, 0x10000000,
    0xf8000000, 0x3c000000, 0x5a000000, 0x1b000000, 0xa8800000, 0x1c400000,
    0x7b600000, 0x81100000, 0x4f080000, 0xab040000, 0x80860000, 0xf8410000,
    0x0d608000, 0x3817c000, 0xc089e000, 0x45c6d000, 0xfca6d800, 0xaab44400,
    0xdf386200, 0xa7781b00, 0x6a1fe880, 0x720ba840, 0xa2860020, 0x1f410030,
    0xdfe08008, 0x2f57c004, 0xeb69e03e, 0xe496d00f, 0x92ced816, 0x9ba04406,
    0xb836622a, 0xe87d1b07, 0x9c99689e, 0x334d6860, 0x20676033, 0xc994101a,
    0x6349b828, 0x3864543a, 0xc597da3d, 0xd14d4f01, 0xe760b2a6, 0x0b152757,
    0x8c0952b5, 0x2f83f75d, 0x3ec78a81, 0xa423b37d, 0x7ef1e89f, 0x705ea84d,
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x28000000, 0x3c000000,
    0xd2000000, 0x7b000000, 0xef800000, 0x48400000, 0xc9200000, 0x88100000,
    0x90a80000, 0xa3040000, 0x8b820000, 0xbe450000, 0xe4248000, 0xda914000,
    0xa269e000, 0x64e29000, 0x1671d800, 0xc81a7c00, 0xdefac200, 0x23890900,
    0x2c16a080, 0x86a99540, 0xbe020020, 0x61050010, 0x98848028, 0xcdc14024,
    0xee61e00a, 0x40b6900f, 0xf9fbd834, 0x6e0b7c1e, 0x0754423b, 0x24094912,
    0xb851c0b2, 0xad8b4562, 0xf514b804, 0x0a2dac38, 0x9dc0fa0a, 0x2664e50b,
    0x4cb13ab3, 0x93ffa079, 0x010d82bc, 0x06d60c57, 0xc54f78b6, 0xe5f7e954,
    0x825ac207, 0xe4d90911, 0xe81ea0b9, 0x0efd957c, 0x80000000, 0xc0000000,
    0xa0000000, 0xb0000000, 0xf8000000, 0xbc000000, 0xc2000000, 0x57000000,
    0xc0800000, 0x30c00000, 0x82200000, 0x28b00000, 0x66380000, 0xcb040000,
    0x72860000, 0x3fc50000, 0x4ea58000, 0x2277c000, 0x0f1de000, 0xe1321000,
    0x737cb800, 0xb6670400, 0x24520600, 0xf9aed100, 0xa20d2580, 0xd7f8e1c0,
    0x88a60020, 0x6b750030, 0x4a9d8028, 0x0e73c02c, 0x451be03e, 0x5237102f,
    0x7df93830, 0xeba0c415, 0x8df7e630, 0xe358c10c, 0x21d79da0, 0x76eae5ca,
    0x84698639, 0x7ba81102, 0x950b45b4, 0x077c31e3, 0xf064d80d, 0xad52d417,
    0x1c2b5e1b, 0xfd4fc501, 0x199d9b92, 0xd0f034ce, 0xf0daa3b9, 0x0f91f0d1,
    0xe10ec589, 0x417bf1d7, 0x80000000, 0x40000000, 0x60000000, 0x70000000,
    0x88000000, 0x0c000000, 0xca000000, 0x37000000, 0x2b800000, 0x9d400000,
    0xd2e00000, 0x56b00000, 0x55c80000, 0xeb040000, 0x39820000, 0x3e430000,
    0xc7638000, 0xb2f44000, 0x5da86000, 0xf6725000, 0x3f6bb800, 0xe7d65c00,
    0xb23d6a00, 0xb62dd700, 0x4b375580, 0xfd89be40, 0x49620020, 0x63f30010,
    0x9b2b8018, 0x8fb0401c, 0xdf4a6022, 0x38c15003, 0x9ea03832, 0x42d61c0d,
    0x7abf0a0a, 0x5ee88727, 0x0d956db4, 0x2b5ca255, 0x0dde8a35, 0x441fc72a,
    0x4c3e8d96, 0xef2ab253, 0x81b55233, 0x4e4fcb3f, 0x9e425fbd, 0x9766396c,
    0x2af6ed87, 0xa9a8e24d, 0xb876ea12, 0xce6d9739, 0x315535b7, 0x33fcee7d,
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x38000000, 0x54000000,
    0x12000000, 0xed000000, 0x9c800000, 0x89400000, 0x8a600000, 0x07500000,
    0xc1380000, 0x91040000, 0x82860000, 0xd2450000, 0x81e28000, 0x9391c000,
    0x189aa000, 0x6a749000, 0xbf096800, 0x90ede400, 0x507cca00, 0xdf629300,
    0x0fd31a80, 0xfa78d9c0, 0xa6660020, 0x21550030, 0xce3a8028, 0x8885c014,
    0xfb44a00e, 0x97659015, 0xf3d5e804, 0x247d243b, 0x5d62ea27, 0x7ad2c322,
    0x62fa52a2, 0x05246dc1, 0x12370210, 0x47efe714, 0x2df8b888, 0x7ca6aee0,
    0x9bf5508e, 0x6acf8ac1, 0x33c9ba8a, 0x8d4c49c5, 0x210f680e, 0x0be8e437,
    0xfbfe4a14, 0x1ba3530c, 0xee71ba9e, 0x550849d6, 0x80000000, 0x40000000,
    0x60000000, 0x90000000, 0x48000000, 0x14000000, 0x6e000000, 0xc9000000,
    0xf3800000, 0xd4c00000, 0x89e00000, 0xbb100000, 0x7eb80000, 0xe5040000,
    0x11820000, 0x4fc30000, 0x59648000, 0x73524000, 0x0d18a000, 0x9eb77000,
    0x400c4800, 0x15089c00, 0xbc8c2600, 0x3f4b0f00, 0x542cf880, 0x947b45c0,
    0xcde20020, 0xbd130010, 0x53bc8018, 0xa0864024, 0x5042a012, 0x4fa07005,
    0x91b2c81b, 0xbe8ddc32, 0x744a063c, 0xaca93f35, 0xd83e90a2, 0x9845e9ee,
    0x1ba64e3f, 0x9fb1a329, 0xe78ab69c, 0xcfcae6f7, 0x6c68b6a4, 0x3fd9e6c9,
    0xea5436a0, 0x969fa6e1, 0xae769686, 0x7fefd6c1, 0x3b1c5ebc, 0x4bb60ae2,
    0xa98c5887, 0xf6c835ea, 0x80000000, 0x40000000, 0xa0000000, 0x90000000,
    0xf8000000, 0x4c000000, 0x76000000, 0x07000000, 0xb5800000, 0x5f400000,
    0x91e00000, 0x80900000, 0xb2980000, 0xb1040000, 0x52820000, 0xdac50000,
    0xa6a48000, 0xa577c000, 0x080a6000, 0x729fb000, 0x51063800, 0x6282ac00,
    0xb2c37a00, 0x12a7cf00, 0x9f71a480, 0x790c44c0, 0xc01a0020, 0xbbc10010,
    0xac268028, 0xa3b2c024, 0x20aee03e, 0x9ce87013, 0x9a8c581d, 0x485d1c01,
    0xc7a5422d, 0xaff56317, 0x0ecadea4, 0x5a3f8be0, 0xbf71a48c, 0xa90c44fc,
    0x981a001c, 0x67c10002, 0x2226803f, 0xe8b2c01e, 0xe32ee021, 0xc4a8700e,
    0xbeec5824, 0x978d1c0e, 0xe4dd4225, 0x9e616333, 0xeed0deaf, 0x31fe8bd2,
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xb8000000, 0xfc000000,
    0x26000000, 0xe3000000, 0xc1800000, 0xcec00000, 0x3ce00000, 0x41900000,
    0xe9780000, 0xb5040000, 0x5a860000, 0x93430000, 0x24278000, 0x2675c000,
    0x956fe000, 0xb4bd3000, 0x30651800, 0x49d30c00, 0x90daf600, 0x8bb7a700,
    0xa80e2c80, 0x5bee9bc0, 0x15fe0020, 0x05470030, 0xdf218018, 0x8bf6c03c,
    0x35a8602e, 0x2f58f03f, 0x6a72f809, 0xab6a3c38, 0x3bb9ee30, 0x9fe7ab33,
    0x20135a8f, 0xb7bcfcd0, 0xc1e7cc9a, 0x5f10abdd, 0xa03c982e, 0x5421cc28,
    0x5e74963f, 0x096c570a, 0x62bb5482, 0x6b6167ea, 0x74500e15, 0x78199b29,
    0x5451c283, 0x281a30fd, 0x7c52da91, 0x9c1a3ce4, 0x80000000, 0xc0000000,
    0x20000000, 0x50000000, 0xb8000000, 0x64000000, 0x7a000000, 0xf5000000,
    0xb5800000, 0xd7c00000, 0x78600000, 0xdff00000, 0xca580000, 0x6b040000,
    0xfa860000, 0xb7410000, 0x4a228000, 0xc855c000, 0x09cb2000, 0x04afd000,
    0xaedda800, 0x9346ac00, 0xd0233e00, 0x4d558300, 0x544a9f80, 0x0f6f62c0,
    0xc8be0020, 0xc3b50030, 0x5afc8008, 0x4410c014, 0x016fa02e, 0x1fbb1019,
    0x9734081e, 0xaabcbc3d, 0xc2b5b62d, 0x0d7cff35, 0x52d4099e, 0x0e8c4df7,
    0x868fa192, 0xea8be1ea, 0x3c8e1f96, 0x3f8ba2c9, 0xd90fa014, 0x504b100f,
    0xc56c083a, 0xf5b8bc31, 0xfa33b636, 0x2b3dff35, 0xd7768999, 0xe4198dec,
    0x42a481b4, 0xe61431eb, 0x80000000, 0x40000000, 0xa0000000, 0x10000000,
    0x28000000, 0x6c000000, 0xa2000000, 0x55000000, 0x89800000, 0x0c400000,
    0x1d600000, 0xcdb00000, 0x25580000, 0x73040000, 0xf2820000, 0xc2c50000,
    0xf5a08000, 0x11114000, 0x37cb6000, 0x71891000, 0xb5eca800, 0xe3df4c00,
    0xa7c3e200, 0x04262b00, 0xf951cd80, 0xf4ae9ac0, 0x633a0020, 0x20310010,
    0xb71a8028, 0x11604004, 0x9fb1e00a, 0xe859501b, 0xae854828, 0x18c21c15,
    0x44a4aa22, 0x46913703, 0xe48de787, 0xdc6aedf3, 0x5f9e87a9, 0x82a7fdcc,
    0x8d902fb4, 0x120db1e4, 0x70ab4dbf, 0x4d3edacb, 0x6733e027, 0x539c5006,
    0xd0a5c805, 0x40935c31, 0xcf8fca2e, 0x9ae8273f, 0xcb594fba, 0xd401a1c4,
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0xb8000000, 0xd4000000,
    0xaa000000, 0x6b000000, 0xff800000, 0xc2c00000, 0x9e200000, 0x44500000,
    0xf5980000, 0xaf840000, 0x4ac20000, 0x52250000, 0x4a538000, 0x8c9dc000,
    0xef02a000, 0xdd875000, 0x65c65800, 0x6fa47c00, 0xff93d600, 0x2b3a5100,
    0x7c937280, 0x88bef4c0, 0xd8538020, 0x739dc010, 0x1a82a028, 0x0447501c,
    0xbc66582e, 0x3d347c35, 0x3e2bd62a, 0xabee511a, 0x3c4972bf, 0xb7dff4f0,
    0x46e20007, 0xe9750001, 0x4a4b8015, 0xfad9c037, 0x7c60a03c, 0xdd325021,
    0xee2dd838, 0x63edbc39, 0x504b7604, 0xc9dc0107, 0x87e4aabe, 0x7df248ca,
    0x77097622, 0xa6390131, 0xa6172aa5, 0x6cff88ea, 0x80000000, 0xc0000000,
    0x60000000, 0x10000000, 0x48000000, 0x54000000, 0x96000000, 0xdb000000,
    0x1d800000, 0x79400000, 0xd9600000, 0xf0500000, 0x22a80000, 0xb5840000,
    0xfd460000, 0x67630000, 0x6f508000, 0xe12a4000, 0x43c6a000, 0xafa2b000,
    0x3575d800, 0x89186c00, 0xddbd8a00, 0x454e6b00, 0x8d123280, 0x85ca4d40,
    0xbad08020, 0x0c6a4030, 0x6ca6a018, 0x94f2b004, 0x425dd812, 0x11dc6c15,
    0x6f9b8a25, 0x097d6b36, 0xdd6ab287, 0xa8240d5e, 0xdd302016, 0x34fbf00c,
    0x142bf810, 0x49449c29, 0x2160f22d, 0x9c53b70c, 0xb8ace0be, 0xe4850a4e,
    0xf9c118b7, 0x4ea29645, 0x09f16a83, 0xacdb616a, 0x311b2a15, 0x11bcdb1d,
    0xaf4feab3, 0x8416215f, 0x80000000, 0xc0000000, 0xa0000000, 0x10000000,
    0x68000000, 0xa4000000, 0x26000000, 0x8f000000, 0x92800000, 0x61c00000,
    0xfce00000, 0x6ff00000, 0x89780000, 0xa6840000, 0xefc60000, 0x77e50000,
    0xcb708000, 0x0fbb4000, 0x6ce12000, 0xc7f73000, 0x8d797800, 0x90801400,
    0x08c64e00, 0x4167c700, 0x8cb2cf80, 0x7c5b73c0, 0x91908020, 0x2f4b4030,
    0xd7192028, 0x10b33004, 0xf65f781a, 0x2c951429, 0x6ccece09, 0x67588723,
    0x9d15efa4, 0xad8943d8, 0x2b79781f, 0xdf80142b, 0x3a464e0a, 0x30a7c72d,
    0x1852cfa1, 0xb7ab73f4, 0x3ee8801b, 0x06cf4010, 0xaa5f2017, 0x0696302d,
    0xc1cff806, 0x4cde5416, 0x8957ee29, 0x062bb71a, 0xffaa97bc, 0x4aec57da,
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xa8000000, 0x34000000,
    0x2a000000, 0xc3000000, 0x6b800000, 0x67400000, 0x41600000, 0x83300000,
    0x49280000, 0x0f840000, 0x35460000, 0x0e670000, 0xaeb78000, 0x5b6d4000,
    0xf865a000, 0x53b75000, 0xc9e91800, 0x6fa0dc00, 0x82107a00, 0x72fcab00,
    0x0ddec980, 0xef0b1140, 0x0dd78020, 0x1f5d4030, 0xb8cda038, 0x3c73503c,
    0x544f182a, 0x72b7dc0d, 0x656ffa0a, 0x0165eb30, 0xa335699a, 0x592f4159,
    0x57871830, 0xa943dc10, 0x1061fa2a, 0x47b6eb3f, 0xf3ece9a7, 0xf4a1014e,
    0x75933801, 0x0bbecc16, 0xa5bac21c, 0xc4bc2731, 0x48382b88, 0x36fe2676,
    0x4fda9398, 0xf80aaa5f, 0xbc52718c, 0x131c9d6d, 0x80000000, 0x40000000,
    0x20000000, 0x30000000, 0xe8000000, 0xcc000000, 0x5e000000, 0x39000000,
    0x43800000, 0x8fc00000, 0x75e00000, 0x68900000, 0x10e80000, 0x97840000,
    0x95c20000, 0xcee10000, 0x94118000, 0xc1af4000, 0xbc226000, 0x6070f000,
    0xb9f8c800, 0xb7af9c00, 0x29253e00, 0x6df6cf00, 0xd7393480, 0xa5cb8f40,
    0x5c718020, 0x6fff4010, 0x52aa6008, 0xeca4f00c, 0xff32c83a, 0x735a9c33,
    0x259ebe17, 0x43fc8f0e, 0x5ca8d490, 0x2da53f63, 0xa8b2a83d, 0x869b6c0a,
    0xfb7ff60c, 0x0fe85329, 0xb9058a9f, 0x03860040, 0xafc0d492, 0x45e13f6e,
    0x8090a817, 0xdcea6c27, 0xc9867601, 0xacc31308, 0x8d65eaa3, 0x1bd7f043,
    0xb4499cb7, 0xd4b1e367, 0x80000000, 0xc0000000, 0xa0000000, 0x10000000,
    0x48000000, 0x34000000, 0xe2000000, 0xaf000000, 0xdf800000, 0x1cc00000,
    0x52200000, 0xfed00000, 0xbaa80000, 0x7d840000, 0xd3c60000, 0x3da50000,
    0xba108000, 0x948a4000, 0x5555a000, 0x24691000, 0x30a47800, 0xaa907c00,
    0xe7cfa600, 0x43b7b100, 0xf49ca680, 0xa2d80d40, 0x20b88020, 0x390e4030,
    0x6e93a028, 0x3dcc1004, 0x20b4f812, 0xa51a3c0d, 0x8f1a0638, 0xd41ea12b,
    0x4998deb7, 0xea587147, 0x2fff2634, 0xf9edf10f, 0xf3610686, 0xdf351d5b,
    0x69daf806, 0x353b3c32, 0x0ecc863e, 0x5931e10a, 0x0cddfeb0, 0xc1bb2143,
    0x778efe00, 0xc4d49d0e, 0xa9aad888, 0xd402d04c, 0x9201f8af, 0x57008065,
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x88000000, 0xa4000000,
    0x4a000000, 0x5f000000, 0x94800000, 0x90c00000, 0x71e00000, 0x89f00000,
    0x4a980000, 0x9a840000, 0x55c20000, 0xa2610000, 0x11b58000, 0xcdbc4000,
    0xd3912000, 0x17285000, 0x293ff800, 0xab572400, 0x52cbc600, 0xd2ce2f00,
    0x92c9df80, 0xb2ceccc0, 0x02cd8020, 0x8ac84010, 0x2ecb2008, 0x64cd502c,
    0x3bc87822, 0xaf4a6429, 0x3f8f6612, 0x4e6a3f17, 0xc79f07a5, 0x8d05b8e4,
    0x1783be3c, 0x42444b32, 0xe026b99a, 0xf194f3ca, 0x3c2a8797, 0xefb9f8d1,
    0xf8929e3e, 0xd1ac1b18, 0x7af941bb, 0x2833d7e4, 0xfaf94186, 0x6833d7e6,
    0xdaf94199, 0xd833d7dd, 0x52f94182, 0x7c33d7d7, 0x80000000, 0xc0000000,
    0xa0000000, 0x30000000, 0xb8000000, 0x2c000000, 0x2e000000, 0xe7000000,
    0x2e800000, 0xa6c00000, 0x58e00000, 0x61b00000, 0xf8c80000, 0x5c840000,
    0xb7c60000, 0x2d650000, 0x4ff18000, 0x75edc000, 0x49556000, 0x417f7000,
    0x184e3800, 0x4d42f400, 0xe9a3f600, 0x4e172700, 0x55de3d80, 0xadd85e40,
    0xe1d98020, 0x5fd9c030, 0x30db6028, 0x8a5e700c, 0x2e99b82e, 0xbf7a340b,
    0x174f160b, 0x67c19739, 0xc563658b, 0x4bf0da69, 0xffedce36, 0x1455d328,
    0x8afdcb96, 0x590f795b, 0x7ae7bda3, 0x58b19e70, 0x294ae010, 0xc8c3b018,
    0xdfe4d81f, 0xdf31443e, 0xd60f2e35, 0x90626339, 0xd4771384, 0x1caf3d54,
    0xdaf71385, 0x4a6f3d61, 0x80000000, 0x40000000, 0xe0000000, 0x30000000,
    0x88000000, 0xec000000, 0x1a000000, 0xb5000000, 0x46800000, 0xf7c00000,
    0xe3200000, 0x1c900000, 0x35780000, 0x88840000, 0x7cc20000, 0x06a70000,
    0x32d18000, 0x5a1c4000, 0x2a736000, 0x5bcad000, 0xf1eea800, 0xa9fdb400,
    0x6a42fe00, 0x0964f900, 0x55f2f480, 0x808ea3c0, 0x38098020, 0xccc84010,
    0x26696038, 0x0eb9d00c, 0xe1a52822, 0x8d52f43b, 0x215a1e06, 0x3391692d,
    0x86fcbc91, 0xd9c287fd, 0x58273618, 0x71179d17, 0xf73ca2b5, 0xfde0eeee,
    0x6b300a9d, 0x672a5aea, 0x325b7492, 0x2216e3e7, 0x06b8e021, 0x4da5900c,
    0x77564818, 0xa4582437, 0xfd14b622, 0x9d3cdd0b, 0x20e642a5, 0xf1b27ef6,
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xf8000000, 0xec000000,
    0xa2000000, 0xcd000000, 0x7a800000, 0x86400000, 0x83200000, 0x3e500000,
    0x38b80000, 0x67840000, 0xc4c60000, 0x89630000, 0x4f728000, 0x33efc000,
    0xc9bb6000, 0x87071000, 0x03836800, 0x82c25400, 0xc2617200, 0x1ef4b900,
    0xb42b8280, 0x355ebdc0, 0xa9b48020, 0xb78cc030, 0x9c49e018, 0x62a8d014,
    0xb118083e, 0xd795443b, 0x5b5a1a28, 0x36b2ed33, 0xc80cf09e, 0x248904e1,
    0xd1cd8280, 0x8f6dbdff, 0xc4fe0036, 0x35a7003d, 0xea148017, 0xbe9cc00d,
    0x6751e005, 0xcc3cd004, 0xeec60804, 0xa0624433, 0xb3f69a3e, 0x9eaa2d0e,
    0x4b1b109e, 0xc696d4d1, 0x2bd90ab2, 0x69f039c6, 0x80000000, 0xc0000000,
    0xe0000000, 0x50000000, 0x88000000, 0x34000000, 0x12000000, 0x4f000000,
    0x08800000, 0x2e400000, 0x00a00000, 0x8a300000, 0xc3b80000, 0x6f840000,
    0x62c60000, 0x04e70000, 0x29928000, 0xef0c4000, 0xeb7da000, 0x58629000,
    0x85d37800, 0xc8adc400, 0x0dcbb200, 0x2f9fe500, 0x91f06180, 0x3adf75c0,
    0xabd48020, 0x61ab4030, 0xb84f2038, 0x165ed014, 0x3f96d822, 0xaa0b540d,
    0xf0feca04, 0x08a52113, 0x7e315382, 0x31b8d0cb, 0x708741a0, 0xe245a5d2,
    0x1ea45828, 0x3b37143f, 0x2a3b6a02, 0x2043b118, 0x19a42bac, 0xe7b214e5,
    0x467e739c, 0xe7e600fe, 0xaf1199bb, 0x184ef1ff, 0x665a9209, 0x0792351b,
    0x460a3992, 0x5efb61de, 0x80000000, 0xc0000000, 0xe0000000, 0xd0000000,
    0x38000000, 0xd4000000, 0x7a000000, 0x91000000, 0x06800000, 0x47400000,
    0x96600000, 0x3b300000, 0x5ba80000, 0x1f840000, 0xbdc60000, 0xa7270000,
    0x42568000, 0xb519c000, 0x40eaa000, 0x0fe1d000, 0x61f58800, 0x1509b400,
    0xcf117a00, 0x9a7dd300, 0x715fa980, 0x6d090540, 0x3b108020, 0xd07ec030,
    0x085c2038, 0x87881034, 0xd257280e, 0xad1c6435, 0xa4eaf21e, 0x9de76724,
    0x1cf65381, 0xbd8e1651, 0x63550985, 0x9b98d57e, 0x0bad080e, 0xe7837403,
    0x89c35a19, 0x0d26c328, 0xeb500180, 0x679fa17c, 0x7da8522f, 0x0882b706,
    0x5c45db84, 0x09e0a26e, 0x46f2f3ae, 0x1c8cc66a, 0x8dd001a3, 0x30dfa155,
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xf8000000, 0x4c000000,
    0x8a000000, 0xd9000000, 0x17800000, 0x6e400000, 0xeca00000, 0x2a100000,
    0x8b180000, 0x6a840000, 0xd7c20000, 0xb5e70000, 0x06318000, 0x3fcfc000,
    0x6bfe6000, 0x51325000, 0x8f4bc800, 0xed3a3c00, 0xa7533200, 0x113fc500,
    0x9555e080, 0x643a80c0, 0x38d38020, 0x2b78c010, 0x8ff7e038, 0xe529900c,
    0x314fa83e, 0xb23b6c13, 0x03d37a22, 0x81f93936, 0xf8333285, 0x80cbd5db,
    0xff78489b, 0x39f6ecda, 0xae297a3a, 0x83ca3906, 0xb9f8b2b3, 0x143715f2,
    0xdacda8bd, 0xee787cfa, 0x9a775225, 0x066e9525, 0x3c6da89b, 0x5d687cf5,
    0xe6ef520c, 0x32aa9521, 0xff0fa8ad, 0x8e9f7ccf, 0x80000000, 0x40000000,
    0x20000000, 0x10000000, 0xc8000000, 0x24000000, 0x2e000000, 0xe1000000,
    0xc0800000, 0x9d400000, 0x4b600000, 0xea300000, 0x84880000, 0x8f840000,
    0xfcc20000, 0x36a10000, 0x2c108000, 0xedde4000, 0xc53d2000, 0xd9cf7000,
    0xa4e00800, 0x26f58400, 0x6a2b2a00, 0x4f91bb00, 0x1b1b4180, 0x3c9e7c40,
    0xd45a8020, 0x14fb4010, 0x35efa008, 0x12b03004, 0x85cda832, 0x36e4b409,
    0x25f6020b, 0x51ab4f38, 0x155063b0, 0xc8ba4367, 0xee0aebb2, 0x8dc4876a,
    0x7e266189, 0xb5510c77, 0x98ba8825, 0x060ec410, 0xb9c48a3a, 0x98218b0e,
    0x7056e9b8, 0x763ac860, 0x7a4c8220, 0x32200f3c, 0xef57c391, 0xbfbe7369,
    0x138d4398, 0x02053342, 0x80000000, 0xc0000000, 0x20000000, 0x90000000,
    0x28000000, 0x94000000, 0x3e000000, 0xed000000, 0xd7800000, 0x13c00000,
    0xbe200000, 0x1cb00000, 0x4ed80000, 0x64840000, 0x59460000, 0xe2610000,
    0x9d548000, 0x6e494000, 0x71e8a000, 0x779bf000, 0xf6e46800, 0x5c153c00,
    0xa02c5e00, 0x6eb89100, 0x5ed6f580, 0x838f4ec0, 0x02ca8020, 0x2cac4030,
    0x83fa2008, 0x12b3b024, 0xdbd8480a, 0x2f078c25, 0x7080960f, 0xa7465d3b,
    0x2f66c3b5, 0xdad6e3c4, 0x558e2b8f, 0x5bce9ff7, 0x552cd5bb, 0x553cfecd,
    0xef12c834, 0xeaabcc09, 0x32fab62a, 0xdf35ed21, 0xa31e8bac, 0x17a16fc7,
    0x0276bd88, 0x977cc2df, 0xd3f41609, 0x15bf1d15, 0x305663bf, 0x59c913c7,
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x48000000, 0xac000000,
    0xd2000000, 0xb3000000, 0x02800000, 0x38400000, 0x63e00000, 0x6f100000,
    0x98e80000, 0x33840000, 0x31c60000, 0x5d270000, 0x7ab18000, 0xbd1a4000,
    0xd9f96000, 0x726c9000, 0xb7c09800, 0x18209400, 0x55350200, 0xd6ddbf00,
    0x7bdec880, 0xe858af40, 0xc99f8020, 0x0cb94030, 0xa20ee038, 0x2911d00c,
    0x3de87812, 0x2c06442b, 0x1204fa34, 0x5305bb2c, 0x32855280, 0x7046844e,
    0xcfe3cab8, 0xbd11106b, 0x2bef48be, 0x3102ef70, 0x0986e006, 0x3ec5d000,
    0x15a67800, 0x25f54424, 0xea7b7a10, 0x43acfb15, 0xeae3b281, 0x6293547f,
    0xe82db28b, 0x0f20545c, 0x09b232b4, 0x5f991446, 0x80000000, 0x40000000,
    0x60000000, 0x10000000, 0xe8000000, 0xb4000000, 0x3a000000, 0x9f000000,
    0x85800000, 0x3dc00000, 0x38e00000, 0x34f00000, 0x7a280000, 0x78840000,
    0x4b420000, 0x96a30000, 0xd8d08000, 0x0abf4000, 0x9f19a000, 0x6c4fd000,
    0x8e31f800, 0xcb4dac00, 0x77b12e00, 0x0889a700, 0x12559780, 0x7af9d940,
    0x5e3a8020, 0xa2584010, 0x03eb2018, 0xc2639004, 0xdcb0d83a, 0xf7093c2d,
    0xd093760e, 0xd79cdb27, 0xbf0fc1a1, 0x5495924f, 0x759d19ae, 0x6c0fae5d,
    0xb716efa6, 0x5958354a, 0x746a8e10, 0xa4a5771c, 0xa3d4ef9a, 0x3d3b354c,
    0x99da0e12, 0x032a370e, 0xac054f9a, 0x3600e553, 0x9901f636, 0x84809b23,
    0xf546e190, 0xaba5024b, 0x80000000, 0x40000000, 0x60000000, 0x70000000,
    0xc8000000, 0x54000000, 0xf2000000, 0x39000000, 0xe9800000, 0x44c00000,
    0x59e00000, 0x5f100000, 0xe4b80000, 0xb6840000, 0x46420000, 0xdda30000,
    0x13b38000, 0x3a8e4000, 0xf2cea000, 0x80699000, 0x195cc800, 0x9391cc00,
    0xaffee600, 0x00a2af00, 0xe0300880, 0x034e9dc0, 0x08a98020, 0x3eb94010,
    0xeb872018, 0xf5c0d01c, 0x8463e832, 0x99d51c15, 0x4c5f0e3c, 0x5414b30e,
    0x143c86ba, 0x0bc46ed1, 0xe363a6b6, 0x4750bec7, 0x0e1a4e81, 0xa3b2a2e1,
    0xd28cc09b, 0xb6cf51ee, 0xca6f6632, 0xbc5fef19, 0xdc152890, 0x203d4df6,
    0x89c1e804, 0x12661c29, 0xfad48e1a, 0xb8def339, 0xc350268e, 0x641efec9,
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x58000000, 0x8c000000,
    0xee000000, 0x7b000000, 0x28800000, 0xf4c00000, 0x94600000, 0xe2700000,
    0x86280000, 0xe9840000, 0x05460000, 0xfd210000, 0xe1518000, 0x747ac000,
    0x61786000, 0xf2fd7000, 0x0eb8d800, 0x5e1bc400, 0x700fe600, 0x98508300,
    0x19f84380, 0x8e3ab940, 0x5edf8020, 0xb66fc030, 0xb727e008, 0x4052b00c,
    0x55ff3816, 0x40397423, 0x15d8de3b, 0xc6edf71e, 0xcfe69d8a, 0x3a364e7d,
    0xcc889d85, 0xee934e48, 0x089f1d89, 0x57c88e46, 0xd0b6fdbf, 0x5d4f3e60,
    0x517645bd, 0x8aa98a5c, 0x07417b97, 0xb822cd40, 0xfad6de29, 0x4c38f713,
    0x3bd91db7, 0x9de98e68, 0xd7677d84, 0x96f5fe6e, 0x80000000, 0x40000000,
    0x20000000, 0x70000000, 0x78000000, 0x64000000, 0xf2000000, 0xeb000000,
    0x0c800000, 0x79c00000, 0x6d200000, 0x6fb00000, 0x3dc80000, 0xb9840000,
    0x10420000, 0x35610000, 0x66d38000, 0xbd1bc000, 0x659f2000, 0xf6599000,
    0x44785800, 0xdd4ce400, 0x6e448e00, 0x20630900, 0x3f568d80, 0xbd5a4640,
    0x78f98020, 0xfc8ec010, 0x1766a008, 0xc5d7501c, 0x8d9ef81e, 0xfa5bb419,
    0xfa7a763c, 0xa848bd3a, 0x67c4fb83, 0x2826fb5e, 0x3e377bbb, 0x218d3b4b,
    0x32e05ba7, 0x0390ab62, 0x81fa03b2, 0x0b0d4f58, 0x4a250d93, 0xbd318640,
    0x610ea010, 0xd523500c, 0x6bb4f823, 0x9fceb40d, 0x5a83f62e, 0x00c67d00,
    0xdaa25ba0, 0x12f1ab73, 0x80000000, 0x40000000, 0x20000000, 0xb0000000,
    0x18000000, 0x1c000000, 0x22000000, 0x87000000, 0xac800000, 0x58400000,
    0x2fe00000, 0xfab00000, 0x50680000, 0x70440000, 0x6be20000, 0xe4b10000,
    0x456d8000, 0x43c4c000, 0x8322e000, 0xb1101000, 0x1739b800, 0x4599a400,
    0xfb4c2200, 0x85576f00, 0x62dd6d80, 0xb42fa740, 0x8da2e020, 0x2e501010,
    0xb459b808, 0x5769a42c, 0x9cc42206, 0x13a36f07, 0x7b576d88, 0xa7daa761,
    0x0fad600b, 0xd165d006, 0x5df6d803, 0x5f0d7412, 0x58b77a12, 0x976edb1b,
    0xfcc0f792, 0x83a56c58, 0xd351af9a, 0xa3d9d856, 0x31abb583, 0x7462d36e,
    0x76759a3f, 0xabcecb36, 0x2f114fa2, 0x4238c852, 0x561f8d8c, 0xa38fb75d,
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xd8000000, 0x34000000,
    0xc2000000, 0x7b000000, 0x20800000, 0xa8c00000, 0x76e00000, 0x50500000,
    0xccf80000, 0xfcc40000, 0x84e60000, 0x13570000, 0x287f8000, 0x4e02c000,
    0xbd07a000, 0xa1811000, 0x37445800, 0xe4a7c400, 0xc174e600, 0x08cda700,
    0xb3ad5a80, 0xe2bd63c0, 0x93e7a020, 0x05d11030, 0xd9bc5838, 0x9363c43c,
    0xbd12e636, 0x875aa70d, 0x2f32dab0, 0x87efa3de, 0xc2980028, 0xf054001a,
    0x1cfe0025, 0x34c30028, 0x98e18005, 0x3d51c032, 0xa57e2011, 0xd784d01a,
    0x4e447802, 0x5f201439, 0xb9311e32, 0x0eec733c, 0xa11a64be, 0xbc11c0c6,
    0xd8dfbcb1, 0x5d77c4f6, 0xe6cd7abe, 0xdeaab3e7, 0x80000000, 0xc0000000,
    0xe0000000, 0x30000000, 0x38000000, 0x04000000, 0x8e000000, 0x13000000,
    0xa2800000, 0xbf400000, 0x2a200000, 0x4ad00000, 0x54480000, 0x23440000,
    0xb0260000, 0x3fd70000, 0xe9c98000, 0x8c85c000, 0xbc462000, 0x60a37000,
    0xf9911800, 0xcc6cd400, 0xf091da00, 0xdbeb2100, 0x1251ce80, 0x6e083640,
    0x6ce62020, 0x61337030, 0xd1f91838, 0x82f8d40c, 0x007fda0e, 0x6f382101,
    0x4d1e4ea3, 0x3bcaf644, 0xe5818008, 0x5bc1c01f, 0x5a602032, 0x7874701e,
    0x04d8981b, 0xe8a91409, 0x4a77fa0f, 0x5dd8510b, 0x3728d692, 0x74b0e24c,
    0x5239fa05, 0xec9b513a, 0xce0f5693, 0x7ce62277, 0x89305a3e, 0xddfae108,
    0x30f9eea5, 0x99784670, 0x80000000, 0xc0000000, 0xa0000000, 0x10000000,
    0xf8000000, 0x94000000, 0x16000000, 0x47000000, 0x54800000, 0x46c00000,
    0x0a600000, 0xed900000, 0xdd580000, 0x1ac40000, 0xa0660000, 0x70950000,
    0x5cd88000, 0xa183c000, 0x6b42a000, 0x9325b000, 0x67b2b800, 0xd56d6400,
    0xa7ea9600, 0x8e2ae300, 0x1cca5480, 0x259bcec0, 0x5ba2a020, 0x2b75b030,
    0x520ab828, 0x33f96404, 0x7c34963e, 0xdb2be325, 0x214cd485, 0x44d90ed1,
    0x45868035, 0x3542c021, 0xa824202a, 0x4937703f, 0x56ae9809, 0xa80e1423,
    0x36fa0e2d, 0xd9b5f70d, 0x9e6eda82, 0xc168f9f9, 0x71ee5ab8, 0x692f39ef,
    0x584afaa6, 0x9b5f89c7, 0xc5c0c2b7, 0xd0e12dee, 0xc850f4a3, 0x7dba7ee1,
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x88000000, 0x74000000,
    0xa6000000, 0x41000000, 0x89800000, 0xa9c00000, 0xdaa00000, 0xfa700000,
    0xf2280000, 0xcfc40000, 0xbba20000, 0xe3f30000, 0x23ef8000, 0xe9604000,
    0x93d1a000, 0xf6de3000, 0x24a98800, 0x72860c00, 0x0347ee00, 0xf5e76500,
    0xc5961b80, 0xdcbc3d40, 0x81f9a020, 0x891a3010, 0x770b8818, 0x15750c3c,
    0x0ea86e22, 0x2987251d, 0x79c7bba9, 0xc2a20d50, 0xf6702802, 0xa82c3c3a,
    0x5cc4662e, 0xd5266902, 0x82b4759e, 0xd90c186e, 0x60739ba7, 0x412b7d78,
    0x31458012, 0xa2e7403c, 0xe5142028, 0x78f97022, 0xdc9da83e, 0x9ccf7c22,
    0x50d24625, 0xc05c193f, 0x29ee5dad, 0x22672459, 0x80000000, 0x40000000,
    0x60000000, 0x10000000, 0xa8000000, 0x2c000000, 0x52000000, 0x5f000000,
    0x76800000, 0x5a400000, 0xe3600000, 0xadf00000, 0x4a780000, 0x70440000,
    0x18620000, 0xd5730000, 0xa5388000, 0x3ea14000, 0xe7536000, 0x2b299000,
    0xb26e7800, 0xed88f400, 0xb13eb200, 0xa8a00b00, 0xa6535780, 0x40ae47c0,
    0x69ab6020, 0x0e2d9010, 0xf7ec7818, 0xf34bf404, 0x471e322a, 0x38b54b0b,
    0x379a3794, 0xcbf0d7d7, 0xf37f983d, 0xffc72406, 0xada12a20, 0x93d72f2f,
    0xe66a7db8, 0x1b8d68d7, 0xe03b1db2, 0x6b27f8f2, 0x5195e58c, 0xf10a4ccd,
    0x707a3793, 0x2340d7fe, 0x4ce79838, 0x6833242f, 0xb4db2a11, 0xb7102f11,
    0x4348fd9b, 0xdf1b28fe, 0x80000000, 0xc0000000, 0xe0000000, 0xb0000000,
    0xe8000000, 0xe4000000, 0xde000000, 0xbb000000, 0xe8800000, 0x24400000,
    0x4ba00000, 0x7c300000, 0xfd680000, 0xc2440000, 0x8ca60000, 0xa6b70000,
    0xe82d8000, 0xec634000, 0x63512000, 0x02b9f000, 0x82bc5800, 0x42ba0400,
    0xa2bb0200, 0x12bc2d00, 0xfab9f980, 0x1eb84f40, 0xc0b92020, 0x7bbdf030,
    0x933a5838, 0xb77d042c, 0xfcde823a, 0x80eb6d39, 0x7d86d9b7, 0xbfc2bf6e,
    0x3366f81a, 0x95d7b439, 0x7dfbfa2a, 0x919c9933, 0xf2cf8385, 0xf0779649,
    0x72cf83b4, 0x30779677, 0x92cf8398, 0x8077966e, 0x7acf83a8, 0x6477967a,
    0xa4cf838a, 0xdf77966b, 0x4c4f83a4, 0xfb37966f, 0x07ef83b9, 0x87079661,
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x98000000, 0x3c000000,
    0x6e000000, 0x53000000, 0xb2800000, 0xfa400000, 0x50600000, 0x5ed00000,
    0xcc080000, 0x80440000, 0x89620000, 0x8d530000, 0x89c98000, 0x53e0c000,
    0xf313e000, 0xdba87000, 0x98371800, 0x7a9b5400, 0x41293200, 0x86767300,
    0x18fdae80, 0x12fc9440, 0x33fbe020, 0xec7c7010, 0x5fbd1818, 0xe31c540c,
    0x45eab226, 0xba51b30f, 0x494dce9b, 0xc4a32454, 0xeaf4980c, 0x69bc942e,
    0xac19520c, 0xc969c31b, 0xbb12d695, 0x0fac706f, 0x3237aa19, 0x4b9de727,
    0x56af7c96, 0xa1b69766, 0x6e5b56ae, 0xb50cb07e, 0x43c44a36, 0x04a59736,
    0xcaf064a0, 0x39b9c37f, 0x041864ad, 0x6d6dc34c, 0x80000000, 0xc0000000,
    0x20000000, 0x50000000, 0xe8000000, 0x8c000000, 0x92000000, 0x17000000,
    0x26800000, 0x9ac00000, 0xbe600000, 0x6bd00000, 0xfe880000, 0x5cc40000,
    0xef660000, 0xdc510000, 0xf3ca8000, 0xbfe34000, 0x8f926000, 0xce2d9000,
    0x2f763800, 0x9b387400, 0x519db600, 0x7929e300, 0x99f7a680, 0xc9ff2040,
    0x33fa6020, 0x68f99030, 0xfc783808, 0x21bd7414, 0x5159363a, 0x2c4fa323,
    0xfea146a4, 0xdeb4f045, 0xe9dab829, 0xf38a3416, 0x51455627, 0x5927330e,
    0xdbf3fe85, 0xf6fac474, 0xb979ee3f, 0x303c0702, 0xbd1c28bd, 0xe0eeb75d,
    0xa7107096, 0xd9ef537a, 0x5c95feb8, 0x66abc450, 0xf8b36e34, 0xc8df4708,
    0xfc0e48a3, 0x38032775, 0x80000000, 0x40000000, 0xa0000000, 0x50000000,
    0x98000000, 0x5c000000, 0x0e000000, 0xc5000000, 0xe0800000, 0x54400000,
    0x59a00000, 0xb6900000, 0x09d80000, 0x41440000, 0x61220000, 0x1ed50000,
    0x0e7a8000, 0xaad0c000, 0xd478e000, 0x05d17000, 0xf3fea800, 0xe212c400,
    0x8798c200, 0xb7e77d00, 0xf031fc80, 0xf0cefac0, 0x3b5ae020, 0x9e047010,
    0xbd042828, 0x4c820414, 0x92402226, 0x58a60d17, 0x04175483, 0x96983ef1,
    0x3d602218, 0x63760d05, 0x1aef54be, 0xa00c3ef9, 0x74ba2204, 0x82370d17,
    0x2bcfd4b3, 0x26ddfee2, 0x26c2423d, 0x26e7bd38, 0x3ab11c88, 0xc38b8ac9,
    0x817e4800, 0x9d57b43a, 0x0bbc6a04, 0x7db4b922, 0x3009bea3, 0x0cb847c4,
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x38000000, 0xfc000000,
    0xea000000, 0x61000000, 0x30800000, 0xcb400000, 0xf0a00000, 0xb0100000,
    0x31580000, 0x72440000, 0xcc260000, 0x99550000, 0xf4fc8000, 0xdcd5c000,
    0x4139e000, 0xa0365000, 0x12098800, 0x7fb94400, 0x4c773a00, 0xc12a1500,
    0x396ce880, 0xa4481ec0, 0xa59fe020, 0x5e235030, 0x64550828, 0x1e7c8424,
    0xde96da0e, 0x4518453f, 0xcd6360ba, 0x58f45ad8, 0xec6c5a2c, 0x4ac88502,
    0x11de0094, 0x4103cac8, 0x60823222, 0x53469113, 0x9ca232a1, 0x62145bda,
    0xac5a809f, 0xa8c20aca, 0x6665d21e, 0x5971c108, 0x8fa93aa2, 0x1d29dfea,
    0x836eda88, 0x5d4e8fed, 0xf91dd281, 0x47670bfc, 0x80000000, 0x40000000,
    0x20000000, 0xb0000000, 0xf8000000, 0x1c000000, 0x32000000, 0xeb000000,
    0x73800000, 0x21400000, 0x7de00000, 0x55b00000, 0x30880000, 0x42440000,
    0x8a620000, 0xcaf10000, 0xdc6d8000, 0x6b73c000, 0xc62ae000, 0x0d149000,
    0xe6d8d800, 0x96795c00, 0x342a6a00, 0x8612bf00, 0x055b9580, 0xff3cc840,
    0xadc8e020, 0xfda59010, 0xecd55808, 0x25fa9c2c, 0x75688a3e, 0x6bf22f07,
    0x18e94d8c, 0x2bb0947a, 0xc18d0a3c, 0xaec5ef18, 0xbea1ad97, 0xab550479,
    0x42b85212, 0x858f7307, 0x70c127a6, 0xbfa32b64, 0x9fd31fb5, 0xda7ee745,
    0x2e29ad8a, 0x19110450, 0x10da523f, 0xe37e7306, 0x66aca78a, 0x23d0eb57,
    0x1879ffb4, 0x1d2a7750, 0x80000000, 0x40000000, 0xe0000000, 0x50000000,
    0x98000000, 0x1c000000, 0x5e000000, 0xab000000, 0x85800000, 0x3cc00000,
    0xa6600000, 0x23700000, 0xbc880000, 0xd3c40000, 0xc1e20000, 0x5ab70000,
    0xfc6a8000, 0xcdf0c000, 0xa5cae000, 0xf961f000, 0x8cf5d800, 0x414fec00,
    0xd1278600, 0x2ad10300, 0x101ba380, 0xe6fdb840, 0x27c8e020, 0xac66f010,
    0x12775838, 0x300b2c14, 0xcf876626, 0xedc3f307, 0x7ae6fb97, 0xa735946a,
    0x8caf0601, 0xad96c31f, 0x31bbc391, 0x9e6c885c, 0xc8f7d829, 0xa348ec23,
    0x9425061f, 0xcc55c328, 0x2d5b43b8, 0x3e5f487b, 0x57ddb837, 0x1d1adc0c,
    0xc47abe15, 0xb8881f3f, 0xd1c37d8b, 0xd4e39753, 0x243625a3, 0xdd2fbb44,
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x38000000, 0xc4000000,
    0x6e000000, 0x59000000, 0x36800000, 0xb7c00000, 0xb5e00000, 0xc7900000,
    0xc2f80000, 0x62c40000, 0xe1620000, 0x0b550000, 0x9a988000, 0xef15c000,
    0xe43c2000, 0xada27000, 0x13304800, 0xb74d7400, 0xfa4f1e00, 0x7ac91f00,
    0xe009d480, 0x256f53c0, 0xf03e2020, 0x1ba77010, 0x3e30c828, 0xc7ccb404,
    0xe8893e0e, 0x53aa6f31, 0xa75b1c9b, 0x3df6e7d6, 0xd42f9e2d, 0x3a18df3d,
    0x25d7f485, 0xb95823f5, 0xacf6e81e, 0xaeafc439, 0x0fdbf60b, 0x5b33db10,
    0xbb4aa2a5, 0xd84948e7, 0xa1c8a2af, 0x1d8c48dc, 0x572822b1, 0xf39d88cc,
    0xb19602ad, 0x0ffaf8c8, 0xa246cab3, 0xdba64cd9, 0x80000000, 0x40000000,
    0x20000000, 0x70000000, 0x08000000, 0xf4000000, 0x12000000, 0x67000000,
    0x01800000, 0xe8400000, 0xb9200000, 0xb6f00000, 0x5c680000, 0x4d440000,
    0xe7a20000, 0x83310000, 0x9b0b8000, 0x3f944000, 0x9fbda000, 0x69dd9000,
    0x078eb800, 0x55574c00, 0x85586200, 0x654b9900, 0xbbb4ef80, 0x9bce9f40,
    0xbe77a020, 0x74a89010, 0x48a73808, 0x16b20c1c, 0x314e4202, 0x99b2493d,
    0xd4cff784, 0x3bf04359, 0x86eb7a20, 0x6281452a, 0xb3c235a6, 0xe2624a71,
    0x6c532db5, 0x6dd9967e, 0x5d8e7795, 0xe6510375, 0xe6df5a0c, 0xe2099504,
    0xf712ad87, 0xd778d64f, 0x3c3a57b0, 0x8e99d348, 0x1b2fc21a, 0x61e3093b,
    0xfb13d7bb, 0x797c934c, 0x80000000, 0x40000000, 0xa0000000, 0xd0000000,
    0x88000000, 0x54000000, 0x96000000, 0x31000000, 0x7f800000, 0xfec00000,
    0x91200000, 0x85500000, 0x24c80000, 0xbdc40000, 0xf1a20000, 0x99150000,
    0xaeae8000, 0x2c704000, 0x4d98a000, 0xa30db000, 0xe7610800, 0x6c30bc00,
    0x45fed600, 0x35bef900, 0xc5dd4280, 0x5f6fca40, 0x37d2a020, 0xf78cb010,
    0x5d258828, 0x2f51fc34, 0xa7caf622, 0x3d460915, 0x9de26aa5, 0x4b76864c,
    0xe31fde3f, 0x524e452f, 0xd083948c, 0xa4413355, 0x2667e28b, 0x0bb77a6a,
    0xc73d2811, 0xb69c4c0e, 0x6f8bfe3e, 0x6126b515, 0x9d54bcb0, 0x58cc7f50,
    0xafc09caa, 0xdea48f57, 0x8397b49e, 0xb9e9c351, 0x7290ca9d, 0x266a3663,
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x68000000, 0x3c000000,
    0x52000000, 0xf7000000, 0x69800000, 0x66400000, 0x91600000, 0x20b00000,
    0x52580000, 0xf7440000, 0xb1e60000, 0xf2710000, 0x5ff98000, 0x4f574000,
    0xad2fe000, 0x2a3f9000, 0x93743800, 0x377f0c00, 0x91965200, 0x9a8adb00,
    0x59291d80, 0xb4392ec0, 0x7e71e020, 0xa5fa9030, 0xa453b808, 0xa6ad4c0c,
    0xd37e321a, 0x57970b0f, 0x238d4594, 0xa5aff2fd, 0x24fdea3a, 0xdcd39729,
    0x20692fac, 0xb0db25c4, 0x4a8325ae, 0xa1c322c2, 0x72203210, 0x1f520b3d,
    0x152ac59f, 0x6e3db2c9, 0xa5758a21, 0xc67e4700, 0x611577b6, 0x3049f9d8,
    0x30892f8c, 0x0a2b25f4, 0xfbbb258d, 0xb13722ca, 0x80000000, 0xc0000000,
    0xe0000000, 0x70000000, 0xa8000000, 0xec000000, 0xb6000000, 0x95000000,
    0xef800000, 0x61c00000, 0x55200000, 0x90700000, 0xc3480000, 0x36c40000,
    0xfda60000, 0x41370000, 0xe32b8000, 0xacd14000, 0x2ff96000, 0x332eb000,
    0x54d52800, 0xfbfb3c00, 0xb12cee00, 0x33d3d900, 0xdb7b0b80, 0x1c6b3640,
    0x7db76020, 0x906db030, 0x7bb0a838, 0x4d697c1c, 0x08300e2a, 0x32af293b,
    0x2412c3ad, 0xfb5cfa65, 0x139a461b, 0x773da528, 0x1f8885ad, 0xa0615f78,
    0x5a12c3ba, 0x325cfa46, 0x021a460a, 0x1ffda519, 0xbb288591, 0x28d15f54,
    0x95fac3b9, 0x6028fa46, 0x8654462b, 0x99bea522, 0x33cd05af, 0x63831f47,
    0x67c6238c, 0x88240a6b, 0x80000000, 0x40000000, 0xa0000000, 0xb0000000,
    0xd8000000, 0xd4000000, 0x2a000000, 0xd3000000, 0x62800000, 0xcbc00000,
    0x59e00000, 0x64500000, 0x07f80000, 0x89440000, 0x62220000, 0x45b50000,
    0x07ad8000, 0x7cbac000, 0xec60a000, 0x6f165000, 0x5ade1800, 0x40745400,
    0x3f4c3e00, 0xdd6c3f00, 0xd8df6a80, 0x7f7073c0, 0xb3cd2020, 0x87ac9010,
    0x3cbeb828, 0x4c62042c, 0xdf122636, 0x82d86b35, 0x9473548a, 0x154c4cf4,
    0x0e6a4ab8, 0xba58e3e2, 0xb4b1981e, 0xea2b9425, 0xe3f91e1f, 0x3b44af3b,
    0xc523d2a4, 0xbd3777d0, 0xc76a8633, 0x93da3b09, 0x69f74c9d, 0xe20918dc,
    0xd549f497, 0xee6b1cce, 0xaa5bd294, 0xdcb377cc, 0xe6288609, 0x1dff3b2a,
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x48000000, 0x84000000,
    0x76000000, 0x03000000, 0xa1800000, 0x00400000, 0x0ca00000, 0x46f00000,
    0xfd480000, 0x85c40000, 0x6ae20000, 0x51530000, 0xe6398000, 0xc2ce4000,
    0x12822000, 0xa9c2b000, 0xe8e29800, 0x0c56cc00, 0xf0be6200, 0x5d0bf500,
    0x99679f80, 0x3413fe40, 0x501ba020, 0xd9fcf010, 0x5928b818, 0x97507c0c,
    0xed3efa12, 0x874e3921, 0x54c07d9d, 0xee664b40, 0x8b961f88, 0x8759be50,
    0x7adb803b, 0xd09d400d, 0x353ba035, 0x5b4cf00c, 0xbec0b815, 0x67647c35,
    0x9314fa0c, 0xd7993930, 0xa2bbfdaf, 0x380b0b7b, 0x23e5bfa6, 0x69d14e63,
    0xe6f93821, 0x62aa3c3e, 0x3616da0f, 0x4d1b8904, 0x80000000, 0xc0000000,
    0x60000000, 0x10000000, 0xe8000000, 0x14000000, 0x22000000, 0x8d000000,
    0x19800000, 0xf7c00000, 0x69200000, 0x14700000, 0x78980000, 0xaa440000,
    0xf4e60000, 0x94530000, 0xaf688000, 0x541b4000, 0x1802a000, 0x2c041000,
    0xbe07e800, 0xab070c00, 0x5e805e00, 0x7742f900, 0xa565db80, 0x079760c0,
    0x1c4a2020, 0x316f5030, 0x4f1d4818, 0xde871c04, 0xb741b63a, 0xc566f505,
    0x17950588, 0xf44ad9e3, 0x256b5ba6, 0x6d1f20cd, 0x53800022, 0xaec00031,
    0x32a0003c, 0x7eb0002b, 0xe038000f, 0x5df40003, 0xc75e0025, 0xa767000b,
    0x3a96801a, 0x9dcc4033, 0x2aac202b, 0xf83c5005, 0x71f5c834, 0x795c5c12,
    0x0c63163f, 0x6412e531, 0x80000000, 0xc0000000, 0x20000000, 0x50000000,
    0x58000000, 0x4c000000, 0x2e000000, 0x59000000, 0x57800000, 0x2b400000,
    0x14a00000, 0xb4100000, 0x3ac80000, 0x32c40000, 0xd6e60000, 0xdf310000,
    0xe19a8000, 0x26aec000, 0x6b306000, 0x139e7000, 0x29ad4800, 0x79b0fc00,
    0x195efa00, 0x034c3500, 0xa0845880, 0xe5c60240, 0x4862e020, 0xdbf4b030,
    0xc27b2808, 0xf01f8c14, 0xf0e93216, 0x62120913, 0xbfcac28b, 0x33444756,
    0xb8a3f0b5, 0xea164e7a, 0x6bc9322d, 0x71420909, 0x9fa2c290, 0xbc90474b,
    0x5b0df088, 0x60a34e42, 0x6615b20e, 0x65cdc931, 0x78402294, 0x9024f764,
    0xdbd6d8bc, 0x61acc24a, 0x8db4800b, 0x0b5bc003, 0x7c4ce02b, 0xba01b027,
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x68000000, 0xcc000000,
    0xae000000, 0x27000000, 0xf7800000, 0x98c00000, 0xa7a00000, 0x5fb00000,
    0xdba80000, 0x09440000, 0x64620000, 0xe9910000, 0x07df8000, 0x44cf4000,
    0x41506000, 0xa87e7000, 0x077bb800, 0xacfd7c00, 0x223ee600, 0xf69ead00,
    0x54ad7580, 0x52c5f940, 0x82a7e020, 0xf1353010, 0x0be9d808, 0x65a20c3c,
    0x66b2de1a, 0x43289133, 0x5a01f3ab, 0x9d042449, 0xfa86ad9d, 0xda46f576,
    0x29e2be01, 0x7c56e13b, 0xe2fa4ba4, 0x9539584d, 0xb9184b88, 0x98685850,
    0xff67cbbf, 0x98171852, 0x541fabb6, 0x4aed6844, 0xc9261387, 0xeff11468,
    0x674f7583, 0x9394f975, 0x6ad86000, 0xd64a7018, 0x80000000, 0x40000000,
    0x60000000, 0xb0000000, 0x68000000, 0xdc000000, 0x96000000, 0xb9000000,
    0x1c800000, 0x0f400000, 0xefa00000, 0x80300000, 0xba680000, 0xddc40000,
    0xade20000, 0x59130000, 0xaa1d8000, 0x458f4000, 0x3fd0e000, 0x387db000,
    0xf85f4800, 0x64a82400, 0x4ba0da00, 0x3231ad00, 0xf168b980, 0xea44df40,
    0x25256020, 0x5676f010, 0xf94da818, 0x3ab6942c, 0x242a121a, 0x92e2c937,
    0x049283a5, 0xdddfc26e, 0x376d11a7, 0xcb464b53, 0xeda57203, 0xa333391c,
    0x51e8abac, 0xc301166c, 0x1b8063b4, 0x16c1725f, 0xda67d9b0, 0xb1d52f40,
    0x157f4811, 0x7ed82426, 0x9ce8da0c, 0xb585ad3b, 0xebc2b9af, 0x84e3df77,
    0xfd92e004, 0xa15eb020, 0x80000000, 0x40000000, 0xa0000000, 0x50000000,
    0x38000000, 0xd4000000, 0x16000000, 0xd9000000, 0x6a800000, 0xe9400000,
    0x73200000, 0xe1700000, 0xa1b80000, 0x71c40000, 0xdd620000, 0x3dd50000,
    0x690a8000, 0x691dc000, 0x4f70a000, 0xecbfb000, 0xad454800, 0xbd221400,
    0x1c752a00, 0xb53f0900, 0xad84b380, 0x06c431c0, 0xfae22020, 0x08167010,
    0x7a6fe828, 0xa9cca414, 0x32f8e20e, 0x59e5dd35, 0x3993b985, 0x96ad48f6,
    0xd0297bba, 0x1b6ee5ea, 0x574d2a14, 0x6dbb093c, 0xa3c6b38e, 0x8a6131fd,
    0x0a50a01c, 0xc4cfb01c, 0xfe7d482d, 0xa1a61402, 0x9c372a1b, 0x649a090c,
    0x19b6339a, 0x2e5df1fd, 0x71508022, 0xd14cc014, 0x6cb82032, 0xed477038,
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x88000000, 0xd4000000,
    0xce000000, 0xfb000000, 0xb8800000, 0xc3400000, 0xa4e00000, 0xe8500000,
    0x8ab80000, 0x69c40000, 0x46a60000, 0xa1330000, 0xb22a8000, 0xb4584000,
    0x7494a000, 0xef9b7000, 0xe3325800, 0x1b2d0400, 0x8ddbfa00, 0x6a557700,
    0x43bfaa80, 0x004569c0, 0xd0662020, 0xd9173030, 0x9f58f818, 0x84117414,
    0x98dd2222, 0xd9d73335, 0x807c70b3, 0x6be02efe, 0x0ed5f28e, 0x5afc6dc0,
    0xf1a3da11, 0x2bb5471e, 0xa06bd298, 0x453f5dfb, 0x40052220, 0xa0033313,
    0x300270a9, 0xd8072ef7, 0x5c017298, 0x1a032df4, 0x3503fa38, 0x4381773c,
    0x7bc1aa84, 0x67a269f9, 0x4cb2a035, 0x62e87004, 0x80000000, 0xc0000000,
    0xa0000000, 0xd0000000, 0x08000000, 0x9c000000, 0x32000000, 0xeb000000,
    0xa0800000, 0xc1400000, 0x1f600000, 0xc2700000, 0xc7e80000, 0x37c40000,
    0x83260000, 0x90950000, 0xf15e8000, 0x5f8c4000, 0x7f36e000, 0x5a8a9000,
    0x66b0d800, 0xa04dc400, 0xc013aa00, 0x281d0b00, 0x74e99b80, 0xc3440340,
    0x4c606020, 0x86f2d030, 0x70a83828, 0x65a65434, 0xa4d3f202, 0xefbd8f27,
    0x533c518c, 0x607ed87a, 0x341f4388, 0x86ecc740, 0x88454a0f, 0x3ce79b34,
    0x4fb1439b, 0xf3cdc75e, 0x95d5ca0e, 0x883adb09, 0x78ff23b0, 0x115e1769,
    0xef8d7212, 0x0731cf01, 0x1e8ab18b, 0xc0b4485b, 0xe54f9bab, 0xb9910344,
    0xa2dee002, 0x0a4e900d, 0x80000000, 0x40000000, 0xe0000000, 0x30000000,
    0xf8000000, 0x14000000, 0x32000000, 0x1d000000, 0xa2800000, 0x60400000,
    0xa4200000, 0x07f00000, 0x93080000, 0xffc40000, 0xf6e20000, 0xeb970000,
    0xecd98000, 0xb53bc000, 0xa12ea000, 0x6f309000, 0x2e6c6800, 0xd4905400,
    0x3b5fe200, 0x4bf8d100, 0x8b4e6780, 0x0fe63440, 0x23152020, 0x559c5010,
    0x499b4838, 0x379b040c, 0xdc9d2a3e, 0x99181505, 0xaadded8c, 0xea3eb147,
    0x06aca588, 0x89f6b548, 0x200a0fb1, 0x7e42605d, 0x3f20c202, 0x5a778126,
    0x84ceafb7, 0x7521f074, 0x13772a01, 0xf44b1527, 0x38666d9d, 0xedd27149,
    0x87fb85b0, 0x3d4de546, 0x08e0c7aa, 0x4096a44d, 0x4959480e, 0xb6fc042a,
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x78000000, 0x6c000000,
    0x1e000000, 0x55000000, 0x77800000, 0x3cc00000, 0xcc200000, 0xd9100000,
    0x51e80000, 0xce440000, 0x4f620000, 0x9df50000, 0xc6df8000, 0x75bfc000,
    0x9e4d6000, 0x4993f000, 0xb1aa2800, 0x4c26fc00, 0x9914c600, 0xf1eb3100,
    0x3e447080, 0x3762ab40, 0xf1f0e020, 0xd8d93010, 0x20b8c828, 0xe9cacc3c,
    0x75538e1e, 0x7d8e3d1b, 0x95329e87, 0xc8fb6655, 0x3faa56bd, 0x7121aa5f,
    0xaa91d8bb, 0x372b975a, 0xad614602, 0xbef5f104, 0xa05c90a2, 0xc4ff9b55,
    0x31aa2815, 0x0c26fc0c, 0x3914c626, 0x01eb3102, 0x46447088, 0x5b62ab42,
    0xeff0e035, 0x8dd9301b, 0x5738c80c, 0xd50acc37, 0x80000000, 0xc0000000,
    0x60000000, 0x30000000, 0x48000000, 0x4c000000, 0xe2000000, 0x0d000000,
    0x44800000, 0x29400000, 0x03200000, 0xb8d00000, 0xebe80000, 0xc8c40000,
    0xd2e60000, 0x58b30000, 0x21198000, 0x757e4000, 0x99886000, 0xe7361000,
    0x37dce800, 0xa09ee400, 0x94baea00, 0x31ee2900, 0x61c05e80, 0x6864c340,
    0xe6f7e020, 0x6fbb5030, 0x0e6d0818, 0xb706b40c, 0xdd866212, 0xdbc2dd13,
    0xf1605cb8, 0x14770e43, 0x9dfcd4b1, 0xa2cbfa7a, 0xc114d6b8, 0xb78c3752,
    0xc831e210, 0x1e5b9d1d, 0xfd5fbc86, 0xf6d85e4a, 0xc61fdc93, 0xd0fa4e77,
    0x464d34b7, 0xb853aa62, 0xcca85e8c, 0x74e0c351, 0x5bb1e039, 0xda98502a,
    0x6dbc883d, 0xf36cf435, 0x80000000, 0xc0000000, 0x20000000, 0x30000000,
    0x58000000, 0x54000000, 0x06000000, 0x61000000, 0xd0800000, 0x2dc00000,
    0x96a00000, 0x59d00000, 0x07b80000, 0x88440000, 0x8de60000, 0x93b10000,
    0x70498000, 0xf7eec000, 0xc6b8a000, 0xa8c33000, 0xd8258800, 0x6114c400,
    0x77988e00, 0xc550e500, 0x987d5680, 0x69e081c0, 0x0db72020, 0x654cf030,
    0x116ca808, 0xd27d340c, 0xbae3a616, 0xaa361115, 0x9109d081, 0x768a60d8,
    0x62ca5894, 0x152fa4fb, 0xcd9b568d, 0x6e5181ea, 0x5bfea03f, 0xc3a2300b,
    0x5f54083c, 0x037e0425, 0xf2662e3f, 0xf3f2d53b, 0x31a95ea1, 0x165e85ef,
    0xe1f10e06, 0xb6ae2517, 0xb7ddf692, 0x74b7b1ed, 0x01cca82e, 0x2aad3404,
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x88000000, 0x54000000,
    0xfa000000, 0x37000000, 0x21800000, 0x60c00000, 0x30200000, 0x91300000,
    0x1bb80000, 0x92440000, 0x43620000, 0x42d70000, 0x51298000, 0xc7084000,
    0x8f3ca000, 0x9806d000, 0x4c053800, 0xf603cc00, 0x21046600, 0x3080b100,
    0xd8404180, 0xbc67b9c0, 0xd7572020, 0xfbe99010, 0x48281838, 0x6b895c0c,
    0x197ffe22, 0xd962ad15, 0x05d09fbe, 0x18a884cd, 0xc3cda7a8, 0xcd1f48c8,
    0x6a33c194, 0x8c3cf9f8, 0x3380003c, 0x73c0002d, 0x83a00034, 0xa2f00004,
    0x78180000, 0x00b40031, 0xb37a0019, 0x16630017, 0x18538011, 0xe66b4025,
    0xb6ef2012, 0x1ead901c, 0xcaca1834, 0x799e5c2a, 0x80000000, 0xc0000000,
    0xa0000000, 0x50000000, 0xe8000000, 0x2c000000, 0xce000000, 0xdf000000,
    0x74800000, 0xa0400000, 0x10a00000, 0x19f00000, 0x28880000, 0x4fc40000,
    0xe6660000, 0x18150000, 0xda5a8000, 0x427b4000, 0x1dcb6000, 0x76e17000,
    0xca577800, 0x93fb6400, 0x8c0da200, 0xc782d500, 0x7ac22780, 0x9fe5e840,
    0xc5d7e020, 0x553f3030, 0x95ee9828, 0xa1555414, 0x7d7fba3a, 0x5949c10b,
    0xcea47db3, 0x4ef21977, 0x800985bd, 0x99823d58, 0xedc7478c, 0x97659862,
    0x43941838, 0xb69e143c, 0x369cda18, 0xf69cb12e, 0x569d05a2, 0x06987d44,
    0xee98a78d, 0xc29ea874, 0x0c9c8029, 0xd39e403d, 0xa719e006, 0x075e303d,
    0x17fa1812, 0x0e0f141e, 0x80000000, 0xc0000000, 0x60000000, 0xb0000000,
    0x08000000, 0x24000000, 0x0a000000, 0xbd000000, 0x75800000, 0xfbc00000,
    0xaa600000, 0xf9100000, 0x1bc80000, 0x3f440000, 0x1a260000, 0xc7b30000,
    0x1c3d8000, 0x75dc4000, 0xfc0b2000, 0x73215000, 0x10356800, 0xaefd6c00,
    0x183f3e00, 0x6fde6300, 0x990a5080, 0x9aa24a40, 0xcdf0a020, 0x979e1030,
    0x23abc818, 0x47547c2c, 0x826f7602, 0x28355f09, 0x42fb8682, 0x563e056f,
    0x68db6ebd, 0x598b294e, 0x30e17092, 0x96531a62, 0x79edc83c, 0xb4f77c1a,
    0x981af61e, 0x0d6d1f3b, 0x0cb6a69a, 0x82bc5545, 0x009b86aa, 0xfb2e0543,
    0x11136e8d, 0x4fcf2978, 0x5d477096, 0x33201a4e, 0xb0304819, 0x7efb3c3f,
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0xb8000000, 0x4c000000,
    0x26000000, 0xb7000000, 0x86800000, 0x64c00000, 0xcd600000, 0xde700000,
    0xa2280000, 0x71440000, 0xdd260000, 0xdad70000, 0x8ebc8000, 0xac59c000,
    0x4b686000, 0x90643000, 0x09f03800, 0x176a7400, 0xce640600, 0x12f6fb00,
    0x27ef1b80, 0xa5a52d40, 0x1512e020, 0xbb5af030, 0x7decd838, 0x3ca38424,
    0xa0925e2e, 0x1b1bbf13, 0xb149a589, 0x7433626d, 0xaf8b1d81, 0x5053d669,
    0xec7dfbab, 0xa63fdd63, 0x3b9e381e, 0xa289741b, 0xdfd68628, 0x853c3b2c,
    0x871dfba5, 0x0f4fdd4c, 0xff363829, 0x270d7417, 0x77908600, 0xcd9b3b13,
    0x8d897bb1, 0x65521d4a, 0xeff8581c, 0x097e4435, 0x80000000, 0xc0000000,
    0xe0000000, 0x30000000, 0xe8000000, 0xb4000000, 0x22000000, 0x45000000,
    0xed800000, 0x25400000, 0xa1600000, 0xa8100000, 0xee480000, 0x9bc40000,
    0xcea60000, 0x64b70000, 0x1ff98000, 0xb1bb4000, 0x065fa000, 0x558c1000,
    0x8566a800, 0x7210ac00, 0x274d4a00, 0x38437b00, 0xd0e29880, 0xfb518640,
    0x18282020, 0x73545030, 0x5c2e8838, 0x5954fc0c, 0x9d2bc23a, 0x7ed3872d,
    0x496f5a88, 0x10350151, 0x813efa9b, 0xb29a1179, 0x97afd2b0, 0x3312fd56,
    0xc0cab899, 0x0c05d677, 0x8e06a819, 0xdb00ac19, 0x0e854a36, 0x47c77b15,
    0x98a498a0, 0xe3b6864a, 0x8779a021, 0x917b1038, 0x367f282a, 0x7efbec1e,
    0x863aea29, 0xea1b6b2a, 0x80000000, 0xc0000000, 0xe0000000, 0x30000000,
    0xd8000000, 0x94000000, 0x52000000, 0x49000000, 0x7e800000, 0xfa400000,
    0x35e00000, 0x45700000, 0xf6780000, 0x5bc40000, 0x82260000, 0x11570000,
    0xf4298000, 0xe46ac000, 0xfc8ea000, 0xad7f9000, 0x4c46c800, 0xd6e5b400,
    0x36f33200, 0xc8b8df00, 0x91649380, 0x4a363fc0, 0x43192020, 0x5bf65030,
    0xfc3fe838, 0x5623e40c, 0x6354da36, 0x6d2f3b25, 0x72ee4994, 0x4aca04d2,
    0x5e98e9bf, 0x123194ce, 0x17182195, 0xe9f320ed, 0x853a9393, 0xf0a53fcf,
    0x0d16a01a, 0x0acb900f, 0x7e98c838, 0xc236b43c, 0xff1cb20f, 0xa5f51f33,
    0x433bb3a8, 0xeba76fde, 0x3a974822, 0x8e0b743f, 0xb13b9231, 0xb2a04f24,
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x18000000, 0x1c000000,
    0xae000000, 0x8f000000, 0x90800000, 0x7bc00000, 0x4ee00000, 0xbc300000,
    0xc0380000, 0x1e440000, 0xc0a20000, 0xc4970000, 0xa8aa8000, 0x50ecc000,
    0x1b4ee000, 0xfd5c7000, 0x0f37f800, 0x0ebbc400, 0x42827e00, 0x4ac7a700,
    0xa963c980, 0x1b71edc0, 0x431e6020, 0x7f93b010, 0x82299838, 0xee287414,
    0xa82be606, 0x932fd307, 0xf9a82fab, 0xa76e3ee3, 0x440e4f84, 0x32798ece,
    0xd8e5d78b, 0xdf36faeb, 0x56bcb1ae, 0xbe81e9c4, 0xb4c07e05, 0x3e60a711,
    0x97f1499b, 0x96d92dfa, 0xbe72803c, 0xae98c03a, 0x55d4e017, 0xf88f7002,
    0xefbf7821, 0xfd000412, 0x11861e38, 0xd4471728, 0x80000000, 0x40000000,
    0x20000000, 0xd0000000, 0x28000000, 0xb4000000, 0x22000000, 0xa7000000,
    0x0b800000, 0xf3c00000, 0x64200000, 0x7b700000, 0xd5880000, 0x74240000,
    0x33720000, 0x91890000, 0xae228000, 0x08734000, 0x0c0ca000, 0xd8e39000,
    0xc0d67800, 0x8f3cfc00, 0x9a8c0e00, 0xaba15900, 0x12b52780, 0xaaafa240,
    0x42d67820, 0xb83cfc10, 0x990c0e08, 0x3c615934, 0x7c95278a, 0xc2dfa26d,
    0xbede7828, 0x98d8fc39, 0xc5de0e0a, 0x25585908, 0x631fa793, 0xc5f8e273,
    0x5428d81d, 0xa5966c24, 0x9858f606, 0x339ee52c, 0x5bbd89b8, 0xbec96b71,
    0x8a47279e, 0x58e6a252, 0x80d4f816, 0xaf3fbc1f, 0x4a88ae16, 0x83a6c92f,
    0xa6b15fb0, 0x88aa5e45, 0x80000000, 0xc0000000, 0x20000000, 0xb0000000,
    0x38000000, 0x54000000, 0x4e000000, 0x17000000, 0x6a800000, 0x6b400000,
    0xa2a00000, 0x80b00000, 0x06280000, 0xdaa40000, 0x34b60000, 0xd8290000,
    0x45a18000, 0x3237c000, 0xa96ba000, 0xbe03f000, 0xcf077800, 0xae80f400,
    0xad44aa00, 0xd9a46d00, 0xf035f180, 0x34691b40, 0x05877820, 0xb5c0f430,
    0x17e4aa08, 0xbd146d2c, 0x801df18e, 0xadcd1b55, 0x15b17833, 0x11a9f435,
    0x9a652a12, 0x64d3ad36, 0x8dfe51a6, 0x49daeb75, 0xe8280032, 0xbda40003,
    0x4636001f, 0x57690000, 0x91018037, 0xf187c039, 0x8bc3a038, 0x18e7f01c,
    0x33917824, 0x9d59f407, 0x4c6d2a12, 0xb187ad1a, 0x6bc05197, 0x88e7eb54,
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x18000000, 0xe4000000,
    0xf2000000, 0x85000000, 0x0e800000, 0xb1c00000, 0xf5200000, 0x9c100000,
    0x05e80000, 0x3d240000, 0x30160000, 0x9beb0000, 0x46238000, 0xb596c000,
    0xb7ac2000, 0x7b441000, 0xe6e2e800, 0x64345400, 0x9b7d9e00, 0x870f4100,
    0x6b11b480, 0x4e6f3140, 0xe262e820, 0x84f45430, 0xeadd9e18, 0x3bdf413c,
    0x7f59b486, 0x3f9b3179, 0xde3ce81c, 0x8aeb5411, 0x62a01e1b, 0x05568110,
    0x4e0814bb, 0xcb96e15e, 0xfcafa01d, 0x86c2d01e, 0xdea6c817, 0xb3544436,
    0xa909762a, 0xa8101533, 0xbfefaa90, 0xd426b070, 0xc0977c96, 0xa12b7563,
    0x2e839e32, 0xe1c04127, 0x7d2434a8, 0x9012f147, 0x80000000, 0x40000000,
    0x60000000, 0x50000000, 0x58000000, 0xdc000000, 0xe6000000, 0x89000000,
    0x74800000, 0xa8400000, 0x7b200000, 0xb2100000, 0xb8b80000, 0x47240000,
    0x44120000, 0x09bb0000, 0xbfa68000, 0x5250c000, 0x279de000, 0x9f31b000,
    0xcbac8800, 0x6f1a4400, 0xc176f200, 0x018c5100, 0x258d5480, 0x6f89f7c0,
    0x688c8820, 0x410a4410, 0xffcef218, 0x9fa85114, 0x4d1f5496, 0x1272f7f7,
    0x4a0a0819, 0x284a8432, 0x146b1205, 0xeffde13e, 0xb981dc88, 0xc6c3b3db,
    0x8c627a37, 0x3cb21523, 0x5269a694, 0x16fea6fc, 0xa5075c87, 0xba8373df,
    0x95479a26, 0x3da7a510, 0xf1572eb0, 0x041fe2d0, 0x46f72e8e, 0xd24fe2fd,
    0x5b6f2eb2, 0x227be2e1, 0x80000000, 0x40000000, 0xe0000000, 0xf0000000,
    0xe8000000, 0xb4000000, 0x02000000, 0xf1000000, 0xa4800000, 0x50c00000,
    0x73a00000, 0xb0500000, 0x68180000, 0xb7a40000, 0x1a520000, 0xcd1f0000,
    0xe1238000, 0x53954000, 0xae3aa000, 0x03b39000, 0xb92ac800, 0x0d4b8400,
    0x213b1600, 0xb0325500, 0x466f8680, 0xd7aa16c0, 0x488ac820, 0x0c1b8410,
    0x0da31638, 0xa756553c, 0xc79d86ba, 0x1ee516ed, 0xc3b14820, 0x192ac42c,
    0x1d4bb611, 0x393ac528, 0xec34cea6, 0xf06bd2c1, 0x24a8fe3a, 0x1d0f0101,
    0xf85cf897, 0x2ec457db, 0x64a690be, 0x1fd743c5, 0xc15ecea9, 0x6e40d2fd,
    0xce617e23, 0x31714125, 0x8b8fd8ae, 0x119987f9, 0x5de77893, 0x9e3517cd,
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x68000000, 0x7c000000,
    0xa2000000, 0x69000000, 0x63800000, 0x24400000, 0x18600000, 0x55500000,
    0x9ff80000, 0x5c640000, 0xd3520000, 0xe0fd0000, 0xf8e78000, 0x37914000,
    0xaa5ee000, 0x50129000, 0xa81a0800, 0x4771fc00, 0x31cdb200, 0x4049cb00,
    0x850fd680, 0x52e88dc0, 0x99fa0820, 0x6361fc10, 0xd7d5b228, 0x743dcb1c,
    0xda45d69a, 0xe3618ddf, 0x97d78808, 0xd439bc0a, 0xaa46d230, 0x8b671b15,
    0xebd4be9c, 0x763ea1ca, 0xc341522f, 0xe8e65b1d, 0xcf925e84, 0x6e5831ed,
    0x96115a02, 0x771ea717, 0x93f26c8d, 0xbd09bac5, 0x76edecbc, 0x8ffcfaef,
    0xa4610c94, 0x17536ade, 0x26fc84a6, 0x27e3d6cd, 0x80000000, 0xc0000000,
    0xe0000000, 0xb0000000, 0x18000000, 0xdc000000, 0x16000000, 0x1f000000,
    0x3a800000, 0x55c00000, 0x9e200000, 0x72d00000, 0x4c980000, 0x10240000,
    0x71d60000, 0x801f0000, 0xeae18000, 0xcd76c000, 0x7b09e000, 0x2e593000,
    0xb0823800, 0x7cc63400, 0xeba09e00, 0xb5914900, 0x437c6280, 0x36d29ac0,
    0x469a3820, 0xf9223430, 0xe4569e38, 0xf75e492c, 0xfd05e286, 0x37805af7,
    0x5a45d825, 0x48640437, 0x84b52636, 0x132ebd39, 0xf38c9ca1, 0xde9823eb,
    0xe52382b6, 0x1254aaf3, 0x5859800a, 0xdf82c029, 0xbe47e023, 0xd2623034,
    0x25b5b80e, 0xf2aff43f, 0x56c8fe3b, 0x1c7eb92d, 0x2c57baa9, 0x435d9ed7,
    0xcf009e1a, 0x5281492e, 0x80000000, 0x40000000, 0x60000000, 0x70000000,
    0xe8000000, 0xe4000000, 0x7a000000, 0xb3000000, 0xd6800000, 0x93c00000,
    0x16200000, 0x79900000, 0x43780000, 0x24240000, 0x7e920000, 0x17fb0000,
    0x78e78000, 0xc8354000, 0xd0ac2000, 0x323c5000, 0x63c4d800, 0xbe209400,
    0xfd97ce00, 0x4979e900, 0x7f211880, 0x4c1075c0, 0xfe3cd820, 0xddc49410,
    0x6725ce18, 0x0012e91c, 0x003e98ba, 0x64c135f9, 0xeaa2f83e, 0xa153c43c,
    0xffde962d, 0xb8733d38, 0x06cf76bf, 0x55cb8ce7, 0xb34ab8ae, 0xa88965f5,
    0x2aac2012, 0xc13c502d, 0xd544d839, 0x5de09409, 0x03b7ce00, 0xd4e9e910,
    0x465918ac, 0xdb3475e2, 0x562ed831, 0x59ff940a, 0x09e24e26, 0xb1b7a914,
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xb8000000, 0xc4000000,
    0xca000000, 0x89000000, 0xa9800000, 0x50c00000, 0x81600000, 0x6d500000,
    0xf1c80000, 0x0f640000, 0xee560000, 0x714d0000, 0x46218000, 0x87f3c000,
    0x597b2000, 0x10bfd000, 0xf05b8800, 0x11cc6c00, 0xdf665600, 0x46530300,
    0xbd4d4680, 0xf0213840, 0x00f38820, 0xb3f86c30, 0x60f85628, 0x887a032c,
    0xad3ac6ae, 0xc29ff871, 0xd5a92812, 0xadb47c12, 0x6058fe02, 0xd9c9bf38,
    0x0367188e, 0xf850976a, 0x464a38ae, 0x14a24751, 0x33b03099, 0xeb5deb54,
    0x254d4697, 0x44213857, 0xd2f3883e, 0x4ef86c08, 0xbb785619, 0x95ba0333,
    0x4fdac6b0, 0x760ff86c, 0x0c81281d, 0x9f407c26, 0x80000000, 0xc0000000,
    0x20000000, 0xd0000000, 0xa8000000, 0x8c000000, 0x6e000000, 0x4f000000,
    0x09800000, 0x43400000, 0x83e00000, 0xa5b00000, 0xdd580000, 0x11e40000,
    0x3cb60000, 0x9fd90000, 0x69228000, 0x75134000, 0x730d6000, 0x3509f000,
    0x360d3800, 0x718f2c00, 0xadccea00, 0x8faea700, 0xe559c180, 0xd5e320c0,
    0x2eb53820, 0xc6db2c30, 0x0ba2ea08, 0xddd3a734, 0x92ad41aa, 0x55d960e3,
    0x0422d83b, 0x7d959c23, 0xa6ccb20a, 0x54287b24, 0xdf18138a, 0xe482abca,
    0x8bc0138c, 0x7626abe7, 0x149613a5, 0x9c4fabf3, 0x08ec93b8, 0x74b8ebd3,
    0x2957f3b2, 0x91681bfd, 0x7ff84b99, 0xd6b477df, 0x22d9c18a, 0xc9a320f3,
    0x2cd53829, 0x7c2b2c31, 0x80000000, 0xc0000000, 0x60000000, 0xb0000000,
    0x48000000, 0x24000000, 0xbe000000, 0xa7000000, 0xda800000, 0x5a400000,
    0x94200000, 0xff300000, 0x12d80000, 0xd6240000, 0x9a360000, 0x6d5b0000,
    0x93e18000, 0xfbd44000, 0xbb8a2000, 0x73ec7000, 0x73fd7800, 0x0e96f400,
    0x712fa200, 0xb8995900, 0xaa05cd80, 0x9101d4c0, 0x39857820, 0x8ec2f430,
    0x2161a218, 0x9596592c, 0x09aa4d92, 0xf7da94c9, 0x69a0d80f, 0xbff5c419,
    0xbcb97a2e, 0x0d379d3a, 0x3fdd37b7, 0x8da209f6, 0x61f26f8b, 0xabbc8dec,
    0x9fb6b5a8, 0x419820d1, 0xa7855a2b, 0x39c0ed14, 0x63e1cf8f, 0x13d0bde5,
    0x4f8fed91, 0x35eda4de, 0xb8f8003c, 0x4e14000c, 0x326e0019, 0x513f0001,
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xf8000000, 0xf4000000,
    0x9a000000, 0x41000000, 0xf4800000, 0xa4400000, 0x56600000, 0x97700000,
    0x81980000, 0xd7640000, 0x03f20000, 0x75d90000, 0x09078000, 0x9885c000,
    0x9a46a000, 0x05675000, 0x2ef5c800, 0xbf580400, 0xfe45f200, 0x7762bb00,
    0x33f21f80, 0xaddaaec0, 0x8d07c820, 0xfa810410, 0x2f427208, 0x6be77b1c,
    0xcbb4bfbe, 0x1dbdfefd, 0xcd720006, 0xa0990000, 0x73e78035, 0x2fb5c035,
    0x2fbea02b, 0xf0735018, 0xc21fc806, 0xf8a50425, 0x5650723d, 0xa90e7b34,
    0x774b3f97, 0x702c3ec3, 0xbbdea026, 0xe2035024, 0xf507c803, 0x4e81042e,
    0x95427203, 0x5ae77b06, 0xc734bf8c, 0x4dfdfefa, 0x80000000, 0xc0000000,
    0xa0000000, 0x70000000, 0xa8000000, 0x94000000, 0xae000000, 0xbf000000,
    0x9b800000, 0x71400000, 0xfba00000, 0x33d00000, 0x51d80000, 0xdca40000,
    0xf4560000, 0xca9d0000, 0xee078000, 0xdf034000, 0x4b81a000, 0xa946f000,
    0xc7a0b800, 0x09d07c00, 0x40defa00, 0xf8262500, 0x1e934280, 0x407c04c0,
    0x2676b820, 0xbd0d7c30, 0xc6f97a28, 0x81b5651c, 0xf96ae2aa, 0x2d4ef4e5,
    0x71d8000b, 0x6ca4001f, 0xfc56000e, 0x2e9d0000, 0xe8078014, 0xf4034029,
    0x7e01a03f, 0x6706f018, 0xa780b81b, 0x4b407c2e, 0xeaa6fa05, 0x1752253b,
    0xbb1d4286, 0x564504dd, 0x3c27382c, 0xa8933c00, 0x637f5a03, 0xf7f0d515,
    0x754bfabf, 0x8dd878df, 0x80000000, 0x40000000, 0xa0000000, 0x90000000,
    0x88000000, 0xbc000000, 0x46000000, 0x65000000, 0x02800000, 0xcb400000,
    0x90a00000, 0x4ff00000, 0xe6280000, 0xcda40000, 0xa9720000, 0xff6d0000,
    0x52008000, 0x4f064000, 0x0980e000, 0x80c6b000, 0x97676800, 0xcd15f400,
    0x7dfc6a00, 0xca3bad00, 0x10dc6b80, 0x1f0a6b40, 0x72956820, 0x6038f410,
    0x5bdcea28, 0xf48ded24, 0xe5548ba2, 0x6ad8db6f, 0x7c080031, 0xb5140009,
    0x39fa0028, 0x88390016, 0x97da8006, 0x0a8f403c, 0x24526028, 0x1a5df02a,
    0x284f082a, 0x0431040d, 0xdac9e230, 0x3775e900, 0x4e6fe9bb, 0x9a867253,
    0xbf4789af, 0xcaa2825c, 0xfcf20183, 0x09acc655, 0xb86183ac, 0xb490df7c,
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x58000000, 0x8c000000,
    0xe2000000, 0xc7000000, 0xb8800000, 0xb4400000, 0x70a00000, 0x5bf00000,
    0xf3c80000, 0x43a40000, 0xfd720000, 0x9a8d0000, 0xf0858000, 0x1040c000,
    0xe6a16000, 0xc2f69000, 0x364cf800, 0x0465a400, 0x6310b200, 0xc298bd00,
    0x909a9b80, 0x4f9efc40, 0xdb1ef820, 0xbd58a410, 0x52fd3228, 0x3d8c7d0c,
    0x9801fb96, 0x6c016c63, 0x72058018, 0xaf00c021, 0x6c816006, 0xda469021,
    0x55a4f80a, 0x2471a435, 0xff0ab204, 0x8741bd21, 0xd6251b91, 0x32b73c4b,
    0x40e81800, 0xae93f402, 0x815d2a2d, 0xa8fb892c, 0xd68ed1a4, 0xf287e544,
    0x4746d1bc, 0x3623e555, 0xa2b4d1bb, 0x28eee552, 0x80000000, 0xc0000000,
    0x20000000, 0x50000000, 0x48000000, 0xf4000000, 0xa6000000, 0x9d000000,
    0xc3800000, 0xb8c00000, 0xf4a00000, 0x84b00000, 0x87a80000, 0xe5a40000,
    0xed360000, 0xc8690000, 0x05868000, 0x95c44000, 0x0f26a000, 0xd077b000,
    0x690ea800, 0xae15bc00, 0x921ef600, 0xcb8e4d00, 0x6752b980, 0x957cbb40,
    0xfd18a820, 0xa30cbc30, 0xe9107608, 0xbe9e0d14, 0xdbca1992, 0x3db60b7d,
    0x6a2e8009, 0x14604017, 0x2c10a038, 0x211eb03a, 0x4108282f, 0xea11fc1c,
    0x0c185608, 0xba89fd1e, 0xbed4118b, 0xe2bd075c, 0xf1385e1c, 0xc1fff134,
    0xe15a4faa, 0x93ebf659, 0xc1449193, 0x13604754, 0xe0907e24, 0x41580114,
    0x03ec47b0, 0xa944fa56, 0x80000000, 0xc0000000, 0xa0000000, 0xb0000000,
    0x98000000, 0x4c000000, 0xde000000, 0xe1000000, 0xbf800000, 0x36c00000,
    0x7ca00000, 0x2cd00000, 0xea880000, 0xc3a40000, 0xb2560000, 0xc3cd0000,
    0x39c18000, 0x7a22c000, 0x49976000, 0xceeb7000, 0xead7c800, 0x87899c00,
    0x02264600, 0xd5976d00, 0x98ed5a80, 0x6fd50240, 0x3209c820, 0x47e09c30,
    0x29b1c628, 0xdc78ad2c, 0x70bbbaa6, 0x971cb253, 0x4f496017, 0xef827008,
    0x7ec04807, 0xb8a65c21, 0x96d0a639, 0x018edd18, 0x0f25f28d, 0x0413ee48,
    0xd72e4623, 0xe0f36d0d, 0xf61b5ab9, 0x30c80279, 0x7940482e, 0xb2665c20,
    0x0c70a609, 0x305edd05, 0x1c2df287, 0x5c77ee75, 0x7858463c, 0xd82e6d2b,
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x68000000, 0xfc000000,
    0x46000000, 0x7f000000, 0x68800000, 0xcfc00000, 0x3ea00000, 0xbc900000,
    0x6d980000, 0x67a40000, 0xfb160000, 0x32d90000, 0xb2c18000, 0xab254000,
    0x26d6e000, 0xe97fb000, 0xefd4b800, 0x76faa400, 0x24914e00, 0x19998d00,
    0x4da0e080, 0x1a1172c0, 0xb15ab820, 0xaf87a430, 0x6346ce08, 0xb365cd2c,
    0x9f37809a, 0x148b82ff, 0x6878e031, 0x3c52b02f, 0x93bb3812, 0xc8f2e41f,
    0x5e282e15, 0xfeee7d10, 0xb0cd388a, 0x779c26c6, 0x2ea62e04, 0xa4937d0f,
    0xd99ab8ab, 0x6da066e9, 0xaa114e28, 0xd9598d2c, 0x5380e09c, 0x254172e2,
    0xcc62b805, 0xf7b3a410, 0xdb48ce0c, 0x56d8cd20, 0x80000000, 0xc0000000,
    0xe0000000, 0x90000000, 0xe8000000, 0x1c000000, 0x16000000, 0xa3000000,
    0x28800000, 0x8cc00000, 0xb4a00000, 0xc8f00000, 0xc7480000, 0xd1a40000,
    0x8b760000, 0x0f0f0000, 0x87c08000, 0xa0214000, 0x2237e000, 0xa8ec3000,
    0xc5d65800, 0xcaffa400, 0xdf0fd600, 0x4fc63d00, 0xcc214380, 0x4c313c40,
    0xffe85820, 0xe754a430, 0xf3395638, 0xe0287d24, 0x237623ba, 0x330c4c47,
    0xe1c1e025, 0x7b233018, 0xfeb6d832, 0x2e2ee407, 0xc4703617, 0x898e0d35,
    0xbc011bb4, 0xa601985c, 0x3b070e08, 0x4c83d910, 0x6ec7f5b4, 0x1da1717e,
    0x557623a3, 0xc00c4c69, 0xc141e00e, 0x7be3300d, 0xb416d81e, 0x59dee43b,
    0x3db83629, 0x77ea0d24, 0x80000000, 0xc0000000, 0xe0000000, 0xb0000000,
    0xc8000000, 0x0c000000, 0x4e000000, 0xc3000000, 0xf5800000, 0x0b400000,
    0x68e00000, 0xfb500000, 0x99180000, 0xa9e40000, 0xa3d60000, 0xf4df0000,
    0x47c18000, 0xff204000, 0xbc776000, 0x016ff000, 0x5a8c5800, 0xbc5dcc00,
    0x72072a00, 0x8501df00, 0xda84b680, 0x00c732c0, 0x68a25820, 0x6a36cc30,
    0x2708aa38, 0x9b1a9f2c, 0x04e456b2, 0xc55782c3, 0x7218e033, 0xe064b000,
    0x2e94b805, 0x53397c2e, 0x07139228, 0xae78a33d, 0x88f724b5, 0x52af91da,
    0x5fad7cb5, 0xa92d5dcf, 0xb7ebd693, 0x644cc2dd, 0x3ff80023, 0x51b40035,
    0x2f4e0027, 0xe67b000d, 0x44f78011, 0xfcaf402f, 0x2caee02d, 0x94abb00c,
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x68000000, 0x14000000,
    0x86000000, 0x8f000000, 0x3a800000, 0x7e400000, 0xa0200000, 0xe5f00000,
    0xb1f80000, 0xeaa40000, 0x33b60000, 0xe5df0000, 0x79538000, 0x654d4000,
    0x21fba000, 0xb2a1b000, 0xafb63800, 0x87d9f400, 0x18570200, 0xc4cc9900,
    0xe3396b80, 0xe3c3b5c0, 0xd0e5b820, 0xad94b430, 0xe32ca238, 0xf82d293c,
    0x84af539a, 0x95ea41c5, 0xff4aba01, 0x0cfc2d13, 0x0923c9b6, 0x80719ce3,
    0x8d396b92, 0xb8c3b5cc, 0x8c65b815, 0xacd4b415, 0x118ca220, 0x779d291f,
    0x1377538d, 0x15be41c6, 0x4784ba2b, 0x7dc72d1a, 0xe3e649b9, 0xe513dcc2,
    0x64694ba6, 0x858b45de, 0x319e2029, 0x7c73f038, 0x80000000, 0xc0000000,
    0xe0000000, 0x90000000, 0x48000000, 0x4c000000, 0x2a000000, 0xdd000000,
    0x49800000, 0xbec00000, 0x55600000, 0x8a300000, 0x12680000, 0xf4e40000,
    0xc8f60000, 0x550f0000, 0x37d08000, 0xbd1c4000, 0xa4296000, 0x14c7d000,
    0x4865a800, 0x23b3ac00, 0x3caa6600, 0xe9806300, 0x0ec32d80, 0x6d65dd40,
    0x1e352820, 0x3c6fec30, 0x4fe30638, 0x7677b324, 0x7f4e8592, 0x95f27153,
    0xdc894e2a, 0x69108f07, 0x7878abaa, 0x661a2e4b, 0x4aaccda7, 0x96814d41,
    0x36416016, 0x2023d01e, 0x6093a80a, 0xe6bcac0d, 0x437ae600, 0x189c2329,
    0x80ea4db5, 0xa4a20d60, 0x1fd08007, 0xa11c4020, 0x2629602b, 0x15c7d02e,
    0x63e5a80e, 0x0c73ac25, 0x80000000, 0x40000000, 0x60000000, 0x50000000,
    0xa8000000, 0xbc000000, 0x6a000000, 0x6d000000, 0x95800000, 0xc9c00000,
    0x90200000, 0x4b900000, 0xf8c80000, 0x1da40000, 0x86520000, 0x76eb0000,
    0xbd368000, 0x441f4000, 0xe60ae000, 0x9d07d000, 0x4d872800, 0xedc0cc00,
    0xbe22de00, 0x58974900, 0xd6484080, 0x46e5b040, 0x2731a820, 0xf11f8c10,
    0x57883e18, 0x7ac09914, 0xcea768aa, 0x88d17c6f, 0x1da9763a, 0xe457c50b,
    0xd7ecfebd, 0xdab56966, 0xa4d8a0ae, 0x9dad606d, 0xa452001c, 0xb7eb0018,
    0x8ab68036, 0x0cdf4014, 0x21aae03b, 0xce57d037, 0xdaef2838, 0x1f34cc09,
    0xc518de33, 0xb1884906, 0x85c4c09a, 0x2225f052, 0x0297c833, 0x43481c3c,
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x48000000, 0x7c000000,
    0x5a000000, 0x2b000000, 0xfc800000, 0xa1c00000, 0x8ce00000, 0xa7900000,
    0x99a80000, 0x8c640000, 0x9c560000, 0xde4f0000, 0x67718000, 0xec3c4000,
    0xa2c8e000, 0x06b55000, 0x80da1800, 0xb55a8400, 0xd71a1e00, 0x70b99f00,
    0x730b6880, 0x22508b40, 0xeb4b9820, 0x3ef6c430, 0x0c7afe38, 0x4a68cf2c,
    0x27877092, 0x35450f5f, 0x01200636, 0x89731b3a, 0x21397687, 0xcf4d1444,
    0xc0f6f091, 0x19794f46, 0x43e8e628, 0x3fc64b35, 0xe9e36eb2, 0x0617906c,
    0x4decee9e, 0x42c0d077, 0xcc638ebf, 0xbc56c05c, 0x8e48f691, 0x9f715458,
    0xd83e10b5, 0x84cc1f64, 0x77b2fe16, 0x575ccf3c, 0x80000000, 0x40000000,
    0xa0000000, 0xf0000000, 0xf8000000, 0xa4000000, 0x7e000000, 0x71000000,
    0xc7800000, 0xb5c00000, 0x54200000, 0xa1b00000, 0xa4580000, 0xe7a40000,
    0x22720000, 0x7d7d0000, 0xab938000, 0xc4edc000, 0xdc7c2000, 0x24127000,
    0x8d2b4800, 0xa25d9c00, 0x72a01e00, 0x3bf4c900, 0x49bf6180, 0xc034b4c0,
    0x7498c820, 0x52005c10, 0x13043e28, 0xcc82b93c, 0x8d4629be, 0xaf6428e9,
    0x23d3563f, 0x9a0d550c, 0xc76d7f99, 0x07bd7dd1, 0xa934298b, 0x471928d1,
    0x91c0d63e, 0x6a209509, 0x70b15faf, 0x93df0de7, 0xaa6761be, 0xd250b4fc,
    0xa2cac838, 0x7ecd5c2d, 0xe4cfbe19, 0x4bcb7927, 0x0d4809ab, 0x870b58db,
    0xc2eb9e0a, 0x497d093e, 0x80000000, 0x40000000, 0x20000000, 0xd0000000,
    0x88000000, 0xd4000000, 0x46000000, 0x63000000, 0x1c800000, 0x3cc00000,
    0xb4e00000, 0x77f00000, 0x58780000, 0xa4640000, 0x11320000, 0x3d990000,
    0x3a128000, 0x820e4000, 0xd95ba000, 0x92f2b000, 0x47fc5800, 0x7425c400,
    0xc1131600, 0xa28d5f00, 0x879d4b80, 0x5b104dc0, 0x138ed820, 0x9e1b8410,
    0xc850b608, 0x0f2bef34, 0xb5cb13a2, 0x153889f5, 0xe7c54e31, 0x44659b08,
    0xa136dd8f, 0x459e52fb, 0xb610b3af, 0x980a39f8, 0x2859162f, 0xab705f15,
    0x04bdcba9, 0xe0870dc1, 0x3ec7f830, 0x39e77400, 0x0c774e3e, 0xb63c9b2e,
    0x9b445d9d, 0x88a012f5, 0x4dd313b4, 0x6e6c89f4, 0x7c6f4e2a, 0x19689b3f,
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xb8000000, 0xcc000000,
    0x1a000000, 0x09000000, 0x18800000, 0x70400000, 0x7ca00000, 0xc0100000,
    0x89b80000, 0x86240000, 0x55560000, 0xa79f0000, 0x37718000, 0xcccbc000,
    0x47ed6000, 0x843f5000, 0x3ce08800, 0xc4b22400, 0x65ac1200, 0xa5998d00,
    0x6277b480, 0x264837c0, 0xfaa90820, 0x8e1de430, 0x53b77238, 0x3a29dd2c,
    0x425ebcae, 0x6d15d3f3, 0x8f3e7a26, 0x71643932, 0x5e71cebe, 0xa4480ef0,
    0x6faec691, 0x849aeaf3, 0x5ef034bc, 0x880cf7ff, 0xe10de825, 0x898d741a,
    0xa1cc9a02, 0xa16ba91e, 0xc37ba69d, 0x8fc1baed, 0x0b66bca5, 0x2771d3c6,
    0xe4c87a37, 0x63eb390b, 0x5a384eb7, 0x5be7cecf, 0x80000000, 0xc0000000,
    0xa0000000, 0x70000000, 0xb8000000, 0x84000000, 0xb2000000, 0x29000000,
    0xcf800000, 0x0d400000, 0x57200000, 0x45900000, 0x2e880000, 0xb2a40000,
    0x55d60000, 0x1c2d0000, 0x27778000, 0xe9fbc000, 0x4b5d2000, 0x768c1000,
    0x26a38800, 0x8fd2dc00, 0x792eba00, 0x66f59100, 0xfbbe2080, 0x48f8e640,
    0xd8dc0820, 0x9dcd1c30, 0x22859a28, 0x10c4811c, 0xa36228ae, 0x1535fa61,
    0x5a59920c, 0xfd099d3a, 0x39e7b29b, 0x81f17b5f, 0x4b3bba9b, 0xc13c6740,
    0xac3e20af, 0x71b8e64a, 0x25fc0800, 0x055d1c09, 0xc98d9a36, 0x0220811c,
    0xdc1428a8, 0x68c8fa59, 0xcb061236, 0xee865d0c, 0x5ec49292, 0x1c646b41,
    0x31b1b2a9, 0x099c7b64, 0x80000000, 0x40000000, 0x60000000, 0x70000000,
    0x08000000, 0x34000000, 0x3a000000, 0x0d000000, 0x7f800000, 0xbb400000,
    0x09a00000, 0xd8700000, 0x37080000, 0xb8240000, 0x74320000, 0x5c2b0000,
    0xdc978000, 0xcdda4000, 0x3bdea000, 0x70dc5000, 0x6c5d2800, 0xef9cdc00,
    0x27faca00, 0x06ef4500, 0x61738f80, 0x328eba40, 0x6e62a820, 0x72129c10,
    0x371e6a18, 0xd63c151c, 0x978b2782, 0x75e3264d, 0xeb51422e, 0x7fbbc913,
    0x77ce6d87, 0x18c22372, 0x8ce66da0, 0x8ed6236b, 0xd9fc6dbb, 0x79e92361,
    0x47f1edb8, 0xbc4c6378, 0xd982cd81, 0xe8457347, 0x5924c5a8, 0x5db4bf5e,
    0xfc6a07af, 0xd1b13676, 0xda68ca1a, 0xc2b44506, 0xeaec0f8f, 0x3770fa63,
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x68000000, 0x3c000000,
    0xba000000, 0xbf000000, 0x9a800000, 0xd9400000, 0x5c600000, 0x41100000,
    0x5f680000, 0xa8e40000, 0x61560000, 0xfc8b0000, 0x65378000, 0x499d4000,
    0xac5ee000, 0xfc7c5000, 0xbc8fb800, 0xc537b400, 0x599eda00, 0xb4593b00,
    0xa8782c80, 0x3a8fb940, 0xc0303820, 0x7c1ef430, 0xf79e3a18, 0x2d5a6b1c,
    0x27fe149a, 0xde4a4d4f, 0x8b91820e, 0x3e2ddf1f, 0xb080cebe, 0xbe43766a,
    0xf2e1aead, 0x6e56666f, 0x6e0ef681, 0xf0728269, 0xc7fe149c, 0x6e4a4d6a,
    0x83918202, 0x722ddf0e, 0x6280ceb6, 0x3d43765f, 0xd261ae92, 0x08166678,
    0xa8eef6bf, 0x68228270, 0xc4f6149d, 0x87be4d61, 0x80000000, 0xc0000000,
    0xa0000000, 0xd0000000, 0x28000000, 0x4c000000, 0xda000000, 0xd3000000,
    0xad800000, 0xd1c00000, 0x6fa00000, 0xb8300000, 0xf1b80000, 0x9c240000,
    0x9cf60000, 0x629d0000, 0x3f528000, 0xc0af4000, 0xbdeb6000, 0x210a5000,
    0xd8d8d800, 0x60368c00, 0x85bc9e00, 0x82214500, 0x09f5dd80, 0xee1f6bc0,
    0xdc125820, 0x094dcc30, 0x68b9fe28, 0xaaa21534, 0xdcb1858a, 0xfeffa7d3,
    0x5fc12616, 0xb2a49904, 0x08b51b83, 0x30fae2c0, 0xe2c2fbb1, 0x7226f2cd,
    0x31f5c382, 0x2a186ed7, 0x9a10658e, 0x284eb7fb, 0x5a3c9e20, 0x0ce1453d,
    0xb1d5ddac, 0x84ef6bc8, 0xc78a583d, 0xb099cc0d, 0xb057fe3c, 0x3f2b152d,
    0x232d058c, 0x1129e7c5, 0x80000000, 0xc0000000, 0x20000000, 0xd0000000,
    0xd8000000, 0x0c000000, 0xee000000, 0x9d000000, 0xf2800000, 0x18c00000,
    0xd4e00000, 0xf3700000, 0x11e80000, 0xdb640000, 0x29360000, 0xf5c90000,
    0xf8f28000, 0xf1a8c000, 0x40456000, 0x8b27f000, 0x5a132800, 0x73d97400,
    0xbd2d7600, 0xdd802f00, 0x81407f80, 0x8fa32140, 0xf3d7a820, 0x6bb8b430,
    0x139a9608, 0xe60f1f34, 0x5f9637b6, 0xfe9da543, 0xdc89f61b, 0xb351ef17,
    0x187f9fb4, 0x84f81172, 0xc13fe023, 0xc75b300f, 0xfce84837, 0xe1e38425,
    0xc5f2de00, 0x132c9b38, 0xa084e9b0, 0x83c13e67, 0x9f651f88, 0xf334d162,
    0x7acc8001, 0x7175c019, 0x52e9e02b, 0x9ce2300a, 0xc772c837, 0x03ef4418,
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x08000000, 0x5c000000,
    0xf6000000, 0x69000000, 0x0f800000, 0x59c00000, 0x22600000, 0x6ef00000,
    0x73280000, 0xb4e40000, 0x10b60000, 0x048f0000, 0xb6718000, 0x306e4000,
    0x66c1e000, 0xd4e43000, 0x60b40800, 0xec8f1c00, 0x5a713e00, 0xce6ebb00,
    0x53c7bb80, 0x2d619f40, 0x50738820, 0xc16e5c30, 0x6d415e38, 0x9f24cb2c,
    0x89d25382, 0x4efab357, 0xe01ebe1d, 0x67abfb2a, 0x59a1dbbb, 0x4f94ef7a,
    0x6d5fe02a, 0x488f303c, 0xd8738819, 0x5d6e5c1b, 0x7b415e05, 0x4624cb00,
    0x8e525398, 0x4b3ab34d, 0x347ebe26, 0x605bfb3e, 0x2509dbac, 0xa2b0ef4d,
    0x5f89e005, 0x22f03035, 0x1d2a080c, 0xd9e41c09, 0x80000000, 0xc0000000,
    0x60000000, 0x50000000, 0xd8000000, 0x2c000000, 0xfa000000, 0x03000000,
    0xce800000, 0x31c00000, 0xff600000, 0xb4f00000, 0x5c080000, 0x0ae40000,
    0xf7b60000, 0xd0ab0000, 0x3e768000, 0xf3c8c000, 0x98866000, 0x08c35000,
    0x52e5d800, 0x1bb59400, 0x4aa89e00, 0x6d728300, 0xe54a0380, 0x85447640,
    0x0da55820, 0xe5165430, 0x89387e18, 0x71891314, 0x65a1bbb6, 0x8116b24b,
    0xe73e1e1e, 0xf48a4330, 0x8a2463ab, 0x51532658, 0x1d1e8029, 0x8ddcc016,
    0x53386031, 0x828c5016, 0x43255838, 0x14d65433, 0x16587e0e, 0x95791311,
    0xe1a9bb82, 0xa7f2b24c, 0xea881e36, 0x2721432f, 0x7ad2e392, 0x935be671,
    0x7af8e034, 0x31ef902c, 0x80000000, 0xc0000000, 0x60000000, 0x30000000,
    0x78000000, 0xc4000000, 0xf2000000, 0x9f000000, 0x74800000, 0x87c00000,
    0x18200000, 0xfa700000, 0x0a080000, 0x3ba40000, 0x75360000, 0xc3eb0000,
    0x84f58000, 0x16cdc000, 0xc5012000, 0xa7801000, 0xdd443800, 0x06e40400,
    0x83d06e00, 0x583a1900, 0x28cfe780, 0xb4029640, 0x2a07b820, 0x0b02c430,
    0xce84ce18, 0xa4c7c90c, 0x5aa2ff9e, 0x10b28271, 0xf9adee1c, 0x3293d917,
    0xe0d8c785, 0x1a19866d, 0x01be0038, 0xe48f003f, 0x0f638026, 0x0796c025,
    0x5f5ca01e, 0x3359d020, 0x8d5b181b, 0x3c5b141c, 0xd1dfd62e, 0x379cdd06,
    0x87fd29ac, 0x64ee5f4f, 0x9470c7a3, 0x330d866d, 0x0a20001e, 0x95700008,
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x48000000, 0xbc000000,
    0xae000000, 0x01000000, 0x19800000, 0xfcc00000, 0xc7600000, 0x8bf00000,
    0xca180000, 0x67e40000, 0xeab20000, 0x9bbb0000, 0x20768000, 0xe9d84000,
    0xc002e000, 0x2005f000, 0x30014800, 0x1807ac00, 0xf400d600, 0x1203d300,
    0xaf01e380, 0x1881bec0, 0xe545c820, 0x3ba4ec10, 0x4c94b618, 0x41ee6314,
    0xadfa4b92, 0x8d57e2ef, 0x710e560b, 0xbbcf9310, 0xc9a9039e, 0x29db4eeb,
    0xe0000003, 0x1000001d, 0x28000001, 0xec00000d, 0xe600002e, 0xbd000036,
    0xb7800012, 0xfdc00018, 0xdee00004, 0x7730002e, 0x0d780007, 0xec140002,
    0x20aa0007, 0xfc5f0027, 0xcac48021, 0x72634028, 0x80000000, 0xc0000000,
    0xe0000000, 0x90000000, 0x08000000, 0x84000000, 0xae000000, 0x89000000,
    0xea800000, 0xbb400000, 0xb0a00000, 0x32500000, 0xd5080000, 0x67240000,
    0x75960000, 0xabef0000, 0xbd508000, 0x828e4000, 0xe0e72000, 0xeb77f000,
    0xe19b0800, 0x424bf400, 0x4d82ea00, 0x18c4ed00, 0x01603680, 0xa9b3fa40,
    0x5ffd8820, 0x047ab430, 0x69bd4a38, 0x30595d24, 0x89aa1e82, 0x2f70fe61,
    0x6f9cea0b, 0xbb4fed12, 0x3f06b682, 0x2f82ba4a, 0x9bc2280e, 0xbce7041d,
    0xe9776226, 0x329a591f, 0x17cb7ca5, 0x1945a765, 0xd3a71688, 0x1fd40a7e,
    0x9dce802f, 0x8e454019, 0xc821a033, 0x5216b033, 0xb42ca820, 0xafb2443c,
    0xe2fec234, 0x38f8e936, 0x80000000, 0xc0000000, 0x20000000, 0xd0000000,
    0x98000000, 0xb4000000, 0xbe000000, 0xe3000000, 0x0e800000, 0xa9400000,
    0x9f600000, 0xd4300000, 0x8b180000, 0x2ee40000, 0xf1f60000, 0xec390000,
    0x52328000, 0xcc1ac000, 0x2660a000, 0xdfb57000, 0x5bdad800, 0x78475400,
    0x68e27a00, 0x96f74300, 0x34bda580, 0xe476cac0, 0xcffe5820, 0xb2149430,
    0x98485a08, 0xe5ccf334, 0x3a09dda6, 0x4829eeed, 0xf57a7a0f, 0x65534308,
    0xc42ba58b, 0xef7fcade, 0x8054d821, 0x4daa5428, 0x6ebefa05, 0xe1708307,
    0xb6798599, 0x7bd07afc, 0xd56ea03c, 0x1418700e, 0x72665820, 0x91b09422,
    0xf0de5a2b, 0x5ac5f33d, 0xcba35d83, 0x54972ee5, 0x0d0cda1b, 0xc8af332f,
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x38000000, 0xfc000000,
    0x42000000, 0x47000000, 0xdd800000, 0x8c400000, 0xa3e00000, 0xbfd00000,
    0xd8f80000, 0x1b640000, 0xb9120000, 0xf2df0000, 0x27168000, 0x07dbc000,
    0x3594e000, 0xc21a9000, 0x9c30f800, 0x27298c00, 0x239cb200, 0xf2744700,
    0x73cdc280, 0x29cefdc0, 0x62cc7820, 0x75494c10, 0x2a0cd238, 0xd26a1714,
    0x18ff5a8e, 0xbb6621ff, 0x0914d230, 0x9ade1701, 0xe3155a8f, 0xb9dd21f7,
    0x30905206, 0x589ad700, 0xcdf73a9e, 0x088c71c3, 0x3fac4a37, 0x955dcb30,
    0xb0517089, 0x8bbabaeb, 0x2901baa2, 0xa087b1fa, 0x0ac0aa29, 0xe0235b0f,
    0xef7388b6, 0xe54c36f3, 0xb20b88a9, 0x9e6836d7, 0x80000000, 0x40000000,
    0x20000000, 0xd0000000, 0x48000000, 0x94000000, 0x2e000000, 0x45000000,
    0x06800000, 0x67c00000, 0xb8e00000, 0x4ad00000, 0x1ae80000, 0xe5640000,
    0x96920000, 0xef490000, 0x52928000, 0xc9484000, 0xa391a000, 0x31cdf000,
    0xc9556800, 0x1ba81400, 0xca450e00, 0xfca7cf00, 0x63705280, 0x171be140,
    0xd1bde820, 0x99cd5410, 0xed542e08, 0x8dab7f34, 0x83461a92, 0x08264565,
    0xfbb42e2b, 0xc27b7f01, 0xbf2e1a89, 0x5a82456d, 0x9dc62e1c, 0xf3e27f27,
    0xd9549a85, 0x33ae055c, 0xae458e16, 0x4aa68f17, 0xfa7372b9, 0xab9e5145,
    0xdd79201d, 0x62a8b019, 0xc6c4483a, 0x4864a40a, 0x94134633, 0xce8a6b08,
    0xeb7194b0, 0xe319ca71, 0x80000000, 0xc0000000, 0x60000000, 0xd0000000,
    0xd8000000, 0x54000000, 0x1a000000, 0xe9000000, 0x34800000, 0xc2400000,
    0x2b200000, 0x98b00000, 0x22880000, 0x14a40000, 0xa3760000, 0x8d6b0000,
    0xd0728000, 0x90e8c000, 0x46b5a000, 0xa9885000, 0x2d268800, 0x47b38400,
    0x010b0200, 0x19663100, 0x1b957180, 0x8639ee40, 0x702a0820, 0xc8d44430,
    0xbd9a2218, 0x58dda134, 0x747cd9b6, 0x930efa55, 0xbc642226, 0x0112a10a,
    0x67785995, 0x5e8d3a44, 0xf2a3021c, 0x6c723103, 0x16eb7196, 0x59b6ee4b,
    0xea0e8833, 0xf0e78436, 0x27550220, 0x5e59310c, 0xa339f1a2, 0xaaae2e4a,
    0x4993280f, 0x433bd41e, 0xbaad8a29, 0xf195b523, 0xc73e7383, 0x78afdf5b,
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xb8000000, 0x34000000,
    0x2a000000, 0x93000000, 0x6e800000, 0x89400000, 0x09200000, 0xaa900000,
    0xc4380000, 0x9aa40000, 0xec520000, 0xdddf0000, 0xfcd18000, 0x1d9fc000,
    0x5072a000, 0xd4ced000, 0x862a5800, 0x4ad95400, 0x4051da00, 0xd3ddf100,
    0xadd43080, 0xdc1d13c0, 0x11b1d820, 0xd9ad9410, 0xf218fa38, 0x50b7e12c,
    0xf02f48ae, 0x8fda57cd, 0xfbd17a2a, 0x091c2134, 0x4237e8a3, 0x3f6f87ce,
    0xbbf8a20c, 0x3ec5b537, 0x8de51283, 0x1c7366ee, 0x6acc6aae, 0x6f2b22c8,
    0xbf5d48af, 0x2b9557f5, 0x4db8fa08, 0xb767e100, 0x4f374884, 0xa8ee57ca,
    0x2f3b7a01, 0x6027210e, 0x1f1468af, 0x4fff47f5, 0x80000000, 0x40000000,
    0xe0000000, 0x70000000, 0xc8000000, 0x6c000000, 0x1e000000, 0x2d000000,
    0x71800000, 0x09c00000, 0x09600000, 0x4a700000, 0x6f580000, 0xc0a40000,
    0xe3120000, 0xb52f0000, 0x17ff8000, 0x87b04000, 0x243e6000, 0x91d07000,
    0xcccea800, 0xdbcdac00, 0xb54e5e00, 0x1e0e9300, 0x32295780, 0xc17c88c0,
    0x88f0c820, 0x7a1ddc10, 0x5180f638, 0xd9c33f1c, 0x516709b2, 0x9e721bdb,
    0xd5599fa7, 0x9fa154db, 0xa1903e04, 0xe06ee30e, 0x66dfff88, 0xcd6524d5,
    0x0874960e, 0x74584f30, 0x8024219b, 0x4d50f7f8, 0xf48e2189, 0x3b6bf7fa,
    0x865ba18f, 0xf320b7c1, 0xf1d041a6, 0xfccb87fe, 0xf3cd09bf, 0xa9491bc5,
    0xc80c1faa, 0x732a14db, 0x80000000, 0x40000000, 0xa0000000, 0x70000000,
    0x68000000, 0xc4000000, 0xc6000000, 0xa7000000, 0x71800000, 0x03400000,
    0x2c200000, 0x41700000, 0xfc580000, 0x0f640000, 0x5d520000, 0x752d0000,
    0x473f8000, 0xfc354000, 0x4b792000, 0x8594b000, 0x1f4ff800, 0xeaefec00,
    0x8cdd8a00, 0x4aa22900, 0xbbb61f80, 0xc73f84c0, 0xbc36d820, 0xeb7b5c10,
    0xf5927228, 0x774dc51c, 0x2eeb959a, 0x4addadf1, 0xeda0c791, 0xca34d8f9,
    0xc47caa14, 0x9012990c, 0xaa0be7b9, 0x09cd68fd, 0x782cd234, 0x73b8350b,
    0x3ff74d92, 0xaa9ff1e8, 0x360735bc, 0x8f055dce, 0x15839f9f, 0xb543c4d7,
    0xe3227821, 0xf4f7ac19, 0x391b2a2d, 0x8443d924, 0x6da0c7a5, 0x8a34d8f4,
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xf8000000, 0x24000000,
    0x36000000, 0x07000000, 0xe6800000, 0xb8400000, 0xc2e00000, 0xcab00000,
    0x01a80000, 0x02a40000, 0x6c520000, 0x9d1b0000, 0xd40a8000, 0x7071c000,
    0x6d082000, 0xbdf03000, 0x69cb7800, 0xfa56d400, 0x6a19d200, 0x7a8f5f00,
    0xc430f980, 0x45ed8b40, 0x62435820, 0xbfe6e410, 0xa132aa18, 0x9a698b34,
    0x57812bbe, 0x19c6d449, 0xfc21a1ad, 0x60106f51, 0xf1fb7201, 0xedbeaf0a,
    0x595ba196, 0xf4ef6f4f, 0xc3c3f213, 0x81246f18, 0x0b9101b7, 0x6a3a9f7c,
    0xb89aaa22, 0x2ccd8b19, 0x95d32bbe, 0x77ddd468, 0x00ab21a6, 0x8b21af6e,
    0x8e935231, 0x25be9f32, 0x1558d980, 0x7eedbb71, 0x80000000, 0xc0000000,
    0x20000000, 0x10000000, 0xa8000000, 0xa4000000, 0xc2000000, 0xa5000000,
    0x55800000, 0xcd400000, 0x49600000, 0x85900000, 0x47a80000, 0x90240000,
    0x76f60000, 0x4b390000, 0xf40c8000, 0xe4974000, 0x202a2000, 0x60639000,
    0x7616e800, 0xcdebcc00, 0x39c1da00, 0xc3a23300, 0x2cb78880, 0x6ad86b40,
    0xf55cc820, 0xe9185c30, 0xbfff3208, 0xe62dff04, 0xd76052aa, 0x0e935869,
    0xe12fc090, 0xd7e37759, 0x0e57da3d, 0x790b3307, 0xd51308b0, 0x0f6b2b4c,
    0x9c00e82b, 0x0e02cc14, 0xe3055a30, 0x2281730c, 0x95c3a890, 0x75a6fb42,
    0xc3b0a01b, 0x2e5dd004, 0x0798480c, 0x6c3b1c32, 0xe48b1216, 0x4c536f13,
    0x1c0c3a9f, 0xa096d476, 0x80000000, 0xc0000000, 0x20000000, 0xb0000000,
    0x88000000, 0xa4000000, 0x3a000000, 0xbb000000, 0x2b800000, 0x95c00000,
    0xb7600000, 0x57300000, 0xb9580000, 0xdea40000, 0xa6560000, 0xd3690000,
    0x51798000, 0x6bb64000, 0x591a2000, 0x5d015000, 0x66821800, 0x0b413c00,
    0xb025de00, 0xc915f300, 0x794b1d80, 0x936de8c0, 0xb1783820, 0xfbb06c30,
    0x611fc608, 0x7100cf2c, 0xf880c3a2, 0x8a451be9, 0x20a4a5ae, 0x7756c4de,
    0x5bea5e22, 0x733ab339, 0x5f10bd87, 0x9c4ef8d0, 0x19ee0022, 0x043d0000,
    0x7a978025, 0xb08b4013, 0x120da011, 0x734a1003, 0x606fb81b, 0x1efb2c1b,
    0xe4726614, 0xe57adf24, 0xa9b77bbc, 0xee1a37c9, 0x5880c392, 0xfa451bee,
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x48000000, 0xc4000000,
    0xb2000000, 0xcd000000, 0xcc800000, 0x71400000, 0x07a00000, 0x78300000,
    0x27480000, 0x94e40000, 0x9a920000, 0xe7f90000, 0xa8e88000, 0x48d44000,
    0xbfdd2000, 0x661c1000, 0x72fea800, 0xa86d0400, 0x6f93ba00, 0x577e0500,
    0x57ae2d80, 0x2c77a440, 0xf86b8820, 0x47951410, 0x237f1208, 0x3daa0124,
    0x6d751792, 0x42ede171, 0x49d0858c, 0x255aa063, 0xf858321b, 0x3cdb1128,
    0xa9993f9b, 0x8c39a54b, 0x710c9f97, 0x5ec1f577, 0x09671791, 0x5954e162,
    0x0a1805a2, 0xf4fee055, 0x2f6d1231, 0x72130114, 0xd4bd97b6, 0x9a49a14c,
    0xe065a5bb, 0xd7d2b06e, 0x4e5c9a2f, 0x23db1520, 0x80000000, 0xc0000000,
    0xe0000000, 0x30000000, 0x48000000, 0xac000000, 0xb2000000, 0x8f000000,
    0xd7800000, 0x14c00000, 0x9b600000, 0x70300000, 0x70780000, 0x35a40000,
    0xe8560000, 0xb5cf0000, 0xa61d8000, 0x75104000, 0x276c6000, 0xc5cf1000,
    0xce1db800, 0x09149c00, 0xed68d600, 0xaecdf300, 0x079de580, 0x20d229c0,
    0x2e89d820, 0x1dbf8c30, 0xf8436e38, 0xfe266f0c, 0xc690b392, 0xedab9aeb,
    0x83ae5d8c, 0xd6adb5d3, 0xf22a8e2d, 0xfb6d3f39, 0x1fcf6b8c, 0x3d1b16fb,
    0x1490b382, 0x92ab9af5, 0xfc2e5dbb, 0x5e6db5f7, 0x934a8e30, 0xa85d3f13,
    0x0a376bb5, 0x937f16e4, 0xb026b3be, 0x43949adf, 0xb12bdd8f, 0x6ee9f5dd,
    0x2c08ee24, 0xedf92f27, 0x80000000, 0xc0000000, 0xa0000000, 0xd0000000,
    0x18000000, 0x64000000, 0x76000000, 0xdb000000, 0x15800000, 0x37c00000,
    0x63a00000, 0xa5b00000, 0xbbf80000, 0x6a640000, 0xa1160000, 0xb9cd0000,
    0x9b5a8000, 0x7e52c000, 0xfb282000, 0xbb0c3000, 0x927a9800, 0x2fa44c00,
    0x1fb4ae00, 0x1afd3500, 0x7ee23980, 0x52529dc0, 0x312ab820, 0xd20c7c30,
    0xfaf83628, 0xcee47934, 0x3a541786, 0x9d2968d9, 0xd80ea1bd, 0x33fbd1c6,
    0x7664960d, 0xc3138909, 0xdcca2fb6, 0x29ded4c4, 0x4e123795, 0x024c58c5,
    0xb398b9b8, 0xae705dd1, 0xaa5a9835, 0x12d44c26, 0x1c6cae3b, 0x8de93506,
    0x7c2c39bc, 0xac8b9ddd, 0xb0be3829, 0x3687bc15, 0xf644961c, 0x4a63892f,
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x38000000, 0xdc000000,
    0x82000000, 0xcf000000, 0x6a800000, 0x4dc00000, 0xa0e00000, 0x4f500000,
    0xca180000, 0xc3240000, 0xdab20000, 0x5ccd0000, 0x5c7b8000, 0x03b7c000,
    0xdf49e000, 0x4a3a9000, 0x39163800, 0xe0bb7400, 0x94d61e00, 0x105b2f00,
    0x13817680, 0x3e401ac0, 0x8ea7d820, 0xa9f5e410, 0x77ea2628, 0xd2c95b3c,
    0x997ee88e, 0xe231f5f7, 0x560cce80, 0xd21caee3, 0xaf202612, 0xc0b05b3f,
    0xbfcf688e, 0x8cff35d8, 0x5d74aebc, 0x9728fee4, 0x87ae7e04, 0x396f7f1b,
    0x210f2e83, 0x249f3ecb, 0xc0e79e23, 0x5f55ef25, 0xa2191698, 0xd7244ac3,
    0xbcb18018, 0xcdcec034, 0x7bf86036, 0xebf45031, 0x80000000, 0xc0000000,
    0xe0000000, 0xb0000000, 0xa8000000, 0xe4000000, 0x3e000000, 0xb7000000,
    0xaf800000, 0xd6400000, 0x71e00000, 0x69300000, 0xdf980000, 0x75a40000,
    0xe5d60000, 0x682f0000, 0x98f98000, 0xea574000, 0x2e6e2000, 0x111f7000,
    0x7f677800, 0x83f61c00, 0x09bae200, 0xbc330700, 0x251fed80, 0x9960e2c0,
    0x98f15820, 0xcc3d6c30, 0x4b739a38, 0xa87e1b2c, 0xb7928faa, 0x57cfa5f9,
    0x0ecf15af, 0xce4abedd, 0x1b8a1a33, 0xd6295b29, 0xeffcaf8e, 0xa5d0d5cf,
    0x48286db2, 0xc8fca2f9, 0xf250f805, 0x626a5c1e, 0xcb1b4203, 0xf6643700,
    0x9b773585, 0x707aced7, 0x1b94e215, 0x3dc8070f, 0x2fc86d92, 0x32cca2cc,
    0x5c48f805, 0xc68e5c16, 0x80000000, 0xc0000000, 0xa0000000, 0xb0000000,
    0xd8000000, 0x04000000, 0x2a000000, 0x2f000000, 0xc1800000, 0x5fc00000,
    0xc7200000, 0x07300000, 0x76e80000, 0x9ee40000, 0x79160000, 0xa15d0000,
    0x1b498000, 0x4d94c000, 0xa81b2000, 0x562dd000, 0x90403800, 0xede3ec00,
    0x56930e00, 0x5b9d5100, 0x82edad80, 0x0ce43540, 0x42131820, 0x22da3c30,
    0xb78d3628, 0x6537bd2c, 0xf5e923b6, 0x0964a441, 0x97d215aa, 0x7afe197b,
    0xa93ab638, 0x481a7d0b, 0x862d83af, 0x5840b46c, 0x81e08d81, 0xa094e55d,
    0x5a9aa02c, 0x466d1028, 0xbda51819, 0x1b773c28, 0xbd0cb63a, 0x01777d39,
    0x8a0c039d, 0x64f07468, 0x4fcdadac, 0x54d4354b, 0x8d7b1828, 0x57fe3c3f,
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x68000000, 0x5c000000,
    0xae000000, 0xad000000, 0x5a800000, 0x9ac00000, 0xcea00000, 0xf5b00000,
    0xbdc80000, 0x99640000, 0x91960000, 0x8ab90000, 0xce0c8000, 0x67414000,
    0xf9e5e000, 0x8454f000, 0x559ea800, 0x1aff7400, 0x12694600, 0x30556d00,
    0x679f9180, 0x39fd2c40, 0xf5ed4820, 0x98128430, 0x6ffb6e08, 0xaceb5904,
    0x1093379a, 0xe63cb157, 0xfdcc718b, 0x7960dc5b, 0xa197603e, 0xf2b8b012,
    0xfa09c821, 0x9547c42e, 0xfae08e1e, 0x73d2a91a, 0x95df1f99, 0x4e9f856f,
    0x297a57b6, 0x78290172, 0x4337398a, 0x310b584e, 0xeec08e2c, 0xdca2a921,
    0xc6b71faa, 0x324b854f, 0x6d245793, 0x37f4015c, 0x80000000, 0x40000000,
    0xe0000000, 0x50000000, 0x88000000, 0xac000000, 0x4a000000, 0x3d000000,
    0x99800000, 0x9b400000, 0xdf200000, 0x03700000, 0x03980000, 0x31640000,
    0x49d20000, 0x61af0000, 0x08de8000, 0xc6424000, 0x56a06000, 0xf037d000,
    0x20bf2800, 0xf011ec00, 0xdb49ea00, 0x834e4100, 0xe749bf80, 0xe14d4ac0,
    0xc64d4820, 0xeac93c10, 0x44084238, 0x4a6ded14, 0xab3835a2, 0x3250dbeb,
    0x9be9dfb2, 0x3c7a9adf, 0x1772603e, 0x7d98d022, 0x8261a82d, 0x5b53ac3f,
    0x9c698a30, 0x44399128, 0x52d697a6, 0x2f2ca6f1, 0x871ca233, 0xc3a37d07,
    0x35b3fd9a, 0xc9ffa7e4, 0x6633fd98, 0x2fbfa7d3, 0xc093fdac, 0xe78fa7c2,
    0x942bfdb2, 0x799ba7fc, 0x80000000, 0xc0000000, 0xe0000000, 0xf0000000,
    0xc8000000, 0xf4000000, 0xf6000000, 0x0f000000, 0x76800000, 0xa7c00000,
    0xb8200000, 0x1d300000, 0x3b980000, 0xa8e40000, 0x2f960000, 0x636f0000,
    0x225b8000, 0x2bc44000, 0x5226a000, 0x00373000, 0x8c19b800, 0x4aa65400,
    0x44f32e00, 0x98bd0900, 0xc550a580, 0x74cf16c0, 0xf1291820, 0x413e6430,
    0xc4111638, 0xb32f1d3c, 0x983d2bb2, 0xad912ffd, 0x5a6e059d, 0xbbdc26f3,
    0x0a86a005, 0x85c73025, 0x5121b824, 0x5cb25406, 0xd6dd2e01, 0xb5060914,
    0x738525ab, 0x3c4056f2, 0x6062381b, 0xb3521414, 0xbbcd8e0c, 0x67ae3911,
    0x16ff1d94, 0xb43642dd, 0x5a19b60f, 0x55a32d07, 0x0a711388, 0x03783bc2,
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0xe8000000, 0xe4000000,
    0x96000000, 0xed000000, 0x2a800000, 0xaec00000, 0x13e00000, 0xdf900000,
    0x95180000, 0xdc240000, 0xd4f20000, 0x7f4f0000, 0xcd5e8000, 0xbb014000,
    0x67822000, 0x34413000, 0x0522a800, 0xc0713400, 0x388ee600, 0x323f4700,
    0xcf56c080, 0x2ffd8ac0, 0x0f328820, 0xba2f0410, 0x960ace38, 0x1afb3314,
    0x39b006ba, 0x6ee8fdf9, 0x4aea6085, 0x7cedfaeb, 0x21ea0012, 0xb36b002f,
    0x11ac8006, 0x704e401a, 0xd4dca03a, 0x86407035, 0xde20881a, 0xb7f0040f,
    0x04cc4e3d, 0x831e7332, 0x712026b8, 0x1e76cdcd, 0x818e48b1, 0x36b98ec8,
    0x8094c610, 0x649a7739, 0x0566689b, 0xfb53bec5, 0x80000000, 0x40000000,
    0x20000000, 0xb0000000, 0xc8000000, 0x4c000000, 0x66000000, 0x01000000,
    0x49800000, 0x07c00000, 0x6fe00000, 0xa3900000, 0x13880000, 0x0d240000,
    0x7ff20000, 0x88d90000, 0x0dc98000, 0x7d004000, 0xa7816000, 0x6ac7b000,
    0xf063c800, 0x6d566c00, 0x79e96e00, 0xcf744700, 0x029d5880, 0x6fefee40,
    0x6670a820, 0x9718dc10, 0x762b2608, 0x8c966b2c, 0x570f56b2, 0x05611953,
    0xa6d5b8b9, 0xc5281e50, 0xf612003a, 0x6a49003d, 0x77c18021, 0xc7e44017,
    0x7f93602f, 0x0d8eb010, 0x88224814, 0x1c722c23, 0xe81a0e0a, 0x2aaaf736,
    0x90d710b6, 0xdc29c271, 0xab90a607, 0x3f8f2b2a, 0xfb27b68a, 0x06f6e962,
    0x455f10b8, 0x200dc25d, 0x80000000, 0xc0000000, 0xe0000000, 0x50000000,
    0xe8000000, 0x3c000000, 0xe6000000, 0xaf000000, 0xc5800000, 0x61c00000,
    0x8ea00000, 0x72300000, 0x24e80000, 0xa4640000, 0x9b160000, 0x4a1f0000,
    0xeeae8000, 0x48054000, 0x4c00e000, 0xbe02b000, 0x2b00b800, 0xf7808c00,
    0x14c5de00, 0x02263d00, 0x7970c580, 0x0e0c0540, 0x39365820, 0x436d3c30,
    0xb8a3e638, 0xf537f114, 0x3d6bfbba, 0x73a3884f, 0x52b6a599, 0xc1aff55b,
    0x4d800029, 0xcdc0003c, 0x60a00021, 0xb1300007, 0xef68000a, 0x56a4000d,
    0x3636002e, 0xf6ef0021, 0x81668029, 0xff914016, 0x7d5ee039, 0x2249b01a,
    0x7a503825, 0x51fecc06, 0x2d7dbe18, 0xbe3ecd00, 0xf0de1db6, 0x0f8b797e,
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x88000000, 0x1c000000,
    0x16000000, 0xc1000000, 0x2c800000, 0x3cc00000, 0x46200000, 0xecb00000,
    0x8e380000, 0xede40000, 0x27160000, 0xa2cd0000, 0xe13f8000, 0xf4664000,
    0xed53e000, 0xf72e3000, 0x322dc800, 0x8cafc400, 0x236eb600, 0x7ac80900,
    0xc538c980, 0xd664d3c0, 0x56502820, 0x84a8f430, 0xff6afe28, 0xcccc8d1c,
    0x743a1fa2, 0x72e4aac7, 0x7696c9a5, 0xd48dd3c0, 0xd2d9a803, 0x6e73b423,
    0xa51e9e1b, 0x13d0fd20, 0x38ea3784, 0xbb8c5ecc, 0xcb5c37a7, 0xa4315ee7,
    0xf0fbb7aa, 0xc0c31ee5, 0x402657a3, 0x75b42ed6, 0x46ba1f89, 0x5324aaeb,
    0xaa36c99d, 0xb5fdd3df, 0xbe41a807, 0x4fe7b41a, 0x80000000, 0xc0000000,
    0x20000000, 0xb0000000, 0x38000000, 0xe4000000, 0x0e000000, 0x7d000000,
    0xc9800000, 0xecc00000, 0x9da00000, 0x19900000, 0xfc980000, 0x16640000,
    0xe6b60000, 0xc9490000, 0xd4198000, 0x3923c000, 0x74d02000, 0x71fcf000,
    0xc853a800, 0x48beac00, 0x73353600, 0x0f8cf500, 0x1ab9a880, 0x24366ec0,
    0x950d8820, 0xf2ff5c30, 0xa4d11e08, 0x19fc992c, 0x84533e8e, 0x2abcabf9,
    0xdc3628a3, 0x510caeef, 0x4cfc281a, 0xe1d46c27, 0x347c9621, 0x6693c513,
    0xca1a20b2, 0x0c2432e3, 0x41531628, 0xc7390526, 0x1ef380a8, 0x01ab02df,
    0xa4e89e2b, 0x158f5916, 0xb1bb1ebf, 0xe4b45bd6, 0x364b808c, 0x229f02cd,
    0x03669e22, 0x6332591e, 0x80000000, 0x40000000, 0xa0000000, 0xd0000000,
    0xa8000000, 0xfc000000, 0xe6000000, 0xe9000000, 0x73800000, 0xe6400000,
    0xda600000, 0xe3300000, 0x4eb80000, 0x47240000, 0x29d20000, 0x3f4d0000,
    0x833a8000, 0x8c634000, 0x9230e000, 0x193cb000, 0xc3608800, 0xa8b33c00,
    0x5cfae200, 0x57442b00, 0x6de48d80, 0x17743bc0, 0xb7da6820, 0x70968c10,
    0xe7aaea28, 0xd1cd5734, 0x9cfe0faa, 0xb746e0ff, 0x1de60d99, 0x6f737bea,
    0xe3d88814, 0x6a973c1d, 0xe8a8e234, 0x4b492b33, 0x093e0d80, 0x8b677bd4,
    0x24b2880f, 0xc2fe3c1c, 0xea406222, 0x04676b16, 0xfe346dab, 0xf7388bd0,
    0x0662e030, 0x9531b01e, 0xafba0809, 0x18a07c34, 0x81920203, 0xf02c9b27,
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x18000000, 0x6c000000,
    0x1e000000, 0x5b000000, 0xfc800000, 0x93c00000, 0xb5600000, 0xf2900000,
    0x5da80000, 0x02240000, 0x58320000, 0x145d0000, 0x5e198000, 0x8f3ec000,
    0xaf886000, 0xe2167000, 0x90689800, 0x4c40c400, 0xe6204e00, 0xc2312300,
    0x855cb880, 0x3b9f7f40, 0xbd797820, 0x42a87410, 0xd4a0b628, 0x42f7972c,
    0xa8bc6e86, 0x80ca985b, 0x64b78ea7, 0x679b2846, 0xfb7cf6b7, 0xd5ae5c58,
    0x8625c0a3, 0x92370b5b, 0x8d59ce1e, 0xff9fe331, 0xd77cd880, 0x6bad0f40,
    0x6d23e024, 0x76b5b026, 0x72997801, 0x54f8741a, 0x7ee8b631, 0xca839715,
    0xfcc66e85, 0x9be3987c, 0x94540e83, 0x574ce864, 0x80000000, 0x40000000,
    0x60000000, 0xb0000000, 0xa8000000, 0x24000000, 0xda000000, 0x99000000,
    0x9e800000, 0x85400000, 0x4a200000, 0xf7f00000, 0x57680000, 0x45e40000,
    0x0a920000, 0x37bb0000, 0x11f98000, 0xac5b4000, 0x886c2000, 0x84665000,
    0x0e550800, 0x195e1400, 0x78ef1a00, 0x3a222900, 0x7ff17380, 0xa36efd40,
    0x87e0a820, 0x1f930410, 0x573e3218, 0xd7be6d2c, 0xe1f961aa, 0x6459c049,
    0x1c6f4196, 0xf6609076, 0xb351c99f, 0x5ddec45d, 0x64ab7380, 0xee81fd48,
    0x0d432831, 0xbe274402, 0x35f19221, 0x426c7d2f, 0x2563c9ad, 0xccd5c458,
    0x7a1af394, 0xfdcebd5a, 0x34550819, 0x705e143a, 0x2e6f1a2d, 0x2b622921,
    0x47d173b2, 0xe99efd51, 0x80000000, 0xc0000000, 0x60000000, 0xd0000000,
    0x48000000, 0xe4000000, 0xf2000000, 0xf5000000, 0x6d800000, 0xd8c00000,
    0x78e00000, 0x31700000, 0xddb80000, 0xf1a40000, 0x6f560000, 0xc72b0000,
    0xefea8000, 0xaf084000, 0x827e2000, 0xd1c01000, 0x8b666800, 0x6ab38c00,
    0x1fdab600, 0xc8929f00, 0x9b4bff80, 0x55dc7fc0, 0xe192c820, 0x18cbdc30,
    0xf61afe18, 0x5ff50334, 0x7ff92192, 0xe1026cf9, 0xa787019c, 0x31c27ccd,
    0x9b6169a3, 0x42b1f0f2, 0x2bdbdfb4, 0x72936ff1, 0x8a482021, 0xca5b103c,
    0xcc54e836, 0x0dafcc37, 0x1faa9610, 0xfaad8f15, 0xbf2917ae, 0x53e8b3cf,
    0x910ade2b, 0xb17a131d, 0xf343c996, 0x2f22a0ec, 0x551117a3, 0x7b8cb3ce,
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xe8000000, 0x54000000,
    0xc6000000, 0x23000000, 0xbb800000, 0xefc00000, 0x29200000, 0xff700000,
    0xe0180000, 0xcb640000, 0x02920000, 0x81c90000, 0xd1c88000, 0x59c94000,
    0xbdcda000, 0x03cdb000, 0x9ccdd800, 0xb54bbc00, 0xbf8f2e00, 0x0e280100,
    0xa51b6f80, 0x83e4eac0, 0x9ed0f820, 0x832b4c10, 0x299d5608, 0x31a70d24,
    0xeb3119ba, 0x06fe17d5, 0x8d311991, 0xf5fe17d8, 0xfeb11986, 0xde3e17cf,
    0xf9911998, 0x564e17de, 0x6409199b, 0x51ea17db, 0xf43b198d, 0xc09317f2,
    0xeccb99b3, 0xad4e57fb, 0xb38c3990, 0xe42ee7df, 0xfc1b6198, 0x89651bd2,
    0x2f916fa4, 0xdd49eaea, 0xab8a780d, 0xe82b0c09, 0x80000000, 0x40000000,
    0x20000000, 0x90000000, 0x58000000, 0x44000000, 0x22000000, 0x61000000,
    0x2c800000, 0x21c00000, 0x4ee00000, 0xee100000, 0x65a80000, 0xd9a40000,
    0x54320000, 0x23d90000, 0x9ed88000, 0xb45cc000, 0x669d2000, 0xadfa9000,
    0x52aa4800, 0x3e220400, 0x04777e00, 0x967d0f00, 0x04ec6c80, 0x7887bf40,
    0x1bc7e820, 0x4be05410, 0x70921608, 0x7d6c9b24, 0xffc1da96, 0xb9e07451,
    0x6993daa8, 0x85e97448, 0xa4035aa3, 0xd201b47c, 0x89047aad, 0xa086245e,
    0x1fc4b2af, 0x49e1e04b, 0x81966ca8, 0x09eabf7d, 0x9a056809, 0xd5019423,
    0xe685b60e, 0xccc3cb03, 0x5c66329e, 0xc8d0204b, 0x44c9cc9a, 0x5bf1ef4d,
    0x72388003, 0x7b4cc021, 0x80000000, 0x40000000, 0x20000000, 0xf0000000,
    0xa8000000, 0xcc000000, 0xb6000000, 0xf9000000, 0xe5800000, 0xc8400000,
    0x5ea00000, 0x93100000, 0x3f880000, 0x3d640000, 0x28f20000, 0xe5b90000,
    0x2abb8000, 0x763b4000, 0x7bf96000, 0x1d1d3000, 0x78aa0800, 0x18348c00,
    0xacdc5200, 0x40492d00, 0x68836c80, 0x6fc2ca40, 0x6de0e820, 0xf336fc10,
    0xaa5d3a08, 0xf289913c, 0xbae6b6aa, 0xebb02b73, 0x2d9cb68d, 0x736d2b6e,
    0x0fd53691, 0x10ef6b5e, 0xf697d695, 0xb7c91b7b, 0x43c4bea0, 0x4be0a76e,
    0x7232e49c, 0xdbdd066a, 0xe8cdda0b, 0x6746e12a, 0xd2265eb0, 0xc6d6d76f,
    0x3d698c92, 0x22d0ba7b, 0x0769800f, 0x4dd2403f, 0xebeae007, 0xc812702e,
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xb8000000, 0x74000000,
    0x9a000000, 0x35000000, 0xc7800000, 0xbfc00000, 0xe3200000, 0x87b00000,
    0x32e80000, 0xa5640000, 0xac560000, 0xe0fd0000, 0xda788000, 0x9e3fc000,
    0xa4dca000, 0x334f5000, 0x2297e800, 0x165fdc00, 0x2b0ace00, 0x4e728100,
    0x5aca1980, 0x52510d40, 0x37fbc820, 0xfcfb4c30, 0xec7f8628, 0x753b0d24,
    0xe459bfae, 0xb20e905d, 0x57f73f86, 0x620c507d, 0x8ff31fb9, 0x260cc07b,
    0x3df0579e, 0xdf084c68, 0x1473718c, 0xcfcc116d, 0x05d5261a, 0x30395d13,
    0x6bded79f, 0xf1ca8c5d, 0x72d75184, 0x86bc814b, 0xa19e6e08, 0x5429d103,
    0x3fc3f194, 0x2327d152, 0x27b7863e, 0xa2ef0d2f, 0x80000000, 0x40000000,
    0x60000000, 0x50000000, 0xe8000000, 0x14000000, 0x56000000, 0x79000000,
    0x08800000, 0xd6c00000, 0xb8e00000, 0xec900000, 0xcf880000, 0x0ca40000,
    0x99b20000, 0x8c7b0000, 0x30fe8000, 0xc0394000, 0xd9dda000, 0x91cd3000,
    0x22830800, 0xadc42400, 0xff626600, 0x1bd1df00, 0x4129b880, 0x9a155640,
    0x54482820, 0xdac45410, 0x62e6ce18, 0x0f97cb14, 0x440c56ba, 0x01e6ed45,
    0xc412d6b5, 0x294fad4e, 0x0c4776ba, 0x89269d71, 0x01f67eac, 0x1359b97a,
    0x280a98a4, 0x8be1265c, 0xcf168033, 0xb6cd4009, 0x5707a017, 0xad823031,
    0xac478806, 0xf9226432, 0xd9f34624, 0xbf5eaf1b, 0x8209908a, 0xb0e50258,
    0xe894e631, 0x118c9f39, 0x80000000, 0x40000000, 0x60000000, 0x70000000,
    0x38000000, 0xf4000000, 0x5a000000, 0x6d000000, 0xb9800000, 0xd0400000,
    0x0b600000, 0x09900000, 0x8e480000, 0x04a40000, 0x69b20000, 0x963b0000,
    0xadbf8000, 0xd4ffc000, 0x641aa000, 0x54cc5000, 0x0a642800, 0x4e112c00,
    0x410ab200, 0x67400300, 0x9fe05880, 0x00522440, 0x25690820, 0x3e56bc10,
    0x1a6e3a18, 0x46d27f1c, 0xadab428e, 0x92f3cb7d, 0x8fdcc2b6, 0x26e80b4b,
    0xb3146296, 0xf08f5b78, 0x1b07cab4, 0x4a85b773, 0x06c5d883, 0x8ba2e46b,
    0x09362814, 0xc5fa2c3b, 0x6b9d3207, 0x578bc339, 0xc780f88e, 0x8f417444,
    0x03e0a021, 0x8653500a, 0xae69a836, 0x7cd5ec22, 0xb0af9220, 0x1373933b,
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x38000000, 0xdc000000,
    0xa2000000, 0x7b000000, 0xc2800000, 0x22c00000, 0xf1a00000, 0x37b00000,
    0x37e80000, 0xaae40000, 0x06520000, 0x033b0000, 0xd3198000, 0x48efc000,
    0xe663e000, 0xa5919000, 0x271c9800, 0x9ee8b400, 0x0b652600, 0xea16a500,
    0xfa5fe180, 0x8a0d2540, 0xf434f820, 0x80ade410, 0x4103de18, 0xf580412c,
    0xaa45bf8e, 0xfc62a477, 0x4292a788, 0x279ed04e, 0x772de188, 0x00462574,
    0x2365780a, 0x9e162406, 0x6c5a3e33, 0x070ed12f, 0x0bb2a797, 0x65eed061,
    0x89e5e1b0, 0xa8d22559, 0xbbff7800, 0x85b9243a, 0x1fd9be2f, 0x884e111b,
    0x3c52c79c, 0x343f806b, 0x5b99198a, 0x452bc15f, 0x80000000, 0xc0000000,
    0xe0000000, 0xf0000000, 0xc8000000, 0x44000000, 0xba000000, 0xa5000000,
    0xfb800000, 0xb3400000, 0xc2200000, 0x5c300000, 0x32d80000, 0x67e40000,
    0x52d60000, 0x458f0000, 0x9e2b8000, 0x685c4000, 0xb5272000, 0x96b35000,
    0x181be800, 0xcf803c00, 0x01422a00, 0xc323c900, 0xedb24580, 0xec98b8c0,
    0x1a414820, 0x07a02c30, 0x10756238, 0x5e7ce53c, 0xbb14a7b2, 0x556c1dd1,
    0x067ccf8e, 0x071461d9, 0x836fc5a6, 0xad7bf8e0, 0x2b95e81a, 0x2aab3c0a,
    0x9d9faa28, 0xa3c0891d, 0x7de6e5b6, 0x27d3a8c5, 0x660b8027, 0x516c4038,
    0x9c7f2017, 0xb217503b, 0x40ede81c, 0x923f3c3d, 0x17b1aa11, 0x699b890b,
    0xf1c3659b, 0x8ce4e8f9, 0x80000000, 0x40000000, 0x20000000, 0xd0000000,
    0x68000000, 0xfc000000, 0x1a000000, 0xe1000000, 0xb2800000, 0x8ec00000,
    0x04200000, 0xfe900000, 0x76980000, 0xa5640000, 0x9cf20000, 0xc3e90000,
    0x4bca8000, 0x575d4000, 0x74c0e000, 0x55255000, 0xd413c800, 0xbc5fb400,
    0x2f440600, 0x65621900, 0xfcf4b880, 0x33ebdec0, 0xf3cba820, 0xc35ea410,
    0x92c5ae08, 0xae21bd34, 0x8791969a, 0x801a23ff, 0xa5a25ea6, 0x9fd597e8,
    0x74fe5884, 0xe0138ec7, 0xca58e033, 0x9c415024, 0x1ae1c809, 0xb2b6b41a,
    0xa40e8617, 0xa1ff5914, 0x249458b9, 0xf79e8ef1, 0xe7e0600d, 0xaa351030,
    0x53cba806, 0x535ea43d, 0xdac5ae39, 0x8221bd2a, 0xf5919691, 0x9d1a23c4,
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x08000000, 0x7c000000,
    0xd6000000, 0x91000000, 0xcb800000, 0xf0400000, 0x3ea00000, 0xbab00000,
    0x03380000, 0xd0640000, 0x5dd20000, 0x2c6b0000, 0x6bc98000, 0x96fe4000,
    0xdb86e000, 0x68423000, 0x9aa24800, 0xa8b07c00, 0x303a9200, 0x20e42d00,
    0x2113b180, 0xb80e4fc0, 0xd41f2820, 0xe1970c10, 0x8ccfba18, 0x5c7c212c,
    0x38478b82, 0x62a72edf, 0xbcb7c395, 0x2a3c52f4, 0x6fe4d18a, 0x07963fc0,
    0x55c98035, 0x8bfe400d, 0xae06e02f, 0xc5023023, 0xb1824812, 0x0f407c0c,
    0x10229212, 0x2b702d13, 0x8ad9b18b, 0x0ef14ffc, 0xdf9ca81e, 0x31d64c2b,
    0x626ada19, 0x5ecf513e, 0x4f78a3b1, 0x18c022c5, 0x80000000, 0x40000000,
    0xe0000000, 0x10000000, 0xb8000000, 0xfc000000, 0x62000000, 0xc1000000,
    0x56800000, 0x46400000, 0x03200000, 0x9a100000, 0xb9380000, 0x90e40000,
    0xf8f20000, 0x78cf0000, 0xa2ac8000, 0x6e1bc000, 0x6cf6e000, 0xfece9000,
    0x0da84800, 0x339e1400, 0xf9320200, 0x732f6100, 0x71dd3c80, 0x8417e7c0,
    0x5a382820, 0xe7604410, 0xf8322a38, 0x85ab2504, 0xc79d16ae, 0x2f33c2ff,
    0x8429beb8, 0xc05846e0, 0xcbd5748d, 0xead9f3c5, 0xaf922a36, 0xc8fb250d,
    0x730516a0, 0x8f87c2ef, 0x1cc3bebd, 0x8f6346d0, 0x1c33f4bd, 0xeba933c8,
    0xcc9a4a16, 0xfcb17507, 0x0aef3e9d, 0x263886db, 0xc5651485, 0xd937a3f3,
    0xc32a0204, 0x39db6108, 0x80000000, 0x40000000, 0xe0000000, 0x10000000,
    0x08000000, 0x04000000, 0xaa000000, 0x4d000000, 0x88800000, 0xad400000,
    0x2ba00000, 0x4d700000, 0x8cb80000, 0x39640000, 0xa6120000, 0x3baf0000,
    0xcc4c8000, 0x341e4000, 0x43912000, 0xae68d000, 0xb2a9a800, 0x4ecaa400,
    0x24595a00, 0xf8b7c500, 0x425cd780, 0xbbb4c3c0, 0xddde0820, 0xcb773410,
    0xdfbf5238, 0xaee4f104, 0xd2d18582, 0x93cf32c1, 0xe4db0d8a, 0xb1f246c3,
    0xd3ff7fba, 0xb3c567ff, 0xdde1d210, 0xf555b106, 0x1f0c25b3, 0x50b9a2d8,
    0x3f638583, 0xb51032e7, 0x4c2f8da9, 0xa88806f2, 0x947c5f81, 0x6f02b7c8,
    0x8184fa1c, 0x6fc15506, 0xdbe45f82, 0xe656b7ce, 0x688efa3a, 0x347a553c,
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x38000000, 0xf4000000,
    0x12000000, 0x79000000, 0x0c800000, 0x59400000, 0xb4600000, 0x19500000,
    0xf4980000, 0x62a40000, 0x1df20000, 0xc26d0000, 0x75498000, 0x8d7fc000,
    0x9a34a000, 0xb64a1000, 0xc4fe8800, 0xb1f58400, 0x746b3a00, 0x364ddb00,
    0x84f9b680, 0x11f3a2c0, 0xc469a820, 0x0e495410, 0x70fa9228, 0x03f08f2c,
    0xbd69248e, 0x02ca2dfd, 0x29bb0ca4, 0xb791b9ce, 0xa43cbe8b, 0xf654e6ea,
    0x4b1fb22b, 0xaa615f07, 0x66510c9f, 0x8318b9d7, 0xc6673eae, 0x305626d5,
    0xd01a923f, 0x47e08f11, 0x77912493, 0x443e2df4, 0xe6510c8c, 0xc318b9f1,
    0x66673eb5, 0x805626f2, 0xe81a9235, 0xb3e08f2b, 0x80000000, 0x40000000,
    0xe0000000, 0xd0000000, 0x58000000, 0xd4000000, 0x16000000, 0xcf000000,
    0x48800000, 0x34c00000, 0xd4e00000, 0x43900000, 0x42280000, 0x55a40000,
    0x1a320000, 0xda1f0000, 0xb6ba8000, 0xfb0cc000, 0x0557a000, 0x87cb3000,
    0xfdb13800, 0x365aa400, 0xee9e7600, 0x687e4f00, 0x4aed5080, 0x8b46ab40,
    0xeca61820, 0x0db65410, 0x1e586e38, 0x52981b34, 0x227d3e96, 0x1feab075,
    0xcec126a5, 0x49e7e463, 0x6a11c88a, 0xf56c3f69, 0xb301d63b, 0xa2817f01,
    0x51c668bb, 0x19670f67, 0x6ad0ee27, 0xe78bdb2d, 0x67901eb7, 0x7c2d4064,
    0x26a7be80, 0x18b6704c, 0xbbde8681, 0x27d8d469, 0x1ddaf09c, 0x20dd9b5b,
    0x395f2006, 0x0618f039, 0x80000000, 0x40000000, 0x60000000, 0xb0000000,
    0xd8000000, 0x5c000000, 0x26000000, 0x09000000, 0x94800000, 0x45c00000,
    0xb9200000, 0x8e100000, 0xc7980000, 0x43640000, 0xd5720000, 0x6eeb0000,
    0xdb898000, 0x6ff8c000, 0x1197e000, 0xf5ddb000, 0x0c040800, 0x0e070400,
    0xed043e00, 0x5e83d100, 0xb2c76c80, 0x78a21ec0, 0x79506820, 0x327d7410,
    0xe0d45618, 0xd93ea52c, 0x53333ab6, 0xc38cbbd7, 0x13fb52a9, 0xe795cfd2,
    0x94dd049d, 0x1c806aed, 0x31c7be20, 0x7b241108, 0x4d130c96, 0xa4186ee9,
    0xc720000f, 0x9b10000f, 0x1518002c, 0xbfa40007, 0x20d20008, 0xf93b0008,
    0x83318020, 0xab8cc029, 0x97fde02c, 0x9d92b016, 0xbbdf8805, 0x8104c400,
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x78000000, 0xb4000000,
    0x06000000, 0x29000000, 0x98800000, 0x15c00000, 0xe2e00000, 0xd8500000,
    0xa7280000, 0xf8540000, 0x572e0000, 0xb0570000, 0xcb2c8000, 0x7a54c000,
    0x50292000, 0xcdd4f000, 0xf4686800, 0xa2703400, 0xdb18c600, 0x3fef2300,
    0x5c320480, 0x37b81a40, 0x4318c620, 0x1bef2330, 0x42320498, 0xfab81a54,
    0xa598c63e, 0x932f231d, 0x3e520499, 0x1e281a5e, 0x78d0c618, 0xa6eb2318,
    0x2cb404a1, 0x8e7b1a68, 0x43fa4631, 0x94bce326, 0xe09fa4b4, 0x89ac2a44,
    0x2c978e03, 0x814ce738, 0x9fc62aa0, 0xd9e7cd77, 0x5fd524be, 0x2b6bea50,
    0x5bf42e36, 0xca5fd708, 0x02cde291, 0xfd84c979, 0x80000000, 0xc0000000,
    0x60000000, 0xd0000000, 0x48000000, 0x94000000, 0x9e000000, 0x7d000000,
    0x81800000, 0x8c400000, 0x87e00000, 0xffb00000, 0x18c80000, 0xe7b40000,
    0x04ce0000, 0x8db70000, 0x37c88000, 0x39354000, 0xae0c2000, 0xac91b000,
    0xab5fc800, 0xca6dbc00, 0xd867aa00, 0xaef38300, 0xaea95780, 0x0c44c540,
    0x47e7aa20, 0x9fb38330, 0xc8c95798, 0xafb4c574, 0x90cfaa32, 0x13b78315,
    0x4acf57bf, 0xb8b7c56b, 0x22492a12, 0x2b75c336, 0x54ebf79e, 0xd2a33554,
    0x3fd2c214, 0xaa3dcf0f, 0x231d959f, 0x3b8a0a77, 0x7ed4bf99, 0x31bfc941,
    0x645f4814, 0x04ecfc2c, 0x5aa58a0b, 0xcbd53337, 0xe43e1f88, 0x161c3966,
    0x2e0c202d, 0x6c91b00a, 0x80000000, 0xc0000000, 0xa0000000, 0x70000000,
    0xf8000000, 0xdc000000, 0x0e000000, 0x91000000, 0xad800000, 0xe8400000,
    0x49a00000, 0xadf00000, 0xb8880000, 0xc5f40000, 0x8c8e0000, 0x3ff10000,
    0x478d8000, 0x2976c000, 0x414b6000, 0xba16b000, 0x71dfe800, 0xa30bdc00,
    0x00b4aa00, 0xb6ab9100, 0x6342c580, 0x3f20d540, 0x7b34aa20, 0xa3eb9130,
    0xd162c5a8, 0x4790d55c, 0xd19caa1e, 0x6eaf9107, 0x0f44c5ab, 0x6925d578,
    0x46372a35, 0xf86c513d, 0x742425b9, 0xadb0a553, 0x0528221b, 0x3202fd0c,
    0x8f07879a, 0x1481985c, 0x11c7458a, 0x8be21546, 0xa751ca2a, 0x27fc2102,
    0xa9b8ad9e, 0x4519c942, 0xbf6d603c, 0x24a3b004, 0xbe74683b, 0x99c81c1e,
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x18000000, 0x64000000,
    0x02000000, 0xb5000000, 0x06800000, 0x3cc00000, 0x51a00000, 0x8bb00000,
    0xe8a80000, 0x2fb40000, 0x4aaa0000, 0x8ab30000, 0xa42d8000, 0xca73c000,
    0x938ea000, 0xf6c3d000, 0xc8a30800, 0xe337e400, 0xef68ee00, 0xb3966900,
    0x28593380, 0xbefeec40, 0xdec8ee20, 0x88266910, 0x38f133b8, 0x054aec7c,
    0x8e62ee26, 0xd3956909, 0x985cb3b8, 0x46f92c51, 0x4acc4e27, 0x9226b906,
    0xe9f7bbac, 0x01cac873, 0x07a6a01d, 0x84b7d00d, 0x2f29083e, 0xfff4e411,
    0xeecd6e14, 0x3021a92f, 0x4cf593a2, 0xef4a3c50, 0x47646600, 0xb3154d1e,
    0x1398fda1, 0xa4db956d, 0xfb39f58d, 0x17eb7167, 0x80000000, 0xc0000000,
    0xa0000000, 0x50000000, 0x88000000, 0xd4000000, 0x82000000, 0x07000000,
    0x10800000, 0x91c00000, 0xaa600000, 0x52100000, 0x48780000, 0x8e140000,
    0xde7e0000, 0xab110000, 0x99fc8000, 0xa2554000, 0x765a2000, 0xd8215000,
    0x6b321800, 0x0ecdd400, 0xaa9c9600, 0xd1c78700, 0xca638680, 0xa21404c0,
    0x907c9620, 0xd2178730, 0x887b86a8, 0x2e1004d4, 0x8e7a9602, 0x23128705,
    0x4df90688, 0x205444d5, 0x715c3606, 0xc8a69721, 0xfaf13ea2, 0xa4a8c0c1,
    0xf88ab814, 0x99b8c402, 0x44702e15, 0x7c6a432b, 0x3b692892, 0x4bee07da,
    0x2a2d1e80, 0x584c90f9, 0x565a2022, 0x48215008, 0x43321820, 0x8acdd41d,
    0xa09c961e, 0x02c78714, 0x80000000, 0xc0000000, 0x60000000, 0x70000000,
    0xd8000000, 0xbc000000, 0xc2000000, 0xc9000000, 0x5d800000, 0x50400000,
    0x07e00000, 0x5eb00000, 0xf7680000, 0x0ab40000, 0xf16e0000, 0xadb70000,
    0x0fed8000, 0x0d71c000, 0x7bc86000, 0x0f67d000, 0x41762800, 0xa1c93c00,
    0x1a66aa00, 0xaef40300, 0xe088df80, 0xfc04f840, 0x6206aa20, 0xd9040330,
    0xf580df98, 0x3440f85c, 0x79e0aa16, 0x55b7031f, 0x63eb5fa8, 0x0772386e,
    0xa6cb4a01, 0xf4e6130b, 0xa63097a9, 0xf0a91479, 0x8015a83c, 0x53bffc09,
    0xe32b4a15, 0xa3561312, 0x6cd8979f, 0xda5d147a, 0xae9ba833, 0x1cb8fc3d,
    0xd9aeca21, 0x6d93d321, 0xbbfef793, 0x28cdc47b, 0xe7e00006, 0xeeb00014,
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xb8000000, 0x24000000,
    0x06000000, 0xa5000000, 0x1e800000, 0x04c00000, 0xdfa00000, 0xec700000,
    0x5ee80000, 0xc0740000, 0xd4ea0000, 0x9f770000, 0x1d688000, 0x9e32c000,
    0x5989a000, 0xb1a2f000, 0x95748800, 0x026e0400, 0x37b2ae00, 0x08c9f900,
    0x4d444d80, 0x9ee44e40, 0xc892ae20, 0x2179f910, 0xb48c4d98, 0x43204e54,
    0x3bb0ae0e, 0xb2caf919, 0xfa46cd99, 0xcb618e7d, 0xebd38e09, 0xc699c918,
    0x209965ae, 0x9598ba46, 0x531c881e, 0x23da0428, 0x4278ae1b, 0x2f0ef921,
    0x6964cdb9, 0x08d28e5f, 0x1d190e35, 0x6ad80909, 0xf6fa45aa, 0x44cb8a42,
    0x97432017, 0x79e3302b, 0x2517a83f, 0x263d340d, 0x80000000, 0xc0000000,
    0x20000000, 0xd0000000, 0x78000000, 0xac000000, 0xfa000000, 0xbf000000,
    0x21800000, 0x44400000, 0xc1e00000, 0x8b300000, 0xa4280000, 0xd1340000,
    0x0b2e0000, 0xa8b50000, 0x33688000, 0xeb56c000, 0xab5de000, 0x94f91000,
    0x812c1800, 0x7fb61c00, 0xe6eb3a00, 0x29109300, 0x57bda380, 0x2d4e5240,
    0xbac33a20, 0x94249330, 0x8693a388, 0xeafb5274, 0xd02bba3e, 0x9732531b,
    0x162e43b6, 0x4a32425b, 0xd4afa236, 0x7df04f0a, 0x3a0b7986, 0x40a7d179,
    0x1452819f, 0x6adcdd7e, 0x20bba3a4, 0xe8cf5263, 0x2085ba1b, 0x14c75330,
    0xbd26c3b0, 0xc214825d, 0xe03a420d, 0x0c0d5f34, 0x35a1619f, 0x02d0cd6d,
    0x0b1f3b96, 0x8b1f8e72, 0x80000000, 0x40000000, 0x20000000, 0xd0000000,
    0xc8000000, 0xd4000000, 0xd6000000, 0x21000000, 0x95800000, 0x3e400000,
    0xb8600000, 0x8b900000, 0x1c580000, 0x69940000, 0x5b5a0000, 0xe5150000,
    0x3c9c8000, 0xa9334000, 0x2c6a2000, 0x5c7df000, 0xd3672800, 0x7d175c00,
    0x6099da00, 0x8b331f00, 0x0b6e4680, 0x20fc9dc0, 0xaca1da20, 0x2d371f10,
    0x726c4688, 0x897d9df4, 0x40e75a12, 0xaa515f25, 0x997ae6bd, 0xe8e32dfc,
    0x8e525237, 0x577ff32a, 0xd5e61493, 0x19d66ede, 0x9e3b4eb0, 0xd90231f0,
    0x39852825, 0x04465c37, 0x83675a17, 0xf5115f3e, 0x949ae6b4, 0x8d332df1,
    0xe26a520c, 0x617bf338, 0x44e41486, 0xb4576ed5, 0x6c7dce82, 0xab6471e0,
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xb8000000, 0x94000000,
    0xaa000000, 0x11000000, 0x67800000, 0xa0c00000, 0x53200000, 0xb7500000,
    0xa2780000, 0x11540000, 0x5d7e0000, 0xd5d10000, 0x0f3e8000, 0x53b4c000,
    0xce8a2000, 0xd8399000, 0x7b36a800, 0x02c8ac00, 0xf558ae00, 0x7403b500,
    0xda025480, 0x1900c6c0, 0x5b80ae20, 0x26c7b530, 0x7c2454a8, 0x6bd5c6c4,
    0x74382e0e, 0x85367515, 0x19cef482, 0x93d996c0, 0x0b422617, 0xbde7893d,
    0x5774d296, 0x5faa1fed, 0xf268f4bf, 0x90cc96f9, 0xb05aa621, 0x19864928,
    0x7bc672b4, 0x95a24fd9, 0xd814fc94, 0x7d986aff, 0xcb20000e, 0xf3500008,
    0x10780012, 0x8454003a, 0x28fe0013, 0xf011001a, 0x80000000, 0x40000000,
    0xe0000000, 0x70000000, 0xc8000000, 0xe4000000, 0x76000000, 0x29000000,
    0x07800000, 0xbbc00000, 0x5de00000, 0x6d500000, 0xdc680000, 0x24540000,
    0xebea0000, 0xb7930000, 0x22098000, 0x64c54000, 0x3366a000, 0x3112f000,
    0x4a4de800, 0xdce1cc00, 0xbed1b600, 0x39ae6300, 0xc4b07c80, 0x3f387040,
    0x1d3bb620, 0x2a3d6310, 0x70b9fcb8, 0x02fd305c, 0xe1dd1612, 0x44ef9329,
    0x111414a5, 0x9a4cfc56, 0x84e4a013, 0xe2d5f007, 0x63ae6832, 0x7fb78c0d,
    0x67be9604, 0x8879d31e, 0xcb9b34b0, 0xfbcb4c7c, 0xee27e81e, 0x74b2cc2e,
    0x57383619, 0x693b2326, 0xe43edc9f, 0x75be805e, 0x977c5e24, 0x051faf35,
    0x3789ca92, 0xc0021353, 0x80000000, 0xc0000000, 0x60000000, 0x10000000,
    0x68000000, 0x64000000, 0xfe000000, 0x5d000000, 0x8c800000, 0x99400000,
    0x6d600000, 0x8af00000, 0xc6480000, 0xe3f40000, 0x7cce0000, 0x33b70000,
    0x1b2e8000, 0x71044000, 0xa685a000, 0x2247b000, 0xa0e14800, 0x6d30d400,
    0xf56d0200, 0x2be4ff00, 0x78b47580, 0x6eaa3d40, 0xfac30220, 0x1fa3ff30,
    0x2152f598, 0x111a7d44, 0xdbe8a23a, 0xbda34f29, 0x2e553da7, 0x2a9ae953,
    0x152e0019, 0x9407000f, 0x4606803c, 0x31004031, 0x0683a008, 0x5244b007,
    0xd8e1c83b, 0x61339439, 0x6f6e2214, 0x88e30f02, 0xa9369dad, 0x7b6e5966,
    0x0ee7c83f, 0xf830940f, 0x6deea213, 0x34a04f0a, 0x44d5bdaa, 0xf2d9a945,
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xe8000000, 0xdc000000,
    0x9e000000, 0xf9000000, 0x15800000, 0x4f400000, 0x42a00000, 0x3e300000,
    0x3e380000, 0x0b340000, 0x2dba0000, 0x29710000, 0x089b8000, 0xd7064000,
    0x44856000, 0x26c6b000, 0xa3e0a800, 0x6d931c00, 0xc98b5200, 0xe44a4900,
    0x9d2a4380, 0x2f7848c0, 0x50915220, 0x960b4910, 0x8009c3a8, 0x750a08cc,
    0x868e321a, 0x34ccf927, 0xc9eaeb8f, 0x039b54f2, 0x0d82001f, 0x9b450034,
    0x90a1801f, 0x8137403d, 0xe6bee030, 0x13f0f026, 0x475dc83c, 0xb961ac3b,
    0x5251fa08, 0xefe85524, 0x1e9a918a, 0x220441cc, 0xb7067185, 0x9481b1fc,
    0x5ec239a0, 0xa7e35de6, 0xc79723bf, 0x728af8ce, 0x80000000, 0xc0000000,
    0x60000000, 0xf0000000, 0x88000000, 0xc4000000, 0x9e000000, 0x1f000000,
    0x60800000, 0x3a400000, 0xb3a00000, 0xa3700000, 0x19980000, 0x20740000,
    0xfb1e0000, 0x47370000, 0x15398000, 0x73834000, 0xa0c7a000, 0x98e3b000,
    0x17515800, 0xac2bb400, 0xea0b0a00, 0x4ab86900, 0x79453180, 0x3124d5c0,
    0x34350a20, 0x7fbf6930, 0xd0c4b198, 0xd0e395fc, 0xb354aa02, 0xc22fd901,
    0x7d0a69bf, 0xee3861fb, 0xdd07801a, 0x9d84400f, 0xf7c62013, 0x5c64f013,
    0x4310f83c, 0x888b0437, 0xedfdd235, 0xf7679d3e, 0xf5901b9b, 0x09cc4cda,
    0x50dec39a, 0xf957b8ef, 0xfb2de9be, 0x2e8c21f3, 0x1ef9a036, 0x5de4b018,
    0x36d0d803, 0x89ecf431, 0x80000000, 0x40000000, 0xa0000000, 0xf0000000,
    0xc8000000, 0x0c000000, 0xf6000000, 0x91000000, 0xbc800000, 0x02400000,
    0x38e00000, 0x4a700000, 0x7b880000, 0xfd740000, 0x2e0a0000, 0x27b10000,
    0x1ead8000, 0xfa274000, 0x0ed5e000, 0x341cf000, 0x760f6800, 0xf3b21400,
    0x7cabfa00, 0xa9251300, 0x11550980, 0xe1dcdf40, 0x9729fa20, 0xaee01310,
    0xcb7289a8, 0x5f0a9f7c, 0xcb319a12, 0x24eba313, 0x06c00195, 0xbea07b58,
    0x2897083d, 0xa6f9a413, 0x6379721b, 0x61bff70a, 0xc51b9b83, 0xda8ad87c,
    0x69f28998, 0x704a9f6f, 0xd1519a3e, 0x01dba32d, 0xc728019c, 0x96e47b69,
    0x0f75082b, 0xa50ca40a, 0xac36f22d, 0x096db736, 0xb801fb8d, 0x8404686b,
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x78000000, 0x4c000000,
    0x52000000, 0xe7000000, 0x28800000, 0x62400000, 0x00600000, 0x01300000,
    0x4b480000, 0xec340000, 0x38ce0000, 0x2cf10000, 0xc1ef8000, 0x2f22c000,
    0x42d5e000, 0xf2bc5000, 0x1258d800, 0x852a1400, 0x70014a00, 0x18015700,
    0xdc036380, 0x1a033d40, 0xd3074a20, 0x36845730, 0xd742e3a8, 0xcfe0fd4c,
    0x4bf52a3e, 0x296ec723, 0xed61dbbc, 0x72b7b975, 0x8b8b3834, 0x1513443b,
    0x3b18123c, 0xafc88335, 0x1c704986, 0x7fa8fa70, 0x354711ba, 0x90e02e42,
    0x8f73bba0, 0x292d2954, 0x72000008, 0x17000018, 0xf0800004, 0x1e400037,
    0x2a600002, 0xaa300003, 0x31c8001d, 0x6974000d, 0x80000000, 0x40000000,
    0x60000000, 0x10000000, 0xd8000000, 0xac000000, 0xe2000000, 0xb3000000,
    0x03800000, 0xd5400000, 0x76600000, 0xaab00000, 0x09480000, 0x93b40000,
    0xfdca0000, 0xa3770000, 0x6bea8000, 0x5921c000, 0xe3d7e000, 0x327ad000,
    0x34bc7800, 0x6f9fcc00, 0x6f4b5200, 0xe6b13f00, 0xbb492780, 0x98b7c540,
    0x42495220, 0x4c323f10, 0x0289a798, 0x12110544, 0x8cdc3216, 0xd42d2f3b,
    0xb6803fa0, 0xb3c71968, 0x3da39816, 0x4b111c0e, 0x685d2a3d, 0x3ce9f302,
    0x8ca0f5b4, 0xab933a7a, 0x069d95ba, 0x23c82a7e, 0x6a760da0, 0x176d3653,
    0x7de12794, 0x2bf3c571, 0x412b5223, 0xa0013f3a, 0x3001278a, 0xa803c56b,
    0x6403520a, 0x96053f23, 0x80000000, 0x40000000, 0x20000000, 0xb0000000,
    0xe8000000, 0x9c000000, 0x6a000000, 0xbf000000, 0xdd800000, 0xac400000,
    0x42200000, 0xd0100000, 0xe8380000, 0x59140000, 0x80ba0000, 0x07d50000,
    0xeb5f8000, 0x4da24000, 0x67536000, 0xf99d1000, 0x34409800, 0x5620fc00,
    0xb6157a00, 0x653a2d00, 0x4f955a80, 0x077d5cc0, 0x3cb77a20, 0x1beb2d10,
    0x0448da88, 0x381e1cec, 0xb2019a1a, 0x8b017d37, 0x0b84a292, 0xc941b0c3,
    0xc8a7182d, 0x3dd6bc1c, 0x6c5c1a02, 0x74223d37, 0x651242b7, 0x1abbe0da,
    0x70d3600a, 0x1add100a, 0x63e0983f, 0x0670fc02, 0x9e0d7a13, 0xcf3e2d2c,
    0x90975a97, 0x4afc5cff, 0xc8f2fa03, 0x2dcc6d1d, 0x225c3abc, 0x05254cdf,
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x18000000, 0x74000000,
    0x26000000, 0x43000000, 0xdc800000, 0x1c400000, 0x76a00000, 0xad100000,
    0x82480000, 0x6c140000, 0xe3ce0000, 0x7bd30000, 0x23ac8000, 0xe723c000,
    0xd2d72000, 0x9e2ef000, 0xeae73800, 0x1bb11400, 0xcf5e5a00, 0xbe5ae100,
    0x97dd5280, 0xec1fe340, 0x7e785a20, 0x878de130, 0xe977d2b8, 0x50bb2354,
    0x026dfa26, 0x5c43d12d, 0x56a34ab1, 0x1d130744, 0xca4db811, 0x0015d42a,
    0xb1cbfa2c, 0x1ed4d12f, 0xbc29ca91, 0x27e7c741, 0xb830180c, 0x459fe415,
    0xc5b96227, 0xf5ebf531, 0x40830897, 0x2645024f, 0xcfa508bb, 0x28920244,
    0x4b8f8890, 0xcb76c275, 0x9dba2894, 0xa1e8f256, 0x80000000, 0xc0000000,
    0xa0000000, 0xb0000000, 0x58000000, 0xdc000000, 0xaa000000, 0xa9000000,
    0x6b800000, 0xcbc00000, 0x64600000, 0x92900000, 0x7bf80000, 0xe5940000,
    0xf77e0000, 0x8ad10000, 0xd85b8000, 0xf163c000, 0x83156000, 0x513a9000,
    0xde722800, 0x802acc00, 0x4a4cf600, 0xc7daaf00, 0x74a24280, 0x2873c0c0,
    0x432af620, 0x28cfaf30, 0xd79fc2a8, 0x830500ec, 0x02821636, 0x0043ff07,
    0x1fa50a82, 0xaef39cc6, 0x356c282c, 0x346bcc35, 0xbbef761b, 0x162d6f22,
    0x99492292, 0x4d5850fc, 0xe0e35e2e, 0xa9d6a31c, 0x6ade549a, 0xa9213fdb,
    0x40b47cb2, 0x55cff3d5, 0x421e8abd, 0xdfc05cd3, 0x3a61480b, 0xb5955c1e,
    0x7f7b5e11, 0x1ed2a303, 0x80000000, 0x40000000, 0xe0000000, 0x90000000,
    0x28000000, 0xb4000000, 0xde000000, 0x05000000, 0xd1800000, 0x5dc00000,
    0x25e00000, 0x6bd00000, 0x8c480000, 0xaa540000, 0xb98a0000, 0xdbb30000,
    0x9c5e8000, 0x7afa4000, 0x538f2000, 0x40b6b000, 0xa8dc0800, 0x66bebc00,
    0x03aca600, 0xba84b300, 0x91434880, 0x45a7d940, 0xc1f22620, 0x857ef310,
    0xf34c68b8, 0xc8d16964, 0x64ce2e2a, 0x3c104f3d, 0xa2a8ce8f, 0xdd01da65,
    0x9d87669e, 0xffc4966a, 0xdae468a6, 0x4955696f, 0xb10c2e05, 0xddf74f24,
    0xaf7c4ea2, 0xc8489a64, 0x8c56c6ad, 0xc088665f, 0xf03740a8, 0x329d655e,
    0x3f9c8001, 0x6a1d4039, 0xb1dba015, 0x9d3ff030, 0x656da82d, 0xdbe24c31,
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xe8000000, 0xac000000,
    0x9e000000, 0x13000000, 0x0b800000, 0x68400000, 0x2fa00000, 0x21d00000,
    0x99d80000, 0x3a540000, 0x899e0000, 0x01f10000, 0x82498000, 0x512e4000,
    0x9298e000, 0x3674b000, 0xcc097800, 0xd98d6c00, 0x62cc7a00, 0xe6e8f100,
    0x5f7bc480, 0x010647c0, 0xb685fa20, 0x38c6b130, 0x106324a8, 0x1032f7fc,
    0x28ac821a, 0x17dbdd1b, 0x51575e8f, 0x961e06f8, 0x43b14698, 0x64e89ac1,
    0x5a7d24a4, 0xe583f7c0, 0x53450216, 0x28259d33, 0x2797be9c, 0x4d7eb6db,
    0xbc063eb9, 0xe604f6df, 0x0700dea0, 0x218146d7, 0xa140268e, 0x05226ad9,
    0xcf14bca6, 0xc6be2bd1, 0x57e60017, 0x76750015, 0x80000000, 0x40000000,
    0x60000000, 0xf0000000, 0x18000000, 0x7c000000, 0xea000000, 0x27000000,
    0x3a800000, 0x4c400000, 0x99600000, 0x4c700000, 0x04780000, 0xeef40000,
    0x743a0000, 0xfd970000, 0xef4d8000, 0xdb6fc000, 0x31fa6000, 0xdc329000,
    0xa71c5800, 0x0d86c400, 0xdec5fa00, 0xd1226f00, 0xb3120980, 0x9d0b94c0,
    0x8b087a20, 0x060daf10, 0x7b886998, 0xfd4904fc, 0x306c2226, 0x997f6b0f,
    0x3b7793a2, 0xf6fc6bf5, 0x56b3aba8, 0x935b3fdc, 0x18e589a4, 0x60b354f6,
    0x8e5f9a31, 0x8d60ff1b, 0x8276519f, 0xd57950c6, 0xe9778028, 0x3df8c018,
    0x6e37e01b, 0x9c1d503d, 0x2d06383d, 0xad845411, 0x0ec1a23b, 0x5920ab1d,
    0x2715f3ac, 0x130afbc5, 0x80000000, 0x40000000, 0xa0000000, 0x90000000,
    0x28000000, 0xbc000000, 0xae000000, 0xef000000, 0x5a800000, 0x58400000,
    0xc3200000, 0xcf100000, 0x3c080000, 0xed940000, 0x104a0000, 0x0cb10000,
    0x265e8000, 0x11384000, 0xdb0f6000, 0xdb173000, 0x6e091800, 0x0c936400,
    0x35cf9a00, 0x26741d00, 0x013dd280, 0xb30f6540, 0xc7111a20, 0x500c5d10,
    0xcb92b2a8, 0xd3485564, 0xd030022a, 0x2d1b393f, 0x269f2883, 0xa359485f,
    0x7eb950bc, 0x14cd1c69, 0xe3f7d293, 0x1bfe657c, 0x2c6f9a1b, 0xf1241d36,
    0x5e15d2bd, 0x018b6540, 0xc3531a11, 0x0d295d2d, 0x53863297, 0x21c1154f,
    0x77e1e211, 0xbf744926, 0x50b95083, 0xbbcd1c6b, 0x1977d2a5, 0xd3be657a,
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x18000000, 0x3c000000,
    0x6a000000, 0xdd000000, 0xdc800000, 0xf6c00000, 0xf9a00000, 0x9e100000,
    0xfbd80000, 0x2e940000, 0xdf1e0000, 0x46370000, 0xff8e8000, 0xb22fc000,
    0xa23b6000, 0xb2e29000, 0xe7f28800, 0xd7aef400, 0x7e7cfe00, 0x7a815900,
    0x89c21e80, 0xbc20cfc0, 0xf2527e20, 0x5bbe9930, 0x74a17e98, 0xfa965fc4,
    0x411ef626, 0xb5376d3f, 0xb80b0082, 0x376cc6f3, 0x90d98891, 0x951232c2,
    0x505d769c, 0xb9d76be4, 0x1cf96837, 0xcf44a40d, 0x5fe3960d, 0x9376fd0a,
    0x756908aa, 0xd9daf2e2, 0x779096ac, 0x259e3be0, 0x0ff68009, 0x23abc03c,
    0x507d601e, 0xe1819004, 0xfa420831, 0x77663414, 0x80000000, 0x40000000,
    0xe0000000, 0xb0000000, 0x78000000, 0xe4000000, 0xde000000, 0x8b000000,
    0x44800000, 0xdcc00000, 0xeb200000, 0xb0700000, 0xb0e80000, 0x08f40000,
    0xa62a0000, 0x2ed30000, 0x8ddf8000, 0xa078c000, 0xddcca000, 0xc7843000,
    0xa443f800, 0x5de59400, 0xc653de00, 0x531f6d00, 0x1a5aed80, 0xcc3c5240,
    0x1c2c5e20, 0x3bd7ad10, 0xa25e4db8, 0x883c626c, 0x922da63e, 0x78d53929,
    0x7ad8138f, 0x6ef8cf4e, 0x2c0c6baf, 0x07219b5e, 0x52711595, 0x51edc672,
    0xd175803b, 0x296bc030, 0x67b32002, 0x5f4cf010, 0x84475837, 0x4de5a406,
    0xee522602, 0x7f1df903, 0x585cb38d, 0x7d38ff66, 0x0dad9399, 0x28930f50,
    0xd13f4b91, 0x0fad6b79, 0x80000000, 0xc0000000, 0xa0000000, 0x50000000,
    0xa8000000, 0x2c000000, 0x0a000000, 0x0d000000, 0x0d800000, 0xf3400000,
    0x49600000, 0x53300000, 0x2ae80000, 0x6ab40000, 0x67ae0000, 0x50d10000,
    0xea1c8000, 0x07fc4000, 0x1c09e000, 0x83c21000, 0x8fa08800, 0xcd12fc00,
    0x46b95200, 0xbc6a5700, 0x0b765b80, 0xa9084840, 0x6a45d220, 0xaae61730,
    0x7b77bba8, 0x910e5854, 0x4e435a0a, 0xdce1eb3b, 0xd47469aa, 0xbd8d4f57,
    0xba866189, 0x6bc2f347, 0xc3a25398, 0x3712f473, 0xb3bb602b, 0x35ef5009,
    0xde35e80b, 0xe76cac1c, 0x39f03a1b, 0x7ecabb2f, 0xabe7818d, 0xecf4e35f,
    0x674cdba2, 0x76a10870, 0xde96b21f, 0x96fd4731, 0x838c538a, 0x0983f449,
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xe8000000, 0xcc000000,
    0xba000000, 0x1d000000, 0x6c800000, 0x37400000, 0x06e00000, 0x9ad00000,
    0x3dd80000, 0xcc540000, 0x579a0000, 0x46330000, 0x4a0f8000, 0x950c4000,
    0xd08de000, 0x454b9000, 0x47ea0800, 0x345d7400, 0xa394f200, 0xa83f2300,
    0xe907f480, 0x028125c0, 0x54437220, 0xb1676310, 0x8e1014b8, 0xb1f9b5ec,
    0xb1a6fa1a, 0xdc365723, 0x47090696, 0x418d06eb, 0x73cb0681, 0xddaa06ee,
    0xb63e86b7, 0xc20546dd, 0x2904e6b6, 0xa28696f1, 0x04410e98, 0xe96772ff,
    0xaa12748a, 0xc7fe65d3, 0x16a11237, 0xadb0b323, 0x1ccffcba, 0x702b51e8,
    0xeffa0028, 0x7aa30016, 0x47b7802f, 0x59c8400a, 0x80000000, 0xc0000000,
    0x60000000, 0xd0000000, 0x18000000, 0x2c000000, 0x62000000, 0x4b000000,
    0xbd800000, 0x5cc00000, 0xb4200000, 0x31900000, 0xee880000, 0x7e140000,
    0x414e0000, 0xebb70000, 0x86188000, 0xce1fc000, 0x3a1de000, 0x141ad000,
    0xed1cb800, 0x0399bc00, 0xcede9e00, 0x443d7d00, 0x8a8c0280, 0xe8105140,
    0x244e1e20, 0xaf36bd30, 0x345fe298, 0xb77d8174, 0x816a2626, 0x3420c13b,
    0xf1949c80, 0x8e8e2c66, 0xae149c89, 0x594e2c6c, 0xc7b49c8d, 0xe41e2c5a,
    0x851c9caa, 0x879a2c47, 0x48da9c9b, 0x59392c6b, 0x320c1c93, 0x2051ec66,
    0x3a297cba, 0xcbc4fc79, 0x03a02485, 0xa253906a, 0x612c02b2, 0x0e405177,
    0xa3661e37, 0x6c72bd2a, 0x80000000, 0x40000000, 0x20000000, 0xd0000000,
    0x98000000, 0xb4000000, 0xb2000000, 0xf9000000, 0x2d800000, 0xa2400000,
    0xd3e00000, 0x39300000, 0xaf980000, 0x9eb40000, 0xd0da0000, 0x6ad50000,
    0xd6ac8000, 0x1129c000, 0x9e6d2000, 0x220e5000, 0x087be800, 0x7581bc00,
    0x76463a00, 0x91e48300, 0x88316380, 0xae19b7c0, 0x3af2ba20, 0x48394310,
    0x87664388, 0xf6f2e7f4, 0xfe3dd206, 0xa4653f3d, 0xde7759a4, 0xeffd34ca,
    0x2ac3d98d, 0x5220f4d5, 0x0f94f9b0, 0x47cba4d4, 0x54db91ae, 0xf0d7d8c6,
    0xf3aa8ba2, 0x72a80be3, 0x5b2c8037, 0x2369c03c, 0xf58d202e, 0x7f3e5013,
    0x8de3e829, 0xa635bc0b, 0x391c3a36, 0xa0718309, 0xa0fde3b5, 0x244077e9,
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x38000000, 0x74000000,
    0x02000000, 0x4d000000, 0x9c800000, 0xdfc00000, 0x40e00000, 0x30300000,
    0x09380000, 0x82b40000, 0x7dfe0000, 0x79d50000, 0x7f8d8000, 0x3d4cc000,
    0x692a2000, 0xeadad000, 0xa5014800, 0x6081b400, 0xb1c47600, 0x0be71300,
    0xdbb76780, 0x737f72c0, 0x8311f620, 0x9fefd330, 0x9cbb4788, 0x1bf4a2dc,
    0x8bdb3e2e, 0xdf83a72d, 0x98469188, 0x1ca0a1cf, 0x3692b189, 0x76af71da,
    0x529e79b8, 0xc9a205f3, 0x6e102f83, 0xb36fc6e6, 0x5b7e0029, 0x5f150030,
    0x81ed803c, 0xefbcc00a, 0x8472203c, 0xf39ed011, 0x93274803, 0xe6d0b41f,
    0x260ff61c, 0x120ad33d, 0xf00ec78d, 0xed0c62f9, 0x80000000, 0xc0000000,
    0x20000000, 0xf0000000, 0x28000000, 0x0c000000, 0x02000000, 0x39000000,
    0xa5800000, 0x1b400000, 0x3ca00000, 0xb2500000, 0xd5780000, 0x61d40000,
    0xe13e0000, 0xc7f50000, 0x2aa98000, 0x83ec4000, 0x4e4de000, 0x859a5000,
    0x91a52800, 0xd1d4fc00, 0x293eb200, 0x1bf67900, 0xf0abb080, 0x9eeedac0,
    0xe5cf3220, 0xa5de3930, 0x31805088, 0xdd458afc, 0xdba59a2a, 0xf4d78533,
    0x76bc8288, 0xedb4e3f2, 0x4f896283, 0x00fab3f5, 0x92924aa7, 0xf19b4fee,
    0x87a578be, 0xeed176d1, 0x4bbb2815, 0xb631fc1c, 0x47cf3214, 0xacde390f,
    0x9c005087, 0x3a058af7, 0xcd059a1d, 0x73878518, 0x044482ba, 0xae20e3d8,
    0x379762ba, 0x6e1fb3c5, 0x80000000, 0x40000000, 0x20000000, 0xf0000000,
    0x88000000, 0x0c000000, 0x46000000, 0x63000000, 0x7a800000, 0xf2c00000,
    0x68e00000, 0x9cd00000, 0x57980000, 0x05540000, 0x9fda0000, 0xbf750000,
    0x9bed8000, 0xfc394000, 0xc521e000, 0x20b57000, 0x868df800, 0x7eae2400,
    0x139eae00, 0x2f55c300, 0x6aded880, 0xdef7f7c0, 0x97a92e20, 0x2c198310,
    0x1412b888, 0xf27bc7fc, 0x5c053602, 0x7e02d713, 0xc701ee99, 0xc08020e4,
    0x5fc5409c, 0x7d60e3ef, 0x52961823, 0xaebe5413, 0x8be6d621, 0xa656a702,
    0x855b968e, 0x9db244d3, 0x8b0f8e9c, 0xe4ed10ca, 0xd8bed8ba, 0x00e7f7d0,
    0x00d12e02, 0x499d8329, 0x1250b8bc, 0x275ac7ca, 0x64b2b637, 0xac8e970f,
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x48000000, 0x94000000,
    0x72000000, 0xfb000000, 0xa2800000, 0x4f400000, 0x42200000, 0x52100000,
    0xc7580000, 0x03940000, 0x1e9e0000, 0x2cf70000, 0x8daf8000, 0xc73d4000,
    0xe0272000, 0x1114d000, 0xd9d9f800, 0x9ad14400, 0x9dbd4200, 0xb3673500,
    0xd5332280, 0x32cfa7c0, 0x4c0cc220, 0xe7ed7530, 0xd29b8298, 0x12f637cc,
    0x88aa1a32, 0x00bce115, 0x58e13884, 0xa3f746f2, 0xad2bfa9a, 0x5b7933c6,
    0xa481f834, 0x36454416, 0x33a34213, 0x1bd0353a, 0xf03ca299, 0x7ca2e7c4,
    0x5b53e206, 0x5c7da52c, 0x70047a9f, 0xe80473c4, 0xc406d806, 0x0a019416,
    0x2702ba2d, 0x44857111, 0xc647e09d, 0x1ba6d2e6, 0x80000000, 0x40000000,
    0x20000000, 0xf0000000, 0xc8000000, 0xec000000, 0x02000000, 0x77000000,
    0x2f800000, 0x03c00000, 0x63600000, 0x94700000, 0xc9f80000, 0x14f40000,
    0x51ba0000, 0x82550000, 0x07ad8000, 0xa15b4000, 0x6fe6e000, 0xde355000,
    0x105a5800, 0x4964ac00, 0x9f708600, 0xfc7c1700, 0xb4349580, 0x3b5bd0c0,
    0x8ce70620, 0xf7b25710, 0x7a9ff588, 0xb885c0fc, 0xbc43be12, 0x78a7ab2b,
    0x23172b88, 0x7b8c7be1, 0x44082d99, 0x1fca2ceb, 0x88add830, 0xcadaec14,
    0x5223e603, 0xf0560702, 0xf8aa2dbe, 0x42db2ce3, 0x9e225818, 0x0250ac20,
    0x47aa8614, 0x8159170e, 0x9fe1159d, 0x163490e1, 0xfc5be63a, 0x4b620720,
    0xe8702dbf, 0xd3fe2ce8, 0x80000000, 0xc0000000, 0x20000000, 0x50000000,
    0x08000000, 0xc4000000, 0xea000000, 0x15000000, 0x17800000, 0x2cc00000,
    0x6be00000, 0x05500000, 0x34280000, 0xf3d40000, 0x5d6e0000, 0x1df50000,
    0x525c8000, 0x334d4000, 0xd2c6a000, 0x5ce01000, 0xe3d50800, 0xb56d2c00,
    0xa9f3ae00, 0xe05c9300, 0xea4bb480, 0xeb426a40, 0x8f212e20, 0x8ab4d330,
    0x8b799488, 0xdafb3a54, 0x7d3c8622, 0x865cef01, 0x314bb2b2, 0x73c3c551,
    0xf9643ca7, 0x1613064a, 0xe70ea008, 0x7f641020, 0xbd130802, 0x278c2c12,
    0xc5212e35, 0x0fb4d332, 0xb4f994a6, 0x623b3a7e, 0xf4dc861c, 0x520cef2a,
    0xf8e3b2b3, 0xb9d7c548, 0xd86a3ca6, 0x22760655, 0xea9a2013, 0xbaad503d,
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x48000000, 0x94000000,
    0x26000000, 0xdd000000, 0xe3800000, 0xf3400000, 0x47600000, 0x59300000,
    0x19880000, 0x1bb40000, 0xab4e0000, 0xcc930000, 0x679f8000, 0x66e94000,
    0xbe872000, 0xd0c27000, 0x5424c800, 0x2e55ec00, 0x08bf9200, 0x963cb700,
    0x96f88b80, 0xbade0340, 0x488e1220, 0xf236f730, 0x9f082bb8, 0x3771334c,
    0x9d6bfa32, 0x61c66b15, 0x8da2f1b1, 0x5212287b, 0x675c438a, 0x4acbef69,
    0x4cd18000, 0x6a7a401d, 0x3918a014, 0x862b3013, 0xa2a3e820, 0x6a979c37,
    0x7a9b5a2e, 0x65695b14, 0x7dc719ac, 0xdfa2b46d, 0x991699bb, 0x11d8f472,
    0xce0e3999, 0xdef3c458, 0xa92dd189, 0x9a245856, 0x80000000, 0x40000000,
    0x20000000, 0xf0000000, 0x88000000, 0x24000000, 0x86000000, 0xd5000000,
    0x3f800000, 0xddc00000, 0xa2600000, 0xb6100000, 0xe8d80000, 0xa0940000,
    0x909a0000, 0x00350000, 0x3c6d8000, 0x67b94000, 0xc500a000, 0x27837000,
    0xa1c10800, 0x78660c00, 0x49152600, 0xa059ff00, 0x11d5c680, 0x05bf01c0,
    0xf602a620, 0x1d05bf10, 0x3b80e688, 0xabc131fc, 0xff610e02, 0xad91c319,
    0xb31b48a9, 0xd7f682c9, 0x190ece8d, 0x352c0dee, 0x3e9a0021, 0x41350034,
    0x2ded801f, 0xbb79402a, 0x56e0a00f, 0xbd537011, 0x52f9081b, 0x66220c33,
    0xacb72632, 0x6b28ff13, 0xf79a46b5, 0x74b741c2, 0x772d861d, 0xfd9e8f19,
    0xf3b6ce8f, 0x93a80dfa, 0x80000000, 0xc0000000, 0x20000000, 0xd0000000,
    0xd8000000, 0x6c000000, 0x52000000, 0x2b000000, 0x55800000, 0x9bc00000,
    0x56600000, 0x18700000, 0x98a80000, 0x74f40000, 0x9dee0000, 0x1cd50000,
    0x40388000, 0x7e6bc000, 0x8a17e000, 0x76db5000, 0x0159b800, 0x799a7c00,
    0xee7b2600, 0x83cc6f00, 0xec049580, 0x9201a240, 0x0b05a620, 0x8586af30,
    0x43c5f588, 0x3a643274, 0x4a737e16, 0xb3ac432b, 0x21708b9c, 0x0629717e,
    0x4ab57583, 0x584bf24d, 0xe6c29e29, 0xfee61308, 0xeb37b38d, 0x1d89cd54,
    0x39a733b0, 0x90160d60, 0x09ded39f, 0x9ad85d6a, 0x935feb9b, 0x7299e165,
    0x6bfb2da9, 0xc00ade4f, 0xd6600007, 0xd8700014, 0xb8a80026, 0xa4f40027,
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x88000000, 0x44000000,
    0xf6000000, 0xef000000, 0x47800000, 0x38c00000, 0x8fe00000, 0x20700000,
    0xcc780000, 0x96f40000, 0x283e0000, 0xe8550000, 0x4c688000, 0xf6394000,
    0x5356a000, 0x55ecf000, 0xb5fed800, 0xe5354c00, 0xe65fde00, 0x47e05300,
    0x8474cd80, 0xca7838c0, 0x21f15e20, 0xa3b81330, 0x6294ed88, 0xda8888f4,
    0x7ec9a602, 0xe06cef21, 0x743d4bb5, 0x325467cf, 0xe16ced93, 0xf0bc88ef,
    0x0f17a636, 0x1749ef37, 0x3badcb88, 0x2e5927ce, 0xe3e44d96, 0x827578e8,
    0x7d79fe24, 0xaa71e329, 0x297ab586, 0xf47084cc, 0x527ed811, 0xcdf54c33,
    0xc1bfde30, 0xf390531a, 0x360ccd85, 0xf78c38db, 0x80000000, 0xc0000000,
    0xe0000000, 0x50000000, 0x38000000, 0xfc000000, 0xc2000000, 0x27000000,
    0x32800000, 0x8ac00000, 0x84200000, 0x17d00000, 0xf6980000, 0x44540000,
    0x77de0000, 0x2d330000, 0x136c8000, 0x341ac000, 0x86976000, 0x87fed000,
    0x6ce75800, 0xc4f2c400, 0x5bcc4e00, 0xac0ac500, 0xb1a80080, 0x5439d9c0,
    0x1f46ce20, 0xfc670530, 0xf935e0b8, 0x356ac9d4, 0x9d1c762e, 0x3916d10f,
    0xdcbb1688, 0x6e85d8dd, 0x38c480a2, 0x2b2319ed, 0xb151ae09, 0x7a59d528,
    0xd972b887, 0xb7880dd8, 0x44e83822, 0x6b581408, 0x5af5163d, 0xcecb0123,
    0x3188ce9f, 0x9de9dcf2, 0x5cd9ae93, 0x95b00cd1, 0xcaac7683, 0xd4bb08d6,
    0x3a83d899, 0xdec1ddfc, 0x80000000, 0xc0000000, 0xa0000000, 0x10000000,
    0x18000000, 0x6c000000, 0xaa000000, 0x81000000, 0x50800000, 0xdac00000,
    0xf3200000, 0xdd500000, 0x15b80000, 0xf2d40000, 0x08fe0000, 0x18b10000,
    0x51ce8000, 0x1b39c000, 0xaf11e000, 0x205e9000, 0xdea6e800, 0x25119400,
    0x715c7e00, 0x3627ad00, 0x83d7a480, 0x307fd8c0, 0x0674fe20, 0x6ceb6d30,
    0x996ec4a8, 0xad2d88c4, 0x73cb7626, 0x2e38a92b, 0x99953282, 0xc19de1e4,
    0xe40124b2, 0x1e0218dd, 0xe7031e1e, 0x6b80fd23, 0x1340acbf, 0x1560dcd5,
    0x5eb66832, 0xbac9543a, 0x6abb1e07, 0x3554fd28, 0x11beac87, 0x9cd1dcd4,
    0x47f8e810, 0x17309414, 0x9c8afe0c, 0x495a6d0d, 0x8a2044bb, 0x91d448e9,
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xa8000000, 0xec000000,
    0x32000000, 0xb7000000, 0x11800000, 0x06400000, 0x7b600000, 0x5b300000,
    0x05a80000, 0x1d740000, 0xdece0000, 0x76470000, 0x23648000, 0x2f364000,
    0x23ade000, 0xdc70d000, 0xa64cd800, 0xe4861c00, 0xf8c10a00, 0x18a51700,
    0x00170b80, 0xe4ff2640, 0x3b6cea20, 0x54d5c730, 0x6e5bd398, 0xbc793a54,
    0x59ade00a, 0x1770d00b, 0x4dccd814, 0xe9c61c39, 0x08210a2e, 0x1ed5173a,
    0x5d5f0b92, 0x13fb267b, 0x8aeaea25, 0x6296c736, 0xed3953b1, 0xa34c7a5f,
    0x82028003, 0x8f054007, 0x3587602b, 0x88419013, 0x5665b80f, 0x11b08c08,
    0x20683224, 0xd757db0a, 0xef1cd9ac, 0x2e9f2d46, 0x80000000, 0xc0000000,
    0xa0000000, 0xd0000000, 0x08000000, 0x3c000000, 0xfe000000, 0xed000000,
    0xae800000, 0x54400000, 0xba600000, 0x94f00000, 0xf4180000, 0xf0b40000,
    0xf67e0000, 0x20410000, 0x18608000, 0xf7f54000, 0x6f9f6000, 0x3e73b000,
    0xda588800, 0x1dd38400, 0x3b0d4a00, 0x0999e700, 0x87736580, 0xc6dec3c0,
    0x82922a20, 0xf6ea5730, 0xa5abeda8, 0x8e4d47f4, 0x5b7f6022, 0xeec3b03f,
    0x3c208817, 0x9597840f, 0xcf6b4a29, 0x086ce71a, 0x39ede591, 0xa82a83de,
    0xe18dca36, 0xffdca719, 0x5e1405bb, 0xc9a973d9, 0xb84ca219, 0x2a7cd33e,
    0x6e4027b1, 0x8d64e0c8, 0xbd75e5b9, 0xf1de83d0, 0xab13ca0c, 0xf32da717,
    0xfe0c85ab, 0x8b1833e4, 0x80000000, 0xc0000000, 0xa0000000, 0x50000000,
    0xf8000000, 0x14000000, 0xda000000, 0x33000000, 0xcc800000, 0xb7400000,
    0xae600000, 0xc8700000, 0xbd080000, 0xf7340000, 0x6f6e0000, 0xa9410000,
    0x7f648000, 0x83f2c000, 0x4cca2000, 0x25151000, 0xd1ff3800, 0xb179b400,
    0xa83ca200, 0x1f5bd700, 0x80aed980, 0xaa640b40, 0x8a768220, 0x6a0ec730,
    0x49b1e1a8, 0x072dbf54, 0x05a2201e, 0xe9511035, 0x6f19381e, 0x084cb418,
    0xee56220d, 0xe9981728, 0xd408799d, 0xc8b7db7e, 0xb4ad9a3c, 0xe0636320,
    0xe176fb98, 0xe28d1c4c, 0xdcf27bae, 0x8e4fdc68, 0xdb505bb6, 0xd01ecc4b,
    0xfac963ae, 0x18127840, 0x547f4192, 0xa9ba6f51, 0x859f3808, 0xda09b43b,
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x68000000, 0x8c000000,
    0xe2000000, 0x19000000, 0x83800000, 0x61400000, 0x25600000, 0x9d900000,
    0x37b80000, 0xf0d40000, 0xb0da0000, 0xd4410000, 0x74e18000, 0x2dd64000,
    0x6d5fe000, 0x86005000, 0x3706a800, 0xd8860c00, 0x8bc04200, 0xafa67700,
    0x55b38680, 0x6d4f86c0, 0x43ffa220, 0xf4362710, 0xf50d2ea8, 0x351d8adc,
    0x10e5e03a, 0x03d15033, 0x365f2810, 0x6c844c1a, 0xbdc5a23a, 0x10a7273b,
    0xd134aeb1, 0x1c8fcae1, 0x1158000d, 0x4c040034, 0x0202000d, 0xc905000e,
    0x9b83800a, 0x85434014, 0x4b64600f, 0x66971012, 0xad38c830, 0x12101c25,
    0xf4f90a30, 0x6cb02b2d, 0xdecd6c95, 0xeabbfdd1, 0x80000000, 0xc0000000,
    0xe0000000, 0xb0000000, 0x78000000, 0xbc000000, 0xc2000000, 0x49000000,
    0x1b800000, 0x12c00000, 0x0e200000, 0xa8700000, 0x1ff80000, 0x3eb40000,
    0x4fde0000, 0x4dc30000, 0xcaa38000, 0xbe34c000, 0xe7986000, 0xdea1d000,
    0xc831a800, 0x4899cc00, 0x42235e00, 0x32756d00, 0xbaff3580, 0x2f371ec0,
    0xd01b3e20, 0x2664bd30, 0xfb169db8, 0xfd6ad2ec, 0x781e603e, 0x9266d01f,
    0x1d142808, 0x7a6a0c3e, 0x909ebe18, 0x6e277d2b, 0xd8737db3, 0x87fcc2f8,
    0x32b42821, 0xf5da0c3b, 0xb8c6be28, 0x13237d15, 0xe5f57dab, 0xf23bc2cf,
    0x6411a83a, 0xd9e9cc06, 0xde5b5e3e, 0x12016d15, 0x410135b4, 0x3f841efe,
    0xdcc0be0b, 0xfd247d34, 0x80000000, 0xc0000000, 0x20000000, 0x10000000,
    0x18000000, 0x34000000, 0x8a000000, 0xd3000000, 0x90800000, 0x78c00000,
    0xa6e00000, 0x31300000, 0x15280000, 0xc5f40000, 0xddce0000, 0x95c50000,
    0xaf668000, 0x2a71c000, 0x4b892000, 0x32e09000, 0x6b313800, 0xfe29d400,
    0x7171de00, 0x370f7300, 0xd426ef80, 0x84d74e40, 0x9498fe20, 0xb81fe330,
    0xa6dfd788, 0x4d3a9a44, 0xa58f2026, 0x93e1903d, 0x2cb1b82a, 0x94691430,
    0x50507e22, 0x8e5b2313, 0xd1f8778b, 0xb16fca78, 0x55d13801, 0x3b19d41f,
    0xce59de16, 0x31fb732d, 0x8168efa8, 0x5dd24e76, 0x171e7e27, 0x705e232d,
    0x68fef79d, 0xc2ee0a6f, 0xb5901801, 0xc93d4430, 0xe78ee600, 0x4ce3a71f,
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x88000000, 0x1c000000,
    0x4a000000, 0x4d000000, 0xfc800000, 0x22400000, 0x8b200000, 0x15900000,
    0x5cf80000, 0xadd40000, 0x62da0000, 0xb0c70000, 0x7a638000, 0x19374000,
    0xa0a96000, 0x61ca1000, 0x937c8800, 0x7810b400, 0xe83bfa00, 0x19b17d00,
    0xb8ee9e80, 0x4fef4ec0, 0x566a9a20, 0xc4af6d10, 0x9fc81698, 0xd878facc,
    0x3b92e002, 0xeff95017, 0x1a57e80a, 0x0319a41f, 0x3c26f21d, 0x6c15890f,
    0xfe3d84b0, 0x7eb063d6, 0x39686c88, 0x192ac7f3, 0xe30f1e82, 0x101b0ef5,
    0x9ba27a13, 0xd5d13d36, 0xd6dc7e98, 0xb6c61eec, 0xc5657215, 0x3cb2c914,
    0x286ce485, 0xcfae73cc, 0xbc4ee482, 0xefbd73fc, 0x80000000, 0x40000000,
    0x20000000, 0xd0000000, 0x18000000, 0x2c000000, 0xbe000000, 0xc7000000,
    0xe2800000, 0x1b400000, 0x3be00000, 0xe8d00000, 0x07780000, 0x31940000,
    0x1d9a0000, 0xf0c50000, 0x8d248000, 0x3ef1c000, 0x8d0fe000, 0x84d93000,
    0xca215800, 0x9c71e400, 0xb6496200, 0x6f3c8b00, 0x3af03c80, 0xb70e74c0,
    0x39de8220, 0xb5a1bb10, 0x28b36488, 0x216e90f4, 0x3cc96026, 0xd079f01b,
    0xab103827, 0xdadc1405, 0xbd235a3e, 0x96f59f0d, 0x490fe6a1, 0xdede2bcb,
    0x87248499, 0x2bf3a0da, 0x368a3821, 0x6a191422, 0x1007da2c, 0x78045f3c,
    0xdc00068d, 0x76071be7, 0xf305dca6, 0x708244cf, 0x62435a10, 0x1e659f22,
    0x1117e6bd, 0x27da2bc3, 0x80000000, 0x40000000, 0xe0000000, 0xf0000000,
    0x98000000, 0xd4000000, 0x06000000, 0x91000000, 0xb3800000, 0xd7c00000,
    0x2b600000, 0xef900000, 0x5f180000, 0x3a540000, 0x2b7a0000, 0xab430000,
    0xaa258000, 0xb6b3c000, 0xb5292000, 0x5e38f000, 0xa4642800, 0x5910ac00,
    0xdd5ab600, 0xa7f38700, 0xc409a280, 0x180e33c0, 0xe20b9620, 0xd90f7710,
    0xd98f8ab8, 0xb2c99ffc, 0xb8eea006, 0x1e5c3025, 0xc3728839, 0xd1489c18,
    0xa72a3e0a, 0x693c1b00, 0x96e41c8b, 0x5556e8df, 0x6df92a9b, 0xb101afeb,
    0xe3862818, 0x5fc7ac3d, 0x97653623, 0xa593472a, 0x1c1d0280, 0x1ed103ec,
    0xde3c9e0e, 0xe4642b3a, 0xb9149484, 0x2d5974cc, 0x3ff49483, 0x100974c0,
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xc8000000, 0xfc000000,
    0xfe000000, 0x81000000, 0x3e800000, 0x30c00000, 0x13600000, 0x8a300000,
    0xfec80000, 0xf0f40000, 0x2eaa0000, 0xdb430000, 0xaf258000, 0xfe914000,
    0xd4186000, 0xbc4db000, 0x7e35e800, 0x5ccb0400, 0x9ff10e00, 0xa92aaf00,
    0xe1077780, 0x8e82fd40, 0x18c16e20, 0x1f631f10, 0xbc309fb8, 0x83cef97c,
    0x3077e012, 0x9f6ff02f, 0xf6a00807, 0x15d3f41c, 0x133e863d, 0xaedb1b33,
    0x6c2c11bb, 0x55811642, 0xdd42f790, 0xba23bd60, 0xd2110e17, 0xa3daaf38,
    0x24af779e, 0xf846fd40, 0xfea36e13, 0x49d41f16, 0xfd3f1fbc, 0x17dcb978,
    0x66aa000b, 0x67430004, 0xb125801b, 0x8f914036, 0x80000000, 0x40000000,
    0xe0000000, 0xd0000000, 0x48000000, 0xc4000000, 0xf2000000, 0x73000000,
    0x24800000, 0x1dc00000, 0xe7600000, 0x2d700000, 0x01780000, 0x5eb40000,
    0x4b1a0000, 0x22430000, 0x6a248000, 0x5dd54000, 0xe468a000, 0x2839d000,
    0x4c13b800, 0x750bb400, 0x644ef600, 0xcaecdf00, 0x5afce580, 0x11f100c0,
    0xd0be5620, 0x6fd10f10, 0x376d5db8, 0x3cbdb4f4, 0xc9d62032, 0x1e6f9021,
    0x7f3f9804, 0x4a972428, 0x53cdee1b, 0x63aabb36, 0x085bab85, 0xcfe56bd7,
    0x46b0c5a9, 0x871d90c0, 0xf4454e33, 0x3b236b27, 0x425013b0, 0x192adfc5,
    0x209c33a5, 0xf5064fff, 0x7d872ba4, 0x26442bf5, 0x3822659a, 0x1ed740e1,
    0x58ea760a, 0xb9f99f0c, 0x80000000, 0xc0000000, 0x60000000, 0xd0000000,
    0x68000000, 0x2c000000, 0x8e000000, 0x07000000, 0x16800000, 0x93c00000,
    0x10a00000, 0x96700000, 0xadd80000, 0xffb40000, 0x607e0000, 0xd2470000,
    0x3de08000, 0x59104000, 0x750fe000, 0xab1b3000, 0x08935800, 0x5049c400,
    0x987d2600, 0x3647f100, 0x2fe70d80, 0x68157bc0, 0x208ac620, 0x8c58c130,
    0x02f25598, 0xc71fbff4, 0x2691603a, 0xe74c703b, 0x36fc383b, 0xe182b435,
    0x9d419e1f, 0x7765052f, 0x9cd173a7, 0xf6af4ee4, 0xe1eeed8e, 0x938d4beb,
    0x20df1e24, 0xec324515, 0xdc3e13a6, 0xf8a43ed6, 0x7a72559c, 0x43dfbfe4,
    0x28b16013, 0x1efc7023, 0x6d843838, 0xa346b419, 0xc8679e1f, 0xce56051e,
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xb8000000, 0x74000000,
    0xae000000, 0x59000000, 0xfa800000, 0x11c00000, 0xdbe00000, 0x45f00000,
    0x15780000, 0xd9340000, 0x0a1a0000, 0x4c050000, 0x9a048000, 0xd704c000,
    0x73852000, 0x5340b000, 0xbe216800, 0x3012a400, 0x098a4600, 0x36cd0b00,
    0xc2eca180, 0x9df974c0, 0x93f56620, 0x5878bb10, 0x7db14988, 0x2adb10f4,
    0xa160000e, 0x1430000d, 0xee980023, 0x4cc40022, 0xa7620010, 0xe1310019,
    0x3e1e801d, 0xc201c007, 0x1301a03b, 0x95847032, 0x16444834, 0x26a21402,
    0xa2d32e23, 0xdfebaf03, 0xc17ce79e, 0xe7317fc7, 0xcb1d47a9, 0x12850fe9,
    0x9dc10fb6, 0x21e31bfd, 0x62f02199, 0x0ef9b4d2, 0x80000000, 0x40000000,
    0xe0000000, 0x70000000, 0x68000000, 0x1c000000, 0x1a000000, 0xb7000000,
    0x1a800000, 0xedc00000, 0xeaa00000, 0xf9700000, 0xd3980000, 0x4fb40000,
    0x11ba0000, 0x10030000, 0x58018000, 0x94044000, 0x76036000, 0xc5039000,
    0xb1855800, 0xed400400, 0xb062d600, 0x09578100, 0xc728a580, 0x768dc9c0,
    0xa77bb620, 0xd2271110, 0x07b47db8, 0xddbd8ddc, 0xf200003a, 0xeb000017,
    0xe080003e, 0x2ac00031, 0x9820001c, 0x08b0003c, 0x2338003c, 0x01c40013,
    0xd8a20032, 0xb2770028, 0xa31b803e, 0x7d77403a, 0xfd9ae022, 0x1eb3d036,
    0xd63c3819, 0x38409435, 0x59e60e3a, 0x7013c51e, 0x014913b1, 0xbad9d8f3,
    0xd1d64bbd, 0x49eadcf6, 0x80000000, 0xc0000000, 0xe0000000, 0xb0000000,
    0x38000000, 0x04000000, 0x36000000, 0x2f000000, 0x1e800000, 0x05400000,
    0x72e00000, 0x3c100000, 0x22180000, 0xaa540000, 0xbc7e0000, 0x6a030000,
    0x6d038000, 0xdf86c000, 0x80c5a000, 0x67207000, 0x60b15800, 0x44694400,
    0x9e1d5200, 0x58516300, 0x4578ca80, 0xeb8407c0, 0x4ec6f220, 0xac221330,
    0xf83212b8, 0x562f83ec, 0xf678002e, 0x57040031, 0x3a860035, 0x63470027,
    0xd5e58009, 0x1e91c000, 0x15582011, 0xc1b5b004, 0xb1ef780f, 0x53dbf42b,
    0xb0f7aa33, 0x2d0b5715, 0xf4cf4093, 0x826ee0dd, 0xa918caaf, 0x12d407f3,
    0xfe3ef21b, 0x8a66133a, 0x5e5412b1, 0x927883e2, 0x1105802a, 0xcd81c011,
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x08000000, 0x6c000000,
    0x02000000, 0x05000000, 0x1f800000, 0x27400000, 0xa2200000, 0x41900000,
    0xb8280000, 0x41d40000, 0x908e0000, 0x90810000, 0x91c48000, 0x38e54000,
    0x91f1e000, 0x4c185000, 0xf32f4800, 0xc952ec00, 0x054a1200, 0x36666d00,
    0x5f37f680, 0x0a7ef040, 0x341df220, 0x072b3d30, 0x0f523ea8, 0x3e485c54,
    0x26e28022, 0x0ef0402b, 0x929b6028, 0xf5ec1015, 0x43322805, 0x907bfc12,
    0xf51aba28, 0x26add111, 0x27162ca9, 0xeaef3159, 0x5db1f6ac, 0x36bbf044,
    0x2f7f7202, 0xbb9b7d3a, 0x88695eaa, 0x91744c78, 0x75d8a83a, 0xf7cfbc16,
    0x52a7da0a, 0x2054c102, 0xd8ce8486, 0xb4208d72, 0x80000000, 0xc0000000,
    0xe0000000, 0x90000000, 0x98000000, 0x84000000, 0x22000000, 0x85000000,
    0xd4800000, 0xc7400000, 0xd7200000, 0x09900000, 0x03b80000, 0x51d40000,
    0xb11e0000, 0x81830000, 0xabc28000, 0xe463c000, 0xf4b0a000, 0x932dd000,
    0x20ec0800, 0x808db400, 0xb63f1200, 0x30119d00, 0x5c7f3680, 0x9fb1c4c0,
    0xdca9b220, 0x602b4d30, 0xeb6fbeb8, 0xe24cb0e4, 0x58dc8006, 0xb0e0c011,
    0xf3f22030, 0xa40e1005, 0xb97ca813, 0x1b306410, 0x63eb1a3d, 0xa3082923,
    0x58fe24b5, 0xe0f359e5, 0xff8c04b9, 0x43bd49d2, 0x71d0acb2, 0xc11d2df9,
    0x8983b6af, 0xb7c104f1, 0x42639214, 0x53b15d0d, 0xc2ad16b3, 0x332fd4fd,
    0x90ed1a11, 0x688f2904, 0x80000000, 0xc0000000, 0x60000000, 0x70000000,
    0x68000000, 0x94000000, 0x02000000, 0xd7000000, 0xfe800000, 0xfac00000,
    0x07a00000, 0x93100000, 0xeab80000, 0xe4d40000, 0x989e0000, 0xf5870000,
    0x42458000, 0x50604000, 0x31372000, 0x83eb5000, 0xb20e1800, 0xc37de400,
    0xc7f06e00, 0xba494900, 0x001c8e80, 0x724108c0, 0x98614e20, 0xb5311930,
    0x99e91698, 0x990bacdc, 0xabfb803a, 0xe8374015, 0x946aa018, 0x974f1029,
    0x659f3825, 0xe805b41b, 0x5405f601, 0x6203ed11, 0xa7064085, 0x968751c7,
    0x6ec2f887, 0x05a5a5e9, 0x4415ae92, 0x143d58c1, 0x1e12d608, 0x9f38bd14,
    0x669058be, 0xa8feb5e8, 0xb4b496b8, 0xa9afecd0, 0x766aa02a, 0xf04f102f,
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xe8000000, 0x4c000000,
    0x3e000000, 0x4f000000, 0x63800000, 0x8ac00000, 0x97200000, 0x64300000,
    0xbe480000, 0x03f40000, 0x73ea0000, 0x7d830000, 0x75c28000, 0xeca04000,
    0x5af2e000, 0xb36eb000, 0x5ac41800, 0xdf20ec00, 0xd8312e00, 0x784f2500,
    0xe8f43780, 0x62692b40, 0x8641ce20, 0xce669510, 0x61d0afb8, 0xf95e8744,
    0x438a801a, 0xf3544003, 0x1f18e037, 0xddedb017, 0x9a869822, 0xba40ac31,
    0x4863ce2a, 0x6ad1950a, 0xf8d82fb7, 0x504dc762, 0x04f2e019, 0xac6eb016,
    0x3144180a, 0x09e0ec3f, 0x99112e30, 0x1f7f2520, 0x0b3c3784, 0xa45d2b5f,
    0x010bce18, 0x5d159500, 0x3d7a2fb1, 0x723ac772, 0x80000000, 0xc0000000,
    0x20000000, 0x10000000, 0x28000000, 0x7c000000, 0xde000000, 0x7f000000,
    0xa6800000, 0x6b400000, 0xe8e00000, 0xf5500000, 0xa9180000, 0x2b140000,
    0xda7e0000, 0x82850000, 0x11468000, 0x2de04000, 0xb6d36000, 0x91dfb000,
    0xd3341800, 0xab0dc400, 0x84eda200, 0x4338f300, 0x0366b080, 0x71966fc0,
    0xaf38c220, 0x35664330, 0x52922888, 0xc7baebc4, 0x0926802a, 0x60f0402f,
    0x87ab603f, 0x37dbb01b, 0x18321823, 0x9f8cc405, 0x76ad220d, 0x2659b322,
    0x99f55083, 0xfa289fd0, 0x401f3a2c, 0x7e95772d, 0xd1b872a6, 0x3a212cc5,
    0x20726ab1, 0xc7e9e8eb, 0xdbb948af, 0x27215bca, 0x07f49807, 0x652c8405,
    0xd69e423b, 0x2dd6030f, 0x80000000, 0x40000000, 0xe0000000, 0x50000000,
    0x28000000, 0x14000000, 0xf6000000, 0xbf000000, 0x17800000, 0xf8400000,
    0x21a00000, 0xfd300000, 0x41f80000, 0x92f40000, 0xd81a0000, 0xae630000,
    0x34d08000, 0x556e4000, 0x6a3e2000, 0xd510f000, 0x4f885800, 0xa32e8c00,
    0x889ffa00, 0x3da15100, 0xef30bb80, 0x90fd8ac0, 0x56715a20, 0xfddfe110,
    0x2a86c3b8, 0xb6c3f6d4, 0xb966f82a, 0x77503c15, 0xbb298205, 0xa49f2d3b,
    0x17a7198f, 0xe23257fb, 0xe67e1b95, 0x12b33ac0, 0xc5bf220d, 0xb1559d1e,
    0x3c2b618c, 0x6f1f2bc5, 0x5de1398a, 0xa296a7cb, 0xa7cc438c, 0x4a8eb6cb,
    0x31a85801, 0xa25e8c3d, 0xd6c7fa2f, 0xa965511f, 0xbf52bbbc, 0xff2a8ad7,
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x08000000, 0x24000000,
    0xae000000, 0x05000000, 0x17800000, 0x73c00000, 0x6c200000, 0x71500000,
    0xe5e80000, 0x3d140000, 0x6e0a0000, 0x26610000, 0x2bb58000, 0x4f1d4000,
    0x2a6aa000, 0xd2d33000, 0x202e0800, 0x28334c00, 0x7ade7600, 0x374bbd00,
    0xe205c480, 0x9f065640, 0xe4815620, 0xbd45cd10, 0x8a616ca8, 0xe1b62a7c,
    0x44192822, 0xc8e93c19, 0xbe90de03, 0x1bcac13d, 0x9b403a87, 0xeb63e755,
    0xf8304490, 0xc2db164d, 0xbb4bf634, 0x9806fd3f, 0x3c0764aa, 0xd2016660,
    0x77055e3a, 0x90878104, 0xeb429a97, 0xa364d75c, 0x7c344cbe, 0x9cd95a40,
    0xb6480015, 0xab840007, 0xe1c2003d, 0xbb250002, 0x80000000, 0xc0000000,
    0x20000000, 0x30000000, 0xb8000000, 0xfc000000, 0xf6000000, 0x53000000,
    0xff800000, 0xc2400000, 0x07e00000, 0x50500000, 0x8dc80000, 0xd1940000,
    0x5e6e0000, 0xc5250000, 0xf4778000, 0x1f3cc000, 0x766a6000, 0x71207000,
    0x66727800, 0x7638cc00, 0x94ecca00, 0xe3e7e300, 0xaa53c080, 0xb0c9f940,
    0xb1112a20, 0x2dab5330, 0xaf83d888, 0xaa45454c, 0x53e1980e, 0xd2517c0f,
    0x6ccb5235, 0x77179f18, 0xc6a91291, 0xac03a64f, 0x9e03d89c, 0x07054570,
    0x7d819834, 0x23417c38, 0xa1635230, 0xc8939f16, 0xe4ef128d, 0xbbe2a658,
    0x465258a8, 0xcec88579, 0xa6127832, 0xd828cc02, 0xc8c4ca3c, 0x0123e337,
    0x3e75c094, 0x9a38f95f, 0x80000000, 0xc0000000, 0x60000000, 0x70000000,
    0xd8000000, 0x64000000, 0x3e000000, 0x41000000, 0xdc800000, 0x84400000,
    0xe2e00000, 0x76500000, 0x0a180000, 0xaa940000, 0xe2be0000, 0xc7270000,
    0x56758000, 0x05edc000, 0xd9bca000, 0xb4a53000, 0x87b42800, 0x73cf9400,
    0x4b4f6a00, 0x310e1300, 0xf2ec4080, 0x283e3fc0, 0x7e664a20, 0x5216e330,
    0xf8fcc898, 0x74c09bdc, 0x54a30816, 0x37b06429, 0xcbca6217, 0x5f4d770c,
    0xd70da281, 0xd7e988f8, 0xcabac897, 0xbb239bfd, 0x6c70880d, 0x0aeea427,
    0x9c3d422e, 0x88628729, 0xdf10aaae, 0xa67eece2, 0xeb852a96, 0x15c32cdd,
    0x58218a83, 0x7bf21ccd, 0xe52ba290, 0xab1a88e3, 0xc61148a6, 0xdef95be8,
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x58000000, 0x4c000000,
    0x0e000000, 0x05000000, 0xc6800000, 0xcac00000, 0x5e600000, 0xb4300000,
    0x83c80000, 0x04740000, 0x316e0000, 0x4f230000, 0x8a148000, 0x1d5dc000,
    0x60ece000, 0xd060b000, 0x71334800, 0xa54bc400, 0x9eb23e00, 0x370a6700,
    0xb712e780, 0x07da3540, 0x1c2a5e20, 0x97071730, 0x55854fb8, 0xa5454154,
    0x0c252836, 0x7d95b423, 0xe319163b, 0xf74cd315, 0xedb771a7, 0x088f2661,
    0xbd57cfb4, 0x827f815c, 0x72fb4809, 0x613fc417, 0x4fdc3e35, 0x28296739,
    0x65066797, 0x5687f554, 0x72c6be06, 0x4267a724, 0xe23607a0, 0xcace8565,
    0xccf7163e, 0xfeafd336, 0xd7c3f1a6, 0xf4e2e66f, 0x80000000, 0xc0000000,
    0x20000000, 0xd0000000, 0x48000000, 0x54000000, 0x1a000000, 0x07000000,
    0x87800000, 0x86c00000, 0xdd200000, 0xcab00000, 0xa6680000, 0xb7f40000,
    0x838e0000, 0x05650000, 0xa3d08000, 0x13bb4000, 0x85482000, 0x18409000,
    0x49659800, 0x65d36c00, 0x7ab8ce00, 0xcfce3500, 0x56021380, 0xc1043240,
    0xee806e20, 0xcc45e530, 0x9367ab88, 0x42d3ce74, 0x2d3b3832, 0x0109bc25,
    0xdf23f60e, 0x11b78935, 0x4fe9e5b3, 0xfc37bb74, 0x962f8b91, 0x9a935e43,
    0x445ea020, 0xb4dad008, 0xed9b380d, 0x8a79bc12, 0x03ebf615, 0x3a33893d,
    0xff2fe5a6, 0xd016bb67, 0x0a190b8c, 0x3cb91e7e, 0x66c80009, 0x3c84002e,
    0x5f460014, 0x2ee10024, 0x80000000, 0x40000000, 0xe0000000, 0x10000000,
    0xf8000000, 0x34000000, 0x5e000000, 0x83000000, 0x5a800000, 0x72400000,
    0xc2e00000, 0xa6700000, 0xcfe80000, 0x10b40000, 0x5c4a0000, 0xdea30000,
    0xaf928000, 0x0f18c000, 0x2f1d2000, 0x9f1b3000, 0x971cb800, 0x4b19a400,
    0xd919ca00, 0x301b2300, 0xb79bb180, 0x1c596040, 0xf67e6a20, 0xe0acd310,
    0x4bd029b8, 0x32f8f444, 0xb1e9981e, 0x23b6941d, 0x0ecf722f, 0x70e18724,
    0xff70fba8, 0x406a8351, 0x6770fb87, 0x246a8359, 0x2170fbbd, 0x836a834c,
    0xddf0fb81, 0x462a8347, 0x1b90fba9, 0x111a837e, 0x4c18fbbb, 0xd59e8375,
    0x1d5afb99, 0xbdf9835d, 0x216a7b99, 0x7cf64363, 0xfdafdbbb, 0x3256b36a,
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xe8000000, 0xdc000000,
    0x32000000, 0xcb000000, 0xd1800000, 0x16c00000, 0x36a00000, 0x48700000,
    0xb1d80000, 0x4d340000, 0x72be0000, 0x5e670000, 0xdfd58000, 0xb72c4000,
    0xa5a96000, 0x0eecd000, 0x9489b800, 0x8d5d9c00, 0x7f732e00, 0x82581900,
    0x68f64580, 0xd19fd3c0, 0x06d7ce20, 0x7dac8930, 0x9ae89d98, 0x6a899fdc,
    0xec58d81a, 0x51f54c07, 0xab1c9614, 0xb196852e, 0xb5ceeb8e, 0x383c8af2,
    0xa1256ba1, 0xdbb7cad0, 0xbff98ba0, 0x91075afa, 0x06815393, 0x954216de,
    0x9b65c595, 0x475093d7, 0x336d2e0f, 0xf84f1938, 0xbcfbc585, 0x4c8793c0,
    0xda40ae35, 0x2ce75912, 0x0494a5a2, 0xc54843ea, 0x80000000, 0x40000000,
    0x60000000, 0xd0000000, 0xe8000000, 0x4c000000, 0x8e000000, 0xd9000000,
    0xa8800000, 0x52400000, 0x3ea00000, 0x3ab00000, 0x44e80000, 0x32740000,
    0x070a0000, 0x83e70000, 0x91948000, 0x269c4000, 0x9d78e000, 0xa8ed3000,
    0x4c71a800, 0x860eb400, 0x5f629a00, 0xe9d51100, 0x03391780, 0x58498a40,
    0xcfc6fa20, 0xba606110, 0xd7525f98, 0x9c790e74, 0x346b481a, 0x54308403,
    0x73adb23b, 0x7250e502, 0xc2ffed90, 0x7b29eb47, 0xd014a58c, 0xa4596f68,
    0x35991783, 0xbef98a7c, 0x8d2efa0c, 0xcd146119, 0x1ed85fb4, 0xd8de0e54,
    0xbddfc835, 0xc35cc42b, 0x3c1d5229, 0x8039d530, 0xf3cc45be, 0x76045f55,
    0x5d00bf8f, 0xda833e73, 0x80000000, 0x40000000, 0x60000000, 0x10000000,
    0x08000000, 0x6c000000, 0x22000000, 0xc9000000, 0x30800000, 0x47400000,
    0x9ea00000, 0xfcb00000, 0x44f80000, 0x7d740000, 0x221a0000, 0xd0e70000,
    0x72928000, 0x8f0b4000, 0xbf2fe000, 0xc7df5000, 0xf8002800, 0x34011400,
    0x2607b200, 0x9706d100, 0xd387ef80, 0xd2c2eac0, 0xcb62d220, 0xec56c110,
    0x166a2798, 0x827faec4, 0x8535c822, 0x7339440b, 0xc4951a10, 0x500c8536,
    0x60afbd8e, 0x271b6bca, 0xf265158f, 0x84d53fdd, 0x552f47a5, 0x42dfbeda,
    0x9a800015, 0xa2400004, 0xec20001f, 0x62f00011, 0xe2d80021, 0xaa84003d,
    0xda420001, 0x98230032, 0x24f0801c, 0x65d84025, 0x71076034, 0x6483102d,
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x18000000, 0xa4000000,
    0x1a000000, 0xc7000000, 0x46800000, 0x20400000, 0xbd600000, 0xc3900000,
    0xba880000, 0xc2540000, 0x312a0000, 0xa4e50000, 0x41528000, 0x1da9c000,
    0x6ba1a000, 0x16b21000, 0x587a1800, 0x154e6400, 0x8cf1fa00, 0x7219ff00,
    0xa85a4e80, 0xa2384740, 0x0f28da20, 0x39e72f10, 0xe0d37688, 0x6b6df344,
    0xee829826, 0xcc42a439, 0x3b62da0e, 0xaa922f35, 0x3909f697, 0xc7903361,
    0xf0893809, 0x3d55b411, 0xc3aa4237, 0x86a58b3c, 0x9f31aca5, 0x82bfdc70,
    0x366b6e98, 0x2f029756, 0x8a83e22f, 0xb6439b30, 0xcc61b4a7, 0xe414b85f,
    0xa54814b7, 0xc4f2a861, 0xee180c8f, 0x0659cc69, 0x80000000, 0xc0000000,
    0x60000000, 0x90000000, 0x18000000, 0x44000000, 0xee000000, 0x29000000,
    0x87800000, 0xe9400000, 0x6da00000, 0x2bd00000, 0x44a80000, 0x54140000,
    0x33ce0000, 0xfd270000, 0xd4128000, 0xf3cbc000, 0x9d22a000, 0x4411b000,
    0xebc86800, 0xd923cc00, 0xaa10c200, 0xc2ce7100, 0x5ea1e480, 0x4356c040,
    0xaf6ee220, 0x75730130, 0x07f9ac98, 0xfb7f7c64, 0x46bce826, 0xfadb0c21,
    0x2f6ee223, 0xb573012e, 0x67f9aca7, 0x6b7f7c6b, 0x5ebce800, 0xbedb0c30,
    0xc16ee228, 0x9c73010b, 0xe079ac91, 0x823f7c64, 0x331ce83f, 0x950b0c13,
    0x85c6e212, 0xc8670130, 0xd3b7ac92, 0x7f187c51, 0xe70e6807, 0x66c0cc0e,
    0x18e44218, 0x8c76b107, 0x80000000, 0x40000000, 0x20000000, 0x70000000,
    0x78000000, 0xbc000000, 0x06000000, 0xc3000000, 0x39800000, 0xcd400000,
    0x5aa00000, 0x34b00000, 0xbdb80000, 0xcb740000, 0xb7da0000, 0x82250000,
    0xa9718000, 0xfedac000, 0x26a26000, 0x52b1f000, 0x2ebaf800, 0xfaf67c00,
    0xbe99b200, 0x6283f900, 0x58c67f80, 0xb9e3e0c0, 0x19105220, 0x728dc910,
    0xc28f6788, 0xda8eacdc, 0x3689783e, 0x388dbc3f, 0x3f885209, 0xbc09c92c,
    0xb44d6790, 0x146facdc, 0xd41af837, 0xfe467c2d, 0x5b21b229, 0x65f7f91d,
    0x911c7fa5, 0x44c6e0c2, 0x8fe1d224, 0x8217092d, 0x870d07a2, 0x71cf5cdb,
    0xff2b8009, 0x3dbfc033, 0x8b73e000, 0x97db3012, 0xf2209820, 0xd1738c2c,
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x88000000, 0x84000000,
    0xaa000000, 0x41000000, 0x94800000, 0x8ec00000, 0x8c600000, 0xab700000,
    0xb2f80000, 0xa4340000, 0x36de0000, 0xe0e10000, 0xe9b18000, 0xb0994000,
    0x1447a000, 0xd9a71000, 0xda932800, 0x77ce7400, 0x366e3e00, 0x70fee700,
    0xf1337d80, 0xd05f7cc0, 0xd3261e20, 0x5751b730, 0xfa2e75a8, 0x555b58fc,
    0x8da2a802, 0xc8973411, 0x9ac99e02, 0x7ce9f72c, 0x9d385587, 0x2cd508c2,
    0xcb6e2029, 0x227a500a, 0x40f28821, 0x5bbc6436, 0x2f12960c, 0x5d88d333,
    0x1ccb63bc, 0x23efcbd5, 0xcab9eb8d, 0x0393afdd, 0x7f4b7da7, 0x4eab7cd7,
    0xeb981e0e, 0x29c0b72e, 0x17e7f5a7, 0x0a3618dc, 0x80000000, 0x40000000,
    0xa0000000, 0xb0000000, 0xd8000000, 0x3c000000, 0x4a000000, 0xeb000000,
    0xcf800000, 0x49400000, 0xb3e00000, 0xab300000, 0x82580000, 0xe2f40000,
    0x217a0000, 0x02610000, 0xf7778000, 0xab3bc000, 0x3a006000, 0xd3069000,
    0xe383b800, 0x6b41ac00, 0xbce3d200, 0x12b20300, 0x6a1d4380, 0x7592d5c0,
    0x0c8e3220, 0x7a9e5310, 0x0d511ba8, 0xa32a29ec, 0x58cc3816, 0xe7fe6c1f,
    0x6ba1b23a, 0xa4519316, 0x33ab7b85, 0x600db9dd, 0xe858001e, 0xf9f40000,
    0x96fa003b, 0xc7210006, 0xd6978012, 0xd70bc025, 0x3dd8600f, 0x93b29028,
    0xbe99b835, 0x8b50ac26, 0x7a2c5229, 0xf04dc31a, 0xf33f2381, 0x460145c8,
    0x39000a0a, 0xb8853f17, 0x80000000, 0xc0000000, 0xe0000000, 0x70000000,
    0x08000000, 0xdc000000, 0x8e000000, 0x23000000, 0x99800000, 0x02c00000,
    0x32200000, 0x75900000, 0x1d280000, 0xbbd40000, 0x834e0000, 0xd5230000,
    0x06158000, 0x86ef4000, 0x11716000, 0xc89a3000, 0x9e6cf800, 0xef313c00,
    0x7ef84e00, 0xbc9b3d00, 0x9c6e0a80, 0xda33c040, 0x607aae20, 0x7dd94d30,
    0xdd8812b8, 0xa9048c5c, 0xb082f822, 0x72423c07, 0xa065ce1b, 0xa5f07d14,
    0xb0d96aa4, 0xd70ef077, 0xda45d60f, 0x2c603125, 0xb3f2bc99, 0x37ddc172,
    0x148aea8e, 0xa986b06f, 0x2ac7363d, 0x7e22412b, 0x8394a4b8, 0xea2a8d6c,
    0x7052bcab, 0x2c8dc148, 0x5d82ea81, 0xe8c2b057, 0xab213610, 0xed15413e,
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xa8000000, 0x94000000,
    0x06000000, 0xb1000000, 0x3b800000, 0x54c00000, 0x45e00000, 0xf9700000,
    0x6b680000, 0x15340000, 0x86ce0000, 0xffe50000, 0x1a738000, 0xc7ec4000,
    0x7b752000, 0x046b7000, 0x83b42800, 0xcb8a6c00, 0xf1c76e00, 0xb864d300,
    0x3cb11d80, 0xa50ddc40, 0x1087ce20, 0x3c42e330, 0x15a59588, 0x46d1806c,
    0x16bc280a, 0xb30e6c15, 0x79816e09, 0x1bc5d300, 0x63649da4, 0x1c309c70,
    0xf14f6e30, 0xb120d322, 0xcc971d9c, 0x1a1cdc7c, 0x5a5a4e3a, 0x3dfba314,
    0x5c2b3595, 0xd812b074, 0x385b203b, 0xc2fe703e, 0xd2afa83e, 0xa9522c3d,
    0xa47c4e1c, 0xd7eaa31a, 0xa376b59e, 0x186bf076, 0x80000000, 0xc0000000,
    0x60000000, 0x90000000, 0x88000000, 0x44000000, 0xc2000000, 0x77000000,
    0x96800000, 0x2a400000, 0x13a00000, 0xcc300000, 0x46a80000, 0x79f40000,
    0xc0ce0000, 0x03a70000, 0x84328000, 0x62af4000, 0x2bf2a000, 0x3fcc5000,
    0xd1269800, 0x6c702400, 0x060daa00, 0x71468900, 0x53236380, 0xbb703040,
    0x608b8a20, 0x43069930, 0x8c83db98, 0xf1400464, 0x93269802, 0xdb702421,
    0xf08daa28, 0xcb068939, 0xc8836387, 0x3340305b, 0xe4238a14, 0x4df2991e,
    0xdacddbac, 0xd8a70470, 0x04b41836, 0x75ef6412, 0x9dd70a18, 0x8d3ed93f,
    0xd96bfbbd, 0x5c971454, 0x661ca001, 0x5e1b501d, 0xa21c1827, 0x5c1b6423,
    0xb5190a36, 0x5a99d917, 0x80000000, 0xc0000000, 0x60000000, 0x90000000,
    0xe8000000, 0x0c000000, 0xde000000, 0x65000000, 0xb1800000, 0xd9400000,
    0x2ee00000, 0xa3100000, 0xe6880000, 0x3df40000, 0x9d9e0000, 0xcf7f0000,
    0x0a6e8000, 0x0de64000, 0xc391e000, 0xd44e3000, 0xed548800, 0xf2ea5c00,
    0x8b247200, 0x4933a300, 0x9c393680, 0x4b8de540, 0xb070fa20, 0x82d9ff30,
    0xf09d4498, 0x22fe4664, 0x8529cc9a, 0xda041a73, 0xe705be8f, 0x8283b94d,
    0x91c2882e, 0x70215c21, 0x3db4f21e, 0x04fae316, 0xc42e5698, 0xd9819563,
    0x15439217, 0x90e69304, 0x56153e84, 0xbf0af976, 0xe8b5e83f, 0x6d7d2c12,
    0x096f9a08, 0x5d618f3e, 0xe9502ca1, 0x70ee2a62, 0xb82736b2, 0x01b2e559,
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x38000000, 0x54000000,
    0xf6000000, 0x63000000, 0xab800000, 0xad400000, 0xf0e00000, 0x64500000,
    0x99d80000, 0x40b40000, 0xcb8e0000, 0x1a690000, 0xb0be8000, 0x44a6c000,
    0x0e352000, 0x664ff000, 0xb048f800, 0x834b8c00, 0xb0cc6200, 0xd98df300,
    0xe76a4c80, 0xb43b9fc0, 0x70649a20, 0xfe967f30, 0x6e7e2ea8, 0xbd026ce4,
    0x6480d6ae, 0x04c4e0e5, 0x58a434b5, 0x6432d3cc, 0xaf4bd82c, 0x72c97c2a,
    0x7c8c1a27, 0x87edbf30, 0xdefb8ebf, 0x8fc25cf6, 0xff238eb9, 0x5b765cdc,
    0x62ad8e94, 0xb21f5ce7, 0x41930ead, 0x0ff99cd7, 0x49462eaf, 0x6ee66cfe,
    0xcb56d6a0, 0x0059e0ca, 0x40f4b497, 0xa7ed13ee, 0x80000000, 0x40000000,
    0x60000000, 0x50000000, 0x68000000, 0x7c000000, 0xc6000000, 0x11000000,
    0x25800000, 0x60400000, 0xc0600000, 0x61100000, 0xdd280000, 0x4d740000,
    0x323a0000, 0xcd5f0000, 0xa4cc8000, 0x9a264000, 0x36706000, 0xe8bcf000,
    0x859ea800, 0xb769bc00, 0x22135a00, 0x13aa1700, 0xbfb76e80, 0xf69ae440,
    0x41edf220, 0xc4d3ab10, 0x6d0c3498, 0xe404f354, 0xa2009cba, 0xf3064f4f,
    0xb6854689, 0x86c51840, 0x2ea6c82b, 0x33b14c03, 0x289ff203, 0x74e8ab17,
    0x6352b495, 0xce49b350, 0xaae67ca4, 0x51d3ff67, 0xba8f0e9f, 0x1f421471,
    0xa8e15a24, 0xd2d11719, 0x5409ee80, 0xdd87a464, 0x54431222, 0x4a621b38,
    0x8e147cba, 0xfda8ff5c, 0x80000000, 0xc0000000, 0x60000000, 0x50000000,
    0xf8000000, 0x8c000000, 0xd6000000, 0x0b000000, 0xcb800000, 0xfec00000,
    0xa4a00000, 0xe0900000, 0xe1180000, 0x78340000, 0xbf8e0000, 0x862f0000,
    0x06388000, 0xe266c000, 0x6833e000, 0xe788f000, 0x3a2d7800, 0x78394c00,
    0x9d647e00, 0xf9b21100, 0xc448b680, 0x5e0ea7c0, 0xade90620, 0x261b5d30,
    0xc5b4c898, 0x7a48b6d4, 0x410fb09e, 0x6c6afad3, 0xfddd4e8d, 0x2d912be6,
    0x799e9834, 0xf171bc38, 0x9be9063a, 0xbd1b5d0d, 0x9634c881, 0x5888b6c0,
    0xcbafb0a1, 0x0bfafad4, 0x01454e9a, 0xa0652bc5, 0xa9309822, 0x690ebc39,
    0xd869860b, 0xc7d99d2c, 0xa09128aa, 0x411b46c0, 0x483448aa, 0x178a76fd,
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x88000000, 0x84000000,
    0xc6000000, 0xf5000000, 0xc8800000, 0xef400000, 0x13a00000, 0x79d00000,
    0x31180000, 0x96740000, 0xf2ce0000, 0x286f0000, 0x433c8000, 0xc2654000,
    0xe837a000, 0xffeff000, 0xa3fd4800, 0xfd021400, 0x8c87c200, 0x4942c100,
    0x36a79880, 0x39504bc0, 0x5a5a8a20, 0x43d0d530, 0x7e185a98, 0xd1f68af4,
    0x3a0b1282, 0x230b9ed1, 0xb9885089, 0x8dc81ff9, 0xf7ee6828, 0xe7fca41e,
    0x5b032a0f, 0xa9802536, 0x09c192ad, 0x5de5dec2, 0xecf5709b, 0xd689afe2,
    0xba4e0012, 0x072f0034, 0x309c8034, 0x6bb5401b, 0x512fa01b, 0xed9bf03c,
    0x97334836, 0x206d1411, 0x073b4239, 0x6467811b, 0x80000000, 0xc0000000,
    0x20000000, 0xb0000000, 0xd8000000, 0x3c000000, 0x16000000, 0x6d000000,
    0xd6800000, 0x4cc00000, 0xeee00000, 0xa8d00000, 0x1ae80000, 0xd0340000,
    0x1f3e0000, 0x3c5d0000, 0x33cf8000, 0x1585c000, 0x9b436000, 0x2aa2f000,
    0x33f1c800, 0x78592400, 0x69cc5e00, 0x96801b00, 0xacc5fc80, 0x7ee7f240,
    0xc0d59620, 0xfeed3f30, 0xfa37a288, 0x643ae96c, 0x87dfea96, 0xa98f0d7f,
    0xb7a154ad, 0xdd752647, 0x9899802b, 0xf92cc000, 0xb752e000, 0x4aaa3012,
    0x99152800, 0x8a8a1433, 0xf020f60c, 0x7136cf2d, 0xe7bfea84, 0xb19f0d48,
    0x75a954bc, 0x7891266b, 0x93cf8029, 0x6585c03c, 0x63436009, 0xa6a2f006,
    0xfdf1c83e, 0x2959241a, 0x80000000, 0x40000000, 0xa0000000, 0xd0000000,
    0x68000000, 0x8c000000, 0x6e000000, 0xff000000, 0x9b800000, 0xef400000,
    0xe1600000, 0xa7100000, 0xa2580000, 0xd8740000, 0x024a0000, 0xa5a90000,
    0x07788000, 0xbf804000, 0xed45e000, 0x0063b000, 0x7b965800, 0x32988c00,
    0x34539200, 0xd53d5f00, 0xc4606680, 0x09953fc0, 0x6b9dca20, 0x0cd1d310,
    0xa7f9f4a8, 0xb94160f4, 0xba652cba, 0x7e94acf3, 0x0c19de93, 0x359703db,
    0x5d988034, 0x67d0403c, 0x667de011, 0x2307b001, 0xdd84580f, 0x3c458c11,
    0xc4e11205, 0xdf541f04, 0x54bd06b7, 0xfe26cfcb, 0xbe76720b, 0x414eef26,
    0x482e3e9f, 0x2339b3c8, 0x4f64580d, 0xb8158c00, 0x49d91226, 0x8f301f2a,
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x98000000, 0x0c000000,
    0xb2000000, 0x25000000, 0x69800000, 0xc3c00000, 0xa9600000, 0xdef00000,
    0xdef80000, 0xd1940000, 0xdb0a0000, 0xd1ed0000, 0x35db8000, 0x91c3c000,
    0x5c66e000, 0xbf75d000, 0x39380800, 0x5ef67c00, 0x9ef8c600, 0xf197bf00,
    0x6b0d0d80, 0x49ef2ec0, 0x39d8ce20, 0x23c5c310, 0x7967cb88, 0xd6f191ec,
    0xfafc4386, 0xf7902dd3, 0x40086584, 0x2f6f42f5, 0xba9ee014, 0x92e1d00f,
    0xe8320828, 0x161b7c11, 0xe8a34627, 0x8a947f0e, 0x458bedaa, 0xceaafefa,
    0x1ef8c62a, 0xb197bf07, 0x4b0d0db4, 0xf9ef2ef4, 0xa1d8ce04, 0x2fc5c320,
    0xcb67cbaf, 0xf3f191e6, 0x937c4392, 0x34502ded, 0x80000000, 0x40000000,
    0xa0000000, 0x50000000, 0xa8000000, 0xc4000000, 0x9e000000, 0x11000000,
    0xfe800000, 0x52c00000, 0x16e00000, 0xef700000, 0x1ab80000, 0x78940000,
    0x434a0000, 0x04e90000, 0x4b3c8000, 0xd5d64000, 0xf1eba000, 0x3bba3000,
    0x9e176800, 0x8d8f6400, 0xb00b4e00, 0x474afb00, 0x7aeaf180, 0xaa3e50c0,
    0xd3562620, 0xcf2c9f10, 0x775d3fa8, 0xfe62ebd4, 0x78b7778a, 0x64d8ffe1,
    0x402471af, 0x879510c0, 0x14cb061d, 0x64a9ef21, 0x051d77a0, 0x0b41ffda,
    0x2fa0f194, 0x6bd750ef, 0xf0eaa605, 0xcd3adf2e, 0x58d69fac, 0xad68dbe1,
    0x8a781f82, 0x3d739bcf, 0x41bd3fb3, 0x0112ebdd, 0x6a0f778a, 0x884cfff1,
    0x356e7191, 0x567c10e6, 0x80000000, 0xc0000000, 0xe0000000, 0x50000000,
    0xe8000000, 0x4c000000, 0xaa000000, 0x6d000000, 0x34800000, 0x82c00000,
    0x69a00000, 0xd3900000, 0xe9a80000, 0xe7340000, 0x76be0000, 0xc85b0000,
    0x4e288000, 0x42724000, 0x7a59e000, 0xf72b9000, 0xc8f6c800, 0xcb98d400,
    0xc909ce00, 0x26231100, 0x3ad46680, 0x4f4b0240, 0xb5410620, 0xc4e0c530,
    0xc37528b8, 0x94da5354, 0x40ec809a, 0x61d05763, 0x94cae6b2, 0xc206427f,
    0xe106662f, 0x7e861517, 0xbfc480b2, 0xb5245768, 0x1d54e687, 0x2a0d4261,
    0x59a6e638, 0xab905519, 0xadab60bc, 0x5130c77a, 0x59bcae93, 0xddd8d67a,
    0x52684839, 0xc4159436, 0xf4eeae37, 0x4fd5c105, 0xafcdce81, 0x89810649,
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xc8000000, 0x44000000,
    0xfa000000, 0x83000000, 0x1a800000, 0xbd400000, 0x1fa00000, 0xbad00000,
    0x5bd80000, 0x4e740000, 0x8f8a0000, 0xbaed0000, 0x695d8000, 0xa7314000,
    0xf22aa000, 0x7f3f1000, 0x5e05f800, 0x69006400, 0x01868200, 0x5bc62100,
    0xd4e09080, 0x9872edc0, 0x82897a20, 0x316b4510, 0x799b9288, 0x2d558cdc,
    0x2d1b4a92, 0x6112b8c1, 0xcf3d1096, 0xf603adec, 0x7d03da1c, 0x43845532,
    0x54c66a83, 0x7061e8c3, 0x5c37c8bc, 0x04a999dd, 0x2c780034, 0x80a40003,
    0xc6520037, 0x43990036, 0xce578002, 0x679c403d, 0x64572000, 0x5c9e5001,
    0xf2d75804, 0x5fdb740f, 0x94717a15, 0x7c8f4537, 0x80000000, 0xc0000000,
    0x60000000, 0x90000000, 0x98000000, 0x5c000000, 0xd2000000, 0x27000000,
    0xaf800000, 0xa9400000, 0x1a600000, 0x19100000, 0xfd380000, 0x38740000,
    0x39ae0000, 0xbb0f0000, 0xbc3e8000, 0xf6f5c000, 0x6e6b6000, 0x9ea9d000,
    0xd4899800, 0x757ccc00, 0x7c958200, 0xef7f4700, 0x3f946680, 0x3efd3cc0,
    0x6bd21a20, 0x681c8b30, 0xfa076498, 0xd303bbe4, 0x49831c86, 0x084767e7,
    0x84e2668c, 0xb6d63cdd, 0x149a9a35, 0x1ac24b29, 0xc124848c, 0xd474abfc,
    0x43a964a6, 0xa80cbbca, 0x95bd9caf, 0x6eb2a7df, 0x728906a3, 0x747fecdc,
    0x12130206, 0x48be870b, 0x1231068a, 0x924becd0, 0x665d023a, 0x8fe1870d,
    0x035786b0, 0x3eda2cc7, 0x80000000, 0xc0000000, 0xa0000000, 0x10000000,
    0x28000000, 0x2c000000, 0x22000000, 0x03000000, 0xca800000, 0x75400000,
    0xc4200000, 0xb3100000, 0x61e80000, 0xa8340000, 0x627e0000, 0x0b990000,
    0xf2ea8000, 0x8ab64000, 0x9b3ae000, 0xfdb9d000, 0x6afab800, 0x0dd86400,
    0x644c4200, 0x58e7bd00, 0x18f3de80, 0xeb9c6040, 0x82e8fa20, 0x12b6d930,
    0x8f3d1ca8, 0xdbb99d44, 0x67ffc4aa, 0xe65a697b, 0xd88dde80, 0x23056074,
    0x1a827a30, 0xfd409922, 0xf827fc9b, 0xb9104d63, 0x4eed7c88, 0x40b60d4c,
    0x143f9c9b, 0x053bdd47, 0x34bb24a5, 0x2f7ab946, 0x801de69d, 0xfe2b4444,
    0xc954d81e, 0x9d4ef42b, 0xe5669a32, 0x31304937, 0x6fffc49f, 0x1a5a6974,
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x78000000, 0x14000000,
    0xea000000, 0xb3000000, 0x45800000, 0x24400000, 0x3ba00000, 0x47100000,
    0x4f480000, 0x93b40000, 0x5bda0000, 0xadbf0000, 0x2b488000, 0xf1b6c000,
    0x34df2000, 0xbe3d1000, 0x3a0e7800, 0xc2931c00, 0x4b0cca00, 0x18137900,
    0xb4cb4e80, 0x8ef39940, 0x46f8b220, 0xf36f6510, 0x6fe70498, 0xf4b22074,
    0xd45edcbe, 0x8afaec55, 0xfd6b4e82, 0xfee39948, 0xbe30b237, 0x339b6528,
    0xd81d04b2, 0x9d5d204c, 0x247e5c86, 0x38a82c54, 0xa3066e8b, 0x1d85897b,
    0x80444a20, 0x79a5b921, 0x98146eba, 0xf4ce896c, 0xeef6ca14, 0x96fc7933,
    0x8b6bcebe, 0x7be1597e, 0x1eb59216, 0x67597529, 0x80000000, 0x40000000,
    0xe0000000, 0x90000000, 0x28000000, 0x54000000, 0x12000000, 0x5d000000,
    0x69800000, 0xf0c00000, 0x96e00000, 0xd0f00000, 0x99780000, 0x69140000,
    0xad0a0000, 0xa12b0000, 0x663a8000, 0x70304000, 0x879b2000, 0x9de65000,
    0x9e778800, 0xe93f3c00, 0xe4b7de00, 0x6edec300, 0x43c10580, 0xa462a6c0,
    0xe6b25620, 0x5bdeff10, 0x9e465bb8, 0xd6a725e4, 0x0552f3aa, 0xb6aa49c5,
    0xe5f8a59c, 0x7450b6e3, 0x112cfe08, 0x7e38931d, 0x7c368d93, 0x799d9ad2,
    0xaee58812, 0xecf03c34, 0x3f7f5e28, 0xb6118313, 0xb18aa58a, 0x6c6fb6db,
    0x121c7e2d, 0x6b23d326, 0xa7972d91, 0x9d4b8acc, 0xcc892025, 0x35e95039,
    0xbadf0815, 0x11c07c01, 0x80000000, 0x40000000, 0x20000000, 0x90000000,
    0x68000000, 0xac000000, 0x22000000, 0x35000000, 0x28800000, 0xc6400000,
    0xc4600000, 0x9db00000, 0x73180000, 0xa6d40000, 0x1f2a0000, 0x390d0000,
    0x1eda8000, 0x3f744000, 0xa33ae000, 0x1203d000, 0x8d010800, 0xcc877400,
    0xd8476a00, 0xbb649f00, 0x2c375380, 0xbfdbddc0, 0x91f46220, 0x6e7aeb10,
    0x11e0b988, 0x0f7602e4, 0x1b3b51ba, 0xf602a6fb, 0x930533a0, 0xb3854df9,
    0x69c70a38, 0x77a30f2e, 0x1b14bbab, 0xce8b79e5, 0xb9180024, 0x7fd4002e,
    0x35aa003c, 0x5a4d0031, 0x9a3a803a, 0xc884401b, 0x3642e00a, 0x1c67d009,
    0xc9b30835, 0x951e742a, 0x1dd7ea2f, 0x20addf0c, 0xe2cf339b, 0x34784dfe,
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xc8000000, 0x54000000,
    0x0a000000, 0x3b000000, 0xf4800000, 0xf6c00000, 0xf2a00000, 0x0ab00000,
    0xbbc80000, 0x21140000, 0x5afe0000, 0xea9f0000, 0x088c8000, 0x2af74000,
    0xc0a92000, 0x8f879000, 0xa245b800, 0xb4601400, 0xe0121e00, 0x2d7ff900,
    0xc4df3f80, 0x4ae80940, 0x7fe1a620, 0xe054ed30, 0x261fa198, 0x124fb074,
    0xfe533992, 0xb7183465, 0x6dcc9fba, 0xe413d94a, 0x2f7fbe37, 0xcbdb292c,
    0x646da794, 0x7a208d6d, 0xb2728003, 0xd068401e, 0x6025a00d, 0x2170d03f,
    0xa0ec981f, 0x54e78428, 0xbcd7a636, 0x54dfed1d, 0x22ed21af, 0x9be7f068,
    0xf2569980, 0x8118e46a, 0xb8c807bd, 0x39905d5a, 0x80000000, 0xc0000000,
    0x60000000, 0x70000000, 0x08000000, 0x9c000000, 0xb2000000, 0xab000000,
    0xc9800000, 0x74c00000, 0xdce00000, 0xd5f00000, 0x57380000, 0x0c140000,
    0x924e0000, 0x2d6f0000, 0x8ff98000, 0xcaf14000, 0x60ba6000, 0x79d15000,
    0xc82c7800, 0x63d87c00, 0xf5e60e00, 0x1f752300, 0x667a7d80, 0x6e33e4c0,
    0xa45c7620, 0x48265f30, 0xb913f398, 0xeacc87dc, 0xb72beba2, 0x245aabd7,
    0x88201d94, 0xd912b4c6, 0x9ac80e08, 0xbf2a2316, 0xb85bfd81, 0x3a26a4e4,
    0x72101629, 0x534c0f23, 0xcbe80b95, 0x64babbd5, 0xefd60591, 0x252b98ce,
    0x5f5a780a, 0x59a37c25, 0x49d18e08, 0x602b6304, 0xefd99dbb, 0x3fe3f4d8,
    0x20726e3b, 0x81fb732b, 0x80000000, 0x40000000, 0x60000000, 0x90000000,
    0x98000000, 0xc4000000, 0xb6000000, 0x7d000000, 0x51800000, 0xfd400000,
    0x0b200000, 0xb2100000, 0xd4080000, 0x16340000, 0x4c9a0000, 0x7bff0000,
    0x314a8000, 0x9911c000, 0x288ba000, 0x42f2f000, 0xeeff8800, 0xeccadc00,
    0xee551200, 0xbca94d00, 0xf266be80, 0x2f346f40, 0xeb189a20, 0x9bb89110,
    0xfbeb2c98, 0x4e47e264, 0x33a50486, 0x50d0ce61, 0x0b6d1e95, 0xd0869f6b,
    0x6ec7120a, 0x55624d3a, 0x59b63e91, 0x20daaf66, 0x3b59ba0a, 0x791ba104,
    0x80bf04b0, 0x2f6fce76, 0xb6879ea9, 0xebc75f51, 0x50e4b23b, 0x8af4bd0c,
    0x92fbb6bb, 0x6ecb736c, 0x2d542807, 0xcc282c15, 0x2ca29a15, 0x12579107,
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x48000000, 0x2c000000,
    0x1e000000, 0xf1000000, 0x15800000, 0x4a400000, 0xd6e00000, 0x60500000,
    0x38e80000, 0x25b40000, 0x0a3a0000, 0xaf990000, 0x60aa8000, 0xcc514000,
    0x66eae000, 0x74b73000, 0x8fba2800, 0xadda7c00, 0x9a4eca00, 0xb2002300,
    0xaf049480, 0x4486be40, 0xcfc6e220, 0xd4a75f10, 0x9ab2dea8, 0x46badd64,
    0xec5816b2, 0x3a0e915b, 0xefe6748f, 0x19d58e48, 0xccaeca1f, 0x9250232d,
    0x37ec9488, 0xf132be4b, 0x8dfce23e, 0x573e5f3c, 0xe4185e9d, 0x7beb9d79,
    0x9f32f694, 0x04f9a16b, 0xb6bc5caf, 0xd45ff26f, 0x6e080028, 0x05e40017,
    0x92d2002d, 0x1a2d0022, 0x22908017, 0x4fc84038, 0x80000000, 0xc0000000,
    0xe0000000, 0xf0000000, 0xe8000000, 0x5c000000, 0xce000000, 0xef000000,
    0x5f800000, 0x08400000, 0x82600000, 0xe4100000, 0xcd980000, 0xa9f40000,
    0xf9ce0000, 0xb20b0000, 0xd62d8000, 0x4f5a4000, 0x21506000, 0xf97fb000,
    0xb9265800, 0x37f0ac00, 0x2ecbea00, 0x498e8700, 0x5469d680, 0x583859c0,
    0xe7c03220, 0x42246b30, 0x2a725cb8, 0xff896efc, 0x3f6fbc9a, 0x9dbc9ee7,
    0x628184ab, 0x56c782f7, 0x2aa236b5, 0x29b2a9d9, 0x17ad8a31, 0x901e3719,
    0x58b40e95, 0x9f2db5f8, 0x63d83820, 0x58941c0b, 0x6c58323a, 0x68d06b05,
    0x4a3c5c88, 0x06c26ed4, 0x12a23ca5, 0x8db6deea, 0x9da9e4b4, 0x051c32f7,
    0x7a326eba, 0xe9ed05f8, 0x80000000, 0xc0000000, 0x60000000, 0x90000000,
    0xa8000000, 0xcc000000, 0xf6000000, 0x37000000, 0x6f800000, 0xa1400000,
    0xb6e00000, 0xfb500000, 0xb8180000, 0x9a340000, 0x460e0000, 0xcecf0000,
    0x766e8000, 0xc05c4000, 0x2053e000, 0x119b7000, 0x54711800, 0x6b6d6c00,
    0x06df2200, 0x75902300, 0x0fbfe480, 0x278259c0, 0x3d40ba20, 0x88e10f30,
    0x90532698, 0x89990ae4, 0xc076468a, 0x696a3ac3, 0xa3dabe85, 0x171326d9,
    0x007a0489, 0x68a229cf, 0xbe312202, 0xdc0f2314, 0xffc964ba, 0x16ea19d4,
    0x6a9d5a10, 0x0df57f2b, 0x9d2cbea0, 0x4fb826e9, 0x8782848b, 0xcd4569c4,
    0xb0e2421f, 0xf4571318, 0xb39d1c82, 0x017445c3, 0x31ee8008, 0x6d1c4024,
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x18000000, 0xa4000000,
    0x36000000, 0xeb000000, 0xc3800000, 0x4bc00000, 0xfca00000, 0xc7300000,
    0xedb80000, 0xac140000, 0x0f4a0000, 0x52090000, 0xe1ed8000, 0x083bc000,
    0x84d5a000, 0x5c6df000, 0x24f83800, 0x91f7cc00, 0xd99e5600, 0x3360b100,
    0x3d95d380, 0x798b72c0, 0x562bee20, 0xc69cbd10, 0xeee625a8, 0x815233dc,
    0xa4ac05a6, 0x1fd903f9, 0x5b061d85, 0x3b81fff6, 0x3fc053be, 0xa2a4b2f7,
    0x90344e3c, 0xbc384d2e, 0x3ad39da8, 0xdb6e3ff6, 0x1d7ff3a7, 0xbb3042f4,
    0x9fb9f609, 0xa110413c, 0x4fca6bb8, 0x664e7efe, 0xc48d981d, 0xeeaa3c2b,
    0x86de6e02, 0x95837d12, 0x30c18595, 0xf722c3f1, 0x80000000, 0x40000000,
    0x20000000, 0x90000000, 0x28000000, 0xc4000000, 0x62000000, 0x1d000000,
    0xbc800000, 0x3ec00000, 0xebe00000, 0x3f900000, 0x28a80000, 0xdcf40000,
    0x93fa0000, 0x5ebd0000, 0xd21a8000, 0x482e4000, 0xbc35a000, 0xcb1dd000,
    0xf6ae0800, 0x2ff31400, 0x247e6e00, 0x1bfee300, 0x4abdd680, 0xb81a8040,
    0x012ae620, 0x4ab3b710, 0x2cde1888, 0xc3cdb364, 0x33a338aa, 0x5bb72361,
    0xc65810b0, 0x1a0aa773, 0x05c7568d, 0x6864c04a, 0x80d74600, 0xd10a670d,
    0x1e4210bf, 0xab27a76a, 0xf775d683, 0xa8be8071, 0xe518e61b, 0x9daab716,
    0xe4769896, 0xef3af347, 0x385e18af, 0x790db350, 0x9a4338a3, 0xe927237a,
    0x7a7010a7, 0x3c3ea757, 0x80000000, 0x40000000, 0x60000000, 0x30000000,
    0x68000000, 0xa4000000, 0x36000000, 0x2f000000, 0x6f800000, 0x05c00000,
    0x40a00000, 0xc9b00000, 0xd2580000, 0x8a940000, 0x9c2a0000, 0x396f0000,
    0x638f8000, 0xe75e4000, 0x2811a000, 0xe76a7000, 0xa8899800, 0xdedb2c00,
    0x32d38600, 0xa04c1100, 0xc0f81780, 0x7a275dc0, 0x5ef59e20, 0x81b97d10,
    0x76c23198, 0xc5253ccc, 0x497611ba, 0x187e0cf9, 0xfc61a9b5, 0xd99110d7,
    0x49aa17b9, 0xe1ac5df4, 0x65a81e3f, 0x03ac3d0c, 0x74ae11a0, 0xd72a0ccd,
    0x40eba99b, 0x194e10cf, 0x907d9792, 0x28661dff, 0xe793be30, 0xf2a94d13,
    0xd02809be, 0xeb6f60fe, 0x1a898fa1, 0x97d871f7, 0x2a541811, 0x060e6c03,
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xf8000000, 0x64000000,
    0x5e000000, 0x09000000, 0xff800000, 0x9bc00000, 0xffe00000, 0x4ef00000,
    0x2f380000, 0x02940000, 0x980a0000, 0x114b0000, 0x94ee8000, 0x573ec000,
    0x2692a000, 0x2608b000, 0x084f2800, 0x936f6c00, 0xa8fb8600, 0x87701b00,
    0x61f9ad80, 0xd8f28cc0, 0x0a3a2e20, 0xcf11b710, 0xd8c88bb8, 0xda2e27c4,
    0x8d5eab9e, 0xb4a357c9, 0xf855a38f, 0x446e4bd6, 0x1e79ad99, 0x03328ceb,
    0x15da2e0e, 0x91e1b71c, 0x0ff08ba5, 0xbcba27f9, 0x4b54abaf, 0xace857fa,
    0x933b23a1, 0x88908bf6, 0xc70b0d82, 0x6bca3cf5, 0x32ad0604, 0x001adb29,
    0x3f010d85, 0x2a813cc0, 0xbe438619, 0x23241b34, 0x80000000, 0x40000000,
    0x60000000, 0xf0000000, 0x78000000, 0x5c000000, 0x6a000000, 0x01000000,
    0x82800000, 0x94c00000, 0x0aa00000, 0x0f100000, 0xdc380000, 0x0d340000,
    0xf6ea0000, 0x412f0000, 0xcc098000, 0x735ec000, 0xd2006000, 0x7d061000,
    0x7885a800, 0x1dc1e400, 0xac26de00, 0xadd5f900, 0xbd9b9280, 0x81a20ec0,
    0x3c92f620, 0xd27edd10, 0x3f572c98, 0xe15ee7fc, 0xcf054cbe, 0xf583f7c7,
    0x1d4364a2, 0xede3d3ec, 0x6bf45a86, 0x114afade, 0xbeb8003e, 0x29f40038,
    0xe44a000b, 0xe23f000d, 0x0231801b, 0x236ac021, 0xcc6a603c, 0xa9e91039,
    0x3cac281c, 0xf54f242a, 0xa8bebe25, 0xd2f7e90b, 0xefcc3aa6, 0xd078eafb,
    0xaa57a82b, 0x4ddae424, 0x80000000, 0xc0000000, 0x60000000, 0xb0000000,
    0x88000000, 0x14000000, 0xa2000000, 0x49000000, 0x4a800000, 0xc3400000,
    0xfe600000, 0xc5b00000, 0x84b80000, 0xab540000, 0xf74e0000, 0xfd0f0000,
    0x89ef8000, 0xef1d4000, 0x25c42000, 0xc321d000, 0xa4d02800, 0x508e2400,
    0x6729a200, 0x3fb85f00, 0x50d43b80, 0x828d50c0, 0xc62e0a20, 0xd13f3b30,
    0xb997b998, 0x21ebdfec, 0xeb1d9982, 0xdfc50ff5, 0xa6223190, 0xd0566bce,
    0x6ccfb388, 0x38cfe4e9, 0x3acba00d, 0xa3cc903a, 0xd14c0821, 0x8e0bf421,
    0xc66f8a1a, 0xe8dd7b29, 0x6fe41986, 0x4d734fc2, 0x871f9198, 0x41c1fbd4,
    0x89223b90, 0x49d650d7, 0x300f8a34, 0xf96d7b08, 0x295c19b9, 0x1f274ffb,
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xe8000000, 0xec000000,
    0x62000000, 0x4f000000, 0xc6800000, 0xe1400000, 0x8a200000, 0x88f00000,
    0xc4280000, 0xea540000, 0xd09e0000, 0x55db0000, 0xe1f98000, 0x4c0a4000,
    0x9da1e000, 0xda36d000, 0xc2ced800, 0x31428400, 0x32204200, 0x1cf36d00,
    0xd22f9180, 0xc3527640, 0xd71f1a20, 0x5f1fa930, 0x031833b8, 0x6918cb5c,
    0xba19d39a, 0xf69e1b4b, 0xb4df0b80, 0x9a789f7f, 0xbcc94993, 0x3444f26f,
    0xb7a15818, 0x2937c426, 0x1e4e221a, 0xeb00fd36, 0x18872985, 0xb4476267,
    0x77a1e022, 0xc936d010, 0x6e4ed809, 0x0302841f, 0xf4804215, 0xd6436d29,
    0x38a7918e, 0x0fb6765e, 0x8f091a3e, 0x8920a904, 0x80000000, 0xc0000000,
    0x60000000, 0xb0000000, 0x68000000, 0x6c000000, 0x32000000, 0xad000000,
    0x35800000, 0x12400000, 0x9e200000, 0x24900000, 0xa4180000, 0x59340000,
    0x11ce0000, 0xc18f0000, 0x3aaf8000, 0x97ba4000, 0xcbe7e000, 0xa5f25000,
    0xfb2bc800, 0x13f99c00, 0x76c64a00, 0xf3e7c500, 0xd1f26280, 0xad2b47c0,
    0x50fa0220, 0xb4401930, 0x1525c898, 0x5a15d2ec, 0xa8da28ba, 0x7bd382eb,
    0x7fbfe0b4, 0x67e51ef7, 0xf7f62aaf, 0xe6289bc3, 0x4e7ba809, 0x08858c25,
    0x5fc4622a, 0x5863090e, 0x3cb060b8, 0x1b8f5ecd, 0x3ba9caa1, 0xf03ecbe5,
    0xc4a6600d, 0x6657101e, 0xa1fba838, 0x1bc58c39, 0xa664621a, 0x73b30926,
    0x5b0860b3, 0x186b5efc, 0x80000000, 0x40000000, 0xe0000000, 0xf0000000,
    0xe8000000, 0x5c000000, 0x92000000, 0xe5000000, 0x75800000, 0xddc00000,
    0xb7a00000, 0xfe900000, 0x50f80000, 0xa9b40000, 0xae2a0000, 0x2f2b0000,
    0x2ca98000, 0x226e4000, 0xd34c6000, 0x469d5000, 0x22840800, 0x1d401c00,
    0xe7e07600, 0xd0f78900, 0x3fccae80, 0x2cdf20c0, 0x55e7fe20, 0x65f2d510,
    0xb24938b8, 0xb51bb9fc, 0xc443389a, 0xb060b9c7, 0xe032b8bc, 0x51eaf9d5,
    0x758cd8bf, 0x0bb8a9cc, 0xd55350ab, 0x7459f5fd, 0xf1a4c68f, 0x65926cdf,
    0x5a7b801d, 0x48f14001, 0xcbcfe009, 0x02d81038, 0xd2e1e825, 0x1d730c16,
    0x46081e28, 0x4d7ac51f, 0x6870d089, 0x6b8cb5c4, 0xc4b9268a, 0xe1d57cdb,
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x88000000, 0x3c000000,
    0xa6000000, 0xad000000, 0x67800000, 0xdbc00000, 0xd4a00000, 0x5e500000,
    0x00580000, 0x70740000, 0xda4a0000, 0x3b4f0000, 0xa2ca8000, 0x00094000,
    0xb9286000, 0xbfb8f000, 0x9dc14800, 0xa9a62c00, 0xd1d4a600, 0x779ce100,
    0x8ad6e880, 0x1518fdc0, 0xfa956e20, 0xa47c8d10, 0x6960ae98, 0x07f5ace4,
    0xc98aae82, 0xb3eaacdf, 0xca982e91, 0x2557ecdf, 0x92da4e83, 0x18301ccd,
    0xdf298686, 0x32bb70c7, 0x0a4740aa, 0x6a6461fa, 0xb1706029, 0xb3ccf03f,
    0x818b4817, 0xafe92c3d, 0x9c9e263f, 0x9055a138, 0x415e88bc, 0x59f00df2,
    0x008c2608, 0xa66ea111, 0xb65e0898, 0x15764de1, 0x80000000, 0x40000000,
    0x60000000, 0x50000000, 0x28000000, 0x94000000, 0x82000000, 0xa1000000,
    0x13800000, 0x69400000, 0x90200000, 0x7d700000, 0xa7580000, 0x6bd40000,
    0x52ea0000, 0x8cef0000, 0x2bec8000, 0x536c4000, 0x4cab2000, 0x0c4ad000,
    0xbd5f6800, 0x66d6ec00, 0x1f6c3200, 0x02ad6500, 0xa3484580, 0x61db95c0,
    0x8315da20, 0x4288c910, 0xb63bd798, 0x328460d4, 0x3ac3d7aa, 0x996060f5,
    0xbd51d798, 0xf22b60ec, 0x588f57b6, 0xbb3c20fb, 0x7f02f7b6, 0xb485b0d6,
    0x11c23fbf, 0x8fe1ccc9, 0x3d9045a6, 0x164f95ef, 0xb05fda11, 0x2b57c902,
    0x912f57bc, 0x8a0c20e6, 0x91faf7b2, 0xae61b0ec, 0xcdd03f9b, 0x49eaccc7,
    0xe26ec5b1, 0x1728d5cb, 0x80000000, 0x40000000, 0xe0000000, 0xb0000000,
    0xb8000000, 0x94000000, 0x0a000000, 0x0b000000, 0x04800000, 0x7cc00000,
    0x02200000, 0x09d00000, 0xb3980000, 0xe0740000, 0xd00a0000, 0xe20b0000,
    0x3d0b8000, 0xd38cc000, 0x14482000, 0xaae91000, 0x4bfdb800, 0xf0459400,
    0x12e20e00, 0x75f3dd00, 0x0b4f6480, 0xe46b27c0, 0xdc3e3620, 0x46e18910,
    0xdff6cab8, 0x50492aec, 0xe8eeca8e, 0x8cfd2af5, 0xdac4ca9a, 0xd7262afe,
    0xec574ab7, 0x70deeac6, 0x22156ab4, 0x333cfad9, 0x50635299, 0x6c35aefc,
    0x54e97c81, 0xbaff63fe, 0xa7c3a016, 0x4ea5d00a, 0xb9159808, 0x9fbc843c,
    0x50a7b628, 0xf8124932, 0x703f6a95, 0x98e7fadc, 0x3ef0d2a3, 0xefcd6ed6,
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0xc8000000, 0x24000000,
    0x62000000, 0x07000000, 0x13800000, 0xec400000, 0xa8a00000, 0x6df00000,
    0x2d080000, 0x5dd40000, 0xe93e0000, 0x793b0000, 0x913c8000, 0x853b4000,
    0xff3aa000, 0x143ed000, 0x41bcd800, 0xc8ff6c00, 0x74d8aa00, 0xe6ea1100,
    0x8f035980, 0x17801b40, 0xbe46f220, 0xb7a53d30, 0x9275d3b8, 0x874b9a74,
    0x9075d392, 0x904b9a79, 0xabf5d380, 0x880b9a45, 0xa955d3ae, 0xc6fb9a76,
    0xf5ddd398, 0x706f9a57, 0xa7c3d3bd, 0x88e49a60, 0xb35753a6, 0x3dfbda72,
    0x885bf3b3, 0x0d2a0a5a, 0xb1e5ab92, 0x39d52660, 0xab3b2199, 0x4e3aa776,
    0x9abe002b, 0x857b0038, 0x119c8025, 0x1ccb4006, 0x80000000, 0x40000000,
    0xa0000000, 0x30000000, 0xa8000000, 0x3c000000, 0xe2000000, 0x51000000,
    0x84800000, 0xd1400000, 0x29a00000, 0xe2900000, 0xbfa80000, 0x00b40000,
    0x5bfa0000, 0x02790000, 0x5dbf8000, 0x685e4000, 0xf5eb6000, 0x8090d000,
    0xaea8a800, 0x24371400, 0xbabc3200, 0x83dd5100, 0x832e4280, 0x35f5c640,
    0xa4591a20, 0x5fe90510, 0x7d9490a8, 0x502b074c, 0x3071108a, 0xc99c475f,
    0x030df0b0, 0xc0a6d748, 0x82143883, 0xb8e81367, 0x96172290, 0x26e8167f,
    0x85143214, 0xc3695133, 0x78d44287, 0x078cc65b, 0x51e69a21, 0x0bb7451d,
    0x6a7ff0bf, 0x81bbd774, 0x1a59b8a4, 0x3ceb5340, 0x9011c287, 0xa1eb866a,
    0xbe927a1b, 0x8da9d519, 0x80000000, 0xc0000000, 0x20000000, 0xb0000000,
    0x68000000, 0x6c000000, 0x92000000, 0x6d000000, 0x94800000, 0x51c00000,
    0x25600000, 0xcb500000, 0xd9680000, 0x01b40000, 0x847e0000, 0xe7fd0000,
    0x73bf8000, 0xf9984000, 0x9f6de000, 0xaab15000, 0x7bf9c800, 0x69b89400,
    0x689ad600, 0x41e95700, 0x92726880, 0x341ff240, 0x0c2a9e20, 0x6d108330,
    0x4e4cde88, 0xbbc6b56c, 0x3c655eba, 0xe9d7f56b, 0xaba93e8c, 0x2753e547,
    0x8b6a9697, 0x4cb66153, 0xa0fa689f, 0xde3bf26e, 0x3adc9e05, 0xa0c98308,
    0x2b055ebb, 0x3f87f573, 0xae413e98, 0xab27e568, 0xd0749690, 0x611b6172,
    0x0cade88b, 0x1ad7b27c, 0x902f7e29, 0x7715d313, 0xdf4b1685, 0x65432142,
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x98000000, 0x9c000000,
    0xf6000000, 0x49000000, 0x20800000, 0x01400000, 0x84a00000, 0x88b00000,
    0x9df80000, 0xa7940000, 0x1f8a0000, 0x440f0000, 0x66c88000, 0xcca9c000,
    0xe07f6000, 0x5450f000, 0x096de800, 0x9f9f1400, 0x1f455200, 0x39a1f900,
    0xea31d380, 0xf7be7cc0, 0xb8b23a20, 0x95fc2d10, 0xc3916198, 0xa58db5f4,
    0x630be186, 0x934f75f7, 0x1b6e0185, 0x2c9d45f6, 0x78c60996, 0x1d6061c3,
    0x21535382, 0x2fe8bcf3, 0xffddda0c, 0x6f611d38, 0x4251e9ad, 0xd06951f2,
    0x4719dbac, 0x520358dd, 0xd3076034, 0xb784f039, 0xbcc7e82c, 0x5760141d,
    0x2e55d23c, 0x0e6c3907, 0xda1cb38c, 0x80858cd6, 0x80000000, 0x40000000,
    0x60000000, 0x10000000, 0x58000000, 0x7c000000, 0x2a000000, 0x73000000,
    0xe2800000, 0xd6400000, 0x58e00000, 0x1ef00000, 0x11280000, 0x30540000,
    0x673a0000, 0x178f0000, 0x72468000, 0x4ee3c000, 0x27f06000, 0x90ab1000,
    0x5c96b800, 0x959fa400, 0x7b9b7a00, 0x0e98cb00, 0x8d1e9180, 0xa6da9c40,
    0xb8fda220, 0x27ac7f10, 0xb8135398, 0x22ddf344, 0xdef849b6, 0x56ae284f,
    0x1d906032, 0x181b1008, 0x755eb836, 0xab3ba42e, 0x55897a0a, 0x5543cb04,
    0xb26211b6, 0x8cb65c65, 0x0fcb4217, 0x2fa4af27, 0x9b958b96, 0x3919475c,
    0xe8dd8ba2, 0xfdfd4762, 0x8c2f8ba0, 0xa7d6477b, 0x32fb0b9d, 0x64ae874a,
    0x7297eb8f, 0xc0995778, 0x80000000, 0xc0000000, 0xe0000000, 0x70000000,
    0x78000000, 0x74000000, 0x9e000000, 0x67000000, 0x17800000, 0xb2400000,
    0xd8e00000, 0xc3100000, 0xc5880000, 0x91b40000, 0x8a7e0000, 0x992b0000,
    0xb1418000, 0x9962c000, 0xfa572000, 0x90ecb000, 0x61e75800, 0x9391ec00,
    0xf04d5a00, 0xf312c300, 0x9d8ef680, 0x75b5d940, 0x1c7d2220, 0xf22f9f30,
    0x4cc4f4b8, 0xd226f65c, 0x52368ebe, 0xf63c856d, 0xcec9203f, 0x19d7b035,
    0x7caed823, 0x3e072c2d, 0x37047a0f, 0xff857334, 0xce402e93, 0x4ae2f551,
    0x4e115831, 0x2b0eec0a, 0x5372da13, 0xf75b032e, 0x309856b3, 0x6f3ba97b,
    0x0e4d5a11, 0x2412c30d, 0x120ef693, 0xc3f5d94e, 0x229d2209, 0x223f9f00,
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xe8000000, 0x24000000,
    0xc2000000, 0x21000000, 0xeb800000, 0xb0400000, 0x29200000, 0x5dd00000,
    0x2a280000, 0x0cb40000, 0x6ada0000, 0xf1490000, 0x19448000, 0x56a04000,
    0x3796a000, 0xbe0bd000, 0xb4e36800, 0x37b26c00, 0xdc5f9a00, 0x54899d00,
    0xff217080, 0xe6d3ba40, 0xdcaa5220, 0x09702110, 0xdcbd82a8, 0xa9384b54,
    0xd67cb89a, 0x23de0659, 0x7ecca038, 0xcb02d00c, 0x0e87e828, 0x69c22c31,
    0x00613a00, 0x53764d16, 0x21b81880, 0xecb8d667, 0xf139480a, 0xea7dfc17,
    0x7dd8522e, 0x51cd2115, 0xe78302a7, 0xb6410b59, 0x3a2698a1, 0x2f51967c,
    0xbdeb680e, 0x73d66c07, 0xfd2d9a07, 0x4c349d11, 0x80000000, 0xc0000000,
    0x60000000, 0x10000000, 0xa8000000, 0x24000000, 0xde000000, 0xd1000000,
    0x23800000, 0x0bc00000, 0x3d600000, 0x85f00000, 0x38280000, 0x07540000,
    0x36be0000, 0x2f8f0000, 0xe4428000, 0x6ca04000, 0xc792a000, 0xf75b3000,
    0x9b3ee800, 0xfd4ccc00, 0xaea12600, 0x8493ff00, 0x9fdbad80, 0xac789440,
    0x916d6e20, 0x1a740330, 0xd1ec6398, 0xc933a744, 0x03c9e58a, 0xbce06879,
    0xdd30200f, 0xc5cb7000, 0x91e4483a, 0xbcb3fc0f, 0x4d09ce12, 0xa404331c,
    0x1e060bb1, 0xb1042b77, 0x3386e3aa, 0xa3c7e758, 0x19654580, 0x5bf4584f,
    0xe92c4820, 0x24d7fc0a, 0x3d7fce17, 0x12ef3316, 0x61b28bb6, 0x548f6b78,
    0xc0c0c3a0, 0xc1e7974e, 0x80000000, 0xc0000000, 0x60000000, 0x30000000,
    0x58000000, 0x9c000000, 0x2a000000, 0x87000000, 0xde800000, 0x40c00000,
    0x4be00000, 0xee300000, 0xaa480000, 0x7f140000, 0x109e0000, 0x19ef0000,
    0x9f038000, 0xe287c000, 0x3ac66000, 0xa4e21000, 0xf4b21800, 0x5c8b4400,
    0x99f36e00, 0xa72e9300, 0x2de48380, 0xeb328b40, 0x57cf1620, 0x6753c730,
    0xeebbf598, 0x79b85c4c, 0x6f3b7bb6, 0xbbf81f57, 0x2e1e0032, 0xa92f001d,
    0xece38039, 0xa0b7c03b, 0xe28e600e, 0xc0f6103d, 0x10ac1817, 0x82a4442e,
    0x9390ee21, 0xeb59532d, 0xf68ae39f, 0xdef49b5c, 0x19ab0e00, 0x5d238300,
    0xf8d51b86, 0x25fe0f65, 0xe71a1839, 0x16af442f, 0xb7a56e2a, 0x36159329,
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x58000000, 0x64000000,
    0xe2000000, 0xfb000000, 0xc5800000, 0x4f400000, 0x27a00000, 0x05b00000,
    0x3dd80000, 0x3f540000, 0x8cca0000, 0x8ebb0000, 0x8f028000, 0x3f87c000,
    0x3040a000, 0x90215000, 0xe9f63800, 0xbbfa1c00, 0x97a6b200, 0x6db2c900,
    0x71db7b80, 0x715229c0, 0xa9c82a20, 0x363d8510, 0x1cc1f1b8, 0x69e1fce4,
    0x989763b6, 0xc0aaa5c9, 0xc96a0020, 0x300b000a, 0x975a801f, 0xdf93c02e,
    0xc32aa027, 0x7f2a5026, 0xb92cb806, 0x4029dc22, 0xeeac121b, 0x3c689931,
    0x308fc3a5, 0xf09ff5c1, 0x33f63800, 0xf4fa1c18, 0x0826b202, 0x2df2c926,
    0x29fb7b9c, 0xa4a229e9, 0x94302a32, 0xb8998538, 0x80000000, 0xc0000000,
    0x20000000, 0x90000000, 0x18000000, 0x54000000, 0xce000000, 0x85000000,
    0xc2800000, 0xebc00000, 0x9a600000, 0x6d500000, 0xdcb80000, 0x1af40000,
    0x028e0000, 0x439d0000, 0xec068000, 0xca07c000, 0x73072000, 0x83823000,
    0xff464800, 0xa0a2c400, 0xfbb50600, 0xdf2eef00, 0x9eae2080, 0x9eef68c0,
    0x07cc6e20, 0xd83a1b30, 0xf8336e88, 0xe06e43e4, 0x1e09c8a6, 0xf5585ce5,
    0xc0e0001b, 0x12900035, 0xa8d8003e, 0x62a4000b, 0x04b60013, 0xe6a9002f,
    0xbae88034, 0x61cac01d, 0x8139a016, 0xb8b1f031, 0x14af682a, 0x0dedf42f,
    0x344dce2b, 0xaf7feb36, 0x14920684, 0x81deb7ca, 0x8a2286b9, 0x2c7077d5,
    0x774d26ac, 0x64f887fb, 0x80000000, 0x40000000, 0x60000000, 0x70000000,
    0x08000000, 0x2c000000, 0x0a000000, 0x0f000000, 0xf8800000, 0x77400000,
    0x3be00000, 0xc0700000, 0xd9c80000, 0x1ed40000, 0x395a0000, 0xb1ef0000,
    0xd0058000, 0x58014000, 0x3401e000, 0x5e039000, 0x21015800, 0xd186f400,
    0x8ac39200, 0xbb266300, 0x74527d80, 0x551cab40, 0x3c8b2a20, 0x3e370710,
    0x4faab798, 0x46633c5c, 0x00b745a2, 0x0de88f5b, 0xe200003a, 0x1300000f,
    0x9a800024, 0x2440000a, 0xc160000e, 0x94300038, 0x10a8000a, 0xa6e40019,
    0x23f2003e, 0x180b0001, 0x0b77800c, 0x374a4021, 0x04966035, 0xa939d03c,
    0xfc5f3832, 0x666b240e, 0x4fc6aa1b, 0x6ca2472f, 0xeb915798, 0x61bfac76,
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x78000000, 0x9c000000,
    0xd2000000, 0x83000000, 0xed800000, 0x74400000, 0x16a00000, 0x36100000,
    0x77280000, 0x9af40000, 0x469a0000, 0xd54f0000, 0x02878000, 0x13c2c000,
    0x2de66000, 0x5734d000, 0x527b3800, 0x58f91c00, 0xcf3f2a00, 0x9cdec100,
    0xe2e9fe80, 0x4217ee40, 0x512a7220, 0x7ff70d10, 0x2e1fec98, 0xf98b334c,
    0x40e126be, 0xfbb3e277, 0x60bd800c, 0x039dc03c, 0xadc9e03d, 0x06421036,
    0x85a7582f, 0xf392cc0a, 0xd76b9212, 0xba511d1b, 0xbd8ab4af, 0x1ee2ff65,
    0x82b734b8, 0xda3f3f7f, 0xac5ed4bf, 0x022d2f5a, 0x9a718ca3, 0xde5be35c,
    0x91281eaa, 0x5ff1fe6d, 0x7e1f2a0e, 0xb18ec115, 0x80000000, 0x40000000,
    0xe0000000, 0x90000000, 0x98000000, 0xfc000000, 0xf6000000, 0x83000000,
    0xcf800000, 0x83400000, 0x39200000, 0x9a700000, 0x61f80000, 0x7a140000,
    0x8faa0000, 0x411b0000, 0x26828000, 0xe9c1c000, 0x8ee46000, 0x8397f000,
    0x2fef3800, 0xc7ba2c00, 0x37b1b200, 0xd51ead00, 0x64813580, 0x18c49cc0,
    0x5862ea20, 0x22577110, 0x250dbfb8, 0xde2f1de4, 0xf55aed86, 0xa22780ef,
    0xe9f08025, 0xf4bec014, 0x5034e02d, 0x4259303b, 0x5fa3d815, 0x93b71c39,
    0x7f186a16, 0x6182b11e, 0x5c43df9e, 0x70a3edd6, 0x923755bf, 0xf35c6cd2,
    0x69255200, 0xa2779d1a, 0xedfaedbf, 0x841780c0, 0x68a8801c, 0x849ac020,
    0xd0c6e007, 0x9c663033, 0x80000000, 0xc0000000, 0xe0000000, 0xf0000000,
    0xc8000000, 0x8c000000, 0xf6000000, 0x2d000000, 0xaa800000, 0xc9400000,
    0x3ca00000, 0xfd100000, 0xdcc80000, 0x75f40000, 0xaffe0000, 0xc96b0000,
    0x78658000, 0x71774000, 0x3fbce000, 0x0d4a7000, 0xeb314800, 0x289f8400,
    0x759c1200, 0xd71e1900, 0x725bd680, 0x48f81940, 0x50efba20, 0xaaa0ed30,
    0xe0130cb8, 0x5e4ec47c, 0xc0b49e92, 0xad5c9d53, 0x957e2825, 0xf82db407,
    0xe0c23a20, 0x0663ad2d, 0xf071ec80, 0x733fb457, 0xd1085680, 0x39105954,
    0x66c8da16, 0x4ef6dd33, 0xd87b24ac, 0x62ac7061, 0x018524bc, 0x46c77074,
    0x3360a480, 0x0ef03051, 0xf87c4483, 0x72aa4048, 0x39850c86, 0x02c1c45d,
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xe8000000, 0x24000000,
    0x5e000000, 0xe3000000, 0x19800000, 0xd8c00000, 0xea200000, 0x63900000,
    0x46f80000, 0xda740000, 0xb2ca0000, 0x59dd0000, 0x77648000, 0xa3744000,
    0x264aa000, 0xe39b3000, 0xc0077800, 0x60001c00, 0x7000ae00, 0xb8054500,
    0xcc037680, 0x7a0070c0, 0xbd077620, 0xfa836910, 0xc1402088, 0x32e169d4,
    0x89b60e9a, 0x25696cd9, 0x9c89583f, 0x68bf6c3c, 0xeb157634, 0x2eba692b,
    0xd416a097, 0x853c29e9, 0xc5d22ea0, 0x239b1ce8, 0xa0000038, 0x1000003c,
    0xc8000004, 0x7400001b, 0xb6000019, 0xc7000029, 0x47800010, 0x3bc00028,
    0xf3a00034, 0xbb500010, 0xacd80021, 0xb9e40010, 0x80000000, 0x40000000,
    0xe0000000, 0xf0000000, 0xf8000000, 0x24000000, 0x8e000000, 0x75000000,
    0x8e800000, 0xb1c00000, 0x68a00000, 0x59b00000, 0xc4180000, 0x2dd40000,
    0x0f8a0000, 0x67bb0000, 0xd7e18000, 0xc0d2c000, 0x1509a000, 0x40783000,
    0x1e434800, 0x61e42400, 0x31d2d600, 0x058cd900, 0x8cb9d780, 0x2463bbc0,
    0x23923e20, 0x666bcd10, 0x8a69c9b8, 0x786986fc, 0xb7689f9e, 0xcae89fd9,
    0x5cab683b, 0xa14ed431, 0xda983e25, 0xd410cd19, 0x5b284987, 0x640b46c2,
    0x10f93f91, 0x3284afea, 0xabc22022, 0x8ba1f00f, 0x76336818, 0x8d5ad418,
    0xa5b23e2a, 0x3e1bcd16, 0x3ed1c9b1, 0xd80d86c0, 0x0afa9fa5, 0xd1879fcb,
    0x8440e812, 0xc2e71430, 0x80000000, 0xc0000000, 0x20000000, 0x10000000,
    0x28000000, 0x4c000000, 0x9e000000, 0x19000000, 0x96800000, 0x67c00000,
    0xe9e00000, 0x28500000, 0x65980000, 0x27740000, 0x86ae0000, 0xd77d0000,
    0xf6a28000, 0x67764000, 0x66abe000, 0xe7793000, 0xcea1e800, 0x03752400,
    0xb4ae8600, 0x607ef300, 0x4127e880, 0xf236cdc0, 0x3a8a8e20, 0xa1cfe730,
    0x0cea0688, 0xb0db5ac4, 0x9b5000aa, 0xf01ae9e3, 0x2d30880f, 0x210e5432,
    0x9a8a8e27, 0x71cfe70e, 0x04ea0697, 0xecdb5adf, 0x2d5000bb, 0xa51ae9e6,
    0x25b08816, 0x5fce5412, 0xe5ea8e1c, 0x3e5fe70d, 0x8892068c, 0xe3ff5ad0,
    0xce66008d, 0x5513e9c3, 0x55bc083e, 0xefc5141f, 0x75e3ee1b, 0xbe509711,
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x88000000, 0xcc000000,
    0xc6000000, 0xb9000000, 0xdf800000, 0x0ac00000, 0x41600000, 0x0db00000,
    0x0d680000, 0x43140000, 0x303e0000, 0x2c0d0000, 0x9ea38000, 0xa5534000,
    0x1b1ee000, 0x2c9ff000, 0x3a5de800, 0x253dac00, 0xe5892e00, 0xb567ff00,
    0x4fb26780, 0x9e6ea640, 0xd3942620, 0xd478a330, 0x742d2188, 0x1eb3b54c,
    0x5def8f82, 0x87530a43, 0x581d0819, 0x241f5c12, 0xaa1f461d, 0xff1d133d,
    0xd69ba983, 0xed5ba95e, 0xbfb829a5, 0x7ec8e94c, 0x8bc6c983, 0x1ae71976,
    0x2d7321be, 0x030eb575, 0xa0240fb2, 0x24144a71, 0xe2bde829, 0x5b4dac08,
    0x56012e24, 0xc103ff1f, 0xbb8467ac, 0x30c7a669, 0x80000000, 0xc0000000,
    0x20000000, 0xd0000000, 0xe8000000, 0x34000000, 0x66000000, 0x5d000000,
    0x03800000, 0xf8c00000, 0x5ea00000, 0xbc900000, 0xd6880000, 0xdbf40000,
    0x853e0000, 0x822d0000, 0xb0648000, 0x47304000, 0x959e2000, 0x77bef000,
    0xd36e0800, 0xd1018c00, 0x79879e00, 0xd7c0c100, 0xb6225e80, 0xf2d65740,
    0x4769b620, 0xa702bd30, 0xec874888, 0x30435a74, 0xc0e4569a, 0xc573db7d,
    0x9e782831, 0xd44b7c13, 0x6a579632, 0xf12c4d07, 0xcae140b4, 0x1276d675,
    0x8afdc88c, 0x180e1a6f, 0x28b6f69e, 0xe7596b75, 0x3e1e001c, 0x5b7d0001,
    0x1bcc801a, 0x08944025, 0x7088201a, 0xa6f7f021, 0x56bc8819, 0x92e8cc3f,
    0xdac33e1e, 0x9da37132, 0x80000000, 0x40000000, 0x60000000, 0xf0000000,
    0x38000000, 0x64000000, 0x96000000, 0x11000000, 0x4d800000, 0xf5400000,
    0x99e00000, 0x4cd00000, 0x3e580000, 0x1d740000, 0x2cea0000, 0x19bf0000,
    0xaca18000, 0xf530c000, 0xe28fa000, 0xeb2ef000, 0x6d9c6800, 0xc750fc00,
    0x321d1200, 0x05176b00, 0xaf78c080, 0x6503c7c0, 0x5384da20, 0xd8466710,
    0xd6603a98, 0x069090fc, 0x9f3ca8ae, 0x7f673bc9, 0x6f13c81d, 0x9c7e0c28,
    0x07817a05, 0x56479718, 0x3365d28d, 0x1514acce, 0x277c1a99, 0x5905a0ee,
    0x5184e086, 0x6746f7c4, 0xeee49234, 0x2853ab1c, 0xe29d608f, 0xe7d237da,
    0xe8d93223, 0x26b65b3a, 0x7aca8897, 0x5d4d0bd0, 0x9b0a001c, 0x606f0032,
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xd8000000, 0xb4000000,
    0x8e000000, 0x49000000, 0x70800000, 0xbec00000, 0x2f200000, 0x47300000,
    0x59780000, 0x19d40000, 0x34ee0000, 0xbbd90000, 0x7ea38000, 0x2575c000,
    0x52992000, 0x86c73000, 0xcb272800, 0x81375400, 0x4c7a4e00, 0x8b527500,
    0xf92feb80, 0x237b34c0, 0xbed24620, 0x9d6f1130, 0x9d9f0da8, 0x8342d5cc,
    0x77654396, 0x8bd0a0dd, 0xffeaa82b, 0x285b942e, 0x9fe0ee02, 0xe110850e,
    0xcec9e39e, 0xce6f50ee, 0xda192009, 0x7c07300b, 0x12072832, 0x0b07541c,
    0x33824e34, 0xd1467533, 0x1c61ebac, 0x285234db, 0xc6a9c61c, 0x583ed118,
    0x8db02dbb, 0xe0b8e5d7, 0xaf77eb98, 0x8d9f34d2, 0x80000000, 0x40000000,
    0x60000000, 0x10000000, 0x08000000, 0x9c000000, 0x8a000000, 0x71000000,
    0x0e800000, 0x5cc00000, 0x83600000, 0x31900000, 0x75280000, 0x51340000,
    0x865a0000, 0x50cf0000, 0x90668000, 0x82114000, 0xc56f6000, 0x73909000,
    0xb82d2800, 0xa5b7c400, 0xb39fbe00, 0x4928a700, 0xeb317e80, 0x8f584440,
    0xda4ff620, 0xd2a4f310, 0x66776898, 0x017d6744, 0x25fad6a2, 0x383ec077,
    0xcddf281a, 0x248cc408, 0xccc33e19, 0xcb66e734, 0xcd909e80, 0xef2d9477,
    0x2837be1c, 0x14dca70f, 0x860b7e9a, 0x6207444b, 0xbd01763b, 0xec81b30f,
    0xa1c208b7, 0x0fe2f744, 0x80517e8a, 0x72c8447d, 0x4d67f603, 0x7e90f32a,
    0x6cad68a1, 0xe0726776, 0x80000000, 0x40000000, 0x60000000, 0xd0000000,
    0xb8000000, 0xf4000000, 0x36000000, 0xb7000000, 0x99800000, 0x6bc00000,
    0xa8200000, 0xac500000, 0x7df80000, 0x92b40000, 0xbd0a0000, 0x1c5f0000,
    0xad208000, 0xfcd4c000, 0xc4ba2000, 0x62d6f000, 0x1fbdd800, 0x8955dc00,
    0x9d7bd600, 0x43f6f500, 0x0169d080, 0x7cee80c0, 0xb92e2e20, 0xe20ed910,
    0x89dd5e98, 0x64e269f4, 0x05f4888e, 0xfe6f9ced, 0x196fd835, 0x78eedc09,
    0x87295610, 0xc9093513, 0x6a597089, 0x7a23b0fb, 0xb5515614, 0x177d3503,
    0x3ef370bb, 0x85ecb0c2, 0x43a9d610, 0x964df51d, 0x953b5094, 0xb51140e2,
    0x7d9e8e2b, 0x3803e92d, 0xb4022682, 0x560185c5, 0x6702a681, 0x218545f6,
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x28000000, 0xec000000,
    0xea000000, 0xc5000000, 0x97800000, 0xb4400000, 0x6da00000, 0x2d300000,
    0x32080000, 0x03540000, 0x56de0000, 0xb9cb0000, 0xf6b08000, 0x1c484000,
    0x33f6e000, 0x786a9000, 0x11830800, 0x5b400c00, 0xdf229a00, 0x5ef41900,
    0xc3ee6780, 0xafc21740, 0xa3e7f220, 0x4d96c530, 0x34b915b8, 0x471c9254,
    0x112807aa, 0xbfa0c74b, 0x0c321a22, 0x138c5915, 0xe0108797, 0xadfc8742,
    0xb13afa0b, 0x325dc931, 0x0d0b0fab, 0x59d0cb48, 0x29188001, 0xf22c4003,
    0xb720e028, 0x92f59029, 0x99ed883a, 0x12c34c26, 0xf064fa0d, 0xffd6c905,
    0x761b8faf, 0x38a88b63, 0x00e66016, 0x6512d036, 0x80000000, 0xc0000000,
    0xa0000000, 0x10000000, 0xd8000000, 0x84000000, 0xc6000000, 0xed000000,
    0xf2800000, 0xb1c00000, 0x53200000, 0xc0500000, 0x9f880000, 0x40340000,
    0xa53e0000, 0x68c90000, 0x6cd28000, 0x274dc000, 0x9795a000, 0xf1ae7000,
    0x0ae48800, 0x1f730400, 0x65df1600, 0x60bac500, 0xe48ee880, 0xe7b7a340,
    0xd27cbe20, 0x842a7130, 0x4ea0d6a8, 0xc8101244, 0xd2e9c896, 0x58041351,
    0x44059639, 0x6603050f, 0xfd0548a2, 0x2a80d349, 0x35c2b633, 0x9520b51a,
    0x2d546082, 0x6d0da743, 0xf1f12817, 0xf61d7417, 0xa89b9e31, 0xf359c116,
    0x6779fea1, 0x32a9667b, 0x996456b5, 0x6630d26f, 0x3838e8b4, 0xf24aa365,
    0x91103e1d, 0xee6eb13d, 0x80000000, 0x40000000, 0x60000000, 0x10000000,
    0x68000000, 0x24000000, 0xce000000, 0xc9000000, 0x0b800000, 0xedc00000,
    0xfda00000, 0x0a500000, 0x41680000, 0xf9b40000, 0x3f5a0000, 0xe12f0000,
    0x54d68000, 0x052a4000, 0xbad6a000, 0xbc2fb000, 0xc9532800, 0x1ded8c00,
    0xdef31600, 0x10ba5900, 0x5d1d5080, 0x0f4b6040, 0x72201e20, 0x19922510,
    0x6dcbce98, 0xa4630544, 0x11f570ba, 0xc63a9059, 0x6d5f960b, 0x8a2f1926,
    0x0c557080, 0x9c6a9076, 0x24379636, 0x479b1929, 0x950f70b9, 0x90459073,
    0xb5611608, 0x66715918, 0xd9f9d091, 0xcbfa204b, 0xc0fa3e09, 0x8878d50b,
    0x7938c6bc, 0xc3db794a, 0xf66beea4, 0x6336f576, 0xe518f8b0, 0x634cac77,
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x28000000, 0x74000000,
    0x6e000000, 0x55000000, 0x6e800000, 0xa9400000, 0x4c600000, 0xe1d00000,
    0x8eb80000, 0xa2740000, 0x4e4e0000, 0xb7790000, 0x5a548000, 0x897a4000,
    0xe7542000, 0x33fab000, 0xf0114800, 0x029b2400, 0x0b44d200, 0x4b609f00,
    0xb0560080, 0x8a7cd4c0, 0x20d53a20, 0x3e3b4b30, 0x0637baa8, 0xe0addff4,
    0xcdeea0aa, 0xd78824ed, 0x9f5e5213, 0xb563df11, 0xad56a0b9, 0xe0fc24c3,
    0x1f905222, 0x7b5adf00, 0x9362208b, 0xfc5664e3, 0x187c7231, 0xbfd46f12,
    0x43bd6895, 0xe0f440d3, 0x050c2038, 0x9c1eb00e, 0x9a074819, 0xfb062416,
    0x9b86521f, 0x17c7df23, 0xcd20a0b2, 0xd9b124ee, 0x80000000, 0x40000000,
    0x20000000, 0x10000000, 0x38000000, 0xf4000000, 0x12000000, 0xe9000000,
    0x82800000, 0x8c400000, 0x77200000, 0xfb700000, 0x4c580000, 0xbe940000,
    0xe24a0000, 0x799d0000, 0x4e768000, 0x50dac000, 0x1dd22000, 0xfcebd000,
    0x5d2c2800, 0x8fcda400, 0xfc5d7a00, 0xd690c500, 0x0e4d7d80, 0x8f9911c0,
    0x8d75f220, 0xcf5c7110, 0x01160f88, 0xee8ba0c4, 0x53fbddae, 0xb4a101ed,
    0x79b77a2c, 0x713dc52e, 0xd9c3fda6, 0x06e7d1da, 0x7195d237, 0xfbcea129,
    0xae5ea7bf, 0x1f95c4f2, 0x9cc807ab, 0x3bddd4ee, 0x0e528fb1, 0x262860eb,
    0xa44d7daa, 0xd29911c4, 0x3df5f203, 0xba1c7104, 0xccb60f9a, 0x6dbba0d1,
    0x7a83ddbc, 0x184501eb, 0x80000000, 0xc0000000, 0x60000000, 0xd0000000,
    0x08000000, 0x44000000, 0xce000000, 0x47000000, 0x6f800000, 0x35400000,
    0x68200000, 0x6d300000, 0xdab80000, 0x11d40000, 0x6dee0000, 0xc1ff0000,
    0x2ef48000, 0x075d4000, 0xba03a000, 0x9106b000, 0x04835800, 0x00c1ac00,
    0xdc65a200, 0x69902500, 0x234fcf80, 0xd10a06c0, 0x16a9da20, 0x2ede7930,
    0x4c449598, 0x38a23ff4, 0xcbf46fa2, 0xd5d8b6e1, 0xd1c4820b, 0x78e0d515,
    0xd955b781, 0x272f5ae8, 0xf498000b, 0xbfe4002b, 0x76d60006, 0x726b002c,
    0x4cba8018, 0xdad24037, 0xe86f2014, 0xadbff00f, 0x6656f818, 0x74ac1c1d,
    0xf3dc7a0b, 0xc2c3c92a, 0xb1654da4, 0x3f15d3fb, 0xe688ed9c, 0xafec63d0,
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xc8000000, 0xd4000000,
    0x72000000, 0xbb000000, 0x0c800000, 0xadc00000, 0x96e00000, 0xff900000,
    0x59e80000, 0x0a340000, 0x8e5e0000, 0xb2290000, 0xc5d58000, 0x5e4d4000,
    0xa6802000, 0x9ac45000, 0xa4603800, 0x7752d400, 0x168d6600, 0x49e3ab00,
    0x29176680, 0xcb2bce40, 0xda50fe20, 0x7b0c6f30, 0xd7a418a8, 0x54b7e17c,
    0xa89f4692, 0x404b9e45, 0xb386c614, 0x2b43bb22, 0x3c22fe99, 0x33f00a62,
    0x0abd802b, 0xa6b94014, 0xa8be2021, 0xe5bd503b, 0x183db837, 0x1e7b940d,
    0x8fdb461e, 0x826afb04, 0x0574de9f, 0x08795a63, 0xeede383e, 0xb1ebd429,
    0xee30e623, 0x945aeb1d, 0x2d29469b, 0x73569e50, 0x80000000, 0x40000000,
    0xe0000000, 0x10000000, 0x38000000, 0x7c000000, 0xae000000, 0x81000000,
    0xf6800000, 0x81c00000, 0xc2600000, 0x48300000, 0x90e80000, 0x23140000,
    0x727a0000, 0x6b2b0000, 0xca768000, 0x7fccc000, 0xb3806000, 0xe5463000,
    0x8ca12800, 0xedd1a400, 0x979cb600, 0x8c5a4f00, 0x753a8b80, 0x408b9240,
    0xe4237e20, 0x65151b10, 0x177d75b8, 0xbfad4944, 0x4cb2ebae, 0x8e29a24f,
    0x5ef05633, 0x190bbf34, 0x5265438b, 0x3034c67b, 0x0cec8035, 0x9d17c03d,
    0xcb7ee00a, 0xe1aef00c, 0xe5b3481f, 0x3ca89437, 0x0d311e0d, 0xf46c2b25,
    0x6dd0dda9, 0xd79b2d4b, 0x6c58bd9d, 0x65391d7c, 0x788b9587, 0x9827b959,
    0xcb13a398, 0x967e3643, 0x80000000, 0x40000000, 0x20000000, 0xf0000000,
    0xa8000000, 0x44000000, 0x2e000000, 0x1d000000, 0x09800000, 0x3fc00000,
    0x73e00000, 0x6ff00000, 0x60a80000, 0xdc540000, 0xf27a0000, 0xe36d0000,
    0xddb18000, 0x628e4000, 0x0d40a000, 0xaca1b000, 0x8c568800, 0xea7c9c00,
    0x2f692600, 0x47b71b00, 0xf988bd80, 0x5dc30c40, 0xb4e68e20, 0xdd707710,
    0xffedb388, 0x1ff43b7c, 0x88a81d8a, 0xb852bc41, 0x2c780623, 0x5668eb2b,
    0x903695a0, 0x734a2062, 0x63a3201d, 0xcad6f01d, 0xd33da819, 0x45ce6c03,
    0xb2e68e08, 0xc470773d, 0xf86db3b8, 0xcd343b73, 0x5ac81d85, 0xac62bc7b,
    0x1130061c, 0xf8cceb2d, 0x0b649585, 0x73b32078, 0x3f88a023, 0x24c5b038,
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x88000000, 0x84000000,
    0xbe000000, 0x81000000, 0x57800000, 0x73400000, 0x23e00000, 0xa4900000,
    0x48a80000, 0xa5b40000, 0x819a0000, 0x7fef0000, 0x18528000, 0x540d4000,
    0x78c7a000, 0xc2a73000, 0xcc776800, 0x9cbfec00, 0x44da2200, 0x190d8b00,
    0x3544f280, 0x7ee14840, 0x21106a20, 0x10ec1710, 0x66d41898, 0x04cb1f64,
    0x8e635282, 0xc8d67871, 0x4dcf0217, 0x3de7fb14, 0x95943aaf, 0x67299459,
    0x4af52025, 0x107a7038, 0x6078c830, 0x387cdc31, 0x547f4a1f, 0xfe79670b,
    0x497e50b3, 0x1bfa8375, 0x813bb899, 0x50982f4a, 0x806e3aa5, 0x1f169470,
    0xd1efa001, 0x5153301f, 0xe78d6815, 0x2580ec32, 0x80000000, 0xc0000000,
    0xa0000000, 0x70000000, 0xb8000000, 0x4c000000, 0x7e000000, 0xd1000000,
    0x7c800000, 0x91c00000, 0xaba00000, 0x7f700000, 0x45880000, 0x2b940000,
    0x1f9e0000, 0x0f490000, 0xdfb18000, 0x82aec000, 0xad20e000, 0x75b3b000,
    0xd1ac2800, 0x66a5f400, 0x75f23600, 0x514f5100, 0xbeb0e180, 0xe62eb740,
    0x00e77e20, 0x1813d530, 0x33d81fa8, 0x21aaa25c, 0x1ea6018e, 0x99f00763,
    0x5f4cd617, 0xd7b5e118, 0xd6ad4999, 0xef25836b, 0x62b5a83b, 0x302f3408,
    0xf5e4d639, 0x9e91e106, 0xf91b499c, 0x1588836b, 0x23922833, 0x4b9cf431,
    0x4d4bb60a, 0xc8b5912c, 0x632e0180, 0x3e640776, 0x9ed2d62f, 0x79fce127,
    0xcd9cc980, 0xb04b4346, 0x80000000, 0xc0000000, 0x60000000, 0x50000000,
    0x28000000, 0x4c000000, 0x9e000000, 0xf1000000, 0xe5800000, 0x58c00000,
    0xb5e00000, 0xcf100000, 0x71b80000, 0xc5b40000, 0xd48e0000, 0xf67f0000,
    0xdcd08000, 0xa2dc4000, 0xe8e7e000, 0x24913000, 0x907fa800, 0x89d73c00,
    0xf55efe00, 0x8f206b00, 0xadf3e280, 0xae292cc0, 0x8b4e3620, 0xbb1e2730,
    0x00835498, 0xb7444bd4, 0xd62202aa, 0xc4731ce3, 0x08ef1e1f, 0x9faa5b18,
    0xb98acaab, 0x65f950d1, 0x5911a820, 0x3cb83c2c, 0xa6367e1a, 0x49482b0f,
    0x5c1a02ab, 0x68071ccb, 0xec011e01, 0xae055b26, 0x89024ab2, 0x818110c7,
    0x8ac04821, 0xdae20c27, 0xdb975613, 0xccfc571b, 0x28939cb3, 0xae7a07f8,
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xa8000000, 0xa4000000,
    0xc2000000, 0x77000000, 0x40800000, 0xc0400000, 0xc0a00000, 0xda700000,
    0xf1e80000, 0x25140000, 0x1ffa0000, 0x846b0000, 0x92d28000, 0xbf984000,
    0xcefaa000, 0xd1e9d000, 0x1512d800, 0xc7f8b400, 0x18696a00, 0x5cd55900,
    0xae99a580, 0x3b788040, 0x26299220, 0x55777d10, 0x1d6a37b8, 0xf354fd64,
    0x5259258a, 0x659fc079, 0x85fbb228, 0x2f6ded29, 0xfc50cf82, 0xfeddd97d,
    0x53d8378a, 0x585bfd52, 0x6699a584, 0x4f788050, 0xac299215, 0x16777d3a,
    0x37ea378a, 0xe014fd40, 0x107925a2, 0x08afc048, 0xf433b22e, 0x1049ed10,
    0xd2e2cf9f, 0x85d2d94e, 0x2f18b7ac, 0x46bcbd71, 0x80000000, 0x40000000,
    0xe0000000, 0xb0000000, 0x48000000, 0x74000000, 0x46000000, 0xff000000,
    0x46800000, 0xea400000, 0xdc600000, 0x02900000, 0x2b880000, 0x99340000,
    0xefba0000, 0xd10b0000, 0x01738000, 0x6adf4000, 0xda1d2000, 0xce3bf000,
    0xb1cf1800, 0xad572400, 0xc9285a00, 0x44844f00, 0x5b412280, 0xf1e3c540,
    0x5853e220, 0xaaacdb10, 0x7540c0b8, 0x6ae01e6c, 0x40d2a2b2, 0x33ec854d,
    0x95a6c209, 0x4f332b03, 0x48bdd8bb, 0xfb883a4b, 0x21337894, 0x33bc8a72,
    0x53094092, 0xf0745e5f, 0xa75c0297, 0x30d8356f, 0x071cfa26, 0x29bbff22,
    0x6e089aad, 0xa7f45155, 0x309b8012, 0x4e7b400d, 0xb8af2001, 0xdc44f037,
    0xcb669809, 0x60136411, 0x80000000, 0xc0000000, 0xe0000000, 0x10000000,
    0x68000000, 0xcc000000, 0x7a000000, 0x9d000000, 0x58800000, 0xd3c00000,
    0xe4a00000, 0xdd300000, 0x08e80000, 0x53d40000, 0x983e0000, 0x786b0000,
    0x6c128000, 0xf69a4000, 0x405de000, 0x987a1000, 0xc08cc800, 0xdbc2f400,
    0xf8a36600, 0x2f33a900, 0x49ecc380, 0x1957e440, 0x1afece20, 0xbe4a0d30,
    0xffe40db8, 0x4252e944, 0x1d7e43ba, 0xec0da443, 0x36032e06, 0x27001d13,
    0x2580c5b4, 0x9b441d43, 0x5f63259d, 0xf5950d53, 0xafdd6d92, 0xc63db973,
    0x936beb8b, 0x3390005a, 0xf0dde03c, 0x47ba103e, 0xbe2cc81e, 0x8bf2f408,
    0xc0cb6626, 0x6327a902, 0x4f72c386, 0x210ce460, 0x26844e19, 0xc8c44d2f,
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xa8000000, 0x34000000,
    0x12000000, 0x37000000, 0xc6800000, 0x04c00000, 0xbae00000, 0x4e700000,
    0xe2180000, 0x1dd40000, 0xb2ca0000, 0x0a9d0000, 0xb8118000, 0x63ae4000,
    0x75ab2000, 0x98ac5000, 0x8d2a5800, 0x056f8400, 0x104cce00, 0x045e3b00,
    0x89f09180, 0x3d5ba9c0, 0x1e763620, 0xfa1eaf10, 0xa1d4a788, 0x64cc06fc,
    0x8799118a, 0x7d91e9dd, 0xb3ef162c, 0xfc8bff21, 0xaabd7f93, 0x2584c2f0,
    0x40457fa0, 0xf120c2c3, 0x5e177fa5, 0x26a9c2e7, 0x542cffb1, 0x02ea82f1,
    0xaf0e5fbe, 0xd7fc92e0, 0x992527be, 0x0a1246ce, 0xe4aa31b8, 0x3b29b9e5,
    0x586f4e16, 0x8dc97b06, 0x481831b1, 0x26d0b9c3, 0x80000000, 0x40000000,
    0xe0000000, 0x70000000, 0xc8000000, 0x94000000, 0x6a000000, 0xed000000,
    0x9f800000, 0x31400000, 0x21a00000, 0x4b500000, 0x2e680000, 0x13340000,
    0x1f5a0000, 0x356b0000, 0x3fb58000, 0xa69b4000, 0xef0c2000, 0xa7809000,
    0x2d408800, 0x3fa78c00, 0xbc507200, 0x94e87900, 0x29f4dc80, 0x65bfcc40,
    0xb29b5a20, 0xc50b2510, 0xaa8786b8, 0xc2c0e95c, 0xc6e6dc92, 0x09f0cc75,
    0xb5bcda02, 0xea9f6537, 0xe90c26ad, 0x9c843975, 0xd1c5f480, 0xde67905c,
    0x4a35802e, 0x3adb403f, 0xb12c2022, 0xad90902a, 0xea888824, 0xf3c38c21,
    0xe762720a, 0x5fb77917, 0x969b5cac, 0xc70f8c75, 0x4382fa38, 0x8f40f523,
    0x46a32e8e, 0x49d3f56a, 0x80000000, 0x40000000, 0xa0000000, 0xf0000000,
    0xb8000000, 0x44000000, 0x46000000, 0xf7000000, 0xa1800000, 0xc9c00000,
    0x1d200000, 0xe6100000, 0x89b80000, 0x4a740000, 0xa1ca0000, 0x4ab90000,
    0x55f18000, 0x7b0ac000, 0x401ca000, 0x35267000, 0x0a175800, 0x63bf9c00,
    0xf7758600, 0x4d4fbd00, 0xd7fd6280, 0x9196e2c0, 0x1f7dfe20, 0x5ad19110,
    0xc4189ca8, 0x932373fc, 0xad17628e, 0x8a3fe2c1, 0xc2b47e19, 0x526f5111,
    0x80ee3cae, 0x4eac03df, 0x3d49ba98, 0x2ffebec5, 0x75975813, 0xa97f9c31,
    0x15d58601, 0x219fbd34, 0x1ce5628f, 0x4732e2d9, 0xcdaffe03, 0x82cc9112,
    0x053b1cb8, 0xc734b3e3, 0x8da84293, 0x22ce52ea, 0xf53c0634, 0x7f317d20,
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x48000000, 0xec000000,
    0xaa000000, 0x69000000, 0xf6800000, 0xbec00000, 0xcce00000, 0x18700000,
    0x2d580000, 0x13d40000, 0x228a0000, 0x935f0000, 0x54d58000, 0xeb0b4000,
    0x201be000, 0x1d729000, 0x31df6800, 0xa4110400, 0x68e82e00, 0x7de8bb00,
    0x596d3180, 0x4aaba3c0, 0x46cb2620, 0x6b7b6f10, 0xf9461798, 0x10a0ccdc,
    0x045531b2, 0xa6cfa3eb, 0x5b792612, 0xd1406f16, 0x8ca197b7, 0xe6508cc8,
    0x23c951ab, 0x07fd73f7, 0x06822e24, 0xb6c7bb3d, 0x40e0b18c, 0xc274e3ea,
    0x0c5ac635, 0x0956ff09, 0x364cff84, 0x36ba88ce, 0xba26ffad, 0x789588f5,
    0xff2b7fad, 0x278ac8f6, 0x8fda9f86, 0xe31758c4, 0x80000000, 0xc0000000,
    0x60000000, 0x90000000, 0x78000000, 0x84000000, 0x0a000000, 0xfd000000,
    0x40800000, 0x9c400000, 0xbee00000, 0xae900000, 0xbd480000, 0xcfb40000,
    0xaefe0000, 0xdf4f0000, 0x0eb68000, 0x007ec000, 0x240fa000, 0x75d51000,
    0xf62d0800, 0xb1e5f400, 0x57121a00, 0x0b8cfb00, 0x80176280, 0x860e8740,
    0xd4d03220, 0xc8a9df30, 0x32a75098, 0xa8775864, 0xf7df62be, 0xe8fa8751,
    0xe44e323a, 0xb536df2b, 0x47b9d096, 0x4d2d9862, 0xca66c293, 0x70d49745,
    0xf2abba05, 0x47a2eb3f, 0x84f2ea92, 0x9d9ab37e, 0x251b083f, 0xfd5ef436,
    0x29ba9a07, 0xea2d3b25, 0x6fe642b4, 0xb8115776, 0xa20c9a3d, 0x2ed63b08,
    0xddaec298, 0x8e209757, 0x80000000, 0xc0000000, 0x20000000, 0x10000000,
    0x38000000, 0xbc000000, 0x2a000000, 0xa1000000, 0x75800000, 0x14c00000,
    0x31a00000, 0xdeb00000, 0xba080000, 0x21540000, 0xd35e0000, 0x860d0000,
    0xcb528000, 0x525ec000, 0xe3886000, 0xe7921000, 0xdffe2800, 0x173a9c00,
    0xfc9fbe00, 0x8b280900, 0xd0a2cf80, 0x4b36e340, 0x9ecd7620, 0x38f74530,
    0x89efb988, 0xaa01a644, 0x6102cfae, 0x5586e35f, 0x04c57622, 0x09a3451c,
    0x62b1b99b, 0x900ca66e, 0x80504fa8, 0xa6d82340, 0x92cd1611, 0xfaf15511,
    0x8cef91a3, 0x59863a78, 0xc6c7f1b4, 0x0ca42a5c, 0x9131d99d, 0x37cab649,
    0xd9706786, 0x332fbf59, 0xaca0283b, 0x41379c03, 0x2fcd3e30, 0x7576c901,
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x18000000, 0xa4000000,
    0x32000000, 0x75000000, 0xbb800000, 0xc2c00000, 0xa2200000, 0xe8300000,
    0xfda80000, 0xd8540000, 0xa5fe0000, 0xbdab0000, 0xf8578000, 0xf5f9c000,
    0x15aba000, 0x4456d000, 0x63ff4800, 0x52afec00, 0x8ad36e00, 0x1abf8500,
    0x324ebb80, 0xc0c19240, 0x0f260620, 0x17b07930, 0xbd68bdb8, 0x1771eb6c,
    0x524ebba6, 0xb0c19259, 0xf7260614, 0x03b07901, 0x9768bd90, 0xc671eb75,
    0xdbcebb82, 0x0701927e, 0xee860605, 0x29407907, 0xc8e0bd91, 0xf615eb60,
    0x8398bb83, 0x62fe9275, 0xb32f8629, 0x6112b939, 0x251c9db7, 0x47bafb49,
    0xf5cc53a4, 0x7407ae62, 0x5a03a03d, 0x2902d01d, 0x80000000, 0x40000000,
    0x60000000, 0x70000000, 0xf8000000, 0x4c000000, 0xce000000, 0xad000000,
    0xed800000, 0x2f400000, 0xfe600000, 0xb6900000, 0x22980000, 0x829c0000,
    0xd29e0000, 0x3a9d0000, 0xfe9e8000, 0x84994000, 0xab9b2000, 0x251d5000,
    0x4ad83800, 0x767f5400, 0x11ce2e00, 0x7ba1dd00, 0x6d306980, 0x1fab7d40,
    0x753069a0, 0x63ab7d50, 0x233069b8, 0xf2ab7d4c, 0xf8b06986, 0x3ceb7d5f,
    0x255069b5, 0x083b7d74, 0x1428698e, 0x13777d7f, 0x1a4e69b1, 0x1de67d52,
    0x14d6e9b9, 0x217e3d72, 0x934d498d, 0xba672d7c, 0x8c90d1b2, 0x6d9c695d,
    0x7c1de798, 0x455fb054, 0x4a3b980a, 0x572a4409, 0x43f5b62e, 0x508b9907,
    0x78c5dfad, 0xde20e45c, 0x80000000, 0x40000000, 0xe0000000, 0x30000000,
    0xc8000000, 0x1c000000, 0xba000000, 0xff000000, 0x99800000, 0x1c400000,
    0xeca00000, 0x8b900000, 0xd8380000, 0x703c0000, 0x1c3e0000, 0x8e390000,
    0x5d388000, 0xb6bec000, 0x49fe2000, 0x86dbf000, 0xee0c0800, 0x4310c400,
    0xa4fc2600, 0x8c5d4300, 0xf9cc1f80, 0x60f45e40, 0x284c1fa0, 0x20b45e50,
    0x9eec1f98, 0x64245e5c, 0x17541faa, 0x14585e5b, 0x5dca1f84, 0xeef15e64,
    0x414a9fa2, 0x34339e63, 0xf82abf99, 0xb7416e41, 0x932637af, 0x32d36a5d,
    0x621a31a8, 0xb66cd97e, 0x28e2a63f, 0x23368313, 0xedacbf8d, 0x09046e62,
    0x6480b7ae, 0x4ec4aa6e, 0xff64918d, 0xf675e946, 0xc58e8e2f, 0x1c54b726,
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x48000000, 0xe4000000,
    0x9e000000, 0x8f000000, 0x52800000, 0x01400000, 0xada00000, 0x0c100000,
    0x15a80000, 0x2dac0000, 0x41aa0000, 0x9baf0000, 0x7aa88000, 0xef2ac000,
    0x58ede000, 0x6a091000, 0x44bd6800, 0x0f87fc00, 0x36c3f600, 0xf7609b00,
    0x2175fb80, 0xd5dad6c0, 0x6df5fba0, 0x9b9ad6f0, 0x32d5fb88, 0x66cad6cc,
    0xc2ddfb9a, 0xa376d6f5, 0x08dffbbd, 0x9a75d6d6, 0x615d7ba9, 0xefb016d6,
    0xeeb81b82, 0x6683c6d5, 0xe7409387, 0x2ea12ade, 0xd4940d97, 0x4de94df8,
    0xb98a8009, 0x8079c003, 0xade7603f, 0xa430d029, 0xb67a0806, 0x56e72c16,
    0x70b1fe19, 0x643bb712, 0x9bc605b6, 0x88e261c4, 0x80000000, 0xc0000000,
    0xa0000000, 0x10000000, 0xe8000000, 0xb4000000, 0xb6000000, 0x31000000,
    0x5e800000, 0x73400000, 0x36e00000, 0x50300000, 0xf4d80000, 0xb0dc0000,
    0x9eda0000, 0x43df0000, 0xe75f8000, 0x4f18c000, 0x147d6000, 0xee88d000,
    0x30715800, 0xcbbfac00, 0xb42e3600, 0xd5248100, 0xb8978080, 0x6e89e640,
    0xf07780a0, 0x6bb9e670, 0xa42f8088, 0x3d25e674, 0x0c9580b2, 0xd88ae659,
    0xc172009f, 0x353e2655, 0xd76d6088, 0x0bc5f649, 0x5ca1b885, 0x2c519a5d,
    0x71af6eb8, 0xabe60b71, 0x94b1561f, 0xec9f5121, 0x13bb5886, 0x382d8a42,
    0x9f21568b, 0x9b92774d, 0x5f0bb815, 0x58b3bc16, 0xc6980e0f, 0x80bcfd32,
    0xf1af6eb3, 0x6be60b7d, 0x80000000, 0x40000000, 0x60000000, 0xd0000000,
    0x58000000, 0xf4000000, 0x52000000, 0xe7000000, 0xba800000, 0xadc00000,
    0x31600000, 0x39300000, 0xa8880000, 0xaa8c0000, 0x558e0000, 0x7b0d0000,
    0x54cb8000, 0xdaa94000, 0xad1ee000, 0xfa547000, 0x86bf4800, 0x50849c00,
    0x2ec4f200, 0xe1e2f900, 0x57f47080, 0x296ad4c0, 0x2d7c70a0, 0x24e6d4d0,
    0xa27270b8, 0x222bd4e4, 0x9fd9f0ae, 0x35b294d9, 0xc84f10ba, 0x826ae4e0,
    0xa1fe5894, 0x042378cb, 0xea912a98, 0x0658c1c5, 0xb8f3ba32, 0x7fea652f,
    0x46be8287, 0x70852de1, 0x9ec3802a, 0x69e54033, 0xfbf0e02f, 0x8f697014,
    0x987cc814, 0x7961dc30, 0xb5341233, 0xbe8b8927, 0x9788b890, 0xa40b08f1,
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x28000000, 0xcc000000,
    0x86000000, 0x35000000, 0xf1800000, 0x17c00000, 0xf2e00000, 0x0f700000,
    0xb0a80000, 0x26ac0000, 0xabaa0000, 0xee2d0000, 0x2be88000, 0x8e09c000,
    0x0fffa000, 0xea139000, 0xed1e3800, 0x5d63b400, 0xe9b60a00, 0xa9cd1d00,
    0x151aa680, 0xc96383c0, 0x6bb2a6a0, 0x66cf83f0, 0x7f98a698, 0xd62283dc,
    0xf9102692, 0xb99b43ef, 0xc32786b3, 0x5894d3e2, 0x365bbe8f, 0xd5c667e7,
    0x1de734b3, 0x35f3bae4, 0x37e8b21f, 0x500b692d, 0x3ef90c95, 0xe1900ee6,
    0x61deb807, 0xa7067419, 0x8683aa16, 0xc9438d0c, 0x3fa41ebe, 0xcad5f7c9,
    0xe1790cb3, 0xcf500ee8, 0x04beb82f, 0x3ab6743d, 0x80000000, 0xc0000000,
    0xe0000000, 0x50000000, 0x28000000, 0xe4000000, 0x5a000000, 0xeb000000,
    0x44800000, 0xc6400000, 0x85a00000, 0x67d00000, 0x30a80000, 0x2eac0000,
    0xefaa0000, 0xd82d0000, 0xc6ef8000, 0x130ec000, 0xa479e000, 0x06833000,
    0x71406800, 0xb7244c00, 0xa4957e00, 0x688bd300, 0xc4bdad80, 0x826508c0,
    0x39b5ada0, 0xbf1908f0, 0x74b7ad98, 0x169808e4, 0x6b722d92, 0x14fbc8dd,
    0x92c44d84, 0x4be638e7, 0xb675c595, 0x757d44d6, 0x3902d3b4, 0x3b83dbcf,
    0x40c78038, 0x34e2c004, 0x30f3e023, 0xc43e3002, 0x6e27e82a, 0xcf168c12,
    0x004e9e09, 0x1459e32a, 0xe8904583, 0x168e84fd, 0x95bcb39b, 0x7de22be6,
    0x93740833, 0x18f8bc0b, 0x80000000, 0xc0000000, 0xa0000000, 0x30000000,
    0xc8000000, 0xdc000000, 0xce000000, 0xb1000000, 0x28800000, 0xd7400000,
    0x8fe00000, 0x08f00000, 0xef380000, 0x853c0000, 0x2e3a0000, 0x05bf0000,
    0xb57e8000, 0xbc58c000, 0x188e2000, 0x69e05000, 0x35f1d800, 0x51be9c00,
    0xc7792600, 0x535ad900, 0x7909de80, 0x8221c740, 0x7f51dea0, 0xa9adc770,
    0xb933de88, 0xc69ec77c, 0x8aaf5eba, 0x2eb5074b, 0x285dfe89, 0xca8e9767,
    0xb6e68683, 0x9c779b52, 0x667ed8a0, 0x43db4e50, 0x1a49d81b, 0x2fc29c31,
    0xc0a32630, 0x0315d900, 0x0dcf5eb5, 0x01050763, 0x2085fea1, 0xab42977e,
    0x71e486b7, 0x71f49b4a, 0x1bba58be, 0x9c7c8e5c, 0x10d97830, 0x25ca0c12,
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xa8000000, 0xa4000000,
    0x86000000, 0x83000000, 0x7e800000, 0x6bc00000, 0x9ea00000, 0xc6d00000,
    0x6b280000, 0x512c0000, 0x682e0000, 0x6fad0000, 0x63ed8000, 0xe108c000,
    0x0d3de000, 0x2e21d000, 0xda11c800, 0xc5083c00, 0xcb3c6200, 0xcd221700,
    0xb4966180, 0x06ca98c0, 0xf19e61a0, 0x8df698d0, 0x5cb861b8, 0x296798d4,
    0xf273e192, 0x7cfe58fd, 0xf98581b3, 0xa34648dd, 0xae6229ac, 0x3af664c7,
    0x4c39e38b, 0x05a45ff6, 0x84544811, 0xfaecfc22, 0xd68f822b, 0xd97ec729,
    0xb0c229ab, 0xbc2664d5, 0x4711e3a2, 0x44885fe7, 0x447a482d, 0x3141fc32,
    0x3362020a, 0xbb760722, 0xc37fc9b9, 0xf9c7b4f6, 0x80000000, 0xc0000000,
    0x20000000, 0x10000000, 0xa8000000, 0x1c000000, 0x9a000000, 0xdd000000,
    0x80800000, 0xa5c00000, 0x08e00000, 0xb8500000, 0x4d880000, 0xb88c0000,
    0xe40a0000, 0xfbcb0000, 0x3e2b8000, 0xaefec000, 0x5ab62000, 0x70def000,
    0xf1821800, 0xc7451c00, 0xe427b200, 0xa6333500, 0xbf1bd780, 0xbc64cbc0,
    0x5b91d7a0, 0x226fcbf0, 0x4d5a57a8, 0x24c10bf4, 0xf2647782, 0xf093fbf3,
    0x7dec6fa4, 0x111de7c4, 0x27605d84, 0xbc1012ed, 0xca2daa06, 0xc8fa2903,
    0x2db665b5, 0x955cfedd, 0x60c18024, 0xec65c017, 0x1395a029, 0x0e6c300f,
    0x6f5e383b, 0x4dc0ec27, 0xf4e62a2b, 0x1254e90f, 0x28884596, 0x8c0e0ed6,
    0xc7c99828, 0xb42bdc20, 0x80000000, 0xc0000000, 0xa0000000, 0x30000000,
    0x18000000, 0x5c000000, 0x5a000000, 0x6b000000, 0x95800000, 0xb8c00000,
    0x7ea00000, 0x00300000, 0x62e80000, 0xd5ec0000, 0xda6a0000, 0xa9af0000,
    0x728e8000, 0xd27e4000, 0x9234a000, 0x1dea7000, 0xce6b2800, 0x27ac8400,
    0x378dc200, 0x32ff7700, 0xd2755680, 0x7f0a71c0, 0xf6bf56a0, 0x169571f0,
    0x46d9d688, 0x210731fc, 0x1687768e, 0xc94241eb, 0xf062de98, 0x579085f1,
    0xc05bbcbd, 0xc04582df, 0xa2e5c222, 0x98d3771f, 0x013f569a, 0x695571da,
    0x4ff9d6a4, 0x9ef731cc, 0xdd4f7696, 0x935e41e3, 0xf9c0dea2, 0xf82385e9,
    0xe1773ca2, 0xd688c2d4, 0x847de215, 0x2b344736, 0x976c5e86, 0xfd2ec5ec,
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x18000000, 0x94000000,
    0xda000000, 0x25000000, 0x79800000, 0xf5c00000, 0x98a00000, 0x69b00000,
    0x78e80000, 0xf1ec0000, 0x966e0000, 0x24ab0000, 0x648b8000, 0x437b4000,
    0xe7f7e000, 0x448d3000, 0x137a1800, 0x5ff6d400, 0xc088fa00, 0xd17a7f00,
    0xeef25280, 0x630a65c0, 0x01bc52a0, 0x0fd165d0, 0xff7fd288, 0xe1f625d4,
    0x978e328e, 0x11fc15f1, 0x34b1aab8, 0x656a81f8, 0x762d30a6, 0xb7ca8ec5,
    0x629c9a00, 0x82a00f1f, 0xacb1aabe, 0xb16a81f3, 0x0c2d3093, 0x82ca8eee,
    0x031c9a24, 0xe3600f1f, 0xee11aa8d, 0xfdda81f2, 0x0d4530a9, 0x86e68ec5,
    0x0dd29a0f, 0xae7b0f37, 0xf2722a9c, 0x4f4dc1f5, 0x80000000, 0x40000000,
    0xa0000000, 0x50000000, 0xf8000000, 0x1c000000, 0x0a000000, 0xc1000000,
    0xc6800000, 0xd8c00000, 0xbae00000, 0xd6b00000, 0xe8880000, 0xfd8c0000,
    0x650e0000, 0x62cb0000, 0x61a98000, 0x865e4000, 0x1d76a000, 0x59eaf000,
    0x677af800, 0x62a3cc00, 0xc7968a00, 0x3f5c1d00, 0x87f48880, 0x2b2ffcc0,
    0x4c9a88a0, 0x8a94fcd0, 0xebdb0888, 0x7236bcc4, 0xf54ba8b6, 0x67eb4cc3,
    0x087ed0b4, 0xd321c0f3, 0x42d17a85, 0xa2fe6dc5, 0xe9e62a2b, 0x7d31ed30,
    0xf4c9f0b1, 0xeaa970df, 0x21db22a0, 0x533051c3, 0xc3cdd82e, 0x172b7c31,
    0x569cd235, 0x13922100, 0x615f7ab7, 0x58f56dca, 0x92afaa07, 0x7ddfad11,
    0xf93750b8, 0x52cf80e5, 0x80000000, 0x40000000, 0x20000000, 0x10000000,
    0x88000000, 0xec000000, 0xc2000000, 0xe9000000, 0xc2800000, 0x95400000,
    0x7ea00000, 0x65f00000, 0x0f180000, 0xa41c0000, 0xcf9e0000, 0xb85f0000,
    0x43bf8000, 0xd0ebc000, 0x5604a000, 0x3f06b000, 0xbd83f800, 0x08c4ec00,
    0x6660c600, 0x8b977300, 0x688b3c80, 0x0e915440, 0x280d3ca0, 0x52d25450,
    0x842cbca8, 0x2a669454, 0x19979c8a, 0x298be46f, 0x3010c4ba, 0xf749b855,
    0x2973fa8a, 0xe15a2770, 0x59380015, 0x01ac0029, 0x16a60036, 0xf9f30010,
    0x7519800d, 0x3918c03a, 0xab1d203f, 0xea1e7035, 0xd49ed81a, 0x0bda9c00,
    0x707e1e05, 0x150def27, 0x66552283, 0x7e6cbb5c, 0x41401e3a, 0x88a2ef26,
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x38000000, 0xa4000000,
    0xd6000000, 0x35000000, 0x37800000, 0x1f400000, 0xbd200000, 0x78100000,
    0xeef80000, 0xf5fc0000, 0x337e0000, 0x5dbf0000, 0x42da8000, 0x2c6b4000,
    0xd7c66000, 0x92e4d000, 0x2ef77800, 0x860fc400, 0xcef6be00, 0x560c9700,
    0x66f57780, 0x7a0e3040, 0x2cf377a0, 0x3d0d3050, 0xf877f7a8, 0x20c9707c,
    0x6d9317a6, 0xfabae055, 0x465c0f93, 0x99aef458, 0x6e27499e, 0x0296e75f,
    0x423ae031, 0x319c9001, 0xfb4d982a, 0x58d3542c, 0x909b262e, 0x62cfc317,
    0xf69651b0, 0x7c3df375, 0x089b2610, 0x36cfc30c, 0x389651be, 0x5d3df356,
    0xd11b2604, 0xb88fc308, 0x643651b5, 0x0f6df373, 0x80000000, 0xc0000000,
    0x60000000, 0x30000000, 0xf8000000, 0x74000000, 0xea000000, 0x03000000,
    0xb6800000, 0xf2c00000, 0x8e600000, 0x84b00000, 0xb8c80000, 0x19cc0000,
    0xe04a0000, 0x5a090000, 0xffa88000, 0xb8ff4000, 0xb4c4e000, 0x8367b000,
    0x7331a800, 0x438f1c00, 0xb5ed0a00, 0x8558b900, 0xb7943c80, 0x9d5b2ac0,
    0x33963ca0, 0xef5e2af0, 0x7494bcb8, 0x4bd86afc, 0xf150dc86, 0x993c9ae1,
    0x842794bc, 0x191136e1, 0xeb99b691, 0xcff0d3dd, 0x2cece032, 0x68dbb03c,
    0xd7d3a83c, 0xc3fa1c0a, 0xb6478a1c, 0xfba2f910, 0xce525c9d, 0x89badae3,
    0x8be3f4aa, 0xf8f5c6f3, 0xd06efe83, 0xc91d7fd3, 0x2732c233, 0x398a550e,
    0x1eeefeaa, 0x8fdd7fdf, 0x80000000, 0x40000000, 0x20000000, 0xd0000000,
    0xb8000000, 0x0c000000, 0x02000000, 0xa7000000, 0xed800000, 0x9fc00000,
    0xe2600000, 0xf0100000, 0x60480000, 0x694c0000, 0xb1ce0000, 0xfc8f0000,
    0xb0a98000, 0x871c4000, 0x5e242000, 0x48b03000, 0xc8bf0800, 0xe3556400,
    0x71691a00, 0x387cc900, 0xc8b6a980, 0x88bbfbc0, 0xc350a9a0, 0xa168fbd0,
    0x807f29a8, 0xc4b7bbe4, 0x8abc8986, 0x6454cbe7, 0x4cee2186, 0x1fbddfce,
    0x26d413bd, 0x7aa842e9, 0x041aa805, 0x25a51415, 0xae74323d, 0xda5a9d1f,
    0xca073b99, 0x830116d4, 0x7b82ba3b, 0xe6c3b926, 0x12e20184, 0x2951eff9,
    0xf26d1b8b, 0x43fe26c1, 0x2e743209, 0x9a5a9d2d, 0xea073b96, 0x530116c8,
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x28000000, 0xbc000000,
    0x82000000, 0x7b000000, 0x89800000, 0xc3c00000, 0x0be00000, 0x07700000,
    0xed380000, 0xf83c0000, 0x70be0000, 0x45fb0000, 0x225a8000, 0x800bc000,
    0xad262000, 0x0c163000, 0x530fe800, 0xd8a2a400, 0xedd33a00, 0x13ed2500,
    0x7e507e80, 0x7f2dc740, 0x62367ea0, 0x729ac750, 0x5e6afe88, 0x7b96075c,
    0x89c85e82, 0xb1c0f773, 0xb8e316a2, 0xa2f3a36d, 0xb4ffe480, 0x1cdd125d,
    0xc04fc802, 0x9203941c, 0x23005219, 0xbd834132, 0xcdc1e4ad, 0xdae6126f,
    0x49f5480f, 0x25785430, 0x4b1e720c, 0xf5a97131, 0x6c700c98, 0x3cbfb654,
    0x0ffcf22b, 0x755eb130, 0x93882c85, 0x81e28663, 0x80000000, 0xc0000000,
    0x20000000, 0xf0000000, 0x68000000, 0x84000000, 0xba000000, 0xed000000,
    0xe9800000, 0x6bc00000, 0x58200000, 0xfad00000, 0x7e180000, 0x379c0000,
    0x6c5a0000, 0x7c7b0000, 0xf2ac8000, 0x5eb7c000, 0x002fe000, 0x3ff03000,
    0xc54c5800, 0x86479400, 0x49e30a00, 0x6ff62b00, 0x9d4dcd80, 0x4a406540,
    0x87e14da0, 0x50f7a570, 0x1dceada8, 0x7207954c, 0x5902f5b2, 0x1b80016d,
    0xf2c1ff9c, 0x63a62a56, 0xf8143226, 0x75ba4f0c, 0x4b8f7f90, 0xa3e6ea42,
    0xdaf55227, 0xb8cabf03, 0xef82478e, 0xe0c18e71, 0x2aa3602e, 0x5b97f030,
    0x9b7bb808, 0x7e2ba433, 0x88f55229, 0x11cabf10, 0x9c0247bc, 0x96018e78,
    0xf303603d, 0x4e87f017, 0x80000000, 0xc0000000, 0xa0000000, 0x10000000,
    0x98000000, 0x1c000000, 0xca000000, 0xe7000000, 0x4d800000, 0xb8400000,
    0xaca00000, 0xd0f00000, 0x40180000, 0xfd9c0000, 0xadda0000, 0x357f0000,
    0xbb8f8000, 0x52934000, 0xd38fa000, 0xa693f000, 0x2d8bc800, 0x1f962400,
    0xc908a600, 0xdb566300, 0xbd6d1480, 0xb5c5dc40, 0x74e294a0, 0xcc569c70,
    0x18ed3488, 0x39856c74, 0x8646fcae, 0xb5a34873, 0x24765a9c, 0x1cd92b4a,
    0x95f94e0f, 0x094ff724, 0x1bf65a84, 0x8f992b60, 0x86d94e1c, 0x8afff72b,
    0xe8ce5a99, 0xe1b52b55, 0x403b4e2b, 0xcdacf70b, 0x5fa3da90, 0x13756b46,
    0x69596e3f, 0x21bf4711, 0xf7ea32b9, 0x3000ff48, 0x48002009, 0x2400b007,
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x78000000, 0xc4000000,
    0x5a000000, 0xa3000000, 0xd8800000, 0xbf400000, 0xfde00000, 0x0c900000,
    0x50e80000, 0x146c0000, 0xe52e0000, 0x39cb0000, 0x1adf8000, 0x0ff44000,
    0x3e3e6000, 0xa8e2b000, 0xd114a800, 0xaa29ec00, 0xe74a5600, 0xa89ed900,
    0x3b948d80, 0x4a6f62c0, 0xfc2b0da0, 0x724b22d0, 0x951d6d88, 0xf15592f4,
    0x514fc596, 0x0d9b7ec5, 0xee141380, 0x3caae7ed, 0x79097e36, 0x7aff7502,
    0x72c6bba9, 0x3f240bd1, 0x9bb2a835, 0xd75eec20, 0xcd33d61a, 0xa91d992b,
    0x2f536dbc, 0x084e92d5, 0xe61845ad, 0xf1d33ed9, 0xba0c73ae, 0xd27f57d3,
    0x85845614, 0xeec5d921, 0x71230dbe, 0xbab722c3, 0x80000000, 0xc0000000,
    0xe0000000, 0x90000000, 0x98000000, 0xa4000000, 0x3e000000, 0x59000000,
    0x2e800000, 0x9bc00000, 0x0d200000, 0x2e900000, 0x89c80000, 0x394c0000,
    0x4b8a0000, 0x802d0000, 0x99798000, 0x1f954000, 0xcb4c6000, 0x408f9000,
    0x15ac5800, 0x7f3eac00, 0x58f23200, 0xa0bfbb00, 0x61b01f80, 0x445a69c0,
    0x89019fa0, 0x968329f0, 0x4fc7ff98, 0x3b21b9d4, 0x4b9227be, 0x3d4a55fd,
    0xc58c75b1, 0x312a7eeb, 0x1bf8323a, 0x8652bb0d, 0x05699f99, 0x279f29f6,
    0x7025ffa3, 0xfe10b9ec, 0xab09a7af, 0x8aee15c1, 0x66db95a0, 0xa0c1aef9,
    0xb0a38a16, 0x84d7c719, 0x5ca815bb, 0x09b9eedb, 0x87366a14, 0x039d1722,
    0x8e202d82, 0x4714d2e0, 0x80000000, 0x40000000, 0xa0000000, 0x10000000,
    0x58000000, 0xb4000000, 0xfe000000, 0x55000000, 0xc2800000, 0x6dc00000,
    0x67a00000, 0x1dd00000, 0xf8e80000, 0xf46c0000, 0xc4ae0000, 0x2d8b0000,
    0x079b8000, 0x6bd14000, 0xa1e8e000, 0xcce91000, 0x4a6cb800, 0x31af2c00,
    0xff0e0200, 0x325a5f00, 0xb870e180, 0x423e7ec0, 0x610361a0, 0x7c833ed0,
    0x98c58188, 0xb5212ed4, 0x2812b99e, 0x2b4f42f9, 0x17bc5ba1, 0x69400dec,
    0x1b660211, 0xaef65f37, 0x21fee1a8, 0xbba57ee0, 0x5fd0e19e, 0x1fee7ec9,
    0x39eb6191, 0x98ef3eeb, 0x046b81b9, 0x2caa2ec9, 0xd189399e, 0x159e02f4,
    0x74d4bba5, 0xc8691de4, 0x36aaba3d, 0x82897312, 0x2618e3bc, 0x7d9321e4,
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x68000000, 0xa4000000,
    0x02000000, 0xcf000000, 0xd9800000, 0x92400000, 0x26e00000, 0x6bd00000,
    0x55880000, 0x360c0000, 0xf74a0000, 0x56290000, 0x5ebe8000, 0xf555c000,
    0x8a4ce000, 0x88aef000, 0x217d8800, 0xdbf7c400, 0xc47b9600, 0xc976c100,
    0x1db9af80, 0x2ad3ebc0, 0x450f2fa0, 0x20ca2bf0, 0xcd69cfb8, 0x9cdddbcc,
    0x7242c7a2, 0x16e3dfe5, 0x63d7b1a2, 0x018eeed6, 0x5c0f1614, 0x9c4a0132,
    0x8dabcfbd, 0x03f8dbd8, 0x0a364790, 0x73df1fd9, 0xfbc5d1af, 0x7ca5ded9,
    0x79367e22, 0xa45f353e, 0x6087d196, 0xbec0defb, 0xfe22fe19, 0x38f3f53f,
    0x8bfdb196, 0x9e37eeff, 0x79d9961b, 0x60c3c13b, 0x80000000, 0xc0000000,
    0x60000000, 0x30000000, 0x68000000, 0xc4000000, 0x2a000000, 0x1f000000,
    0x62800000, 0xc7c00000, 0xb0600000, 0xb8f00000, 0xdee80000, 0x126c0000,
    0x40aa0000, 0xdd490000, 0x98f88000, 0x9db3c000, 0x6949e000, 0x7afab000,
    0x16b74800, 0x79cadc00, 0x0e3c2200, 0x2a51c100, 0x33fdf680, 0x1d3269c0,
    0x258d76a0, 0xda1da9f0, 0xda8696b8, 0x9bc219fc, 0x56635ea2, 0x79f205cd,
    0xe16e1ca8, 0x6c2ab4ca, 0x7f8d4230, 0x0d18b13b, 0x2c035ebc, 0x2e0205e5,
    0x55061cb3, 0x4d86b4dd, 0xcd474221, 0xb3a1b117, 0x2293deb7, 0x791dc5f6,
    0xae05fc87, 0x950504e2, 0x2d808a34, 0xfd44ad1e, 0xdba41c9c, 0xe693b4f8,
    0x531dc21d, 0xb1077106, 0x80000000, 0xc0000000, 0x20000000, 0x30000000,
    0x38000000, 0xac000000, 0x12000000, 0x8d000000, 0x42800000, 0x90c00000,
    0x84600000, 0x05d00000, 0x1de80000, 0x596c0000, 0x3aaa0000, 0x434b0000,
    0x29da8000, 0x5a134000, 0xbe0a2000, 0x0af8b000, 0x85e3d800, 0x90954c00,
    0x7acf8a00, 0x109a0900, 0x2f305780, 0x7af880c0, 0x5de2d7a0, 0x2c97c0f0,
    0x60caf7a8, 0x099870fc, 0xd3b1afa6, 0x75397cd7, 0x160485a2, 0xfb0385f4,
    0x6987aa32, 0xd145b910, 0xf1230fb3, 0x72f58ce1, 0x5c1dfd9c, 0xd8f639cb,
    0xbd1b5814, 0xa8710c3c, 0x90dd2a34, 0x5696f912, 0xa9c92f87, 0xdd1d3cdb,
    0x787625b9, 0xb8df75c1, 0xf296d20d, 0x2fcc053d, 0xee1dfdb1, 0xa5f639da,
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x78000000, 0xcc000000,
    0x2e000000, 0xd5000000, 0xbe800000, 0xd4c00000, 0x57600000, 0x8d500000,
    0x6ad80000, 0x1e5c0000, 0xa59a0000, 0x8b7d0000, 0xff6d8000, 0xc9964000,
    0x85bc2000, 0xbf0f5000, 0xf140f800, 0x38268c00, 0x28756a00, 0xb82d7100,
    0xf8b28b80, 0x454fc540, 0xcae70ba0, 0xce158570, 0xf1f92b98, 0x61abd574,
    0x31f65386, 0x916a1947, 0x3c90998d, 0xcb3f7872, 0x03c94a22, 0x12222107,
    0x57727397, 0xb9a94954, 0xcdf26195, 0x3768f467, 0x4d93a01a, 0xefb81032,
    0xe00b5810, 0x00c29c36, 0x6564322d, 0xee52ed1d, 0xdd5b39b5, 0x221b6876,
    0x3f38121b, 0xc1cdbd39, 0x1923c1a1, 0x54f1e44c, 0x80000000, 0xc0000000,
    0xa0000000, 0x90000000, 0xc8000000, 0x8c000000, 0x86000000, 0x8d000000,
    0x11800000, 0x66400000, 0xb1e00000, 0x16d00000, 0x33680000, 0x63ec0000,
    0xf22a0000, 0x988f0000, 0x763b8000, 0x71c5c000, 0x9aa5a000, 0x16b79000,
    0xd3fef800, 0x2966f400, 0x0b118600, 0xdfcb6900, 0x005a6f80, 0xe4535cc0,
    0x15abefa0, 0x4bc99cf0, 0xa25dcf88, 0x5357ccd4, 0x572c97ba, 0xf509a8f7,
    0x6e78699b, 0x9921f5d4, 0x5ff6201f, 0xc49e500d, 0x1b715813, 0x375e6438,
    0x66d4fe37, 0x0b685d04, 0x17ee49b9, 0xa02fa5c1, 0xd78f7825, 0xe0bc340e,
    0x0d07a60f, 0xd1853906, 0xc643378d, 0x21e138ce, 0xded511b0, 0xbf6ec1d1,
    0xe5e80601, 0x7f2da910, 0x80000000, 0xc0000000, 0x60000000, 0xb0000000,
    0x78000000, 0x84000000, 0x36000000, 0xb5000000, 0x2e800000, 0x15c00000,
    0xdc200000, 0xdb700000, 0x2a480000, 0x05cc0000, 0xb08a0000, 0x28690000,
    0x87bc8000, 0xae474000, 0xf7676000, 0xba90d000, 0x611e7800, 0x3ef68c00,
    0x980fe200, 0x30ac2300, 0x911bc880, 0xe6f272c0, 0xcc0d48a0, 0xceac32f0,
    0xd81ea8b8, 0x7a77a2dc, 0x5acdb0a6, 0x8908fefd, 0x3828aaab, 0x99d911d0,
    0x5851e020, 0xc8be9015, 0x3fc59837, 0xab211c13, 0x6ef6fa25, 0x900a7f3e,
    0xacaa5297, 0x9318ddd5, 0x1df1621b, 0xd38e6323, 0xc3ea2895, 0xa4fce2d4,
    0x53a0d09c, 0xbe312ed0, 0x7aaa52bb, 0x5618ddfd, 0x2b71622b, 0xf24e6307,
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xc8000000, 0xfc000000,
    0xde000000, 0x89000000, 0xa0800000, 0xccc00000, 0x58200000, 0x60b00000,
    0xe3380000, 0x1ebc0000, 0x00fa0000, 0x9b1f0000, 0x8e0e8000, 0x8bc0c000,
    0x49a32000, 0x98f3d000, 0x65da9800, 0xb92a1c00, 0x56f43a00, 0xd4d81b00,
    0x8dae6e80, 0x88307f40, 0x13faeea0, 0x389fbf70, 0xd94f4e88, 0x10a0af7c,
    0xa074f6ba, 0x0d1a6343, 0x3b0ed48d, 0x5547a461, 0x3c612025, 0xa850d012,
    0x35ae1813, 0xdc35dc3a, 0xa1f99a03, 0x979b0b31, 0xc4cfd6b1, 0x5ee5b368,
    0x63964c85, 0x1c0eb858, 0xd4c19a17, 0x3c270b01, 0x1ab5d68a, 0xb03ab378,
    0xdd38cc98, 0xc7be7854, 0xf87aba09, 0x53d8db10, 0x80000000, 0xc0000000,
    0x20000000, 0x10000000, 0x28000000, 0xe4000000, 0xc6000000, 0x3b000000,
    0xcd800000, 0xbd400000, 0xab600000, 0xf7100000, 0x73780000, 0xe3fc0000,
    0x783a0000, 0xab9b0000, 0xbeab8000, 0x7fa2c000, 0xc731e000, 0x2409d000,
    0x92150800, 0x99f9e400, 0xb93e4e00, 0x671bb500, 0xef6afd80, 0x95065e40,
    0xf2837da0, 0x86c39e70, 0x15231da8, 0x5df38e74, 0x1b2c75a2, 0xc6e17a4d,
    0x9a56d393, 0xd01afb43, 0xe0ef6820, 0xe542f42c, 0x9762a62a, 0xcd178121,
    0x527bbbbe, 0x1f7f0f5d, 0x11fc4e0a, 0x8d3cb53e, 0xa91b7dbc, 0x206f9e5b,
    0xb6811d9c, 0x90c48e70, 0x2625f5a1, 0x6474ba58, 0x486eb39b, 0xb286eb61,
    0x66c20016, 0x25270032, 0x80000000, 0xc0000000, 0xa0000000, 0xb0000000,
    0x58000000, 0x54000000, 0x32000000, 0x93000000, 0x77800000, 0x71c00000,
    0x58a00000, 0x3b900000, 0xe0380000, 0x06bc0000, 0x0bfa0000, 0xa11f0000,
    0x31ea8000, 0x79e04000, 0x8776e000, 0x29c97000, 0x4e34e800, 0x9928d400,
    0xe1c69a00, 0x70a47f00, 0x97907380, 0x363b0a40, 0xffb8f3a0, 0xbb784a70,
    0x955e9388, 0x8b8e7a5c, 0x6d561b9e, 0x2d1f9e49, 0x97ea8992, 0x78e6456d,
    0xd3f2880f, 0x778ee431, 0x33561239, 0xc8199b0f, 0xa96ee1a9, 0xe1a1d162,
    0xeb10721d, 0xc47fab2f, 0x54de6995, 0x134c3549, 0x6d76e037, 0x2ec97016,
    0xabb4e820, 0xcbe8d413, 0x96e69a0f, 0x6ef47f0f, 0x1d0873b9, 0x98170a49,
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x28000000, 0xd4000000,
    0xb6000000, 0xcd000000, 0xaa800000, 0x0fc00000, 0x5a600000, 0x61d00000,
    0xdef80000, 0x977c0000, 0xa33a0000, 0xae190000, 0x396e8000, 0x47a7c000,
    0xa8b56000, 0x6caed000, 0xaac7b800, 0x84e76c00, 0x48135200, 0x919ba100,
    0xa02fdf80, 0x1006a040, 0x18035fa0, 0x9c046070, 0x9202bfb8, 0x5304704c,
    0xb386e7b2, 0x13460c79, 0x98a56d9f, 0x9131114a, 0xb0ead835, 0x13e5bc09,
    0x5596ea03, 0xd3d9cd21, 0x00080dac, 0xddf3c178, 0x410f602e, 0xfd77d016,
    0x81c93835, 0x8690ac38, 0xa05e3227, 0x73497129, 0xb55267bc, 0xf838cc56,
    0x999e8dbe, 0x24280157, 0x1e00001a, 0xd900001f, 0x80000000, 0x40000000,
    0xe0000000, 0xf0000000, 0x58000000, 0x54000000, 0xc6000000, 0x4f000000,
    0x1f800000, 0x94400000, 0xfae00000, 0xe2d00000, 0xa4b80000, 0xe63c0000,
    0xa4fe0000, 0x7ad90000, 0x192e8000, 0x69e44000, 0x6752e000, 0xa5fed000,
    0x765fa800, 0x48ead400, 0x7243b600, 0xe5e54100, 0xb554a780, 0xccfe5a40,
    0xd6dc27a0, 0x9b2f1a50, 0x48e64798, 0x3bd08a6c, 0xbc3b8f8e, 0x91f9ce79,
    0x005bf1bf, 0xbfeccb6a, 0xc9c1a838, 0xefa3d40f, 0x54b53626, 0xf7ad0127,
    0xa92047b7, 0x98758a62, 0x9a8b0fa8, 0x1f548e79, 0xa1ff91a7, 0xf85a5b4c,
    0xfbeae02f, 0xa7c2d015, 0xaca1a81d, 0xd933d43c, 0xeaed3617, 0x03410125,
    0xf16647bb, 0x50908a65, 0x80000000, 0xc0000000, 0x60000000, 0x10000000,
    0x48000000, 0x54000000, 0x5a000000, 0xaf000000, 0xe2800000, 0x6cc00000,
    0xe7e00000, 0xa5900000, 0xd9780000, 0xcafc0000, 0x59ba0000, 0xbb190000,
    0x75298000, 0x31e3c000, 0x8c956000, 0xfaf9b000, 0xa1bbc800, 0xd71a5c00,
    0x23287a00, 0xd8e56500, 0xcf14d980, 0x81bbca40, 0x671f59a0, 0x1b2d0a70,
    0xd4e1b9b8, 0x89127a74, 0x20bc91aa, 0x709b5661, 0x3a6bc3bc, 0xbd421f4a,
    0xa7a3c804, 0xbbb65c11, 0xc68a7a1d, 0x70506508, 0x951f59b3, 0x302d0a7e,
    0x4461b997, 0x0ed27a75, 0x37dc9184, 0x42cb5656, 0xbc73c38d, 0x11ee1f66,
    0x2201c80a, 0x03035c11, 0xd481fa2c, 0x95c6a53e, 0xec61b9a8, 0x8ad27a5d,
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x78000000, 0x84000000,
    0xf2000000, 0x79000000, 0x7d800000, 0x6bc00000, 0x8ce00000, 0xce900000,
    0x83380000, 0xe1bc0000, 0xb4fe0000, 0xcb5d0000, 0x196a8000, 0x40e14000,
    0xe0916000, 0x1c3cf000, 0x9f383800, 0x27be5400, 0x27fdca00, 0xbbda0d00,
    0x85282980, 0x5ac3d840, 0x2d64a9a0, 0x43539850, 0x0cd949b8, 0xd7af286c,
    0x578491a6, 0x46c1cc4d, 0xeb62839a, 0xd0542553, 0x7c583805, 0x4bee5409,
    0x4da5ca06, 0x8b360d2a, 0xb40e29be, 0x43b2d86e, 0x8c4829ad, 0x3b93d86d,
    0xb0bca98f, 0xe57f985f, 0x3e9f49b6, 0x128e2863, 0x84f0118e, 0x7aed8c47,
    0xec2163b8, 0x06f5954b, 0x3bef6017, 0x75a1f01c, 0x80000000, 0x40000000,
    0x20000000, 0x90000000, 0xf8000000, 0x3c000000, 0x8e000000, 0x1d000000,
    0xac800000, 0x61c00000, 0x90e00000, 0xaf900000, 0x0ac80000, 0x314c0000,
    0x330e0000, 0x4daf0000, 0xca9b8000, 0xf6644000, 0x2151a000, 0x85afd000,
    0xde9a3800, 0x9c61dc00, 0x1e501200, 0x422bf500, 0x32d83980, 0x4fc7e7c0,
    0x5de5b9a0, 0xdb10a7d0, 0xc70999a8, 0xd7a837f4, 0xbd9f8196, 0x65e17bfb,
    0x87118bb5, 0xf90fc2fc, 0xa2a9b81e, 0xd5199c24, 0xb627b21a, 0x84f7251f,
    0xe71f8190, 0x65217bf7, 0x15718b82, 0xba5fc2fb, 0x6c01b81b, 0x16059c25,
    0x9101b226, 0x4a842503, 0xb8c2019e, 0x8e663bec, 0x5d55abae, 0x2bab52f7,
    0x5399a021, 0xc8e3d03f, 0x80000000, 0xc0000000, 0xe0000000, 0x10000000,
    0xb8000000, 0x74000000, 0xbe000000, 0x97000000, 0xa3800000, 0xb5c00000,
    0x50e00000, 0x65700000, 0x5cd80000, 0xaa5c0000, 0x691a0000, 0x3abd0000,
    0xec6d8000, 0x76604000, 0xfe37e000, 0x6b7c1000, 0x7a8ba800, 0x10103400,
    0xaf6b5a00, 0x5be0fd00, 0x94f6e680, 0x441a9840, 0xd83966a0, 0x412bd870,
    0xeac10698, 0xef668874, 0x42b2ceb6, 0x413bec69, 0xfdaa5c99, 0xc086754c,
    0x68442831, 0x92217421, 0x86133a05, 0x346dad08, 0xd2652eaa, 0x1837fc66,
    0x9879f4be, 0xdf0a4145, 0x46d57212, 0xe20c8939, 0x1c505c8b, 0x3b4b7563,
    0x3ef1a836, 0xbd1d342f, 0xb4beda14, 0x336cbd17, 0x09e30686, 0x39f7886d,
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x48000000, 0x74000000,
    0x9e000000, 0x5b000000, 0x3f800000, 0xe3400000, 0xa1a00000, 0x52300000,
    0xa6180000, 0xb55c0000, 0x1cfe0000, 0xdac90000, 0x92d28000, 0x348cc000,
    0x63f16000, 0xc47c9000, 0xac0cc800, 0xf531f400, 0xd39f8e00, 0x031a1300,
    0xe1da4a80, 0x683f8e40, 0x9c2b2aa0, 0xb7431e50, 0xefa7e298, 0xd132ea4c,
    0xd5986c8a, 0xf418f951, 0x0c5a262d, 0x727b7707, 0xb30f0c82, 0xfcb1696f,
    0x6fda6e32, 0x4b3f4337, 0x7fab6291, 0xce072a4b, 0xc3038cbb, 0x9384a97a,
    0x31418e1d, 0x58a31318, 0xdcb0cab7, 0xbfdf4e5e, 0x933c4aad, 0x33aa8e78,
    0x6c07aaba, 0x7206de4e, 0x69040295, 0xb682ba5d, 0x80000000, 0x40000000,
    0xa0000000, 0xb0000000, 0x68000000, 0x94000000, 0xb2000000, 0x49000000,
    0x4a800000, 0x77400000, 0xeea00000, 0xd0f00000, 0x10680000, 0xb72c0000,
    0x618e0000, 0x5d7b0000, 0xb3168000, 0x0339c000, 0x47336000, 0xdc8df000,
    0xf5f93800, 0xf552ac00, 0xeb1a7600, 0xae84f300, 0x4d414c80, 0x23a263c0,
    0xf0722ca0, 0xd22f93d0, 0x350b1488, 0x3d3d3ffc, 0xa0316292, 0xe909ccd9,
    0xeb382e3e, 0x9337af0b, 0xce8c028c, 0x0cff3cc6, 0xd7d7963f, 0x085cc30e,
    0xf22514a9, 0xd4b63ffa, 0x794fe28f, 0x301c0ce6, 0x5d054e2f, 0xb8815f20,
    0x9e43ba81, 0x142450d9, 0xcfb68035, 0x6ac9c00e, 0xd5db6028, 0x38e1f02f,
    0xa0d7382e, 0xa5d9ac32, 0x80000000, 0xc0000000, 0xa0000000, 0x70000000,
    0x28000000, 0xec000000, 0x6e000000, 0xff000000, 0x6f800000, 0x72c00000,
    0xfd600000, 0x0ed00000, 0x83680000, 0x89ac0000, 0x00ca0000, 0x041f0000,
    0x8a748000, 0xd559c000, 0xdbd4a000, 0x51e8d000, 0xa5eba800, 0x6fe91400,
    0xc2ea2200, 0x646b1900, 0x4229c780, 0x200d48c0, 0x307d67a0, 0xd02598f0,
    0xc976cf88, 0x4cdc8cec, 0x3214ed82, 0x310b95d7, 0x60ff2a19, 0x6d65dd28,
    0x36d4cda2, 0x976a85c4, 0x53a82215, 0x55c8192b, 0x169f47b7, 0x063788de,
    0xca7f47ae, 0x352788f7, 0x53f747ae, 0x5c9b88c6, 0x6b3547ad, 0xccf888c9,
    0x6363c79b, 0x19d248d0, 0xa0e9e7af, 0xe56c58f5, 0x2aaa6f82, 0x89485ce8,
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xd8000000, 0x2c000000,
    0xbe000000, 0x41000000, 0xa2800000, 0xd0c00000, 0x71600000, 0xed900000,
    0x76580000, 0x6a9c0000, 0xb5fe0000, 0x916f0000, 0xc1b48000, 0x31ee4000,
    0x26712000, 0x070bd000, 0x83a55800, 0xdbf20c00, 0x044baa00, 0x7884f100,
    0xcbc64580, 0x88e3bb40, 0xe4d765a0, 0x7e786b50, 0x572a3da8, 0xd216674c,
    0x221f979e, 0x863d9647, 0x458d5231, 0x43606d17, 0x229317b9, 0x6ddfd673,
    0x44da720d, 0x7258bd04, 0x609ccf8e, 0x46fc9a59, 0xbcec7812, 0x2af5dc2a,
    0x1ec8f23b, 0xd445fd05, 0xaca76f97, 0xd0760a4c, 0xa20c8027, 0x3b224024,
    0x70372025, 0xdca8d017, 0x3457d81d, 0x41bf4c1f, 0x80000000, 0x40000000,
    0x20000000, 0xb0000000, 0xd8000000, 0x84000000, 0xc6000000, 0xaf000000,
    0x19800000, 0xe4400000, 0x29600000, 0x73b00000, 0x81280000, 0x096c0000,
    0xfa0e0000, 0x44bf0000, 0x05128000, 0x86b84000, 0x2c126000, 0x103b5000,
    0x61d4a800, 0x05182400, 0xbf076600, 0x31807d00, 0x9844c880, 0xdb6525c0,
    0xc2b6a8a0, 0xb3ae75d0, 0x32aa00a8, 0x982a51fc, 0x07eb669e, 0x13c92cdd,
    0x279b2e2f, 0xacc74936, 0x2fa36689, 0x29152cdf, 0x7cbd2e2b, 0x5114493f,
    0x08bfe695, 0x6f126ce0, 0x93bdce04, 0x68975907, 0x5cf92eac, 0x9e7118e9,
    0x640e0004, 0x2fbf003e, 0xfa92801f, 0x7df8402e, 0xc4f2602d, 0x03cb5032,
    0x0f9ca81f, 0xd0c42419, 0x80000000, 0xc0000000, 0xa0000000, 0x50000000,
    0x68000000, 0x94000000, 0x3e000000, 0x63000000, 0x88800000, 0x66400000,
    0xe4600000, 0xf0500000, 0xab980000, 0xe3dc0000, 0x6cba0000, 0x706f0000,
    0xbbb58000, 0x230ac000, 0x9d646000, 0x7dd29000, 0x2a580800, 0x7b7c8c00,
    0xbfccde00, 0x8e40ed00, 0xb067a780, 0x6e511740, 0x989bc7a0, 0x035f8770,
    0x9ef9cf88, 0xaa0c0b64, 0x28e09192, 0x00162641, 0x18fb561d, 0xf509a119,
    0xaa62999f, 0x6b55aa70, 0x7f1a082e, 0x7f9f8c28, 0xbddb5e16, 0xffb92d11,
    0xc0ec47b0, 0x21f64764, 0x6d6a2f89, 0x30375b78, 0x3dcb7992, 0x2741fa4e,
    0x95e46033, 0xdb929028, 0x6e38083b, 0xdb2c8c3b, 0x7c54de02, 0xf99ced01,
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xb8000000, 0x4c000000,
    0xd6000000, 0x55000000, 0x8d800000, 0x82c00000, 0x3fa00000, 0x1c300000,
    0x0d280000, 0x21ec0000, 0x274e0000, 0x70fd0000, 0x62168000, 0x05df4000,
    0x26632000, 0xe7109000, 0x6058b800, 0x40a59400, 0x8ab3a200, 0x0b6a4f00,
    0x0f085680, 0x271c0bc0, 0x49c376a0, 0x53209bd0, 0xe975ceb8, 0x43480fcc,
    0x62f8ec96, 0x751100df, 0x375d9a23, 0x12209b0a, 0xcef0d4a0, 0x9a8ad4fa,
    0xb9dd9817, 0x08640431, 0x9e139a02, 0x4bdd9b26, 0x2f665488, 0x749594e0,
    0x439eb808, 0x68849417, 0x97432220, 0xe1640f10, 0x3d93f6a1, 0xb01edbe0,
    0x3b466ebd, 0x0766dfe7, 0xb093f4a2, 0x019a44d2, 0x80000000, 0xc0000000,
    0xa0000000, 0x70000000, 0x68000000, 0x24000000, 0x66000000, 0x51000000,
    0x2b800000, 0x9ac00000, 0x07a00000, 0xaf300000, 0xa4b80000, 0xc07c0000,
    0x1ada0000, 0x7c6f0000, 0x05148000, 0xd04bc000, 0xf0e0e000, 0xd354d000,
    0xefaed800, 0x05364400, 0x77b97200, 0x7cff1f00, 0x8a9a7e80, 0xa28a7f40,
    0x13429ea0, 0xba62af70, 0x6a164688, 0x86cbeb6c, 0xd3a3b492, 0x61333465,
    0x71bb2a0b, 0xfdfe9b31, 0xb919eca1, 0x744eb067, 0x56e2b828, 0x22555420,
    0xb42d4a13, 0xf7f28b35, 0x541954be, 0xb5c8e46b, 0x7f217216, 0x49731f14,
    0x93587eb0, 0xc1a97f55, 0xc0341ebb, 0xf23a6f4c, 0xe33826a3, 0xa8bbfb56,
    0xe2790ca6, 0xfdda605e, 0x80000000, 0x40000000, 0x20000000, 0xf0000000,
    0x48000000, 0xb4000000, 0x46000000, 0xdb000000, 0xc8800000, 0x43c00000,
    0x77200000, 0x28900000, 0xd5f80000, 0xc43c0000, 0x9e1e0000, 0xcd0f0000,
    0xd7b08000, 0x296ec000, 0x87c56000, 0x39205000, 0x67920800, 0xab788c00,
    0x14fef200, 0x95ba9b00, 0xe05b9780, 0xae681440, 0x0d46f7a0, 0x8fe44450,
    0x4732ffa8, 0x06afc86c, 0x9ae28dba, 0x80b49341, 0x1becfa2b, 0xcd021737,
    0xeb8565b9, 0x57428f77, 0x36e5600c, 0x8ab05011, 0x5aea0803, 0xdc848c21,
    0xb5c0f22f, 0xc4259b35, 0xa41317ab, 0x983ad474, 0xdc1d9794, 0x380b1446,
    0x8030779f, 0xac29847b, 0xdc211f87, 0xe812587b, 0x023b6589, 0x051d8f6e,
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x48000000, 0xb4000000,
    0x22000000, 0xdb000000, 0x54800000, 0xd1400000, 0xb9600000, 0x64500000,
    0x5aa80000, 0xd0ec0000, 0x7d0e0000, 0x28190000, 0x7bd48000, 0x876ac000,
    0x14c96000, 0xce3d7000, 0x13e12800, 0xe8104c00, 0x564b2600, 0xa6795d00,
    0xc5023780, 0xb985dec0, 0x2cc557a0, 0x1fa1aed0, 0xa4f0ff98, 0xc0db22fc,
    0xae72b98a, 0x1c9f0fd1, 0x5a91a602, 0x960a9d27, 0x749fd7b7, 0xfe926ec3,
    0xac0d1f81, 0xe39c92e6, 0x7412f1bd, 0x304e33d3, 0xf77da838, 0x4e868c02,
    0x5644461b, 0x2be12d31, 0xb4119f9d, 0x904a52c3, 0xa77d9193, 0xb68643e9,
    0xaa46003f, 0xbde50024, 0x4d128028, 0x1fcfc028, 0x80000000, 0x40000000,
    0xe0000000, 0x70000000, 0xa8000000, 0xac000000, 0x4a000000, 0x21000000,
    0x91800000, 0x59c00000, 0x08e00000, 0xb5300000, 0xdbe80000, 0xcb2c0000,
    0x5e4e0000, 0x68b90000, 0x42b28000, 0xa92bc000, 0x9348a000, 0x533ff000,
    0x4a727800, 0x984c3400, 0xd3b8da00, 0xca32ad00, 0x156cdc80, 0x8c6f47c0,
    0x29ea7ca0, 0xde29b7d0, 0x61ca8498, 0x867e43cc, 0x18d2feb2, 0x595f1ee7,
    0xc2025a20, 0x5d056d2f, 0xe3827ca4, 0x0cc5b7e9, 0xd76484be, 0x2bf743c8,
    0x29887e9a, 0x9758decd, 0x4504fa35, 0x47839d34, 0x7ac284b3, 0x646243d0,
    0x9f74fea9, 0x07ca1ef3, 0xad7eda1d, 0x4857ad3d, 0xe1185c90, 0x3b2187d4,
    0x4cd65cbc, 0xc75887d5, 0x80000000, 0xc0000000, 0x60000000, 0xd0000000,
    0xf8000000, 0xd4000000, 0x4a000000, 0x0f000000, 0x4a800000, 0xed400000,
    0x44e00000, 0xd7500000, 0xaa780000, 0xe03c0000, 0x025a0000, 0xc6490000,
    0xbdd78000, 0x373c4000, 0xecd8e000, 0x290fb000, 0x0a324800, 0xcced5c00,
    0x3ae15600, 0x82568100, 0x77f99380, 0x43f8ac40, 0x19fb73a0, 0x8efe1c70,
    0xc07ebbb8, 0x9f3f0044, 0x00df0d86, 0xd70a3171, 0x9f36d614, 0x716ac132,
    0x492173a6, 0x61f71c79, 0xeb493b8f, 0x74534048, 0xbeffed83, 0x28798171,
    0xd33e9e2f, 0x4ede9d36, 0x6a0fa5a0, 0x0eb1dd73, 0x9caa4820, 0xef815c33,
    0xb8c3561f, 0x7b23813c, 0x7af4138f, 0x8bcdec57, 0x461413a3, 0x489dec46,
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x98000000, 0xb4000000,
    0xa2000000, 0xdf000000, 0x60800000, 0x6dc00000, 0xffe00000, 0xf2700000,
    0x18a80000, 0x026c0000, 0x010a0000, 0x60bb0000, 0x86f18000, 0x47694000,
    0x9a8ee000, 0x77fcf000, 0x2fd18800, 0x1078cc00, 0x7690c200, 0x505c8d00,
    0x6c017680, 0xf6010fc0, 0x0d0596a0, 0x7786fff0, 0x21459ea8, 0x842773e4,
    0x7093bc8e, 0x555b0ec9, 0x17814226, 0x9145cd3e, 0x6c27969e, 0x0c91ffd5,
    0xdb5e1e89, 0xde8533cd, 0x8cc4dca1, 0xbe62bef4, 0xfe342a2f, 0xbb0af136,
    0xcbbf5c9e, 0x6470fefb, 0xa5ab4a37, 0x9def4125, 0x5c48348b, 0x6a98c2d4,
    0x3f600036, 0x0fb00026, 0x5f480032, 0x141c0037, 0x80000000, 0x40000000,
    0xe0000000, 0x30000000, 0x58000000, 0xfc000000, 0x46000000, 0x3d000000,
    0x7f800000, 0x8cc00000, 0x39600000, 0xbaf00000, 0x68f80000, 0x953c0000,
    0x8dde0000, 0x9ae90000, 0xc2f08000, 0x04fe4000, 0x5b3fa000, 0x24d89000,
    0x076ff800, 0xc9374400, 0x391a0200, 0x2f881900, 0x86031680, 0x9d00c540,
    0xaf82b6a0, 0xe4c15550, 0x9d65ce98, 0x00f4515c, 0x13fe6c8e, 0xd7bdd863,
    0x7e9a021f, 0x2f48192c, 0x416316a0, 0xd6f0c55f, 0xa6fab6b6, 0x3c3d556d,
    0x105bce82, 0x912d517b, 0xff16eca6, 0x704f986d, 0xf9e3a218, 0xbeb58900,
    0x61da6ebf, 0x14ecc154, 0x8bf194b2, 0xa97a9c71, 0x08f8002b, 0xe53c000a,
    0x35de003e, 0x56e9002a, 0x80000000, 0x40000000, 0xa0000000, 0x90000000,
    0x68000000, 0xc4000000, 0x5e000000, 0xb9000000, 0x77800000, 0x37400000,
    0xbfa00000, 0xe3300000, 0x3fe80000, 0x7dac0000, 0x5f8e0000, 0x34fb0000,
    0x46378000, 0x6a68c000, 0xa1e8e000, 0x24ad1000, 0x18095800, 0xfbbd2400,
    0x5591fe00, 0x135cd300, 0x7902f280, 0x978679c0, 0x074412a0, 0x47a069d0,
    0x4f32ca88, 0xa5e98df4, 0x9aadd492, 0x910f4ec5, 0x743ffe05, 0xced7d32b,
    0x36fd72b8, 0x7d32b9f6, 0x66eaf29f, 0x3a2a79fa, 0x90ca12a2, 0x275b69f0,
    0x3f054ab8, 0xb2814de2, 0x12c534a3, 0x3be25edb, 0xa416a639, 0xe11af727,
    0xe3248cbf, 0xf0f26aee, 0x7f8e003a, 0xe4fb000c, 0x8e378030, 0x3e68c03b,
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xc8000000, 0x94000000,
    0xfe000000, 0xdf000000, 0x19800000, 0x59400000, 0x3c600000, 0xefd00000,
    0xd6c80000, 0x7c8c0000, 0xdb6a0000, 0x08fd0000, 0x22d48000, 0x724ec000,
    0x69486000, 0xb6ce9000, 0x8c8ee800, 0xf369e400, 0xacf9ce00, 0x14d37d00,
    0x39490b80, 0x8ecb89c0, 0x308b6ba0, 0xa96819f0, 0x45f90398, 0x46533dfc,
    0x878aadaa, 0x34efd0d9, 0xfabbce15, 0xc9327d2e, 0xd3df8bb3, 0x0e6449c8,
    0x82d58ba4, 0x624949cf, 0x71490b9b, 0xdacb89f9, 0x2e8b6ba0, 0x466819e9,
    0x94790391, 0x8b133dd4, 0x45eaad82, 0x043fd0d4, 0x35f3ce1b, 0xecfe7d0c,
    0x34d58b93, 0xe94949e4, 0x76c90bbb, 0x6c8b89e5, 0x80000000, 0x40000000,
    0xe0000000, 0x90000000, 0xf8000000, 0x94000000, 0xe2000000, 0x1f000000,
    0xc1800000, 0xd0400000, 0x9b600000, 0x60700000, 0xacf80000, 0x41bc0000,
    0xa45e0000, 0xa5e90000, 0x2a358000, 0xfc9e4000, 0xe24ce000, 0x57e6f000,
    0x46b18800, 0xaa5ec400, 0x8ce82600, 0xf6b1cd00, 0x6259e680, 0x90ec5540,
    0xe8b306a0, 0xf35fa550, 0x38690e98, 0x04762174, 0x66f848a6, 0xd2bf5c51,
    0x83dcc61e, 0x70ab3d16, 0xfbd66e8e, 0x6f2b9172, 0x1a96a0b0, 0x2ccc285e,
    0xfe22081d, 0x7995840f, 0x234f4612, 0xa7607d14, 0x4e710ea8, 0xb5fa217c,
    0x153e4898, 0xc69a5c70, 0x594f4604, 0xfc607d31, 0x75f10e8b, 0x7eba2174,
    0x55de48b6, 0xfdaa5c6d, 0x80000000, 0xc0000000, 0x20000000, 0x90000000,
    0xb8000000, 0xec000000, 0xee000000, 0xdd000000, 0x24800000, 0x2e400000,
    0xfae00000, 0xb4500000, 0x50180000, 0x955c0000, 0x0a3a0000, 0x52ab0000,
    0xcf178000, 0x8a7e4000, 0x954b2000, 0xefc35000, 0xdc243800, 0xaef25c00,
    0x53a88e00, 0xed97c900, 0x0d3c3380, 0xd92d1f40, 0xfed513a0, 0x63594f70,
    0x6b3caba8, 0x002e5354, 0x40508586, 0x02188a6f, 0x3e59ae3d, 0x8fbf9918,
    0x0e6f8b94, 0x2ab10363, 0x0e4ebd82, 0x8241d65a, 0xf4e6a030, 0xd9561020,
    0x5c989807, 0xef1f4c08, 0xf2df960e, 0xd5fac532, 0x668a85b2, 0x15e38a54,
    0x4bd62e34, 0xf3ddd930, 0xf77eab97, 0xe1c95365, 0x5985059d, 0x5ac1ca67,
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x38000000, 0x84000000,
    0x6a000000, 0xb3000000, 0x21800000, 0x2e400000, 0xc0a00000, 0x70f00000,
    0x91980000, 0x4edc0000, 0xc0fe0000, 0xa1cf0000, 0xefb18000, 0x3fbc4000,
    0xffee6000, 0xb6863000, 0xf5c02800, 0x45e46400, 0xc5d1f600, 0x9d2e0300,
    0x28e68c80, 0xb554b440, 0x6deeeca0, 0xe1818450, 0x4e4144a8, 0x30a6a064,
    0x98f752a6, 0x2d9ed345, 0xa0d9963c, 0x19fb3329, 0x33492494, 0xe0739072,
    0xd158fa8c, 0x4fb9f74a, 0x57ef802e, 0x2a83400c, 0xcbc7e02a, 0xa4e67039,
    0xd350480b, 0xf8ed5425, 0x75005e02, 0x2486273e, 0xa2c11ab1, 0xfe60874c,
    0xb096483c, 0xc00e540b, 0x9857de25, 0x3d696739, 0x80000000, 0xc0000000,
    0x20000000, 0xb0000000, 0xf8000000, 0x94000000, 0x2e000000, 0xd7000000,
    0x86800000, 0x59400000, 0x19e00000, 0x28500000, 0x83d80000, 0xd79c0000,
    0xe1fa0000, 0xa96b0000, 0x30968000, 0xcdfd4000, 0xf36be000, 0x59959000,
    0xd47ba800, 0x40afdc00, 0xa3317600, 0x1ccce900, 0xbaa22380, 0x28b4d140,
    0x6a0bc3a0, 0xc3864170, 0x1ac4eba8, 0xc323dd5c, 0xcb72fd96, 0xf8ace479,
    0xd736161d, 0xa2cf390c, 0x25a4eb9c, 0xc233dd6a, 0x894afdb2, 0x2360e47c,
    0x63141624, 0x9f383900, 0x5c486b89, 0x28e59d4a, 0xd5d79d87, 0xc6183446,
    0xde3c5e2a, 0x79ce7505, 0x4920b5ac, 0x0a71a84a, 0x1d28481e, 0x96f64c2d,
    0xcd68de35, 0x0694351b, 0x80000000, 0xc0000000, 0x60000000, 0xd0000000,
    0x98000000, 0x6c000000, 0xd6000000, 0x37000000, 0x2d800000, 0x11c00000,
    0xd3e00000, 0x71700000, 0x02c80000, 0x1e8c0000, 0xacaa0000, 0x26390000,
    0x71878000, 0x4fc74000, 0x70e22000, 0x36f79000, 0x6a08a800, 0xbbe90400,
    0x379cea00, 0xd1d7c500, 0xe01f7680, 0x8110ccc0, 0x997ad6a0, 0x84201cf0,
    0xad905eb8, 0x823e88c4, 0x93841c9e, 0xa2c049df, 0x6c67802b, 0xa5b74012,
    0xe9aa2000, 0xdebb9026, 0xa0c2a82c, 0x9160040e, 0x41336a0a, 0xc6ec8512,
    0x131f5694, 0x9e925cd6, 0xfdbffea3, 0x274758f1, 0x99a11493, 0x34559dd4,
    0xc5dbe22f, 0x88f71126, 0xd90e949c, 0x046edde6, 0xe35bc20b, 0x3ab58115,
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x18000000, 0x4c000000,
    0x46000000, 0xf7000000, 0x18800000, 0x84400000, 0xbe600000, 0xcf500000,
    0xc0380000, 0xa4fc0000, 0x62de0000, 0x2ded0000, 0x69828000, 0x4bc64000,
    0xb2a62000, 0x1d771000, 0xe50f2800, 0xa1932c00, 0xb71b6e00, 0x0449ad00,
    0xba76ef80, 0x35886a40, 0xe1d24fa0, 0xeb793a50, 0x2e1b47b8, 0x9fcd066c,
    0xbcb701be, 0x56ab877f, 0x2b64802f, 0x72d74002, 0xc1faa009, 0xc75c5033,
    0x602b883e, 0x4c227c3c, 0xbe326608, 0xcbed9106, 0x4e82a981, 0xdb42eb70,
    0x92e7ce3d, 0xb114fd13, 0xd759e786, 0xc82d564b, 0x782289b1, 0x4434fb75,
    0x62ec660b, 0xed00912d, 0x0180298e, 0x5fc4ab6d, 0x80000000, 0x40000000,
    0xe0000000, 0x70000000, 0xb8000000, 0x64000000, 0xd6000000, 0x8b000000,
    0xf1800000, 0x7dc00000, 0x9fa00000, 0x0f300000, 0xf6380000, 0x4e7c0000,
    0x121e0000, 0x45890000, 0x37028000, 0x73834000, 0x78c26000, 0xf123d000,
    0xed740800, 0xfb5e4400, 0xf96a8a00, 0x1dd2c700, 0x93ede680, 0x19905b40,
    0x4d8d06a0, 0x4b00cb50, 0x51836e98, 0xedc15f4c, 0x57a3ecb6, 0xd334dc55,
    0x443e0003, 0x13790037, 0x689a801f, 0xc9cf4038, 0xd5646000, 0xe316d027,
    0x81c88813, 0x4964042d, 0xb1126a22, 0xacce571e, 0x8be58e93, 0x5954cf5d,
    0x98a9048a, 0x90730872, 0x51d86234, 0x5d291303, 0x53b58480, 0x0979485c,
    0xd9988204, 0x59498328, 0x80000000, 0xc0000000, 0x60000000, 0xd0000000,
    0x18000000, 0x3c000000, 0x16000000, 0xc5000000, 0x43800000, 0xd1c00000,
    0x7b200000, 0x11300000, 0xacb80000, 0xb0fc0000, 0x231a0000, 0x7c890000,
    0x05c78000, 0x39234000, 0x5634a000, 0xc83f1000, 0xd5bbb800, 0x257f6400,
    0x57db0a00, 0x942ee300, 0xdd308280, 0xd2ba1b40, 0xe1fba2a0, 0x829a4b70,
    0x5a4ebab8, 0xd2633f44, 0x695188be, 0xd6edf84b, 0x8094a03b, 0xe1cf103a,
    0x2fa3b80b, 0x7c73643e, 0xeed90a0d, 0x61abe30e, 0x79f502a0, 0x221c5b6d,
    0x050a828d, 0x7f031b73, 0x28842284, 0xdb450b7d, 0x37601a89, 0x5ad52f44,
    0xaf2db092, 0x0fb1dc50, 0xc2fb0a1f, 0x6c1ee31e, 0x5c088297, 0x9a861b50,
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xc8000000, 0xbc000000,
    0xbe000000, 0x15000000, 0x38800000, 0x4cc00000, 0x7d200000, 0xbf900000,
    0x09380000, 0x1b7c0000, 0xbb9a0000, 0x2baf0000, 0xf6c68000, 0xc224c000,
    0x00172000, 0x2e7fd000, 0x731af800, 0x0f6b7c00, 0x07e1fa00, 0x0bb26300,
    0xa02f7780, 0xb3821a40, 0x9146d7a0, 0x61650a70, 0x02710f88, 0xbd8ea67c,
    0x04d48dba, 0x2f5f7953, 0xd28f2015, 0x2353d016, 0xec18f83b, 0x40e87c35,
    0x48a57a0c, 0xefd5a316, 0x62dcd7bc, 0x36ca0a7f, 0xeab78f9d, 0x5aaa6640,
    0xf443ad86, 0xf1e0a96f, 0x62b5d82b, 0x86a8ac24, 0xda41023a, 0x1ce61f14,
    0x2e300db3, 0xc868b943, 0x0c64802b, 0x8ef7c02f, 0x80000000, 0x40000000,
    0x60000000, 0x90000000, 0x98000000, 0x4c000000, 0xc6000000, 0xd5000000,
    0xb5800000, 0x70400000, 0x5be00000, 0xb2300000, 0x4ec80000, 0x790c0000,
    0xddae0000, 0x6afd0000, 0x5ac18000, 0xad214000, 0x09112000, 0x6adc1000,
    0x7a523800, 0x89bd5400, 0x21a1b600, 0xbad4d900, 0xfc7ea080, 0x62045ac0,
    0x170600a0, 0x12850ad0, 0x0ac318b8, 0x15254ef4, 0xb517169e, 0xa4dc83e7,
    0x7b56a02f, 0xb63c5012, 0x42e49822, 0x81b1041e, 0x8b8d2e2c, 0x0769dd16,
    0x87dd8e99, 0x33d087db, 0x57fa0e3f, 0xeb44cd24, 0xaf6036bc, 0x9df193e7,
    0xe66b1836, 0x685d4436, 0xa8958e14, 0xb0988d18, 0xc2b09689, 0x530cc3f2,
    0x7ea8002c, 0x627c0007, 0x80000000, 0x40000000, 0x60000000, 0x90000000,
    0x28000000, 0xc4000000, 0x7e000000, 0x3d000000, 0x4e800000, 0xd6400000,
    0x3e200000, 0xaf100000, 0xda580000, 0xf79c0000, 0x257e0000, 0xc40d0000,
    0xce618000, 0x9034c000, 0xc9c8e000, 0xec841000, 0xc9477800, 0x2fa54c00,
    0x08d25e00, 0xd3bd9f00, 0x796a6f80, 0xb5d11940, 0xdd3d0fa0, 0xcf2cc950,
    0x1bf317b8, 0x5a295574, 0xd176d1b2, 0x92699645, 0x4257982d, 0x5bfd5c0a,
    0x8a4b261e, 0xec45d32f, 0x3d21b189, 0xbc944660, 0xd2998015, 0x37f8c03c,
    0x704ee03b, 0xcf451036, 0xdea0f809, 0x0c508c32, 0xfefd3e21, 0xd8cc4f1c,
    0x380277a9, 0xac058550, 0xda07499e, 0xd305ca5b, 0x5b833e12, 0x5cc14f20,
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x08000000, 0xa4000000,
    0xda000000, 0x77000000, 0xf9800000, 0xeac00000, 0x6c600000, 0xe5b00000,
    0xfab80000, 0xc6fc0000, 0x75de0000, 0xd8cf0000, 0x9ea38000, 0x65d7c000,
    0x4108e000, 0x01433000, 0x35a20800, 0x1a568400, 0x1ac97200, 0x05a40100,
    0xc253f480, 0x96cb1d40, 0xeba694a0, 0x6750ed50, 0xbc4ffca8, 0x22e29974,
    0x96f466aa, 0xcc1f2c5d, 0xd72ae81c, 0xc6d5b400, 0x9a8b7a02, 0x8082852a,
    0x46428691, 0x14231c77, 0x7c93600d, 0x98a8f03f, 0x4514e80e, 0x126ab420,
    0x9970fa1d, 0x6fd9450e, 0xcfcc66a2, 0xd7232c43, 0x1714e839, 0x816ab403,
    0x9af0fa2f, 0x62194503, 0x522c6697, 0x7c532c7a, 0x80000000, 0xc0000000,
    0x20000000, 0x10000000, 0x68000000, 0x84000000, 0xda000000, 0x7b000000,
    0x90800000, 0x00c00000, 0x9ee00000, 0xad500000, 0x85480000, 0xba0c0000,
    0xe6aa0000, 0x1adb0000, 0x9ea38000, 0x9b74c000, 0x12fee000, 0x58153000,
    0xcaec6800, 0x52f8ac00, 0xb8130a00, 0xfaefed00, 0x2afcbf80, 0x5412a1c0,
    0xa4ebdfa0, 0x8bf851f0, 0xbf92d7a8, 0x34ad0df4, 0x15d955b2, 0x8c247cd5,
    0x1cb10804, 0x2a995c0b, 0xd0818200, 0xe0c2713b, 0xaee3ddaf, 0xd555e0d4,
    0x694c6a34, 0xe4091d2b, 0x47afb793, 0xf15cfdc7, 0x0ee3dda2, 0x0555e0f4,
    0x214c6a25, 0x70091d32, 0xf5afb79e, 0x0e5cfdc7, 0x4463dd94, 0x7e95e0fe,
    0x2f2c6a09, 0xdd991d2d, 0x80000000, 0xc0000000, 0x20000000, 0xb0000000,
    0x48000000, 0xe4000000, 0xa6000000, 0xdd000000, 0x2f800000, 0x0ac00000,
    0x94a00000, 0x1c900000, 0xdee80000, 0xbaac0000, 0xc14a0000, 0xfcbb0000,
    0x4ee68000, 0x8670c000, 0x7699e000, 0xd531d000, 0x2df8b800, 0x4e808400,
    0x5f417200, 0x69602700, 0x88b7cb80, 0xd43d90c0, 0xeca2aba0, 0x709780f0,
    0xbced73a8, 0x71aa14dc, 0x7bcf59ba, 0x3dfc67e5, 0x7685d813, 0xd3469412,
    0x9b64aa38, 0xbbb6b320, 0xc2bb6195, 0x6fe723cb, 0x33f3ca10, 0x1b5ba32c,
    0xb91039a1, 0x8b2d77f8, 0x5a8c8003, 0x959bc03e, 0xdbb76028, 0x92bd101e,
    0xb7e3582c, 0x2ff65403, 0x115d4a1e, 0x2617632d, 0xdfabd99f, 0xa2cba7e5,
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x58000000, 0xc4000000,
    0x42000000, 0xdb000000, 0x72800000, 0x48400000, 0x55a00000, 0xd1f00000,
    0x8c780000, 0xafbc0000, 0x5bde0000, 0x05490000, 0x75208000, 0x8ab64000,
    0xe75a6000, 0xd80b7000, 0x87062800, 0x54847c00, 0x01439e00, 0x9426e300,
    0x77311480, 0x179e3340, 0xb2edf4a0, 0xafd60350, 0x1c4f3c98, 0x9ca64f5c,
    0x50706a8e, 0xcab9e06d, 0x045ea81e, 0x1e8e3c1b, 0x3547fe22, 0x2e249319,
    0xb837bc8f, 0x4f1c0f61, 0xbdac0a9a, 0x0ef7906b, 0x1cfe0024, 0xecf90010,
    0x14f88013, 0x00fa4001, 0x2afc6017, 0x6dfe7039, 0x9978a81f, 0x483b3c24,
    0xb4197e0c, 0x5f2bd302, 0xceb55cb3, 0xe55d3f5c, 0x80000000, 0xc0000000,
    0x20000000, 0x30000000, 0x98000000, 0xac000000, 0x86000000, 0xc1000000,
    0x14800000, 0xc0c00000, 0x32e00000, 0x05100000, 0x79980000, 0x8adc0000,
    0x7d7a0000, 0x16cb0000, 0x9c628000, 0xead24000, 0x8af92000, 0x41881000,
    0x29c19800, 0xd260fc00, 0xcfd41a00, 0x3c7c7d00, 0xc24abd80, 0x7ca72540,
    0xe8331da0, 0x17ea7570, 0x941325a8, 0x251bd97c, 0x6e1d078e, 0xcd9d0857,
    0x60db182f, 0x1a7ebc27, 0xf34f3a0a, 0xd0236d27, 0xb4f3a58e, 0x3b0e996a,
    0xfc04a796, 0xce005853, 0xe5032020, 0x9683102a, 0xb3c31804, 0xcd62bc3b,
    0x96553a03, 0x5e386d16, 0x696925b4, 0xf3d0d95b, 0xd27f8795, 0x174f4850,
    0x72223811, 0xf7f6ac2b, 0x80000000, 0x40000000, 0xe0000000, 0xb0000000,
    0x28000000, 0x74000000, 0x66000000, 0xaf000000, 0x94800000, 0x86c00000,
    0x00200000, 0x8c500000, 0xc9380000, 0x5a7c0000, 0x631e0000, 0x53290000,
    0xfba48000, 0x3e11c000, 0x1fd86000, 0x4e085000, 0x7a72a800, 0xd26c4c00,
    0x0bc05a00, 0x35a32b00, 0xa5111180, 0x0d5b0c40, 0xd7cbf1a0, 0xc6d79c50,
    0xacfbb998, 0xa4db407c, 0x4c8dab92, 0x9bb1b761, 0x82c8280b, 0x4f548c0a,
    0x27bcba0e, 0x81babb3b, 0x8ebbd9b6, 0x4a3f1074, 0x54f903ae, 0x08d8fb6f,
    0x968af217, 0x96b3673c, 0xf74f4ba6, 0x8611275f, 0x53de6020, 0x240d5038,
    0x5f70283b, 0xd3e88c1a, 0xa482ba0a, 0xeec3bb3a, 0x94275999, 0x5a52d077,
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xa8000000, 0x84000000,
    0xea000000, 0xb7000000, 0xff800000, 0x7a400000, 0xa0600000, 0xcd100000,
    0xbad80000, 0xa61c0000, 0xfeba0000, 0xb10d0000, 0xbb628000, 0x9c93c000,
    0x7d99e000, 0xbefdb000, 0x1e698800, 0x55f43400, 0x9a084600, 0xa2e55500,
    0x2fd7a580, 0x277c5f40, 0x6d2ec5a0, 0xef132f70, 0xb9de2d98, 0xfb986b4c,
    0x47fe83b2, 0xacea7a6d, 0x3f338808, 0x93a93400, 0xdbd2c617, 0xa57a952e,
    0xbe2c4587, 0x0a90ef61, 0xdc9fcda3, 0x2079db59, 0x1aad0b9e, 0x01534e64,
    0xabb94e25, 0xad8fa13c, 0x6ca48388, 0x2db77a7d, 0x29690806, 0x6a76f413,
    0x00492605, 0xf2862509, 0x4ac54da6, 0x19a61b7e, 0x80000000, 0xc0000000,
    0xe0000000, 0x50000000, 0x48000000, 0x0c000000, 0xfa000000, 0x93000000,
    0xb3800000, 0x89400000, 0x2e200000, 0xbe900000, 0x4b280000, 0x74ec0000,
    0x990a0000, 0x087d0000, 0xb5278000, 0x2111c000, 0x886fa000, 0xd1cb7000,
    0xd01b6800, 0x3c13b400, 0x86e91e00, 0x260fff00, 0xf1fff380, 0xb76266c0,
    0xf8b5d3a0, 0x49b9d6f0, 0xddc49b98, 0x3ae1d2e4, 0xd4f4cd8a, 0x5d1a29e7,
    0x9a916834, 0x2d2eb403, 0xb5ee9e38, 0xe58e3f11, 0x80b8538b, 0x8d4516ea,
    0xf824bbab, 0x679762c4, 0x73aa058b, 0x0a2fedf6, 0xc86c9e18, 0xf1cf3f1f,
    0x601dd3af, 0x2415d6d0, 0xc2ee9bbd, 0xd00cd2c4, 0x98fb4d9b, 0x97e7e9f7,
    0xc274c834, 0xeed8c428, 0x80000000, 0xc0000000, 0xa0000000, 0x70000000,
    0x98000000, 0x14000000, 0x82000000, 0x61000000, 0xf1800000, 0x5e400000,
    0xbe600000, 0x5b100000, 0x5d980000, 0x7d5c0000, 0x8bfa0000, 0x6a4f0000,
    0xe0648000, 0x84144000, 0x631ae000, 0x559ff000, 0xe1597800, 0x55ff3400,
    0x754ee600, 0x7ee3c500, 0xdcd6b580, 0x91b9c540, 0x7e2ad5a0, 0xf6717570,
    0xce0fcd88, 0x3b06f16c, 0xe48433ae, 0xfdc2b069, 0x6921780e, 0x98f33431,
    0xcecce612, 0x7da0c516, 0x3d303595, 0x13ee855c, 0x1756b584, 0x0af9c576,
    0x8bcad5ae, 0xf6217568, 0xc677cd8c, 0x360af15b, 0xff06339b, 0x8e81b040,
    0x10c7f808, 0x0ea4741d, 0x25b08638, 0xe028753e, 0x89752d88, 0x80890178,
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x58000000, 0x54000000,
    0x52000000, 0x71000000, 0x8a800000, 0x20c00000, 0xb8600000, 0x41300000,
    0x49f80000, 0x1cbc0000, 0xc19e0000, 0x558b0000, 0x24638000, 0x5f354000,
    0x9efde000, 0xa53e7000, 0x42df7800, 0x13acec00, 0xaff7ca00, 0x9e9e5900,
    0x000b7880, 0x1120f340, 0x721318a0, 0xe2ecc350, 0xc8d40088, 0x678c1f54,
    0xa564d29e, 0x3db29a41, 0xa23f780a, 0x435cec1d, 0x74efca08, 0xf3d25905,
    0x680d788e, 0x4d27f351, 0x8c1698aa, 0x85ee8353, 0x395460a6, 0xe8cc2f5e,
    0xe545ca9b, 0x95254654, 0x98122a06, 0x77ec2931, 0x58520086, 0x3a4b1f6a,
    0x918152bb, 0x7f40da5c, 0xa827181e, 0xb490dc19, 0x80000000, 0xc0000000,
    0x60000000, 0x10000000, 0x78000000, 0x44000000, 0xca000000, 0x45000000,
    0xdd800000, 0xd8400000, 0x66200000, 0x58d00000, 0xa3780000, 0x555c0000,
    0xb58a0000, 0x32f10000, 0xbdad8000, 0x35244000, 0x9e576000, 0x31bcb000,
    0x27bad800, 0x3cbb5400, 0x76392600, 0x62fccf00, 0xb31f5d80, 0x54aa6040,
    0xdea585a0, 0xed113470, 0x151ca3b8, 0x47adfb74, 0xb823fe26, 0x0fd79b25,
    0x0ffe7bb4, 0xf29aaf44, 0x72e8d83b, 0x5f865406, 0x1146a604, 0x3da58f35,
    0x2397bd98, 0xabdf9064, 0xc34fbd8e, 0xfa13906e, 0x199dbda5, 0x906e9056,
    0x17423d9a, 0x5ea7d07e, 0x2d12ddbd, 0x751e206f, 0x57aae5bd, 0xc0218455,
    0x4bd47bad, 0xc5fbaf5b, 0x80000000, 0x40000000, 0x60000000, 0x30000000,
    0x18000000, 0xdc000000, 0xbe000000, 0x63000000, 0x25800000, 0x30c00000,
    0xf1200000, 0xf5b00000, 0xb6f80000, 0xafdc0000, 0xbe6e0000, 0x3a950000,
    0x60488000, 0x5ca64000, 0x1175a000, 0x6dd8d000, 0x736d8800, 0x34110400,
    0x810c5200, 0xe7445300, 0x14e1fa80, 0xd6119f40, 0x1c0c72a0, 0xc1c09b50,
    0x31a020b8, 0x0ff4c85c, 0xc499da3e, 0x3c89572b, 0x4b83a8b1, 0x3bc0cc63,
    0x70a50800, 0x97774433, 0x82d9f202, 0xc0ec8325, 0xa3d4729e, 0x37ac9b6d,
    0xff3620b1, 0x15bdc850, 0x993f5a2b, 0xd57a1722, 0x501e8891, 0xacce5c44,
    0x70e52024, 0xa4129015, 0x890e2829, 0x7340d439, 0x5ee75a12, 0xcf161710,
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x98000000, 0x5c000000,
    0xba000000, 0xd5000000, 0x78800000, 0x89c00000, 0xa3600000, 0x24900000,
    0xf1880000, 0x6eec0000, 0x207a0000, 0x8cf30000, 0x6e9e8000, 0xb9204000,
    0xa5b1a000, 0xf83af000, 0x94d41800, 0x0daa7c00, 0xdbdec200, 0xb584c100,
    0x6d451980, 0xb0a217c0, 0x62f101a0, 0x35986bf0, 0x4aa7c3a8, 0x57f0aafc,
    0x5d18da0e, 0x6b61bd2b, 0x30975b80, 0x9f8996ee, 0xf5e93836, 0xf3ffcc30,
    0x4eb7fa10, 0x53bb0d12, 0x1a92e3ac, 0x22891ae7, 0x696be212, 0xac3d7134,
    0x1ad621b9, 0x86aedbf8, 0xa0587b94, 0xb3c326dd, 0xb664802d, 0x7c134001,
    0x484f2002, 0x558ab00a, 0x58edb833, 0xc77c8c07, 0x80000000, 0xc0000000,
    0x20000000, 0xb0000000, 0xb8000000, 0x3c000000, 0x6a000000, 0xf9000000,
    0xe9800000, 0x81c00000, 0x0be00000, 0x2e500000, 0x0cc80000, 0xed2c0000,
    0xfa7a0000, 0x3f330000, 0xe3da8000, 0xaa454000, 0x8727a000, 0x02367000,
    0xbc58f800, 0x28821400, 0x94436a00, 0xc0214d00, 0x6cb76b80, 0x731bc7c0,
    0x5c2793a0, 0x76b5d3f0, 0x121ef9a8, 0x39a79edc, 0x25731206, 0xdcf91913,
    0x947321bc, 0x517abadd, 0xd3b5202e, 0xc19f3021, 0x6965582a, 0xf3176439,
    0x9d691215, 0x3c5a191f, 0xe881a1a5, 0xb443fac1, 0x7020801f, 0xd4b6400e,
    0x4f1d202d, 0x36233002, 0x8fb7581b, 0xfb986414, 0xb861920f, 0x2e90590b,
    0xf2ae8193, 0x98bfcaec, 0x80000000, 0x40000000, 0x20000000, 0xf0000000,
    0xe8000000, 0x94000000, 0x56000000, 0xcb000000, 0x74800000, 0xdb400000,
    0x09a00000, 0x78d00000, 0x55480000, 0x5aec0000, 0xb13e0000, 0xccf70000,
    0x7f5c8000, 0xb2c5c000, 0x2d666000, 0xfeb05000, 0x0f7fc800, 0x96d40c00,
    0x524d8600, 0x246a8300, 0x937a8980, 0xc4d2c5c0, 0xf74d41a0, 0x17eac9d0,
    0x16bec7a8, 0x1f374aec, 0x6fb8ce12, 0x5eb04f09, 0xbf7befa7, 0x5ed6d6eb,
    0x364ce012, 0x9a6e9031, 0xcc7b2802, 0xe6569c26, 0xe708ae30, 0x6acb1f1b,
    0xb52ea7ae, 0x43dc1ac9, 0x4d85861b, 0xbac6832f, 0x296489b2, 0x90b5c5c2,
    0x4879c198, 0xc85309d5, 0x800ea78d, 0xc44c1afe, 0x8f6d8623, 0x37fa830e,
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xd8000000, 0x9c000000,
    0x56000000, 0xa1000000, 0x7f800000, 0x03c00000, 0xb6e00000, 0x34100000,
    0x0f780000, 0x279c0000, 0x668a0000, 0x54750000, 0x732c8000, 0x6fc04000,
    0x18e1a000, 0x59179000, 0x4efed800, 0xc15e8400, 0x65e80a00, 0x94a1e500,
    0x14358180, 0x000bd040, 0xc43359a0, 0xa8095470, 0x60315398, 0xd20db15c,
    0x4f30522e, 0x908a213b, 0x6570ab9b, 0x84ade563, 0x9801a01c, 0xbc07903f,
    0x0606d81f, 0xc9028409, 0x3b820a07, 0xc9c4e523, 0x41e101a2, 0xea979079,
    0x7338f9b9, 0x92bbc477, 0xe47b0bb6, 0x6f1f7549, 0x5bcbf824, 0x2ed5540f,
    0x2a1d720e, 0x7e4df135, 0x5217d3af, 0xb678f141, 0x80000000, 0x40000000,
    0xe0000000, 0xb0000000, 0x18000000, 0xd4000000, 0xa2000000, 0x43000000,
    0xbb800000, 0xcdc00000, 0xede00000, 0xbf500000, 0x0c580000, 0xa7bc0000,
    0xa1ee0000, 0x61310000, 0xa2c88000, 0x78064000, 0x2401e000, 0x5a047000,
    0x27042800, 0x01821400, 0x5ac70a00, 0xf461cd00, 0x3196e380, 0x5a3f2b40,
    0xd52acba0, 0x40513f50, 0x79dbc198, 0x0f7df27c, 0xbe8ba21e, 0x27259909,
    0x43300996, 0xa1ca9649, 0x23800020, 0x59c00006, 0xafe00005, 0x4c500020,
    0xafd80010, 0xbe7c0000, 0xee0e0038, 0x9d61000e, 0x1510802d, 0x127a401c,
    0x680fe032, 0x8465703f, 0x8994a82b, 0xde385421, 0xdf28ea3e, 0xcf54bd33,
    0xb45a4bbb, 0x23bb7f75, 0x80000000, 0x40000000, 0x20000000, 0x10000000,
    0x78000000, 0x94000000, 0xba000000, 0xe9000000, 0x7b800000, 0x7d400000,
    0xa5200000, 0xccb00000, 0xa9080000, 0xba2c0000, 0xc19e0000, 0x08170000,
    0xa1fb8000, 0x95864000, 0x4e45e000, 0x07a3b000, 0xa276b800, 0x9d6a8400,
    0xfdbfde00, 0xf726cf00, 0x89b4ee80, 0xdc8c58c0, 0x846a56a0, 0x8e3adcd0,
    0x566388a8, 0x6a9713d4, 0xaf3ae636, 0x91e60b31, 0x61d0d0b8, 0xdd1e27db,
    0x0dd3800e, 0xb31a4010, 0x7ed3e011, 0x3198b012, 0x00133803, 0x7dfbc427,
    0xd381be1d, 0xf1433f25, 0xbb27b6ac, 0xf7b56cd6, 0xd78b3082, 0x92ea97c5,
    0x4afeb811, 0xf3068439, 0xc281de22, 0x5ec1cf38, 0x5c676ead, 0xab9618d7,
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x38000000, 0x2c000000,
    0x0a000000, 0x69000000, 0x45800000, 0xf5c00000, 0x9ae00000, 0x21300000,
    0x79480000, 0xcdac0000, 0x3b9a0000, 0x58510000, 0x0ebe8000, 0x62854000,
    0x17452000, 0x4da3f000, 0x0c91f800, 0x05d8f400, 0xf073aa00, 0xe7ef0500,
    0xb5be3880, 0xd205b8c0, 0xf507c0a0, 0x17814cf0, 0xc0c66ab8, 0xed6349ec,
    0x91f4d236, 0xac2eb127, 0x705ab294, 0x9db44dcd, 0x410c803d, 0xd688401c,
    0xd649a02d, 0x5b2bb033, 0xbad85827, 0x2ef3440d, 0x72abf234, 0xe51c4137,
    0xcd15ca82, 0x5e19f9c0, 0x7d920a0e, 0xbc58b525, 0x27b46083, 0x700bfce5,
    0xcf08b29a, 0x11894dc6, 0x84c8002b, 0xd46c0022, 0x80000000, 0x40000000,
    0xa0000000, 0x30000000, 0x98000000, 0xc4000000, 0xd6000000, 0xe3000000,
    0xb4800000, 0x19400000, 0x2c600000, 0xa5900000, 0xe6b80000, 0x49dc0000,
    0x88ce0000, 0x7f330000, 0x768e8000, 0xd1d44000, 0xb9596000, 0x078d5000,
    0x10500800, 0x579fcc00, 0xb62cd600, 0x18e1fd00, 0xfcd67d80, 0x6adace40,
    0xdc4875a0, 0xf6760250, 0xf2ea2388, 0x2843bf5c, 0x4de53e2e, 0x7b54212d,
    0xcf1d43bb, 0x856def45, 0xf583b61e, 0x40c3ad1f, 0x06a6f5bb, 0xc232425b,
    0x0d0b4399, 0x5612ef5c, 0x4d7b362d, 0x97f8ed00, 0xd9bf15a5, 0xaf585242,
    0x048caba9, 0x34d4335a, 0xe6de881e, 0xc64b8c10, 0xaf75b60d, 0x2f6cad1f,
    0x748675aa, 0xf945024f, 0x80000000, 0x40000000, 0xe0000000, 0x50000000,
    0xc8000000, 0xa4000000, 0xca000000, 0x79000000, 0x68800000, 0x49400000,
    0xf2200000, 0x8d300000, 0xada80000, 0x2e8c0000, 0xcf3e0000, 0x51d10000,
    0x6c7f8000, 0x2af7c000, 0xf1cbe000, 0xf21e3000, 0x8b643800, 0xa7159c00,
    0xac9a6600, 0xbd200f00, 0x9ab31a80, 0x2b69a1c0, 0xd66922a0, 0x84ed3dd0,
    0xccacc498, 0x6a0af2c4, 0x087c3e2a, 0x40f1632d, 0x38cf24b8, 0x0298c2e3,
    0xae26063a, 0x3b35ff35, 0x92aac2ac, 0x010f0dfb, 0x95fefc9f, 0x5f326ec3,
    0xf8afd80e, 0xc80bac26, 0x657e5e13, 0x7a75933a, 0x64897ca8, 0xf639aef6,
    0xd9523826, 0x75389c08, 0x10d3e618, 0xd8facf0b, 0x95b17a91, 0xdced51c7,
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x38000000, 0x04000000,
    0x12000000, 0x0d000000, 0xe7800000, 0xfec00000, 0x7c600000, 0xc5700000,
    0x03580000, 0xba3c0000, 0xe4ce0000, 0x6f550000, 0xc60a8000, 0x35354000,
    0x44786000, 0xa8ee7000, 0xcd055800, 0xc7870400, 0xeec00200, 0x3461f900,
    0xf973b680, 0x155a5e40, 0xa538eea0, 0x0e485a50, 0x76126cb8, 0x44ace34c,
    0x8c21ba36, 0x8254cd0d, 0x118a0c92, 0x93f2935e, 0x4c1ce213, 0x479fc92d,
    0xc75c0eba, 0x883a6a51, 0xf9cbd488, 0xc0d5d771, 0x04ce001a, 0x5f55000b,
    0x9e0a8027, 0x4135401a, 0x6e78600c, 0xa1ee700f, 0x3885582e, 0x34470404,
    0x75200206, 0x0fd1f903, 0x864bb698, 0x6a165e6b, 0x80000000, 0xc0000000,
    0xa0000000, 0xb0000000, 0x28000000, 0x8c000000, 0xfe000000, 0x61000000,
    0x82800000, 0xc5400000, 0x64e00000, 0x32700000, 0xc3880000, 0x6a6c0000,
    0x549a0000, 0xbb570000, 0x0b5e8000, 0x7ef5c000, 0x8fcea000, 0xa00bd000,
    0xedaf1800, 0x553eac00, 0x5dc7d600, 0xd2a12900, 0x5b123680, 0x4f3fecc0,
    0x2ec72ea0, 0xdf2640f0, 0xe5d67888, 0xc81ea9dc, 0xcf10ee02, 0xd53d953f,
    0x9dc6589d, 0x72a0b9d7, 0xeb115635, 0x6738e93a, 0xa2c696ae, 0x21233cc9,
    0x84d6b6a3, 0x4a9d2cf4, 0x0a570e8b, 0xb1d850fc, 0xafb7c085, 0xb12bd5e5,
    0x81782010, 0x33a21032, 0x1993b817, 0x2a7e7c1e, 0xfa244e16, 0xc5514521,
    0xaa5fc08e, 0x5c77d5d2, 0x80000000, 0x40000000, 0xe0000000, 0x50000000,
    0x58000000, 0x34000000, 0x5a000000, 0x5b000000, 0xd0800000, 0x19400000,
    0xf6a00000, 0xe3d00000, 0x41d80000, 0xb07c0000, 0xa52e0000, 0x70b10000,
    0x83ef8000, 0x55d34000, 0x34dbe000, 0x81fab000, 0x67ed2800, 0x17d54c00,
    0xbbdab600, 0x5b786b00, 0x7dad5980, 0x05f49140, 0x1b4e71a0, 0xb700dd50,
    0xfe834798, 0xf847f644, 0x2d23fe0e, 0x7214d709, 0x9a3927b8, 0xff0f064f,
    0x5c22b614, 0x51946b0d, 0x8ffb59a7, 0x76e9917c, 0x2457f1af, 0x161e9d4f,
    0xb699278a, 0x07df065a, 0x2d7ab623, 0xa8a86b2a, 0x84755981, 0xd188915e,
    0xbc6071b0, 0xa8b1dd51, 0xf7ecc794, 0xefd4b643, 0x3fd81e1f, 0x097e671c,
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0xfc000000,
    0x72000000, 0x31000000, 0x65800000, 0x27400000, 0x0e600000, 0x57100000,
    0xfda80000, 0x40cc0000, 0x2b5e0000, 0x08350000, 0x63da8000, 0x08f5c000,
    0x33ff2000, 0xb8023000, 0xe4047800, 0xc6037400, 0xcf07fe00, 0x0e80b500,
    0x8fc59980, 0x3ea59ac0, 0x4f37e1a0, 0xc15feed0, 0xcd349fb8, 0x985f9bcc,
    0x34b4a632, 0xbd1df133, 0x23d01f8e, 0x738f5bef, 0x8b39062f, 0x0c26012a,
    0x92f5479e, 0xdefb1fcc, 0xbf80000f, 0xaa400023, 0x79e00032, 0x31500017,
    0xbe48003e, 0xcc9c0026, 0xaa960001, 0x2ee90037, 0xd0ac800b, 0x674cc004,
    0x751ba00f, 0xefd2f00b, 0x4989d80e, 0x3638842f, 0x80000000, 0xc0000000,
    0xa0000000, 0x50000000, 0x18000000, 0xac000000, 0x1e000000, 0x9b000000,
    0x3f800000, 0x7a400000, 0x91a00000, 0xe7500000, 0x98180000, 0x84bc0000,
    0x136a0000, 0x8cb70000, 0x2ee98000, 0x5bf34000, 0x5fc92000, 0x03645000,
    0x1d35c800, 0xe7a81400, 0xb1d51600, 0x38d89300, 0x3bd8dd80, 0x685efb40,
    0xac1f15a0, 0xf6bdef70, 0x36698388, 0x78313c64, 0x7329fe0e, 0x1c14d70f,
    0x373803a9, 0xe72e7c59, 0x3e12de2e, 0x0a3b8723, 0xbfae4b84, 0x7dd22855,
    0xd6df682b, 0xe8d8041d, 0xe3d87e29, 0x645b9709, 0xe21b23a0, 0x75bd2c61,
    0xa5ee961b, 0x1c70d31a, 0x798a7d9a, 0xc4c2eb44, 0xd5607dba, 0xf235eb76,
    0xca29fd87, 0x1e96ab58, 0x80000000, 0x40000000, 0xe0000000, 0x70000000,
    0xe8000000, 0x74000000, 0x8a000000, 0xd7000000, 0xcf800000, 0x5bc00000,
    0x2e600000, 0x76d00000, 0xbdd80000, 0x9abc0000, 0xaeee0000, 0x28710000,
    0xe4ee8000, 0x5f77c000, 0xbb6d6000, 0x9cb3b000, 0x0908c800, 0x1460d400,
    0xe9d03a00, 0x9659c100, 0xd37a8380, 0xcb8c4740, 0x6f244ba0, 0x5ff19350,
    0xf32cf198, 0xf712924c, 0x7cbb9222, 0x2feba511, 0x2ef4f1a0, 0x5dae9274,
    0xda55920b, 0x039aa52e, 0xa81a71a2, 0xa1d95262, 0x24b8f20d, 0x13e91520,
    0x40f2b995, 0x98a98658, 0x5ed0c814, 0x69dcd420, 0x80be3a2d, 0xe1e8c10e,
    0x7bf403b3, 0x412b8758, 0x2c112bb4, 0xd53e2375, 0xb52a39b1, 0xe6134679,
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x58000000, 0x84000000,
    0xb2000000, 0x95000000, 0xd8800000, 0xb0400000, 0xb3a00000, 0x63d00000,
    0x0fc80000, 0xf76c0000, 0xf73e0000, 0x13370000, 0x283a8000, 0xaab64000,
    0x8afd6000, 0x88567000, 0x680e9800, 0x45083c00, 0x498c4e00, 0x03ce8b00,
    0xc96d0980, 0x1c39e9c0, 0x00b591a0, 0xbbfad5d0, 0xd2d55fa8, 0x15491edc,
    0xaa29b63e, 0x281bc73d, 0x2aa35fb2, 0x85521ec8, 0x548d362c, 0x574a8738,
    0x072cbfbe, 0x649e2edd, 0x40e0ce2f, 0x7ff3cb38, 0xd9dce9b6, 0xcfc2d9c8,
    0x0e62e9b4, 0x98b5d9ce, 0x5ff869bd, 0x70d399ed, 0xe84d09b9, 0xaea9e9f5,
    0xae5d91a9, 0xbe06d5f7, 0xab035f97, 0x33821ef5, 0x80000000, 0xc0000000,
    0xa0000000, 0x10000000, 0x68000000, 0x94000000, 0x26000000, 0x77000000,
    0x02800000, 0x91400000, 0xfea00000, 0x66100000, 0x41980000, 0x8dbc0000,
    0xc2ea0000, 0x21d70000, 0x687b8000, 0xd20ac000, 0x9fe56000, 0x80b5d000,
    0x6b8ba800, 0x06255c00, 0xe256c600, 0x24bbfb00, 0x8b6e4780, 0xa0142540,
    0x469e6fa0, 0x573bb970, 0xbfadc988, 0x05759274, 0xcb682612, 0xc014eb11,
    0xf6988fbb, 0x2f38a97c, 0x43a901b3, 0xb7721e6c, 0x9a6ec83e, 0xb5908c14,
    0x655d6e1d, 0x40dea73f, 0xdb18818c, 0x90ffde4a, 0x56482813, 0xfac39c16,
    0x8661a61a, 0x09752b25, 0x616c6f92, 0xdd10b94a, 0x491c498c, 0x11f8526e,
    0xebcec622, 0xed07fb0c, 0x80000000, 0xc0000000, 0xe0000000, 0xd0000000,
    0x28000000, 0xc4000000, 0xce000000, 0xf5000000, 0x6b800000, 0x80c00000,
    0x10a00000, 0x7d700000, 0x3c680000, 0x1f4c0000, 0xfefa0000, 0xc0350000,
    0xa50f8000, 0xdb1cc000, 0x1023e000, 0x8b301000, 0xe38e7800, 0xec594400,
    0x72459200, 0x31e68f00, 0x36173080, 0x1f39b9c0, 0x9d16c8a0, 0x89bc3df0,
    0x8250ba98, 0x2fdaa2c4, 0xf681f212, 0x0f465f35, 0x6e60a881, 0x60d5edf8,
    0xc69aa283, 0xa9e336dc, 0xca13f835, 0xdd3c8406, 0xb213f223, 0xf13f5f3d,
    0x5815288d, 0x1a3c2de4, 0xee96c290, 0x357fe6ec, 0xb0f66014, 0xada9d01f,
    0x9a6a182c, 0x0e499432, 0x6b7a0a29, 0x4df6db2e, 0x32295a96, 0x2cafb2eb,
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x08000000, 0x0c000000,
    0x32000000, 0xc5000000, 0x7e800000, 0x60c00000, 0xd2600000, 0x8db00000,
    0x06e80000, 0x060c0000, 0x897a0000, 0xb0f30000, 0xd9cb8000, 0x0c99c000,
    0xa106a000, 0x3086b000, 0x2fc25800, 0xfde08c00, 0xa5f6fa00, 0x4f4f9100,
    0xd05a4080, 0xd96515c0, 0x7c3398a0, 0x69ac59f0, 0x6c2bc2a8, 0x456978d4,
    0x6c49da2a, 0xbddfe117, 0x8c273886, 0xdf15e9d6, 0xe9381ab1, 0x155334da,
    0x8d9a000f, 0x0183001e, 0x17438020, 0xde25c01d, 0x6a14a019, 0x2fb9b03c,
    0xe193d806, 0x69fa4c07, 0x7733da17, 0x982ce118, 0x036cb8a0, 0x2f4c29d2,
    0xa05eba89, 0x616584fd, 0xe830582a, 0x5faf8c21, 0x80000000, 0xc0000000,
    0xa0000000, 0xf0000000, 0xa8000000, 0x24000000, 0x92000000, 0xc9000000,
    0xca800000, 0xf9c00000, 0x36a00000, 0xf2500000, 0xbce80000, 0x4ccc0000,
    0x315a0000, 0x40170000, 0x0d0c8000, 0x1bfbc000, 0xfc41e000, 0x96e3f000,
    0x4ab17800, 0x815e4c00, 0x8817b200, 0x790b9f00, 0xd1fa3180, 0xb9465cc0,
    0xea67c9a0, 0xe873d0f0, 0xb4799b88, 0x4907bfcc, 0x0a80d222, 0x59c4af05,
    0xc6a629a6, 0x5a5020c7, 0x98e8e39c, 0xdec9f3f5, 0xf85f6013, 0x8a93303c,
    0xf4ce1812, 0x2d5d7c24, 0x0e11aa20, 0x2a0ae304, 0x06799bb6, 0xb007bfc9,
    0xc800d22f, 0x7404af01, 0xca0629a4, 0x450020d0, 0x7c80e3a6, 0xa2c5f3e1,
    0x35256027, 0xc1143038, 0x80000000, 0x40000000, 0x60000000, 0x10000000,
    0xf8000000, 0xdc000000, 0x32000000, 0x53000000, 0xd2800000, 0x62c00000,
    0xe1e00000, 0x85100000, 0xf3a80000, 0x44cc0000, 0x7d1e0000, 0x86550000,
    0xf2098000, 0xdaf84000, 0x2647a000, 0x7e21b000, 0xb7766800, 0x85fadc00,
    0x1ec23a00, 0xe3e7fd00, 0x5e103980, 0x152836c0, 0x300fd1a0, 0x21faaad0,
    0xb0c24bb8, 0xe2e0e7d4, 0xcf921a06, 0x5d6b0d23, 0x6f2871aa, 0x770b1ae7,
    0x957c23a6, 0x87063beb, 0x94862038, 0x47c5f039, 0x9e67c816, 0xac526c1b,
    0x2d0bd229, 0xa27c6132, 0xdb8223a7, 0x87433bca, 0xdfa7a006, 0x7731b021,
    0xeede6804, 0x5e36dc3c, 0x7b5c3a3e, 0x8872fd01, 0xad79b992, 0x7b0076df,
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xb8000000, 0x54000000,
    0xf2000000, 0xb7000000, 0x3e800000, 0x56c00000, 0x11e00000, 0xe6500000,
    0x86e80000, 0xbb8c0000, 0xec1e0000, 0x9d950000, 0xd2898000, 0xe39a4000,
    0xc0d1e000, 0xb429f000, 0x906f0800, 0x41489c00, 0x3bfc9a00, 0x2ec37d00,
    0x65e36380, 0x645326c0, 0x99edeba0, 0x690dfad0, 0x1cde91b8, 0xc97277d4,
    0xbd5b7a16, 0x0d338d01, 0x3c7beb8a, 0xaf84fafc, 0x6d4111bd, 0xaea137fd,
    0x8ff51a0f, 0x9f993d15, 0x9ed2839c, 0xc52ad6d3, 0xfbeae3ac, 0x260966d8,
    0x165c0ba5, 0x7db40add, 0xa3b999a2, 0x81e6ebdf, 0x1e51e02f, 0xb2e9f03e,
    0x598f0805, 0xe3189c16, 0xf7149a25, 0x764f7d09, 0x80000000, 0xc0000000,
    0x60000000, 0x30000000, 0x88000000, 0xb4000000, 0x22000000, 0xdf000000,
    0x85800000, 0xc6c00000, 0xe2e00000, 0x51d00000, 0x04d80000, 0x51bc0000,
    0x01aa0000, 0x0e110000, 0xe6bc8000, 0xc02ac000, 0x02d26000, 0x5f5df000,
    0xbe7cc800, 0xabcc0400, 0x4b840200, 0xf7c53d00, 0xc6628780, 0x6b970b40,
    0xd07acfa0, 0xcacdcf70, 0xd706adb8, 0xf184027c, 0x84c4621a, 0x0de5cd11,
    0x5c50cfb2, 0x761ccf56, 0x915a2dab, 0x8f7ec25b, 0x8f4e0229, 0x71c43d2e,
    0x236607a2, 0x5d11cb50, 0xbd3aafb3, 0x2fed3f69, 0xa8b4e5a9, 0x1acfc65d,
    0xaf04803a, 0xad86c010, 0x22c0601d, 0x78e0f01b, 0xb2d24837, 0x175bc43c,
    0x6a78e224, 0xb9cf0d2c, 0x80000000, 0x40000000, 0x20000000, 0xf0000000,
    0x88000000, 0xec000000, 0x0a000000, 0x85000000, 0x07800000, 0xb2c00000,
    0xbbe00000, 0x09900000, 0x5a380000, 0x345c0000, 0xde0e0000, 0x76570000,
    0x6a5c8000, 0x550ec000, 0xc2d2a000, 0x28187000, 0xbaa99800, 0x23e18400,
    0xfd91a200, 0xe439c500, 0x2f5bbd80, 0x328e7640, 0xa016a5a0, 0xebfd3250,
    0xd73ba7a8, 0x9fdb876c, 0x46cd020a, 0xb8b6b517, 0xec4ea5a8, 0x51f13266,
    0x476da781, 0x7a808766, 0x91478205, 0xcf237523, 0xcd768593, 0x592c8264,
    0x37241f8f, 0xe970b358, 0x9f299810, 0x48218424, 0xe3f1a218, 0xc669c52b,
    0x4b03bd9c, 0xd4827642, 0x9240a5a3, 0x97a63276, 0x853127b0, 0x338e4777,
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xd8000000, 0x34000000,
    0xee000000, 0x4d000000, 0x79800000, 0xf8c00000, 0xe7600000, 0xe8700000,
    0x92b80000, 0x665c0000, 0x5dee0000, 0xd0b70000, 0x15db8000, 0xbe2b4000,
    0x0751e000, 0x5aeb1000, 0x92313800, 0xcd9a9400, 0x260c0200, 0x65836100,
    0x8ac76680, 0x98656940, 0xcef5dea0, 0x5cf8bd50, 0x977e3ca8, 0x70bbcc54,
    0x815de21e, 0x6f687119, 0xe0f65e85, 0x71fffd5a, 0xdef9dcb3, 0x407bdc70,
    0x8a395a34, 0x5d1ea503, 0xd1483cbd, 0x2320cc54, 0x02506227, 0x8f683119,
    0x90f23e9b, 0x99f8ad6b, 0x22fa84a2, 0x427d1854, 0x1d3b802e, 0x879b402e,
    0x1d09e03f, 0x45071026, 0xf5873829, 0x12c19433, 0x80000000, 0xc0000000,
    0x20000000, 0x50000000, 0xf8000000, 0xc4000000, 0x56000000, 0xa5000000,
    0x18800000, 0x98400000, 0x9e200000, 0x47500000, 0x0fc80000, 0xa36c0000,
    0xab7a0000, 0xa1130000, 0xc8ed8000, 0x4eb84000, 0x9ff16000, 0xd9dc5000,
    0x60063800, 0xb0041c00, 0x8801ce00, 0x6c06e700, 0x6a025180, 0x370579c0,
    0xeb81e9a0, 0x25c525f0, 0x1ee347a8, 0x413092e4, 0xd6b8ae16, 0xebf6b715,
    0x07de69a3, 0xa90265cc, 0xc285a78d, 0x274782ce, 0x19a2761c, 0x0896bb3a,
    0x2628ff94, 0x09dccefa, 0x58000005, 0x54000039, 0x8e000000, 0x31000008,
    0xb6800020, 0xf940000b, 0xd0a0003c, 0x7a100019, 0x89680032, 0x7c7c0027,
    0x3a92001f, 0x452f0010, 0x80000000, 0x40000000, 0xe0000000, 0xd0000000,
    0x58000000, 0xfc000000, 0x2a000000, 0xfd000000, 0x72800000, 0x92400000,
    0xc0e00000, 0xe8700000, 0x81680000, 0x4d0c0000, 0x343e0000, 0x44310000,
    0xa28b8000, 0x44ff4000, 0xae95a000, 0xa6197000, 0x5fe4d800, 0x63f36c00,
    0x87aace00, 0x40ad3100, 0x372fae80, 0x1befd3c0, 0xeb48f6a0, 0x9adfffd0,
    0x57419898, 0xde66bee4, 0xe8376e0e, 0x9088411b, 0xa5fd76a4, 0x2611bff4,
    0x915fb8a0, 0x11808ef4, 0x33c6163e, 0x3b225d05, 0x975360a2, 0x103fe2c6,
    0xd232d821, 0x958e6c28, 0x1b7f4e2b, 0x1653713c, 0x08b98eb4, 0x5d75e3c8,
    0xf7ef8eae, 0x3948e3e6, 0xabda0eb4, 0x87c6a3e3, 0x15242ea0, 0x8c5093ef,
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xb8000000, 0x6c000000,
    0x22000000, 0x83000000, 0x93800000, 0xdfc00000, 0xbaa00000, 0x58300000,
    0x65780000, 0xa75c0000, 0x172a0000, 0x01350000, 0x39fc8000, 0x991b4000,
    0xf9492000, 0xa422b000, 0x9572e800, 0x409ed400, 0x01895a00, 0x9b020700,
    0x6f868280, 0x15c72b40, 0x5da2eaa0, 0x3db7bf70, 0x77be1098, 0x2f7c485c,
    0x805b5a36, 0x92ab0707, 0xa3f0029e, 0x09d96b57, 0x626f4aa2, 0x48d24f7c,
    0xbd2fd89a, 0x96352c5d, 0x047c6825, 0x57dc940f, 0xeb6efa2c, 0xdc52f728,
    0xb76bca90, 0x86550f43, 0xb86cf897, 0x87d29c7e, 0x5caa001e, 0xc2f5000b,
    0xf95c803f, 0x9e2b4017, 0x95b1200a, 0x33beb007, 0x80000000, 0x40000000,
    0xa0000000, 0x90000000, 0xe8000000, 0x1c000000, 0xc2000000, 0x0f000000,
    0x38800000, 0x6f400000, 0x6b600000, 0x5cb00000, 0x23080000, 0xe3ec0000,
    0x6a9e0000, 0xe2b30000, 0x9e0b8000, 0x0c6ac000, 0x595d2000, 0xd092b000,
    0x78dd0800, 0x86556c00, 0xc17be600, 0x65415500, 0xa862cc80, 0xee354ac0,
    0xcf4a44a0, 0x9a09e6d0, 0x4a6f0288, 0x505cc3f4, 0x4113e632, 0x161d5533,
    0x6bf4cca2, 0x6c6a4ae0, 0x295fc4a4, 0x089026cf, 0x1cd9a2ac, 0xb054b3fb,
    0x107bce2e, 0x90c68907, 0xf0a422aa, 0xd29173f7, 0x97db6e11, 0x8ed1f90c,
    0xd6398aa7, 0xfa236fe4, 0x2ad52029, 0x003eb035, 0x1b230828, 0xa7566c3c,
    0xacf86605, 0xf987951c, 0x80000000, 0xc0000000, 0x20000000, 0x90000000,
    0x68000000, 0xc4000000, 0xc6000000, 0x6b000000, 0xa1800000, 0x32400000,
    0x55200000, 0xbff00000, 0xa5080000, 0x86ac0000, 0x009a0000, 0x8bf30000,
    0x7b0b8000, 0xf1aac000, 0x5b1be000, 0xb8b05000, 0xe6a8c800, 0x709aa400,
    0x53f42600, 0x470a6700, 0x9bac0c80, 0x321fdac0, 0xb43544a0, 0x1e6cbef0,
    0xb67902a8, 0x8b6049d4, 0x08d42632, 0x07fa6725, 0x11240ca3, 0xb9f3dacf,
    0xee0f44a3, 0xb72fbed7, 0x5ada82a4, 0x1ad689ed, 0x02fdc626, 0x3fa53727,
    0x7c35449f, 0x8a6cbee3, 0x38790294, 0xb46049e8, 0x0754262c, 0x9aba671d,
    0x23840cb7, 0x5f43dad9, 0xbfa7448c, 0xbc33bed4, 0xaa68828d, 0xa87989fc,
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x48000000, 0x4c000000,
    0x7a000000, 0xa1000000, 0x03800000, 0x15c00000, 0x49600000, 0x89700000,
    0x57d80000, 0x963c0000, 0x500e0000, 0x7cf70000, 0xf91c8000, 0xadd8c000,
    0x7739a000, 0x738cf000, 0x99343800, 0xf8780400, 0x68af1a00, 0x5ae08900,
    0x44b35680, 0xcabe9a40, 0x914deea0, 0xd8d55e50, 0x7e49d4a8, 0x6456e76c,
    0x2f0b9a3a, 0x5874493f, 0x5c5cf684, 0xeff96a47, 0x936b56ac, 0x1c829a6e,
    0xe143eea4, 0x54225e63, 0xcf5554bd, 0x858e277d, 0x22323a37, 0x8af8b90f,
    0xc6e8cebb, 0x02416e53, 0xb2a44c89, 0xcf121364, 0xf228b834, 0x08a0c40f,
    0x0e16ba28, 0x21ac7906, 0xa5676e8c, 0x43769e52, 0x80000000, 0xc0000000,
    0x60000000, 0xf0000000, 0x78000000, 0x4c000000, 0xbe000000, 0x2d000000,
    0x95800000, 0xcf400000, 0x7aa00000, 0xd9700000, 0x0f380000, 0xeb1c0000,
    0x39aa0000, 0xb0f10000, 0xa67a8000, 0x60bb4000, 0x435c2000, 0x698d5000,
    0x50407800, 0xdc217400, 0x3eb69e00, 0xa75ad300, 0xb38a5c80, 0x67453340,
    0x1ea2a4a0, 0xc3720770, 0x58389ab8, 0xd99fc44c, 0xbc6c1e26, 0x0391931f,
    0x726e7ca9, 0x96946364, 0xcbe8dcb4, 0x17d2735b, 0xe44c84ac, 0x17225742,
    0x9a30629e, 0xab98f060, 0xef6e201a, 0xdb105034, 0xd8a8f828, 0x5b773419,
    0x243a3e3d, 0x7f9dc333, 0x2d6c84ba, 0x50125741, 0xdc28629d, 0xc7b4f067,
    0xf0dc2035, 0xf7cd5033, 0x80000000, 0x40000000, 0x20000000, 0x90000000,
    0x18000000, 0x94000000, 0x0e000000, 0x13000000, 0x71800000, 0x03400000,
    0x31a00000, 0x20100000, 0x27480000, 0x726c0000, 0xffbe0000, 0x21970000,
    0xcc0f8000, 0x7fc94000, 0xcdaee000, 0x97db1000, 0x46e7c800, 0xefb42400,
    0xbc5aee00, 0x38a68b00, 0x0c961f80, 0x668f73c0, 0xa10857a0, 0xf54917d0,
    0x836dd9a8, 0xb73accf4, 0xc6556e2e, 0x106fcb11, 0x86b8ff8d, 0xe51463c5,
    0xb1cf9fb9, 0xbead33f1, 0x565f37bb, 0xcda047f8, 0x521571b7, 0x064bb8c5,
    0x02e92817, 0x1c7f3409, 0xebf52614, 0xb27eaf0e, 0x28f2f1aa, 0xfbfef8db,
    0x2fb1c82b, 0xdc5f2401, 0x88a36e23, 0x8494cb28, 0xea897fb2, 0x3b0a23ca,
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x78000000, 0x34000000,
    0x22000000, 0x6f000000, 0x43800000, 0xe8400000, 0x8f200000, 0x32b00000,
    0x38480000, 0x4dec0000, 0x799e0000, 0x5a330000, 0x89888000, 0xd18d4000,
    0x558be000, 0xaf887000, 0x048f4800, 0x1d0f3400, 0xae48c600, 0x40eed700,
    0xf51e2680, 0x01f2bac0, 0x96efeea0, 0x581fced0, 0x7d724888, 0xb52b29ec,
    0x737e4616, 0xd6e09721, 0xf2d546be, 0x2a5b8aea, 0x495546a6, 0xb61b8afc,
    0x447546b3, 0x1bab8ac1, 0x47bd46ab, 0x8a078ac4, 0x930346ad, 0x8d848af3,
    0x6143c6bc, 0xf9a5caf1, 0xc2762684, 0x3eaebac5, 0x7739ee95, 0xbfc0cec7,
    0xf564c882, 0x0a9569f5, 0x8d7d2608, 0xc7e5a72a, 0x80000000, 0xc0000000,
    0x20000000, 0x30000000, 0xd8000000, 0xe4000000, 0x3e000000, 0x13000000,
    0x8b800000, 0x19c00000, 0x56a00000, 0x27700000, 0x6a880000, 0xceac0000,
    0x4e9a0000, 0x37f30000, 0x14ce8000, 0x93ca4000, 0x1e4a6000, 0xe08b1000,
    0xebacc800, 0xfa197400, 0x97b76a00, 0x4aa8b700, 0xa09f4880, 0xecf78ec0,
    0x934f00a0, 0x880bbaf0, 0x81ee8aa8, 0x617d5dfc, 0x0063ea1e, 0xf051f705,
    0xb13ba8b1, 0x6606def1, 0x3701a8bb, 0x9585decb, 0x3ac72890, 0x05239ef7,
    0xdab748b3, 0x022b8ef9, 0xfadd008d, 0xaf94baf6, 0xe09a0abf, 0x0cf41ddd,
    0x834f0a37, 0x600ca71f, 0xbdef00a4, 0xbb7bbaef, 0x2d668abf, 0x68d15de8,
    0x2379ea2b, 0x2962f73a, 0x80000000, 0x40000000, 0x20000000, 0x10000000,
    0x78000000, 0x34000000, 0x86000000, 0x53000000, 0x0b800000, 0xc7c00000,
    0xd8e00000, 0x80f00000, 0x69180000, 0xab7c0000, 0x3ace0000, 0x68770000,
    0x8d5b8000, 0xd85e4000, 0xc0dce000, 0x2c995000, 0x23b88800, 0x03aab400,
    0xde411a00, 0x9a257500, 0x5891b680, 0x01ad9c40, 0x2344bea0, 0xaea26850,
    0x36d4c4a8, 0xb38b0d54, 0x17d49a36, 0x0d0c3519, 0xb896d6b7, 0x71aa8c5d,
    0x6b40d69d, 0xf2a18c78, 0xfcd556bd, 0x5288cc51, 0xc9523698, 0x924fdc62,
    0xac365eb5, 0xee7c385d, 0x5a4fcca2, 0xb033f97a, 0x047f603e, 0xab4b103b,
    0x16b26802, 0xaf38e41b, 0x39ec1210, 0xda668115, 0x95b7cc8b, 0xbcbff965,
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x18000000, 0x04000000,
    0x7a000000, 0x1f000000, 0x14800000, 0x85400000, 0xfd200000, 0xfe300000,
    0xd9980000, 0x21fc0000, 0xe2ea0000, 0xa5410000, 0x2d268000, 0xf6304000,
    0xb59b6000, 0x47ff3000, 0x83e90800, 0xd4c28c00, 0xa3e2f600, 0x9ad32700,
    0x33cf5280, 0x9d71e440, 0x85bd3aa0, 0xce4c5870, 0xc5b6c4b8, 0xf05df36c,
    0x4d9b603e, 0xf3ff302d, 0x81e90800, 0xbfc28c1a, 0xd562f61d, 0x04932727,
    0xa06f52a4, 0xf901e459, 0xb5853aac, 0x94c05866, 0x03e4c489, 0x8ad0f372,
    0x5bcfe03b, 0x81727031, 0xfbbee81e, 0xab4cfc1f, 0xce361e1b, 0x619edb3e,
    0x35ffcc81, 0xf0ef7f5b, 0xa6419628, 0x47a01712, 0x80000000, 0x40000000,
    0xa0000000, 0x70000000, 0x88000000, 0x6c000000, 0xa2000000, 0x4f000000,
    0x35800000, 0x33400000, 0x03a00000, 0x06100000, 0x98980000, 0x187c0000,
    0x75ce0000, 0x57430000, 0x8da48000, 0x4b12c000, 0x921ca000, 0x96be3000,
    0x292a0800, 0xf0f5c400, 0x5c2ece00, 0xfe76eb00, 0xccef1780, 0xb797d940,
    0xf5d9bfa0, 0xaedc2d50, 0x9d5d7988, 0x8f1f024c, 0x243ca02a, 0xe3ee3017,
    0x12120822, 0x9e99c414, 0x3978ce07, 0xdd49eb04, 0x968597a5, 0xe4c6195e,
    0xdfe19f8b, 0x4030dd5b, 0x25cbd1b3, 0xef44f65e, 0xc9a06632, 0xf5111f16,
    0xf71dd1b8, 0x803bf676, 0x8deae62a, 0x8f10df1f, 0x6c1df1b4, 0x53bb0664,
    0x4faa4e07, 0xdc342b2e, 0x80000000, 0x40000000, 0x20000000, 0x50000000,
    0x98000000, 0xc4000000, 0xb6000000, 0xc9000000, 0x8d800000, 0xed400000,
    0x51600000, 0xeeb00000, 0x9e880000, 0x0aac0000, 0xd97e0000, 0x33470000,
    0xd4618000, 0xa9374000, 0x98c86000, 0x314b5000, 0x5a0bd800, 0x2a689400,
    0x4558ce00, 0xdc90cd00, 0x3c59f480, 0xf911dac0, 0xfd1a4ca0, 0x12721ed0,
    0x30a95aa8, 0xba7a47c4, 0x25c0600e, 0x9ba75035, 0xc995d803, 0x83df9417,
    0x4b514e28, 0xb8fb8d38, 0x0407949a, 0xd6018af2, 0xb90614b0, 0x4586cad2,
    0xb14674ad, 0x23619af1, 0x91b3acaa, 0xda0e0ed1, 0x6a6ae286, 0x655983ed,
    0x8c937605, 0xa45f0910, 0x3d14e295, 0x4b1e83e6, 0xdb72f633, 0xbd284912,
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x58000000, 0x34000000,
    0x92000000, 0xc5000000, 0x12800000, 0x36c00000, 0xf1600000, 0xd2900000,
    0xbc080000, 0x2fac0000, 0x4e5e0000, 0x5dc10000, 0x78e18000, 0xe5d14000,
    0xf62fe000, 0x811bf000, 0x53e51800, 0x8c572c00, 0x516c8a00, 0x933ce900,
    0xc955c980, 0x03eccfc0, 0x45ff31a0, 0xa83013d0, 0x897ea398, 0xcdf7d6f4,
    0x1599e00e, 0x0226f039, 0x82b2980a, 0x5bbb6c18, 0x1694ea36, 0xa60b5931,
    0x66a8b19c, 0x6adc53c8, 0x6406c3b7, 0x6a0066e2, 0x81049818, 0x48866c1c,
    0x9fc36a0c, 0x45e7190c, 0xb350d182, 0x9aebe3f2, 0xd97bbbb7, 0x35f0fad6,
    0x519d6a1d, 0x5826192a, 0x2bb1518f, 0xef3aa3d1, 0x80000000, 0x40000000,
    0xe0000000, 0xf0000000, 0x58000000, 0x1c000000, 0x96000000, 0xcd000000,
    0x03800000, 0xccc00000, 0x31e00000, 0x29500000, 0xcab80000, 0xfb9c0000,
    0x7d2e0000, 0x07c10000, 0x17628000, 0x42124000, 0x4d9da000, 0xe02a9000,
    0x4c443800, 0x6fa7c400, 0xa1f09200, 0x23cab500, 0x72108380, 0xb598c040,
    0xec291ba0, 0x72459450, 0xe6a5b198, 0x2874e56c, 0xb40ba00e, 0x8d77902b,
    0x5388b80b, 0xdbb48408, 0x916fb233, 0x78626507, 0x1e911ba9, 0x25d9944a,
    0xb58bb19e, 0x0eb5e557, 0x6ee92039, 0xd2a5d019, 0xba751806, 0x130e1414,
    0x25f38a3a, 0x09c9a11d, 0x391789a0, 0xd31e2173, 0x676fb204, 0x05626502,
    0xa5111ba1, 0x05199476, 0x80000000, 0xc0000000, 0x60000000, 0x30000000,
    0xd8000000, 0x94000000, 0xbe000000, 0x29000000, 0x99800000, 0x29400000,
    0x86a00000, 0xd9d00000, 0x11980000, 0x827c0000, 0x8f0a0000, 0x14410000,
    0x61248000, 0xb9944000, 0x3ebbe000, 0xaaeb9000, 0x8c321800, 0xf1ed7400,
    0xd6b24e00, 0xb628f300, 0xf9d6d180, 0x819ca740, 0x0a7f29a0, 0xf30a4370,
    0xe6477fb8, 0x6223c47c, 0xb711e00e, 0xa77a9019, 0x9c8e9801, 0xfa053423,
    0xbf03ae3f, 0x9c826325, 0xaac049a8, 0xe0e59376, 0x7bf687a3, 0xc689206c,
    0x1503b63e, 0xcb82172f, 0x7a448791, 0x60242062, 0x0c15360d, 0x0dfb571e,
    0x6349e7a5, 0x7166f074, 0xeeb24e08, 0xd228f312, 0xffd6d1ba, 0x0c9ca761,
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xa8000000, 0xc4000000,
    0x72000000, 0xb3000000, 0x36800000, 0x9cc00000, 0xdfa00000, 0x1af00000,
    0x5be80000, 0xda8c0000, 0xc4da0000, 0xd7470000, 0x88e28000, 0x5211c000,
    0xa9fae000, 0x4374f000, 0x2fae2800, 0x3ceebc00, 0xc60b4a00, 0x2719ef00,
    0xb8626c80, 0x67d0a5c0, 0x97dea4a0, 0xb1c6e9f0, 0x2c21c688, 0xd1b6bafc,
    0xad0a6022, 0x1d9e300d, 0x02a4481e, 0xe1708c11, 0x64af023b, 0xf669633a,
    0x74cd6ea6, 0x55b9c6cd, 0x9113ca0c, 0x577f2f27, 0x8bb20cb8, 0x1a0995c9,
    0xf9186c8f, 0x1d67a5d6, 0xa05424ad, 0x269b29e1, 0x002126ac, 0x07b54ae1,
    0xfc0ec819, 0x001d4c31, 0xc4e7e211, 0x1416931f, 0x80000000, 0x40000000,
    0xe0000000, 0x50000000, 0x58000000, 0x4c000000, 0x56000000, 0x89000000,
    0x4a800000, 0xa9c00000, 0xc0e00000, 0x0f500000, 0x2b280000, 0xcc0c0000,
    0x86be0000, 0x5e410000, 0xc9a78000, 0x51774000, 0x631a2000, 0x49361000,
    0x9bbe9800, 0x4ec7ac00, 0x5f63d200, 0x0214dd00, 0xd70bd380, 0x473b54c0,
    0xce076ba0, 0x6506e8d0, 0xac842198, 0x28c499c4, 0x9e63a00e, 0xbc905017,
    0x34cb383b, 0x00dafc25, 0x4ed16a11, 0xfb68611b, 0x80af19b7, 0x2b4e65cb,
    0x4d9aca08, 0x52f4310a, 0x205a21a3, 0x901599f3, 0x5c0c202f, 0x7ebb1033,
    0xa2471826, 0x97a1ec27, 0xcc767208, 0x33998d2c, 0x3ff16b8c, 0x98dbe8e0,
    0xa2d5a1bc, 0x1d6ed9cb, 0x80000000, 0xc0000000, 0xa0000000, 0x50000000,
    0x78000000, 0x0c000000, 0x8a000000, 0x51000000, 0x43800000, 0x27c00000,
    0xaa600000, 0xd4900000, 0xc6980000, 0xa93c0000, 0x92ca0000, 0xb5470000,
    0x0e218000, 0xf9344000, 0xe8692000, 0xc333f000, 0xf168b800, 0x04b5c400,
    0x78ad2a00, 0x01d4b100, 0x38be2980, 0x780b5340, 0x0ea7b1a0, 0xf0716770,
    0x24482388, 0xef071264, 0xf482a016, 0x4f40b027, 0xb7201814, 0x6eb27403,
    0x19acb22c, 0xca52851e, 0x3b7bbb98, 0x2c6a2668, 0x0d34b22b, 0xae6e8526,
    0xb831bb97, 0xb3ed2666, 0x18f53228, 0xf90ac50a, 0xf5209b97, 0x7bb2d663,
    0x542f8a2b, 0x12940135, 0x7d9e31b8, 0x4bb92744, 0xde8b03b3, 0x4ce3e24f,
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x48000000, 0xf4000000,
    0x62000000, 0x35000000, 0x9f800000, 0x06400000, 0xcde00000, 0x51100000,
    0x13380000, 0x469c0000, 0x196a0000, 0x23c70000, 0x82a38000, 0x3577c000,
    0x036d6000, 0x7ac2f000, 0x63231800, 0x80334400, 0x4e0de600, 0x7314e100,
    0x463d7580, 0x691e6e40, 0x472b0da0, 0x5223da70, 0x45b7f388, 0x714f7f74,
    0xef76e01a, 0xfa693009, 0x8b447822, 0x9e66b434, 0x39557e2d, 0x25dc6531,
    0x630ff38c, 0x30937f58, 0x667ce030, 0xabfe3034, 0x00bff819, 0x4edd7409,
    0x9f8a1e30, 0x5e559529, 0x175d6bbe, 0xe6ccfb56, 0x7d35e63f, 0xe588e102,
    0xb7577590, 0xaed96e72, 0xef888dac, 0xa6541a7a, 0x80000000, 0xc0000000,
    0xa0000000, 0xb0000000, 0xf8000000, 0xac000000, 0x12000000, 0x65000000,
    0x23800000, 0xe5c00000, 0x29e00000, 0xc4b00000, 0xb5f80000, 0x1fdc0000,
    0x598a0000, 0x24470000, 0x31268000, 0x72d74000, 0xce8f2000, 0xb2c63000,
    0x1f60d800, 0x5af7a400, 0x65d89a00, 0x188cbd00, 0xe1c72480, 0xbfe15540,
    0xf7b0dca0, 0x057cc170, 0xfa9a9e88, 0x6d2cd85c, 0x7851a036, 0xcacd7037,
    0xf3e5f812, 0x35b6941e, 0x887ec232, 0x3d1c590b, 0xcee89e86, 0x8ab7d851,
    0x5afd200f, 0xe55d303f, 0xc5cc5819, 0xd967e413, 0x41f13a09, 0x915dcd39,
    0x0bc8dcad, 0xf660c160, 0x1b709e90, 0xbd1bd86f, 0x0eef202f, 0x2ab63011,
    0xeaf8d81d, 0x1d5ba43f, 0x80000000, 0xc0000000, 0x20000000, 0x10000000,
    0x78000000, 0x14000000, 0x3a000000, 0x6d000000, 0xff800000, 0xec400000,
    0x6c600000, 0xe5d00000, 0xd8180000, 0xcd3c0000, 0x6f0a0000, 0xa4830000,
    0xa0c78000, 0x60a24000, 0x8b73e000, 0x146ab000, 0x33d61800, 0x5b1b4400,
    0x45bef600, 0x01c97d00, 0xa323ef80, 0xd135ad40, 0x0b0c17a0, 0x16875970,
    0x91c379a8, 0xd9272074, 0x5c358036, 0xc48d4031, 0x92c66018, 0x91a7f01a,
    0x12f0782f, 0xd32cb425, 0x9b368e2a, 0xee09c919, 0xb5076192, 0x3b836471,
    0x8e46f616, 0x05657d13, 0x5851ef8d, 0x4d5aad46, 0x64d997af, 0x0b9a1941,
    0xef7d19a0, 0x646cd064, 0xbbd7f836, 0x071ef419, 0x03bd6e36, 0x3acf7901,
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x88000000, 0xc4000000,
    0xb6000000, 0x6f000000, 0x6b800000, 0x07400000, 0xeae00000, 0x06100000,
    0x4e480000, 0xf4ec0000, 0x9f9a0000, 0x32810000, 0xc3c28000, 0xe620c000,
    0x1bb5e000, 0x2abfd000, 0x78b4e800, 0x933b9400, 0x36f71e00, 0x055db100,
    0x10241d80, 0xd4b2b5c0, 0xd13f15a0, 0x07f7f1f0, 0x35de63b8, 0x42e114cc,
    0x9210801a, 0xe04dc03d, 0x27ed6017, 0x0e1e1016, 0x28c38815, 0x9ba4842b,
    0xe3f6160d, 0xd3d9f51b, 0x35e7ebb3, 0x459490fd, 0x1d0c162e, 0xd008f500,
    0xba8d6b9c, 0x654850f4, 0xe96bf613, 0x97da253e, 0x43e1039d, 0x4a9204f0,
    0x868b880d, 0x5f48842f, 0x946c1618, 0xd558f536, 0x80000000, 0xc0000000,
    0x20000000, 0xd0000000, 0x98000000, 0xf4000000, 0x16000000, 0x6f000000,
    0x51800000, 0xc2400000, 0x42a00000, 0x45900000, 0xa6d80000, 0xa13c0000,
    0x8b8a0000, 0xf0830000, 0xe8c18000, 0x37634000, 0xe275e000, 0x9c6bd000,
    0x62306800, 0xb7cf4400, 0xa122e600, 0xa6d60b00, 0x0efbeb80, 0xb1682f40,
    0x5ab463a0, 0xf30fbb70, 0x54476da8, 0xeda5b444, 0x3413800e, 0xb49c4039,
    0x7b9e602b, 0x3a1b9012, 0x405c0837, 0x26fbd416, 0xed6d6e01, 0xd0b19f3a,
    0x3608e5ad, 0x10c22049, 0xf3608e3b, 0x9c764f35, 0x4f6a8db9, 0x49b2646d,
    0xf889e826, 0xcb00041b, 0x1f850617, 0x7942db28, 0xd52003ba, 0x70d72b6e,
    0x41fae586, 0x30ed2052, 0x80000000, 0x40000000, 0xe0000000, 0x90000000,
    0x88000000, 0xdc000000, 0xea000000, 0x5b000000, 0xe3800000, 0x48400000,
    0x45a00000, 0x39100000, 0x8b380000, 0xf1dc0000, 0xdcee0000, 0xc9810000,
    0xb3418000, 0xd627c000, 0x69562000, 0x9a9df000, 0xfecf6800, 0xe6d49400,
    0x80da8600, 0xc468f300, 0x12476780, 0xa6a01c40, 0xfe902fa0, 0xed787850,
    0x517c4198, 0x6b7fdf74, 0x5879803a, 0xf7fbc003, 0xddb82020, 0x1f1cf005,
    0x2f8ee820, 0xb7f35433, 0xe00ca613, 0x4db5030a, 0x4aa80f8b, 0x31248860,
    0xb0d2a9a4, 0xe1dc8b50, 0x14ed2621, 0xf582c30f, 0xc9462f9b, 0x05257872,
    0x56d3c1b1, 0x38d91f5b, 0xe06e201f, 0x3c41f01e, 0x43a16828, 0x7015942e,
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0xc8000000, 0x4c000000,
    0xf6000000, 0x25000000, 0x00800000, 0x45400000, 0x59a00000, 0xb9500000,
    0x8ba80000, 0x744c0000, 0x993a0000, 0xf2030000, 0x5f048000, 0xf384c000,
    0x10c7a000, 0xd4639000, 0xe9b4f800, 0x9d5e9c00, 0x63b70600, 0x665ee300,
    0x5a302d80, 0x6d9edac0, 0xe7d175a0, 0x37ecd6f0, 0x436c0ba8, 0xb42b69ec,
    0x5288001a, 0x485c003f, 0x6b320007, 0x4f1f0006, 0x8596800f, 0x39cbc00b,
    0x20f9202b, 0xf0e45036, 0xa6f7d834, 0xfff9cc22, 0xc3645e12, 0x9633ef0f,
    0x5b9bd393, 0xe2d2a5dd, 0x476c5e15, 0xce2fef05, 0xa189d3a1, 0x1ddda5f2,
    0xe6f2de34, 0x1ff82f28, 0x9362f381, 0x2e36f5f0, 0x80000000, 0xc0000000,
    0xe0000000, 0x30000000, 0x98000000, 0x5c000000, 0xae000000, 0xeb000000,
    0x68800000, 0x72400000, 0xff200000, 0xb4d00000, 0x38680000, 0x280c0000,
    0x9c7a0000, 0x74050000, 0xaa008000, 0xf9024000, 0x1d87a000, 0x69c35000,
    0xb9e0c800, 0x97b16c00, 0x989f8e00, 0xcc332f00, 0xfe5fcd80, 0x3f509cc0,
    0xf6aaa5a0, 0x1f6ba0f0, 0x668f6398, 0x113ea3fc, 0xb9a0003e, 0xed90002b,
    0x4fc80035, 0xde9c0021, 0xc3320017, 0xb4d90031, 0xa012800e, 0x4e0b400b,
    0x437d202b, 0x9684103b, 0xf147e816, 0xb3a07c3a, 0x0490e603, 0x1a4d1329,
    0x435a8b8a, 0x10d7dff9, 0x3a6a6623, 0x150a5331, 0x73fdabb7, 0x58c6cfc0,
    0x90650e31, 0x74746f3e, 0x80000000, 0xc0000000, 0x60000000, 0x50000000,
    0x28000000, 0xac000000, 0x2e000000, 0x3d000000, 0xaf800000, 0xc5c00000,
    0x07600000, 0x7d900000, 0x5ae80000, 0x434c0000, 0x973a0000, 0xbc010000,
    0xa6078000, 0xa100c000, 0xf986a000, 0x7cc55000, 0x2ae5f800, 0xab55e400,
    0xcf0aba00, 0x549f6900, 0x0f77f980, 0x85bc00c0, 0x1646a1a0, 0x04a1b4f0,
    0x8bf463b8, 0xf6faf9e4, 0xc9600032, 0xd090000f, 0xbd680019, 0x7a8c0030,
    0x965a002a, 0x50910015, 0x7d6f8021, 0x1a8cc021, 0xc65ca03c, 0x7894503e,
    0xd16a7832, 0x34892420, 0xfb5e1a1a, 0xd7173917, 0x14af81b2, 0x33e824d8,
    0x86cd3bbd, 0x8dfb4ded, 0x57e0c23f, 0xa4d64d04, 0x3ac9e3a8, 0x2bfb39e1,
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0x04000000,
    0x36000000, 0xe7000000, 0xc0800000, 0x40400000, 0x9da00000, 0xa8d00000,
    0x38780000, 0xf09c0000, 0xf46e0000, 0x13050000, 0x9e828000, 0xc341c000,
    0x1b22e000, 0x2790d000, 0x615ea800, 0x2e0c8c00, 0xb6b53e00, 0x8bc9eb00,
    0x12d72980, 0xbd78a840, 0xd91d61a0, 0xcfadf450, 0x146277b8, 0x3eb0534c,
    0xdfce0032, 0x1cd5000d, 0x067a801f, 0x039dc024, 0x5aece037, 0x9845d028,
    0xf1a4281a, 0xfad14c03, 0x9979de19, 0xff1c3b06, 0x70ab0194, 0xf8e5e452,
    0x4cf2bfb4, 0x9368cf58, 0x9385f624, 0xbec17731, 0x2ee4dfab, 0x9bf0df6f,
    0x1bed3e14, 0xa7c5eb08, 0x3d612994, 0x6531a873, 0x80000000, 0xc0000000,
    0x20000000, 0x10000000, 0xd8000000, 0x4c000000, 0xae000000, 0xfd000000,
    0x41800000, 0xab400000, 0xd9e00000, 0xf8f00000, 0x52d80000, 0x4f7c0000,
    0x54ea0000, 0x4d030000, 0x49878000, 0x1f474000, 0x2be42000, 0x73f1d000,
    0xa258f800, 0x0bbc9400, 0xdb4abe00, 0x2d929900, 0x48ebd280, 0xdb00de40,
    0xc8850aa0, 0x38c29a70, 0xe9a2cca8, 0x0994d774, 0xa2ea001e, 0x3c030027,
    0x86078015, 0x59074028, 0x6b84200d, 0x6c41d006, 0x8760f80d, 0x4130942b,
    0x9cf8be32, 0x84ad9907, 0x8c6652b7, 0x71b49e7e, 0xf83eaab3, 0x1b080a77,
    0x34f414a5, 0x3cda937c, 0x927fc62e, 0x056a4d3e, 0x3e42cc81, 0xdc64d77d,
    0x49b20021, 0x843f0009, 0x80000000, 0xc0000000, 0xe0000000, 0xb0000000,
    0xa8000000, 0x44000000, 0x16000000, 0x51000000, 0x5f800000, 0xa0400000,
    0xe3a00000, 0xbbd00000, 0xe2980000, 0x9efc0000, 0x16ca0000, 0xe4250000,
    0xd7948000, 0x033fc000, 0x7a2ee000, 0x16d5d000, 0xd7191800, 0xc5be4400,
    0xb1efb600, 0x0b328300, 0x2a69d180, 0x7d742f40, 0x78caa9a0, 0x29207b70,
    0x9212e798, 0x10796c5c, 0x290d9832, 0x47c1840d, 0x3fe15617, 0xf2775329,
    0x4248c9b8, 0x88e66b6d, 0x74f71f8a, 0xa98bf862, 0xc505b60f, 0x9187833d,
    0xfd455197, 0x5e27ef4d, 0xf4964987, 0x4bbcab6b, 0xcced7fa4, 0xe6b1e85c,
    0x7d2a4e03, 0x3850173f, 0x78d9ff90, 0x9e5e2856, 0x059cae36, 0x0079c72f,
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x78000000, 0x7c000000,
    0x52000000, 0xd5000000, 0x1b800000, 0xe8c00000, 0xf4200000, 0x03100000,
    0xbca80000, 0xcbcc0000, 0x5c3a0000, 0x23a10000, 0x51d78000, 0xf98a4000,
    0xad5ea000, 0xf750b000, 0xaecad800, 0xafb96400, 0xaf627200, 0xdbf51b00,
    0x05980f80, 0xa37324c0, 0x9ddbf7a0, 0x3b10b0f0, 0x60adfdb8, 0xa9cc7fe4,
    0xa13d5826, 0x3c23243b, 0x9714d212, 0x8aa9ab3e, 0x60c8d78c, 0xb8bb40d0,
    0x79e6058f, 0x04b3ebff, 0x3379522c, 0xfd42eb2c, 0x6be1f783, 0x71b1b0f1,
    0x18fa7d86, 0x3d863fde, 0x9bc3f802, 0x5ca39420, 0x23560a29, 0x38cccf19,
    0x34b8a5b3, 0x63e35bf8, 0x85b38a0b, 0x7efb8f30, 0x80000000, 0x40000000,
    0xe0000000, 0xf0000000, 0x38000000, 0x6c000000, 0x82000000, 0xdf000000,
    0x38800000, 0x13c00000, 0xea600000, 0x38f00000, 0xaa280000, 0x630c0000,
    0x565e0000, 0xd0e10000, 0xb4328000, 0x98c94000, 0xb8392000, 0x2e10b000,
    0xe71c8800, 0xca47ac00, 0xf423e200, 0x62d3a900, 0x75fefa80, 0x0174edc0,
    0x4469d2a0, 0x012ab1d0, 0xe58f9898, 0x309e04ec, 0x79060816, 0x7182ec37,
    0xfa44c216, 0x6c221910, 0x1ed0f2a0, 0x3ffa01e8, 0x8a7310b4, 0x92e9a8ed,
    0x4fedea06, 0xe86d453e, 0x232c38b3, 0x2a8bf4c5, 0xc01da01c, 0x3ec4f036,
    0x75e12800, 0x9fb35c16, 0x218aca00, 0x569cf50e, 0x9002309a, 0x880518c0,
    0xb4076208, 0x1e07e912, 0x80000000, 0xc0000000, 0xe0000000, 0x70000000,
    0xb8000000, 0xdc000000, 0x66000000, 0xa7000000, 0xf7800000, 0x06400000,
    0xc6200000, 0xd7700000, 0x18f80000, 0x731c0000, 0xc20a0000, 0x8ca50000,
    0xb7b28000, 0xa0194000, 0x878ca000, 0xcfe21000, 0xeb11e800, 0xffad3400,
    0xd390f600, 0x3a6c9f00, 0x81f66880, 0xfe3bc540, 0x1cf9a0a0, 0x791da170,
    0x5b0c1e98, 0x70221a6c, 0x98716836, 0x1b7d741b, 0x075cd60f, 0xa12ecf02,
    0xb153a08a, 0x9f88a15f, 0x43e69eb5, 0xa5175a6d, 0x4cafc812, 0x26166404,
    0x212dbe11, 0x7153bb21, 0x7f8f76ac, 0x33e66e49, 0x1d153e38, 0x90affb20,
    0x40115682, 0x862d3e4c, 0x86d07616, 0x79ccdf2c, 0xf5c248b9, 0xca659544,
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xd8000000, 0x3c000000,
    0xbe000000, 0xc1000000, 0xa8800000, 0x67c00000, 0x79e00000, 0xc0d00000,
    0x1e380000, 0x049c0000, 0x8c6e0000, 0x6e650000, 0xee928000, 0xb89e4000,
    0x7268a000, 0xcf64d000, 0x36131800, 0x075e3c00, 0x37893200, 0xb1b49500,
    0xe92be780, 0xab424040, 0xdc22dfa0, 0xa636ec50, 0xc76855b8, 0x0de4954c,
    0xaad7980e, 0xe5397c03, 0x9f1d1201, 0xe42b0523, 0x25c2dfb3, 0x26e6ec66,
    0xb95055bb, 0x79789549, 0xfeb9980b, 0xb75c7c24, 0xcf8f9214, 0x9db54539,
    0xff2a7f86, 0x8e423c4b, 0xf6a34da1, 0xbef6a97f, 0xd708aa26, 0x0274e939,
    0xaaca75ab, 0x5892057c, 0xcd9a2027, 0x90ea9032, 0x80000000, 0x40000000,
    0xe0000000, 0xf0000000, 0x98000000, 0x1c000000, 0xba000000, 0x29000000,
    0xd8800000, 0x89c00000, 0x32200000, 0xc6100000, 0x7c180000, 0xeb7c0000,
    0xe88e0000, 0x0fa10000, 0xe5528000, 0x7afc4000, 0x09cfa000, 0xcc47f000,
    0xfd617800, 0xe2f2dc00, 0xaba88200, 0xad333b00, 0xba8cdf80, 0xe2a3d940,
    0x7bd087a0, 0x903ab550, 0x526edd98, 0x4710a26c, 0x809df83e, 0xd4bf9c2b,
    0x21ada230, 0xbc348b31, 0x6e0c07be, 0xb967f56f, 0xe4f3fdb4, 0x28ab1249,
    0x34b3203d, 0x6fcab005, 0xff445837, 0x1ce56c33, 0xdbb05a14, 0x944b172a,
    0xff01a599, 0x93837e46, 0x8447fa1e, 0x2960e716, 0xccf6ddbc, 0x4caca257,
    0x62b3f818, 0x64ce9c05, 0x80000000, 0x40000000, 0xe0000000, 0xb0000000,
    0x68000000, 0x3c000000, 0x6a000000, 0x45000000, 0xd8800000, 0x0ec00000,
    0x8ba00000, 0xd1f00000, 0xc2b80000, 0x755c0000, 0x24ce0000, 0x84a10000,
    0x5c708000, 0x2cf9c000, 0x143b2000, 0x409ff000, 0x84e99800, 0x1c133c00,
    0xee2f5a00, 0xe9b6cf00, 0xccdcd480, 0x6c8c1f40, 0x42c6eca0, 0x29a51350,
    0xf8f50e98, 0xa83e107c, 0x6a9f9802, 0x21ee3c33, 0x7491da38, 0x88ee0f32,
    0x5e1774b6, 0x772a2f5d, 0xeb3454ae, 0xef19df76, 0x03abccbc, 0xf7f7e356,
    0x25ba1699, 0x84d9ec7b, 0x408d6236, 0x10c3c315, 0x88a13695, 0x1e761c4b,
    0xb5fcfa07, 0x16bcff25, 0x63586c99, 0xebcdd37a, 0xa926aebe, 0xe2342072,
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xb8000000, 0x14000000,
    0xe6000000, 0xc9000000, 0x70800000, 0x1b400000, 0xede00000, 0xf3900000,
    0xc3c80000, 0x83ec0000, 0xdfde0000, 0x1ae10000, 0x2e148000, 0x160b4000,
    0x9848e000, 0xef2c5000, 0xecf8d800, 0x15527c00, 0x6bec5600, 0x03dbd100,
    0xb0e5f980, 0x2517f5c0, 0xf18941a0, 0x2e8e99d0, 0x8f0b2f98, 0x20ca64dc,
    0xb86ed836, 0xc31f7c19, 0x71c6d62f, 0x05a1913b, 0x0df1998b, 0x509ce5f1,
    0x510779be, 0xf481b5d8, 0x9543218f, 0xb8e489c6, 0xc911978a, 0xe38e08c3,
    0x318e3603, 0x8e8dc108, 0x5f0941a9, 0xa8ce99c5, 0x146b2f86, 0x311a64e6,
    0x5ec6d831, 0xbc237c0a, 0x6630d63b, 0xa63c9119, 0x80000000, 0x40000000,
    0x20000000, 0xb0000000, 0x88000000, 0x04000000, 0x4e000000, 0x8f000000,
    0xb4800000, 0xa4c00000, 0x8a200000, 0x01700000, 0x99d80000, 0x05bc0000,
    0xc12e0000, 0xb9270000, 0x37f68000, 0xd818c000, 0x4a1de000, 0xd7181000,
    0xbe992800, 0x53d92c00, 0x84ba3a00, 0xdaaa3300, 0x1965ec80, 0x91147c40,
    0x574fa4a0, 0x9cb18050, 0xc47f56a8, 0xce8d8f7c, 0x8f17280a, 0x804e2c3d,
    0x3434ba39, 0x12bef30e, 0x09ae0c9c, 0xffe76c4b, 0xc8d60cbc, 0x24eb6c5a,
    0x48800c81, 0x06c06c54, 0xdf208cbe, 0x4cf3ac52, 0x8a9dec82, 0xd5d87c47,
    0x2fb9a49b, 0x902a805a, 0xbaa7d6a6, 0xabb24f60, 0xbcfc482c, 0x004efc21,
    0x74307228, 0x32bfcf0e, 0x80000000, 0x40000000, 0x20000000, 0x90000000,
    0xd8000000, 0xe4000000, 0xaa000000, 0xe3000000, 0x82800000, 0x1dc00000,
    0xeb200000, 0xf7d00000, 0xdab80000, 0xb8dc0000, 0x54ee0000, 0x79270000,
    0x00d78000, 0x9a3b4000, 0xea196000, 0xab4ab000, 0x3e326800, 0xfac9dc00,
    0xa974a200, 0x102cc300, 0x6b81b980, 0xac45da40, 0x8c6531a0, 0x7531f650,
    0xb44c9ba8, 0x92b55974, 0x1e0a681e, 0x6bd5dc0d, 0x44baa214, 0x09dbc325,
    0x416e39bc, 0x94629a46, 0xf1325190, 0xae4c4652, 0x39b17384, 0xa08bc560,
    0x3811aa07, 0xe698af00, 0x9f88f3b7, 0x04978573, 0xda5f4a33, 0xb9295f04,
    0xfa03fb8d, 0x5b04e954, 0xd6818025, 0xffc0402d, 0x3420e004, 0x3b56f000,
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x78000000, 0x1c000000,
    0xd6000000, 0x11000000, 0x9d800000, 0x0c400000, 0xc6e00000, 0x38900000,
    0xf3680000, 0xb64c0000, 0xcf7a0000, 0x70e50000, 0x99928000, 0xf6ef4000,
    0xd60ca000, 0xa79f9000, 0x4573d800, 0x21785400, 0x5de74600, 0x42141900,
    0xe3ad0180, 0xe96930c0, 0x5948f9a0, 0xb7fdb4f0, 0x2322c798, 0xf03769ec,
    0x4e1bd806, 0x4b34542b, 0xa49d4613, 0x53f1191f, 0x9fbf818c, 0x0fc670c0,
    0x9fa45983, 0x39f224f9, 0x08b91fb2, 0x6b433dcc, 0x1a669e38, 0x41554d14,
    0x2dcac7ba, 0xfa3b69d3, 0xdf81d80c, 0x6f415438, 0x6067c619, 0x1e525909,
    0xcd492187, 0xc5fce0d6, 0x18250195, 0xdab530e9, 0x80000000, 0xc0000000,
    0x20000000, 0x70000000, 0xe8000000, 0x0c000000, 0x5e000000, 0xed000000,
    0x4e800000, 0xc0400000, 0x68e00000, 0xc7f00000, 0x63d80000, 0x58fc0000,
    0x712a0000, 0x21a30000, 0x73948000, 0xf76dc000, 0x8040a000, 0x88e3d000,
    0x97f4f800, 0xfbdc6c00, 0xbcf85e00, 0x232d5100, 0x92a28a80, 0xd0158e40,
    0x79a852a0, 0x28e4f270, 0x27f0d4a8, 0x33dbdf6c, 0xc0fe5812, 0x952cbc2f,
    0x73a02625, 0xc090fd24, 0x54e874be, 0x0e840f48, 0x2040a03e, 0x38e3d00a,
    0x5ff4f819, 0x87dc6c0b, 0x0af85e24, 0xc22d512c, 0x82228a8f, 0xfd558e58,
    0x5fc85293, 0x2f54f257, 0x2cc8d4ab, 0xacd7df7c, 0xd20c5820, 0xec73bc2d,
    0x711ea617, 0x165e3d2e, 0x80000000, 0x40000000, 0x60000000, 0xf0000000,
    0xc8000000, 0x9c000000, 0x7e000000, 0x0f000000, 0x37800000, 0xd6400000,
    0x6e200000, 0x5e100000, 0xefb80000, 0x475c0000, 0xbaae0000, 0x65650000,
    0x9eb68000, 0x536ac000, 0x61012000, 0x40835000, 0xd5c46800, 0xaa65b400,
    0x89313600, 0x15289f00, 0x3720c380, 0x4a948440, 0xd87d0ba0, 0x9c3da050,
    0x0b1ff5b8, 0x91891b6c, 0x11f3480a, 0x29cfe40b, 0x08d5de35, 0x745eeb18,
    0x232855a0, 0xe4208b51, 0x63160029, 0xf1390031, 0x0d988035, 0x1f4fc00f,
    0x6e17a03c, 0x07b99038, 0x4b5d482d, 0xfcaae41f, 0x3e635e1c, 0x4b342b28,
    0xf4297591, 0x37a3db79, 0xff526814, 0x821cb43e, 0xdd09b62c, 0x82375f18,
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x18000000, 0x8c000000,
    0x52000000, 0xd7000000, 0x31800000, 0xdfc00000, 0x80200000, 0x5cb00000,
    0x93180000, 0xa27c0000, 0x44ae0000, 0xeae10000, 0x92158000, 0x45ef4000,
    0xb8802000, 0x2b443000, 0x59674800, 0x22d52400, 0x88490a00, 0x61f31300,
    0x7b788a80, 0x482fc440, 0xafa462a0, 0xa6709050, 0x05bf8098, 0x188dd754,
    0x1c51681e, 0x4a0c1437, 0x9c15c22a, 0x78e87712, 0x2204209e, 0x9f07a761,
    0x45838018, 0x11c24005, 0x1d23a030, 0x3636700c, 0x2f5ce813, 0x2a9f5426,
    0xa9bbe205, 0xfa8d4736, 0x2356e897, 0xff8dc356, 0x85d2aa1c, 0xf1c96314,
    0xca326286, 0x355d9076, 0x899c009d, 0x563f974b, 0x80000000, 0xc0000000,
    0xa0000000, 0x10000000, 0x08000000, 0x7c000000, 0x32000000, 0xf7000000,
    0x38800000, 0xd2400000, 0x31a00000, 0x72100000, 0xd9c80000, 0xc9ac0000,
    0x32da0000, 0x3de70000, 0x4eb38000, 0xb85dc000, 0xd8a72000, 0xe7943000,
    0x0808c800, 0x38cb6c00, 0x202aae00, 0xd11a3b00, 0x3b829f80, 0x64c0abc0,
    0x86e4f7a0, 0x9c3537f0, 0x491a3188, 0x8f8190f4, 0x8ac7e80a, 0x53e35c2b,
    0x5bb06626, 0xdfda5726, 0x5e61b180, 0x3e7050d6, 0xc0bac82e, 0x99906c25,
    0x150b2e1c, 0x234cfb1e, 0x94ec3fb4, 0xfffe5bfe, 0xcbb09f85, 0x17dbabde,
    0x826577af, 0x1c73f7d8, 0x3fbc91a1, 0xdd1360ee, 0xf549800c, 0xe5eac027,
    0xde7ca020, 0xf475f03e, 0x80000000, 0x40000000, 0x60000000, 0x50000000,
    0x98000000, 0xa4000000, 0x62000000, 0xf3000000, 0x70800000, 0xf3400000,
    0x1e200000, 0x0af00000, 0x20880000, 0xcc6c0000, 0xb87e0000, 0xf7e50000,
    0x08938000, 0xb2dd4000, 0x4c576000, 0xf538f000, 0xccc6a800, 0x1be78c00,
    0x16944600, 0xe7db4f00, 0xfdd4ec80, 0x1df91ac0, 0xf520a4a0, 0x9e7226d0,
    0xd1c8aab8, 0x714e55c4, 0x5a0a481e, 0x802e3c2d, 0xb8db8e26, 0xf3513301,
    0xebbd82a2, 0xc28499e9, 0xd8416e23, 0xaaa18312, 0xcbb7ca8b, 0x55aaa5d9,
    0x121ae027, 0x09b0b035, 0xd6aa4824, 0xca9e3c0a, 0x96f38e05, 0x968d3339,
    0xf56b82bd, 0x57fd99e9, 0x2a24ee11, 0xd0f5c31d, 0x478d2ab8, 0x16ea15d3,
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x78000000, 0x3c000000,
    0xd2000000, 0x8d000000, 0x29800000, 0x12c00000, 0xd1600000, 0xdc300000,
    0xa3180000, 0x863c0000, 0x552e0000, 0xd4270000, 0x08908000, 0x6ec94000,
    0x5c55a000, 0x94aeb000, 0x92e61800, 0x1ff23400, 0xd9ff7200, 0xcdc93100,
    0x4ad3ac80, 0x72ebfa40, 0x70c694a0, 0x44653e50, 0x99b4dea8, 0x6bdecb4c,
    0x9e5b3836, 0x4e99c403, 0x3afaca22, 0xfb4eb530, 0xdc9446a0, 0xe8cebf68,
    0x17576a2a, 0xd62c0500, 0xb2a45e9e, 0x96d78b4e, 0xb0ee9837, 0xd5c7743c,
    0x59e4d203, 0x1d708130, 0xd9bd3494, 0x34ec8e40, 0x5bc24691, 0x56e5bf7d,
    0xb1f1ea0f, 0xa6fe4538, 0x194f7eb7, 0x09977b79, 0x80000000, 0x40000000,
    0xe0000000, 0x50000000, 0x68000000, 0x6c000000, 0x5e000000, 0xc7000000,
    0xde800000, 0xd2400000, 0x77e00000, 0x48500000, 0x45080000, 0x4f2c0000,
    0x975e0000, 0x5f210000, 0x2ff78000, 0x3bbec000, 0x0ff6a000, 0xcbb8d000,
    0xd7f4a800, 0x9fbabc00, 0x8df61e00, 0x6ab83900, 0xca75df80, 0xa17e0dc0,
    0xb15657a0, 0x4c8fa1d0, 0xcbebc198, 0x0efa34c4, 0x56958802, 0x89acac1f,
    0xb11c1635, 0xc2c6553e, 0xaaa169ba, 0x3d3188de, 0xb91c161d, 0xbec65507,
    0x7ca16983, 0xc63188e1, 0x519c1613, 0xc786551d, 0x8bc16990, 0x9b2188ef,
    0xbdf41620, 0x12ba5514, 0x2e77698f, 0xc37c88ec, 0x40559609, 0x39099523,
    0x992849b3, 0x6c5b98f5, 0x80000000, 0xc0000000, 0xa0000000, 0xf0000000,
    0xb8000000, 0x7c000000, 0x3e000000, 0x51000000, 0x2a800000, 0x08400000,
    0x62200000, 0xa4f00000, 0xf3b80000, 0x845c0000, 0xdd4a0000, 0x1ce70000,
    0xc0948000, 0x7c6f4000, 0x7595a000, 0x24e9d000, 0x0ad19800, 0xb14bac00,
    0x0ae75e00, 0x05906700, 0x5cef4480, 0xd6d34340, 0x7f4dfca0, 0xe3e57f70,
    0x53101a88, 0x6aaf244c, 0xe5f0b826, 0xf13d3c13, 0x181b6609, 0xb56e1b37,
    0x131382ab, 0x0aaf8849, 0xb5f1663d, 0xb9391b0f, 0xdc1f0286, 0xf76cc876,
    0x7c16c61d, 0x712bcb20, 0x97301a9c, 0xd35f2451, 0x1ac8b81e, 0xa0213c3c,
    0x0bf16610, 0x28391b3b, 0x569f0285, 0x0f2cc858, 0xa636c617, 0xa9dbcb12,
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xa8000000, 0x0c000000,
    0x5e000000, 0x63000000, 0x75800000, 0xebc00000, 0xd8600000, 0x9a300000,
    0xf6980000, 0xd5bc0000, 0x5eae0000, 0x2e230000, 0x45918000, 0x9acec000,
    0xa217a000, 0xac0dd000, 0x1cf08800, 0xd07ec400, 0x7dcbaa00, 0x1592d100,
    0x72cdfc80, 0x0e115e40, 0x220d54a0, 0xd7f38a50, 0xa9fe5688, 0xc80f8f64,
    0xaef6a822, 0x9d7dd427, 0x134c8215, 0x2fd1c52f, 0x136edea0, 0x71414b61,
    0x5825021c, 0x6a930514, 0x114f7ebe, 0xfad39b5d, 0xa9ea0a16, 0x6100010b,
    0xa082f484, 0x51425a74, 0xc820deb9, 0x62924b6f, 0xcd4c8217, 0x0cd1c523,
    0xc6eede92, 0x4a814b62, 0x28450238, 0xfca30514, 0x80000000, 0x40000000,
    0x20000000, 0x30000000, 0x88000000, 0xd4000000, 0xaa000000, 0xdb000000,
    0x24800000, 0x20c00000, 0xa7600000, 0x36b00000, 0x25380000, 0xa31c0000,
    0x078e0000, 0x4c270000, 0x6f928000, 0xd72cc000, 0x5f776000, 0x61ddb000,
    0xcfe82800, 0xe4152c00, 0x0969ba00, 0xabd73900, 0x308f1880, 0xdea49f40,
    0xca54d0a0, 0x15cbc350, 0x3e86a2a8, 0x33c3a65c, 0x77e3c80a, 0x8c735c29,
    0xd15c7200, 0x652f650f, 0xa877ea81, 0x935c3a4b, 0x7a28da2a, 0x9ef18923,
    0x349bb0a1, 0x87ca7361, 0xf9808aa3, 0x49418a53, 0x1620f211, 0x5c94a524,
    0x37aa0aae, 0x6db14a4f, 0x41b9923e, 0xa3de150a, 0x90e8a284, 0xf294a651,
    0x9ea9481e, 0xde339c17, 0x80000000, 0x40000000, 0xa0000000, 0x70000000,
    0x88000000, 0xfc000000, 0xe2000000, 0x07000000, 0x5c800000, 0x8b400000,
    0x5da00000, 0xdeb00000, 0x9b680000, 0x400c0000, 0xedde0000, 0x17630000,
    0x67d48000, 0x71bac000, 0x46342000, 0x662eb000, 0xd4a9c800, 0x72e84c00,
    0x28c9c600, 0xb3bb3300, 0x71339280, 0x12afdbc0, 0xd3ecfaa0, 0x454ce7d0,
    0x0d7a5488, 0x9654e8cc, 0xbd7f682a, 0xfe533c33, 0x917eae32, 0xe4540f22,
    0xe27b3c8d, 0xa6d4d4dc, 0x8c3d4618, 0xa0f1f304, 0x854fb28e, 0xed7d6bd9,
    0x46533288, 0x457babcd, 0x8a5112b4, 0x8f7a1bc4, 0x01525a8e, 0xb9fb97d1,
    0x71133cb8, 0x5ad8d4dc, 0x23e3460d, 0xc092f329, 0x361b32aa, 0xeb87abc6,
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x78000000, 0x54000000,
    0x56000000, 0x6f000000, 0x4d800000, 0xac400000, 0x2b200000, 0x1a700000,
    0x70680000, 0x2a1c0000, 0xfa720000, 0x406d0000, 0x32188000, 0x5e764000,
    0x6e6c6000, 0x09189000, 0x45f78800, 0xad2d7400, 0x6fbf9e00, 0xf3c3b300,
    0xf664fe80, 0x5fd0cec0, 0x79db60a0, 0x9c137df0, 0x97bf9e38, 0x67c3b30c,
    0xc064fe86, 0xc0d0cee9, 0x4c5b60ab, 0x64537dfe, 0xea9f9e3e, 0x12b3b33c,
    0xfd8cfe9f, 0x468ccec4, 0x9d0960bd, 0x3e4e7df2, 0xa8ef1e1c, 0x66d9f326,
    0x69929ead, 0x0ff95ec3, 0xeae668aa, 0xcd1549e7, 0xa93ce016, 0x9c02d00f,
    0xda01e827, 0xfd04e414, 0xfc82962c, 0xa2c5873c, 0x80000000, 0x40000000,
    0xa0000000, 0x10000000, 0x78000000, 0x74000000, 0xba000000, 0x05000000,
    0xb4800000, 0xb2400000, 0x56e00000, 0xf6100000, 0x0d480000, 0xdb5c0000,
    0x86160000, 0x854f0000, 0x67598000, 0x20154000, 0x364f6000, 0x18dff000,
    0x99d0b800, 0x636aec00, 0xbeefc600, 0x862f9d00, 0x158beb80, 0x18fa1cc0,
    0x53642da0, 0xaad581d0, 0x5cefc608, 0xa72f9d14, 0xc30bebb6, 0xcbba1cd9,
    0x73042d90, 0x9f8581cc, 0x09c7c60b, 0x3d239d39, 0xaa35eb8e, 0xd1f91cc8,
    0xc9e3ad86, 0x1793c1c7, 0xd38f2629, 0x5bfa2d2e, 0xe4e5b3b6, 0x0f1640e1,
    0xbfca3392, 0xca1c00c9, 0xd774d382, 0xbe9ab0f0, 0x85350b9f, 0x587cacc8,
    0x1b25f590, 0x59339dea, 0x80000000, 0xc0000000, 0xe0000000, 0x70000000,
    0x68000000, 0xa4000000, 0xe6000000, 0xaf000000, 0x9d800000, 0xea400000,
    0x0f600000, 0xb1900000, 0x8b480000, 0xf2dc0000, 0x8d920000, 0x61490000,
    0xffd88000, 0x2912c000, 0xd18f6000, 0x237a9000, 0x9ba08800, 0x4b36f400,
    0x76fd2e00, 0x85e1a100, 0x5a540380, 0xd46f78c0, 0xb9292da0, 0xafced9f0,
    0x821d2e18, 0xb131a12c, 0xa3fc03a2, 0x0d6378f5, 0xd8932d83, 0x29cbd9f2,
    0x9d1fae06, 0xa4b6613d, 0x9db9e386, 0x8c0228e3, 0x620445a2, 0xd9057de2,
    0x2a856807, 0xbbc7a419, 0xa722461a, 0xf7f30531, 0x085cc589, 0x0e57bdd0,
    0x9a6a082d, 0x522d341f, 0xa44ace3b, 0xaf59f12b, 0x87d3ebbb, 0x1e2f1cef,
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xc8000000, 0x14000000,
    0xce000000, 0x35000000, 0xd3800000, 0xcac00000, 0x52200000, 0x18f00000,
    0xe2c80000, 0x623c0000, 0xacf60000, 0xbcc90000, 0x4f3a8000, 0x1375c000,
    0x640fe000, 0xf21c5000, 0x23021800, 0xaa80d400, 0xdb409a00, 0x0fe0df00,
    0xbe538280, 0x0c79cbc0, 0x309318a0, 0xa85914d0, 0xa1609a38, 0xf310df3c,
    0x3a9b82aa, 0xff45cbe9, 0x49e518a1, 0xff5014d8, 0xa1fa1a3f, 0x07551f03,
    0x3dfc628a, 0xbd559bdd, 0x76f9008d, 0x93d5c0c6, 0x7bbe002c, 0xc5350034,
    0x046c8032, 0xec8cc036, 0x4e5d6027, 0x7065902e, 0x4693f805, 0x6159841e,
    0x78e60226, 0xbad0cb36, 0x523878bf, 0x24f584e6, 0x80000000, 0x40000000,
    0x20000000, 0x10000000, 0x08000000, 0x34000000, 0xca000000, 0xd3000000,
    0xbf800000, 0x51400000, 0x0c200000, 0x6a700000, 0x8a680000, 0x341c0000,
    0x04760000, 0xdb6b0000, 0x4c9d8000, 0x30b6c000, 0x5d0ae000, 0xa14a7000,
    0x4bee0800, 0x3c5d8400, 0x44d70600, 0x4fd9e300, 0x93943680, 0x56fd46c0,
    0x736330a0, 0x1754a5d0, 0x889f0628, 0x82b5e314, 0x820a368a, 0xf8ca46c9,
    0x3fa8b090, 0xa2f965e9, 0xd9606635, 0xf4555334, 0x2f18dea6, 0xeff6b2c7,
    0x702c3eb1, 0x8bbbc2fe, 0xd941b696, 0x782786cf, 0x8077d094, 0x4969d5ed,
    0x839a8e3d, 0x6135a71e, 0x1d4a50b1, 0xf5ef15f5, 0x05586e2d, 0x3853d701,
    0xa91a5885, 0xfaf591d1, 0x80000000, 0xc0000000, 0xe0000000, 0x90000000,
    0xf8000000, 0xb4000000, 0xa6000000, 0x9d000000, 0xfe800000, 0xaf400000,
    0x69200000, 0x45100000, 0x71d80000, 0x38cc0000, 0x7b120000, 0x08d90000,
    0x784f8000, 0x6d514000, 0xc17b6000, 0xbb1f1000, 0x2d289800, 0x8ee47c00,
    0x26779e00, 0xf76bab00, 0x95409d80, 0x3e227840, 0x449703a0, 0x7319d370,
    0xd12f9e18, 0x14e7ab14, 0xc1729d86, 0x7eeb7849, 0x4b8083b7, 0x3dc4937a,
    0xa466fe0e, 0x7f31bb18, 0x1b4d85a3, 0x0ad24473, 0xbebe7db1, 0x3c792865,
    0x15997b8c, 0x9a6aff54, 0xc3c47803, 0x3d662c1a, 0xafb66607, 0xf509c704,
    0x77701b91, 0xdbecef60, 0xe103602e, 0xa483102a, 0xa8429803, 0x70a17c17,
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x08000000, 0x24000000,
    0x8a000000, 0x11000000, 0x40800000, 0x46400000, 0x91200000, 0xb8100000,
    0xf0680000, 0x727c0000, 0xfb160000, 0xbdeb0000, 0xf2be8000, 0xe375c000,
    0x475a6000, 0x8903f000, 0x7c851800, 0xb042ec00, 0x5626c600, 0x4f922300,
    0x49aae580, 0x7e9a25c0, 0xc5e423a0, 0x627406d0, 0x1fd8c628, 0xb345230c,
    0x3ba2658a, 0xbf54e5d5, 0x59c8c380, 0xa02e36dd, 0x3459be1a, 0xec833f19,
    0xa8413bbe, 0x2a26eaea, 0x99960018, 0xfeab002f, 0x811e8038, 0x5825c03a,
    0xe4926034, 0x302ff021, 0x2c5b1817, 0x9085ec2c, 0x7e46461c, 0x9d20e32c,
    0x661005ac, 0x636b15c6, 0x07fbdbb6, 0x77d7dada, 0x80000000, 0xc0000000,
    0xe0000000, 0x10000000, 0x58000000, 0x74000000, 0x66000000, 0x8f000000,
    0x26800000, 0x6c400000, 0xd7600000, 0x90d00000, 0xb0480000, 0x8e9c0000,
    0x5dd20000, 0x07c90000, 0xcf5b8000, 0xee704000, 0x8f386000, 0x0c231000,
    0xc5330800, 0x92db2c00, 0x02b64600, 0x5b1e5100, 0x7d17d180, 0xd1eee2c0,
    0x0f6997a0, 0x272cb3f0, 0x3e4c4618, 0x1d9b5134, 0xc15651ae, 0xbe8ba2d9,
    0xfbb877af, 0xa966e3ce, 0x4bd4ae08, 0x00cf2d0c, 0x25d97f92, 0x8034cfe6,
    0xe9596836, 0x41713c09, 0x59bece13, 0x28653d1e, 0x3e51f78e, 0x100fa3d8,
    0x5bff4e30, 0x7c007d2c, 0x6a001798, 0x6d05f3da, 0x8787a616, 0xe9c40101,
    0x8fa73982, 0xc2f69ede, 0x80000000, 0x40000000, 0x20000000, 0x10000000,
    0xa8000000, 0xac000000, 0x1a000000, 0x43000000, 0x58800000, 0x7e400000,
    0xcba00000, 0x4f300000, 0x98a80000, 0xf19c0000, 0xd8360000, 0xbe2b0000,
    0x4add8000, 0xaa13c000, 0x90db2000, 0x89103000, 0xf85d0800, 0x4f55fc00,
    0x37fe0600, 0xb6672700, 0xf6531880, 0x5c7b1ac0, 0x08a51ea0, 0x57b03dd0,
    0xc6e80628, 0x2a3c2714, 0x3f0698a2, 0x8a84daef, 0xa1403e8c, 0x31270deb,
    0x76768e38, 0xbd8d1b1b, 0x99e83e86, 0x90bb0de3, 0x26408e18, 0xbfa61b04,
    0x6135be88, 0xd5a8cdd8, 0xf41bae0a, 0x0bf62b32, 0x0a48b6ac, 0xab8d31f3,
    0x90eda816, 0x033d0c06, 0xbc85ae2b, 0xb8412b3c, 0x0aa3369c, 0x40b5f1fa,
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xd8000000, 0xfc000000,
    0xde000000, 0x2f000000, 0x74800000, 0xc3400000, 0x38a00000, 0x68f00000,
    0x64480000, 0x76bc0000, 0x5ff60000, 0xccc90000, 0xbbfa8000, 0x20554000,
    0xf4b82000, 0x3ef39000, 0x9f4ec800, 0x983cfc00, 0x21b72e00, 0xa9ef9700,
    0xb7cd3e80, 0x157e6bc0, 0x3e1210a0, 0x219dfcd0, 0xeac12e38, 0x5666973c,
    0x8c97beae, 0x11db2bd3, 0xa8e230a1, 0xbad26ce4, 0x80f9e612, 0xeed36b07,
    0x5afa10bd, 0x33d1fcf9, 0xb77f2e36, 0x8f139723, 0x1a1b3ebc, 0xed076bf9,
    0x758090bc, 0x20c4bcfe, 0xc3670e0b, 0x95100737, 0xe71df6a7, 0xd08797e4,
    0xa141beb9, 0xa9a22bc9, 0x8370b0bd, 0x0b8b2cf2, 0x80000000, 0x40000000,
    0x60000000, 0xd0000000, 0xe8000000, 0x6c000000, 0xee000000, 0x8d000000,
    0xf6800000, 0xf2c00000, 0x39a00000, 0x48700000, 0x13c80000, 0x7abc0000,
    0x51f60000, 0xe4890000, 0x42598000, 0x9867c000, 0x72552000, 0xbbf99000,
    0xf016d800, 0xd19dfc00, 0xf9433200, 0x25e1c300, 0xb7141280, 0xd81f1fc0,
    0xc60120a0, 0xc107dcd0, 0xa884b238, 0x47c30324, 0x4b26b2a2, 0x38b44fef,
    0x496d58a1, 0x494d70e8, 0x467df83e, 0x55516c3b, 0x627a6a11, 0x2752ff01,
    0x597b808b, 0x08d08cf4, 0x373eca36, 0xccb0af28, 0xd36e78af, 0x1e4de0c5,
    0x87faa01c, 0xb617500f, 0x509a7813, 0x31c3ac2a, 0xb220ca01, 0x1435af05,
    0x8ca9f8aa, 0x616f20c6, 0x80000000, 0x40000000, 0x60000000, 0xf0000000,
    0xb8000000, 0x14000000, 0x9e000000, 0xd7000000, 0x51800000, 0x25400000,
    0xe1a00000, 0x95f00000, 0x01e80000, 0x6f1c0000, 0xf5760000, 0x96290000,
    0xf4788000, 0x3b644000, 0x1e146000, 0xa038d000, 0x08440800, 0x01235400,
    0x4234f600, 0xfa8bef00, 0x510e5680, 0xc549a6c0, 0xd66ca0a0, 0x595b49d0,
    0xf3527638, 0xad9aaf2c, 0x77b4b6b6, 0xb9cc36f9, 0x13ac48a9, 0x6f388de0,
    0x9dc0e80b, 0x9263c410, 0x28929e1a, 0x0cf96b15, 0x28a628b1, 0x53755dce,
    0x152a602e, 0x5bfdd012, 0x39228834, 0x1632143b, 0x048e162c, 0x760e7f1d,
    0x2ccebe9f, 0xe72a62e3, 0x26fe3ea6, 0xb1a222cc, 0xfdf45ebe, 0x3deff2e0,
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x98000000, 0x14000000,
    0x02000000, 0x27000000, 0xcc800000, 0x8c400000, 0x58a00000, 0x33d00000,
    0x2a680000, 0x22bc0000, 0x2a520000, 0xc5ab0000, 0x16df8000, 0x0b604000,
    0x39b76000, 0xd25b3000, 0x6b276800, 0x07153c00, 0x8c8fb600, 0x26cd0f00,
    0x736ac780, 0x573d6bc0, 0x639771a0, 0x3ccb64f0, 0x806a3608, 0x39ba4f04,
    0x18d0278e, 0x30ed1bf1, 0x2bf8f986, 0x497528fc, 0x2ebd883b, 0xfc554c2e,
    0x40a83e2b, 0x2d5f431e, 0xd3a779ba, 0xf95568c8, 0xbb2ae813, 0x559e7c23,
    0xc3475602, 0x08267f28, 0x9192cfb1, 0x93cf67f7, 0x60edafb4, 0x73f857f5,
    0xfd70c78d, 0xfcba6bdc, 0x4352f18c, 0x982c24e7, 0x80000000, 0xc0000000,
    0x60000000, 0xd0000000, 0x98000000, 0xac000000, 0x12000000, 0xb1000000,
    0xe0800000, 0x6fc00000, 0x09200000, 0x83b00000, 0xb1280000, 0xc19c0000,
    0x79320000, 0xfbed0000, 0x26398000, 0x7e404000, 0x2664a000, 0x55507000,
    0x73bf5800, 0xc7072c00, 0xb7878a00, 0xe0452f00, 0xf5605880, 0x2cd12ec0,
    0x18fdd2a0, 0x87e501f0, 0x32160a38, 0x91596f04, 0xbb96f8be, 0x121c5edf,
    0x7f730a82, 0x618e6df7, 0x996f2004, 0xc0fd3033, 0x8be27804, 0x90171c24,
    0x685c720c, 0x6f127317, 0xc3d88a8e, 0xd5532df9, 0xb3ba000d, 0xa701002a,
    0x67838036, 0x7841402e, 0x59672001, 0x3ed13001, 0xa9f87822, 0x67661c04,
    0x5dd7f228, 0x987f3322, 0x80000000, 0xc0000000, 0xa0000000, 0x10000000,
    0xb8000000, 0x34000000, 0x7e000000, 0x6d000000, 0x65800000, 0x94400000,
    0x67a00000, 0xfb100000, 0xd7080000, 0xcf1c0000, 0xd8920000, 0xda4b0000,
    0x13398000, 0xcac74000, 0xb7676000, 0x8777d000, 0xdcfdd800, 0x34202400,
    0xfe53de00, 0x972a0700, 0x2f482180, 0x92b92ec0, 0x3881ffa0, 0x99c429f0,
    0xdfe25e08, 0xc6b14734, 0x871d4186, 0x2495fec9, 0x984da791, 0x9c3f4de6,
    0x3044e00e, 0x61a7900a, 0x02113806, 0xdc8bb412, 0x8e58e61d, 0xeeb6b31b,
    0xcb1b4785, 0xce93ddfb, 0x9b4c5812, 0x2cbb642f, 0xf586be2d, 0xec46d71a,
    0xf3a479b7, 0x95124ae4, 0x020f4185, 0x9e9efec7, 0x32d4278c, 0xd0e80dc3,
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x18000000, 0x24000000,
    0x6a000000, 0xaf000000, 0xc3800000, 0x2a400000, 0xa0600000, 0xed100000,
    0x8b180000, 0x070c0000, 0xca960000, 0x2b5f0000, 0xd86a8000, 0x8c054000,
    0xb606e000, 0x3104f000, 0x6e856800, 0x7ac28400, 0x07a53e00, 0xa2327900,
    0xaae90f80, 0x88c07e40, 0xcca231a0, 0xabb10750, 0x5fafbe08, 0xf327390c,
    0x2ff7efae, 0xeac88e55, 0x1ab159bc, 0x712c8372, 0x29e00022, 0x5850002d,
    0x50f80036, 0x945c0024, 0x93ee0016, 0x4a430018, 0x3064803a, 0x2516402a,
    0xc71a601c, 0x510eb018, 0x2b910811, 0x2ddf3415, 0x9ea8b626, 0xc5a70d19,
    0xd135d99e, 0xf76ac35f, 0x0f826010, 0x3c42b035, 0x80000000, 0x40000000,
    0xa0000000, 0x70000000, 0xe8000000, 0xac000000, 0x12000000, 0x05000000,
    0x68800000, 0x13400000, 0x73e00000, 0xb7d00000, 0xfe880000, 0xda5c0000,
    0x17560000, 0x71cf0000, 0xf3ba8000, 0x7982c000, 0x1dc52000, 0x93a37000,
    0x67b47800, 0xcd994c00, 0x85f22e00, 0x60f9bd00, 0x4a644d80, 0x0a1014c0,
    0x1d2863a0, 0x55eaa9d0, 0x76c8ae08, 0xe63b7d0c, 0x96416d92, 0x5b6364f7,
    0x04941b9e, 0xfd6fe5fa, 0x858c8016, 0x45ddc009, 0xb997a014, 0xe1edb01e,
    0x60cf581d, 0xfd393c31, 0x99c2d624, 0xcda1312f, 0xa0b7c3bf, 0x381b19eb,
    0xba31f638, 0xbe5d4131, 0x99513b8c, 0x2ecc95e1, 0x4238f81b, 0xf8448c12,
    0xd4658e24, 0x2d140d3d, 0x80000000, 0xc0000000, 0xa0000000, 0xf0000000,
    0x88000000, 0xc4000000, 0x0a000000, 0x8f000000, 0x41800000, 0xc0c00000,
    0xd2a00000, 0x39d00000, 0x43f80000, 0xc32c0000, 0xc8520000, 0x6b3b0000,
    0x858e8000, 0x8381c000, 0xebc16000, 0xc924f000, 0x0e17e800, 0x9cdc1400,
    0xf43e7a00, 0xdc0ebb00, 0x5f462f80, 0x8f635b40, 0x39f255a0, 0x4d6ae070,
    0x5bb0fa08, 0xe08f7b0c, 0xdd074f8a, 0xb287ab4d, 0x6745bd80, 0xa366f462,
    0xa7f6801a, 0xb06dc01f, 0xd933602e, 0xafcff033, 0x4a616804, 0x9771d42c,
    0x9c2d1a30, 0x31d14b39, 0x47ff47b7, 0x692e8f44, 0xb7554f9f, 0xa2bcab5c,
    0x814b3d93, 0x5b273473, 0x5d17e007, 0xcb593017, 0x0dfc8839, 0x862fe428,
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xd8000000, 0x6c000000,
    0x36000000, 0x9f000000, 0x50800000, 0xfdc00000, 0xc6600000, 0xfd100000,
    0x3df80000, 0x106c0000, 0x90560000, 0x26590000, 0xfb1a8000, 0x38bd4000,
    0xbfc8a000, 0x21225000, 0x27b70800, 0xad0d5c00, 0x4fc0fa00, 0x9b633500,
    0x08967780, 0x89bba540, 0x3c4c0da0, 0x6a65d050, 0xeb12da38, 0x72fc253c,
    0x28e9dfae, 0xd994a977, 0xba3bff9b, 0xaf0bb96c, 0xcac457a1, 0x02e4b564,
    0x8ad3a5ab, 0x3a9adc67, 0x96fd283d, 0x5aee4c3b, 0xa491521c, 0x9fb93922,
    0x734d0584, 0x52e18c7b, 0xa2d0a016, 0xee9e5035, 0x7cf90830, 0x2be85c02,
    0x07147a08, 0x04fb752a, 0xd7ea57a6, 0x3911b568, 0x80000000, 0xc0000000,
    0x20000000, 0x30000000, 0xb8000000, 0xe4000000, 0xee000000, 0x43000000,
    0xf0800000, 0x90400000, 0x30a00000, 0xcf700000, 0xa6680000, 0xf99c0000,
    0x1fb20000, 0x7e8f0000, 0xc24c8000, 0xa8ae4000, 0xda79e000, 0x30e2d000,
    0xb7d62800, 0x151ffc00, 0x65f31600, 0xf32c8f00, 0x36bf3280, 0x3206a6c0,
    0x8900a4a0, 0x7d8469f0, 0x13c67628, 0xe8601f3c, 0x8b90faa6, 0xb7bb8af5,
    0xd3859ab5, 0xb0c71ad9, 0x08e252af, 0x93d636c8, 0xdb1d6cb6, 0x16f645d2,
    0xbbafc818, 0x42fd2c18, 0xeca53e0f, 0x05737320, 0x2b6c2492, 0x7a1a29cb,
    0xc7779604, 0x3a6ecf2f, 0xd39cd28d, 0x82b776f3, 0x75080ca8, 0x468ad5c8,
    0xe648002f, 0x66ac001b, 0x80000000, 0xc0000000, 0xa0000000, 0x10000000,
    0x98000000, 0x9c000000, 0xae000000, 0x3d000000, 0xa4800000, 0xa4400000,
    0xdda00000, 0x01f00000, 0x35580000, 0xc02c0000, 0xa9320000, 0x98bb0000,
    0x16798000, 0x829e4000, 0xc24f2000, 0xdea61000, 0xc073d800, 0x09996c00,
    0x07c9d600, 0xd0657700, 0x9490be80, 0xe948bb40, 0x0b20e8a0, 0x56b38c70,
    0xc17f7608, 0x491d2734, 0xe18c468e, 0xb6c7c763, 0x18e2e6ad, 0x76d39758,
    0xbdec1e8a, 0x1457eb52, 0x50af90b0, 0x7775b07a, 0x7219d83f, 0xac0e6c2c,
    0xbc02562b, 0x7e003713, 0x05061ebc, 0x2880eb47, 0x924410ad, 0x7ca0f071,
    0x0b777831, 0xac1a3c3e, 0xb90cae2a, 0x0c844b23, 0x704590bb, 0xd7a2b067,
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x28000000, 0x64000000,
    0x1e000000, 0xf1000000, 0x41800000, 0xcbc00000, 0xdae00000, 0xbd500000,
    0xfb380000, 0xefec0000, 0x9b160000, 0xc0190000, 0x2f5f8000, 0x19ffc000,
    0x688f6000, 0xdf865000, 0x7ac7b800, 0xfb646400, 0x66964200, 0x09dd9100,
    0x36b96980, 0x7e2f1940, 0xdef0aba0, 0xf5cd4850, 0x1226a238, 0x9d340114,
    0x7b29b192, 0xe9712d5d, 0xcb0f51ad, 0x8741bd75, 0x32a009af, 0x7f70495a,
    0x6e089394, 0x80c6ec50, 0x5467803d, 0xb613c025, 0x9399601d, 0x0f9f5018,
    0x7d983806, 0x869ba40e, 0x1019220e, 0x275bc12b, 0x0dfed1ba, 0x4e8b7d5f,
    0x6286e982, 0x4140d94e, 0xdfa7cba5, 0x0cf71873, 0x80000000, 0xc0000000,
    0x60000000, 0xd0000000, 0xd8000000, 0x34000000, 0x9a000000, 0x57000000,
    0xda800000, 0x0e400000, 0x4da00000, 0x40700000, 0xf6980000, 0x006c0000,
    0x96b20000, 0x767d0000, 0xfd398000, 0x711a4000, 0xfbae6000, 0x8bd2f000,
    0xe7eb2800, 0xbd728c00, 0xb31d9600, 0x58ac1700, 0xab55f280, 0x6eaeb940,
    0xf251e4a0, 0xc928ee70, 0x79927638, 0xbc48a704, 0xd402baae, 0x8a03c579,
    0xef06dab0, 0x3e803568, 0x4c4672a8, 0x2ea5f952, 0x00f404ab, 0xafdd5e5a,
    0x974ebe06, 0xd8829b0c, 0xcd4264a6, 0xbd23ae72, 0x1137960f, 0x8dbd173a,
    0xe05e72a7, 0xe089f94c, 0xbbe604ac, 0x49d05e7e, 0x44ef3e3f, 0x9df4db39,
    0x3a5e0487, 0x178c5e54, 0x80000000, 0xc0000000, 0x20000000, 0xd0000000,
    0xb8000000, 0xcc000000, 0xea000000, 0x25000000, 0xa5800000, 0xba400000,
    0x4ba00000, 0xc6b00000, 0x93480000, 0xaa7c0000, 0x2e720000, 0xee2f0000,
    0xf2ab8000, 0x7f694000, 0x4788a000, 0x551cb000, 0x27a63800, 0x3cb62400,
    0x2e4b8e00, 0x13f8d700, 0xc6369c80, 0x4c8d49c0, 0x7b9e92a0, 0x7360def0,
    0x03d2ae28, 0x079e2704, 0x116184a6, 0xa2d19dc7, 0xec1804b4, 0x1027ddca,
    0x4ff324bb, 0xfa6e2de3, 0xf20fbcbd, 0x775bb9e8, 0x70018a8a, 0xa8000ae5,
    0x5406383a, 0xf6062401, 0x77038e10, 0x4c84d735, 0xf5c49ca6, 0xd4e249c5,
    0x28951296, 0xefb99eed, 0x72920e02, 0x42be971e, 0x5315bc8c, 0xb6f8b9fa,
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x98000000, 0x44000000,
    0xc6000000, 0xa7000000, 0x2b800000, 0xb4400000, 0x5c200000, 0x31500000,
    0x43a80000, 0xbb7c0000, 0x9d960000, 0x9e4f0000, 0x214b8000, 0x0ec84000,
    0xdc8de000, 0x77ad9000, 0xf57e4800, 0x46930400, 0x67c9ae00, 0x6c092b00,
    0x9a6b5f80, 0xb41981c0, 0x7b6171a0, 0x08f4ead0, 0x1db9ce08, 0x5d73fb04,
    0x5afb778e, 0xd4d355c5, 0x6ced77b7, 0xbedc55e8, 0xb186f7b3, 0xd14415c0,
    0xb6a317b3, 0x599585f4, 0x184b5f98, 0x264981de, 0x754971a2, 0xf0c8ead8,
    0x6f8fce2d, 0x022cfb39, 0xa238f78d, 0xf73715fd, 0x45de9797, 0x5802c5cc,
    0xa4053fbf, 0x360051cc, 0x6f04d984, 0xf7857ed5, 0x80000000, 0xc0000000,
    0xa0000000, 0xd0000000, 0x08000000, 0xcc000000, 0xee000000, 0xd3000000,
    0x52800000, 0x4ac00000, 0xa5e00000, 0xbed00000, 0x68780000, 0x562c0000,
    0x51920000, 0x47db0000, 0x42df8000, 0xb75cc000, 0xf5192000, 0x33389000,
    0x83882800, 0xbc63ac00, 0x02941200, 0xd55b3100, 0xa81f0580, 0xc2bbbf40,
    0x43cc97a0, 0x97404e70, 0x3ba0b208, 0x3ef46104, 0x17c98daa, 0xdd404347,
    0xbaa38d99, 0x89774377, 0x188e0da7, 0x42e08362, 0xd650adb7, 0x7bb8d34a,
    0x804ba582, 0xc204ef79, 0x8d021fab, 0xf987b255, 0x0c45a808, 0xc5246c02,
    0xea32b21b, 0xb92f613a, 0xf5160d97, 0xba1c835d, 0x47baad98, 0x764fd34a,
    0x750625bc, 0x2d832f59, 0x80000000, 0x40000000, 0xa0000000, 0xf0000000,
    0xe8000000, 0xb4000000, 0x22000000, 0x81000000, 0x21800000, 0x56400000,
    0xc2200000, 0xa9100000, 0xe6480000, 0x2fdc0000, 0x5e560000, 0xb5ef0000,
    0x988e8000, 0x3e3ec000, 0xf921e000, 0x15943000, 0xa788d800, 0xe8bc6400,
    0x7de64e00, 0x39731b00, 0xe77dcd80, 0xa5810cc0, 0x7c4303a0, 0xa723d7d0,
    0xb291ae08, 0x6d082b2c, 0x5a7b9592, 0x0203a8d1, 0x3104ad92, 0x6984fcdd,
    0x1244bb88, 0x082543d9, 0x9c16d80a, 0xe5cf643e, 0xf89ece13, 0xbdf2db10,
    0x4abaad94, 0xbce7fcfe, 0xb8f43ba1, 0x413883ed, 0x8fa7b811, 0x61569412,
    0x636f761b, 0x1c4b4f22, 0x12db5b8c, 0xb9d273d0, 0x58ae8009, 0xa62ec025,
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xb8000000, 0x1c000000,
    0x1a000000, 0xd1000000, 0x03800000, 0x65c00000, 0x27a00000, 0xc0500000,
    0xe3b80000, 0x516c0000, 0x04960000, 0x8f9b0000, 0xe0f98000, 0xee8f4000,
    0x71a22000, 0xd357b000, 0x9d3e1800, 0x052b3400, 0x33f0c200, 0x6defab00,
    0x6dd0fb80, 0xa97fe540, 0x824fb9a0, 0xf9840e50, 0x44c4e228, 0x2c231b34,
    0x919763a6, 0x7a1b9163, 0x463d5b88, 0x2fac1563, 0x69b201ae, 0xa58bca59,
    0xe326180f, 0x9517341a, 0x4f5ec211, 0x5ad8ab33, 0x0c1f7b91, 0xc53ba55d,
    0xe92c1996, 0x21f0fe55, 0x88eeda3d, 0xd0549f06, 0x1bb839ad, 0x6d6c4e51,
    0x8e914222, 0xe69ceb35, 0xff7cdbbc, 0x914f5554, 0x80000000, 0x40000000,
    0x20000000, 0x50000000, 0x48000000, 0xec000000, 0xb2000000, 0x03000000,
    0xf3800000, 0x70c00000, 0x3f200000, 0x9c300000, 0xec580000, 0x28ec0000,
    0x9bf60000, 0x76fb0000, 0xb91f8000, 0x5a0ec000, 0x0a622000, 0x9ed37000,
    0x65cc4800, 0x64c42400, 0x1926aa00, 0xf9319700, 0x5add8c80, 0xbea9c140,
    0x7a92a6a0, 0xe7ad9650, 0x76128a28, 0xbee9e704, 0x86f6449a, 0x147f256f,
    0x69582c9e, 0xae68716b, 0x35b2ceb8, 0x639dc258, 0x3e49e809, 0xc8059404,
    0xac06c202, 0x9201c302, 0x5306ee9f, 0xbb85b270, 0x9cc22037, 0x8d237020,
    0x9f34482c, 0x1fd82414, 0x5828aa1b, 0xa4d69735, 0xeacc0c80, 0x55400166,
    0x72e10686, 0x91972671, 0x80000000, 0xc0000000, 0x20000000, 0x70000000,
    0xa8000000, 0x04000000, 0x2a000000, 0xcb000000, 0x32800000, 0x68400000,
    0xada00000, 0xabf00000, 0x2ba80000, 0xfddc0000, 0x66b20000, 0xb58f0000,
    0x97ee8000, 0x627cc000, 0x8a466000, 0xf2a5f000, 0x4b70c800, 0x54e92c00,
    0xe4fae600, 0x40030700, 0xe001ae80, 0x50020cc0, 0xd807c8a0, 0xac02cbf0,
    0x2e068628, 0xe105f72c, 0xf985e6a2, 0x5ac4e0dd, 0xc5e7ce80, 0x0657fcc3,
    0x805f00ae, 0xd677e7c4, 0x9b6e6025, 0xd339f01d, 0x2262c809, 0xf5962c3a,
    0xe83c663f, 0x78e3c73b, 0xb9d5ce91, 0x1f98fcf7, 0xb011808a, 0xa4fb27db,
    0xa0000020, 0xb000003d, 0x8800003f, 0x74000012, 0x8200003f, 0xcf00003e,
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x38000000, 0x7c000000,
    0x06000000, 0xf7000000, 0xae800000, 0x79400000, 0x9d600000, 0x22500000,
    0xc5880000, 0x625c0000, 0x86120000, 0xff690000, 0xfccd8000, 0xdf3d4000,
    0x94472000, 0xd2e45000, 0xda97c800, 0x232e6c00, 0x9a28ae00, 0x77a94900,
    0xd26a0580, 0x534db8c0, 0xf7fd2ba0, 0x4ae0b1f0, 0x56958e18, 0x2d281904,
    0xf92a4db6, 0x9b2b94eb, 0x262d25af, 0x91a9e8d2, 0xf56ae3b2, 0xc5cedde7,
    0xf2bd201a, 0xd181500d, 0x83c04821, 0x46262c06, 0xe2300e34, 0x8059591b,
    0xfb176d93, 0xa8eac4e3, 0x480d6d87, 0xd79fc4fd, 0xdf32edbc, 0xf7db84d7,
    0x7fd04da9, 0x484e94de, 0x477aa5be, 0x88a1a8d3, 0x80000000, 0x40000000,
    0xe0000000, 0x70000000, 0xd8000000, 0x84000000, 0xd6000000, 0xc5000000,
    0x92800000, 0xb6400000, 0xdb200000, 0xa0b00000, 0x03380000, 0x600c0000,
    0x79f60000, 0x0d9d0000, 0xbf788000, 0x6c2b4000, 0xb8c3e000, 0x9f641000,
    0xf892d800, 0x5c0bdc00, 0x1bf17600, 0x269dd300, 0x1cfcd080, 0x46ef9240,
    0x94a326a0, 0xa0740150, 0x285c9618, 0x7698c30c, 0x14f8888e, 0x8aee0e7d,
    0x6ea730a3, 0xef778240, 0x2ddffe89, 0x415edd50, 0x2e1b603c, 0xd5bf5028,
    0xa049380d, 0xf7d3cc3c, 0x97adae39, 0x56070f26, 0x85032696, 0x7284016c,
    0xc6449633, 0x0324c331, 0x24b68880, 0xd53f0e5f, 0xa509b09f, 0xeb71c26f,
    0xbbdc9eb3, 0x645d8d5a, 0x80000000, 0xc0000000, 0xa0000000, 0x90000000,
    0xc8000000, 0x8c000000, 0x0a000000, 0xfd000000, 0x44800000, 0x35400000,
    0xff200000, 0xd3b00000, 0x38880000, 0x88bc0000, 0x94f20000, 0x2eab0000,
    0xf18d8000, 0x7238c000, 0x22b52000, 0xb60bb000, 0xe0fc7800, 0xbf516c00,
    0x005afe00, 0xba200b00, 0x23303880, 0x73cc1fc0, 0x549d46a0, 0xb0c3d4f0,
    0x1ce7de08, 0x00d7bb14, 0x469e409a, 0x69c673c7, 0xee623890, 0x9a971fec,
    0x4438c69b, 0x4db714e6, 0xeb88fe14, 0x873b0b0e, 0x4a35b8a9, 0x1948dfee,
    0x2ada66aa, 0xa46364c8, 0x0796263d, 0x30be1705, 0x20f19e8e, 0x50adc8ed,
    0xd28e7834, 0x85ba6c33, 0x28777e14, 0xcfe8cb22, 0x40ad1885, 0xda8bafd2,
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x78000000, 0x8c000000,
    0x86000000, 0x53000000, 0x93800000, 0x2bc00000, 0x68e00000, 0xb0f00000,
    0x1a380000, 0x5c4c0000, 0x45360000, 0xdddd0000, 0xb13d8000, 0x03cb4000,
    0x08f6a000, 0x363bd000, 0xea48e800, 0xbe312400, 0xba5b5200, 0x90fd5100,
    0xbe2fb480, 0x7884ac40, 0x944766a0, 0xf523bd50, 0x2315f218, 0xcd4a8124,
    0x67b15ca6, 0xa4988857, 0xe899b49f, 0xce99ac67, 0xad9ae69d, 0x9618fd7a,
    0x49db5238, 0x2b3d5121, 0x4ecfb49b, 0x9474ac78, 0x707f66ac, 0x766fbd4d,
    0x73a3f23a, 0x68578121, 0x2decdcb0, 0x3c63c86b, 0x92b714aa, 0x141e7c49,
    0x18dc0eb2, 0xa9b8d951, 0x078b8006, 0x65d64021, 0x80000000, 0xc0000000,
    0x60000000, 0xb0000000, 0x18000000, 0x44000000, 0x6e000000, 0x8d000000,
    0x7b800000, 0xf7c00000, 0x0ea00000, 0xed700000, 0x26280000, 0x0bdc0000,
    0xc8b20000, 0xff8d0000, 0x062a8000, 0x1bdf4000, 0x00b3e000, 0x1389d000,
    0x342d5800, 0xbcdad400, 0x9834f200, 0x12ca7300, 0xb6c99a80, 0xa8cb30c0,
    0x5dcde8a0, 0xd24f03f0, 0x538f1238, 0x942fa31c, 0x6cdec29e, 0x3030e4fd,
    0x4ec99abd, 0x9ccb30c2, 0x4bcde8bd, 0xab4f03c2, 0x5e0f1223, 0xaaefa30b,
    0x77fec28f, 0xa780e4e7, 0x1dc19a98, 0x8da730c2, 0xabf7e88d, 0xb26e03c0,
    0xb6bf922b, 0x4561e30b, 0xb9d5a2b0, 0x505b74f3, 0x2f75a2b2, 0x392b74ef,
    0x075da286, 0x0ff774ea, 0x80000000, 0x40000000, 0xa0000000, 0x10000000,
    0x58000000, 0x94000000, 0xae000000, 0xe9000000, 0xe4800000, 0xa3400000,
    0x70600000, 0xb7500000, 0x61080000, 0x91dc0000, 0x58160000, 0x6b6f0000,
    0xc1898000, 0x249c4000, 0xe5756000, 0xdebe5000, 0x26c17800, 0x1ba48c00,
    0xee742e00, 0xa9388100, 0x8605e580, 0xd50564c0, 0x36864ba0, 0x3842a5d0,
    0x1fe14e08, 0x2396d114, 0x11ac9dbe, 0xf82de8e1, 0xb9ec659d, 0xffc924cf,
    0xae7b2b9a, 0x5060f5c6, 0xe756363b, 0x990d5d34, 0x15d93391, 0xae1529d2,
    0x166ae02a, 0x8b0d1019, 0x6edd9800, 0x71969c28, 0xcaa83622, 0x37ae5d3a,
    0x3d2eb389, 0xd76a69d8, 0x53880015, 0x1f9c0023, 0x9af60031, 0x127f0012,
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x18000000, 0x7c000000,
    0x86000000, 0xa7000000, 0xda800000, 0x02400000, 0x51600000, 0x45500000,
    0x23980000, 0x594c0000, 0x2f160000, 0x56f90000, 0x86188000, 0xdd894000,
    0x6a362000, 0x0dc95000, 0x5e514800, 0x5f1d4c00, 0x6c0ed600, 0x4cf1f100,
    0x75eebd80, 0x0ee3a840, 0xe096eba0, 0x1b3e1950, 0xdab8f638, 0xa478a12c,
    0xc05ff59e, 0xe6eee463, 0xe6603d87, 0x37d3e866, 0x25d84baf, 0x022e0945,
    0x53479e1c, 0x74e0bd22, 0x81966ba3, 0x06bb594d, 0xf278d632, 0xef58f125,
    0xa86e3db1, 0x0626e866, 0x3bb6cbb7, 0x9b0e497c, 0x5e713e03, 0x83acad03,
    0x4d870386, 0xe0c64553, 0xbf27c825, 0x7a310c06, 0x80000000, 0x40000000,
    0x60000000, 0x10000000, 0x38000000, 0xfc000000, 0x86000000, 0x11000000,
    0x05800000, 0xdcc00000, 0xe7e00000, 0x79500000, 0x94780000, 0x4bac0000,
    0x05960000, 0x43990000, 0x7aff8000, 0x45ef4000, 0x4a332000, 0x146a5000,
    0x94f2f800, 0xf88c0400, 0x6f23da00, 0x9cb00100, 0xe62aa180, 0x5d524b40,
    0xbe78fba0, 0x84a80a50, 0xfd10fa38, 0x24da5114, 0xacd85996, 0x58de4f7b,
    0x6adb218f, 0x29d80b6b, 0x7f5a5b98, 0xcd181a67, 0x64b8a20e, 0x324a4502,
    0xe1c5dbab, 0x7c675a73, 0x3893822a, 0xd81c151e, 0x3b39239e, 0x098e5e68,
    0x3aa1d83f, 0x18765400, 0xedc92213, 0x9a000527, 0xc7077b8b, 0x4c874a42,
    0x3543da17, 0x8520013e, 0x80000000, 0xc0000000, 0xe0000000, 0x90000000,
    0x98000000, 0x84000000, 0xe2000000, 0x75000000, 0xf7800000, 0x09c00000,
    0xe0600000, 0xa0100000, 0xac780000, 0xa5ac0000, 0x59b20000, 0xb4090000,
    0xcdc78000, 0x22664000, 0xa517e000, 0x53ffb000, 0xb06c7800, 0xdfd23400,
    0x8319e200, 0xe33b6500, 0x798fff80, 0x1505cd40, 0xa781fda0, 0x71c11870,
    0xf4627a18, 0xda16e114, 0x5d7a659e, 0xb02c9c45, 0x2577e03e, 0xa3efb00c,
    0x6414783d, 0x6e7e343b, 0xa0abe223, 0xa632650b, 0xa1c87fab, 0x4ba38d5c,
    0x15761da0, 0x8beea876, 0x08160205, 0x0078d519, 0x2ba987af, 0x42b2f970,
    0xc88d9fad, 0x20853d42, 0xab45e5a2, 0x6e26dc4c, 0x41b2002c, 0xf0090036,
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x08000000, 0x0c000000,
    0xce000000, 0x25000000, 0x64800000, 0x37c00000, 0x89a00000, 0x36d00000,
    0xca980000, 0x178c0000, 0xd2b60000, 0x3aed0000, 0xd8418000, 0xefe0c000,
    0x04372000, 0x1e2c9000, 0xa4631800, 0x10706c00, 0x9fcbea00, 0x35525b00,
    0x32dc9f80, 0x086d3c40, 0x6e8055a0, 0x70c3f750, 0xb627d218, 0x1892a704,
    0x147a6dba, 0x5d3e0b57, 0x4c58a011, 0x90ad501a, 0x84a3b812, 0xae513c10,
    0x8b5e5239, 0xef2e6703, 0x4ae34da3, 0x20b39b41, 0xc9ec383f, 0x7dc0fc16,
    0x2ea6f218, 0x5953372c, 0xecd8f587, 0xc56ea77a, 0x56046a0f, 0x81039b14,
    0x16843f99, 0x84c06c6b, 0xcc23edaa, 0xa792cb56, 0x80000000, 0x40000000,
    0xa0000000, 0x90000000, 0xe8000000, 0xc4000000, 0x66000000, 0x21000000,
    0xdb800000, 0xe5400000, 0x6ba00000, 0x52900000, 0x42b80000, 0xc16c0000,
    0x16760000, 0xb88f0000, 0xedc58000, 0x1a61c000, 0xd2f46000, 0x5b499000,
    0x52a17800, 0xd513f400, 0xddffc600, 0x51cdff00, 0xf4665580, 0x47f68b40,
    0x3ecdf3a0, 0x2ae2e450, 0x2f32de08, 0xe92b9b34, 0xe456eb92, 0x785b8055,
    0x465fe003, 0x9b5b5029, 0xaade9807, 0x5c98a415, 0x43b95e16, 0xcae95b1c,
    0xbb310b93, 0x872cd06c, 0x31577803, 0xbddcf437, 0xae1a460c, 0x897c3f18,
    0x5a0a35a5, 0x8f031b51, 0xee828b9c, 0x10c21055, 0xfbe69826, 0x6cb4a42a,
    0x106f5e36, 0x55f65b12, 0x80000000, 0x40000000, 0x60000000, 0x30000000,
    0x08000000, 0x14000000, 0x22000000, 0x5d000000, 0x6c800000, 0x9ac00000,
    0x4ca00000, 0x54d00000, 0xbe780000, 0xbc6c0000, 0x00b60000, 0xeb090000,
    0x62468000, 0xb463c000, 0x2573e000, 0xb6283000, 0x90d7b800, 0xe47b2c00,
    0x9d69a200, 0x6a33db00, 0x06cae780, 0x0b65a340, 0x34f0a5a0, 0x106e4850,
    0x7eb5fa38, 0xe00cc71c, 0x41c2fd9a, 0x17245449, 0x8b95602a, 0x169bf002,
    0x6bdc580b, 0xde3f1c3d, 0x05081a0a, 0x7141f736, 0xdbe5c5b4, 0x8835b86d,
    0x7bc9a214, 0x37e3db23, 0x9632e793, 0x40c9a34e, 0x1c66a59c, 0x2177487a,
    0xcc2b7a1d, 0xe1d30725, 0xb6ff1d9a, 0x6ca96461, 0x35125816, 0xf95a1c22,
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x18000000, 0x54000000,
    0x0a000000, 0x29000000, 0x07800000, 0x2bc00000, 0x69600000, 0xb7900000,
    0xd6080000, 0xd85c0000, 0xda320000, 0x987f0000, 0x26808000, 0x10434000,
    0x24a36000, 0x19f77000, 0x5d19d800, 0x5f17d400, 0x4d4f3200, 0x9e7e5d00,
    0xb1814b80, 0xa4c592c0, 0x89e519a0, 0x10d0bff0, 0xf62f8a28, 0x74edf91c,
    0xda0d218e, 0x665c5bf9, 0x69328024, 0x1efc402f, 0x46c3e00b, 0x0ce4302c,
    0xd952b81d, 0x56eca432, 0x7f0cea2d, 0x1fda8911, 0xd1f4f982, 0x411b8fda,
    0x8915b205, 0x924e1d3f, 0xf6f8abbd, 0xeac2a2d8, 0xc2e5218e, 0x52505bd2,
    0x34688027, 0x0d4f4022, 0x7e796039, 0x2184703b, 0x80000000, 0xc0000000,
    0x60000000, 0x70000000, 0x48000000, 0xe4000000, 0x6e000000, 0x7f000000,
    0x27800000, 0x47c00000, 0x37a00000, 0x89d00000, 0xf9a80000, 0x81bc0000,
    0x2cb20000, 0xa15d0000, 0xb6848000, 0xdf47c000, 0x37e66000, 0x89b7d000,
    0x0fdac800, 0x15c1e400, 0x3aa67200, 0x73537b00, 0x1cef4f80, 0x8f5ffdc0,
    0x69875da0, 0xe8c756f0, 0x4820da38, 0x12144f2c, 0x0c0d758a, 0xfd6ba2e5,
    0xe39e8029, 0x3fa6c016, 0xcdd0e00a, 0x87ad1012, 0xc6b82816, 0xa731f40a,
    0x6c9ada28, 0x90254f1d, 0x0e13f5bc, 0xae0d62d9, 0x786e600b, 0x9d1bd00d,
    0xc4e0c806, 0xf430e429, 0x0118f217, 0xa6e5bb36, 0x1137afbb, 0x0f9eedf1,
    0x15a575ad, 0xccd7a2fc, 0x80000000, 0x40000000, 0xe0000000, 0xd0000000,
    0xb8000000, 0x44000000, 0xba000000, 0x81000000, 0x4e800000, 0x21c00000,
    0xda600000, 0x71500000, 0x82b80000, 0xac2c0000, 0x8ff60000, 0x7d0d0000,
    0xcf058000, 0x5d814000, 0xf240e000, 0x9b217000, 0x09f41800, 0xa20c5c00,
    0x8a82aa00, 0xdbc1d500, 0xbb602d80, 0xefd01140, 0x1b7a67a0, 0x324cb450,
    0x44a05218, 0x7eb1f924, 0x2dab1f96, 0xf3b0d865, 0x552e0020, 0x25710021,
    0xd6cb8005, 0xfc60401c, 0x9e53600b, 0xaf3d3005, 0xd6697838, 0x38d06c17,
    0x32f85210, 0x120df93c, 0xa2851fa6, 0xc7c1d854, 0x9565800f, 0x6cd1400a,
    0x90f8e025, 0xe70d7025, 0x3e02183d, 0x9b015c18, 0xff872a1e, 0x0740950b,
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xf8000000, 0xec000000,
    0xc6000000, 0x21000000, 0xd4800000, 0x52400000, 0x6ee00000, 0x16f00000,
    0x37080000, 0xb9bc0000, 0x37560000, 0xe59b0000, 0x27078000, 0x95874000,
    0xf6c1a000, 0x94a3d000, 0x6c10f800, 0x0bf8cc00, 0x69b60600, 0x7b6aed00,
    0x54086480, 0xfe3f1dc0, 0xca97c2a0, 0x42ba20d0, 0xecd15e28, 0x765af104,
    0xb5211ab6, 0xa0d67cef, 0xa05e002f, 0x4c270023, 0xc851800c, 0xcc1c4008,
    0xefc62010, 0xcc24902a, 0x88515827, 0xec1b1c23, 0xbfc6fe35, 0x34222103,
    0x6456629f, 0x2a19f0d9, 0x9ec1a619, 0xe0a23d3e, 0x36171ca3, 0x44fc91ca,
    0x88366496, 0xd7a81dd2, 0x8fae42ab, 0x73aa60c8, 0x80000000, 0x40000000,
    0xe0000000, 0x90000000, 0x88000000, 0xd4000000, 0x9a000000, 0x8b000000,
    0xd9800000, 0x60c00000, 0x06200000, 0xe4100000, 0x37680000, 0xb5bc0000,
    0xe1f60000, 0x08dd0000, 0xf4078000, 0xaa02c000, 0x7305e000, 0x1586f000,
    0xa6c4c800, 0xc3243400, 0x2c911a00, 0x052f6f00, 0x0adddd80, 0x63039dc0,
    0xdd8127a0, 0x92c602d0, 0xc9263218, 0x2f90ab34, 0x08af8f9a, 0xf01a06d1,
    0xee200024, 0xe0100007, 0xc5680028, 0x7abc001e, 0x2a760015, 0x371d0014,
    0xb1a7802a, 0xa5d2c036, 0x9bcde003, 0x24eaf037, 0x767ac804, 0x9a553411,
    0x0e089a2c, 0x124caf02, 0x6c29bd8d, 0xd45aadf7, 0xfc478fbf, 0xee6606cb,
    0x3076000d, 0xfc1d0028, 0x80000000, 0xc0000000, 0x60000000, 0xf0000000,
    0xa8000000, 0xe4000000, 0x5a000000, 0xa1000000, 0xa5800000, 0xb3c00000,
    0x22200000, 0xd9700000, 0x82680000, 0x1edc0000, 0x91920000, 0xc0bd0000,
    0x70008000, 0x6804c000, 0x84016000, 0xaa027000, 0x09029800, 0x41870400,
    0xe9c26200, 0x83218700, 0x7cf2f680, 0x31af46c0, 0x3cf9f4a0, 0x48e0b1f0,
    0x42d39a38, 0x6ed9f30c, 0xf9928cb2, 0x44bd05c5, 0xda00001c, 0x61000021,
    0xc5800027, 0x43c00038, 0x8a20000b, 0x3d700023, 0xd868003e, 0xbfdc0019,
    0x3412002d, 0x737d001b, 0x52208030, 0xb174c01c, 0x0669601d, 0xb4de7037,
    0x98909807, 0x813a040a, 0x99c2e224, 0xeb25472a, 0xf8f39684, 0x9bad36c6,
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x18000000, 0x0c000000,
    0xd2000000, 0xc9000000, 0xba800000, 0xdb400000, 0x72e00000, 0x4ef00000,
    0xcfc80000, 0x837c0000, 0xdcd60000, 0xa6190000, 0x85e38000, 0x3f764000,
    0x1f0ba000, 0x0c5e7000, 0xf1861800, 0x90c2fc00, 0xef221e00, 0xbd574500,
    0x2edc9480, 0x66c023c0, 0x50232aa0, 0xf8d016d0, 0xd01a2638, 0x7ae48934,
    0x1af0b29e, 0x71cdaae7, 0x08781812, 0xb757fc21, 0xcbdf9e02, 0xfe440520,
    0xca62b4b4, 0x24b113e6, 0x9bad12bb, 0xdccadad1, 0xa4fd8012, 0x0313400b,
    0x84be2014, 0xd2713012, 0xd38e3827, 0x281acc1d, 0xa6e7a616, 0xb0f7c90a,
    0x24ce9294, 0x78fc9ae1, 0xa9162038, 0xd1bd3016, 0x80000000, 0xc0000000,
    0x20000000, 0xf0000000, 0x68000000, 0xac000000, 0x1a000000, 0x63000000,
    0x24800000, 0x28c00000, 0x2c200000, 0xdf100000, 0xaf080000, 0x8fdc0000,
    0x36720000, 0xbb7f0000, 0xa3a28000, 0x4f52c000, 0xf9ef2000, 0x43ee3000,
    0x10ea8800, 0x7c6c5c00, 0x08ac3200, 0x568cff00, 0x469c1d80, 0xd710b6c0,
    0x130d0fa0, 0x2ddd79f0, 0x61711a28, 0x41ff530c, 0x5e650792, 0x3ef3e5d7,
    0x49ba083c, 0xcc819c03, 0x44c19207, 0x16200f2e, 0x4c11b598, 0xe38edad6,
    0x0b19b586, 0x0052dafc, 0x076bb587, 0x282ddacb, 0xe849359c, 0xe3bf1aed,
    0x27861589, 0x1c412adf, 0xbce49d8a, 0xc73176d4, 0xae1aaf98, 0xf5d289db,
    0xe42c3230, 0xe24cff11, 0x80000000, 0xc0000000, 0xe0000000, 0x30000000,
    0x28000000, 0x24000000, 0x8a000000, 0xb1000000, 0xe0800000, 0x0bc00000,
    0x61a00000, 0x46500000, 0x84a80000, 0xe43c0000, 0x77b20000, 0x39190000,
    0x4c228000, 0x0b16c000, 0x21cf6000, 0x0048f000, 0xe30a9800, 0x7d6eac00,
    0xc89f8a00, 0xb7631b00, 0x9976db80, 0x3a3cf9c0, 0x44b431a0, 0x9c9e12f0,
    0x3562f218, 0xdc76873c, 0x48bc29b2, 0xf2767ec5, 0xb3ba1808, 0x43f16c15,
    0x68fa6a22, 0x01912b22, 0x6b0923aa, 0x496fa5da, 0xba99a3bb, 0x3a6065f4,
    0xfff4439c, 0x2efe55c9, 0xfe91bb84, 0x808809e8, 0x3b2ca98a, 0x1479bee2,
    0x9c57f825, 0xedaf5c0a, 0xe8bf9229, 0xe277770a, 0x4bbc31b5, 0x7ff212ec,
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x18000000, 0xb4000000,
    0x02000000, 0x7b000000, 0xcc800000, 0xe1c00000, 0x19a00000, 0x80900000,
    0xeea80000, 0x06fc0000, 0x4e760000, 0x695b0000, 0xd7e78000, 0x40704000,
    0xb45c6000, 0x5a633000, 0xf2310800, 0x9ab91c00, 0xed97fa00, 0x4b2edb00,
    0x68ba0d80, 0x9e90efc0, 0x0baf97a0, 0x6f7a04d0, 0xe6351228, 0x88b8b704,
    0xae969f8e, 0x63af18f9, 0x937ce826, 0x48316c23, 0x45bd123b, 0x1b14b732,
    0x35e89fb3, 0xa79818f5, 0x30c5681d, 0x32262c2f, 0x73d0f213, 0x93ccc737,
    0x864a77a6, 0xc00e74c7, 0xcce9fa03, 0x5019db09, 0x3d838db9, 0x9a47afc6,
    0xf2e27792, 0x49f274f9, 0x6c1ffa1f, 0xf382db38, 0x80000000, 0xc0000000,
    0xa0000000, 0x90000000, 0x98000000, 0xbc000000, 0xae000000, 0x87000000,
    0xf0800000, 0xc7c00000, 0x0ca00000, 0xd5100000, 0x46080000, 0xa5dc0000,
    0x44f20000, 0x9d7b0000, 0xdbe58000, 0xee764000, 0x37bc2000, 0x82c01000,
    0x2d238800, 0xe9535c00, 0xdbe84a00, 0x18aaa300, 0x39cea980, 0x4578d6c0,
    0x07e0c3a0, 0x707565f0, 0xb8ba6208, 0x5643af14, 0xf8e34b8e, 0xccf639cb,
    0x797a282d, 0x69e50c3e, 0x5777e23f, 0xd839ef34, 0x09856b99, 0x484129eb,
    0xb7e62019, 0xb877100d, 0x3cbc0814, 0xd4421c1b, 0x49e3ea02, 0x0777f306,
    0xe03c8181, 0x2581dad3, 0x7e45218b, 0x8ce78afc, 0xe6f28980, 0x7c78c6e6,
    0x28634b8a, 0x5b3639e5, 0x80000000, 0xc0000000, 0x20000000, 0xd0000000,
    0x18000000, 0x64000000, 0x1e000000, 0x1b000000, 0x5a800000, 0xf1c00000,
    0x53a00000, 0xa1100000, 0xe2880000, 0x0f5c0000, 0x8bf20000, 0xa8ff0000,
    0xcce38000, 0xc5704000, 0x4f3ae000, 0xd8415000, 0x94e6e800, 0x41702c00,
    0xa13b2a00, 0x0b410b00, 0xb2606180, 0xcab462c0, 0xf79baba0, 0xebd739f0,
    0xfbaca228, 0x678c3704, 0x8edd438e, 0x00b715ed, 0xda9f8821, 0x26513c2f,
    0xe2ef2219, 0xbcec770e, 0x47efa384, 0xed6a45cd, 0xd4ab600b, 0xfb0e101d,
    0x201f8804, 0xc7913c21, 0x894f2203, 0xa9fc772a, 0xa367a39f, 0x9d3645c2,
    0x1bd96022, 0xb9311000, 0xe5dc0822, 0x52317c3f, 0x775dc229, 0xdff1271c,
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xf8000000, 0x14000000,
    0xce000000, 0x35000000, 0x00800000, 0xe3c00000, 0x97200000, 0xe7100000,
    0xd0e80000, 0xc73c0000, 0xc9760000, 0xf81d0000, 0xb2628000, 0xeaf44000,
    0xaa586000, 0x20035000, 0x90021800, 0x28060c00, 0xdc00ea00, 0x2205cf00,
    0xef032580, 0xfb80d1c0, 0xd645afa0, 0x74674ed0, 0x93f01218, 0xa0d8d31c,
    0xf0c7b786, 0xdea142c9, 0xf650f82d, 0x830d1c18, 0xa08c920b, 0xf2cd9339,
    0x60ab579b, 0x1a5b52c4, 0x98000002, 0x64000015, 0xd600003e, 0x1100003b,
    0x36800005, 0xc2c00038, 0x59a00001, 0x31d0000e, 0x4748003c, 0xc3ec0004,
    0x8ebe001a, 0xd8310001, 0xabfc8012, 0xd5d5400f, 0x80000000, 0x40000000,
    0x60000000, 0x10000000, 0x28000000, 0x14000000, 0x62000000, 0x87000000,
    0x8c800000, 0xbac00000, 0x5f200000, 0xb9d00000, 0xf8d80000, 0xeacc0000,
    0x74b60000, 0xdee90000, 0x3fe78000, 0x1df3c000, 0xdb8ae000, 0x5dd73000,
    0xe2dc6800, 0x31cffc00, 0x9e342200, 0xa92b5700, 0x7f447380, 0xf0670e40,
    0x41b4b1a0, 0xdd6e6950, 0x6da52a38, 0xa2105b14, 0x867ed992, 0xe6589541,
    0xaf0e8832, 0xfb14cc34, 0xbbfe4a23, 0x551dab0b, 0x516fd1be, 0x03a39945,
    0x0b142211, 0xc3fb5725, 0x091c7398, 0x376b0e67, 0xcea2b1af, 0x1497694b,
    0x97baaa27, 0x6bff9b1f, 0x5d1a39a2, 0x356aa543, 0x59a36035, 0xb011f03b,
    0x397f0813, 0x56de0c30, 0x80000000, 0xc0000000, 0x60000000, 0x50000000,
    0x98000000, 0xf4000000, 0xfa000000, 0xc7000000, 0x95800000, 0x80c00000,
    0xaaa00000, 0x17100000, 0xdb980000, 0x554c0000, 0xd4f20000, 0xd0ed0000,
    0xca658000, 0x2db04000, 0x34886000, 0x2ad6f000, 0xe3bb2800, 0x371a3400,
    0x750ffa00, 0xa012ab00, 0x26196180, 0x898cf240, 0xb854fba0, 0x96f9a970,
    0x4d793238, 0x50be2f24, 0x989dd3be, 0x52ce9d69, 0xcf334838, 0x29ccc43c,
    0x0cb4d203, 0x00089f05, 0x5e969ba9, 0x5d5e5958, 0xceed9a02, 0xcf655b11,
    0xbb35c9be, 0x13cb8655, 0xabb6e1ab, 0xc58db277, 0x46531b8f, 0x03fe1941,
    0x23fdfa3b, 0xd3ffab0a, 0x7bfce1bd, 0x47fcb273, 0xd1fc9bb2, 0x18ff5949,
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x28000000, 0xa4000000,
    0x7e000000, 0xe5000000, 0x8d800000, 0x8ec00000, 0x12600000, 0x1bf00000,
    0x14880000, 0xa6bc0000, 0xdad20000, 0x0bdf0000, 0x17a68000, 0xd914c000,
    0xd03d6000, 0xac915000, 0x62fb9800, 0x6cf36400, 0x360e6a00, 0x46ff8d00,
    0xd2f08080, 0xf309bdc0, 0xbb798aa0, 0x743460f0, 0x456e1228, 0xde89792c,
    0x85b81282, 0x6e5404f5, 0x8a9cf835, 0x9c013420, 0x62017234, 0x47072906,
    0xea850aad, 0x1443a0cc, 0x2e27f23e, 0x91d3e926, 0xfb586a98, 0xb8e2f0d4,
    0xefb46a1d, 0x6aac8d2b, 0x6f6c00a3, 0xad8e7dd1, 0x69386a93, 0x6312f0c8,
    0xdb3c6a23, 0xbc108d2f, 0x9dbe00a9, 0x02517df9, 0x80000000, 0xc0000000,
    0x20000000, 0xb0000000, 0x28000000, 0x3c000000, 0x6e000000, 0x07000000,
    0x81800000, 0x0f400000, 0x03600000, 0x59500000, 0xaff80000, 0xd06c0000,
    0x8fb20000, 0x4bef0000, 0x85f08000, 0x180ac000, 0xf165a000, 0x40511000,
    0x217b0800, 0xd2ac5400, 0xc5944600, 0x2adeb900, 0x9cdd2d80, 0x6fd93740,
    0x2c5c4ba0, 0xd21c5e70, 0x43ffce28, 0xc6682d1c, 0x0cb4cb82, 0x006a9e63,
    0xf7b06e31, 0xcfea3d3e, 0x4ff543b3, 0x650f0a6e, 0x25e3080a, 0xa790542a,
    0xabde4638, 0x065db90f, 0x3f1fada2, 0x0f7cf76a, 0x35a96bb9, 0xd4178e73,
    0xbd99663e, 0x8bb9693d, 0x64898595, 0xeaa77343, 0x84f18582, 0x428b7372,
    0x81a3859a, 0xd374734d, 0x80000000, 0x40000000, 0xa0000000, 0x10000000,
    0x18000000, 0xd4000000, 0x66000000, 0xfd000000, 0x4d800000, 0x8a400000,
    0xa1a00000, 0xe9700000, 0xcd380000, 0xe78c0000, 0x9f560000, 0xa90f0000,
    0x31918000, 0x096a4000, 0x1e076000, 0xd9071000, 0x83811800, 0xab43a400,
    0x4625ce00, 0x2c301700, 0xba1b1a80, 0x343e9840, 0x340834a0, 0x8c13df50,
    0x2b2d5608, 0x63a5f314, 0x9a77b4ae, 0x01ba9f71, 0x9a4db63f, 0xe3b7a31a,
    0xe3584ca2, 0x49186b59, 0xb8b8001d, 0xe9cc003d, 0xe0f6002a, 0x797f0038,
    0xcf298001, 0x4da64004, 0x0b71601a, 0xee38102d, 0x9308982b, 0x2695e42f,
    0xabecae28, 0x52c4070c, 0x5a65828e, 0xd8947c5a, 0xc2ed1abf, 0xd941984a,
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x28000000, 0xa4000000,
    0x2a000000, 0x9f000000, 0x32800000, 0xc4400000, 0xf7a00000, 0xed700000,
    0xf0680000, 0xffdc0000, 0x6e520000, 0x385b0000, 0x67958000, 0x093bc000,
    0x01056000, 0x6f86f000, 0x6dc1e800, 0xbb64cc00, 0x6997a600, 0x7c384700,
    0x0c841280, 0x094432c0, 0x762354a0, 0x05b145f0, 0x5e8bce08, 0xec8b4b14,
    0xaf8cd4a2, 0x9b0d85cd, 0xde492e20, 0x866d7b3e, 0xa6dddcae, 0x7dd479f2,
    0xc39a001b, 0x75f70013, 0x6b2f8023, 0x9afcc007, 0xd762e021, 0x17963029,
    0xd1390835, 0xbd05fc10, 0x59812e29, 0x54c17b17, 0x98e7dcbd, 0x2a5379c0,
    0xe25d8004, 0xe097c03c, 0x27bf602a, 0x6341f02c, 0x80000000, 0xc0000000,
    0xe0000000, 0x70000000, 0x48000000, 0x0c000000, 0xbe000000, 0x69000000,
    0x40800000, 0x35400000, 0x97e00000, 0x40300000, 0xb2180000, 0xa3ec0000,
    0xb1520000, 0xba690000, 0xac908000, 0x84cfc000, 0xfd412000, 0x5be01000,
    0x1e33f800, 0xab1aac00, 0xab681e00, 0x88143d00, 0x93884a80, 0x85a5f340,
    0x7651f4a0, 0x6bee1e70, 0x7d536618, 0xe46d512c, 0xb59374aa, 0x8c48de5f,
    0xc402c61d, 0x72028129, 0x3701ac87, 0x5982624b, 0x3dc12007, 0xaea0102e,
    0x69d3f81e, 0x9b2aac3e, 0x51701e02, 0x27f83d08, 0x9cda4a8d, 0x56ccf345,
    0x9a417488, 0xda61de62, 0x17f24629, 0xffbd412e, 0x19b88c80, 0x84be725e,
    0xde38d800, 0x407fbc12, 0x80000000, 0x40000000, 0x60000000, 0x30000000,
    0xe8000000, 0x34000000, 0x12000000, 0xfd000000, 0xe0800000, 0x50400000,
    0x2aa00000, 0xb3f00000, 0x05580000, 0x4a6c0000, 0xebd60000, 0x5be90000,
    0xe5168000, 0x720cc000, 0x77c1e000, 0x7362b000, 0x6b933800, 0xe948cc00,
    0xeae65600, 0x61579f00, 0x3aa85e80, 0xb1355f40, 0x92b968a0, 0x8bbcb050,
    0xe13bee38, 0xf07f931c, 0x2c59e8a2, 0xc8e97041, 0xce948e1e, 0x95cde322,
    0xfca530a4, 0x94f60c67, 0x7cd96028, 0x30ab7025, 0xb0325817, 0x043fbc0d,
    0xecfa0e39, 0x0a1d231d, 0xd54ad08d, 0xbce1bc59, 0x0652d83d, 0x232a7c16,
    0xfbf56e2f, 0x215f5310, 0xe06e08a2, 0xfad2c061, 0x75693637, 0x6e55ef11,
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xa8000000, 0x2c000000,
    0x96000000, 0x23000000, 0x15800000, 0xf1400000, 0x54600000, 0x8a900000,
    0xe0380000, 0xf06c0000, 0x9a720000, 0x67690000, 0x5df68000, 0xef2ec000,
    0x19172000, 0x0a7e5000, 0x658be800, 0x43a75400, 0xe237d600, 0xab8fd100,
    0xc4a62b80, 0x1db7e740, 0xf7c85da0, 0x2244a670, 0xc9e0be18, 0x07d3451c,
    0x3a5a5d92, 0xddfda667, 0xd5ce3e2f, 0xd3418533, 0xa5677d98, 0xe616f658,
    0x01f9561a, 0xcbcd1125, 0x8c430bb0, 0x3ee0b77a, 0xb0553591, 0xfa1d3262,
    0x05184819, 0x0e9ec414, 0xa0dd9e3e, 0x6f38151e, 0xb3ed35a3, 0xa831326a,
    0x968a480e, 0x8e27c439, 0x77731e01, 0xf5ead504, 0x80000000, 0x40000000,
    0xa0000000, 0xf0000000, 0xf8000000, 0x14000000, 0x3a000000, 0x89000000,
    0x9b800000, 0xbbc00000, 0x05e00000, 0x55700000, 0xb9080000, 0x7e3c0000,
    0x5c160000, 0x673f0000, 0x2f968000, 0x60fa4000, 0x0c766000, 0x6a8cf000,
    0x89fb5800, 0x87f1b400, 0x79481200, 0x901f9900, 0x0481c880, 0x674695c0,
    0xc6a13aa0, 0xf1d3bcd0, 0x25dbca08, 0x02676d2c, 0x78b73a96, 0xbbecbcf9,
    0xf3cd4a10, 0xb45d2d37, 0x28a15a80, 0xa2d04cf0, 0x675e1239, 0x2a20992e,
    0x2a974889, 0xc57cd5d4, 0xacb75a81, 0x61ef4cfd, 0x2ac8921b, 0x27dad91a,
    0x7f612896, 0x893025ca, 0x812c02a7, 0x81aef8c0, 0x74e88039, 0x27494022,
    0x9b1ee03a, 0xa205b03c, 0x80000000, 0x40000000, 0x60000000, 0xf0000000,
    0x88000000, 0x04000000, 0x5a000000, 0x45000000, 0x1b800000, 0xa2400000,
    0x68600000, 0x23900000, 0xedf80000, 0xe9ac0000, 0xf1760000, 0x9da90000,
    0x63708000, 0xbca9c000, 0xd2f36000, 0xd3ef7000, 0xa513b800, 0x083f5400,
    0x658c5e00, 0xd985d900, 0xdb451380, 0xc5e5e940, 0x6ad2ada0, 0x091a8050,
    0x32f96638, 0x972a4d2c, 0xd8b2adba, 0x2f8a807d, 0xa4816614, 0x2cc64d00,
    0xc9a4ad88, 0x95b38045, 0x7009e61e, 0x3cc38d31, 0xf1a1cdaf, 0x79b5f05f,
    0xde0ade03, 0xabc51924, 0xab26f3b0, 0x9a73596d, 0x512a7593, 0xfbb6a458,
    0xc7088015, 0xf645c024, 0x6a65602f, 0x7a967034, 0xd07b3809, 0xd8ea940c,
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xf8000000, 0x1c000000,
    0x2e000000, 0x0f000000, 0xc3800000, 0x24400000, 0xe6a00000, 0x72100000,
    0x2bd80000, 0x2c0c0000, 0xf4320000, 0x580f0000, 0xde338000, 0x950f4000,
    0x14b22000, 0x99c91000, 0x27d3c800, 0x083e0400, 0x543c8e00, 0x9a3a0f00,
    0x653f0980, 0x8ebef440, 0x4efa27a0, 0x9a5eab70, 0xc94ec628, 0x2e144b04,
    0xe5da27b6, 0xd30eab73, 0x1fb6c615, 0x98484b34, 0x0a9027b3, 0xc61dab7e,
    0xf3ef4617, 0x52040b22, 0x110387b0, 0xc484fb60, 0xd3c52e19, 0x08e05f23,
    0xa9b4e1b0, 0xbb4ae058, 0xef14e196, 0xd95ae076, 0x1ccce1ab, 0x3956e069,
    0x3efee187, 0x7259e040, 0x0d4d6190, 0xcc16a069, 0x80000000, 0x40000000,
    0x60000000, 0xf0000000, 0x28000000, 0x24000000, 0x9e000000, 0x4d000000,
    0x34800000, 0x63c00000, 0xf1a00000, 0x9c700000, 0x95680000, 0xb45c0000,
    0x98560000, 0xa4590000, 0x00508000, 0xc85cc000, 0x4a576000, 0x33585000,
    0x17d0d800, 0xfa1f6c00, 0xc8b00a00, 0xa34a5b00, 0xa2687a80, 0x73d99ec0,
    0x121790a0, 0xdabb55d0, 0x02465238, 0x8ae0f72c, 0x24179092, 0xf3bb55f5,
    0xc8c6520d, 0x5420f70a, 0xc93790b2, 0x280b55f7, 0x320e521b, 0x310cf726,
    0xf08990a6, 0x5bce55e5, 0x5ba8d224, 0xc1793705, 0x2fe670a5, 0x1496c5d3,
    0x9e796a10, 0xac670b12, 0xf0d622b2, 0x859f32d3, 0xbef67ab5, 0x4fac9ec8,
    0x5779108d, 0xd6e295c9, 0x80000000, 0xc0000000, 0x20000000, 0x30000000,
    0x88000000, 0xbc000000, 0x26000000, 0x0d000000, 0x35800000, 0x76c00000,
    0x5ee00000, 0xb7500000, 0x75880000, 0x139c0000, 0x19320000, 0xdd9f0000,
    0x78348000, 0x561bc000, 0x07f4a000, 0x2f7b5000, 0x51601800, 0x1a93a400,
    0xbbee6a00, 0x6b894900, 0xea999180, 0x96b328c0, 0xb05fdba0, 0x9656f1f0,
    0x1e08f228, 0x7c5e2d3c, 0xd857dbaa, 0xbf0af1e3, 0xd7daf20b, 0x97912d1c,
    0x4e6b5b8c, 0x3d4d31d2, 0x847c5218, 0xa9e57d2f, 0x79d7c38b, 0xa3c955e6,
    0x0a3c9814, 0x94446431, 0xd6a0ca0e, 0xb7f11900, 0x677f09ad, 0xcd644ce8,
    0x0c9191ad, 0x3eef28e4, 0xe20ddb9c, 0xba59f1ec, 0xc554720e, 0x3289ed3d,
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x18000000, 0x1c000000,
    0xf2000000, 0xd1000000, 0xc6800000, 0xdb400000, 0x24a00000, 0x34f00000,
    0xdbf80000, 0x24cc0000, 0x2fd60000, 0xb6cd0000, 0x0ed68000, 0x884f4000,
    0x79932000, 0x46e8f000, 0x8062d800, 0xa997dc00, 0xaee8be00, 0x64601700,
    0xf793e680, 0x95e8ca40, 0x6fe6f8a0, 0x18536d50, 0xbb0ae618, 0xb9358b3c,
    0x2c1ef8be, 0x609f6d6b, 0x86dce61a, 0x6ef88b23, 0xfc4878b5, 0x2f902d6e,
    0x29efc61e, 0xcde07b2c, 0x6152a0bb, 0x798bf15c, 0x8c71782a, 0x2bbd6c05,
    0x43efc605, 0x40e07b1a, 0xb5d2a09c, 0xc3cbf14b, 0x76517820, 0xd80d6c3f,
    0x4eb7c637, 0x81dc7b02, 0x877ca08c, 0x8a8af14a, 0x80000000, 0x40000000,
    0x20000000, 0xf0000000, 0xe8000000, 0xb4000000, 0x0a000000, 0x6d000000,
    0xa7800000, 0x73400000, 0x11e00000, 0x3a300000, 0x7e680000, 0xcd9c0000,
    0xfed60000, 0x0fdb0000, 0xb6b28000, 0x01aac000, 0xe3bfe000, 0xcac47000,
    0xb5a77800, 0x29557400, 0xd49e3600, 0x33569d00, 0xc19b9280, 0x18d780c0,
    0x14dec4a0, 0x3234add0, 0x5a6f4e28, 0xff98e92c, 0x3fd724b2, 0xfe5bddd1,
    0x16f2b618, 0xd0cb5d26, 0x6048f2a3, 0x718e30fb, 0x20aadcb7, 0x823869ef,
    0x52856031, 0xc8c2b00a, 0xfca6983b, 0xbcd6043d, 0x66ddce2e, 0xd332293b,
    0x5be8c4a1, 0xb7dfadc6, 0x5ab5ce27, 0x77ae2939, 0xc0bec4a6, 0xe244adc7,
    0xb8674e07, 0xe674e935, 0x80000000, 0xc0000000, 0x20000000, 0x70000000,
    0x58000000, 0xe4000000, 0x92000000, 0x59000000, 0x64800000, 0x2b400000,
    0x64600000, 0xf7100000, 0xa2a80000, 0xeb7c0000, 0x1e720000, 0x1b3f0000,
    0x8f968000, 0x4fef4000, 0x3c18e000, 0x40e23000, 0x3c539800, 0x96cc4c00,
    0x346bae00, 0x00df5100, 0x86470f80, 0x5ae12fc0, 0x6950c1a0, 0xfc4c0ef0,
    0x402a3628, 0x933c1d2c, 0x8392219e, 0x41ed3ee5, 0x631d2e12, 0xb760111f,
    0xce97efb5, 0x2f6f1fc0, 0xd55959b6, 0x558342fe, 0x13c5183d, 0x69230c3d,
    0x70734e28, 0xd43d6113, 0x7014978f, 0x712d63c7, 0xabbb6f99, 0x8ed35fd5,
    0xc68d39af, 0x158d32e8, 0x2c0ae02e, 0xa1cd3024, 0x9fed1836, 0xd41f0c09,
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x58000000, 0x84000000,
    0x4a000000, 0x1d000000, 0x83800000, 0xfec00000, 0x52200000, 0x5ad00000,
    0xf3f80000, 0x6d6c0000, 0x0bf60000, 0x75af0000, 0x32d48000, 0x6ffd4000,
    0x036fe000, 0xecf5f000, 0xb32f7800, 0xcb945400, 0x891cfa00, 0x169a6f00,
    0xc659ab80, 0xd379c740, 0xff2831a0, 0xad941850, 0xa21d8208, 0xf61d3b3c,
    0xb41fd1be, 0x651de84d, 0xc09cfa24, 0xb55a6f36, 0xb7f9ab9a, 0xc769c754,
    0x06f03182, 0x1e281858, 0x10138232, 0xf3de3b36, 0x0ebd51a0, 0x818fa874,
    0xa3079a3e, 0x6c82df26, 0xf44133aa, 0x8d64636f, 0x3735b3ac, 0xb689234c,
    0x6d8253b0, 0x59c0d35a, 0x34a32b93, 0x1397876e,
};

const uint64_t SobolMatrices64[NumSobolDimensions * SobolMatrixSize] = {
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x0001000000000000, 0x0000800000000000, 0x0000400000000000,
    0x0000200000000000, 0x0000100000000000, 0x0000080000000000,
    0x0000040000000000, 0x0000020000000000, 0x0000010000000000,
    0x0000008000000000, 0x0000004000000000, 0x0000002000000000,
    0x0000001000000000, 0x0000000800000000, 0x0000000400000000,
    0x0000000200000000, 0x0000000100000000, 0x0000000080000000,
    0x0000000040000000, 0x0000000020000000, 0x0000000010000000,
    0x0000000008000000, 0x0000000004000000, 0x0000000002000000,
    0x0000000001000000, 0x0000000000800000, 0x0000000000400000,
    0x0000000000200000, 0x0000000000100000, 0x0000000000080000,
    0x0000000000040000, 0x0000000000020000, 0x0000000000010000,
    0x0000000000008000, 0x0000000000004000, 0x0000000000002000,
    0x0000000000001000, 0x0000000000000800, 0x0000000000000400,
    0x0000000000000200, 0x0000000000000100, 0x0000000000000080,
    0x0000000000000040, 0x0000000000000020, 0x0000000000000010,
    0x0000000000000008, 0x0000000000000004, 0x0000000000000002,
    0x0000000000000001, 0x0008000000000000, 0x000c000000000000,
    0x000a000000000000, 0x000f000000000000, 0x0008800000000000,
    0x000cc00000000000, 0x000aa00000000000, 0x000ff00000000000,
    0x0008080000000000, 0x000c0c0000000000, 0x000a0a0000000000,
    0x000f0f0000000000, 0x0008888000000000, 0x000cccc000000000,
    0x000aaaa000000000, 0x000ffff000000000, 0x0008000800000000,
    0x000c000c00000000, 0x000a000a00000000, 0x000f000f00000000,
    0x0008800880000000, 0x000cc00cc0000000, 0x000aa00aa0000000,
    0x000ff00ff0000000, 0x0008080808000000, 0x000c0c0c0c000000,
    0x000a0a0a0a000000, 0x000f0f0f0f000000, 0x0008888888800000,
    0x000cccccccc00000, 0x000aaaaaaaa00000, 0x000ffffffff00000,
    0x0008000000080000, 0x000c0000000c0000, 0x000a0000000a0000,
    0x000f0000000f0000, 0x0008800000088000, 0x000cc000000cc000,
    0x000aa000000aa000, 0x000ff000000ff000, 0x0008080000080800,
    0x000c0c00000c0c00, 0x000a0a00000a0a00, 0x000f0f00000f0f00,
    0x0008888000088880, 0x000cccc0000cccc0, 0x000aaaa0000aaaa0,
    0x000ffff0000ffff0, 0x0008000800080008, 0x000c000c000c000c,
    0x000a000a000a000a, 0x000f000f000f000f, 0x0008000000000000,
    0x000c000000000000, 0x0006000000000000, 0x0009000000000000,
    0x000e800000000000, 0x0005c00000000000, 0x0008e00000000000,
    0x000c500000000000, 0x0006880000000000, 0x0009cc0000000000,
    0x000ee60000000000, 0x0005590000000000, 0x0008068000000000,
    0x000c09c000000000, 0x00060ee000000000, 0x0009055000000000,
    0x000e880800000000, 0x0005cc0c00000000, 0x0008e60600000000,
    0x000c590900000000, 0x0006868e80000000, 0x0009c9c5c0000000,
    0x000eeee8e0000000, 0x0005555c50000000, 0x0008000e88000000,
    0x000c0005cc000000, 0x00060008e6000000, 0x0009000c59000000,
    0x000e800686800000, 0x0005c009c9c00000, 0x0008e00eeee00000,
    0x000c500555500000, 0x0006880800080000, 0x0009cc0c000c0000,
    0x000ee60600060000, 0x0005590900090000, 0x0008068e800e8000,
    0x000c09c5c005c000, 0x00060ee8e008e000, 0x0009055c500c5000,
    0x000e880e88068800, 0x0005cc05cc09cc00, 0x0008e608e60ee600,
    0x000c590c59055900, 0x0006868686880680, 0x0009c9c9c9cc09c0,
    0x000eeeeeeee60ee0, 0x0005555555590550, 0x0008000000068808,
    0x000c00000009cc0c, 0x00060000000ee606, 0x0009000000055909,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x0005000000000000, 0x000f800000000000, 0x0007400000000000,
    0x000a200000000000, 0x0009300000000000, 0x000d880000000000,
    0x0002540000000000, 0x00059e0000000000, 0x000e6d0000000000,
    0x0007808000000000, 0x000b40c000000000, 0x0008202000000000,
    0x000c305000000000, 0x000208f800000000, 0x0005147400000000,
    0x000fbea200000000, 0x00075d9300000000, 0x000a085880000000,
    0x000914e540000000, 0x000dbe79e0000000, 0x00025db6d0000000,
    0x0005880008000000, 0x000e54000c000000, 0x00079e0002000000,
    0x000b6d0005000000, 0x000800800f800000, 0x000c00c007400000,
    0x000200200a200000, 0x0005005009300000, 0x000f80f80d880000,
    0x0007407402540000, 0x000a20a2059e0000, 0x000930930e6d0000,
    0x000d88d887808000, 0x000254254b40c000, 0x00059e59e8202000,
    0x000e6de6dc305000, 0x000780f80a08f800, 0x000b407409147400,
    0x000820a20dbea200, 0x000c3093025d9300, 0x000208d885885880,
    0x000514254e54e540, 0x000fbe59e79e79e0, 0x00075de6db6db6d0,
    0x000a08f800000008, 0x000914740000000c, 0x000dbea200000002,
    0x00025d9300000005, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x000b000000000000, 0x000f800000000000,
    0x000dc00000000000, 0x0007a00000000000, 0x0009d00000000000,
    0x0005a80000000000, 0x0002fc0000000000, 0x000a160000000000,
    0x000f0b0000000000, 0x000da88000000000, 0x0006fc4000000000,
    0x0008162000000000, 0x00040bb000000000, 0x0002287800000000,
    0x000b3c9c00000000, 0x000fb65a00000000, 0x000ddb2d00000000,
    0x0007802280000000, 0x0009c0b3c0000000, 0x0005a0fb60000000,
    0x0002d0ddb0000000, 0x000a287808000000, 0x000f3c9c04000000,
    0x000db65a02000000, 0x0006db2d0b000000, 0x000800228f800000,
    0x000400b3cdc00000, 0x000200fb67a00000, 0x000b00ddb9d00000,
    0x000f80780da80000, 0x000dc09c06fc0000, 0x0007a05a08160000,
    0x0009d02d040b0000, 0x0005a8a282288000, 0x0002fcf3cb3c4000,
    0x000a16db6fb62000, 0x000f0b6dbddbb000, 0x000da8000f807800,
    0x0006fc000dc09c00, 0x0008160007a05a00, 0x00040b0009d02d00,
    0x0002288005a8a280, 0x000b3c4002fcf3c0, 0x000fb6200a16db60,
    0x000ddbb00f0b6db0, 0x000780780da80008, 0x0009c09c06fc0004,
    0x0005a05a08160002, 0x0002d02d040b000b, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x0003000000000000,
    0x000c800000000000, 0x0002400000000000, 0x0005600000000000,
    0x000fb00000000000, 0x000e080000000000, 0x0007040000000000,
    0x000a860000000000, 0x0001430000000000, 0x0009ec8000000000,
    0x000df24000000000, 0x000b6d6000000000, 0x0008bbb000000000,
    0x0004800800000000, 0x0006400400000000, 0x0003600600000000,
    0x000cb00300000000, 0x0002880c80000000, 0x0005440240000000,
    0x000fe60560000000, 0x000ef30fb0000000, 0x0007e48e08000000,
    0x000af64704000000, 0x0001eb6a86000000, 0x0009f8b143000000,
    0x000d6c81ec800000, 0x000bb249f2400000, 0x00080d6d6d600000,
    0x00040bbbbbb00000, 0x0006080000080000, 0x0003040000040000,
    0x000c860000060000, 0x0002430000030000, 0x00056c80000c8000,
    0x000fb24000024000, 0x000e0d6000056000, 0x00070bb0000fb000,
    0x000a8808000e0800, 0x0001440400070400, 0x0009e606000a8600,
    0x000df30300014300, 0x000b648c8009ec80, 0x0008b642400df240,
    0x00048b65600b6d60, 0x000648bfb008bbb0, 0x0003648608048008,
    0x000cb64304064004, 0x00028b6c86036006, 0x000548b2430cb003,
    0x0008000000000000, 0x000c000000000000, 0x000a000000000000,
    0x000d000000000000, 0x0005800000000000, 0x0009400000000000,
    0x0003e00000000000, 0x000e300000000000, 0x000be80000000000,
    0x00023c0000000000, 0x0001e20000000000, 0x000f310000000000,
    0x0004678000000000, 0x0006784000000000, 0x0007846000000000,
    0x0008467000000000, 0x000c678800000000, 0x000a784c00000000,
    0x000d846a00000000, 0x0005467d00000000, 0x0009e78d80000000,
    0x0003384540000000, 0x000e6469e0000000, 0x000b767330000000,
    0x00020f8668000000, 0x000104477c000000, 0x000f866802000000,
    0x0004477c01000000, 0x000668020f800000, 0x00077c0104400000,
    0x0008020f86600000, 0x000c010447700000, 0x000a0f8668080000,
    0x000d04477c0c0000, 0x00058668020a0000, 0x0009477c010d0000,
    0x0003e8020f858000, 0x000e3c0104494000, 0x000be20f8663e000,
    0x00023104477e3000, 0x0001e7866803e800, 0x000f38477c0e3c00,
    0x00046468020be200, 0x0006767c01023100, 0x00078f820f81e780,
    0x00084441044f3840, 0x000c666f86646460, 0x000a777447767670,
    0x000d800e680f8f88, 0x0005400b7c04444c, 0x0009e0020206666a,
    0x000330010107777d, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x0005000000000000, 0x0008800000000000,
    0x0002400000000000, 0x0001200000000000, 0x0002d00000000000,
    0x0007680000000000, 0x0009e40000000000, 0x0000820000000000,
    0x0006410000000000, 0x000b228000000000, 0x0007d14000000000,
    0x000fea2000000000, 0x000ba49000000000, 0x0001a24800000000,
    0x000491b400000000, 0x000c4b5a00000000, 0x000e373900000000,
    0x000f680080000000, 0x000de40040000000, 0x000a8200a0000000,
    0x0003410050000000, 0x0003a28088000000, 0x0005914024000000,
    0x000eca2012000000, 0x000974902d000000, 0x0006ca4876800000,
    0x000d75b49e400000, 0x000cc95a08200000, 0x0008763964100000,
    0x00044a8032280000, 0x000a35403d140000, 0x000568205ea20000,
    0x0008e590ea490000, 0x000200c892248000, 0x000100f46d1b4000,
    0x0002817ad6b5a000, 0x000743a9ce739000, 0x0009a24800000800,
    0x000091b400000400, 0x00064b5a00000a00, 0x000b373900000500,
    0x0007e80080000880, 0x000fa40040000240, 0x000ba200a0000120,
    0x00019100500002d0, 0x0004ca8088000768, 0x000c7540240009e4,
    0x000e482012000082, 0x000f35902d000641, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x0005000000000000,
    0x0002800000000000, 0x000d400000000000, 0x0006a00000000000,
    0x0007100000000000, 0x0003880000000000, 0x0005840000000000,
    0x000ea20000000000, 0x0003110000000000, 0x00098a8000000000,
    0x0000854000000000, 0x000c22a000000000, 0x000e525000000000,
    0x000f2b2800000000, 0x0007948400000000, 0x000faa4200000000,
    0x000bd73100000000, 0x00018a8080000000, 0x0004854040000000,
    0x000622a0a0000000, 0x000b525050000000, 0x000dab2828000000,
    0x000ad484d4000000, 0x00090a426a000000, 0x000cc73171000000,
    0x00020280b8800000, 0x0001014018400000, 0x000880a04a200000,
    0x0008435061100000, 0x000421a8b0a80000, 0x000a51c4dc540000,
    0x000528e2a82a0000, 0x0002956194250000, 0x000d29a84a328000,
    0x000695c461084000, 0x00072ae2b0842000, 0x00039461dc631000,
    0x0005ab2828000800, 0x000ed484d4000400, 0x00030a426a000a00,
    0x0009c73171000500, 0x00008280b8800280, 0x000c414018400d40,
    0x000e20a04a2006a0, 0x000f535061100710, 0x0007a9a8b0a80388,
    0x000fd5c4dc540584, 0x000b8ae2a82a0ea2, 0x0001846194250311,
    0x0008000000000000, 0x0004000000000000, 0x000e000000000000,
    0x000b000000000000, 0x0009800000000000, 0x0009400000000000,
    0x0008a00000000000, 0x0005b00000000000, 0x0003380000000000,
    0x000d9c0000000000, 0x0007220000000000, 0x0003f10000000000,
    0x000c1b8000000000, 0x000a6ec000000000, 0x0005386000000000,
    0x00029f5000000000, 0x0000a3a800000000, 0x0001b2ac00000000,
    0x000d392e00000000, 0x00069ff700000000, 0x000ea38080000000,
    0x000ab2c040000000, 0x0004ba60e0000000, 0x000fde50b0000000,
    0x0006002898000000, 0x000f006c94000000, 0x0007834e8a000000,
    0x000241a75b000000, 0x000123a8b3800000, 0x000cf2ac99c00000,
    0x000b992e92200000, 0x00082ff78f100000, 0x00041b80d9b80000,
    0x000e6ec072ec0000, 0x000b386039860000, 0x00099f50c2f50000,
    0x000923a8a1ba8000, 0x0008f2ac56eac000, 0x0005992e2bb2e000,
    0x00032ff70def7000, 0x000d9b8098000800, 0x00072ec094000400,
    0x000398608a000e00, 0x000c2f505b000b00, 0x000a1ba833800980,
    0x00056eacd9c00940, 0x0002bb2e722008a0, 0x0000def73f1005b0,
    0x0001800041b80338, 0x000d4000e6ec0d9c, 0x0006a000b3860722,
    0x000eb00099f503f1, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x0001000000000000, 0x0000800000000000,
    0x0006c00000000000, 0x0009e00000000000, 0x0002300000000000,
    0x0005780000000000, 0x000adc0000000000, 0x0007fa0000000000,
    0x00091d0000000000, 0x0004988000000000, 0x000ced4000000000,
    0x000880a000000000, 0x0002c0f000000000, 0x0003e0d800000000,
    0x0003317c00000000, 0x0005fb0600000000, 0x000c1f8b00000000,
    0x000e18d880000000, 0x000b2d7c40000000, 0x0001e106a0000000,
    0x0006328b10000000, 0x000f785888000000, 0x000bdc3c2c000000,
    0x00077ba63e000000, 0x000fdf7b33000000, 0x000d7800df800000,
    0x000edc0081c00000, 0x000dfa0041a00000, 0x00081d00a2d00000,
    0x0004188016080000, 0x000a2d400f140000, 0x000160a069aa0000,
    0x0000f0f09edf0000, 0x000698d820058000, 0x0009ed7c5003c000,
    0x00020106a81a6000, 0x0005028b7c27b000, 0x000a805816080800,
    0x0007c03c0f140400, 0x000961a669aa0a00, 0x0004f27b9edf0100,
    0x000c9880a0058080, 0x0008ed401003c6c0, 0x000280a0081a69e0,
    0x0003c0f06c27b230, 0x000360d89e080d78, 0x0005f17c23140edc,
    0x000c1b0657aa0dfa, 0x000e2f8baddf081d, 0x0008000000000000,
    0x0004000000000000, 0x0002000000000000, 0x0003000000000000,
    0x0005800000000000, 0x000ac00000000000, 0x0009600000000000,
    0x0002b00000000000, 0x000d480000000000, 0x0000940000000000,
    0x000e2a0000000000, 0x0005250000000000, 0x0004e28000000000,
    0x000c71c000000000, 0x000629e000000000, 0x0001267000000000,
    0x0006e13800000000, 0x000f731c00000000, 0x0003a98a00000000,
    0x000be44900000000, 0x000f83b880000000, 0x000dc2dc40000000,
    0x000ee06a20000000, 0x000b723930000000, 0x0001aa80d8000000,
    0x0008e5c0ec000000, 0x000a03e0b6000000, 0x000703701b000000,
    0x000783b88c800000, 0x0009c2dca5400000, 0x000ce06a74a00000,
    0x0008723979500000, 0x00042a801aa80000, 0x000225c08e5c0000,
    0x000363e0a03e0000, 0x0005b37070370000, 0x000acbb8783b8000,
    0x000956dc9c2dc000, 0x0002ca6ace06a000, 0x000d573987239000,
    0x0000c800c2a80800, 0x000e5400625c0400, 0x00054a00163e0200,
    0x000495006b370300, 0x000c2a80f4bb8580, 0x000625c0396dcac0,
    0x000163e0baa6a960, 0x0006b370fe7392b0, 0x000f4bb8d8000548,
    0x000396dcec000494, 0x000baa6ab6000c2a, 0x000fe7391b000625,
    0x0008000000000000, 0x000c000000000000, 0x000a000000000000,
    0x0005000000000000, 0x000f800000000000, 0x0008c00000000000,
    0x000e200000000000, 0x0003300000000000, 0x0000f80000000000,
    0x0002140000000000, 0x00095a0000000000, 0x0005e70000000000,
    0x000d808000000000, 0x0001c24000000000, 0x000ba16000000000,
    0x000ef37000000000, 0x0001586800000000, 0x0009e6fc00000000,
    0x000781b600000000, 0x0004c34900000000, 0x000420e880000000,
    0x000630bcc0000000, 0x000f7ad6a0000000, 0x000ad73950000000,
    0x0007780078000000, 0x0006d4004c000000, 0x000d7a0042000000,
    0x0003d70063000000, 0x0002f880f7800000, 0x000b1640ad400000,
    0x000cdb6077a00000, 0x000824706d700000, 0x000c20e8d7880000,
    0x000a30bc3d640000, 0x00057ad62fb60000, 0x000fd739b1470000,
    0x0008f8004d8e8000, 0x000e1400424bc000, 0x00035a00620d6000,
    0x0000e700f3039000, 0x00020080af880800, 0x0009024071640c00,
    0x000581606db60a00, 0x000dc370d2470500, 0x0001a0683a0e8f80,
    0x000bf2fc2f0bc8c0, 0x000edbb6b5ad6e20, 0x00012449ce739330,
    0x0009a068000008f8, 0x0007f2fc00000e14, 0x0004dbb60000035a,
    0x00042449000000e7, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x0009000000000000, 0x0003800000000000,
    0x000c400000000000, 0x0004200000000000, 0x000a300000000000,
    0x000f180000000000, 0x000aa40000000000, 0x000fce0000000000,
    0x0008510000000000, 0x000e008000000000, 0x000500c000000000,
    0x0005806000000000, 0x0005409000000000, 0x0007a03800000000,
    0x000670c400000000, 0x000b384200000000, 0x000094a300000000,
    0x0000d6f180000000, 0x0002f5aa40000000, 0x0001ce7ce0000000,
    0x000d514510000000, 0x000b800008000000, 0x000040000c000000,
    0x0002200006000000, 0x0003300009000000, 0x000c980003800000,
    0x0006e4000c400000, 0x000bee0004200000, 0x000261000a300000,
    0x000118800f180000, 0x000fa4c00aa40000, 0x000a4e600fce0000,
    0x000d119008510000, 0x0009a0b80e008000, 0x000370040500c000,
    0x000eb82205806000, 0x0005d43305409000, 0x000776c987a03800,
    0x0004856e4670c400, 0x000af63eeb384200, 0x000dc5e61094a300,
    0x000b56f188d6f180, 0x0002b5aa4ef5aa40, 0x0003ee7ce7ce7ce0,
    0x000e614514514510, 0x0007180000000008, 0x0006a4000000000c,
    0x0009ce0000000006, 0x0001510000000009, 0x0008000000000000,
    0x0004000000000000, 0x0002000000000000, 0x000f000000000000,
    0x000a800000000000, 0x0005400000000000, 0x0009a00000000000,
    0x0009d00000000000, 0x0001e80000000000, 0x0005cc0000000000,
    0x0007d20000000000, 0x0008d10000000000, 0x0002488000000000,
    0x00071c4000000000, 0x000eba2000000000, 0x00075df000000000,
    0x0006ba2800000000, 0x00035d1400000000, 0x0004ba3a00000000,
    0x000c5d2d00000000, 0x000e3a1680000000, 0x00091db8c0000000,
    0x00079aef20000000, 0x0000cdf410000000, 0x000672a808000000,
    0x0005015404000000, 0x0001a01a02000000, 0x000dd0dd0f000000,
    0x0003e83e8a800000, 0x000accacc5400000, 0x000d52d529a00000,
    0x000d91d919d00000, 0x000be83e89e80000, 0x000eccacc1cc0000,
    0x000f52d525d20000, 0x000291d917d10000, 0x0001683e80c88000,
    0x000b8cacc65c4000, 0x0006f2d5251a2000, 0x000b41d9118df000,
    0x0000803e85d22800, 0x000e40acc7d11400, 0x000120d528c83a00,
    0x000390d9125c2d00, 0x0002c8be8f1a9680, 0x00095cecca8df8c0,
    0x000f9af52552cf20, 0x0004cd2919910410, 0x0004729681e80008,
    0x000a01f8c5cc0004, 0x000b20cf27d20002, 0x0008900418d1000f,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x000d000000000000, 0x000d800000000000, 0x000c400000000000,
    0x0004600000000000, 0x0008500000000000, 0x000a580000000000,
    0x00076c0000000000, 0x000ada0000000000, 0x0006ab0000000000,
    0x0002da8000000000, 0x000aabc000000000, 0x0000daa000000000,
    0x0007ab1000000000, 0x000d5a7800000000, 0x000bebd400000000,
    0x00093a3e00000000, 0x0003bb5100000000, 0x0003629b80000000,
    0x0004d727c0000000, 0x0009b83620000000, 0x00027c4d70000000,
    0x000b629b88000000, 0x0008d727cc000000, 0x000bb83622000000,
    0x000f7c4d7d000000, 0x0006e29b85800000, 0x00049727c0400000,
    0x000fd83626600000, 0x00072c4d75500000, 0x000cba9b8fd80000,
    0x0003fb27c72c0000, 0x000502362cba0000, 0x0001874d73fb0000,
    0x000e601b8d028000, 0x000950e7cd87c000, 0x0005d8962c60a000,
    0x00062c5d74501000, 0x00033a638058f800, 0x0002bb33c66c1400,
    0x000ce2a8255a9e00, 0x0005970c77eb4100, 0x000058f8033a6380,
    0x00066c1402bb33c0, 0x00055a9e0ce2a820, 0x0007eb4105970c70,
    0x000b3a638058f808, 0x000ebb33c66c140c, 0x000ee2a8255a9e02,
    0x0008970c77eb410d, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x000f000000000000, 0x0003800000000000,
    0x0001400000000000, 0x000f600000000000, 0x0006700000000000,
    0x0008f80000000000, 0x0005040000000000, 0x0008aa0000000000,
    0x0000ff0000000000, 0x00012a8000000000, 0x000abf4000000000,
    0x000fcaa000000000, 0x00028fb000000000, 0x000bd29800000000,
    0x0000bba400000000, 0x0004e06e00000000, 0x000330c300000000,
    0x0005986180000000, 0x000c74d340000000, 0x0003d2cb20000000,
    0x0004bb2cb0000000, 0x0006e06188000000, 0x000c30d344000000,
    0x000618cb22000000, 0x000d342cbf000000, 0x000cb2e18b800000,
    0x0002cb9345400000, 0x000e186b2d600000, 0x0009349cb9700000,
    0x000eb2f983780000, 0x000dcb7740440000, 0x000d98a525ca0000,
    0x000874efb98f0000, 0x0001d28002528000, 0x000bbb400afb4000,
    0x000560a00a00a000, 0x000d70b00b00b000, 0x0009781801801800,
    0x000b44e40e40e400, 0x00044ace0ce0ce00, 0x0007cf7307307300,
    0x0006b2f987987980, 0x0009cb7743743740, 0x000f98a520520520,
    0x000774efb5fb5fb0, 0x0002528001801808, 0x000afb400e40e404,
    0x000a00a00ce0ce02, 0x000b00b00730730f, 0x0008000000000000,
    0x000c000000000000, 0x0002000000000000, 0x000f000000000000,
    0x0006800000000000, 0x0006400000000000, 0x0003600000000000,
    0x0006d00000000000, 0x0004180000000000, 0x000e040000000000,
    0x000d2e0000000000, 0x0009bf0000000000, 0x0000ce8000000000,
    0x00052fc000000000, 0x0005b6a000000000, 0x0002fb3000000000,
    0x000a00c800000000, 0x0003005400000000, 0x0004807e00000000,
    0x000940f900000000, 0x0005e01f80000000, 0x000090e940000000,
    0x000778a560000000, 0x0008d416b0000000, 0x0009369f88000000,
    0x0007bb294c000000, 0x000de00562000000, 0x000c9026bf000000,
    0x000578d78e800000, 0x0007d4bd4a400000, 0x000fb6db61600000,
    0x0001fbefb9d00000, 0x000e80000a980000, 0x000a400004440000,
    0x000160000c4e0000, 0x0009d000006f0000, 0x0002980002568000,
    0x000844000d6bc000, 0x000e4e000bf8a000, 0x000f6f000d943000,
    0x0004d6800ed64800, 0x000b2bc0082b9400, 0x000898a00c18de00,
    0x000b44300204c900, 0x000ace480f2e5780, 0x00062f9406bf7d40,
    0x000136de064e7b60, 0x000bbbc9036fdfb0, 0x000fe0d786d64808,
    0x000390bd442b940c, 0x0003f8db6e18de02, 0x000194efbd04c90f,
    0x0008000000000000, 0x0004000000000000, 0x000a000000000000,
    0x0005000000000000, 0x0009800000000000, 0x000f400000000000,
    0x000ae00000000000, 0x000bb00000000000, 0x000e780000000000,
    0x00095c0000000000, 0x0001c20000000000, 0x000d030000000000,
    0x000dba8000000000, 0x00055f4000000000, 0x000ff82000000000,
    0x00021c1000000000, 0x0001223800000000, 0x0003b3a400000000,
    0x000a42b600000000, 0x0003430f00000000, 0x0004da6980000000,
    0x0004af3ec0000000, 0x0002e043a0000000, 0x000fb0a1f0000000,
    0x0004785188000000, 0x000c5c9ac4000000, 0x000842f5aa000000,
    0x000243aef5000000, 0x00075a3801800000, 0x000eefa40b400000,
    0x000180b600e00000, 0x000b400f0eb00000, 0x0000e0e987f80000,
    0x000eb07ec61c0000, 0x0007f863ab220000, 0x00061cb1f6b30000,
    0x000b22698bc28000, 0x0006b33ec8034000, 0x0003c243a43a2000,
    0x000c03a1fa1f1000, 0x000e3ad18d18b800, 0x000f1fdacdace400,
    0x000c98d5a55a9600, 0x0006ecbeffef1f00, 0x0005ba800a005180,
    0x00015f4005009ac0, 0x0005f8200980f5a0, 0x00071c100f40aef0,
    0x0008a2380ae0b808, 0x000cf3a40bb0e404, 0x0000a2b60e78960a,
    0x0008f30f095c1f05, 0x0008000000000000, 0x000c000000000000,
    0x000e000000000000, 0x000b000000000000, 0x000b800000000000,
    0x0003c00000000000, 0x000ce00000000000, 0x0004100000000000,
    0x0002180000000000, 0x00051c0000000000, 0x0000960000000000,
    0x0008570000000000, 0x000f278000000000, 0x0008e9c000000000,
    0x0006002000000000, 0x0007003000000000, 0x0005803800000000,
    0x0008c02c00000000, 0x0007602e00000000, 0x0007d00f00000000,
    0x000ef83380000000, 0x00010c1040000000, 0x00028e0860000000,
    0x000d4b1470000000, 0x000fb18258000000, 0x0000bee15c000000,
    0x0009279c9e000000, 0x000fe9d3a7000000, 0x0003800000800000,
    0x000fc00000c00000, 0x0002e00000e00000, 0x000f100000b00000,
    0x0009980000b80000, 0x0006dc00003c0000, 0x000c760000ce0000,
    0x000c470000410000, 0x000d3f8000218000, 0x000df5c00051c000,
    0x0006962000096000, 0x000f573000857000, 0x000aa7b800f27800,
    0x000029ec008e9c00, 0x0001600e00600200, 0x0000d03f00700300,
    0x000b780b80580380, 0x0009cc3c408c02c0, 0x0005ee26607602e0,
    0x000a9b1b707d00f0, 0x000149b1d8ef8338, 0x0001b2f11c10c104,
    0x000ba994fe28e086, 0x0002a2c7d7d4b147, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x000d000000000000,
    0x0006800000000000, 0x0003c00000000000, 0x0008a00000000000,
    0x0005100000000000, 0x000a980000000000, 0x000ddc0000000000,
    0x0005ba0000000000, 0x00039d0000000000, 0x00095f8000000000,
    0x00056d4000000000, 0x0000a02000000000, 0x0009103000000000,
    0x0004983800000000, 0x0000dc3400000000, 0x00033a1a00000000,
    0x00005d0f00000000, 0x0001ffa280000000, 0x00007d5440000000,
    0x000a380a60000000, 0x0004cc0770000000, 0x0001222ee8000000,
    0x0003413a74000000, 0x000a65bf7e000000, 0x0005305ab5000000,
    0x00015f8000800000, 0x00096d4000c00000, 0x000ea02000e00000,
    0x0004103000d00000, 0x0002183800680000, 0x00031c34003c0000,
    0x000b9a1a008a0000, 0x00054d0f00510000, 0x000b67a280a98000,
    0x000da15440ddc000, 0x000f820a605ba000, 0x000751077039d000,
    0x00087daee895f800, 0x00062c7a7456d400, 0x000ac59f7e0a0200,
    0x000c206ab5910300, 0x0005c7b800c98380, 0x0009b17400cdc340,
    0x000d9a3a00d3a1a0, 0x00044d3f00d5d0f0, 0x0003e79a8077fa28,
    0x00036160403bd544, 0x0001a210602980a6, 0x00018108701dc077,
    0x0008000000000000, 0x0004000000000000, 0x0006000000000000,
    0x000d000000000000, 0x0003800000000000, 0x0008c00000000000,
    0x0007e00000000000, 0x0007100000000000, 0x000c880000000000,
    0x00004c0000000000, 0x0001ba0000000000, 0x000bb70000000000,
    0x0004a98000000000, 0x000c3bc000000000, 0x000a602000000000,
    0x0006d01000000000, 0x000ee81800000000, 0x00029c3400000000,
    0x0009520e00000000, 0x00042b2300000000, 0x000e7b9f80000000,
    0x0000d0dc40000000, 0x0003fb9220000000, 0x000110d130000000,
    0x00019bbee8000000, 0x0003c0cadc000000, 0x000973a4a6000000,
    0x000c5cf7ef000000, 0x0003a18000800000, 0x0000b7c000400000,
    0x000a3a2000600000, 0x0007771000d00000, 0x0005499800380000,
    0x00062bf4008c0000, 0x0005682e007e0000, 0x000e5c3300710000,
    0x0008b20780c88000, 0x000e3b284004c000, 0x000173bc201ba000,
    0x00085ce230bb7000, 0x0005a1b9684a9800, 0x000db7e29cc3bc00,
    0x0009ba1886a60200, 0x000fb715df6d0100, 0x0002a9b9686e8180,
    0x00013be29c69c340, 0x0009e01886f520e0, 0x000e1015df92b230,
    0x00090839685fb9f8, 0x00058c229cc10dc4, 0x0005da388621b922,
    0x00046705dfb00d13, 0x0008000000000000, 0x000c000000000000,
    0x000a000000000000, 0x0009000000000000, 0x0000800000000000,
    0x0006400000000000, 0x0006a00000000000, 0x0008900000000000,
    0x000a580000000000, 0x000cb40000000000, 0x0001820000000000,
    0x000ad90000000000, 0x000af88000000000, 0x00072f4000000000,
    0x0002582000000000, 0x0000b43000000000, 0x000b822800000000,
    0x0003d92400000000, 0x000a788200000000, 0x00016f5900000000,
    0x0004f83a80000000, 0x0008241240000000, 0x0001da0160000000,
    0x000f6d16d0000000, 0x000bfa8408000000, 0x000bb67264000000,
    0x000e009162000000, 0x000f0b4efd000000, 0x0003822800800000,
    0x000fd92400c00000, 0x0000788200a00000, 0x00086f5900900000,
    0x0004783a80080000, 0x000e641240640000, 0x00077a01606a0000,
    0x0007fd16d0890000, 0x0001a28408a58000, 0x0007027264cb4000,
    0x000f829162182000, 0x0005d24efdad9000, 0x00097aa8002f8800,
    0x0008f66400b2f400, 0x000220a200858200, 0x0008db69009b4300,
    0x000ffa1280b02280, 0x000dbd3640599240, 0x000d028360cd8820,
    0x0006924fd09ff590, 0x00055abe88ea03a8, 0x000f266024490124,
    0x000e589002058016, 0x000abf582d5b416d, 0x0008000000000000,
    0x000c000000000000, 0x0002000000000000, 0x000d000000000000,
    0x0004800000000000, 0x0008c00000000000, 0x000d600000000000,
    0x0003900000000000, 0x000d580000000000, 0x0003240000000000,
    0x000b2a0000000000, 0x0007210000000000, 0x00053d8000000000,
    0x00082cc000000000, 0x000cb82000000000, 0x0004743000000000,
    0x0009120800000000, 0x000a953400000000, 0x0007cf9200000000,
    0x0004e9e300000000, 0x000fcf9580000000, 0x0008e9fe40000000,
    0x000dcf9d60000000, 0x0005e9c890000000, 0x00094f96a8000000,
    0x000d29fb84000000, 0x00042f9b76000000, 0x000eb9c9f3000000,
    0x0009778800800000, 0x000d9df400c00000, 0x00025db200200000,
    0x000abcd300d00000, 0x0007601d80480000, 0x0002900a408c0000,
    0x000bd82f60d60000, 0x0006e41b90390000, 0x0002ca0b28d58000,
    0x000c7131c4324000, 0x0005059416b2a000, 0x000898e263721000,
    0x000aca0b28d3d800, 0x00007131c442cc00, 0x0007059416eb8200,
    0x000598e263974300, 0x000e4a0b28592080, 0x0008b131c4e55340,
    0x000a6594168af920, 0x000608e263a79e30, 0x0003120b28e17958,
    0x000b9531c4f0dfe4, 0x00014f94169859d6, 0x000129e263c58c89,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x0005000000000000, 0x000d800000000000, 0x000f400000000000,
    0x0003e00000000000, 0x0009500000000000, 0x0008f80000000000,
    0x0003d40000000000, 0x000f320000000000, 0x0002ef0000000000,
    0x000adc8000000000, 0x0000a0c000000000, 0x0008b22000000000,
    0x0004af3000000000, 0x0006bc8800000000, 0x0003b0d400000000,
    0x000e2a1600000000, 0x00016b0d00000000, 0x0002968780000000,
    0x000bdbf140000000, 0x00033cb5e0000000, 0x0000f0c250000000,
    0x000fca1b48000000, 0x000d3b0afc000000, 0x0007eeb692000000,
    0x00074fe4d3000000, 0x000fee8780800000, 0x000b4ff140c00000,
    0x000deeb5e0200000, 0x000e4fc250500000, 0x00006e9b48d80000,
    0x00010fcafcf40000, 0x00038e96923e0000, 0x00085fd4d3950000,
    0x000b768f800f8000, 0x000b8be540fd4000, 0x00044483e0d32000,
    0x000964ff507ef000, 0x000e9814c875c800, 0x0009c42fbcfe0c00,
    0x00062a1572b52200, 0x000d6b2b83dff300, 0x0000969b48644880,
    0x000edbcafcc64d40, 0x000ebc9692318160, 0x000fb0d4d36840d0,
    0x000c2a0f80dca078, 0x00046b254083b314, 0x000f16a3e0a6e95e,
    0x00049bcf5080ff25, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x000b000000000000, 0x0009800000000000,
    0x000a400000000000, 0x0007a00000000000, 0x000d500000000000,
    0x0000280000000000, 0x0006040000000000, 0x00051e0000000000,
    0x0008870000000000, 0x0008c28000000000, 0x00047c4000000000,
    0x0000be2000000000, 0x000ad71000000000, 0x000b6aa800000000,
    0x0003386c00000000, 0x000b800600000000, 0x0005403900000000,
    0x0004203680000000, 0x000c101940000000, 0x000e0826a0000000,
    0x0001143110000000, 0x0002960af8000000, 0x0003d3175c000000,
    0x000df4a3aa000000, 0x000aff49e1000000, 0x000d62b680800000,
    0x00062c5940400000, 0x00031606a0a00000, 0x000d932110b00000,
    0x000054a2f8980000, 0x000caf7b5ca40000, 0x0004caa5aa7a0000,
    0x000a6870e1d50000, 0x0001a80000828000, 0x0008440000204000,
    0x0008be0000f1e000, 0x000ed70000387000, 0x00016a8000142800,
    0x0008384000e3c400, 0x000200200071e200, 0x000f001000787100,
    0x0003802800b42a80, 0x0001402c0053c6c0, 0x000e202600e9e060,
    0x0007102900dc7390, 0x0007881e80ce2b68, 0x000b54354086c594,
    0x00053600a0eb606a, 0x000e831810bc3211, 0x0008000000000000,
    0x000c000000000000, 0x000a000000000000, 0x0003000000000000,
    0x0001800000000000, 0x0003400000000000, 0x0008a00000000000,
    0x0009d00000000000, 0x0006780000000000, 0x0008240000000000,
    0x00040e0000000000, 0x00060f0000000000, 0x0009148000000000,
    0x0002944000000000, 0x0002d62000000000, 0x000bfb3000000000,
    0x000162a800000000, 0x000fbf4c00000000, 0x000e4ca600000000,
    0x000c207d00000000, 0x0002002a80000000, 0x000f001b40000000,
    0x000b8037e0000000, 0x0000402190000000, 0x00092034b8000000,
    0x000a90327c000000, 0x000ed81f32000000, 0x0001f40d81000000,
    0x0002760280800000, 0x000e2b1740c00000, 0x000d1ab1e0a00000,
    0x00049b6c90300000, 0x000bc2b638180000, 0x00096f653c340000,
    0x0003b48ed28a0000, 0x00044451119d0000, 0x000f2e1cb8e78000,
    0x00039f3e7c424000, 0x000c4c9932e0e000, 0x000320408150f000,
    0x0009800000094800, 0x000f400000dd4400, 0x0002a00000076200,
    0x000ad0000012b300, 0x0007f8000069aa80, 0x000b6400004db4c0,
    0x000cae00002e2a60, 0x000fdf00003ff7d0, 0x000f6c8000d6caa8,
    0x000ab040005b05b4, 0x0006d82000d5817e, 0x000df43000db4119,
    0x0008000000000000, 0x0004000000000000, 0x000e000000000000,
    0x000d000000000000, 0x0000800000000000, 0x0004c00000000000,
    0x0000200000000000, 0x000b500000000000, 0x0003680000000000,
    0x000c2c0000000000, 0x0001420000000000, 0x0000750000000000,
    0x0001bf8000000000, 0x0005034000000000, 0x00048a2000000000,
    0x000ac91000000000, 0x000d35b800000000, 0x000bca7400000000,
    0x0007bfa200000000, 0x000c034300000000, 0x000a0a1880000000,
    0x0003090940000000, 0x000d95b7a0000000, 0x00045a57b0000000,
    0x0004f7a788000000, 0x000b7f6f94000000, 0x00082013de000000,
    0x000f502dfd000000, 0x000d682080800000, 0x00012c3d40400000,
    0x0001c235a0e00000, 0x0004b504b0d00000, 0x00019f8708080000,
    0x000e5352d44c0000, 0x0007e2267e020000, 0x0006e5294db50000,
    0x000c77a788b68000, 0x000bbf6f9482c000, 0x00060013def42000,
    0x0009002dfdd75000, 0x000e80208093f800, 0x0009c03d405c3400,
    0x0000a035a0aaa200, 0x000f9004b0c99100, 0x0003480708eddb80,
    0x00077c12d4326740, 0x00022a067e6dda20, 0x000c59394d726430,
    0x0000fd9f880dd988, 0x0005765b94e26494, 0x00053591de65d97a,
    0x000fca7efd3e647b, 0x0008000000000000, 0x000c000000000000,
    0x000e000000000000, 0x0005000000000000, 0x0006800000000000,
    0x0004c00000000000, 0x0007600000000000, 0x000f700000000000,
    0x0003680000000000, 0x000d740000000000, 0x00087e0000000000,
    0x000ef30000000000, 0x000a3a8000000000, 0x000d544000000000,
    0x00023aa000000000, 0x0001547000000000, 0x000c3a9800000000,
    0x0004546400000000, 0x000aba8200000000, 0x0000947700000000,
    0x000dda9f80000000, 0x000fe44ac0000000, 0x000eb29220000000,
    0x0002907f10000000, 0x0006ccb3d8000000, 0x000c6344dc000000,
    0x000cf61b32000000, 0x000137318d000000, 0x000eccb3d8800000,
    0x00006344dcc00000, 0x0002f61b32e00000, 0x000437318d500000,
    0x00084cb3d8e80000, 0x0004a344dc8c0000, 0x0005961b32960000,
    0x000b47318da70000, 0x000b24b3d8de8000, 0x0009d744dc5b4000,
    0x000de81b3211e000, 0x0005b4318d483000, 0x00011e33d87d2800,
    0x00048304dc8e0400, 0x000fd2bb32324a00, 0x0004e0418d5d7700,
    0x000d24abd8be8180, 0x0000d760dccb4240, 0x000568393299e220,
    0x000474368d543070, 0x0000fe3458632878, 0x000f332a1c3506ec,
    0x000bdaab1272cb02, 0x0006e4499d7d3781, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x0009000000000000,
    0x000c800000000000, 0x0007400000000000, 0x0005200000000000,
    0x0000300000000000, 0x000eb80000000000, 0x0006f40000000000,
    0x0006460000000000, 0x000daf0000000000, 0x0001798000000000,
    0x000297c000000000, 0x000a59a000000000, 0x000fa7d000000000,
    0x000e61b800000000, 0x000713f400000000, 0x0001878a00000000,
    0x000dcce900000000, 0x000b661e80000000, 0x00099f29c0000000,
    0x0009c18460000000, 0x000d63e210000000, 0x00009fa578000000,
    0x000548e0ac000000, 0x000a380a9e000000, 0x0005b413f3000000,
    0x0005662578800000, 0x00049f20ac400000, 0x000341aa9e600000,
    0x000323c3f3900000, 0x00093f9d78480000, 0x000238d4ac340000,
    0x0001a0209e320000, 0x0003702af3930000, 0x000d9803f8a38000,
    0x000fc43d6c5b4000, 0x00047e04fe566000, 0x000c1b18e349f000,
    0x00021f9e80b41800, 0x000f08e9c0723c00, 0x0005982460f3fa00,
    0x000bc43210b38d00, 0x00027e1d78d20380, 0x00051b14ac430340,
    0x000e9f809e8b82a0, 0x000848faf3ff4390, 0x0000b83bf82c6268,
    0x000bf4096ceef1dc, 0x000cc62efe259ae6, 0x0003ef21e3ba7db1,
    0x0008000000000000, 0x000c000000000000, 0x000a000000000000,
    0x000d000000000000, 0x000b800000000000, 0x0000400000000000,
    0x0006e00000000000, 0x0009700000000000, 0x000f280000000000,
    0x000edc0000000000, 0x0001360000000000, 0x0005c90000000000,
    0x000db58000000000, 0x00031e4000000000, 0x00009da000000000,
    0x000cc27000000000, 0x00002b8800000000, 0x00044b4400000000,
    0x0000fe2600000000, 0x000e650500000000, 0x0009ab9d80000000,
    0x00050b50c0000000, 0x00079e2920000000, 0x000a552fb0000000,
    0x000be38bf8000000, 0x0002e77d94000000, 0x000f6000ae000000,
    0x000830112d000000, 0x00084803f8800000, 0x000aec3994c00000,
    0x00037e26aea00000, 0x000225142dd00000, 0x00054b9e78380000,
    0x00017b6954c40000, 0x0003360f8ece0000, 0x0004c93b9d470000,
    0x000c359580ca8000, 0x000e5e54c029c000, 0x000dfdaf20dd6000,
    0x0005f25ab01b9000, 0x0009e39e7891d800, 0x0003e76954d82400,
    0x000ee00f8e74ba00, 0x0005703b9d07b700, 0x0005281580ab6080,
    0x0003dc14c0589040, 0x000ab60f20b55860, 0x0005892ab0a6e750,
    0x000b559678fb5958, 0x000a6e6d5421e54c, 0x000fb5898e11daf2,
    0x00021e4e9d1825ab, 0x0008000000000000, 0x000c000000000000,
    0x000e000000000000, 0x0003000000000000, 0x0006800000000000,
    0x000ec00000000000, 0x0002200000000000, 0x0002b00000000000,
    0x0003680000000000, 0x0009d40000000000, 0x0006a20000000000,
    0x0001670000000000, 0x0004de8000000000, 0x000330c000000000,
    0x000936a000000000, 0x000824f000000000, 0x0003b49800000000,
    0x0008f3fc00000000, 0x0002820200000000, 0x000cd70700000000,
    0x000f36aa80000000, 0x000724fdc0000000, 0x000b34bf20000000,
    0x000533e690000000, 0x00062207a8000000, 0x0000a7140c000000,
    0x000e7ea652000000, 0x000c40d90f000000, 0x000efe9fa8800000,
    0x000d80e80cc00000, 0x00045ea452e00000, 0x0002f0de0f300000,
    0x000396b528e80000, 0x000754d5cc2c0000, 0x00047cbb72c20000,
    0x000d57c89f1b0000, 0x0005682a80de8000, 0x0006d43dc0b14000,
    0x000e221f20a82000, 0x000ca716900d7000, 0x00007e9fa8136800,
    0x000f40e80c424c00, 0x00087ea452db4a00, 0x000340de0fbf3f00,
    0x00067eb528c02180, 0x000040d5cce173c0, 0x0000febb72316a20,
    0x000e80c89f694f70, 0x0002deaa806dcb28, 0x000c30fdc0e27c1c,
    0x0001b6bf20ca01d2, 0x0005e4e690070119, 0x0008000000000000,
    0x000c000000000000, 0x0002000000000000, 0x0003000000000000,
    0x0002800000000000, 0x000d400000000000, 0x0008a00000000000,
    0x000ff00000000000, 0x0008480000000000, 0x00073c0000000000,
    0x0001320000000000, 0x000c2b0000000000, 0x000fb38000000000,
    0x000361c000000000, 0x000401a000000000, 0x000e0af000000000,
    0x0001122800000000, 0x00019b3c00000000, 0x000fdb8200000000,
    0x0005edf900000000, 0x00075b8880000000, 0x0007adfac0000000,
    0x000f7baba0000000, 0x00061ddf30000000, 0x000d1387e8000000,
    0x000391e55c000000, 0x000cc9ba86000000, 0x000776cbeb000000,
    0x000a000f68800000, 0x000f001f9cc00000, 0x0000801126200000,
    0x000e4014db300000, 0x000a200880a80000, 0x0002b03ac0140000,
    0x0000e80ba0aa0000, 0x0008cc2f30cf0000, 0x00097a2fe8ac8000,
    0x000b17195ca7c000, 0x000e819886992000, 0x000f4ac2eb3db000,
    0x000bb22fe8ffb800, 0x000d6b195c85dc00, 0x0005139886733a00,
    0x000f91c2eb121f00, 0x000ec9afe8421a80, 0x000476d95c3bafc0,
    0x000880388617a220, 0x00024032eb717090, 0x00082007e8481a08,
    0x0001b0255c04ac6c, 0x0002681a86b3229a, 0x00058c3beb32b263,
    0x0008000000000000, 0x0004000000000000, 0x000a000000000000,
    0x0005000000000000, 0x000b800000000000, 0x0008400000000000,
    0x0001a00000000000, 0x000af00000000000, 0x000bd80000000000,
    0x000dfc0000000000, 0x00014e0000000000, 0x0004350000000000,
    0x000da38000000000, 0x0004e1c000000000, 0x0004cda000000000,
    0x000364d000000000, 0x0002960800000000, 0x000dc90400000000,
    0x0006ed8600000000, 0x0005d4f500000000, 0x0002ee0880000000,
    0x000fc51ac0000000, 0x0007fb81e0000000, 0x00045dc830000000,
    0x000fa3a458000000, 0x0005e1d624000000, 0x00054dbd36000000,
    0x000e24ec93000000, 0x0008b62cd8800000, 0x000f790ce4400000,
    0x000c959cd6a00000, 0x0002d8f4a3500000, 0x0008780080380000,
    0x00060c1ec0c40000, 0x000b1607e0ba0000, 0x0004893d30ff0000,
    0x0006cdacd8058000, 0x000264cce45bc000, 0x0003163cd60ee000,
    0x00008924a3ec5000, 0x000ccd8880e7b800, 0x000764dac0d1dc00,
    0x00089621e0f83a00, 0x0008c91830251d00, 0x000d6dac584b5880,
    0x000d94d224168c40, 0x00034e3b36380260, 0x0005351993c40250,
    0x000c23a4583a0008, 0x0009a1d624bf01ec, 0x000eedbd36a5807e,
    0x0001d4ec930bc3d3, 0x0008000000000000, 0x0004000000000000,
    0x000e000000000000, 0x0007000000000000, 0x0000800000000000,
    0x000f400000000000, 0x000f600000000000, 0x0008b00000000000,
    0x000c980000000000, 0x0005540000000000, 0x0006720000000000,
    0x000f3f0000000000, 0x0003478000000000, 0x0005744000000000,
    0x0001ada000000000, 0x000b1f5000000000, 0x000a981800000000,
    0x0006540c00000000, 0x0008f23a00000000, 0x00077f2100000000,
    0x000ca7bf80000000, 0x0002845fc0000000, 0x000255afe0000000,
    0x0006fb6790000000, 0x00007233a8000000, 0x000c3f25ac000000,
    0x000dc7aed6000000, 0x000d34482d000000, 0x000e4d9428800000,
    0x000cef766c400000, 0x0009603b36e00000, 0x000bb00ebd700000,
    0x0002181800880000, 0x000d140c00b40000, 0x0009923a00160000,
    0x0008cf2100fb0000, 0x0000bfbf80c18000, 0x0008905fc0a14000,
    0x000b47afe0912000, 0x000174679078f000, 0x000fadb3a8fdf800,
    0x000c1f65ac020400, 0x000a180ed67dfa00, 0x000914182d420500,
    0x0007920c281df980, 0x000fcf3a6c7204c0, 0x00003fa13675f9a0,
    0x0007d07fbdb60710, 0x000427bf80ebfa78, 0x0009c45fc0f9053c,
    0x000335afe0bc795e, 0x00094b6790e34469, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x0009000000000000,
    0x0006800000000000, 0x000f400000000000, 0x0006200000000000,
    0x000df00000000000, 0x0007980000000000, 0x000dd40000000000,
    0x00076e0000000000, 0x0002cf0000000000, 0x000cfb8000000000,
    0x00051ec000000000, 0x000c8da000000000, 0x000845d000000000,
    0x0009b81800000000, 0x0004243400000000, 0x000ef62200000000,
    0x00061b1900000000, 0x000d158280000000, 0x000891cac0000000,
    0x00065626e0000000, 0x0000ab1090000000, 0x0002adbbd8000000,
    0x0001b5d86c000000, 0x0000201456000000, 0x0000f03247000000,
    0x000f182158800000, 0x000b9426ac400000, 0x0007ce10b6e00000,
    0x00007f3bd7900000, 0x000d439800e80000, 0x00053af400b40000,
    0x000c7b8200820000, 0x00075ec9004f0000, 0x00022d9a80118000,
    0x0003f5fec0294000, 0x000e8004e014e000, 0x000b400990f3f000,
    0x0008203958b63800, 0x0004f012ac8cac00, 0x00011832b6be3a00,
    0x00029422d7a8ad00, 0x00014e1a80d43980, 0x000f3f3ec053af40,
    0x000b63a4e0c7b820, 0x0008cad99075ec90, 0x000be3a15822d9a8,
    0x000a8ae6ac3f5fec, 0x000543b0b6e8004e, 0x00013aebd7b40099,
    0x0008000000000000, 0x000c000000000000, 0x0006000000000000,
    0x0005000000000000, 0x0001800000000000, 0x000dc00000000000,
    0x0004200000000000, 0x0003700000000000, 0x0002080000000000,
    0x000f140000000000, 0x0002860000000000, 0x0009490000000000,
    0x0008788000000000, 0x000a83c000000000, 0x000556a000000000,
    0x000e6ef000000000, 0x000f803800000000, 0x0004c02400000000,
    0x0003a01e00000000, 0x000bb02300000000, 0x0007a81680000000,
    0x0001a43ac0000000, 0x0004ae18a0000000, 0x00052d3190000000,
    0x0008f68238000000, 0x000cded974000000, 0x000fa80bfa000000,
    0x000da43f2b000000, 0x0002ae2cb8800000, 0x00002d07b4c00000,
    0x000976ad5a600000, 0x00011eddbb500000, 0x000b880000980000,
    0x000ed400001c0000, 0x0000a60000220000, 0x000f390000670000,
    0x000bf08000388000, 0x000857c0002d4000, 0x0003f0a0006a6000,
    0x000457f000a39000, 0x0005f0b800a70800, 0x000157e400597c00,
    0x000470be007d0a00, 0x000c97d300727f00, 0x000050ae807f8b80,
    0x000fe7dec0e43e40, 0x000258a6a06f6be0, 0x0000f3e2905ded30,
    0x0000deacb88282e8, 0x0009bac7b45641ec, 0x0008a60d5a70e06a,
    0x0003392dbbe9d129, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x000f000000000000, 0x000f800000000000,
    0x0003400000000000, 0x0006200000000000, 0x000f500000000000,
    0x000a880000000000, 0x000fcc0000000000, 0x0008e20000000000,
    0x00053f0000000000, 0x000c778000000000, 0x0009574000000000,
    0x000b802000000000, 0x000d4e5000000000, 0x000b280800000000,
    0x000fdc0c00000000, 0x00064a0200000000, 0x000aa30f00000000,
    0x00019d8f80000000, 0x0000e44340000000, 0x000935a620000000,
    0x000e761f50000000, 0x000657a288000000, 0x00040913cc000000,
    0x000e0022e2000000, 0x000d0e563f000000, 0x00008809f7800000,
    0x000ccc0917400000, 0x0005620020200000, 0x00097f0e5e500000,
    0x0005d78800080000, 0x0005474c000c0000, 0x0007282200020000,
    0x000dd25f000f0000, 0x00094207800f8000, 0x00052f0f40034000,
    0x0002df8420062000, 0x0006cb40500f5000, 0x00066a25080a8800,
    0x0004fd5c8c0fcc00, 0x00099d86c208e200, 0x000ce4466f053f00,
    0x000b35a4ff8c7780, 0x000176199b495740, 0x0009d7a4e22b8020,
    0x00074917315d4e50, 0x0008202b7f832808, 0x00025e5adb43dc0c,
    0x000a0002c2244a02, 0x000300086155a30f, 0x0008000000000000,
    0x000c000000000000, 0x000a000000000000, 0x000f000000000000,
    0x000f800000000000, 0x000ec00000000000, 0x0007e00000000000,
    0x0006100000000000, 0x0005c80000000000, 0x000e6c0000000000,
    0x000dda0000000000, 0x0002a70000000000, 0x0009338000000000,
    0x00013cc000000000, 0x000d3ce000000000, 0x0007379000000000,
    0x00083a0800000000, 0x0007b70c00000000, 0x00097b8a00000000,
    0x000e90cf00000000, 0x000886ef80000000, 0x000d409ec0000000,
    0x0003218fe0000000, 0x000ef7ca10000000, 0x000c556fc8000000,
    0x00056c516c000000, 0x0004556a5a000000, 0x00096c5067000000,
    0x000e556cd3800000, 0x00066c542cc00000, 0x0001d56574e00000,
    0x0008ac549b900000, 0x0006356f80080000, 0x000ebc5ec00c0000,
    0x0003fd6fe00a0000, 0x0000d05a100f0000, 0x000e2767c80f8000,
    0x0002775d6c0ec000, 0x000714e05a07e000, 0x00034b9f67061000,
    0x000a28035385c800, 0x00047c0aecce6c00, 0x0002120a94edda00,
    0x0003cb0e8b92a700, 0x000b698848013380, 0x000d5bc3ac0d3cc0,
    0x0003ef6fba073ce0, 0x00001b5577083790, 0x0000ceec9b87ba08,
    0x000eec9b80c9770c, 0x000c9b80ceee9b8a, 0x000b80ceec9880cf,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x000b000000000000, 0x0005800000000000, 0x0002c00000000000,
    0x0009a00000000000, 0x000f900000000000, 0x0003c80000000000,
    0x000b2c0000000000, 0x000ad20000000000, 0x0003a30000000000,
    0x0008998000000000, 0x000448c000000000, 0x0002eea000000000,
    0x0006f81000000000, 0x000ef20800000000, 0x0002f30c00000000,
    0x0000f18200000000, 0x000bf4cb00000000, 0x000e74a580000000,
    0x000cb712c0000000, 0x00051981a0000000, 0x000a88c390000000,
    0x00094ea1c8000000, 0x000268102c000000, 0x0008ba0752000000,
    0x000b1f0d63000000, 0x0003838339800000, 0x0007c7c0d8c00000,
    0x00052524a6a00000, 0x0003d3df14100000, 0x000d252580080000,
    0x000fd3d2c00c0000, 0x000f2521a0020000, 0x0004d3d3900b0000,
    0x000aa529c8058000, 0x000613dc2c02c000, 0x000305255209a000,
    0x000983d6630f9000, 0x0000cd2eb983c800, 0x0002afde18cb2c00,
    0x000a1f2706aad200, 0x00010cd78413a300, 0x000286a1c8009980,
    0x000544102c0848c0, 0x000068075200eea0, 0x0003bc0d630df810,
    0x000e9a03398b7208, 0x00014f00d8c0330c, 0x000e6b84a6a95182,
    0x000abbcf141464cb, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x000b000000000000, 0x000d800000000000,
    0x000ac00000000000, 0x0008e00000000000, 0x0000900000000000,
    0x0009e80000000000, 0x000a1c0000000000, 0x000caa0000000000,
    0x0003370000000000, 0x0009578000000000, 0x000085c000000000,
    0x00024b6000000000, 0x0006a35000000000, 0x0004378800000000,
    0x0006d5cc00000000, 0x0001436200000000, 0x00072f5b00000000,
    0x000cf58580000000, 0x00053ec6c0000000, 0x000c5eeae0000000,
    0x00040d9b90000000, 0x000e016c68000000, 0x0009045cdc000000,
    0x0006880e4a000000, 0x00074c04a7000000, 0x0002220f3f800000,
    0x00087b0b59c00000, 0x0009758b81600000, 0x0003fecfc4500000,
    0x0006beec68080000, 0x000f9d9cdc0c0000, 0x000a696e4a020000,
    0x0009d854a70b0000, 0x0002c2073f8d8000, 0x0004eb0759cac000,
    0x00029d898168e000, 0x0002e2c4c4509000, 0x000794e1e801e800,
    0x00066a961c061c00, 0x000bdee6aa0eaa00, 0x0009cd9437083700,
    0x0009616ed784d780, 0x0008545d45ca45c0, 0x000a000d2b6aab60,
    0x0007000bf3563350, 0x000f800abf85df88, 0x0001c00d99c0c9cc,
    0x00056001616fe962, 0x000a5004545f185b, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x000f000000000000,
    0x000a800000000000, 0x0002c00000000000, 0x000a200000000000,
    0x0002d00000000000, 0x000da80000000000, 0x000f940000000000,
    0x000ec60000000000, 0x00002b0000000000, 0x0003d48000000000,
    0x000825c000000000, 0x0007d4a000000000, 0x0006261000000000,
    0x0008dc8800000000, 0x000ca1c400000000, 0x000a1aae00000000,
    0x0006891f00000000, 0x0008c60280000000, 0x000b2b06c0000000,
    0x0007548420000000, 0x0005e5cdd0000000, 0x000774a728000000,
    0x0006361d54000000, 0x000f548ce6000000, 0x0001e5c6fb000000,
    0x000974a07c800000, 0x00093618b1c00000, 0x0005d48b92a00000,
    0x000325c0cd100000, 0x000354af28080000, 0x000be61954040000,
    0x00087c82e60e0000, 0x000cb1c9fb0f0000, 0x000d92aafc8a8000,
    0x000bcd1a71c2c000, 0x000ba801b2aa2000, 0x000494021d12d000,
    0x000a46028005a800, 0x000deb06c00b9400, 0x000374842000c600,
    0x000835cdd00f2b00, 0x00005ca728095480, 0x000b621d540ae5c0,
    0x000bb28ce60df4a0, 0x00031ec6fb04f610, 0x000708207c857488,
    0x000e87d8b1c335c4, 0x000cc62b92a4dcae, 0x000528d0cd16a21f,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x0003000000000000, 0x000c800000000000, 0x0007c00000000000,
    0x0008200000000000, 0x0004f00000000000, 0x000be80000000000,
    0x000edc0000000000, 0x0002160000000000, 0x000ab70000000000,
    0x0007868000000000, 0x000746c000000000, 0x0001e9a000000000,
    0x000fdcb000000000, 0x0003908800000000, 0x0002f1cc00000000,
    0x0004ef2e00000000, 0x000c5a7300000000, 0x0006d92480000000,
    0x000e1d7bc0000000, 0x0004b7ae20000000, 0x000487bbf0000000,
    0x000bc80168000000, 0x00062c061c000000, 0x0007fe08b6000000,
    0x00076b0a87000000, 0x00091088ce800000, 0x000a31caaac00000,
    0x000e4f2037a00000, 0x000c6a7f47b00000, 0x00099125e8080000,
    0x0003f17ddc0c0000, 0x000569a6960e0000, 0x00041cb177030000,
    0x0005b089a68c8000, 0x000501ccb6c7c000, 0x0003872881a82000,
    0x00054675c0b4f000, 0x000cef2d2683e800, 0x00005a7776c2dc00,
    0x0008d926a1ac1600, 0x000d1d7e30b9b700, 0x000837a44e830680,
    0x000347bd6acc86c0, 0x0003e80017a7c9a0, 0x0002dc07b7b82cb0,
    0x000c1608000cf888, 0x0009b70c0007edcc, 0x000b068e0000d92e,
    0x000086c300011d73, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x0001000000000000, 0x0009800000000000,
    0x0002c00000000000, 0x0000600000000000, 0x000cd00000000000,
    0x0008a80000000000, 0x0001bc0000000000, 0x000ffa0000000000,
    0x000ad50000000000, 0x0007af8000000000, 0x000b3dc000000000,
    0x0005b2e000000000, 0x0001f29000000000, 0x0009d58800000000,
    0x000f28cc00000000, 0x00007d6200000000, 0x00071f5100000000,
    0x000d4f6180000000, 0x000da65ec0000000, 0x000632ea60000000,
    0x000e3291d0000000, 0x0002358b28000000, 0x000038ce7c000000,
    0x000135641a000000, 0x0008b355c5000000, 0x000a7d6ee7800000,
    0x000a1f5891c00000, 0x0006cf6880e00000, 0x000e665b4b900000,
    0x000fd2eaa8080000, 0x00002290bc0c0000, 0x000afd8e7a020000,
    0x000d54c415010000, 0x00066765cf898000, 0x0003da56edc2c000,
    0x000228ec9ae06000, 0x000bf79e8e9cd000, 0x0004d20c4f80a800,
    0x0004a9042dcdbc00, 0x0003b584faedfa00, 0x000ef8ce5e9bd500,
    0x0003556ee7862f80, 0x0005635891c5fdc0, 0x000b556880e7d2e0,
    0x0009635b4b9c2290, 0x0009556aa800fd88, 0x00086350bc0054cc,
    0x0000d56e7a0de762, 0x000aa35415001a51, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x0009000000000000,
    0x0009800000000000, 0x0005400000000000, 0x0003a00000000000,
    0x0009d00000000000, 0x0007e80000000000, 0x0007f40000000000,
    0x0001720000000000, 0x000ab50000000000, 0x0006df8000000000,
    0x00096a4000000000, 0x00083d2000000000, 0x00071e1000000000,
    0x000c0d8800000000, 0x000e0f4400000000, 0x00030aaa00000000,
    0x0000805900000000, 0x000cc2a180000000, 0x0006e45140000000,
    0x000a78a1a0000000, 0x000e3554d0000000, 0x00001d2c68000000,
    0x00068e1fb4000000, 0x000bc58952000000, 0x000c6b4b25000000,
    0x000fb0a117800000, 0x0001515b0e400000, 0x000f272c87200000,
    0x000b1f12cf100000, 0x0002000de8080000, 0x000d000ef4040000,
    0x00038008f20a0000, 0x000c400ff5090000, 0x000a20057f898000,
    0x000c9000ba454000, 0x0004480fd523a000, 0x000e2400ea19d000,
    0x00069a0d7f8fe800, 0x000d4104ba43f400, 0x0007ad85d52b7200,
    0x0003df49ea13b500, 0x000ee2a4ff875f80, 0x000e7451fa482a40,
    0x000430ae75219d20, 0x000911543a17ce10, 0x000f0721178a6588,
    0x000e8f1b0e48bb44, 0x000fc80c872bd8aa, 0x00066402cf1ae559,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x000b000000000000, 0x0000800000000000, 0x0008400000000000,
    0x000b200000000000, 0x000b900000000000, 0x000be80000000000,
    0x0004fc0000000000, 0x0005560000000000, 0x000f8f0000000000,
    0x000ac28000000000, 0x00066d4000000000, 0x000b30a000000000,
    0x0008bb5000000000, 0x000c7c8800000000, 0x00011e4c00000000,
    0x000aa42e00000000, 0x000a591b00000000, 0x000d0ea880000000,
    0x0007885440000000, 0x0006c80d20000000, 0x00086c0c90000000,
    0x00003e0568000000, 0x00083307bc000000, 0x0004348ef6000000,
    0x000a324c5f000000, 0x00013a2a0a800000, 0x0001ba1901400000,
    0x0009f22d8ea00000, 0x0002d61fc8500000, 0x00094c25e8080000,
    0x0002a51ffc0c0000, 0x000658add60e0000, 0x0003075bcf0b0000,
    0x000c8a87e2808000, 0x0006414afd484000, 0x00002eae58ab2000,
    0x000b185f075b9000, 0x0003a00a8a83e800, 0x000fd0014148fc00,
    0x000ec80eaeab5600, 0x00046c0858548f00, 0x000e3e0800024280,
    0x0003330c00022d40, 0x0004b48e000e10a0, 0x0002724b00082b50,
    0x000a1a2080071488, 0x000a2a18400da24c, 0x00021a232004d22e,
    0x00062a17900e461b, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x0003000000000000, 0x0007800000000000,
    0x0002400000000000, 0x0009e00000000000, 0x0004700000000000,
    0x0006780000000000, 0x000f740000000000, 0x000df20000000000,
    0x000b310000000000, 0x0007168000000000, 0x0008c4c000000000,
    0x0003252000000000, 0x000e5d5000000000, 0x000aa52800000000,
    0x00031d5c00000000, 0x0002c52e00000000, 0x00062d5f00000000,
    0x000add2980000000, 0x000f695d40000000, 0x0008b72060000000,
    0x000f5c5930000000, 0x00042ba618000000, 0x0003dd9644000000,
    0x000dea0bea000000, 0x000e750d75000000, 0x00037c84fc800000,
    0x000bf1c9b1c00000, 0x000839a1d9a00000, 0x00009c94ec900000,
    0x000a8484fc880000, 0x000ac5c9b1cc0000, 0x000a2ba1d9a60000,
    0x000cdd94ec930000, 0x000c6a04fc8f8000, 0x000f3509b1ce4000,
    0x000d1c81d9afe000, 0x000dc1c4ec977000, 0x0007a1acfc89f800,
    0x000b9895b1c13400, 0x00010e8fd9a21200, 0x000e80cbec9c4100,
    0x0000cf2d7c8eee80, 0x000f2854f1c9f0c0, 0x000859a1b9a13720,
    0x0009ac9ddc921c50, 0x00049c8ae4844ba8, 0x000081c3f5caed9c,
    0x000fc1a433a3f20e, 0x000ea8969994310f, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x000b000000000000,
    0x0007800000000000, 0x0009c00000000000, 0x000ee00000000000,
    0x0001b00000000000, 0x000cb80000000000, 0x000c340000000000,
    0x000c7a0000000000, 0x0000510000000000, 0x0008868000000000,
    0x000c474000000000, 0x000225a000000000, 0x0003da1000000000,
    0x000345a800000000, 0x0007aa1c00000000, 0x000f1da600000000,
    0x00012e1700000000, 0x00085fa180000000, 0x00048b1ec0000000,
    0x0002432f60000000, 0x00092d5f70000000, 0x00045803d8000000,
    0x000a840344000000, 0x00094207a2000000, 0x000ea50f15000000,
    0x000d9c8124800000, 0x0004664852400000, 0x0008fb2481200000,
    0x0002195248500000, 0x0001a20124880000, 0x00081508524c0000,
    0x0008a484812e0000, 0x000a9242485b0000, 0x000de129248f8000,
    0x000a38545245c000, 0x000b7c828120e000, 0x0009d645485ab000,
    0x000a4320a4833800, 0x00052d569249f400, 0x000a580be12c9a00,
    0x0001840d385ae100, 0x000ec202fc8bbe80, 0x0007650b1645b340,
    0x00037c83232ebfa0, 0x0005d64d5d593b10, 0x000443280008fb28,
    0x000e2d5c0002195c, 0x000dd8060001a206, 0x0008440700081507,
    0x0008000000000000, 0x0004000000000000, 0x0006000000000000,
    0x0001000000000000, 0x0005800000000000, 0x0007c00000000000,
    0x000c200000000000, 0x000e100000000000, 0x0000d80000000000,
    0x000d7c0000000000, 0x0002aa0000000000, 0x000f530000000000,
    0x0009ba8000000000, 0x000c0f4000000000, 0x00020c6000000000,
    0x000702f000000000, 0x0004866800000000, 0x000241f400000000,
    0x000be4ee00000000, 0x000232b500000000, 0x000ec28b80000000,
    0x000da342c0000000, 0x000fde6fa0000000, 0x000dfdf8d0000000,
    0x0006eee178000000, 0x0005b1b0ac000000, 0x000e000052000000,
    0x000500093f000000, 0x0003800848800000, 0x0006c008e0400000,
    0x0009a000bce00000, 0x0009d00d8eb00000, 0x000cf803c8880000,
    0x00036c0a20440000, 0x0002720f1ce60000, 0x00022f055eb10000,
    0x000b108ab08d8000, 0x00035c4e8c43c000, 0x000bb6e14eea2000,
    0x000b0db961bf1000, 0x00068a09780d5800, 0x00054304ac0ebc00,
    0x000f628e52088a00, 0x0000734c3f004300, 0x0005266bc88ce280,
    0x000f91fe2046b340, 0x00011ce11cec8660, 0x00005eb05eb641f0,
    0x000930813085e4e8, 0x00084c4c4c4732b4, 0x0008eeeeeeed428e,
    0x0000b1b1b1bb6345, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x0003000000000000, 0x000b800000000000,
    0x000ac00000000000, 0x0007200000000000, 0x000b100000000000,
    0x0000380000000000, 0x000d2c0000000000, 0x000c160000000000,
    0x0009b90000000000, 0x0004e48000000000, 0x0000b74000000000,
    0x000864e000000000, 0x0003f0b000000000, 0x0006806800000000,
    0x000447f400000000, 0x0007648a00000000, 0x000e774700000000,
    0x000d44e980000000, 0x000be0b9c0000000, 0x000d3864a0000000,
    0x0003abf5d0000000, 0x000c528d18000000, 0x000cde413c000000,
    0x00099865ae000000, 0x00067bfd55000000, 0x00094a8c52800000,
    0x0009e24cde400000, 0x000e366998600000, 0x00082ef67bf00000,
    0x000698014a880000, 0x000bfc0de2440000, 0x00028e0c36620000,
    0x0006450b2ef30000, 0x00046a8d18038000, 0x0005f2413c0ec000,
    0x00078e65ae052000, 0x000cc2fd55081000, 0x00062e0c528bb800,
    0x0003950cde47ec00, 0x00017289986b3600, 0x0000ce467bf2a900,
    0x000020694a8cdc80, 0x000297f9e2499b40, 0x0009fc86366672e0,
    0x00018b4c2ef949b0, 0x000dcae49801e4e8, 0x000ea5b8fc0a30b4,
    0x0002d2e10e0a206a, 0x000c99b8850597f7, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x0007000000000000,
    0x0008800000000000, 0x0004400000000000, 0x0004a00000000000,
    0x0004700000000000, 0x000dd80000000000, 0x0004240000000000,
    0x000c320000000000, 0x0007710000000000, 0x00075b8000000000,
    0x000966c000000000, 0x000715e000000000, 0x000fc95000000000,
    0x000a6e6800000000, 0x000d9f9c00000000, 0x0002838600000000,
    0x000142cb00000000, 0x000527e680000000, 0x000fb85340000000,
    0x0005b5e420000000, 0x0000b95c30000000, 0x0001366f78000000,
    0x000afb9b54000000, 0x0002918f6a000000, 0x000603cc15000000,
    0x000b046949800000, 0x00068a9927c00000, 0x00034a09b6600000,
    0x000c250ebb900000, 0x0000318631880000, 0x000973c273cc0000,
    0x00005c66dc6e0000, 0x0001ee92ae970000, 0x0003580778008000,
    0x000b640754084000, 0x000e12096a0aa000, 0x0000410715037000,
    0x0006a38fc9855800, 0x000d72ca67c06400, 0x00025fed96689200,
    0x0008ec528b930100, 0x000cdfe949828380, 0x0007ac5927c142c0,
    0x000effe9b66527e0, 0x00009c5ebb9fb850, 0x000f07ee318db5e8,
    0x0004885e73ccb95c, 0x000a4de0dc6f3666, 0x0003ad59ae9dfb9b,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x0005000000000000, 0x000d800000000000, 0x000fc00000000000,
    0x000f600000000000, 0x000d500000000000, 0x000bf80000000000,
    0x0002c40000000000, 0x000eee0000000000, 0x0000970000000000,
    0x0001908000000000, 0x0002164000000000, 0x000ad6a000000000,
    0x000d313000000000, 0x0002282800000000, 0x0009707c00000000,
    0x00098e0a00000000, 0x0001c70900000000, 0x0008688f80000000,
    0x0005d24ac0000000, 0x0009b8a2e0000000, 0x0002663290000000,
    0x000cd8ac98000000, 0x0006363394000000, 0x0008a0af16000000,
    0x000e323b53000000, 0x0004aea8fe800000, 0x000c353441400000,
    0x0001a623a6200000, 0x0001b774b7700000, 0x000e668be6880000,
    0x000ed54d154c0000, 0x0003302e50220000, 0x0005247d74750000,
    0x0001f80f80058000, 0x000bc40ac003c000, 0x00016e02e00d6000,
    0x000a570290085000, 0x0003708498067800, 0x0000864f940d0400,
    0x000e4ea516018e00, 0x0002a532530dc700, 0x00073e277e8a6880,
    0x000b237e8140d240, 0x0006f081462438a0, 0x00034646277da630,
    0x00032ea77e8bb8a8, 0x000af53e8147663c, 0x00014621462158aa,
    0x000627762779f639, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x0005000000000000, 0x0005800000000000,
    0x000ac00000000000, 0x0006a00000000000, 0x0008500000000000,
    0x000fb80000000000, 0x000a8c0000000000, 0x0008420000000000,
    0x000ae30000000000, 0x0004b08000000000, 0x000e074000000000,
    0x0001086000000000, 0x000388f000000000, 0x000fc2e800000000,
    0x000320b400000000, 0x0002980e00000000, 0x00091c0100000000,
    0x0002da0380000000, 0x0007ff0fc0000000, 0x00006a8320000000,
    0x000cf84290000000, 0x0004e2e918000000, 0x0005b0b2dc000000,
    0x000d800ffa000000, 0x000ec0046f000000, 0x0000a00af2800000,
    0x000d5001e4400000, 0x000a380038e00000, 0x00004c074fb00000,
    0x000ee2086a880000, 0x0002b308f8440000, 0x000b0882e2e60000,
    0x00048b40b0b50000, 0x00094a68000d8000, 0x00096bf4000ec000,
    0x000b726e0000a000, 0x000d27f1000d5000, 0x0003906b800a3800,
    0x000a94fbc0004c00, 0x000d18ed200ee200, 0x0004dfb39002b300,
    0x0002f282980b0880, 0x0005e4491c048b40, 0x000638e2da094a60,
    0x00024fb7ff096bf0, 0x000dea886a8b7268, 0x00023848f84d27f4,
    0x000442e2e2e3906e, 0x0008e0b0b0ba94f1, 0x0008000000000000,
    0x000c000000000000, 0x000a000000000000, 0x0005000000000000,
    0x000e800000000000, 0x0004400000000000, 0x0005e00000000000,
    0x000ad00000000000, 0x000ef80000000000, 0x0006840000000000,
    0x0008460000000000, 0x000fe50000000000, 0x000fd28000000000,
    0x00007f4000000000, 0x0002c62000000000, 0x000da4f000000000,
    0x0005306800000000, 0x00012dfc00000000, 0x0006f80200000000,
    0x000a840300000000, 0x0002460280000000, 0x000ae50140000000,
    0x00015283a0000000, 0x00043f4110000000, 0x0007262178000000,
    0x000774f2b4000000, 0x000bc86bbe000000, 0x0007a9fda1000000,
    0x000ebe0011800000, 0x00056100f9400000, 0x000d948174a00000,
    0x000a9a415fd00000, 0x000394a311880000, 0x00099bb2793c0000,
    0x00021648341a0000, 0x0006590eff7f0000, 0x000d306800008000,
    0x000d2dfc0000c000, 0x000cf8020000a000, 0x000f840300005000,
    0x000cc6028000e800, 0x000ea50140004400, 0x0004b283a0005e00,
    0x000eef411000ad00, 0x0009de217800ef80, 0x0001f0f2b4006840,
    0x00038e6bbe008460, 0x00084cfda100fe50, 0x00016c801180fd28,
    0x00051e40f94007f4, 0x000f52a174a02c62, 0x00073eb15fd0da4f,
    0x0008000000000000, 0x000c000000000000, 0x0006000000000000,
    0x000b000000000000, 0x0001800000000000, 0x0000400000000000,
    0x000da00000000000, 0x0000900000000000, 0x0002280000000000,
    0x000e840000000000, 0x000bc60000000000, 0x0000e30000000000,
    0x0007b58000000000, 0x000378c000000000, 0x00014c2000000000,
    0x000874d000000000, 0x00099d4800000000, 0x000bfb9400000000,
    0x0001880200000000, 0x0009140300000000, 0x000e6e0180000000,
    0x00052702c0000000, 0x0000538060000000, 0x00034bc010000000,
    0x000971a368000000, 0x0005181024000000, 0x00013f688a000000,
    0x000de847a1000000, 0x000466c8f1800000, 0x0001745738c00000,
    0x00091fa26d600000, 0x00073f111e300000, 0x0006ece9b3080000,
    0x0005e384cd340000, 0x0001376b6f520000, 0x0004bc45cae50000,
    0x0007a8c800008000, 0x0004c3540000c000, 0x000b642200006000,
    0x000af0d30000b000, 0x00045b4980001800, 0x00001896c0000400,
    0x0007bd826000da00, 0x000a2cc310000900, 0x00028222e8002280,
    0x000dc3d2e400e840, 0x000be6c8ea00bc60, 0x00063457b1000e30,
    0x00033fa399807b58, 0x000cef131cc0378c, 0x0008e4e8e76014c2,
    0x000bb785bf30874d, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x0005000000000000, 0x0008800000000000,
    0x0009c00000000000, 0x0002e00000000000, 0x0000500000000000,
    0x000ab80000000000, 0x0001c40000000000, 0x0006e20000000000,
    0x0002510000000000, 0x000fba8000000000, 0x0009404000000000,
    0x000f26e000000000, 0x0000b07000000000, 0x000feaa800000000,
    0x0003fd1c00000000, 0x000ee20200000000, 0x0006510100000000,
    0x000dba8080000000, 0x000c404140000000, 0x0007a6e220000000,
    0x0009707270000000, 0x000d0aa8b8000000, 0x0003ad1c14000000,
    0x00045a00ae000000, 0x0007950171000000, 0x000b588138800000,
    0x000e1141d4400000, 0x00081c61cea00000, 0x0000303020100000,
    0x00022c4b71b80000, 0x00031d6c381c0000, 0x000bb0ab54aa0000,
    0x0004681d8e470000, 0x0005ba8080008000, 0x0008404140004000,
    0x0005a6e220002000, 0x000c707270005000, 0x00058aa8b8008800,
    0x000a6d1c14009c00, 0x0006ba00ae002e00, 0x0007c50171000500,
    0x0001e0813880ab80, 0x000fd541d4401c40, 0x000efe61cea06e20,
    0x0002613020102510, 0x000d96cb71b8fba8, 0x000a5d2c381c9404,
    0x0004964b54aaf26e, 0x0004d86d8e470b07, 0x0008000000000000,
    0x000c000000000000, 0x0002000000000000, 0x0005000000000000,
    0x000c800000000000, 0x0003c00000000000, 0x0003e00000000000,
    0x0006700000000000, 0x000f980000000000, 0x000cc40000000000,
    0x0006660000000000, 0x000b310000000000, 0x000aba8000000000,
    0x0005d24000000000, 0x000c4fe000000000, 0x000b8cf000000000,
    0x00066bb800000000, 0x00071a8c00000000, 0x0001060200000000,
    0x0002810300000000, 0x0004c28080000000, 0x000a664140000000,
    0x000931e320000000, 0x000fb9f0f0000000, 0x00095738f8000000,
    0x000f89cd9c000000, 0x00086b61e6000000, 0x00001bb031000000,
    0x000880d919800000, 0x000dc13f8c400000, 0x0004e6db8ea00000,
    0x000ff03e84900000, 0x0000dc596bf80000, 0x000ce27d3f3c0000,
    0x0003f3bbdcee0000, 0x0002de8c47a30000, 0x0009e00080008000,
    0x000f70014000c000, 0x0001180320002000, 0x000a0400f0005000,
    0x00090600f800c800, 0x000e81019c003c00, 0x0006c283e6003e00,
    0x000f664331006700, 0x0005b1e19980f980, 0x000c79f2cc40cc40,
    0x000ab73aaea06660, 0x0009f9cd7490b310, 0x0007f36113f8aba8,
    0x000cdfb1e33c5d24, 0x000ee6d91aeec4fe, 0x0006f03c86a3b8cf,
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x000b000000000000, 0x0005800000000000, 0x0004400000000000,
    0x0007e00000000000, 0x0006900000000000, 0x0005b80000000000,
    0x000dc40000000000, 0x0005a20000000000, 0x0008710000000000,
    0x000dad8000000000, 0x0009bec000000000, 0x000bc42000000000,
    0x000ca0f000000000, 0x0006f7c800000000, 0x000c6d9c00000000,
    0x000a1a0200000000, 0x000ab50100000000, 0x000f8f8080000000,
    0x000e8fc2c0000000, 0x000409a160000000, 0x0007ce3110000000,
    0x000f6be9f8000000, 0x000b996da4000000, 0x000cf7cb6e000000,
    0x00036d9e71000000, 0x000d9a03e8800000, 0x0005f501dc400000,
    0x000def828b600000, 0x000c5fc1bfb00000, 0x000651a269080000,
    0x000c9a339c3c0000, 0x000f71e92bf20000, 0x000e2c6dce670000,
    0x0004f84880008000, 0x0002a25ec0004000, 0x000bf3a360002000,
    0x0000eb301000b000, 0x0000dc6978005800, 0x000c92af64004400,
    0x000abc6a0e007e00, 0x000a42af61006900, 0x000ae46a10805b80,
    0x000a16ac7840dc40, 0x000f7e69e5605a20, 0x000be3afceb08710,
    0x000091e98188dad8, 0x000cbc6e407c9bec, 0x00034049a092bc42,
    0x0004665d71d7ca0f, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x000b000000000000, 0x0004800000000000,
    0x0007400000000000, 0x000c200000000000, 0x000e700000000000,
    0x000b580000000000, 0x000ba40000000000, 0x0009b20000000000,
    0x000a3d0000000000, 0x0002f18000000000, 0x0008184000000000,
    0x000d82a000000000, 0x000cc19000000000, 0x0005e07800000000,
    0x000e138c00000000, 0x000d898200000000, 0x0009cc4100000000,
    0x000568a280000000, 0x00065892c0000000, 0x000a23f920000000,
    0x000b76cdd0000000, 0x000edaa108000000, 0x000365929c000000,
    0x0006527856000000, 0x000f2e8c29000000, 0x000bf8014c800000,
    0x000694025f400000, 0x0004ca0134600000, 0x0004e9035a100000,
    0x00049b8096a80000, 0x000ec14009640000, 0x000ae1201c9e0000,
    0x000094d297a30000, 0x0001cb5908008000, 0x00016e5e9c004000,
    0x000c595a5600a000, 0x0001235d2900b000, 0x000ff0dbcc804800,
    0x00099f1c9f407400, 0x000f407a1460c200, 0x0008238f8a10e700,
    0x000471831ea8b580, 0x000058405564ba40, 0x000f22a16a9e9b20,
    0x000ef1936ea3a3d0, 0x000618794c80af18, 0x000c878e5f40c184,
    0x000343833460782a, 0x000625425a107c19, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x000f000000000000,
    0x0009800000000000, 0x000b400000000000, 0x0005200000000000,
    0x0000700000000000, 0x000bf80000000000, 0x0005a40000000000,
    0x0003b20000000000, 0x00091d0000000000, 0x000d338000000000,
    0x000fdec000000000, 0x000954a000000000, 0x00058f1000000000,
    0x000b5df800000000, 0x000091dc00000000, 0x00086b8200000000,
    0x000a4ac100000000, 0x0007bea280000000, 0x000d0613c0000000,
    0x0002847a60000000, 0x0008c61ed0000000, 0x000166a348000000,
    0x000cd2111c000000, 0x0000ce787e000000, 0x000b7f1ea9000000,
    0x000667208c800000, 0x000151d197400000, 0x0001895884e00000,
    0x00015ecc2bb00000, 0x000f9678cb280000, 0x0001eb1fdac40000,
    0x00010d23f3fe0000, 0x000298d0bf370000, 0x000d70db48008000,
    0x0009790d1c004000, 0x000d635a7e00a000, 0x0002d7cfa900f000,
    0x0005cffa0c809800, 0x000dfcde5740b400, 0x0004a000e4e05200,
    0x000f3003fbb00700, 0x0004d8010328bf80, 0x000ad40106c45a40,
    0x0001ca03edfe3b20, 0x0007f901c63791d0, 0x000ba1820c805338,
    0x0006b3c25740bdec, 0x000f9f22e4e0354a, 0x000ff5d2fbb0a8f1,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x0007000000000000, 0x000f800000000000, 0x0004c00000000000,
    0x000a600000000000, 0x0008900000000000, 0x0006e80000000000,
    0x0001a40000000000, 0x0001760000000000, 0x0004bf0000000000,
    0x000a2f8000000000, 0x0007c5c000000000, 0x0007e36000000000,
    0x000551b000000000, 0x0004080800000000, 0x000272d400000000,
    0x0009398200000000, 0x0007eac300000000, 0x000524e380000000,
    0x00043071c0000000, 0x000d1d6be0000000, 0x00075c6530000000,
    0x000d7e0898000000, 0x000acdd524000000, 0x000d16003a000000,
    0x00072f02a9000000, 0x000d47803d800000, 0x0005a1c1dfc00000,
    0x00037563f3e00000, 0x000dbeb2e5700000, 0x0002af8adad80000,
    0x000c8317196c0000, 0x000944e2e5820000, 0x0007a072da750000,
    0x000a756b18008000, 0x00053864e400c000, 0x0009e80bda00e000,
    0x000222d799007000, 0x000bb180a580f800, 0x0009dec0fbc04c00,
    0x000d3ae1c9e0a600, 0x0005eb734c708900, 0x000c24e967586e80,
    0x000cb6a706ac1a40, 0x00065aeaf6621760, 0x0009fda50f054bf0,
    0x000f8b695ad822f8, 0x0004b366d96cbc5c, 0x000a598905829e36,
    0x0007fc17ea75251b, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x0003000000000000, 0x000b800000000000,
    0x0003c00000000000, 0x000de00000000000, 0x000df00000000000,
    0x0002980000000000, 0x0003240000000000, 0x000e920000000000,
    0x0006290000000000, 0x00071d8000000000, 0x0005e3c000000000,
    0x0009f2e000000000, 0x00009e7000000000, 0x000026b800000000,
    0x0005176c00000000, 0x0005ef8200000000, 0x000afac100000000,
    0x0008176080000000, 0x000b69b0c0000000, 0x0003be5ae0000000,
    0x000eb41cf0000000, 0x00033eb978000000, 0x0002f36e7c000000,
    0x000f1d8226000000, 0x0001e3c109000000, 0x000bf2e1c4800000,
    0x00039e71ba400000, 0x000ba6b85f600000, 0x0006d76ef4f00000,
    0x00080f83a2b80000, 0x00070ac2929c0000, 0x000a8f638b2e0000,
    0x00084db0c69b0000, 0x000d2c59f8008000, 0x00089d1ebc004000,
    0x00042338c6002000, 0x000710adf9003000, 0x0006ef60bc80b800,
    0x00017db3c6403c00, 0x000bd4587960de00, 0x0006891efdf0df00,
    0x000e493ae6382980, 0x000c2dafe8dc3240, 0x000018e3344ee920,
    0x000c6373c26b6290, 0x0009313ba2b8f1d8, 0x0006f9ae929c1e3c,
    0x000e12e18b2ebf2e, 0x000a6e71c69b39e7, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x000d000000000000,
    0x000f800000000000, 0x0003c00000000000, 0x0006e00000000000,
    0x0001900000000000, 0x0005080000000000, 0x000ca40000000000,
    0x0007b20000000000, 0x000afd0000000000, 0x00097a8000000000,
    0x0004b9c000000000, 0x00055ae000000000, 0x00064ef000000000,
    0x000f028800000000, 0x0006852400000000, 0x0006408200000000,
    0x000820c100000000, 0x0008f26280000000, 0x00075a3340000000,
    0x000f4aebe0000000, 0x000a8614f0000000, 0x000842ebb8000000,
    0x000f221564000000, 0x000a70e9c2000000, 0x000b1f1569000000,
    0x000a6a6a8c800000, 0x000df6d40f400000, 0x000cd88886a00000,
    0x00068c27fa700000, 0x00016002ccb80000, 0x000650006ebc0000,
    0x0009e803b6220000, 0x00003403e3090000, 0x000d3a0138008000,
    0x0005990224004000, 0x000828802200a000, 0x000fd4c09900d000,
    0x00092863b480f800, 0x000e53322b403c00, 0x000dea6aa4a06e00,
    0x000a36d663701900, 0x0000388bf8385080, 0x000a1c2505fcca40,
    0x000be800f2827b20, 0x000934007079afd0, 0x0008ba03f83817a8,
    0x000b590105fc0b9c, 0x00014882f282f5ae, 0x000d84c17079b4ef,
    0x0008000000000000, 0x0004000000000000, 0x0006000000000000,
    0x000d000000000000, 0x000c800000000000, 0x000bc00000000000,
    0x0004e00000000000, 0x0005700000000000, 0x0008080000000000,
    0x0000a40000000000, 0x000fd20000000000, 0x0008db0000000000,
    0x000ffa8000000000, 0x000a684000000000, 0x000110e000000000,
    0x0004bdf000000000, 0x00074d7800000000, 0x000b872400000000,
    0x0008408200000000, 0x0008a74100000000, 0x000bd06180000000,
    0x000edab340000000, 0x0002fd1b20000000, 0x0006ed96f0000000,
    0x000ad59b38000000, 0x00005ed45c000000, 0x00023ff982000000,
    0x00038b6669000000, 0x0008e26354800000, 0x000771b286c00000,
    0x00030f9866a00000, 0x000121d676100000, 0x0008977a5e380000,
    0x0007f827aa7c0000, 0x000e68029dde0000, 0x00071403e2090000,
    0x0009ba02b8008000, 0x000bcf031c004000, 0x00004080a2006000,
    0x000ca7419900d000, 0x000dd061ec80c800, 0x0003dab19ac0bc00,
    0x000e7d18c4a04e00, 0x000d2d97ef105700, 0x000e359bb2b88080,
    0x00052ed630bc0a40, 0x000a37fa597efd20, 0x00032f640d198db0,
    0x000730610ab87fa8, 0x000faab12cbce684, 0x000cf518fb7e710e,
    0x000b499494199bdf, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x000b000000000000, 0x000a800000000000,
    0x000d400000000000, 0x000fa00000000000, 0x000f900000000000,
    0x0009280000000000, 0x0001940000000000, 0x00042a0000000000,
    0x0002150000000000, 0x0008ef8000000000, 0x000a704000000000,
    0x0005992000000000, 0x00036f9000000000, 0x0002b2e800000000,
    0x000ffd0400000000, 0x0005192200000000, 0x00012f9100000000,
    0x000592e880000000, 0x00062d06c0000000, 0x00091120a0000000,
    0x00026b9250000000, 0x000730eb68000000, 0x000a3c0524000000,
    0x000cfca2ea000000, 0x000b9ad235000000, 0x000e6c4a62800000,
    0x000136d5a1400000, 0x000338e8d1e00000, 0x000d7804a9100000,
    0x000c5ea104c80000, 0x000c8bd07aa40000, 0x000101cafd5a0000,
    0x0005879496510000, 0x0005c44a62808000, 0x0009e2d5a1404000,
    0x000ab2e8d1e02000, 0x000bfd04a910b000, 0x0007192104c8a800,
    0x000a2f907aa4d400, 0x000f12eafd5afa00, 0x000b6d049651f900,
    0x0006b12262801280, 0x000dfb91a1405940, 0x000e18ead1e062a0,
    0x000ba805a9109150, 0x0008d6a184c826f8, 0x00098fd2baa47304,
    0x000683c85d5aa392, 0x000b4697c651cff9, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x000b000000000000,
    0x0005800000000000, 0x0001c00000000000, 0x0007200000000000,
    0x0004f00000000000, 0x000a180000000000, 0x0007740000000000,
    0x0004da0000000000, 0x000bd30000000000, 0x000aef8000000000,
    0x000369c000000000, 0x0008ab6000000000, 0x000a885000000000,
    0x0000fe1800000000, 0x000ea0dc00000000, 0x000f336200000000,
    0x00083c5100000000, 0x000d041b80000000, 0x000a83dec0000000,
    0x000a44e360000000, 0x000de19170000000, 0x0006557a48000000,
    0x000f288ffc000000, 0x000a4d79e6000000, 0x00075c8cad000000,
    0x000517797e800000, 0x00064f8c08c00000, 0x000d58f8dde00000,
    0x0000164eb7700000, 0x0008cb9a34580000, 0x00091a1edad40000,
    0x0006f7812a660000, 0x000b1dc023470000, 0x0007f1617e808000,
    0x000b9b5008c04000, 0x0008b19adde0e000, 0x0008f91fb770b000,
    0x000aa001b4585800, 0x000130001ad41c00, 0x000338024a667200,
    0x0008840153474f00, 0x000b420336802180, 0x000d6703f4c03740,
    0x000915813be0ada0, 0x000c4ac21a700d30, 0x00085ce34ad8f6f8,
    0x000e9592d2142a9c, 0x000c8f79f786f8b6, 0x000ffb8e9437e785,
    0x0008000000000000, 0x0004000000000000, 0x000a000000000000,
    0x0005000000000000, 0x0008800000000000, 0x0003400000000000,
    0x000a200000000000, 0x0000300000000000, 0x0004180000000000,
    0x000f740000000000, 0x00003a0000000000, 0x0000410000000000,
    0x0009a08000000000, 0x0004f14000000000, 0x0000fb2000000000,
    0x000ea55000000000, 0x000d73b800000000, 0x00013a1c00000000,
    0x0002c12200000000, 0x000fe45100000000, 0x0006533a80000000,
    0x00038b5d40000000, 0x00009a0020000000, 0x00023101d0000000,
    0x0005188008000000, 0x000df5414c000000, 0x0006792326000000,
    0x0002e0530d000000, 0x000ad13a86800000, 0x000ace5c1c400000,
    0x000fb8816e200000, 0x000a8543e1500000, 0x00024122b0480000,
    0x0008a452f9140000, 0x0006733b14ce0000, 0x0006bb5da2d70000,
    0x000c020006808000, 0x000e05015c404000, 0x000f02814e20a000,
    0x000d844231505000, 0x000bc1a2b8488800, 0x00096513b5143400,
    0x000a101832cea200, 0x00042a0eafd70300, 0x000b6bba8000c180,
    0x000f4e1d4000b740, 0x00007b202000a3a0, 0x0009e551d0005410,
    0x000d53b808001208, 0x00040a1d4c007b14, 0x000e59212600adb2,
    0x0003d0520d00e955, 0x0008000000000000, 0x0004000000000000,
    0x000e000000000000, 0x000d000000000000, 0x000b800000000000,
    0x0001c00000000000, 0x0008200000000000, 0x000fb00000000000,
    0x000ed80000000000, 0x0008740000000000, 0x000ffa0000000000,
    0x0002430000000000, 0x000de48000000000, 0x000992c000000000,
    0x000c6e6000000000, 0x000d2dd000000000, 0x0006493800000000,
    0x00059a7c00000000, 0x0000146200000000, 0x000aaed100000000,
    0x000d8dbb80000000, 0x000eb8bf40000000, 0x00092200e0000000,
    0x000e370170000000, 0x000c1e8188000000, 0x0006d1c0ac000000,
    0x000a0ae156000000, 0x00057f126d000000, 0x00020759f6800000,
    0x000707af7cc00000, 0x0008855acf200000, 0x000740ad79b00000,
    0x000263d965180000, 0x0006556d9bb40000, 0x00094b398b6e0000,
    0x00091d7d322f0000, 0x000952e276808000, 0x0005cb103cc04000,
    0x00005d5a2f20e000, 0x000634ac09b0d000, 0x000819d8ed18b800,
    0x0008d66d37b41c00, 0x00070fb8dd6e8200, 0x000effbf5f2ffb00,
    0x0003c48380006d80, 0x000f22c34000c740, 0x00073662e0001fa0,
    0x000999d07000f430, 0x000a133a08006648, 0x0009a97fec00852c,
    0x000b08e1b60044e6, 0x0004f8131d0029dd, 0x0008000000000000,
    0x000c000000000000, 0x000a000000000000, 0x0001000000000000,
    0x0004800000000000, 0x000ac00000000000, 0x0000600000000000,
    0x0009500000000000, 0x0000580000000000, 0x000c940000000000,
    0x0003be0000000000, 0x0000810000000000, 0x000cc68000000000,
    0x000b674000000000, 0x000cd5e000000000, 0x000e1a7000000000,
    0x000635c800000000, 0x000a8e1c00000000, 0x00098be200000000,
    0x00000b7300000000, 0x00044b4a80000000, 0x000fed5c40000000,
    0x0002580320000000, 0x00019401b0000000, 0x000d3e0298000000,
    0x000b410214000000, 0x0008268136000000, 0x0008f74195000000,
    0x000cede0f7800000, 0x000bde7274400000, 0x0005d3cb27a00000,
    0x00069b1dfcd00000, 0x0006f361daf80000, 0x000bed30a6dc0000,
    0x000458283cd20000, 0x000a906c3a570000, 0x0008b82a77808000,
    0x0005006e3440c000, 0x0002802807a0a000, 0x0001c46c4cd01000,
    0x0005e62b42f84800, 0x0007116eb2dcac00, 0x000afeab0ad20600,
    0x0005a72eaf579500, 0x000ab5c800008580, 0x000c4e1c00000940,
    0x0003ebe200009be0, 0x00085b7300001810, 0x0000934a80008468,
    0x0009b95c40001a74, 0x000186032000cb5e, 0x00084501b00074a7,
    0x0008000000000000, 0x0004000000000000, 0x0006000000000000,
    0x000d000000000000, 0x000f800000000000, 0x0003400000000000,
    0x0001a00000000000, 0x000ff00000000000, 0x000f380000000000,
    0x0009340000000000, 0x0002da0000000000, 0x0003e70000000000,
    0x0003d48000000000, 0x00088cc000000000, 0x00052b2000000000,
    0x0008d91000000000, 0x000ce35800000000, 0x000750cc00000000,
    0x0009492200000000, 0x00084a1100000000, 0x0005cdd980000000,
    0x000d8b0f40000000, 0x000eae81e0000000, 0x000d9bc1d0000000,
    0x000047a1e8000000, 0x000721d0bc000000, 0x000532782e000000,
    0x0000dede9d000000, 0x0008e6fade800000, 0x0001521e05c00000,
    0x00044dd8bb200000, 0x0007cb0e2e300000, 0x00068e819c480000,
    0x000c2bc05f840000, 0x00015fa1c5f60000, 0x0002a5d39b030000,
    0x0009707b5e808000, 0x0005fddd45c04000, 0x0006d07b5b206000,
    0x00030ddefe30d000, 0x00006879f448f800, 0x000479dfa3843400,
    0x000c92780bf61a00, 0x000b2edcd603ff00, 0x0001def868007380,
    0x0005661ffc00d340, 0x000917d9ce004da0, 0x00076c0f4d00ee70,
    0x0004fa033680c548, 0x000b5702b9c0bccc, 0x000b4c82952048b2,
    0x000348c1b3307291, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x0001000000000000, 0x0002800000000000,
    0x000fc00000000000, 0x000b200000000000, 0x0005b00000000000,
    0x0003f80000000000, 0x0007f40000000000, 0x00089e0000000000,
    0x0002270000000000, 0x000b368000000000, 0x000a3a4000000000,
    0x000dd36000000000, 0x000faad000000000, 0x000e1a3800000000,
    0x0007e6ec00000000, 0x0007156200000000, 0x000c09d300000000,
    0x00036ab980000000, 0x000cbfac40000000, 0x00081682a0000000,
    0x00038a40f0000000, 0x00082b6348000000, 0x00095ed12c000000,
    0x000404385e000000, 0x000a01ee0d000000, 0x000703e2ef800000,
    0x00038392e5c00000, 0x000d41dbb3a00000, 0x0004e17f33900000,
    0x000e92bbf3580000, 0x00064baf93740000, 0x00040880032e0000,
    0x000f6d415b2b0000, 0x000abde36f808000, 0x00091492a5c0c000,
    0x00010f5b13a06000, 0x0007ef3cc3901000, 0x00027fd93b582800,
    0x0001b67eff74fc00, 0x0009fc38fd2eb200, 0x0000f5eca62b5b00,
    0x000b1de34800bf80, 0x000f64912c00bf40, 0x000fd7585e00e9e0,
    0x0004ab3e0d003270, 0x000b99daef809b68, 0x000ba57ee5c05fa4,
    0x000174b9b3a06f36, 0x000d58ac3390a1ad, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x0003000000000000,
    0x0000800000000000, 0x0004c00000000000, 0x000f600000000000,
    0x0007f00000000000, 0x0007680000000000, 0x0001940000000000,
    0x00011a0000000000, 0x0007bf0000000000, 0x0008af8000000000,
    0x000a754000000000, 0x00042ae000000000, 0x000cb17000000000,
    0x000e4a5800000000, 0x0008c12400000000, 0x000d656200000000,
    0x0002f43100000000, 0x0004e8b980000000, 0x0005d454c0000000,
    0x000abd3a20000000, 0x000f2e1430000000, 0x0008305858000000,
    0x000c8e243c000000, 0x0004a2e27a000000, 0x000a157095000000,
    0x0001585a3e800000, 0x000a1a25e3c00000, 0x000338e209e00000,
    0x000a6a7334500000, 0x000617dace380000, 0x00035f679a9c0000,
    0x000f1a0205f60000, 0x0000bf0117d90000, 0x000e2f8266808000,
    0x000db541dfc04000, 0x000bcae073e06000, 0x000f8173a1503000,
    0x00064258f0b80800, 0x000ea526795c4c00, 0x000b17620c16f600,
    0x0004df3323897f00, 0x000d5d3928b8f680, 0x00081e16855c5940,
    0x0006385a561671a0, 0x0009ea2786894bf0, 0x000250e34e3802f8,
    0x0008fe735a9cab54, 0x00078dd825f6d4ae, 0x0000206527d98417,
    0x0008000000000000, 0x0004000000000000, 0x000a000000000000,
    0x0007000000000000, 0x000b800000000000, 0x0007c00000000000,
    0x0004a00000000000, 0x000f300000000000, 0x0009080000000000,
    0x0008140000000000, 0x0005fa0000000000, 0x000fb90000000000,
    0x0005dd8000000000, 0x0008cec000000000, 0x0005b36000000000,
    0x000c4b1000000000, 0x000df33800000000, 0x0005297400000000,
    0x000166e200000000, 0x000891d100000000, 0x0007ba5a80000000,
    0x0001db65c0000000, 0x0002c858e0000000, 0x0002b664f0000000,
    0x0007cfd9a8000000, 0x000a31a70c000000, 0x0001893822000000,
    0x000e507735000000, 0x00019b6236800000, 0x000faf1112400000,
    0x0004213a7d600000, 0x000d7477cab00000, 0x0007696398580000,
    0x000f0211c5840000, 0x000f86ba9f2e0000, 0x000dc3b49ead0000,
    0x0003a7839e808000, 0x0004b7c21e404000, 0x000ecee05f60a000,
    0x000cb5d1ffb07000, 0x000ac85b2ed8b800, 0x0006b66517c47c00,
    0x000dcfd8024e4a00, 0x000d31a7a41df300, 0x000a0939aed81080,
    0x00099074d7c4c140, 0x00053b62e24effa0, 0x00009f12541d8b90,
    0x000d293a86d865d8, 0x000560761bc4b0ec, 0x00029362204eb136,
    0x0000bb11911d47b1, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x000b000000000000, 0x0008800000000000,
    0x000d400000000000, 0x000ea00000000000, 0x000b700000000000,
    0x000f580000000000, 0x000a540000000000, 0x000fea0000000000,
    0x0007e90000000000, 0x0003eb8000000000, 0x0009ef4000000000,
    0x0002e82000000000, 0x000a6d9000000000, 0x000729d800000000,
    0x00098c9c00000000, 0x0002fba200000000, 0x000da6d100000000,
    0x0007f3fa80000000, 0x00081c0ec0000000, 0x000ff3f820000000,
    0x000c1c0e50000000, 0x0005f3fb28000000, 0x00071c0d1c000000,
    0x000d73f976000000, 0x000a5c0e05000000, 0x0003d3faf2800000,
    0x00012c0fb6400000, 0x000c8bfa24e00000, 0x000b780ea2d00000,
    0x000361f99e880000, 0x000c910fb8240000, 0x00008a7814160000,
    0x00057e4d3bb70000, 0x00026259da808000, 0x000f13deaa404000,
    0x00054b8152e0a000, 0x00069f41a7d0b000, 0x0007b021ec088800,
    0x000b3992ce64d400, 0x000043d810f6ea00, 0x0003259cc967b700,
    0x000fb021ec087580, 0x000f3992ce64e540, 0x000a43d810f65ea0,
    0x0008259cc967ce90, 0x00073021ec0836b8, 0x00027992ce640af4,
    0x0004e3d810f66482, 0x0003559cc967a1d9, 0x0008000000000000,
    0x0004000000000000, 0x0002000000000000, 0x0005000000000000,
    0x0000800000000000, 0x0003400000000000, 0x0001a00000000000,
    0x000d100000000000, 0x000ac80000000000, 0x0005740000000000,
    0x00043a0000000000, 0x00018d0000000000, 0x0000d48000000000,
    0x000b2b4000000000, 0x000e462000000000, 0x0005201000000000,
    0x000c566800000000, 0x000e6e9400000000, 0x0008e0a200000000,
    0x000db25100000000, 0x00055ec880000000, 0x0009f8c540000000,
    0x00006c6a20000000, 0x000be395d0000000, 0x000a3422e8000000,
    0x0003991304000000, 0x000b98ea12000000, 0x000f98d4cd000000,
    0x000d9a0346800000, 0x00089d02f7400000, 0x00081c826f200000,
    0x000b5f4193d00000, 0x000afc200d080000, 0x0007ed10a6440000,
    0x000d22ea463a0000, 0x000855d676350000, 0x000c6e812e808000,
    0x000de640b3404000, 0x000d32a05d202000, 0x00061b518ed05000,
    0x0008584923880800, 0x000d7a8415043400, 0x00012cc81b1a1a00,
    0x000f41c6f8e5d100, 0x0007a2e88d082c80, 0x000a15d5e6441740,
    0x000f4e80663a63a0, 0x0006b643a63548d0, 0x0006daa3c6808548,
    0x000d3f53b740c6b4, 0x00070a4a4f20de62, 0x0004938543d0d301,
    0x0008000000000000, 0x0004000000000000, 0x0006000000000000,
    0x000f000000000000, 0x0000800000000000, 0x000e400000000000,
    0x000e600000000000, 0x0000700000000000, 0x0001080000000000,
    0x0007d40000000000, 0x0005da0000000000, 0x00008f0000000000,
    0x0002118000000000, 0x0003794000000000, 0x000fdfa000000000,
    0x000d8ef000000000, 0x000b925800000000, 0x0002be1400000000,
    0x000f7c2200000000, 0x000ddcb100000000, 0x00048e7980000000,
    0x000412a7c0000000, 0x000c7a5a20000000, 0x000f5a1690000000,
    0x0003ce2018000000, 0x0005f7b2dc000000, 0x0002cdf9e2000000,
    0x000e70e5a5000000, 0x000a0e78ce800000, 0x000152a6afc00000,
    0x00049a58de600000, 0x000e6a17f7500000, 0x000c262163680000,
    0x000c13b3e57c0000, 0x00087ff92e760000, 0x00095be41e150000,
    0x000ccdf956808000, 0x000570e7b3c04000, 0x000c8e791c606000,
    0x000012a5c250f000, 0x000a7a5835e80800, 0x00005a1456bce400,
    0x00034e203216e600, 0x000bb7b1dc450700, 0x000cadf963689080,
    0x000e00e7e57c3d40, 0x000b067b2e763da0, 0x000686a51e15f8f0,
    0x00014058d680a918, 0x000ee51473c09394, 0x000e37a13c607bfa,
    0x000f6af252502fef, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x000b000000000000, 0x0003800000000000,
    0x000ac00000000000, 0x000a200000000000, 0x000cf00000000000,
    0x0005780000000000, 0x0002fc0000000000, 0x00063a0000000000,
    0x00051b0000000000, 0x00016e8000000000, 0x000d574000000000,
    0x000f4e2000000000, 0x000fa13000000000, 0x0003344800000000,
    0x0005dc7400000000, 0x000c4c4a00000000, 0x0000207700000000,
    0x000bf64a80000000, 0x0004fb75c0000000, 0x000338ca60000000,
    0x000f9c3770000000, 0x00032ee8e8000000, 0x000e31044c000000,
    0x000358a1b6000000, 0x000c0a70f3000000, 0x0008406a38800000,
    0x00046646b5c00000, 0x000d9680e3200000, 0x00026b4020100000,
    0x0002d42150a80000, 0x00078a30b85c0000, 0x000e82cb75ba0000,
    0x000c473683410000, 0x000a606950a88000, 0x00049644b85cc000,
    0x000aee8175ba2000, 0x000b97418341b000, 0x00076e23d0a8b800,
    0x00085131785c6c00, 0x0005cc4b15ba8200, 0x000de076f3417f00,
    0x0000564b38a8ef80, 0x0009cb75345c43c0, 0x000fe0caa3bae1a0,
    0x000b503600412eb0, 0x000a4ce90028f968, 0x00052607819c96b4,
    0x00017420409a1542, 0x0006ba312051d4a3, 0x0008000000000000,
    0x000c000000000000, 0x0002000000000000, 0x0001000000000000,
    0x0007800000000000, 0x0006c00000000000, 0x0007e00000000000,
    0x000ff00000000000, 0x0001880000000000, 0x000c0c0000000000,
    0x0007ca0000000000, 0x0005ab0000000000, 0x000d9b8000000000,
    0x000c704000000000, 0x00094f2000000000, 0x0008eed000000000,
    0x000ebe2800000000, 0x0005676c00000000, 0x0000b62a00000000,
    0x0003ab6f00000000, 0x00029c2a80000000, 0x0008f06f40000000,
    0x00090fab60000000, 0x000e4c2ef0000000, 0x00006a8a98000000,
    0x000cf9fd0c000000, 0x0002c722fa000000, 0x0009e2d20f000000,
    0x000cf42908800000, 0x00070c6c65c00000, 0x000d4da8ee600000,
    0x0006eb2c39d00000, 0x000dbb0bdda80000, 0x0003e2bff2640000,
    0x0001f3806a220000, 0x00028c40e7bf0000, 0x000a8d23dda88000,
    0x000689d3f264c000, 0x00048faa6a222000, 0x00058c2fe7bf1000,
    0x00020a895da8f800, 0x0004c9fcb264ac00, 0x00032f210a225e00,
    0x000cded117bfef00, 0x000d562bc5a8e080, 0x00015b6dbe646cc0,
    0x00069429f02222a0, 0x00033c6c18bfb5b0, 0x000ea5a84d283938,
    0x0002d72e9ba4abc4, 0x000b990a7e42b652, 0x000375bed16f3b5d,
    0x0008000000000000, 0x000c000000000000, 0x000a000000000000,
    0x0003000000000000, 0x000d800000000000, 0x000f400000000000,
    0x000d200000000000, 0x000ab00000000000, 0x0009880000000000,
    0x00090c0000000000, 0x000eca0000000000, 0x00082f0000000000,
    0x000e7e8000000000, 0x0002a04000000000, 0x000af3e000000000,
    0x00032b7000000000, 0x000fff2800000000, 0x0007e46c00000000,
    0x0004d72a00000000, 0x0004186f00000000, 0x0009352880000000,
    0x0003cb6fc0000000, 0x0000a9abe0000000, 0x0005b82c10000000,
    0x000e46c8a8000000, 0x000fa01ebc000000, 0x00027682ca000000,
    0x0008ec40ff000000, 0x000319e378800000, 0x0002b471f4c00000,
    0x000589aa67200000, 0x0003082d9cd00000, 0x000dcec9bbd80000,
    0x0005ac1d860c0000, 0x00013c838c120000, 0x000f834213170000,
    0x00004761bbd88000, 0x000aa431860cc000, 0x0006f2498c12a000,
    0x00092f5d13173000, 0x000cfbe13bd85800, 0x000a6772460c3400,
    0x000b95286c127200, 0x00093b6e03179b00, 0x000381a913d8c080,
    0x000a442f3a0ca4c0, 0x0009a4cb46129ea0, 0x000b731dec1719f0,
    0x00066a0243582768, 0x0001df03b2cc8ec4, 0x0000d6820b32319e,
    0x00021c439fc72b47, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x0003000000000000, 0x0000800000000000,
    0x0000c00000000000, 0x0007200000000000, 0x000f900000000000,
    0x0004a80000000000, 0x00086c0000000000, 0x00014e0000000000,
    0x0007db0000000000, 0x0000f28000000000, 0x0008dec000000000,
    0x000e70a000000000, 0x0001183000000000, 0x000ad57800000000,
    0x000ecdec00000000, 0x00099b7a00000000, 0x000e16ed00000000,
    0x0003e9f880000000, 0x0005082dc0000000, 0x000a3958a0000000,
    0x000b401df0000000, 0x0003642168000000, 0x000271f214000000,
    0x000f195a42000000, 0x0003d01d0f000000, 0x000d4c2291800000,
    0x0009ddf139c00000, 0x0009f75a0d200000, 0x000b5b1efe700000,
    0x000e36a0f9080000, 0x0006ff30ac7c0000, 0x000261fa0e560000,
    0x0005f42f10070000, 0x00055f5879088000, 0x0007371d6c7c4000,
    0x000578a2ae56a000, 0x00022432e0073000, 0x0002137911088800,
    0x000deaef787c4c00, 0x000c0ff8ec56d200, 0x0009bf2fef07c900,
    0x000b05db8088c280, 0x000485de41bccac0, 0x000ac602e176c6e0,
    0x000427011177b4b0, 0x000f14837980cda8, 0x000469c2edc0472c,
    0x000f4c22ef2021ea, 0x000eddf30170a533, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x0005000000000000,
    0x0002800000000000, 0x000e400000000000, 0x0001e00000000000,
    0x0000d00000000000, 0x0004f80000000000, 0x00003c0000000000,
    0x000b9e0000000000, 0x000cad0000000000, 0x000d878000000000,
    0x000bc2c000000000, 0x000e27e000000000, 0x0008f41000000000,
    0x00090ef800000000, 0x000bb1c400000000, 0x000e68fa00000000,
    0x000320c500000000, 0x000e717b80000000, 0x00014f0440000000,
    0x000f511b20000000, 0x000c39d7d0000000, 0x0009980358000000,
    0x000fac03e4000000, 0x000a060066000000, 0x00070102eb000000,
    0x0001818301800000, 0x0009c3c080400000, 0x000d2660c0600000,
    0x000f77d1e0f00000, 0x0005c89b31980000, 0x00041617e9f40000,
    0x000f58624c260000, 0x00070ad00a850000, 0x000ab718b1988000,
    0x000ae8d7a9f44000, 0x000861836c266000, 0x000d13c2da855000,
    0x000fde606998a800, 0x000a4bd00df4a400, 0x000cd6982a267e00,
    0x0006fb17e1855d00, 0x00033fe03018e780, 0x000c181369b4a7c0,
    0x000068f88c46c7e0, 0x000220c4ea7597d0, 0x000af17800003ff8,
    0x000a0f0400001bec, 0x000c311a0000259e, 0x0002a9d500001891,
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x000b000000000000, 0x0003800000000000, 0x0002c00000000000,
    0x000d200000000000, 0x0008d00000000000, 0x0007080000000000,
    0x00014c0000000000, 0x000b2e0000000000, 0x00051f0000000000,
    0x000f628000000000, 0x0000b74000000000, 0x00023c2000000000,
    0x0008b7b000000000, 0x0006385800000000, 0x000ab51c00000000,
    0x000d3e5a00000000, 0x0009361d00000000, 0x000ffada80000000,
    0x0004125fc0000000, 0x00072a7a60000000, 0x00031daf70000000,
    0x0006648128000000, 0x0008344144000000, 0x000378a2ea000000,
    0x000753f017000000, 0x0003c8f8a1800000, 0x00056aef90c00000,
    0x000b78a199200000, 0x000353f20d100000, 0x0001c8f8de280000,
    0x000e6aedd4fc0000, 0x0008f8a2f23e0000, 0x000193f05abb0000,
    0x000ce8fa5e288000, 0x0006baee14fc4000, 0x000ff0a2923e2000,
    0x0000dff22abbb000, 0x0007c6f9f628b800, 0x0003a5ec90fc6c00,
    0x00009220183ef200, 0x000068b04dbb3d00, 0x0005fadaffa8c880,
    0x000b125d843c78c0, 0x0006aa790b1e40e0, 0x000addad27ab6cf0,
    0x0008c483a8003ea8, 0x00022442840073b4, 0x000950a28a006322,
    0x000ecff26700e78b, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x0005000000000000, 0x000d800000000000,
    0x000ec00000000000, 0x000f200000000000, 0x0006500000000000,
    0x0008780000000000, 0x00005c0000000000, 0x00048a0000000000,
    0x000cb10000000000, 0x00058f8000000000, 0x000b334000000000,
    0x00084d2000000000, 0x000c913000000000, 0x000d5f5800000000,
    0x0005094400000000, 0x000470da00000000, 0x000faa0700000000,
    0x0000e5fb80000000, 0x000ef73640000000, 0x0003e8a0e0000000,
    0x000f8371f0000000, 0x0001c5f928000000, 0x0001a73764000000,
    0x000010a0b6000000, 0x00041f7133000000, 0x0007eff974800000,
    0x00058637ef400000, 0x0002c7233f600000, 0x0009203147900000,
    0x000350d81a280000, 0x0005fa0610dc0000, 0x000e9dfb597e0000,
    0x000bab340dcd0000, 0x000ae2a132288000, 0x000df27174dcc000,
    0x000b6a7bef7e6000, 0x000cc4753ecd5000, 0x0000258046a85800,
    0x0008d2429b9c2c00, 0x000e3aa2d01e9200, 0x000c3e73795d3500,
    0x0003387bdc80df80, 0x000db976cb4029c0, 0x000bf8036960daa0,
    0x00079c018490fe10, 0x00002a0046a80778, 0x000121029b9c5af4,
    0x000f5782d01e3e72, 0x0003ff43795d6703, 0x0008000000000000,
    0x000c000000000000, 0x000a000000000000, 0x0009000000000000,
    0x0005800000000000, 0x000c400000000000, 0x0006600000000000,
    0x0003b00000000000, 0x0003980000000000, 0x000d7c0000000000,
    0x00010a0000000000, 0x000bb70000000000, 0x000f9f8000000000,
    0x00077f4000000000, 0x00080a6000000000, 0x000e30d000000000,
    0x0003db4800000000, 0x00011c6400000000, 0x000bbcca00000000,
    0x000daf2700000000, 0x000ea4a880000000, 0x000014f540000000,
    0x00000a61e0000000, 0x000230d250000000, 0x0009db4a78000000,
    0x00081c65bc000000, 0x000e3cca1e000000, 0x0001ef27a3000000,
    0x0008c4a9bc800000, 0x0003a4f41ec00000, 0x00039262a3600000,
    0x000f4cd23d100000, 0x0008d14bdff80000, 0x0003ab6502240000,
    0x0001a34b0daa0000, 0x00069065b7fd0000, 0x0000cec9a7f88000,
    0x000d9424be24c000, 0x0000492b13aaa000, 0x000e50b514fd9000,
    0x00036d809b78d800, 0x000e0441e0e40400, 0x000f07e250cac600,
    0x0006849279edab00, 0x0000c4a9bc80e180, 0x000fa4f41ec0d3c0,
    0x00099262a360d6a0, 0x00064cd23d101070, 0x000d514bdff89878,
    0x000feb6502246434, 0x0007c34b0daaf606, 0x00052065b7fd637d,
    0x0008000000000000, 0x0004000000000000, 0x000e000000000000,
    0x0001000000000000, 0x000b800000000000, 0x000b400000000000,
    0x000fa00000000000, 0x0004700000000000, 0x000d180000000000,
    0x0001fc0000000000, 0x000e2e0000000000, 0x0009410000000000,
    0x0004a58000000000, 0x0000f24000000000, 0x000cd8e000000000,
    0x000e9bb000000000, 0x000ebe4800000000, 0x000f8a6400000000,
    0x000c35ca00000000, 0x0002392500000000, 0x000a48a980000000,
    0x000d50d540000000, 0x0003ae0360000000, 0x0007010390000000,
    0x000e858288000000, 0x000ec2438c000000, 0x0005e0e24e000000,
    0x000057b3b3000000, 0x0002284b25800000, 0x0003476733400000,
    0x000ba64be4e00000, 0x000a766713d00000, 0x000c1bc814d80000,
    0x000a78248a3c0000, 0x00056d2ad0ca0000, 0x0006e297e8e50000,
    0x0000d6e31cd88000, 0x000deab2463c4000, 0x000d23cbfecae000,
    0x0000b427cbe51000, 0x0007fb2ab1583800, 0x000b2f96f97cf400,
    0x000cc562542a1a00, 0x000ee5f36b355700, 0x0004d0a98000e980,
    0x0003ecd54000ebc0, 0x000c20036000f8e0, 0x000b30039000c310,
    0x000cb802880023d8, 0x00048c038c00a4e4, 0x0008b6024e00d56e,
    0x0003fd03b3003aab, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x0005000000000000, 0x000b800000000000,
    0x0001400000000000, 0x000d200000000000, 0x0006d00000000000,
    0x0002580000000000, 0x00073c0000000000, 0x00054e0000000000,
    0x0003850000000000, 0x0005438000000000, 0x000b244000000000,
    0x0003d7e000000000, 0x0009dbf000000000, 0x0006795800000000,
    0x00086ad400000000, 0x000554da00000000, 0x00071b9500000000,
    0x000c18bb80000000, 0x0006982440000000, 0x000a580160000000,
    0x00033c0010000000, 0x00034e0028000000, 0x00068500a4000000,
    0x000ec3813e000000, 0x000a64402b000000, 0x000ef7e28d800000,
    0x000f0bf09a400000, 0x0004215895600000, 0x000f56d7e7500000,
    0x00001adaf6980000, 0x00049e955eac0000, 0x00095b3bbb4e0000,
    0x000dbc66e5590000, 0x00098fe15e988000, 0x000ae7f1baac4000,
    0x0005375be54e6000, 0x000eefd6de595000, 0x000b975bfb183800,
    0x000d7fd584ec5400, 0x0002ef584e2eb200, 0x000993d412093d00,
    0x000e795800001d80, 0x000c6ad4000027c0, 0x000354da0000e6e0,
    0x00021b9500000550, 0x000798bb8000c9b8, 0x0007d8244000d584,
    0x000778016000bb9e, 0x0005ec001000c8ef, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x000f000000000000,
    0x0003800000000000, 0x0002c00000000000, 0x0008600000000000,
    0x0007900000000000, 0x000e280000000000, 0x000d8c0000000000,
    0x000afe0000000000, 0x000c010000000000, 0x000a028000000000,
    0x0001014000000000, 0x000c872000000000, 0x0001449000000000,
    0x000aa69800000000, 0x000ff0ec00000000, 0x0009ba1a00000000,
    0x0003a0ad00000000, 0x000777b980000000, 0x0006f97ec0000000,
    0x0006000160000000, 0x000b000270000000, 0x000d800178000000,
    0x000dc00294000000, 0x000be00172000000, 0x0005500237000000,
    0x000648032d800000, 0x000a1c0187400000, 0x0004d603b5200000,
    0x00018d0023100000, 0x0000fc831ee80000, 0x000d004311340000,
    0x000685a308ce0000, 0x000045d3ed4f0000, 0x000621bbe6e88000,
    0x000eb47f45344000, 0x00031c831acee000, 0x000c5043aa4ff000,
    0x000ecda1b368b800, 0x000559d056746c00, 0x000177bbddee6600,
    0x000df97cbe5f8900, 0x000b800000005a80, 0x0006c0000000b4c0,
    0x000660000000c9e0, 0x0008900000004910, 0x000da80000007aa8,
    0x000f4c000000e4d4, 0x00029e000000e192, 0x000b91000000ad59,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x0003000000000000, 0x0004800000000000, 0x0003400000000000,
    0x0003e00000000000, 0x0001b00000000000, 0x000e080000000000,
    0x000e2c0000000000, 0x000d3a0000000000, 0x000c650000000000,
    0x000a708000000000, 0x0000acc000000000, 0x000f7e6000000000,
    0x0006001000000000, 0x000f018800000000, 0x000a80ac00000000,
    0x0000430a00000000, 0x0007656f00000000, 0x0002f7e980000000,
    0x000decbfc0000000, 0x000f9880a0000000, 0x000330c310000000,
    0x00024c6258000000, 0x000749107c000000, 0x000ccb0a5a000000,
    0x0005096f37000000, 0x0006adea34800000, 0x000079bffe400000,
    0x000c8003d0a00000, 0x000f400379700000, 0x000de000ad380000,
    0x0002b002a2740000, 0x000a88035bda0000, 0x000d6c03b71f0000,
    0x000eda0375388000, 0x000dd5011e74c000, 0x00047883a1dae000,
    0x000e80c0901f3000, 0x0002446299b8c800, 0x000a65115c34f400,
    0x0005710a8b7ade00, 0x000a2c6fce6f2b00, 0x000f3d6a58002880,
    0x0001657c7c0016c0, 0x000df6605a000da0, 0x00076c103700ed50,
    0x000fdb8bb4800f88, 0x000455ac3e40dc0c, 0x0000bb8970a01a46,
    0x000aa5af6970bd51, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x000f000000000000, 0x0009800000000000,
    0x0009c00000000000, 0x0004e00000000000, 0x0005900000000000,
    0x0000780000000000, 0x000ddc0000000000, 0x000dea0000000000,
    0x0001a30000000000, 0x0002308000000000, 0x00034a4000000000,
    0x000a13a000000000, 0x0008bc5000000000, 0x000db95800000000,
    0x00073d0400000000, 0x00057bda00000000, 0x0007584700000000,
    0x000faafa80000000, 0x00038154c0000000, 0x000ac280e0000000,
    0x000f6542b0000000, 0x00035123d8000000, 0x000d1910d4000000,
    0x0001887b46000000, 0x0009741463000000, 0x0009eba05c800000,
    0x000fa0517bc00000, 0x000f335b68a00000, 0x0005ce040d500000,
    0x000a535912480000, 0x00059e07e5440000, 0x000ccb5ade9e0000,
    0x0002d20696c50000, 0x0008d9584a488000, 0x00076d07f144c000,
    0x0003e3db789e2000, 0x0000144745c5f000, 0x000bb8f94ec81800,
    0x00063e569e845c00, 0x0001f801b63e6e00, 0x00081c029b95a900,
    0x000b0a0158001f80, 0x000b3300140081c0, 0x000bc881a600b0a0,
    0x00075641d300b330, 0x000319a10480bc88, 0x000c8f516fc07564,
    0x000ff1dacea0319a, 0x0009ab45de50c8f5, 0x0008000000000000,
    0x0004000000000000, 0x0002000000000000, 0x0001000000000000,
    0x0000800000000000, 0x0008400000000000, 0x0009200000000000,
    0x0009100000000000, 0x000bd80000000000, 0x0008cc0000000000,
    0x0006160000000000, 0x000c5b0000000000, 0x00030d8000000000,
    0x0006f6c000000000, 0x0004af6000000000, 0x0000a53000000000,
    0x0005d2d800000000, 0x0008bc0400000000, 0x0009fdba00000000,
    0x0004593500000000, 0x00070f6280000000, 0x0004f53140000000,
    0x0005aad8a0000000, 0x0000200650000000, 0x000d93b868000000,
    0x00019e3554000000, 0x0000ece23e000000, 0x000f84f137000000,
    0x000fc63bd3800000, 0x0002e4f775c00000, 0x0009f5812ee00000,
    0x00032ac3ff700000, 0x000b6161d6b80000, 0x00053231a3fc0000,
    0x0000495b0cee0000, 0x000a51c5338d0000, 0x00077f5a05388000,
    0x000b1ac6d63c4000, 0x000daada220e2000, 0x00042006ccfd1000,
    0x000f93bbd3808800, 0x00009e3775c0c400, 0x00006ce12ee0b200,
    0x0007c4f3ff708100, 0x0006e639d6b8b580, 0x000bf4f5a3fc08c0,
    0x00022d810ceef360, 0x000be6c0338d54b0, 0x000d776085380d58,
    0x00096933963ca3ac, 0x000344d8820e0b96, 0x000ca7059cfddfe3,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x000f000000000000, 0x0007800000000000, 0x000ac00000000000,
    0x0003a00000000000, 0x0000d00000000000, 0x000f180000000000,
    0x0006cc0000000000, 0x000f520000000000, 0x0009df0000000000,
    0x00076a8000000000, 0x0000864000000000, 0x000141a000000000,
    0x000b623000000000, 0x000c75f800000000, 0x0008494400000000,
    0x0003145a00000000, 0x000a3b7700000000, 0x000659a280000000,
    0x0001ae30c0000000, 0x000127f960000000, 0x000e964570000000,
    0x0003fedb08000000, 0x00007d3584000000, 0x0004b801ae000000,
    0x000a1c0147000000, 0x00024a0172800000, 0x00001302b4c00000,
    0x000fb88306200000, 0x00039940d2500000, 0x00058b22a4c80000,
    0x000b34737e1c0000, 0x00022c5b5f960000, 0x0005e7770e1d0000,
    0x000033a3d6488000, 0x000bad31cadcc000, 0x0002277859b62000,
    0x000b1307dc4df000, 0x00063ff97280f800, 0x00045a46b4c06c00,
    0x000eacd906201a00, 0x0006a237d250fd00, 0x0004528024c88980,
    0x00005a43be1cc0c0, 0x0000aba23f96cf20, 0x000ba1327e1d90f0,
    0x000cd578de480728, 0x000d1c044edca4a4, 0x0009cd79f7b6c13a,
    0x0008d0069b4ddbd3, 0x0008000000000000, 0x0004000000000000,
    0x000e000000000000, 0x0003000000000000, 0x0009800000000000,
    0x0006c00000000000, 0x000aa00000000000, 0x0008300000000000,
    0x000d780000000000, 0x000c0c0000000000, 0x000a160000000000,
    0x00030d0000000000, 0x0009928000000000, 0x0008cf4000000000,
    0x0009b4a000000000, 0x000fbdb000000000, 0x0008ae8800000000,
    0x0001264400000000, 0x0007f42a00000000, 0x00035af500000000,
    0x00087e2180000000, 0x00028ef1c0000000, 0x000b5429e0000000,
    0x000c6af570000000, 0x00028622c8000000, 0x000b42f2bc000000,
    0x0002622a76000000, 0x000197f5cf000000, 0x000ccca1bb800000,
    0x0007b1b370400000, 0x000cb889c9200000, 0x00012b443c900000,
    0x0007e6ab37880000, 0x000d55b66fbc0000, 0x000b6a81eb0a0000,
    0x00050340a9bd0000, 0x000e82a30c088000, 0x000140b0dffc4000,
    0x000f640bc22ae000, 0x000b1504e52d3000, 0x00038e8b73801800,
    0x000bd645cc402c00, 0x000e2c29bf204a00, 0x000466f4f390b300,
    0x000690230c084f80, 0x000b4ff0dffcacc0, 0x000270abc22a0b60,
    0x000f98b4e52db3d0, 0x000fd8037380cea8, 0x00003c01cc400c34,
    0x00096e03bf20da2a, 0x000c0101f390fb0b, 0x0008000000000000,
    0x000c000000000000, 0x0006000000000000, 0x0003000000000000,
    0x0002800000000000, 0x0008c00000000000, 0x0002e00000000000,
    0x000c300000000000, 0x000ae80000000000, 0x00079c0000000000,
    0x0009d20000000000, 0x000e5d0000000000, 0x0000b68000000000,
    0x000d2ec000000000, 0x0001fa2000000000, 0x000e269000000000,
    0x0004d32800000000, 0x0003dd8c00000000, 0x000cf30a00000000,
    0x00040a1f00000000, 0x000daca380000000, 0x00003853c0000000,
    0x000b410920000000, 0x0001a71ef0000000, 0x0001922218000000,
    0x000d7a923c000000, 0x0009e12b82000000, 0x0002b08e2b000000,
    0x00042d8a6e800000, 0x000678df40400000, 0x0007648161200000,
    0x000c73c010f00000, 0x0005cca3c9280000, 0x0008c853d5140000,
    0x0005490b26c20000, 0x00090b1dd5870000, 0x0000282227a88000,
    0x000c7b935554c000, 0x000265a967e26000, 0x000df34c35773000,
    0x000f89287680a800, 0x0002ec8d7c404c00, 0x000b9f8ae3204e00,
    0x000fd5de3bf0f300, 0x000d5a01a7a88680, 0x000231009554f5c0,
    0x0005ec8047e2b320, 0x00031fc2c57726d0, 0x000216a26e8025e8,
    0x000e395340406b2c, 0x0004458b6120e282, 0x000524df10f037b9,
    0x0008000000000000, 0x000c000000000000, 0x0006000000000000,
    0x0007000000000000, 0x0004800000000000, 0x0006c00000000000,
    0x0004e00000000000, 0x0003b00000000000, 0x0009480000000000,
    0x000c1c0000000000, 0x000be20000000000, 0x000b350000000000,
    0x0009888000000000, 0x000ffdc000000000, 0x000cd32000000000,
    0x0004bc1000000000, 0x0001772800000000, 0x0007aabc00000000,
    0x000eac8a00000000, 0x00012b6f00000000, 0x0005688380000000,
    0x00004dc2c0000000, 0x00039b20a0000000, 0x000fa01070000000,
    0x000e152818000000, 0x000a5fbd5c000000, 0x0003c4096a000000,
    0x000d66aceb000000, 0x0000f3a32a800000, 0x0008edd30a400000,
    0x00090e083aa00000, 0x00033fad42300000, 0x000931234ee80000,
    0x000489108c740000, 0x000a7fa983020000, 0x0009977eeeab0000,
    0x00021fa87c688000, 0x0000e77eda34c000, 0x0009b7a8d3a26000,
    0x00084b7f479b7000, 0x000f9da81800c800, 0x0009a27d5c00ac00,
    0x000917296a002e00, 0x000edabceb004b00, 0x0005048b2a80dc80,
    0x0009876f0a40adc0, 0x000342823aa0f020, 0x0001a4c242308850,
    0x000511a0cee80c08, 0x0008d8d24c743e1c, 0x0002068923027312,
    0x000d026e9eabf891, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x0009000000000000, 0x0005800000000000,
    0x0004400000000000, 0x0001a00000000000, 0x000f100000000000,
    0x0004e80000000000, 0x000f5c0000000000, 0x0003260000000000,
    0x0003d10000000000, 0x00028f8000000000, 0x000caa4000000000,
    0x000cfee000000000, 0x000337f000000000, 0x000bbad800000000,
    0x000c14bc00000000, 0x000a6bba00000000, 0x0001990d00000000,
    0x000a478380000000, 0x000ca64340000000, 0x000c90e0e0000000,
    0x0009aaf350000000, 0x000b7b5908000000, 0x000873fed4000000,
    0x00069cdb52000000, 0x0002c5bd13000000, 0x000b643a73800000,
    0x0000734c63400000, 0x000299628a600000, 0x0004c1b18ed00000,
    0x0002623b14580000, 0x0005f24f736c0000, 0x0006dee3e30e0000,
    0x000567f3cbd30000, 0x000d72d86fd88000, 0x000118bdc42c4000,
    0x000985ba3b6e6000, 0x0006440f56039000, 0x000ea6010800d800,
    0x00039102d4000400, 0x00052f8152007a00, 0x000aba4013006100,
    0x000d96e1f3801680, 0x00082bf32340b1c0, 0x00093cd86a602860,
    0x0000d5bfded0cc10, 0x000c0c399c586678, 0x00026f4ee76c3f64,
    0x00059f62510efd8e, 0x000c40b088d30e6f, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x000f000000000000,
    0x000c800000000000, 0x000e400000000000, 0x0004200000000000,
    0x000bd00000000000, 0x0006a80000000000, 0x00005c0000000000,
    0x0002a20000000000, 0x0008910000000000, 0x000f088000000000,
    0x00064dc000000000, 0x0002eb6000000000, 0x0009783000000000,
    0x0004f57800000000, 0x0003fe7c00000000, 0x0009b69a00000000,
    0x00055b8f00000000, 0x0003208180000000, 0x000b51c0c0000000,
    0x0006e960a0000000, 0x000b793050000000, 0x0005f5fa28000000,
    0x00007fbd64000000, 0x000b77faa2000000, 0x000f3ebde3000000,
    0x000cd77882800000, 0x00062f7ef3400000, 0x00001e19caa00000,
    0x0009864ce7300000, 0x000fc3e0d0f80000, 0x0007e5f2697c0000,
    0x0002361985860000, 0x000b9a4c12930000, 0x000741e27a788000,
    0x000ba4f1fe3cc000, 0x0007169aed26e000, 0x0003cb8d16a3f000,
    0x0003288228004800, 0x00019dc164002400, 0x000a4360a200a200,
    0x00062432e3004d00, 0x000ad7790280a280, 0x00052f7e3340e1c0,
    0x00029e196aa06820, 0x0008c64cb7303410, 0x000763e2f8f89a08,
    0x000275f30d7c611c, 0x0000be1927860496, 0x0000164ef1931e93,
    0x0008000000000000, 0x0004000000000000, 0x000e000000000000,
    0x0001000000000000, 0x0004800000000000, 0x000dc00000000000,
    0x0009200000000000, 0x0005300000000000, 0x0006c80000000000,
    0x00085c0000000000, 0x0003660000000000, 0x000e550000000000,
    0x000c9f8000000000, 0x000ac6c000000000, 0x0008a6a000000000,
    0x0002757000000000, 0x00032e8800000000, 0x0000cfbc00000000,
    0x000d5faa00000000, 0x0009e00d00000000, 0x0002918180000000,
    0x00013fc140000000, 0x00023722a0000000, 0x00074ab330000000,
    0x000f19ab68000000, 0x0006850e3c000000, 0x0006c601fa000000,
    0x0002a5025b000000, 0x000d7782eb800000, 0x0006aac1c2400000,
    0x000988a2de600000, 0x0009bc7254f00000, 0x0005f70b46480000,
    0x00016c7f60ec0000, 0x000fae89500a0000, 0x00090fbfb9b30000,
    0x000a7faac5c88000, 0x000dd00c9eac4000, 0x0000d980746ae000,
    0x0004a3c2b6431000, 0x00087122e800c800, 0x000c2fb37c009c00,
    0x00054e295a007200, 0x00041fcc6b004300, 0x000d06a003802480,
    0x000e8572be4059c0, 0x0002c68b8460a460, 0x000ca3be3ff0b650,
    0x000c71ab45c8a578, 0x0002290ddeac29ac, 0x00044802d46abc0a,
    0x00009c018643c207, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x000d000000000000, 0x0009800000000000,
    0x0006c00000000000, 0x0002e00000000000, 0x0007100000000000,
    0x0007c80000000000, 0x000ebc0000000000, 0x000d220000000000,
    0x0006750000000000, 0x000d1d8000000000, 0x000f164000000000,
    0x000bc9a000000000, 0x0008bd1000000000, 0x0000267800000000,
    0x000ff1ac00000000, 0x000bda5a00000000, 0x000df6ff00000000,
    0x000cdf8380000000, 0x000f734040000000, 0x000e9c23e0000000,
    0x0002d752f0000000, 0x000daddad8000000, 0x0000e9bc74000000,
    0x0003c9a34a000000, 0x0004bd116b000000, 0x0006267b3a800000,
    0x0002f1ad72400000, 0x00025a586fe00000, 0x000b36fce8d00000,
    0x000e3f828d080000, 0x000863406ed40000, 0x00095420e9f60000,
    0x000c6b508c2f0000, 0x00008fdb6f888000, 0x00069cbd6894c000,
    0x000ed421cc166000, 0x000bab520fffd000, 0x000defd958001800,
    0x000a4cbc3400ac00, 0x00027c20aa004e00, 0x0004c7539b00a100,
    0x0005e5d9e280e480, 0x000595bd064087c0, 0x00058ba125e0fc20,
    0x0003181283d01650, 0x000e13fa3788ad58, 0x00044bed5c941aa4,
    0x000379fb66166eba, 0x000b42ee94ffec81, 0x0008000000000000,
    0x000c000000000000, 0x000a000000000000, 0x0003000000000000,
    0x000b800000000000, 0x000ac00000000000, 0x0000600000000000,
    0x000fd00000000000, 0x000ef80000000000, 0x000f8c0000000000,
    0x0008c20000000000, 0x000f630000000000, 0x000e548000000000,
    0x00073c4000000000, 0x00046ca000000000, 0x000dd75000000000,
    0x0001fcd800000000, 0x000e081400000000, 0x000106fa00000000,
    0x0004800700000000, 0x000b420080000000, 0x0009a303c0000000,
    0x0004348060000000, 0x000bec4270000000, 0x000114a2f8000000,
    0x00089b5144000000, 0x00095edba6000000, 0x000ebb1417000000,
    0x0001aa7b8e800000, 0x000c30473bc00000, 0x0007eca125a00000,
    0x000b1751d7d00000, 0x000b9cdaee080000, 0x0002d814cac40000,
    0x00047ef99c1e0000, 0x0001cc06b3d10000, 0x0003e00318888000,
    0x000910017504c000, 0x000498037fbea000, 0x00035c0103013000,
    0x000dba0080003800, 0x000a2f03c0006c00, 0x0006f6806000a600,
    0x00078f427000cd00, 0x0004c022f8005780, 0x00056711440054c0,
    0x000d527ba6008a20, 0x000cbc4417000b30, 0x000eaea38e800ac8,
    0x000db4533bc08b04, 0x000e285b25a0caea, 0x0000f456d7d02b45,
    0x0008000000000000, 0x0004000000000000, 0x000a000000000000,
    0x0005000000000000, 0x0005800000000000, 0x0001400000000000,
    0x0005a00000000000, 0x0007500000000000, 0x0006c80000000000,
    0x00087c0000000000, 0x000dc60000000000, 0x000f670000000000,
    0x000cb78000000000, 0x0004b84000000000, 0x000d266000000000,
    0x0007907000000000, 0x00082c7800000000, 0x000f8e4c00000000,
    0x0009db9a00000000, 0x0000917d00000000, 0x000cae0080000000,
    0x00014b0040000000, 0x00083983e0000000, 0x0007e34110000000,
    0x000c77e008000000, 0x000a5f3184000000, 0x000ad598da000000,
    0x00038a7fcb000000, 0x0007df80c3800000, 0x000f9440c6c00000,
    0x000c2862dc600000, 0x00058b73b7d00000, 0x000cddf904780000,
    0x0005110c9a0c0000, 0x000dea7a2a860000, 0x0004e94ed38f0000,
    0x000f6c194ff88000, 0x0001293d98cc4000, 0x00040863cce6a000,
    0x00079b73bf5f5000, 0x0005b5f88000d800, 0x000f3d0c40005400,
    0x00036479e000fa00, 0x0002b24c10002500, 0x000bbd9888003480,
    0x000da67dc40093c0, 0x000351813a008660, 0x000ccf43db008370,
    0x000d79e04b80a7f8, 0x0008443102c0cc44, 0x000e2419e6600e06,
    0x0009153d6cd08f77, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x0007000000000000, 0x000e800000000000,
    0x0009400000000000, 0x0004200000000000, 0x0007b00000000000,
    0x0004980000000000, 0x0003cc0000000000, 0x0009020000000000,
    0x0005850000000000, 0x0001c08000000000, 0x000a64c000000000,
    0x000d13e000000000, 0x000a6eb000000000, 0x000375c800000000,
    0x000d7f9400000000, 0x00081caa00000000, 0x00078ce700000000,
    0x0002a00380000000, 0x0002f002c0000000, 0x0006b80220000000,
    0x00037c0390000000, 0x00031a02a8000000, 0x000f0903bc000000,
    0x000ce2802e000000, 0x000851c11f000000, 0x00084b6366800000,
    0x0003c67192400000, 0x0007642a30a00000, 0x00029427f8700000,
    0x000aa9e134d80000, 0x000097b3029c0000, 0x0007af4a198a0000,
    0x000f125404490000, 0x00076dcb7a588000, 0x000cf397ecdcc000,
    0x000dbea8272a6000, 0x000bf9e673397000, 0x000d588000006800,
    0x0005a8c000005400, 0x000211e000002200, 0x0008ebb000000b00,
    0x000c35480000a180, 0x000e5b540000a8c0, 0x00012f4a0000d220,
    0x000a525700002350, 0x00054dcb80005588, 0x000c4396c0009a8c,
    0x0007a6a82000411e, 0x000175e49000febb, 0x0008000000000000,
    0x000c000000000000, 0x0002000000000000, 0x000f000000000000,
    0x0002800000000000, 0x0001400000000000, 0x0004a00000000000,
    0x000e300000000000, 0x0006f80000000000, 0x00072c0000000000,
    0x0007020000000000, 0x000e830000000000, 0x0003408000000000,
    0x000ba3c000000000, 0x000cb0a000000000, 0x0007b85000000000,
    0x00038d2800000000, 0x0009318c00000000, 0x00087abe00000000,
    0x00046d4b00000000, 0x000ca00080000000, 0x00023000c0000000,
    0x0004f80020000000, 0x00082c00f0000000, 0x0005820028000000,
    0x000fc30014000000, 0x0007e0804a000000, 0x000593c0e3000000,
    0x000a48a06f800000, 0x0000945072c00000, 0x00048f2870200000,
    0x0007b28ce8300000, 0x000b3a3e34080000, 0x000fce8bba3c0000,
    0x000010a04b0a0000, 0x00058850bb850000, 0x0007752818d28000,
    0x00011d8c6318c000, 0x000df8beafabe000, 0x000bae4b52d4b000,
    0x000b408000000800, 0x0007a3c000000c00, 0x000eb0a000000200,
    0x0008b85000000f00, 0x00010d2800000280, 0x0008718c00000140,
    0x000cdabe000004a0, 0x000a5d4b00000e30, 0x000a5800800006f8,
    0x00051c00c000072c, 0x0003fa0020000702, 0x0006af00f0000e83,
    0x0008000000000000, 0x0004000000000000, 0x000e000000000000,
    0x0005000000000000, 0x0002800000000000, 0x0009c00000000000,
    0x0007e00000000000, 0x000ff00000000000, 0x0004380000000000,
    0x00079c0000000000, 0x000b820000000000, 0x0001410000000000,
    0x0005238000000000, 0x000f914000000000, 0x000088a000000000,
    0x000d867000000000, 0x00040ff800000000, 0x000108fc00000000,
    0x0007c78e00000000, 0x0006ad2700000000, 0x0005d80080000000,
    0x00096c0040000000, 0x00033a00e0000000, 0x000a1d0050000000,
    0x000bc18028000000, 0x0008e0409c000000, 0x000673207e000000,
    0x000a7b30ff000000, 0x000b3d5843800000, 0x000a538c79c00000,
    0x000d69f6b8200000, 0x0009759b14100000, 0x0007b4aed2380000,
    0x000dd617b9140000, 0x00026558688a0000, 0x000fff8cc8670000,
    0x000b33f688ff8000, 0x0005589bdc8fc000, 0x000fad2eaa78e000,
    0x000d5a5749d27000, 0x000bac7800000800, 0x000359bc00000400,
    0x000eaf2e00000e00, 0x0001db5700000500, 0x00076ff880000280,
    0x000638fc400009c0, 0x00089f8ee00007e0, 0x0002012750000ff0,
    0x000f0200a8000438, 0x00098100dc00079c, 0x000e43809e000b82,
    0x000ca140af000141, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x0007000000000000, 0x0004800000000000,
    0x0001c00000000000, 0x000ae00000000000, 0x000f900000000000,
    0x0006c80000000000, 0x00095c0000000000, 0x0007c20000000000,
    0x0003e30000000000, 0x000e108000000000, 0x000489c000000000,
    0x0006fd2000000000, 0x0003727000000000, 0x000059b800000000,
    0x000e176400000000, 0x000cde7200000000, 0x000b827700000000,
    0x0009420080000000, 0x00092300c0000000, 0x0002708020000000,
    0x000dd9c070000000, 0x000e552048000000, 0x00047e701c000000,
    0x000bb3b8ae000000, 0x000b3864f9000000, 0x0003c4f26c800000,
    0x0005b4b795c00000, 0x00066da0fc200000, 0x000d3bb0fe300000,
    0x000ac498c1080000, 0x00043514389c0000, 0x00042fca27d20000,
    0x000299132b270000, 0x000e76722b9b8000, 0x00078e77d8764000,
    0x0004280001672000, 0x000acc009de77000, 0x00030a0080000800,
    0x000dbf00c0000c00, 0x000d528020000200, 0x0006aac070000700,
    0x00020da048000480, 0x00086bb01c0001c0, 0x00006c98ae000ae0,
    0x00043914f9000f90, 0x000b45ca6c8006c8, 0x0006761395c0095c,
    0x000b8cf2fc2007c2, 0x000628b7fe3003e3, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x000d000000000000,
    0x0004800000000000, 0x000bc00000000000, 0x0000e00000000000,
    0x000e100000000000, 0x000b580000000000, 0x0003dc0000000000,
    0x0008c20000000000, 0x000d610000000000, 0x0007518000000000,
    0x000d7b4000000000, 0x0009ad2000000000, 0x000648f000000000,
    0x0005053800000000, 0x00025c0400000000, 0x0003829600000000,
    0x0000415700000000, 0x0004a20080000000, 0x000cb10040000000,
    0x000ae98060000000, 0x000db740d0000000, 0x000eb72048000000,
    0x000335f0bc000000, 0x000a76b80e000000, 0x000c5644e1000000,
    0x00062636b5800000, 0x0008aee73dc00000, 0x0000c8180c200000,
    0x0005c4f496100000, 0x000b3fae15180000, 0x0002d15307b40000,
    0x00003a9652d20000, 0x00098d57988f0000, 0x00013800be538000,
    0x000f0c0054c04000, 0x0001fa00a5a96000, 0x00066d0055d57000,
    0x0000ab8080000800, 0x0006164040000400, 0x000d86a060000600,
    0x000b9eb0d0000d00, 0x0008639848000480, 0x0007d2b4bc000bc0,
    0x0000b90e0e0000e0, 0x00044fe3e1000e10, 0x000cd90e35800b58,
    0x00059fe37dc003dc, 0x0001610e6c2008c2, 0x000553e346100d61,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x000d000000000000, 0x0009800000000000, 0x0003400000000000,
    0x0001200000000000, 0x0004300000000000, 0x0000480000000000,
    0x000b840000000000, 0x0004620000000000, 0x0004130000000000,
    0x0003fb8000000000, 0x00058f4000000000, 0x0007446000000000,
    0x000701d000000000, 0x000680c800000000, 0x0009c1cc00000000,
    0x0006e13200000000, 0x000fd05100000000, 0x0006198080000000,
    0x000edc40c0000000, 0x000b9fe0e0000000, 0x000bbe90d0000000,
    0x00080ca898000000, 0x0006041c34000000, 0x000523fa12000000,
    0x0006329d43000000, 0x00034b3284800000, 0x000f075178400000,
    0x000ea00026200000, 0x0006700051300000, 0x0006e80047b80000,
    0x0001f400bcf40000, 0x000c8a00fe460000, 0x0008e700071d0000,
    0x0006f1807e8c8000, 0x000e2840675cc000, 0x000095e02cb32000,
    0x000d199004751000, 0x00065d2818000800, 0x000f5c5cf4000c00,
    0x0004de1af2000e00, 0x00049f0d93000d00, 0x00013c1a1c800980,
    0x000fcc0d4c400340, 0x000de79a34200120, 0x0003734d12300430,
    0x00036bfac3380048, 0x000cb69dc4b40b84, 0x0000a932d8660462,
    0x00055451562d0413, 0x0008000000000000, 0x000c000000000000,
    0x000a000000000000, 0x0005000000000000, 0x0009800000000000,
    0x000ec00000000000, 0x0000e00000000000, 0x0002900000000000,
    0x0009f80000000000, 0x000a940000000000, 0x0005220000000000,
    0x0008f30000000000, 0x00032a8000000000, 0x0001cd4000000000,
    0x000a846000000000, 0x00089ab000000000, 0x000ac5b800000000,
    0x0006396400000000, 0x0005f65e00000000, 0x000673f500000000,
    0x000d688080000000, 0x000c6e40c0000000, 0x000336e0a0000000,
    0x000a93f050000000, 0x0005fbd898000000, 0x000094d4ec000000,
    0x000023660e000000, 0x000170d129000000, 0x000dea3e1f800000,
    0x00012d4569400000, 0x0008173872200000, 0x000160241f300000,
    0x0000503e0aa80000, 0x00031a45a0d40000, 0x000d07b8be460000,
    0x00055a648cab0000, 0x000ca4de9ddb8000, 0x0006eab5b3d64000,
    0x000baee08ac5e000, 0x000057f06d4f5000, 0x0003c1d818000800,
    0x000563d42c000c00, 0x000653e6ae000a00, 0x000c1a9179000500,
    0x000186de87800980, 0x000219b585400ec0, 0x000284607c2000e0,
    0x00049ab036300290, 0x0000c5b8952809f8, 0x0003396409940a94,
    0x000c765e6c660522, 0x0008b3f5c39b08f3, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x0003000000000000,
    0x000f800000000000, 0x000fc00000000000, 0x0001e00000000000,
    0x0002b00000000000, 0x0006780000000000, 0x000c540000000000,
    0x000ab20000000000, 0x0002790000000000, 0x0006568000000000,
    0x0009b2c000000000, 0x000dfae000000000, 0x0009957000000000,
    0x000852b800000000, 0x000f4a4c00000000, 0x000fecee00000000,
    0x000405ad00000000, 0x0005fae080000000, 0x000d957040000000,
    0x000252b8a0000000, 0x000c4a4c30000000, 0x00006ceef8000000,
    0x000bc5adfc000000, 0x00041ae09e000000, 0x000f25706b000000,
    0x00042ab8c7800000, 0x00001e4cf5400000, 0x000adeee53200000,
    0x0009bcaddb900000, 0x00024c60fb680000, 0x000697b0f02c0000,
    0x0009d058182e0000, 0x00098b3c6c170000, 0x00028c56d60b8000,
    0x0006f6e12f34c000, 0x000da08e05a6e000, 0x0002921db076d000,
    0x000c2ab8c7800800, 0x00041e4cf5400400, 0x0000deee53200a00,
    0x000abcaddb900300, 0x000dcc60fb680f80, 0x000957b0f02c0fc0,
    0x00083058182e01e0, 0x000b3b3c6c1702b0, 0x0004f456d60b8678,
    0x000aa2e12f34cc54, 0x0007128e05a6eab2, 0x0000eb1db076d279,
    0x0008000000000000, 0x0004000000000000, 0x000e000000000000,
    0x0009000000000000, 0x0006800000000000, 0x0009c00000000000,
    0x0000600000000000, 0x0002f00000000000, 0x000f880000000000,
    0x0002a40000000000, 0x0007f20000000000, 0x0003090000000000,
    0x000c678000000000, 0x0008104000000000, 0x000eb8a000000000,
    0x000a4df000000000, 0x0008245800000000, 0x0004321c00000000,
    0x00046b1200000000, 0x0001157100000000, 0x0008d8a080000000,
    0x0005bdf040000000, 0x000f2c58e0000000, 0x0006561c90000000,
    0x0005791268000000, 0x00092c719c000000, 0x000b572086000000,
    0x000df9b06f000000, 0x0009eef818800000, 0x000db6ecba400000,
    0x0006c8ca17200000, 0x0006072dac900000, 0x000de31240780000,
    0x000eb171ee040000, 0x0007aaa0730a0000, 0x000674f05e9f0000,
    0x0005abd875658000, 0x0005765c7fb1c000, 0x000429b2eec92000,
    0x0003358123531000, 0x000b097818800800, 0x000866acba400400,
    0x0006106a17200e00, 0x0007baddac900900, 0x000ccf4a40780680,
    0x0001e76dee0409c0, 0x000453b2730a0060, 0x000698815e9f02f0,
    0x000e9cf8f5658f88, 0x000a7fec3fb1c2a4, 0x00024f4a0ec927f2,
    0x000c276db3531309, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x0007000000000000, 0x000a800000000000,
    0x0004400000000000, 0x000c200000000000, 0x0001300000000000,
    0x000cf80000000000, 0x000e240000000000, 0x0007120000000000,
    0x0006cb0000000000, 0x000a5c8000000000, 0x000a77c000000000,
    0x00077ba000000000, 0x0009e69000000000, 0x0000f04800000000,
    0x0002182c00000000, 0x0005740e00000000, 0x0001fa5100000000,
    0x000fa72080000000, 0x000bd150c0000000, 0x0009abe820000000,
    0x000dcebc70000000, 0x0003fc46a8000000, 0x0009867d44000000,
    0x0001e12e42000000, 0x000dd001d3000000, 0x0000a8486f800000,
    0x00024c2c52400000, 0x000a3e0ef9200000, 0x000b655158b00000,
    0x0008b1a04fc80000, 0x000c3990307c0000, 0x000346c85a3a0000,
    0x000780ec1f290000, 0x0005c12e19a48000, 0x0000e001eb72c000,
    0x000e5048c1a8e000, 0x000b682c07691000, 0x0007ac0ec7800800,
    0x0009ee5116400c00, 0x000ecd20bb200200, 0x00077e508bb00700,
    0x0008c56820480a80, 0x0000427c623c0440, 0x00022366a31a0c20,
    0x0004332d47990130, 0x000178c6566c8cf8, 0x0000e5bddb0ece24,
    0x000f708e9b92e712, 0x000bd991184016cb, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x0001000000000000,
    0x0001800000000000, 0x0007c00000000000, 0x0008e00000000000,
    0x0006f00000000000, 0x0005280000000000, 0x0001fc0000000000,
    0x0005920000000000, 0x00071b0000000000, 0x0002b78000000000,
    0x0005de4000000000, 0x0009016000000000, 0x000d817000000000,
    0x0009c1f800000000, 0x0009e19c00000000, 0x000770da00000000,
    0x0002ebb700000000, 0x00091ee080000000, 0x00036330c0000000,
    0x00023298e0000000, 0x00034bec10000000, 0x00004ea218000000,
    0x000e186b7c000000, 0x000f355a0e000000, 0x000c1ef7af000000,
    0x0000e00032800000, 0x000af000cfc00000, 0x000b2800a1200000,
    0x0000fc001db00000, 0x00041200bd780000, 0x0000db004ee40000,
    0x000a57804c960000, 0x00032e40a8d70000, 0x000c296097bf8000,
    0x000c7d70f069c000, 0x000c53f80555a000, 0x000efa9c02ef7000,
    0x0005c75a2a800800, 0x000735f7b3c00c00, 0x00001f80af200e00,
    0x000ee240b2b00100, 0x000bf3600ff80180, 0x000aaa70412407c0,
    0x00073e780db608e0, 0x000cf3dca56706f0, 0x00062bba32c78528,
    0x000f7dc7c28dc1fc, 0x0002d29847c3a592, 0x0009bbec0538771b,
    0x0008000000000000, 0x0004000000000000, 0x000a000000000000,
    0x000b000000000000, 0x0000800000000000, 0x000f400000000000,
    0x000a600000000000, 0x0007700000000000, 0x0006580000000000,
    0x000d3c0000000000, 0x0004520000000000, 0x000e490000000000,
    0x000d968000000000, 0x000bf4c000000000, 0x0002872000000000,
    0x0005de5000000000, 0x000361d800000000, 0x0008f0bc00000000,
    0x00039a2600000000, 0x00031ce700000000, 0x0009c3a080000000,
    0x0000239040000000, 0x000c9078a0000000, 0x0005ea2cb0000000,
    0x000ec4de08000000, 0x000b3e0bf4000000, 0x0001525e26000000,
    0x000fcacb37000000, 0x0009557e45800000, 0x000e549b23c00000,
    0x0000d4a66d200000, 0x000e9427e0900000, 0x000f768057680000,
    0x0007c4c0cc4c0000, 0x0004bf2043f20000, 0x00049250bd250000,
    0x0001ebd8b8bd8000, 0x0004c5bc3b5bc000, 0x00003ea6666a6000,
    0x0001d127ced27000, 0x00008a00cd800800, 0x0003350097c00400,
    0x00092480eb200a00, 0x00068dc067900b00, 0x0003a9a01ae80080,
    0x000b26901b8c0f40, 0x00098cf808d20a60, 0x00092bec6ab50770,
    0x000f677eaa558658, 0x00036d9bd4d7cd3c, 0x00011a2648b86452,
    0x00035ce793677e49, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x000d000000000000, 0x0004800000000000,
    0x000f400000000000, 0x0002600000000000, 0x0006100000000000,
    0x0001780000000000, 0x00008c0000000000, 0x000bb20000000000,
    0x00004b0000000000, 0x000e858000000000, 0x0005d54000000000,
    0x0001cc2000000000, 0x0008d35000000000, 0x0004d95800000000,
    0x000dbe6400000000, 0x0003bbee00000000, 0x00032d4b00000000,
    0x000b83a080000000, 0x000cc110c0000000, 0x0002a2f860000000,
    0x0002b374d0000000, 0x000ecb1648000000, 0x000ac53ff4000000,
    0x000e3536a6000000, 0x000c1d6fa1000000, 0x000489eef7800000,
    0x0000264b18c00000, 0x0001662013200000, 0x00020450e0b00000,
    0x000696d8e6580000, 0x0005ac2418540000, 0x0003c04e65420000,
    0x0001205b10f50000, 0x0002735847358000, 0x000a696476964000,
    0x0005746e1f46e000, 0x00047f0bb3f0b000, 0x000998003f800800,
    0x0008dc002cc00c00, 0x000a2a00d5200600, 0x0004970091b00d00,
    0x0002af80d9d80480, 0x000c424034940f40, 0x0007e3a0b0620260,
    0x000bd11081450610, 0x00015af81eed8178, 0x00007f748202408c,
    0x00039916cf24ebb2, 0x0003de3fe2b5b04b, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x0007000000000000,
    0x0007800000000000, 0x0007400000000000, 0x0007e00000000000,
    0x0005f00000000000, 0x000d080000000000, 0x0007540000000000,
    0x0007d20000000000, 0x0002d90000000000, 0x00018f8000000000,
    0x00085fc000000000, 0x000d86e000000000, 0x000b895000000000,
    0x000496b800000000, 0x000ef0dc00000000, 0x00008bb200000000,
    0x0009179d00000000, 0x0000b36080000000, 0x0007eb9040000000,
    0x000c25d8e0000000, 0x000d1b4c70000000, 0x0002ae6a78000000,
    0x00030cd174000000, 0x00059d0afe000000, 0x0003a7411f000000,
    0x000e58d2b0800000, 0x000b4c0d45400000, 0x0001feb865200000,
    0x000f14dc69900000, 0x0003b1b2fef80000, 0x000e6a9ddefc0000,
    0x000c66e08eee0000, 0x000d7950a6d50000, 0x00001eb87acb8000,
    0x0009e4dc98ddc000, 0x000739b2c5e32000, 0x00097e9d3855d000,
    0x000bd4e048800800, 0x000d105071400400, 0x000b79387b200e00,
    0x00031f1c06900700, 0x00006552b6780780, 0x00077acdafbc0740,
    0x00091fd8f5ce07e0, 0x0009664ca04505f0, 0x0007fbeaccb38d08,
    0x0009de113761c754, 0x0009c66a302d27d2, 0x0005e8d19810d2d9,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x0009000000000000, 0x000c800000000000, 0x0002400000000000,
    0x0008e00000000000, 0x0003900000000000, 0x0006a80000000000,
    0x0006040000000000, 0x0005aa0000000000, 0x000f870000000000,
    0x00096a8000000000, 0x000c254000000000, 0x000e99a000000000,
    0x000b5dd000000000, 0x0006d79800000000, 0x000b633400000000,
    0x000a533200000000, 0x000b8b3500000000, 0x000ab79880000000,
    0x0006b334c0000000, 0x00061b3220000000, 0x00071f3590000000,
    0x0005359848000000, 0x000d7034e4000000, 0x00023bb2ae000000,
    0x00072d75a9000000, 0x00046eb822800000, 0x000c0ca484400000,
    0x000fdf8af4a00000, 0x0008949151700000, 0x00018092b4280000,
    0x0000c1e546140000, 0x0001a2809d3a0000, 0x000ef14024ad0000,
    0x000bfba079518000, 0x000a0ed0a0274000, 0x0008df1850092000,
    0x000f1574e81e5000, 0x00064212b4280800, 0x0006e0a546140c00,
    0x000891209d3a0200, 0x00032b9024ad0900, 0x0008c6b879518c80,
    0x000f08a4a0274240, 0x0004f58a500928e0, 0x000c5391e81e5390,
    0x000c8a1234280ea8, 0x000d34a586140a04, 0x00017320bd3a07aa,
    0x00003890b4ad0687, 0x0008000000000000, 0x000c000000000000,
    0x000a000000000000, 0x000d000000000000, 0x000f800000000000,
    0x000bc00000000000, 0x000ca00000000000, 0x0003900000000000,
    0x0001380000000000, 0x0005540000000000, 0x000bba0000000000,
    0x000d170000000000, 0x0006d88000000000, 0x000f244000000000,
    0x000bf36000000000, 0x00008ab000000000, 0x0009be4800000000,
    0x0005b75400000000, 0x0003498600000000, 0x00091ec100000000,
    0x000c264880000000, 0x000f7354c0000000, 0x0003cb86a0000000,
    0x000c5dc1d0000000, 0x000ec4c878000000, 0x000680147c000000,
    0x000240666a000000, 0x00006331e9000000, 0x000db1e06b800000,
    0x0006e9f029400000, 0x00030da8d1a00000, 0x0001dda438700000,
    0x000406ae86080000, 0x000fa0251b040000, 0x000713064e960000,
    0x0002798120db0000, 0x0000b7a8c5ec8000, 0x0000caa4ec714000,
    0x0008de2e680e6000, 0x000d846524371000, 0x0003606686080800,
    0x000933311b040c00, 0x0005a9e04e960a00, 0x0006edf020db0d00,
    0x000aafa845ec8f80, 0x0001cea42c714bc0, 0x0004fc2ec80e6ca0,
    0x000b5765f4371390, 0x0000bae67e080938, 0x00059471a7040954,
    0x000f9800849601ba, 0x0007c40019db0017, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x0003000000000000,
    0x000f800000000000, 0x000e400000000000, 0x000fa00000000000,
    0x000ad00000000000, 0x000b680000000000, 0x00089c0000000000,
    0x00092a0000000000, 0x00053d0000000000, 0x0006fb8000000000,
    0x0002d5c000000000, 0x000fa46000000000, 0x000a1c5000000000,
    0x000fea8800000000, 0x000d5d6400000000, 0x000ec99200000000,
    0x00034d2300000000, 0x0008c08880000000, 0x000f606440000000,
    0x0001b21260000000, 0x000cd8e330000000, 0x000744e878000000,
    0x0001ec34a4000000, 0x000a909a9a000000, 0x0003c9879d000000,
    0x000bcf7ace800000, 0x000f00172dc00000, 0x000d819288a00000,
    0x000b41238ed00000, 0x00032288c1380000, 0x000b1164309c0000,
    0x000a8b920ae60000, 0x000dec238b150000, 0x00089108a5908000,
    0x0006c8a4784a4000, 0x00074df2a8ff2000, 0x000ec173d2073000,
    0x000c620041380800, 0x000e3100709c0400, 0x000299806ae60600,
    0x0008e4c0bb150300, 0x000b3de0dd908f80, 0x0001f890dc4a4e40,
    0x000b576832ff2fa0, 0x0002e5f44f073ad0, 0x000a3efa8fb80368,
    0x000b78d75d5c0c9c, 0x00099672e2460f2a, 0x000c84b335c5063d,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x0001000000000000, 0x0006800000000000, 0x000e400000000000,
    0x0008600000000000, 0x0009d00000000000, 0x000e180000000000,
    0x000b0c0000000000, 0x000eda0000000000, 0x00012f0000000000,
    0x0001698000000000, 0x0007e74000000000, 0x0002fc2000000000,
    0x000c72d000000000, 0x00056b3800000000, 0x0005e62400000000,
    0x000dfe7e00000000, 0x000bf38700000000, 0x000da93880000000,
    0x0003c524c0000000, 0x000c4dfee0000000, 0x000c3bc710000000,
    0x0008bc98e8000000, 0x000610b424000000, 0x0003bae666000000,
    0x000c7f338d000000, 0x000e31de09800000, 0x0003091794c00000,
    0x000d37a00ba00000, 0x000566905ff00000, 0x000ebc987f180000,
    0x000b10b43ab40000, 0x000b3ae62c620000, 0x00033f33acdd0000,
    0x0000d1dea7ab8000, 0x00049917cdd64000, 0x000b4fa09c05e000,
    0x0007ba900a257000, 0x000e7e98ff180800, 0x000133b4fab40c00,
    0x00048966cc620e00, 0x0005f773bcdd0100, 0x0003447ecfab8680,
    0x000f0c8729d64e40, 0x000cd8b81a05e860, 0x000e2e64972579d0,
    0x0006ebde1e980618, 0x000f26174a74070c, 0x0004de20a1c200da,
    0x000dc1d06e2d002f, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x0007000000000000, 0x000a800000000000,
    0x0003400000000000, 0x000d200000000000, 0x0005900000000000,
    0x000d680000000000, 0x000f140000000000, 0x0009aa0000000000,
    0x0008f50000000000, 0x000ada8000000000, 0x00096cc000000000,
    0x000a942000000000, 0x00046a1000000000, 0x0004946800000000,
    0x00056af400000000, 0x000b167200000000, 0x000baa5100000000,
    0x000ff66880000000, 0x00005bf440000000, 0x000a2ef220000000,
    0x0007b79170000000, 0x0001fac828000000, 0x0009fc2474000000,
    0x000a7e3af2000000, 0x0002beb529000000, 0x00035e72fe800000,
    0x00052e5185400000, 0x00093468e8a00000, 0x0000baf4e6500000,
    0x0003de72f3280000, 0x00056e51238c0000, 0x000c9468c9e20000,
    0x00016af4e4f10000, 0x00091672c06e8000, 0x000caa5118234000,
    0x000576687c052000, 0x00031bf4f6141000, 0x00070ef273280800,
    0x00022791638c0400, 0x000c92c8e9e20200, 0x0006e82494f10700,
    0x0003d43a686e8a80, 0x000a4bb52c234340, 0x000984f2ae052d20,
    0x000c4291af141590, 0x0003a04825a80568, 0x0004d0e4d2cc0b14,
    0x00074a1ad3420baa, 0x000004a52ba10ff5, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x0009000000000000,
    0x0008800000000000, 0x000cc00000000000, 0x0005a00000000000,
    0x0007700000000000, 0x0004e80000000000, 0x0002340000000000,
    0x000d4a0000000000, 0x000b450000000000, 0x000aa08000000000,
    0x0008f34000000000, 0x0003a8a000000000, 0x000ad57000000000,
    0x000bd94800000000, 0x0001bfec00000000, 0x000eacd200000000,
    0x0004141100000000, 0x000379c880000000, 0x00044cac40000000,
    0x000f8472a0000000, 0x000b016190000000, 0x0005808008000000,
    0x000e43408c000000, 0x000060a0fa000000, 0x000a5170e7000000,
    0x000f5b48c6800000, 0x00037eecef400000, 0x00080e528ea00000,
    0x0002e651c3500000, 0x0003d3e864880000, 0x000f1b9cec740000,
    0x00001f1a4e2a0000, 0x0003ddbd89070000, 0x0009fd3a1f9c8000,
    0x0009ce8d18cac000, 0x0005c452aa472000, 0x000163514b161000,
    0x0006d3686c880800, 0x000998dc60740400, 0x000fdfbab42a0a00,
    0x0007fccd6e070900, 0x000ace72d91c8880, 0x00044461f78accc0,
    0x0005200024e725a0, 0x000fb00088461770, 0x000b480008000ce8,
    0x000c44008c000634, 0x00012200fa00074a, 0x0005b100e7000245,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x0007000000000000, 0x0006800000000000, 0x000b400000000000,
    0x000b600000000000, 0x0000900000000000, 0x0004080000000000,
    0x000b940000000000, 0x0003ea0000000000, 0x0005470000000000,
    0x0003018000000000, 0x000482c000000000, 0x0002422000000000,
    0x000ae31000000000, 0x000d537800000000, 0x00042af400000000,
    0x000067da00000000, 0x000770c100000000, 0x000adaf880000000,
    0x000b7c34c0000000, 0x00022ffae0000000, 0x000404d170000000,
    0x000d6000e8000000, 0x000b900074000000, 0x000c880056000000,
    0x0007d40079000000, 0x000e0a0028800000, 0x000e97000d400000,
    0x000c698088a00000, 0x000f86c05d700000, 0x0005a02070980000,
    0x00043010f16c0000, 0x000db8f81a820000, 0x0005ef34fa410000,
    0x0001247ae52f8000, 0x000911110a834000, 0x0005cba0a25fa000,
    0x0005b5d0193d1000, 0x000f1b5898980800, 0x00075ee4856c0c00,
    0x0007dd224c820e00, 0x00079cf583410700, 0x00047d024daf8680,
    0x0008ace5c7c34b40, 0x000145facaffab60, 0x000103d1344d1090,
    0x000d818000000c08, 0x0003c2c000000794, 0x0007222000000dea,
    0x000d731000000247, 0x0008000000000000, 0x000c000000000000,
    0x000e000000000000, 0x0001000000000000, 0x000b800000000000,
    0x000e400000000000, 0x0008600000000000, 0x0008d00000000000,
    0x0004b80000000000, 0x0008ec0000000000, 0x00079a0000000000,
    0x0001df0000000000, 0x000ab18000000000, 0x000f6b4000000000,
    0x0008d56000000000, 0x000bb5d000000000, 0x000be5f800000000,
    0x00059f2400000000, 0x0001d1f600000000, 0x00033a2f00000000,
    0x0008ae7880000000, 0x000efb64c0000000, 0x00028d16e0000000,
    0x000048bf10000000, 0x000fe4e038000000, 0x00079e9024000000,
    0x000ed09866000000, 0x0009baf49d000000, 0x000d6c0ef3800000,
    0x0008d90b6ac00000, 0x00023d8e7fa00000, 0x000c224b50f00000,
    0x0003b0ee80980000, 0x0008eb9ba8740000, 0x000897162cf60000,
    0x0002d7bf92ad0000, 0x0008b5604b478000, 0x000f65d016464000,
    0x00015df805c96000, 0x000c73247f3ff000, 0x000dcbf638980800,
    0x000ca52f4c740c00, 0x000a7ff8aaf60e00, 0x000940241fad0100,
    0x000ee07680c78b80, 0x0003116f58864e40, 0x00039b181c696860,
    0x0003deb4b2cff8d0, 0x0005b0eecb800cb8, 0x0005eb9b4ec004ec,
    0x000d171619a0099a, 0x000d97bfcdf000df, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x000b000000000000,
    0x0008800000000000, 0x000bc00000000000, 0x000ba00000000000,
    0x0006b00000000000, 0x000bb80000000000, 0x0002740000000000,
    0x00030a0000000000, 0x0006cd0000000000, 0x000fff8000000000,
    0x000505c000000000, 0x000a10a000000000, 0x000788b000000000,
    0x000f0f8800000000, 0x00095dbc00000000, 0x000037d600000000,
    0x0002eba900000000, 0x00059f2880000000, 0x0001150c40000000,
    0x0002985e60000000, 0x00060615b0000000, 0x000690fe08000000,
    0x000a4aa5fc000000, 0x000fad765a000000, 0x00076e199b000000,
    0x00004f20d3800000, 0x000b3d706b400000, 0x0000272862a00000,
    0x000c610c0bd00000, 0x000f125e76780000, 0x00000b15a01c0000,
    0x000a4f7e102a0000, 0x00023f65181b0000, 0x0005a5d664208000,
    0x000422a97e17c000, 0x0007f2a8052f6000, 0x0006d9cc26bd9000,
    0x000ce57ea5f80800, 0x000d4265cb5c0400, 0x000f6256728a0600,
    0x0003936913cb0b00, 0x000dc80812588880, 0x000aec7cde0bcbc0,
    0x000c0d7615056ba0, 0x0005de193ea696b0, 0x000df720c1d883b8,
    0x00024970b54bc674, 0x000bad2877a5650a, 0x00016c0c35769dcd,
    0x0008000000000000, 0x000c000000000000, 0x0006000000000000,
    0x0005000000000000, 0x0005800000000000, 0x0005400000000000,
    0x0005600000000000, 0x0003300000000000, 0x0005480000000000,
    0x000e4c0000000000, 0x00017a0000000000, 0x0001870000000000,
    0x000cf78000000000, 0x00005c4000000000, 0x000be1e000000000,
    0x000af29000000000, 0x0006e8f800000000, 0x00085dbc00000000,
    0x0007e23a00000000, 0x000cf05700000000, 0x0003e91880000000,
    0x000ddf2cc0000000, 0x0002a2c260000000, 0x000991eb50000000,
    0x0000d922d8000000, 0x0008947b94000000, 0x000cee5ab6000000,
    0x0008e987a3000000, 0x00015f80ec800000, 0x0004604020c00000,
    0x000cb3e079a00000, 0x000309902f700000, 0x000bad7895f80000,
    0x00028afc86040000, 0x0004ee5aab3e0000, 0x0004e98760990000,
    0x00075f8062d78000, 0x00016040bcafc000, 0x000933e078e5a000,
    0x000649902d987000, 0x000ecd7879780800, 0x0001bafca6c40c00,
    0x0001a65ad29e0600, 0x000aa5874fe90500, 0x00062580f72f8580,
    0x0000e7403aabc540, 0x0005c460d3dba560, 0x000615d04d017330,
    0x00052c989baf8d48, 0x000b486cda6bc24c, 0x00074ea2ca7ba77a,
    0x0002f83b32717487, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x0003000000000000, 0x0007800000000000,
    0x000dc00000000000, 0x000ca00000000000, 0x0004300000000000,
    0x000e380000000000, 0x0009c40000000000, 0x000b8a0000000000,
    0x00073d0000000000, 0x00006c8000000000, 0x0001c7c000000000,
    0x000f886000000000, 0x000d3c3000000000, 0x00036e8800000000,
    0x0006445c00000000, 0x00024bb600000000, 0x00019c6500000000,
    0x00075ee880000000, 0x00087c6c40000000, 0x000b8f3ea0000000,
    0x000a153930000000, 0x000061def8000000, 0x000813c99c000000,
    0x000a4bb6ea000000, 0x00059c6533000000, 0x000d5ee8bb800000,
    0x000b7c6c30400000, 0x000c0f3eaaa00000, 0x0007d539dcd00000,
    0x000cc1ded7480000, 0x000c23c95f3c0000, 0x000473b649a60000,
    0x000c58650f530000, 0x0006d4e833008000, 0x000c416c3ba9c000,
    0x000c63be70556000, 0x000612f90aa95000, 0x000349be6cc80800,
    0x00011ff96f7c0400, 0x00071d3ee3060a00, 0x000a1c39d3830300,
    0x00049f5e64488780, 0x000ddd092495cdc0, 0x000b3d5699f36ca0,
    0x000e6e9535fa5430, 0x0008c680a7c88638, 0x000b0ac0c8d5cdc4,
    0x00077ce07953618a, 0x00020ff0ea2a543d, 0x0008000000000000,
    0x000c000000000000, 0x000a000000000000, 0x0009000000000000,
    0x0000800000000000, 0x0005c00000000000, 0x0003a00000000000,
    0x0002f00000000000, 0x000ac80000000000, 0x00094c0000000000,
    0x0005fa0000000000, 0x000c270000000000, 0x0004448000000000,
    0x000a174000000000, 0x0001afa000000000, 0x000e68b000000000,
    0x00043f0800000000, 0x0009732c00000000, 0x000a8a4a00000000,
    0x0005add700000000, 0x00086aa880000000, 0x00073c9cc0000000,
    0x0000f1c2a0000000, 0x000fc9bb90000000, 0x0003cf4288000000,
    0x000939fb9c000000, 0x000f04621a000000, 0x0003760b7f000000,
    0x00037cca84800000, 0x000a119798c00000, 0x00015b884da00000,
    0x0001546ce1700000, 0x0008cdea7ac80000, 0x000cb967d6b40000,
    0x000047a05bda0000, 0x000c14b0033b0000, 0x0002ad086e988000,
    0x0007e82cdff6c000, 0x00017cca0d36a000, 0x000f119717927000,
    0x000bdb887e480800, 0x000d946c8e740c00, 0x000bedeab67a0a00,
    0x000b8967724b0900, 0x00092fa09c508080, 0x0007a8b09542c5c0,
    0x000d9f084ceca3a0, 0x0002832c6ba972f0, 0x0000c24a945082c8,
    0x000921d7c942c54c, 0x000e30a8f6ecaffa, 0x0009eb9c84a97527,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x0007000000000000, 0x0002800000000000, 0x000c400000000000,
    0x0003a00000000000, 0x0009b00000000000, 0x000a180000000000,
    0x0009340000000000, 0x000a0a0000000000, 0x000f9f0000000000,
    0x0002a58000000000, 0x000560c000000000, 0x000a502000000000,
    0x000e095000000000, 0x000d9d8800000000, 0x000ba7dc00000000,
    0x0000e07e00000000, 0x0004904900000000, 0x0001e82880000000,
    0x00078e4cc0000000, 0x00080dd6e0000000, 0x0003cec570000000,
    0x0007addea8000000, 0x00047dd904000000, 0x000ab7805a000000,
    0x000fcbc02b000000, 0x000cffa069800000, 0x0003f69027400000,
    0x0007e828b2a00000, 0x000c8e4ca6f00000, 0x00048dd6b1d80000,
    0x00088ec55e4c0000, 0x00068dde24220000, 0x00018dd94a250000,
    0x00030f8033208000, 0x000f4fc0a581c000, 0x000ceda0495de000,
    0x00055d904b9d9000, 0x000f47a870580800, 0x0006718c7d0c0c00,
    0x000c7876cc820e00, 0x0003e755c7d50700, 0x00014076eb788280,
    0x00042355dc8dcc40, 0x000e7276dfdfe3a0, 0x00007855a74899b0,
    0x000de5f6f2a08218, 0x0006439586c1c534, 0x0006a256a1fde40a,
    0x00023105c66d989f, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x0007000000000000, 0x0002800000000000,
    0x000a400000000000, 0x000fe00000000000, 0x0003d00000000000,
    0x0008280000000000, 0x000b340000000000, 0x00005a0000000000,
    0x00042f0000000000, 0x0004178000000000, 0x000a28c000000000,
    0x0006362000000000, 0x0003d8d000000000, 0x000bed9800000000,
    0x0003354400000000, 0x000c5ba200000000, 0x00022fe100000000,
    0x0003163880000000, 0x0008aa54c0000000, 0x000c779a60000000,
    0x000c3ab570000000, 0x00083e22a8000000, 0x000b1c2164000000,
    0x00076d981e000000, 0x000275448d000000, 0x00073ba2ca800000,
    0x000cbfe167400000, 0x00065e3853a00000, 0x000a0e541bf00000,
    0x000be59a5df80000, 0x0000f1b55ccc0000, 0x00045ba24c420000,
    0x000e2fe1a83d0000, 0x00051638e4018000, 0x000faa545e284000,
    0x000ef79a2d202000, 0x00067ab5dabf1000, 0x0007de22bf780800,
    0x0008cc219f8c0c00, 0x000f459861e20600, 0x000941444ecd0700,
    0x000761a2db798280, 0x000890e101a44a40, 0x000249b82cc22fe0,
    0x00002694e47213d0, 0x000dd3bacc018028, 0x00032965fa284734,
    0x000fb63a5320265a, 0x000d1aa527bf132f, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x0007000000000000,
    0x0008800000000000, 0x0005c00000000000, 0x000ea00000000000,
    0x0004300000000000, 0x0004080000000000, 0x000fc40000000000,
    0x0009da0000000000, 0x00019f0000000000, 0x0009058000000000,
    0x000df8c000000000, 0x00096ea000000000, 0x000c2d3000000000,
    0x000b4d4800000000, 0x000fdcdc00000000, 0x0008e49a00000000,
    0x000ba83500000000, 0x0008746880000000, 0x000e922cc0000000,
    0x000238f2e0000000, 0x0002ce1970000000, 0x00099e9a08000000,
    0x000507359c000000, 0x0003f9e88a000000, 0x000e6eecf3000000,
    0x0004ac5228800000, 0x000e8c29d0400000, 0x00017e527fa00000,
    0x000cd729c6f00000, 0x000fa1d25ad80000, 0x0007b0e9d0cc0000,
    0x00074af2a3ca0000, 0x0003a519cb630000, 0x000bc91abb2c8000,
    0x000464f594b1c000, 0x000c68c8ca7ba000, 0x000fd41cf49c5000,
    0x0005223afa580800, 0x000b71055c8c0c00, 0x00066b20b66a0e00,
    0x000ad5f08e930700, 0x0004a3e841748880, 0x000131ecc83dc5c0,
    0x000589d27c11aea0, 0x000584e97a0f5430, 0x000a38f23b2c8c08,
    0x000ece1954b1c3c4, 0x00079e9a2a7ba7da, 0x00020735849c569f,
    0x0008000000000000, 0x0004000000000000, 0x0006000000000000,
    0x000d000000000000, 0x0005800000000000, 0x0009c00000000000,
    0x0002a00000000000, 0x000cf00000000000, 0x0003d80000000000,
    0x0004c40000000000, 0x0000ca0000000000, 0x00070d0000000000,
    0x000b478000000000, 0x0006084000000000, 0x000b2de000000000,
    0x0006f6b000000000, 0x000b318800000000, 0x000878ac00000000,
    0x000bb4ee00000000, 0x0007d28500000000, 0x0004e9e880000000,
    0x000ebf5c40000000, 0x00007d0660000000, 0x00085dd9d0000000,
    0x0003eceed8000000, 0x0003d685dc000000, 0x000503e8ca000000,
    0x0001825c5f000000, 0x000fc28605800000, 0x000fa19900400000,
    0x0009730efea00000, 0x000a193563d00000, 0x000667e043f80000,
    0x000c3bb073c40000, 0x0004d608bbfe0000, 0x000f80ec1ffb0000,
    0x0006c10e79c08000, 0x000c2035c4dec000, 0x000db2602a68e000,
    0x000d3af0b1875000, 0x000356681e780800, 0x000d431cef840400,
    0x000ce2e6ef5e0600, 0x000c9269f32b0d00, 0x000508e667b88580,
    0x0007af692b5ac9c0, 0x000cb766c536e2a0, 0x000d532942ac5cf0,
    0x0003a88679c08bd8, 0x000d5c99c4dec0c4, 0x00026c8e2a68e6ca,
    0x000c1575b1875a0d, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x0009000000000000, 0x000e800000000000,
    0x0000c00000000000, 0x000be00000000000, 0x0002f00000000000,
    0x0007380000000000, 0x0001240000000000, 0x0003a60000000000,
    0x0001670000000000, 0x0005868000000000, 0x0000f4c000000000,
    0x00098f6000000000, 0x00038b5000000000, 0x00093fa800000000,
    0x000d901400000000, 0x000e0b5a00000000, 0x000c7dd300000000,
    0x0007335a80000000, 0x000059d340000000, 0x000c155ae0000000,
    0x0008fed3d0000000, 0x000cf3da08000000, 0x000a3a13dc000000,
    0x0009a4bab6000000, 0x000a6543f3000000, 0x00040512c5800000,
    0x0007b657e1400000, 0x000c2ec8ffe00000, 0x000a5844f7300000,
    0x0007147227880000, 0x00097e07b87c0000, 0x000bb1e05f7e0000,
    0x000f9b9050c90000, 0x000076c8c4848000, 0x00044c4455c84000,
    0x0000ea7212312000, 0x00020d0721157000, 0x000fc960c4848800,
    0x000d1c5055c84400, 0x0003012812312600, 0x000580d421157900,
    0x0001423a44848680, 0x000ca18315c844c0, 0x00075272f2312de0,
    0x000ee907f1157bf0, 0x000f0f604c8481b8, 0x00074b50c9c845e4,
    0x0004dfa844312e46, 0x0006601402157a97, 0x0008000000000000,
    0x000c000000000000, 0x0002000000000000, 0x0009000000000000,
    0x0000800000000000, 0x0007400000000000, 0x000ea00000000000,
    0x0001500000000000, 0x000dc80000000000, 0x00040c0000000000,
    0x000e8e0000000000, 0x000ccd0000000000, 0x0000ed8000000000,
    0x000fffc000000000, 0x000c17e000000000, 0x000e0a3000000000,
    0x0003ef9800000000, 0x000a7ecc00000000, 0x0009d63e00000000,
    0x000ee9fd00000000, 0x000c9e3e80000000, 0x0001a5fdc0000000,
    0x000eb03ea0000000, 0x000538fd50000000, 0x000315bea8000000,
    0x00098b3d24000000, 0x000f2c5e42000000, 0x000a1c0d31000000,
    0x0001e6469e800000, 0x000b910171c00000, 0x000aa99876600000,
    0x0007bfccbd100000, 0x000535bef8b80000, 0x00039b3d82ec0000,
    0x000e445e99c60000, 0x0006400d324f0000, 0x000220468f3f8000,
    0x0004100171a3c000, 0x000a6a18f05c6000, 0x0005dd0cfe3c1000,
    0x000407de8f3f8800, 0x000662cd71a3cc00, 0x000f3226f05c6200,
    0x000ef9f1fe3c1900, 0x0008f4600f3f8880, 0x000f78f0b1a3cb40,
    0x000335f8505c6ca0, 0x00049b3cae3c1850, 0x0005c646a73f8548,
    0x0008810195a3cf4c, 0x000b4198125c622e, 0x000ca3cc9f3c149d,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x000d000000000000, 0x000a800000000000, 0x0009c00000000000,
    0x000fa00000000000, 0x000d300000000000, 0x000db80000000000,
    0x000b4c0000000000, 0x00088e0000000000, 0x00062d0000000000,
    0x00039d8000000000, 0x000ae6c000000000, 0x0004886000000000,
    0x0008f41000000000, 0x000cc2f800000000, 0x0009203400000000,
    0x0006f39a00000000, 0x000f182900000000, 0x000cfd9a80000000,
    0x000cf529c0000000, 0x0002c01aa0000000, 0x000623e910000000,
    0x0001707a08000000, 0x000c5bf98c000000, 0x000a9c82f2000000,
    0x000e66cd5f000000, 0x00024a9829800000, 0x0000d424ebc00000,
    0x0002b16221600000, 0x0002f81d49100000, 0x000f2e00b8b80000,
    0x00071d00f77c0000, 0x000c2580f83e0000, 0x000caac0f43d0000,
    0x0006866046118000, 0x00071910f93e4000, 0x0000ff78a0a82000,
    0x000ef6f4f37cd000, 0x000fc3fac6118800, 0x000ca039393e4c00,
    0x0008b16200a82200, 0x0003f81de37cdd00, 0x0007ae00ce118280,
    0x0003dd00b53e45c0, 0x00090580f2a82da0, 0x00085ac0bc7cd030,
    0x00049e60e7918f38, 0x000165105efe4e8c, 0x0005c978d3c8252e,
    0x000397f4f56cd61d, 0x0008000000000000, 0x0004000000000000,
    0x000e000000000000, 0x0003000000000000, 0x0008800000000000,
    0x000fc00000000000, 0x000e600000000000, 0x0005900000000000,
    0x0001880000000000, 0x000c140000000000, 0x0009560000000000,
    0x0001f70000000000, 0x000f848000000000, 0x000fdc4000000000,
    0x000b626000000000, 0x000a139000000000, 0x0008c90800000000,
    0x000eb7ec00000000, 0x000a254e00000000, 0x000a2d6b00000000,
    0x000c7b4e80000000, 0x000f0e6b40000000, 0x000249ce60000000,
    0x0008752b70000000, 0x0001c72ee8000000, 0x000bfefb8c000000,
    0x0004d2460e000000, 0x00072987d5000000, 0x0001648016800000,
    0x00018c4014400000, 0x000a8a6003e00000, 0x000097904b300000,
    0x000897081ba80000, 0x000c94ec86f40000, 0x000297ce258e0000,
    0x0001962bdbcd0000, 0x000915aecf1e8000, 0x0006d5bb29b3c000,
    0x0008b4a695ca6000, 0x000d26577a257000, 0x000cafe84f1e8800,
    0x0000b83c69b3c400, 0x0009ee26f5ca6e00, 0x000819170a257300,
    0x00079f08271e8080, 0x000840eca5b3cbc0, 0x000321ce9bca6060,
    0x0009312baf257690, 0x0001f92ed99e8108, 0x000f4dfb3df3c7d4,
    0x000568c6962a6936, 0x000f46c731157767, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x000d000000000000,
    0x0005800000000000, 0x0008400000000000, 0x000ca00000000000,
    0x0006b00000000000, 0x0001f80000000000, 0x0001240000000000,
    0x0009860000000000, 0x000d350000000000, 0x000fce8000000000,
    0x000669c000000000, 0x00022ea000000000, 0x000bf9b000000000,
    0x000e241800000000, 0x000f047400000000, 0x000df6aa00000000,
    0x000ead5300000000, 0x0004382a80000000, 0x0009c493c0000000,
    0x000d968a60000000, 0x00077d2310000000, 0x000a929238000000,
    0x0006895794000000, 0x000a3c38f2000000, 0x000fb004ff000000,
    0x00067a126d800000, 0x000a65972d400000, 0x000da41895e00000,
    0x00064474ee100000, 0x000ad6aa51080000, 0x000d5d531c8c0000,
    0x000ce02a81e20000, 0x000610935c170000, 0x0009488a0e238000,
    0x000ddc2381104000, 0x000d2212c4a92000, 0x000cf19745d57000,
    0x000e5a1836238800, 0x000f157415104c00, 0x0005be2a36a92e00,
    0x0008f193bad57d00, 0x000c580a5ba38d80, 0x000c14e338504440,
    0x000d3c32a34922a0, 0x000530e754c57bb0, 0x0008b8200aab8c78,
    0x0006047024dc4564, 0x000a74b822ab2b26, 0x0005ecc408d27685,
    0x0008000000000000, 0x0004000000000000, 0x000a000000000000,
    0x0005000000000000, 0x0006800000000000, 0x000e400000000000,
    0x0007e00000000000, 0x0008700000000000, 0x000da80000000000,
    0x0002c40000000000, 0x0006260000000000, 0x0003d70000000000,
    0x0009bd8000000000, 0x000158c000000000, 0x00002f6000000000,
    0x000f83f000000000, 0x0006c38800000000, 0x0006a35400000000,
    0x000c125e00000000, 0x000d199f00000000, 0x0006cfde80000000,
    0x000b715f40000000, 0x000028be20000000, 0x000506af10000000,
    0x000c053648000000, 0x000486fbf4000000, 0x0005c4e836000000,
    0x0001a4a473000000, 0x000117d66c800000, 0x00051dcb1f400000,
    0x000848002ee00000, 0x000bb40032300000, 0x00070e00fd380000,
    0x000a5300d3bc0000, 0x000efb8049ce0000, 0x0004bfc018830000,
    0x0003dae0e9768000, 0x00046f303df64000, 0x000d62e8eeb36000,
    0x000833a47a5fb000, 0x00054a56a1768800, 0x0009350bc9f64400,
    0x00034f60d8b36a00, 0x0008b3f0095fb500, 0x00000b88cdf68e80,
    0x00075754d6b64a40, 0x0006fc5ef6536de0, 0x000a3a9f3b6fbd70,
    0x00031c5eb0ce8328, 0x00034a9f450a4884, 0x0002345e9f9d6bc6,
    0x000ace9f33ecbea7, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x0007000000000000, 0x000d800000000000,
    0x000fc00000000000, 0x000ba00000000000, 0x0002f00000000000,
    0x000d080000000000, 0x00078c0000000000, 0x000aae0000000000,
    0x00081f0000000000, 0x0000768000000000, 0x00042b4000000000,
    0x00033e2000000000, 0x0005c6d000000000, 0x0001c0b800000000,
    0x0008a24400000000, 0x000972a600000000, 0x0005ca5500000000,
    0x0001ac2680000000, 0x00079d1540000000, 0x000eb406e0000000,
    0x000508c530000000, 0x00038c3e38000000, 0x000caec1cc000000,
    0x000f1e3882000000, 0x000df504e3000000, 0x000bea86d2800000,
    0x00089f85dbc00000, 0x0007341e98600000, 0x000ccb116a300000,
    0x000f2e0027080000, 0x0003df00a4840000, 0x000dd680f6ea0000,
    0x0001db406be90000, 0x0003b620e0618000, 0x000d8ad0c60d4000,
    0x0000ceb8d52be000, 0x00024d449f981000, 0x00040c26d8618800,
    0x00066d150a0d4400, 0x00083c06572be600, 0x000a44c57c981700,
    0x000f023e8ae18580, 0x000981c191cd4bc0, 0x0009c0b82f4beda0,
    0x000ca24426a815f0, 0x000f72a615e98888, 0x0002ca55b9494c4c,
    0x000c2c26bba1e70e, 0x00085d159e411def, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x0001000000000000,
    0x000b800000000000, 0x0007400000000000, 0x0000200000000000,
    0x000bf00000000000, 0x0001880000000000, 0x00005c0000000000,
    0x0005be0000000000, 0x0006af0000000000, 0x000db68000000000,
    0x0006b2c000000000, 0x0002aa2000000000, 0x00072ef000000000,
    0x0009f57800000000, 0x000a12c400000000, 0x00049bc600000000,
    0x000a474100000000, 0x00053b4680000000, 0x0005f68140000000,
    0x000811e6e0000000, 0x000399b150000000, 0x0000c63e58000000,
    0x0009f84524000000, 0x000294205a000000, 0x0003c1f09b000000,
    0x0009e3f8c2800000, 0x00011004dec00000, 0x000c19e6f9600000,
    0x000185b1a4300000, 0x0008d83e1a080000, 0x0002e745fb1c0000,
    0x00050aa052aa0000, 0x00099f3026f30000, 0x000f5fd8ed7d8000,
    0x000b3df4b61f4000, 0x000c6c1e9d21e000, 0x000bd6b5d79b5000,
    0x0006e158357d8800, 0x000f9334d21f4400, 0x0006d83e2721e600,
    0x0007e7451c9b5100, 0x00088aa02ffd8380, 0x000fdf3068df4340,
    0x0004ffd86441e620, 0x00078df473ab5af0, 0x000dc41e2f758208,
    0x00007ab52903431c, 0x0002d758758be39e, 0x000960343a685c5f,
    0x0008000000000000, 0x0004000000000000, 0x0006000000000000,
    0x000f000000000000, 0x000c800000000000, 0x000dc00000000000,
    0x0001200000000000, 0x0006500000000000, 0x0006d80000000000,
    0x00097c0000000000, 0x000c1e0000000000, 0x00072f0000000000,
    0x000ec68000000000, 0x0008514000000000, 0x000dd86000000000,
    0x0003fe1000000000, 0x000eddd800000000, 0x000a8e8c00000000,
    0x0005559a00000000, 0x000fab7500000000, 0x0002f51a80000000,
    0x0009393540000000, 0x00008dfae0000000, 0x00085565b0000000,
    0x000a28c228000000, 0x000cb7b96c000000, 0x000958603a000000,
    0x000a3e1009000000, 0x0009fdd8d7800000, 0x0003de8cdec00000,
    0x000f0d9a76600000, 0x000b17755c300000, 0x000fcb1ad2080000,
    0x0008463545240000, 0x0008937a7d8e0000, 0x00097825efc50000,
    0x000beea235d38000, 0x000866a90cedc000, 0x00094338b36a2000,
    0x0008e1dce1aa9000, 0x000170229dd38800, 0x000f8be920edc400,
    0x00032558696a2600, 0x0008a0cc58aa9f00, 0x000a137ae2538480,
    0x000fb825d22dc9c0, 0x00004ea2c50a2720, 0x000cf6a9bd9a9950,
    0x00023b384fdb8258, 0x000a0ddc65c9c0bc, 0x000a962214e42b3e,
    0x000788e9b76f9e7f, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x0007000000000000, 0x0003800000000000,
    0x0004c00000000000, 0x0006600000000000, 0x000fb00000000000,
    0x000c480000000000, 0x0004cc0000000000, 0x00047e0000000000,
    0x0007b50000000000, 0x0005b98000000000, 0x0000a64000000000,
    0x000b23a000000000, 0x0006131000000000, 0x000418c800000000,
    0x0004f68400000000, 0x00091b8600000000, 0x000c77fd00000000,
    0x000c582680000000, 0x0009d4edc0000000, 0x000608eea0000000,
    0x000eee69b0000000, 0x0008ed6898000000, 0x0001ec94fc000000,
    0x00076cce7e000000, 0x00072e39c7000000, 0x00060f801a800000,
    0x000b1f403bc00000, 0x000e8420c5600000, 0x0009b050bc900000,
    0x00054ae8e0f80000, 0x00024fd471f40000, 0x00043eeec8420000,
    0x00069769eb050000, 0x0008aae8ecae8000, 0x00053fd4a8fd4000,
    0x000c16ee05eee000, 0x000aeb69e2769000, 0x00031ce8f62e8800,
    0x000286d4933d4c00, 0x000bb16ec08ee200, 0x000248295ee69700,
    0x0001cec816d68b80, 0x0000ff84e2c948c0, 0x0000f40608cce460,
    0x000718bdb5e398b0, 0x000974067a7807c8, 0x0008d8bd8a340c0c,
    0x000e9406ad22001e, 0x0004a8bde7950f05, 0x0008000000000000,
    0x000c000000000000, 0x0006000000000000, 0x0003000000000000,
    0x000c800000000000, 0x000dc00000000000, 0x0002200000000000,
    0x0004b00000000000, 0x000a880000000000, 0x00000c0000000000,
    0x000bfe0000000000, 0x0001950000000000, 0x000d888000000000,
    0x00068e4000000000, 0x00033c6000000000, 0x000c359000000000,
    0x0008785800000000, 0x0003e49400000000, 0x0005a36600000000,
    0x0009f01d00000000, 0x0003690680000000, 0x00059c8dc0000000,
    0x000947dee0000000, 0x0006d359f0000000, 0x0004585828000000,
    0x000854942c000000, 0x0005ab668a000000, 0x00073c1da7000000,
    0x00063706c2800000, 0x000d798d57c00000, 0x000c675ed5600000,
    0x0004e119a2900000, 0x00061238e7e80000, 0x0005f8045d740000,
    0x000ba5bedeae0000, 0x0003c3c915ed0000, 0x000d2080ae4b8000,
    0x000e3240c2344000, 0x00044a60bb15e000, 0x000eac9000819000,
    0x00028ed8eccb8800, 0x00093fd455f44c00, 0x000937868e75e600,
    0x0007fbcd52119300, 0x0002a53ea3238480, 0x000a4189e48041c0,
    0x000f62e03adbe420, 0x000d52d010fc97b0, 0x000f1ab8e7e80e08,
    0x0002b6445d7401cc, 0x000cb9dedeae0fde, 0x0008465915ed0625,
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x000d000000000000, 0x000c800000000000, 0x0004400000000000,
    0x0008200000000000, 0x0002d00000000000, 0x000ef80000000000,
    0x0006740000000000, 0x0004860000000000, 0x000caf0000000000,
    0x0006238000000000, 0x0009d2c000000000, 0x000d78e000000000,
    0x0003b57000000000, 0x0004663800000000, 0x00021cac00000000,
    0x00022a8200000000, 0x00038c5700000000, 0x000171e280000000,
    0x000debe740000000, 0x000a6f3aa0000000, 0x0001423b90000000,
    0x0000a38068000000, 0x000492c0d4000000, 0x000bd8e06a000000,
    0x00082570b9000000, 0x000e3e38a5800000, 0x0002f8ac0e400000,
    0x0000748225e00000, 0x000b875780b00000, 0x000d2c6245d80000,
    0x000ee227709c0000, 0x0005b25a5dd60000, 0x00078a8bfc8b0000,
    0x000f9ed89bd58000, 0x000ce9dc53b1c000, 0x0000ecbad945a000,
    0x000a00fb9b58b000, 0x0009036056558800, 0x000e83b089f1c400,
    0x000940d896a5a200, 0x0004a2dca2e8bd00, 0x0006913ab60d8480,
    0x0006d93bf72dc040, 0x0004a600ee93aa20, 0x000a7f00ded3bfd0,
    0x000adb8068000a78, 0x0002a6c0d4000634, 0x00057ee06a000ea6,
    0x000b5a70b900037f, 0x0008000000000000, 0x0004000000000000,
    0x000e000000000000, 0x0007000000000000, 0x000d800000000000,
    0x000c400000000000, 0x000c600000000000, 0x000a100000000000,
    0x0006a80000000000, 0x000b5c0000000000, 0x000cae0000000000,
    0x0006570000000000, 0x000ec08000000000, 0x0009a34000000000,
    0x0004312000000000, 0x0007d9b000000000, 0x000a676800000000,
    0x000d188c00000000, 0x000dc53600000000, 0x000e287900000000,
    0x00079c9680000000, 0x00080e8940000000, 0x0006e4de60000000,
    0x000fd8b530000000, 0x000e6600b8000000, 0x00031b00f4000000,
    0x000ac680fe000000, 0x0003a84015000000, 0x000bdfa074800000,
    0x00046df0d0c00000, 0x000cf6c866600000, 0x0009727c71b00000,
    0x00053b7e4c680000, 0x000fb5454a840000, 0x000c90c8e5fa0000,
    0x000d697cc2df0000, 0x00027dfee96c8000, 0x00005d054627c000,
    0x000b2f686137e000, 0x0003148cca945000, 0x0008233625ec8800,
    0x0002737962e7c400, 0x0002ba16f957ee00, 0x000af6c9ae245700,
    0x000a737e9d048580, 0x0006b945b8a3c840, 0x0004f6c81acde260,
    0x000d727c2d4b5d10, 0x000b3b7e80000328, 0x0008b5454000031c,
    0x000110c860000ece, 0x0001297c30000b47, 0x0008000000000000,
    0x000c000000000000, 0x000a000000000000, 0x0001000000000000,
    0x000b800000000000, 0x0001400000000000, 0x0005600000000000,
    0x0002900000000000, 0x0007d80000000000, 0x000d640000000000,
    0x000e160000000000, 0x00069d0000000000, 0x0008838000000000,
    0x0007c1c000000000, 0x0005a02000000000, 0x0007b2f000000000,
    0x000babe800000000, 0x00096dac00000000, 0x0001ca0a00000000,
    0x00077d0b00000000, 0x0007d1aa80000000, 0x0004ba3bc0000000,
    0x0004f46220000000, 0x00034c67d0000000, 0x0001380098000000,
    0x0002b400c4000000, 0x0006ae004e000000, 0x000869002d000000,
    0x000acd8093800000, 0x000d78c0eb400000, 0x000655a0cae00000,
    0x00047e3096900000, 0x0001504814d80000, 0x00047a9cc38c0000,
    0x0001d7c2335a0000, 0x000f3f576ee30000, 0x000533c8e8848000,
    0x000d6b5c51e9c000, 0x00074fe25c1c2000, 0x000739a78a257000,
    0x0009b620e3048800, 0x000c2ff07ea9cc00, 0x0002a868d8fc2a00,
    0x000eec6c31b57100, 0x000a8a2ae45c8380, 0x00031ffb9665cd40,
    0x000ec24201462f60, 0x0002239719c67390, 0x000cf06800000458,
    0x000fc86c00000024, 0x00007c2a00000176, 0x000752fb0000050d,
    0x0008000000000000, 0x000c000000000000, 0x0006000000000000,
    0x0007000000000000, 0x0005800000000000, 0x000f400000000000,
    0x0004e00000000000, 0x0005700000000000, 0x000bf80000000000,
    0x000d0c0000000000, 0x000f5e0000000000, 0x0004f50000000000,
    0x000f508000000000, 0x000f2b4000000000, 0x0006652000000000,
    0x000e597000000000, 0x00079c8800000000, 0x0002543400000000,
    0x000a425a00000000, 0x000c630100000000, 0x000eb1fa80000000,
    0x0002d831c0000000, 0x00065ed2e0000000, 0x000a7735b0000000,
    0x000393a0b8000000, 0x00038b3044000000, 0x0002772876000000,
    0x000f9304d3000000, 0x00058b72a9800000, 0x0005750573c00000,
    0x000a120884600000, 0x000aca7408900000, 0x000197fadf680000,
    0x000f61311d240000, 0x00013052beba0000, 0x000c99756c730000,
    0x00003e0044928000, 0x0005c500d5604000, 0x0003c8803c3f2000,
    0x000f174052245000, 0x0003a320d5128800, 0x000d907022a04c00,
    0x00088a082e5f2600, 0x0001f67439b45700, 0x0007d1fa9bfa8d80,
    0x0004e831c8444340, 0x000f46d2828522e0, 0x00050b353e575270,
    0x0002b5a091800678, 0x00053230f7c00e4c, 0x000699a812600dbe,
    0x00013d446b900685, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x000f000000000000, 0x0006800000000000,
    0x0001c00000000000, 0x0003a00000000000, 0x0000700000000000,
    0x000fc80000000000, 0x000e6c0000000000, 0x000d260000000000,
    0x000f8b0000000000, 0x000e8c8000000000, 0x0009344000000000,
    0x000c916000000000, 0x0009d95000000000, 0x000476d800000000,
    0x0003f09400000000, 0x00058b3e00000000, 0x00038d7100000000,
    0x0006b5e680000000, 0x0004d1e540000000, 0x000d38d8e0000000,
    0x00066794b0000000, 0x000fe9be08000000, 0x00045e31ec000000,
    0x000f0e06d2000000, 0x000a77f55b000000, 0x0008f3e026800000,
    0x00050a1051c00000, 0x000d4d3826e00000, 0x00039684f2700000,
    0x0005600668a80000, 0x000150f570f40000, 0x00087960675e0000,
    0x000d0550af110000, 0x0005b8d8c09b8000, 0x000ca7944cec4000,
    0x000cc9be4d766000, 0x000aee31702a5000, 0x0005e606a8338800,
    0x0005abf53c184400, 0x0009bde02a286600, 0x00049d10df3b5f00,
    0x00012fb8e8a80e80, 0x000b45c430f405c0, 0x000a5be6875e05a0,
    0x000e36e51f110f70, 0x000e1258489b8948, 0x000e18d4e0ec4fac,
    0x0008d45e7f766e86, 0x000503219b2a5ffb, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x0001000000000000,
    0x0002800000000000, 0x0007c00000000000, 0x0005e00000000000,
    0x0009d00000000000, 0x000de80000000000, 0x0007d40000000000,
    0x000fbe0000000000, 0x0000290000000000, 0x0001348000000000,
    0x000bedc000000000, 0x000981e000000000, 0x000641d000000000,
    0x000fa34800000000, 0x000873ec00000000, 0x0004985e00000000,
    0x0001ce0700000000, 0x0009b31680000000, 0x000c79ebc0000000,
    0x00049d4860000000, 0x00029aecd0000000, 0x000cccdec8000000,
    0x000533c76c000000, 0x000abaf6f6000000, 0x0003fc3b21000000,
    0x000c8800e0800000, 0x0004c40030400000, 0x000b3600ed600000,
    0x0008ed0013d00000, 0x000402809ea80000, 0x000200c05d4c0000,
    0x000f03600bd60000, 0x000381103a810000, 0x00054028474a8000,
    0x000222fc9cf3c000, 0x000c30765b196000, 0x000438fb2792b000,
    0x000a3d60d9e28800, 0x00086810c1bfcc00, 0x000f94a850cf6e00,
    0x00011f3c1d13b100, 0x000ad9961ea80a80, 0x00026d2b9d4c0bc0,
    0x000fc0286bd60be0, 0x0009e2fcea8108d0, 0x0007d0768f4a8f68,
    0x000ce8fbf0f3c014, 0x00055560ad196a5e, 0x00087c100692b9f9,
    0x0008000000000000, 0x0004000000000000, 0x0006000000000000,
    0x0007000000000000, 0x0000800000000000, 0x000ac00000000000,
    0x0001200000000000, 0x0009300000000000, 0x0003980000000000,
    0x0009740000000000, 0x00082e0000000000, 0x00047b0000000000,
    0x0003648000000000, 0x0003864000000000, 0x000916e000000000,
    0x00087c1000000000, 0x000431b800000000, 0x00061b6400000000,
    0x0002347a00000000, 0x00044fa300000000, 0x00062bc280000000,
    0x00022fc740000000, 0x00017b38e0000000, 0x0002e62430000000,
    0x000ec61a68000000, 0x000275f3dc000000, 0x000aac9a9a000000,
    0x000fb8b37f000000, 0x0005c6facb800000, 0x0000f6e334400000,
    0x00016fa253600000, 0x00091a974cf00000, 0x0006b6e04ea80000,
    0x00088c1070d40000, 0x000009b8e4a60000, 0x000b9f6467e50000,
    0x0008227a73158000, 0x000ab0a309874000, 0x000fd9427f742000,
    0x000596871ed87000, 0x0000bf58bdbd8800, 0x0004137439534400,
    0x0008abc27bd22600, 0x000befc7493d7700, 0x0006db38a6a80880,
    0x00061624ecd40ec0, 0x000cfe1a9ea60720, 0x0008f1f328e50e30,
    0x00003a9ad0958318, 0x000b87b3e1c743b4, 0x000d147ab614290e,
    0x000e7fa32d287d4b, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x000d000000000000, 0x0002800000000000,
    0x0000400000000000, 0x000ee00000000000, 0x000d300000000000,
    0x000e380000000000, 0x000fa40000000000, 0x00065e0000000000,
    0x0009d90000000000, 0x000a168000000000, 0x000324c000000000,
    0x00071ee000000000, 0x0003b83000000000, 0x000a666800000000,
    0x00017c9400000000, 0x0005ca3200000000, 0x00053def00000000,
    0x00012a5a80000000, 0x00030c7bc0000000, 0x000090e8e0000000,
    0x000e685410000000, 0x00086cd248000000, 0x000461dfd4000000,
    0x0001723246000000, 0x0006d9ef17000000, 0x000f945aed800000,
    0x000ae57b39400000, 0x00063e684e600000, 0x0002a89473d00000,
    0x0007cc3262880000, 0x000330efa8dc0000, 0x000f3ada75060000,
    0x000b25bbe48f0000, 0x000b1e885fe88000, 0x0005b9a4889a4000,
    0x000764da95cda000, 0x0003fcbbc58bb000, 0x00058808bd608800,
    0x000bdd64e0464c00, 0x000c1a3a00cba600, 0x000d348b3104bd00,
    0x000f36602a880a80, 0x000835f07cdc0c40, 0x0001b608330608e0,
    0x000e7464f38f0030, 0x000254bab2688cb8, 0x0001c44bb1da4fe4,
    0x000c2e80dbada8be, 0x000080c0b65bb4e9, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x0005000000000000,
    0x0006800000000000, 0x0004c00000000000, 0x0000600000000000,
    0x000f300000000000, 0x0002580000000000, 0x000d2c0000000000,
    0x0005160000000000, 0x00000b0000000000, 0x0002c48000000000,
    0x0008a2c000000000, 0x000d51e000000000, 0x000e691000000000,
    0x000cf46800000000, 0x000a787400000000, 0x0001bf6a00000000,
    0x000d9c4500000000, 0x00070f8280000000, 0x000a86f140000000,
    0x000b0108e0000000, 0x000783a410000000, 0x000442e208000000,
    0x0001a1211c000000, 0x0009d280ee000000, 0x0009a9c0ff000000,
    0x000f156043800000, 0x00070bd071c00000, 0x000745881ce00000,
    0x000fe1649e700000, 0x000f73027b280000, 0x0005f831799c0000,
    0x0001fee85cd60000, 0x000a3db4fe7d0000, 0x000bdc0a2b388000,
    0x0005ac9511a64000, 0x0000d68a10f82000, 0x0000e955f86f1000,
    0x000c35ea58108800, 0x000c1985743a4400, 0x000b8ce2a22e2600,
    0x00094621f9121500, 0x000ee00030a80e80, 0x000ff000145c00c0,
    0x00043800ae360660, 0x00071c009f0d0a30, 0x0001ce00139084d8,
    0x0009e70019fa49ec, 0x0007b28050ce2576, 0x000799c098621f3b,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x0007000000000000, 0x0000800000000000, 0x0004c00000000000,
    0x000b600000000000, 0x000f900000000000, 0x000b280000000000,
    0x0009340000000000, 0x00087e0000000000, 0x0005590000000000,
    0x000c4c8000000000, 0x0008804000000000, 0x0008c2e000000000,
    0x0005629000000000, 0x0008922800000000, 0x000ba91c00000000,
    0x000df41e00000000, 0x00031c5f00000000, 0x000acab680000000,
    0x00076503c0000000, 0x0001b44860000000, 0x0000bfccb0000000,
    0x00003ad6e8000000, 0x0004ded33c000000, 0x000328003e000000,
    0x0005340075000000, 0x00067e00e4800000, 0x000259001a400000,
    0x000ccc803d600000, 0x000c40408ad00000, 0x0003a2e0f5280000,
    0x000af29024940000, 0x0003ba28fa660000, 0x00029d1c4d6d0000,
    0x00058a1e82ec8000, 0x0006455fb928c000, 0x0006863612ab6000,
    0x000fe543c3503000, 0x000976a89fc48800, 0x0005dd5ca1bccc00,
    0x0008a8fed6cd6e00, 0x000f77cffb3d3700, 0x000edc1ef9a80880,
    0x0006285f02d408c0, 0x000cb4b6f9060560, 0x00053c03b2bd0890,
    0x000d78c813448ba8, 0x000cff8c47fccdf4, 0x00039836b5ad631e,
    0x000e2c43b4ed3ac9, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x0009000000000000, 0x0000800000000000,
    0x0006400000000000, 0x000da00000000000, 0x000c500000000000,
    0x0008b80000000000, 0x00066c0000000000, 0x0009f60000000000,
    0x00088b0000000000, 0x0006e58000000000, 0x000b10c000000000,
    0x00019b6000000000, 0x000e7d3000000000, 0x0005eeb800000000,
    0x0002375c00000000, 0x0001eb2a00000000, 0x0008571d00000000,
    0x0002d81280000000, 0x00055c8140000000, 0x0004fe58a0000000,
    0x000eadacd0000000, 0x000d157228000000, 0x0002fab1f4000000,
    0x000dcd6052000000, 0x000ea630e1000000, 0x0009b33871800000,
    0x00064b9c33c00000, 0x0009064a1ce00000, 0x0008e12d8a700000,
    0x000c732aab380000, 0x00002b1dbcbc0000, 0x000c36125c6e0000,
    0x000eeb81e01f0000, 0x0003d5d8703d8000, 0x000d1a6cf816c000,
    0x000e3d92dc012000, 0x00034c4126081000, 0x0007e538f3058800,
    0x000f909cb0aac400, 0x0005dbcad26f2200, 0x000added27171900,
    0x00093e4a72b80880, 0x000ccd2d3b7c0240, 0x000a252ab28e0fa0,
    0x000df01d5b6f0550, 0x0002eb9202858838, 0x0005d741c36ac02c,
    0x000618b86e8f2456, 0x0007bc5c7d6714db, 0x0008000000000000,
    0x000c000000000000, 0x0002000000000000, 0x000f000000000000,
    0x000b800000000000, 0x000e400000000000, 0x0007600000000000,
    0x0008700000000000, 0x0005f80000000000, 0x00012c0000000000,
    0x000f360000000000, 0x000fa90000000000, 0x000e478000000000,
    0x0000d14000000000, 0x0007aa2000000000, 0x000245f000000000,
    0x0002d38800000000, 0x0008aa2400000000, 0x0009c47200000000,
    0x000c912d00000000, 0x000fc87a80000000, 0x0001b649c0000000,
    0x00096828a0000000, 0x000ee79430000000, 0x000e825a98000000,
    0x0006c3b914000000, 0x0000a3a04e000000, 0x000e51b0a3000000,
    0x0001682809800000, 0x0002e79465c00000, 0x000c825a14e00000,
    0x0009c3b90c500000, 0x000b23a0e1180000, 0x000011b0b0840000,
    0x00060828e15a0000, 0x000a9794cb8b0000, 0x00097a5a1cfa8000,
    0x0008efb9b06d4000, 0x000415a0a307a000, 0x000fb8b009a49000,
    0x00084fa865e28800, 0x000a46d414e94c00, 0x000ed07a0c5da200,
    0x000aaa49612f9f00, 0x0006c628f0980380, 0x0007129401440240,
    0x00018bda1bba0560, 0x0006d7f954db0770, 0x000118006c628e78,
    0x000b1c0071294f6c, 0x000fae0018bda856, 0x0009f5006d7f97d9,
    0x0008000000000000, 0x0004000000000000, 0x000a000000000000,
    0x000f000000000000, 0x000e800000000000, 0x0005400000000000,
    0x0004e00000000000, 0x000fd00000000000, 0x000bf80000000000,
    0x0005740000000000, 0x00032e0000000000, 0x00036b0000000000,
    0x00016f8000000000, 0x000d0b4000000000, 0x0001fd6000000000,
    0x000d127000000000, 0x0005daa800000000, 0x000087ec00000000,
    0x0007259a00000000, 0x000d163b00000000, 0x0002beb280000000,
    0x0008f19740000000, 0x000189c820000000, 0x000fbe9cb0000000,
    0x000d70b248000000, 0x00004a97a4000000, 0x00011e4826000000,
    0x0008c1dce9000000, 0x000123d251800000, 0x000b73e75a400000,
    0x00014b60e5600000, 0x000a9d7075f00000, 0x000c0328ca180000,
    0x000e03aceb040000, 0x0005017a5eae0000, 0x0001800b02d30000,
    0x000bc0fabe9c8000, 0x0001a04b52e9c000, 0x000b321aa68b2000,
    0x0004297beee97000, 0x000e8dd2bc848800, 0x000658e75dedc400,
    0x000044e0fe252a00, 0x00020630b53a7f00, 0x000c66481b980680,
    0x000cf5dcf1440140, 0x000cedd29bce0ee0, 0x0008c8e7c72300d0,
    0x00055ce03c848578, 0x0007a2301dedc034, 0x000a3048de2527ce,
    0x000faadc053a7cbb, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x0005000000000000, 0x0009800000000000,
    0x000b400000000000, 0x0007a00000000000, 0x0009700000000000,
    0x0006380000000000, 0x000f540000000000, 0x00070e0000000000,
    0x000d490000000000, 0x00066e8000000000, 0x0002dac000000000,
    0x000d842000000000, 0x000e473000000000, 0x0001277800000000,
    0x0007b55400000000, 0x0003dcc200000000, 0x0001001300000000,
    0x0003833a80000000, 0x00084287c0000000, 0x000b2358e0000000,
    0x000bb26490000000, 0x000adbbaf8000000, 0x00018547e4000000,
    0x000847f862000000, 0x00042694e3000000, 0x000e366279800000,
    0x00089de332400000, 0x0006a0620b600000, 0x000af0e355d00000,
    0x000e78e28c080000, 0x00047723fe3c0000, 0x000cbc42a52a0000,
    0x000793d3189f0000, 0x0007e99ab8d58000, 0x000a9f77f8b64000,
    0x0009a00028d3a000, 0x0000700000b87000, 0x0009b8004cdd8800,
    0x00011400228a4c00, 0x00092e000ff9a600, 0x000f79006b277500,
    0x0007f680f5880180, 0x0004fec0cc7c0740, 0x000cb220ae4a01a0,
    0x000c5a304d4f0c70, 0x000047f834dd8fb8, 0x00082694068a4414,
    0x000836628df9a0ae, 0x000d9de318277439, 0x0008000000000000,
    0x000c000000000000, 0x000a000000000000, 0x000d000000000000,
    0x0004800000000000, 0x000f400000000000, 0x000d600000000000,
    0x0008d00000000000, 0x0004680000000000, 0x0000040000000000,
    0x0003be0000000000, 0x0002510000000000, 0x0000298000000000,
    0x000ee5c000000000, 0x000dac6000000000, 0x00009bf000000000,
    0x000add0800000000, 0x000c82ac00000000, 0x0003424e00000000,
    0x0007616b00000000, 0x0005d32680000000, 0x0000e837c0000000,
    0x000f446020000000, 0x000edff010000000, 0x000a8308e8000000,
    0x000443ac24000000, 0x000ee3ce9e000000, 0x000e10ab79000000,
    0x0002c94610800000, 0x000af6c74d400000, 0x000266e85d600000,
    0x000eed9c35500000, 0x0007faa6d1780000, 0x000f0df7ef4c0000,
    0x000c6800c65e0000, 0x000c04005ee30000, 0x0009be0047968000,
    0x000f51009cd5c000, 0x0004a980ac946000, 0x0001a5c06f6c7000,
    0x0000cc60866e8800, 0x00084bf03ed9cc00, 0x000eb50837aa6a00,
    0x000c86ac04df7d00, 0x0000fc4e10800c80, 0x0005306b4d400340,
    0x0005faa65d600760, 0x000e0df7355005d0, 0x0002e800517800e8,
    0x000e44002f4c0f44, 0x00005e00e65e0ede, 0x0008c1004ee30a81,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x000b000000000000, 0x000d800000000000, 0x0006400000000000,
    0x000aa00000000000, 0x0006900000000000, 0x0009a80000000000,
    0x000f4c0000000000, 0x0009f60000000000, 0x0007510000000000,
    0x00024b8000000000, 0x000cfe4000000000, 0x000b8fa000000000,
    0x000697f000000000, 0x000422b800000000, 0x0001524c00000000,
    0x00074aee00000000, 0x00087d8900000000, 0x000b4ff680000000,
    0x0007f435c0000000, 0x000e51a0a0000000, 0x0004caf070000000,
    0x00073f38f8000000, 0x00076d0cd4000000, 0x000aa6ce72000000,
    0x000b18390d000000, 0x0007b4eeb0800000, 0x0001f0895dc00000,
    0x0006da76a5e00000, 0x000e5775f1d00000, 0x00094380c3d80000,
    0x00092240aef40000, 0x0009d1a0ce420000, 0x00058af01b9b0000,
    0x00021f3812518000, 0x000cbd0c859bc000, 0x00042ece99656000,
    0x000484397a2c5000, 0x000d4aee61098800, 0x000f7d8976afcc00,
    0x0004cff6f2c76200, 0x000ab43590675b00, 0x000971a030800580,
    0x00041af09dc00a40, 0x0004373805e008a0, 0x000eb10c81d00d90,
    0x000af8cebbd80428, 0x00030539baf4090c, 0x000c096e1c420356,
    0x000a5fc9669b01c1, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x000b000000000000, 0x0009800000000000,
    0x0001c00000000000, 0x000e600000000000, 0x000df00000000000,
    0x000ae80000000000, 0x0000ac0000000000, 0x0007f60000000000,
    0x000e110000000000, 0x000cda8000000000, 0x0009274000000000,
    0x00082aa000000000, 0x000b4d1000000000, 0x000dc46800000000,
    0x00019b2400000000, 0x0008052600000000, 0x0005fba100000000,
    0x0008f5ee80000000, 0x000d9095c0000000, 0x00001820e0000000,
    0x0005c65070000000, 0x000d98c8f8000000, 0x000e0734ac000000,
    0x000efbce7e000000, 0x000177c5c3000000, 0x000c5268c8800000,
    0x000e7a2415c00000, 0x000837a6b1e00000, 0x000770e15bd00000,
    0x000ea94eaac80000, 0x00090c85af640000, 0x000f66c849020000,
    0x00008a3489a50000, 0x00075f4e086c8000, 0x00001d850ba34000,
    0x000c3c48dd74e000, 0x00036d74a4185000, 0x000895eeea248800,
    0x0007609571074c00, 0x00057020c596e600, 0x000faa50066d5b00,
    0x000d8ec830800180, 0x000c2634b9c00dc0, 0x0006a94ecfe00860,
    0x00050c8598d006f0, 0x000966c8e2480368, 0x000b8a347aa4016c,
    0x000edf4e18e20996, 0x0001dd85a27503e1, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x0009000000000000,
    0x000a800000000000, 0x0009c00000000000, 0x000f600000000000,
    0x0001500000000000, 0x0008980000000000, 0x000e7c0000000000,
    0x0007560000000000, 0x0009a30000000000, 0x0009b28000000000,
    0x000489c000000000, 0x000944e000000000, 0x000d9ad000000000,
    0x000efca800000000, 0x0009960c00000000, 0x0005433200000000,
    0x000ba19900000000, 0x000ab1fa80000000, 0x0009088540000000,
    0x0003048060000000, 0x0001bac0d0000000, 0x00090e6048000000,
    0x000f3f100c000000, 0x0002f6485e000000, 0x000a13dc89000000,
    0x000a3b1a7f800000, 0x000e4d55f2c00000, 0x00079ca87ce00000,
    0x0005c60c3df00000, 0x00095b320e480000, 0x00051d9942ac0000,
    0x000807fa27660000, 0x00083b854d310000, 0x000d4e00ed848000,
    0x000a1f0085cdc000, 0x000f84807a79a000, 0x00057ac0c8b95000,
    0x0002ee60d44c8800, 0x000eaf1039a1c400, 0x000f8e487fffae00,
    0x000cffdc31785900, 0x000a951ac8000280, 0x0008c2554c000dc0,
    0x0001e0283e000160, 0x000690cc59000850, 0x000efb5237800218,
    0x0005ad89fec007bc, 0x00060d3222e00836, 0x0008be99b4f008f3,
    0x0008000000000000, 0x0004000000000000, 0x000e000000000000,
    0x000d000000000000, 0x0007800000000000, 0x000a400000000000,
    0x0005e00000000000, 0x000f300000000000, 0x0009780000000000,
    0x0006d40000000000, 0x0004be0000000000, 0x0001830000000000,
    0x0003428000000000, 0x000c60c000000000, 0x000872a000000000,
    0x000b1b7000000000, 0x0003a7e800000000, 0x000824b400000000,
    0x0008669200000000, 0x000e876b00000000, 0x000b375a80000000,
    0x000f8f6f40000000, 0x0006f80060000000, 0x0008940090000000,
    0x000f5e0098000000, 0x0003b30074000000, 0x000dba8026000000,
    0x0000f4c057000000, 0x00092ca0c9800000, 0x0005a8709e400000,
    0x00099d68dc600000, 0x0002907475700000, 0x0004aa327fc80000,
    0x00041f1bde3c0000, 0x000bd23233020000, 0x000bcb1b37bb0000,
    0x0006ec32dd548000, 0x000d081ba3fc4000, 0x0007ceb2a417a000,
    0x000418db5e3df000, 0x00032412731c8800, 0x0006e7abd7804400,
    0x000d45fa0d75ae00, 0x0009941fdbf6fd00, 0x0002dfe800000f80,
    0x000af0b400000e40, 0x0002d89200000be0, 0x0002046b00000230,
    0x000ff5da80000ef8, 0x0009afaf40000c94, 0x000b6aa06000015e,
    0x000cbf7090000eb3, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x0007000000000000, 0x0003800000000000,
    0x0000c00000000000, 0x0001e00000000000, 0x0006300000000000,
    0x000cc80000000000, 0x000b3c0000000000, 0x000c660000000000,
    0x000b030000000000, 0x0005818000000000, 0x0005c14000000000,
    0x0005612000000000, 0x000570d000000000, 0x000de84800000000,
    0x000cedf400000000, 0x00069cbe00000000, 0x000cf6fd00000000,
    0x0002da5680000000, 0x0002a59940000000, 0x000be000a0000000,
    0x0005300030000000, 0x000d480018000000, 0x000cfc007c000000,
    0x000e060026000000, 0x000df3006f000000, 0x0008a980d2800000,
    0x0008cd40d0c00000, 0x0005cf200ae00000, 0x00054fd003f00000,
    0x00040fc89e780000, 0x00022fb4ec240000, 0x00067c1e0e0a0000,
    0x000c476d0b190000, 0x000a533e08968000, 0x000b38bdd9d24000,
    0x000094f6174f6000, 0x00052b0931b09000, 0x00090ee8dc6e8800,
    0x0002af64d9364400, 0x00073c5695a56200, 0x000a669966599700,
    0x000e018000000b80, 0x00010140000004c0, 0x00068120000003e0,
    0x000440d000000130, 0x0002a04800000f48, 0x000711f400000bfc,
    0x000b1abe00000d86, 0x0001c5fd00000d33, 0x0008000000000000,
    0x000c000000000000, 0x0006000000000000, 0x000f000000000000,
    0x000d800000000000, 0x000c400000000000, 0x000e200000000000,
    0x0007b00000000000, 0x0003880000000000, 0x00010c0000000000,
    0x0003aa0000000000, 0x000e010000000000, 0x0003018000000000,
    0x000b80c000000000, 0x000341e000000000, 0x0003a1b000000000,
    0x000bf18800000000, 0x000da9c400000000, 0x0006bcf600000000,
    0x0000227100000000, 0x000f0d2180000000, 0x0000abf540000000,
    0x0005800020000000, 0x0000400030000000, 0x0008200018000000,
    0x0008b0003c000000, 0x000e080036000000, 0x000d4c0031000000,
    0x000d8a0038800000, 0x0009b1001ec00000, 0x000089800e200000,
    0x000a8cc004300000, 0x0000ebe00ea80000, 0x000da0b038040000,
    0x0008f0080c060000, 0x000629042e030000, 0x0005fd160d078000,
    0x000383c10e86c000, 0x0004fca9afc62000, 0x000d023176a71000,
    0x00033cf63af3d800, 0x000062713089c400, 0x00072d21a4348600,
    0x00081bf57eafd500, 0x000b880000000080, 0x000d0c00000000c0,
    0x0005aa0000000060, 0x00010100000000f0, 0x000e8180000000d8,
    0x0007c0c0000000c4, 0x000d61e0000000e2, 0x000411b00000007b,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x000b000000000000, 0x0001800000000000, 0x0005c00000000000,
    0x000ae00000000000, 0x000a900000000000, 0x0003b80000000000,
    0x00078c0000000000, 0x00018e0000000000, 0x000b810000000000,
    0x000cc18000000000, 0x000e61c000000000, 0x0005d16000000000,
    0x000d183000000000, 0x00023cb800000000, 0x0002475c00000000,
    0x0005245200000000, 0x00097bf700000000, 0x0003e23180000000,
    0x00031fd1c0000000, 0x0004380020000000, 0x00054c0030000000,
    0x0004ee0038000000, 0x000fd1002c000000, 0x0004198006000000,
    0x0006bdc017000000, 0x000d07602b800000, 0x000b85302a400000,
    0x000ccb380ee00000, 0x00002b9c1e300000, 0x000dbab206380000,
    0x000183072e040000, 0x0008ce69b3060000, 0x0002217df9870000,
    0x0006f18a37458000, 0x0003689b0460c000, 0x000014dbb0f2e000,
    0x0007f27ae51d7000, 0x0006e7e3b2914800, 0x000995e6c2efdc00,
    0x000e3351bc08c600, 0x000207e1fa3f4700, 0x000804b800000080,
    0x000c0b5c000000c0, 0x00004a52000000e0, 0x00036af7000000b0,
    0x000d1bb180000018, 0x000f3211c000005c, 0x000a8760200000ae,
    0x00094530300000a9, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x000f000000000000, 0x0003800000000000,
    0x0004400000000000, 0x000da00000000000, 0x000e500000000000,
    0x0005980000000000, 0x0003540000000000, 0x0005ca0000000000,
    0x0007410000000000, 0x0000208000000000, 0x000f114000000000,
    0x0004b9e000000000, 0x000ac47000000000, 0x0009b28800000000,
    0x0007e4b400000000, 0x000e234a00000000, 0x000e9cf300000000,
    0x0002070a80000000, 0x00075e8940000000, 0x000a6a0020000000,
    0x0002110010000000, 0x000c388028000000, 0x000705403c000000,
    0x000f53e00e000000, 0x0007957011000000, 0x0001aa0836800000,
    0x0005f1f439400000, 0x000ac8aa16600000, 0x00004d830d500000,
    0x000e5f0297280000, 0x0008ea7d5d040000, 0x0000d02a20820000,
    0x000958c32c450000, 0x000334e2bae78000, 0x000d7b0d5711c000,
    0x0002a82208ca2000, 0x000cfc371e92d000, 0x0001b6c8a60d2800,
    0x000b36ce7f33cc00, 0x000df640b07c2a00, 0x0002977a512a2500,
    0x0009a78a80000080, 0x00080fc940000040, 0x000973e0200000a0,
    0x00098570100000f0, 0x0003920828000038, 0x0007f5f43c000044,
    0x00091aaa0e0000da, 0x00001883110000e5, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x000d000000000000,
    0x0005800000000000, 0x0004400000000000, 0x0003200000000000,
    0x0008700000000000, 0x000c980000000000, 0x0008b40000000000,
    0x000b320000000000, 0x000b410000000000, 0x000fa08000000000,
    0x0003b14000000000, 0x0006f9a000000000, 0x000664b000000000,
    0x000b9a8800000000, 0x000c4d6400000000, 0x0004578e00000000,
    0x000f5bd300000000, 0x000aad3680000000, 0x0001461640000000,
    0x0005920020000000, 0x0003710010000000, 0x000a188028000000,
    0x000e754034000000, 0x0004d3a016000000, 0x0001d1b011000000,
    0x000c28080c800000, 0x000ccd2421c00000, 0x000196ae32600000,
    0x00023a2322d00000, 0x000cfc1eacc80000, 0x00002ec26d040000,
    0x0005ff861e820000, 0x0003d6f71ec50000, 0x00021b98b3e68000,
    0x00060c356d92c000, 0x0000761e986a2000, 0x000fabc270359000,
    0x0007f50615de3800, 0x000e92b738af4c00, 0x0005f0b8a6d4da00,
    0x000cd8c542c85900, 0x000195b680000080, 0x000e435640000040,
    0x000259a0200000a0, 0x000354b0100000d0, 0x000ba28828000058,
    0x0005c96434000044, 0x00055d8e16000032, 0x00009ed311000087,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x0001000000000000, 0x0000800000000000, 0x000f400000000000,
    0x0008600000000000, 0x000d700000000000, 0x0005e80000000000,
    0x000ec40000000000, 0x0009b60000000000, 0x000e610000000000,
    0x0002718000000000, 0x0006684000000000, 0x0000042000000000,
    0x000e161000000000, 0x000430e800000000, 0x0002888c00000000,
    0x000035ee00000000, 0x00029e9d00000000, 0x000704c880000000,
    0x0001975ec0000000, 0x0008f18020000000, 0x0004284030000000,
    0x000ae42008000000, 0x000d261004000000, 0x000938e802000000,
    0x000e7c8c3d000000, 0x00040bee21800000, 0x000f4b9d35c00000,
    0x00092b4897a00000, 0x00075a1efb100000, 0x0003322006d80000,
    0x0002371009840000, 0x000ca16801c60000, 0x0007d0cc1da10000,
    0x000d39ce02108000, 0x00007c8d05584000, 0x00070a20b143a000,
    0x000ecad2ffe23000, 0x0006ebee3777b800, 0x00007b9d016a7400,
    0x00062348b2cb2200, 0x000aae1efbd97b00, 0x00078c2008000080,
    0x0000a210040000c0, 0x000aeee802000020, 0x000c6d8c3d000010,
    0x0003126e21800008, 0x0008a7dd35c000f4, 0x0008f96897a00086,
    0x000a5d0efb1000d7, 0x0008000000000000, 0x0004000000000000,
    0x000e000000000000, 0x000d000000000000, 0x0008800000000000,
    0x0008400000000000, 0x0001200000000000, 0x000dd00000000000,
    0x000d680000000000, 0x0003640000000000, 0x000d1e0000000000,
    0x0005610000000000, 0x0006f08000000000, 0x0003b9c000000000,
    0x000b8da000000000, 0x000ebb1000000000, 0x00011e0800000000,
    0x000f61a400000000, 0x0005f0fa00000000, 0x000639cd00000000,
    0x000b4cdc80000000, 0x0007dbbbc0000000, 0x000dee8020000000,
    0x000fd8c010000000, 0x000bfd2038000000, 0x000842d034000000,
    0x000333a822000000, 0x00044ab421000000, 0x0008a6f204800000,
    0x0007ec6937400000, 0x000eca26b5a00000, 0x0007e776cd900000,
    0x000d4cdc94780000, 0x000edbbbc5840000, 0x000b6e8003c20000,
    0x000a98c02ae70000, 0x00025d2034368000, 0x000dd2d02fec4000,
    0x000f7ba822f82000, 0x000afeb42bc69000, 0x0008d0f226e3e800,
    0x0001e96922373400, 0x000524a6aceb7200, 0x00013fb6c77aef00,
    0x000031fcb8000080, 0x0003d96bf4000040, 0x0001fd28020000e0,
    0x000b4274310000d0, 0x0006b3d23c800088, 0x00048ab903400084,
    0x0001c78e97a00012, 0x000b1cc2ec9000dd, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x000b000000000000,
    0x000d800000000000, 0x0000c00000000000, 0x0001e00000000000,
    0x0005d00000000000, 0x0002e80000000000, 0x000d840000000000,
    0x0008320000000000, 0x000f210000000000, 0x000b308000000000,
    0x000cb8c000000000, 0x0004ad6000000000, 0x0009d7b000000000,
    0x0002031800000000, 0x000719bc00000000, 0x000fdcfa00000000,
    0x0002cffd00000000, 0x000fde6080000000, 0x0008d72e40000000,
    0x0006828020000000, 0x000759c010000000, 0x00087de018000000,
    0x000bbf702c000000, 0x0009c67836000000, 0x00038a0c03000000,
    0x00040de207800000, 0x000f274117400000, 0x0009da1a8ba00000,
    0x000b241376100000, 0x0005c38080c80000, 0x0009785e6c840000,
    0x0007ccf814c20000, 0x000747cc0ee30000, 0x000aca023cb58000,
    0x00032d31085ec000, 0x000016e2b98c6000, 0x000363df4826f000,
    0x000489829353e800, 0x0001956f7a6ff400, 0x000bba1aac118200,
    0x0001341355c8b900, 0x000d4b8098000080, 0x000aec5e6c000040,
    0x000176f816000060, 0x0000f2cc130000b0, 0x000ac0821f8000d8,
    0x0008e0f13b40000c, 0x00055102bda0001e, 0x0004a9af7510005d,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x0007000000000000, 0x000c800000000000, 0x000a400000000000,
    0x000f200000000000, 0x0002300000000000, 0x000ba80000000000,
    0x0005ec0000000000, 0x000c160000000000, 0x0001e10000000000,
    0x000b518000000000, 0x0008b9c000000000, 0x000b74e000000000,
    0x000ed39000000000, 0x00025a4800000000, 0x0009876400000000,
    0x0000390600000000, 0x000335d500000000, 0x0008f20d80000000,
    0x000beabac0000000, 0x0004ef8020000000, 0x0000b4c030000000,
    0x0002336038000000, 0x00008b501c000000, 0x000eff2832000000,
    0x0005ad3429000000, 0x000637ae3c800000, 0x0006512108c00000,
    0x00013943aea00000, 0x0004b40bd7b00000, 0x0000328b90580000,
    0x00098aaff7840000, 0x00057f6db5460000, 0x00036ceacee70000,
    0x0003572807d38000, 0x000b41343e4e4000, 0x0008a1ae3fe92000,
    0x000af0211bdd9000, 0x0009c8c3a0c41800, 0x00047dcbfaa75400,
    0x000fce6ba1b03600, 0x0000853fc75eeb00, 0x00009b25b8000080,
    0x000ee68edc0000c0, 0x000429ae120000e0, 0x00012c2119000070,
    0x000076c3848000c8, 0x000770cbd4c000a4, 0x000409ebbca000f2,
    0x00039dffceb00023, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x0009000000000000, 0x0005800000000000,
    0x0008c00000000000, 0x0005a00000000000, 0x000cd00000000000,
    0x0007880000000000, 0x0000240000000000, 0x0000760000000000,
    0x0005e10000000000, 0x000e318000000000, 0x000938c000000000,
    0x00025d2000000000, 0x00064ab000000000, 0x000f5a1800000000,
    0x0002f23400000000, 0x0009c7da00000000, 0x0007199100000000,
    0x00034cd480000000, 0x0007e246c0000000, 0x00026f8020000000,
    0x00052dc030000000, 0x000812a018000000, 0x000b777024000000,
    0x000360b816000000, 0x000c714423000000, 0x0008d96216800000,
    0x00066dd533400000, 0x000072369e200000, 0x00018653c0900000,
    0x0009f916a1d80000, 0x000bfde3e7840000, 0x000c9a8e80c60000,
    0x0001d317f0e30000, 0x00075674a7748000, 0x00017136ee2ac000,
    0x0007593805e86000, 0x0001ad840f88d000, 0x0009524221bf6800,
    0x0000166528b64400, 0x000311ae924b5200, 0x0002a8a7d8dd1b00,
    0x0007b5ec98000080, 0x00039fc2e40000c0, 0x000935c236000060,
    0x000ddfa513000090, 0x000ed50e8e800058, 0x0000eed7d740008c,
    0x000d6cd4a820005a, 0x0006f246d39000cd, 0x0008000000000000,
    0x000c000000000000, 0x0002000000000000, 0x0007000000000000,
    0x0001800000000000, 0x000cc00000000000, 0x0000e00000000000,
    0x000b100000000000, 0x0001a80000000000, 0x000f3c0000000000,
    0x0000b20000000000, 0x0006110000000000, 0x000b298000000000,
    0x00007c4000000000, 0x000b92e000000000, 0x000c613000000000,
    0x000d501800000000, 0x000e085c00000000, 0x000f0d8200000000,
    0x000b6a0500000000, 0x000f557f80000000, 0x0005ef8a40000000,
    0x0002f2e020000000, 0x0007b13030000000, 0x000e181808000000,
    0x000d245c1c000000, 0x000f978206000000, 0x000e870533000000,
    0x00042eff83800000, 0x000892ca6c400000, 0x0003e18026a00000,
    0x000490400cf00000, 0x000868e00ac80000, 0x00095c3004440000,
    0x0006e3982aa60000, 0x000b991c32f10000, 0x000fe4e22dcb8000,
    0x000a76751dc4c000, 0x00031607b3e06000, 0x0008c6a644d17000,
    0x000b8f9a1efe0800, 0x0008a35905ec1400, 0x0008397d99f3fe00,
    0x000dd5cf4a4f2900, 0x0006af7f83800080, 0x000bd28a6c4000c0,
    0x000ac16026a00020, 0x0009e0700cf00070, 0x000f91780ac80018,
    0x000be82c044400cc, 0x00029cfa2aa6000e, 0x0007822932f100b1,
    0x0008000000000000, 0x0004000000000000, 0x0006000000000000,
    0x0005000000000000, 0x000d800000000000, 0x0000400000000000,
    0x000e200000000000, 0x000e700000000000, 0x0009580000000000,
    0x000bdc0000000000, 0x0006ba0000000000, 0x000df10000000000,
    0x0008188000000000, 0x000e7cc000000000, 0x000d8aa000000000,
    0x000708b000000000, 0x000df48800000000, 0x000fbf0400000000,
    0x0005d66e00000000, 0x0000f31b00000000, 0x0005a43380000000,
    0x000c97f340000000, 0x000152a020000000, 0x000894b010000000,
    0x00036e8818000000, 0x00093e0414000000, 0x000916ee36000000,
    0x000513db01000000, 0x0000b493b8800000, 0x00081e4379c00000,
    0x000de6a805600000, 0x00028b743f700000, 0x000d884602e80000,
    0x000334af23c40000, 0x00095ed596620000, 0x000847ec78f30000,
    0x0009bafdaeaa8000, 0x0007715875e2c000, 0x0006d89baab22000,
    0x00089d87558c1000, 0x00001a6603b1b800, 0x000e40df31086c00,
    0x000f20fda072ce00, 0x0005f058676ccd00, 0x000c181bb8800080,
    0x00087d4779c00040, 0x00088ac605600060, 0x000a896f3f700050,
    0x000db4f582e800d8, 0x00019f9c63c40004, 0x000ba6d5b66200e2,
    0x0009abec68f300e7, 0x0008000000000000, 0x000c000000000000,
    0x0006000000000000, 0x000f000000000000, 0x000c800000000000,
    0x0007400000000000, 0x0000a00000000000, 0x000ff00000000000,
    0x0004580000000000, 0x000dec0000000000, 0x000fde0000000000,
    0x000e710000000000, 0x000a998000000000, 0x000f8cc000000000,
    0x00044fe000000000, 0x000eb89000000000, 0x000b3d6800000000,
    0x0006b6d400000000, 0x0003a51e00000000, 0x000c3a9b00000000,
    0x00026a9580000000, 0x0006428fc0000000, 0x000237e020000000,
    0x0008e49030000000, 0x000a9b6818000000, 0x00029bd43c000000,
    0x000e9a9e32000000, 0x00089b5b1d000000, 0x00079af582800000,
    0x000b1bdfffc00000, 0x000c5ae831600000, 0x000cfb1407b00000,
    0x00030b7e27780000, 0x000752cb05c40000, 0x000abe1d98660000,
    0x000561cbe3330000, 0x000b101633bf8000, 0x0001891f35224000,
    0x000e0483a595a000, 0x000a4a90d16b5000, 0x0004f2e3a3ec7800,
    0x000fcec0e42e6c00, 0x0009786b994c5600, 0x000adc84d4f93f00,
    0x0006e61d82800080, 0x00048dcbffc000c0, 0x0002ce1631600060,
    0x0000f81f07b000f0, 0x00081d03a77800c8, 0x00028650c5c40074,
    0x00001d03b866000a, 0x000e8650d33300ff, 0x0008000000000000,
    0x000c000000000000, 0x0002000000000000, 0x0001000000000000,
    0x0006800000000000, 0x0002400000000000, 0x000da00000000000,
    0x000c100000000000, 0x000d180000000000, 0x00017c0000000000,
    0x0000220000000000, 0x0007510000000000, 0x000a398000000000,
    0x000d2c4000000000, 0x00019a2000000000, 0x000cbdd000000000,
    0x000543c800000000, 0x0006a0f400000000, 0x0007902200000000,
    0x000bd93300000000, 0x000f9c4780000000, 0x0007136040000000,
    0x0004182020000000, 0x000bfcd030000000, 0x0000624808000000,
    0x000bf0b404000000, 0x0000a8021a000000, 0x000275e309000000,
    0x000d460fb6800000, 0x00008fd470400000, 0x000f0a2214600000,
    0x000de43335f00000, 0x000a9fc788880000, 0x000d122059440000,
    0x0009198012e60000, 0x000f7c400db10000, 0x0003222038e88000,
    0x0000d1d006b74000, 0x000ef9c83b6f2000, 0x0002cdf41673d000,
    0x00002ba228488800, 0x000db4730260cc00, 0x000927e7a2f71e00,
    0x0007fef06d0c8100, 0x0000e3c836800080, 0x0006b0f4304000c0,
    0x0008882234600020, 0x000ba53305f00010, 0x00093e4780880068,
    0x000202605d440024, 0x000381a008e600da, 0x000ac09004b100c1,
    0x0008000000000000, 0x0004000000000000, 0x000e000000000000,
    0x0009000000000000, 0x0001800000000000, 0x0001c00000000000,
    0x0003a00000000000, 0x0002900000000000, 0x0004380000000000,
    0x000d1c0000000000, 0x0006c60000000000, 0x000ad10000000000,
    0x0002588000000000, 0x00022dc000000000, 0x00096f2000000000,
    0x0002753000000000, 0x000842b800000000, 0x000d9ab400000000,
    0x000376f200000000, 0x000638f700000000, 0x000e1dfb80000000,
    0x0000467cc0000000, 0x0003912020000000, 0x0001b83010000000,
    0x0002dc3838000000, 0x000c667424000000, 0x0009c15206000000,
    0x0007a00707000000, 0x000c90638e800000, 0x000d39f8ca400000,
    0x000c9d6a30e00000, 0x0007067324700000, 0x00097131a3180000,
    0x0000c9ffcf440000, 0x00061509af620000, 0x0004738bdfb70000,
    0x0004b25bb33c8000, 0x0002928cf794c000, 0x000fc2b82feae000,
    0x00015ab4311ad000, 0x000f56f22643c800, 0x000c68f71ae7dc00,
    0x000805fba975ee00, 0x000e0a7cf09ef300, 0x0002cf200e800080,
    0x0004e5300a400040, 0x00027ab810e000e0, 0x000986b434700090,
    0x000430f21b180018, 0x000d29f72b44001c, 0x000fe57b8962003a,
    0x0000fbbcc8b70029, 0x0008000000000000, 0x0004000000000000,
    0x000e000000000000, 0x0009000000000000, 0x000c800000000000,
    0x000c400000000000, 0x000f600000000000, 0x000d900000000000,
    0x0003880000000000, 0x000e340000000000, 0x0001ae0000000000,
    0x0009f10000000000, 0x0001988000000000, 0x000a7dc000000000,
    0x00093b2000000000, 0x000a6e9000000000, 0x0005500800000000,
    0x0004a8ac00000000, 0x0002c55200000000, 0x0006b6c100000000,
    0x0008ccde80000000, 0x000242d1c0000000, 0x000d43a020000000,
    0x000cc35010000000, 0x0002032838000000, 0x0008223c24000000,
    0x0006535a32000000, 0x00040b6d31000000, 0x0006d70cbd800000,
    0x0004dcd0f6400000, 0x000f0adeae200000, 0x000957d1e8d00000,
    0x00031d201eb80000, 0x0009ab9013c40000, 0x000b66880c620000,
    0x000e246c3cf70000, 0x0006e6f22b6c8000, 0x000ae5912efa4000,
    0x000bc7f6a6e02000, 0x000114eddc32b000, 0x00095efa238d4800,
    0x0000e93d15cf0400, 0x0009a4a49be97a00, 0x0005272ce3384700,
    0x000244a485800080, 0x0000f72cd2400040, 0x0000aca49c2000e0,
    0x000a532cd9d00090, 0x000e0aa4a33800c8, 0x0001d62ce58400c4,
    0x00015c24a24200f6, 0x000fcaecd42700d9, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x0003000000000000,
    0x000b800000000000, 0x0003c00000000000, 0x0005600000000000,
    0x0008500000000000, 0x0006c80000000000, 0x00051c0000000000,
    0x00070a0000000000, 0x000eb10000000000, 0x0009588000000000,
    0x0008b5c000000000, 0x0009466000000000, 0x0004f27000000000,
    0x000135f800000000, 0x000387ec00000000, 0x000713aa00000000,
    0x0002244900000000, 0x00086eeb80000000, 0x000cfe9540000000,
    0x000ed6e020000000, 0x000d5bb010000000, 0x0001799838000000,
    0x000ac49c0c000000, 0x0004fed22e000000, 0x000ad6650f000000,
    0x00035b2195800000, 0x000278ac61400000, 0x000145f3bb200000,
    0x00073ec944700000, 0x000fb6d204280000, 0x000b0a6526c40000,
    0x0004b121b3620000, 0x000459ac61d70000, 0x00003573be998000,
    0x000107096d89c000, 0x000252b21277e000, 0x000c0515272fb000,
    0x000d1e598d46a800, 0x0004c68065252400, 0x000032398371ae00,
    0x0001d5f055a95500, 0x000b1741ad800080, 0x000f3bdc6d400040,
    0x000ca88b952000e0, 0x000ccce54b700030, 0x000f031811a800b8,
    0x00064c5c0784003c, 0x000e423228420056, 0x00066cd535a70085,
    0x0008000000000000, 0x0004000000000000, 0x0006000000000000,
    0x0003000000000000, 0x0006800000000000, 0x000d400000000000,
    0x0007e00000000000, 0x0007b00000000000, 0x000ee80000000000,
    0x000b1c0000000000, 0x000ad60000000000, 0x0005110000000000,
    0x000ab88000000000, 0x000444c000000000, 0x000c226000000000,
    0x00025bd000000000, 0x00083e2800000000, 0x000c0dbc00000000,
    0x00056ed600000000, 0x0004d4ad00000000, 0x000d5afb80000000,
    0x000cbf1ec0000000, 0x00044ce020000000, 0x00070e1010000000,
    0x0008a4c818000000, 0x000912ac0c000000, 0x0007f29e1a000000,
    0x0007c2c135000000, 0x0007ea059f800000, 0x0003d60fdec00000,
    0x000290cd9ba00000, 0x000479a3fc700000, 0x000b64d393580000,
    0x0007b2a2c8440000, 0x0001a23608e20000, 0x000d9abd38130000,
    0x00049e33ad098000, 0x000f5db2eeaf4000, 0x000ab67e3ed8a000,
    0x000c60d12786f000, 0x000b70cd82c35800, 0x0004c9a3f9a6b400,
    0x00050cd3b571ee00, 0x0002eea2fedb7b00, 0x000a143607800080,
    0x00027bbd12c00040, 0x00072eb3a1a00060, 0x0007b572d9700030,
    0x0002aa1e14d80068, 0x000036011a8400d4, 0x000320658942007e,
    0x000991dff163007b, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x000f000000000000, 0x0003800000000000,
    0x0007400000000000, 0x0009600000000000, 0x0007700000000000,
    0x0005a80000000000, 0x000ef40000000000, 0x0001ee0000000000,
    0x0003510000000000, 0x0006b88000000000, 0x0006acc000000000,
    0x000173e000000000, 0x0001eb7000000000, 0x000d576800000000,
    0x0008fc6c00000000, 0x000d4b4e00000000, 0x000c86e500000000,
    0x0001852680000000, 0x000047c9c0000000, 0x000ba56020000000,
    0x000856b010000000, 0x00067c0818000000, 0x00008bdc3c000000,
    0x000e27c60e000000, 0x000b55f91d000000, 0x000cbf00a5800000,
    0x000ee840ddc00000, 0x00059588b6a00000, 0x000f9e5cebd00000,
    0x000a792ebfb80000, 0x000c8c15e1440000, 0x000962a62ce20000,
    0x000c33492bb30000, 0x00058b08b64f8000, 0x0000a79cfb6dc000,
    0x0006944ea87da000, 0x000e1ea5c8e1b000, 0x000438ae39b53800,
    0x00096d95354f9400, 0x000ad24e9bee9a00, 0x0007bba5cc382700,
    0x00056e2e3d800080, 0x0003905521c00040, 0x000e992e98a00060,
    0x0007bc15e6d000f0, 0x00002aa602380038, 0x000df74900840074,
    0x000b2d0894420096, 0x000d329cdd630077, 0x0008000000000000,
    0x0004000000000000, 0x0002000000000000, 0x000b000000000000,
    0x000d800000000000, 0x0006400000000000, 0x000da00000000000,
    0x0009700000000000, 0x0008580000000000, 0x00018c0000000000,
    0x000b6a0000000000, 0x0005910000000000, 0x0007088000000000,
    0x000fe44000000000, 0x00099f6000000000, 0x000dc6b000000000,
    0x000a4b4800000000, 0x0008207400000000, 0x000b308e00000000,
    0x0007f99b00000000, 0x0003fc2980000000, 0x000eb3a140000000,
    0x00025de020000000, 0x0001c3f010000000, 0x000304a808000000,
    0x0006ce842c000000, 0x0003aea636000000, 0x0008be5f19000000,
    0x0000776fb6800000, 0x0006720e65c00000, 0x00003c2781600000,
    0x0001527a56300000, 0x00048ca985a80000, 0x000bebe16a440000,
    0x0007508002220000, 0x000a68401a910000, 0x0000f5602efd8000,
    0x000357b027dac000, 0x0000c3c808cd2000, 0x000184341a71d000,
    0x000f0fee168a3800, 0x00034f2b2a526c00, 0x0001ef619f1aa600,
    0x00071fd5552b8500, 0x0002076e3e800080, 0x0003ab6b09c00040,
    0x0007f00197600020, 0x000799655f3000b0, 0x00086c263b2800d8,
    0x0004bb1f23840064, 0x0009388fb54200da, 0x00089cfe55a10097,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x000f000000000000, 0x0002800000000000, 0x0001400000000000,
    0x0006a00000000000, 0x0009100000000000, 0x0000580000000000,
    0x000b540000000000, 0x000bba0000000000, 0x000a710000000000,
    0x000da98000000000, 0x00083dc000000000, 0x0007e7e000000000,
    0x000ee75000000000, 0x000f66a800000000, 0x0002a79400000000,
    0x000a478200000000, 0x000776fb00000000, 0x000f7fb280000000,
    0x0002d37b40000000, 0x000b2c6020000000, 0x000abf9030000000,
    0x000632c838000000, 0x00081c043c000000, 0x000db74a0a000000,
    0x00091fff05000000, 0x0000a3789a800000, 0x000a844464400000,
    0x000c8378a1600000, 0x000ed4445d500000, 0x00047b78b6e80000,
    0x0003904465c40000, 0x000d1978a4a60000, 0x0003f54469f70000,
    0x000daaf8971f8000, 0x0008a98456dd4000, 0x0007bc98b47aa000,
    0x000527144a8e5000, 0x000487d08e160800, 0x000316d0740fec00,
    0x000c0f7aac50ca00, 0x000efa7f426eed00, 0x000ed0aa22800080,
    0x0005b8af184000c0, 0x0005e5d08b6000e0, 0x000f73d0685000f0,
    0x0002bcfa94680028, 0x000aa6bf7d840014, 0x000646ca2fc6006a,
    0x0009763f01a70091, 0x0008000000000000, 0x000c000000000000,
    0x000e000000000000, 0x0001000000000000, 0x0004800000000000,
    0x000ac00000000000, 0x0008e00000000000, 0x000e500000000000,
    0x0004e80000000000, 0x00097c0000000000, 0x000e560000000000,
    0x0003e90000000000, 0x0000fd8000000000, 0x000e17c000000000,
    0x0000c92000000000, 0x0002cd1000000000, 0x000e6e9800000000,
    0x0005bc3c00000000, 0x000bb6da00000000, 0x0007390500000000,
    0x000fd59380000000, 0x000b0b50c0000000, 0x000a0e9820000000,
    0x000d2c3c30000000, 0x0009beda38000000, 0x0001150504000000,
    0x0001eb9392000000, 0x000b5e50eb000000, 0x000c451803800000,
    0x000e82fc09400000, 0x000d627a2ba00000, 0x0004b3d521f00000,
    0x00011a2bab580000, 0x000fc67ce4a40000, 0x000960da00760000,
    0x00021005311f0000, 0x0009c813a8848000, 0x000a4c90eac44000,
    0x000aafb832e26000, 0x000c5d2c0254f000, 0x0001664236ad6800,
    0x0009103919fb1400, 0x000e48c9bdd2ce00, 0x000b0c95e9e90300,
    0x000d0fabab580080, 0x0004adbce4a400c0, 0x0009fffa007600e0,
    0x00023415311f0010, 0x0003db0ba8848048, 0x000b276ceac440ac,
    0x0009304232e2608e, 0x0007f9390254f0e5, 0x0008000000000000,
    0x000c000000000000, 0x0006000000000000, 0x000d000000000000,
    0x000c800000000000, 0x0000400000000000, 0x0000a00000000000,
    0x0001b00000000000, 0x000eb80000000000, 0x0005740000000000,
    0x0000fe0000000000, 0x0006390000000000, 0x000f358000000000,
    0x000b5ec000000000, 0x000608a000000000, 0x000d4c1000000000,
    0x000ecac800000000, 0x0007e6b400000000, 0x00047d2600000000,
    0x000a329f00000000, 0x000932da80000000, 0x0004b299c0000000,
    0x000e72c820000000, 0x000392b430000000, 0x000e032618000000,
    0x00014b9f34000000, 0x000a275ab2000000, 0x000e1c59c1000000,
    0x0006626822800000, 0x000a1aa436c00000, 0x000e8fee22e00000,
    0x0005e02b21d00000, 0x000191fcb1f80000, 0x00094906d9e40000,
    0x00066d929e560000, 0x0008baeddbbb0000, 0x00083f4e1ac28000,
    0x000cd83b24e04000, 0x0005253492d32000, 0x0005d6b2f27ed000,
    0x00010534bda29800, 0x000826b2f2717c00, 0x00091d34bc89ea00,
    0x0001e2b2f0ea2700, 0x000bdb34b1f80080, 0x0002efb2d9e400c0,
    0x0004b0b49e560060, 0x000e3872dbbb00d0, 0x000335949ac280c8,
    0x000d5ea2e4e04004, 0x000b09fcb2d3200a, 0x0001cd06c27ed01b,
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x0001000000000000, 0x000b800000000000, 0x0009400000000000,
    0x0001200000000000, 0x000dd00000000000, 0x0008680000000000,
    0x000e040000000000, 0x000d2a0000000000, 0x000b290000000000,
    0x000a248000000000, 0x00097a4000000000, 0x000b012000000000,
    0x000e81f000000000, 0x0000c16800000000, 0x0009600400000000,
    0x000770ca00000000, 0x000cf82500000000, 0x00074de480000000,
    0x000efe1f40000000, 0x000e6b6820000000, 0x000f090410000000,
    0x000e744a08000000, 0x0009526504000000, 0x000fa4c4ae000000,
    0x00073bef65000000, 0x0002a00024800000, 0x0000900027400000,
    0x000b480029a00000, 0x0002d4003c100000, 0x000ec2001aa80000,
    0x000c6d0009a40000, 0x00062e802c120000, 0x000f834012a90000,
    0x00094da00da48000, 0x0009ffb00217c000, 0x0006ea4837ada000,
    0x000cc8f409241000, 0x000d952235512800, 0x000ce26116099400,
    0x000b3c0eb1331200, 0x000c87ca41ffbd00, 0x0009e7e49aa80080,
    0x0008971f49a40040, 0x00076fe80c120020, 0x000aa34402a90010,
    0x00069d6a05a480b8, 0x000097950617c094, 0x00036fac99ada012,
    0x0008a2eb6c2410dd, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x0003000000000000, 0x000f800000000000,
    0x0007400000000000, 0x0006600000000000, 0x0001300000000000,
    0x0009b80000000000, 0x0008a40000000000, 0x000f620000000000,
    0x0005f90000000000, 0x0005448000000000, 0x000f12c000000000,
    0x0009216000000000, 0x0003517000000000, 0x000e882800000000,
    0x00021cac00000000, 0x000847d600000000, 0x000ddadf00000000,
    0x0006dc5880000000, 0x000b678a40000000, 0x000f8a2820000000,
    0x0002d5ac10000000, 0x0002bb5618000000, 0x00096c1f0c000000,
    0x000f1f38be000000, 0x000a8ffa5d000000, 0x0002268039800000,
    0x000eebc014c00000, 0x000a65e03ee00000, 0x000f43b02e900000,
    0x0008294803880000, 0x00060ddc0ae40000, 0x0000affe0c920000,
    0x000ef673388b0000, 0x0007238e82658000, 0x000e19556fd5c000,
    0x00063470a7a8a000, 0x000c4b264f96b000, 0x000875fe0c0d5800,
    0x0004ab7317207c00, 0x0004850e99f4e200, 0x0000b29571dbe900,
    0x0003b19083880080, 0x000678964ae40040, 0x000004b62c920060,
    0x000c72af288b0030, 0x000490f09a6580f8, 0x000229e663d5c074,
    0x00070c9e19a8a066, 0x000a2e031296b013, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x0005000000000000,
    0x0002800000000000, 0x000dc00000000000, 0x0002200000000000,
    0x0002700000000000, 0x000ed80000000000, 0x000a7c0000000000,
    0x000bf20000000000, 0x0000990000000000, 0x00051d8000000000,
    0x000d63c000000000, 0x000991a000000000, 0x000c89d000000000,
    0x000dd47800000000, 0x0008d6e400000000, 0x000e571e00000000,
    0x000196e300000000, 0x0008b64b80000000, 0x000d46d040000000,
    0x000cde7820000000, 0x000943e430000000, 0x0002e09e38000000,
    0x000ed02314000000, 0x000f686b8a000000, 0x000385c077000000,
    0x00017e2028800000, 0x0008731039c00000, 0x000dd85803600000,
    0x0001fcf43df00000, 0x000ab2c625c80000, 0x000a79d735640000,
    0x0007cd2d9cf60000, 0x000c0ad77c4f0000, 0x000f152dbd268000,
    0x000f76d76bd74000, 0x0008672d8099e000, 0x00072fd7453f9000,
    0x000ddaadbf2a7800, 0x0005fc1760d48c00, 0x0008b30d9e1fae00,
    0x000179c75dfc0100, 0x00004d75a5c80080, 0x00034a23756400c0,
    0x0000f5ebbcf600e0, 0x000f26004c4f0050, 0x0004cf8005268028,
    0x00038ac03fd740dc, 0x000c54202a99e022, 0x000e9610023f9027,
    0x0008000000000000, 0x0004000000000000, 0x000e000000000000,
    0x0001000000000000, 0x0000800000000000, 0x0008c00000000000,
    0x0005e00000000000, 0x0001b00000000000, 0x000da80000000000,
    0x00062c0000000000, 0x000cc60000000000, 0x0002e90000000000,
    0x000e8c8000000000, 0x000ed7c000000000, 0x0002d12000000000,
    0x0001d89000000000, 0x0000e4d800000000, 0x00029a9c00000000,
    0x0006e72600000000, 0x0003392d00000000, 0x0004d53980000000,
    0x0009724ec0000000, 0x000cead820000000, 0x000b2f9c10000000,
    0x0002e5a638000000, 0x00099bed04000000, 0x0009669982000000,
    0x000a781ee3000000, 0x000975a037800000, 0x0005e35016c00000,
    0x000513f80ea00000, 0x00011b0c1cb00000, 0x0005a77e31180000,
    0x0001987128a40000, 0x0009c53fadb20000, 0x0008caf3fd9f0000,
    0x000bffb99de48000, 0x00083c8ecfd24000, 0x0006ff78288b6000,
    0x0002bccc15ce7000, 0x00013e5e1bae9800, 0x0006dce110bbb400,
    0x0008cfe78d906600, 0x0006556fc76b7b00, 0x000ab21fb1180080,
    0x00068b63e8a40040, 0x0003dfe18db200e0, 0x0002edd2ed9f0010,
    0x0003277e25e48008, 0x000c58710bd2408c, 0x0002a53f8a8b605e,
    0x0000baf3e6ce701b, 0x0008000000000000, 0x0004000000000000,
    0x000e000000000000, 0x0003000000000000, 0x0006800000000000,
    0x0005c00000000000, 0x0005600000000000, 0x0008700000000000,
    0x000a380000000000, 0x00022c0000000000, 0x00030a0000000000,
    0x0009590000000000, 0x000d5c8000000000, 0x0001b3c000000000,
    0x000db56000000000, 0x000db65000000000, 0x00055a7800000000,
    0x000fb14c00000000, 0x0006589e00000000, 0x0001dc5f00000000,
    0x0009725980000000, 0x000d540740000000, 0x000686f820000000,
    0x000fc28c10000000, 0x00008dfe38000000, 0x00071a0f0c000000,
    0x000090219a000000, 0x0005094b57000000, 0x0006b46635800000,
    0x000f37d331c00000, 0x000e9b2790e00000, 0x0009d1c844b00000,
    0x0008a9b9b6280000, 0x000e249762640000, 0x000e3f6038f20000,
    0x00062f503b0f0000, 0x0005e6f83c358000, 0x0000b28c25694000,
    0x000235fe16c1e000, 0x0003f60f2d613000, 0x00007a2191707800,
    0x0001e04b68ce7c00, 0x0004b0e617d4e600, 0x0004d8133e5d5d00,
    0x000a1c478e280080, 0x000f12986e640040, 0x0003a541a2f200e0,
    0x00097f1b6c0f0030, 0x00088e1e09b58068, 0x000bf69f14a9405c,
    0x00047bb98621e056, 0x000fe19769d13087, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x0003000000000000,
    0x0004800000000000, 0x0006400000000000, 0x000b600000000000,
    0x0001900000000000, 0x000d680000000000, 0x00036c0000000000,
    0x0004020000000000, 0x000d090000000000, 0x000a7d8000000000,
    0x00012bc000000000, 0x0006056000000000, 0x000b6f1000000000,
    0x00070a0800000000, 0x0004758c00000000, 0x000fd6e200000000,
    0x00016fc500000000, 0x00060b7180000000, 0x000df5aa40000000,
    0x000e178820000000, 0x0008ce4c30000000, 0x000abb8238000000,
    0x000a6cd50c000000, 0x0001837992000000, 0x0002c92659000000,
    0x0000dcea0d800000, 0x00091a4936400000, 0x0007dd938da00000,
    0x000f9a6f41b00000, 0x000c9cf9a2080000, 0x00037be65d240000,
    0x000fcc0a1c760000, 0x000332993eef0000, 0x000650fb87b58000,
    0x000bc9f3750c4000, 0x00055d9393a02000, 0x0006da6f4ab23000,
    0x000d7cf9968d8800, 0x0007abe676e01400, 0x000d440a2f904600,
    0x00078e9906fee900, 0x00045afb9a080080, 0x00043cf3512400c0,
    0x00064a138e7600e0, 0x000994af67ef0030, 0x000506198a358048,
    0x0000e636434c4064, 0x000636e21e0020b6, 0x0009bfc50b023019,
    0x0008000000000000, 0x0004000000000000, 0x0006000000000000,
    0x0005000000000000, 0x0006800000000000, 0x0007400000000000,
    0x000ee00000000000, 0x000c900000000000, 0x0008a80000000000,
    0x0002740000000000, 0x000ff60000000000, 0x0008c90000000000,
    0x000da48000000000, 0x000fbec000000000, 0x00032da000000000,
    0x000c7a5000000000, 0x0002432800000000, 0x000f9efc00000000,
    0x00079c0200000000, 0x0004631d00000000, 0x000e2e2280000000,
    0x00090574c0000000, 0x000f4fa820000000, 0x0006543c10000000,
    0x000d47a218000000, 0x0005d04d14000000, 0x0007498a9a000000,
    0x000e6548dd000000, 0x00051e0a1b800000, 0x0002dd7122400000,
    0x000982a8baa00000, 0x00013fc5ddd00000, 0x00006c2085d80000,
    0x00049b69ee240000, 0x000bd30ab5120000, 0x0001b688c8bb0000,
    0x0002a92a0c168000, 0x000574e121394000, 0x000a76a08f54a000,
    0x000c08a9e61ff000, 0x0002842a8bc20800, 0x000a8f18d9e77400,
    0x0009f5222af60a00, 0x000a378d09489300, 0x000768aa9dd80080,
    0x000ad5d8fa240040, 0x000d06822f120060, 0x000eb0dd15bb0050,
    0x000f190297968068, 0x0009ece4c3794074, 0x00025ba015f4a0ee,
    0x0007f3502bcff0c9, 0x0008000000000000, 0x000c000000000000,
    0x000a000000000000, 0x0003000000000000, 0x000e800000000000,
    0x000e400000000000, 0x0001a00000000000, 0x0001100000000000,
    0x0005380000000000, 0x000b8c0000000000, 0x00080e0000000000,
    0x000d190000000000, 0x000c5d8000000000, 0x000bd74000000000,
    0x000ba56000000000, 0x0000ba5000000000, 0x00079b8800000000,
    0x0004cad400000000, 0x000a523200000000, 0x0003cecf00000000,
    0x0000793580000000, 0x0008ad9bc0000000, 0x000d5e0820000000,
    0x000a819430000000, 0x0008415228000000, 0x0008a19f0c000000,
    0x000c913dba000000, 0x0005f90ff9000000, 0x00046cda26800000,
    0x0008be4b34400000, 0x0009308fbce00000, 0x0002e980e2300000,
    0x0008550fba380000, 0x000eb2c0fd640000, 0x0001fe6fbff60000,
    0x00001190d71d0000, 0x0004b86788758000, 0x00014c04e9d94000,
    0x0004ef358ad62000, 0x0003289be60f5000, 0x00063588385ec800,
    0x0004c3d40f163c00, 0x000937b20f295600, 0x0000958f0b4b2f00,
    0x000d525592380080, 0x000b4ecbf16400c0, 0x0007380005f600a0,
    0x00048c002e1d0030, 0x000c8e002ef580e8, 0x000059001d9940e4,
    0x00037d801636201a, 0x00048740343f5011, 0x0008000000000000,
    0x000c000000000000, 0x0006000000000000, 0x0005000000000000,
    0x000e800000000000, 0x0005400000000000, 0x000be00000000000,
    0x0001b00000000000, 0x0007f80000000000, 0x000a9c0000000000,
    0x000bf60000000000, 0x0003d90000000000, 0x000f8d8000000000,
    0x00055ec000000000, 0x00048da000000000, 0x0002de5000000000,
    0x00094d6800000000, 0x00097e5c00000000, 0x000d9c2600000000,
    0x000a777700000000, 0x000b183f80000000, 0x000aacc0c0000000,
    0x0004cee820000000, 0x000c659c30000000, 0x0005ea0618000000,
    0x000e6ee714000000, 0x000c3577ba000000, 0x0000a20cd5000000,
    0x00088a060f800000, 0x00069ee736c00000, 0x00062d7787e00000,
    0x000e8e0cfe700000, 0x000a040635d80000, 0x000a9be72a640000,
    0x0009b6f789b60000, 0x0009b9ccc7bb0000, 0x0006fc2617d68000,
    0x0007877704094000, 0x000f803fbd6da000, 0x0001c0c0f85d7000,
    0x000da0e80da69800, 0x0001d09c33d6dc00, 0x000d8986260e7e00,
    0x0003c5273c6e4300, 0x000b3b57add80080, 0x000e679cfe6400c0,
    0x0001314e13b60060, 0x000bb92b22bb0050, 0x0009fc19805680e8,
    0x000a07b7e6c94054, 0x000140d7a08da0be, 0x0001e05ce32d701b,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x000f000000000000, 0x0004800000000000, 0x0001400000000000,
    0x0002a00000000000, 0x0004700000000000, 0x0001e80000000000,
    0x000f040000000000, 0x0009620000000000, 0x0000890000000000,
    0x000b958000000000, 0x0004dbc000000000, 0x000454e000000000,
    0x000a3b1000000000, 0x000704e800000000, 0x0005623400000000,
    0x000e88de00000000, 0x0004947500000000, 0x00005ae480000000,
    0x0005156a40000000, 0x00089b6820000000, 0x000374f430000000,
    0x00048bbe38000000, 0x00018da53c000000, 0x000df76c92000000,
    0x0000d38e45000000, 0x000e81be2a800000, 0x000c40a521c00000,
    0x000720ecbfa00000, 0x000eb14e40100000, 0x000688de17880000,
    0x0008947537240000, 0x000e5ae49cd60000, 0x000a156a7eaf0000,
    0x000c1b6824f38000, 0x000234f421fc4000, 0x00062bbe0b1ba000,
    0x0005fda53a6cd000, 0x000c1f6c81d57800, 0x000fd78e782ed400,
    0x0007e3be1f301200, 0x000cc9a51f5de900, 0x000cb56caf880080,
    0x000a6a8e4b2400c0, 0x0002dc3e2ed600e0, 0x0002af650baf00f0,
    0x00095e0cb6738048, 0x000f775e7c3c4014, 0x000293b606bba02a,
    0x0006a0810f7cd047, 0x0008000000000000, 0x000c000000000000,
    0x000a000000000000, 0x000d000000000000, 0x0007800000000000,
    0x000e400000000000, 0x0004200000000000, 0x0005d00000000000,
    0x000e580000000000, 0x000d8c0000000000, 0x0001be0000000000,
    0x0000b90000000000, 0x000ebd8000000000, 0x0000d74000000000,
    0x00065ca000000000, 0x0004e77000000000, 0x000db58800000000,
    0x000bc2a400000000, 0x000d8e0a00000000, 0x0007512300000000,
    0x000b990580000000, 0x000deda5c0000000, 0x000d4e0820000000,
    0x000cb0e430000000, 0x0003292a28000000, 0x0008c41334000000,
    0x00028bad9e000000, 0x0004ba31f9000000, 0x000e52aa30800000,
    0x000cf65327400000, 0x000f8c8d91600000, 0x0000bf01c2300000,
    0x000d380238f80000, 0x000dfdc70be40000, 0x0003762f82760000,
    0x000dccb6e01d0000, 0x000e9e259e128000, 0x0005e895ecadc000,
    0x000424a028ae2000, 0x0000bb703eae9000, 0x0008538803ae2800,
    0x000bf7a425298c00, 0x00050d8a3f6e9600, 0x00097f63088f5700,
    0x0007582590f80080, 0x000c0d95ffe400c0, 0x0008ff203c7600a0,
    0x000e1930291d00d0, 0x0002aca806928078, 0x0004ee943fedc0e4,
    0x000a212207ce2042, 0x000ed1f7359e905d, 0x0008000000000000,
    0x0004000000000000, 0x0002000000000000, 0x000f000000000000,
    0x0008800000000000, 0x000ac00000000000, 0x000fe00000000000,
    0x000bf00000000000, 0x0002180000000000, 0x0002c40000000000,
    0x0008620000000000, 0x0005e90000000000, 0x0006dc8000000000,
    0x0007a64000000000, 0x000a0ae000000000, 0x0001749000000000,
    0x00045b9800000000, 0x0009bd5c00000000, 0x0002970e00000000,
    0x0005f34b00000000, 0x0007409c80000000, 0x0006a05e40000000,
    0x0004517820000000, 0x0003c9cc10000000, 0x000c4c9608000000,
    0x00098e173c000000, 0x0002b792a2000000, 0x000263156b000000,
    0x000ee9e49f800000, 0x000c5d927fc00000, 0x000267ee20600000,
    0x000d6adb27100000, 0x000045848b880000, 0x0009a24240a40000,
    0x0000881626f20000, 0x0008ec570a590000, 0x0002df7297cb8000,
    0x0009fe855d024000, 0x0004eefcba866000, 0x0008868e41417000,
    0x00051a0027263800, 0x00021d001d302c00, 0x000146800c3bf200,
    0x00047b401dda3900, 0x000e2c6014080080, 0x000b3fd03f640040,
    0x000f0ff806920020, 0x0001768c2d4900f0, 0x000802f61c438088,
    0x000858c71da640ac, 0x0003e4ea9c7460fe, 0x000e73d94b1870bf,
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x000f000000000000, 0x000b800000000000, 0x0001c00000000000,
    0x0002a00000000000, 0x000c700000000000, 0x0002580000000000,
    0x0004940000000000, 0x000c960000000000, 0x000f290000000000,
    0x00044c8000000000, 0x000f424000000000, 0x00045ee000000000,
    0x000ff4f000000000, 0x000646f800000000, 0x000300f400000000,
    0x000d819e00000000, 0x000cc14300000000, 0x0006211e80000000,
    0x00063138c0000000, 0x0001381820000000, 0x000a440410000000,
    0x0002bf6608000000, 0x0009e5b73c000000, 0x000c4e80ae000000,
    0x000cfd7bc7000000, 0x000f3b86aa800000, 0x0004fa7ce1c00000,
    0x000d5b1e21600000, 0x0008aa033e500000, 0x0004337e94580000,
    0x00098788c7a40000, 0x0008a00015b20000, 0x000770001bc90000,
    0x000bd8001a9b8000, 0x000a54002043c000, 0x0005b6000c23e000,
    0x0002990025f7d000, 0x0004b4801fec7800, 0x0007a64003680c00,
    0x000a90e011adfa00, 0x000449f0084e2300, 0x000e9c783ed80080,
    0x00036bb426640040, 0x000d93fe34d20020, 0x000c77f3259900f0,
    0x000439068ec380b8, 0x000ac53ce7e7c01c, 0x000aff7e1991e02a,
    0x000585b33e3ed0c7, 0x0008000000000000, 0x000c000000000000,
    0x000e000000000000, 0x000d000000000000, 0x0007800000000000,
    0x0009c00000000000, 0x0002a00000000000, 0x0009500000000000,
    0x0002080000000000, 0x000b940000000000, 0x00027e0000000000,
    0x000b990000000000, 0x000ebd8000000000, 0x000a7bc000000000,
    0x0003cea000000000, 0x0009a07000000000, 0x000fd17800000000,
    0x0002483400000000, 0x000df47a00000000, 0x000e0f8900000000,
    0x0009011e80000000, 0x000580b1c0000000, 0x000ac1d820000000,
    0x0008214430000000, 0x0007108238000000, 0x0009687d34000000,
    0x000065c49e000000, 0x00092648e7000000, 0x0002043eaa800000,
    0x00075601d5400000, 0x00039d8010200000, 0x0006ebc02a500000,
    0x000d66a02ff80000, 0x000664703d640000, 0x000827782e760000,
    0x000b85342baf0000, 0x000397fa0d9a8000, 0x0006bd492d91c000,
    0x00067a3ebe9de000, 0x000dcf01c914d000, 0x0004a00024dfe800,
    0x000850000fb52400, 0x000b880029c8fa00, 0x000f54002d6c0700,
    0x00075e0005780080, 0x000b0900282400c0, 0x000e15801e5600e0,
    0x0008bfc031ff00d0, 0x0003b8a01a628078, 0x0009ad7024f5c09c,
    0x000312f80eebe02a, 0x0003aaf405bbd095, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x000b000000000000,
    0x000b800000000000, 0x0003400000000000, 0x000ca00000000000,
    0x0005900000000000, 0x0008a80000000000, 0x00081c0000000000,
    0x00058e0000000000, 0x0003790000000000, 0x0000958000000000,
    0x000ec3c000000000, 0x000abe6000000000, 0x000941f000000000,
    0x0005a02800000000, 0x000b113400000000, 0x000b68a200000000,
    0x000c7c0d00000000, 0x000ffeff80000000, 0x0002e097c0000000,
    0x0005b04820000000, 0x000bf9c430000000, 0x0004550a38000000,
    0x000f22f92c000000, 0x00088e3dae000000, 0x000ff86acd000000,
    0x0006551f92800000, 0x000a22a7e6400000, 0x00080e003aa00000,
    0x000739003c700000, 0x0009b58000380000, 0x000313c02ce40000,
    0x000536601ed60000, 0x00078df0204f0000, 0x000426283ad98000,
    0x0005e4341337c000, 0x0006db222218a000, 0x0009dacd01d0d000,
    0x00005b1fb9cc8800, 0x00061ba7c71b3400, 0x000a3b8037547e00,
    0x00076ac0258a9f00, 0x000023e012b80080, 0x00010e300aa400c0,
    0x0009b848047600e0, 0x000a75c42c3f00b0, 0x0007730a02e180b8,
    0x000f47f913d3c034, 0x000615bd92cea0ca, 0x000102aaec9fd059,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x000f000000000000, 0x0009800000000000, 0x0006c00000000000,
    0x000aa00000000000, 0x000cb00000000000, 0x000dc80000000000,
    0x0001840000000000, 0x000ece0000000000, 0x0009390000000000,
    0x0005ad8000000000, 0x00019bc000000000, 0x00032ee000000000,
    0x0005e9b000000000, 0x0000749800000000, 0x000e677400000000,
    0x00082c4600000000, 0x00055bd100000000, 0x00088f7c80000000,
    0x000fd87bc0000000, 0x0002fc7820000000, 0x000383c430000000,
    0x0000f35e38000000, 0x000d1a653c000000, 0x00016e5aa6000000,
    0x000108dadb000000, 0x000624fc8a800000, 0x000afebbc2c00000,
    0x0004b1182f200000, 0x0001c8b40a100000, 0x000f84a625380000,
    0x0001cf6103e40000, 0x0000b8649a360000, 0x00036dcfefaf0000,
    0x000b3b5e311b8000, 0x000f9e651376c000, 0x0008205ab5ca6000,
    0x0001f1dae769d000, 0x0000a97c8b3f1800, 0x0001157bdce44400,
    0x0000f7f80ab07200, 0x0009150410682f00, 0x000cf63e2fb80080,
    0x00071515012400c0, 0x0003f7a2951600e0, 0x000e94ded5bf00f0,
    0x00053742ac238098, 0x0004346eec92c06c, 0x0009865aa9fc60aa,
    0x0009fcdae3c6d0cb, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x0003000000000000, 0x000e800000000000,
    0x0006400000000000, 0x0002a00000000000, 0x0009b00000000000,
    0x0000580000000000, 0x0002fc0000000000, 0x00018a0000000000,
    0x000d490000000000, 0x0006158000000000, 0x000cae4000000000,
    0x0005ff6000000000, 0x0000b75000000000, 0x000aa20800000000,
    0x00040cf400000000, 0x0002f34600000000, 0x000cc43300000000,
    0x000026f380000000, 0x00068b0b40000000, 0x000dc8e820000000,
    0x000155e430000000, 0x00038e2e08000000, 0x00048f970c000000,
    0x00040fbdba000000, 0x00034fcc59000000, 0x000c6f5daa800000,
    0x000d1fdc56c00000, 0x0009a7b5a9600000, 0x00004a3877f00000,
    0x0008299b94280000, 0x0007c5af50240000, 0x0002a62600d60000,
    0x0002ca6331790000, 0x000c697bae1d8000, 0x000665bf7aed4000,
    0x000596ce3d402000, 0x0004d3872127d000, 0x000c355596531800,
    0x000e5f2855bdcc00, 0x000886f392784e00, 0x00003b0b7d9c6d00,
    0x000110e836a80080, 0x0006e9e40ae400c0, 0x000e242e13b60020,
    0x000636971f890030, 0x0000e23d90b580e8, 0x0004ad8c7c094064,
    0x0008423d94f6202a, 0x00021d8c67aed09b, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x0005000000000000,
    0x000d800000000000, 0x0002c00000000000, 0x000a200000000000,
    0x0006500000000000, 0x000e480000000000, 0x000a8c0000000000,
    0x000d2e0000000000, 0x0002b90000000000, 0x0009d48000000000,
    0x000f0bc000000000, 0x000c6ba000000000, 0x0003da3000000000,
    0x0002621800000000, 0x000737a400000000, 0x00097d9a00000000,
    0x0008f7c100000000, 0x000add9d80000000, 0x000267e3c0000000,
    0x000bb53820000000, 0x00033a5410000000, 0x000a122238000000,
    0x00012f5514000000, 0x0008b89fb6000000, 0x0002d546cb000000,
    0x00078a1f88800000, 0x00032b86c9400000, 0x000b3b3fa1200000,
    0x000e1376ee300000, 0x000f2e079ab80000, 0x000db922c5e40000,
    0x000f5425a1d20000, 0x00054a77ea6f0000, 0x00090aba0e0e8000,
    0x000d6a313318c000, 0x00005a25a2906000, 0x0005a377fa4a9000,
    0x0000963a31bc6800, 0x000dedf13d640400, 0x000c9f85a092f600,
    0x00060047d74c4f00, 0x000100a22a380080, 0x0003819518a40040,
    0x0007c1bfb6f200e0, 0x0007a1b6cf5f0050, 0x000491279c3680d8,
    0x000468d2ffbcc02c, 0x000cdd9d826260a2, 0x000367e3ee159065,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x0005000000000000, 0x000c800000000000, 0x0001400000000000,
    0x0008200000000000, 0x000c100000000000, 0x0001480000000000,
    0x0008dc0000000000, 0x00061a0000000000, 0x000e390000000000,
    0x0004a58000000000, 0x000d1e4000000000, 0x0005f7a000000000,
    0x0000fb1000000000, 0x000cc8e800000000, 0x000b1c6400000000,
    0x00087af200000000, 0x0003883100000000, 0x00043c2780000000,
    0x000dea2d40000000, 0x000f00c820000000, 0x0005803430000000,
    0x000fc03a08000000, 0x000c610514000000, 0x0008b19db2000000,
    0x000c196845000000, 0x0001b4f580800000, 0x0002d74c40400000,
    0x00096ba7ad200000, 0x0002416d47700000, 0x000fa0e802680000,
    0x0006d06419e40000, 0x0001a8f208160000, 0x00012d3115390000,
    0x000223a7807e8000, 0x00039d6d55dc4000, 0x00073ae82eeba000,
    0x000ca96437a59000, 0x0001ad722635c800, 0x0001637135cdc400,
    0x000ebc07bfd01e00, 0x0007aa7d7dd9f500, 0x000ca0000ae80080,
    0x000150000da400c0, 0x000b680037360020, 0x0001cc0027490050,
    0x000bd2000a9680c8, 0x0007a50018784014, 0x000a9f8039dda082,
    0x000f374020ec90c1, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x0005000000000000, 0x0005800000000000,
    0x0003c00000000000, 0x000e200000000000, 0x0004d00000000000,
    0x000cd80000000000, 0x000adc0000000000, 0x0008ae0000000000,
    0x0006690000000000, 0x0004358000000000, 0x0006da4000000000,
    0x000f53a000000000, 0x0004963000000000, 0x000fc4b800000000,
    0x000552a400000000, 0x000d97ca00000000, 0x0008457300000000,
    0x0003939780000000, 0x000637d3c0000000, 0x000f549820000000,
    0x00016bd430000000, 0x00083b5208000000, 0x000b22a714000000,
    0x000ddec596000000, 0x0004a074cf000000, 0x000b91dd98800000,
    0x0006b8e0e3400000, 0x0006ecaf9b600000, 0x000b0637cf700000,
    0x00077d721cb80000, 0x0004bed732a40000, 0x000611ddb6560000,
    0x000978e0d3290000, 0x000accaf80ae8000, 0x000ad637d568c000,
    0x000e25723e4ae000, 0x000da2d710de9000, 0x00009fdda9512800,
    0x000bc1e0d3a8cc00, 0x0002212f8feede00, 0x0006d077e40a8f00,
    0x0009d8d20c380080, 0x000f5de705e400c0, 0x000b6ee59b360020,
    0x00084904e3590050, 0x0000e5458c968058, 0x000a0334d08cc03c,
    0x00058ffda57ce0e2, 0x000c3890f387904d, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x0009000000000000,
    0x0005800000000000, 0x000d400000000000, 0x000ee00000000000,
    0x000ab00000000000, 0x0001b80000000000, 0x0004a40000000000,
    0x0003fa0000000000, 0x000ca50000000000, 0x0007fa8000000000,
    0x000aa5c000000000, 0x000efba000000000, 0x000f257000000000,
    0x0003ba0800000000, 0x0001c4ac00000000, 0x00090b5e00000000,
    0x00007c9b00000000, 0x000dafca80000000, 0x000386e440000000,
    0x00010b5e20000000, 0x00047c9b10000000, 0x000bafca98000000,
    0x000a86e464000000, 0x00048b5e36000000, 0x00093c9b25000000,
    0x00054fcaa3800000, 0x000036e44ec00000, 0x0005335e30e00000,
    0x000d989b37900000, 0x0006b5caac680000, 0x000c93e47c540000,
    0x0002c9de2f0a0000, 0x00073d5b1d070000, 0x00084e6a97868000,
    0x0003b69440c1c000, 0x000173d621e22000, 0x0006f9f71a15b000,
    0x00014534b3abf800, 0x0003ca0f4133ac00, 0x000cdc1c975d0a00,
    0x00057f13540e2100, 0x00004e6a97868080, 0x0007b69440c1c040,
    0x000773d621e22060, 0x000ff9f71a15b090, 0x0004c534b3abf858,
    0x000e8a0f4133acd4, 0x00023c1c975d0aee, 0x000fcf13540e21ab,
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x0001000000000000, 0x0005800000000000, 0x0009c00000000000,
    0x000e200000000000, 0x0008b00000000000, 0x0005280000000000,
    0x00056c0000000000, 0x0004a60000000000, 0x000b6d0000000000,
    0x0003a68000000000, 0x000ded4000000000, 0x000ee6a000000000,
    0x000f8df000000000, 0x0001b79800000000, 0x000c343400000000,
    0x0009428e00000000, 0x0008d69100000000, 0x0003e52380000000,
    0x0004bb85c0000000, 0x0006c28e20000000, 0x0004169110000000,
    0x000a452388000000, 0x0004cb85c4000000, 0x00084a8e36000000,
    0x00000a9137000000, 0x0005eb23b0800000, 0x00027a85e6c00000,
    0x000a620e22a00000, 0x0003e6d122b00000, 0x000c0d03a2180000,
    0x000b7735cb740000, 0x000695b62c3a0000, 0x000db25515050000,
    0x000a1eb599828000, 0x00001860f543c000, 0x000d8583aae46000,
    0x000deb75e5d5d000, 0x00067b961c88b800, 0x000863e506198400,
    0x0002e70d8d70ee00, 0x00098de4e33bc700, 0x0002b6b599828080,
    0x0008b460f543c040, 0x00050383aae46020, 0x000f3675e5d5d010,
    0x000575161c88b858, 0x000922a50619849c, 0x000687ad8d70eee2,
    0x0005dd14e33bc78b, 0x0008000000000000, 0x000c000000000000,
    0x000e000000000000, 0x000b000000000000, 0x0004800000000000,
    0x0004400000000000, 0x000ca00000000000, 0x0000d00000000000,
    0x0002880000000000, 0x0005140000000000, 0x000d8a0000000000,
    0x0005950000000000, 0x000bcb8000000000, 0x000c34c000000000,
    0x00049ae000000000, 0x000e7c5000000000, 0x00096e6800000000,
    0x000f87c400000000, 0x000ea37200000000, 0x0003d01500000000,
    0x000a091080000000, 0x000f544440000000, 0x000a2b7220000000,
    0x0001c41530000000, 0x000d0310b8000000, 0x000581446c000000,
    0x0009c0f232000000, 0x000960d521000000, 0x0007b1f08a800000,
    0x000e39146f400000, 0x000fac9a38200000, 0x0006661135500000,
    0x000f5302bca80000, 0x000448c179140000, 0x000af4ea970e0000,
    0x000b7ac545830000, 0x00088cf88ec38000, 0x0004774070e54000,
    0x00003ae00ab7a000, 0x0002ac50179c1000, 0x0005e668064e4800,
    0x000193c41ea51400, 0x0007a9720813e200, 0x00020515358d0100,
    0x000d62908ec38080, 0x0003b08470e540c0, 0x000c39920ab7a0e0,
    0x000aac45179c10b0, 0x0009e778864e4848, 0x000f93805ea51444,
    0x000ca8002813e2ca, 0x00068400058d010d, 0x0008000000000000,
    0x000c000000000000, 0x0002000000000000, 0x0001000000000000,
    0x000a800000000000, 0x000ac00000000000, 0x000e600000000000,
    0x0000900000000000, 0x0003880000000000, 0x000e2c0000000000,
    0x00050a0000000000, 0x000ead0000000000, 0x0002cb8000000000,
    0x00084d4000000000, 0x00099ba000000000, 0x000f241000000000,
    0x000de6f800000000, 0x0007c7dc00000000, 0x000df7ea00000000,
    0x00038e2d00000000, 0x00053a6f80000000, 0x000dd4ac40000000,
    0x000cffea20000000, 0x000b622d30000000, 0x000c506f88000000,
    0x0002e9ac44000000, 0x00073c6a0a000000, 0x0007c36d1b000000,
    0x000ea1cfb1800000, 0x0003f0bc46400000, 0x000b991204200000,
    0x000665f123b00000, 0x000fc785a5a80000, 0x0001f7817cf40000,
    0x00018e058f0e0000, 0x00043bc142850000, 0x00075425a3c68000,
    0x00063f9170644000, 0x000502fdb095e000, 0x000cc11d599a7000,
    0x0001604fbe192800, 0x000910fc555cf400, 0x0002c9321dfc5e00,
    0x00000ca12c88c100, 0x00013adda3c68080, 0x0003d44d706440c0,
    0x000fff17b095e020, 0x0000e230599a7010, 0x000c11a03e1928a8,
    0x00064910155cf4ac, 0x0009cd783dfc5ee6, 0x0004da9c1c88c109,
    0x0008000000000000, 0x0004000000000000, 0x000e000000000000,
    0x0003000000000000, 0x0004800000000000, 0x0006400000000000,
    0x000ea00000000000, 0x000c500000000000, 0x0004f80000000000,
    0x00075c0000000000, 0x0003b60000000000, 0x000a1d0000000000,
    0x000d968000000000, 0x000e0cc000000000, 0x0004cee000000000,
    0x0001805000000000, 0x0005c02800000000, 0x0002608400000000,
    0x0007b12200000000, 0x000289db00000000, 0x0009b5a980000000,
    0x000eb33dc0000000, 0x0002a72220000000, 0x0000c4db10000000,
    0x000edb29b8000000, 0x0004e3fdcc000000, 0x00015fc232000000,
    0x000d198b09000000, 0x00082d8182800000, 0x0004dfb9fd400000,
    0x0006d80021e00000, 0x00094c0014700000, 0x0007ee000c580000,
    0x0002110015340000, 0x000e588037ba0000, 0x00050dc03c430000,
    0x00044e6027638000, 0x0009c1901f354000, 0x0008604832baa000,
    0x000ab0142cc11000, 0x000509ea03270800, 0x000b740f24522c00,
    0x00065223878c0600, 0x000056a2cb7de700, 0x00086d49a7638080,
    0x000d7e6ddf354040, 0x0000098a12baa0e0, 0x0008f49f3cc11030,
    0x000a92ebbb270848, 0x000bb776e8522c64, 0x000e1cc3b58c06ea,
    0x000396f2c27de7c5, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x0009000000000000, 0x0005800000000000,
    0x0005400000000000, 0x0007200000000000, 0x000cf00000000000,
    0x000f280000000000, 0x0009940000000000, 0x000cfa0000000000,
    0x000fb50000000000, 0x00098b8000000000, 0x0007dd4000000000,
    0x000e3ea000000000, 0x000257f000000000, 0x000be30800000000,
    0x0005689400000000, 0x000c35d600000000, 0x000bcad100000000,
    0x000e7c9480000000, 0x000b0f0640000000, 0x000a9e5620000000,
    0x000ce79130000000, 0x000d6a3488000000, 0x0009ccf664000000,
    0x0008075e36000000, 0x00037a0525000000, 0x000ff46294800000,
    0x00092b6757c00000, 0x00076d6a8aa00000, 0x0003b6f343500000,
    0x0002733c87680000, 0x000f116259140000, 0x000fb908248e0000,
    0x00066d9438250000, 0x000a365609928000, 0x00053391354bc000,
    0x00013034bf822000, 0x0006c9f64a475000, 0x000c04de3be5d800,
    0x000483453d308400, 0x000538c2b7187200, 0x0001ad975a6f4900,
    0x0006d7e281928080, 0x00072227514bc0c0, 0x000509ca89822020,
    0x000ee4036f475090, 0x000d93b4af65d858, 0x000d80b66af08454,
    0x0009407e3db87272, 0x000521b5193f49cf, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x0007000000000000,
    0x000d800000000000, 0x000dc00000000000, 0x0006200000000000,
    0x000df00000000000, 0x0002c80000000000, 0x0001540000000000,
    0x000be60000000000, 0x0002b50000000000, 0x0004368000000000,
    0x00038cc000000000, 0x0000aa6000000000, 0x0004bf7000000000,
    0x000438d800000000, 0x00041c3400000000, 0x000e732600000000,
    0x0005f2cd00000000, 0x000b321c80000000, 0x000e9219c0000000,
    0x0009a3a620000000, 0x0000cb0d10000000, 0x0001aefcb8000000,
    0x000ea1a9dc000000, 0x0000b11e16000000, 0x000da84927000000,
    0x000dc502a0800000, 0x0002bf50ebc00000, 0x000738249d200000,
    0x00079c9de2500000, 0x0004b2b82f180000, 0x000e534431140000,
    0x000b03fe15fa0000, 0x000a7af920630000, 0x0005073a83b18000,
    0x0009e5d4d8e9c000, 0x00024f3ab3996000, 0x000171d4fcd3d000,
    0x0001893a87dd1800, 0x000934d4c6b2f400, 0x000af7baad691200,
    0x00062c14d5dfb700, 0x00079bdabbb18080, 0x000dd664c4e9c040,
    0x00055d82859960e0, 0x000b1290cbd3d070, 0x000062c49f5d18d8,
    0x0008ea2df172f4dc, 0x000b5e8026491262, 0x0001e8c0108fb7df,
    0x0008000000000000, 0x0004000000000000, 0x000a000000000000,
    0x0003000000000000, 0x0009800000000000, 0x000a400000000000,
    0x0005a00000000000, 0x0003300000000000, 0x000df80000000000,
    0x0004ac0000000000, 0x000a960000000000, 0x000a4d0000000000,
    0x0002868000000000, 0x000d444000000000, 0x000732e000000000,
    0x000c6f7000000000, 0x000360a800000000, 0x0008504400000000,
    0x0001a80e00000000, 0x000f045b00000000, 0x0006928b80000000,
    0x00055e11c0000000, 0x000d988e20000000, 0x00057d1b10000000,
    0x00017eeba8000000, 0x0000e921cc000000, 0x000724c606000000,
    0x0005e32f39000000, 0x000e06cdbe800000, 0x0003847ec0c00000,
    0x00085223b1e00000, 0x000a3e55ebb00000, 0x000bc88034d80000,
    0x000dd54039f40000, 0x0004fa6033fa0000, 0x0005ba3002a10000,
    0x000d9ac806138000, 0x000eea743d49c000, 0x0005b2c626f8a000,
    0x000bae2f0a201000, 0x0006804d87d3b800, 0x000dc03ef628ac00,
    0x0006e0c3978a8e00, 0x000c1125f81c5700, 0x000d08282e138080,
    0x0006b5043149c040, 0x0008aa6e00f8a0a0, 0x000e126b23201030,
    0x00019e439153b898, 0x0001f965fae8aca4, 0x000aacc8206a8e5a,
    0x000397742aac5733, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x000d000000000000, 0x0000800000000000,
    0x0008400000000000, 0x000ea00000000000, 0x0008f00000000000,
    0x0009c80000000000, 0x0002ec0000000000, 0x0008620000000000,
    0x00018d0000000000, 0x000af38000000000, 0x0004554000000000,
    0x000a862000000000, 0x000f635000000000, 0x00000c2800000000,
    0x0000320400000000, 0x000fb4f600000000, 0x000c56dd00000000,
    0x00061b1b80000000, 0x000589c940000000, 0x00024d7620000000,
    0x000f929d30000000, 0x0005c4bb88000000, 0x0000ded974000000,
    0x000ad6fe22000000, 0x000d5b8911000000, 0x0004a9c5b2800000,
    0x000f7c1057c00000, 0x00003b1b85200000, 0x000939c95ab00000,
    0x0007257633080000, 0x00088e9d21f40000, 0x0004eebb86ee0000,
    0x000bffd94fe50000, 0x0006e77e13108000, 0x000073c909794000,
    0x000d1465be5ea000, 0x0006a6004ded1000, 0x0002d313b0635800,
    0x0007e59d50523400, 0x00026e28009ace00, 0x0000bf04264e3500,
    0x0007c7761b108080, 0x000d439d3d7940c0, 0x0002bd3bbc5ea020,
    0x000a5a996ced10d0, 0x0005295e0ae35808, 0x0005bc9933923484,
    0x000bda4d87baceea, 0x000fe9045dfe358f, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x0007000000000000,
    0x0002800000000000, 0x0002c00000000000, 0x0008200000000000,
    0x0006100000000000, 0x000bc80000000000, 0x0005e40000000000,
    0x000bba0000000000, 0x0008850000000000, 0x0008ca8000000000,
    0x00043cc000000000, 0x000f966000000000, 0x000fda9000000000,
    0x000e753800000000, 0x0004321400000000, 0x000980ba00000000,
    0x000a404d00000000, 0x0003e1b680000000, 0x000bb1b240000000,
    0x000d983a20000000, 0x0004cd8d10000000, 0x00006f56b8000000,
    0x000ee6e25c000000, 0x000e63e22a000000, 0x0002a8c91b000000,
    0x0008943498800000, 0x000003eb44400000, 0x000d593685200000,
    0x0001ec724c900000, 0x000dfeda16680000, 0x00026edd36540000,
    0x0003e68ebe0a0000, 0x0005e2a650630000, 0x0005e8001a318000,
    0x0000f4001e3e4000, 0x000cf2002d5ee000, 0x0008a10013eb5000,
    0x0009d08013936800, 0x000869c028ef7400, 0x0004b4e01b103a00,
    0x0008125014a99900, 0x0001915822318080, 0x00068984023e4040,
    0x00048502275ee0e0, 0x0002cb9918eb5070, 0x000d3decb3136828,
    0x000a17af70af742c, 0x000f9ad494303a82, 0x000494bb53399961,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x0001000000000000, 0x000a800000000000, 0x0008c00000000000,
    0x000be00000000000, 0x0004100000000000, 0x0003180000000000,
    0x00005c0000000000, 0x0009ae0000000000, 0x000e4d0000000000,
    0x0007b78000000000, 0x0006914000000000, 0x0007d9a000000000,
    0x0009bd1000000000, 0x000cbf3800000000, 0x0007d52c00000000,
    0x000f2a1a00000000, 0x0004de5f00000000, 0x000d842980000000,
    0x000d13c6c0000000, 0x000a73ba20000000, 0x0009a34f30000000,
    0x0008db1188000000, 0x000fd6eac4000000, 0x000cc1a00a000000,
    0x0005e11013000000, 0x0007113827800000, 0x0008982c14400000,
    0x00021d9a26600000, 0x000a8f1f22700000, 0x0001bd8989380000,
    0x0000bed6e9740000, 0x0005d48232be0000, 0x000e2a632b350000,
    0x000e5f0bb1de8000, 0x000545b5dbc04000, 0x0006f209a622e000,
    0x000e6396d611b000, 0x000abb22244ee800, 0x0008867311cd3c00,
    0x000679b3aa8c4600, 0x00028cd9cd6bab00, 0x00025633965e8080,
    0x00018199cf8040c0, 0x000f41938042e020, 0x000ba189f461b010,
    0x0006312bad76e8a8, 0x000669e5f8b93c8c, 0x000f9491983246be,
    0x00010baae65eab41, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x0009000000000000, 0x0001800000000000,
    0x0009400000000000, 0x000be00000000000, 0x000a700000000000,
    0x0003980000000000, 0x0006a40000000000, 0x0006c60000000000,
    0x0005550000000000, 0x00081e8000000000, 0x0002104000000000,
    0x000da9a000000000, 0x00055d7000000000, 0x000a520800000000,
    0x000a6a4c00000000, 0x0008dfe600000000, 0x0004b1cf00000000,
    0x0006397a80000000, 0x0005b4fbc0000000, 0x000eee4620000000,
    0x000348bf10000000, 0x0000ad72a8000000, 0x00038bb7e4000000,
    0x000faf2026000000, 0x000ca93035000000, 0x0000dda807800000,
    0x0009123c0dc00000, 0x00088b6e08600000, 0x00032fc33f900000,
    0x000e693cb4980000, 0x000b7d44fc940000, 0x000903b48e1a0000,
    0x00082248c2d10000, 0x000df372a5be8000, 0x00047ab7f421c000,
    0x000b77a007322000, 0x0002ec7030e83000, 0x0004ea8814591800,
    0x00071f0c2f72fc00, 0x000490c6164dca00, 0x000668ff292adf00,
    0x000f7cd2a23e8080, 0x000302c7f9e1c040, 0x000123280f5220a0,
    0x000c727c0f783090, 0x000d3ace20c11818, 0x000096b313e6fc94,
    0x00089d34b857cabe, 0x00077208fbfbdfa7, 0x0008000000000000,
    0x000c000000000000, 0x0006000000000000, 0x000d000000000000,
    0x0000800000000000, 0x0009400000000000, 0x0003600000000000,
    0x000bd00000000000, 0x0002880000000000, 0x000a9c0000000000,
    0x00060a0000000000, 0x0002cd0000000000, 0x000c438000000000,
    0x0004f1c000000000, 0x0006b82000000000, 0x000c84d000000000,
    0x00007e8800000000, 0x00050b7c00000000, 0x00034cd200000000,
    0x0003837d00000000, 0x0003d04980000000, 0x000e88a040000000,
    0x000c9cf220000000, 0x000b0bad30000000, 0x00024cc198000000,
    0x000502dc74000000, 0x000791a022000000, 0x000d681015000000,
    0x000e0d2815800000, 0x000ae26c1b400000, 0x0003007a08200000,
    0x000181d10f700000, 0x000fc19395a80000, 0x0007216164740000,
    0x000830499b2e0000, 0x000018a049b70000, 0x000b74f23ac88000,
    0x000747ad3d274000, 0x00064ec1aaf42000, 0x000413dc56eaf000,
    0x000eb8203853c800, 0x000084d0065eb400, 0x00067e88111b0600,
    0x00080b7c1f3f7100, 0x0003ccd22f488080, 0x000ac37d266740c0,
    0x0000b049a2d42060, 0x000558a0599af0d0, 0x000e14f22dfbc808,
    0x000197ad222ab494, 0x000446c1aa350636, 0x0007cfdc668871bd,
    0x0008000000000000, 0x0004000000000000, 0x0006000000000000,
    0x000b000000000000, 0x0000800000000000, 0x000f400000000000,
    0x000c600000000000, 0x000e900000000000, 0x000d680000000000,
    0x000f240000000000, 0x0000620000000000, 0x0004f50000000000,
    0x00086a8000000000, 0x0008c1c000000000, 0x0001a1e000000000,
    0x0000b0d000000000, 0x0004188800000000, 0x00031d9c00000000,
    0x00010e3a00000000, 0x0009432100000000, 0x000f05b680000000,
    0x000613e140000000, 0x000e4dda20000000, 0x000d46f110000000,
    0x000997be98000000, 0x00071fbd6c000000, 0x000f6a0022000000,
    0x000a41002d000000, 0x0003e08029800000, 0x000750c016400000,
    0x0005496037a00000, 0x000d541001900000, 0x000cdbe830080000,
    0x000ad88c29940000, 0x0009bd52140a0000, 0x00013f6d1f970000,
    0x00021b84870f8000, 0x0000799c51174000, 0x00098d3691c82000,
    0x000a67217f717000, 0x000d66ba3abf6800, 0x000fe7e11bcfc400,
    0x000da6d6b674fa00, 0x000a46f14539f500, 0x000b16b22e8f8080,
    0x00055ebd07574040, 0x00088b8c86682060, 0x000b10c06ee170b0,
    0x000da86c92b76808, 0x000a85105e5bc4f4, 0x0006d264807efac6,
    0x000bed4c77aef5e9, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x0007000000000000, 0x000c800000000000,
    0x000fc00000000000, 0x000c600000000000, 0x000a500000000000,
    0x0007a80000000000, 0x000c640000000000, 0x0008ee0000000000,
    0x0002f50000000000, 0x0009a68000000000, 0x000e014000000000,
    0x0001006000000000, 0x000981d000000000, 0x0004411800000000,
    0x000f201c00000000, 0x0009f0b200000000, 0x0001997900000000,
    0x00019cc680000000, 0x000323e8c0000000, 0x00067ed220000000,
    0x0003bda910000000, 0x0005535e88000000, 0x0006a6b4dc000000,
    0x0006800012000000, 0x000cc0002f000000, 0x0002e00039800000,
    0x0002900035400000, 0x000748002ca00000, 0x0009f4000e900000,
    0x0003260012380000, 0x0004c10022940000, 0x0006e080383a0000,
    0x0000904009950000, 0x000048e027b98000, 0x000575902dd34000,
    0x000ce7f8379e6000, 0x0008a08c04857000, 0x000cb1ca23c34800,
    0x000738b52062a400, 0x000c2d6c97777a00, 0x000d9a8df00fd300,
    0x000e12a69e398080, 0x00010738d8934040, 0x0002b14a3b3e6020,
    0x000638f51a157070, 0x0005ad8cb9fb48c8, 0x0009db1ddef6a4fc,
    0x0001335ebd4d7ac6, 0x0008f6b4d69ad3a5, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x000b000000000000,
    0x0005800000000000, 0x000ac00000000000, 0x0006e00000000000,
    0x0004100000000000, 0x0002380000000000, 0x00046c0000000000,
    0x0002220000000000, 0x00033d0000000000, 0x00023a8000000000,
    0x0004a04000000000, 0x0008b1e000000000, 0x000e89f000000000,
    0x0000e43800000000, 0x0009c66c00000000, 0x000f7ada00000000,
    0x0007811b00000000, 0x0005c1cf80000000, 0x0009602340000000,
    0x0005d13a20000000, 0x000159eb10000000, 0x000abd77a8000000,
    0x0006fb0f6c000000, 0x0003408036000000, 0x000221403b000000,
    0x0003f16033800000, 0x0008a8b03c400000, 0x000915581ee00000,
    0x000a6edc3ab00000, 0x0003ef8213080000, 0x00072fc71cb40000,
    0x0000ce4d800a0000, 0x000a5fe443310000, 0x000727778a4f8000,
    0x000f6a0f66d3c000, 0x000fb800037ae000, 0x000aac000998b000,
    0x000ec200212ce800, 0x000c2d002323ac00, 0x000582801917de00,
    0x000a0c4039d93d00, 0x000c73e039cf8080, 0x0009a4f01a93c040,
    0x0000e6b83d9ae0a0, 0x00090a2c2328b0b0, 0x0005e93a1a24e858,
    0x000a35eb1397acac, 0x00071f778f1dde6e, 0x0004060f51e83d41,
    0x0008000000000000, 0x0004000000000000, 0x000a000000000000,
    0x0005000000000000, 0x0004800000000000, 0x0000c00000000000,
    0x000ca00000000000, 0x000fb00000000000, 0x000b180000000000,
    0x0005ec0000000000, 0x000c960000000000, 0x000c1d0000000000,
    0x000aee8000000000, 0x0004604000000000, 0x0007102000000000,
    0x000ea9d000000000, 0x000bf4b800000000, 0x000dfb0400000000,
    0x00004aee00000000, 0x000a537700000000, 0x00013f8b80000000,
    0x00086891c0000000, 0x000c54ce20000000, 0x0009cba710000000,
    0x000a13b3a8000000, 0x00075ed5d4000000, 0x000e788032000000,
    0x000c7d4013000000, 0x0007fea01a800000, 0x000fc9902ac00000,
    0x000864983e600000, 0x000392d414b00000, 0x00071e5600d80000,
    0x000818730eb40000, 0x000a6d6587da0000, 0x0007d7e6c6310000,
    0x0001fd458e188000, 0x000dbe36dad34000, 0x000ca9fd8c68e000,
    0x000af532e26d1000, 0x00037b13876b3800, 0x00058a45d4ea9c00,
    0x0002729803acce00, 0x000e4fd42f8e5700, 0x000fd0d614988080,
    0x0006083330134040, 0x000e45459208e0a0, 0x0003e236e6dd1050,
    0x000127fdafb33848, 0x00060432ce5e9c0c, 0x000183939676ceca,
    0x000d3705eabf57fb, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x000f000000000000, 0x000a800000000000,
    0x000fc00000000000, 0x000aa00000000000, 0x0006300000000000,
    0x0001880000000000, 0x000bb40000000000, 0x000a6e0000000000,
    0x0007a50000000000, 0x0009168000000000, 0x000fb94000000000,
    0x000e3d6000000000, 0x0003db1000000000, 0x0002cb1800000000,
    0x0004338400000000, 0x00096efe00000000, 0x000b254500000000,
    0x000bd7c080000000, 0x00009974c0000000, 0x000d4d1e20000000,
    0x0007331510000000, 0x0005efb888000000, 0x0009e4e0fc000000,
    0x0004f6780a000000, 0x0003e8942f000000, 0x0009a5e622800000,
    0x000016c124c00000, 0x0008393eac200000, 0x00047c31d1d00000,
    0x000c3adea3380000, 0x00019a61d6540000, 0x00092aa68a7a0000,
    0x000563f5fc350000, 0x000b77c0934d8000, 0x000da974c2f84000,
    0x0004451e07f66000, 0x000c471525eb1000, 0x000fa1b893ee7800,
    0x0007b1e0d6e95400, 0x0006c8f82b6b6200, 0x0001d5d4152fc300,
    0x000c7e8639cd8080, 0x000fdcd11a384040, 0x00098aa6a1d66020,
    0x000853f5db3b10f0, 0x00027fc0925678a8, 0x0006dd74e47d54fc,
    0x000e0b1e2d3162aa, 0x0002121528cac363, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x000d000000000000,
    0x000d800000000000, 0x0002400000000000, 0x000f200000000000,
    0x0002b00000000000, 0x0007f80000000000, 0x000b2c0000000000,
    0x0002420000000000, 0x00003d0000000000, 0x000bca8000000000,
    0x000b084000000000, 0x000df52000000000, 0x000cdef000000000,
    0x000506e800000000, 0x000f1bd400000000, 0x000fe0de00000000,
    0x000b517b00000000, 0x000fa86380000000, 0x000e04ef40000000,
    0x000e877e20000000, 0x000e5bcb10000000, 0x000a41aba8000000,
    0x000b20cb74000000, 0x0008b1c816000000, 0x000af82419000000,
    0x0006acb614800000, 0x000002ef3ec00000, 0x000f1d9da9e00000,
    0x00097b6465b00000, 0x000cf1f595880000, 0x0006d8f05a340000,
    0x000e9c0bb8ca0000, 0x00053b7b64910000, 0x0004d08000dc8000,
    0x0004e9401e8fc000, 0x0006a5a019b1a000, 0x000377b0278e5000,
    0x000b03481d37f800, 0x00019c64314e2c00, 0x0001bb9600d22e00,
    0x0001111f22f8ed00, 0x000489f5bc5c8080, 0x0006b4f0544fc040,
    0x00047e0ba651a0a0, 0x0008f67b5b3e50d0, 0x000a42001c3ff8d8,
    0x00043d0015ba2c24, 0x0001ca8031f82ef2, 0x0006084033d9ed2b,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x0005000000000000, 0x000d800000000000, 0x0004c00000000000,
    0x0002200000000000, 0x000df00000000000, 0x0002680000000000,
    0x0008ec0000000000, 0x000b0e0000000000, 0x000efd0000000000,
    0x0007378000000000, 0x000f494000000000, 0x00019d2000000000,
    0x000227f000000000, 0x0005f13800000000, 0x000e687400000000,
    0x000aed6600000000, 0x000e0ea900000000, 0x00037c1380000000,
    0x0003f634c0000000, 0x000d69c620000000, 0x000c6d1930000000,
    0x00004f8b88000000, 0x000d1cf0d4000000, 0x000566b816000000,
    0x0004113423000000, 0x0009384600800000, 0x000c355923c00000,
    0x00026b2bbfa00000, 0x000f4f40f0b00000, 0x00099d2004b80000,
    0x000e27f03c340000, 0x0007f1381d7e0000, 0x000b68740a950000,
    0x00076d661c4c8000, 0x000acea9206bc000, 0x00015c13839ae000,
    0x000e0634f344d000, 0x000f01c604611800, 0x0004811923156400,
    0x000b418bbe0cae00, 0x0003e1f0d98d0300, 0x0002513814cc8080,
    0x000b587417abc0c0, 0x0008a5660a3ae020, 0x000e12a910f4d050,
    0x00079a13885918d8, 0x00012734e8e1644c, 0x000370460ad2ae22,
    0x0000295900a803df, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x0003000000000000, 0x0006800000000000,
    0x000ec00000000000, 0x000fa00000000000, 0x000fb00000000000,
    0x0006180000000000, 0x00089c0000000000, 0x000d920000000000,
    0x00034d0000000000, 0x00001a8000000000, 0x0003384000000000,
    0x0007ece000000000, 0x000d2b9000000000, 0x0001e0b800000000,
    0x0003d1a400000000, 0x0009896e00000000, 0x000a755700000000,
    0x0004f63580000000, 0x000893a940000000, 0x0008cd0e20000000,
    0x00015b8710000000, 0x0007d8eda8000000, 0x000fbddd4c000000,
    0x0005e2383a000000, 0x000f75e42b000000, 0x000f778e16800000,
    0x0009d3c732c00000, 0x000c2c0d82600000, 0x00090a4d59700000,
    0x000f108028c80000, 0x0001294023f40000, 0x00094460300a0000,
    0x000f2ed022910000, 0x00092ed833fb8000, 0x00042e74029a4000,
    0x000baf363968e000, 0x0000ee633d679000, 0x00070f63a1f63800,
    0x0009de1a7f0b1c00, 0x000fd63582123600, 0x000ee3a9703c3500,
    0x000df50e0d7b8080, 0x000bb7873c5a4040, 0x000572eda108e0a0,
    0x00051cdd5f179030, 0x0001d2b837be3868, 0x00082ca4223f1cec,
    0x00030bee0a7836fa, 0x000c111720dd35fb, 0x0008000000000000,
    0x000c000000000000, 0x0006000000000000, 0x000f000000000000,
    0x0006800000000000, 0x0006c00000000000, 0x0006200000000000,
    0x0006900000000000, 0x000c280000000000, 0x000f2c0000000000,
    0x0005e60000000000, 0x0007dd0000000000, 0x0003bf8000000000,
    0x000269c000000000, 0x000ccc6000000000, 0x0005d61000000000,
    0x0004a43800000000, 0x00001b9400000000, 0x0008f3ca00000000,
    0x0004fe2100000000, 0x000809a780000000, 0x000cbd41c0000000,
    0x00064e2a20000000, 0x0007b0f130000000, 0x0000387f98000000,
    0x0003c405fc000000, 0x0003ea383a000000, 0x00022a942b000000,
    0x000e8a4a00800000, 0x0008dae126400000, 0x000dd247aaa00000,
    0x0002ee91e7b00000, 0x000de0722f180000, 0x0003307535340000,
    0x0003f80da65e0000, 0x000a6470c9170000, 0x000a3a359ea98000,
    0x000862e4e32c4000, 0x0007d67fbceee000, 0x0001a505df895000,
    0x000f9bb8025ea800, 0x0007b2542f10c400, 0x00029faa3fae7e00,
    0x000e783110af5700, 0x0000259f86298080, 0x0003dad5f96c40c0,
    0x000153e00c4ee060, 0x000d2fd0233950f0, 0x0002405835c6a868,
    0x0005e1840064c46c, 0x000f31f229507e62, 0x0005f8b525085769,
    0x0008000000000000, 0x000c000000000000, 0x000a000000000000,
    0x000f000000000000, 0x000b800000000000, 0x000ac00000000000,
    0x0004600000000000, 0x0006b00000000000, 0x000df80000000000,
    0x000bec0000000000, 0x0001fa0000000000, 0x00037d0000000000,
    0x0009938000000000, 0x0008784000000000, 0x00082c6000000000,
    0x000b1a3000000000, 0x000b8db800000000, 0x00014a7c00000000,
    0x000b85ce00000000, 0x0006ff5300000000, 0x0008c29b80000000,
    0x0005f1b840000000, 0x0000582e20000000, 0x0008bc2330000000,
    0x000f72c3a8000000, 0x000a88b47c000000, 0x000ff5b80e000000,
    0x0003667c1b000000, 0x000f9fce39800000, 0x0006f25326c00000,
    0x0003491b99e00000, 0x000a15f844b00000, 0x0000164e36680000,
    0x000d871327340000, 0x00016efbb9ae0000, 0x000b2b8872510000,
    0x0004359629598000, 0x0005865f3a9cc000, 0x000d6f0db1f8e000,
    0x00012be74208f000, 0x000b3523b746b800, 0x000e06c443258c00,
    0x0007ae6013548e00, 0x00054b3009db1100, 0x000d843838d98080,
    0x0003ff3c205cc0c0, 0x000c422e0618e0a0, 0x0004b1232db8f0f0,
    0x000ef94390aeb8b8, 0x000a6cf47ed18cac, 0x00043bd81d1a8e46,
    0x000c9d4c143a116b, 0x0008000000000000, 0x000c000000000000,
    0x000a000000000000, 0x000b000000000000, 0x000a800000000000,
    0x0000c00000000000, 0x0002200000000000, 0x0002700000000000,
    0x000f880000000000, 0x00065c0000000000, 0x0004c60000000000,
    0x000dd50000000000, 0x00049b8000000000, 0x0008124000000000,
    0x0008cfe000000000, 0x0006c89000000000, 0x00023db800000000,
    0x000e573400000000, 0x00090d6600000000, 0x0005bf7d00000000,
    0x0005c09980000000, 0x0005a183c0000000, 0x000930de20000000,
    0x000ce84930000000, 0x000c4dffa8000000, 0x000bdefeec000000,
    0x000450478a000000, 0x000bf9caf3000000, 0x0008d52180800000,
    0x00031ab7d5c00000, 0x000353b81c200000, 0x000bae3406700000,
    0x000cd8e619980000, 0x000d243d11940000, 0x0007d2f98ece0000,
    0x00066e53f3f90000, 0x0005790626878000, 0x000e15ad0cc64000,
    0x00003ac19fa0e000, 0x0000a227db31d000, 0x000e66000c7c1800,
    0x0008650029c2b400, 0x0009b3800e250600, 0x0007fe4031719f00,
    0x000b21e03f1f8080, 0x000ff1901d5240c0, 0x000fc838116ee0a0,
    0x000fbc7428c8d0b0, 0x000e17062afb98a8, 0x0000ecad2504f40c,
    0x000f6f419185e622, 0x0008f967ea404f27, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x000d000000000000,
    0x0007800000000000, 0x0007c00000000000, 0x000e200000000000,
    0x0001100000000000, 0x0000b80000000000, 0x0007ec0000000000,
    0x000f960000000000, 0x0002550000000000, 0x000bfa8000000000,
    0x000402c000000000, 0x000a8e2000000000, 0x000968b000000000,
    0x0009f41800000000, 0x000a2b5400000000, 0x000e1a8a00000000,
    0x0001325b00000000, 0x000827a380000000, 0x0004bde3c0000000,
    0x0001ce9220000000, 0x000e090f10000000, 0x00088529b8000000,
    0x000f63b8f4000000, 0x0001ff31be000000, 0x000f21eccf000000,
    0x000c913ba0800000, 0x00047877e0400000, 0x00034c3804e00000,
    0x000ec6e424b00000, 0x000b0c1220d80000, 0x000327cf26140000,
    0x000a3d098b8a0000, 0x000f8e08d4fb0000, 0x000ae9a98e008000,
    0x00003478e706c000, 0x00090b91ac826000, 0x00088b9cca425000,
    0x00064b0385e0a800, 0x0001eb93c334ac00, 0x000a3aaa3c1c6e00,
    0x000323eb30b31f00, 0x00021f3baed88080, 0x00031177c112c040,
    0x0007b8b8270860e0, 0x00036d241eb950d0, 0x0002d6b20be02878,
    0x000c34bf24326c7c, 0x00030bb1909e0ee2, 0x000b8a2cfaf14f11,
    0x0008000000000000, 0x0004000000000000, 0x000e000000000000,
    0x000f000000000000, 0x0001800000000000, 0x0003c00000000000,
    0x0003e00000000000, 0x0009900000000000, 0x000d380000000000,
    0x00013c0000000000, 0x0003ee0000000000, 0x0005850000000000,
    0x0005128000000000, 0x000b8ac000000000, 0x0006066000000000,
    0x0002207000000000, 0x000f70d800000000, 0x0004286c00000000,
    0x0001449a00000000, 0x0003739300000000, 0x000fda1180000000,
    0x0007df14c0000000, 0x000b0c4220000000, 0x000267ff10000000,
    0x0003708bb8000000, 0x000e2987fc000000, 0x000044d3a6000000,
    0x000df22bdf000000, 0x000d9aa997800000, 0x0007fe08ca400000,
    0x00017c802ae00000, 0x0006cfc027f00000, 0x000f74e03e380000,
    0x000cfab003540000, 0x00062eb8292a0000, 0x000d641c039b0000,
    0x000302422cc18000, 0x000a72ff3c25c000, 0x00055a0b92d16000,
    0x000b9f47ec6eb000, 0x00042cb3a6f9e800, 0x0009975bed708c00,
    0x000418f196f8a600, 0x0001cca4c5772300, 0x000b067a12f98080,
    0x0006a0233f71c040, 0x000c3029bbfb60e0, 0x000a88c8eff5b0f0,
    0x000974e00a386818, 0x0007fab011554c3c, 0x0009aeb82429c63e,
    0x0001a41c39199399, 0x0008000000000000, 0x0004000000000000,
    0x000e000000000000, 0x0009000000000000, 0x0009800000000000,
    0x0006400000000000, 0x0002e00000000000, 0x000ab00000000000,
    0x000fc80000000000, 0x000e6c0000000000, 0x000f8a0000000000,
    0x0002650000000000, 0x000f468000000000, 0x0002bec000000000,
    0x0008daa000000000, 0x00039d7000000000, 0x000f22a800000000,
    0x000ef88c00000000, 0x0004e50e00000000, 0x000d879d00000000,
    0x00019e2f80000000, 0x000fcbb240000000, 0x000d85a620000000,
    0x0002761110000000, 0x000237a1b8000000, 0x000dd7ef64000000,
    0x0000e7a986000000, 0x00006e1349000000, 0x0005620f93800000,
    0x000618025ec00000, 0x000955ae01200000, 0x0002cfed14b00000,
    0x00003207aba80000, 0x0004e1fe5e540000, 0x0007b0080fba0000,
    0x000849fc108b0000, 0x00012da611e28000, 0x0004ea113091c000,
    0x000e95a1a698a000, 0x00026eef583d3000, 0x00066329984cb800,
    0x000899d341c4b400, 0x000f942f83a29e00, 0x000feeb24df23900,
    0x000e23263a4a8080, 0x000378d12ec5c040, 0x000ca5018922a0e0,
    0x0006669f58b63090, 0x0002af01b1ae3898, 0x0006439f55557464,
    0x00010981833a3e2e, 0x00074d5f4ccf09ab, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x0009000000000000,
    0x000a800000000000, 0x0006c00000000000, 0x000f200000000000,
    0x000df00000000000, 0x0004280000000000, 0x00015c0000000000,
    0x0005720000000000, 0x0006350000000000, 0x00004e8000000000,
    0x000ed64000000000, 0x0005c2a000000000, 0x00057d9000000000,
    0x000f023800000000, 0x00045dd400000000, 0x0001f39600000000,
    0x0003f4a900000000, 0x000cef0980000000, 0x000f676140000000,
    0x00080bae20000000, 0x0006f07d10000000, 0x0003a81fa8000000,
    0x00071c8864000000, 0x000592878a000000, 0x000e65cc4b000000,
    0x000f57a9b4800000, 0x000483f143c00000, 0x000c1d1632a00000,
    0x000212e92a700000, 0x000825a9ab480000, 0x000fb6f150140000,
    0x000cd396271a0000, 0x000304a902e90000, 0x0008470986e28000,
    0x0001fb615b924000, 0x0008d9ae325ae000, 0x000bf57d3c8a5000,
    0x0008ee9f90b6d800, 0x000566c86a69e400, 0x00010a2783244600,
    0x000c715c4c359500, 0x00056911adaa8080, 0x00083d654b864040,
    0x000862a03540e0a0, 0x000a4d902e635090, 0x000e0a383e5458a8,
    0x0001f1d415fba46c, 0x000a29961b7ea6f2, 0x00025da92bbfc5df,
    0x0008000000000000, 0x0004000000000000, 0x000a000000000000,
    0x0005000000000000, 0x0004800000000000, 0x0004c00000000000,
    0x000d600000000000, 0x0006300000000000, 0x0009f80000000000,
    0x000bf40000000000, 0x000b6a0000000000, 0x00076d0000000000,
    0x0002ae8000000000, 0x000ffe4000000000, 0x000b372000000000,
    0x0002ba5000000000, 0x000764f800000000, 0x0006425c00000000,
    0x000c102e00000000, 0x0003e8bb00000000, 0x00031d5c80000000,
    0x0003f70040000000, 0x0001da5620000000, 0x000e54a710000000,
    0x000e3a52a8000000, 0x0007a5eb54000000, 0x000123f2b2000000,
    0x000f21fb43000000, 0x000e902abd800000, 0x000c29f75cc00000,
    0x0005fcfcbde00000, 0x0000871078d00000, 0x0005038e02280000,
    0x000a31ab12740000, 0x0007f804a2da0000, 0x0004f54c4fe90000,
    0x000aeba021148000, 0x00072d10234d4000, 0x000b0f5800e1e000,
    0x0004af4c18547000, 0x0004ff760e6e3800, 0x0000b7f71bd6ac00,
    0x0007fa2aafa81200, 0x000a44f766b13100, 0x0009d27c8b3c8080,
    0x000eb95065394040, 0x0007d4ae103be0a0, 0x000a7bfb14bd7050,
    0x000404fc92fab848, 0x000f7310645bec4c, 0x0004698e12a9f2d6,
    0x00085cab06354163, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x0003000000000000, 0x0009800000000000,
    0x0006400000000000, 0x0000600000000000, 0x0006500000000000,
    0x0005580000000000, 0x000b640000000000, 0x0001760000000000,
    0x00015d0000000000, 0x0007c28000000000, 0x000633c000000000,
    0x00071be000000000, 0x0009167000000000, 0x00030de800000000,
    0x00049b1c00000000, 0x000e569200000000, 0x000fecbf00000000,
    0x000e0a1280000000, 0x0004af2bc0000000, 0x0004f9fa20000000,
    0x000c146310000000, 0x000d9f6098000000, 0x000c71e4cc000000,
    0x0001680086000000, 0x000d6d54c9000000, 0x0005ca88b9800000,
    0x00048ef8c5400000, 0x0001c8928b600000, 0x00069cebe8900000,
    0x0005e21a1a580000, 0x0006021319340000, 0x00071288b5ea0000,
    0x000eaaf8f91f0000, 0x000f5e928b578000, 0x0004d1ebdcfdc000,
    0x000e989a3a05a000, 0x000b45d327077000, 0x000447689487c800,
    0x000bd588fec03c00, 0x000fbffab5226a00, 0x000c4037e9721f00,
    0x00016168090f8080, 0x000ad1dc09c9c040, 0x000999f209efa060,
    0x0004c40f17187030, 0x0001069aa6504898, 0x00023587e77dfc64,
    0x000faf600447ca06, 0x000978b026e56f65, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x0001000000000000,
    0x0006800000000000, 0x0005c00000000000, 0x000aa00000000000,
    0x0005d00000000000, 0x0009180000000000, 0x0003440000000000,
    0x00004a0000000000, 0x000f7d0000000000, 0x00019e8000000000,
    0x000f4fc000000000, 0x0003d7a000000000, 0x0004d39000000000,
    0x000c79d800000000, 0x000f35e400000000, 0x000d023200000000,
    0x0007613f00000000, 0x000b716e80000000, 0x000ac8bc40000000,
    0x000b5d6a20000000, 0x00058f1b10000000, 0x000af6fc98000000,
    0x0004431344000000, 0x000b015cba000000, 0x0005808347000000,
    0x0004408492800000, 0x0008e16743400000, 0x000c30b686600000,
    0x0003a9584e100000, 0x00052d5809a80000, 0x000fc72429b40000,
    0x00056b120a9a0000, 0x000ded6f346f0000, 0x0001e7169a968000,
    0x00027ac863ea4000, 0x0009d48018556000, 0x000432c0364c9000,
    0x0004492000644800, 0x000a9c500711bc00, 0x00092e780e2e5a00,
    0x000e267413702100, 0x000bdbea0b3e8080, 0x000d84db0e5e4040,
    0x000f6b5ca8cf6060, 0x000eed8345239010, 0x000066048872c868,
    0x00003aa767bbfc5c, 0x00003516b01b3aaa, 0x000e83c87b2cb15d,
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x000f000000000000, 0x000c800000000000, 0x0006400000000000,
    0x0009a00000000000, 0x000fd00000000000, 0x000a680000000000,
    0x000ecc0000000000, 0x0008620000000000, 0x0000850000000000,
    0x000abe8000000000, 0x000cef4000000000, 0x0007466000000000,
    0x0008ea5000000000, 0x000fb8e800000000, 0x000fa58400000000,
    0x00082f0200000000, 0x0001a7c100000000, 0x000f1bcf80000000,
    0x000fc18740000000, 0x0008616a20000000, 0x000eb10510000000,
    0x000558ad88000000, 0x000e55167c000000, 0x000556cd92000000,
    0x0005e34649000000, 0x000344258e800000, 0x0004dfc253400000,
    0x000f5fa7b3a00000, 0x00019e434e300000, 0x000c7e881d080000,
    0x00050fd408540000, 0x000c37ea1fda0000, 0x000ed24512cd0000,
    0x0001dccd81b18000, 0x0006ea467ccd4000, 0x0006b8a59ab1a000,
    0x000e25825b4f1000, 0x000def47b7778800, 0x0002c75343af4400,
    0x000f2a000ee71e00, 0x0003d90026904d00, 0x0003148014b98080,
    0x0002764008994040, 0x000372e0176ba020, 0x000c0c10008210f0,
    0x00038208384608c8, 0x0004f5942c220464, 0x0000070a07f6be9a,
    0x0004cb5523ef5dfd, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x0009000000000000, 0x0008800000000000,
    0x0007400000000000, 0x0006e00000000000, 0x0002f00000000000,
    0x0007f80000000000, 0x0004c40000000000, 0x000fea0000000000,
    0x000c9d0000000000, 0x00023e8000000000, 0x0008ffc000000000,
    0x0003dea000000000, 0x000f8e5000000000, 0x000de68800000000,
    0x0003ebac00000000, 0x000e9dc600000000, 0x000d3ebb00000000,
    0x00097f0280000000, 0x000c1ed840000000, 0x000e2fce20000000,
    0x0009f7d710000000, 0x0006e2e498000000, 0x000da1f364000000,
    0x000610e482000000, 0x000a08f34d000000, 0x0002bc64a3800000,
    0x0004ee337fc00000, 0x0002d64485e00000, 0x000ab2a37a100000,
    0x000fc8ecbe280000, 0x00081c9f50b40000, 0x00077f02969a0000,
    0x00011ed8522f0000, 0x0000afce2eb28000, 0x0007b7d73d9d4000,
    0x000882e4bea82000, 0x000811f37ff5b000, 0x000708e4843f9800,
    0x000c3cf34e98ac00, 0x000aae64962eaa00, 0x000cb7337cb79100,
    0x000f02c4889a8080, 0x000ed06349294040, 0x000e28cc8a322060,
    0x000f6d0f70dab090, 0x0009472a910d1888, 0x000d7b2468c5ec74,
    0x0003d4802f668a6e, 0x000962c03452212f, 0x0008000000000000,
    0x000c000000000000, 0x0006000000000000, 0x0009000000000000,
    0x000e800000000000, 0x000fc00000000000, 0x0001200000000000,
    0x0006700000000000, 0x000f480000000000, 0x000eac0000000000,
    0x000be60000000000, 0x0004050000000000, 0x000f9b8000000000,
    0x00089bc000000000, 0x00031ba000000000, 0x00045b9000000000,
    0x0003ba9800000000, 0x000a6a9400000000, 0x000c938600000000,
    0x000c568500000000, 0x000f6c7780000000, 0x000fc637c0000000,
    0x000af49e20000000, 0x000612d130000000, 0x000997d198000000,
    0x00014ce2e4000000, 0x000e37d19a000000, 0x0004fce2cf000000,
    0x00065fd1bc800000, 0x000520e2cdc00000, 0x000c71d1bf200000,
    0x000049e2d1b00000, 0x00092c51a9180000, 0x000aa722e2d40000,
    0x000ae47185ce0000, 0x0008cb72ea1f0000, 0x0001a34998568000,
    0x0002ff76c90a4000, 0x000111d7a4bc6000, 0x000c58a7d3a15000,
    0x0001f58614769800, 0x000b93851a3f5400, 0x0007d7f7b5633e00,
    0x00082df7cdd7cf00, 0x0008273e294e8080, 0x000325410fde40c0,
    0x0000eb499b726060, 0x00095376c6be5090, 0x000277d7a8a018e8,
    0x000e9da7faf514fc, 0x0001ce0634ff5e12, 0x000ab84500c69f67,
    0x0008000000000000, 0x000c000000000000, 0x000e000000000000,
    0x000f000000000000, 0x0003800000000000, 0x0007c00000000000,
    0x000b200000000000, 0x000af00000000000, 0x000b880000000000,
    0x00054c0000000000, 0x0004a60000000000, 0x0008a50000000000,
    0x00077b8000000000, 0x000c1ac000000000, 0x00080b6000000000,
    0x0003533000000000, 0x000be65800000000, 0x0005c5b400000000,
    0x00006a7600000000, 0x000ac3bd00000000, 0x00087f7b80000000,
    0x0005d017c0000000, 0x000379ae20000000, 0x000fc5c930000000,
    0x000d6bedb8000000, 0x0008435afc000000, 0x00033e6dae000000,
    0x000ab09aef000000, 0x0005688db4800000, 0x00059c6ae7c00000,
    0x00095e35b8200000, 0x0002202ec6300000, 0x000a717ba8180000,
    0x0001c917da540000, 0x0006ac2e094e0000, 0x0006f6091d9b0000,
    0x000e1d0d86158000, 0x00029faaf228c000, 0x000700d58c4f6000,
    0x000f80ded419d000, 0x0009c1c3b4525800, 0x00042053c64d3400,
    0x000970e0191f0e00, 0x000c49f019d54f00, 0x000e6d38160d8080,
    0x000e5684147cc0c0, 0x00032c2e0b0160e0, 0x000236091682d0f0,
    0x0008bd0dbec7d838, 0x0000afaaefa5f47c, 0x000428d5a3706eb2,
    0x0007fcded4fc9faf, 0x0008000000000000, 0x000c000000000000,
    0x000e000000000000, 0x000d000000000000, 0x000c800000000000,
    0x0001400000000000, 0x0008e00000000000, 0x000cf00000000000,
    0x0007d80000000000, 0x0005bc0000000000, 0x0005320000000000,
    0x0004950000000000, 0x0008578000000000, 0x000b9ac000000000,
    0x0009312000000000, 0x000279d000000000, 0x000fac4800000000,
    0x00031b2c00000000, 0x000a712600000000, 0x0009984f00000000,
    0x0002ddf580000000, 0x0009026340000000, 0x00066c4e20000000,
    0x0008bab330000000, 0x000d609bb8000000, 0x0003310074000000,
    0x000d789d92000000, 0x00002c9f75000000, 0x0003db203b800000,
    0x000f50d037c00000, 0x000cc9c815600000, 0x000114ec27f00000,
    0x0007978605480000, 0x00013b5f24940000, 0x000ca09d9dbe0000,
    0x0004909f4b5b0000, 0x000469200f6c8000, 0x000785d03d434000,
    0x0000fe4833272000, 0x00073e2c0453b000, 0x00019ea61e5e1800,
    0x000a0e8f04ed7c00, 0x0001e6d5b2827600, 0x0006a2b352427d00,
    0x00037d8631a48080, 0x0001125f2e1740c0, 0x0003451dbbf920e0,
    0x0007df5f68f8b0d0, 0x00016f80147a98c8, 0x0003d6c01d3a3c14,
    0x00095b201c1b568e, 0x000f10d01d4acdcf, 0x0008000000000000,
    0x000c000000000000, 0x0006000000000000, 0x0003000000000000,
    0x000a800000000000, 0x0006400000000000, 0x0009600000000000,
    0x0002300000000000, 0x0000f80000000000, 0x0005040000000000,
    0x000c860000000000, 0x0000cd0000000000, 0x0009fb8000000000,
    0x000a0fc000000000, 0x000550e000000000, 0x000dc81000000000,
    0x00097c6800000000, 0x000cc21c00000000, 0x000faade00000000,
    0x000d477b00000000, 0x000a6d8a80000000, 0x00086ae9c0000000,
    0x0004e65620000000, 0x00017d7730000000, 0x0000c33c98000000,
    0x0009ab8ecc000000, 0x000e47028a000000, 0x0000ede5e9000000,
    0x000e2b601d800000, 0x000d87d034c00000, 0x00034c8831e00000,
    0x00003a0c01100000, 0x000caeb63d980000, 0x0002c16712f40000,
    0x00002154818e0000, 0x0007d092f4ef0000, 0x0007885c84bb8000,
    0x00061c5ed0044000, 0x000df38a8807a000, 0x0005d3e9e4037000,
    0x000e03d61e06f800, 0x000f8bb70f02ac00, 0x000a965c8e840a00,
    0x000de55ef8439700, 0x000e760aa4a38080, 0x00091529f63040c0,
    0x0004aeb63869a060, 0x000ec16711fc7030, 0x00062154a72578a8,
    0x0004d092cdf2ec64, 0x000d085c870daa96, 0x00005c5ee8afe723,
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x0009000000000000, 0x0005800000000000, 0x0000400000000000,
    0x0008200000000000, 0x0000500000000000, 0x0000580000000000,
    0x0005240000000000, 0x00042e0000000000, 0x000cad0000000000,
    0x0007128000000000, 0x000e874000000000, 0x000340a000000000,
    0x0000a07000000000, 0x0007916800000000, 0x0001389400000000,
    0x0008d4b200000000, 0x0004670700000000, 0x0001f0aa80000000,
    0x00064804c0000000, 0x00065d7a20000000, 0x000ddbe310000000,
    0x000d1b7088000000, 0x0006fa97e4000000, 0x0005cbe2b6000000,
    0x000163a0d1000000, 0x00018e0008800000, 0x0008bd0035400000,
    0x000d6a801f600000, 0x0002f34031900000, 0x0002b6a026380000,
    0x0009697032f40000, 0x000c8de83daa0000, 0x000342d42fcd0000,
    0x000cde921cda8000, 0x000f643724a5c000, 0x00010f6292b7a000,
    0x000b7de0cc4b5000, 0x000e0a20121a4800, 0x000603303900dc00,
    0x00077fc81c858a00, 0x000475e43b438300, 0x0005f75a32628080,
    0x000bc8d32311c040, 0x00021cb8b07da020, 0x0007fb73d2165090,
    0x00044ab8a8f8c858, 0x00032273ef511c04, 0x0000ae3893982a82,
    0x000d6c33c8c5d305, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x0003000000000000, 0x0009800000000000,
    0x0003400000000000, 0x0002200000000000, 0x0002b00000000000,
    0x000bd80000000000, 0x0007940000000000, 0x0002fe0000000000,
    0x00057d0000000000, 0x000af28000000000, 0x0001b64000000000,
    0x000f81e000000000, 0x000e40f000000000, 0x0002a14800000000,
    0x000b711400000000, 0x0003390e00000000, 0x0004455700000000,
    0x0009b6e080000000, 0x000b8072c0000000, 0x000441a620000000,
    0x0001a0b310000000, 0x0002f0a6a8000000, 0x00007931cc000000,
    0x000664c886000000, 0x000b07d6dd000000, 0x0000580000800000,
    0x0003d40016c00000, 0x00035e0021600000, 0x00078d001f500000,
    0x000a8a8025780000, 0x0007d24012340000, 0x000487e00c2a0000,
    0x000e19f012490000, 0x000175c81a9f8000, 0x00082e5432a7c000,
    0x0004b46e2ab72000, 0x000ecee73ee95000, 0x000e64c89929b800,
    0x000f07d6eecf9c00, 0x000a580032592200, 0x0000d4002ac65b00,
    0x000ade003f678080, 0x0004cd003653c040, 0x0008aa8007fd20a0,
    0x0005624033f05030, 0x000f5fe026ce3898, 0x00098df00e5c5c34,
    0x00038bc834c40222, 0x000d535416660b2b, 0x0008000000000000,
    0x000c000000000000, 0x000a000000000000, 0x000d000000000000,
    0x0006800000000000, 0x0002400000000000, 0x000aa00000000000,
    0x0009300000000000, 0x000f480000000000, 0x000c4c0000000000,
    0x0008da0000000000, 0x000b750000000000, 0x000cff8000000000,
    0x0005124000000000, 0x0003792000000000, 0x0009841000000000,
    0x000cd6a800000000, 0x00040f2400000000, 0x00083b3e00000000,
    0x0004e53500000000, 0x0000869b80000000, 0x000b16e440000000,
    0x00016eb620000000, 0x00086b0130000000, 0x0001fc8da8000000,
    0x0004d2b574000000, 0x00011833ba000000, 0x000255c079000000,
    0x000d0f8822800000, 0x0008bb3420c00000, 0x0001a5960f200000,
    0x0001a6110c300000, 0x0006e7a593e80000, 0x0006c6d140140000,
    0x0007b7ad845e0000, 0x000f5fa571b90000, 0x000ca31b9bac8000,
    0x000971a47ef44000, 0x0004e81631cca000, 0x0009fd5124a19000,
    0x0008d30586767800, 0x000b1981780d9400, 0x000f55a591044e00,
    0x000b8fd176874100, 0x000afa2daac48080, 0x000b04e55e2040c0,
    0x000897bb9ab2a0a0, 0x0009aef4692890d0, 0x000a8a1e2632f868,
    0x000f6d2532edd424, 0x00042a339e96eeaa, 0x00005cc05a9fd193,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x0001000000000000, 0x0002800000000000, 0x000cc00000000000,
    0x0004a00000000000, 0x0008100000000000, 0x0006180000000000,
    0x0004a40000000000, 0x000dee0000000000, 0x0002ed0000000000,
    0x0008338000000000, 0x0006974000000000, 0x000678a000000000,
    0x0004159000000000, 0x0001e7f800000000, 0x000151e400000000,
    0x0003f94a00000000, 0x0005558f00000000, 0x0008072280000000,
    0x0002a12cc0000000, 0x0007101220000000, 0x000798fb30000000,
    0x000be41088000000, 0x00070f07c4000000, 0x00029d5aaa000000,
    0x00029a88c3000000, 0x000c3a783a800000, 0x00092ba414400000,
    0x000fb26a1a600000, 0x0006d75f25900000, 0x000d187aaf380000,
    0x000b2558d8f40000, 0x0001aea00a2e0000, 0x000b8c90188d0000,
    0x000602783e3a8000, 0x00045fa40d724000, 0x0000646a1ae9e000,
    0x00054e5f27ae9000, 0x0008fdfaa449a800, 0x000f2b18ff1d7c00,
    0x0000b3800601ea00, 0x000757403d056300, 0x000258a02b828080,
    0x0001c59001c640c0, 0x0001dff82aa7e020, 0x000125e42ab39010,
    0x000caf4a3d4b2828, 0x000b0c8f2e9b3ccc, 0x000bc2a29cc60a4a,
    0x00027f6cf126f381, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x000f000000000000, 0x0009800000000000,
    0x000e400000000000, 0x0007600000000000, 0x000b500000000000,
    0x000e380000000000, 0x000ae40000000000, 0x000fe20000000000,
    0x00094d0000000000, 0x00009e8000000000, 0x0001bbc000000000,
    0x0005786000000000, 0x0009057000000000, 0x000a72e800000000,
    0x0008d53c00000000, 0x00018b1200000000, 0x0002112300000000,
    0x0004d9ba80000000, 0x0009f4a140000000, 0x0009bb9a20000000,
    0x0001786f10000000, 0x000f04c098000000, 0x0005727e7c000000,
    0x000155d286000000, 0x000fca5d69000000, 0x000570e825800000,
    0x000f883c01400000, 0x0007cd9206e00000, 0x00035ee32e900000,
    0x000e9bda84080000, 0x000648d171740000, 0x0005edf2071a0000,
    0x0000ef93103f0000, 0x000ab3328a898000, 0x000c74ed56b1c000,
    0x0005fa601239a000, 0x000f1870298ff000, 0x0002d4681437c800,
    0x000c8afc3bfe4c00, 0x0002917231acca00, 0x000c19533203b500,
    0x000955d2ab018080, 0x000bca5d6685c040, 0x000370e833c3a060,
    0x0000883c0720f0f0, 0x000e4d9202b64898, 0x000d1ee3203b8ce4,
    0x0009fbda828f6a76, 0x000d18d172b345b5, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x0001000000000000,
    0x000d800000000000, 0x0002400000000000, 0x0008200000000000,
    0x0009100000000000, 0x000a280000000000, 0x0002f40000000000,
    0x0001920000000000, 0x0000ed0000000000, 0x0001df8000000000,
    0x0005e2c000000000, 0x000b74a000000000, 0x0001d3f000000000,
    0x0007cca800000000, 0x00044f1400000000, 0x00000a1a00000000,
    0x0003e0a900000000, 0x0001718880000000, 0x000419fd40000000,
    0x000d4d9220000000, 0x00068e8d30000000, 0x0009eb9ab8000000,
    0x000191b044000000, 0x0007e8a896000000, 0x000795cd79000000,
    0x000c221a38800000, 0x000c14a910400000, 0x00036388a6a00000,
    0x0007b4fd46d00000, 0x0009321230c80000, 0x00083c4d1ef40000,
    0x0000973ab75e0000, 0x000ba6407c1b0000, 0x000b9e00953a8000,
    0x0001c3d9762bc000, 0x000c65802684a000, 0x000afbc015435000,
    0x0008b9200c24e800, 0x00079c3019966400, 0x0008c78827ee0200,
    0x000b2e2428e06500, 0x000eba1225728080, 0x000d984d3c9fc0c0,
    0x000d0d3aa17aa0e0, 0x0001af4056885010, 0x000c7b80915668d8,
    0x000478196109a424, 0x000f7ca01094a282, 0x000737f007683591,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x000f000000000000, 0x000f800000000000, 0x0005c00000000000,
    0x0002600000000000, 0x0000500000000000, 0x000f280000000000,
    0x0009140000000000, 0x0004360000000000, 0x00008d0000000000,
    0x00061b8000000000, 0x0008274000000000, 0x0009056000000000,
    0x000fbe3000000000, 0x0006281800000000, 0x000795dc00000000,
    0x0003770200000000, 0x0007adf100000000, 0x000e6b1480000000,
    0x0000fe91c0000000, 0x000d09fa20000000, 0x000de55d30000000,
    0x0004af6e88000000, 0x000c218cfc000000, 0x0009f0749e000000,
    0x000019a1e7000000, 0x0006ec6221800000, 0x00084ac10d400000,
    0x000a0e8c8aa00000, 0x0000910dcf500000, 0x0001c81807580000,
    0x000105dc24740000, 0x0003bf02254e0000, 0x000429f1398d0000,
    0x00089514b66d8000, 0x000cf791cf9cc000, 0x00026c7a39966000,
    0x000c0b1d0dbe7000, 0x0000af8e85078800, 0x000221fcd8820400,
    0x0004f08c8bc1b200, 0x0000980dc661f700, 0x000cad9818b58080,
    0x000feb9c1aa8c0c0, 0x00083fe208786020, 0x000fe9811c6370f0,
    0x0007f5ec95b208f8, 0x000c263dfe2ac45c, 0x000705803db9d226,
    0x0002be400d028705, 0x0008000000000000, 0x0004000000000000,
    0x000e000000000000, 0x000d000000000000, 0x0005800000000000,
    0x0003c00000000000, 0x0008200000000000, 0x0005300000000000,
    0x0005c80000000000, 0x000d3c0000000000, 0x00067e0000000000,
    0x000b650000000000, 0x0004fa8000000000, 0x00058ec000000000,
    0x00070c2000000000, 0x000137f000000000, 0x0003191800000000,
    0x0001e49400000000, 0x0005bbae00000000, 0x0008ef6500000000,
    0x00015d3580000000, 0x000fafe8c0000000, 0x00053c1620000000,
    0x00027ec110000000, 0x000565a3b8000000, 0x0009fae9f4000000,
    0x00000f15b6000000, 0x0004cd18df000000, 0x0009178e38800000,
    0x0006289530c00000, 0x00042c2db9200000, 0x0008877ccff00000,
    0x000e91b80f780000, 0x000a38a426540000, 0x000b54161c4a0000,
    0x0000b2c1020b0000, 0x000573a384e88000, 0x000453e9d2bbc000,
    0x000ae39586f66000, 0x0001ead8f8fd5000, 0x0001772e16143800,
    0x0001f8a521a95400, 0x00077595a2d83600, 0x000b83d8eb663300,
    0x000dbbae0b108080, 0x000cef65302fc040, 0x000f5d35959c60e0,
    0x0002afe8ea0650d0, 0x0000bc162504b858, 0x0001bec12586943c,
    0x000d45a3a1445682, 0x000ccae9ce606353, 0x0008000000000000,
    0x000c000000000000, 0x000a000000000000, 0x0007000000000000,
    0x0003800000000000, 0x000dc00000000000, 0x0009200000000000,
    0x0000f00000000000, 0x0009780000000000, 0x0007fc0000000000,
    0x000ee20000000000, 0x0004950000000000, 0x0008b78000000000,
    0x000a824000000000, 0x0005046000000000, 0x0008deb000000000,
    0x0009571800000000, 0x000bd33400000000, 0x0008cc1600000000,
    0x0005bb9300000000, 0x000a191580000000, 0x0005ec4540000000,
    0x00034aee20000000, 0x000e615730000000, 0x000691fba8000000,
    0x0003e8125c000000, 0x000e1495ae000000, 0x0007f70547000000,
    0x0000e30e2c800000, 0x000594a72fc00000, 0x0006370383e00000,
    0x0003c2d674f00000, 0x0002647bb1080000, 0x000ccf5256940000,
    0x0009ff75abbe0000, 0x0005a7f55a390000, 0x0008aa760c798000,
    0x0008302335dec000, 0x0008d98dbe8a6000, 0x00034d317fd1d000,
    0x00047a983a9fd800, 0x0009387404ad8c00, 0x00021df60bc1b600,
    0x0009b26309e30500, 0x00045dedb9f18080, 0x00015381508ac0c0,
    0x00078d8018d460a0, 0x000fdb402618d070, 0x000a89e0036e5838,
    0x000b05f014274cdc, 0x0009def83315d692, 0x0007d6c41ffbd50f,
    0x0008000000000000, 0x000c000000000000, 0x000a000000000000,
    0x0009000000000000, 0x0003800000000000, 0x0005400000000000,
    0x0005a00000000000, 0x0000f00000000000, 0x000c680000000000,
    0x0006040000000000, 0x0004aa0000000000, 0x00017d0000000000,
    0x000d178000000000, 0x00038a4000000000, 0x000b4da000000000,
    0x000b9eb000000000, 0x0009dfc800000000, 0x0000ff6400000000,
    0x0005cf0600000000, 0x0003c77100000000, 0x000652fa80000000,
    0x000e813e40000000, 0x0000c0ee20000000, 0x0003e1e530000000,
    0x000fd014a8000000, 0x000a59db64000000, 0x000a8d7aae000000,
    0x0007ff7e65000000, 0x00094f4e1e800000, 0x0006065517c00000,
    0x000c325c97a00000, 0x000d11ff69100000, 0x000cb85caa280000,
    0x000cdcff63340000, 0x0001e7dc9b7e0000, 0x0005e2bf41f90000,
    0x0004487c883e8000, 0x000cb50f729ec000, 0x000de23491092000,
    0x0008492b4ae09000, 0x0006b512af749800, 0x0004e3aa759e0400,
    0x000bc800208a4a00, 0x0003f40008a7a900, 0x0001420014968080,
    0x000b3900226ac0c0, 0x000f9d8013d720a0, 0x0007474037099090,
    0x000f92203be21838, 0x000ee0f017f4c454, 0x000a5068135d6a5a,
    0x000c18d40fae390f, 0x0008000000000000, 0x000c000000000000,
    0x000e000000000000, 0x0003000000000000, 0x000b800000000000,
    0x0003400000000000, 0x0009200000000000, 0x000dd00000000000,
    0x000ff80000000000, 0x000dcc0000000000, 0x0009e20000000000,
    0x000ee30000000000, 0x0007628000000000, 0x0009234000000000,
    0x0008832000000000, 0x000d925000000000, 0x00080a3800000000,
    0x0001371c00000000, 0x000afca600000000, 0x00062a5900000000,
    0x0005676080000000, 0x000b441cc0000000, 0x000a4760a0000000,
    0x0009941cf0000000, 0x00003f6098000000, 0x0004181cfc000000,
    0x000b7d60b6000000, 0x00046b1cf1000000, 0x000ac7e092800000,
    0x000d545cc6400000, 0x00045ec0ad600000, 0x0003e90cf1700000,
    0x0002d4788ae80000, 0x00051e50cafc0000, 0x0007c97e97620000,
    0x00078519ee710000, 0x00022706356e8000, 0x0000644918384000,
    0x000a96f8b5466000, 0x000eed10ece43000, 0x0005325e86b4f800,
    0x00079b49c84d5400, 0x00016f3e05297a00, 0x00012055245d2700,
    0x0001d0de86b4f880, 0x0001f809c84d54c0, 0x000ecc1e05297ae0,
    0x00026205245d2730, 0x000da2e686b4f838, 0x000e4315c84d54f4,
    0x0004f2b805297a72, 0x00077b5c245d27ed, 0x0008000000000000,
    0x0004000000000000, 0x0006000000000000, 0x000b000000000000,
    0x0000800000000000, 0x000cc00000000000, 0x0009200000000000,
    0x000b900000000000, 0x0001080000000000, 0x000f3c0000000000,
    0x000b420000000000, 0x000e430000000000, 0x0001c38000000000,
    0x000b834000000000, 0x0005622000000000, 0x0007523000000000,
    0x00010ba800000000, 0x00061e8c00000000, 0x0009f1fe00000000,
    0x000df8df00000000, 0x000d45b880000000, 0x000c4610c0000000,
    0x000ce5b8a0000000, 0x000f1610d0000000, 0x0002cdb8b8000000,
    0x0000ba10fc000000, 0x000807b8ba000000, 0x000d0510cf000000,
    0x000ba6389e800000, 0x00035550e1400000, 0x000e0f989aa00000,
    0x0000b820ddb00000, 0x00012410b7a80000, 0x000fb79ce4bc0000,
    0x00081dc6b0a60000, 0x000fd28fcab10000, 0x0009cba0252e8000,
    0x00093e7017f9c000, 0x0009600801002000, 0x000c70fc1f83f000,
    0x000eb9f63ec7d800, 0x000e242304608c00, 0x0009364e89d13a00,
    0x000fdd33c678cf00, 0x000672763ec7d880, 0x000e9b6304608c40,
    0x0001166e89d13a60, 0x000dcc03c678cfb0, 0x00063a5e3ec7d888,
    0x000fc6af04608c8c, 0x0004a5b089d13af2, 0x000cf6ecc678cf09,
    0x0008000000000000, 0x000c000000000000, 0x0006000000000000,
    0x0009000000000000, 0x0009800000000000, 0x000ec00000000000,
    0x0002a00000000000, 0x0002700000000000, 0x000a980000000000,
    0x0000940000000000, 0x00011e0000000000, 0x00099f0000000000,
    0x0002de8000000000, 0x0008be4000000000, 0x00016f6000000000,
    0x0000065000000000, 0x0004cb8800000000, 0x0007e1dc00000000,
    0x000d109200000000, 0x000cc84100000000, 0x00063c9380000000,
    0x000ef39040000000, 0x00060493a0000000, 0x0000179070000000,
    0x000b8293b8000000, 0x00001c9054000000, 0x0001c2139e000000,
    0x000ffdd06f000000, 0x0000d3f394800000, 0x000535c066c00000,
    0x000fef1bbee00000, 0x0002464c64900000, 0x00072a01ba980000,
    0x0000f0d142ec0000, 0x000ed88031e20000, 0x000a754020150000,
    0x000f8fe0145f8000, 0x00049710100c4000, 0x0006c2681f71a000,
    0x00037dcc2b8b3000, 0x0001927a0d33e800, 0x000054cd23aa3400,
    0x0006bf099f41a600, 0x00046f4d51a47500, 0x000f87720d33e880,
    0x00030b5123aa34c0, 0x000cc0fb9f41a660, 0x0001a15c51a47590,
    0x0004f0698d33e818, 0x0004d91d63aa342c, 0x000574fa3f41a64a,
    0x000f0e8d21a475b7, 0x0008000000000000, 0x0004000000000000,
    0x000e000000000000, 0x0001000000000000, 0x000f800000000000,
    0x0008400000000000, 0x0002600000000000, 0x000a700000000000,
    0x0003a80000000000, 0x0009ec0000000000, 0x0004fe0000000000,
    0x00087f0000000000, 0x0004bf8000000000, 0x000e1e4000000000,
    0x0000ce6000000000, 0x000cb79000000000, 0x0006a29800000000,
    0x000008d400000000, 0x000cbc9a00000000, 0x000ec66f00000000,
    0x00010b9280000000, 0x0007e5ad40000000, 0x00094392a0000000,
    0x000939ad50000000, 0x000df59298000000, 0x000b9aad54000000,
    0x0003fc12a6000000, 0x000627ed75000000, 0x0002bbf2af800000,
    0x000f6d3d5cc00000, 0x00073e8aa1200000, 0x000c5f397b700000,
    0x000daf68b2d80000, 0x000847525a8c0000, 0x0002cb1820260000,
    0x0003c59422f50000, 0x0000537a031f8000, 0x000f60bf002b4000,
    0x000ff0eaa195e000, 0x0004e8a944081000, 0x00050df08d678800,
    0x00094f864e11ac00, 0x0001f78238c9c200, 0x000543fb3c471900,
    0x000338e88d678880, 0x0002f5124e11ac40, 0x00051b7838c9c2e0,
    0x00043d043c471910, 0x000c06620d678878, 0x000aaa2b0e11acc4,
    0x0006b41098c9c2c6, 0x000d7a566c4719b7, 0x0008000000000000,
    0x0004000000000000, 0x0002000000000000, 0x0003000000000000,
    0x0002800000000000, 0x0003400000000000, 0x0007600000000000,
    0x0005300000000000, 0x000b180000000000, 0x0005740000000000,
    0x000f5e0000000000, 0x0004bf0000000000, 0x0007cf8000000000,
    0x000837c000000000, 0x000ab3a000000000, 0x000855f000000000,
    0x00088e9800000000, 0x000957f400000000, 0x000e839200000000,
    0x0002ccd100000000, 0x000c3b4f80000000, 0x0002291c40000000,
    0x00086ccfa0000000, 0x000b2adc50000000, 0x000a616fa8000000,
    0x0002b02c5c000000, 0x000bd877a2000000, 0x0000d41851000000,
    0x000cce45bf800000, 0x000eb63945c00000, 0x000bf21213e00000,
    0x000c341110100000, 0x000f3f6f8e980000, 0x00010f2c52ec0000,
    0x000c97f7b9a60000, 0x0008a3d86e330000, 0x00039de591688000,
    0x000093c94e64c000, 0x000f048a24d2e000, 0x000527e532fb1000,
    0x0005fafd8f3ca800, 0x000208fd68d85400, 0x00083d3806c99600,
    0x000602043b502500, 0x00068d0a273ca880, 0x000bdb2534d85440,
    0x000758dda4c99620, 0x000695cd6a502530, 0x00082f8018bca8a8,
    0x000947c031185474, 0x00064ba017299656, 0x000851f02a402563,
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x0005000000000000, 0x0009800000000000, 0x0000c00000000000,
    0x0006a00000000000, 0x0008500000000000, 0x0003080000000000,
    0x000d7c0000000000, 0x0007ae0000000000, 0x0009cf0000000000,
    0x00033f8000000000, 0x000a67c000000000, 0x0001136000000000,
    0x0002405000000000, 0x000ce14800000000, 0x0000b11c00000000,
    0x0001b85600000000, 0x0009c49700000000, 0x0007ea0880000000,
    0x000ee5e540000000, 0x000b7b88a0000000, 0x00094d2550000000,
    0x000b5768a8000000, 0x00046ab544000000, 0x000f25408e000000,
    0x00065bf947000000, 0x0004dc5e94800000, 0x00077e7266400000,
    0x0001860018a00000, 0x000d230013b00000, 0x000ab98026180000,
    0x000344c0248c0000, 0x0009aae022e60000, 0x0004049019130000,
    0x000ccba800ab8000, 0x0004758c13124000, 0x000bd3fe29aea000,
    0x0005e11b30963000, 0x000f31f6a36ff800, 0x000678fe62746c00,
    0x0003e47e027fda00, 0x0006fadb2edff900, 0x000b8c968b6ff880,
    0x0008f7ae66746c40, 0x0005bab62c7fda20, 0x000cec0739dff950,
    0x000d87a0b7eff818, 0x000b236944346c4c, 0x000db9f6badfda4a,
    0x000fc4fe6d6ff9d5, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x000d000000000000, 0x0004800000000000,
    0x000a400000000000, 0x000b600000000000, 0x0006900000000000,
    0x0005680000000000, 0x0001840000000000, 0x0004e20000000000,
    0x000cc30000000000, 0x000bb28000000000, 0x000d0ac000000000,
    0x000b076000000000, 0x000631f000000000, 0x000a59b800000000,
    0x00015d5400000000, 0x0000ffc600000000, 0x000eddcb00000000,
    0x000d3feb80000000, 0x00047cffc0000000, 0x00030f6ba0000000,
    0x0002253ff0000000, 0x0000528ba8000000, 0x000fda0fc4000000,
    0x000a0e53ba000000, 0x0008a5abed000000, 0x000512ad97800000,
    0x000d3bf4f7400000, 0x00025fe002200000, 0x000cec3031500000,
    0x0009665831a80000, 0x000a2164325c0000, 0x000a719e17620000,
    0x000238af32770000, 0x000c4c75a97f8000, 0x00065750c3b0c000,
    0x000af99e0d996000, 0x000e6caf2c859000, 0x00002675b3c67800,
    0x000ac050d5e2bc00, 0x000f211e2eb1d600, 0x0002f16f1a1d4300,
    0x000a79959bc67880, 0x000a2c60d1e2bcc0, 0x0004474634b1d620,
    0x0005d00b071d43d0, 0x0004880ba44678c8, 0x000254cfe2a2bc64,
    0x00036b338c91d696, 0x0005175bdb4d43b9, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x0003000000000000,
    0x0003800000000000, 0x000c400000000000, 0x000e600000000000,
    0x0008500000000000, 0x0002380000000000, 0x00039c0000000000,
    0x00084e0000000000, 0x0005ef0000000000, 0x00019f8000000000,
    0x000c96c000000000, 0x0005e2a000000000, 0x0003c8d000000000,
    0x000fd45800000000, 0x0005db1400000000, 0x0007545e00000000,
    0x000e1bf900000000, 0x000f753a80000000, 0x000b2b1b40000000,
    0x00069cbaa0000000, 0x0006cedb50000000, 0x00032f9a88000000,
    0x00033fcb5c000000, 0x000566e286000000, 0x000daacf6d000000,
    0x00045c44bf800000, 0x000e6ef24c400000, 0x0009df7837600000,
    0x0008f60402300000, 0x000eb32636580000, 0x000271fd058c0000,
    0x0000081c98260000, 0x0003f5e67bd70000, 0x000aeb2621ac8000,
    0x000dbdfd15f44000, 0x00007e1caf7de000, 0x000686e67fd81000,
    0x0000baa63ccc9800, 0x0008843d24c7f400, 0x000a633c9fa07200,
    0x000188f653979900, 0x0008b45e34cc9880, 0x000d0bf938c7f440,
    0x000aad3ab9a072a0, 0x000fa71b6e979930, 0x00010aba834c98b8,
    0x0004addb6887f484, 0x0006a61aa8c07246, 0x00018a0b51a799b5,
    0x0008000000000000, 0x0004000000000000, 0x000e000000000000,
    0x0005000000000000, 0x0008800000000000, 0x000ac00000000000,
    0x0005e00000000000, 0x0002d00000000000, 0x000f880000000000,
    0x00088c0000000000, 0x0005ea0000000000, 0x00013b0000000000,
    0x000fb38000000000, 0x0001be4000000000, 0x000b94e000000000,
    0x0007cef000000000, 0x00006c2800000000, 0x000bbad400000000,
    0x000a726e00000000, 0x0007df6f00000000, 0x000e055680000000,
    0x000fe6bfc0000000, 0x000511b6a0000000, 0x0006e84fd0000000,
    0x000e9d9e98000000, 0x000a829bc4000000, 0x0003e7f0ba000000,
    0x000f11f4ef000000, 0x000de8a62d800000, 0x00031c4b24400000,
    0x0008c290b3a00000, 0x000cc644d6700000, 0x000821ee3c080000,
    0x0000b12f169c0000, 0x000419b6b8c60000, 0x0005a44fff650000,
    0x0008179ebb158000, 0x0006a99bc41ec000, 0x000ebc7089052000,
    0x000e33b4fc859000, 0x0009fe463cc49800, 0x000fb5bb25642c00,
    0x000d7f38a417c200, 0x000f75d0e19bd300, 0x00039ee011449880,
    0x000025f001242c40, 0x000e57a817b7c2e0, 0x0007889437ebd350,
    0x000c8c8e2d4c9808, 0x000bea9f17b82cec, 0x00043afeaf71c2be,
    0x0007322bc88ed37d, 0x0008000000000000, 0x000c000000000000,
    0x000a000000000000, 0x000f000000000000, 0x000a800000000000,
    0x000f400000000000, 0x000f600000000000, 0x000bf00000000000,
    0x0007c80000000000, 0x00007c0000000000, 0x0004ee0000000000,
    0x00081f0000000000, 0x0009568000000000, 0x000c6bc000000000,
    0x0008e42000000000, 0x00018a7000000000, 0x0000551800000000,
    0x0003233400000000, 0x0004d86a00000000, 0x000a85e300000000,
    0x0003fa7480000000, 0x00085c1d40000000, 0x000c7e54a0000000,
    0x000e266d70000000, 0x0001e34c88000000, 0x000279594c000000,
    0x000b5526a2000000, 0x000fa3ba71000000, 0x000e99d21f800000,
    0x000064671ec00000, 0x000dcba6a0a00000, 0x000fb47a6f300000,
    0x000893f23b180000, 0x0006f117034c0000, 0x000e483ebc420000,
    0x000fbc8e43e30000, 0x000bcfb800528000, 0x00060e841b0ac000,
    0x000a2f5201a6e000, 0x0004bfa708b61000, 0x00078786a1df4800,
    0x000ab20a6ded9c00, 0x000160ea30749a00, 0x0002f1233e7ee900,
    0x000848d4be5f4880, 0x000abdad732d9cc0, 0x000e4f6c90d49aa0,
    0x0003cf29514ee9f0, 0x000a0e3e85474828, 0x00002f8e70619c34,
    0x000bbf382c969a56, 0x000d064412ade94f, 0x0008000000000000,
    0x000c000000000000, 0x000e000000000000, 0x0009000000000000,
    0x0008800000000000, 0x0001c00000000000, 0x0001600000000000,
    0x000b900000000000, 0x0003f80000000000, 0x0002a40000000000,
    0x000f3e0000000000, 0x00062f0000000000, 0x000f168000000000,
    0x0003534000000000, 0x0007bc6000000000, 0x000a4a7000000000,
    0x000cc8c800000000, 0x0009ada400000000, 0x0002f3b600000000,
    0x0009cd3900000000, 0x000de3e580000000, 0x0005f44640000000,
    0x00072785a0000000, 0x0009da3670000000, 0x0003314d98000000,
    0x0005089254000000, 0x0004cc7bba000000, 0x000762eb53000000,
    0x000335fe3f800000, 0x0007c7dd3d400000, 0x000b0a3390600000,
    0x0000680f47d00000, 0x000d5c2834980000, 0x00039b940b6c0000,
    0x0000119e32c20000, 0x0001b9ad15210000, 0x000d84fbb3b38000,
    0x00058eab7148c000, 0x0006671e08f0a000, 0x00057aed042e5000,
    0x0007c09bada67800, 0x000460db4b76b400, 0x000d11d62f6bee00,
    0x000b384910c6ad00, 0x000b45ad92267880, 0x00056ea27636b4c0,
    0x0004b653bf0beee0, 0x0006227f5716ad90, 0x000f94e026be7808,
    0x000336303d5ab4dc, 0x000a62282dc9eef6, 0x0009b4943237ad29,
    0x0008000000000000, 0x0004000000000000, 0x000a000000000000,
    0x000d000000000000, 0x0005800000000000, 0x0002c00000000000,
    0x0001200000000000, 0x0003100000000000, 0x0000e80000000000,
    0x0001f40000000000, 0x00062e0000000000, 0x0001bf0000000000,
    0x0008178000000000, 0x000d02c000000000, 0x00019d6000000000,
    0x00049ad000000000, 0x000e710800000000, 0x000699ec00000000,
    0x00036dee00000000, 0x000f43a300000000, 0x0003fdd580000000,
    0x000e6a5c40000000, 0x0001a8b5a0000000, 0x0001148c50000000,
    0x00069fbd88000000, 0x0008066064000000, 0x000f6bd39e000000,
    0x000a28036f000000, 0x0004d4e61a800000, 0x000f3e4f23400000,
    0x000c563bb9200000, 0x000c62ff74900000, 0x0009ece029980000,
    0x00010310166c0000, 0x000f9de817c60000, 0x00039afc0d670000,
    0x0006f0062b338000, 0x0001d95f2c4c4000, 0x00008dd383d7a000,
    0x000d730376bbf000, 0x0000056631f81800, 0x000f778f16d97c00,
    0x000672db8d494e00, 0x000685ef7e570d00, 0x000f37082b781880,
    0x000d12ec35997c40, 0x0003f46e34694ea0, 0x000f2e630ac70dd0,
    0x000e3f3582e018d8, 0x0007d64c63f57c6c, 0x0009a2dd83af4eb2,
    0x00004cb057a00de1, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x000f000000000000, 0x000f800000000000,
    0x000a400000000000, 0x0001a00000000000, 0x000a700000000000,
    0x0008880000000000, 0x0006b40000000000, 0x0000720000000000,
    0x0000830000000000, 0x0006cb8000000000, 0x00061fc000000000,
    0x0008fc2000000000, 0x0004a6d000000000, 0x000c601800000000,
    0x000591ec00000000, 0x0001598200000000, 0x000b4cc300000000,
    0x0001cf4d80000000, 0x000c04cfc0000000, 0x00079b6da0000000,
    0x000a261fd0000000, 0x0000a175a8000000, 0x000cf0f3ec000000,
    0x0000497796000000, 0x000dd4f0c5000000, 0x000e639a10800000,
    0x00099a2f2cc00000, 0x0003274f92a00000, 0x000220cce6100000,
    0x000631803b680000, 0x000428c0081c0000, 0x000c45a036460000,
    0x000d3a1015630000, 0x000dd7b825368000, 0x000d68fc3b384000,
    0x000465ba0e16e000, 0x00000bff376ff000, 0x00047ed7ae18e800,
    0x00046de0eb40fc00, 0x00077fa231e3de00, 0x000ded130bf0c300,
    0x00003ed5be98e880, 0x000ccde3c780fc40, 0x000f8f4fa343de20,
    0x000fa4ccede0c3f0, 0x0002eb8005f0e878, 0x000d2fc00f9cfce4,
    0x000c54203505de3a, 0x000d22d02883c357, 0x0008000000000000,
    0x000c000000000000, 0x000a000000000000, 0x0003000000000000,
    0x000d800000000000, 0x0001c00000000000, 0x0004600000000000,
    0x000d100000000000, 0x0002080000000000, 0x0004240000000000,
    0x000ae20000000000, 0x000fb30000000000, 0x000e1a8000000000,
    0x000a4fc000000000, 0x000135a000000000, 0x0004eb1000000000,
    0x000197a800000000, 0x0007f9e400000000, 0x00087c6600000000,
    0x000eee7700000000, 0x000ac53b80000000, 0x000db233c0000000,
    0x00011a9ba0000000, 0x000dce23f0000000, 0x0003f5b388000000,
    0x000d0b07fc000000, 0x000d46f5be000000, 0x000191a0fb000000,
    0x000149c62f800000, 0x000605670f400000, 0x0001529387a00000,
    0x00094bd7efd00000, 0x0004e6fda4280000, 0x0002e054ed1c0000,
    0x000d508802420000, 0x000da9340f230000, 0x000e546e01148000,
    0x00087b831fcf4000, 0x00085e75b6ea2000, 0x0004bd60e8f8d000,
    0x00020ee622b3b800, 0x000295b70a1d0c00, 0x00049a9b83c55600,
    0x00000e23e366c300, 0x000d95b38d33b880, 0x00031b07c55d0cc0,
    0x0002cef5a46556a0, 0x000475a0fcb6c330, 0x000fcbc6211bb858,
    0x0004a66714410cdc, 0x000d4013b82756e6, 0x00072017f895c3e1,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x000d000000000000, 0x000f800000000000, 0x0004c00000000000,
    0x0006a00000000000, 0x0008f00000000000, 0x0004380000000000,
    0x0000240000000000, 0x0007fa0000000000, 0x000f4b0000000000,
    0x0005928000000000, 0x000fa6c000000000, 0x0004756000000000,
    0x000a339000000000, 0x0006d78800000000, 0x000b8c9c00000000,
    0x000e376200000000, 0x00029d3500000000, 0x00029e9980000000,
    0x0005d14ac0000000, 0x000609f9a0000000, 0x000dbddaf0000000,
    0x000daef1a8000000, 0x0007c886c4000000, 0x00089c7396000000,
    0x00039fe3d7000000, 0x000850820c800000, 0x000fc86534c00000,
    0x00049c71bc600000, 0x00019e46c4500000, 0x000551138b880000,
    0x00004873fd7c0000, 0x00005d0a2bc20000, 0x00073ff924e70000,
    0x000da193be978000, 0x000471b3cce94000, 0x000078ea07a9a000,
    0x0000c5a9058b3000, 0x0002ebfba67c2800, 0x0001e37fe543e400,
    0x000fdfe029244e00, 0x0004b1500571cf00, 0x0008d8e82afc2880,
    0x0007340c1183e4c0, 0x0004526a35444e20, 0x000a87693121cfd0,
    0x000a449b89742878, 0x0005abefe8ffe48c, 0x000182e828864e4a,
    0x000c8f0c32c6cf5f, 0x0008000000000000, 0x0004000000000000,
    0x000e000000000000, 0x000d000000000000, 0x000f800000000000,
    0x0001400000000000, 0x000e600000000000, 0x0009900000000000,
    0x0004780000000000, 0x000ef40000000000, 0x0004de0000000000,
    0x00012f0000000000, 0x000bc78000000000, 0x000dca4000000000,
    0x000421e000000000, 0x0001711000000000, 0x000d29b800000000,
    0x0008adb400000000, 0x00025b2600000000, 0x0009595900000000,
    0x000e052f80000000, 0x0005b73840000000, 0x0008634fa0000000,
    0x00014c6850000000, 0x000e8b1798000000, 0x000d40cc64000000,
    0x00046189a6000000, 0x000a902161000000, 0x0006f9801f800000,
    0x0000354007400000, 0x000bfe602e600000, 0x0006df502c900000,
    0x00062e5805180000, 0x000747a41c2c0000, 0x000e0b1e14060000,
    0x000481ad2e050000, 0x0007c069bd018000, 0x000ea1314d814000,
    0x000bb03838476000, 0x000c08f404e79000, 0x00025d463a53f800,
    0x00003209013ef400, 0x00029577ab594600, 0x000a4f9c51cb1500,
    0x0009d7d1bdd3f880, 0x0006f385627ef440, 0x0009b49e233946e0,
    0x0003bfed1c5b15d0, 0x00093f89a74bf878, 0x0003ff217912f454,
    0x0002de00195f4606, 0x00082f001ece1549, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x000b000000000000,
    0x000c800000000000, 0x0004c00000000000, 0x0003a00000000000,
    0x0001f00000000000, 0x0009480000000000, 0x000ebc0000000000,
    0x0003760000000000, 0x0008270000000000, 0x00031f8000000000,
    0x0006aac000000000, 0x000701a000000000, 0x0002813000000000,
    0x0005c12800000000, 0x0004201c00000000, 0x0009b14200000000,
    0x000e29fb00000000, 0x000cecb480000000, 0x000bceae40000000,
    0x000fd294a0000000, 0x000ed55e50000000, 0x000dfa1c88000000,
    0x000c38727c000000, 0x00073476ba000000, 0x00046a956f000000,
    0x0001a00034800000, 0x000ef00028c00000, 0x000fc80031a00000,
    0x00017c0002300000, 0x000c560014780000, 0x000d17000eac0000,
    0x0009f7802a060000, 0x0009e6c007070000, 0x000d3fa038808000,
    0x00041a300ac3c000, 0x0005a8a80aa42000, 0x000aaddc20b3b000,
    0x000daf6221b92800, 0x000a020b38885c00, 0x000e2c3c9e75fa00,
    0x000d6f824d19e500, 0x0003a2fe9d392880, 0x0004dcb96c485c40,
    0x0008a7ea15d5faa0, 0x0009df272029e5b0, 0x00040a56bdc12848,
    0x000171654a245c0c, 0x000388880e73fa9a, 0x000c1d2c251ee5af,
    0x0008000000000000, 0x000c000000000000, 0x0006000000000000,
    0x0005000000000000, 0x000a800000000000, 0x0002c00000000000,
    0x000fe00000000000, 0x0005100000000000, 0x000ef80000000000,
    0x0000640000000000, 0x0005760000000000, 0x0001070000000000,
    0x00022e8000000000, 0x0000524000000000, 0x000fd0e000000000,
    0x000d18b000000000, 0x0003756800000000, 0x000e8e5400000000,
    0x000be35600000000, 0x0005985900000000, 0x000eb5cd80000000,
    0x0008efbf40000000, 0x0003b3ada0000000, 0x000cc14f70000000,
    0x0006e025b8000000, 0x000990ab64000000, 0x0009389b92000000,
    0x000504e66f000000, 0x0002a6e02d800000, 0x00001fb03b400000,
    0x00075be836600000, 0x000bdc140ad00000, 0x000eb3b63bb80000,
    0x000a40e91acc0000, 0x000220a599020000, 0x000371eb50850000,
    0x0006a8fbb9c18000, 0x00093d1640a7c000, 0x000d23e817f42000,
    0x000078142f0e9000, 0x0008a5b627a17800, 0x000997e90673f400,
    0x000b9625b24c4e00, 0x000497ab64c40900, 0x000d161bb2217880,
    0x000056a65933f4c0, 0x0007f600162c4e60, 0x000fc70001140950,
    0x000bce8024197828, 0x0000424038bff4ec, 0x000ba8e0194e4e9e,
    0x000fbcb02b410901, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x000b000000000000, 0x000c800000000000,
    0x0007c00000000000, 0x000c200000000000, 0x0001300000000000,
    0x0006180000000000, 0x000c340000000000, 0x0005820000000000,
    0x000a130000000000, 0x0005fb8000000000, 0x0009774000000000,
    0x000d302000000000, 0x000418b000000000, 0x000134c800000000,
    0x0002038c00000000, 0x000153ca00000000, 0x000e1a1900000000,
    0x000467a780000000, 0x000a19f3c0000000, 0x000e3407a0000000,
    0x00088203d0000000, 0x000d92efb8000000, 0x000eba3ffc000000,
    0x0002966d8a000000, 0x000020eae3000000, 0x000330203a800000,
    0x000b18b027c00000, 0x000bb4c802e00000, 0x000ec38c07100000,
    0x0001f3ca0ce80000, 0x0008ea19035c0000, 0x000e5fa7a9060000,
    0x00071df3f9810000, 0x000dae078d468000, 0x000ea503fd23c000,
    0x000deb6f89f5a000, 0x000dde7fe9fdf000, 0x000a5dcda8b28800,
    0x000d4f1ae6d99400, 0x000f34c81e421600, 0x000d038c2fa35b00,
    0x000bd3ca2a328880, 0x0002da193d199440, 0x0004c7a796a21660,
    0x000ce9f3cbb35bb0, 0x00040c079c5a8848, 0x00058603d985943c,
    0x000e08ef9d4416a2, 0x00089d3fe5225ba3, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x0005000000000000,
    0x000f800000000000, 0x0002c00000000000, 0x0009600000000000,
    0x000cf00000000000, 0x0006280000000000, 0x000dd40000000000,
    0x000fea0000000000, 0x0004bb0000000000, 0x0009038000000000,
    0x00010ec000000000, 0x000f986000000000, 0x00045c9000000000,
    0x000dae4800000000, 0x0004892400000000, 0x0009c59a00000000,
    0x0008f36f00000000, 0x000ca66d80000000, 0x000a8d6cc0000000,
    0x0007d78da0000000, 0x000a643cd0000000, 0x0009622588000000,
    0x000c7f48c4000000, 0x00047197b6000000, 0x000a6993cf000000,
    0x0003f42813800000, 0x000dbab43cc00000, 0x000882522b200000,
    0x000ccf8b1b900000, 0x000c7817bc880000, 0x0005ec53dd7c0000,
    0x000027c806860000, 0x000ccce402470000, 0x000cf67a15678000,
    0x0007b53f24f54000, 0x00079a45ad7ea000, 0x0000d3d8de81d000,
    0x0005f7df8e40c800, 0x000634b7c7606c00, 0x000a5bb20df77e00,
    0x000332db39fedf00, 0x000447bf95c0c880, 0x000bbc27ffa06c40,
    0x00021ffa30d77ea0, 0x000600ff3d6edf50, 0x000b01a5b2c8c878,
    0x00008188da1c6c6c, 0x000841f7ab717e36, 0x00042103ebb9df9f,
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x000b000000000000, 0x0004800000000000, 0x0005c00000000000,
    0x0003a00000000000, 0x000e700000000000, 0x0009980000000000,
    0x0000440000000000, 0x000bb20000000000, 0x0000a30000000000,
    0x00046b8000000000, 0x000407c000000000, 0x000ec8a000000000,
    0x000f6d3000000000, 0x000c4f0800000000, 0x000f643c00000000,
    0x0004031200000000, 0x00089b7100000000, 0x00015e6180000000,
    0x0002acd3c0000000, 0x000bef41a0000000, 0x00031523d0000000,
    0x00069b69a8000000, 0x000c5feffc000000, 0x000f2dd3ba000000,
    0x0001ae92eb000000, 0x0001f42834800000, 0x000e8acc12c00000,
    0x000816ba32e00000, 0x0008817d03d00000, 0x0003c1fb94280000,
    0x000aa05eed5c0000, 0x0001f09237860000, 0x0008d8b13a430000,
    0x000624c1aa248000, 0x000662e3c237c000, 0x00074bc98778a000,
    0x000db6dfd5b73000, 0x000ff0dbad3ce800, 0x0005d9aef796f400,
    0x000ba4ba030b6e00, 0x000c227d02eabb00, 0x0005aa7bb1bce880,
    0x0005a79ed956f440, 0x000bb8322beb6e20, 0x000275813a3abbb0,
    0x0009cbc9b914e8c8, 0x000776dfdacaf41c, 0x000ad0db948d6e1a,
    0x000569aee8a9bb57, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x000b000000000000, 0x0005800000000000,
    0x000ac00000000000, 0x000de00000000000, 0x000e900000000000,
    0x0009980000000000, 0x00082c0000000000, 0x0009d60000000000,
    0x0003e70000000000, 0x0006cf8000000000, 0x00008ac000000000,
    0x000239a000000000, 0x000b1c1000000000, 0x00067fc800000000,
    0x0000e23400000000, 0x00085c0600000000, 0x000f5fc500000000,
    0x0002937880000000, 0x0001d48e40000000, 0x0001ab58a0000000,
    0x0004495e50000000, 0x000894b088000000, 0x00038aba7c000000,
    0x0003b95e9e000000, 0x000bdd9b57000000, 0x00009e4829800000,
    0x000bf3f42d400000, 0x000b04262fe00000, 0x000a92151df00000,
    0x0005d490a0b80000, 0x000bab6a7e6c0000, 0x000f48b68d860000,
    0x000d157f47470000, 0x00094a261ae08000, 0x000e59153d774000,
    0x00054d10937fa000, 0x000906aa654f9000, 0x0003de96aad7b800,
    0x0002d3af51ec8400, 0x0009744e23c45a00, 0x00031b313325bd00,
    0x000b20de8b57b880, 0x000d705b40ac8440, 0x0006086832245aa0,
    0x000f352429d5bdb0, 0x000eba4e0a6fb8d8, 0x000d10312f8084ec,
    0x0006595eae425a7e, 0x00014d9b7462bd59, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x0005000000000000,
    0x0000800000000000, 0x0005400000000000, 0x000d600000000000,
    0x000e500000000000, 0x000ab80000000000, 0x000e940000000000,
    0x0001b20000000000, 0x00070b0000000000, 0x00039f8000000000,
    0x00092c4000000000, 0x000ba7e000000000, 0x000df87000000000,
    0x000cf49800000000, 0x000462d400000000, 0x000d736e00000000,
    0x0005aaa100000000, 0x000eefa780000000, 0x000525ffc0000000,
    0x00041b3fa0000000, 0x0000472bd0000000, 0x0007e85198000000,
    0x0005ad8ac4000000, 0x0004e7f61a000000, 0x000b987511000000,
    0x000724c98f800000, 0x000b1b5ef8400000, 0x000bc6983d600000,
    0x000729d406100000, 0x000d0cee21a80000, 0x000296e10b3c0000,
    0x00021047a0560000, 0x000d598fd7cd0000, 0x000e85a7b3a98000,
    0x0003eaffe63cc000, 0x00020ebfa1d3e000, 0x0000b46bfc8b9000,
    0x00038231b4485800, 0x000d62bafdec1400, 0x0007f30e1c5f4600,
    0x000bea911f472b00, 0x00060edf95e05880, 0x000eb45bf6d01440,
    0x00068349bc0946e0, 0x000de31ec88a2b50, 0x0002b3782649d888,
    0x00068aa410ecd414, 0x00085ff61ddaa636, 0x00040c753401bbb5,
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x000b000000000000, 0x0001800000000000, 0x0005400000000000,
    0x000fa00000000000, 0x0008300000000000, 0x000ca80000000000,
    0x00095c0000000000, 0x000b7a0000000000, 0x0002d30000000000,
    0x00070f8000000000, 0x0001b5c000000000, 0x000307a000000000,
    0x0007581000000000, 0x0008957800000000, 0x0009f72c00000000,
    0x0008103a00000000, 0x000cd9d700000000, 0x0002d55080000000,
    0x0005d745c0000000, 0x000e6028a0000000, 0x000e5069d0000000,
    0x0006f812a8000000, 0x000da5befc000000, 0x000ddf422e000000,
    0x000e8dfb29000000, 0x000cc2eab0800000, 0x0002d752d9c00000,
    0x0009e0d82a200000, 0x0002103c00b00000, 0x0003d8c229c80000,
    0x0001543b22fc0000, 0x000b974a85760000, 0x00004042fdeb0000,
    0x0003202023488000, 0x0005f1d0203b4000, 0x000cc8d808d56000,
    0x000a0c3c351bf000, 0x000502c225e38800, 0x0000b73b1797ac00,
    0x0001b0caabfe4a00, 0x000de982e5f1fb00, 0x0004fd800c2b8880,
    0x00084ac0356bac40, 0x000ffa202e884a20, 0x000b12d0181afbb0,
    0x00056f582f630898, 0x0009e5fc1550ec14, 0x000cff62265d2ada,
    0x00007c2b2d010b33, 0x0008000000000000, 0x000c000000000000,
    0x000a000000000000, 0x0005000000000000, 0x0004800000000000,
    0x0009c00000000000, 0x0004200000000000, 0x0005100000000000,
    0x000c280000000000, 0x00025c0000000000, 0x0006560000000000,
    0x0009ff0000000000, 0x000fe28000000000, 0x000ad5c000000000,
    0x000eda6000000000, 0x0008a07000000000, 0x0000d08800000000,
    0x0002086c00000000, 0x00024dbe00000000, 0x000eff3300000000,
    0x0002635480000000, 0x000d950040000000, 0x00063bdca0000000,
    0x000d116c70000000, 0x0000286288000000, 0x00085d5f64000000,
    0x000357b61a000000, 0x000d7e9f03000000, 0x0006228aaa800000,
    0x000ef54367400000, 0x000bca8012200000, 0x000489c00a300000,
    0x00028c6011780000, 0x00045f702ecc0000, 0x000bb20804720000,
    0x00011dac22db0000, 0x0008b7de0d3b8000, 0x00034f433a6ac000,
    0x000e9bdcb701a000, 0x000dc16c48877000, 0x0002206288455800,
    0x000a115f46a0bc00, 0x000da9b634738a00, 0x000f1d9f0ade7d00,
    0x000bb60a993d5880, 0x0008cf83686cbcc0, 0x0006da6030018aa0,
    0x0004a07028057d50, 0x000ad0881406d8c8, 0x0007086c12067c5c,
    0x0006cdbe27002ae2, 0x00073f3310820d01, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x0007000000000000,
    0x0003800000000000, 0x0000400000000000, 0x0007600000000000,
    0x000df00000000000, 0x0008480000000000, 0x0008440000000000,
    0x000fca0000000000, 0x0005c30000000000, 0x0007e78000000000,
    0x000f5c4000000000, 0x000617a000000000, 0x000d145000000000,
    0x0007521800000000, 0x00065e5400000000, 0x0001503a00000000,
    0x0006996b00000000, 0x00049c9780000000, 0x00053784c0000000,
    0x0009848fa0000000, 0x0005ead0d0000000, 0x0005d33598000000,
    0x00069ffbcc000000, 0x000bf00216000000, 0x000b482f0d000000,
    0x0005c495ab800000, 0x00088babeac00000, 0x0001221a12a00000,
    0x000a567b07d00000, 0x000074afbb880000, 0x0003a2c0dddc0000,
    0x000a968daf960000, 0x000ad5ffda6d0000, 0x000e72203d688000,
    0x000bcf1025ec4000, 0x000768380da8e000, 0x0006d5442c491000,
    0x000472022cfe0800, 0x0002cf2f1681bc00, 0x0003e915a944d600,
    0x000514ebfc63ef00, 0x0003523a17760880, 0x00085e6b0b5dbc40,
    0x00065117a6d2d6e0, 0x000518c4f60eef70, 0x0004dcafb21e88b8,
    0x000256c0e2b1fc44, 0x0004748dbd7a3696, 0x000da2ffd747ffaf,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x0003000000000000, 0x0004800000000000, 0x0005c00000000000,
    0x000aa00000000000, 0x000b500000000000, 0x0001780000000000,
    0x0004240000000000, 0x0000620000000000, 0x000ddb0000000000,
    0x0008de8000000000, 0x0000acc000000000, 0x00006fa000000000,
    0x0009e5b000000000, 0x0006c3c800000000, 0x00048a3c00000000,
    0x000aa66600000000, 0x0000084100000000, 0x0005ccd980000000,
    0x000e9f43c0000000, 0x00054d11a0000000, 0x00055e7ff0000000,
    0x000eedf7a8000000, 0x00098efefc000000, 0x000ed48e3a000000,
    0x0002cb0d2b000000, 0x000f46d7b0800000, 0x0005388ef6400000,
    0x0002c4661d600000, 0x0001d3411ad00000, 0x000f1259a6e80000,
    0x000d3383c6bc0000, 0x0001a2b195120000, 0x00097bcfc24f0000,
    0x00028e3fa1cc8000, 0x000654c2c309c000, 0x00050ae8062ba000,
    0x0006e74c0c9d3000, 0x000ae80e01203800, 0x00067ccd34b33400,
    0x000f57f7b8bfde00, 0x000421fec017fb00, 0x0001900e27c83880,
    0x000d58cd320f34c0, 0x0009b5f78dadde20, 0x000f3afef258fb30,
    0x00076e8e2e04b8c8, 0x0003640d0d06f49c, 0x00020257b1867e8a,
    0x0009ab4ed5c5cb85, 0x0008000000000000, 0x000c000000000000,
    0x000a000000000000, 0x000b000000000000, 0x0009800000000000,
    0x0005c00000000000, 0x0001200000000000, 0x0000700000000000,
    0x0004e80000000000, 0x0004ac0000000000, 0x000f7e0000000000,
    0x0002b70000000000, 0x000a6a8000000000, 0x000bfdc000000000,
    0x0006e7a000000000, 0x000a721000000000, 0x0006f86800000000,
    0x000b556c00000000, 0x000aaab200000000, 0x000e5de700000000,
    0x000bd60e80000000, 0x0008fb3b40000000, 0x000f44e6a0000000,
    0x0004539770000000, 0x000909f488000000, 0x000b7c605c000000,
    0x000da7922e000000, 0x000d12370b000000, 0x000969c68a800000,
    0x00076c477ac00000, 0x000f5e3c91200000, 0x0000471c74700000,
    0x0002c34822d80000, 0x000bb1bc05ac0000, 0x0008c9fa09f20000,
    0x000c5c5b0c9b0000, 0x000cd7f4ad4c8000, 0x000b7b605a234000,
    0x000185121ef52000, 0x000cf3f7081af000, 0x000cb866ac8de800,
    0x000eb55749866c00, 0x00097ad48c415200, 0x000684b075e5c100,
    0x000f72da0655e880, 0x0002788b102a6cc0, 0x000614bcabb352a0,
    0x000ccadc727ec1b0, 0x00034ce821996818, 0x000bafac30c92c9c,
    0x0009ef92246672b2, 0x00000e370e1431b7, 0x0008000000000000,
    0x000c000000000000, 0x0002000000000000, 0x0005000000000000,
    0x0007800000000000, 0x0001400000000000, 0x0002a00000000000,
    0x0006900000000000, 0x0000e80000000000, 0x00054c0000000000,
    0x0008220000000000, 0x000c6b0000000000, 0x0004b68000000000,
    0x000cfcc000000000, 0x00061b6000000000, 0x000eef1000000000,
    0x000b08f800000000, 0x000d7d4c00000000, 0x000c5a4e00000000,
    0x000ccfcb00000000, 0x000e583e80000000, 0x0009f40cc0000000,
    0x000c6646a0000000, 0x00003580f0000000, 0x00010768a8000000,
    0x0000c55be4000000, 0x00019fae36000000, 0x0006d01b21000000,
    0x000bc9a69c800000, 0x00059d50cb400000, 0x0008ea70b7200000,
    0x000977c7fa700000, 0x000f9c7801a80000, 0x0001ea8c1adc0000,
    0x000cf7ae27f20000, 0x000bdc1b066f0000, 0x0004cba6bebf8000,
    0x000b2650e6a34000, 0x000994f08fb46000, 0x00071707c2ca7000,
    0x0003ed180e0f5800, 0x0000b29c3dea5c00, 0x000b83d600782200,
    0x00037a9732452f00, 0x00021e08a7a75880, 0x0009914bc3365cc0,
    0x000e69d6118a2220, 0x00018d97152a2f50, 0x000ec2888598d8f8,
    0x000fda8beed51cd4, 0x00038e36291e420a, 0x000bf9472d905f39,
    0x0008000000000000, 0x0004000000000000, 0x0002000000000000,
    0x0001000000000000, 0x0002800000000000, 0x0008400000000000,
    0x0008200000000000, 0x0005500000000000, 0x0003780000000000,
    0x000b040000000000, 0x0003be0000000000, 0x0000670000000000,
    0x0003738000000000, 0x000b15c000000000, 0x000c66e000000000,
    0x0005733000000000, 0x000814f800000000, 0x000fe69c00000000,
    0x000fb3c600000000, 0x0008743100000000, 0x0002963d80000000,
    0x00099a1440000000, 0x00000945a0000000, 0x000a2d4850000000,
    0x000a4263a8000000, 0x00031d4954000000, 0x00024b2622000000,
    0x000d300135000000, 0x000a0945a2800000, 0x000f2d4870400000,
    0x000ac26387600000, 0x000a5d4948500000, 0x0008eb260b980000,
    0x000020012ccc0000, 0x000151458cd60000, 0x0001794864db0000,
    0x000a0463b82d8000, 0x00013e495c47c000, 0x000826a619666000,
    0x000b52c12b51b000, 0x000e4425ae1f7800, 0x000f1fb8430a7400,
    0x000e767b9d720e00, 0x000babe571a9e500, 0x000f81980d877880,
    0x000cc06c3bc67440, 0x000361de33a40e20, 0x000ef19d2072e510,
    0x000ce903972af8a8, 0x00081cb957c1b4c4, 0x0005cabe0da26ea2,
    0x0005f06d13735545, 0x0008000000000000, 0x0004000000000000,
    0x0002000000000000, 0x0007000000000000, 0x0004800000000000,
    0x0008c00000000000, 0x0009a00000000000, 0x0005700000000000,
    0x0004b80000000000, 0x0005040000000000, 0x0000ca0000000000,
    0x0006530000000000, 0x000e678000000000, 0x000975c000000000,
    0x0001f22000000000, 0x000a173000000000, 0x000c4ce800000000,
    0x000fb67c00000000, 0x000f3d2200000000, 0x000e0ffd00000000,
    0x0009b85180000000, 0x00028462c0000000, 0x000e8b39a0000000,
    0x000033ded0000000, 0x0006363ba8000000, 0x00007c13cc000000,
    0x0009ef023a000000, 0x000aa8cd2f000000, 0x000e6cb9bc800000,
    0x0002861eeac00000, 0x0008e41b86600000, 0x0000db23f2d00000,
    0x000c3bea1f480000, 0x000daab1149c0000, 0x000c839bb2560000,
    0x000aaee3d78b0000, 0x000b49ca29fe8000, 0x00087d813207c000,
    0x000def73b3052000, 0x0008a89fee823000, 0x00096ce829c7a800,
    0x0006067c10e6c400, 0x000025223f106e00, 0x00097bfd39ac8f00,
    0x00094a519e8fa880, 0x00091362c87ac440, 0x000986b9b7466e20,
    0x000a651ec1278f70, 0x000d1b9b8bf128c8, 0x00061ae3d0bd04cc,
    0x00049bca22234eba, 0x00095a810d75bf27, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x0007000000000000,
    0x0008800000000000, 0x0000400000000000, 0x0006600000000000,
    0x000c500000000000, 0x0005780000000000, 0x000cac0000000000,
    0x00099a0000000000, 0x0006c30000000000, 0x000e5f8000000000,
    0x0003ecc000000000, 0x00037b2000000000, 0x0000d3b000000000,
    0x000a467800000000, 0x000b911400000000, 0x000fd86e00000000,
    0x000cdd5900000000, 0x0001d34880000000, 0x000bc6ddc0000000,
    0x000e50b0a0000000, 0x00067809d0000000, 0x000e2c7e88000000,
    0x000eda20cc000000, 0x0008226e2a000000, 0x00024e590d000000,
    0x0000f4c893800000, 0x0003861dec400000, 0x000c31908e600000,
    0x000028b9d2f00000, 0x000c5586a2080000, 0x000af7f4d4fc0000,
    0x0001f92020f60000, 0x0002ecb02b0f0000, 0x0002fbf8017a8000,
    0x000512d43bb1c000, 0x0003e6ce33eb6000, 0x0009612920499000,
    0x0000d190b19cd800, 0x000f38b9c683f400, 0x000dcd86bbc37a00,
    0x000d4bf4c4254300, 0x0003fb201b94d880, 0x000493b01e7ff440,
    0x0006267811357aa0, 0x0000c114322a4370, 0x0002206e016e5808,
    0x00003159058e3444, 0x000e294886be1ac6, 0x000155ddcd93d3b5,
    0x0008000000000000, 0x000c000000000000, 0x0006000000000000,
    0x000f000000000000, 0x000b800000000000, 0x0009400000000000,
    0x000aa00000000000, 0x000b900000000000, 0x0007780000000000,
    0x00087c0000000000, 0x0005b60000000000, 0x000c2f0000000000,
    0x000be28000000000, 0x00097c4000000000, 0x000d36a000000000,
    0x0008ef5000000000, 0x0007033800000000, 0x0003cd4c00000000,
    0x00089fae00000000, 0x000d4b9900000000, 0x000159aa80000000,
    0x000d2d1a40000000, 0x00072e12a0000000, 0x000a631670000000,
    0x00093d9cb8000000, 0x0003179f4c000000, 0x0001bfae16000000,
    0x00039b9929000000, 0x000a81aa9c800000, 0x0001c11a77400000,
    0x000e6012b9600000, 0x000770165ab00000, 0x000dc91c99b80000,
    0x000dd4df730c0000, 0x0000138e32b20000, 0x000a74891dbd0000,
    0x0005023291088000, 0x0006cc0641b04000, 0x000a1e04be3c6000,
    0x00008a8353c97000, 0x000939b81310d800, 0x00055d0c2aaa1400,
    0x0001670e29a6f200, 0x000ef7c923123d00, 0x00038e12b2a8d880,
    0x0002f31655a614c0, 0x0003c59cad14f260, 0x000d2b9f67af3df0,
    0x000529ae07205838, 0x000d64992f565454, 0x000cbb2abc4892ca,
    0x000b515a47d64d49, 0x0008000000000000, 0x000c000000000000,
    0x0002000000000000, 0x0007000000000000, 0x0003800000000000,
    0x000dc00000000000, 0x000de00000000000, 0x0006d00000000000,
    0x0009080000000000, 0x0006dc0000000000, 0x0001e60000000000,
    0x00034f0000000000, 0x000f628000000000, 0x000ebcc000000000,
    0x0003f72000000000, 0x000127d000000000, 0x00062fa800000000,
    0x0005f2b400000000, 0x000094fe00000000, 0x000d9b1700000000,
    0x0002d94880000000, 0x000754d240000000, 0x000b7a60a0000000,
    0x000589a670000000, 0x00049d3ea8000000, 0x0003c6a16c000000,
    0x000f7e7e26000000, 0x00033bd71b000000, 0x000ca868b1800000,
    0x00092c0270400000, 0x00055f48bda00000, 0x00030bd247300000,
    0x0002f0e0bc380000, 0x000c3966610c0000, 0x000c041eb8320000,
    0x000ab27177bf0000, 0x000a3556244e8000, 0x000deaa333104000,
    0x0009a136bf482000, 0x000df00542969000, 0x0003b8882f09d800,
    0x0003c5642f35cc00, 0x00005356303a7a00, 0x000f65a3170ac500,
    0x000923b6bb31d880, 0x00029cc56239ccc0, 0x000ac7a80e087a20,
    0x0009feb40bb5c570, 0x000a7afe06ff58b8, 0x000f08170d698c1c,
    0x000fddc88ae05afe, 0x000767126513551d, 0x0008000000000000,
    0x0004000000000000, 0x000e000000000000, 0x000b000000000000,
    0x0008800000000000, 0x000d400000000000, 0x0004600000000000,
    0x000d900000000000, 0x0008180000000000, 0x000d540000000000,
    0x000d060000000000, 0x000c0f0000000000, 0x000e038000000000,
    0x000f304000000000, 0x0000282000000000, 0x000ffdb000000000,
    0x000abbd800000000, 0x0001553400000000, 0x0007061600000000,
    0x00090efd00000000, 0x000d83fb80000000, 0x000af05940000000,
    0x00090803a0000000, 0x00060cdd50000000, 0x000f33cd98000000,
    0x000418147c000000, 0x000755a03a000000, 0x000806f009000000,
    0x000f8e780b800000, 0x000bc3c42f400000, 0x0006106e13e00000,
    0x0009d93936100000, 0x000a759585f80000, 0x000ff660732c0000,
    0x000106160c760000, 0x00060efd29ad0000, 0x000b03fbb4b68000,
    0x000cb0595f0bc000, 0x0005e8039041e000, 0x0006dcdd63631000,
    0x00034bcdbfd7b800, 0x0004dc1454d9e400, 0x00024ba01a98d600,
    0x00095df036fe4100, 0x000c8bf831afb880, 0x0008fc8408b5e440,
    0x00083bce050ed6e0, 0x000914c9294341b0, 0x0000e66d80e13808,
    0x00015ee464922494, 0x000cbbd8393936a6, 0x000e5534338d5169,
    0x0008000000000000, 0x000c000000000000, 0x0002000000000000,
    0x0009000000000000, 0x0000800000000000, 0x000fc00000000000,
    0x000ae00000000000, 0x0001100000000000, 0x0002480000000000,
    0x0008d40000000000, 0x0008860000000000, 0x00045f0000000000,
    0x0006828000000000, 0x000870c000000000, 0x000918e000000000,
    0x000d3d7000000000, 0x000d62c800000000, 0x0005e1b400000000,
    0x0006910600000000, 0x0006097700000000, 0x0004745180000000,
    0x000c365340000000, 0x00022679a0000000, 0x0007ee9770000000,
    0x000b7bb7a8000000, 0x000f5d5454000000, 0x000fb2602a000000,
    0x000f49b02b000000, 0x0006542821800000, 0x000c47c41f400000,
    0x00073f4e20a00000, 0x0008d30318100000, 0x000f193780b80000,
    0x000a3d94766c0000, 0x0006e28011320000, 0x0003a0c023ef0000,
    0x000330e014718000, 0x00023970204ac000, 0x000dccc809e2a000,
    0x0007bab43db01000, 0x00003d86202cb800, 0x0003e2b73f16cc00,
    0x00012031b73e7e00, 0x0005f0e35c2a4100, 0x000858d18114b880,
    0x00031d93563accc0, 0x000f121986ac7e20, 0x0009f82767d54190,
    0x00092d1f95dd3888, 0x000daa50401c0c3c, 0x000bf5ce3e7cde8e,
    0x000477c3098a5181, 0x0008000000000000, 0x0004000000000000,
    0x0006000000000000, 0x0003000000000000, 0x0005800000000000,
    0x000a400000000000, 0x0000200000000000, 0x0003900000000000,
    0x0009380000000000, 0x00041c0000000000, 0x00080a0000000000,
    0x0003e30000000000, 0x000f678000000000, 0x000ca14000000000,
    0x000d502000000000, 0x0003d81000000000, 0x000b6d9800000000,
    0x000d43fc00000000, 0x0007363e00000000, 0x0009f8d100000000,
    0x0009fd9680000000, 0x0004fa05c0000000, 0x000fea2ea0000000,
    0x000e12e9d0000000, 0x0003ee08b8000000, 0x00011484dc000000,
    0x000dff802e000000, 0x00066d4035000000, 0x000fc2200e800000,
    0x000ef7102b400000, 0x0000981832600000, 0x000fcdbc37300000,
    0x0004139e04480000, 0x0002ee8111bc0000, 0x000195aeb9560000,
    0x00013fa9ed790000, 0x00098c2888f68000, 0x00063394e2694000,
    0x00047f981d68e000, 0x000e2cfc14eab000, 0x000ae3be0a2e1800,
    0x000be691388cf400, 0x000660368018c200, 0x0001b055e644a300,
    0x000fa81680e61880, 0x000ba445c270f440, 0x0003d78eab2ec260,
    0x000188b9ec0da330, 0x000f3430b45898d8, 0x00096e28eda5b4e4,
    0x000cd40621102262, 0x00029e7d209e1309, 0x0008000000000000,
    0x0004000000000000, 0x000a000000000000, 0x0001000000000000,
    0x000d800000000000, 0x000b400000000000, 0x000da00000000000,
    0x000a100000000000, 0x000cd80000000000, 0x0006940000000000,
    0x000ae60000000000, 0x0007ef0000000000, 0x0008c38000000000,
    0x000340c000000000, 0x0009a1e000000000, 0x000010d000000000,
    0x000dd8f800000000, 0x000b156c00000000, 0x0001a79e00000000,
    0x000a4e6d00000000, 0x0002d38b80000000, 0x000f98d540000000,
    0x000f3493a0000000, 0x000af66950000000, 0x000a367588000000,
    0x0003d6a854000000, 0x0002e6003e000000, 0x0003ef0039000000,
    0x0002c38028800000, 0x000240c001400000, 0x000421e033e00000,
    0x000b50d01f100000, 0x000078f82e780000, 0x0001056c2dac0000,
    0x000d7f9e3bf60000, 0x000cda6d08ef0000, 0x0008358bae118000,
    0x000877d552fc4000, 0x0007f71392ea6000, 0x0009b6a97115f000,
    0x000397959f7a1800, 0x0003c678512f4400, 0x000f3ef804b3b600,
    0x0008fa6c020f5100, 0x0003641e19821880, 0x00080ead3dc34440,
    0x0006f26baca5b6a0, 0x0004c80545f05110, 0x000f4c6b91eb9858,
    0x000bf305569304f4, 0x000749eb9bb9d67a, 0x000f0cc5550aa1b1,
    0x0008000000000000, 0x000c000000000000, 0x000a000000000000,
    0x000b000000000000, 0x000c800000000000, 0x0008c00000000000,
    0x0005e00000000000, 0x000bf00000000000, 0x000a980000000000,
    0x0006840000000000, 0x000d7e0000000000, 0x0001570000000000,
    0x000bea8000000000, 0x000041c000000000, 0x000b21a000000000,
    0x000f11b000000000, 0x0006e9e800000000, 0x00085c3400000000,
    0x0006dada00000000, 0x0002399100000000, 0x000bd57d80000000,
    0x0007b76c40000000, 0x00009b35a0000000, 0x000819e870000000,
    0x0003448788000000, 0x00051e8d5c000000, 0x0005e6003a000000,
    0x0000d3003f000000, 0x000014800d800000, 0x0002d6c020c00000,
    0x0009ab200fe00000, 0x000c607016d00000, 0x0002b04808180000,
    0x000a3984308c0000, 0x0007d53230320000, 0x000db6a51e4b0000,
    0x000b9b27b6d48000, 0x0004983d781dc000, 0x000b8568388b2000,
    0x0000fef42c311000, 0x000e17fa044a4800, 0x000a4ae139d05400,
    0x000691b59d993e00, 0x000fa828544b2500, 0x0008fd2781d24880,
    0x00078b3d699c54c0, 0x0002f1e8024b3ea0, 0x000118342cd025b0,
    0x0008c4da371ec848, 0x000b5e913d0d944c, 0x0003c7fd90f21efe,
    0x000242ac51aa350f, 0x0008000000000000, 0x0004000000000000,
    0x000a000000000000, 0x000f000000000000, 0x000a800000000000,
    0x0000400000000000, 0x000ba00000000000, 0x000fb00000000000,
    0x000af80000000000, 0x0003640000000000, 0x000dce0000000000,
    0x0004270000000000, 0x000c8b8000000000, 0x000298c000000000,
    0x000cb42000000000, 0x000ce7f000000000, 0x000c6bb800000000,
    0x000609ac00000000, 0x0006bd4a00000000, 0x00045b7d00000000,
    0x000d317580000000, 0x000eb95240000000, 0x0002c56da0000000,
    0x000d7fce50000000, 0x00045fbf88000000, 0x000faeef6c000000,
    0x0004f63822000000, 0x0007226c2d000000, 0x000a94ea2c800000,
    0x000d974d03c00000, 0x0007736daf600000, 0x000e7cce72500000,
    0x0004ba3f92580000, 0x0009a12f73cc0000, 0x0004b19826f60000,
    0x000a795c3b6f0000, 0x000c257235c68000, 0x000cee111460c000,
    0x000bd61fb5d06000, 0x000dd2df5e1a7000, 0x000e4c203ceb4800,
    0x000b83f019848400, 0x000ba5b82b461e00, 0x000d2eac12a20d00,
    0x0000b6ca0a334880, 0x000683bd05888440, 0x000a255580d01ea0,
    0x000deea2769d0df0, 0x000456d5812dc828, 0x0008126261e44444,
    0x000f2cf5bc967e1a, 0x000fd29261b87d0b, 0x0008000000000000,
    0x000c000000000000, 0x0006000000000000, 0x000b000000000000,
    0x0001800000000000, 0x0001c00000000000, 0x0009600000000000,
    0x0009b00000000000, 0x0009c80000000000, 0x00034c0000000000,
    0x0003d60000000000, 0x00094f0000000000, 0x000aba8000000000,
    0x0006084000000000, 0x000d2c2000000000, 0x000de79000000000,
    0x000a466800000000, 0x000117a400000000, 0x000dae6200000000,
    0x0004ca0300000000, 0x000da17680000000, 0x0006510240000000,
    0x000639bea0000000, 0x0009257670000000, 0x0001cb94b8000000,
    0x000b20415c000000, 0x000010683e000000, 0x000598a41b000000,
    0x000874e23b800000, 0x000072430dc00