
/*
    pbrt source code Copyright(c) 1998-2012 Matt Pharr and Greg Humphreys.

    This file is part of pbrt.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are
    met:

    - Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

    - Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
    IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
    TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
    HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

#if defined(_MSC_VER)
#pragma once
#endif

#ifndef PBRT_CORE_PROBES_H
#define PBRT_CORE_PROBES_H

// core/probes.h*
#include "pbrt.h"
#ifdef PBRT_PROBES_DTRACE
#include "core/dtrace.h"
inline void ProbesCleanup() { }
inline void ProbesPrint(FILE *) { }
#endif // PBRT_PROBES_DTRACE

#ifdef PBRT_PROBES_NONE
inline void ProbesCleanup() { }
inline void ProbesPrint(FILE *) { }

// Statistics Disabled Declarations
#define PBRT_STARTED_RAY_INTERSECTION(ray)
#define PBRT_FINISHED_RAY_INTERSECTION(ray, isect, hit)
#define PBRT_STARTED_RAY_INTERSECTIONP(ray)
#define PBRT_FINISHED_RAY_INTERSECTIONP(ray, hit)

// Remainder of disabled probes declarations
#define PBRT_ACCESSED_TEXEL(arg0, arg1, arg2, arg3)
#define PBRT_ALLOCATED_CACHED_TRANSFORM()
#define PBRT_FOUND_CACHED_TRANSFORM()
#define PBRT_ATOMIC_MEMORY_OP()
#define PBRT_BVH_STARTED_CONSTRUCTION(arg0, arg1)
#define PBRT_BVH_FINISHED_CONSTRUCTION(arg0)
#define PBRT_BVH_INTERSECTION_STARTED(arg0, arg1)
#define PBRT_BVH_INTERSECTION_TRAVERSED_INTERIOR_NODE(arg0)
#define PBRT_BVH_INTERSECTION_TRAVERSED_LEAF_NODE(arg0)
#define PBRT_BVH_INTERSECTION_PRIMITIVE_TEST(arg0)
#define PBRT_BVH_INTERSECTION_PRIMITIVE_HIT(arg0)
#define PBRT_BVH_INTERSECTION_PRIMITIVE_MISSED(arg0)
#define PBRT_BVH_INTERSECTION_FINISHED()
#define PBRT_BVH_INTERSECTIONP_STARTED(arg0, arg1)
#define PBRT_BVH_INTERSECTIONP_TRAVERSED_INTERIOR_NODE(arg0)
#define PBRT_BVH_INTERSECTIONP_TRAVERSED_LEAF_NODE(arg0)
#define PBRT_BVH_INTERSECTIONP_PRIMITIVE_TEST(arg0)
#define PBRT_BVH_INTERSECTIONP_PRIMITIVE_HIT(arg0)
#define PBRT_BVH_INTERSECTIONP_PRIMITIVE_MISSED(arg0)
#define PBRT_BVH_INTERSECTIONP_FINISHED()
#define PBRT_CREATED_SHAPE(shape)
#define PBRT_CREATED_TRIANGLE(tri)
#define PBRT_FINISHED_GENERATING_CAMERA_RAY(arg0, arg1, arg2)
#define PBRT_FINISHED_PARSING()
#define PBRT_FINISHED_PREPROCESSING()
#define PBRT_FINISHED_RENDERING()
#define PBRT_FINISHED_RENDERTASK(arg0)
#define PBRT_FINISHED_TASK(arg0)
#define PBRT_FINISHED_ADDING_IMAGE_SAMPLE()
#define PBRT_FINISHED_CAMERA_RAY_INTEGRATION(arg0, arg1, arg2)
#define PBRT_FINISHED_EWA_TEXTURE_LOOKUP()
#define PBRT_FINISHED_BSDF_SHADING(arg0, arg1)
#define PBRT_FINISHED_BSSRDF_SHADING(arg0, arg1)
#define PBRT_FINISHED_SPECULAR_REFLECTION_RAY(arg0)
#define PBRT_FINISHED_SPECULAR_REFRACTION_RAY(arg0)
#define PBRT_FINISHED_TRILINEAR_TEXTURE_LOOKUP()
#define PBRT_GRID_BOUNDS_AND_RESOLUTION(arg0, arg1)
#define PBRT_GRID_FINISHED_CONSTRUCTION(arg0)
#define PBRT_GRID_INTERSECTIONP_TEST(arg0, arg1)
#define PBRT_GRID_INTERSECTION_TEST(arg0, arg1)
#define PBRT_GRID_RAY_MISSED_BOUNDS()
#define PBRT_GRID_RAY_PRIMITIVE_HIT(arg0)
#define PBRT_GRID_RAY_PRIMITIVE_INTERSECTIONP_TEST(arg0)
#define PBRT_GRID_RAY_PRIMITIVE_INTERSECTION_TEST(arg0)
#define PBRT_GRID_RAY_TRAVERSED_VOXEL(arg0, arg1)
#define PBRT_GRID_STARTED_CONSTRUCTION(arg0, arg1)
#define PBRT_GRID_VOXELIZED_PRIMITIVE(arg0, arg1)
#define PBRT_IRRADIANCE_CACHE_ADDED_NEW_SAMPLE(arg0, arg1, arg2, arg3, arg4, arg5)
#define PBRT_IRRADIANCE_CACHE_CHECKED_SAMPLE(arg0, arg1, arg2)
#define PBRT_IRRADIANCE_CACHE_FINISHED_COMPUTING_IRRADIANCE(arg0, arg1)
#define PBRT_IRRADIANCE_CACHE_FINISHED_INTERPOLATION(arg0, arg1, arg2, arg3)
#define PBRT_IRRADIANCE_CACHE_FINISHED_RAY(arg0, arg1, arg2)
#define PBRT_IRRADIANCE_CACHE_STARTED_COMPUTING_IRRADIANCE(arg0, arg1)
#define PBRT_IRRADIANCE_CACHE_STARTED_INTERPOLATION(arg0, arg1)
#define PBRT_IRRADIANCE_CACHE_STARTED_RAY(arg0)
#define PBRT_KDTREE_CREATED_INTERIOR_NODE(arg0, arg1)
#define PBRT_KDTREE_CREATED_LEAF(arg0, arg1)
#define PBRT_KDTREE_FINISHED_CONSTRUCTION(arg0)
#define PBRT_KDTREE_INTERSECTIONP_PRIMITIVE_TEST(arg0)
#define PBRT_KDTREE_INTERSECTION_PRIMITIVE_TEST(arg0)
#define PBRT_KDTREE_INTERSECTIONP_HIT(arg0)
#define PBRT_KDTREE_INTERSECTIONP_MISSED()
#define PBRT_KDTREE_INTERSECTIONP_TEST(arg0, arg1)
#define PBRT_KDTREE_INTERSECTION_FINISHED()
#define PBRT_KDTREE_INTERSECTION_HIT(arg0)
#define PBRT_KDTREE_INTERSECTION_TEST(arg0, arg1)
#define PBRT_KDTREE_RAY_MISSED_BOUNDS()
#define PBRT_KDTREE_STARTED_CONSTRUCTION(arg0, arg1)
#define PBRT_KDTREE_INTERSECTION_TRAVERSED_INTERIOR_NODE(arg0)
#define PBRT_KDTREE_INTERSECTION_TRAVERSED_LEAF_NODE(arg0, arg1)
#define PBRT_KDTREE_INTERSECTIONP_TRAVERSED_INTERIOR_NODE(arg0)
#define PBRT_KDTREE_INTERSECTIONP_TRAVERSED_LEAF_NODE(arg0, arg1)
#define PBRT_LOADED_IMAGE_MAP(arg0, arg1, arg2, arg3, arg4)
#define PBRT_MIPMAP_EWA_FILTER(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10)
#define PBRT_MIPMAP_TRILINEAR_FILTER(arg0, arg1, arg2, arg3, arg4, arg5)
#define PBRT_MLT_ACCEPTED_MUTATION(arg0, arg1, arg2)
#define PBRT_MLT_REJECTED_MUTATION(arg0, arg1, arg2)
#define PBRT_MLT_STARTED_MLT_TASK(arg0)
#define PBRT_MLT_FINISHED_MLT_TASK(arg0)
#define PBRT_MLT_STARTED_RENDERING()
#define PBRT_MLT_FINISHED_RENDERING()
#define PBRT_MLT_STARTED_DIRECTLIGHTING()
#define PBRT_MLT_FINISHED_DIRECTLIGHTING()
#define PBRT_MLT_STARTED_BOOTSTRAPPING(count)
#define PBRT_MLT_FINISHED_BOOTSTRAPPING(b)
#define PBRT_MLT_STARTED_MUTATION()
#define PBRT_MLT_FINISHED_MUTATION()
#define PBRT_MLT_STARTED_SAMPLE_SPLAT()
#define PBRT_MLT_FINISHED_SAMPLE_SPLAT()
#define PBRT_MLT_STARTED_GENERATE_PATH()
#define PBRT_MLT_FINISHED_GENERATE_PATH()
#define PBRT_MLT_STARTED_LPATH()
#define PBRT_MLT_FINISHED_LPATH()
#define PBRT_MLT_STARTED_LBIDIR()
#define PBRT_MLT_FINISHED_LBIDIR()
#define PBRT_MLT_STARTED_TASK_INIT()
#define PBRT_MLT_FINISHED_TASK_INIT()
#define PBRT_MLT_STARTED_SAMPLE_LIGHT_FOR_BIDIR()
#define PBRT_MLT_FINISHED_SAMPLE_LIGHT_FOR_BIDIR()
#define PBRT_MLT_STARTED_DISPLAY_UPDATE()
#define PBRT_MLT_FINISHED_DISPLAY_UPDATE()
#define PBRT_MLT_STARTED_ESTIMATE_DIRECT()
#define PBRT_MLT_FINISHED_ESTIMATE_DIRECT()
#define PBRT_PHOTON_MAP_DEPOSITED_CAUSTIC_PHOTON(arg0, arg1, arg2)
#define PBRT_PHOTON_MAP_DEPOSITED_DIRECT_PHOTON(arg0, arg1, arg2)
#define PBRT_PHOTON_MAP_DEPOSITED_INDIRECT_PHOTON(arg0, arg1, arg2)
#define PBRT_PHOTON_MAP_FINISHED_GATHER_RAY(arg0)
#define PBRT_PHOTON_MAP_FINISHED_LOOKUP(arg0, arg1, arg2, arg3)
#define PBRT_PHOTON_MAP_FINISHED_RAY_PATH(arg0, arg1)
#define PBRT_PHOTON_MAP_STARTED_GATHER_RAY(arg0)
#define PBRT_PHOTON_MAP_STARTED_LOOKUP(arg0)
#define PBRT_PHOTON_MAP_STARTED_RAY_PATH(arg0, arg1)
#define PBRT_RAY_TRIANGLE_INTERSECTIONP_HIT(arg0, arg1)
#define PBRT_RAY_TRIANGLE_INTERSECTIONP_TEST(arg0, arg1)
#define PBRT_RAY_TRIANGLE_INTERSECTION_HIT(arg0, arg1)
#define PBRT_RAY_TRIANGLE_INTERSECTION_TEST(arg0, arg1)
#define PBRT_SAMPLE_OUTSIDE_IMAGE_EXTENT(arg0)
#define PBRT_STARTED_ADDING_IMAGE_SAMPLE(arg0, arg1, arg2, arg3)
#define PBRT_STARTED_CAMERA_RAY_INTEGRATION(arg0, arg1)
#define PBRT_STARTED_EWA_TEXTURE_LOOKUP(arg0, arg1)
#define PBRT_STARTED_GENERATING_CAMERA_RAY(arg0)
#define PBRT_STARTED_PARSING()
#define PBRT_STARTED_PREPROCESSING()
#define PBRT_STARTED_RENDERING()
#define PBRT_STARTED_RENDERTASK(arg0)
#define PBRT_STARTED_BSDF_SHADING(arg0)
#define PBRT_STARTED_BSSRDF_SHADING(arg0)
#define PBRT_STARTED_SPECULAR_REFLECTION_RAY(arg0)
#define PBRT_STARTED_SPECULAR_REFRACTION_RAY(arg0)
#define PBRT_STARTED_TASK(arg0)
#define PBRT_STARTED_TRILINEAR_TEXTURE_LOOKUP(arg0, arg1)
#define PBRT_SUBSURFACE_ADDED_INTERIOR_CONTRIBUTION(arg0)
#define PBRT_SUBSURFACE_ADDED_POINT_CONTRIBUTION(arg0)
#define PBRT_SUBSURFACE_ADDED_POINT_TO_OCTREE(arg0, arg1)
#define PBRT_SUBSURFACE_COMPUTED_IRRADIANCE_AT_POINT(arg0, arg1)
#define PBRT_SUBSURFACE_FINISHED_COMPUTING_IRRADIANCE_VALUES()
#define PBRT_SUBSURFACE_FINISHED_OCTREE_LOOKUP()
#define PBRT_SUBSURFACE_FINISHED_RAYS_FOR_POINTS(arg0, arg1)
#define PBRT_SUBSURFACE_STARTED_COMPUTING_IRRADIANCE_VALUES()
#define PBRT_SUBSURFACE_STARTED_OCTREE_LOOKUP(arg0)
#define PBRT_SUBSURFACE_STARTED_RAYS_FOR_POINTS()
#define PBRT_SUPERSAMPLE_PIXEL_NO(arg0, arg1)
#define PBRT_SUPERSAMPLE_PIXEL_YES(arg0, arg1)
#define PBRT_RNG_STARTED_RANDOM_FLOAT()
#define PBRT_RNG_FINISHED_RANDOM_FLOAT()
#define PBRT_RNG_FINISHED_TABLEGEN()
#define PBRT_RNG_STARTED_TABLEGEN()
#define PBRT_STARTED_BSDF_EVAL()
#define PBRT_FINISHED_BSDF_EVAL()
#define PBRT_STARTED_BSDF_SAMPLE()
#define PBRT_FINISHED_BSDF_SAMPLE()
#define PBRT_STARTED_BSDF_PDF()
#define PBRT_FINISHED_BSDF_PDF()
#define PBRT_AREA_LIGHT_STARTED_SAMPLE()
#define PBRT_AREA_LIGHT_FINISHED_SAMPLE()
#define PBRT_INFINITE_LIGHT_STARTED_SAMPLE()
#define PBRT_INFINITE_LIGHT_FINISHED_SAMPLE()
#define PBRT_INFINITE_LIGHT_STARTED_PDF()
#define PBRT_INFINITE_LIGHT_FINISHED_PDF()
#endif // PBRT_PROBES_NONE

#ifdef PBRT_PROBES_COUNTERS

// Statistics Counters Declarations
void ProbesPrint(FILE *dest);
void ProbesCleanup();
class Triangle;
extern void PBRT_CREATED_SHAPE(Shape *);
extern void PBRT_CREATED_TRIANGLE(Triangle *);
extern void PBRT_STARTED_GENERATING_CAMERA_RAY(const struct CameraSample *);
extern void PBRT_KDTREE_CREATED_INTERIOR_NODE(int axis, float split);
extern void PBRT_KDTREE_CREATED_LEAF(int nprims, int depth);
#if 1
extern void PBRT_RAY_TRIANGLE_INTERSECTION_TEST(const Ray *, const Triangle *);
extern void PBRT_RAY_TRIANGLE_INTERSECTIONP_TEST(const Ray *, const Triangle *);
extern void PBRT_RAY_TRIANGLE_INTERSECTION_HIT(const Ray *, float t);
extern void PBRT_RAY_TRIANGLE_INTERSECTIONP_HIT(const Ray *, float t);
#else
#define PBRT_RAY_TRIANGLE_INTERSECTION_HIT(arg0, arg1)
#define PBRT_RAY_TRIANGLE_INTERSECTION_TEST(arg0, arg1)
#define PBRT_RAY_TRIANGLE_INTERSECTIONP_HIT(arg0, arg1)
#define PBRT_RAY_TRIANGLE_INTERSECTIONP_TEST(arg0, arg1)
#endif
extern void PBRT_FINISHED_RAY_INTERSECTION(const Ray *, const Intersection *, int hit);
extern void PBRT_FINISHED_RAY_INTERSECTIONP(const Ray *, int hit);
extern void PBRT_STARTED_SPECULAR_REFLECTION_RAY(const RayDifferential *);
extern void PBRT_STARTED_SPECULAR_REFRACTION_RAY(const RayDifferential *);
#define PBRT_ACCESSED_TEXEL(arg0, arg1, arg2, arg3)
#define PBRT_ALLOCATED_CACHED_TRANSFORM()
#define PBRT_FOUND_CACHED_TRANSFORM()
#define PBRT_ATOMIC_MEMORY_OP()
#define PBRT_BVH_STARTED_CONSTRUCTION(arg0, arg1)
#define PBRT_BVH_FINISHED_CONSTRUCTION(arg0)
#define PBRT_BVH_INTERSECTION_STARTED(arg0, arg1)
#define PBRT_BVH_INTERSECTION_TRAVERSED_INTERIOR_NODE(arg0)
#define PBRT_BVH_INTERSECTION_TRAVERSED_LEAF_NODE(arg0)
#define PBRT_BVH_INTERSECTION_PRIMITIVE_TEST(arg0)
#define PBRT_BVH_INTERSECTION_PRIMITIVE_HIT(arg0)
#define PBRT_BVH_INTERSECTION_PRIMITIVE_MISSED(arg0)
#define PBRT_BVH_INTERSECTION_FINISHED()
#define PBRT_BVH_INTERSECTIONP_STARTED(arg0, arg1)
#define PBRT_BVH_INTERSECTIONP_TRAVERSED_INTERIOR_NODE(arg0)
#define PBRT_BVH_INTERSECTIONP_TRAVERSED_LEAF_NODE(arg0)
#define PBRT_BVH_INTERSECTIONP_PRIMITIVE_TEST(arg0)
#define PBRT_BVH_INTERSECTIONP_PRIMITIVE_HIT(arg0)
#define PBRT_BVH_INTERSECTIONP_PRIMITIVE_MISSED(arg0)
#define PBRT_BVH_INTERSECTIONP_FINISHED()
#define PBRT_FINISHED_PARSING()
#define PBRT_FINISHED_PREPROCESSING()
#define PBRT_FINISHED_RENDERING()
#define PBRT_FINISHED_RENDERTASK(arg0)
#define PBRT_FINISHED_TASK(arg0)
#define PBRT_FINISHED_ADDING_IMAGE_SAMPLE()
#define PBRT_FINISHED_CAMERA_RAY_INTEGRATION(arg0, arg1, arg2)
#define PBRT_FINISHED_EWA_TEXTURE_LOOKUP()
#define PBRT_FINISHED_GENERATING_CAMERA_RAY(arg0, arg1, arg2)
#define PBRT_FINISHED_BSDF_SHADING(arg0, arg1)
#define PBRT_FINISHED_BSSRDF_SHADING(arg0, arg1)
#define PBRT_FINISHED_SPECULAR_REFLECTION_RAY(arg0)
#define PBRT_FINISHED_SPECULAR_REFRACTION_RAY(arg0)
#define PBRT_FINISHED_TRILINEAR_TEXTURE_LOOKUP()
#define PBRT_GRID_BOUNDS_AND_RESOLUTION(arg0, arg1)
#define PBRT_GRID_FINISHED_CONSTRUCTION(arg0)
#define PBRT_GRID_INTERSECTIONP_TEST(arg0, arg1)
#define PBRT_GRID_INTERSECTION_TEST(arg0, arg1)
#define PBRT_GRID_RAY_MISSED_BOUNDS()
#define PBRT_GRID_RAY_PRIMITIVE_HIT(arg0)
#define PBRT_GRID_RAY_PRIMITIVE_INTERSECTIONP_TEST(arg0)
#define PBRT_GRID_RAY_PRIMITIVE_INTERSECTION_TEST(arg0)
#define PBRT_GRID_RAY_TRAVERSED_VOXEL(arg0, arg1)
#define PBRT_GRID_STARTED_CONSTRUCTION(arg0, arg1)
#define PBRT_GRID_VOXELIZED_PRIMITIVE(arg0, arg1)
#define PBRT_IRRADIANCE_CACHE_ADDED_NEW_SAMPLE(arg0, arg1, arg2, arg3, arg4, arg5)
#define PBRT_IRRADIANCE_CACHE_CHECKED_SAMPLE(arg0, arg1, arg2)
#define PBRT_IRRADIANCE_CACHE_FINISHED_COMPUTING_IRRADIANCE(arg0, arg1)
#define PBRT_IRRADIANCE_CACHE_FINISHED_INTERPOLATION(arg0, arg1, arg2, arg3)
#define PBRT_IRRADIANCE_CACHE_FINISHED_RAY(arg0, arg1, arg2)
#define PBRT_IRRADIANCE_CACHE_STARTED_COMPUTING_IRRADIANCE(arg0, arg1)
#define PBRT_IRRADIANCE_CACHE_STARTED_INTERPOLATION(arg0, arg1)
#define PBRT_IRRADIANCE_CACHE_STARTED_RAY(arg0)
#define PBRT_KDTREE_FINISHED_CONSTRUCTION(arg0)
#define PBRT_KDTREE_INTERSECTIONP_PRIMITIVE_TEST(arg0)
#define PBRT_KDTREE_INTERSECTION_PRIMITIVE_TEST(arg0)
#define PBRT_KDTREE_INTERSECTIONP_HIT(arg0)
#define PBRT_KDTREE_INTERSECTIONP_MISSED()
#define PBRT_KDTREE_INTERSECTIONP_TEST(arg0, arg1)
#define PBRT_KDTREE_INTERSECTION_FINISHED()
#define PBRT_KDTREE_INTERSECTION_HIT(arg0)
#define PBRT_KDTREE_INTERSECTION_TEST(arg0, arg1)
#define PBRT_KDTREE_RAY_MISSED_BOUNDS()
#define PBRT_KDTREE_STARTED_CONSTRUCTION(arg0, arg1)
#define PBRT_KDTREE_INTERSECTION_TRAVERSED_INTERIOR_NODE(arg0)
#define PBRT_KDTREE_INTERSECTION_TRAVERSED_LEAF_NODE(arg0, arg1)
#define PBRT_KDTREE_INTERSECTIONP_TRAVERSED_INTERIOR_NODE(arg0)
#define PBRT_KDTREE_INTERSECTIONP_TRAVERSED_LEAF_NODE(arg0, arg1)
#define PBRT_LOADED_IMAGE_MAP(arg0, arg1, arg2, arg3, arg4)
#define PBRT_MIPMAP_EWA_FILTER(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10)
#define PBRT_MIPMAP_TRILINEAR_FILTER(arg0, arg1, arg2, arg3, arg4, arg5)
#define PBRT_MLT_ACCEPTED_MUTATION(arg0, arg1, arg2)
#define PBRT_MLT_REJECTED_MUTATION(arg0, arg1, arg2)
#define PBRT_MLT_STARTED_MLT_TASK(arg0)
#define PBRT_MLT_FINISHED_MLT_TASK(arg0)
#define PBRT_MLT_STARTED_RENDERING()
#define PBRT_MLT_FINISHED_RENDERING()
#define PBRT_MLT_STARTED_DIRECTLIGHTING()
#define PBRT_MLT_FINISHED_DIRECTLIGHTING()
#define PBRT_MLT_STARTED_BOOTSTRAPPING(count)
#define PBRT_MLT_FINISHED_BOOTSTRAPPING(b)
#define PBRT_MLT_STARTED_MUTATION()
#define PBRT_MLT_FINISHED_MUTATION()
#define PBRT_MLT_STARTED_SAMPLE_SPLAT()
#define PBRT_MLT_FINISHED_SAMPLE_SPLAT()
#define PBRT_MLT_STARTED_GENERATE_PATH()
#define PBRT_MLT_FINISHED_GENERATE_PATH()
#define PBRT_MLT_STARTED_LPATH()
#define PBRT_MLT_FINISHED_LPATH()
#define PBRT_MLT_STARTED_LBIDIR()
#define PBRT_MLT_FINISHED_LBIDIR()
#define PBRT_MLT_STARTED_TASK_INIT()
#define PBRT_MLT_FINISHED_TASK_INIT()
#define PBRT_MLT_STARTED_SAMPLE_LIGHT_FOR_BIDIR()
#define PBRT_MLT_FINISHED_SAMPLE_LIGHT_FOR_BIDIR()
#define PBRT_MLT_STARTED_DISPLAY_UPDATE()
#define PBRT_MLT_FINISHED_DISPLAY_UPDATE()
#define PBRT_MLT_STARTED_ESTIMATE_DIRECT()
#define PBRT_MLT_FINISHED_ESTIMATE_DIRECT()
#define PBRT_PHOTON_MAP_DEPOSITED_CAUSTIC_PHOTON(arg0, arg1, arg2)
#define PBRT_PHOTON_MAP_DEPOSITED_DIRECT_PHOTON(arg0, arg1, arg2)
#define PBRT_PHOTON_MAP_DEPOSITED_INDIRECT_PHOTON(arg0, arg1, arg2)
#define PBRT_PHOTON_MAP_FINISHED_GATHER_RAY(arg0)
#define PBRT_PHOTON_MAP_FINISHED_LOOKUP(arg0, arg1, arg2, arg3)
#define PBRT_PHOTON_MAP_FINISHED_RAY_PATH(arg0, arg1)
#define PBRT_PHOTON_MAP_STARTED_GATHER_RAY(arg0)
#define PBRT_PHOTON_MAP_STARTED_LOOKUP(arg0)
#define PBRT_PHOTON_MAP_STARTED_RAY_PATH(arg0, arg1)
#define PBRT_SAMPLE_OUTSIDE_IMAGE_EXTENT(arg0)
#define PBRT_STARTED_ADDING_IMAGE_SAMPLE(arg0, arg1, arg2, arg3)
#define PBRT_STARTED_CAMERA_RAY_INTEGRATION(arg0, arg1)
#define PBRT_STARTED_EWA_TEXTURE_LOOKUP(arg0, arg1)
#define PBRT_STARTED_PARSING()
#define PBRT_STARTED_PREPROCESSING()
#define PBRT_STARTED_RAY_INTERSECTION(arg0)
#define PBRT_STARTED_RAY_INTERSECTIONP(arg0)
#define PBRT_STARTED_RENDERING()
#define PBRT_STARTED_RENDERTASK(arg0)
#define PBRT_STARTED_BSDF_SHADING(arg0)
#define PBRT_STARTED_BSSRDF_SHADING(arg0)
#define PBRT_STARTED_TASK(arg0)
#define PBRT_STARTED_TRILINEAR_TEXTURE_LOOKUP(arg0, arg1)
#define PBRT_SUBSURFACE_ADDED_INTERIOR_CONTRIBUTION(arg0)
#define PBRT_SUBSURFACE_ADDED_POINT_CONTRIBUTION(arg0)
#define PBRT_SUBSURFACE_ADDED_POINT_TO_OCTREE(arg0, arg1)
#define PBRT_SUBSURFACE_COMPUTED_IRRADIANCE_AT_POINT(arg0, arg1)
#define PBRT_SUBSURFACE_FINISHED_COMPUTING_IRRADIANCE_VALUES()
#define PBRT_SUBSURFACE_FINISHED_OCTREE_LOOKUP()
#define PBRT_SUBSURFACE_FINISHED_RAYS_FOR_POINTS(arg0, arg1)
#define PBRT_SUBSURFACE_STARTED_COMPUTING_IRRADIANCE_VALUES()
#define PBRT_SUBSURFACE_STARTED_OCTREE_LOOKUP(arg0)
#define PBRT_SUBSURFACE_STARTED_RAYS_FOR_POINTS()
#define PBRT_SUPERSAMPLE_PIXEL_NO(arg0, arg1)
#define PBRT_SUPERSAMPLE_PIXEL_YES(arg0, arg1)
#define PBRT_RNG_STARTED_RANDOM_FLOAT()
#define PBRT_RNG_FINISHED_RANDOM_FLOAT()
#define PBRT_RNG_FINISHED_TABLEGEN()
#define PBRT_RNG_STARTED_TABLEGEN()
#define PBRT_STARTED_BSDF_EVAL()
#define PBRT_FINISHED_BSDF_EVAL()
#define PBRT_STARTED_BSDF_SAMPLE()
#define PBRT_FINISHED_BSDF_SAMPLE()
#define PBRT_STARTED_BSDF_PDF()
#define PBRT_FINISHED_BSDF_PDF()
#define PBRT_AREA_LIGHT_STARTED_SAMPLE()
#define PBRT_AREA_LIGHT_FINISHED_SAMPLE()
#define PBRT_INFINITE_LIGHT_STARTED_SAMPLE()
#define PBRT_INFINITE_LIGHT_FINISHED_SAMPLE()
#define PBRT_INFINITE_LIGHT_STARTED_PDF()
#define PBRT_INFINITE_LIGHT_FINISHED_PDF()
#endif // PBRT_PROBES_COUNTERS

#endif // PBRT_CORE_PROBES_H
