(*
  Copyright Florian Hatat, Tom Hirschowitz, Pierre Hyvernat,
  Pierre-Etienne Meunier, Christophe Raffalli, Guillaume Theyssier 2012.

  This file is part of Patoline.

  Patoline is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Patoline is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Patoline.  If not, see <http://www.gnu.org/licenses/>.
*)
open Typography
open CamomileLibrary
open Fonts.FTypes
open OutputCommon
open OutputPaper
open Util

let filename file=try (Filename.chop_extension file)^".bin" with _->file^".bin"

let output ?(structure:structure={name="";displayname=[];metadata=[];tags=[];
				  page= -1;struct_x=0.;struct_y=0.;substructures=[||]})
    pages fileName=

  let fileName = filename fileName in
  let ch = open_out_bin fileName in
  output_value ch false;
  Marshal.to_channel ch structure [Marshal.Closures];
  Marshal.to_channel ch pages [Marshal.Closures];
  close_out ch;
  Printf.fprintf stderr "File %s written.\n" fileName;
  flush stderr

let output' ?(structure:structure={name="";displayname=[];metadata=[];tags=[];
				  page= -1;struct_x=0.;struct_y=0.;substructures=[||]})
    pages fileName=

  let fileName = filename fileName in
  let ch = open_out_bin fileName in
  output_value ch true;
  Marshal.to_channel ch structure [Marshal.Closures];
  Marshal.to_channel ch pages [Marshal.Closures];
  close_out ch;
  Printf.fprintf stderr "File %s written.\n" fileName;
  flush stderr

