#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"

#define BUFSIZE 255

#undef DEBUG

#if USE_UNIFY
unifier * newUnifier(char * from, char * to, unifier * next = NULL)
{
	int error_value;
	unifier * retval = (unifier *) malloc (sizeof (unifier));
	retval->from = (regex_t *) malloc (sizeof (regex_t));
	retval->to = to;
	retval->next = next;

	/* 0 == success */
	if (! (error_value = regcomp(retval->from, from, REG_ICASE | REG_EXTENDED)))
		return retval;

	char buffer[BUFSIZE];
	regerror(error_value, retval->from, buffer, BUFSIZE);
	fprintf(stderr, "newUnifier regex error: %s\n", buffer);

	free (retval->from);
	free (retval);
	return next;
}
#endif

#if USE_IGNORE
ignorer * newIgnore(char * regexp, ignorer * next = NULL)
{
	int error_value;
	ignorer * retval = (ignorer *) malloc (sizeof (ignorer));
	retval->regexp = (regex_t *) malloc (sizeof (regex_t));
	retval->next = next;

	/* 0 == success */
	if (! (error_value = regcomp(retval->regexp, regexp, REG_ICASE | REG_EXTENDED)))
		return retval;

	char buffer[BUFSIZE];
	regerror(error_value, retval->regexp, buffer, BUFSIZE);
	fprintf(stderr, "newIgnore regex error: %s\n", buffer);

	free (retval->regexp);
	free (retval);
	return next;
}
#endif

Config * ReadConfig (char * file)
{
	FILE * in;
	Config * retval = (Config *) malloc (sizeof(Config));

	// DEFAULTS
	retval->min_edgewidth = -1; // auto
	retval->max_edgecount = 60; // when auto, max 60 edges
	retval->ignore_refresh = 0; // don't ignore refreshes
	retval->session_timeout = -1; // sessions don't time out

	in = fopen (file, "r");

	if (in == NULL)
	{
		char * error = "Error opening configfile ('";
		char * errmsg = (char *) malloc (strlen(error) + strlen(file) + 2 + 1);
		sprintf(errmsg, "%s%s')", error, file);
		perror(errmsg);
		return retval;
	};

	char buffer[BUFSIZE];

	while (fgets(buffer, BUFSIZE, in))
	{
		char * option;
		char * value;

		if ((buffer[0] == '#') || (buffer[0] == '\n'))
			continue;

		option = buffer;
		if (! (value = strchr(buffer, ' ')))
			continue;
		*value = '\0';
		value++;

#ifdef DEBUG
		fprintf(stderr, "Read option: %s -> %s", option, value);
#endif

		if (strcmp(option, "min_edgewidth") == 0)
		{
			sscanf(value, "%d", &retval->min_edgewidth);
		}
		else if (strcmp(option, "max_edgecount") == 0)
		{
			sscanf(value, "%d", &retval->max_edgecount);
		}
		else if (strcmp(option, "ignore_refresh") == 0)
		{
			sscanf(value, "%d", &retval->ignore_refresh);
#ifdef DEBUG
			fprintf(stderr, "Ignore_refresh is %d\n", retval->ignore_refresh);
#endif
		}
		else if (strcmp(option, "session_timeout") == 0)
		{
			sscanf(value, "%d", &retval->session_timeout);
#ifdef DEBUG
			fprintf(stderr, "Session timeout is %d\n", retval->ignore_refresh);
#endif
		}
		else if (strcmp(option, "unify") == 0)
		{
#if USE_UNIFY
			// strtok(value, "\"");
			char * to = strtok(value, "\"");
			char * from;

			strtok(NULL, "\"");
			while (from = strtok(NULL, "\""))
			{
				retval->unifiers = newUnifier(strdup(from),
						strdup(to), retval->unifiers);
				strtok(NULL, "\"");
			}
#else
			fprintf(stderr, "Unifying was disabeled at compile-time. sorry.\n");
#endif /* USE_UNIFY */
		}
		// Options for other parts of the series
		else if (strcmp(option, "ignore") == 0)
		{
#if USE_IGNORE
			ignorer * new_ignore;
			value[strlen(value)-1] = '\0';
			/* returns null on failure */
			if (new_ignore = newIgnore(value, retval->ignores))
				retval->ignores = new_ignore;
			else
				fprintf(stderr, "Regex '%s' could not be compiled. Ignoring\n", value);
#else
			fprintf(stderr, "Ignoring was disabeled at compile-time. sorry.\n");
#endif
			// ignore
		}
		else
		{
			fprintf(stderr, "Unknown argument: %s - ignoring.\n", option);
		}
	}

	fclose(in);
	return retval;
}
