REM  --  Written by Ren Wolferink (renewolf@sci.kun.nl), use at your own risk  ;)

@echo off

set LOGFILE=access.log
set DOT_PATH=c:\Progra~1\graphviz\Graphviz\bin
set GS_PATH=c:\Progra~1\gs\gs7.04\bin
set PBM_PATH=c:\Progra~1\netpbm\bin

echo Ordering logfile by session and by date
apache2events.exe < %LOGFILE% > %LOGFILE%.events

echo Generating graph edges
event2dot.exe %LOGFILE%.events > %LOGFILE%.dot

echo Generating postscript output
%DOT_PATH%\dot.exe -Tps %LOGFILE%.dot -o %LOGFILE%.ps

echo Converting to png...

echo ...running ghostscript
%GS_PATH%\gswin32c.exe -sDEVICE=ppmraw -dTextAlphaBits=4 -dGraphicsAlphaBits=4 -sOutputFile=- -g8400x8400 -r700 -q -dNOPAUSE %LOGFILE%.ps < NUL > %LOGFILE%.1.tmp
echo ...cropping
%PBM_PATH%\pnmcrop.exe -white %LOGFILE%.1.tmp > %LOGFILE%.2.tmp
echo ...rotating
%PBM_PATH%\pnmmerge.exe pnmrotate -90 %LOGFILE%.2.tmp > %LOGFILE%.3.tmp
echo ...reducing colors
%PBM_PATH%\pnmdepth.exe 15 %LOGFILE%.3.tmp > %LOGFILE%.4.tmp
%PBM_PATH%\ppmquant.exe 256 %LOGFILE%.4.tmp > %LOGFILE%.5.tmp
echo ...converting to png
%PBM_PATH%\pnmtopng.exe -interlace %LOGFILE%.5.tmp > %LOGFILE%.png

echo Cleaning up temporary files
del %LOGFILE%.1.tmp
del %LOGFILE%.2.tmp
del %LOGFILE%.3.tmp
del %LOGFILE%.4.tmp
del %LOGFILE%.5.tmp
