!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!
!!!!   MIT License
!!!!
!!!!   ParaMonte: plain powerful parallel Monte Carlo library.
!!!!
!!!!   Copyright (C) 2012-present, The Computational Data Science Lab
!!!!
!!!!   This file is part of the ParaMonte library.
!!!!
!!!!   Permission is hereby granted, free of charge, to any person obtaining a
!!!!   copy of this software and associated documentation files (the "Software"),
!!!!   to deal in the Software without restriction, including without limitation
!!!!   the rights to use, copy, modify, merge, publish, distribute, sublicense,
!!!!   and/or sell copies of the Software, and to permit persons to whom the
!!!!   Software is furnished to do so, subject to the following conditions:
!!!!
!!!!   The above copyright notice and this permission notice shall be
!!!!   included in all copies or substantial portions of the Software.
!!!!
!!!!   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
!!!!   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
!!!!   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
!!!!   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
!!!!   DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
!!!!   OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
!!!!   OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
!!!!
!!!!   ACKNOWLEDGMENT
!!!!
!!!!   ParaMonte is an honor-ware and its currency is acknowledgment and citations.
!!!!   As per the ParaMonte library license agreement terms, if you use any parts of
!!!!   this library for any purposes, kindly acknowledge the use of ParaMonte in your
!!!!   work (education/research/industry/development/...) by citing the ParaMonte
!!!!   library as described on this page:
!!!!
!!!!       https://github.com/cdslaborg/paramonte/blob/main/ACKNOWLEDGMENT.md
!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!>  \brief This module contains tests of the module [ParaDRAM_ChainFileContents_mod](@ref paradram_chainfilecontents_mod).
!>  \author Amir Shahmoradi

#if defined PARADRAM

#define ParaXXXX_ChainFileContents_mod ParaDRAM_ChainFileContents_mod

#elif defined PARADISE

#define ParaXXXX_ChainFileContents_mod ParaDISE_ChainFileContents_mod

#elif defined PARANEST

#define ParaXXXX_ChainFileContents_mod ParaNest_ChainFileContents_mod

#endif

    use Test_mod, only: Test_type, getLogFuncMVN
    use ParaXXXX_ChainFileContents_mod
    implicit none

    private
    public :: test_ChainFileContents

    type(Test_type) :: Test

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

contains

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    subroutine test_ChainFileContents()
        implicit none
        Test = Test_type(moduleName=MODULE_NAME)
        call Test%run(test_constructChainFileContents_1, "test_constructChainFileContents_1")
        call Test%finalize()
    end subroutine test_ChainFileContents

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    function test_constructChainFileContents_1() result(assertion)
        use Constants_mod, only: IK, RK
        use ParaDRAM_mod, only: ParaDRAM_type
        implicit none
        logical                     :: assertion
        type(ParaDRAM_type)         :: PD
        type(ChainFileContents_type):: CFC
        real(RK)    , parameter     :: tolerance = 1.e-10_RK
        character(*), parameter     :: DELIM = "delim"
       !character(9), parameter     :: variableNameList(*) = ["var1", "var2"]
        integer(IK) , parameter     :: NDIM = 2_IK
        assertion = .true.
#if defined CODECOV_ENABLED || defined SAMPLER_TEST_ENABLED

        call PD%runSampler  ( ndim = NDIM &
                            , getLogFunc = getLogFuncMVN &
                            , outputFileName = Test%outDir//"/"//MODULE_NAME//"/test_constructChainFileContents_1" &
                            , mpiFinalizeRequested = .false. &
                            , outputRealPrecision = 15_IK &
                            , outputDelimiter = DELIM &
                            , sampleSize = 10_IK &
                            )
        assertion = assertion .and. .not. PD%Err%occurred
        if (Test%isVerboseMode .and. .not. assertion) then
        ! LCOV_EXCL_START
            write(*,"(10(g0,:,', '))")
            write(*,"(10(g0,:,', '))") "PD%Err%occurred", PD%Err%occurred
            write(*,"(10(g0,:,', '))") "PD%Err%msg     ", PD%Err%msg
            write(*,"(10(g0,:,', '))")
            return
        end if
        ! LCOV_EXCL_STOP

        ! read the chain file, first call without the optional input file, in which case no error should happen.

        CFC = ChainFileContents_type( ndim = NDIM )
        assertion = assertion .and. .not. CFC%Err%occurred
        if (Test%isVerboseMode .and. .not. assertion) then
        ! LCOV_EXCL_START
            write(*,"(10(g0,:,', '))")
            write(*,"(10(g0,:,', '))") "CFC%Err%occurred", CFC%Err%occurred
            write(*,"(10(g0,:,', '))") "CFC%Err%msg     ", CFC%Err%msg
            write(*,"(10(g0,:,', '))")
            return
        end if
        ! LCOV_EXCL_STOP

        CFC = ChainFileContents_type( ndim = NDIM &
                                    !, variableNameList = variableNameList &
                                    , chainFilePath = PD%ChainFile%Path%original &
                                    , targetChainSize = 2 * PD%Chain%Count%compact &
                                    , chainSize = PD%Chain%Count%compact &
                                    , chainFileForm = "compact" &
                                    )
        assertion = assertion .and. .not. CFC%Err%occurred
        if (Test%isVerboseMode .and. .not. assertion) then
        ! LCOV_EXCL_START
            write(*,"(10(g0,:,', '))")
            write(*,"(10(g0,:,', '))") "CFC%Err%occurred", CFC%Err%occurred
            write(*,"(10(g0,:,', '))") "CFC%Err%msg     ", CFC%Err%msg
            write(*,"(10(g0,:,', '))")
            return
        end if
        ! LCOV_EXCL_STOP

#endif
    end function test_constructChainFileContents_1

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

#undef ParaXXXX_ChainFileContents_mod