!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!
!!!!   MIT License
!!!!
!!!!   ParaMonte: plain powerful parallel Monte Carlo library.
!!!!
!!!!   Copyright (C) 2012-present, The Computational Data Science Lab
!!!!
!!!!   This file is part of the ParaMonte library.
!!!!
!!!!   Permission is hereby granted, free of charge, to any person obtaining a
!!!!   copy of this software and associated documentation files (the "Software"),
!!!!   to deal in the Software without restriction, including without limitation
!!!!   the rights to use, copy, modify, merge, publish, distribute, sublicense,
!!!!   and/or sell copies of the Software, and to permit persons to whom the
!!!!   Software is furnished to do so, subject to the following conditions:
!!!!
!!!!   The above copyright notice and this permission notice shall be
!!!!   included in all copies or substantial portions of the Software.
!!!!
!!!!   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
!!!!   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
!!!!   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
!!!!   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
!!!!   DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
!!!!   OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
!!!!   OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
!!!!
!!!!   ACKNOWLEDGMENT
!!!!
!!!!   ParaMonte is an honor-ware and its currency is acknowledgment and citations.
!!!!   As per the ParaMonte library license agreement terms, if you use any parts of
!!!!   this library for any purposes, kindly acknowledge the use of ParaMonte in your
!!!!   work (education/research/industry/development/...) by citing the ParaMonte
!!!!   library as described on this page:
!!!!
!!!!       https://github.com/cdslaborg/paramonte/blob/main/ACKNOWLEDGMENT.md
!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!>  \brief This module contains procedures for computing random numbers from a truncated Gaussian distribution.
!>  \author Amir Shahmoradi

module TranGaus_mod

    use Constants_mod, only: IK, RK

    implicit none

    character(*), parameter :: MODULE_NAME = "@TranGaus_mod"

    integer(IK), parameter  :: LEN_VEC_X = 4002, LEN_VEC_YU = 4001, LEN_VEC_CELL = 8961

    real(RK), parameter :: VEC_X_1(1:1000) = [ &
    -2.00443204036_RK, -1.99990455547_RK, -1.99541747213_RK, -1.99096998962_RK, &
    -1.98656133124_RK, -1.98219074335_RK, -1.97785749442_RK, -1.97356087419_RK, &
    -1.96930019287_RK, -1.96507478031_RK, -1.96088398528_RK, -1.95672717477_RK, &
    -1.95260373328_RK, -1.9485130622_RK, -1.94445457918_RK, -1.94042771755_RK, &
    -1.93643192574_RK, -1.93246666677_RK, -1.92853141772_RK, -1.92462566922_RK, &
    -1.92074892503_RK, -1.91690070156_RK, -1.91308052741_RK, -1.90928794302_RK, &
    -1.90552250025_RK, -1.90178376197_RK, -1.89807130174_RK, -1.89438470345_RK, &
    -1.89072356098_RK, -1.88708747787_RK, -1.88347606705_RK, -1.8798889505_RK, &
    -1.87632575899_RK, -1.87278613181_RK, -1.86926971649_RK, -1.86577616858_RK, &
    -1.86230515137_RK, -1.85885633567_RK, -1.8554293996_RK, -1.85202402837_RK, &
    -1.84863991405_RK, -1.84527675539_RK, -1.84193425762_RK, -1.83861213227_RK, &
    -1.83531009698_RK, -1.83202787533_RK, -1.82876519668_RK, -1.825521796_RK, &
    -1.82229741372_RK, -1.81909179558_RK, -1.81590469249_RK, -1.81273586036_RK, &
    -1.80958506_RK, -1.80645205698_RK, -1.8033366215_RK, -1.80023852827_RK, &
    -1.79715755637_RK, -1.79409348917_RK, -1.79104611422_RK, -1.78801522309_RK, &
    -1.78500061134_RK, -1.78200207837_RK, -1.77901942732_RK, -1.77605246501_RK, &
    -1.77310100183_RK, -1.77016485166_RK, -1.76724383175_RK, -1.7643377627_RK, &
    -1.7614464683_RK, -1.75856977555_RK, -1.75570751448_RK, -1.75285951816_RK, &
    -1.75002562257_RK, -1.74720566658_RK, -1.74439949184_RK, -1.74160694276_RK, &
    -1.73882786639_RK, -1.7360621124_RK, -1.73330953303_RK, -1.73056998298_RK, &
    -1.72784331941_RK, -1.72512940185_RK, -1.72242809217_RK, -1.71973925449_RK, &
    -1.71706275519_RK, -1.7143984628_RK, -1.71174624799_RK, -1.70910598353_RK, &
    -1.70647754419_RK, -1.70386080677_RK, -1.70125565_RK, -1.69866195455_RK, &
    -1.69607960292_RK, -1.69350847947_RK, -1.69094847035_RK, -1.68839946345_RK, &
    -1.6858613484_RK, -1.68333401649_RK, -1.68081736069_RK, -1.67831127556_RK, &
    -1.67581565725_RK, -1.67333040348_RK, -1.67085541345_RK, -1.6683905879_RK, &
    -1.665935829_RK, -1.66349104035_RK, -1.66105612696_RK, -1.65863099522_RK, &
    -1.65621555288_RK, -1.65380970898_RK, -1.65141337389_RK, -1.64902645924_RK, &
    -1.64664887792_RK, -1.64428054402_RK, -1.64192137286_RK, -1.63957128092_RK, &
    -1.63723018585_RK, -1.63489800643_RK, -1.63257466256_RK, -1.63026007522_RK, &
    -1.62795416649_RK, -1.62565685948_RK, -1.62336807836_RK, -1.62108774828_RK, &
    -1.61881579544_RK, -1.61655214696_RK, -1.61429673098_RK, -1.61204947656_RK, &
    -1.60981031368_RK, -1.60757917325_RK, -1.60535598708_RK, -1.60314068784_RK, &
    -1.60093320909_RK, -1.59873348523_RK, -1.59654145149_RK, -1.59435704393_RK, &
    -1.59218019943_RK, -1.59001085565_RK, -1.58784895103_RK, -1.58569442477_RK, &
    -1.58354721686_RK, -1.581407268_RK, -1.57927451964_RK, -1.57714891392_RK, &
    -1.57503039371_RK, -1.57291890258_RK, -1.57081438477_RK, -1.56871678519_RK, &
    -1.56662604942_RK, -1.56454212368_RK, -1.56246495486_RK, -1.56039449044_RK, &
    -1.55833067854_RK, -1.55627346789_RK, -1.55422280782_RK, -1.55217864825_RK, &
    -1.55014093969_RK, -1.5481096332_RK, -1.54608468043_RK, -1.54406603357_RK, &
    -1.54205364536_RK, -1.54004746908_RK, -1.53804745854_RK, -1.53605356807_RK, &
    -1.53406575252_RK, -1.53208396723_RK, -1.53010816806_RK, -1.52813831134_RK, &
    -1.52617435391_RK, -1.52421625305_RK, -1.52226396655_RK, -1.52031745264_RK, &
    -1.51837667_RK, -1.51644157777_RK, -1.51451213554_RK, -1.51258830332_RK, &
    -1.51067004156_RK, -1.50875731112_RK, -1.5068500733_RK, -1.50494828979_RK, &
    -1.50305192269_RK, -1.50116093452_RK, -1.49927528818_RK, -1.49739494693_RK, &
    -1.49551987447_RK, -1.49365003484_RK, -1.49178539245_RK, -1.48992591209_RK, &
    -1.48807155892_RK, -1.48622229844_RK, -1.48437809651_RK, -1.48253891934_RK, &
    -1.48070473348_RK, -1.47887550581_RK, -1.47705120356_RK, -1.47523179427_RK, &
    -1.47341724582_RK, -1.47160752641_RK, -1.46980260454_RK, -1.46800244903_RK, &
    -1.46620702902_RK, -1.46441631394_RK, -1.46263027351_RK, -1.46084887778_RK, &
    -1.45907209704_RK, -1.45729990192_RK, -1.4555322633_RK, -1.45376915236_RK, &
    -1.45201054053_RK, -1.45025639954_RK, -1.44850670139_RK, -1.44676141832_RK, &
    -1.44502052286_RK, -1.44328398779_RK, -1.44155178613_RK, -1.43982389118_RK, &
    -1.43810027647_RK, -1.43638091579_RK, -1.43466578316_RK, -1.43295485285_RK, &
    -1.43124809936_RK, -1.42954549744_RK, -1.42784702206_RK, -1.4261526484_RK, &
    -1.42446235191_RK, -1.42277610822_RK, -1.42109389321_RK, -1.41941568296_RK, &
    -1.41774145377_RK, -1.41607118216_RK, -1.41440484485_RK, -1.41274241877_RK, &
    -1.41108388106_RK, -1.40942920906_RK, -1.40777838029_RK, -1.40613137251_RK, &
    -1.40448816364_RK, -1.40284873181_RK, -1.40121305532_RK, -1.39958111269_RK, &
    -1.3979528826_RK, -1.39632834393_RK, -1.39470747574_RK, -1.39309025725_RK, &
    -1.39147666789_RK, -1.38986668723_RK, -1.38826029505_RK, -1.38665747129_RK, &
    -1.38505819603_RK, -1.38346244956_RK, -1.38187021232_RK, -1.3802814649_RK, &
    -1.37869618807_RK, -1.37711436276_RK, -1.37553597004_RK, -1.37396099116_RK, &
    -1.37238940752_RK, -1.37082120066_RK, -1.36925635228_RK, -1.36769484423_RK, &
    -1.36613665852_RK, -1.36458177727_RK, -1.3630301828_RK, -1.36148185752_RK, &
    -1.35993678401_RK, -1.35839494499_RK, -1.35685632332_RK, -1.35532090198_RK, &
    -1.3537886641_RK, -1.35225959295_RK, -1.35073367192_RK, -1.34921088453_RK, &
    -1.34769121444_RK, -1.34617464545_RK, -1.34466116145_RK, -1.34315074649_RK, &
    -1.34164338473_RK, -1.34013906045_RK, -1.33863775808_RK, -1.33713946213_RK, &
    -1.33564415726_RK, -1.33415182822_RK, -1.33266245992_RK, -1.33117603734_RK, &
    -1.3296925456_RK, -1.32821196994_RK, -1.32673429568_RK, -1.32525950829_RK, &
    -1.32378759331_RK, -1.32231853644_RK, -1.32085232344_RK, -1.31938894019_RK, &
    -1.3179283727_RK, -1.31647060705_RK, -1.31501562944_RK, -1.31356342618_RK, &
    -1.31211398366_RK, -1.31066728839_RK, -1.30922332698_RK, -1.30778208612_RK, &
    -1.30634355261_RK, -1.30490771336_RK, -1.30347455533_RK, -1.30204406564_RK, &
    -1.30061623144_RK, -1.29919104001_RK, -1.29776847873_RK, -1.29634853503_RK, &
    -1.29493119647_RK, -1.29351645068_RK, -1.29210428538_RK, -1.29069468838_RK, &
    -1.28928764758_RK, -1.28788315096_RK, -1.28648118658_RK, -1.2850817426_RK, &
    -1.28368480725_RK, -1.28229036885_RK, -1.2808984158_RK, -1.27950893658_RK, &
    -1.27812191975_RK, -1.27673735394_RK, -1.27535522788_RK, -1.27397553036_RK, &
    -1.27259825027_RK, -1.27122337654_RK, -1.2698508982_RK, -1.26848080436_RK, &
    -1.26711308419_RK, -1.26574772695_RK, -1.26438472195_RK, -1.26302405859_RK, &
    -1.26166572634_RK, -1.26030971474_RK, -1.25895601339_RK, -1.25760461198_RK, &
    -1.25625550025_RK, -1.25490866802_RK, -1.25356410517_RK, -1.25222180165_RK, &
    -1.25088174749_RK, -1.24954393277_RK, -1.24820834764_RK, -1.24687498231_RK, &
    -1.24554382707_RK, -1.24421487225_RK, -1.24288810826_RK, -1.24156352558_RK, &
    -1.24024111474_RK, -1.23892086632_RK, -1.23760277098_RK, -1.23628681945_RK, &
    -1.23497300248_RK, -1.23366131092_RK, -1.23235173565_RK, -1.23104426764_RK, &
    -1.22973889789_RK, -1.22843561746_RK, -1.22713441748_RK, -1.22583528914_RK, &
    -1.22453822366_RK, -1.22324321234_RK, -1.22195024653_RK, -1.22065931762_RK, &
    -1.21937041707_RK, -1.2180835364_RK, -1.21679866716_RK, -1.21551580096_RK, &
    -1.21423492948_RK, -1.21295604444_RK, -1.21167913759_RK, -1.21040420078_RK, &
    -1.20913122586_RK, -1.20786020475_RK, -1.20659112944_RK, -1.20532399194_RK, &
    -1.20405878432_RK, -1.2027954987_RK, -1.20153412724_RK, -1.20027466216_RK, &
    -1.19901709572_RK, -1.19776142023_RK, -1.19650762804_RK, -1.19525571156_RK, &
    -1.19400566322_RK, -1.19275747553_RK, -1.19151114101_RK, -1.19026665225_RK, &
    -1.18902400188_RK, -1.18778318256_RK, -1.18654418701_RK, -1.18530700798_RK, &
    -1.18407163828_RK, -1.18283807074_RK, -1.18160629825_RK, -1.18037631374_RK, &
    -1.17914811017_RK, -1.17792168055_RK, -1.17669701793_RK, -1.1754741154_RK, &
    -1.17425296609_RK, -1.17303356317_RK, -1.17181589985_RK, -1.17059996938_RK, &
    -1.16938576505_RK, -1.16817328018_RK, -1.16696250814_RK, -1.16575344233_RK, &
    -1.1645460762_RK, -1.16334040321_RK, -1.16213641689_RK, -1.16093411079_RK, &
    -1.1597334785_RK, -1.15853451364_RK, -1.15733720988_RK, -1.1561415609_RK, &
    -1.15494756045_RK, -1.1537552023_RK, -1.15256448023_RK, -1.1513753881_RK, &
    -1.15018791978_RK, -1.14900206916_RK, -1.1478178302_RK, -1.14663519686_RK, &
    -1.14545416315_RK, -1.14427472312_RK, -1.14309687083_RK, -1.14192060039_RK, &
    -1.14074590595_RK, -1.13957278166_RK, -1.13840122174_RK, -1.13723122041_RK, &
    -1.13606277195_RK, -1.13489587064_RK, -1.13373051083_RK, -1.13256668686_RK, &
    -1.13140439313_RK, -1.13024362405_RK, -1.12908437408_RK, -1.12792663769_RK, &
    -1.1267704094_RK, -1.12561568374_RK, -1.12446245528_RK, -1.12331071862_RK, &
    -1.12216046839_RK, -1.12101169923_RK, -1.11986440583_RK, -1.1187185829_RK, &
    -1.11757422519_RK, -1.11643132745_RK, -1.11528988448_RK, -1.11414989111_RK, &
    -1.11301134218_RK, -1.11187423257_RK, -1.11073855719_RK, -1.10960431095_RK, &
    -1.10847148882_RK, -1.10734008578_RK, -1.10621009684_RK, -1.10508151703_RK, &
    -1.10395434141_RK, -1.10282856507_RK, -1.10170418311_RK, -1.10058119068_RK, &
    -1.09945958293_RK, -1.09833935506_RK, -1.09722050226_RK, -1.09610301977_RK, &
    -1.09498690286_RK, -1.09387214681_RK, -1.09275874692_RK, -1.09164669853_RK, &
    -1.09053599698_RK, -1.08942663766_RK, -1.08831861598_RK, -1.08721192734_RK, &
    -1.08610656721_RK, -1.08500253104_RK, -1.08389981434_RK, -1.08279841262_RK, &
    -1.08169832142_RK, -1.0805995363_RK, -1.07950205283_RK, -1.07840586663_RK, &
    -1.07731097332_RK, -1.07621736855_RK, -1.07512504799_RK, -1.07403400732_RK, &
    -1.07294424226_RK, -1.07185574854_RK, -1.07076852192_RK, -1.06968255816_RK, &
    -1.06859785307_RK, -1.06751440246_RK, -1.06643220217_RK, -1.06535124805_RK, &
    -1.06427153597_RK, -1.06319306184_RK, -1.06211582157_RK, -1.06103981109_RK, &
    -1.05996502636_RK, -1.05889146336_RK, -1.05781911808_RK, -1.05674798653_RK, &
    -1.05567806475_RK, -1.05460934878_RK, -1.0535418347_RK, -1.0524755186_RK, &
    -1.05141039657_RK, -1.05034646476_RK, -1.04928371929_RK, -1.04822215635_RK, &
    -1.04716177209_RK, -1.04610256273_RK, -1.04504452448_RK, -1.04398765357_RK, &
    -1.04293194626_RK, -1.04187739881_RK, -1.04082400752_RK, -1.03977176868_RK, &
    -1.03872067861_RK, -1.03767073366_RK, -1.03662193018_RK, -1.03557426455_RK, &
    -1.03452773314_RK, -1.03348233237_RK, -1.03243805866_RK, -1.03139490845_RK, &
    -1.03035287819_RK, -1.02931196435_RK, -1.02827216342_RK, -1.02723347191_RK, &
    -1.02619588633_RK, -1.02515940322_RK, -1.02412401912_RK, -1.02308973062_RK, &
    -1.02205653428_RK, -1.02102442671_RK, -1.01999340452_RK, -1.01896346433_RK, &
    -1.01793460279_RK, -1.01690681657_RK, -1.01588010232_RK, -1.01485445675_RK, &
    -1.01382987655_RK, -1.01280635844_RK, -1.01178389916_RK, -1.01076249545_RK, &
    -1.00974214407_RK, -1.0087228418_RK, -1.00770458543_RK, -1.00668737176_RK, &
    -1.00567119762_RK, -1.00465605983_RK, -1.00364195524_RK, -1.00262888071_RK, &
    -1.00161683312_RK, -1.00060580935_RK, -0.999595806306_RK, -0.9985868209_RK, &
    -0.997578850062_RK, -0.996571890733_RK, -0.995565939868_RK, -0.994560994436_RK, &
    -0.993557051418_RK, -0.992554107808_RK, -0.991552160613_RK, -0.990551206854_RK, &
    -0.989551243564_RK, -0.988552267788_RK, -0.987554276585_RK, -0.986557267027_RK, &
    -0.985561236196_RK, -0.984566181188_RK, -0.983572099113_RK, -0.982578987091_RK, &
    -0.981586842254_RK, -0.980595661749_RK, -0.979605442731_RK, -0.978616182371_RK, &
    -0.977627877849_RK, -0.976640526359_RK, -0.975654125105_RK, -0.974668671305_RK, &
    -0.973684162186_RK, -0.972700594988_RK, -0.971717966963_RK, -0.970736275374_RK, &
    -0.969755517495_RK, -0.968775690612_RK, -0.967796792022_RK, -0.966818819033_RK, &
    -0.965841768964_RK, -0.964865639146_RK, -0.963890426921_RK, -0.962916129641_RK, &
    -0.961942744669_RK, -0.960970269379_RK, -0.959998701157_RK, -0.959028037398_RK, &
    -0.958058275508_RK, -0.957089412906_RK, -0.956121447017_RK, -0.955154375281_RK, &
    -0.954188195145_RK, -0.953222904069_RK, -0.952258499521_RK, -0.951294978982_RK, &
    -0.95033233994_RK, -0.949370579895_RK, -0.948409696358_RK, -0.947449686847_RK, &
    -0.946490548893_RK, -0.945532280036_RK, -0.944574877824_RK, -0.943618339818_RK, &
    -0.942662663587_RK, -0.941707846709_RK, -0.940753886774_RK, -0.939800781378_RK, &
    -0.93884852813_RK, -0.937897124647_RK, -0.936946568555_RK, -0.935996857491_RK, &
    -0.9350479891_RK, -0.934099961035_RK, -0.933152770962_RK, -0.932206416553_RK, &
    -0.931260895491_RK, -0.930316205466_RK, -0.929372344179_RK, -0.928429309338_RK, &
    -0.927487098664_RK, -0.926545709881_RK, -0.925605140727_RK, -0.924665388946_RK, &
    -0.923726452292_RK, -0.922788328527_RK, -0.921851015421_RK, -0.920914510754_RK, &
    -0.919978812315_RK, -0.919043917899_RK, -0.918109825313_RK, -0.917176532369_RK, &
    -0.916244036888_RK, -0.915312336703_RK, -0.91438142965_RK, -0.913451313577_RK, &
    -0.912521986339_RK, -0.911593445799_RK, -0.910665689828_RK, -0.909738716305_RK, &
    -0.908812523118_RK, -0.907887108163_RK, -0.906962469342_RK, -0.906038604567_RK, &
    -0.905115511758_RK, -0.90419318884_RK, -0.90327163375_RK, -0.902350844428_RK, &
    -0.901430818827_RK, -0.900511554903_RK, -0.899593050622_RK, -0.898675303958_RK, &
    -0.897758312891_RK, -0.896842075409_RK, -0.895926589508_RK, -0.895011853191_RK, &
    -0.894097864469_RK, -0.893184621359_RK, -0.892272121887_RK, -0.891360364086_RK, &
    -0.890449345995_RK, -0.889539065661_RK, -0.888629521138_RK, -0.887720710488_RK, &
    -0.886812631779_RK, -0.885905283087_RK, -0.884998662493_RK, -0.884092768089_RK, &
    -0.883187597969_RK, -0.882283150238_RK, -0.881379423006_RK, -0.88047641439_RK, &
    -0.879574122514_RK, -0.878672545509_RK, -0.877771681512_RK, -0.876871528668_RK, &
    -0.875972085128_RK, -0.875073349049_RK, -0.874175318595_RK, -0.873277991937_RK, &
    -0.872381367254_RK, -0.871485442727_RK, -0.870590216549_RK, -0.869695686916_RK, &
    -0.868801852031_RK, -0.867908710104_RK, -0.86701625935_RK, -0.866124497993_RK, &
    -0.865233424261_RK, -0.864343036389_RK, -0.863453332618_RK, -0.862564311196_RK, &
    -0.861675970376_RK, -0.860788308418_RK, -0.859901323588_RK, -0.859015014157_RK, &
    -0.858129378404_RK, -0.857244414613_RK, -0.856360121074_RK, -0.855476496083_RK, &
    -0.854593537942_RK, -0.853711244958_RK, -0.852829615446_RK, -0.851948647726_RK, &
    -0.851068340122_RK, -0.850188690965_RK, -0.849309698594_RK, -0.84843136135_RK, &
    -0.847553677583_RK, -0.846676645646_RK, -0.845800263899_RK, -0.844924530708_RK, &
    -0.844049444444_RK, -0.843175003483_RK, -0.842301206208_RK, -0.841428051007_RK, &
    -0.840555536273_RK, -0.839683660404_RK, -0.838812421805_RK, -0.837941818885_RK, &
    -0.83707185006_RK, -0.83620251375_RK, -0.83533380838_RK, -0.834465732382_RK, &
    -0.833598284192_RK, -0.832731462252_RK, -0.831865265009_RK, -0.830999690914_RK, &
    -0.830134738426_RK, -0.829270406006_RK, -0.828406692123_RK, -0.827543595248_RK, &
    -0.826681113861_RK, -0.825819246443_RK, -0.824957991484_RK, -0.824097347476_RK, &
    -0.823237312917_RK, -0.82237788631_RK, -0.821519066163_RK, -0.82066085099_RK, &
    -0.819803239307_RK, -0.818946229639_RK, -0.818089820512_RK, -0.817234010459_RK, &
    -0.816378798017_RK, -0.815524181729_RK, -0.814670160142_RK, -0.813816731806_RK, &
    -0.812963895279_RK, -0.812111649122_RK, -0.8112599919_RK, -0.810408922185_RK, &
    -0.80955843855_RK, -0.808708539576_RK, -0.807859223848_RK, -0.807010489955_RK, &
    -0.806162336489_RK, -0.805314762049_RK, -0.804467765238_RK, -0.803621344663_RK, &
    -0.802775498936_RK, -0.801930226672_RK, -0.801085526493_RK, -0.800241397023_RK, &
    -0.799397836891_RK, -0.798554844732_RK, -0.797712419183_RK, -0.796870558888_RK, &
    -0.796029262492_RK, -0.795188528648_RK, -0.79434835601_RK, -0.793508743238_RK, &
    -0.792669688996_RK, -0.791831191953_RK, -0.790993250781_RK, -0.790155864155_RK, &
    -0.789319030758_RK, -0.788482749274_RK, -0.787647018393_RK, -0.786811836806_RK, &
    -0.785977203212_RK, -0.785143116312_RK, -0.784309574812_RK, -0.783476577421_RK, &
    -0.782644122852_RK, -0.781812209823_RK, -0.780980837056_RK, -0.780150003277_RK, &
    -0.779319707213_RK, -0.7784899476_RK, -0.777660723175_RK, -0.776832032678_RK, &
    -0.776003874855_RK, -0.775176248455_RK, -0.774349152231_RK, -0.773522584939_RK, &
    -0.772696545341_RK, -0.7718710322_RK, -0.771046044284_RK, -0.770221580367_RK, &
    -0.769397639223_RK, -0.768574219631_RK, -0.767751320376_RK, -0.766928940243_RK, &
    -0.766107078024_RK, -0.765285732513_RK, -0.764464902507_RK, -0.763644586809_RK, &
    -0.762824784223_RK, -0.762005493558_RK, -0.761186713627_RK, -0.760368443246_RK, &
    -0.759550681234_RK, -0.758733426414_RK, -0.757916677614_RK, -0.757100433662_RK, &
    -0.756284693394_RK, -0.755469455646_RK, -0.754654719259_RK, -0.753840483077_RK, &
    -0.753026745948_RK, -0.752213506722_RK, -0.751400764255_RK, -0.750588517404_RK, &
    -0.74977676503_RK, -0.748965505998_RK, -0.748154739176_RK, -0.747344463435_RK, &
    -0.746534677651_RK, -0.7457253807_RK, -0.744916571465_RK, -0.74410824883_RK, &
    -0.743300411682_RK, -0.742493058914_RK, -0.741686189419_RK, -0.740879802096_RK, &
    -0.740073895844_RK, -0.739268469569_RK, -0.738463522177_RK, -0.737659052579_RK, &
    -0.736855059689_RK, -0.736051542423_RK, -0.735248499702_RK, -0.734445930447_RK, &
    -0.733643833587_RK, -0.73284220805_RK, -0.732041052768_RK, -0.731240366677_RK, &
    -0.730440148716_RK, -0.729640397826_RK, -0.728841112951_RK, -0.728042293041_RK, &
    -0.727243937044_RK, -0.726446043916_RK, -0.725648612612_RK, -0.724851642093_RK, &
    -0.724055131321_RK, -0.723259079262_RK, -0.722463484884_RK, -0.721668347159_RK, &
    -0.720873665062_RK, -0.720079437569_RK, -0.719285663661_RK, -0.718492342322_RK, &
    -0.717699472536_RK, -0.716907053294_RK, -0.716115083586_RK, -0.715323562408_RK, &
    -0.714532488756_RK, -0.713741861631_RK, -0.712951680037_RK, -0.712161942978_RK, &
    -0.711372649463_RK, -0.710583798504_RK, -0.709795389115_RK, -0.709007420313_RK, &
    -0.708219891118_RK, -0.707432800551_RK, -0.706646147638_RK, -0.705859931406_RK, &
    -0.705074150887_RK, -0.704288805113_RK, -0.70350389312_RK, -0.702719413947_RK, &
    -0.701935366634_RK, -0.701151750226_RK, -0.700368563769_RK, -0.699585806312_RK, &
    -0.698803476906_RK, -0.698021574607_RK, -0.69724009847_RK, -0.696459047555_RK, &
    -0.695678420925_RK, -0.694898217643_RK, -0.694118436777_RK, -0.693339077397_RK, &
    -0.692560138575_RK, -0.691781619384_RK, -0.691003518904_RK, -0.690225836212_RK, &
    -0.689448570392_RK, -0.688671720529_RK, -0.687895285708_RK, -0.687119265021_RK, &
    -0.686343657558_RK, -0.685568462415_RK, -0.684793678689_RK, -0.684019305478_RK, &
    -0.683245341885_RK, -0.682471787013_RK, -0.68169863997_RK, -0.680925899864_RK, &
    -0.680153565806_RK, -0.679381636911_RK, -0.678610112294_RK, -0.677838991074_RK, &
    -0.677068272372_RK, -0.67629795531_RK, -0.675528039013_RK, -0.674758522611_RK, &
    -0.673989405232_RK, -0.67322068601_RK, -0.672452364078_RK, -0.671684438573_RK, &
    -0.670916908635_RK, -0.670149773405_RK, -0.669383032026_RK, -0.668616683646_RK, &
    -0.66785072741_RK, -0.667085162471_RK, -0.666319987981_RK, -0.665555203094_RK, &
    -0.664790806967_RK, -0.66402679876_RK, -0.663263177633_RK, -0.662499942752_RK, &
    -0.66173709328_RK, -0.660974628386_RK, -0.66021254724_RK, -0.659450849015_RK, &
    -0.658689532883_RK, -0.657928598023_RK, -0.657168043612_RK, -0.656407868831_RK, &
    -0.655648072862_RK, -0.654888654892_RK, -0.654129614105_RK, -0.653370949693_RK, &
    -0.652612660844_RK, -0.651854746754_RK, -0.651097206616_RK, -0.650340039629_RK, &
    -0.64958324499_RK, -0.648826821903_RK, -0.648070769569_RK, -0.647315087195_RK, &
    -0.646559773988_RK, -0.645804829157_RK, -0.645050251913_RK, -0.64429604147_RK, &
    -0.643542197043_RK, -0.642788717849_RK, -0.642035603108_RK, -0.641282852041_RK, &
    -0.640530463871_RK, -0.639778437823_RK, -0.639026773124_RK, -0.638275469004_RK, &
    -0.637524524692_RK, -0.636773939423_RK, -0.636023712429_RK, -0.63527384295_RK, &
    -0.634524330221_RK, -0.633775173485_RK, -0.633026371984_RK, -0.632277924961_RK, &
    -0.631529831662_RK, -0.630782091336_RK, -0.630034703232_RK, -0.629287666601_RK, &
    -0.628540980698_RK, -0.627794644778_RK, -0.627048658096_RK, -0.626303019913_RK, &
    -0.625557729489_RK, -0.624812786087_RK, -0.62406818897_RK, -0.623323937406_RK ]

    real(RK), parameter :: VEC_X_2(1001:2000) = [ &
    -0.622580030661_RK, -0.621836468005_RK, -0.621093248711_RK, -0.62035037205_RK, &
    -0.619607837299_RK, -0.618865643733_RK, -0.618123790632_RK, -0.617382277275_RK, &
    -0.616641102944_RK, -0.615900266923_RK, -0.615159768498_RK, -0.614419606955_RK, &
    -0.613679781584_RK, -0.612940291674_RK, -0.612201136518_RK, -0.61146231541_RK, &
    -0.610723827646_RK, -0.609985672522_RK, -0.609247849338_RK, -0.608510357395_RK, &
    -0.607773195994_RK, -0.607036364439_RK, -0.606299862036_RK, -0.605563688093_RK, &
    -0.604827841918_RK, -0.604092322821_RK, -0.603357130115_RK, -0.602622263113_RK, &
    -0.601887721131_RK, -0.601153503486_RK, -0.600419609496_RK, -0.599686038481_RK, &
    -0.598952789763_RK, -0.598219862666_RK, -0.597487256514_RK, -0.596754970634_RK, &
    -0.596023004354_RK, -0.595291357003_RK, -0.594560027913_RK, -0.593829016416_RK, &
    -0.593098321847_RK, -0.592367943541_RK, -0.591637880836_RK, -0.590908133071_RK, &
    -0.590178699585_RK, -0.589449579722_RK, -0.588720772824_RK, -0.587992278236_RK, &
    -0.587264095305_RK, -0.586536223378_RK, -0.585808661806_RK, -0.585081409939_RK, &
    -0.584354467129_RK, -0.58362783273_RK, -0.582901506099_RK, -0.58217548659_RK, &
    -0.581449773564_RK, -0.580724366379_RK, -0.579999264397_RK, -0.57927446698_RK, &
    -0.578549973492_RK, -0.5778257833_RK, -0.577101895769_RK, -0.576378310269_RK, &
    -0.575655026169_RK, -0.57493204284_RK, -0.574209359655_RK, -0.573486975988_RK, &
    -0.572764891214_RK, -0.57204310471_RK, -0.571321615855_RK, -0.570600424028_RK, &
    -0.56987952861_RK, -0.569158928984_RK, -0.568438624533_RK, -0.567718614641_RK, &
    -0.566998898697_RK, -0.566279476088_RK, -0.565560346202_RK, -0.56484150843_RK, &
    -0.564122962165_RK, -0.563404706799_RK, -0.562686741727_RK, -0.561969066345_RK, &
    -0.56125168005_RK, -0.560534582241_RK, -0.559817772317_RK, -0.559101249681_RK, &
    -0.558385013733_RK, -0.557669063878_RK, -0.556953399521_RK, -0.556238020069_RK, &
    -0.555522924929_RK, -0.55480811351_RK, -0.554093585223_RK, -0.553379339478_RK, &
    -0.552665375689_RK, -0.551951693269_RK, -0.551238291635_RK, -0.550525170202_RK, &
    -0.549812328389_RK, -0.549099765614_RK, -0.548387481299_RK, -0.547675474863_RK, &
    -0.546963745731_RK, -0.546252293327_RK, -0.545541117075_RK, -0.544830216402_RK, &
    -0.544119590737_RK, -0.543409239507_RK, -0.542699162143_RK, -0.541989358077_RK, &
    -0.541279826741_RK, -0.540570567568_RK, -0.539861579995_RK, -0.539152863456_RK, &
    -0.53844441739_RK, -0.537736241235_RK, -0.537028334431_RK, -0.536320696418_RK, &
    -0.535613326639_RK, -0.534906224537_RK, -0.534199389557_RK, -0.533492821143_RK, &
    -0.532786518743_RK, -0.532080481805_RK, -0.531374709778_RK, -0.530669202111_RK, &
    -0.529963958257_RK, -0.529258977668_RK, -0.528554259797_RK, -0.5278498041_RK, &
    -0.527145610031_RK, -0.526441677048_RK, -0.52573800461_RK, -0.525034592175_RK, &
    -0.524331439204_RK, -0.523628545158_RK, -0.5229259095_RK, -0.522223531693_RK, &
    -0.521521411203_RK, -0.520819547494_RK, -0.520117940035_RK, -0.519416588293_RK, &
    -0.518715491738_RK, -0.518014649839_RK, -0.517314062067_RK, -0.516613727896_RK, &
    -0.515913646798_RK, -0.515213818248_RK, -0.514514241722_RK, -0.513814916696_RK, &
    -0.513115842648_RK, -0.512417019057_RK, -0.511718445402_RK, -0.511020121164_RK, &
    -0.510322045826_RK, -0.509624218869_RK, -0.508926639778_RK, -0.508229308038_RK, &
    -0.507532223135_RK, -0.506835384556_RK, -0.506138791788_RK, -0.505442444322_RK, &
    -0.504746341647_RK, -0.504050483254_RK, -0.503354868635_RK, -0.502659497283_RK, &
    -0.501964368692_RK, -0.501269482359_RK, -0.500574837777_RK, -0.499880434446_RK, &
    -0.499186271862_RK, -0.498492349525_RK, -0.497798666935_RK, -0.497105223592_RK, &
    -0.496412018999_RK, -0.49571905266_RK, -0.495026324076_RK, -0.494333832755_RK, &
    -0.493641578201_RK, -0.492949559921_RK, -0.492257777423_RK, -0.491566230217_RK, &
    -0.49087491781_RK, -0.490183839715_RK, -0.489492995442_RK, -0.488802384505_RK, &
    -0.488112006416_RK, -0.487421860691_RK, -0.486731946843_RK, -0.48604226439_RK, &
    -0.48535281285_RK, -0.484663591739_RK, -0.483974600576_RK, -0.483285838883_RK, &
    -0.48259730618_RK, -0.481909001988_RK, -0.48122092583_RK, -0.480533077229_RK, &
    -0.479845455711_RK, -0.479158060801_RK, -0.478470892024_RK, -0.477783948909_RK, &
    -0.477097230982_RK, -0.476410737773_RK, -0.475724468813_RK, -0.47503842363_RK, &
    -0.474352601759_RK, -0.473667002729_RK, -0.472981626076_RK, -0.472296471333_RK, &
    -0.471611538035_RK, -0.470926825718_RK, -0.470242333919_RK, -0.469558062177_RK, &
    -0.468874010028_RK, -0.468190177013_RK, -0.467506562672_RK, -0.466823166546_RK, &
    -0.466139988176_RK, -0.465457027107_RK, -0.46477428288_RK, -0.464091755042_RK, &
    -0.463409443136_RK, -0.46272734671_RK, -0.46204546531_RK, -0.461363798483_RK, &
    -0.460682345779_RK, -0.460001106748_RK, -0.459320080938_RK, -0.458639267901_RK, &
    -0.45795866719_RK, -0.457278278357_RK, -0.456598100954_RK, -0.455918134538_RK, &
    -0.455238378662_RK, -0.454558832883_RK, -0.453879496757_RK, -0.453200369842_RK, &
    -0.452521451697_RK, -0.45184274188_RK, -0.45116423995_RK, -0.45048594547_RK, &
    -0.449807858_RK, -0.449129977103_RK, -0.448452302341_RK, -0.447774833279_RK, &
    -0.44709756948_RK, -0.446420510511_RK, -0.445743655937_RK, -0.445067005325_RK, &
    -0.444390558244_RK, -0.44371431426_RK, -0.443038272944_RK, -0.442362433866_RK, &
    -0.441686796595_RK, -0.441011360704_RK, -0.440336125765_RK, -0.43966109135_RK, &
    -0.438986257034_RK, -0.43831162239_RK, -0.437637186994_RK, -0.436962950421_RK, &
    -0.436288912249_RK, -0.435615072055_RK, -0.434941429417_RK, -0.434267983913_RK, &
    -0.433594735123_RK, -0.432921682628_RK, -0.432248826008_RK, -0.431576164846_RK, &
    -0.430903698722_RK, -0.430231427222_RK, -0.429559349928_RK, -0.428887466426_RK, &
    -0.4282157763_RK, -0.427544279136_RK, -0.426872974521_RK, -0.426201862043_RK, &
    -0.42553094129_RK, -0.42486021185_RK, -0.424189673313_RK, -0.423519325269_RK, &
    -0.422849167309_RK, -0.422179199024_RK, -0.421509420007_RK, -0.420839829851_RK, &
    -0.420170428149_RK, -0.419501214496_RK, -0.418832188486_RK, -0.418163349716_RK, &
    -0.417494697781_RK, -0.416826232279_RK, -0.416157952806_RK, -0.415489858963_RK, &
    -0.414821950346_RK, -0.414154226557_RK, -0.413486687196_RK, -0.412819331863_RK, &
    -0.41215216016_RK, -0.41148517169_RK, -0.410818366055_RK, -0.410151742859_RK, &
    -0.409485301706_RK, -0.408819042201_RK, -0.40815296395_RK, -0.407487066559_RK, &
    -0.406821349634_RK, -0.406155812784_RK, -0.405490455615_RK, -0.404825277738_RK, &
    -0.404160278761_RK, -0.403495458294_RK, -0.402830815949_RK, -0.402166351335_RK, &
    -0.401502064066_RK, -0.400837953753_RK, -0.40017402001_RK, -0.399510262451_RK, &
    -0.398846680689_RK, -0.39818327434_RK, -0.397520043019_RK, -0.396856986343_RK, &
    -0.396194103929_RK, -0.395531395393_RK, -0.394868860354_RK, -0.394206498431_RK, &
    -0.393544309243_RK, -0.392882292409_RK, -0.392220447549_RK, -0.391558774287_RK, &
    -0.390897272241_RK, -0.390235941036_RK, -0.389574780293_RK, -0.388913789636_RK, &
    -0.38825296869_RK, -0.387592317078_RK, -0.386931834425_RK, -0.386271520359_RK, &
    -0.385611374504_RK, -0.384951396488_RK, -0.384291585938_RK, -0.383631942482_RK, &
    -0.382972465749_RK, -0.382313155368_RK, -0.381654010969_RK, -0.380995032182_RK, &
    -0.380336218639_RK, -0.379677569969_RK, -0.379019085806_RK, -0.378360765783_RK, &
    -0.377702609531_RK, -0.377044616686_RK, -0.37638678688_RK, -0.37572911975_RK, &
    -0.37507161493_RK, -0.374414272056_RK, -0.373757090765_RK, -0.373100070693_RK, &
    -0.372443211479_RK, -0.37178651276_RK, -0.371129974175_RK, -0.370473595364_RK, &
    -0.369817375965_RK, -0.369161315619_RK, -0.368505413967_RK, -0.36784967065_RK, &
    -0.367194085311_RK, -0.36653865759_RK, -0.365883387132_RK, -0.36522827358_RK, &
    -0.364573316578_RK, -0.36391851577_RK, -0.363263870801_RK, -0.362609381316_RK, &
    -0.361955046963_RK, -0.361300867386_RK, -0.360646842235_RK, -0.359992971155_RK, &
    -0.359339253795_RK, -0.358685689804_RK, -0.358032278831_RK, -0.357379020525_RK, &
    -0.356725914537_RK, -0.356072960516_RK, -0.355420158116_RK, -0.354767506986_RK, &
    -0.354115006779_RK, -0.353462657149_RK, -0.352810457747_RK, -0.352158408227_RK, &
    -0.351506508245_RK, -0.350854757453_RK, -0.350203155508_RK, -0.349551702065_RK, &
    -0.34890039678_RK, -0.348249239309_RK, -0.34759822931_RK, -0.346947366441_RK, &
    -0.346296650358_RK, -0.345646080722_RK, -0.344995657189_RK, -0.344345379421_RK, &
    -0.343695247078_RK, -0.343045259818_RK, -0.342395417304_RK, -0.341745719196_RK, &
    -0.341096165157_RK, -0.340446754849_RK, -0.339797487934_RK, -0.339148364076_RK, &
    -0.338499382938_RK, -0.337850544184_RK, -0.33720184748_RK, -0.33655329249_RK, &
    -0.335904878879_RK, -0.335256606314_RK, -0.334608474462_RK, -0.333960482988_RK, &
    -0.33331263156_RK, -0.332664919846_RK, -0.332017347514_RK, -0.331369914234_RK, &
    -0.330722619673_RK, -0.330075463502_RK, -0.329428445391_RK, -0.328781565009_RK, &
    -0.328134822029_RK, -0.32748821612_RK, -0.326841746956_RK, -0.326195414208_RK, &
    -0.325549217549_RK, -0.324903156652_RK, -0.32425723119_RK, -0.323611440838_RK, &
    -0.322965785269_RK, -0.322320264159_RK, -0.321674877183_RK, -0.321029624016_RK, &
    -0.320384504335_RK, -0.319739517815_RK, -0.319094664135_RK, -0.318449942971_RK, &
    -0.317805354_RK, -0.317160896902_RK, -0.316516571355_RK, -0.315872377037_RK, &
    -0.315228313629_RK, -0.314584380809_RK, -0.313940578259_RK, -0.313296905659_RK, &
    -0.312653362689_RK, -0.312009949032_RK, -0.311366664369_RK, -0.310723508383_RK, &
    -0.310080480756_RK, -0.309437581171_RK, -0.308794809313_RK, -0.308152164863_RK, &
    -0.307509647508_RK, -0.306867256932_RK, -0.306224992819_RK, -0.305582854855_RK, &
    -0.304940842726_RK, -0.304298956119_RK, -0.303657194719_RK, -0.303015558215_RK, &
    -0.302374046293_RK, -0.301732658641_RK, -0.301091394947_RK, -0.3004502549_RK, &
    -0.29980923819_RK, -0.299168344504_RK, -0.298527573533_RK, -0.297886924968_RK, &
    -0.297246398498_RK, -0.296605993814_RK, -0.295965710609_RK, -0.295325548572_RK, &
    -0.294685507396_RK, -0.294045586775_RK, -0.293405786399_RK, -0.292766105963_RK, &
    -0.292126545159_RK, -0.291487103683_RK, -0.290847781227_RK, -0.290208577487_RK, &
    -0.289569492157_RK, -0.288930524932_RK, -0.288291675509_RK, -0.287652943584_RK, &
    -0.287014328852_RK, -0.28637583101_RK, -0.285737449756_RK, -0.285099184787_RK, &
    -0.2844610358_RK, -0.283823002495_RK, -0.283185084568_RK, -0.28254728172_RK, &
    -0.28190959365_RK, -0.281272020056_RK, -0.280634560639_RK, -0.279997215099_RK, &
    -0.279359983137_RK, -0.278722864454_RK, -0.278085858751_RK, -0.277448965729_RK, &
    -0.27681218509_RK, -0.276175516537_RK, -0.275538959773_RK, -0.2749025145_RK, &
    -0.274266180422_RK, -0.273629957242_RK, -0.272993844665_RK, -0.272357842394_RK, &
    -0.271721950134_RK, -0.271086167591_RK, -0.270450494469_RK, -0.269814930474_RK, &
    -0.269179475313_RK, -0.268544128691_RK, -0.267908890315_RK, -0.267273759892_RK, &
    -0.26663873713_RK, -0.266003821735_RK, -0.265369013416_RK, -0.264734311881_RK, &
    -0.264099716838_RK, -0.263465227997_RK, -0.262830845067_RK, -0.262196567757_RK, &
    -0.261562395776_RK, -0.260928328836_RK, -0.260294366646_RK, -0.259660508917_RK, &
    -0.25902675536_RK, -0.258393105687_RK, -0.25775955961_RK, -0.25712611684_RK, &
    -0.256492777089_RK, -0.25585954007_RK, -0.255226405497_RK, -0.254593373082_RK, &
    -0.253960442538_RK, -0.253327613581_RK, -0.252694885923_RK, -0.252062259279_RK, &
    -0.251429733364_RK, -0.250797307892_RK, -0.25016498258_RK, -0.249532757143_RK, &
    -0.248900631296_RK, -0.248268604756_RK, -0.24763667724_RK, -0.247004848463_RK, &
    -0.246373118143_RK, -0.245741485998_RK, -0.245109951745_RK, -0.244478515102_RK, &
    -0.243847175788_RK, -0.24321593352_RK, -0.242584788017_RK, -0.241953738999_RK, &
    -0.241322786185_RK, -0.240691929294_RK, -0.240061168047_RK, -0.239430502163_RK, &
    -0.238799931363_RK, -0.238169455368_RK, -0.237539073899_RK, -0.236908786677_RK, &
    -0.236278593424_RK, -0.235648493861_RK, -0.235018487711_RK, -0.234388574696_RK, &
    -0.233758754538_RK, -0.233129026961_RK, -0.232499391688_RK, -0.231869848442_RK, &
    -0.231240396947_RK, -0.230611036927_RK, -0.229981768106_RK, -0.229352590209_RK, &
    -0.22872350296_RK, -0.228094506085_RK, -0.227465599309_RK, -0.226836782357_RK, &
    -0.226208054955_RK, -0.22557941683_RK, -0.224950867708_RK, -0.224322407315_RK, &
    -0.223694035378_RK, -0.223065751624_RK, -0.222437555781_RK, -0.221809447576_RK, &
    -0.221181426737_RK, -0.220553492993_RK, -0.219925646071_RK, -0.219297885701_RK, &
    -0.21867021161_RK, -0.218042623529_RK, -0.217415121186_RK, -0.216787704312_RK, &
    -0.216160372636_RK, -0.215533125887_RK, -0.214905963798_RK, -0.214278886097_RK, &
    -0.213651892517_RK, -0.213024982787_RK, -0.212398156639_RK, -0.211771413806_RK, &
    -0.211144754018_RK, -0.210518177008_RK, -0.209891682507_RK, -0.209265270249_RK, &
    -0.208638939966_RK, -0.208012691392_RK, -0.207386524258_RK, -0.206760438299_RK, &
    -0.206134433249_RK, -0.20550850884_RK, -0.204882664808_RK, -0.204256900887_RK, &
    -0.203631216811_RK, -0.203005612315_RK, -0.202380087133_RK, -0.201754641003_RK, &
    -0.201129273658_RK, -0.200503984834_RK, -0.199878774268_RK, -0.199253641695_RK, &
    -0.198628586852_RK, -0.198003609476_RK, -0.197378709302_RK, -0.196753886069_RK, &
    -0.196129139514_RK, -0.195504469373_RK, -0.194879875385_RK, -0.194255357287_RK, &
    -0.193630914818_RK, -0.193006547715_RK, -0.192382255718_RK, -0.191758038565_RK, &
    -0.191133895995_RK, -0.190509827747_RK, -0.189885833561_RK, -0.189261913176_RK, &
    -0.188638066331_RK, -0.188014292767_RK, -0.187390592225_RK, -0.186766964443_RK, &
    -0.186143409164_RK, -0.185519926127_RK, -0.184896515074_RK, -0.184273175746_RK, &
    -0.183649907884_RK, -0.18302671123_RK, -0.182403585526_RK, -0.181780530513_RK, &
    -0.181157545935_RK, -0.180534631532_RK, -0.179911787049_RK, -0.179289012227_RK, &
    -0.17866630681_RK, -0.178043670541_RK, -0.177421103162_RK, -0.176798604419_RK, &
    -0.176176174053_RK, -0.175553811811_RK, -0.174931517434_RK, -0.174309290669_RK, &
    -0.173687131258_RK, -0.173065038948_RK, -0.172443013482_RK, -0.171821054607_RK, &
    -0.171199162066_RK, -0.170577335606_RK, -0.169955574973_RK, -0.169333879911_RK, &
    -0.168712250167_RK, -0.168090685487_RK, -0.167469185618_RK, -0.166847750305_RK, &
    -0.166226379296_RK, -0.165605072338_RK, -0.164983829177_RK, -0.164362649561_RK, &
    -0.163741533237_RK, -0.163120479952_RK, -0.162499489456_RK, -0.161878561494_RK, &
    -0.161257695816_RK, -0.16063689217_RK, -0.160016150304_RK, -0.159395469966_RK, &
    -0.158774850907_RK, -0.158154292873_RK, -0.157533795616_RK, -0.156913358883_RK, &
    -0.156292982424_RK, -0.15567266599_RK, -0.155052409329_RK, -0.154432212191_RK, &
    -0.153812074328_RK, -0.153191995488_RK, -0.152571975423_RK, -0.151952013883_RK, &
    -0.151332110619_RK, -0.150712265381_RK, -0.150092477921_RK, -0.14947274799_RK, &
    -0.148853075339_RK, -0.148233459721_RK, -0.147613900885_RK, -0.146994398586_RK, &
    -0.146374952573_RK, -0.1457555626_RK, -0.14513622842_RK, -0.144516949783_RK, &
    -0.143897726444_RK, -0.143278558154_RK, -0.142659444667_RK, -0.142040385735_RK, &
    -0.141421381113_RK, -0.140802430553_RK, -0.140183533808_RK, -0.139564690633_RK, &
    -0.138945900782_RK, -0.138327164007_RK, -0.137708480064_RK, -0.137089848707_RK, &
    -0.136471269689_RK, -0.135852742766_RK, -0.135234267692_RK, -0.134615844222_RK, &
    -0.13399747211_RK, -0.133379151113_RK, -0.132760880985_RK, -0.132142661481_RK, &
    -0.131524492358_RK, -0.13090637337_RK, -0.130288304273_RK, -0.129670284824_RK, &
    -0.129052314778_RK, -0.128434393892_RK, -0.127816521921_RK, -0.127198698623_RK, &
    -0.126580923754_RK, -0.12596319707_RK, -0.125345518329_RK, -0.124727887287_RK, &
    -0.124110303701_RK, -0.12349276733_RK, -0.122875277929_RK, -0.122257835256_RK, &
    -0.12164043907_RK, -0.121023089128_RK, -0.120405785187_RK, -0.119788527006_RK, &
    -0.119171314342_RK, -0.118554146955_RK, -0.117937024601_RK, -0.117319947041_RK, &
    -0.116702914032_RK, -0.116085925333_RK, -0.115468980703_RK, -0.1148520799_RK, &
    -0.114235222685_RK, -0.113618408815_RK, -0.113001638051_RK, -0.112384910152_RK, &
    -0.111768224876_RK, -0.111151581985_RK, -0.110534981238_RK, -0.109918422394_RK, &
    -0.109301905213_RK, -0.108685429456_RK, -0.108068994883_RK, -0.107452601254_RK, &
    -0.10683624833_RK, -0.10621993587_RK, -0.105603663637_RK, -0.104987431389_RK, &
    -0.10437123889_RK, -0.103755085898_RK, -0.103138972176_RK, -0.102522897484_RK, &
    -0.101906861584_RK, -0.101290864237_RK, -0.100674905205_RK, -0.100058984249_RK, &
    -0.0994431011311_RK, -0.0988272556129_RK, -0.0982114474563_RK, -0.0975956764232_RK, &
    -0.0969799422759_RK, -0.0963642447764_RK, -0.0957485836871_RK, -0.0951329587704_RK, &
    -0.0945173697886_RK, -0.0939018165045_RK, -0.0932862986806_RK, -0.0926708160798_RK, &
    -0.0920553684649_RK, -0.0914399555988_RK, -0.0908245772446_RK, -0.0902092331655_RK, &
    -0.0895939231246_RK, -0.0889786468852_RK, -0.0883634042109_RK, -0.0877481948651_RK, &
    -0.0871330186113_RK, -0.0865178752133_RK, -0.0859027644347_RK, -0.0852876860396_RK, &
    -0.0846726397917_RK, -0.0840576254552_RK, -0.0834426427941_RK, -0.0828276915726_RK, &
    -0.0822127715549_RK, -0.0815978825056_RK, -0.0809830241889_RK, -0.0803681963694_RK, &
    -0.0797533988117_RK, -0.0791386312806_RK, -0.0785238935406_RK, -0.0779091853568_RK, &
    -0.077294506494_RK, -0.0766798567172_RK, -0.0760652357914_RK, -0.0754506434819_RK, &
    -0.0748360795539_RK, -0.0742215437727_RK, -0.0736070359035_RK, -0.072992555712_RK, &
    -0.0723781029636_RK, -0.0717636774239_RK, -0.0711492788586_RK, -0.0705349070334_RK, &
    -0.0699205617141_RK, -0.0693062426667_RK, -0.068691949657_RK, -0.0680776824512_RK, &
    -0.0674634408152_RK, -0.0668492245152_RK, -0.0662350333175_RK, -0.0656208669883_RK, &
    -0.065006725294_RK, -0.0643926080011_RK, -0.0637785148759_RK, -0.0631644456851_RK, &
    -0.0625504001953_RK, -0.0619363781731_RK, -0.0613223793853_RK, -0.0607084035987_RK, &
    -0.0600944505801_RK, -0.0594805200964_RK, -0.0588666119147_RK, -0.058252725802_RK, &
    -0.0576388615253_RK, -0.0570250188518_RK, -0.0564111975488_RK, -0.0557973973834_RK, &
    -0.0551836181231_RK, -0.0545698595352_RK, -0.0539561213871_RK, -0.0533424034463_RK, &
    -0.0527287054803_RK, -0.0521150272568_RK, -0.0515013685434_RK, -0.0508877291078_RK, &
    -0.0502741087177_RK, -0.0496605071409_RK, -0.0490469241453_RK, -0.0484333594987_RK, &
    -0.0478198129692_RK, -0.0472062843246_RK, -0.0465927733331_RK, -0.0459792797628_RK, &
    -0.0453658033816_RK, -0.0447523439579_RK, -0.0441389012599_RK, -0.0435254750557_RK, &
    -0.0429120651138_RK, -0.0422986712024_RK, -0.04168529309_RK, -0.041071930545_RK, &
    -0.0404585833359_RK, -0.0398452512311_RK, -0.0392319339993_RK, -0.0386186314091_RK, &
    -0.0380053432289_RK, -0.0373920692277_RK, -0.0367788091739_RK, -0.0361655628365_RK, &
    -0.0355523299841_RK, -0.0349391103856_RK, -0.0343259038099_RK, -0.0337127100257_RK, &
    -0.0330995288021_RK, -0.032486359908_RK, -0.0318732031123_RK, -0.0312600581842_RK, &
    -0.0306469248925_RK, -0.0300338030065_RK, -0.0294206922952_RK, -0.0288075925277_RK, &
    -0.0281945034733_RK, -0.0275814249011_RK, -0.0269683565803_RK, -0.0263552982801_RK, &
    -0.0257422497699_RK, -0.025129210819_RK, -0.0245161811967_RK, -0.0239031606722_RK, &
    -0.0232901490151_RK, -0.0226771459946_RK, -0.0220641513803_RK, -0.0214511649415_RK, &
    -0.0208381864477_RK, -0.0202252156684_RK, -0.019612252373_RK, -0.0189992963312_RK, &
    -0.0183863473125_RK, -0.0177734050864_RK, -0.0171604694224_RK, -0.0165475400903_RK, &
    -0.0159346168595_RK, -0.0153216994998_RK, -0.0147087877807_RK, -0.0140958814719_RK, &
    -0.0134829803432_RK, -0.0128700841641_RK, -0.0122571927044_RK, -0.0116443057337_RK, &
    -0.0110314230219_RK, -0.0104185443386_RK, -0.00980566945358_RK, -0.00919279813659_RK, &
    -0.00857993015739_RK, -0.00796706528575_RK, -0.00735420329145_RK, -0.00674134394428_RK, &
    -0.00612848701402_RK, -0.00551563227049_RK, -0.00490277948347_RK, -0.00428992842278_RK, &
    -0.00367707885824_RK, -0.00306423055966_RK, -0.00245138329686_RK, -0.00183853683967_RK, &
    -0.00122569095791_RK, -0.000612845421414_RK, 0.0_RK, 0.000612845421414_RK, &
    0.00122569095791_RK, 0.00183853683967_RK, 0.00245138329686_RK, 0.00306423055966_RK, &
    0.00367707885824_RK, 0.00428992842278_RK, 0.00490277948347_RK, 0.00551563227049_RK, &
    0.00612848701402_RK, 0.00674134394428_RK, 0.00735420329145_RK, 0.00796706528575_RK, &
    0.00857993015739_RK, 0.00919279813659_RK, 0.00980566945358_RK, 0.0104185443386_RK, &
    0.0110314230219_RK, 0.0116443057337_RK, 0.0122571927044_RK, 0.0128700841641_RK, &
    0.0134829803432_RK, 0.0140958814719_RK, 0.0147087877807_RK, 0.0153216994998_RK, &
    0.0159346168595_RK, 0.0165475400903_RK, 0.0171604694224_RK, 0.0177734050864_RK, &
    0.0183863473125_RK, 0.0189992963312_RK, 0.019612252373_RK, 0.0202252156684_RK, &
    0.0208381864477_RK, 0.0214511649415_RK, 0.0220641513803_RK, 0.0226771459946_RK, &
    0.0232901490151_RK, 0.0239031606722_RK, 0.0245161811967_RK, 0.025129210819_RK, &
    0.0257422497699_RK, 0.0263552982801_RK, 0.0269683565803_RK, 0.0275814249011_RK ]

    real(RK), parameter :: VEC_X_3(2001:3000) = [ &
    0.0281945034733_RK, 0.0288075925277_RK, 0.0294206922952_RK, 0.0300338030065_RK, &
    0.0306469248925_RK, 0.0312600581842_RK, 0.0318732031123_RK, 0.032486359908_RK, &
    0.0330995288021_RK, 0.0337127100257_RK, 0.0343259038099_RK, 0.0349391103856_RK, &
    0.0355523299841_RK, 0.0361655628365_RK, 0.0367788091739_RK, 0.0373920692277_RK, &
    0.0380053432289_RK, 0.0386186314091_RK, 0.0392319339993_RK, 0.0398452512311_RK, &
    0.0404585833359_RK, 0.041071930545_RK, 0.04168529309_RK, 0.0422986712024_RK, &
    0.0429120651138_RK, 0.0435254750557_RK, 0.0441389012599_RK, 0.0447523439579_RK, &
    0.0453658033816_RK, 0.0459792797628_RK, 0.0465927733331_RK, 0.0472062843246_RK, &
    0.0478198129692_RK, 0.0484333594987_RK, 0.0490469241453_RK, 0.0496605071409_RK, &
    0.0502741087177_RK, 0.0508877291078_RK, 0.0515013685434_RK, 0.0521150272568_RK, &
    0.0527287054803_RK, 0.0533424034463_RK, 0.0539561213871_RK, 0.0545698595352_RK, &
    0.0551836181231_RK, 0.0557973973834_RK, 0.0564111975488_RK, 0.0570250188518_RK, &
    0.0576388615253_RK, 0.058252725802_RK, 0.0588666119147_RK, 0.0594805200964_RK, &
    0.0600944505801_RK, 0.0607084035987_RK, 0.0613223793853_RK, 0.0619363781731_RK, &
    0.0625504001953_RK, 0.0631644456851_RK, 0.0637785148759_RK, 0.0643926080011_RK, &
    0.065006725294_RK, 0.0656208669883_RK, 0.0662350333175_RK, 0.0668492245152_RK, &
    0.0674634408152_RK, 0.0680776824512_RK, 0.068691949657_RK, 0.0693062426667_RK, &
    0.0699205617141_RK, 0.0705349070334_RK, 0.0711492788586_RK, 0.0717636774239_RK, &
    0.0723781029636_RK, 0.072992555712_RK, 0.0736070359035_RK, 0.0742215437727_RK, &
    0.0748360795539_RK, 0.0754506434819_RK, 0.0760652357914_RK, 0.0766798567172_RK, &
    0.077294506494_RK, 0.0779091853568_RK, 0.0785238935406_RK, 0.0791386312806_RK, &
    0.0797533988117_RK, 0.0803681963694_RK, 0.0809830241889_RK, 0.0815978825056_RK, &
    0.0822127715549_RK, 0.0828276915726_RK, 0.0834426427941_RK, 0.0840576254552_RK, &
    0.0846726397917_RK, 0.0852876860396_RK, 0.0859027644347_RK, 0.0865178752133_RK, &
    0.0871330186113_RK, 0.0877481948651_RK, 0.0883634042109_RK, 0.0889786468852_RK, &
    0.0895939231246_RK, 0.0902092331655_RK, 0.0908245772446_RK, 0.0914399555988_RK, &
    0.0920553684649_RK, 0.0926708160798_RK, 0.0932862986806_RK, 0.0939018165045_RK, &
    0.0945173697886_RK, 0.0951329587704_RK, 0.0957485836871_RK, 0.0963642447764_RK, &
    0.0969799422759_RK, 0.0975956764232_RK, 0.0982114474563_RK, 0.0988272556129_RK, &
    0.0994431011311_RK, 0.100058984249_RK, 0.100674905205_RK, 0.101290864237_RK, &
    0.101906861584_RK, 0.102522897484_RK, 0.103138972176_RK, 0.103755085898_RK, &
    0.10437123889_RK, 0.104987431389_RK, 0.105603663637_RK, 0.10621993587_RK, &
    0.10683624833_RK, 0.107452601254_RK, 0.108068994883_RK, 0.108685429456_RK, &
    0.109301905213_RK, 0.109918422394_RK, 0.110534981238_RK, 0.111151581985_RK, &
    0.111768224876_RK, 0.112384910152_RK, 0.113001638051_RK, 0.113618408815_RK, &
    0.114235222685_RK, 0.1148520799_RK, 0.115468980703_RK, 0.116085925333_RK, &
    0.116702914032_RK, 0.117319947041_RK, 0.117937024601_RK, 0.118554146955_RK, &
    0.119171314342_RK, 0.119788527006_RK, 0.120405785187_RK, 0.121023089128_RK, &
    0.12164043907_RK, 0.122257835256_RK, 0.122875277929_RK, 0.12349276733_RK, &
    0.124110303701_RK, 0.124727887287_RK, 0.125345518329_RK, 0.12596319707_RK, &
    0.126580923754_RK, 0.127198698623_RK, 0.127816521921_RK, 0.128434393892_RK, &
    0.129052314778_RK, 0.129670284824_RK, 0.130288304273_RK, 0.13090637337_RK, &
    0.131524492358_RK, 0.132142661481_RK, 0.132760880985_RK, 0.133379151113_RK, &
    0.13399747211_RK, 0.134615844222_RK, 0.135234267692_RK, 0.135852742766_RK, &
    0.136471269689_RK, 0.137089848707_RK, 0.137708480064_RK, 0.138327164007_RK, &
    0.138945900782_RK, 0.139564690633_RK, 0.140183533808_RK, 0.140802430553_RK, &
    0.141421381113_RK, 0.142040385735_RK, 0.142659444667_RK, 0.143278558154_RK, &
    0.143897726444_RK, 0.144516949783_RK, 0.14513622842_RK, 0.1457555626_RK, &
    0.146374952573_RK, 0.146994398586_RK, 0.147613900885_RK, 0.148233459721_RK, &
    0.148853075339_RK, 0.14947274799_RK, 0.150092477921_RK, 0.150712265381_RK, &
    0.151332110619_RK, 0.151952013883_RK, 0.152571975423_RK, 0.153191995488_RK, &
    0.153812074328_RK, 0.154432212191_RK, 0.155052409329_RK, 0.15567266599_RK, &
    0.156292982424_RK, 0.156913358883_RK, 0.157533795616_RK, 0.158154292873_RK, &
    0.158774850907_RK, 0.159395469966_RK, 0.160016150304_RK, 0.16063689217_RK, &
    0.161257695816_RK, 0.161878561494_RK, 0.162499489456_RK, 0.163120479952_RK, &
    0.163741533237_RK, 0.164362649561_RK, 0.164983829177_RK, 0.165605072338_RK, &
    0.166226379296_RK, 0.166847750305_RK, 0.167469185618_RK, 0.168090685487_RK, &
    0.168712250167_RK, 0.169333879911_RK, 0.169955574973_RK, 0.170577335606_RK, &
    0.171199162066_RK, 0.171821054607_RK, 0.172443013482_RK, 0.173065038948_RK, &
    0.173687131258_RK, 0.174309290669_RK, 0.174931517434_RK, 0.175553811811_RK, &
    0.176176174053_RK, 0.176798604419_RK, 0.177421103162_RK, 0.178043670541_RK, &
    0.17866630681_RK, 0.179289012227_RK, 0.179911787049_RK, 0.180534631532_RK, &
    0.181157545935_RK, 0.181780530513_RK, 0.182403585526_RK, 0.18302671123_RK, &
    0.183649907884_RK, 0.184273175746_RK, 0.184896515074_RK, 0.185519926127_RK, &
    0.186143409164_RK, 0.186766964443_RK, 0.187390592225_RK, 0.188014292767_RK, &
    0.188638066331_RK, 0.189261913176_RK, 0.189885833561_RK, 0.190509827747_RK, &
    0.191133895995_RK, 0.191758038565_RK, 0.192382255718_RK, 0.193006547715_RK, &
    0.193630914818_RK, 0.194255357287_RK, 0.194879875385_RK, 0.195504469373_RK, &
    0.196129139514_RK, 0.196753886069_RK, 0.197378709302_RK, 0.198003609476_RK, &
    0.198628586852_RK, 0.199253641695_RK, 0.199878774268_RK, 0.200503984834_RK, &
    0.201129273658_RK, 0.201754641003_RK, 0.202380087133_RK, 0.203005612315_RK, &
    0.203631216811_RK, 0.204256900887_RK, 0.204882664808_RK, 0.20550850884_RK, &
    0.206134433249_RK, 0.206760438299_RK, 0.207386524258_RK, 0.208012691392_RK, &
    0.208638939966_RK, 0.209265270249_RK, 0.209891682507_RK, 0.210518177008_RK, &
    0.211144754018_RK, 0.211771413806_RK, 0.212398156639_RK, 0.213024982787_RK, &
    0.213651892517_RK, 0.214278886097_RK, 0.214905963798_RK, 0.215533125887_RK, &
    0.216160372636_RK, 0.216787704312_RK, 0.217415121186_RK, 0.218042623529_RK, &
    0.21867021161_RK, 0.219297885701_RK, 0.219925646071_RK, 0.220553492993_RK, &
    0.221181426737_RK, 0.221809447576_RK, 0.222437555781_RK, 0.223065751624_RK, &
    0.223694035378_RK, 0.224322407315_RK, 0.224950867708_RK, 0.22557941683_RK, &
    0.226208054955_RK, 0.226836782357_RK, 0.227465599309_RK, 0.228094506085_RK, &
    0.22872350296_RK, 0.229352590209_RK, 0.229981768106_RK, 0.230611036927_RK, &
    0.231240396947_RK, 0.231869848442_RK, 0.232499391688_RK, 0.233129026961_RK, &
    0.233758754538_RK, 0.234388574696_RK, 0.235018487711_RK, 0.235648493861_RK, &
    0.236278593424_RK, 0.236908786677_RK, 0.237539073899_RK, 0.238169455368_RK, &
    0.238799931363_RK, 0.239430502163_RK, 0.240061168047_RK, 0.240691929294_RK, &
    0.241322786185_RK, 0.241953738999_RK, 0.242584788017_RK, 0.24321593352_RK, &
    0.243847175788_RK, 0.244478515102_RK, 0.245109951745_RK, 0.245741485998_RK, &
    0.246373118143_RK, 0.247004848463_RK, 0.24763667724_RK, 0.248268604756_RK, &
    0.248900631296_RK, 0.249532757143_RK, 0.25016498258_RK, 0.250797307892_RK, &
    0.251429733364_RK, 0.252062259279_RK, 0.252694885923_RK, 0.253327613581_RK, &
    0.253960442538_RK, 0.254593373082_RK, 0.255226405497_RK, 0.25585954007_RK, &
    0.256492777089_RK, 0.25712611684_RK, 0.25775955961_RK, 0.258393105687_RK, &
    0.25902675536_RK, 0.259660508917_RK, 0.260294366646_RK, 0.260928328836_RK, &
    0.261562395776_RK, 0.262196567757_RK, 0.262830845067_RK, 0.263465227997_RK, &
    0.264099716838_RK, 0.264734311881_RK, 0.265369013416_RK, 0.266003821735_RK, &
    0.26663873713_RK, 0.267273759892_RK, 0.267908890315_RK, 0.268544128691_RK, &
    0.269179475313_RK, 0.269814930474_RK, 0.270450494469_RK, 0.271086167591_RK, &
    0.271721950134_RK, 0.272357842394_RK, 0.272993844665_RK, 0.273629957242_RK, &
    0.274266180422_RK, 0.2749025145_RK, 0.275538959773_RK, 0.276175516537_RK, &
    0.27681218509_RK, 0.277448965729_RK, 0.278085858751_RK, 0.278722864454_RK, &
    0.279359983137_RK, 0.279997215099_RK, 0.280634560639_RK, 0.281272020056_RK, &
    0.28190959365_RK, 0.28254728172_RK, 0.283185084568_RK, 0.283823002495_RK, &
    0.2844610358_RK, 0.285099184787_RK, 0.285737449756_RK, 0.28637583101_RK, &
    0.287014328852_RK, 0.287652943584_RK, 0.288291675509_RK, 0.288930524932_RK, &
    0.289569492157_RK, 0.290208577487_RK, 0.290847781227_RK, 0.291487103683_RK, &
    0.292126545159_RK, 0.292766105963_RK, 0.293405786399_RK, 0.294045586775_RK, &
    0.294685507396_RK, 0.295325548572_RK, 0.295965710609_RK, 0.296605993814_RK, &
    0.297246398498_RK, 0.297886924968_RK, 0.298527573533_RK, 0.299168344504_RK, &
    0.29980923819_RK, 0.3004502549_RK, 0.301091394947_RK, 0.301732658641_RK, &
    0.302374046293_RK, 0.303015558215_RK, 0.303657194719_RK, 0.304298956119_RK, &
    0.304940842726_RK, 0.305582854855_RK, 0.306224992819_RK, 0.306867256932_RK, &
    0.307509647508_RK, 0.308152164863_RK, 0.308794809313_RK, 0.309437581171_RK, &
    0.310080480756_RK, 0.310723508383_RK, 0.311366664369_RK, 0.312009949032_RK, &
    0.312653362689_RK, 0.313296905659_RK, 0.313940578259_RK, 0.314584380809_RK, &
    0.315228313629_RK, 0.315872377037_RK, 0.316516571355_RK, 0.317160896902_RK, &
    0.317805354_RK, 0.318449942971_RK, 0.319094664135_RK, 0.319739517815_RK, &
    0.320384504335_RK, 0.321029624016_RK, 0.321674877183_RK, 0.322320264159_RK, &
    0.322965785269_RK, 0.323611440838_RK, 0.32425723119_RK, 0.324903156652_RK, &
    0.325549217549_RK, 0.326195414208_RK, 0.326841746956_RK, 0.32748821612_RK, &
    0.328134822029_RK, 0.328781565009_RK, 0.329428445391_RK, 0.330075463502_RK, &
    0.330722619673_RK, 0.331369914234_RK, 0.332017347514_RK, 0.332664919846_RK, &
    0.33331263156_RK, 0.333960482988_RK, 0.334608474462_RK, 0.335256606314_RK, &
    0.335904878879_RK, 0.33655329249_RK, 0.33720184748_RK, 0.337850544184_RK, &
    0.338499382938_RK, 0.339148364076_RK, 0.339797487934_RK, 0.340446754849_RK, &
    0.341096165157_RK, 0.341745719196_RK, 0.342395417304_RK, 0.343045259818_RK, &
    0.343695247078_RK, 0.344345379421_RK, 0.344995657189_RK, 0.345646080722_RK, &
    0.346296650358_RK, 0.346947366441_RK, 0.34759822931_RK, 0.348249239309_RK, &
    0.34890039678_RK, 0.349551702065_RK, 0.350203155508_RK, 0.350854757453_RK, &
    0.351506508245_RK, 0.352158408227_RK, 0.352810457747_RK, 0.353462657149_RK, &
    0.354115006779_RK, 0.354767506986_RK, 0.355420158116_RK, 0.356072960516_RK, &
    0.356725914537_RK, 0.357379020525_RK, 0.358032278831_RK, 0.358685689804_RK, &
    0.359339253795_RK, 0.359992971155_RK, 0.360646842235_RK, 0.361300867386_RK, &
    0.361955046963_RK, 0.362609381316_RK, 0.363263870801_RK, 0.36391851577_RK, &
    0.364573316578_RK, 0.36522827358_RK, 0.365883387132_RK, 0.36653865759_RK, &
    0.367194085311_RK, 0.36784967065_RK, 0.368505413967_RK, 0.369161315619_RK, &
    0.369817375965_RK, 0.370473595364_RK, 0.371129974175_RK, 0.37178651276_RK, &
    0.372443211479_RK, 0.373100070693_RK, 0.373757090765_RK, 0.374414272056_RK, &
    0.37507161493_RK, 0.37572911975_RK, 0.37638678688_RK, 0.377044616686_RK, &
    0.377702609531_RK, 0.378360765783_RK, 0.379019085806_RK, 0.379677569969_RK, &
    0.380336218639_RK, 0.380995032182_RK, 0.381654010969_RK, 0.382313155368_RK, &
    0.382972465749_RK, 0.383631942482_RK, 0.384291585938_RK, 0.384951396488_RK, &
    0.385611374504_RK, 0.386271520359_RK, 0.386931834425_RK, 0.387592317078_RK, &
    0.38825296869_RK, 0.388913789636_RK, 0.389574780293_RK, 0.390235941036_RK, &
    0.390897272241_RK, 0.391558774287_RK, 0.392220447549_RK, 0.392882292409_RK, &
    0.393544309243_RK, 0.394206498431_RK, 0.394868860354_RK, 0.395531395393_RK, &
    0.396194103929_RK, 0.396856986343_RK, 0.397520043019_RK, 0.39818327434_RK, &
    0.398846680689_RK, 0.399510262451_RK, 0.40017402001_RK, 0.400837953753_RK, &
    0.401502064066_RK, 0.402166351335_RK, 0.402830815949_RK, 0.403495458294_RK, &
    0.404160278761_RK, 0.404825277738_RK, 0.405490455615_RK, 0.406155812784_RK, &
    0.406821349634_RK, 0.407487066559_RK, 0.40815296395_RK, 0.408819042201_RK, &
    0.409485301706_RK, 0.410151742859_RK, 0.410818366055_RK, 0.41148517169_RK, &
    0.41215216016_RK, 0.412819331863_RK, 0.413486687196_RK, 0.414154226557_RK, &
    0.414821950346_RK, 0.415489858963_RK, 0.416157952806_RK, 0.416826232279_RK, &
    0.417494697781_RK, 0.418163349716_RK, 0.418832188486_RK, 0.419501214496_RK, &
    0.420170428149_RK, 0.420839829851_RK, 0.421509420007_RK, 0.422179199024_RK, &
    0.422849167309_RK, 0.423519325269_RK, 0.424189673313_RK, 0.42486021185_RK, &
    0.42553094129_RK, 0.426201862043_RK, 0.426872974521_RK, 0.427544279136_RK, &
    0.4282157763_RK, 0.428887466426_RK, 0.429559349928_RK, 0.430231427222_RK, &
    0.430903698722_RK, 0.431576164846_RK, 0.432248826008_RK, 0.432921682628_RK, &
    0.433594735123_RK, 0.434267983913_RK, 0.434941429417_RK, 0.435615072055_RK, &
    0.436288912249_RK, 0.436962950421_RK, 0.437637186994_RK, 0.43831162239_RK, &
    0.438986257034_RK, 0.43966109135_RK, 0.440336125765_RK, 0.441011360704_RK, &
    0.441686796595_RK, 0.442362433866_RK, 0.443038272944_RK, 0.44371431426_RK, &
    0.444390558244_RK, 0.445067005325_RK, 0.445743655937_RK, 0.446420510511_RK, &
    0.44709756948_RK, 0.447774833279_RK, 0.448452302341_RK, 0.449129977103_RK, &
    0.449807858_RK, 0.45048594547_RK, 0.45116423995_RK, 0.45184274188_RK, &
    0.452521451697_RK, 0.453200369842_RK, 0.453879496757_RK, 0.454558832883_RK, &
    0.455238378662_RK, 0.455918134538_RK, 0.456598100954_RK, 0.457278278357_RK, &
    0.45795866719_RK, 0.458639267901_RK, 0.459320080938_RK, 0.460001106748_RK, &
    0.460682345779_RK, 0.461363798483_RK, 0.46204546531_RK, 0.46272734671_RK, &
    0.463409443136_RK, 0.464091755042_RK, 0.46477428288_RK, 0.465457027107_RK, &
    0.466139988176_RK, 0.466823166546_RK, 0.467506562672_RK, 0.468190177013_RK, &
    0.468874010028_RK, 0.469558062177_RK, 0.470242333919_RK, 0.470926825718_RK, &
    0.471611538035_RK, 0.472296471333_RK, 0.472981626076_RK, 0.473667002729_RK, &
    0.474352601759_RK, 0.47503842363_RK, 0.475724468813_RK, 0.476410737773_RK, &
    0.477097230982_RK, 0.477783948909_RK, 0.478470892024_RK, 0.479158060801_RK, &
    0.479845455711_RK, 0.480533077229_RK, 0.48122092583_RK, 0.481909001988_RK, &
    0.48259730618_RK, 0.483285838883_RK, 0.483974600576_RK, 0.484663591739_RK, &
    0.48535281285_RK, 0.48604226439_RK, 0.486731946843_RK, 0.487421860691_RK, &
    0.488112006416_RK, 0.488802384505_RK, 0.489492995442_RK, 0.490183839715_RK, &
    0.49087491781_RK, 0.491566230217_RK, 0.492257777423_RK, 0.492949559921_RK, &
    0.493641578201_RK, 0.494333832755_RK, 0.495026324076_RK, 0.49571905266_RK, &
    0.496412018999_RK, 0.497105223592_RK, 0.497798666935_RK, 0.498492349525_RK, &
    0.499186271862_RK, 0.499880434446_RK, 0.500574837777_RK, 0.501269482359_RK, &
    0.501964368692_RK, 0.502659497283_RK, 0.503354868635_RK, 0.504050483254_RK, &
    0.504746341647_RK, 0.505442444322_RK, 0.506138791788_RK, 0.506835384556_RK, &
    0.507532223135_RK, 0.508229308038_RK, 0.508926639778_RK, 0.509624218869_RK, &
    0.510322045826_RK, 0.511020121164_RK, 0.511718445402_RK, 0.512417019057_RK, &
    0.513115842648_RK, 0.513814916696_RK, 0.514514241722_RK, 0.515213818248_RK, &
    0.515913646798_RK, 0.516613727896_RK, 0.517314062067_RK, 0.518014649839_RK, &
    0.518715491738_RK, 0.519416588293_RK, 0.520117940035_RK, 0.520819547494_RK, &
    0.521521411203_RK, 0.522223531693_RK, 0.5229259095_RK, 0.523628545158_RK, &
    0.524331439204_RK, 0.525034592175_RK, 0.52573800461_RK, 0.526441677048_RK, &
    0.527145610031_RK, 0.5278498041_RK, 0.528554259797_RK, 0.529258977668_RK, &
    0.529963958257_RK, 0.530669202111_RK, 0.531374709778_RK, 0.532080481805_RK, &
    0.532786518743_RK, 0.533492821143_RK, 0.534199389557_RK, 0.534906224537_RK, &
    0.535613326639_RK, 0.536320696418_RK, 0.537028334431_RK, 0.537736241235_RK, &
    0.53844441739_RK, 0.539152863456_RK, 0.539861579995_RK, 0.540570567568_RK, &
    0.541279826741_RK, 0.541989358077_RK, 0.542699162143_RK, 0.543409239507_RK, &
    0.544119590737_RK, 0.544830216402_RK, 0.545541117075_RK, 0.546252293327_RK, &
    0.546963745731_RK, 0.547675474863_RK, 0.548387481299_RK, 0.549099765614_RK, &
    0.549812328389_RK, 0.550525170202_RK, 0.551238291635_RK, 0.551951693269_RK, &
    0.552665375689_RK, 0.553379339478_RK, 0.554093585223_RK, 0.55480811351_RK, &
    0.555522924929_RK, 0.556238020069_RK, 0.556953399521_RK, 0.557669063878_RK, &
    0.558385013733_RK, 0.559101249681_RK, 0.559817772317_RK, 0.560534582241_RK, &
    0.56125168005_RK, 0.561969066345_RK, 0.562686741727_RK, 0.563404706799_RK, &
    0.564122962165_RK, 0.56484150843_RK, 0.565560346202_RK, 0.566279476088_RK, &
    0.566998898697_RK, 0.567718614641_RK, 0.568438624533_RK, 0.569158928984_RK, &
    0.56987952861_RK, 0.570600424028_RK, 0.571321615855_RK, 0.57204310471_RK, &
    0.572764891214_RK, 0.573486975988_RK, 0.574209359655_RK, 0.57493204284_RK, &
    0.575655026169_RK, 0.576378310269_RK, 0.577101895769_RK, 0.5778257833_RK, &
    0.578549973492_RK, 0.57927446698_RK, 0.579999264397_RK, 0.580724366379_RK, &
    0.581449773564_RK, 0.58217548659_RK, 0.582901506099_RK, 0.58362783273_RK, &
    0.584354467129_RK, 0.585081409939_RK, 0.585808661806_RK, 0.586536223378_RK, &
    0.587264095305_RK, 0.587992278236_RK, 0.588720772824_RK, 0.589449579722_RK, &
    0.590178699585_RK, 0.590908133071_RK, 0.591637880836_RK, 0.592367943541_RK, &
    0.593098321847_RK, 0.593829016416_RK, 0.594560027913_RK, 0.595291357003_RK, &
    0.596023004354_RK, 0.596754970634_RK, 0.597487256514_RK, 0.598219862666_RK, &
    0.598952789763_RK, 0.599686038481_RK, 0.600419609496_RK, 0.601153503486_RK, &
    0.601887721131_RK, 0.602622263113_RK, 0.603357130115_RK, 0.604092322821_RK, &
    0.604827841918_RK, 0.605563688093_RK, 0.606299862036_RK, 0.607036364439_RK, &
    0.607773195994_RK, 0.608510357395_RK, 0.609247849338_RK, 0.609985672522_RK, &
    0.610723827646_RK, 0.61146231541_RK, 0.612201136518_RK, 0.612940291674_RK, &
    0.613679781584_RK, 0.614419606955_RK, 0.615159768498_RK, 0.615900266923_RK, &
    0.616641102944_RK, 0.617382277275_RK, 0.618123790632_RK, 0.618865643733_RK, &
    0.619607837299_RK, 0.62035037205_RK, 0.621093248711_RK, 0.621836468005_RK, &
    0.622580030661_RK, 0.623323937406_RK, 0.62406818897_RK, 0.624812786087_RK, &
    0.625557729489_RK, 0.626303019913_RK, 0.627048658096_RK, 0.627794644778_RK, &
    0.628540980698_RK, 0.629287666601_RK, 0.630034703232_RK, 0.630782091336_RK, &
    0.631529831662_RK, 0.632277924961_RK, 0.633026371984_RK, 0.633775173485_RK, &
    0.634524330221_RK, 0.63527384295_RK, 0.636023712429_RK, 0.636773939423_RK, &
    0.637524524692_RK, 0.638275469004_RK, 0.639026773124_RK, 0.639778437823_RK, &
    0.640530463871_RK, 0.641282852041_RK, 0.642035603108_RK, 0.642788717849_RK, &
    0.643542197043_RK, 0.64429604147_RK, 0.645050251913_RK, 0.645804829157_RK, &
    0.646559773988_RK, 0.647315087195_RK, 0.648070769569_RK, 0.648826821903_RK, &
    0.64958324499_RK, 0.650340039629_RK, 0.651097206616_RK, 0.651854746754_RK, &
    0.652612660844_RK, 0.653370949693_RK, 0.654129614105_RK, 0.654888654892_RK, &
    0.655648072862_RK, 0.656407868831_RK, 0.657168043612_RK, 0.657928598023_RK, &
    0.658689532883_RK, 0.659450849015_RK, 0.66021254724_RK, 0.660974628386_RK, &
    0.66173709328_RK, 0.662499942752_RK, 0.663263177633_RK, 0.66402679876_RK, &
    0.664790806967_RK, 0.665555203094_RK, 0.666319987981_RK, 0.667085162471_RK, &
    0.66785072741_RK, 0.668616683646_RK, 0.669383032026_RK, 0.670149773405_RK, &
    0.670916908635_RK, 0.671684438573_RK, 0.672452364078_RK, 0.67322068601_RK, &
    0.673989405232_RK, 0.674758522611_RK, 0.675528039013_RK, 0.67629795531_RK, &
    0.677068272372_RK, 0.677838991074_RK, 0.678610112294_RK, 0.679381636911_RK, &
    0.680153565806_RK, 0.680925899864_RK, 0.68169863997_RK, 0.682471787013_RK, &
    0.683245341885_RK, 0.684019305478_RK, 0.684793678689_RK, 0.685568462415_RK, &
    0.686343657558_RK, 0.687119265021_RK, 0.687895285708_RK, 0.688671720529_RK, &
    0.689448570392_RK, 0.690225836212_RK, 0.691003518904_RK, 0.691781619384_RK ]

    real(RK), parameter :: VEC_X_4(3001:LEN_VEC_X) = [ &
    0.692560138575_RK, 0.693339077397_RK, 0.694118436777_RK, 0.694898217643_RK, &
    0.695678420925_RK, 0.696459047555_RK, 0.69724009847_RK, 0.698021574607_RK, &
    0.698803476906_RK, 0.699585806312_RK, 0.700368563769_RK, 0.701151750226_RK, &
    0.701935366634_RK, 0.702719413947_RK, 0.70350389312_RK, 0.704288805113_RK, &
    0.705074150887_RK, 0.705859931406_RK, 0.706646147638_RK, 0.707432800551_RK, &
    0.708219891118_RK, 0.709007420313_RK, 0.709795389115_RK, 0.710583798504_RK, &
    0.711372649463_RK, 0.712161942978_RK, 0.712951680037_RK, 0.713741861631_RK, &
    0.714532488756_RK, 0.715323562408_RK, 0.716115083586_RK, 0.716907053294_RK, &
    0.717699472536_RK, 0.718492342322_RK, 0.719285663661_RK, 0.720079437569_RK, &
    0.720873665062_RK, 0.721668347159_RK, 0.722463484884_RK, 0.723259079262_RK, &
    0.724055131321_RK, 0.724851642093_RK, 0.725648612612_RK, 0.726446043916_RK, &
    0.727243937044_RK, 0.728042293041_RK, 0.728841112951_RK, 0.729640397826_RK, &
    0.730440148716_RK, 0.731240366677_RK, 0.732041052768_RK, 0.73284220805_RK, &
    0.733643833587_RK, 0.734445930447_RK, 0.735248499702_RK, 0.736051542423_RK, &
    0.736855059689_RK, 0.737659052579_RK, 0.738463522177_RK, 0.739268469569_RK, &
    0.740073895844_RK, 0.740879802096_RK, 0.741686189419_RK, 0.742493058914_RK, &
    0.743300411682_RK, 0.74410824883_RK, 0.744916571465_RK, 0.7457253807_RK, &
    0.746534677651_RK, 0.747344463435_RK, 0.748154739176_RK, 0.748965505998_RK, &
    0.74977676503_RK, 0.750588517404_RK, 0.751400764255_RK, 0.752213506722_RK, &
    0.753026745948_RK, 0.753840483077_RK, 0.754654719259_RK, 0.755469455646_RK, &
    0.756284693394_RK, 0.757100433662_RK, 0.757916677614_RK, 0.758733426414_RK, &
    0.759550681234_RK, 0.760368443246_RK, 0.761186713627_RK, 0.762005493558_RK, &
    0.762824784223_RK, 0.763644586809_RK, 0.764464902507_RK, 0.765285732513_RK, &
    0.766107078024_RK, 0.766928940243_RK, 0.767751320376_RK, 0.768574219631_RK, &
    0.769397639223_RK, 0.770221580367_RK, 0.771046044284_RK, 0.7718710322_RK, &
    0.772696545341_RK, 0.773522584939_RK, 0.774349152231_RK, 0.775176248455_RK, &
    0.776003874855_RK, 0.776832032678_RK, 0.777660723175_RK, 0.7784899476_RK, &
    0.779319707213_RK, 0.780150003277_RK, 0.780980837056_RK, 0.781812209823_RK, &
    0.782644122852_RK, 0.783476577421_RK, 0.784309574812_RK, 0.785143116312_RK, &
    0.785977203212_RK, 0.786811836806_RK, 0.787647018393_RK, 0.788482749274_RK, &
    0.789319030758_RK, 0.790155864155_RK, 0.790993250781_RK, 0.791831191953_RK, &
    0.792669688996_RK, 0.793508743238_RK, 0.79434835601_RK, 0.795188528648_RK, &
    0.796029262492_RK, 0.796870558888_RK, 0.797712419183_RK, 0.798554844732_RK, &
    0.799397836891_RK, 0.800241397023_RK, 0.801085526493_RK, 0.801930226672_RK, &
    0.802775498936_RK, 0.803621344663_RK, 0.804467765238_RK, 0.805314762049_RK, &
    0.806162336489_RK, 0.807010489955_RK, 0.807859223848_RK, 0.808708539576_RK, &
    0.80955843855_RK, 0.810408922185_RK, 0.8112599919_RK, 0.812111649122_RK, &
    0.812963895279_RK, 0.813816731806_RK, 0.814670160142_RK, 0.815524181729_RK, &
    0.816378798017_RK, 0.817234010459_RK, 0.818089820512_RK, 0.818946229639_RK, &
    0.819803239307_RK, 0.82066085099_RK, 0.821519066163_RK, 0.82237788631_RK, &
    0.823237312917_RK, 0.824097347476_RK, 0.824957991484_RK, 0.825819246443_RK, &
    0.826681113861_RK, 0.827543595248_RK, 0.828406692123_RK, 0.829270406006_RK, &
    0.830134738426_RK, 0.830999690914_RK, 0.831865265009_RK, 0.832731462252_RK, &
    0.833598284192_RK, 0.834465732382_RK, 0.83533380838_RK, 0.83620251375_RK, &
    0.83707185006_RK, 0.837941818885_RK, 0.838812421805_RK, 0.839683660404_RK, &
    0.840555536273_RK, 0.841428051007_RK, 0.842301206208_RK, 0.843175003483_RK, &
    0.844049444444_RK, 0.844924530708_RK, 0.845800263899_RK, 0.846676645646_RK, &
    0.847553677583_RK, 0.84843136135_RK, 0.849309698594_RK, 0.850188690965_RK, &
    0.851068340122_RK, 0.851948647726_RK, 0.852829615446_RK, 0.853711244958_RK, &
    0.854593537942_RK, 0.855476496083_RK, 0.856360121074_RK, 0.857244414613_RK, &
    0.858129378404_RK, 0.859015014157_RK, 0.859901323588_RK, 0.860788308418_RK, &
    0.861675970376_RK, 0.862564311196_RK, 0.863453332618_RK, 0.864343036389_RK, &
    0.865233424261_RK, 0.866124497993_RK, 0.86701625935_RK, 0.867908710104_RK, &
    0.868801852031_RK, 0.869695686916_RK, 0.870590216549_RK, 0.871485442727_RK, &
    0.872381367254_RK, 0.873277991937_RK, 0.874175318595_RK, 0.875073349049_RK, &
    0.875972085128_RK, 0.876871528668_RK, 0.877771681512_RK, 0.878672545509_RK, &
    0.879574122514_RK, 0.88047641439_RK, 0.881379423006_RK, 0.882283150238_RK, &
    0.883187597969_RK, 0.884092768089_RK, 0.884998662493_RK, 0.885905283087_RK, &
    0.886812631779_RK, 0.887720710488_RK, 0.888629521138_RK, 0.889539065661_RK, &
    0.890449345995_RK, 0.891360364086_RK, 0.892272121887_RK, 0.893184621359_RK, &
    0.894097864469_RK, 0.895011853191_RK, 0.895926589508_RK, 0.896842075409_RK, &
    0.897758312891_RK, 0.898675303958_RK, 0.899593050622_RK, 0.900511554903_RK, &
    0.901430818827_RK, 0.902350844428_RK, 0.90327163375_RK, 0.90419318884_RK, &
    0.905115511758_RK, 0.906038604567_RK, 0.906962469342_RK, 0.907887108163_RK, &
    0.908812523118_RK, 0.909738716305_RK, 0.910665689828_RK, 0.911593445799_RK, &
    0.912521986339_RK, 0.913451313577_RK, 0.91438142965_RK, 0.915312336703_RK, &
    0.916244036888_RK, 0.917176532369_RK, 0.918109825313_RK, 0.919043917899_RK, &
    0.919978812315_RK, 0.920914510754_RK, 0.921851015421_RK, 0.922788328527_RK, &
    0.923726452292_RK, 0.924665388946_RK, 0.925605140727_RK, 0.926545709881_RK, &
    0.927487098664_RK, 0.928429309338_RK, 0.929372344179_RK, 0.930316205466_RK, &
    0.931260895491_RK, 0.932206416553_RK, 0.933152770962_RK, 0.934099961035_RK, &
    0.9350479891_RK, 0.935996857491_RK, 0.936946568555_RK, 0.937897124647_RK, &
    0.93884852813_RK, 0.939800781378_RK, 0.940753886774_RK, 0.941707846709_RK, &
    0.942662663587_RK, 0.943618339818_RK, 0.944574877824_RK, 0.945532280036_RK, &
    0.946490548893_RK, 0.947449686847_RK, 0.948409696358_RK, 0.949370579895_RK, &
    0.95033233994_RK, 0.951294978982_RK, 0.952258499521_RK, 0.953222904069_RK, &
    0.954188195145_RK, 0.955154375281_RK, 0.956121447017_RK, 0.957089412906_RK, &
    0.958058275508_RK, 0.959028037398_RK, 0.959998701157_RK, 0.960970269379_RK, &
    0.961942744669_RK, 0.962916129641_RK, 0.963890426921_RK, 0.964865639146_RK, &
    0.965841768964_RK, 0.966818819033_RK, 0.967796792022_RK, 0.968775690612_RK, &
    0.969755517495_RK, 0.970736275374_RK, 0.971717966963_RK, 0.972700594988_RK, &
    0.973684162186_RK, 0.974668671305_RK, 0.975654125105_RK, 0.976640526359_RK, &
    0.977627877849_RK, 0.978616182371_RK, 0.979605442731_RK, 0.980595661749_RK, &
    0.981586842254_RK, 0.982578987091_RK, 0.983572099113_RK, 0.984566181188_RK, &
    0.985561236196_RK, 0.986557267027_RK, 0.987554276585_RK, 0.988552267788_RK, &
    0.989551243564_RK, 0.990551206854_RK, 0.991552160613_RK, 0.992554107808_RK, &
    0.993557051418_RK, 0.994560994436_RK, 0.995565939868_RK, 0.996571890733_RK, &
    0.997578850062_RK, 0.9985868209_RK, 0.999595806306_RK, 1.00060580935_RK, &
    1.00161683312_RK, 1.00262888071_RK, 1.00364195524_RK, 1.00465605983_RK, &
    1.00567119762_RK, 1.00668737176_RK, 1.00770458543_RK, 1.0087228418_RK, &
    1.00974214407_RK, 1.01076249545_RK, 1.01178389916_RK, 1.01280635844_RK, &
    1.01382987655_RK, 1.01485445675_RK, 1.01588010232_RK, 1.01690681657_RK, &
    1.01793460279_RK, 1.01896346433_RK, 1.01999340452_RK, 1.02102442671_RK, &
    1.02205653428_RK, 1.02308973062_RK, 1.02412401912_RK, 1.02515940322_RK, &
    1.02619588633_RK, 1.02723347191_RK, 1.02827216342_RK, 1.02931196435_RK, &
    1.03035287819_RK, 1.03139490845_RK, 1.03243805866_RK, 1.03348233237_RK, &
    1.03452773314_RK, 1.03557426455_RK, 1.03662193018_RK, 1.03767073366_RK, &
    1.03872067861_RK, 1.03977176868_RK, 1.04082400752_RK, 1.04187739881_RK, &
    1.04293194626_RK, 1.04398765357_RK, 1.04504452448_RK, 1.04610256273_RK, &
    1.04716177209_RK, 1.04822215635_RK, 1.04928371929_RK, 1.05034646476_RK, &
    1.05141039657_RK, 1.0524755186_RK, 1.0535418347_RK, 1.05460934878_RK, &
    1.05567806475_RK, 1.05674798653_RK, 1.05781911808_RK, 1.05889146336_RK, &
    1.05996502636_RK, 1.06103981109_RK, 1.06211582157_RK, 1.06319306184_RK, &
    1.06427153597_RK, 1.06535124805_RK, 1.06643220217_RK, 1.06751440246_RK, &
    1.06859785307_RK, 1.06968255816_RK, 1.07076852192_RK, 1.07185574854_RK, &
    1.07294424226_RK, 1.07403400732_RK, 1.07512504799_RK, 1.07621736855_RK, &
    1.07731097332_RK, 1.07840586663_RK, 1.07950205283_RK, 1.0805995363_RK, &
    1.08169832142_RK, 1.08279841262_RK, 1.08389981434_RK, 1.08500253104_RK, &
    1.08610656721_RK, 1.08721192734_RK, 1.08831861598_RK, 1.08942663766_RK, &
    1.09053599698_RK, 1.09164669853_RK, 1.09275874692_RK, 1.09387214681_RK, &
    1.09498690286_RK, 1.09610301977_RK, 1.09722050226_RK, 1.09833935506_RK, &
    1.09945958293_RK, 1.10058119068_RK, 1.10170418311_RK, 1.10282856507_RK, &
    1.10395434141_RK, 1.10508151703_RK, 1.10621009684_RK, 1.10734008578_RK, &
    1.10847148882_RK, 1.10960431095_RK, 1.11073855719_RK, 1.11187423257_RK, &
    1.11301134218_RK, 1.11414989111_RK, 1.11528988448_RK, 1.11643132745_RK, &
    1.11757422519_RK, 1.1187185829_RK, 1.11986440583_RK, 1.12101169923_RK, &
    1.12216046839_RK, 1.12331071862_RK, 1.12446245528_RK, 1.12561568374_RK, &
    1.1267704094_RK, 1.12792663769_RK, 1.12908437408_RK, 1.13024362405_RK, &
    1.13140439313_RK, 1.13256668686_RK, 1.13373051083_RK, 1.13489587064_RK, &
    1.13606277195_RK, 1.13723122041_RK, 1.13840122174_RK, 1.13957278166_RK, &
    1.14074590595_RK, 1.14192060039_RK, 1.14309687083_RK, 1.14427472312_RK, &
    1.14545416315_RK, 1.14663519686_RK, 1.1478178302_RK, 1.14900206916_RK, &
    1.15018791978_RK, 1.1513753881_RK, 1.15256448023_RK, 1.1537552023_RK, &
    1.15494756045_RK, 1.1561415609_RK, 1.15733720988_RK, 1.15853451364_RK, &
    1.1597334785_RK, 1.16093411079_RK, 1.16213641689_RK, 1.16334040321_RK, &
    1.1645460762_RK, 1.16575344233_RK, 1.16696250814_RK, 1.16817328018_RK, &
    1.16938576505_RK, 1.17059996938_RK, 1.17181589985_RK, 1.17303356317_RK, &
    1.17425296609_RK, 1.1754741154_RK, 1.17669701793_RK, 1.17792168055_RK, &
    1.17914811017_RK, 1.18037631374_RK, 1.18160629825_RK, 1.18283807074_RK, &
    1.18407163828_RK, 1.18530700798_RK, 1.18654418701_RK, 1.18778318256_RK, &
    1.18902400188_RK, 1.19026665225_RK, 1.19151114101_RK, 1.19275747553_RK, &
    1.19400566322_RK, 1.19525571156_RK, 1.19650762804_RK, 1.19776142023_RK, &
    1.19901709572_RK, 1.20027466216_RK, 1.20153412724_RK, 1.2027954987_RK, &
    1.20405878432_RK, 1.20532399194_RK, 1.20659112944_RK, 1.20786020475_RK, &
    1.20913122586_RK, 1.21040420078_RK, 1.21167913759_RK, 1.21295604444_RK, &
    1.21423492948_RK, 1.21551580096_RK, 1.21679866716_RK, 1.2180835364_RK, &
    1.21937041707_RK, 1.22065931762_RK, 1.22195024653_RK, 1.22324321234_RK, &
    1.22453822366_RK, 1.22583528914_RK, 1.22713441748_RK, 1.22843561746_RK, &
    1.22973889789_RK, 1.23104426764_RK, 1.23235173565_RK, 1.23366131092_RK, &
    1.23497300248_RK, 1.23628681945_RK, 1.23760277098_RK, 1.23892086632_RK, &
    1.24024111474_RK, 1.24156352558_RK, 1.24288810826_RK, 1.24421487225_RK, &
    1.24554382707_RK, 1.24687498231_RK, 1.24820834764_RK, 1.24954393277_RK, &
    1.25088174749_RK, 1.25222180165_RK, 1.25356410517_RK, 1.25490866802_RK, &
    1.25625550025_RK, 1.25760461198_RK, 1.25895601339_RK, 1.26030971474_RK, &
    1.26166572634_RK, 1.26302405859_RK, 1.26438472195_RK, 1.26574772695_RK, &
    1.26711308419_RK, 1.26848080436_RK, 1.2698508982_RK, 1.27122337654_RK, &
    1.27259825027_RK, 1.27397553036_RK, 1.27535522788_RK, 1.27673735394_RK, &
    1.27812191975_RK, 1.27950893658_RK, 1.2808984158_RK, 1.28229036885_RK, &
    1.28368480725_RK, 1.2850817426_RK, 1.28648118658_RK, 1.28788315096_RK, &
    1.28928764758_RK, 1.29069468838_RK, 1.29210428538_RK, 1.29351645068_RK, &
    1.29493119647_RK, 1.29634853503_RK, 1.29776847873_RK, 1.29919104001_RK, &
    1.30061623144_RK, 1.30204406564_RK, 1.30347455533_RK, 1.30490771336_RK, &
    1.30634355261_RK, 1.30778208612_RK, 1.30922332698_RK, 1.31066728839_RK, &
    1.31211398366_RK, 1.31356342618_RK, 1.31501562944_RK, 1.31647060705_RK, &
    1.3179283727_RK, 1.31938894019_RK, 1.32085232344_RK, 1.32231853644_RK, &
    1.32378759331_RK, 1.32525950829_RK, 1.32673429568_RK, 1.32821196994_RK, &
    1.3296925456_RK, 1.33117603734_RK, 1.33266245992_RK, 1.33415182822_RK, &
    1.33564415726_RK, 1.33713946213_RK, 1.33863775808_RK, 1.34013906045_RK, &
    1.34164338473_RK, 1.34315074649_RK, 1.34466116145_RK, 1.34617464545_RK, &
    1.34769121444_RK, 1.34921088453_RK, 1.35073367192_RK, 1.35225959295_RK, &
    1.3537886641_RK, 1.35532090198_RK, 1.35685632332_RK, 1.35839494499_RK, &
    1.35993678401_RK, 1.36148185752_RK, 1.3630301828_RK, 1.36458177727_RK, &
    1.36613665852_RK, 1.36769484423_RK, 1.36925635228_RK, 1.37082120066_RK, &
    1.37238940752_RK, 1.37396099116_RK, 1.37553597004_RK, 1.37711436276_RK, &
    1.37869618807_RK, 1.3802814649_RK, 1.38187021232_RK, 1.38346244956_RK, &
    1.38505819603_RK, 1.38665747129_RK, 1.38826029505_RK, 1.38986668723_RK, &
    1.39147666789_RK, 1.39309025725_RK, 1.39470747574_RK, 1.39632834393_RK, &
    1.3979528826_RK, 1.39958111269_RK, 1.40121305532_RK, 1.40284873181_RK, &
    1.40448816364_RK, 1.40613137251_RK, 1.40777838029_RK, 1.40942920906_RK, &
    1.41108388106_RK, 1.41274241877_RK, 1.41440484485_RK, 1.41607118216_RK, &
    1.41774145377_RK, 1.41941568296_RK, 1.42109389321_RK, 1.42277610822_RK, &
    1.42446235191_RK, 1.4261526484_RK, 1.42784702206_RK, 1.42954549744_RK, &
    1.43124809936_RK, 1.43295485285_RK, 1.43466578316_RK, 1.43638091579_RK, &
    1.43810027647_RK, 1.43982389118_RK, 1.44155178613_RK, 1.44328398779_RK, &
    1.44502052286_RK, 1.44676141832_RK, 1.44850670139_RK, 1.45025639954_RK, &
    1.45201054053_RK, 1.45376915236_RK, 1.4555322633_RK, 1.45729990192_RK, &
    1.45907209704_RK, 1.46084887778_RK, 1.46263027351_RK, 1.46441631394_RK, &
    1.46620702902_RK, 1.46800244903_RK, 1.46980260454_RK, 1.47160752641_RK, &
    1.47341724582_RK, 1.47523179427_RK, 1.47705120356_RK, 1.47887550581_RK, &
    1.48070473348_RK, 1.48253891934_RK, 1.48437809651_RK, 1.48622229844_RK, &
    1.48807155892_RK, 1.48992591209_RK, 1.49178539245_RK, 1.49365003484_RK, &
    1.49551987447_RK, 1.49739494693_RK, 1.49927528818_RK, 1.50116093452_RK, &
    1.50305192269_RK, 1.50494828979_RK, 1.5068500733_RK, 1.50875731112_RK, &
    1.51067004156_RK, 1.51258830332_RK, 1.51451213554_RK, 1.51644157777_RK, &
    1.51837667_RK, 1.52031745264_RK, 1.52226396655_RK, 1.52421625305_RK, &
    1.52617435391_RK, 1.52813831134_RK, 1.53010816806_RK, 1.53208396723_RK, &
    1.53406575252_RK, 1.53605356807_RK, 1.53804745854_RK, 1.54004746908_RK, &
    1.54205364536_RK, 1.54406603357_RK, 1.54608468043_RK, 1.5481096332_RK, &
    1.55014093969_RK, 1.55217864825_RK, 1.55422280782_RK, 1.55627346789_RK, &
    1.55833067854_RK, 1.56039449044_RK, 1.56246495486_RK, 1.56454212368_RK, &
    1.56662604942_RK, 1.56871678519_RK, 1.57081438477_RK, 1.57291890258_RK, &
    1.57503039371_RK, 1.57714891392_RK, 1.57927451964_RK, 1.581407268_RK, &
    1.58354721686_RK, 1.58569442477_RK, 1.58784895103_RK, 1.59001085565_RK, &
    1.59218019943_RK, 1.59435704393_RK, 1.59654145149_RK, 1.59873348523_RK, &
    1.60093320909_RK, 1.60314068784_RK, 1.60535598708_RK, 1.60757917325_RK, &
    1.60981031368_RK, 1.61204947656_RK, 1.61429673098_RK, 1.61655214696_RK, &
    1.61881579544_RK, 1.62108774828_RK, 1.62336807836_RK, 1.62565685948_RK, &
    1.62795416649_RK, 1.63026007522_RK, 1.63257466256_RK, 1.63489800643_RK, &
    1.63723018585_RK, 1.63957128092_RK, 1.64192137286_RK, 1.64428054402_RK, &
    1.64664887792_RK, 1.64902645924_RK, 1.65141337389_RK, 1.65380970898_RK, &
    1.65621555288_RK, 1.65863099522_RK, 1.66105612696_RK, 1.66349104035_RK, &
    1.665935829_RK, 1.6683905879_RK, 1.67085541345_RK, 1.67333040348_RK, &
    1.67581565725_RK, 1.67831127556_RK, 1.68081736069_RK, 1.68333401649_RK, &
    1.6858613484_RK, 1.68839946345_RK, 1.69094847035_RK, 1.69350847947_RK, &
    1.69607960292_RK, 1.69866195455_RK, 1.70125565_RK, 1.70386080677_RK, &
    1.70647754419_RK, 1.70910598353_RK, 1.71174624799_RK, 1.7143984628_RK, &
    1.71706275519_RK, 1.71973925449_RK, 1.72242809217_RK, 1.72512940185_RK, &
    1.72784331941_RK, 1.73056998298_RK, 1.73330953303_RK, 1.7360621124_RK, &
    1.73882786639_RK, 1.74160694276_RK, 1.74439949184_RK, 1.74720566658_RK, &
    1.75002562257_RK, 1.75285951816_RK, 1.75570751448_RK, 1.75856977555_RK, &
    1.7614464683_RK, 1.7643377627_RK, 1.76724383175_RK, 1.77016485166_RK, &
    1.77310100183_RK, 1.77605246501_RK, 1.77901942732_RK, 1.78200207837_RK, &
    1.78500061134_RK, 1.78801522309_RK, 1.79104611422_RK, 1.79409348917_RK, &
    1.79715755637_RK, 1.80023852827_RK, 1.8033366215_RK, 1.80645205698_RK, &
    1.80958506_RK, 1.81273586036_RK, 1.81590469249_RK, 1.81909179558_RK, &
    1.82229741372_RK, 1.825521796_RK, 1.82876519668_RK, 1.83202787533_RK, &
    1.83531009698_RK, 1.83861213227_RK, 1.84193425762_RK, 1.84527675539_RK, &
    1.84863991405_RK, 1.85202402837_RK, 1.8554293996_RK, 1.85885633567_RK, &
    1.86230515137_RK, 1.86577616858_RK, 1.86926971649_RK, 1.87278613181_RK, &
    1.87632575899_RK, 1.8798889505_RK, 1.88347606705_RK, 1.88708747787_RK, &
    1.89072356098_RK, 1.89438470345_RK, 1.89807130174_RK, 1.90178376197_RK, &
    1.90552250025_RK, 1.90928794302_RK, 1.91308052741_RK, 1.91690070156_RK, &
    1.92074892503_RK, 1.92462566922_RK, 1.92853141772_RK, 1.93246666677_RK, &
    1.93643192574_RK, 1.94042771755_RK, 1.94445457918_RK, 1.9485130622_RK, &
    1.95260373328_RK, 1.95672717477_RK, 1.96088398528_RK, 1.96507478031_RK, &
    1.96930019287_RK, 1.97356087419_RK, 1.97785749442_RK, 1.98219074335_RK, &
    1.98656133124_RK, 1.99096998962_RK, 1.99541747213_RK, 1.99990455547_RK, &
    2.00443204036_RK, 2.00900075251_RK, 2.01361154371_RK, 2.01826529295_RK, &
    2.02296290758_RK, 2.02770532458_RK, 2.03249351185_RK, 2.03732846962_RK, &
    2.04221123192_RK, 2.0471428681_RK, 2.05212448451_RK, 2.05715722623_RK, &
    2.06224227888_RK, 2.06738087065_RK, 2.07257427429_RK, 2.07782380938_RK, &
    2.08313084465_RK, 2.08849680045_RK, 2.09392315145_RK, 2.09941142942_RK, &
    2.10496322628_RK, 2.11058019727_RK, 2.11626406445_RK, 2.12201662031_RK, &
    2.12783973172_RK, 2.13373534416_RK, 2.13970548619_RK, 2.14575227431_RK, &
    2.15187791816_RK, 2.1580847261_RK, 2.16437511125_RK, 2.17075159793_RK, &
    2.17721682871_RK, 2.18377357191_RK, 2.19042472984_RK, 2.1971733476_RK, &
    2.20402262267_RK, 2.21097591537_RK, 2.21803676019_RK, 2.22520887808_RK, &
    2.23249618993_RK, 2.23990283128_RK, 2.24743316835_RK, 2.25509181569_RK, &
    2.26288365549_RK, 2.27081385882_RK, 2.27888790909_RK, 2.28711162784_RK, &
    2.29549120334_RK, 2.30403322228_RK, 2.31274470495_RK, 2.32163314439_RK, &
    2.33070655011_RK, 2.33997349698_RK, 2.34944318006_RK, 2.35912547628_RK, &
    2.36903101398_RK, 2.37917125159_RK, 2.3895585669_RK, 2.40020635872_RK, &
    2.411129163_RK, 2.422342786_RK, 2.43386445755_RK, 2.44571300825_RK, &
    2.45790907518_RK, 2.47047534177_RK, 2.48343681896_RK, 2.49682117646_RK, &
    2.51065913523_RK, 2.52498493519_RK, 2.53983689632_RK, 2.55525809634_RK, &
    2.57129719532_RK, 2.58800944712_RK, 2.60545795099_RK, 2.62371521493_RK, &
    2.64286512889_RK, 2.66300548366_RK, 2.68425122698_RK, 2.7067387311_RK, &
    2.73063147325_RK, 2.75612772826_RK, 2.78347119119_RK, 2.81296597401_RK, &
    2.84499832124_RK, 2.8800689917_RK, 2.91884323355_RK, 2.9622311235_RK, &
    3.0115232357_RK, 3.06863405379_RK, 3.13657337257_RK, 3.22045475765_RK, &
    3.32996541598_RK, 3.48672170399_RK ];

    real(RK), parameter :: VEC_YU_1(1:1000) = [ &
    0.0540012735356_RK, 0.0544874991381_RK, 0.054972661389_RK, 0.0554567692269_RK, &
    0.0559398314244_RK, 0.0564218565922_RK, 0.0569028531841_RK, 0.0573828295011_RK, &
    0.0578617936955_RK, 0.0583397537752_RK, 0.058816717607_RK, 0.059292692921_RK, &
    0.0597676873138_RK, 0.060241708252_RK, 0.0607147630756_RK, 0.0611868590013_RK, &
    0.0616580031256_RK, 0.0621282024276_RK, 0.0625974637723_RK, 0.0630657939132_RK, &
    0.0635331994951_RK, 0.0639996870564_RK, 0.0644652630325_RK, 0.0649299337573_RK, &
    0.0653937054663_RK, 0.0658565842984_RK, 0.0663185762986_RK, 0.0667796874201_RK, &
    0.0672399235259_RK, 0.0676992903918_RK, 0.0681577937072_RK, 0.0686154390782_RK, &
    0.0690722320286_RK, 0.0695281780022_RK, 0.0699832823643_RK, 0.0704375504035_RK, &
    0.0708909873334_RK, 0.0713435982942_RK, 0.0717953883543_RK, 0.0722463625114_RK, &
    0.0726965256949_RK, 0.0731458827663_RK, 0.0735944385211_RK, 0.0740421976905_RK, &
    0.074489164942_RK, 0.0749353448811_RK, 0.0753807420524_RK, 0.0758253609412_RK, &
    0.076269205974_RK, 0.0767122815202_RK, 0.0771545918932_RK, 0.077596141351_RK, &
    0.0780369340979_RK, 0.0784769742851_RK, 0.078916266012_RK, 0.0793548133268_RK, &
    0.0797926202279_RK, 0.0802296906646_RK, 0.080666028538_RK, 0.081101637702_RK, &
    0.081536521964_RK, 0.0819706850859_RK, 0.082404130785_RK, 0.0828368627345_RK, &
    0.0832688845646_RK, 0.0837001998631_RK, 0.0841308121761_RK, 0.084560725009_RK, &
    0.0849899418268_RK, 0.0854184660553_RK, 0.0858463010813_RK, 0.0862734502535_RK, &
    0.0866999168832_RK, 0.0871257042449_RK, 0.0875508155769_RK, 0.0879752540816_RK, &
    0.0883990229268_RK, 0.0888221252457_RK, 0.0892445641375_RK, 0.0896663426683_RK, &
    0.0900874638713_RK, 0.0905079307475_RK, 0.0909277462662_RK, 0.0913469133655_RK, &
    0.0917654349529_RK, 0.0921833139053_RK, 0.0926005530704_RK, 0.0930171552661_RK, &
    0.0934331232819_RK, 0.0938484598786_RK, 0.0942631677893_RK, 0.0946772497194_RK, &
    0.0950907083474_RK, 0.095503546325_RK, 0.0959157662776_RK, 0.0963273708049_RK, &
    0.0967383624809_RK, 0.0971487438546_RK, 0.0975585174503_RK, 0.0979676857678_RK, &
    0.098376251283_RK, 0.098784216448_RK, 0.0991915836918_RK, 0.0995983554201_RK, &
    0.100004534016_RK, 0.100410121841_RK, 0.100815121233_RK, 0.10121953451_RK, &
    0.101623363968_RK, 0.102026611881_RK, 0.102429280502_RK, 0.102831372066_RK, &
    0.103232888785_RK, 0.103633832853_RK, 0.104034206444_RK, 0.10443401171_RK, &
    0.104833250787_RK, 0.105231925791_RK, 0.10563003882_RK, 0.106027591953_RK, &
    0.106424587249_RK, 0.106821026753_RK, 0.10721691249_RK, 0.107612246467_RK, &
    0.108007030675_RK, 0.108401267088_RK, 0.108794957663_RK, 0.10918810434_RK, &
    0.109580709043_RK, 0.109972773679_RK, 0.110364300142_RK, 0.110755290307_RK, &
    0.111145746034_RK, 0.111535669171_RK, 0.111925061545_RK, 0.112313924974_RK, &
    0.112702261257_RK, 0.113090072181_RK, 0.113477359516_RK, 0.113864125022_RK, &
    0.11425037044_RK, 0.1146360975_RK, 0.115021307918_RK, 0.115406003396_RK, &
    0.115790185624_RK, 0.116173856276_RK, 0.116557017014_RK, 0.11693966949_RK, &
    0.117321815339_RK, 0.117703456185_RK, 0.118084593641_RK, 0.118465229306_RK, &
    0.118845364768_RK, 0.1192250016_RK, 0.119604141367_RK, 0.119982785621_RK, &
    0.120360935901_RK, 0.120738593735_RK, 0.121115760642_RK, 0.121492438126_RK, &
    0.121868627682_RK, 0.122244330795_RK, 0.122619548937_RK, 0.12299428357_RK, &
    0.123368536146_RK, 0.123742308106_RK, 0.124115600881_RK, 0.12448841589_RK, &
    0.124860754545_RK, 0.125232618245_RK, 0.12560400838_RK, 0.125974926331_RK, &
    0.126345373469_RK, 0.126715351154_RK, 0.127084860738_RK, 0.127453903564_RK, &
    0.127822480963_RK, 0.128190594259_RK, 0.128558244767_RK, 0.128925433793_RK, &
    0.129292162631_RK, 0.129658432571_RK, 0.130024244891_RK, 0.13038960086_RK, &
    0.130754501741_RK, 0.131118948787_RK, 0.131482943242_RK, 0.131846486342_RK, &
    0.132209579317_RK, 0.132572223385_RK, 0.132934419758_RK, 0.133296169642_RK, &
    0.13365747423_RK, 0.134018334713_RK, 0.13437875227_RK, 0.134738728074_RK, &
    0.13509826329_RK, 0.135457359075_RK, 0.135816016581_RK, 0.13617423695_RK, &
    0.136532021316_RK, 0.13688937081_RK, 0.137246286551_RK, 0.137602769653_RK, &
    0.137958821225_RK, 0.138314442365_RK, 0.138669634167_RK, 0.139024397717_RK, &
    0.139378734095_RK, 0.139732644373_RK, 0.140086129618_RK, 0.14043919089_RK, &
    0.140791829241_RK, 0.141144045718_RK, 0.141495841361_RK, 0.141847217205_RK, &
    0.142198174276_RK, 0.142548713597_RK, 0.142898836183_RK, 0.143248543043_RK, &
    0.143597835179_RK, 0.14394671359_RK, 0.144295179266_RK, 0.144643233193_RK, &
    0.144990876349_RK, 0.14533810971_RK, 0.145684934242_RK, 0.146031350908_RK, &
    0.146377360665_RK, 0.146722964463_RK, 0.147068163249_RK, 0.147412957962_RK, &
    0.147757349537_RK, 0.148101338903_RK, 0.148444926984_RK, 0.148788114699_RK, &
    0.149130902961_RK, 0.149473292678_RK, 0.149815284753_RK, 0.150156880085_RK, &
    0.150498079565_RK, 0.150838884082_RK, 0.151179294519_RK, 0.151519311753_RK, &
    0.151858936658_RK, 0.152198170101_RK, 0.152537012946_RK, 0.152875466051_RK, &
    0.153213530271_RK, 0.153551206454_RK, 0.153888495445_RK, 0.154225398084_RK, &
    0.154561915205_RK, 0.15489804764_RK, 0.155233796214_RK, 0.155569161751_RK, &
    0.155904145066_RK, 0.156238746972_RK, 0.156572968279_RK, 0.156906809791_RK, &
    0.157240272307_RK, 0.157573356623_RK, 0.15790606353_RK, 0.158238393817_RK, &
    0.158570348265_RK, 0.158901927654_RK, 0.159233132759_RK, 0.159563964351_RK, &
    0.159894423197_RK, 0.160224510058_RK, 0.160554225695_RK, 0.160883570863_RK, &
    0.161212546311_RK, 0.161541152788_RK, 0.161869391036_RK, 0.162197261796_RK, &
    0.162524765803_RK, 0.162851903789_RK, 0.163178676483_RK, 0.163505084608_RK, &
    0.163831128886_RK, 0.164156810034_RK, 0.164482128766_RK, 0.164807085792_RK, &
    0.165131681818_RK, 0.165455917548_RK, 0.165779793681_RK, 0.166103310913_RK, &
    0.166426469936_RK, 0.16674927144_RK, 0.167071716111_RK, 0.167393804631_RK, &
    0.167715537679_RK, 0.16803691593_RK, 0.168357940058_RK, 0.168678610731_RK, &
    0.168998928615_RK, 0.169318894373_RK, 0.169638508664_RK, 0.169957772145_RK, &
    0.170276685469_RK, 0.170595249286_RK, 0.170913464242_RK, 0.171231330982_RK, &
    0.171548850146_RK, 0.171866022373_RK, 0.172182848295_RK, 0.172499328546_RK, &
    0.172815463755_RK, 0.173131254545_RK, 0.173446701542_RK, 0.173761805364_RK, &
    0.174076566628_RK, 0.174390985949_RK, 0.174705063937_RK, 0.175018801202_RK, &
    0.175332198348_RK, 0.175645255979_RK, 0.175957974695_RK, 0.176270355092_RK, &
    0.176582397766_RK, 0.176894103309_RK, 0.177205472308_RK, 0.177516505351_RK, &
    0.177827203022_RK, 0.178137565902_RK, 0.178447594568_RK, 0.178757289598_RK, &
    0.179066651564_RK, 0.179375681037_RK, 0.179684378585_RK, 0.179992744774_RK, &
    0.180300780166_RK, 0.180608485323_RK, 0.180915860803_RK, 0.18122290716_RK, &
    0.181529624949_RK, 0.18183601472_RK, 0.182142077022_RK, 0.182447812399_RK, &
    0.182753221396_RK, 0.183058304554_RK, 0.183363062412_RK, 0.183667495505_RK, &
    0.183971604368_RK, 0.184275389534_RK, 0.18457885153_RK, 0.184881990885_RK, &
    0.185184808123_RK, 0.185487303768_RK, 0.185789478338_RK, 0.186091332353_RK, &
    0.186392866329_RK, 0.186694080779_RK, 0.186994976215_RK, 0.187295553146_RK, &
    0.18759581208_RK, 0.187895753521_RK, 0.188195377973_RK, 0.188494685937_RK, &
    0.188793677911_RK, 0.189092354391_RK, 0.189390715873_RK, 0.18968876285_RK, &
    0.189986495811_RK, 0.190283915244_RK, 0.190581021638_RK, 0.190877815475_RK, &
    0.191174297238_RK, 0.191470467408_RK, 0.191766326463_RK, 0.192061874879_RK, &
    0.192357113132_RK, 0.192652041693_RK, 0.192946661033_RK, 0.193240971621_RK, &
    0.193534973925_RK, 0.193828668408_RK, 0.194122055533_RK, 0.194415135763_RK, &
    0.194707909556_RK, 0.19500037737_RK, 0.195292539661_RK, 0.195584396882_RK, &
    0.195875949485_RK, 0.196167197921_RK, 0.196458142637_RK, 0.196748784081_RK, &
    0.197039122697_RK, 0.197329158929_RK, 0.197618893218_RK, 0.197908326003_RK, &
    0.198197457722_RK, 0.198486288812_RK, 0.198774819706_RK, 0.199063050838_RK, &
    0.199350982639_RK, 0.199638615537_RK, 0.199925949961_RK, 0.200212986337_RK, &
    0.200499725089_RK, 0.20078616664_RK, 0.20107231141_RK, 0.20135815982_RK, &
    0.201643712287_RK, 0.201928969228_RK, 0.202213931056_RK, 0.202498598186_RK, &
    0.202782971029_RK, 0.203067049994_RK, 0.20335083549_RK, 0.203634327924_RK, &
    0.203917527701_RK, 0.204200435225_RK, 0.204483050898_RK, 0.204765375121_RK, &
    0.205047408293_RK, 0.205329150811_RK, 0.205610603072_RK, 0.205891765471_RK, &
    0.2061726384_RK, 0.206453222252_RK, 0.206733517417_RK, 0.207013524284_RK, &
    0.207293243239_RK, 0.20757267467_RK, 0.207851818961_RK, 0.208130676495_RK, &
    0.208409247653_RK, 0.208687532816_RK, 0.208965532363_RK, 0.209243246671_RK, &
    0.209520676117_RK, 0.209797821075_RK, 0.210074681919_RK, 0.210351259021_RK, &
    0.210627552752_RK, 0.21090356348_RK, 0.211179291575_RK, 0.211454737402_RK, &
    0.211729901327_RK, 0.212004783714_RK, 0.212279384926_RK, 0.212553705325_RK, &
    0.21282774527_RK, 0.213101505121_RK, 0.213374985234_RK, 0.213648185967_RK, &
    0.213921107674_RK, 0.214193750709_RK, 0.214466115425_RK, 0.214738202173_RK, &
    0.215010011303_RK, 0.215281543164_RK, 0.215552798104_RK, 0.215823776468_RK, &
    0.216094478602_RK, 0.21636490485_RK, 0.216635055555_RK, 0.216904931057_RK, &
    0.217174531699_RK, 0.217443857818_RK, 0.217712909752_RK, 0.21798168784_RK, &
    0.218250192415_RK, 0.218518423813_RK, 0.218786382367_RK, 0.219054068409_RK, &
    0.21932148227_RK, 0.21958862428_RK, 0.219855494768_RK, 0.220122094062_RK, &
    0.220388422488_RK, 0.220654480371_RK, 0.220920268035_RK, 0.221185785805_RK, &
    0.221451034002_RK, 0.221716012947_RK, 0.22198072296_RK, 0.222245164359_RK, &
    0.222509337463_RK, 0.222773242589_RK, 0.223036880051_RK, 0.223300250165_RK, &
    0.223563353244_RK, 0.2238261896_RK, 0.224088759545_RK, 0.224351063389_RK, &
    0.224613101442_RK, 0.224874874012_RK, 0.225136381406_RK, 0.22539762393_RK, &
    0.22565860189_RK, 0.22591931559_RK, 0.226179765333_RK, 0.226439951422_RK, &
    0.226699874157_RK, 0.22695953384_RK, 0.227218930768_RK, 0.227478065241_RK, &
    0.227736937556_RK, 0.227995548009_RK, 0.228253896895_RK, 0.22851198451_RK, &
    0.228769811145_RK, 0.229027377095_RK, 0.22928468265_RK, 0.229541728101_RK, &
    0.229798513738_RK, 0.23005503985_RK, 0.230311306723_RK, 0.230567314646_RK, &
    0.230823063904_RK, 0.231078554782_RK, 0.231333787564_RK, 0.231588762534_RK, &
    0.231843479974_RK, 0.232097940164_RK, 0.232352143387_RK, 0.232606089921_RK, &
    0.232859780045_RK, 0.233113214036_RK, 0.233366392173_RK, 0.233619314731_RK, &
    0.233871981984_RK, 0.234124394209_RK, 0.234376551677_RK, 0.234628454662_RK, &
    0.234880103436_RK, 0.235131498268_RK, 0.235382639431_RK, 0.235633527192_RK, &
    0.23588416182_RK, 0.236134543582_RK, 0.236384672746_RK, 0.236634549577_RK, &
    0.23688417434_RK, 0.2371335473_RK, 0.237382668719_RK, 0.237631538861_RK, &
    0.237880157987_RK, 0.238128526359_RK, 0.238376644236_RK, 0.238624511878_RK, &
    0.238872129544_RK, 0.23911949749_RK, 0.239366615975_RK, 0.239613485254_RK, &
    0.239860105583_RK, 0.240106477217_RK, 0.240352600409_RK, 0.240598475413_RK, &
    0.240844102481_RK, 0.241089481863_RK, 0.241334613813_RK, 0.241579498578_RK, &
    0.241824136409_RK, 0.242068527555_RK, 0.242312672262_RK, 0.242556570778_RK, &
    0.24280022335_RK, 0.243043630222_RK, 0.243286791641_RK, 0.243529707849_RK, &
    0.24377237909_RK, 0.244014805607_RK, 0.244256987642_RK, 0.244498925435_RK, &
    0.244740619229_RK, 0.244982069261_RK, 0.245223275772_RK, 0.245464238999_RK, &
    0.24570495918_RK, 0.245945436553_RK, 0.246185671353_RK, 0.246425663816_RK, &
    0.246665414177_RK, 0.24690492267_RK, 0.247144189529_RK, 0.247383214985_RK, &
    0.247621999273_RK, 0.247860542621_RK, 0.248098845263_RK, 0.248336907427_RK, &
    0.248574729343_RK, 0.24881231124_RK, 0.249049653346_RK, 0.249286755888_RK, &
    0.249523619094_RK, 0.249760243188_RK, 0.249996628397_RK, 0.250232774945_RK, &
    0.250468683057_RK, 0.250704352956_RK, 0.250939784865_RK, 0.251174979007_RK, &
    0.251409935601_RK, 0.251644654871_RK, 0.251879137035_RK, 0.252113382314_RK, &
    0.252347390927_RK, 0.252581163092_RK, 0.252814699027_RK, 0.253047998949_RK, &
    0.253281063075_RK, 0.253513891621_RK, 0.253746484801_RK, 0.253978842831_RK, &
    0.254210965925_RK, 0.254442854297_RK, 0.254674508159_RK, 0.254905927723_RK, &
    0.255137113202_RK, 0.255368064807_RK, 0.255598782747_RK, 0.255829267233_RK, &
    0.256059518475_RK, 0.256289536681_RK, 0.256519322059_RK, 0.256748874817_RK, &
    0.256978195162_RK, 0.2572072833_RK, 0.257436139437_RK, 0.257664763779_RK, &
    0.25789315653_RK, 0.258121317895_RK, 0.258349248077_RK, 0.258576947278_RK, &
    0.258804415703_RK, 0.259031653551_RK, 0.259258661026_RK, 0.259485438327_RK, &
    0.259711985655_RK, 0.259938303209_RK, 0.260164391189_RK, 0.260390249794_RK, &
    0.260615879221_RK, 0.260841279668_RK, 0.261066451331_RK, 0.261291394408_RK, &
    0.261516109095_RK, 0.261740595585_RK, 0.261964854076_RK, 0.26218888476_RK, &
    0.262412687831_RK, 0.262636263484_RK, 0.26285961191_RK, 0.263082733302_RK, &
    0.263305627851_RK, 0.263528295749_RK, 0.263750737186_RK, 0.263972952353_RK, &
    0.264194941439_RK, 0.264416704633_RK, 0.264638242124_RK, 0.2648595541_RK, &
    0.265080640748_RK, 0.265301502256_RK, 0.265522138811_RK, 0.265742550598_RK, &
    0.265962737803_RK, 0.266182700611_RK, 0.266402439207_RK, 0.266621953774_RK, &
    0.266841244498_RK, 0.26706031156_RK, 0.267279155143_RK, 0.26749777543_RK, &
    0.267716172603_RK, 0.267934346842_RK, 0.268152298328_RK, 0.268370027242_RK, &
    0.268587533763_RK, 0.268804818071_RK, 0.269021880344_RK, 0.269238720761_RK, &
    0.2694553395_RK, 0.269671736739_RK, 0.269887912653_RK, 0.270103867421_RK, &
    0.270319601217_RK, 0.270535114218_RK, 0.270750406598_RK, 0.270965478533_RK, &
    0.271180330196_RK, 0.271394961762_RK, 0.271609373403_RK, 0.271823565293_RK, &
    0.272037537604_RK, 0.272251290507_RK, 0.272464824175_RK, 0.272678138779_RK, &
    0.272891234489_RK, 0.273104111476_RK, 0.273316769908_RK, 0.273529209956_RK, &
    0.273741431789_RK, 0.273953435575_RK, 0.274165221481_RK, 0.274376789677_RK, &
    0.274588140328_RK, 0.274799273601_RK, 0.275010189664_RK, 0.275220888681_RK, &
    0.275431370818_RK, 0.275641636241_RK, 0.275851685114_RK, 0.2760615176_RK, &
    0.276271133865_RK, 0.276480534071_RK, 0.276689718381_RK, 0.276898686958_RK, &
    0.277107439965_RK, 0.277315977561_RK, 0.27752429991_RK, 0.277732407172_RK, &
    0.277940299507_RK, 0.278147977076_RK, 0.278355440038_RK, 0.278562688553_RK, &
    0.278769722779_RK, 0.278976542875_RK, 0.279183149_RK, 0.27938954131_RK, &
    0.279595719963_RK, 0.279801685116_RK, 0.280007436926_RK, 0.280212975549_RK, &
    0.280418301139_RK, 0.280623413854_RK, 0.280828313848_RK, 0.281033001275_RK, &
    0.281237476289_RK, 0.281441739045_RK, 0.281645789695_RK, 0.281849628394_RK, &
    0.282053255293_RK, 0.282256670545_RK, 0.282459874302_RK, 0.282662866715_RK, &
    0.282865647935_RK, 0.283068218114_RK, 0.283270577402_RK, 0.283472725948_RK, &
    0.283674663903_RK, 0.283876391415_RK, 0.284077908635_RK, 0.284279215709_RK, &
    0.284480312788_RK, 0.284681200017_RK, 0.284881877546_RK, 0.285082345521_RK, &
    0.285282604088_RK, 0.285482653395_RK, 0.285682493588_RK, 0.285882124811_RK, &
    0.286081547211_RK, 0.286280760932_RK, 0.286479766119_RK, 0.286678562916_RK, &
    0.286877151468_RK, 0.287075531918_RK, 0.287273704409_RK, 0.287471669084_RK, &
    0.287669426085_RK, 0.287866975555_RK, 0.288064317636_RK, 0.28826145247_RK, &
    0.288458380196_RK, 0.288655100957_RK, 0.288851614893_RK, 0.289047922144_RK, &
    0.289244022849_RK, 0.289439917148_RK, 0.289635605182_RK, 0.289831087087_RK, &
    0.290026363003_RK, 0.290221433068_RK, 0.290416297419_RK, 0.290610956195_RK, &
    0.290805409533_RK, 0.290999657568_RK, 0.291193700439_RK, 0.29138753828_RK, &
    0.291581171228_RK, 0.291774599419_RK, 0.291967822987_RK, 0.292160842068_RK, &
    0.292353656796_RK, 0.292546267306_RK, 0.292738673731_RK, 0.292930876204_RK, &
    0.29312287486_RK, 0.293314669832_RK, 0.293506261251_RK, 0.293697649251_RK, &
    0.293888833963_RK, 0.294079815519_RK, 0.294270594051_RK, 0.29446116969_RK, &
    0.294651542566_RK, 0.294841712811_RK, 0.295031680553_RK, 0.295221445924_RK, &
    0.295411009053_RK, 0.295600370069_RK, 0.295789529101_RK, 0.295978486277_RK, &
    0.296167241727_RK, 0.296355795578_RK, 0.296544147958_RK, 0.296732298995_RK, &
    0.296920248815_RK, 0.297107997546_RK, 0.297295545315_RK, 0.297482892246_RK, &
    0.297670038468_RK, 0.297856984104_RK, 0.298043729282_RK, 0.298230274125_RK, &
    0.298416618759_RK, 0.298602763308_RK, 0.298788707897_RK, 0.298974452649_RK, &
    0.299159997689_RK, 0.299345343139_RK, 0.299530489123_RK, 0.299715435764_RK, &
    0.299900183184_RK, 0.300084731505_RK, 0.30026908085_RK, 0.300453231339_RK, &
    0.300637183096_RK, 0.30082093624_RK, 0.301004490893_RK, 0.301187847175_RK, &
    0.301371005207_RK, 0.301553965108_RK, 0.301736726999_RK, 0.301919290999_RK, &
    0.302101657227_RK, 0.302283825802_RK, 0.302465796843_RK, 0.302647570468_RK, &
    0.302829146795_RK, 0.303010525942_RK, 0.303191708028_RK, 0.303372693168_RK, &
    0.303553481481_RK, 0.303734073083_RK, 0.30391446809_RK, 0.304094666619_RK, &
    0.304274668786_RK, 0.304454474707_RK, 0.304634084497_RK, 0.304813498271_RK, &
    0.304992716144_RK, 0.305171738232_RK, 0.305350564647_RK, 0.305529195506_RK, &
    0.305707630921_RK, 0.305885871006_RK, 0.306063915875_RK, 0.306241765641_RK, &
    0.306419420416_RK, 0.306596880314_RK, 0.306774145446_RK, 0.306951215926_RK, &
    0.307128091864_RK, 0.307304773373_RK, 0.307481260563_RK, 0.307657553547_RK, &
    0.307833652434_RK, 0.308009557336_RK, 0.308185268362_RK, 0.308360785624_RK, &
    0.308536109231_RK, 0.308711239292_RK, 0.308886175918_RK, 0.309060919216_RK, &
    0.309235469297_RK, 0.309409826268_RK, 0.309583990239_RK, 0.309757961317_RK, &
    0.309931739611_RK, 0.310105325228_RK, 0.310278718275_RK, 0.31045191886_RK, &
    0.31062492709_RK, 0.310797743071_RK, 0.310970366911_RK, 0.311142798715_RK, &
    0.31131503859_RK, 0.31148708664_RK, 0.311658942973_RK, 0.311830607693_RK, &
    0.312002080905_RK, 0.312173362715_RK, 0.312344453226_RK, 0.312515352544_RK, &
    0.312686060772_RK, 0.312856578014_RK, 0.313026904375_RK, 0.313197039958_RK, &
    0.313366984865_RK, 0.313536739201_RK, 0.313706303067_RK, 0.313875676567_RK, &
    0.314044859803_RK, 0.314213852877_RK, 0.31438265589_RK, 0.314551268945_RK, &
    0.314719692144_RK, 0.314887925586_RK, 0.315055969374_RK, 0.315223823609_RK, &
    0.31539148839_RK, 0.315558963818_RK, 0.315726249993_RK, 0.315893347016_RK, &
    0.316060254985_RK, 0.316226974001_RK, 0.316393504163_RK, 0.31655984557_RK, &
    0.31672599832_RK, 0.316891962512_RK, 0.317057738245_RK, 0.317223325617_RK, &
    0.317388724726_RK, 0.31755393567_RK, 0.317718958546_RK, 0.317883793451_RK, &
    0.318048440483_RK, 0.318212899739_RK, 0.318377171315_RK, 0.318541255307_RK, &
    0.318705151813_RK, 0.318868860929_RK, 0.319032382749_RK, 0.31919571737_RK, &
    0.319358864888_RK, 0.319521825397_RK, 0.319684598993_RK, 0.31984718577_RK, &
    0.320009585823_RK, 0.320171799247_RK, 0.320333826135_RK, 0.320495666583_RK, &
    0.320657320683_RK, 0.320818788529_RK, 0.320980070215_RK, 0.321141165834_RK, &
    0.321302075479_RK, 0.321462799242_RK, 0.321623337217_RK, 0.321783689496_RK, &
    0.321943856171_RK, 0.322103837334_RK, 0.322263633077_RK, 0.322423243491_RK, &
    0.322582668669_RK, 0.322741908701_RK, 0.322900963677_RK, 0.323059833691_RK, &
    0.323218518831_RK, 0.323377019188_RK, 0.323535334852_RK, 0.323693465915_RK, &
    0.323851412464_RK, 0.324009174591_RK, 0.324166752385_RK, 0.324324145934_RK, &
    0.324481355329_RK, 0.324638380658_RK, 0.324795222009_RK, 0.324951879472_RK, &
    0.325108353134_RK, 0.325264643085_RK, 0.325420749411_RK, 0.3255766722_RK, &
    0.325732411541_RK, 0.325887967521_RK, 0.326043340226_RK, 0.326198529745_RK, &
    0.326353536163_RK, 0.326508359567_RK, 0.326663000045_RK, 0.326817457682_RK, &
    0.326971732564_RK, 0.327125824778_RK, 0.327279734408_RK, 0.327433461542_RK, &
    0.327587006263_RK, 0.327740368658_RK, 0.327893548812_RK, 0.328046546808_RK, &
    0.328199362732_RK, 0.328351996669_RK, 0.328504448702_RK, 0.328656718917_RK ]

    real(RK), parameter :: VEC_YU_2(1001:2000) = [ &
    0.328808807396_RK, 0.328960714223_RK, 0.329112439483_RK, 0.329263983259_RK, &
    0.329415345633_RK, 0.32956652669_RK, 0.329717526511_RK, 0.32986834518_RK, &
    0.330018982779_RK, 0.330169439391_RK, 0.330319715097_RK, 0.33046980998_RK, &
    0.330619724122_RK, 0.330769457604_RK, 0.330919010508_RK, 0.331068382916_RK, &
    0.331217574907_RK, 0.331366586564_RK, 0.331515417967_RK, 0.331664069197_RK, &
    0.331812540334_RK, 0.331960831459_RK, 0.332108942652_RK, 0.332256873993_RK, &
    0.332404625561_RK, 0.332552197437_RK, 0.332699589699_RK, 0.332846802427_RK, &
    0.332993835701_RK, 0.333140689599_RK, 0.3332873642_RK, 0.333433859582_RK, &
    0.333580175825_RK, 0.333726313006_RK, 0.333872271204_RK, 0.334018050496_RK, &
    0.334163650961_RK, 0.334309072676_RK, 0.334454315719_RK, 0.334599380166_RK, &
    0.334744266096_RK, 0.334888973585_RK, 0.33503350271_RK, 0.335177853547_RK, &
    0.335322026174_RK, 0.335466020667_RK, 0.335609837101_RK, 0.335753475553_RK, &
    0.335896936099_RK, 0.336040218815_RK, 0.336183323776_RK, 0.336326251057_RK, &
    0.336469000734_RK, 0.336611572882_RK, 0.336753967576_RK, 0.336896184891_RK, &
    0.3370382249_RK, 0.33718008768_RK, 0.337321773304_RK, 0.337463281846_RK, &
    0.33760461338_RK, 0.337745767981_RK, 0.337886745721_RK, 0.338027546675_RK, &
    0.338168170916_RK, 0.338308618517_RK, 0.33844888955_RK, 0.338588984091_RK, &
    0.33872890221_RK, 0.33886864398_RK, 0.339008209475_RK, 0.339147598766_RK, &
    0.339286811925_RK, 0.339425849025_RK, 0.339564710138_RK, 0.339703395335_RK, &
    0.339841904688_RK, 0.339980238268_RK, 0.340118396147_RK, 0.340256378395_RK, &
    0.340394185084_RK, 0.340531816284_RK, 0.340669272067_RK, 0.340806552503_RK, &
    0.340943657662_RK, 0.341080587614_RK, 0.34121734243_RK, 0.341353922179_RK, &
    0.341490326932_RK, 0.341626556758_RK, 0.341762611726_RK, 0.341898491907_RK, &
    0.342034197368_RK, 0.34216972818_RK, 0.342305084412_RK, 0.342440266131_RK, &
    0.342575273407_RK, 0.342710106308_RK, 0.342844764904_RK, 0.342979249261_RK, &
    0.343113559448_RK, 0.343247695533_RK, 0.343381657583_RK, 0.343515445668_RK, &
    0.343649059853_RK, 0.343782500207_RK, 0.343915766796_RK, 0.344048859689_RK, &
    0.344181778951_RK, 0.344314524649_RK, 0.344447096851_RK, 0.344579495623_RK, &
    0.344711721031_RK, 0.344843773142_RK, 0.344975652022_RK, 0.345107357736_RK, &
    0.345238890351_RK, 0.345370249932_RK, 0.345501436546_RK, 0.345632450257_RK, &
    0.34576329113_RK, 0.345893959232_RK, 0.346024454627_RK, 0.346154777379_RK, &
    0.346284927555_RK, 0.346414905218_RK, 0.346544710432_RK, 0.346674343264_RK, &
    0.346803803775_RK, 0.346933092032_RK, 0.347062208097_RK, 0.347191152035_RK, &
    0.347319923909_RK, 0.347448523782_RK, 0.34757695172_RK, 0.347705207784_RK, &
    0.347833292037_RK, 0.347961204544_RK, 0.348088945366_RK, 0.348216514568_RK, &
    0.34834391221_RK, 0.348471138357_RK, 0.348598193069_RK, 0.348725076411_RK, &
    0.348851788443_RK, 0.348978329228_RK, 0.349104698827_RK, 0.349230897303_RK, &
    0.349356924717_RK, 0.349482781131_RK, 0.349608466606_RK, 0.349733981203_RK, &
    0.349859324983_RK, 0.349984498007_RK, 0.350109500337_RK, 0.350234332033_RK, &
    0.350358993156_RK, 0.350483483765_RK, 0.350607803923_RK, 0.350731953687_RK, &
    0.35085593312_RK, 0.350979742281_RK, 0.351103381229_RK, 0.351226850025_RK, &
    0.351350148728_RK, 0.351473277398_RK, 0.351596236094_RK, 0.351719024875_RK, &
    0.3518416438_RK, 0.351964092929_RK, 0.35208637232_RK, 0.352208482032_RK, &
    0.352330422124_RK, 0.352452192653_RK, 0.35257379368_RK, 0.352695225262_RK, &
    0.352816487456_RK, 0.352937580322_RK, 0.353058503916_RK, 0.353179258297_RK, &
    0.353299843523_RK, 0.353420259651_RK, 0.353540506738_RK, 0.353660584842_RK, &
    0.35378049402_RK, 0.353900234329_RK, 0.354019805826_RK, 0.354139208567_RK, &
    0.35425844261_RK, 0.354377508012_RK, 0.354496404828_RK, 0.354615133114_RK, &
    0.354733692928_RK, 0.354852084326_RK, 0.354970307363_RK, 0.355088362094_RK, &
    0.355206248577_RK, 0.355323966867_RK, 0.355441517019_RK, 0.355558899089_RK, &
    0.355676113131_RK, 0.355793159202_RK, 0.355910037356_RK, 0.356026747648_RK, &
    0.356143290133_RK, 0.356259664866_RK, 0.356375871902_RK, 0.356491911294_RK, &
    0.356607783098_RK, 0.356723487367_RK, 0.356839024156_RK, 0.356954393519_RK, &
    0.35706959551_RK, 0.357184630183_RK, 0.35729949759_RK, 0.357414197787_RK, &
    0.357528730826_RK, 0.357643096761_RK, 0.357757295645_RK, 0.357871327531_RK, &
    0.357985192472_RK, 0.358098890522_RK, 0.358212421732_RK, 0.358325786157_RK, &
    0.358438983847_RK, 0.358552014857_RK, 0.358664879237_RK, 0.358777577041_RK, &
    0.358890108321_RK, 0.359002473128_RK, 0.359114671515_RK, 0.359226703533_RK, &
    0.359338569235_RK, 0.359450268671_RK, 0.359561801893_RK, 0.359673168954_RK, &
    0.359784369903_RK, 0.359895404792_RK, 0.360006273672_RK, 0.360116976594_RK, &
    0.36022751361_RK, 0.360337884769_RK, 0.360448090122_RK, 0.360558129721_RK, &
    0.360668003615_RK, 0.360777711854_RK, 0.360887254489_RK, 0.360996631571_RK, &
    0.361105843148_RK, 0.361214889271_RK, 0.36132376999_RK, 0.361432485354_RK, &
    0.361541035413_RK, 0.361649420216_RK, 0.361757639813_RK, 0.361865694253_RK, &
    0.361973583586_RK, 0.362081307859_RK, 0.362188867123_RK, 0.362296261425_RK, &
    0.362403490816_RK, 0.362510555343_RK, 0.362617455054_RK, 0.36272419_RK, &
    0.362830760226_RK, 0.362937165783_RK, 0.363043406718_RK, 0.363149483079_RK, &
    0.363255394914_RK, 0.36336114227_RK, 0.363466725196_RK, 0.36357214374_RK, &
    0.363677397947_RK, 0.363782487867_RK, 0.363887413546_RK, 0.363992175032_RK, &
    0.364096772372_RK, 0.364201205612_RK, 0.364305474799_RK, 0.364409579981_RK, &
    0.364513521204_RK, 0.364617298515_RK, 0.364720911959_RK, 0.364824361585_RK, &
    0.364927647437_RK, 0.365030769562_RK, 0.365133728007_RK, 0.365236522816_RK, &
    0.365339154037_RK, 0.365441621714_RK, 0.365543925894_RK, 0.365646066623_RK, &
    0.365748043945_RK, 0.365849857906_RK, 0.365951508551_RK, 0.366052995927_RK, &
    0.366154320077_RK, 0.366255481046_RK, 0.366356478881_RK, 0.366457313625_RK, &
    0.366557985323_RK, 0.36665849402_RK, 0.366758839761_RK, 0.366859022589_RK, &
    0.36695904255_RK, 0.367058899687_RK, 0.367158594044_RK, 0.367258125667_RK, &
    0.367357494598_RK, 0.367456700881_RK, 0.367555744561_RK, 0.36765462568_RK, &
    0.367753344284_RK, 0.367851900414_RK, 0.367950294114_RK, 0.368048525428_RK, &
    0.368146594399_RK, 0.36824450107_RK, 0.368342245484_RK, 0.368439827684_RK, &
    0.368537247713_RK, 0.368634505613_RK, 0.368731601427_RK, 0.368828535197_RK, &
    0.368925306967_RK, 0.369021916778_RK, 0.369118364673_RK, 0.369214650693_RK, &
    0.369310774882_RK, 0.36940673728_RK, 0.36950253793_RK, 0.369598176874_RK, &
    0.369693654153_RK, 0.369788969809_RK, 0.369884123883_RK, 0.369979116417_RK, &
    0.370073947452_RK, 0.37016861703_RK, 0.370263125191_RK, 0.370357471977_RK, &
    0.370451657429_RK, 0.370545681587_RK, 0.370639544492_RK, 0.370733246185_RK, &
    0.370826786707_RK, 0.370920166098_RK, 0.371013384399_RK, 0.371106441649_RK, &
    0.37119933789_RK, 0.371292073161_RK, 0.371384647502_RK, 0.371477060953_RK, &
    0.371569313555_RK, 0.371661405347_RK, 0.371753336368_RK, 0.371845106659_RK, &
    0.371936716259_RK, 0.372028165207_RK, 0.372119453543_RK, 0.372210581305_RK, &
    0.372301548534_RK, 0.372392355268_RK, 0.372483001547_RK, 0.372573487408_RK, &
    0.372663812892_RK, 0.372753978036_RK, 0.372843982879_RK, 0.372933827461_RK, &
    0.373023511819_RK, 0.373113035991_RK, 0.373202400017_RK, 0.373291603934_RK, &
    0.373380647781_RK, 0.373469531595_RK, 0.373558255414_RK, 0.373646819277_RK, &
    0.373735223221_RK, 0.373823467284_RK, 0.373911551503_RK, 0.373999475916_RK, &
    0.37408724056_RK, 0.374174845473_RK, 0.374262290692_RK, 0.374349576255_RK, &
    0.374436702197_RK, 0.374523668557_RK, 0.374610475371_RK, 0.374697122676_RK, &
    0.374783610509_RK, 0.374869938907_RK, 0.374956107906_RK, 0.375042117542_RK, &
    0.375127967852_RK, 0.375213658872_RK, 0.37529919064_RK, 0.375384563189_RK, &
    0.375469776558_RK, 0.375554830782_RK, 0.375639725896_RK, 0.375724461937_RK, &
    0.37580903894_RK, 0.375893456941_RK, 0.375977715976_RK, 0.37606181608_RK, &
    0.376145757289_RK, 0.376229539637_RK, 0.37631316316_RK, 0.376396627894_RK, &
    0.376479933873_RK, 0.376563081133_RK, 0.376646069707_RK, 0.376728899632_RK, &
    0.376811570942_RK, 0.376894083671_RK, 0.376976437854_RK, 0.377058633526_RK, &
    0.377140670721_RK, 0.377222549474_RK, 0.377304269818_RK, 0.377385831788_RK, &
    0.377467235419_RK, 0.377548480743_RK, 0.377629567795_RK, 0.377710496609_RK, &
    0.377791267219_RK, 0.377871879658_RK, 0.37795233396_RK, 0.378032630158_RK, &
    0.378112768286_RK, 0.378192748378_RK, 0.378272570466_RK, 0.378352234585_RK, &
    0.378431740766_RK, 0.378511089043_RK, 0.378590279449_RK, 0.378669312017_RK, &
    0.37874818678_RK, 0.378826903771_RK, 0.378905463021_RK, 0.378983864565_RK, &
    0.379062108433_RK, 0.37914019466_RK, 0.379218123276_RK, 0.379295894315_RK, &
    0.379373507808_RK, 0.379450963788_RK, 0.379528262286_RK, 0.379605403335_RK, &
    0.379682386967_RK, 0.379759213212_RK, 0.379835882104_RK, 0.379912393674_RK, &
    0.379988747952_RK, 0.380064944972_RK, 0.380140984763_RK, 0.380216867358_RK, &
    0.380292592787_RK, 0.380368161083_RK, 0.380443572275_RK, 0.380518826396_RK, &
    0.380593923475_RK, 0.380668863545_RK, 0.380743646634_RK, 0.380818272776_RK, &
    0.380892741999_RK, 0.380967054335_RK, 0.381041209813_RK, 0.381115208466_RK, &
    0.381189050322_RK, 0.381262735412_RK, 0.381336263766_RK, 0.381409635414_RK, &
    0.381482850387_RK, 0.381555908715_RK, 0.381628810426_RK, 0.381701555551_RK, &
    0.381774144121_RK, 0.381846576163_RK, 0.381918851709_RK, 0.381990970787_RK, &
    0.382062933426_RK, 0.382134739657_RK, 0.382206389509_RK, 0.38227788301_RK, &
    0.382349220191_RK, 0.382420401079_RK, 0.382491425704_RK, 0.382562294094_RK, &
    0.38263300628_RK, 0.382703562288_RK, 0.382773962149_RK, 0.382844205891_RK, &
    0.382914293541_RK, 0.382984225129_RK, 0.383054000684_RK, 0.383123620232_RK, &
    0.383193083804_RK, 0.383262391426_RK, 0.383331543127_RK, 0.383400538934_RK, &
    0.383469378877_RK, 0.383538062982_RK, 0.383606591278_RK, 0.383674963791_RK, &
    0.383743180551_RK, 0.383811241584_RK, 0.383879146918_RK, 0.383946896581_RK, &
    0.384014490599_RK, 0.384081929_RK, 0.384149211811_RK, 0.38421633906_RK, &
    0.384283310773_RK, 0.384350126978_RK, 0.384416787701_RK, 0.384483292969_RK, &
    0.384549642809_RK, 0.384615837248_RK, 0.384681876312_RK, 0.384747760028_RK, &
    0.384813488423_RK, 0.384879061522_RK, 0.384944479352_RK, 0.38500974194_RK, &
    0.385074849312_RK, 0.385139801493_RK, 0.38520459851_RK, 0.385269240389_RK, &
    0.385333727156_RK, 0.385398058837_RK, 0.385462235457_RK, 0.385526257042_RK, &
    0.385590123617_RK, 0.385653835209_RK, 0.385717391843_RK, 0.385780793545_RK, &
    0.385844040338_RK, 0.38590713225_RK, 0.385970069305_RK, 0.386032851528_RK, &
    0.386095478944_RK, 0.386157951579_RK, 0.386220269457_RK, 0.386282432603_RK, &
    0.386344441042_RK, 0.386406294798_RK, 0.386467993897_RK, 0.386529538363_RK, &
    0.386590928221_RK, 0.386652163494_RK, 0.386713244207_RK, 0.386774170385_RK, &
    0.386834942052_RK, 0.386895559231_RK, 0.386956021948_RK, 0.387016330226_RK, &
    0.387076484089_RK, 0.387136483561_RK, 0.387196328665_RK, 0.387256019426_RK, &
    0.387315555867_RK, 0.387374938013_RK, 0.387434165885_RK, 0.387493239508_RK, &
    0.387552158906_RK, 0.387610924101_RK, 0.387669535118_RK, 0.387727991978_RK, &
    0.387786294705_RK, 0.387844443323_RK, 0.387902437854_RK, 0.387960278321_RK, &
    0.388017964748_RK, 0.388075497156_RK, 0.388132875569_RK, 0.38819010001_RK, &
    0.3882471705_RK, 0.388304087062_RK, 0.38836084972_RK, 0.388417458495_RK, &
    0.388473913409_RK, 0.388530214485_RK, 0.388586361746_RK, 0.388642355212_RK, &
    0.388698194907_RK, 0.388753880852_RK, 0.388809413069_RK, 0.38886479158_RK, &
    0.388920016407_RK, 0.388975087572_RK, 0.389030005096_RK, 0.389084769_RK, &
    0.389139379307_RK, 0.389193836037_RK, 0.389248139213_RK, 0.389302288855_RK, &
    0.389356284985_RK, 0.389410127623_RK, 0.389463816792_RK, 0.389517352512_RK, &
    0.389570734804_RK, 0.389623963688_RK, 0.389677039187_RK, 0.38972996132_RK, &
    0.389782730109_RK, 0.389835345574_RK, 0.389887807735_RK, 0.389940116614_RK, &
    0.38999227223_RK, 0.390044274604_RK, 0.390096123756_RK, 0.390147819707_RK, &
    0.390199362477_RK, 0.390250752086_RK, 0.390301988554_RK, 0.390353071901_RK, &
    0.390404002147_RK, 0.390454779312_RK, 0.390505403415_RK, 0.390555874477_RK, &
    0.390606192517_RK, 0.390656357554_RK, 0.390706369609_RK, 0.390756228701_RK, &
    0.390805934848_RK, 0.390855488072_RK, 0.39090488839_RK, 0.390954135822_RK, &
    0.391003230387_RK, 0.391052172104_RK, 0.391100960993_RK, 0.391149597072_RK, &
    0.391198080361_RK, 0.391246410877_RK, 0.39129458864_RK, 0.391342613669_RK, &
    0.391390485981_RK, 0.391438205597_RK, 0.391485772534_RK, 0.39153318681_RK, &
    0.391580448445_RK, 0.391627557456_RK, 0.391674513861_RK, 0.39172131768_RK, &
    0.39176796893_RK, 0.391814467628_RK, 0.391860813794_RK, 0.391907007445_RK, &
    0.391953048599_RK, 0.391998937274_RK, 0.392044673487_RK, 0.392090257256_RK, &
    0.392135688599_RK, 0.392180967534_RK, 0.392226094077_RK, 0.392271068247_RK, &
    0.392315890061_RK, 0.392360559535_RK, 0.392405076688_RK, 0.392449441536_RK, &
    0.392493654097_RK, 0.392537714388_RK, 0.392581622425_RK, 0.392625378225_RK, &
    0.392668981806_RK, 0.392712433185_RK, 0.392755732377_RK, 0.3927988794_RK, &
    0.392841874271_RK, 0.392884717005_RK, 0.392927407619_RK, 0.392969946131_RK, &
    0.393012332555_RK, 0.393054566909_RK, 0.393096649209_RK, 0.39313857947_RK, &
    0.39318035771_RK, 0.393221983944_RK, 0.393263458188_RK, 0.393304780457_RK, &
    0.393345950769_RK, 0.393386969139_RK, 0.393427835581_RK, 0.393468550113_RK, &
    0.39350911275_RK, 0.393549523507_RK, 0.3935897824_RK, 0.393629889444_RK, &
    0.393669844655_RK, 0.393709648048_RK, 0.393749299638_RK, 0.393788799441_RK, &
    0.393828147471_RK, 0.393867343743_RK, 0.393906388274_RK, 0.393945281077_RK, &
    0.393984022167_RK, 0.39402261156_RK, 0.39406104927_RK, 0.394099335311_RK, &
    0.394137469699_RK, 0.394175452448_RK, 0.394213283572_RK, 0.394250963087_RK, &
    0.394288491006_RK, 0.394325867343_RK, 0.394363092114_RK, 0.394400165331_RK, &
    0.39443708701_RK, 0.394473857165_RK, 0.394510475809_RK, 0.394546942956_RK, &
    0.394583258621_RK, 0.394619422817_RK, 0.394655435558_RK, 0.394691296858_RK, &
    0.39472700673_RK, 0.394762565188_RK, 0.394797972246_RK, 0.394833227916_RK, &
    0.394868332214_RK, 0.394903285151_RK, 0.394938086741_RK, 0.394972736997_RK, &
    0.395007235934_RK, 0.395041583563_RK, 0.395075779897_RK, 0.395109824951_RK, &
    0.395143718736_RK, 0.395177461266_RK, 0.395211052553_RK, 0.39524449261_RK, &
    0.39527778145_RK, 0.395310919086_RK, 0.39534390553_RK, 0.395376740795_RK, &
    0.395409424892_RK, 0.395441957836_RK, 0.395474339637_RK, 0.395506570308_RK, &
    0.395538649862_RK, 0.39557057831_RK, 0.395602355665_RK, 0.395633981938_RK, &
    0.395665457143_RK, 0.39569678129_RK, 0.395727954391_RK, 0.395758976459_RK, &
    0.395789847504_RK, 0.39582056754_RK, 0.395851136577_RK, 0.395881554626_RK, &
    0.395911821701_RK, 0.395941937811_RK, 0.395971902968_RK, 0.396001717184_RK, &
    0.39603138047_RK, 0.396060892837_RK, 0.396090254297_RK, 0.396119464859_RK, &
    0.396148524537_RK, 0.396177433339_RK, 0.396206191278_RK, 0.396234798364_RK, &
    0.396263254608_RK, 0.396291560021_RK, 0.396319714613_RK, 0.396347718395_RK, &
    0.396375571378_RK, 0.396403273572_RK, 0.396430824988_RK, 0.396458225635_RK, &
    0.396485475525_RK, 0.396512574667_RK, 0.396539523072_RK, 0.39656632075_RK, &
    0.396592967711_RK, 0.396619463965_RK, 0.396645809523_RK, 0.396672004393_RK, &
    0.396698048586_RK, 0.396723942111_RK, 0.396749684979_RK, 0.396775277199_RK, &
    0.396800718781_RK, 0.396826009734_RK, 0.396851150068_RK, 0.396876139792_RK, &
    0.396900978915_RK, 0.396925667448_RK, 0.396950205399_RK, 0.396974592777_RK, &
    0.396998829592_RK, 0.397022915853_RK, 0.397046851568_RK, 0.397070636747_RK, &
    0.397094271399_RK, 0.397117755533_RK, 0.397141089157_RK, 0.39716427228_RK, &
    0.39718730491_RK, 0.397210187058_RK, 0.39723291873_RK, 0.397255499936_RK, &
    0.397277930684_RK, 0.397300210983_RK, 0.39732234084_RK, 0.397344320264_RK, &
    0.397366149264_RK, 0.397387827847_RK, 0.397409356022_RK, 0.397430733797_RK, &
    0.397451961179_RK, 0.397473038177_RK, 0.397493964799_RK, 0.397514741051_RK, &
    0.397535366943_RK, 0.397555842482_RK, 0.397576167675_RK, 0.397596342531_RK, &
    0.397616367056_RK, 0.397636241258_RK, 0.397655965145_RK, 0.397675538724_RK, &
    0.397694962001_RK, 0.397714234986_RK, 0.397733357684_RK, 0.397752330103_RK, &
    0.39777115225_RK, 0.397789824132_RK, 0.397808345755_RK, 0.397826717128_RK, &
    0.397844938256_RK, 0.397863009146_RK, 0.397880929806_RK, 0.397898700242_RK, &
    0.39791632046_RK, 0.397933790467_RK, 0.39795111027_RK, 0.397968279875_RK, &
    0.397985299288_RK, 0.398002168517_RK, 0.398018887566_RK, 0.398035456442_RK, &
    0.398051875152_RK, 0.398068143701_RK, 0.398084262096_RK, 0.398100230343_RK, &
    0.398116048447_RK, 0.398131716414_RK, 0.398147234251_RK, 0.398162601962_RK, &
    0.398177819554_RK, 0.398192887033_RK, 0.398207804404_RK, 0.398222571672_RK, &
    0.398237188843_RK, 0.398251655922_RK, 0.398265972915_RK, 0.398280139828_RK, &
    0.398294156664_RK, 0.39830802343_RK, 0.398321740131_RK, 0.398335306771_RK, &
    0.398348723357_RK, 0.398361989891_RK, 0.398375106381_RK, 0.39838807283_RK, &
    0.398400889243_RK, 0.398413555626_RK, 0.398426071982_RK, 0.398438438316_RK, &
    0.398450654634_RK, 0.398462720938_RK, 0.398474637235_RK, 0.398486403528_RK, &
    0.398498019821_RK, 0.39850948612_RK, 0.398520802428_RK, 0.398531968749_RK, &
    0.398542985087_RK, 0.398553851447_RK, 0.398564567832_RK, 0.398575134247_RK, &
    0.398585550695_RK, 0.398595817181_RK, 0.398605933707_RK, 0.398615900278_RK, &
    0.398625716898_RK, 0.398635383569_RK, 0.398644900296_RK, 0.398654267082_RK, &
    0.39866348393_RK, 0.398672550844_RK, 0.398681467827_RK, 0.398690234883_RK, &
    0.398698852014_RK, 0.398707319224_RK, 0.398715636516_RK, 0.398723803893_RK, &
    0.398731821357_RK, 0.398739688913_RK, 0.398747406562_RK, 0.398754974308_RK, &
    0.398762392153_RK, 0.3987696601_RK, 0.398776778152_RK, 0.398783746311_RK, &
    0.398790564579_RK, 0.39879723296_RK, 0.398803751456_RK, 0.398810120068_RK, &
    0.3988163388_RK, 0.398822407654_RK, 0.398828326631_RK, 0.398834095735_RK, &
    0.398839714966_RK, 0.398845184327_RK, 0.39885050382_RK, 0.398855673448_RK, &
    0.39886069321_RK, 0.398865563111_RK, 0.398870283151_RK, 0.398874853332_RK, &
    0.398879273655_RK, 0.398883544123_RK, 0.398887664737_RK, 0.398891635497_RK, &
    0.398895456407_RK, 0.398899127466_RK, 0.398902648676_RK, 0.398906020039_RK, &
    0.398909241556_RK, 0.398912313228_RK, 0.398915235055_RK, 0.398918007039_RK, &
    0.398920629181_RK, 0.398923101482_RK, 0.398925423943_RK, 0.398927596563_RK, &
    0.398929619345_RK, 0.398931492289_RK, 0.398933215395_RK, 0.398934788664_RK, &
    0.398936212097_RK, 0.398937485693_RK, 0.398938609454_RK, 0.398939583379_RK, &
    0.39894040747_RK, 0.398941081725_RK, 0.398941606146_RK, 0.398941980732_RK, &
    0.398942205484_RK, 0.398942280401_RK, 0.398942280401_RK, 0.398942205484_RK, &
    0.398941980732_RK, 0.398941606146_RK, 0.398941081725_RK, 0.39894040747_RK, &
    0.398939583379_RK, 0.398938609454_RK, 0.398937485693_RK, 0.398936212097_RK, &
    0.398934788664_RK, 0.398933215395_RK, 0.398931492289_RK, 0.398929619345_RK, &
    0.398927596563_RK, 0.398925423943_RK, 0.398923101482_RK, 0.398920629181_RK, &
    0.398918007039_RK, 0.398915235055_RK, 0.398912313228_RK, 0.398909241556_RK, &
    0.398906020039_RK, 0.398902648676_RK, 0.398899127466_RK, 0.398895456407_RK, &
    0.398891635497_RK, 0.398887664737_RK, 0.398883544123_RK, 0.398879273655_RK, &
    0.398874853332_RK, 0.398870283151_RK, 0.398865563111_RK, 0.39886069321_RK, &
    0.398855673448_RK, 0.39885050382_RK, 0.398845184327_RK, 0.398839714966_RK, &
    0.398834095735_RK, 0.398828326631_RK, 0.398822407654_RK, 0.3988163388_RK, &
    0.398810120068_RK, 0.398803751456_RK, 0.39879723296_RK, 0.398790564579_RK ]

    real(RK), parameter :: VEC_YU_3(2001:3000) = [ &
    0.398783746311_RK, 0.398776778152_RK, 0.3987696601_RK, 0.398762392153_RK, &
    0.398754974308_RK, 0.398747406562_RK, 0.398739688913_RK, 0.398731821357_RK, &
    0.398723803893_RK, 0.398715636516_RK, 0.398707319224_RK, 0.398698852014_RK, &
    0.398690234883_RK, 0.398681467827_RK, 0.398672550844_RK, 0.39866348393_RK, &
    0.398654267082_RK, 0.398644900296_RK, 0.398635383569_RK, 0.398625716898_RK, &
    0.398615900278_RK, 0.398605933707_RK, 0.398595817181_RK, 0.398585550695_RK, &
    0.398575134247_RK, 0.398564567832_RK, 0.398553851447_RK, 0.398542985087_RK, &
    0.398531968749_RK, 0.398520802428_RK, 0.39850948612_RK, 0.398498019821_RK, &
    0.398486403528_RK, 0.398474637235_RK, 0.398462720938_RK, 0.398450654634_RK, &
    0.398438438316_RK, 0.398426071982_RK, 0.398413555626_RK, 0.398400889243_RK, &
    0.39838807283_RK, 0.398375106381_RK, 0.398361989891_RK, 0.398348723357_RK, &
    0.398335306771_RK, 0.398321740131_RK, 0.39830802343_RK, 0.398294156664_RK, &
    0.398280139828_RK, 0.398265972915_RK, 0.398251655922_RK, 0.398237188843_RK, &
    0.398222571672_RK, 0.398207804404_RK, 0.398192887033_RK, 0.398177819554_RK, &
    0.398162601962_RK, 0.398147234251_RK, 0.398131716414_RK, 0.398116048447_RK, &
    0.398100230343_RK, 0.398084262096_RK, 0.398068143701_RK, 0.398051875152_RK, &
    0.398035456442_RK, 0.398018887566_RK, 0.398002168517_RK, 0.397985299288_RK, &
    0.397968279875_RK, 0.39795111027_RK, 0.397933790467_RK, 0.39791632046_RK, &
    0.397898700242_RK, 0.397880929806_RK, 0.397863009146_RK, 0.397844938256_RK, &
    0.397826717128_RK, 0.397808345755_RK, 0.397789824132_RK, 0.39777115225_RK, &
    0.397752330103_RK, 0.397733357684_RK, 0.397714234986_RK, 0.397694962001_RK, &
    0.397675538724_RK, 0.397655965145_RK, 0.397636241258_RK, 0.397616367056_RK, &
    0.397596342531_RK, 0.397576167675_RK, 0.397555842482_RK, 0.397535366943_RK, &
    0.397514741051_RK, 0.397493964799_RK, 0.397473038177_RK, 0.397451961179_RK, &
    0.397430733797_RK, 0.397409356022_RK, 0.397387827847_RK, 0.397366149264_RK, &
    0.397344320264_RK, 0.39732234084_RK, 0.397300210983_RK, 0.397277930684_RK, &
    0.397255499936_RK, 0.39723291873_RK, 0.397210187058_RK, 0.39718730491_RK, &
    0.39716427228_RK, 0.397141089157_RK, 0.397117755533_RK, 0.397094271399_RK, &
    0.397070636747_RK, 0.397046851568_RK, 0.397022915853_RK, 0.396998829592_RK, &
    0.396974592777_RK, 0.396950205399_RK, 0.396925667448_RK, 0.396900978915_RK, &
    0.396876139792_RK, 0.396851150068_RK, 0.396826009734_RK, 0.396800718781_RK, &
    0.396775277199_RK, 0.396749684979_RK, 0.396723942111_RK, 0.396698048586_RK, &
    0.396672004393_RK, 0.396645809523_RK, 0.396619463965_RK, 0.396592967711_RK, &
    0.39656632075_RK, 0.396539523072_RK, 0.396512574667_RK, 0.396485475525_RK, &
    0.396458225635_RK, 0.396430824988_RK, 0.396403273572_RK, 0.396375571378_RK, &
    0.396347718395_RK, 0.396319714613_RK, 0.396291560021_RK, 0.396263254608_RK, &
    0.396234798364_RK, 0.396206191278_RK, 0.396177433339_RK, 0.396148524537_RK, &
    0.396119464859_RK, 0.396090254297_RK, 0.396060892837_RK, 0.39603138047_RK, &
    0.396001717184_RK, 0.395971902968_RK, 0.395941937811_RK, 0.395911821701_RK, &
    0.395881554626_RK, 0.395851136577_RK, 0.39582056754_RK, 0.395789847504_RK, &
    0.395758976459_RK, 0.395727954391_RK, 0.39569678129_RK, 0.395665457143_RK, &
    0.395633981938_RK, 0.395602355665_RK, 0.39557057831_RK, 0.395538649862_RK, &
    0.395506570308_RK, 0.395474339637_RK, 0.395441957836_RK, 0.395409424892_RK, &
    0.395376740795_RK, 0.39534390553_RK, 0.395310919086_RK, 0.39527778145_RK, &
    0.39524449261_RK, 0.395211052553_RK, 0.395177461266_RK, 0.395143718736_RK, &
    0.395109824951_RK, 0.395075779897_RK, 0.395041583563_RK, 0.395007235934_RK, &
    0.394972736997_RK, 0.394938086741_RK, 0.394903285151_RK, 0.394868332214_RK, &
    0.394833227916_RK, 0.394797972246_RK, 0.394762565188_RK, 0.39472700673_RK, &
    0.394691296858_RK, 0.394655435558_RK, 0.394619422817_RK, 0.394583258621_RK, &
    0.394546942956_RK, 0.394510475809_RK, 0.394473857165_RK, 0.39443708701_RK, &
    0.394400165331_RK, 0.394363092114_RK, 0.394325867343_RK, 0.394288491006_RK, &
    0.394250963087_RK, 0.394213283572_RK, 0.394175452448_RK, 0.394137469699_RK, &
    0.394099335311_RK, 0.39406104927_RK, 0.39402261156_RK, 0.393984022167_RK, &
    0.393945281077_RK, 0.393906388274_RK, 0.393867343743_RK, 0.393828147471_RK, &
    0.393788799441_RK, 0.393749299638_RK, 0.393709648048_RK, 0.393669844655_RK, &
    0.393629889444_RK, 0.3935897824_RK, 0.393549523507_RK, 0.39350911275_RK, &
    0.393468550113_RK, 0.393427835581_RK, 0.393386969139_RK, 0.393345950769_RK, &
    0.393304780457_RK, 0.393263458188_RK, 0.393221983944_RK, 0.39318035771_RK, &
    0.39313857947_RK, 0.393096649209_RK, 0.393054566909_RK, 0.393012332555_RK, &
    0.392969946131_RK, 0.392927407619_RK, 0.392884717005_RK, 0.392841874271_RK, &
    0.3927988794_RK, 0.392755732377_RK, 0.392712433185_RK, 0.392668981806_RK, &
    0.392625378225_RK, 0.392581622425_RK, 0.392537714388_RK, 0.392493654097_RK, &
    0.392449441536_RK, 0.392405076688_RK, 0.392360559535_RK, 0.392315890061_RK, &
    0.392271068247_RK, 0.392226094077_RK, 0.392180967534_RK, 0.392135688599_RK, &
    0.392090257256_RK, 0.392044673487_RK, 0.391998937274_RK, 0.391953048599_RK, &
    0.391907007445_RK, 0.391860813794_RK, 0.391814467628_RK, 0.39176796893_RK, &
    0.39172131768_RK, 0.391674513861_RK, 0.391627557456_RK, 0.391580448445_RK, &
    0.39153318681_RK, 0.391485772534_RK, 0.391438205597_RK, 0.391390485981_RK, &
    0.391342613669_RK, 0.39129458864_RK, 0.391246410877_RK, 0.391198080361_RK, &
    0.391149597072_RK, 0.391100960993_RK, 0.391052172104_RK, 0.391003230387_RK, &
    0.390954135822_RK, 0.39090488839_RK, 0.390855488072_RK, 0.390805934848_RK, &
    0.390756228701_RK, 0.390706369609_RK, 0.390656357554_RK, 0.390606192517_RK, &
    0.390555874477_RK, 0.390505403415_RK, 0.390454779312_RK, 0.390404002147_RK, &
    0.390353071901_RK, 0.390301988554_RK, 0.390250752086_RK, 0.390199362477_RK, &
    0.390147819707_RK, 0.390096123756_RK, 0.390044274604_RK, 0.38999227223_RK, &
    0.389940116614_RK, 0.389887807735_RK, 0.389835345574_RK, 0.389782730109_RK, &
    0.38972996132_RK, 0.389677039187_RK, 0.389623963688_RK, 0.389570734804_RK, &
    0.389517352512_RK, 0.389463816792_RK, 0.389410127623_RK, 0.389356284985_RK, &
    0.389302288855_RK, 0.389248139213_RK, 0.389193836037_RK, 0.389139379307_RK, &
    0.389084769_RK, 0.389030005096_RK, 0.388975087572_RK, 0.388920016407_RK, &
    0.38886479158_RK, 0.388809413069_RK, 0.388753880852_RK, 0.388698194907_RK, &
    0.388642355212_RK, 0.388586361746_RK, 0.388530214485_RK, 0.388473913409_RK, &
    0.388417458495_RK, 0.38836084972_RK, 0.388304087062_RK, 0.3882471705_RK, &
    0.38819010001_RK, 0.388132875569_RK, 0.388075497156_RK, 0.388017964748_RK, &
    0.387960278321_RK, 0.387902437854_RK, 0.387844443323_RK, 0.387786294705_RK, &
    0.387727991978_RK, 0.387669535118_RK, 0.387610924101_RK, 0.387552158906_RK, &
    0.387493239508_RK, 0.387434165885_RK, 0.387374938013_RK, 0.387315555867_RK, &
    0.387256019426_RK, 0.387196328665_RK, 0.387136483561_RK, 0.387076484089_RK, &
    0.387016330226_RK, 0.386956021948_RK, 0.386895559231_RK, 0.386834942052_RK, &
    0.386774170385_RK, 0.386713244207_RK, 0.386652163494_RK, 0.386590928221_RK, &
    0.386529538363_RK, 0.386467993897_RK, 0.386406294798_RK, 0.386344441042_RK, &
    0.386282432603_RK, 0.386220269457_RK, 0.386157951579_RK, 0.386095478944_RK, &
    0.386032851528_RK, 0.385970069305_RK, 0.38590713225_RK, 0.385844040338_RK, &
    0.385780793545_RK, 0.385717391843_RK, 0.385653835209_RK, 0.385590123617_RK, &
    0.385526257042_RK, 0.385462235457_RK, 0.385398058837_RK, 0.385333727156_RK, &
    0.385269240389_RK, 0.38520459851_RK, 0.385139801493_RK, 0.385074849312_RK, &
    0.38500974194_RK, 0.384944479352_RK, 0.384879061522_RK, 0.384813488423_RK, &
    0.384747760028_RK, 0.384681876312_RK, 0.384615837248_RK, 0.384549642809_RK, &
    0.384483292969_RK, 0.384416787701_RK, 0.384350126978_RK, 0.384283310773_RK, &
    0.38421633906_RK, 0.384149211811_RK, 0.384081929_RK, 0.384014490599_RK, &
    0.383946896581_RK, 0.383879146918_RK, 0.383811241584_RK, 0.383743180551_RK, &
    0.383674963791_RK, 0.383606591278_RK, 0.383538062982_RK, 0.383469378877_RK, &
    0.383400538934_RK, 0.383331543127_RK, 0.383262391426_RK, 0.383193083804_RK, &
    0.383123620232_RK, 0.383054000684_RK, 0.382984225129_RK, 0.382914293541_RK, &
    0.382844205891_RK, 0.382773962149_RK, 0.382703562288_RK, 0.38263300628_RK, &
    0.382562294094_RK, 0.382491425704_RK, 0.382420401079_RK, 0.382349220191_RK, &
    0.38227788301_RK, 0.382206389509_RK, 0.382134739657_RK, 0.382062933426_RK, &
    0.381990970787_RK, 0.381918851709_RK, 0.381846576163_RK, 0.381774144121_RK, &
    0.381701555551_RK, 0.381628810426_RK, 0.381555908715_RK, 0.381482850387_RK, &
    0.381409635414_RK, 0.381336263766_RK, 0.381262735412_RK, 0.381189050322_RK, &
    0.381115208466_RK, 0.381041209813_RK, 0.380967054335_RK, 0.380892741999_RK, &
    0.380818272776_RK, 0.380743646634_RK, 0.380668863545_RK, 0.380593923475_RK, &
    0.380518826396_RK, 0.380443572275_RK, 0.380368161083_RK, 0.380292592787_RK, &
    0.380216867358_RK, 0.380140984763_RK, 0.380064944972_RK, 0.379988747952_RK, &
    0.379912393674_RK, 0.379835882104_RK, 0.379759213212_RK, 0.379682386967_RK, &
    0.379605403335_RK, 0.379528262286_RK, 0.379450963788_RK, 0.379373507808_RK, &
    0.379295894315_RK, 0.379218123276_RK, 0.37914019466_RK, 0.379062108433_RK, &
    0.378983864565_RK, 0.378905463021_RK, 0.378826903771_RK, 0.37874818678_RK, &
    0.378669312017_RK, 0.378590279449_RK, 0.378511089043_RK, 0.378431740766_RK, &
    0.378352234585_RK, 0.378272570466_RK, 0.378192748378_RK, 0.378112768286_RK, &
    0.378032630158_RK, 0.37795233396_RK, 0.377871879658_RK, 0.377791267219_RK, &
    0.377710496609_RK, 0.377629567795_RK, 0.377548480743_RK, 0.377467235419_RK, &
    0.377385831788_RK, 0.377304269818_RK, 0.377222549474_RK, 0.377140670721_RK, &
    0.377058633526_RK, 0.376976437854_RK, 0.376894083671_RK, 0.376811570942_RK, &
    0.376728899632_RK, 0.376646069707_RK, 0.376563081133_RK, 0.376479933873_RK, &
    0.376396627894_RK, 0.37631316316_RK, 0.376229539637_RK, 0.376145757289_RK, &
    0.37606181608_RK, 0.375977715976_RK, 0.375893456941_RK, 0.37580903894_RK, &
    0.375724461937_RK, 0.375639725896_RK, 0.375554830782_RK, 0.375469776558_RK, &
    0.375384563189_RK, 0.37529919064_RK, 0.375213658872_RK, 0.375127967852_RK, &
    0.375042117542_RK, 0.374956107906_RK, 0.374869938907_RK, 0.374783610509_RK, &
    0.374697122676_RK, 0.374610475371_RK, 0.374523668557_RK, 0.374436702197_RK, &
    0.374349576255_RK, 0.374262290692_RK, 0.374174845473_RK, 0.37408724056_RK, &
    0.373999475916_RK, 0.373911551503_RK, 0.373823467284_RK, 0.373735223221_RK, &
    0.373646819277_RK, 0.373558255414_RK, 0.373469531595_RK, 0.373380647781_RK, &
    0.373291603934_RK, 0.373202400017_RK, 0.373113035991_RK, 0.373023511819_RK, &
    0.372933827461_RK, 0.372843982879_RK, 0.372753978036_RK, 0.372663812892_RK, &
    0.372573487408_RK, 0.372483001547_RK, 0.372392355268_RK, 0.372301548534_RK, &
    0.372210581305_RK, 0.372119453543_RK, 0.372028165207_RK, 0.371936716259_RK, &
    0.371845106659_RK, 0.371753336368_RK, 0.371661405347_RK, 0.371569313555_RK, &
    0.371477060953_RK, 0.371384647502_RK, 0.371292073161_RK, 0.37119933789_RK, &
    0.371106441649_RK, 0.371013384399_RK, 0.370920166098_RK, 0.370826786707_RK, &
    0.370733246185_RK, 0.370639544492_RK, 0.370545681587_RK, 0.370451657429_RK, &
    0.370357471977_RK, 0.370263125191_RK, 0.37016861703_RK, 0.370073947452_RK, &
    0.369979116417_RK, 0.369884123883_RK, 0.369788969809_RK, 0.369693654153_RK, &
    0.369598176874_RK, 0.36950253793_RK, 0.36940673728_RK, 0.369310774882_RK, &
    0.369214650693_RK, 0.369118364673_RK, 0.369021916778_RK, 0.368925306967_RK, &
    0.368828535197_RK, 0.368731601427_RK, 0.368634505613_RK, 0.368537247713_RK, &
    0.368439827684_RK, 0.368342245484_RK, 0.36824450107_RK, 0.368146594399_RK, &
    0.368048525428_RK, 0.367950294114_RK, 0.367851900414_RK, 0.367753344284_RK, &
    0.36765462568_RK, 0.367555744561_RK, 0.367456700881_RK, 0.367357494598_RK, &
    0.367258125667_RK, 0.367158594044_RK, 0.367058899687_RK, 0.36695904255_RK, &
    0.366859022589_RK, 0.366758839761_RK, 0.36665849402_RK, 0.366557985323_RK, &
    0.366457313625_RK, 0.366356478881_RK, 0.366255481046_RK, 0.366154320077_RK, &
    0.366052995927_RK, 0.365951508551_RK, 0.365849857906_RK, 0.365748043945_RK, &
    0.365646066623_RK, 0.365543925894_RK, 0.365441621714_RK, 0.365339154037_RK, &
    0.365236522816_RK, 0.365133728007_RK, 0.365030769562_RK, 0.364927647437_RK, &
    0.364824361585_RK, 0.364720911959_RK, 0.364617298515_RK, 0.364513521204_RK, &
    0.364409579981_RK, 0.364305474799_RK, 0.364201205612_RK, 0.364096772372_RK, &
    0.363992175032_RK, 0.363887413546_RK, 0.363782487867_RK, 0.363677397947_RK, &
    0.36357214374_RK, 0.363466725196_RK, 0.36336114227_RK, 0.363255394914_RK, &
    0.363149483079_RK, 0.363043406718_RK, 0.362937165783_RK, 0.362830760226_RK, &
    0.36272419_RK, 0.362617455054_RK, 0.362510555343_RK, 0.362403490816_RK, &
    0.362296261425_RK, 0.362188867123_RK, 0.362081307859_RK, 0.361973583586_RK, &
    0.361865694253_RK, 0.361757639813_RK, 0.361649420216_RK, 0.361541035413_RK, &
    0.361432485354_RK, 0.36132376999_RK, 0.361214889271_RK, 0.361105843148_RK, &
    0.360996631571_RK, 0.360887254489_RK, 0.360777711854_RK, 0.360668003615_RK, &
    0.360558129721_RK, 0.360448090122_RK, 0.360337884769_RK, 0.36022751361_RK, &
    0.360116976594_RK, 0.360006273672_RK, 0.359895404792_RK, 0.359784369903_RK, &
    0.359673168954_RK, 0.359561801893_RK, 0.359450268671_RK, 0.359338569235_RK, &
    0.359226703533_RK, 0.359114671515_RK, 0.359002473128_RK, 0.358890108321_RK, &
    0.358777577041_RK, 0.358664879237_RK, 0.358552014857_RK, 0.358438983847_RK, &
    0.358325786157_RK, 0.358212421732_RK, 0.358098890522_RK, 0.357985192472_RK, &
    0.357871327531_RK, 0.357757295645_RK, 0.357643096761_RK, 0.357528730826_RK, &
    0.357414197787_RK, 0.35729949759_RK, 0.357184630183_RK, 0.35706959551_RK, &
    0.356954393519_RK, 0.356839024156_RK, 0.356723487367_RK, 0.356607783098_RK, &
    0.356491911294_RK, 0.356375871902_RK, 0.356259664866_RK, 0.356143290133_RK, &
    0.356026747648_RK, 0.355910037356_RK, 0.355793159202_RK, 0.355676113131_RK, &
    0.355558899089_RK, 0.355441517019_RK, 0.355323966867_RK, 0.355206248577_RK, &
    0.355088362094_RK, 0.354970307363_RK, 0.354852084326_RK, 0.354733692928_RK, &
    0.354615133114_RK, 0.354496404828_RK, 0.354377508012_RK, 0.35425844261_RK, &
    0.354139208567_RK, 0.354019805826_RK, 0.353900234329_RK, 0.35378049402_RK, &
    0.353660584842_RK, 0.353540506738_RK, 0.353420259651_RK, 0.353299843523_RK, &
    0.353179258297_RK, 0.353058503916_RK, 0.352937580322_RK, 0.352816487456_RK, &
    0.352695225262_RK, 0.35257379368_RK, 0.352452192653_RK, 0.352330422124_RK, &
    0.352208482032_RK, 0.35208637232_RK, 0.351964092929_RK, 0.3518416438_RK, &
    0.351719024875_RK, 0.351596236094_RK, 0.351473277398_RK, 0.351350148728_RK, &
    0.351226850025_RK, 0.351103381229_RK, 0.350979742281_RK, 0.35085593312_RK, &
    0.350731953687_RK, 0.350607803923_RK, 0.350483483765_RK, 0.350358993156_RK, &
    0.350234332033_RK, 0.350109500337_RK, 0.349984498007_RK, 0.349859324983_RK, &
    0.349733981203_RK, 0.349608466606_RK, 0.349482781131_RK, 0.349356924717_RK, &
    0.349230897303_RK, 0.349104698827_RK, 0.348978329228_RK, 0.348851788443_RK, &
    0.348725076411_RK, 0.348598193069_RK, 0.348471138357_RK, 0.34834391221_RK, &
    0.348216514568_RK, 0.348088945366_RK, 0.347961204544_RK, 0.347833292037_RK, &
    0.347705207784_RK, 0.34757695172_RK, 0.347448523782_RK, 0.347319923909_RK, &
    0.347191152035_RK, 0.347062208097_RK, 0.346933092032_RK, 0.346803803775_RK, &
    0.346674343264_RK, 0.346544710432_RK, 0.346414905218_RK, 0.346284927555_RK, &
    0.346154777379_RK, 0.346024454627_RK, 0.345893959232_RK, 0.34576329113_RK, &
    0.345632450257_RK, 0.345501436546_RK, 0.345370249932_RK, 0.345238890351_RK, &
    0.345107357736_RK, 0.344975652022_RK, 0.344843773142_RK, 0.344711721031_RK, &
    0.344579495623_RK, 0.344447096851_RK, 0.344314524649_RK, 0.344181778951_RK, &
    0.344048859689_RK, 0.343915766796_RK, 0.343782500207_RK, 0.343649059853_RK, &
    0.343515445668_RK, 0.343381657583_RK, 0.343247695533_RK, 0.343113559448_RK, &
    0.342979249261_RK, 0.342844764904_RK, 0.342710106308_RK, 0.342575273407_RK, &
    0.342440266131_RK, 0.342305084412_RK, 0.34216972818_RK, 0.342034197368_RK, &
    0.341898491907_RK, 0.341762611726_RK, 0.341626556758_RK, 0.341490326932_RK, &
    0.341353922179_RK, 0.34121734243_RK, 0.341080587614_RK, 0.340943657662_RK, &
    0.340806552503_RK, 0.340669272067_RK, 0.340531816284_RK, 0.340394185084_RK, &
    0.340256378395_RK, 0.340118396147_RK, 0.339980238268_RK, 0.339841904688_RK, &
    0.339703395335_RK, 0.339564710138_RK, 0.339425849025_RK, 0.339286811925_RK, &
    0.339147598766_RK, 0.339008209475_RK, 0.33886864398_RK, 0.33872890221_RK, &
    0.338588984091_RK, 0.33844888955_RK, 0.338308618517_RK, 0.338168170916_RK, &
    0.338027546675_RK, 0.337886745721_RK, 0.337745767981_RK, 0.33760461338_RK, &
    0.337463281846_RK, 0.337321773304_RK, 0.33718008768_RK, 0.3370382249_RK, &
    0.336896184891_RK, 0.336753967576_RK, 0.336611572882_RK, 0.336469000734_RK, &
    0.336326251057_RK, 0.336183323776_RK, 0.336040218815_RK, 0.335896936099_RK, &
    0.335753475553_RK, 0.335609837101_RK, 0.335466020667_RK, 0.335322026174_RK, &
    0.335177853547_RK, 0.33503350271_RK, 0.334888973585_RK, 0.334744266096_RK, &
    0.334599380166_RK, 0.334454315719_RK, 0.334309072676_RK, 0.334163650961_RK, &
    0.334018050496_RK, 0.333872271204_RK, 0.333726313006_RK, 0.333580175825_RK, &
    0.333433859582_RK, 0.3332873642_RK, 0.333140689599_RK, 0.332993835701_RK, &
    0.332846802427_RK, 0.332699589699_RK, 0.332552197437_RK, 0.332404625561_RK, &
    0.332256873993_RK, 0.332108942652_RK, 0.331960831459_RK, 0.331812540334_RK, &
    0.331664069197_RK, 0.331515417967_RK, 0.331366586564_RK, 0.331217574907_RK, &
    0.331068382916_RK, 0.330919010508_RK, 0.330769457604_RK, 0.330619724122_RK, &
    0.33046980998_RK, 0.330319715097_RK, 0.330169439391_RK, 0.330018982779_RK, &
    0.32986834518_RK, 0.329717526511_RK, 0.32956652669_RK, 0.329415345633_RK, &
    0.329263983259_RK, 0.329112439483_RK, 0.328960714223_RK, 0.328808807396_RK, &
    0.328656718917_RK, 0.328504448702_RK, 0.328351996669_RK, 0.328199362732_RK, &
    0.328046546808_RK, 0.327893548812_RK, 0.327740368658_RK, 0.327587006263_RK, &
    0.327433461542_RK, 0.327279734408_RK, 0.327125824778_RK, 0.326971732564_RK, &
    0.326817457682_RK, 0.326663000045_RK, 0.326508359567_RK, 0.326353536163_RK, &
    0.326198529745_RK, 0.326043340226_RK, 0.325887967521_RK, 0.325732411541_RK, &
    0.3255766722_RK, 0.325420749411_RK, 0.325264643085_RK, 0.325108353134_RK, &
    0.324951879472_RK, 0.324795222009_RK, 0.324638380658_RK, 0.324481355329_RK, &
    0.324324145934_RK, 0.324166752385_RK, 0.324009174591_RK, 0.323851412464_RK, &
    0.323693465915_RK, 0.323535334852_RK, 0.323377019188_RK, 0.323218518831_RK, &
    0.323059833691_RK, 0.322900963677_RK, 0.322741908701_RK, 0.322582668669_RK, &
    0.322423243491_RK, 0.322263633077_RK, 0.322103837334_RK, 0.321943856171_RK, &
    0.321783689496_RK, 0.321623337217_RK, 0.321462799242_RK, 0.321302075479_RK, &
    0.321141165834_RK, 0.320980070215_RK, 0.320818788529_RK, 0.320657320683_RK, &
    0.320495666583_RK, 0.320333826135_RK, 0.320171799247_RK, 0.320009585823_RK, &
    0.31984718577_RK, 0.319684598993_RK, 0.319521825397_RK, 0.319358864888_RK, &
    0.31919571737_RK, 0.319032382749_RK, 0.318868860929_RK, 0.318705151813_RK, &
    0.318541255307_RK, 0.318377171315_RK, 0.318212899739_RK, 0.318048440483_RK, &
    0.317883793451_RK, 0.317718958546_RK, 0.31755393567_RK, 0.317388724726_RK, &
    0.317223325617_RK, 0.317057738245_RK, 0.316891962512_RK, 0.31672599832_RK, &
    0.31655984557_RK, 0.316393504163_RK, 0.316226974001_RK, 0.316060254985_RK, &
    0.315893347016_RK, 0.315726249993_RK, 0.315558963818_RK, 0.31539148839_RK, &
    0.315223823609_RK, 0.315055969374_RK, 0.314887925586_RK, 0.314719692144_RK, &
    0.314551268945_RK, 0.31438265589_RK, 0.314213852877_RK, 0.314044859803_RK ]

    real(RK), parameter :: VEC_YU_4(3001:LEN_VEC_YU) = [ &
    0.313875676567_RK, 0.313706303067_RK, 0.313536739201_RK, 0.313366984865_RK, &
    0.313197039958_RK, 0.313026904375_RK, 0.312856578014_RK, 0.312686060772_RK, &
    0.312515352544_RK, 0.312344453226_RK, 0.312173362715_RK, 0.312002080905_RK, &
    0.311830607693_RK, 0.311658942973_RK, 0.31148708664_RK, 0.31131503859_RK, &
    0.311142798715_RK, 0.310970366911_RK, 0.310797743071_RK, 0.31062492709_RK, &
    0.31045191886_RK, 0.310278718275_RK, 0.310105325228_RK, 0.309931739611_RK, &
    0.309757961317_RK, 0.309583990239_RK, 0.309409826268_RK, 0.309235469297_RK, &
    0.309060919216_RK, 0.308886175918_RK, 0.308711239292_RK, 0.308536109231_RK, &
    0.308360785624_RK, 0.308185268362_RK, 0.308009557336_RK, 0.307833652434_RK, &
    0.307657553547_RK, 0.307481260563_RK, 0.307304773373_RK, 0.307128091864_RK, &
    0.306951215926_RK, 0.306774145446_RK, 0.306596880314_RK, 0.306419420416_RK, &
    0.306241765641_RK, 0.306063915875_RK, 0.305885871006_RK, 0.305707630921_RK, &
    0.305529195506_RK, 0.305350564647_RK, 0.305171738232_RK, 0.304992716144_RK, &
    0.304813498271_RK, 0.304634084497_RK, 0.304454474707_RK, 0.304274668786_RK, &
    0.304094666619_RK, 0.30391446809_RK, 0.303734073083_RK, 0.303553481481_RK, &
    0.303372693168_RK, 0.303191708028_RK, 0.303010525942_RK, 0.302829146795_RK, &
    0.302647570468_RK, 0.302465796843_RK, 0.302283825802_RK, 0.302101657227_RK, &
    0.301919290999_RK, 0.301736726999_RK, 0.301553965108_RK, 0.301371005207_RK, &
    0.301187847175_RK, 0.301004490893_RK, 0.30082093624_RK, 0.300637183096_RK, &
    0.300453231339_RK, 0.30026908085_RK, 0.300084731505_RK, 0.299900183184_RK, &
    0.299715435764_RK, 0.299530489123_RK, 0.299345343139_RK, 0.299159997689_RK, &
    0.298974452649_RK, 0.298788707897_RK, 0.298602763308_RK, 0.298416618759_RK, &
    0.298230274125_RK, 0.298043729282_RK, 0.297856984104_RK, 0.297670038468_RK, &
    0.297482892246_RK, 0.297295545315_RK, 0.297107997546_RK, 0.296920248815_RK, &
    0.296732298995_RK, 0.296544147958_RK, 0.296355795578_RK, 0.296167241727_RK, &
    0.295978486277_RK, 0.295789529101_RK, 0.295600370069_RK, 0.295411009053_RK, &
    0.295221445924_RK, 0.295031680553_RK, 0.294841712811_RK, 0.294651542566_RK, &
    0.29446116969_RK, 0.294270594051_RK, 0.294079815519_RK, 0.293888833963_RK, &
    0.293697649251_RK, 0.293506261251_RK, 0.293314669832_RK, 0.29312287486_RK, &
    0.292930876204_RK, 0.292738673731_RK, 0.292546267306_RK, 0.292353656796_RK, &
    0.292160842068_RK, 0.291967822987_RK, 0.291774599419_RK, 0.291581171228_RK, &
    0.29138753828_RK, 0.291193700439_RK, 0.290999657568_RK, 0.290805409533_RK, &
    0.290610956195_RK, 0.290416297419_RK, 0.290221433068_RK, 0.290026363003_RK, &
    0.289831087087_RK, 0.289635605182_RK, 0.289439917148_RK, 0.289244022849_RK, &
    0.289047922144_RK, 0.288851614893_RK, 0.288655100957_RK, 0.288458380196_RK, &
    0.28826145247_RK, 0.288064317636_RK, 0.287866975555_RK, 0.287669426085_RK, &
    0.287471669084_RK, 0.287273704409_RK, 0.287075531918_RK, 0.286877151468_RK, &
    0.286678562916_RK, 0.286479766119_RK, 0.286280760932_RK, 0.286081547211_RK, &
    0.285882124811_RK, 0.285682493588_RK, 0.285482653395_RK, 0.285282604088_RK, &
    0.285082345521_RK, 0.284881877546_RK, 0.284681200017_RK, 0.284480312788_RK, &
    0.284279215709_RK, 0.284077908635_RK, 0.283876391415_RK, 0.283674663903_RK, &
    0.283472725948_RK, 0.283270577402_RK, 0.283068218114_RK, 0.282865647935_RK, &
    0.282662866715_RK, 0.282459874302_RK, 0.282256670545_RK, 0.282053255293_RK, &
    0.281849628394_RK, 0.281645789695_RK, 0.281441739045_RK, 0.281237476289_RK, &
    0.281033001275_RK, 0.280828313848_RK, 0.280623413854_RK, 0.280418301139_RK, &
    0.280212975549_RK, 0.280007436926_RK, 0.279801685116_RK, 0.279595719963_RK, &
    0.27938954131_RK, 0.279183149_RK, 0.278976542875_RK, 0.278769722779_RK, &
    0.278562688553_RK, 0.278355440038_RK, 0.278147977076_RK, 0.277940299507_RK, &
    0.277732407172_RK, 0.27752429991_RK, 0.277315977561_RK, 0.277107439965_RK, &
    0.276898686958_RK, 0.276689718381_RK, 0.276480534071_RK, 0.276271133865_RK, &
    0.2760615176_RK, 0.275851685114_RK, 0.275641636241_RK, 0.275431370818_RK, &
    0.275220888681_RK, 0.275010189664_RK, 0.274799273601_RK, 0.274588140328_RK, &
    0.274376789677_RK, 0.274165221481_RK, 0.273953435575_RK, 0.273741431789_RK, &
    0.273529209956_RK, 0.273316769908_RK, 0.273104111476_RK, 0.272891234489_RK, &
    0.272678138779_RK, 0.272464824175_RK, 0.272251290507_RK, 0.272037537604_RK, &
    0.271823565293_RK, 0.271609373403_RK, 0.271394961762_RK, 0.271180330196_RK, &
    0.270965478533_RK, 0.270750406598_RK, 0.270535114218_RK, 0.270319601217_RK, &
    0.270103867421_RK, 0.269887912653_RK, 0.269671736739_RK, 0.2694553395_RK, &
    0.269238720761_RK, 0.269021880344_RK, 0.268804818071_RK, 0.268587533763_RK, &
    0.268370027242_RK, 0.268152298328_RK, 0.267934346842_RK, 0.267716172603_RK, &
    0.26749777543_RK, 0.267279155143_RK, 0.26706031156_RK, 0.266841244498_RK, &
    0.266621953774_RK, 0.266402439207_RK, 0.266182700611_RK, 0.265962737803_RK, &
    0.265742550598_RK, 0.265522138811_RK, 0.265301502256_RK, 0.265080640748_RK, &
    0.2648595541_RK, 0.264638242124_RK, 0.264416704633_RK, 0.264194941439_RK, &
    0.263972952353_RK, 0.263750737186_RK, 0.263528295749_RK, 0.263305627851_RK, &
    0.263082733302_RK, 0.26285961191_RK, 0.262636263484_RK, 0.262412687831_RK, &
    0.26218888476_RK, 0.261964854076_RK, 0.261740595585_RK, 0.261516109095_RK, &
    0.261291394408_RK, 0.261066451331_RK, 0.260841279668_RK, 0.260615879221_RK, &
    0.260390249794_RK, 0.260164391189_RK, 0.259938303209_RK, 0.259711985655_RK, &
    0.259485438327_RK, 0.259258661026_RK, 0.259031653551_RK, 0.258804415703_RK, &
    0.258576947278_RK, 0.258349248077_RK, 0.258121317895_RK, 0.25789315653_RK, &
    0.257664763779_RK, 0.257436139437_RK, 0.2572072833_RK, 0.256978195162_RK, &
    0.256748874817_RK, 0.256519322059_RK, 0.256289536681_RK, 0.256059518475_RK, &
    0.255829267233_RK, 0.255598782747_RK, 0.255368064807_RK, 0.255137113202_RK, &
    0.254905927723_RK, 0.254674508159_RK, 0.254442854297_RK, 0.254210965925_RK, &
    0.253978842831_RK, 0.253746484801_RK, 0.253513891621_RK, 0.253281063075_RK, &
    0.253047998949_RK, 0.252814699027_RK, 0.252581163092_RK, 0.252347390927_RK, &
    0.252113382314_RK, 0.251879137035_RK, 0.251644654871_RK, 0.251409935601_RK, &
    0.251174979007_RK, 0.250939784865_RK, 0.250704352956_RK, 0.250468683057_RK, &
    0.250232774945_RK, 0.249996628397_RK, 0.249760243188_RK, 0.249523619094_RK, &
    0.249286755888_RK, 0.249049653346_RK, 0.24881231124_RK, 0.248574729343_RK, &
    0.248336907427_RK, 0.248098845263_RK, 0.247860542621_RK, 0.247621999273_RK, &
    0.247383214985_RK, 0.247144189529_RK, 0.24690492267_RK, 0.246665414177_RK, &
    0.246425663816_RK, 0.246185671353_RK, 0.245945436553_RK, 0.24570495918_RK, &
    0.245464238999_RK, 0.245223275772_RK, 0.244982069261_RK, 0.244740619229_RK, &
    0.244498925435_RK, 0.244256987642_RK, 0.244014805607_RK, 0.24377237909_RK, &
    0.243529707849_RK, 0.243286791641_RK, 0.243043630222_RK, 0.24280022335_RK, &
    0.242556570778_RK, 0.242312672262_RK, 0.242068527555_RK, 0.241824136409_RK, &
    0.241579498578_RK, 0.241334613813_RK, 0.241089481863_RK, 0.240844102481_RK, &
    0.240598475413_RK, 0.240352600409_RK, 0.240106477217_RK, 0.239860105583_RK, &
    0.239613485254_RK, 0.239366615975_RK, 0.23911949749_RK, 0.238872129544_RK, &
    0.238624511878_RK, 0.238376644236_RK, 0.238128526359_RK, 0.237880157987_RK, &
    0.237631538861_RK, 0.237382668719_RK, 0.2371335473_RK, 0.23688417434_RK, &
    0.236634549577_RK, 0.236384672746_RK, 0.236134543582_RK, 0.23588416182_RK, &
    0.235633527192_RK, 0.235382639431_RK, 0.235131498268_RK, 0.234880103436_RK, &
    0.234628454662_RK, 0.234376551677_RK, 0.234124394209_RK, 0.233871981984_RK, &
    0.233619314731_RK, 0.233366392173_RK, 0.233113214036_RK, 0.232859780045_RK, &
    0.232606089921_RK, 0.232352143387_RK, 0.232097940164_RK, 0.231843479974_RK, &
    0.231588762534_RK, 0.231333787564_RK, 0.231078554782_RK, 0.230823063904_RK, &
    0.230567314646_RK, 0.230311306723_RK, 0.23005503985_RK, 0.229798513738_RK, &
    0.229541728101_RK, 0.22928468265_RK, 0.229027377095_RK, 0.228769811145_RK, &
    0.22851198451_RK, 0.228253896895_RK, 0.227995548009_RK, 0.227736937556_RK, &
    0.227478065241_RK, 0.227218930768_RK, 0.22695953384_RK, 0.226699874157_RK, &
    0.226439951422_RK, 0.226179765333_RK, 0.22591931559_RK, 0.22565860189_RK, &
    0.22539762393_RK, 0.225136381406_RK, 0.224874874012_RK, 0.224613101442_RK, &
    0.224351063389_RK, 0.224088759545_RK, 0.2238261896_RK, 0.223563353244_RK, &
    0.223300250165_RK, 0.223036880051_RK, 0.222773242589_RK, 0.222509337463_RK, &
    0.222245164359_RK, 0.22198072296_RK, 0.221716012947_RK, 0.221451034002_RK, &
    0.221185785805_RK, 0.220920268035_RK, 0.220654480371_RK, 0.220388422488_RK, &
    0.220122094062_RK, 0.219855494768_RK, 0.21958862428_RK, 0.21932148227_RK, &
    0.219054068409_RK, 0.218786382367_RK, 0.218518423813_RK, 0.218250192415_RK, &
    0.21798168784_RK, 0.217712909752_RK, 0.217443857818_RK, 0.217174531699_RK, &
    0.216904931057_RK, 0.216635055555_RK, 0.21636490485_RK, 0.216094478602_RK, &
    0.215823776468_RK, 0.215552798104_RK, 0.215281543164_RK, 0.215010011303_RK, &
    0.214738202173_RK, 0.214466115425_RK, 0.214193750709_RK, 0.213921107674_RK, &
    0.213648185967_RK, 0.213374985234_RK, 0.213101505121_RK, 0.21282774527_RK, &
    0.212553705325_RK, 0.212279384926_RK, 0.212004783714_RK, 0.211729901327_RK, &
    0.211454737402_RK, 0.211179291575_RK, 0.21090356348_RK, 0.210627552752_RK, &
    0.210351259021_RK, 0.210074681919_RK, 0.209797821075_RK, 0.209520676117_RK, &
    0.209243246671_RK, 0.208965532363_RK, 0.208687532816_RK, 0.208409247653_RK, &
    0.208130676495_RK, 0.207851818961_RK, 0.20757267467_RK, 0.207293243239_RK, &
    0.207013524284_RK, 0.206733517417_RK, 0.206453222252_RK, 0.2061726384_RK, &
    0.205891765471_RK, 0.205610603072_RK, 0.205329150811_RK, 0.205047408293_RK, &
    0.204765375121_RK, 0.204483050898_RK, 0.204200435225_RK, 0.203917527701_RK, &
    0.203634327924_RK, 0.20335083549_RK, 0.203067049994_RK, 0.202782971029_RK, &
    0.202498598186_RK, 0.202213931056_RK, 0.201928969228_RK, 0.201643712287_RK, &
    0.20135815982_RK, 0.20107231141_RK, 0.20078616664_RK, 0.200499725089_RK, &
    0.200212986337_RK, 0.199925949961_RK, 0.199638615537_RK, 0.199350982639_RK, &
    0.199063050838_RK, 0.198774819706_RK, 0.198486288812_RK, 0.198197457722_RK, &
    0.197908326003_RK, 0.197618893218_RK, 0.197329158929_RK, 0.197039122697_RK, &
    0.196748784081_RK, 0.196458142637_RK, 0.196167197921_RK, 0.195875949485_RK, &
    0.195584396882_RK, 0.195292539661_RK, 0.19500037737_RK, 0.194707909556_RK, &
    0.194415135763_RK, 0.194122055533_RK, 0.193828668408_RK, 0.193534973925_RK, &
    0.193240971621_RK, 0.192946661033_RK, 0.192652041693_RK, 0.192357113132_RK, &
    0.192061874879_RK, 0.191766326463_RK, 0.191470467408_RK, 0.191174297238_RK, &
    0.190877815475_RK, 0.190581021638_RK, 0.190283915244_RK, 0.189986495811_RK, &
    0.18968876285_RK, 0.189390715873_RK, 0.189092354391_RK, 0.188793677911_RK, &
    0.188494685937_RK, 0.188195377973_RK, 0.187895753521_RK, 0.18759581208_RK, &
    0.187295553146_RK, 0.186994976215_RK, 0.186694080779_RK, 0.186392866329_RK, &
    0.186091332353_RK, 0.185789478338_RK, 0.185487303768_RK, 0.185184808123_RK, &
    0.184881990885_RK, 0.18457885153_RK, 0.184275389534_RK, 0.183971604368_RK, &
    0.183667495505_RK, 0.183363062412_RK, 0.183058304554_RK, 0.182753221396_RK, &
    0.182447812399_RK, 0.182142077022_RK, 0.18183601472_RK, 0.181529624949_RK, &
    0.18122290716_RK, 0.180915860803_RK, 0.180608485323_RK, 0.180300780166_RK, &
    0.179992744774_RK, 0.179684378585_RK, 0.179375681037_RK, 0.179066651564_RK, &
    0.178757289598_RK, 0.178447594568_RK, 0.178137565902_RK, 0.177827203022_RK, &
    0.177516505351_RK, 0.177205472308_RK, 0.176894103309_RK, 0.176582397766_RK, &
    0.176270355092_RK, 0.175957974695_RK, 0.175645255979_RK, 0.175332198348_RK, &
    0.175018801202_RK, 0.174705063937_RK, 0.174390985949_RK, 0.174076566628_RK, &
    0.173761805364_RK, 0.173446701542_RK, 0.173131254545_RK, 0.172815463755_RK, &
    0.172499328546_RK, 0.172182848295_RK, 0.171866022373_RK, 0.171548850146_RK, &
    0.171231330982_RK, 0.170913464242_RK, 0.170595249286_RK, 0.170276685469_RK, &
    0.169957772145_RK, 0.169638508664_RK, 0.169318894373_RK, 0.168998928615_RK, &
    0.168678610731_RK, 0.168357940058_RK, 0.16803691593_RK, 0.167715537679_RK, &
    0.167393804631_RK, 0.167071716111_RK, 0.16674927144_RK, 0.166426469936_RK, &
    0.166103310913_RK, 0.165779793681_RK, 0.165455917548_RK, 0.165131681818_RK, &
    0.164807085792_RK, 0.164482128766_RK, 0.164156810034_RK, 0.163831128886_RK, &
    0.163505084608_RK, 0.163178676483_RK, 0.162851903789_RK, 0.162524765803_RK, &
    0.162197261796_RK, 0.161869391036_RK, 0.161541152788_RK, 0.161212546311_RK, &
    0.160883570863_RK, 0.160554225695_RK, 0.160224510058_RK, 0.159894423197_RK, &
    0.159563964351_RK, 0.159233132759_RK, 0.158901927654_RK, 0.158570348265_RK, &
    0.158238393817_RK, 0.15790606353_RK, 0.157573356623_RK, 0.157240272307_RK, &
    0.156906809791_RK, 0.156572968279_RK, 0.156238746972_RK, 0.155904145066_RK, &
    0.155569161751_RK, 0.155233796214_RK, 0.15489804764_RK, 0.154561915205_RK, &
    0.154225398084_RK, 0.153888495445_RK, 0.153551206454_RK, 0.153213530271_RK, &
    0.152875466051_RK, 0.152537012946_RK, 0.152198170101_RK, 0.151858936658_RK, &
    0.151519311753_RK, 0.151179294519_RK, 0.150838884082_RK, 0.150498079565_RK, &
    0.150156880085_RK, 0.149815284753_RK, 0.149473292678_RK, 0.149130902961_RK, &
    0.148788114699_RK, 0.148444926984_RK, 0.148101338903_RK, 0.147757349537_RK, &
    0.147412957962_RK, 0.147068163249_RK, 0.146722964463_RK, 0.146377360665_RK, &
    0.146031350908_RK, 0.145684934242_RK, 0.14533810971_RK, 0.144990876349_RK, &
    0.144643233193_RK, 0.144295179266_RK, 0.14394671359_RK, 0.143597835179_RK, &
    0.143248543043_RK, 0.142898836183_RK, 0.142548713597_RK, 0.142198174276_RK, &
    0.141847217205_RK, 0.141495841361_RK, 0.141144045718_RK, 0.140791829241_RK, &
    0.14043919089_RK, 0.140086129618_RK, 0.139732644373_RK, 0.139378734095_RK, &
    0.139024397717_RK, 0.138669634167_RK, 0.138314442365_RK, 0.137958821225_RK, &
    0.137602769653_RK, 0.137246286551_RK, 0.13688937081_RK, 0.136532021316_RK, &
    0.13617423695_RK, 0.135816016581_RK, 0.135457359075_RK, 0.13509826329_RK, &
    0.134738728074_RK, 0.13437875227_RK, 0.134018334713_RK, 0.13365747423_RK, &
    0.133296169642_RK, 0.132934419758_RK, 0.132572223385_RK, 0.132209579317_RK, &
    0.131846486342_RK, 0.131482943242_RK, 0.131118948787_RK, 0.130754501741_RK, &
    0.13038960086_RK, 0.130024244891_RK, 0.129658432571_RK, 0.129292162631_RK, &
    0.128925433793_RK, 0.128558244767_RK, 0.128190594259_RK, 0.127822480963_RK, &
    0.127453903564_RK, 0.127084860738_RK, 0.126715351154_RK, 0.126345373469_RK, &
    0.125974926331_RK, 0.12560400838_RK, 0.125232618245_RK, 0.124860754545_RK, &
    0.12448841589_RK, 0.124115600881_RK, 0.123742308106_RK, 0.123368536146_RK, &
    0.12299428357_RK, 0.122619548937_RK, 0.122244330795_RK, 0.121868627682_RK, &
    0.121492438126_RK, 0.121115760642_RK, 0.120738593735_RK, 0.120360935901_RK, &
    0.119982785621_RK, 0.119604141367_RK, 0.1192250016_RK, 0.118845364768_RK, &
    0.118465229306_RK, 0.118084593641_RK, 0.117703456185_RK, 0.117321815339_RK, &
    0.11693966949_RK, 0.116557017014_RK, 0.116173856276_RK, 0.115790185624_RK, &
    0.115406003396_RK, 0.115021307918_RK, 0.1146360975_RK, 0.11425037044_RK, &
    0.113864125022_RK, 0.113477359516_RK, 0.113090072181_RK, 0.112702261257_RK, &
    0.112313924974_RK, 0.111925061545_RK, 0.111535669171_RK, 0.111145746034_RK, &
    0.110755290307_RK, 0.110364300142_RK, 0.109972773679_RK, 0.109580709043_RK, &
    0.10918810434_RK, 0.108794957663_RK, 0.108401267088_RK, 0.108007030675_RK, &
    0.107612246467_RK, 0.10721691249_RK, 0.106821026753_RK, 0.106424587249_RK, &
    0.106027591953_RK, 0.10563003882_RK, 0.105231925791_RK, 0.104833250787_RK, &
    0.10443401171_RK, 0.104034206444_RK, 0.103633832853_RK, 0.103232888785_RK, &
    0.102831372066_RK, 0.102429280502_RK, 0.102026611881_RK, 0.101623363968_RK, &
    0.10121953451_RK, 0.100815121233_RK, 0.100410121841_RK, 0.100004534016_RK, &
    0.0995983554201_RK, 0.0991915836918_RK, 0.098784216448_RK, 0.098376251283_RK, &
    0.0979676857678_RK, 0.0975585174503_RK, 0.0971487438546_RK, 0.0967383624809_RK, &
    0.0963273708049_RK, 0.0959157662776_RK, 0.095503546325_RK, 0.0950907083474_RK, &
    0.0946772497194_RK, 0.0942631677893_RK, 0.0938484598786_RK, 0.0934331232819_RK, &
    0.0930171552661_RK, 0.0926005530704_RK, 0.0921833139053_RK, 0.0917654349529_RK, &
    0.0913469133655_RK, 0.0909277462662_RK, 0.0905079307475_RK, 0.0900874638713_RK, &
    0.0896663426683_RK, 0.0892445641375_RK, 0.0888221252457_RK, 0.0883990229268_RK, &
    0.0879752540816_RK, 0.0875508155769_RK, 0.0871257042449_RK, 0.0866999168832_RK, &
    0.0862734502535_RK, 0.0858463010813_RK, 0.0854184660553_RK, 0.0849899418268_RK, &
    0.084560725009_RK, 0.0841308121761_RK, 0.0837001998631_RK, 0.0832688845646_RK, &
    0.0828368627345_RK, 0.082404130785_RK, 0.0819706850859_RK, 0.081536521964_RK, &
    0.081101637702_RK, 0.080666028538_RK, 0.0802296906646_RK, 0.0797926202279_RK, &
    0.0793548133268_RK, 0.078916266012_RK, 0.0784769742851_RK, 0.0780369340979_RK, &
    0.077596141351_RK, 0.0771545918932_RK, 0.0767122815202_RK, 0.076269205974_RK, &
    0.0758253609412_RK, 0.0753807420524_RK, 0.0749353448811_RK, 0.074489164942_RK, &
    0.0740421976905_RK, 0.0735944385211_RK, 0.0731458827663_RK, 0.0726965256949_RK, &
    0.0722463625114_RK, 0.0717953883543_RK, 0.0713435982942_RK, 0.0708909873334_RK, &
    0.0704375504035_RK, 0.0699832823643_RK, 0.0695281780022_RK, 0.0690722320286_RK, &
    0.0686154390782_RK, 0.0681577937072_RK, 0.0676992903918_RK, 0.0672399235259_RK, &
    0.0667796874201_RK, 0.0663185762986_RK, 0.0658565842984_RK, 0.0653937054663_RK, &
    0.0649299337573_RK, 0.0644652630325_RK, 0.0639996870564_RK, 0.0635331994951_RK, &
    0.0630657939132_RK, 0.0625974637723_RK, 0.0621282024276_RK, 0.0616580031256_RK, &
    0.0611868590013_RK, 0.0607147630756_RK, 0.060241708252_RK, 0.0597676873138_RK, &
    0.059292692921_RK, 0.058816717607_RK, 0.0583397537752_RK, 0.0578617936955_RK, &
    0.0573828295011_RK, 0.0569028531841_RK, 0.0564218565922_RK, 0.0559398314244_RK, &
    0.0554567692269_RK, 0.054972661389_RK, 0.0544874991381_RK, 0.0540012735356_RK, &
    0.053513975472_RK, 0.0530255956613_RK, 0.0525361246366_RK, 0.052045552744_RK, &
    0.0515538701374_RK, 0.0510610667724_RK, 0.0505671324_RK, 0.0500720565609_RK, &
    0.0495758285778_RK, 0.0490784375496_RK, 0.0485798723434_RK, 0.048080121587_RK, &
    0.0475791736615_RK, 0.0470770166928_RK, 0.0465736385427_RK, 0.0460690268006_RK, &
    0.0455631687734_RK, 0.0450560514761_RK, 0.0445476616215_RK, 0.0440379856092_RK, &
    0.0435270095144_RK, 0.0430147190762_RK, 0.0425010996849_RK, 0.0419861363691_RK, &
    0.0414698137822_RK, 0.0409521161875_RK, 0.0404330274434_RK, 0.0399125309876_RK, &
    0.0393906098197_RK, 0.0388672464844_RK, 0.0383424230521_RK, 0.0378161210995_RK, &
    0.037288321689_RK, 0.0367590053466_RK, 0.0362281520387_RK, 0.0356957411476_RK, &
    0.0351617514458_RK, 0.034626161068_RK, 0.0340889474822_RK, 0.0335500874589_RK, &
    0.033009557038_RK, 0.032467331494_RK, 0.0319233852988_RK, 0.0313776920821_RK, &
    0.0308302245895_RK, 0.0302809546372_RK, 0.0297298530646_RK, 0.0291768896823_RK, &
    0.0286220332182_RK, 0.0280652512583_RK, 0.0275065101844_RK, 0.0269457751062_RK, &
    0.02638300979_RK, 0.0258181765805_RK, 0.0252512363179_RK, 0.0246821482486_RK, &
    0.0241108699283_RK, 0.0235373571186_RK, 0.0229615636755_RK, 0.0223834414285_RK, &
    0.0218029400512_RK, 0.0212200069209_RK, 0.0206345869682_RK, 0.0200466225144_RK, &
    0.0194560530967_RK, 0.0188628152806_RK, 0.0182668424588_RK, 0.0176680646372_RK, &
    0.0170664082066_RK, 0.016461795704_RK, 0.0158541455627_RK, 0.015243371858_RK, &
    0.0146293840521_RK, 0.0140120867521_RK, 0.0133913794939_RK, 0.0127671565806_RK, &
    0.0121393070128_RK, 0.0115077145716_RK, 0.0108722581496_RK, 0.0102328124764_RK, &
    0.00958924947315_RK, 0.00894144061242_RK, 0.00828926090091_RK, 0.00763259551896_RK, &
    0.00697135089651_RK, 0.00630547338383_RK, 0.00563498133279_RK, 0.00496002177703_RK, &
    0.00428097439553_RK, 0.00359865177269_RK, 0.00291471045349_RK, 0.00223256762114_RK, &
    0.00155968193081_RK ];

    integer(IK), parameter :: VEC_CELL_1(1:5000) = [ &
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, &
    2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, &
    5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 8, 8, &
    8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 11, &
    11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 14, &
    14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 17, 17, &
    17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 20, 20, 20, &
    20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, &
    23, 23, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, &
    27, 27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 30, 30, &
    30, 30, 30, 30, 31, 31, 31, 31, 31, 31, 32, 32, 32, 32, 32, 32, 33, 33, 33, 33, &
    33, 34, 34, 34, 34, 34, 34, 35, 35, 35, 35, 35, 35, 36, 36, 36, 36, 36, 37, 37, &
    37, 37, 37, 37, 38, 38, 38, 38, 38, 39, 39, 39, 39, 39, 39, 40, 40, 40, 40, 40, &
    40, 41, 41, 41, 41, 41, 42, 42, 42, 42, 42, 43, 43, 43, 43, 43, 43, 44, 44, 44, &
    44, 44, 45, 45, 45, 45, 45, 46, 46, 46, 46, 46, 46, 47, 47, 47, 47, 47, 48, 48, &
    48, 48, 48, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 52, &
    52, 52, 52, 52, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 56, &
    56, 56, 56, 56, 57, 57, 57, 57, 57, 58, 58, 58, 58, 58, 59, 59, 59, 59, 59, 60, &
    60, 60, 60, 60, 61, 61, 61, 61, 61, 62, 62, 62, 62, 63, 63, 63, 63, 63, 64, 64, &
    64, 64, 64, 65, 65, 65, 65, 65, 66, 66, 66, 66, 66, 67, 67, 67, 67, 68, 68, 68, &
    68, 68, 69, 69, 69, 69, 69, 70, 70, 70, 70, 71, 71, 71, 71, 71, 72, 72, 72, 72, &
    72, 73, 73, 73, 73, 74, 74, 74, 74, 74, 75, 75, 75, 75, 76, 76, 76, 76, 76, 77, &
    77, 77, 77, 78, 78, 78, 78, 78, 79, 79, 79, 79, 80, 80, 80, 80, 80, 81, 81, 81, &
    81, 82, 82, 82, 82, 83, 83, 83, 83, 83, 84, 84, 84, 84, 85, 85, 85, 85, 86, 86, &
    86, 86, 86, 87, 87, 87, 87, 88, 88, 88, 88, 89, 89, 89, 89, 89, 90, 90, 90, 90, &
    91, 91, 91, 91, 92, 92, 92, 92, 93, 93, 93, 93, 94, 94, 94, 94, 95, 95, 95, 95, &
    95, 96, 96, 96, 96, 97, 97, 97, 97, 98, 98, 98, 98, 99, 99, 99, 99, 100, 100, 100, &
    100, 101, 101, 101, 101, 102, 102, 102, 102, 103, 103, 103, 103, 104, 104, 104, 104, 105, 105, 105, &
    105, 106, 106, 106, 106, 107, 107, 107, 107, 108, 108, 108, 108, 109, 109, 109, 109, 110, 110, 110, &
    110, 111, 111, 111, 111, 112, 112, 112, 113, 113, 113, 113, 114, 114, 114, 114, 115, 115, 115, 115, &
    116, 116, 116, 116, 117, 117, 117, 117, 118, 118, 118, 119, 119, 119, 119, 120, 120, 120, 120, 121, &
    121, 121, 121, 122, 122, 122, 123, 123, 123, 123, 124, 124, 124, 124, 125, 125, 125, 126, 126, 126, &
    126, 127, 127, 127, 127, 128, 128, 128, 129, 129, 129, 129, 130, 130, 130, 130, 131, 131, 131, 132, &
    132, 132, 132, 133, 133, 133, 134, 134, 134, 134, 135, 135, 135, 136, 136, 136, 136, 137, 137, 137, &
    137, 138, 138, 138, 139, 139, 139, 139, 140, 140, 140, 141, 141, 141, 141, 142, 142, 142, 143, 143, &
    143, 144, 144, 144, 144, 145, 145, 145, 146, 146, 146, 146, 147, 147, 147, 148, 148, 148, 148, 149, &
    149, 149, 150, 150, 150, 151, 151, 151, 151, 152, 152, 152, 153, 153, 153, 154, 154, 154, 154, 155, &
    155, 155, 156, 156, 156, 157, 157, 157, 157, 158, 158, 158, 159, 159, 159, 160, 160, 160, 160, 161, &
    161, 161, 162, 162, 162, 163, 163, 163, 164, 164, 164, 164, 165, 165, 165, 166, 166, 166, 167, 167, &
    167, 168, 168, 168, 169, 169, 169, 169, 170, 170, 170, 171, 171, 171, 172, 172, 172, 173, 173, 173, &
    174, 174, 174, 175, 175, 175, 176, 176, 176, 176, 177, 177, 177, 178, 178, 178, 179, 179, 179, 180, &
    180, 180, 181, 181, 181, 182, 182, 182, 183, 183, 183, 184, 184, 184, 185, 185, 185, 186, 186, 186, &
    187, 187, 187, 188, 188, 188, 189, 189, 189, 190, 190, 190, 191, 191, 191, 192, 192, 192, 193, 193, &
    193, 194, 194, 194, 195, 195, 195, 196, 196, 196, 197, 197, 197, 198, 198, 198, 199, 199, 199, 200, &
    200, 200, 201, 201, 201, 202, 202, 202, 203, 203, 203, 204, 204, 204, 205, 205, 206, 206, 206, 207, &
    207, 207, 208, 208, 208, 209, 209, 209, 210, 210, 210, 211, 211, 211, 212, 212, 213, 213, 213, 214, &
    214, 214, 215, 215, 215, 216, 216, 216, 217, 217, 217, 218, 218, 219, 219, 219, 220, 220, 220, 221, &
    221, 221, 222, 222, 223, 223, 223, 224, 224, 224, 225, 225, 225, 226, 226, 227, 227, 227, 228, 228, &
    228, 229, 229, 229, 230, 230, 231, 231, 231, 232, 232, 232, 233, 233, 234, 234, 234, 235, 235, 235, &
    236, 236, 237, 237, 237, 238, 238, 238, 239, 239, 240, 240, 240, 241, 241, 241, 242, 242, 243, 243, &
    243, 244, 244, 244, 245, 245, 246, 246, 246, 247, 247, 248, 248, 248, 249, 249, 249, 250, 250, 251, &
    251, 251, 252, 252, 253, 253, 253, 254, 254, 254, 255, 255, 256, 256, 256, 257, 257, 258, 258, 258, &
    259, 259, 260, 260, 260, 261, 261, 262, 262, 262, 263, 263, 264, 264, 264, 265, 265, 266, 266, 266, &
    267, 267, 268, 268, 268, 269, 269, 270, 270, 270, 271, 271, 272, 272, 272, 273, 273, 274, 274, 274, &
    275, 275, 276, 276, 276, 277, 277, 278, 278, 278, 279, 279, 280, 280, 280, 281, 281, 282, 282, 283, &
    283, 283, 284, 284, 285, 285, 285, 286, 286, 287, 287, 288, 288, 288, 289, 289, 290, 290, 290, 291, &
    291, 292, 292, 293, 293, 293, 294, 294, 295, 295, 296, 296, 296, 297, 297, 298, 298, 298, 299, 299, &
    300, 300, 301, 301, 301, 302, 302, 303, 303, 304, 304, 304, 305, 305, 306, 306, 307, 307, 307, 308, &
    308, 309, 309, 310, 310, 311, 311, 311, 312, 312, 313, 313, 314, 314, 314, 315, 315, 316, 316, 317, &
    317, 318, 318, 318, 319, 319, 320, 320, 321, 321, 322, 322, 322, 323, 323, 324, 324, 325, 325, 326, &
    326, 326, 327, 327, 328, 328, 329, 329, 330, 330, 330, 331, 331, 332, 332, 333, 333, 334, 334, 335, &
    335, 335, 336, 336, 337, 337, 338, 338, 339, 339, 340, 340, 340, 341, 341, 342, 342, 343, 343, 344, &
    344, 345, 345, 346, 346, 346, 347, 347, 348, 348, 349, 349, 350, 350, 351, 351, 352, 352, 353, 353, &
    353, 354, 354, 355, 355, 356, 356, 357, 357, 358, 358, 359, 359, 360, 360, 361, 361, 361, 362, 362, &
    363, 363, 364, 364, 365, 365, 366, 366, 367, 367, 368, 368, 369, 369, 370, 370, 371, 371, 371, 372, &
    372, 373, 373, 374, 374, 375, 375, 376, 376, 377, 377, 378, 378, 379, 379, 380, 380, 381, 381, 382, &
    382, 383, 383, 384, 384, 385, 385, 386, 386, 387, 387, 388, 388, 389, 389, 390, 390, 391, 391, 392, &
    392, 393, 393, 394, 394, 395, 395, 396, 396, 397, 397, 398, 398, 399, 399, 400, 400, 401, 401, 402, &
    402, 403, 403, 404, 404, 405, 405, 406, 406, 407, 407, 408, 408, 409, 409, 410, 410, 411, 411, 412, &
    412, 413, 413, 414, 414, 415, 415, 416, 416, 417, 417, 418, 418, 419, 419, 420, 420, 421, 421, 422, &
    423, 423, 424, 424, 425, 425, 426, 426, 427, 427, 428, 428, 429, 429, 430, 430, 431, 431, 432, 432, &
    433, 433, 434, 435, 435, 436, 436, 437, 437, 438, 438, 439, 439, 440, 440, 441, 441, 442, 442, 443, &
    444, 444, 445, 445, 446, 446, 447, 447, 448, 448, 449, 449, 450, 450, 451, 452, 452, 453, 453, 454, &
    454, 455, 455, 456, 456, 457, 458, 458, 459, 459, 460, 460, 461, 461, 462, 462, 463, 464, 464, 465, &
    465, 466, 466, 467, 467, 468, 468, 469, 470, 470, 471, 471, 472, 472, 473, 473, 474, 475, 475, 476, &
    476, 477, 477, 478, 478, 479, 480, 480, 481, 481, 482, 482, 483, 483, 484, 485, 485, 486, 486, 487, &
    487, 488, 488, 489, 490, 490, 491, 491, 492, 492, 493, 494, 494, 495, 495, 496, 496, 497, 498, 498, &
    499, 499, 500, 500, 501, 502, 502, 503, 503, 504, 504, 505, 506, 506, 507, 507, 508, 508, 509, 510, &
    510, 511, 511, 512, 512, 513, 514, 514, 515, 515, 516, 517, 517, 518, 518, 519, 519, 520, 521, 521, &
    522, 522, 523, 524, 524, 525, 525, 526, 526, 527, 528, 528, 529, 529, 530, 531, 531, 532, 532, 533, &
    534, 534, 535, 535, 536, 537, 537, 538, 538, 539, 539, 540, 541, 541, 542, 542, 543, 544, 544, 545, &
    545, 546, 547, 547, 548, 548, 549, 550, 550, 551, 551, 552, 553, 553, 554, 555, 555, 556, 556, 557, &
    558, 558, 559, 559, 560, 561, 561, 562, 562, 563, 564, 564, 565, 565, 566, 567, 567, 568, 569, 569, &
    570, 570, 571, 572, 572, 573, 573, 574, 575, 575, 576, 577, 577, 578, 578, 579, 580, 580, 581, 582, &
    582, 583, 583, 584, 585, 585, 586, 586, 587, 588, 588, 589, 590, 590, 591, 591, 592, 593, 593, 594, &
    595, 595, 596, 597, 597, 598, 598, 599, 600, 600, 601, 602, 602, 603, 603, 604, 605, 605, 606, 607, &
    607, 608, 609, 609, 610, 610, 611, 612, 612, 613, 614, 614, 615, 616, 616, 617, 618, 618, 619, 619, &
    620, 621, 621, 622, 623, 623, 624, 625, 625, 626, 627, 627, 628, 629, 629, 630, 630, 631, 632, 632, &
    633, 634, 634, 635, 636, 636, 637, 638, 638, 639, 640, 640, 641, 642, 642, 643, 644, 644, 645, 646, &
    646, 647, 647, 648, 649, 649, 650, 651, 651, 652, 653, 653, 654, 655, 655, 656, 657, 657, 658, 659, &
    659, 660, 661, 661, 662, 663, 663, 664, 665, 665, 666, 667, 667, 668, 669, 669, 670, 671, 671, 672, &
    673, 674, 674, 675, 676, 676, 677, 678, 678, 679, 680, 680, 681, 682, 682, 683, 684, 684, 685, 686, &
    686, 687, 688, 688, 689, 690, 690, 691, 692, 693, 693, 694, 695, 695, 696, 697, 697, 698, 699, 699, &
    700, 701, 701, 702, 703, 704, 704, 705, 706, 706, 707, 708, 708, 709, 710, 710, 711, 712, 713, 713, &
    714, 715, 715, 716, 717, 717, 718, 719, 719, 720, 721, 722, 722, 723, 724, 724, 725, 726, 726, 727, &
    728, 729, 729, 730, 731, 731, 732, 733, 734, 734, 735, 736, 736, 737, 738, 738, 739, 740, 741, 741, &
    742, 743, 743, 744, 745, 746, 746, 747, 748, 748, 749, 750, 751, 751, 752, 753, 753, 754, 755, 756, &
    756, 757, 758, 758, 759, 760, 761, 761, 762, 763, 763, 764, 765, 766, 766, 767, 768, 769, 769, 770, &
    771, 771, 772, 773, 774, 774, 775, 776, 777, 777, 778, 779, 779, 780, 781, 782, 782, 783, 784, 785, &
    785, 786, 787, 787, 788, 789, 790, 790, 791, 792, 793, 793, 794, 795, 796, 796, 797, 798, 798, 799, &
    800, 801, 801, 802, 803, 804, 804, 805, 806, 807, 807, 808, 809, 810, 810, 811, 812, 813, 813, 814, &
    815, 816, 816, 817, 818, 819, 819, 820, 821, 822, 822, 823, 824, 825, 825, 826, 827, 828, 828, 829, &
    830, 831, 831, 832, 833, 834, 834, 835, 836, 837, 837, 838, 839, 840, 840, 841, 842, 843, 843, 844, &
    845, 846, 846, 847, 848, 849, 849, 850, 851, 852, 853, 853, 854, 855, 856, 856, 857, 858, 859, 859, &
    860, 861, 862, 862, 863, 864, 865, 866, 866, 867, 868, 869, 869, 870, 871, 872, 872, 873, 874, 875, &
    876, 876, 877, 878, 879, 879, 880, 881, 882, 883, 883, 884, 885, 886, 886, 887, 888, 889, 890, 890, &
    891, 892, 893, 893, 894, 895, 896, 897, 897, 898, 899, 900, 900, 901, 902, 903, 904, 904, 905, 906, &
    907, 908, 908, 909, 910, 911, 911, 912, 913, 914, 915, 915, 916, 917, 918, 919, 919, 920, 921, 922, &
    923, 923, 924, 925, 926, 927, 927, 928, 929, 930, 931, 931, 932, 933, 934, 935, 935, 936, 937, 938, &
    939, 939, 940, 941, 942, 943, 943, 944, 945, 946, 947, 947, 948, 949, 950, 951, 951, 952, 953, 954, &
    955, 955, 956, 957, 958, 959, 959, 960, 961, 962, 963, 963, 964, 965, 966, 967, 968, 968, 969, 970, &
    971, 972, 972, 973, 974, 975, 976, 976, 977, 978, 979, 980, 981, 981, 982, 983, 984, 985, 985, 986, &
    987, 988, 989, 990, 990, 991, 992, 993, 994, 994, 995, 996, 997, 998, 999, 999, 1000, 1001, 1002, 1003, &
    1004, 1004, 1005, 1006, 1007, 1008, 1008, 1009, 1010, 1011, 1012, 1013, 1013, 1014, 1015, 1016, 1017, 1018, 1018, 1019, &
    1020, 1021, 1022, 1023, 1023, 1024, 1025, 1026, 1027, 1028, 1028, 1029, 1030, 1031, 1032, 1033, 1033, 1034, 1035, 1036, &
    1037, 1038, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1044, 1045, 1046, 1047, 1048, 1049, 1049, 1050, 1051, 1052, 1053, &
    1054, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1060, 1061, 1062, 1063, 1064, 1065, 1065, 1066, 1067, 1068, 1069, 1070, &
    1071, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1077, 1078, 1079, 1080, 1081, 1082, 1082, 1083, 1084, 1085, 1086, 1087, &
    1088, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1100, 1101, 1102, 1103, 1104, &
    1105, 1106, 1107, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1119, 1120, 1121, &
    1122, 1123, 1124, 1125, 1126, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 1133, 1134, 1135, 1136, 1137, 1138, 1139, &
    1139, 1140, 1141, 1142, 1143, 1144, 1145, 1146, 1146, 1147, 1148, 1149, 1150, 1151, 1152, 1153, 1153, 1154, 1155, 1156, &
    1157, 1158, 1159, 1160, 1161, 1161, 1162, 1163, 1164, 1165, 1166, 1167, 1168, 1168, 1169, 1170, 1171, 1172, 1173, 1174, &
    1175, 1176, 1176, 1177, 1178, 1179, 1180, 1181, 1182, 1183, 1183, 1184, 1185, 1186, 1187, 1188, 1189, 1190, 1191, 1191, &
    1192, 1193, 1194, 1195, 1196, 1197, 1198, 1199, 1199, 1200, 1201, 1202, 1203, 1204, 1205, 1206, 1207, 1208, 1208, 1209, &
    1210, 1211, 1212, 1213, 1214, 1215, 1216, 1216, 1217, 1218, 1219, 1220, 1221, 1222, 1223, 1224, 1225, 1225, 1226, 1227, &
    1228, 1229, 1230, 1231, 1232, 1233, 1234, 1234, 1235, 1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243, 1243, 1244, 1245, &
    1246, 1247, 1248, 1249, 1250, 1251, 1252, 1253, 1253, 1254, 1255, 1256, 1257, 1258, 1259, 1260, 1261, 1262, 1263, 1263, &
    1264, 1265, 1266, 1267, 1268, 1269, 1270, 1271, 1272, 1273, 1273, 1274, 1275, 1276, 1277, 1278, 1279, 1280, 1281, 1282, &
    1283, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1290, 1291, 1292, 1293, 1294, 1294, 1295, 1296, 1297, 1298, 1299, 1300, &
    1301, 1302, 1303, 1304, 1305, 1305, 1306, 1307, 1308, 1309, 1310, 1311, 1312, 1313, 1314, 1315, 1316, 1317, 1317, 1318, &
    1319, 1320, 1321, 1322, 1323, 1324, 1325, 1326, 1327, 1328, 1329, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 1337, &
    1338, 1339, 1340, 1341, 1342, 1342, 1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355, 1356, &
    1356, 1357, 1358, 1359, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 1369, 1370, 1370, 1371, 1372, 1373, 1374, &
    1375, 1376, 1377, 1378, 1379, 1380, 1381, 1382, 1383, 1384, 1385, 1385, 1386, 1387, 1388, 1389, 1390, 1391, 1392, 1393, &
    1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401, 1401, 1402, 1403, 1404, 1405, 1406, 1407, 1408, 1409, 1410, 1411, 1412, &
    1413, 1414, 1415, 1416, 1417, 1417, 1418, 1419, 1420, 1421, 1422, 1423, 1424, 1425, 1426, 1427, 1428, 1429, 1430, 1431, &
    1432, 1433, 1434, 1435, 1435, 1436, 1437, 1438, 1439, 1440, 1441, 1442, 1443, 1444, 1445, 1446, 1447, 1448, 1449, 1450, &
    1451, 1452, 1453, 1454, 1455, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, &
    1470, 1471, 1472, 1473, 1474, 1475, 1476, 1476, 1477, 1478, 1479, 1480, 1481, 1482, 1483, 1484, 1485, 1486, 1487, 1488, &
    1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1500, 1501, 1502, 1503, 1504, 1505, 1506, 1507, &
    1508, 1509, 1510, 1511, 1512, 1513, 1514, 1515, 1516, 1517, 1518, 1519, 1520, 1521, 1522, 1523, 1524, 1525, 1526, 1526, &
    1527, 1528, 1529, 1530, 1531, 1532, 1533, 1534, 1535, 1536, 1537, 1538, 1539, 1540, 1541, 1542, 1543, 1544, 1545, 1546, &
    1547, 1548, 1549, 1550, 1551, 1552, 1553, 1554, 1555, 1556, 1556, 1557, 1558, 1559, 1560, 1561, 1562, 1563, 1564, 1565, &
    1566, 1567, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, &
    1586, 1587, 1588, 1589, 1590, 1591, 1592, 1592, 1593, 1594, 1595, 1596, 1597, 1598, 1599, 1600, 1601, 1602, 1603, 1604, &
    1605, 1606, 1607, 1608, 1609, 1610, 1611, 1612, 1613, 1614, 1615, 1616, 1617, 1618, 1619, 1620, 1621, 1622, 1623, 1624, &
    1625, 1626, 1627, 1628, 1629, 1630, 1631, 1632, 1633, 1634, 1635, 1636, 1637, 1637, 1638, 1639, 1640, 1641, 1642, 1643, &
    1644, 1645, 1646, 1647, 1648, 1649, 1650, 1651, 1652, 1653, 1654, 1655, 1656, 1657, 1658, 1659, 1660, 1661, 1662, 1663, &
    1664, 1665, 1666, 1667, 1668, 1669, 1670, 1671, 1672, 1673, 1674, 1675, 1676, 1677, 1678, 1679, 1680, 1681, 1682, 1683, &
    1684, 1685, 1686, 1687, 1688, 1689, 1690, 1691, 1692, 1693, 1694, 1695, 1696, 1697, 1698, 1699, 1700, 1701, 1702, 1702, &
    1703, 1704, 1705, 1706, 1707, 1708, 1709, 1710, 1711, 1712, 1713, 1714, 1715, 1716, 1717, 1718, 1719, 1720, 1721, 1722, &
    1723, 1724, 1725, 1726, 1727, 1728, 1729, 1730, 1731, 1732, 1733, 1734, 1735, 1736, 1737, 1738, 1739, 1740, 1741, 1742, &
    1743, 1744, 1745, 1746, 1747, 1748, 1749, 1750, 1751, 1752, 1753, 1754, 1755, 1756, 1757, 1758, 1759, 1760, 1761, 1762, &
    1763, 1764, 1765, 1766, 1767, 1768, 1769, 1770, 1771, 1772, 1773, 1774, 1775, 1776, 1777, 1778, 1779, 1780, 1781, 1782, &
    1783, 1784, 1785, 1786, 1787, 1788, 1789, 1790, 1791, 1792, 1793, 1794, 1795, 1796, 1797, 1798, 1799, 1800, 1801, 1802, &
    1803, 1804, 1805, 1806, 1807, 1808, 1809, 1810, 1811, 1812, 1813, 1814, 1815, 1816, 1817, 1818, 1819, 1820, 1821, 1822, &
    1823, 1824, 1825, 1826, 1827, 1828, 1829, 1830, 1831, 1832, 1833, 1834, 1835, 1836, 1837, 1838, 1839, 1840, 1841, 1842, &
    1843, 1844, 1845, 1846, 1847, 1848, 1849, 1850, 1851, 1852, 1853, 1854, 1855, 1856, 1857, 1858, 1859, 1860, 1861, 1862, &
    1863, 1864, 1865, 1866, 1867, 1868, 1869, 1870, 1871, 1872, 1873, 1874, 1875, 1876, 1877, 1878, 1879, 1880, 1881, 1882, &
    1883, 1884, 1885, 1886, 1887, 1888, 1889, 1890, 1891, 1892, 1893, 1894, 1895, 1896, 1897, 1898, 1899, 1900, 1901, 1902, &
    1903, 1904, 1905, 1906, 1907, 1908, 1909, 1910, 1911, 1912, 1913, 1914, 1915, 1916, 1917, 1918, 1919, 1920, 1921, 1922, &
    1923, 1924, 1925, 1926, 1927, 1928, 1929, 1930, 1931, 1932, 1933, 1934, 1935, 1936, 1937, 1938, 1939, 1940, 1941, 1942, &
    1943, 1944, 1945, 1946, 1947, 1948, 1949, 1950, 1951, 1952, 1953, 1954, 1955, 1955, 1956, 1957, 1958, 1959, 1960, 1961, &
    1962, 1963, 1964, 1965, 1966, 1967, 1968, 1969, 1970, 1971, 1972, 1973, 1974, 1975, 1976, 1977, 1978, 1979, 1980, 1981, &
    1982, 1983, 1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001, &
    2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021, &
    2022, 2023, 2024, 2025, 2026, 2027, 2028, 2029, 2030, 2031, 2032, 2033, 2034, 2035, 2036, 2037, 2038, 2039, 2040, 2041, &
    2042, 2043, 2044, 2045, 2046, 2047, 2048, 2049, 2050, 2051, 2052, 2053, 2054, 2055, 2056, 2057, 2058, 2059, 2060, 2061, &
    2062, 2063, 2064, 2065, 2066, 2067, 2068, 2069, 2070, 2071, 2072, 2073, 2074, 2075, 2076, 2077, 2078, 2079, 2080, 2081, &
    2082, 2083, 2084, 2085, 2086, 2087, 2088, 2089, 2090, 2091, 2092, 2093, 2094, 2095, 2096, 2097, 2098, 2099, 2100, 2101, &
    2102, 2103, 2104, 2105, 2106, 2107, 2108, 2109, 2110, 2111, 2112, 2113, 2114, 2115, 2116, 2117, 2118, 2119, 2120, 2121, &
    2122, 2123, 2124, 2125, 2126, 2127, 2128, 2129, 2130, 2131, 2132, 2133, 2134, 2135, 2136, 2137, 2138, 2139, 2140, 2141, &
    2142, 2143, 2144, 2145, 2146, 2147, 2148, 2149, 2150, 2151, 2152, 2153, 2154, 2155, 2156, 2157, 2158, 2159, 2160, 2161, &
    2162, 2163, 2164, 2165, 2166, 2167, 2168, 2169, 2170, 2171, 2172, 2173, 2174, 2175, 2176, 2177, 2178, 2179, 2180, 2181, &
    2182, 2183, 2184, 2185, 2186, 2187, 2188, 2189, 2190, 2191, 2192, 2193, 2194, 2195, 2196, 2197, 2198, 2199, 2200, 2201, &
    2202, 2203, 2204, 2205, 2205, 2206, 2207, 2208, 2209, 2210, 2211, 2212, 2213, 2214, 2215, 2216, 2217, 2218, 2219, 2220, &
    2221, 2222, 2223, 2224, 2225, 2226, 2227, 2228, 2229, 2230, 2231, 2232, 2233, 2234, 2235, 2236, 2237, 2238, 2239, 2240, &
    2241, 2242, 2243, 2244, 2245, 2246, 2247, 2248, 2249, 2250, 2251, 2252, 2253, 2254, 2255, 2256, 2257, 2258, 2259, 2260, &
    2261, 2262, 2263, 2264, 2265, 2266, 2267, 2268, 2269, 2270, 2270, 2271, 2272, 2273, 2274, 2275, 2276, 2277, 2278, 2279, &
    2280, 2281, 2282, 2283, 2284, 2285, 2286, 2287, 2288, 2289, 2290, 2291, 2292, 2293, 2294, 2295, 2296, 2297, 2298, 2299, &
    2300, 2301, 2302, 2303, 2304, 2305, 2306, 2307, 2308, 2309, 2310, 2311, 2312, 2313, 2314, 2315, 2315, 2316, 2317, 2318, &
    2319, 2320, 2321, 2322, 2323, 2324, 2325, 2326, 2327, 2328, 2329, 2330, 2331, 2332, 2333, 2334, 2335, 2336, 2337, 2338, &
    2339, 2340, 2341, 2342, 2343, 2344, 2345, 2346, 2347, 2348, 2349, 2350, 2351, 2351, 2352, 2353, 2354, 2355, 2356, 2357, &
    2358, 2359, 2360, 2361, 2362, 2363, 2364, 2365, 2366, 2367, 2368, 2369, 2370, 2371, 2372, 2373, 2374, 2375, 2376, 2377, &
    2378, 2379, 2380, 2381, 2381, 2382, 2383, 2384, 2385, 2386, 2387, 2388, 2389, 2390, 2391, 2392, 2393, 2394, 2395, 2396, &
    2397, 2398, 2399, 2400, 2401, 2402, 2403, 2404, 2405, 2406, 2407, 2407, 2408, 2409, 2410, 2411, 2412, 2413, 2414, 2415, &
    2416, 2417, 2418, 2419, 2420, 2421, 2422, 2423, 2424, 2425, 2426, 2427, 2428, 2429, 2430, 2431, 2431, 2432, 2433, 2434, &
    2435, 2436, 2437, 2438, 2439, 2440, 2441, 2442, 2443, 2444, 2445, 2446, 2447, 2448, 2449, 2450, 2451, 2452, 2452, 2453, &
    2454, 2455, 2456, 2457, 2458, 2459, 2460, 2461, 2462, 2463, 2464, 2465, 2466, 2467, 2468, 2469, 2470, 2471, 2472, 2472, &
    2473, 2474, 2475, 2476, 2477, 2478, 2479, 2480, 2481, 2482, 2483, 2484, 2485, 2486, 2487, 2488, 2489, 2490, 2490, 2491, &
    2492, 2493, 2494, 2495, 2496, 2497, 2498, 2499, 2500, 2501, 2502, 2503, 2504, 2505, 2506, 2506, 2507, 2508, 2509, 2510, &
    2511, 2512, 2513, 2514, 2515, 2516, 2517, 2518, 2519, 2520, 2521, 2522, 2522, 2523, 2524, 2525, 2526, 2527, 2528, 2529, &
    2530, 2531, 2532, 2533, 2534, 2535, 2536, 2537, 2537, 2538, 2539, 2540, 2541, 2542, 2543, 2544, 2545, 2546, 2547, 2548, &
    2549, 2550, 2551, 2551, 2552, 2553, 2554, 2555, 2556, 2557, 2558, 2559, 2560, 2561, 2562, 2563, 2564, 2565, 2565, 2566, &
    2567, 2568, 2569, 2570, 2571, 2572, 2573, 2574, 2575, 2576, 2577, 2578, 2578, 2579, 2580, 2581, 2582, 2583, 2584, 2585, &
    2586, 2587, 2588, 2589, 2590, 2590, 2591, 2592, 2593, 2594, 2595, 2596, 2597, 2598, 2599, 2600, 2601, 2602, 2602, 2603, &
    2604, 2605, 2606, 2607, 2608, 2609, 2610, 2611, 2612, 2613, 2613, 2614, 2615, 2616, 2617, 2618, 2619, 2620, 2621, 2622, &
    2623, 2624, 2624, 2625, 2626, 2627, 2628, 2629, 2630, 2631, 2632, 2633, 2634, 2634, 2635, 2636, 2637, 2638, 2639, 2640, &
    2641, 2642, 2643, 2644, 2644, 2645, 2646, 2647, 2648, 2649, 2650, 2651, 2652, 2653, 2654, 2654, 2655, 2656, 2657, 2658, &
    2659, 2660, 2661, 2662, 2663, 2664, 2664, 2665, 2666, 2667, 2668, 2669, 2670, 2671, 2672, 2673, 2673, 2674, 2675, 2676, &
    2677, 2678, 2679, 2680, 2681, 2682, 2682, 2683, 2684, 2685, 2686, 2687, 2688, 2689, 2690, 2691, 2691, 2692, 2693, 2694, &
    2695, 2696, 2697, 2698, 2699, 2699, 2700, 2701, 2702, 2703, 2704, 2705, 2706, 2707, 2708, 2708, 2709, 2710, 2711, 2712, &
    2713, 2714, 2715, 2716, 2716, 2717, 2718, 2719, 2720, 2721, 2722, 2723, 2724, 2724, 2725, 2726, 2727, 2728, 2729, 2730, &
    2731, 2731, 2732, 2733, 2734, 2735, 2736, 2737, 2738, 2739, 2739, 2740, 2741, 2742, 2743, 2744, 2745, 2746, 2746, 2747, &
    2748, 2749, 2750, 2751, 2752, 2753, 2754, 2754, 2755, 2756, 2757, 2758, 2759, 2760, 2761, 2761, 2762, 2763, 2764, 2765, &
    2766, 2767, 2768, 2768, 2769, 2770, 2771, 2772, 2773, 2774, 2774, 2775, 2776, 2777, 2778, 2779, 2780, 2781, 2781, 2782, &
    2783, 2784, 2785, 2786, 2787, 2788, 2788, 2789, 2790, 2791, 2792, 2793, 2794, 2794, 2795, 2796, 2797, 2798, 2799, 2800, &
    2800, 2801, 2802, 2803, 2804, 2805, 2806, 2807, 2807, 2808, 2809, 2810, 2811, 2812, 2813, 2813, 2814, 2815, 2816, 2817, &
    2818, 2819, 2819, 2820, 2821, 2822, 2823, 2824, 2825, 2825, 2826, 2827, 2828, 2829, 2830, 2830, 2831, 2832, 2833, 2834, &
    2835, 2836, 2836, 2837, 2838, 2839, 2840, 2841, 2842, 2842, 2843, 2844, 2845, 2846, 2847, 2847, 2848, 2849, 2850, 2851, &
    2852, 2853, 2853, 2854, 2855, 2856, 2857, 2858, 2858, 2859, 2860, 2861, 2862, 2863, 2863, 2864, 2865, 2866, 2867, 2868, &
    2869, 2869, 2870, 2871, 2872, 2873, 2874, 2874, 2875, 2876, 2877, 2878, 2879, 2879, 2880, 2881, 2882, 2883, 2884, 2884, &
    2885, 2886, 2887, 2888, 2889, 2889, 2890, 2891, 2892, 2893, 2894, 2894, 2895, 2896, 2897, 2898, 2899, 2899, 2900, 2901, &
    2902, 2903, 2903, 2904, 2905, 2906, 2907, 2908, 2908, 2909, 2910, 2911, 2912, 2913, 2913, 2914, 2915, 2916, 2917, 2917, &
    2918, 2919, 2920, 2921, 2922, 2922, 2923, 2924, 2925, 2926, 2926, 2927, 2928, 2929, 2930, 2931, 2931, 2932, 2933, 2934, &
    2935, 2935, 2936, 2937, 2938, 2939, 2939, 2940, 2941, 2942, 2943, 2944, 2944, 2945, 2946, 2947, 2948, 2948, 2949, 2950, &
    2951, 2952, 2952, 2953, 2954, 2955, 2956, 2956, 2957, 2958, 2959, 2960, 2960, 2961, 2962, 2963, 2964, 2964, 2965, 2966, &
    2967, 2968, 2968, 2969, 2970, 2971, 2972, 2972, 2973, 2974, 2975, 2976, 2976, 2977, 2978, 2979, 2980, 2980, 2981, 2982, &
    2983, 2984, 2984, 2985, 2986, 2987, 2988, 2988, 2989, 2990, 2991, 2992, 2992, 2993, 2994, 2995, 2996, 2996, 2997, 2998, &
    2999, 2999, 3000, 3001, 3002, 3003, 3003, 3004, 3005, 3006, 3007, 3007, 3008, 3009, 3010, 3010, 3011, 3012, 3013, 3014, &
    3014, 3015, 3016, 3017, 3017, 3018, 3019, 3020, 3021, 3021, 3022, 3023, 3024, 3024, 3025, 3026, 3027, 3028, 3028, 3029, &
    3030, 3031, 3031, 3032, 3033, 3034, 3035, 3035, 3036, 3037, 3038, 3038, 3039, 3040, 3041, 3041, 3042, 3043, 3044, 3045, &
    3045, 3046, 3047, 3048, 3048, 3049, 3050, 3051, 3051, 3052, 3053, 3054, 3054, 3055, 3056, 3057, 3058, 3058, 3059, 3060, &
    3061, 3061, 3062, 3063, 3064, 3064, 3065, 3066, 3067, 3067, 3068, 3069, 3070, 3070, 3071, 3072, 3073, 3073, 3074, 3075, &
    3076, 3076, 3077, 3078, 3079, 3079, 3080, 3081, 3082, 3082, 3083, 3084, 3085, 3085, 3086, 3087, 3088, 3088, 3089, 3090, &
    3091, 3091, 3092, 3093, 3094, 3094, 3095, 3096, 3097, 3097, 3098, 3099, 3100, 3100, 3101, 3102, 3103, 3103, 3104, 3105, &
    3106, 3106, 3107, 3108, 3109, 3109, 3110, 3111, 3111, 3112, 3113, 3114, 3114, 3115, 3116, 3117, 3117, 3118, 3119, 3120, &
    3120, 3121, 3122, 3122, 3123, 3124, 3125, 3125, 3126, 3127, 3128, 3128, 3129, 3130, 3130, 3131, 3132, 3133, 3133, 3134, &
    3135, 3136, 3136, 3137, 3138, 3138, 3139, 3140, 3141, 3141, 3142, 3143, 3144, 3144, 3145, 3146, 3146, 3147, 3148, 3149, &
    3149, 3150, 3151, 3151, 3152, 3153, 3154, 3154, 3155, 3156, 3156, 3157, 3158, 3159, 3159, 3160, 3161, 3161, 3162, 3163, &
    3164, 3164, 3165, 3166, 3166, 3167, 3168, 3169, 3169, 3170, 3171, 3171, 3172, 3173, 3173, 3174, 3175, 3176, 3176, 3177, &
    3178, 3178, 3179, 3180, 3181, 3181, 3182, 3183, 3183, 3184, 3185, 3185, 3186, 3187, 3188, 3188, 3189, 3190, 3190, 3191, &
    3192, 3192, 3193, 3194, 3194, 3195, 3196, 3197, 3197, 3198, 3199, 3199, 3200, 3201, 3201, 3202, 3203, 3203, 3204, 3205, &
    3206, 3206, 3207, 3208, 3208, 3209, 3210, 3210, 3211, 3212, 3212, 3213, 3214, 3214, 3215, 3216, 3217, 3217, 3218, 3219, &
    3219, 3220, 3221, 3221, 3222, 3223, 3223, 3224, 3225, 3225, 3226, 3227, 3227, 3228, 3229, 3229, 3230, 3231, 3231, 3232, &
    3233, 3233, 3234, 3235, 3236, 3236, 3237, 3238, 3238, 3239, 3240, 3240, 3241, 3242, 3242, 3243, 3244, 3244, 3245, 3246, &
    3246, 3247, 3248, 3248, 3249, 3250, 3250, 3251, 3252, 3252, 3253, 3254, 3254, 3255, 3256, 3256, 3257, 3258, 3258, 3259, &
    3260, 3260, 3261, 3261, 3262, 3263, 3263, 3264, 3265, 3265, 3266, 3267, 3267, 3268, 3269, 3269, 3270, 3271, 3271, 3272, &
    3273, 3273, 3274, 3275, 3275, 3276, 3277, 3277, 3278, 3278, 3279, 3280, 3280, 3281, 3282, 3282, 3283, 3284, 3284, 3285, &
    3286, 3286, 3287, 3288, 3288, 3289, 3289, 3290, 3291, 3291, 3292, 3293, 3293, 3294, 3295, 3295, 3296, 3297, 3297, 3298, &
    3298, 3299, 3300, 3300, 3301, 3302, 3302, 3303, 3304, 3304, 3305, 3305, 3306, 3307, 3307, 3308, 3309, 3309, 3310, 3310, &
    3311, 3312, 3312, 3313, 3314, 3314, 3315, 3316, 3316, 3317, 3317, 3318, 3319, 3319, 3320, 3321, 3321, 3322, 3322, 3323, &
    3324, 3324, 3325, 3325, 3326, 3327, 3327, 3328, 3329, 3329, 3330, 3330, 3331, 3332, 3332, 3333, 3334, 3334, 3335, 3335, &
    3336, 3337, 3337, 3338, 3338, 3339, 3340, 3340, 3341, 3342, 3342, 3343, 3343, 3344, 3345, 3345, 3346, 3346, 3347, 3348, &
    3348, 3349, 3349, 3350, 3351, 3351, 3352, 3352, 3353, 3354, 3354, 3355, 3356, 3356, 3357, 3357, 3358, 3359, 3359, 3360, &
    3360, 3361, 3362, 3362, 3363, 3363, 3364, 3365, 3365, 3366, 3366, 3367, 3368, 3368, 3369, 3369, 3370, 3370, 3371, 3372, &
    3372, 3373, 3373, 3374, 3375, 3375, 3376, 3376, 3377, 3378, 3378, 3379, 3379, 3380, 3381, 3381, 3382, 3382, 3383, 3383, &
    3384, 3385, 3385, 3386, 3386, 3387, 3388, 3388, 3389, 3389, 3390, 3390, 3391, 3392, 3392, 3393, 3393, 3394, 3395, 3395, &
    3396, 3396, 3397, 3397, 3398, 3399, 3399, 3400, 3400, 3401, 3401, 3402, 3403, 3403, 3404, 3404, 3405, 3405, 3406, 3407  ]

    integer(IK), parameter :: VEC_CELL_2(5001:LEN_VEC_CELL) = [ &
    3407, 3408, 3408, 3409, 3409, 3410, 3411, 3411, 3412, 3412, 3413, 3413, 3414, 3415, 3415, 3416, 3416, 3417, 3417, 3418, &
    3419, 3419, 3420, 3420, 3421, 3421, 3422, 3422, 3423, 3424, 3424, 3425, 3425, 3426, 3426, 3427, 3427, 3428, 3429, 3429, &
    3430, 3430, 3431, 3431, 3432, 3432, 3433, 3434, 3434, 3435, 3435, 3436, 3436, 3437, 3437, 3438, 3439, 3439, 3440, 3440, &
    3441, 3441, 3442, 3442, 3443, 3443, 3444, 3445, 3445, 3446, 3446, 3447, 3447, 3448, 3448, 3449, 3449, 3450, 3451, 3451, &
    3452, 3452, 3453, 3453, 3454, 3454, 3455, 3455, 3456, 3457, 3457, 3458, 3458, 3459, 3459, 3460, 3460, 3461, 3461, 3462, &
    3462, 3463, 3463, 3464, 3465, 3465, 3466, 3466, 3467, 3467, 3468, 3468, 3469, 3469, 3470, 3470, 3471, 3471, 3472, 3472, &
    3473, 3474, 3474, 3475, 3475, 3476, 3476, 3477, 3477, 3478, 3478, 3479, 3479, 3480, 3480, 3481, 3481, 3482, 3482, 3483, &
    3483, 3484, 3484, 3485, 3486, 3486, 3487, 3487, 3488, 3488, 3489, 3489, 3490, 3490, 3491, 3491, 3492, 3492, 3493, 3493, &
    3494, 3494, 3495, 3495, 3496, 3496, 3497, 3497, 3498, 3498, 3499, 3499, 3500, 3500, 3501, 3501, 3502, 3502, 3503, 3503, &
    3504, 3504, 3505, 3505, 3506, 3506, 3507, 3507, 3508, 3508, 3509, 3509, 3510, 3510, 3511, 3511, 3512, 3512, 3513, 3513, &
    3514, 3514, 3515, 3515, 3516, 3516, 3517, 3517, 3518, 3518, 3519, 3519, 3520, 3520, 3521, 3521, 3522, 3522, 3523, 3523, &
    3524, 3524, 3525, 3525, 3526, 3526, 3527, 3527, 3528, 3528, 3529, 3529, 3530, 3530, 3531, 3531, 3532, 3532, 3533, 3533, &
    3534, 3534, 3535, 3535, 3536, 3536, 3536, 3537, 3537, 3538, 3538, 3539, 3539, 3540, 3540, 3541, 3541, 3542, 3542, 3543, &
    3543, 3544, 3544, 3545, 3545, 3546, 3546, 3546, 3547, 3547, 3548, 3548, 3549, 3549, 3550, 3550, 3551, 3551, 3552, 3552, &
    3553, 3553, 3554, 3554, 3554, 3555, 3555, 3556, 3556, 3557, 3557, 3558, 3558, 3559, 3559, 3560, 3560, 3561, 3561, 3561, &
    3562, 3562, 3563, 3563, 3564, 3564, 3565, 3565, 3566, 3566, 3567, 3567, 3567, 3568, 3568, 3569, 3569, 3570, 3570, 3571, &
    3571, 3572, 3572, 3572, 3573, 3573, 3574, 3574, 3575, 3575, 3576, 3576, 3577, 3577, 3577, 3578, 3578, 3579, 3579, 3580, &
    3580, 3581, 3581, 3581, 3582, 3582, 3583, 3583, 3584, 3584, 3585, 3585, 3585, 3586, 3586, 3587, 3587, 3588, 3588, 3589, &
    3589, 3589, 3590, 3590, 3591, 3591, 3592, 3592, 3593, 3593, 3593, 3594, 3594, 3595, 3595, 3596, 3596, 3596, 3597, 3597, &
    3598, 3598, 3599, 3599, 3600, 3600, 3600, 3601, 3601, 3602, 3602, 3603, 3603, 3603, 3604, 3604, 3605, 3605, 3606, 3606, &
    3606, 3607, 3607, 3608, 3608, 3609, 3609, 3609, 3610, 3610, 3611, 3611, 3611, 3612, 3612, 3613, 3613, 3614, 3614, 3614, &
    3615, 3615, 3616, 3616, 3617, 3617, 3617, 3618, 3618, 3619, 3619, 3619, 3620, 3620, 3621, 3621, 3622, 3622, 3622, 3623, &
    3623, 3624, 3624, 3624, 3625, 3625, 3626, 3626, 3627, 3627, 3627, 3628, 3628, 3629, 3629, 3629, 3630, 3630, 3631, 3631, &
    3631, 3632, 3632, 3633, 3633, 3633, 3634, 3634, 3635, 3635, 3635, 3636, 3636, 3637, 3637, 3637, 3638, 3638, 3639, 3639, &
    3639, 3640, 3640, 3641, 3641, 3641, 3642, 3642, 3643, 3643, 3643, 3644, 3644, 3645, 3645, 3645, 3646, 3646, 3647, 3647, &
    3647, 3648, 3648, 3649, 3649, 3649, 3650, 3650, 3651, 3651, 3651, 3652, 3652, 3653, 3653, 3653, 3654, 3654, 3654, 3655, &
    3655, 3656, 3656, 3656, 3657, 3657, 3658, 3658, 3658, 3659, 3659, 3659, 3660, 3660, 3661, 3661, 3661, 3662, 3662, 3663, &
    3663, 3663, 3664, 3664, 3664, 3665, 3665, 3666, 3666, 3666, 3667, 3667, 3667, 3668, 3668, 3669, 3669, 3669, 3670, 3670, &
    3670, 3671, 3671, 3672, 3672, 3672, 3673, 3673, 3673, 3674, 3674, 3675, 3675, 3675, 3676, 3676, 3676, 3677, 3677, 3678, &
    3678, 3678, 3679, 3679, 3679, 3680, 3680, 3680, 3681, 3681, 3682, 3682, 3682, 3683, 3683, 3683, 3684, 3684, 3684, 3685, &
    3685, 3686, 3686, 3686, 3687, 3687, 3687, 3688, 3688, 3688, 3689, 3689, 3690, 3690, 3690, 3691, 3691, 3691, 3692, 3692, &
    3692, 3693, 3693, 3693, 3694, 3694, 3694, 3695, 3695, 3696, 3696, 3696, 3697, 3697, 3697, 3698, 3698, 3698, 3699, 3699, &
    3699, 3700, 3700, 3700, 3701, 3701, 3701, 3702, 3702, 3703, 3703, 3703, 3704, 3704, 3704, 3705, 3705, 3705, 3706, 3706, &
    3706, 3707, 3707, 3707, 3708, 3708, 3708, 3709, 3709, 3709, 3710, 3710, 3710, 3711, 3711, 3711, 3712, 3712, 3712, 3713, &
    3713, 3713, 3714, 3714, 3714, 3715, 3715, 3715, 3716, 3716, 3716, 3717, 3717, 3717, 3718, 3718, 3718, 3719, 3719, 3719, &
    3720, 3720, 3720, 3721, 3721, 3721, 3722, 3722, 3722, 3723, 3723, 3723, 3724, 3724, 3724, 3725, 3725, 3725, 3726, 3726, &
    3726, 3727, 3727, 3727, 3728, 3728, 3728, 3729, 3729, 3729, 3730, 3730, 3730, 3731, 3731, 3731, 3731, 3732, 3732, 3732, &
    3733, 3733, 3733, 3734, 3734, 3734, 3735, 3735, 3735, 3736, 3736, 3736, 3737, 3737, 3737, 3738, 3738, 3738, 3738, 3739, &
    3739, 3739, 3740, 3740, 3740, 3741, 3741, 3741, 3742, 3742, 3742, 3743, 3743, 3743, 3743, 3744, 3744, 3744, 3745, 3745, &
    3745, 3746, 3746, 3746, 3747, 3747, 3747, 3747, 3748, 3748, 3748, 3749, 3749, 3749, 3750, 3750, 3750, 3750, 3751, 3751, &
    3751, 3752, 3752, 3752, 3753, 3753, 3753, 3753, 3754, 3754, 3754, 3755, 3755, 3755, 3756, 3756, 3756, 3756, 3757, 3757, &
    3757, 3758, 3758, 3758, 3759, 3759, 3759, 3759, 3760, 3760, 3760, 3761, 3761, 3761, 3761, 3762, 3762, 3762, 3763, 3763, &
    3763, 3763, 3764, 3764, 3764, 3765, 3765, 3765, 3766, 3766, 3766, 3766, 3767, 3767, 3767, 3768, 3768, 3768, 3768, 3769, &
    3769, 3769, 3770, 3770, 3770, 3770, 3771, 3771, 3771, 3771, 3772, 3772, 3772, 3773, 3773, 3773, 3773, 3774, 3774, 3774, &
    3775, 3775, 3775, 3775, 3776, 3776, 3776, 3777, 3777, 3777, 3777, 3778, 3778, 3778, 3778, 3779, 3779, 3779, 3780, 3780, &
    3780, 3780, 3781, 3781, 3781, 3781, 3782, 3782, 3782, 3783, 3783, 3783, 3783, 3784, 3784, 3784, 3784, 3785, 3785, 3785, &
    3786, 3786, 3786, 3786, 3787, 3787, 3787, 3787, 3788, 3788, 3788, 3788, 3789, 3789, 3789, 3790, 3790, 3790, 3790, 3791, &
    3791, 3791, 3791, 3792, 3792, 3792, 3792, 3793, 3793, 3793, 3793, 3794, 3794, 3794, 3794, 3795, 3795, 3795, 3796, 3796, &
    3796, 3796, 3797, 3797, 3797, 3797, 3798, 3798, 3798, 3798, 3799, 3799, 3799, 3799, 3800, 3800, 3800, 3800, 3801, 3801, &
    3801, 3801, 3802, 3802, 3802, 3802, 3803, 3803, 3803, 3803, 3804, 3804, 3804, 3804, 3805, 3805, 3805, 3805, 3806, 3806, &
    3806, 3806, 3807, 3807, 3807, 3807, 3808, 3808, 3808, 3808, 3809, 3809, 3809, 3809, 3810, 3810, 3810, 3810, 3811, 3811, &
    3811, 3811, 3812, 3812, 3812, 3812, 3812, 3813, 3813, 3813, 3813, 3814, 3814, 3814, 3814, 3815, 3815, 3815, 3815, 3816, &
    3816, 3816, 3816, 3817, 3817, 3817, 3817, 3818, 3818, 3818, 3818, 3818, 3819, 3819, 3819, 3819, 3820, 3820, 3820, 3820, &
    3821, 3821, 3821, 3821, 3821, 3822, 3822, 3822, 3822, 3823, 3823, 3823, 3823, 3824, 3824, 3824, 3824, 3824, 3825, 3825, &
    3825, 3825, 3826, 3826, 3826, 3826, 3827, 3827, 3827, 3827, 3827, 3828, 3828, 3828, 3828, 3829, 3829, 3829, 3829, 3829, &
    3830, 3830, 3830, 3830, 3831, 3831, 3831, 3831, 3831, 3832, 3832, 3832, 3832, 3833, 3833, 3833, 3833, 3833, 3834, 3834, &
    3834, 3834, 3835, 3835, 3835, 3835, 3835, 3836, 3836, 3836, 3836, 3836, 3837, 3837, 3837, 3837, 3838, 3838, 3838, 3838, &
    3838, 3839, 3839, 3839, 3839, 3839, 3840, 3840, 3840, 3840, 3841, 3841, 3841, 3841, 3841, 3842, 3842, 3842, 3842, 3842, &
    3843, 3843, 3843, 3843, 3843, 3844, 3844, 3844, 3844, 3844, 3845, 3845, 3845, 3845, 3846, 3846, 3846, 3846, 3846, 3847, &
    3847, 3847, 3847, 3847, 3848, 3848, 3848, 3848, 3848, 3849, 3849, 3849, 3849, 3849, 3850, 3850, 3850, 3850, 3850, 3851, &
    3851, 3851, 3851, 3851, 3852, 3852, 3852, 3852, 3852, 3853, 3853, 3853, 3853, 3853, 3854, 3854, 3854, 3854, 3854, 3855, &
    3855, 3855, 3855, 3855, 3856, 3856, 3856, 3856, 3856, 3857, 3857, 3857, 3857, 3857, 3857, 3858, 3858, 3858, 3858, 3858, &
    3859, 3859, 3859, 3859, 3859, 3860, 3860, 3860, 3860, 3860, 3861, 3861, 3861, 3861, 3861, 3861, 3862, 3862, 3862, 3862, &
    3862, 3863, 3863, 3863, 3863, 3863, 3864, 3864, 3864, 3864, 3864, 3864, 3865, 3865, 3865, 3865, 3865, 3866, 3866, 3866, &
    3866, 3866, 3867, 3867, 3867, 3867, 3867, 3867, 3868, 3868, 3868, 3868, 3868, 3868, 3869, 3869, 3869, 3869, 3869, 3870, &
    3870, 3870, 3870, 3870, 3870, 3871, 3871, 3871, 3871, 3871, 3872, 3872, 3872, 3872, 3872, 3872, 3873, 3873, 3873, 3873, &
    3873, 3873, 3874, 3874, 3874, 3874, 3874, 3875, 3875, 3875, 3875, 3875, 3875, 3876, 3876, 3876, 3876, 3876, 3876, 3877, &
    3877, 3877, 3877, 3877, 3877, 3878, 3878, 3878, 3878, 3878, 3878, 3879, 3879, 3879, 3879, 3879, 3879, 3880, 3880, 3880, &
    3880, 3880, 3880, 3881, 3881, 3881, 3881, 3881, 3881, 3882, 3882, 3882, 3882, 3882, 3882, 3883, 3883, 3883, 3883, 3883, &
    3883, 3884, 3884, 3884, 3884, 3884, 3884, 3885, 3885, 3885, 3885, 3885, 3885, 3886, 3886, 3886, 3886, 3886, 3886, 3887, &
    3887, 3887, 3887, 3887, 3887, 3887, 3888, 3888, 3888, 3888, 3888, 3888, 3889, 3889, 3889, 3889, 3889, 3889, 3890, 3890, &
    3890, 3890, 3890, 3890, 3890, 3891, 3891, 3891, 3891, 3891, 3891, 3892, 3892, 3892, 3892, 3892, 3892, 3892, 3893, 3893, &
    3893, 3893, 3893, 3893, 3894, 3894, 3894, 3894, 3894, 3894, 3894, 3895, 3895, 3895, 3895, 3895, 3895, 3895, 3896, 3896, &
    3896, 3896, 3896, 3896, 3897, 3897, 3897, 3897, 3897, 3897, 3897, 3898, 3898, 3898, 3898, 3898, 3898, 3898, 3899, 3899, &
    3899, 3899, 3899, 3899, 3899, 3900, 3900, 3900, 3900, 3900, 3900, 3900, 3901, 3901, 3901, 3901, 3901, 3901, 3901, 3902, &
    3902, 3902, 3902, 3902, 3902, 3902, 3903, 3903, 3903, 3903, 3903, 3903, 3903, 3904, 3904, 3904, 3904, 3904, 3904, 3904, &
    3905, 3905, 3905, 3905, 3905, 3905, 3905, 3906, 3906, 3906, 3906, 3906, 3906, 3906, 3906, 3907, 3907, 3907, 3907, 3907, &
    3907, 3907, 3908, 3908, 3908, 3908, 3908, 3908, 3908, 3908, 3909, 3909, 3909, 3909, 3909, 3909, 3909, 3910, 3910, 3910, &
    3910, 3910, 3910, 3910, 3910, 3911, 3911, 3911, 3911, 3911, 3911, 3911, 3912, 3912, 3912, 3912, 3912, 3912, 3912, 3912, &
    3913, 3913, 3913, 3913, 3913, 3913, 3913, 3913, 3914, 3914, 3914, 3914, 3914, 3914, 3914, 3914, 3915, 3915, 3915, 3915, &
    3915, 3915, 3915, 3915, 3916, 3916, 3916, 3916, 3916, 3916, 3916, 3916, 3917, 3917, 3917, 3917, 3917, 3917, 3917, 3917, &
    3918, 3918, 3918, 3918, 3918, 3918, 3918, 3918, 3919, 3919, 3919, 3919, 3919, 3919, 3919, 3919, 3919, 3920, 3920, 3920, &
    3920, 3920, 3920, 3920, 3920, 3921, 3921, 3921, 3921, 3921, 3921, 3921, 3921, 3922, 3922, 3922, 3922, 3922, 3922, 3922, &
    3922, 3922, 3923, 3923, 3923, 3923, 3923, 3923, 3923, 3923, 3923, 3924, 3924, 3924, 3924, 3924, 3924, 3924, 3924, 3925, &
    3925, 3925, 3925, 3925, 3925, 3925, 3925, 3925, 3926, 3926, 3926, 3926, 3926, 3926, 3926, 3926, 3926, 3927, 3927, 3927, &
    3927, 3927, 3927, 3927, 3927, 3927, 3928, 3928, 3928, 3928, 3928, 3928, 3928, 3928, 3928, 3929, 3929, 3929, 3929, 3929, &
    3929, 3929, 3929, 3929, 3929, 3930, 3930, 3930, 3930, 3930, 3930, 3930, 3930, 3930, 3931, 3931, 3931, 3931, 3931, 3931, &
    3931, 3931, 3931, 3931, 3932, 3932, 3932, 3932, 3932, 3932, 3932, 3932, 3932, 3933, 3933, 3933, 3933, 3933, 3933, 3933, &
    3933, 3933, 3933, 3934, 3934, 3934, 3934, 3934, 3934, 3934, 3934, 3934, 3934, 3935, 3935, 3935, 3935, 3935, 3935, 3935, &
    3935, 3935, 3935, 3936, 3936, 3936, 3936, 3936, 3936, 3936, 3936, 3936, 3936, 3937, 3937, 3937, 3937, 3937, 3937, 3937, &
    3937, 3937, 3937, 3938, 3938, 3938, 3938, 3938, 3938, 3938, 3938, 3938, 3938, 3938, 3939, 3939, 3939, 3939, 3939, 3939, &
    3939, 3939, 3939, 3939, 3940, 3940, 3940, 3940, 3940, 3940, 3940, 3940, 3940, 3940, 3940, 3941, 3941, 3941, 3941, 3941, &
    3941, 3941, 3941, 3941, 3941, 3941, 3942, 3942, 3942, 3942, 3942, 3942, 3942, 3942, 3942, 3942, 3942, 3943, 3943, 3943, &
    3943, 3943, 3943, 3943, 3943, 3943, 3943, 3943, 3944, 3944, 3944, 3944, 3944, 3944, 3944, 3944, 3944, 3944, 3944, 3945, &
    3945, 3945, 3945, 3945, 3945, 3945, 3945, 3945, 3945, 3945, 3945, 3946, 3946, 3946, 3946, 3946, 3946, 3946, 3946, 3946, &
    3946, 3946, 3947, 3947, 3947, 3947, 3947, 3947, 3947, 3947, 3947, 3947, 3947, 3947, 3948, 3948, 3948, 3948, 3948, 3948, &
    3948, 3948, 3948, 3948, 3948, 3948, 3949, 3949, 3949, 3949, 3949, 3949, 3949, 3949, 3949, 3949, 3949, 3949, 3949, 3950, &
    3950, 3950, 3950, 3950, 3950, 3950, 3950, 3950, 3950, 3950, 3950, 3951, 3951, 3951, 3951, 3951, 3951, 3951, 3951, 3951, &
    3951, 3951, 3951, 3951, 3952, 3952, 3952, 3952, 3952, 3952, 3952, 3952, 3952, 3952, 3952, 3952, 3952, 3953, 3953, 3953, &
    3953, 3953, 3953, 3953, 3953, 3953, 3953, 3953, 3953, 3953, 3954, 3954, 3954, 3954, 3954, 3954, 3954, 3954, 3954, 3954, &
    3954, 3954, 3954, 3955, 3955, 3955, 3955, 3955, 3955, 3955, 3955, 3955, 3955, 3955, 3955, 3955, 3955, 3956, 3956, 3956, &
    3956, 3956, 3956, 3956, 3956, 3956, 3956, 3956, 3956, 3956, 3956, 3957, 3957, 3957, 3957, 3957, 3957, 3957, 3957, 3957, &
    3957, 3957, 3957, 3957, 3957, 3958, 3958, 3958, 3958, 3958, 3958, 3958, 3958, 3958, 3958, 3958, 3958, 3958, 3958, 3958, &
    3959, 3959, 3959, 3959, 3959, 3959, 3959, 3959, 3959, 3959, 3959, 3959, 3959, 3959, 3959, 3960, 3960, 3960, 3960, 3960, &
    3960, 3960, 3960, 3960, 3960, 3960, 3960, 3960, 3960, 3960, 3961, 3961, 3961, 3961, 3961, 3961, 3961, 3961, 3961, 3961, &
    3961, 3961, 3961, 3961, 3961, 3962, 3962, 3962, 3962, 3962, 3962, 3962, 3962, 3962, 3962, 3962, 3962, 3962, 3962, 3962, &
    3962, 3963, 3963, 3963, 3963, 3963, 3963, 3963, 3963, 3963, 3963, 3963, 3963, 3963, 3963, 3963, 3963, 3964, 3964, 3964, &
    3964, 3964, 3964, 3964, 3964, 3964, 3964, 3964, 3964, 3964, 3964, 3964, 3964, 3964, 3965, 3965, 3965, 3965, 3965, 3965, &
    3965, 3965, 3965, 3965, 3965, 3965, 3965, 3965, 3965, 3965, 3965, 3966, 3966, 3966, 3966, 3966, 3966, 3966, 3966, 3966, &
    3966, 3966, 3966, 3966, 3966, 3966, 3966, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, &
    3967, 3967, 3967, 3967, 3967, 3967, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, &
    3968, 3968, 3968, 3968, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, &
    3969, 3969, 3969, 3970, 3970, 3970, 3970, 3970, 3970, 3970, 3970, 3970, 3970, 3970, 3970, 3970, 3970, 3970, 3970, 3970, &
    3970, 3970, 3971, 3971, 3971, 3971, 3971, 3971, 3971, 3971, 3971, 3971, 3971, 3971, 3971, 3971, 3971, 3971, 3971, 3971, &
    3971, 3971, 3972, 3972, 3972, 3972, 3972, 3972, 3972, 3972, 3972, 3972, 3972, 3972, 3972, 3972, 3972, 3972, 3972, 3972, &
    3972, 3972, 3972, 3973, 3973, 3973, 3973, 3973, 3973, 3973, 3973, 3973, 3973, 3973, 3973, 3973, 3973, 3973, 3973, 3973, &
    3973, 3973, 3973, 3973, 3974, 3974, 3974, 3974, 3974, 3974, 3974, 3974, 3974, 3974, 3974, 3974, 3974, 3974, 3974, 3974, &
    3974, 3974, 3974, 3974, 3974, 3974, 3975, 3975, 3975, 3975, 3975, 3975, 3975, 3975, 3975, 3975, 3975, 3975, 3975, 3975, &
    3975, 3975, 3975, 3975, 3975, 3975, 3975, 3975, 3976, 3976, 3976, 3976, 3976, 3976, 3976, 3976, 3976, 3976, 3976, 3976, &
    3976, 3976, 3976, 3976, 3976, 3976, 3976, 3976, 3976, 3976, 3976, 3976, 3977, 3977, 3977, 3977, 3977, 3977, 3977, 3977, &
    3977, 3977, 3977, 3977, 3977, 3977, 3977, 3977, 3977, 3977, 3977, 3977, 3977, 3977, 3977, 3977, 3978, 3978, 3978, 3978, &
    3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, 3978, &
    3978, 3979, 3979, 3979, 3979, 3979, 3979, 3979, 3979, 3979, 3979, 3979, 3979, 3979, 3979, 3979, 3979, 3979, 3979, 3979, &
    3979, 3979, 3979, 3979, 3979, 3979, 3979, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, &
    3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3980, 3981, 3981, 3981, 3981, 3981, 3981, &
    3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, 3981, &
    3981, 3981, 3981, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, &
    3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3982, 3983, 3983, 3983, 3983, 3983, 3983, 3983, &
    3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, 3983, &
    3983, 3983, 3983, 3983, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, &
    3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3984, 3985, 3985, 3985, &
    3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, &
    3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3985, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, &
    3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, &
    3986, 3986, 3986, 3986, 3986, 3986, 3986, 3986, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, &
    3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, 3987, &
    3987, 3987, 3987, 3987, 3987, 3987, 3987, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, &
    3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, &
    3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3988, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, &
    3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, &
    3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3989, 3990, 3990, 3990, 3990, 3990, 3990, 3990, &
    3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, &
    3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, 3990, &
    3990, 3990, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, &
    3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, &
    3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3991, 3992, 3992, 3992, 3992, 3992, 3992, &
    3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, &
    3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, &
    3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3992, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, &
    3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, &
    3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, &
    3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3993, 3994, 3994, 3994, 3994, 3994, 3994, &
    3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, &
    3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, &
    3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, 3994, &
    3994, 3994, 3994, 3994, 3994, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, &
    3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, &
    3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, &
    3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, 3995, &
    3995, 3995, 3995, 3995, 3995, 3995, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, &
    3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, &
    3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, &
    3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, &
    3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3996, 3997, &
    3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, &
    3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, &
    3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, &
    3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, &
    3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, &
    3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3997, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, &
    3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, &
    3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, &
    3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, &
    3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, &
    3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, &
    3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, 3998, &
    3998, 3998, 3998, 3998, 3998, 3998, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, &
    3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, &
    3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, &
    3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, &
    3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, &
    3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, &
    3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, &
    3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, &
    3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, 3999, &
    3999, 3999, 3999, 3999, 3999, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, &
    4000 ];

    ! Tables
    real(RK)   , parameter :: VEC_X(LEN_VEC_X)         = [ VEC_X_1, VEC_X_2, VEC_X_3, VEC_X_4 ]
    real(RK)   , parameter :: VEC_YU(LEN_VEC_YU)       = [ VEC_YU_1, VEC_YU_2, VEC_YU_3, VEC_YU_4 ]
    integer(IK), parameter :: VEC_CELL(LEN_VEC_CELL)   = [ VEC_CELL_1, VEC_CELL_2 ]


!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

contains

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    !> \brief
    !> Return a pseudorandom number from a truncated (normalized) Gaussian distribution. Example:
    !> ```
    !> tranGaus = getTranGaus(lowerLim, upperLim, 0._RK, 1._RK)
    !> ```
    !>
    !> \param[in]   lowerLim    :   The lower limit of the random number (the lower truncation on the Gaussian distribution).
    !> \param[in]   upperLim    :   The upper limit of the random number (the lower truncation on the Gaussian distribution).
    !> \param[in]   avg         :   The mean of the (non-truncated) Gaussian distribution (**optional**, default = 0).
    !> \param[in]   std         :   The standard deviation of the (non-truncated) Gaussian distribution (**optional**, default = 1).
    !>
    !> \return
    !> `tranGaus`   :   The output truncated random Gaussian number.
    function getTranGaus(lowerLim,upperLim,avg,std) result(tranGaus)
#if INTEL_COMPILER_ENABLED && defined DLL_ENABLED && (OS_IS_WINDOWS || defined OS_IS_DARWIN)
        !DEC$ ATTRIBUTES DLLEXPORT :: getTranGaus
#endif
    ! getTranGaus    Pseudorandom numbers from a truncated Gaussian distribution.
    !
    !   X = getTranGaus(lowerLim,B) returns a pseudorandom variable generated from a normal
    !   distribution with mean zero and standard deviation one (i.e. standard
    !   normal distribution) truncated to the interval [lowerLim,B].
    !
    !   X = getTranGaus(lowerLim,B,avg,std) returns a pseudorandom variable generated from
    !   a normal distribution with mean avg and standard deviation std
    !   truncated to the interval [lowerLim,B].
    !
    !   [X,P] = getTranGaus(...) also returns the vector of probabilities of X.
    !
    !   This implements an extension of the algorithm of Chopin detailed in
    !   N. Chopin, "Fast simulation of truncated Gaussian distributions", Stat
    !   Comput (2011) 21:275-288
    !
    ! Copyright (C) 2014 Vincent Mazet (ICube, CNRS/Université de Strasbourg),
    ! Version 2014-09-09, vincent.mazet@unistra.fr
    ! 18/06/2012:
    !   - first launch of getTranGaus.m
    ! 05/07/2012:
    !   - fix bug concerning the computing of the pdf when (avg,std) is
    !     different from (0,1).
    !   - fix bug about some indexes out of bounds when computing yl for some
    !     values of the input arguments.
    ! 04/09/2012:
    !   - change condition in line 2628 to fix a bug.
    ! 09/09/2014:
    !   - replace "variance" by "standard deviation" in the comments (thanks
    !   Umberto).
    !
    ! Licence: GNU Lesser General Public License Version 2
    ! This program is free software; you can redistribute it and/or modify it
    ! under the terms of the GNU Lesser General Public License as published by the
    ! Free Software Foundation; either version 2 of the License, or (at your
    ! option) any later version. This program is distributed in the hope that
    ! it will be useful, but WITHOUT ANY WARRANTY; without even the implied
    ! warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    ! GNU Lesser General Public License for more details. You should have received a
    ! copy of the GNU Lesser General Public License along with this program; if not,
    ! see http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt

    use Constants_mod, only: IK, RK
    implicit none
    real(RK), intent(in)            :: lowerLim,upperLim
    real(RK), intent(in), optional  :: avg, std
    real(RK)                        :: tranGaus !,p
    real(RK)                        :: lowerLimStd,upperLimStd, mean, stdev

    mean = 0._RK
    stdev = 1._RK
    if (present(avg))    mean = avg
    if (present(std)) stdev = std

    ! Scaling
    lowerLimStd = (lowerLim-avg)/stdev
    upperLimStd = (upperLim-avg)/stdev
    tranGaus = getStdTranGaus(lowerLimStd,upperLimStd)    ! Generate the random variables

    ! Scaling
    tranGaus = tranGaus * stdev + avg

    !! Compute the probabilities
    !if (present(p)) then
    !    Z = sqrt(pi/2)*std * (erf(upperLim/sqrt(2))-erf(lowerLim/sqrt(2)))
    !    Z = max(Z,1e-15)      ! Avoid NaN
    !    p = exp(-(tranGaus-mu).^2/2/std**2) / Z
    !end if

    end function getTranGaus

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    !> \brief
    !> Return a pseudorandom number from a truncated Standard Gaussian distribution. Example:
    !> ```
    !> tranGaus = getTranGaus(lowerLim, upperLim)
    !> ```
    !>
    !> \param[in]   lowerLim    :   The lower limit of the random number (the lower truncation on the Gaussian distribution).
    !> \param[in]   upperLim    :   The upper limit of the random number (the lower truncation on the Gaussian distribution).
    !>
    !> \return
    !> `tranGaus`   :   The output truncated random Standard Gaussian number.
    recursive function getStdTranGaus(lowerLim,upperLim) result(stdTranGaus)
#if INTEL_COMPILER_ENABLED && defined DLL_ENABLED && (OS_IS_WINDOWS || defined OS_IS_DARWIN)
        !DEC$ ATTRIBUTES DLLEXPORT :: getStdTranGaus
#endif

        use Constants_mod, only: IK, RK
        use Statistics_mod, only: getRandInt, getRandGaus
        use iso_fortran_env, only: output_unit

        implicit none

        real(RK), intent(in)    :: lowerLim, upperLim
        real(RK)                :: stdTranGaus

        real(RK), parameter     :: xmin = -2.00443204036_RK !< The left limit.
        real(RK), parameter     :: xmax = +3.48672170399_RK !< The right limit.

        ! Design variables
       !integer(IK), parameter  :: LEN_VEC_YU = 4001                    !< Index of the right tail
        integer(IK), parameter  :: KMIN = 5_IK                          !< if kb-ka < KMIN then use a rejection algorithm
        integer(IK), parameter  :: I0 = 3271_IK                         !< = - floor(VEC_X(1)/h)
        real(RK)                :: INVH = 1631.73284006_RK              !< 1/h, h being the minimal interval range
        real(RK)                :: ALPHA = 1.837877066409345_RK         !< = log(2*pi)
        real(RK)                :: YL0 = 0.053513975472_RK              !< y_l of the leftmost rectangle
        real(RK)                :: YLN = 0.000914116389555_RK           !< y_l of the rightmost rectangle

        real(RK)                :: twiceLowerLim, expLowerUpper, z, negLogUnifRnd, unifrnd, unifrndFixed
        real(RK)                :: sim, simy, ylk, d, lowerBound    !, u
        integer(IK)             :: i, ka, kb, k

        ! Check if lowerLim < upperLim

        blockRange: if (lowerLim>=upperLim) then

            ! LCOV_EXCL_START
            write(output_unit,"(A)") MODULE_NAME//"@getStdTranGaus: upperLim must be greater than lowerLim."
            error stop
            ! LCOV_EXCL_STOP

        ! Check if |lowerLim| < |upperLim|
        elseif (abs(lowerLim)>abs(upperLim)) then blockRange

            stdTranGaus = -getStdTranGaus(-upperLim,-lowerLim)

        ! If lowerLim in the right tail (lowerLim > xmax), use rejection algorithm with a truncated exponential proposal
        elseif (lowerLim > xmax) then blockRange

            twiceLowerLim = 2_RK * lowerLim**2;
            expLowerUpper = exp(-lowerLim*(upperLim-lowerLim)) - 1._RK;
            do
                call random_number(unifrnd)
                z = log(1 + unifrnd*expLowerUpper)
                call random_number(unifrnd)
                negLogUnifRnd = -log(unifrnd)
                if (twiceLowerLim*negLogUnifRnd > z**2) exit
            end do
            stdTranGaus = lowerLim - z / lowerLim

        ! If lowerLim in the left tail (lowerLim < xmin), use rejection algorithm with a Gaussian proposal
        elseif (lowerLim<xmin) then blockRange

            do ! LCOV_EXCL_LINE
                stdTranGaus = getRandGaus();
                if ( (stdTranGaus>=lowerLim) .and. (stdTranGaus<=upperLim) ) exit
            end do

        ! In other cases (xmin < lowerLim < xmax), use the algorithm of Chopin
        else blockRange

            ! Large data tables and design variables are used here

            ! Compute ka and kb
            i = I0 + floor(lowerLim*INVH)
            ka = VEC_CELL(i+1)                ! +1 due to index offset in Fortran
            if (upperLim >= xmax) then
                kb = LEN_VEC_YU
            else
                i = I0 + floor(upperLim*INVH)
                kb = VEC_CELL(i+1)            ! +1 due to index offset in Fortran
            end if

            ! If |upperLim-lowerLim| is small, use rejection algorithm with a truncated exponential proposal
            if (abs(kb-ka) < KMIN) then
                twiceLowerLim = 2._RK*lowerLim**2
                expLowerUpper = exp(-lowerLim*(upperLim-lowerLim)) - 1._RK
                do
                    call random_number(unifrnd)
                    z = log( 1._RK + unifrnd*expLowerUpper )
                    call random_number(unifrnd)
                    negLogUnifRnd = -log(unifrnd);
                    if (twiceLowerLim*negLogUnifRnd > z**2) exit
                end do
                stdTranGaus = lowerLim - z/lowerLim
                return
            end if

            do ! LCOV_EXCL_LINE

                ! Sample integer between ka and kb
                k = getRandInt(ka,kb) + 1_IK;   ! +1 due to index offset in Fortran

                if (k == LEN_VEC_YU + 1_IK) then

                    ! Right tail

                    lowerBound = VEC_X(LEN_VEC_X);
                    call random_number(unifrnd)
                    z = -log(unifrnd);
                    call random_number(unifrnd)
                    negLogUnifRnd = -log(unifrnd);
                    z = z / lowerBound;
                    if ( (z**2 <= 2._RK*negLogUnifRnd) .and. (z < upperLim-lowerBound) ) then
                        ! Accept this proposition, otherwise reject
                        stdTranGaus = lowerBound + z
                        return
                    end if

                elseif ( (k<=ka+2) .or. (k>=kb .and. upperLim<xmax) ) then

                    ! Two leftmost and rightmost regions

                    call random_number(unifrnd)
                    sim = VEC_X(k) + (VEC_X(k+1_IK)-VEC_X(k)) * unifrnd;
                    if ( (sim >= lowerLim) .and. (sim <= upperLim) ) then

                        ! Accept this proposition, otherwise reject
                        call random_number(unifrnd)
                        simy = VEC_YU(k)*unifrnd

                        ! Compute y_l from y_k
                        if (k == 1_IK) then
                           ylk = YL0
                        elseif (k == LEN_VEC_YU) then
                           ylk = YLN
                        elseif (k <= 1954_IK) then
                            ylk = VEC_YU(k-1_IK)
                        else
                            ylk = VEC_YU(k+1_IK)
                        end if

                        if ( (simy<ylk) .or. (sim**2 + 2._RK*log(simy) + ALPHA < 0._RK) ) then
                            stdTranGaus = sim
                            return
                        end if

                    end if

                else

                    ! All the other boxes

                    call random_number(unifrndFixed)
                    simy = VEC_YU(k) * unifrndFixed;
                    d = VEC_X(k+1_IK) - VEC_X(k);

                    ! Compute y_l from y_k
                    if (k == 1_IK) then
                        ylk = YL0
                    elseif (k == LEN_VEC_YU) then
                        ylk = YLN
                    elseif (k <= 1954_IK) then
                        ylk = VEC_YU(k-1_IK)
                    else
                        ylk = VEC_YU(k+1_IK)
                    end if

                    if (simy < ylk) then  ! That is what happens most of the time
                        stdTranGaus = VEC_X(k) + unifrndFixed*d*VEC_YU(k) / ylk
                        return
                    end if
                    call random_number(unifrnd)
                    sim = VEC_X(k) + d * unifrnd
                    ! Otherwise, check if we are below the pdf curve
                    if (sim**2 + 2*log(simy) + ALPHA < 0) then
                        stdTranGaus = sim
                        return
                    end if

                end if

            end do

        end if blockRange

    end function getStdTranGaus

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

end module TranGaus_mod ! LCOV_EXCL_LINE