/* Pango
 * pango-xsl-attributes.h: PangoAttribute types needed for XSL support
 *
 * Copyright (C) 1999 Red Hat Software
 * Copyright (C) 2000 Tor Lillqvist
 * Copyright (C) 2001-2004 Sun Microsystems
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __PANGO_XSL_ATTRIBUTES_H__
#define __PANGO_XSL_ATTRIBUTES_H__

#include <pango/pango-attributes.h>

G_BEGIN_DECLS

/**
 * PangoBaseline:
 * @PANGO_BASELINE_INVALID: Not a valid baseline.
 * @PANGO_BASELINE_AUTO:
 * @PANGO_BASELINE_RESET_SIZE:
 * @PANGO_BASELINE_ALPHABETIC:
 * @PANGO_BASELINE_IDEOGRAPHIC:
 * @PANGO_BASELINE_HANGING:
 * @PANGO_BASELINE_MATHEMATICAL:
 * @PANGO_BASELINE_CENTRAL:
 * @PANGO_BASELINE_MIDDLE:
 * @PANGO_BASELINE_TEXT_BEFORE_EDGE:
 * @PANGO_BASELINE_TEXT_AFTER_EDGE:
 * @PANGO_BASELINE_BEFORE_EDGE:
 * @PANGO_BASELINE_AFTER_EDGE:
 * @PANGO_BASELINE_LENGTH:
 * @PANGO_BASELINE_USE_SCRIPT:
 * @PANGO_BASELINE_BASELINE:
 *
 * Enumeration of allowed alignment-adjust, alignment-baseline, and
 * dominant-baseline values.
 *
 */
typedef enum {
    PANGO_BASELINE_INVALID,
    PANGO_BASELINE_AUTO,
    PANGO_BASELINE_RESET_SIZE,
    PANGO_BASELINE_ALPHABETIC,
    PANGO_BASELINE_IDEOGRAPHIC,
    PANGO_BASELINE_HANGING,
    PANGO_BASELINE_MATHEMATICAL,
    PANGO_BASELINE_CENTRAL,
    PANGO_BASELINE_MIDDLE,
    PANGO_BASELINE_TEXT_BEFORE_EDGE,
    PANGO_BASELINE_TEXT_AFTER_EDGE,
    PANGO_BASELINE_BEFORE_EDGE,
    PANGO_BASELINE_AFTER_EDGE,
    PANGO_BASELINE_LENGTH,
    PANGO_BASELINE_USE_SCRIPT,
    PANGO_BASELINE_BASELINE
} PangoBaseline;

/**
 * PangoLineStackingStrategy:
 * @PANGO_LINE_STACKING_STRATEGY_INVALID:
 * @PANGO_LINE_STACKING_STRATEGY_LINE_HEIGHT:
 * @PANGO_LINE_STACKING_STRATEGY_FONT_HEIGHT:
 * @PANGO_LINE_STACKING_STRATEGY_MAX_HEIGHT:
 *
 * Enumeration of allowed line-stacking-strategy values.
 */
typedef enum {
    PANGO_LINE_STACKING_STRATEGY_INVALID,
    PANGO_LINE_STACKING_STRATEGY_LINE_HEIGHT,
    PANGO_LINE_STACKING_STRATEGY_FONT_HEIGHT,
    PANGO_LINE_STACKING_STRATEGY_MAX_HEIGHT
} PangoLineStackingStrategy;

PangoAttrType    pango_attr_alignment_adjust_get_type (void);
PangoAttribute * pango_attr_alignment_adjust_new (gint alignment_adjust);

PangoAttrType    pango_attr_alignment_baseline_get_type (void);
PangoAttribute * pango_attr_alignment_baseline_new (gint alignment_baseline);

PangoAttribute * pango_attr_db_reset_size_new (gboolean db_reset_size);
PangoAttrType    pango_attr_db_reset_size_get_type (void);

PangoAttrType    pango_attr_dominant_baseline_get_type (void);
PangoAttribute * pango_attr_dominant_baseline_new (PangoBaseline dominant_baseline,
						   PangoFontDescription *font_desc);

PangoAttrType    pango_attr_callback_get_type (void);
PangoAttribute * pango_attr_callback_new (gpointer callback);
gpointer         pango_attr_callback_get_callback (const PangoAttribute *attr);

PangoAttrType    pango_attr_keep_together_within_line_get_type (void);
PangoAttribute * pango_attr_keep_together_within_line_new (gint strength);

PangoAttrType    pango_attr_keep_with_next_within_line_get_type (void);
PangoAttribute * pango_attr_keep_with_next_within_line_new (gint strength);

PangoAttrType    pango_attr_keep_with_previous_within_line_get_type (void);
PangoAttribute * pango_attr_keep_with_previous_within_line_new (gint strength);

PangoAttrType    pango_attr_line_height_get_type (void);
PangoAttribute * pango_attr_line_height_new (gint line_height);

PangoAttrType    pango_attr_line_stacking_strategy_get_type (void);
PangoAttribute * pango_attr_line_stacking_strategy_new (PangoLineStackingStrategy line_stacking_strategy);

G_END_DECLS

#endif /* __PANGO_XSL_ATTRIBUTES_H__ */
