#!/usr/bin/ruby -w
# -*- ruby -*-

# Very minimal logging output. If $verbose is set, this displays the method and
# line number whence called.

module Log
  
  @@verbose = false
  @@width = 0
  @@output = $stdout
  @@fmt = "[%s:%04d] {%s} %s\n"
  @@align = false

  def Log.verbose=(v)
    @@verbose = v
  end

  def Log.output=(fname)
    @@output = File.new(fname, "w")
  end

  def Log.set_widths(file_width, line_width, func_width)
    @@fmt = "[%#{file_width}s:%#{line_width}d] {%#{func_width}s} %s\n"
  end

  def Log.align
    @@align = true
  end
  
  def Log.log(msg)
    if @@verbose
      c = caller(1)[0]
      c.index(/(.*):(\d+)(?::in \`(.*)\')?/)
      file, line, func = $1, $2, $3
      file.sub!(/.*\//, "")
      if @@align
        @@width = [ @@width, func.length ].max
        @@output.printf "[%s:%04d] {%-*s} %s\n", file, line, @@width, func, msg.chomp
      else
        @@output.printf @@fmt, file, line, func, msg.chomp
      end
    end
  end

  def log(msg)
    if @@verbose
      c = caller(1)[0]
      c.index(/(.*):(\d+)(?::in \`(.*)\')?/)
      file, line, func = $1, $2, $3
      func = self.class.to_s + "#" + func
      file.sub!(/.*\//, "")
      if @@align
        @@width = [ @@width, func.length ].max
        @@output.printf "[%s:%04d] {%-*s} %s\n", file, line, @@width, func, msg.chomp
      else
        @@output.printf @@fmt, file, line, func, msg.chomp
      end
    end
  end

  protected
  
end
