#!/usr/bin/env bash

# $1 - GUI_TEST_REPORT_DIR
# $2 - DRONE_REPO
# $3 - DRONE_BUILD_NUMBER
# $4 - server type ('oc10' or 'ocis')

# create a github comment file only if guiTestUpload Folder is not empty
if [[ $(find "$1" -maxdepth 0 -empty) ]]; then
    echo "No test results to upload"
    echo "Exiting..."

else
    LOG_URL_PATH="${CACHE_ENDPOINT}/${CACHE_BUCKET}/$2/$3/$4/guiReportUpload"
    echo "creating comment for GUI log"

    # if there is index.html generated by squishrunner then create a comment indicating link of GUI result
    if [[ -f "$1/index.html" ]]; then
        cat >"$1/comments.file" <<EOF

:boom: The GUI tests failed.

GUI Logs: ${LOG_URL_PATH}/index.html
EOF
    fi

    echo -e '\n<details>\n' >>"$1/comments.file"

    # if there is serverlog.log generated by squishserver then create a comment indicating link of server result
    if [[ -f "$1/serverlog.log" ]]; then
        echo "creating comment for server log"
        echo "Server Logs: ${LOG_URL_PATH}/serverlog.log" >>"$1/comments.file"
    fi

    # if there is stacktrace file then add to the comment
    if [[ -f "$1/stacktrace.log" ]]; then
        echo "creating comment for stacktrace"
        echo "Stacktrace: ${LOG_URL_PATH}/stacktrace.log" >>"$1/comments.file"
    fi

    if ! [[ $(find "$1/screenshots" -maxdepth 0 -empty) ]]; then
        echo "creating comment for screenshots"
        echo -e "\nScreenshots:" >>"$1/comments.file"
        for i in "$1"/screenshots/*; do
            echo "- [$(basename "$i")](${LOG_URL_PATH}/screenshots/$(basename "$i"))" >>"$1/comments.file"
        done
    fi

    echo -e '\n</details>\n' >>"$1/comments.file"
fi
